/**
 * This file will automatically be loaded by webpack and run in the "renderer" context.
 * To learn more about the differences between the "main" and the "renderer" context in
 * Electron, visit:
 *
 * https://electronjs.org/docs/latest/tutorial/process-model
 *
 * By default, Node.js integration in this file is disabled. When enabling Node.js integration
 * in a renderer process, please be aware of potential security implications. You can read
 * more about security risks here:
 *
 * https://electronjs.org/docs/tutorial/security
 *
 * To enable Node.js integration in this file, open up `main.js` and enable the `nodeIntegration`
 * flag:
 *
 * ```
 *  // Create the browser window.
 *  mainWindow = new BrowserWindow({
 *    width: 800,
 *    height: 600,
 *    webPreferences: {
 *      nodeIntegration: true
 *    }
 *  });
 * ```
 */

import { Buffer as BufferPolyfill } from 'buffer';
declare var Buffer: typeof BufferPolyfill;
globalThis.Buffer = BufferPolyfill;

import log from 'electron-log/renderer';

log.info('UI Start-up');
Object.assign(console, log.functions);
console.log('👋 This message is being logged by "renderer.js", included via webpack');

import './telegram-widget';
import './react';
