import React from 'react'

import themes from './themes.json'

import { contrastColor } from '../../lib/helpers'

const ThemeButton = ({ title, theme: { backgroundColor, actionColor, panelColor }, onClick, size = '7em' }) => (
  <button
    type='button'
    className='no-button theme'
    onClick={onClick}
    title={title}
  >
    <svg width={size} height={size} viewBox='0 0 256 256' fill='none' xmlns='http://www.w3.org/2000/svg'>
      <rect width='256' height='256' fill={backgroundColor} />
      <rect width='256' height='50' fill={panelColor} />
      <path d='M103.445 33H101.184V25.1133H92.582V33H90.332V15.9375H92.582V23.2734H101.184V15.9375H103.445V33ZM112.363 33.2344C110.645 33.2344 109.246 32.6719 108.168 31.5469C107.09 30.4141 106.551 28.9023 106.551 27.0117V26.6133C106.551 25.3555 106.789 24.2344 107.266 23.25C107.75 22.2578 108.422 21.4844 109.281 20.9297C110.148 20.3672 111.086 20.0859 112.094 20.0859C113.742 20.0859 115.023 20.6289 115.938 21.7148C116.852 22.8008 117.309 24.3555 117.309 26.3789V27.2812H108.719C108.75 28.5312 109.113 29.543 109.809 30.3164C110.512 31.082 111.402 31.4648 112.48 31.4648C113.246 31.4648 113.895 31.3086 114.426 30.9961C114.957 30.6836 115.422 30.2695 115.82 29.7539L117.145 30.7852C116.082 32.418 114.488 33.2344 112.363 33.2344ZM112.094 21.8672C111.219 21.8672 110.484 22.1875 109.891 22.8281C109.297 23.4609 108.93 24.3516 108.789 25.5H115.141V25.3359C115.078 24.2344 114.781 23.3828 114.25 22.7812C113.719 22.1719 113 21.8672 112.094 21.8672ZM127.656 33C127.531 32.75 127.43 32.3047 127.352 31.6641C126.344 32.7109 125.141 33.2344 123.742 33.2344C122.492 33.2344 121.465 32.8828 120.66 32.1797C119.863 31.4688 119.465 30.5703 119.465 29.4844C119.465 28.1641 119.965 27.1406 120.965 26.4141C121.973 25.6797 123.387 25.3125 125.207 25.3125H127.316V24.3164C127.316 23.5586 127.09 22.957 126.637 22.5117C126.184 22.0586 125.516 21.832 124.633 21.832C123.859 21.832 123.211 22.0273 122.688 22.418C122.164 22.8086 121.902 23.2812 121.902 23.8359H119.723C119.723 23.2031 119.945 22.5938 120.391 22.0078C120.844 21.4141 121.453 20.9453 122.219 20.6016C122.992 20.2578 123.84 20.0859 124.762 20.0859C126.223 20.0859 127.367 20.4531 128.195 21.1875C129.023 21.9141 129.453 22.918 129.484 24.1992V30.0352C129.484 31.1992 129.633 32.125 129.93 32.8125V33H127.656ZM124.059 31.3477C124.738 31.3477 125.383 31.1719 125.992 30.8203C126.602 30.4688 127.043 30.0117 127.316 29.4492V26.8477H125.617C122.961 26.8477 121.633 27.625 121.633 29.1797C121.633 29.8594 121.859 30.3906 122.312 30.7734C122.766 31.1562 123.348 31.3477 124.059 31.3477ZM132.355 26.5547C132.355 24.6094 132.816 23.0469 133.738 21.8672C134.66 20.6797 135.867 20.0859 137.359 20.0859C138.844 20.0859 140.02 20.5938 140.887 21.6094V15H143.055V33H141.062L140.957 31.6406C140.09 32.7031 138.883 33.2344 137.336 33.2344C135.867 33.2344 134.668 32.6328 133.738 31.4297C132.816 30.2266 132.355 28.6562 132.355 26.7188V26.5547ZM134.523 26.8008C134.523 28.2383 134.82 29.3633 135.414 30.1758C136.008 30.9883 136.828 31.3945 137.875 31.3945C139.25 31.3945 140.254 30.7773 140.887 29.543V23.7188C140.238 22.5234 139.242 21.9258 137.898 21.9258C136.836 21.9258 136.008 22.3359 135.414 23.1562C134.82 23.9766 134.523 25.1914 134.523 26.8008ZM151.691 33.2344C149.973 33.2344 148.574 32.6719 147.496 31.5469C146.418 30.4141 145.879 28.9023 145.879 27.0117V26.6133C145.879 25.3555 146.117 24.2344 146.594 23.25C147.078 22.2578 147.75 21.4844 148.609 20.9297C149.477 20.3672 150.414 20.0859 151.422 20.0859C153.07 20.0859 154.352 20.6289 155.266 21.7148C156.18 22.8008 156.637 24.3555 156.637 26.3789V27.2812H148.047C148.078 28.5312 148.441 29.543 149.137 30.3164C149.84 31.082 150.73 31.4648 151.809 31.4648C152.574 31.4648 153.223 31.3086 153.754 30.9961C154.285 30.6836 154.75 30.2695 155.148 29.7539L156.473 30.7852C155.41 32.418 153.816 33.2344 151.691 33.2344ZM151.422 21.8672C150.547 21.8672 149.812 22.1875 149.219 22.8281C148.625 23.4609 148.258 24.3516 148.117 25.5H154.469V25.3359C154.406 24.2344 154.109 23.3828 153.578 22.7812C153.047 22.1719 152.328 21.8672 151.422 21.8672ZM165.285 22.2656C164.957 22.2109 164.602 22.1836 164.219 22.1836C162.797 22.1836 161.832 22.7891 161.324 24V33H159.156V20.3203H161.266L161.301 21.7852C162.012 20.6523 163.02 20.0859 164.324 20.0859C164.746 20.0859 165.066 20.1406 165.285 20.25V22.2656Z' fill={contrastColor(panelColor)} />
      <rect x='43' y='124' width='170' height='50' rx='9' fill={actionColor} />
      <path d='M94.1836 157V139.938H99.7617C101.613 139.938 103.004 140.32 103.934 141.086C104.871 141.852 105.34 142.984 105.34 144.484C105.34 145.281 105.113 145.988 104.66 146.605C104.207 147.215 103.59 147.688 102.809 148.023C103.73 148.281 104.457 148.773 104.988 149.5C105.527 150.219 105.797 151.078 105.797 152.078C105.797 153.609 105.301 154.812 104.309 155.688C103.316 156.562 101.914 157 100.102 157H94.1836ZM96.4336 149.02V155.16H100.148C101.195 155.16 102.02 154.891 102.621 154.352C103.23 153.805 103.535 153.055 103.535 152.102C103.535 150.047 102.418 149.02 100.184 149.02H96.4336ZM96.4336 147.215H99.832C100.816 147.215 101.602 146.969 102.188 146.477C102.781 145.984 103.078 145.316 103.078 144.473C103.078 143.535 102.805 142.855 102.258 142.434C101.711 142.004 100.879 141.789 99.7617 141.789H96.4336V147.215ZM116.625 155.746C115.781 156.738 114.543 157.234 112.91 157.234C111.559 157.234 110.527 156.844 109.816 156.062C109.113 155.273 108.758 154.109 108.75 152.57V144.32H110.918V152.512C110.918 154.434 111.699 155.395 113.262 155.395C114.918 155.395 116.02 154.777 116.566 153.543V144.32H118.734V157H116.672L116.625 155.746ZM124.98 141.25V144.32H127.348V145.996H124.98V153.859C124.98 154.367 125.086 154.75 125.297 155.008C125.508 155.258 125.867 155.383 126.375 155.383C126.625 155.383 126.969 155.336 127.406 155.242V157C126.836 157.156 126.281 157.234 125.742 157.234C124.773 157.234 124.043 156.941 123.551 156.355C123.059 155.77 122.812 154.938 122.812 153.859V145.996H120.504V144.32H122.812V141.25H124.98ZM132.832 141.25V144.32H135.199V145.996H132.832V153.859C132.832 154.367 132.938 154.75 133.148 155.008C133.359 155.258 133.719 155.383 134.227 155.383C134.477 155.383 134.82 155.336 135.258 155.242V157C134.688 157.156 134.133 157.234 133.594 157.234C132.625 157.234 131.895 156.941 131.402 156.355C130.91 155.77 130.664 154.938 130.664 153.859V145.996H128.355V144.32H130.664V141.25H132.832ZM136.934 150.543C136.934 149.301 137.176 148.184 137.66 147.191C138.152 146.199 138.832 145.434 139.699 144.895C140.574 144.355 141.57 144.086 142.688 144.086C144.414 144.086 145.809 144.684 146.871 145.879C147.941 147.074 148.477 148.664 148.477 150.648V150.801C148.477 152.035 148.238 153.145 147.762 154.129C147.293 155.105 146.617 155.867 145.734 156.414C144.859 156.961 143.852 157.234 142.711 157.234C140.992 157.234 139.598 156.637 138.527 155.441C137.465 154.246 136.934 152.664 136.934 150.695V150.543ZM139.113 150.801C139.113 152.207 139.438 153.336 140.086 154.188C140.742 155.039 141.617 155.465 142.711 155.465C143.812 155.465 144.688 155.035 145.336 154.176C145.984 153.309 146.309 152.098 146.309 150.543C146.309 149.152 145.977 148.027 145.312 147.168C144.656 146.301 143.781 145.867 142.688 145.867C141.617 145.867 140.754 146.293 140.098 147.145C139.441 147.996 139.113 149.215 139.113 150.801ZM153.246 144.32L153.316 145.914C154.285 144.695 155.551 144.086 157.113 144.086C159.793 144.086 161.145 145.598 161.168 148.621V157H159V148.609C158.992 147.695 158.781 147.02 158.367 146.582C157.961 146.145 157.324 145.926 156.457 145.926C155.754 145.926 155.137 146.113 154.605 146.488C154.074 146.863 153.66 147.355 153.363 147.965V157H151.195V144.32H153.246Z' fill={contrastColor(actionColor)} />
    </svg>
  </button>
)

const ThemeSelector = ({ onChange }) => {
  return (
    <div className='theme-selector'>
      <h2>Themes</h2>
      {Object.values(themes).map((theme, index) => (
        <ThemeButton
          title={Object.keys(themes)[index]}
          key={index}
          theme={theme}
          onClick={e => onChange(theme)}
        />
      ))}
    </div>
  )
}
export default ThemeSelector
