// Generated file. Do not edit.

import React from "react";

import type * as LoginFormElement from "@vaadin/login/vaadin-login-form";
import type * as LoginOverlayElement from "@vaadin/login/vaadin-login-overlay";
import { createVaadinComponent, eventMapper } from "../create-component.js";

type LoginFormClass = LoginFormElement.LoginForm;

type LoginFormEventMap = LoginFormElement.LoginFormEventMap;

const LoginFormEventMapper = eventMapper<LoginFormEventMap>();
const LoginFormEvents = {
  ...LoginFormEventMapper("onForgotPassword", "forgot-password"),
  ...LoginFormEventMapper("onLogin", "login"),
};

const LoginFormProperties = {
  version: "",
  action: "",
  disabled: "",
  error: "",
  noForgotPassword: "",
  noAutofocus: "",
  i18n: "",
};

const getLoginFormPreRenderConfig = (props: { [key: string]: any }) => ({
  hostProperties: {},
  children: [],
  shadowDomContent: ``,
});

export const LoginForm = createVaadinComponent<
  LoginFormClass,
  typeof LoginFormEvents
>(
  "vaadin-login-form",
  LoginFormProperties,
  LoginFormEvents,
  () => import("@vaadin/login/vaadin-login-form.js"),
  "LoginForm",
  undefined,
  getLoginFormPreRenderConfig
);

export { LoginFormElement };

type LoginOverlayClass = LoginOverlayElement.LoginOverlay;

type LoginOverlayEventMap = LoginOverlayElement.LoginOverlayEventMap;

const LoginOverlayEventMapper = eventMapper<LoginOverlayEventMap>();
const LoginOverlayEvents = {
  ...LoginOverlayEventMapper("onForgotPassword", "forgot-password"),
  ...LoginOverlayEventMapper("onLogin", "login"),
};

const LoginOverlayProperties = {
  description: "",
  opened: "",
  title: "",
  version: "",
  action: "",
  disabled: "",
  error: "",
  noForgotPassword: "",
  noAutofocus: "",
  i18n: "",
};

const getLoginOverlayPreRenderConfig = (props: { [key: string]: any }) => ({
  hostProperties: {},
  children: [],
  shadowDomContent: `<style>\n        vaadin-password-field [slot="input"]::-ms-reveal {\n          display: none;\n        }\n      </style>\n      <vaadin-login-overlay-wrapper id="vaadinLoginOverlayWrapper" focus-trap="" with-backdrop="">\n        <vaadin-login-form theme="with-overlay" id="vaadinLoginForm">\n      <style>\n        [part='vaadin-login-native-form'] * {\n          width: 100%;\n        }\n      </style>\n      <vaadin-login-form-wrapper part="vaadin-login-native-form-wrapper" theme="with-overlay">\n        <form part="vaadin-login-native-form" method="POST" slot="form">\n          <input id="csrf" type="hidden">\n          <vaadin-text-field name="username" id="vaadinLoginUsername" required="" autocapitalize="none" autocorrect="off" spellcheck="false" has-label="" focused="">\n            <input type="text" slot="input" id="input-vaadin-text-field-6" required="" name="username" autocorrect="off" aria-labelledby="label-vaadin-text-field-0">\n          <label slot="label" id="label-vaadin-text-field-0" for="input-vaadin-text-field-6">Username</label><div slot="error-message" id="error-message-vaadin-text-field-2" hidden=""></div><template shadowroot="open">\n      <style>\n        [part='input-field'] {\n          flex-grow: 0;\n        }\n      </style>\n\n      <div class="vaadin-field-container">\n        <div part="label">\n          <slot name="label"></slot>\n          <span part="required-indicator" aria-hidden="true"></span>\n        </div>\n\n        <vaadin-input-container part="input-field">\n          <slot name="prefix" slot="prefix"></slot>\n          <slot name="input"></slot>\n          <slot name="suffix" slot="suffix"></slot>\n          <div id="clearButton" part="clear-button" slot="suffix" aria-hidden="true"></div>\n        <template shadowroot="open">\n      <style>\n        :host {\n          display: flex;\n          align-items: center;\n          flex: 0 1 auto;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n\n        /* Reset the native input styles */\n        ::slotted(input) {\n          -webkit-appearance: none;\n          -moz-appearance: none;\n          flex: auto;\n          white-space: nowrap;\n          overflow: hidden;\n          width: 100%;\n          height: 100%;\n          outline: none;\n          margin: 0;\n          padding: 0;\n          border: 0;\n          border-radius: 0;\n          min-width: 0;\n          font: inherit;\n          line-height: normal;\n          color: inherit;\n          background-color: transparent;\n          /* Disable default invalid style in Firefox */\n          box-shadow: none;\n        }\n\n        ::slotted(*) {\n          flex: none;\n        }\n\n        ::slotted(:is(input, textarea))::placeholder {\n          /* Use ::slotted(input:placeholder-shown) in themes to style the placeholder. */\n          /* because ::slotted(...)::placeholder does not work in Safari. */\n          /* See the workaround at the end of this file. */\n          font: inherit;\n          color: inherit;\n          /* Override default opacity in Firefox */\n          opacity: 1;\n        }\n      </style>\n      <slot name="prefix"></slot>\n      <slot></slot>\n      <slot name="suffix"></slot>\n    <style>\n    :host {\n      border-radius: var(--lumo-border-radius-m);\n      background-color: var(--lumo-contrast-10pct);\n      padding: 0 calc(0.375em + var(--lumo-border-radius-m) / 4 - 1px);\n      font-weight: 500;\n      line-height: 1;\n      position: relative;\n      cursor: text;\n      box-sizing: border-box;\n    }\n\n    /* Used for hover and activation effects */\n    :host::after {\n      content: '';\n      position: absolute;\n      top: 0;\n      right: 0;\n      bottom: 0;\n      left: 0;\n      border-radius: inherit;\n      pointer-events: none;\n      background-color: var(--lumo-contrast-50pct);\n      opacity: 0;\n      transition: transform 0.15s, opacity 0.2s;\n      transform-origin: 100% 0;\n    }\n\n    ::slotted(:not([slot$='fix'])) {\n      cursor: inherit;\n      min-height: var(--lumo-text-field-size, var(--lumo-size-m));\n      padding: 0 0.25em;\n      --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);\n      -webkit-mask-image: var(--_lumo-text-field-overflow-mask-image);\n      mask-image: var(--_lumo-text-field-overflow-mask-image);\n    }\n\n    /* Read-only */\n    :host([readonly]) {\n      color: var(--lumo-secondary-text-color);\n      background-color: transparent;\n      cursor: default;\n    }\n\n    :host([readonly])::after {\n      background-color: transparent;\n      opacity: 1;\n      border: 1px dashed var(--lumo-contrast-30pct);\n    }\n\n    /* Disabled */\n    :host([disabled]) {\n      background-color: var(--lumo-contrast-5pct);\n    }\n\n    :host([disabled]) ::slotted(*) {\n      color: var(--lumo-disabled-text-color);\n      -webkit-text-fill-color: var(--lumo-disabled-text-color);\n    }\n\n    /* Invalid */\n    :host([invalid]) {\n      background-color: var(--lumo-error-color-10pct);\n    }\n\n    :host([invalid])::after {\n      background-color: var(--lumo-error-color-50pct);\n    }\n\n    /* Slotted icons */\n    ::slotted(iron-icon),\n    ::slotted(vaadin-icon) {\n      color: var(--lumo-contrast-60pct);\n      width: var(--lumo-icon-size-m);\n      height: var(--lumo-icon-size-m);\n    }\n\n    /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */\n    ::slotted(iron-icon[icon^='vaadin:']),\n    ::slotted(vaadin-icon[icon^='vaadin:']) {\n      padding: 0.25em;\n      box-sizing: border-box !important;\n    }\n\n    /* Text align */\n    :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent, #000 1.25em);\n    }\n\n    @-moz-document url-prefix() {\n      :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        mask-image: var(--_lumo-text-field-overflow-mask-image);\n      }\n    }\n\n    :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {\n      text-align: start;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-center']) ::slotted(:not([slot$='fix'])) {\n      text-align: center;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {\n      text-align: end;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    /* RTL specific styles */\n    :host([dir='rtl'])::after {\n      transform-origin: 0% 0;\n    }\n\n    :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-center'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);\n      }\n    }\n  </style></template></vaadin-input-container>\n\n        <div part="helper-text">\n          <slot name="helper"></slot>\n        </div>\n\n        <div part="error-message">\n          <slot name="error-message"></slot>\n        </div>\n      </div>\n    <style>\n  :host {\n    display: inline-flex;\n    outline: none;\n  }\n\n  :host::before {\n    content: '\\2003';\n    width: 0;\n    display: inline-block;\n    /* Size and position this element on the same vertical position as the input-field element\n          to make vertical align for the host element work as expected */\n  }\n\n  :host([hidden]) {\n    display: none !important;\n  }\n\n  :host(:not([has-label])) [part='label'] {\n    display: none;\n  }\n\n\n  [class$='container'] {\n    display: flex;\n    flex-direction: column;\n    min-width: 100%;\n    max-width: 100%;\n    width: var(--vaadin-field-default-width, 12em);\n  }\n\n\n  [part='clear-button'] {\n    display: none;\n    cursor: default;\n  }\n\n  [part='clear-button']::before {\n    content: '✕';\n  }\n\n  :host([clear-button-visible][has-value]:not([disabled]):not([readonly])) [part='clear-button'] {\n    display: block;\n  }\n\n\n  [part='label'] {\n    align-self: flex-start;\n    color: var(--lumo-secondary-text-color);\n    font-weight: 500;\n    font-size: var(--lumo-font-size-s);\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    transition: color 0.2s;\n    line-height: 1;\n    padding-right: 1em;\n    padding-bottom: 0.5em;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    position: relative;\n    max-width: 100%;\n    box-sizing: border-box;\n  }\n\n  :host([has-label])::before {\n    margin-top: calc(var(--lumo-font-size-s) * 1.5);\n  }\n\n  :host([has-label][theme~='small'])::before {\n    margin-top: calc(var(--lumo-font-size-xs) * 1.5);\n  }\n\n  :host([has-label]) {\n    padding-top: var(--lumo-space-m);\n  }\n\n  :host([required]) [part='required-indicator']::after {\n    content: var(--lumo-required-field-indicator, '•');\n    transition: opacity 0.2s;\n    color: var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));\n    position: absolute;\n    right: 0;\n    width: 1em;\n    text-align: center;\n  }\n\n  :host([invalid]) [part='required-indicator']::after {\n    color: var(--lumo-required-field-indicator-color, var(--lumo-error-text-color));\n  }\n\n  [part='error-message'] {\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n    color: var(--lumo-error-text-color);\n    will-change: max-height;\n    transition: 0.4s max-height;\n    max-height: 5em;\n  }\n\n  :host([has-error-message]) [part='error-message']::before,\n  :host([has-error-message]) [part='error-message']::after {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  :host(:not([invalid])) [part='error-message'] {\n    max-height: 0;\n    overflow: hidden;\n  }\n\n  /* RTL specific styles */\n\n  :host([dir='rtl']) [part='label'] {\n    margin-left: 0;\n    margin-right: calc(var(--lumo-border-radius-m) / 4);\n  }\n\n  :host([dir='rtl']) [part='label'] {\n    padding-left: 1em;\n    padding-right: 0;\n  }\n\n  :host([dir='rtl']) [part='required-indicator']::after {\n    right: auto;\n    left: 0;\n  }\n\n  :host([dir='rtl']) [part='error-message'] {\n    margin-left: 0;\n    margin-right: calc(var(--lumo-border-radius-m) / 4);\n  }\n\n\n  [part$='button'] {\n    flex: none;\n    width: 1em;\n    height: 1em;\n    line-height: 1;\n    font-size: var(--lumo-icon-size-m);\n    text-align: center;\n    color: var(--lumo-contrast-60pct);\n    transition: 0.2s color;\n    cursor: var(--lumo-clickable-cursor);\n  }\n\n  [part$='button']:hover {\n    color: var(--lumo-contrast-90pct);\n  }\n\n  :host([disabled]) [part$='button'],\n  :host([readonly]) [part$='button'] {\n    color: var(--lumo-contrast-20pct);\n    cursor: default;\n  }\n\n  [part$='button']::before {\n    font-family: 'lumo-icons';\n    display: block;\n  }\n\n\n  :host([has-helper]) [part='helper-text']::before {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  [part='helper-text'] {\n    display: block;\n    color: var(--lumo-secondary-text-color);\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    transition: color 0.2s;\n  }\n\n  :host(:hover:not([readonly])) [part='helper-text'] {\n    color: var(--lumo-body-text-color);\n  }\n\n  :host([disabled]) [part='helper-text'] {\n    color: var(--lumo-disabled-text-color);\n    -webkit-text-fill-color: var(--lumo-disabled-text-color);\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::before {\n    display: none;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::after {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='label'] {\n    order: 0;\n    padding-bottom: 0.4em;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text'] {\n    order: 1;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='label'] + * {\n    order: 2;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='error-message'] {\n    order: 3;\n  }\n\n\n  :host {\n    --lumo-text-field-size: var(--lumo-size-m);\n    color: var(--lumo-body-text-color);\n    font-size: var(--lumo-font-size-m);\n    font-family: var(--lumo-font-family);\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n    -webkit-tap-highlight-color: transparent;\n    padding: var(--lumo-space-xs) 0;\n  }\n\n  :host::before {\n    height: var(--lumo-text-field-size);\n    box-sizing: border-box;\n    display: inline-flex;\n    align-items: center;\n  }\n\n  :host([focused]:not([readonly])) [part='label'] {\n    color: var(--lumo-primary-text-color);\n  }\n\n  :host([focused]) [part='input-field'] ::slotted(:is(input, textarea)) {\n    -webkit-mask-image: none;\n    mask-image: none;\n  }\n\n  ::slotted(:is(input, textarea):placeholder-shown) {\n    color: var(--lumo-secondary-text-color);\n  }\n\n  /* Hover */\n  :host(:hover:not([readonly]):not([focused])) [part='label'] {\n    color: var(--lumo-body-text-color);\n  }\n\n  :host(:hover:not([readonly]):not([focused])) [part='input-field']::after {\n    opacity: 0.1;\n  }\n\n  /* Touch device adjustment */\n  @media (pointer: coarse) {\n    :host(:hover:not([readonly]):not([focused])) [part='label'] {\n      color: var(--lumo-secondary-text-color);\n    }\n\n    :host(:hover:not([readonly]):not([focused])) [part='input-field']::after {\n      opacity: 0;\n    }\n\n    :host(:active:not([readonly]):not([focused])) [part='input-field']::after {\n      opacity: 0.2;\n    }\n  }\n\n  /* Trigger when not focusing using the keyboard */\n  :host([focused]:not([focus-ring]):not([readonly])) [part='input-field']::after {\n    transform: scaleX(0);\n    transition-duration: 0.15s, 1s;\n  }\n\n  /* Focus-ring */\n  :host([focus-ring]) [part='input-field'] {\n    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);\n  }\n\n  /* Read-only and disabled */\n  :host(:is([readonly], [disabled])) ::slotted(:is(input, textarea):placeholder-shown) {\n    opacity: 0;\n  }\n\n  /* Disabled style */\n  :host([disabled]) {\n    pointer-events: none;\n  }\n\n  :host([disabled]) [part='label'],\n  :host([disabled]) [part='input-field'] ::slotted(*) {\n    color: var(--lumo-disabled-text-color);\n    -webkit-text-fill-color: var(--lumo-disabled-text-color);\n  }\n\n  /* Invalid style */\n  :host([invalid][focus-ring]) [part='input-field'] {\n    box-shadow: 0 0 0 2px var(--lumo-error-color-50pct);\n  }\n\n  :host([input-prevented]) [part='input-field'] {\n    animation: shake 0.15s infinite;\n  }\n\n  @keyframes shake {\n    25% {\n      transform: translateX(4px);\n    }\n    75% {\n      transform: translateX(-4px);\n    }\n  }\n\n  /* Small theme */\n  :host([theme~='small']) {\n    font-size: var(--lumo-font-size-s);\n    --lumo-text-field-size: var(--lumo-size-s);\n  }\n\n  :host([theme~='small']) [part='label'] {\n    font-size: var(--lumo-font-size-xs);\n  }\n\n  :host([theme~='small']) [part='error-message'] {\n    font-size: var(--lumo-font-size-xxs);\n  }\n\n  /* Slotted content */\n  [part='input-field'] ::slotted(:not(iron-icon):not(vaadin-icon):not(input):not(textarea)) {\n    color: var(--lumo-secondary-text-color);\n    font-weight: 400;\n  }\n\n  [part='clear-button']::before {\n    content: var(--lumo-icons-cross);\n  }\n</style></template></vaadin-text-field>\n\n          <vaadin-password-field name="password" id="vaadinLoginPassword" required="" spellcheck="false" autocomplete="current-password" has-label="">\n            <input type="password" slot="input" id="input-vaadin-password-field-7" required="" name="password" autocomplete="current-password" aria-labelledby="label-vaadin-password-field-3" autocapitalize="off">\n          <label slot="label" id="label-vaadin-password-field-3" for="input-vaadin-password-field-7">Password</label><div slot="error-message" id="error-message-vaadin-password-field-5" hidden=""></div><vaadin-password-field-button slot="reveal" tabindex="0" role="button" aria-label="Show password" aria-pressed="false"><template shadowroot="open">\n      <style>\n        :host {\n          display: block;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n      </style>\n    <style>\n  :host {\n    /* Sizing */\n    --lumo-button-size: var(--lumo-size-m);\n    min-width: calc(var(--lumo-button-size) * 2);\n    height: var(--lumo-button-size);\n    padding: 0 calc(var(--lumo-button-size) / 3 + var(--lumo-border-radius-m) / 2);\n    margin: var(--lumo-space-xs) 0;\n    box-sizing: border-box;\n    /* Style */\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size-m);\n    font-weight: 500;\n    color: var(--_lumo-button-color, var(--lumo-primary-text-color));\n    background-color: var(--_lumo-button-background-color, var(--lumo-contrast-5pct));\n    border-radius: var(--lumo-border-radius-m);\n    cursor: var(--lumo-clickable-cursor);\n    -webkit-tap-highlight-color: transparent;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  /* Set only for the internal parts so we don’t affect the host vertical alignment */\n  [part='label'],\n  [part='prefix'],\n  [part='suffix'] {\n    line-height: var(--lumo-line-height-xs);\n  }\n\n  [part='label'] {\n    padding: calc(var(--lumo-button-size) / 6) 0;\n  }\n\n  :host([theme~='small']) {\n    font-size: var(--lumo-font-size-s);\n    --lumo-button-size: var(--lumo-size-s);\n  }\n\n  :host([theme~='large']) {\n    font-size: var(--lumo-font-size-l);\n    --lumo-button-size: var(--lumo-size-l);\n  }\n\n  /* For interaction states */\n  :host::before,\n  :host::after {\n    content: '';\n    /* We rely on the host always being relative */\n    position: absolute;\n    z-index: 1;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    background-color: currentColor;\n    border-radius: inherit;\n    opacity: 0;\n    pointer-events: none;\n  }\n\n  /* Hover */\n\n  @media (any-hover: hover) {\n    :host(:hover)::before {\n      opacity: 0.02;\n    }\n  }\n\n  /* Active */\n\n  :host::after {\n    transition: opacity 1.4s, transform 0.1s;\n    filter: blur(8px);\n  }\n\n  :host([active])::before {\n    opacity: 0.05;\n    transition-duration: 0s;\n  }\n\n  :host([active])::after {\n    opacity: 0.1;\n    transition-duration: 0s, 0s;\n    transform: scale(0);\n  }\n\n  /* Keyboard focus */\n\n  :host([focus-ring]) {\n    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);\n  }\n\n  :host([theme~='primary'][focus-ring]) {\n    box-shadow: 0 0 0 1px var(--lumo-base-color), 0 0 0 3px var(--lumo-primary-color-50pct);\n  }\n\n  /* Types (primary, tertiary, tertiary-inline */\n\n  :host([theme~='tertiary']),\n  :host([theme~='tertiary-inline']) {\n    background-color: transparent !important;\n    min-width: 0;\n  }\n\n  :host([theme~='tertiary']) {\n    padding: 0 calc(var(--lumo-button-size) / 6);\n  }\n\n  :host([theme~='tertiary-inline'])::before {\n    display: none;\n  }\n\n  :host([theme~='tertiary-inline']) {\n    margin: 0;\n    height: auto;\n    padding: 0;\n    line-height: inherit;\n    font-size: inherit;\n  }\n\n  :host([theme~='tertiary-inline']) [part='label'] {\n    padding: 0;\n    overflow: visible;\n    line-height: inherit;\n  }\n\n  :host([theme~='primary']) {\n    background-color: var(--_lumo-button-primary-background-color, var(--lumo-primary-color));\n    color: var(--_lumo-button-primary-color, var(--lumo-primary-contrast-color));\n    font-weight: 600;\n    min-width: calc(var(--lumo-button-size) * 2.5);\n  }\n\n  :host([theme~='primary'])::before {\n    background-color: black;\n  }\n\n  @media (any-hover: hover) {\n    :host([theme~='primary']:hover)::before {\n      opacity: 0.05;\n    }\n  }\n\n  :host([theme~='primary'][active])::before {\n    opacity: 0.1;\n  }\n\n  :host([theme~='primary'][active])::after {\n    opacity: 0.2;\n  }\n\n  /* Colors (success, error, contrast) */\n\n  :host([theme~='success']) {\n    color: var(--lumo-success-text-color);\n  }\n\n  :host([theme~='success'][theme~='primary']) {\n    background-color: var(--lumo-success-color);\n    color: var(--lumo-success-contrast-color);\n  }\n\n  :host([theme~='error']) {\n    color: var(--lumo-error-text-color);\n  }\n\n  :host([theme~='error'][theme~='primary']) {\n    background-color: var(--lumo-error-color);\n    color: var(--lumo-error-contrast-color);\n  }\n\n  :host([theme~='contrast']) {\n    color: var(--lumo-contrast);\n  }\n\n  :host([theme~='contrast'][theme~='primary']) {\n    background-color: var(--lumo-contrast);\n    color: var(--lumo-base-color);\n  }\n\n  /* Disabled state. Keep selectors after other color variants. */\n\n  :host([disabled]) {\n    pointer-events: none;\n    color: var(--lumo-disabled-text-color);\n  }\n\n  :host([theme~='primary'][disabled]) {\n    background-color: var(--lumo-contrast-30pct);\n    color: var(--lumo-base-color);\n  }\n\n  :host([theme~='primary'][disabled]) [part] {\n    opacity: 0.7;\n  }\n\n  /* Icons */\n\n  [part] ::slotted(vaadin-icon),\n  [part] ::slotted(iron-icon) {\n    display: inline-block;\n    width: var(--lumo-icon-size-m);\n    height: var(--lumo-icon-size-m);\n  }\n\n  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */\n  [part] ::slotted(vaadin-icon[icon^='vaadin:']),\n  [part] ::slotted(iron-icon[icon^='vaadin:']) {\n    padding: 0.25em;\n    box-sizing: border-box !important;\n  }\n\n  [part='prefix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  [part='suffix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  /* Icon-only */\n\n  :host([theme~='icon']:not([theme~='tertiary-inline'])) {\n    min-width: var(--lumo-button-size);\n    padding-left: calc(var(--lumo-button-size) / 4);\n    padding-right: calc(var(--lumo-button-size) / 4);\n  }\n\n  :host([theme~='icon']) [part='prefix'],\n  :host([theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n\n  /* RTL specific styles */\n\n  :host([dir='rtl']) [part='prefix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  :host([dir='rtl']) [part='suffix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  :host([dir='rtl'][theme~='icon']) [part='prefix'],\n  :host([dir='rtl'][theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n\n\n  :host {\n    position: absolute;\n    right: 0;\n    top: 0;\n    margin: 0;\n    padding: 0;\n    width: 100%;\n    height: 100%;\n    min-width: auto;\n    background: transparent;\n    outline: none;\n  }\n</style></template></vaadin-password-field-button><template shadowroot="open">\n      <style>\n        [part='input-field'] {\n          flex-grow: 0;\n        }\n      </style>\n\n      <div class="vaadin-field-container">\n        <div part="label">\n          <slot name="label"></slot>\n          <span part="required-indicator" aria-hidden="true"></span>\n        </div>\n\n        <vaadin-input-container part="input-field">\n          <slot name="prefix" slot="prefix"></slot>\n          <slot name="input"></slot>\n          <slot name="suffix" slot="suffix"></slot>\n          <div id="clearButton" part="clear-button" slot="suffix" aria-hidden="true"></div>\n        <div part="reveal-button" slot="suffix">\n    <slot name="reveal"></slot>\n  </div><template shadowroot="open">\n      <style>\n        :host {\n          display: flex;\n          align-items: center;\n          flex: 0 1 auto;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n\n        /* Reset the native input styles */\n        ::slotted(input) {\n          -webkit-appearance: none;\n          -moz-appearance: none;\n          flex: auto;\n          white-space: nowrap;\n          overflow: hidden;\n          width: 100%;\n          height: 100%;\n          outline: none;\n          margin: 0;\n          padding: 0;\n          border: 0;\n          border-radius: 0;\n          min-width: 0;\n          font: inherit;\n          line-height: normal;\n          color: inherit;\n          background-color: transparent;\n          /* Disable default invalid style in Firefox */\n          box-shadow: none;\n        }\n\n        ::slotted(*) {\n          flex: none;\n        }\n\n        ::slotted(:is(input, textarea))::placeholder {\n          /* Use ::slotted(input:placeholder-shown) in themes to style the placeholder. */\n          /* because ::slotted(...)::placeholder does not work in Safari. */\n          /* See the workaround at the end of this file. */\n          font: inherit;\n          color: inherit;\n          /* Override default opacity in Firefox */\n          opacity: 1;\n        }\n      </style>\n      <slot name="prefix"></slot>\n      <slot></slot>\n      <slot name="suffix"></slot>\n    <style>\n    :host {\n      border-radius: var(--lumo-border-radius-m);\n      background-color: var(--lumo-contrast-10pct);\n      padding: 0 calc(0.375em + var(--lumo-border-radius-m) / 4 - 1px);\n      font-weight: 500;\n      line-height: 1;\n      position: relative;\n      cursor: text;\n      box-sizing: border-box;\n    }\n\n    /* Used for hover and activation effects */\n    :host::after {\n      content: '';\n      position: absolute;\n      top: 0;\n      right: 0;\n      bottom: 0;\n      left: 0;\n      border-radius: inherit;\n      pointer-events: none;\n      background-color: var(--lumo-contrast-50pct);\n      opacity: 0;\n      transition: transform 0.15s, opacity 0.2s;\n      transform-origin: 100% 0;\n    }\n\n    ::slotted(:not([slot$='fix'])) {\n      cursor: inherit;\n      min-height: var(--lumo-text-field-size, var(--lumo-size-m));\n      padding: 0 0.25em;\n      --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);\n      -webkit-mask-image: var(--_lumo-text-field-overflow-mask-image);\n      mask-image: var(--_lumo-text-field-overflow-mask-image);\n    }\n\n    /* Read-only */\n    :host([readonly]) {\n      color: var(--lumo-secondary-text-color);\n      background-color: transparent;\n      cursor: default;\n    }\n\n    :host([readonly])::after {\n      background-color: transparent;\n      opacity: 1;\n      border: 1px dashed var(--lumo-contrast-30pct);\n    }\n\n    /* Disabled */\n    :host([disabled]) {\n      background-color: var(--lumo-contrast-5pct);\n    }\n\n    :host([disabled]) ::slotted(*) {\n      color: var(--lumo-disabled-text-color);\n      -webkit-text-fill-color: var(--lumo-disabled-text-color);\n    }\n\n    /* Invalid */\n    :host([invalid]) {\n      background-color: var(--lumo-error-color-10pct);\n    }\n\n    :host([invalid])::after {\n      background-color: var(--lumo-error-color-50pct);\n    }\n\n    /* Slotted icons */\n    ::slotted(iron-icon),\n    ::slotted(vaadin-icon) {\n      color: var(--lumo-contrast-60pct);\n      width: var(--lumo-icon-size-m);\n      height: var(--lumo-icon-size-m);\n    }\n\n    /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */\n    ::slotted(iron-icon[icon^='vaadin:']),\n    ::slotted(vaadin-icon[icon^='vaadin:']) {\n      padding: 0.25em;\n      box-sizing: border-box !important;\n    }\n\n    /* Text align */\n    :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent, #000 1.25em);\n    }\n\n    @-moz-document url-prefix() {\n      :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        mask-image: var(--_lumo-text-field-overflow-mask-image);\n      }\n    }\n\n    :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {\n      text-align: start;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-center']) ::slotted(:not([slot$='fix'])) {\n      text-align: center;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {\n      text-align: end;\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    /* RTL specific styles */\n    :host([dir='rtl'])::after {\n      transform-origin: 0% 0;\n    }\n\n    :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-center'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n      --_lumo-text-field-overflow-mask-image: none;\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);\n      }\n    }\n\n    @-moz-document url-prefix() {\n      /* Firefox is smart enough to align overflowing text to right */\n      :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {\n        --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);\n      }\n    }\n  </style></template></vaadin-input-container>\n\n        <div part="helper-text">\n          <slot name="helper"></slot>\n        </div>\n\n        <div part="error-message">\n          <slot name="error-message"></slot>\n        </div>\n      </div>\n    <style>\n  :host {\n    display: inline-flex;\n    outline: none;\n  }\n\n  :host::before {\n    content: '\\2003';\n    width: 0;\n    display: inline-block;\n    /* Size and position this element on the same vertical position as the input-field element\n          to make vertical align for the host element work as expected */\n  }\n\n  :host([hidden]) {\n    display: none !important;\n  }\n\n  :host(:not([has-label])) [part='label'] {\n    display: none;\n  }\n\n\n  [class$='container'] {\n    display: flex;\n    flex-direction: column;\n    min-width: 100%;\n    max-width: 100%;\n    width: var(--vaadin-field-default-width, 12em);\n  }\n\n\n  [part='clear-button'] {\n    display: none;\n    cursor: default;\n  }\n\n  [part='clear-button']::before {\n    content: '✕';\n  }\n\n  :host([clear-button-visible][has-value]:not([disabled]):not([readonly])) [part='clear-button'] {\n    display: block;\n  }\n\n\n  [part='label'] {\n    align-self: flex-start;\n    color: var(--lumo-secondary-text-color);\n    font-weight: 500;\n    font-size: var(--lumo-font-size-s);\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    transition: color 0.2s;\n    line-height: 1;\n    padding-right: 1em;\n    padding-bottom: 0.5em;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    position: relative;\n    max-width: 100%;\n    box-sizing: border-box;\n  }\n\n  :host([has-label])::before {\n    margin-top: calc(var(--lumo-font-size-s) * 1.5);\n  }\n\n  :host([has-label][theme~='small'])::before {\n    margin-top: calc(var(--lumo-font-size-xs) * 1.5);\n  }\n\n  :host([has-label]) {\n    padding-top: var(--lumo-space-m);\n  }\n\n  :host([required]) [part='required-indicator']::after {\n    content: var(--lumo-required-field-indicator, '•');\n    transition: opacity 0.2s;\n    color: var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));\n    position: absolute;\n    right: 0;\n    width: 1em;\n    text-align: center;\n  }\n\n  :host([invalid]) [part='required-indicator']::after {\n    color: var(--lumo-required-field-indicator-color, var(--lumo-error-text-color));\n  }\n\n  [part='error-message'] {\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n    color: var(--lumo-error-text-color);\n    will-change: max-height;\n    transition: 0.4s max-height;\n    max-height: 5em;\n  }\n\n  :host([has-error-message]) [part='error-message']::before,\n  :host([has-error-message]) [part='error-message']::after {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  :host(:not([invalid])) [part='error-message'] {\n    max-height: 0;\n    overflow: hidden;\n  }\n\n  /* RTL specific styles */\n\n  :host([dir='rtl']) [part='label'] {\n    margin-left: 0;\n    margin-right: calc(var(--lumo-border-radius-m) / 4);\n  }\n\n  :host([dir='rtl']) [part='label'] {\n    padding-left: 1em;\n    padding-right: 0;\n  }\n\n  :host([dir='rtl']) [part='required-indicator']::after {\n    right: auto;\n    left: 0;\n  }\n\n  :host([dir='rtl']) [part='error-message'] {\n    margin-left: 0;\n    margin-right: calc(var(--lumo-border-radius-m) / 4);\n  }\n\n\n  [part$='button'] {\n    flex: none;\n    width: 1em;\n    height: 1em;\n    line-height: 1;\n    font-size: var(--lumo-icon-size-m);\n    text-align: center;\n    color: var(--lumo-contrast-60pct);\n    transition: 0.2s color;\n    cursor: var(--lumo-clickable-cursor);\n  }\n\n  [part$='button']:hover {\n    color: var(--lumo-contrast-90pct);\n  }\n\n  :host([disabled]) [part$='button'],\n  :host([readonly]) [part$='button'] {\n    color: var(--lumo-contrast-20pct);\n    cursor: default;\n  }\n\n  [part$='button']::before {\n    font-family: 'lumo-icons';\n    display: block;\n  }\n\n\n  :host([has-helper]) [part='helper-text']::before {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  [part='helper-text'] {\n    display: block;\n    color: var(--lumo-secondary-text-color);\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n    margin-left: calc(var(--lumo-border-radius-m) / 4);\n    transition: color 0.2s;\n  }\n\n  :host(:hover:not([readonly])) [part='helper-text'] {\n    color: var(--lumo-body-text-color);\n  }\n\n  :host([disabled]) [part='helper-text'] {\n    color: var(--lumo-disabled-text-color);\n    -webkit-text-fill-color: var(--lumo-disabled-text-color);\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::before {\n    display: none;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::after {\n    content: '';\n    display: block;\n    height: 0.4em;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='label'] {\n    order: 0;\n    padding-bottom: 0.4em;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='helper-text'] {\n    order: 1;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='label'] + * {\n    order: 2;\n  }\n\n  :host([has-helper][theme~='helper-above-field']) [part='error-message'] {\n    order: 3;\n  }\n\n\n  :host {\n    --lumo-text-field-size: var(--lumo-size-m);\n    color: var(--lumo-body-text-color);\n    font-size: var(--lumo-font-size-m);\n    font-family: var(--lumo-font-family);\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n    -webkit-tap-highlight-color: transparent;\n    padding: var(--lumo-space-xs) 0;\n  }\n\n  :host::before {\n    height: var(--lumo-text-field-size);\n    box-sizing: border-box;\n    display: inline-flex;\n    align-items: center;\n  }\n\n  :host([focused]:not([readonly])) [part='label'] {\n    color: var(--lumo-primary-text-color);\n  }\n\n  :host([focused]) [part='input-field'] ::slotted(:is(input, textarea)) {\n    -webkit-mask-image: none;\n    mask-image: none;\n  }\n\n  ::slotted(:is(input, textarea):placeholder-shown) {\n    color: var(--lumo-secondary-text-color);\n  }\n\n  /* Hover */\n  :host(:hover:not([readonly]):not([focused])) [part='label'] {\n    color: var(--lumo-body-text-color);\n  }\n\n  :host(:hover:not([readonly]):not([focused])) [part='input-field']::after {\n    opacity: 0.1;\n  }\n\n  /* Touch device adjustment */\n  @media (pointer: coarse) {\n    :host(:hover:not([readonly]):not([focused])) [part='label'] {\n      color: var(--lumo-secondary-text-color);\n    }\n\n    :host(:hover:not([readonly]):not([focused])) [part='input-field']::after {\n      opacity: 0;\n    }\n\n    :host(:active:not([readonly]):not([focused])) [part='input-field']::after {\n      opacity: 0.2;\n    }\n  }\n\n  /* Trigger when not focusing using the keyboard */\n  :host([focused]:not([focus-ring]):not([readonly])) [part='input-field']::after {\n    transform: scaleX(0);\n    transition-duration: 0.15s, 1s;\n  }\n\n  /* Focus-ring */\n  :host([focus-ring]) [part='input-field'] {\n    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);\n  }\n\n  /* Read-only and disabled */\n  :host(:is([readonly], [disabled])) ::slotted(:is(input, textarea):placeholder-shown) {\n    opacity: 0;\n  }\n\n  /* Disabled style */\n  :host([disabled]) {\n    pointer-events: none;\n  }\n\n  :host([disabled]) [part='label'],\n  :host([disabled]) [part='input-field'] ::slotted(*) {\n    color: var(--lumo-disabled-text-color);\n    -webkit-text-fill-color: var(--lumo-disabled-text-color);\n  }\n\n  /* Invalid style */\n  :host([invalid][focus-ring]) [part='input-field'] {\n    box-shadow: 0 0 0 2px var(--lumo-error-color-50pct);\n  }\n\n  :host([input-prevented]) [part='input-field'] {\n    animation: shake 0.15s infinite;\n  }\n\n  @keyframes shake {\n    25% {\n      transform: translateX(4px);\n    }\n    75% {\n      transform: translateX(-4px);\n    }\n  }\n\n  /* Small theme */\n  :host([theme~='small']) {\n    font-size: var(--lumo-font-size-s);\n    --lumo-text-field-size: var(--lumo-size-s);\n  }\n\n  :host([theme~='small']) [part='label'] {\n    font-size: var(--lumo-font-size-xs);\n  }\n\n  :host([theme~='small']) [part='error-message'] {\n    font-size: var(--lumo-font-size-xxs);\n  }\n\n  /* Slotted content */\n  [part='input-field'] ::slotted(:not(iron-icon):not(vaadin-icon):not(input):not(textarea)) {\n    color: var(--lumo-secondary-text-color);\n    font-weight: 400;\n  }\n\n  [part='clear-button']::before {\n    content: var(--lumo-icons-cross);\n  }\n\n\n  [part='reveal-button']::before {\n    content: var(--lumo-icons-eye);\n  }\n\n  :host([password-visible]) [part='reveal-button']::before {\n    content: var(--lumo-icons-eye-disabled);\n  }\n\n  /* Make it easy to hide the button across the whole app */\n  [part='reveal-button'] {\n    position: relative;\n    display: var(--lumo-password-field-reveal-button-display, block);\n  }\n\n  [part='reveal-button'][hidden] {\n    display: none !important;\n  }\n</style></template></vaadin-password-field>\n\n          <vaadin-button part="vaadin-login-submit" theme="primary contained" tabindex="0" role="button">Log in<template shadowroot="open">\n      <style>\n        :host {\n          display: inline-block;\n          position: relative;\n          outline: none;\n          white-space: nowrap;\n          -webkit-user-select: none;\n          -moz-user-select: none;\n          user-select: none;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n\n        /* Aligns the button with form fields when placed on the same line.\n          Note, to make it work, the form fields should have the same "::before" pseudo-element. */\n        .vaadin-button-container::before {\n          content: '\\2003';\n          display: inline-block;\n          width: 0;\n          max-height: 100%;\n        }\n\n        .vaadin-button-container {\n          display: inline-flex;\n          align-items: center;\n          justify-content: center;\n          text-align: center;\n          width: 100%;\n          height: 100%;\n          min-height: inherit;\n          text-shadow: inherit;\n        }\n\n        [part='prefix'],\n        [part='suffix'] {\n          flex: none;\n        }\n\n        [part='label'] {\n          white-space: nowrap;\n          overflow: hidden;\n          text-overflow: ellipsis;\n        }\n      </style>\n      <div class="vaadin-button-container">\n        <span part="prefix">\n          <slot name="prefix"></slot>\n        </span>\n        <span part="label">\n          <slot></slot>\n        </span>\n        <span part="suffix">\n          <slot name="suffix"></slot>\n        </span>\n      </div>\n    <style>\n  :host {\n    /* Sizing */\n    --lumo-button-size: var(--lumo-size-m);\n    min-width: calc(var(--lumo-button-size) * 2);\n    height: var(--lumo-button-size);\n    padding: 0 calc(var(--lumo-button-size) / 3 + var(--lumo-border-radius-m) / 2);\n    margin: var(--lumo-space-xs) 0;\n    box-sizing: border-box;\n    /* Style */\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size-m);\n    font-weight: 500;\n    color: var(--_lumo-button-color, var(--lumo-primary-text-color));\n    background-color: var(--_lumo-button-background-color, var(--lumo-contrast-5pct));\n    border-radius: var(--lumo-border-radius-m);\n    cursor: var(--lumo-clickable-cursor);\n    -webkit-tap-highlight-color: transparent;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  /* Set only for the internal parts so we don’t affect the host vertical alignment */\n  [part='label'],\n  [part='prefix'],\n  [part='suffix'] {\n    line-height: var(--lumo-line-height-xs);\n  }\n\n  [part='label'] {\n    padding: calc(var(--lumo-button-size) / 6) 0;\n  }\n\n  :host([theme~='small']) {\n    font-size: var(--lumo-font-size-s);\n    --lumo-button-size: var(--lumo-size-s);\n  }\n\n  :host([theme~='large']) {\n    font-size: var(--lumo-font-size-l);\n    --lumo-button-size: var(--lumo-size-l);\n  }\n\n  /* For interaction states */\n  :host::before,\n  :host::after {\n    content: '';\n    /* We rely on the host always being relative */\n    position: absolute;\n    z-index: 1;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    background-color: currentColor;\n    border-radius: inherit;\n    opacity: 0;\n    pointer-events: none;\n  }\n\n  /* Hover */\n\n  @media (any-hover: hover) {\n    :host(:hover)::before {\n      opacity: 0.02;\n    }\n  }\n\n  /* Active */\n\n  :host::after {\n    transition: opacity 1.4s, transform 0.1s;\n    filter: blur(8px);\n  }\n\n  :host([active])::before {\n    opacity: 0.05;\n    transition-duration: 0s;\n  }\n\n  :host([active])::after {\n    opacity: 0.1;\n    transition-duration: 0s, 0s;\n    transform: scale(0);\n  }\n\n  /* Keyboard focus */\n\n  :host([focus-ring]) {\n    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);\n  }\n\n  :host([theme~='primary'][focus-ring]) {\n    box-shadow: 0 0 0 1px var(--lumo-base-color), 0 0 0 3px var(--lumo-primary-color-50pct);\n  }\n\n  /* Types (primary, tertiary, tertiary-inline */\n\n  :host([theme~='tertiary']),\n  :host([theme~='tertiary-inline']) {\n    background-color: transparent !important;\n    min-width: 0;\n  }\n\n  :host([theme~='tertiary']) {\n    padding: 0 calc(var(--lumo-button-size) / 6);\n  }\n\n  :host([theme~='tertiary-inline'])::before {\n    display: none;\n  }\n\n  :host([theme~='tertiary-inline']) {\n    margin: 0;\n    height: auto;\n    padding: 0;\n    line-height: inherit;\n    font-size: inherit;\n  }\n\n  :host([theme~='tertiary-inline']) [part='label'] {\n    padding: 0;\n    overflow: visible;\n    line-height: inherit;\n  }\n\n  :host([theme~='primary']) {\n    background-color: var(--_lumo-button-primary-background-color, var(--lumo-primary-color));\n    color: var(--_lumo-button-primary-color, var(--lumo-primary-contrast-color));\n    font-weight: 600;\n    min-width: calc(var(--lumo-button-size) * 2.5);\n  }\n\n  :host([theme~='primary'])::before {\n    background-color: black;\n  }\n\n  @media (any-hover: hover) {\n    :host([theme~='primary']:hover)::before {\n      opacity: 0.05;\n    }\n  }\n\n  :host([theme~='primary'][active])::before {\n    opacity: 0.1;\n  }\n\n  :host([theme~='primary'][active])::after {\n    opacity: 0.2;\n  }\n\n  /* Colors (success, error, contrast) */\n\n  :host([theme~='success']) {\n    color: var(--lumo-success-text-color);\n  }\n\n  :host([theme~='success'][theme~='primary']) {\n    background-color: var(--lumo-success-color);\n    color: var(--lumo-success-contrast-color);\n  }\n\n  :host([theme~='error']) {\n    color: var(--lumo-error-text-color);\n  }\n\n  :host([theme~='error'][theme~='primary']) {\n    background-color: var(--lumo-error-color);\n    color: var(--lumo-error-contrast-color);\n  }\n\n  :host([theme~='contrast']) {\n    color: var(--lumo-contrast);\n  }\n\n  :host([theme~='contrast'][theme~='primary']) {\n    background-color: var(--lumo-contrast);\n    color: var(--lumo-base-color);\n  }\n\n  /* Disabled state. Keep selectors after other color variants. */\n\n  :host([disabled]) {\n    pointer-events: none;\n    color: var(--lumo-disabled-text-color);\n  }\n\n  :host([theme~='primary'][disabled]) {\n    background-color: var(--lumo-contrast-30pct);\n    color: var(--lumo-base-color);\n  }\n\n  :host([theme~='primary'][disabled]) [part] {\n    opacity: 0.7;\n  }\n\n  /* Icons */\n\n  [part] ::slotted(vaadin-icon),\n  [part] ::slotted(iron-icon) {\n    display: inline-block;\n    width: var(--lumo-icon-size-m);\n    height: var(--lumo-icon-size-m);\n  }\n\n  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */\n  [part] ::slotted(vaadin-icon[icon^='vaadin:']),\n  [part] ::slotted(iron-icon[icon^='vaadin:']) {\n    padding: 0.25em;\n    box-sizing: border-box !important;\n  }\n\n  [part='prefix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  [part='suffix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  /* Icon-only */\n\n  :host([theme~='icon']:not([theme~='tertiary-inline'])) {\n    min-width: var(--lumo-button-size);\n    padding-left: calc(var(--lumo-button-size) / 4);\n    padding-right: calc(var(--lumo-button-size) / 4);\n  }\n\n  :host([theme~='icon']) [part='prefix'],\n  :host([theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n\n  /* RTL specific styles */\n\n  :host([dir='rtl']) [part='prefix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  :host([dir='rtl']) [part='suffix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  :host([dir='rtl'][theme~='icon']) [part='prefix'],\n  :host([dir='rtl'][theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n</style></template></vaadin-button>\n        </form>\n      <template shadowroot="open">\n      <style>\n        :host {\n          overflow: hidden;\n          display: inline-block;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n\n        [part='form'] {\n          flex: 1;\n          display: flex;\n          flex-direction: column;\n          box-sizing: border-box;\n        }\n\n        [part='form-title'] {\n          margin: 0;\n        }\n\n        [part='error-message'] {\n          position: relative;\n        }\n      </style>\n      <section part="form">\n        <h2 part="form-title">Log in</h2>\n        <div part="error-message" hidden="">\n          <h5 part="error-message-title">Incorrect username or password</h5>\n          <p part="error-message-description">Check that you have entered the correct username and password and try again.</p>\n        </div>\n\n        <slot name="form"></slot>\n\n        <vaadin-button id="forgotPasswordButton" theme="tertiary small forgot-password" tabindex="0" role="button">Forgot password<template shadowroot="open">\n      <style>\n        :host {\n          display: inline-block;\n          position: relative;\n          outline: none;\n          white-space: nowrap;\n          -webkit-user-select: none;\n          -moz-user-select: none;\n          user-select: none;\n        }\n\n        :host([hidden]) {\n          display: none !important;\n        }\n\n        /* Aligns the button with form fields when placed on the same line.\n          Note, to make it work, the form fields should have the same "::before" pseudo-element. */\n        .vaadin-button-container::before {\n          content: '\\2003';\n          display: inline-block;\n          width: 0;\n          max-height: 100%;\n        }\n\n        .vaadin-button-container {\n          display: inline-flex;\n          align-items: center;\n          justify-content: center;\n          text-align: center;\n          width: 100%;\n          height: 100%;\n          min-height: inherit;\n          text-shadow: inherit;\n        }\n\n        [part='prefix'],\n        [part='suffix'] {\n          flex: none;\n        }\n\n        [part='label'] {\n          white-space: nowrap;\n          overflow: hidden;\n          text-overflow: ellipsis;\n        }\n      </style>\n      <div class="vaadin-button-container">\n        <span part="prefix">\n          <slot name="prefix"></slot>\n        </span>\n        <span part="label">\n          <slot></slot>\n        </span>\n        <span part="suffix">\n          <slot name="suffix"></slot>\n        </span>\n      </div>\n    <style>\n  :host {\n    /* Sizing */\n    --lumo-button-size: var(--lumo-size-m);\n    min-width: calc(var(--lumo-button-size) * 2);\n    height: var(--lumo-button-size);\n    padding: 0 calc(var(--lumo-button-size) / 3 + var(--lumo-border-radius-m) / 2);\n    margin: var(--lumo-space-xs) 0;\n    box-sizing: border-box;\n    /* Style */\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size-m);\n    font-weight: 500;\n    color: var(--_lumo-button-color, var(--lumo-primary-text-color));\n    background-color: var(--_lumo-button-background-color, var(--lumo-contrast-5pct));\n    border-radius: var(--lumo-border-radius-m);\n    cursor: var(--lumo-clickable-cursor);\n    -webkit-tap-highlight-color: transparent;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  /* Set only for the internal parts so we don’t affect the host vertical alignment */\n  [part='label'],\n  [part='prefix'],\n  [part='suffix'] {\n    line-height: var(--lumo-line-height-xs);\n  }\n\n  [part='label'] {\n    padding: calc(var(--lumo-button-size) / 6) 0;\n  }\n\n  :host([theme~='small']) {\n    font-size: var(--lumo-font-size-s);\n    --lumo-button-size: var(--lumo-size-s);\n  }\n\n  :host([theme~='large']) {\n    font-size: var(--lumo-font-size-l);\n    --lumo-button-size: var(--lumo-size-l);\n  }\n\n  /* For interaction states */\n  :host::before,\n  :host::after {\n    content: '';\n    /* We rely on the host always being relative */\n    position: absolute;\n    z-index: 1;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    background-color: currentColor;\n    border-radius: inherit;\n    opacity: 0;\n    pointer-events: none;\n  }\n\n  /* Hover */\n\n  @media (any-hover: hover) {\n    :host(:hover)::before {\n      opacity: 0.02;\n    }\n  }\n\n  /* Active */\n\n  :host::after {\n    transition: opacity 1.4s, transform 0.1s;\n    filter: blur(8px);\n  }\n\n  :host([active])::before {\n    opacity: 0.05;\n    transition-duration: 0s;\n  }\n\n  :host([active])::after {\n    opacity: 0.1;\n    transition-duration: 0s, 0s;\n    transform: scale(0);\n  }\n\n  /* Keyboard focus */\n\n  :host([focus-ring]) {\n    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);\n  }\n\n  :host([theme~='primary'][focus-ring]) {\n    box-shadow: 0 0 0 1px var(--lumo-base-color), 0 0 0 3px var(--lumo-primary-color-50pct);\n  }\n\n  /* Types (primary, tertiary, tertiary-inline */\n\n  :host([theme~='tertiary']),\n  :host([theme~='tertiary-inline']) {\n    background-color: transparent !important;\n    min-width: 0;\n  }\n\n  :host([theme~='tertiary']) {\n    padding: 0 calc(var(--lumo-button-size) / 6);\n  }\n\n  :host([theme~='tertiary-inline'])::before {\n    display: none;\n  }\n\n  :host([theme~='tertiary-inline']) {\n    margin: 0;\n    height: auto;\n    padding: 0;\n    line-height: inherit;\n    font-size: inherit;\n  }\n\n  :host([theme~='tertiary-inline']) [part='label'] {\n    padding: 0;\n    overflow: visible;\n    line-height: inherit;\n  }\n\n  :host([theme~='primary']) {\n    background-color: var(--_lumo-button-primary-background-color, var(--lumo-primary-color));\n    color: var(--_lumo-button-primary-color, var(--lumo-primary-contrast-color));\n    font-weight: 600;\n    min-width: calc(var(--lumo-button-size) * 2.5);\n  }\n\n  :host([theme~='primary'])::before {\n    background-color: black;\n  }\n\n  @media (any-hover: hover) {\n    :host([theme~='primary']:hover)::before {\n      opacity: 0.05;\n    }\n  }\n\n  :host([theme~='primary'][active])::before {\n    opacity: 0.1;\n  }\n\n  :host([theme~='primary'][active])::after {\n    opacity: 0.2;\n  }\n\n  /* Colors (success, error, contrast) */\n\n  :host([theme~='success']) {\n    color: var(--lumo-success-text-color);\n  }\n\n  :host([theme~='success'][theme~='primary']) {\n    background-color: var(--lumo-success-color);\n    color: var(--lumo-success-contrast-color);\n  }\n\n  :host([theme~='error']) {\n    color: var(--lumo-error-text-color);\n  }\n\n  :host([theme~='error'][theme~='primary']) {\n    background-color: var(--lumo-error-color);\n    color: var(--lumo-error-contrast-color);\n  }\n\n  :host([theme~='contrast']) {\n    color: var(--lumo-contrast);\n  }\n\n  :host([theme~='contrast'][theme~='primary']) {\n    background-color: var(--lumo-contrast);\n    color: var(--lumo-base-color);\n  }\n\n  /* Disabled state. Keep selectors after other color variants. */\n\n  :host([disabled]) {\n    pointer-events: none;\n    color: var(--lumo-disabled-text-color);\n  }\n\n  :host([theme~='primary'][disabled]) {\n    background-color: var(--lumo-contrast-30pct);\n    color: var(--lumo-base-color);\n  }\n\n  :host([theme~='primary'][disabled]) [part] {\n    opacity: 0.7;\n  }\n\n  /* Icons */\n\n  [part] ::slotted(vaadin-icon),\n  [part] ::slotted(iron-icon) {\n    display: inline-block;\n    width: var(--lumo-icon-size-m);\n    height: var(--lumo-icon-size-m);\n  }\n\n  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */\n  [part] ::slotted(vaadin-icon[icon^='vaadin:']),\n  [part] ::slotted(iron-icon[icon^='vaadin:']) {\n    padding: 0.25em;\n    box-sizing: border-box !important;\n  }\n\n  [part='prefix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  [part='suffix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  /* Icon-only */\n\n  :host([theme~='icon']:not([theme~='tertiary-inline'])) {\n    min-width: var(--lumo-button-size);\n    padding-left: calc(var(--lumo-button-size) / 4);\n    padding-right: calc(var(--lumo-button-size) / 4);\n  }\n\n  :host([theme~='icon']) [part='prefix'],\n  :host([theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n\n  /* RTL specific styles */\n\n  :host([dir='rtl']) [part='prefix'] {\n    margin-left: 0.25em;\n    margin-right: -0.25em;\n  }\n\n  :host([dir='rtl']) [part='suffix'] {\n    margin-left: -0.25em;\n    margin-right: 0.25em;\n  }\n\n  :host([dir='rtl'][theme~='icon']) [part='prefix'],\n  :host([dir='rtl'][theme~='icon']) [part='suffix'] {\n    margin-left: 0;\n    margin-right: 0;\n  }\n</style></template></vaadin-button>\n\n        <div part="footer">\n          <p></p>\n        </div>\n      </section>\n    <style>\n  :host {\n    max-width: calc(var(--lumo-size-m) * 10);\n    background: var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));\n  }\n\n  [part='form'] {\n    padding: var(--lumo-space-l);\n  }\n\n  [part='form-title'] {\n    margin-top: calc(var(--lumo-font-size-xxxl) - var(--lumo-font-size-xxl));\n  }\n\n  #forgotPasswordButton {\n    margin: var(--lumo-space-s) auto;\n  }\n\n  [part='error-message'] {\n    background-color: var(--lumo-error-color-10pct);\n    padding: var(--lumo-space-m);\n    border-radius: var(--lumo-border-radius-m);\n    margin-top: var(--lumo-space-m);\n    margin-bottom: var(--lumo-space-s);\n    color: var(--lumo-error-text-color);\n  }\n\n  :host(:not([dir='rtl'])) [part='error-message'] {\n    padding-left: var(--lumo-size-m);\n  }\n\n  :host([dir='rtl']) [part='error-message'] {\n    padding-right: var(--lumo-size-m);\n  }\n\n  [part='error-message']::before {\n    content: var(--lumo-icons-error);\n    font-family: lumo-icons;\n    font-size: var(--lumo-icon-size-m);\n    position: absolute;\n    width: var(--lumo-size-m);\n    height: 1em;\n    line-height: 1;\n    text-align: center;\n  }\n\n  :host(:not([dir='rtl'])) [part='error-message']::before {\n    /* Visual centering */\n    margin-left: calc(var(--lumo-size-m) * -0.95);\n  }\n\n  :host([dir='rtl']) [part='error-message']::before {\n    /* Visual centering */\n    margin-right: calc(var(--lumo-size-m) * -0.95);\n  }\n\n  [part='error-message-title'] {\n    margin: 0 0 0.25em;\n    color: inherit;\n  }\n\n  [part='error-message-description'] {\n    font-size: var(--lumo-font-size-s);\n    line-height: var(--lumo-line-height-s);\n    margin: 0;\n    opacity: 0.9;\n  }\n\n  [part='footer'] {\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-s);\n    color: var(--lumo-secondary-text-color);\n  }\n\n\n  [theme~='dark'] {\n    /* Base (background) */\n    --lumo-base-color: hsl(214, 35%, 21%);\n\n    /* Tint */\n    --lumo-tint-5pct: hsla(214, 65%, 85%, 0.06);\n    --lumo-tint-10pct: hsla(214, 60%, 80%, 0.14);\n    --lumo-tint-20pct: hsla(214, 64%, 82%, 0.23);\n    --lumo-tint-30pct: hsla(214, 69%, 84%, 0.32);\n    --lumo-tint-40pct: hsla(214, 73%, 86%, 0.41);\n    --lumo-tint-50pct: hsla(214, 78%, 88%, 0.5);\n    --lumo-tint-60pct: hsla(214, 82%, 90%, 0.58);\n    --lumo-tint-70pct: hsla(214, 87%, 92%, 0.69);\n    --lumo-tint-80pct: hsla(214, 91%, 94%, 0.8);\n    --lumo-tint-90pct: hsla(214, 96%, 96%, 0.9);\n    --lumo-tint: hsl(214, 100%, 98%);\n\n    /* Shade */\n    --lumo-shade-5pct: hsla(214, 0%, 0%, 0.07);\n    --lumo-shade-10pct: hsla(214, 4%, 2%, 0.15);\n    --lumo-shade-20pct: hsla(214, 8%, 4%, 0.23);\n    --lumo-shade-30pct: hsla(214, 12%, 6%, 0.32);\n    --lumo-shade-40pct: hsla(214, 16%, 8%, 0.41);\n    --lumo-shade-50pct: hsla(214, 20%, 10%, 0.5);\n    --lumo-shade-60pct: hsla(214, 24%, 12%, 0.6);\n    --lumo-shade-70pct: hsla(214, 28%, 13%, 0.7);\n    --lumo-shade-80pct: hsla(214, 32%, 13%, 0.8);\n    --lumo-shade-90pct: hsla(214, 33%, 13%, 0.9);\n    --lumo-shade: hsl(214, 33%, 13%);\n\n    /* Contrast */\n    --lumo-contrast-5pct: var(--lumo-tint-5pct);\n    --lumo-contrast-10pct: var(--lumo-tint-10pct);\n    --lumo-contrast-20pct: var(--lumo-tint-20pct);\n    --lumo-contrast-30pct: var(--lumo-tint-30pct);\n    --lumo-contrast-40pct: var(--lumo-tint-40pct);\n    --lumo-contrast-50pct: var(--lumo-tint-50pct);\n    --lumo-contrast-60pct: var(--lumo-tint-60pct);\n    --lumo-contrast-70pct: var(--lumo-tint-70pct);\n    --lumo-contrast-80pct: var(--lumo-tint-80pct);\n    --lumo-contrast-90pct: var(--lumo-tint-90pct);\n    --lumo-contrast: var(--lumo-tint);\n\n    /* Text */\n    --lumo-header-text-color: var(--lumo-contrast);\n    --lumo-body-text-color: var(--lumo-contrast-90pct);\n    --lumo-secondary-text-color: var(--lumo-contrast-70pct);\n    --lumo-tertiary-text-color: var(--lumo-contrast-50pct);\n    --lumo-disabled-text-color: var(--lumo-contrast-30pct);\n\n    /* Primary */\n    --lumo-primary-color: hsl(214, 90%, 48%);\n    --lumo-primary-color-50pct: hsla(214, 90%, 70%, 0.69);\n    --lumo-primary-color-10pct: hsla(214, 90%, 55%, 0.13);\n    --lumo-primary-text-color: hsl(214, 90%, 77%);\n    --lumo-primary-contrast-color: #fff;\n\n    /* Error */\n    --lumo-error-color: hsl(3, 79%, 49%);\n    --lumo-error-color-50pct: hsla(3, 75%, 62%, 0.5);\n    --lumo-error-color-10pct: hsla(3, 75%, 62%, 0.14);\n    --lumo-error-text-color: hsl(3, 100%, 80%);\n\n    /* Success */\n    --lumo-success-color: hsl(145, 72%, 30%);\n    --lumo-success-color-50pct: hsla(145, 92%, 51%, 0.5);\n    --lumo-success-color-10pct: hsla(145, 92%, 51%, 0.1);\n    --lumo-success-text-color: hsl(145, 85%, 46%);\n  }\n\n  html {\n    color: var(--lumo-body-text-color);\n    background-color: var(--lumo-base-color);\n    color-scheme: light;\n  }\n\n  [theme~='dark'] {\n    color: var(--lumo-body-text-color);\n    background-color: var(--lumo-base-color);\n    color-scheme: dark;\n  }\n\n  h1,\n  h2,\n  h3,\n  h4,\n  h5,\n  h6 {\n    color: var(--lumo-header-text-color);\n  }\n\n  a:where(:any-link) {\n    color: var(--lumo-primary-text-color);\n  }\n\n  a:not(:any-link) {\n    color: var(--lumo-disabled-text-color);\n  }\n\n  blockquote {\n    color: var(--lumo-secondary-text-color);\n  }\n\n  code,\n  pre {\n    background-color: var(--lumo-contrast-10pct);\n    border-radius: var(--lumo-border-radius-m);\n  }\n\n\n  html,\n  :host {\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size, var(--lumo-font-size-m));\n    line-height: var(--lumo-line-height-m);\n    -webkit-text-size-adjust: 100%;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  small,\n  [theme~='font-size-s'] {\n    font-size: var(--lumo-font-size-s);\n    line-height: var(--lumo-line-height-s);\n  }\n\n  [theme~='font-size-xs'] {\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n  }\n\n  h1,\n  h2,\n  h3,\n  h4,\n  h5,\n  h6 {\n    font-weight: 600;\n    line-height: var(--lumo-line-height-xs);\n    margin-top: 1.25em;\n  }\n\n  h1 {\n    font-size: var(--lumo-font-size-xxxl);\n    margin-bottom: 0.75em;\n  }\n\n  h2 {\n    font-size: var(--lumo-font-size-xxl);\n    margin-bottom: 0.5em;\n  }\n\n  h3 {\n    font-size: var(--lumo-font-size-xl);\n    margin-bottom: 0.5em;\n  }\n\n  h4 {\n    font-size: var(--lumo-font-size-l);\n    margin-bottom: 0.5em;\n  }\n\n  h5 {\n    font-size: var(--lumo-font-size-m);\n    margin-bottom: 0.25em;\n  }\n\n  h6 {\n    font-size: var(--lumo-font-size-xs);\n    margin-bottom: 0;\n    text-transform: uppercase;\n    letter-spacing: 0.03em;\n  }\n\n  p,\n  blockquote {\n    margin-top: 0.5em;\n    margin-bottom: 0.75em;\n  }\n\n  a {\n    text-decoration: none;\n  }\n\n  a:where(:any-link):hover {\n    text-decoration: underline;\n  }\n\n  hr {\n    display: block;\n    align-self: stretch;\n    height: 1px;\n    border: 0;\n    padding: 0;\n    margin: var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);\n    background-color: var(--lumo-contrast-10pct);\n  }\n\n  blockquote {\n    border-left: 2px solid var(--lumo-contrast-30pct);\n  }\n\n  b,\n  strong {\n    font-weight: 600;\n  }\n\n  /* RTL specific styles */\n  blockquote[dir='rtl'] {\n    border-left: none;\n    border-right: 2px solid var(--lumo-contrast-30pct);\n  }\n\n\n  :host([theme~='with-overlay']) {\n    min-height: 100%;\n    display: flex;\n    justify-content: center;\n    max-width: 100%;\n  }\n\n  /* Landscape small screen */\n  @media only screen and (max-height: 600px) and (min-width: 600px) and (orientation: landscape) {\n    :host([theme~='with-overlay']) [part='form'] {\n      height: 100%;\n      -webkit-overflow-scrolling: touch;\n      flex: 1;\n      padding: 2px;\n    }\n  }\n</style></template></vaadin-login-form-wrapper>\n    <style>\n    vaadin-button[part='vaadin-login-submit'] {\n      margin-top: var(--lumo-space-l);\n      margin-bottom: var(--lumo-space-s);\n    }\n  </style></vaadin-login-form>\n      <template shadowroot="open">\n      <style>\n        :host {\n          z-index: 200;\n          position: fixed;\n\n          /* Despite of what the names say, <vaadin-overlay> is just a container\n          for position/sizing/alignment. The actual overlay is the overlay part. */\n\n          /* Default position constraints: the entire viewport. Note: themes can\n          override this to introduce gaps between the overlay and the viewport. */\n          top: 0;\n          right: 0;\n          bottom: var(--vaadin-overlay-viewport-bottom);\n          left: 0;\n\n          /* Use flexbox alignment for the overlay part. */\n          display: flex;\n          flex-direction: column; /* makes dropdowns sizing easier */\n          /* Align to center by default. */\n          align-items: center;\n          justify-content: center;\n\n          /* Allow centering when max-width/max-height applies. */\n          margin: auto;\n\n          /* The host is not clickable, only the overlay part is. */\n          pointer-events: none;\n\n          /* Remove tap highlight on touch devices. */\n          -webkit-tap-highlight-color: transparent;\n\n          /* CSS API for host */\n          --vaadin-overlay-viewport-bottom: 0;\n        }\n\n        :host([hidden]),\n        :host(:not([opened]):not([closing])) {\n          display: none !important;\n        }\n\n        [part='overlay'] {\n          -webkit-overflow-scrolling: touch;\n          overflow: auto;\n          pointer-events: auto;\n\n          /* Prevent overflowing the host in MSIE 11 */\n          max-width: 100%;\n          box-sizing: border-box;\n\n          -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */\n        }\n\n        [part='backdrop'] {\n          z-index: -1;\n          content: '';\n          background: rgba(0, 0, 0, 0.5);\n          position: fixed;\n          top: 0;\n          left: 0;\n          bottom: 0;\n          right: 0;\n          pointer-events: auto;\n        }\n      </style>\n\n      <div id="backdrop" part="backdrop"></div>\n      <div part="overlay" id="overlay" tabindex="0">\n        <div part="content" id="content">\n          <section part="card">\n      <div part="brand">\n        <slot name="title">\n          <h1 part="title">App name</h1>\n        </slot>\n        <p part="description">Application description</p>\n      </div>\n      <div part="form">\n        <slot></slot>\n      </div>\n    </section>\n        <style>\n      [part="overlay"] {\n        outline: none;\n      }\n\n      [part="card"] {\n        max-width: 100%;\n        box-sizing: border-box;\n        overflow: hidden;\n        display: flex;\n        flex-direction: column;\n      }\n\n      [part="brand"] {\n        box-sizing: border-box;\n        overflow: hidden;\n        flex-grow: 1;\n        flex-shrink: 0;\n        display: flex;\n        flex-direction: column;\n        justify-content: flex-end;\n      }\n\n      [part="brand"] h1 {\n        color: inherit;\n        margin: 0;\n      }\n    </style></div>\n      </div>\n    <style>\n  :host {\n    top: var(--lumo-space-m);\n    right: var(--lumo-space-m);\n    bottom: var(--lumo-space-m);\n    left: var(--lumo-space-m);\n    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */\n    /* stylelint-disable-next-line */\n    outline: 0px solid transparent;\n  }\n\n  [part='overlay'] {\n    background-color: var(--lumo-base-color);\n    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));\n    border-radius: var(--lumo-border-radius-m);\n    box-shadow: 0 0 0 1px var(--lumo-shade-5pct), var(--lumo-box-shadow-m);\n    color: var(--lumo-body-text-color);\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size-m);\n    font-weight: 400;\n    line-height: var(--lumo-line-height-m);\n    letter-spacing: 0;\n    text-transform: none;\n    -webkit-text-size-adjust: 100%;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  [part='content'] {\n    padding: var(--lumo-space-xs);\n  }\n\n  [part='backdrop'] {\n    background-color: var(--lumo-shade-20pct);\n    animation: 0.2s lumo-overlay-backdrop-enter both;\n    will-change: opacity;\n  }\n\n  @keyframes lumo-overlay-backdrop-enter {\n    0% {\n      opacity: 0;\n    }\n  }\n\n  :host([closing]) [part='backdrop'] {\n    animation: 0.2s lumo-overlay-backdrop-exit both;\n  }\n\n  @keyframes lumo-overlay-backdrop-exit {\n    100% {\n      opacity: 0;\n    }\n  }\n\n  @keyframes lumo-overlay-dummy-animation {\n    0% {\n      opacity: 1;\n    }\n\n    100% {\n      opacity: 1;\n    }\n  }\n\n\n  [theme~='dark'] {\n    /* Base (background) */\n    --lumo-base-color: hsl(214, 35%, 21%);\n\n    /* Tint */\n    --lumo-tint-5pct: hsla(214, 65%, 85%, 0.06);\n    --lumo-tint-10pct: hsla(214, 60%, 80%, 0.14);\n    --lumo-tint-20pct: hsla(214, 64%, 82%, 0.23);\n    --lumo-tint-30pct: hsla(214, 69%, 84%, 0.32);\n    --lumo-tint-40pct: hsla(214, 73%, 86%, 0.41);\n    --lumo-tint-50pct: hsla(214, 78%, 88%, 0.5);\n    --lumo-tint-60pct: hsla(214, 82%, 90%, 0.58);\n    --lumo-tint-70pct: hsla(214, 87%, 92%, 0.69);\n    --lumo-tint-80pct: hsla(214, 91%, 94%, 0.8);\n    --lumo-tint-90pct: hsla(214, 96%, 96%, 0.9);\n    --lumo-tint: hsl(214, 100%, 98%);\n\n    /* Shade */\n    --lumo-shade-5pct: hsla(214, 0%, 0%, 0.07);\n    --lumo-shade-10pct: hsla(214, 4%, 2%, 0.15);\n    --lumo-shade-20pct: hsla(214, 8%, 4%, 0.23);\n    --lumo-shade-30pct: hsla(214, 12%, 6%, 0.32);\n    --lumo-shade-40pct: hsla(214, 16%, 8%, 0.41);\n    --lumo-shade-50pct: hsla(214, 20%, 10%, 0.5);\n    --lumo-shade-60pct: hsla(214, 24%, 12%, 0.6);\n    --lumo-shade-70pct: hsla(214, 28%, 13%, 0.7);\n    --lumo-shade-80pct: hsla(214, 32%, 13%, 0.8);\n    --lumo-shade-90pct: hsla(214, 33%, 13%, 0.9);\n    --lumo-shade: hsl(214, 33%, 13%);\n\n    /* Contrast */\n    --lumo-contrast-5pct: var(--lumo-tint-5pct);\n    --lumo-contrast-10pct: var(--lumo-tint-10pct);\n    --lumo-contrast-20pct: var(--lumo-tint-20pct);\n    --lumo-contrast-30pct: var(--lumo-tint-30pct);\n    --lumo-contrast-40pct: var(--lumo-tint-40pct);\n    --lumo-contrast-50pct: var(--lumo-tint-50pct);\n    --lumo-contrast-60pct: var(--lumo-tint-60pct);\n    --lumo-contrast-70pct: var(--lumo-tint-70pct);\n    --lumo-contrast-80pct: var(--lumo-tint-80pct);\n    --lumo-contrast-90pct: var(--lumo-tint-90pct);\n    --lumo-contrast: var(--lumo-tint);\n\n    /* Text */\n    --lumo-header-text-color: var(--lumo-contrast);\n    --lumo-body-text-color: var(--lumo-contrast-90pct);\n    --lumo-secondary-text-color: var(--lumo-contrast-70pct);\n    --lumo-tertiary-text-color: var(--lumo-contrast-50pct);\n    --lumo-disabled-text-color: var(--lumo-contrast-30pct);\n\n    /* Primary */\n    --lumo-primary-color: hsl(214, 90%, 48%);\n    --lumo-primary-color-50pct: hsla(214, 90%, 70%, 0.69);\n    --lumo-primary-color-10pct: hsla(214, 90%, 55%, 0.13);\n    --lumo-primary-text-color: hsl(214, 90%, 77%);\n    --lumo-primary-contrast-color: #fff;\n\n    /* Error */\n    --lumo-error-color: hsl(3, 79%, 49%);\n    --lumo-error-color-50pct: hsla(3, 75%, 62%, 0.5);\n    --lumo-error-color-10pct: hsla(3, 75%, 62%, 0.14);\n    --lumo-error-text-color: hsl(3, 100%, 80%);\n\n    /* Success */\n    --lumo-success-color: hsl(145, 72%, 30%);\n    --lumo-success-color-50pct: hsla(145, 92%, 51%, 0.5);\n    --lumo-success-color-10pct: hsla(145, 92%, 51%, 0.1);\n    --lumo-success-text-color: hsl(145, 85%, 46%);\n  }\n\n  html {\n    color: var(--lumo-body-text-color);\n    background-color: var(--lumo-base-color);\n    color-scheme: light;\n  }\n\n  [theme~='dark'] {\n    color: var(--lumo-body-text-color);\n    background-color: var(--lumo-base-color);\n    color-scheme: dark;\n  }\n\n  h1,\n  h2,\n  h3,\n  h4,\n  h5,\n  h6 {\n    color: var(--lumo-header-text-color);\n  }\n\n  a:where(:any-link) {\n    color: var(--lumo-primary-text-color);\n  }\n\n  a:not(:any-link) {\n    color: var(--lumo-disabled-text-color);\n  }\n\n  blockquote {\n    color: var(--lumo-secondary-text-color);\n  }\n\n  code,\n  pre {\n    background-color: var(--lumo-contrast-10pct);\n    border-radius: var(--lumo-border-radius-m);\n  }\n\n\n  html,\n  :host {\n    font-family: var(--lumo-font-family);\n    font-size: var(--lumo-font-size, var(--lumo-font-size-m));\n    line-height: var(--lumo-line-height-m);\n    -webkit-text-size-adjust: 100%;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n  }\n\n  small,\n  [theme~='font-size-s'] {\n    font-size: var(--lumo-font-size-s);\n    line-height: var(--lumo-line-height-s);\n  }\n\n  [theme~='font-size-xs'] {\n    font-size: var(--lumo-font-size-xs);\n    line-height: var(--lumo-line-height-xs);\n  }\n\n  h1,\n  h2,\n  h3,\n  h4,\n  h5,\n  h6 {\n    font-weight: 600;\n    line-height: var(--lumo-line-height-xs);\n    margin-top: 1.25em;\n  }\n\n  h1 {\n    font-size: var(--lumo-font-size-xxxl);\n    margin-bottom: 0.75em;\n  }\n\n  h2 {\n    font-size: var(--lumo-font-size-xxl);\n    margin-bottom: 0.5em;\n  }\n\n  h3 {\n    font-size: var(--lumo-font-size-xl);\n    margin-bottom: 0.5em;\n  }\n\n  h4 {\n    font-size: var(--lumo-font-size-l);\n    margin-bottom: 0.5em;\n  }\n\n  h5 {\n    font-size: var(--lumo-font-size-m);\n    margin-bottom: 0.25em;\n  }\n\n  h6 {\n    font-size: var(--lumo-font-size-xs);\n    margin-bottom: 0;\n    text-transform: uppercase;\n    letter-spacing: 0.03em;\n  }\n\n  p,\n  blockquote {\n    margin-top: 0.5em;\n    margin-bottom: 0.75em;\n  }\n\n  a {\n    text-decoration: none;\n  }\n\n  a:where(:any-link):hover {\n    text-decoration: underline;\n  }\n\n  hr {\n    display: block;\n    align-self: stretch;\n    height: 1px;\n    border: 0;\n    padding: 0;\n    margin: var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);\n    background-color: var(--lumo-contrast-10pct);\n  }\n\n  blockquote {\n    border-left: 2px solid var(--lumo-contrast-30pct);\n  }\n\n  b,\n  strong {\n    font-weight: 600;\n  }\n\n  /* RTL specific styles */\n  blockquote[dir='rtl'] {\n    border-left: none;\n    border-right: 2px solid var(--lumo-contrast-30pct);\n  }\n\n\n  :host {\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n  }\n\n  [part='backdrop'] {\n    background: var(--lumo-base-color) linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));\n  }\n\n  [part='content'] {\n    padding: 0;\n  }\n\n  [part='overlay'] {\n    background: none;\n    border-radius: 0;\n    box-shadow: none;\n    width: 100%;\n    height: 100%;\n  }\n\n  [part='card'] {\n    width: calc(var(--lumo-size-m) * 10);\n    background: var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));\n  }\n\n  [part='brand'] {\n    padding: var(--lumo-space-l) var(--lumo-space-xl) var(--lumo-space-l) var(--lumo-space-l);\n    background-color: var(--lumo-primary-color);\n    color: var(--lumo-primary-contrast-color);\n    min-height: calc(var(--lumo-size-m) * 5);\n  }\n\n  [part='description'] {\n    line-height: var(--lumo-line-height-s);\n    color: var(--lumo-tint-70pct);\n    margin-bottom: 0;\n  }\n\n  [part='content'] {\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n\n  [part='card'] {\n    border-radius: var(--lumo-border-radius-l);\n    box-shadow: var(--lumo-box-shadow-s);\n    margin: var(--lumo-space-s);\n    height: auto;\n  }\n\n  /* Small screen */\n  @media only screen and (max-width: 500px) {\n    [part='overlay'],\n    [part='content'] {\n      height: 100%;\n    }\n\n    [part='content'] {\n      min-height: 100%;\n      background: var(--lumo-base-color);\n      align-items: flex-start;\n    }\n\n    [part='card'],\n    [part='overlay'] {\n      width: 100%;\n      border-radius: 0;\n      box-shadow: none;\n      margin: 0;\n    }\n\n    /* RTL styles */\n    :host([dir='rtl']) [part='brand'] {\n      padding: var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-xl);\n    }\n  }\n\n  /* Landscape small screen */\n  @media only screen and (max-height: 600px) and (min-width: 600px) and (orientation: landscape) {\n    [part='card'] {\n      flex-direction: row;\n      align-items: stretch;\n      max-width: calc(var(--lumo-size-m) * 16);\n      width: 100%;\n    }\n\n    [part='brand'],\n    [part='form'] {\n      flex: auto;\n      flex-basis: 0;\n      box-sizing: border-box;\n    }\n\n    [part='brand'] {\n      justify-content: flex-start;\n    }\n\n    [part='form'] {\n      padding: var(--lumo-space-l);\n      overflow: auto;\n    }\n  }\n\n  /* Landscape really small screen */\n  @media only screen and (max-height: 500px) and (min-width: 600px) and (orientation: landscape),\n    only screen and (max-width: 600px) and (min-width: 600px) and (orientation: landscape) {\n    [part='content'] {\n      height: 100vh;\n    }\n\n    [part='card'] {\n      margin: 0;\n      width: 100%;\n      max-width: none;\n      height: 100%;\n      flex: auto;\n      border-radius: 0;\n      box-shadow: none;\n    }\n\n    [part='form'] {\n      height: 100%;\n      overflow: auto;\n      -webkit-overflow-scrolling: touch;\n    }\n  }\n\n  /* Handle iPhone X notch */\n  @media only screen and (device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) {\n    [part='card'] {\n      padding-right: constant(safe-area-inset-right);\n      padding-right: env(safe-area-inset-right);\n\n      padding-left: constant(safe-area-inset-left);\n      padding-left: env(safe-area-inset-left);\n    }\n\n    [part='brand'] {\n      margin-left: calc(constant(safe-area-inset-left) * -1);\n      margin-left: calc(env(safe-area-inset-left) * -1);\n\n      padding-left: calc(var(--lumo-space-l) + constant(safe-area-inset-left));\n      padding-left: calc(var(--lumo-space-l) + env(safe-area-inset-left));\n    }\n\n    /* RTL styles */\n    :host([dir='rtl']) [part='card'] {\n      padding-left: constant(safe-area-inset-right);\n      padding-left: env(safe-area-inset-right);\n      padding-right: constant(safe-area-inset-left);\n      padding-right: env(safe-area-inset-left);\n    }\n\n    :host([dir='rtl']) [part='brand'] {\n      margin-right: calc(constant(safe-area-inset-left) * -1);\n      margin-right: calc(env(safe-area-inset-left) * -1);\n      padding-right: calc(var(--lumo-space-l) + constant(safe-area-inset-left));\n      padding-right: calc(var(--lumo-space-l) + env(safe-area-inset-left));\n    }\n  }\n</style></template></vaadin-login-overlay-wrapper>\n    <style></style>`,
});

export const LoginOverlay = createVaadinComponent<
  LoginOverlayClass,
  typeof LoginOverlayEvents
>(
  "vaadin-login-overlay",
  LoginOverlayProperties,
  LoginOverlayEvents,
  () => import("@vaadin/login/vaadin-login-overlay.js"),
  "LoginOverlay",
  undefined,
  getLoginOverlayPreRenderConfig
);

export { LoginOverlayElement };
