<?php

namespace TomatoPHP\FilamentBookmarksMenu\Filament\Tables;

use Filament\Forms\Components\Select;
use Filament\Notifications\Notification;
use Filament\Tables\Actions\BulkAction;
use TomatoPHP\FilamentBookmarksMenu\Models\Bookmark;
use TomatoPHP\FilamentBookmarksMenu\Models\BookmarkLink;
use TomatoPHP\FilamentBookmarksMenu\Traits\HasPage;
use TomatoPHP\FilamentBookmarksMenu\Traits\HasTypes;

class BookmarkBulkClearAction extends BulkAction
{
    use HasPage;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        $this->name('bulk_clear_bookmark');
        $this->requiresConfirmation();
        $this->label(trans('filament-bookmarks-menu::messages.actions.bulk.remove'));
        $this->modalHeading(trans('filament-bookmarks-menu::messages.actions.bulk.modal.remove'));
        $this->color('danger');
        $this->deselectRecordsAfterCompletion();
        $this->icon('heroicon-s-bookmark-slash');
        $this->action(function (array $data, $records) {
            $records->each(function ($record) use ($data){
                $resource = app($this->getLivewire()::getResource());

                $checkExists = BookmarkLink::query()->where('url', $resource::getUrl($this->getPage(),['record' => $record]))->first();
                if($checkExists){
                    $checkExists->delete();
                }
            });

            Notification::make()
                ->title(trans('filament-bookmarks-menu::messages.actions.page.notification.remove.title'))
                ->body(trans('filament-bookmarks-menu::messages.actions.page.notification.remove.body'))
                ->success()
                ->send();

            return redirect()->back();
        });
    }
}
