简体中文 | [English](./README.en.md) 

<h1>TodoAdmin<font color="#666" size=4>-vue</font></h1>

<p align="center">
  <a href="https://pro.todoadmin.com" target="_blank">
    <img width="180" src="https://pro.todoadmin.com/logo.png?1" alt="logo">
  </a>
</p>
<p>一阳动、万物生！愿美好不期而遇、愿幸福如约而至、愿疫情早日消散、一起奔赴更好的未来、不辜负你我所有的努力。</p>

<p align="center">
    <a href="https://github.com/microsoft/TypeScript">
        <img src="https://img.shields.io/badge/TS-4.7+-blue" alt="TS">
    </a>
    <a href="https://github.com/npm/npm">
        <img src="https://img.shields.io/badge/npm-8.1+-blue" alt="npm">
    </a>
    <a href="https://opensource.org/licenses/MIT">
        <img src="https://img.shields.io/badge/license-MIT-blue" alt="license-mit">
    </a>
</p>


> TodoAdmin-Vue版：是一个集成管理后台端模板解决方案，项目采用TS脚本语言，基于Vue 3.2+/Vue-cli 5.0+/Vue-router 4.0+、Axios0.2.7+、Element-plus 2.2+、Pinia 2.0+、ECharts 5.3+等搭建，项目是以Composition api风格编写，采用远程API接口和本地Mock双接口模式加载数据。

<table>
    <tr>
        <td>
            <img width="450px" src="https://img.todoadmin.com/et/show/todo-3.gif">
        </td>
        <td>
            <img width="450px" src="https://img.todoadmin.com/et/show/todo-5.gif">
        </td>
    </tr>
</table>


## 体验Demo地址

- [Todoadmin-pro Pro专业版演示地址（vue3.2+ 支持 PC、平板、手机）](https://pro.todoadmin.com)
- [Todoadmin-base 基本版演示地址（vue3.2+ 支持 PC、平板、手机）](https://base.todoadmin.com)
<p>用户名：guest</p><p>密码：123456</p>




## 克隆vue-admin-chart 项目 [点击访问Github仓库](https://github.com/todoadmin/vue-admin-chart)

```bash
# 克隆项目
git clone -b  https://github.com/todoadmin/vue-admin-chart.git
# 安装依赖
npm i     or     yarn install
# 本地开发 启动项目
npm run serve     or     yarn serve
```


## 克隆vue-admin-chart 项目 [点击访问Gitee仓库](https://gitee.com/todoadmin/vue-admin-chart)

```bash
# 克隆项目
git clone -b  https://gitee.com/todoadmin/vue-admin-chart.git
# 安装依赖
npm i     or     yarn install
# 本地开发 启动项目
npm run serve     or     yarn serve
```


<p>以下为Pro版本的相关介绍</p>


## 项目生态插件【依赖】列表

| 标题名称               | 版本                                                       | 描述                                             |
| --------------------- | ------------------------------------------------------------ | ------------------------------------------------------- |
| [vue]                | [![vue-ico]][vue]                               | 构建用户界面的渐进式框架                           |
| [vue-router]          | [![vue-router-ico]][vue-router]                   | 单页应用程序路由                         |
| [vue-cli]             | [![vue-cli-ico]][vue-cli]                         | 项目脚手架                                    |
| [axios]          | [![axios-ico]][axios]                   | 基于promise的网络请求库 |
| [element-plus]          | [![element-plus-ico]][element-plus]                   | 基于Vue3的组件库 |
| [element-plus-icons]          | [![element-plus-icons-ico]][element-plus-icons]                   | 基于Vue3的组件图标库 |
| [vue-quill]          | [![vue-quill-ico]][vue-quill]                   | 可视化在线文本编辑器 |
| [quill-image-resize]          | [![quill-image-resize-ico]][quill-image-resize]                  | 文本编辑器图片重置尺寸 |
| [vue-cropper]          | [![vue-cropper-ico]][vue-cropper]                  | 基于Vue3的图片裁剪 |
| [pinia]          | [![pinia-ico]][pinia]                  | 状态管理 |
| [vue-i18n-next]          | [![vue-i18n-next-ico]][vue-i18n-next]                  | 多国语言文字切换 |
| [js-md5]          | [![js-md5-ico]][js-md5]                  | MD5加密 |
| [nprogress]          | [![nprogress-ico]][nprogress]                  | 进度条加载 |
| [echarts]          | [![echarts-ico]][echarts]                  | 多功能图表 |



## 项目安装（依赖安装）
```
npm install   or  yarn install
```

### 运行开发环境
```
npm run serve  or  yarn serve
```

### 生产环境打包
```
npm run build  or  yarn build
```

### 修复文件
```
npm run lint
```

### 配置文件
```
#config目录下
/src/config

#项目主体配置import模块
/src/config/index.ts

#项目启动环境配置引入模块
/src/config/config.ts

#项目启动环境（生产环境/Dev环境）基本配置引入模块
/src/config/module/base.ts

#项目启动环境（生产环境/Dev环境）CDN配置引入模块
/src/config/module/cdn.ts

#项目主体全局常量import模块
/src/config/module/global.ts

#项目主体HTTP/HTTPS Restful请求接口地址常量import模块
/src/config/module/HUrl.ts
```


[vue]: https://github.com/vuejs/vue
[vue-ico]:https://img.shields.io/badge/Vue-v3.2.36-brightgreen

[vue-router]: https://github.com/vuejs/vue-router
[vue-router-ico]:https://img.shields.io/badge/Vue--router-v4.0.15-brightgreen

[vue-cli]: https://github.com/vuejs/vue-cli
[vue-cli-ico]:https://img.shields.io/badge/Vue--cli-v5.0.1-brightgreen

[axios]: https://github.com/axios/axios
[axios-ico]:https://img.shields.io/badge/axios-v0.2.7-brightgreen

[element-plus]: https://github.com/element-plus/element-plus
[element-plus-ico]:https://img.shields.io/badge/element--plus-v2.2.2-brightgreen

[element-plus-icons]: https://github.com/element-plus/element-plus-icons
[element-plus-icons-ico]:https://img.shields.io/badge/element--plus--icons-2.x-brightgreen

[vue-quill]: https://github.com/vueup/vue-quill
[vue-quill-ico]:https://img.shields.io/badge/Vue--quill-v1.0.0--beta.8-brightgreen

[quill-image-resize]: https://github.com/kensnyder/quill-image-resize-module
[quill-image-resize-ico]:https://img.shields.io/badge/Quill--image--resize-v3.0.0-brightgreen

[vue-cropper]: https://github.com/xyxiao001/vue-cropper
[vue-cropper-ico]:https://img.shields.io/badge/vue--cropper-v1.0.3-brightgreen

[pinia]: https://github.com/vuejs/pinia
[pinia-ico]:https://img.shields.io/badge/Pinia-v2.0.14-brightgreen

[vue-jsonp]: https://github.com/LancerComet/vue-jsonp
[vue-jsonp-ico]:https://img.shields.io/badge/Vue--jsonp-v2.0.0-brightgreen

[vue-i18n-next]: https://github.com/intlify/vue-i18n-next/tree/master/packages/vue-i18n
[vue-i18n-next-ico]:https://img.shields.io/badge/Vue--i18n-v9.1.10-brightgreen

[js-md5]: https://github.com/emn178/js-md5
[js-md5-ico]:https://img.shields.io/badge/js--md5-v0.7.3-brightgreen

[nprogress]: https://github.com/rstacruz/nprogress
[nprogress-ico]:https://img.shields.io/badge/nprogress-v0.2.0-brightgreen

[echarts]: http://echarts.apache.org
[echarts-ico]:https://img.shields.io/badge/echarts-v5.3.2-brightgreen

---

## 前后端功能简介
<font color="#7167D6" size=5>前端</font>
- CDN 分布式引入JS/样式/图片/Json/地图数据
- 独家采用API远程实时数据接口和Mock本地数据双接口，可自由切换API或Mock
- 120+高质量组件页面
- 管理后台采用实时接口数据传输
- 实时生成可视化数据大屏动态图表
- 实时数据采用Websocket交互
- 采用Composition API模式
- 采用JWT 认证
- 实时监控系统&服务器资源使用
- 所有开源版本均可免费商用
- 跨平台 PC、手机端、平板等多端兼容
- 动态路由菜单认证和精确到用户的权限路由渲染
- 支持MarkDown(md)文件加载成Vue组件页面
- 支持mock本地模拟数据和远程模拟数据
- 支持按钮功能级别的权限控制
- 支持会员用户和管理员用户的角色、权限等分配
- 支持多种主题切换以及自定义添加主题样式
- 支持多国语言文字切换
- 支持Pinia的状态管理模式
- 支持自定义Vue指令
- 支持对接第三方物流平台
- 支持绑定第三方账号功能
- 支持日志追溯（用户操作和管理员操作）

<font color="#D66767" size=5>后端</font>
- 接口语言版本：Go （1.7+）
- 接口语言版本：PHP （8.0.2 +）/Swoole （4.8+）
- 接口语言版本：SpringBoot （2.2+）
- 可支持多种开源关系数据库切换：MySQL、MariaDB、PostgreSQL、openGauss、TiDB
- 可支持多种内存数据库切换：Redis、Memcached
- 可支持关系型数据库的集群
- 可支持内存型数据库的集群
- 可支持静态文件（图片、视频、文档等）云存储和CDN分发


## Demo地址&仓库地址

- [Todoadmin-pro Pro专业版演示地址（vue3.2+ 支持 PC、平板、手机）](https://pro.todoadmin.com)
- [Todoadmin-base 基本版演示地址（vue3.2+ 支持 PC、平板、手机）](https://base.todoadmin.com)
- [Github 地址](https://github.com/todoadmin/vue-admin-chart)
- [Gitee 码云地址](https://gitee.com/todoadmin/vue-admin-chart)
<p>用户名：guest</p><p>密码：123456</p>

## 打赏&联系

- 请喝杯茶呗，打赏后联系 QQ 308407381
<table>
    <tr>
        <td>
            <img width="200px" src="https://img.todoadmin.com/et/zfb-20.jpg">
        </td>
        <td>
            <img width="200px" src="https://img.todoadmin.com/et/wx-20.jpg">
        </td>
    </tr>
</table>


## 优势&注意事项

```
对比其他开源Admin后台管理框架有如下优势:
1. 独家采用API远程实时数据接口和Mock本地数据双接口调试（可自由切换数据接口模式）
2. 支持前后端路由菜单权限和功能按钮权限控制
3. 采用实时接口传输数据，让你事半功倍
4. 偏好数据、主题切换、多国语言切换等配置
5. 支持原生css和scss 自动排序，eslint 自动修复
6. axios 二次封装，支持多种模式和参数方式
7. websocket 封装，支持实时数据传输方式
8. 支持MD5/RSA加密登录
9. 支持https数据加密传输
10. 使用CDN分发项目样式css和js、图片，让速度飞起来
11. 支持全屏操作
12. 支持MarkDown(md)文件加载成Vue组件页面

使用注意事项:
1. 项目默认使用Chrome浏览器，Vue Devtools 插件调试
2. 项目默认使用VSCode + Eslint校验规范，需要配置vscode编辑器
3. 项目也可以使用Goland或IntelliJ IDEA + 相关插件开发
4. 项目使用MIT开源协议，请保留MIT开源协议即可免费商用

```


## 后台效果图预览

以下是截取的是 pro 版的效果图展示：

<table>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/dashboard.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/visual.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/default.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/black.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/red.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/green.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/blue.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/banner.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/white.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/origin.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/indexmessage2.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/Visual2.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/storecenter.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/membercenter.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/goods.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/order.png">
        </td>
    </tr>
</table>



## 提问

<p>如果你有任何疑问可以提出，作者会快速处理</p>

## 问题提交

<p>如果项目存在任何问题或者Bug，可以提交Issue</p>



## 浏览器&移动端浏览器

主流浏览器和IE 10+.

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) IE/Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" style="zoom:70%"/>](https://godban.github.io/browsers-support-badges/) Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) Safari |
| --------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------- |
| IE10/IE11/Edge                                             | last 2 versions                                              | last 2 versions                                              | last 2 versions                                              |


## 贡献

多谢每一位支持本项目的人士！



## 鸣谢

| 项目（排名不分先后）                                                          |
| ---------------------------------------------------------------- |
| [vue](https://github.com/vuejs/vue)                              |
| [element-plus](https://github.com/element-plus/element-plus)     |
| [pinia](https://github.com/vuejs/pinia) |
| [vue-i18n-next](https://github.com/intlify/vue-i18n-next/tree/master/packages/vue-i18n)                          |
| [axios](https://github.com/axios/axios)                          |
| [echarts](http://echarts.apache.org)      |
| [nprogress](https://github.com/rstacruz/nprogress)      |


## 商用注意事项

此项目可免费用于商业用途，请遵守 [MIT](https://opensource.org/licenses/MIT)  协议并保留作者技术支持声明。

Copyright (c) 2022-present, Todoadmin.com
