[简体中文](./README.md) | English

<h1>TodoAdmin<font color="#666" size=4>-vue</font></h1>

<p align="center">
  <a href="https://pro.todoadmin.com" target="_blank">
    <img width="180" src="https://pro.todoadmin.com/logo.png?1" alt="logo">
  </a>
</p>
<p>Yang Qi rising, all things are born! May beauty come by chance, happiness come as promised, and the epidemic disappear as soon as possible. Let's go to a better future together and live up to all our efforts.</p>

<p align="center">
    <a href="https://github.com/microsoft/TypeScript">
        <img src="https://img.shields.io/badge/TS-4.7+-blue" alt="TS">
    </a>
    <a href="https://github.com/npm/npm">
        <img src="https://img.shields.io/badge/npm-8.1+-blue" alt="npm">
    </a>
    <a href="https://opensource.org/licenses/MIT">
        <img src="https://img.shields.io/badge/license-MIT-blue" alt="license-mit">
    </a>
</p>


> TodoAdmin-Vue:It is an integrated management back-end template solution. The project uses TS script language and is based onVue 3.2+/Vue-cli 5.0+/Vue-router 4.0+、Axios0.2.7+、Element-plus 2.2+、Pinia 2.0+、ECharts 5.3+,The project is composition API style,use remote API & mock dual interface mode to load data.

<table>
    <tr>
        <td>
            <img width="450px" src="https://img.todoadmin.com/et/show/todo-3.gif">
        </td>
        <td>
            <img width="450px" src="https://img.todoadmin.com/et/show/todo-5.gif">
        </td>
    </tr>
</table>


## Demo

- [Todoadmin-pro Pro demo](https://pro.todoadmin.com)
- [Todoadmin-base Basic demo](https://base.todoadmin.com)
<p>Username：guest</p><p>Password：123456</p>



## Clone project [Click Github repository](https://github.com/todoadmin/vue-admin-chart)

```bash
# Clone
git clone -b  https://github.com/todoadmin/vue-admin-chart.git
# install
npm i     or     yarn install
# run project
npm run serve     or     yarn serve
```


## Clone project [Click Gitee repository](https://gitee.com/todoadmin/vue-admin-chart)

```bash
# Clone
git clone -b  https://gitee.com/todoadmin/vue-admin-chart.git
# install
npm i     or     yarn install
# run project
npm run serve     or     yarn serve
```


<p>The following is a introduction of the pro version</p>


## Ecosystem

| Project               | Status                                                       | Description                                             |
| --------------------- | ------------------------------------------------------------ | ------------------------------------------------------- |
| [vue]                | [![vue-ico]][vue]                               | Progressive JS Framework                             |
| [vue-router]          | [![vue-router-ico]][vue-router]                   | Single-page application routing                         |
| [vue-cli]             | [![vue-cli-ico]][vue-cli]                         | Project scaffolding                                    |
| [axios]          | [![axios-ico]][axios]                   | Promise network request Library |
| [element-plus]          | [![element-plus-ico]][element-plus]                   | Vue3 component library |
| [element-plus-icons]          | [![element-plus-icons-ico]][element-plus-icons]                   | Vue3 component Icon library |
| [vue-quill]          | [![vue-quill-ico]][vue-quill]                   | Visual online text editor |
| [quill-image-resize]          | [![quill-image-resize-ico]][quill-image-resize]                  | online text resize image |
| [vue-cropper]          | [![vue-cropper-ico]][vue-cropper]                  | vue image cropper |
| [pinia]          | [![pinia-ico]][pinia]                  | state management |
| [vue-i18n-next]          | [![vue-i18n-next-ico]][vue-i18n-next]                  | Multi language |
| [js-md5]          | [![js-md5-ico]][js-md5]                  | MD5 encryption |
| [nprogress]          | [![nprogress-ico]][nprogress]                  | Progress bar loading |
| [echarts]          | [![echarts-ico]][echarts]                  | echarts |



## Install（dependencies）
```
npm install   or  yarn install
```

### Run dev
```
npm run serve  or  yarn serve
```

### Build production
```
npm run build  or  yarn build
```

### ESLint
```
npm run lint
```

### Config
```
#config dir
/src/config

#project main import module
/src/config/index.ts

#project run env require module
/src/config/config.ts

#project run env（production/Dev）base config require module
/src/config/module/base.ts

#project run env（production/Dev）CDN config require module
/src/config/module/cdn.ts

#project main global constant import module
/src/config/module/global.ts

#project HTTP/HTTPS Restful request constant import module
/src/config/module/HUrl.ts
```


[vue]: https://github.com/vuejs/vue
[vue-ico]:https://img.shields.io/badge/Vue-v3.2.36-brightgreen

[vue-router]: https://github.com/vuejs/vue-router
[vue-router-ico]:https://img.shields.io/badge/Vue--router-v4.0.15-brightgreen

[vue-cli]: https://github.com/vuejs/vue-cli
[vue-cli-ico]:https://img.shields.io/badge/Vue--cli-v5.0.1-brightgreen

[axios]: https://github.com/axios/axios
[axios-ico]:https://img.shields.io/badge/axios-v0.2.7-brightgreen

[element-plus]: https://github.com/element-plus/element-plus
[element-plus-ico]:https://img.shields.io/badge/element--plus-v2.2.2-brightgreen

[element-plus-icons]: https://github.com/element-plus/element-plus-icons
[element-plus-icons-ico]:https://img.shields.io/badge/element--plus--icons-2.x-brightgreen

[vue-quill]: https://github.com/vueup/vue-quill
[vue-quill-ico]:https://img.shields.io/badge/Vue--quill-v1.0.0--beta.8-brightgreen

[quill-image-resize]: https://github.com/kensnyder/quill-image-resize-module
[quill-image-resize-ico]:https://img.shields.io/badge/Quill--image--resize-v3.0.0-brightgreen

[vue-cropper]: https://github.com/xyxiao001/vue-cropper
[vue-cropper-ico]:https://img.shields.io/badge/vue--cropper-v1.0.3-brightgreen

[pinia]: https://github.com/vuejs/pinia
[pinia-ico]:https://img.shields.io/badge/Pinia-v2.0.14-brightgreen

[vue-jsonp]: https://github.com/LancerComet/vue-jsonp
[vue-jsonp-ico]:https://img.shields.io/badge/Vue--jsonp-v2.0.0-brightgreen

[vue-i18n-next]: https://github.com/intlify/vue-i18n-next/tree/master/packages/vue-i18n
[vue-i18n-next-ico]:https://img.shields.io/badge/Vue--i18n-v9.1.10-brightgreen

[js-md5]: https://github.com/emn178/js-md5
[js-md5-ico]:https://img.shields.io/badge/js--md5-v0.7.3-brightgreen

[nprogress]: https://github.com/rstacruz/nprogress
[nprogress-ico]:https://img.shields.io/badge/nprogress-v0.2.0-brightgreen

[echarts]: http://echarts.apache.org
[echarts-ico]:https://img.shields.io/badge/echarts-v5.3.2-brightgreen

---

## Introduction functions
<font color="#7167D6" size=5>Web</font>
- CDN Distributed js/ css / image / map json data
- Adopted exclusively API remote real-time interface and mock data, and API or mock can be switched freely
- 120+ high quality components page
- The management real-time interface data transmission
- Real time generation of large screen dynamic chart of visual data
- Real-time data websocket interaction
- Composition API models
- JWT authentication
- Real-time monitoring system & server resource usage
- Commercially available free of charge
- PC, mobile, tablet and other multi terminal compatibility
- Dynamic routing menu authentication
- Support MarkDown(md) file to Vue Component page
- Support mock data and remote data
- Support button function permission control
- Support the assignment of roles and permissions of member and administrator
- Support multiple theme switching and adding custom theme styles
- Support multi language text switching
- Support Pinia state management
- Support for custom Vue directives
- Support docking with third-party logistics platforms
- Support binding third-party accounts
- Support log tracing (member and administrator operation)

<font color="#D66767" size=5>Restful & Websocket</font>
- Go apis ver（1.7+）
- PHP apis ver （8.0.2 +）/Swoole （4.8+）
- SpringBoot apis ver （2.2+）
- Support multiple open source relational database switching：MySQL、MariaDB、PostgreSQL、openGauss、TiDB
- Supports multiple memory database switching：Redis、Memcached
- Cluster supporting relational database
- Cluster supporting memory database
- Support cloud storage and CDN distribution of static files (images, videos, documents, ...) 


## Demo & Repository

- [Todoadmin-pro Pro demo](https://pro.todoadmin.com)
- [Todoadmin-base Basic demo](https://base.todoadmin.com)
- [Github repository](https://github.com/todoadmin/vue-admin-chart)
- [Gitee repository](https://gitee.com/todoadmin/vue-admin-chart)
<p>Username：guest</p><p>Password：123456</p>

## Reward & contact

- If you agree with the project, you can reward and contact QQ:308407381
<table>
    <tr>
        <td>
            <img width="200px" src="https://img.todoadmin.com/et/zfb-20.jpg">
        </td>
        <td>
            <img width="200px" src="https://img.todoadmin.com/et/wx-20.jpg">
        </td>
    </tr>
</table>



## Advantages & considerations

```
Compared with other open source admin management, it has the following advantages:
1. Adopted exclusively remote api real-time interface and mock data, and API or mock can be switched freely
2. Routing menu permission and button permission control
3. Use real-time transmit data
4. Preference data, topic switching, multi language switching ...
5. Native CSS and SCSS automatic sorting and eslint automatic repair
6. Axios secondary packaging supports multiple modes and parameter modes
7. Websocket encapsulation, supporting real-time data transmission
8. Support md5/rsa encryption login
9. Support HTTPS data encryption transmission
10. Use CDN to distribute CSS, JS and image, so speed up
11. Full screen operation
12. Support MarkDown(md) file to Vue Component page

Precautions for use:
1. Project uses Chrome browser , and Vue devtools plug-in debugging
2. Project uses the vscode + eslint verification, vscode editor needs to be configured
3. Project can also be developed using Golan or IntelliJ idea + related plug-ins
4. Project uses the MIT protocol. Please keep the MIT protocol for free commercial use

```


## Rendering Preview

The following is the screenshot of the pro version：

<table>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/dashboard.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/visual.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/default.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/black.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/red.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/green.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/blue.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/banner.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/white.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/origin.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/indexmessage2.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/Visual2.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/storecenter.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/membercenter.png">
        </td>
    </tr>
    <tr>
        <td>
            <img src="https://img.todoadmin.com/et/show/goods.png">
        </td>
        <td>
            <img src="https://img.todoadmin.com/et/show/order.png">
        </td>
    </tr>
</table>



## Questions

<p>For questions and support please use the official forum or community chat. The issue list of this repo is exclusively for bug reports and feature requests.</p>

## Issues

<p>Please make sure to read the Issue Reporting Checklist before opening an issue. Issues not conforming to the guidelines may be closed immediately.</p>



## Browser & mob

Mainstream browsers and IE 10+.

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) IE/Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" style="zoom:70%"/>](https://godban.github.io/browsers-support-badges/) Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" style="zoom:70%" />](https://godban.github.io/browsers-support-badges/) Safari |
| --------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------- |
| IE10/IE11/Edge                                             | last 2 versions                                              | last 2 versions                                              | last 2 versions                                              |


## Contribution

Thank you to everyone who supports this project！



## Acknowledgment

| Projects (in no particular order)                                                          |
| ---------------------------------------------------------------- |
| [vue](https://github.com/vuejs/vue)                              |
| [element-plus](https://github.com/element-plus/element-plus)     |
| [pinia](https://github.com/vuejs/pinia) |
| [vue-i18n-next](https://github.com/intlify/vue-i18n-next/tree/master/packages/vue-i18n)                          |
| [axios](https://github.com/axios/axios)                          |
| [echarts](http://echarts.apache.org)      |
| [nprogress](https://github.com/rstacruz/nprogress)      |


## Commercial considerations

This project can be used for commercial purposes free of charge. Please comply with [MIT]（ https://opensource.org/licenses/MIT ）Agreement and retention of the author's technical support statement

Copyright (c) 2022-present, Todoadmin.com
