# Docs

There're excellent articles about the implementation of seagull.

We recommend you to read all these documents if you want to learn web programming or get involved to develop seagull.

## Usage

```
pip install mkdocs
mkdocs serve
```

You can edit `mkdocs.yml` and change for Chinese.

## Catalog

* [Access docker remote API](en/development/access-docker-remote-api.md)
* [How seagull use Bootstrap](en/development/how-seagull-use-bootstrap.md)
* [Implement i18n with angular translate](en/development/implement-i18n-with-angular-translate.md)
* [Implement search in angular](en/development/implement-search-with-angular.md)
* [Implement angular filter](en/development/implement-angular-filter.md)
* [Seagull design and implement](en/development/seagull-design-and-implement.md)
* [Seagull translate guide](en/development/seagull-translate-guide.md)
* [Use AngularJS](en/development/use-angularjs.md)
* [Use animate.css](en/development/use-animate-css.md)
* [Use Beego as api server](en/development/use-beego-as-api-server.md)
* [Use Beego as web server](en/development/use-beego-as-web-server.md)
* [Use Bower to manage dependency](en/development/use-bower-to-manage-dependency.md)
* [Use drone for ci](en/development/use-drone-for-ci.md)
* [Use Godep to manage dependency](en/development/use-godep-to-manage-dependency.md)
* [Use JQuery.Gritter for notification](en/development/use-jquerygritter-for-notification.md)
* [Seagull dockerfile](en/development/write-seagull-dockerfile.md)
* [Seagull containers page](en/development/seagull-containers-page.md)
* [Seagull images page](en/development/seagull-images-page.md)
* [Seagull configuration page](en/development/seagull-configuration-page.md)
* [Seagull dockerhub page](en/development/seagull-dockerhub-page.md)
* [Similar docker projects](en/user_guide/similar-docker-projects.md)

## 目录

* [请求Docker远程API](zh/development/access-docker-remote-api.md)
* [海鸥的Bootstrap使用](zh/development/how-seagull-use-bootstrap.md)
* [使用Angular-translate实现国际化](zh/development/implement-i18n-with-angular-translate.md)
* [在Angular实现搜索](zh/development/implement-search-with-angular.md)
* [实现Angular过滤器](zh/development/implement-angular-filter.md)
* [海鸥的设计与实现](zh/development/seagull-design-and-implement.md)
* [海鸥翻译指南](zh/development/seagull-translate-guide.md)
* [使用AngularJS](zh/development/use-angularjs.md)
* [使用Animate.css](zh/development/use-animate-css.md)
* [使用Beego为API服务器](zh/development/use-beego-as-api-server.md)
* [使用Beego为Web服务器](zh/development/use-beego-as-web-server.md)
* [使用Bower管理依赖](zh/development/use-bower-to-manage-dependency.md)
* [使用Drone做持续集成](zh/development/use-drone-for-ci.md)
* [使用Godep管理依赖](zh/development/use-godep-to-manage-dependency.md)
* [使用JQuery.gritter实现通知](zh/development/use-jquerygritter-for-notification.md)
* [编写海鸥的Dockerfile](zh/development/write-seagull-dockerfile.md)
* [海鸥的容器页面](zh/development/seagull-containers-page.md)
* [海鸥的镜像页面](zh/development/seagull-images-page.md)
* [海鸥的配置页面](zh/development/seagull-configuration-page.md)
* [海鸥的仓库页面](zh/development/seagull-dockerhub-page.md)
* [类似的Docker项目](zh/development/similar-docker-projects.md)