<script language="javascript" runat="server">
// Modified version of https://github.com/zsxsoft/JWT-ASP
"use strict";
var sjcl = {
    cipher: {},
    hash: {},
    mode: {},
    misc: {},
    codec: {},
    exception: {
        corrupt: function(a) {
            this.toString = function() {
                return "CORRUPT: " + this.message
            };
            this.message = a
        },
        invalid: function(a) {
            this.toString = function() {
                return "INVALID: " + this.message
            };
            this.message = a
        },
        bug: function(a) {
            this.toString = function() {
                return "BUG: " + this.message
            };
            this.message = a
        }
    }
};
sjcl.cipher.aes = function(a) {
    this.h[0][0][0] || this.w();
    var b,
    c,
    d,
    e,
    f = this.h[0][4],
    g = this.h[1];
    b = a.length;
    var h = 1;
    if (b !== 4 && b !== 6 && b !== 8) throw new sjcl.exception.invalid("invalid aes key size");
    this.a = [d = a.slice(0), e = []];
    for (a = b; a < 4 * b + 28; a++) {
        c = d[a - 1];
        if (a % b === 0 || b === 8 && a % b === 4) {
            c = f[c >>> 24] << 24 ^ f[c >> 16 & 255] << 16 ^ f[c >> 8 & 255] << 8 ^ f[c & 255];
            if (a % b === 0) {
                c = c << 8 ^ c >>> 24 ^ h << 24;
                h = h << 1 ^ (h >> 7) * 283
            }
        }
        d[a] = d[a - b] ^ c
    }
    for (b = 0; a; b++, a--) {
        c = d[b & 3 ? a: a - 4];
        e[b] = a <= 4 || b < 4 ? c: g[0][f[c >>> 24]] ^ g[1][f[c >> 16 & 255]] ^ g[2][f[c >> 8 & 255]] ^ 
        g[3][f[c & 255]]
    }
};
sjcl.cipher.aes.prototype = {
    encrypt: function(a) {
        return this.H(a, 0)
    },
    decrypt: function(a) {
        return this.H(a, 1)
    },
    h: [[[], [], [], [], []], [[], [], [], [], []]],
    w: function() {
        var a = this.h[0],
        b = this.h[1],
        c = a[4],
        d = b[4],
        e,
        f,
        g,
        h = [],
        i = [],
        k,
        j,
        l,
        m;
        for (e = 0; e < 0x100; e++) i[(h[e] = e << 1 ^ (e >> 7) * 283) ^ e] = e;
        for (f = g = 0; ! c[f]; f ^= k || 1, g = i[g] || 1) {
            l = g ^ g << 1 ^ g << 2 ^ g << 3 ^ g << 4;
            l = l >> 8 ^ l & 255 ^ 99;
            c[f] = l;
            d[l] = f;
            j = h[e = h[k = h[f]]];
            m = j * 0x1010101 ^ e * 0x10001 ^ k * 0x101 ^ f * 0x1010100;
            j = h[l] * 0x101 ^ l * 0x1010100;
            for (e = 0; e < 4; e++) {
                a[e][f] = j = j << 24 ^ j >>> 8;
                b[e][l] = m = m << 24 ^ m >>> 8
            }
        }
        for (e = 
        0; e < 5; e++) {
            a[e] = a[e].slice(0);
            b[e] = b[e].slice(0)
        }
    },
    H: function(a, b) {
        if (a.length !== 4) throw new sjcl.exception.invalid("invalid aes block size");
        var c = this.a[b],
        d = a[0] ^ c[0],
        e = a[b ? 3: 1] ^ c[1],
        f = a[2] ^ c[2];
        a = a[b ? 1: 3] ^ c[3];
        var g,
        h,
        i,
        k = c.length / 4 - 2,
        j,
        l = 4,
        m = [0, 0, 0, 0];
        g = this.h[b];
        var n = g[0],
        o = g[1],
        p = g[2],
        q = g[3],
        r = g[4];
        for (j = 0; j < k; j++) {
            g = n[d >>> 24] ^ o[e >> 16 & 255] ^ p[f >> 8 & 255] ^ q[a & 255] ^ c[l];
            h = n[e >>> 24] ^ o[f >> 16 & 255] ^ p[a >> 8 & 255] ^ q[d & 255] ^ c[l + 1];
            i = n[f >>> 24] ^ o[a >> 16 & 255] ^ p[d >> 8 & 255] ^ q[e & 255] ^ c[l + 2];
            a = n[a >>> 24] ^ o[d >> 16 & 
            255] ^ p[e >> 8 & 255] ^ q[f & 255] ^ c[l + 3];
            l += 4;
            d = g;
            e = h;
            f = i
        }
        for (j = 0; j < 4; j++) {
            m[b ? 3 & -j: j] = r[d >>> 24] << 24 ^ r[e >> 16 & 255] << 16 ^ r[f >> 8 & 255] << 8 ^ r[a & 255] ^ c[l++];
            g = d;
            d = e;
            e = f;
            f = a;
            a = g
        }
        return m
    }
};
sjcl.bitArray = {
    bitSlice: function(a, b, c) {
        a = sjcl.bitArray.P(a.slice(b / 32), 32 - (b & 31)).slice(1);
        return c === undefined ? a: sjcl.bitArray.clamp(a, c - b)
    },
    concat: function(a, b) {
        if (a.length === 0 || b.length === 0) return a.concat(b);
        var c = a[a.length - 1],
        d = sjcl.bitArray.getPartial(c);
        return d === 32 ? a.concat(b) : sjcl.bitArray.P(b, d, c | 0, a.slice(0, a.length - 1))
    },
    bitLength: function(a) {
        var b = a.length;
        if (b === 0) return 0;
        return (b - 1) * 32 + sjcl.bitArray.getPartial(a[b - 1])
    },
    clamp: function(a, b) {
        if (a.length * 32 < b) return a;
        a = a.slice(0, Math.ceil(b / 
        32));
        var c = a.length;
        b &= 31;
        if (c > 0 && b) a[c - 1] = sjcl.bitArray.partial(b, a[c - 1] & 2147483648 >> b - 1, 1);
        return a
    },
    partial: function(a, b, c) {
        if (a === 32) return b;
        return (c ? b | 0: b << 32 - a) + a * 0x10000000000
    },
    getPartial: function(a) {
        return Math.round(a / 0x10000000000) || 32
    },
    equal: function(a, b) {
        if (sjcl.bitArray.bitLength(a) !== sjcl.bitArray.bitLength(b)) return false;
        var c = 0,
        d;
        for (d = 0; d < a.length; d++) c |= a[d] ^ b[d];
        return c === 0
    },
    P: function(a, b, c, d) {
        var e;
        e = 0;
        if (d === undefined) d = [];
        for (; b >= 32; b -= 32) {
            d.push(c);
            c = 0
        }
        if (b === 0) return d.concat(a);
        for (e = 0; e < a.length; e++) {
            d.push(c | a[e] >>> b);
            c = a[e] << 32 - b
        }
        e = a.length ? a[a.length - 1] : 0;
        a = sjcl.bitArray.getPartial(e);
        d.push(sjcl.bitArray.partial(b + a & 31, b + a > 32 ? c: d.pop(), 1));
        return d
    },
    k: function(a, b) {
        return [a[0] ^ b[0], a[1] ^ b[1], a[2] ^ b[2], a[3] ^ b[3]]
    }
};
sjcl.codec.utf8String = {
    fromBits: function(a) {
        var b = "",
        c = sjcl.bitArray.bitLength(a),
        d,
        e;
        for (d = 0; d < c / 8; d++) {
            if ((d & 3) === 0) e = a[d / 4];
            b += String.fromCharCode(e >>> 24);
            e <<= 8
        }
        return decodeURIComponent(escape(b))
    },
    toBits: function(a) {
        a = unescape(encodeURIComponent(a));
        var b = [],
        c,
        d = 0;
        for (c = 0; c < a.length; c++) {
            d = d << 8 | a.charCodeAt(c);
            if ((c & 3) === 3) {
                b.push(d);
                d = 0
            }
        }
        c & 3 && b.push(sjcl.bitArray.partial(8 * (c & 3), d));
        return b
    }
};
sjcl.codec.hex = {
    fromBits: function(a) {
        var b = "",
        c;
        for (c = 0; c < a.length; c++) b += ((a[c] | 0) + 0xf00000000000).toString(16).substr(4);
        return b.substr(0, sjcl.bitArray.bitLength(a) / 4)
    },
    toBits: function(a) {
        var b,
        c = [],
        d;
        a = a.replace(/\s|0x/g, "");
        d = a.length;
        a += "00000000";
        for (b = 0; b < a.length; b += 8) c.push(parseInt(a.substr(b, 8), 16) ^ 0);
        return sjcl.bitArray.clamp(c, d * 4)
    }
};
sjcl.codec.base64 = {
    D: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
    fromBits: function(a, b) {
        var c = "",
        d,
        e = 0,
        f = sjcl.codec.base64.D,
        g = 0,
        h = sjcl.bitArray.bitLength(a);
        for (d = 0; c.length * 6 < h;) {
            c += f.charAt((g ^ a[d] >>> e) >>> 26);
            if (e < 6) {
                g = a[d] << 6 - e;
                e += 26;
                d++
            } else {
                g <<= 6;
                e -= 6
            }
        }
        for (; c.length & 3 && !b;) c += "=";
        return c
    },
    toBits: function(a) {
        a = a.replace(/\s|=/g, "");
        var b = [],
        c,
        d = 0,
        e = sjcl.codec.base64.D,
        f = 0,
        g;
        for (c = 0; c < a.length; c++) {
            g = e.indexOf(a.charAt(c));
            if (g < 0) throw new sjcl.exception.invalid("this isn't base64!");
            if (d > 26) {
                d -= 26;
                b.push(f ^ g >>> d);
                f = g << 32 - d
            } else {
                d += 6;
                f ^= g << 32 - d
            }
        }
        d & 56 && b.push(sjcl.bitArray.partial(d & 56, f, 1));
        return b
    }
};
sjcl.hash.sha256 = function(a) {
    this.a[0] || this.w();
    if (a) {
        this.n = a.n.slice(0);
        this.i = a.i.slice(0);
        this.e = a.e
    } else this.reset()
};
sjcl.hash.sha256.hash = function(a) {
    return (new sjcl.hash.sha256).update(a).finalize()
};
sjcl.hash.sha256.prototype = {
    blockSize: 512,
    reset: function() {
        this.n = this.N.slice(0);
        this.i = [];
        this.e = 0;
        return this
    },
    update: function(a) {
        if (typeof a === "string") a = sjcl.codec.utf8String.toBits(a);
        var b,
        c = this.i = sjcl.bitArray.concat(this.i, a);
        b = this.e;
        a = this.e = b + sjcl.bitArray.bitLength(a);
        for (b = 512 + b & -512; b <= a; b += 512) this.C(c.splice(0, 16));
        return this
    },
    finalize: function() {
        var a,
        b = this.i,
        c = this.n;
        b = sjcl.bitArray.concat(b, [sjcl.bitArray.partial(1, 1)]);
        for (a = b.length + 2; a & 15; a++) b.push(0);
        b.push(Math.floor(this.e / 
        4294967296));
        for (b.push(this.e | 0); b.length;) this.C(b.splice(0, 16));
        this.reset();
        return c
    },
    N: [],
    a: [],
    w: function() {
        function a(e) {
            return (e - Math.floor(e)) * 0x100000000 | 0
        }
        var b = 0,
        c = 2,
        d;
        a: for (; b < 64; c++) {
            for (d = 2; d * d <= c; d++) if (c % d === 0) continue a;
            if (b < 8) this.N[b] = a(Math.pow(c, 0.5));
            this.a[b] = a(Math.pow(c, 1 / 3));
            b++
        }
    },
    C: function(a) {
        var b,
        c,
        d = a.slice(0),
        e = this.n,
        f = this.a,
        g = e[0],
        h = e[1],
        i = e[2],
        k = e[3],
        j = e[4],
        l = e[5],
        m = e[6],
        n = e[7];
        for (a = 0; a < 64; a++) {
            if (a < 16) b = d[a];
            else {
                b = d[a + 1 & 15];
                c = d[a + 14 & 15];
                b = d[a & 15] = (b >>> 7 ^ b >>> 18 ^ 
                b >>> 3 ^ b << 25 ^ b << 14) + (c >>> 17 ^ c >>> 19 ^ c >>> 10 ^ c << 15 ^ c << 13) + d[a & 15] + d[a + 9 & 15] | 0
            }
            b = b + n + (j >>> 6 ^ j >>> 11 ^ j >>> 25 ^ j << 26 ^ j << 21 ^ j << 7) + (m ^ j & (l ^ m)) + f[a];
            n = m;
            m = l;
            l = j;
            j = k + b | 0;
            k = i;
            i = h;
            h = g;
            g = b + (h & i ^ k & (h ^ i)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0
        }
        e[0] = e[0] + g | 0;
        e[1] = e[1] + h | 0;
        e[2] = e[2] + i | 0;
        e[3] = e[3] + k | 0;
        e[4] = e[4] + j | 0;
        e[5] = e[5] + l | 0;
        e[6] = e[6] + m | 0;
        e[7] = e[7] + n | 0
    }
};
sjcl.mode.ccm = {
    name: "ccm",
    encrypt: function(a, b, c, d, e) {
        var f,
        g = b.slice(0),
        h = sjcl.bitArray,
        i = h.bitLength(c) / 8,
        k = h.bitLength(g) / 8;
        e = e || 64;
        d = d || [];
        if (i < 7) throw new sjcl.exception.invalid("ccm: iv must be at least 7 bytes");
        for (f = 2; f < 4 && k >>> 8 * f; f++);
        if (f < 15 - i) f = 15 - i;
        c = h.clamp(c, 8 * (15 - f));
        b = sjcl.mode.ccm.G(a, b, c, d, e, f);
        g = sjcl.mode.ccm.I(a, g, c, b, e, f);
        return h.concat(g.data, g.tag)
    },
    decrypt: function(a, b, c, d, e) {
        e = e || 64;
        d = d || [];
        var f = sjcl.bitArray,
        g = f.bitLength(c) / 8,
        h = f.bitLength(b),
        i = f.clamp(b, h - e),
        k = f.bitSlice(b, 
        h - e);
        h = (h - e) / 8;
        if (g < 7) throw new sjcl.exception.invalid("ccm: iv must be at least 7 bytes");
        for (b = 2; b < 4 && h >>> 8 * b; b++);
        if (b < 15 - g) b = 15 - g;
        c = f.clamp(c, 8 * (15 - b));
        i = sjcl.mode.ccm.I(a, i, c, k, e, b);
        a = sjcl.mode.ccm.G(a, i.data, c, d, e, b);
        if (!f.equal(i.tag, a)) throw new sjcl.exception.corrupt("ccm: tag doesn't match");
        return i.data
    },
    G: function(a, b, c, d, e, f) {
        var g = [],
        h = sjcl.bitArray,
        i = h.k;
        e /= 8;
        if (e % 2 || e < 4 || e > 16) throw new sjcl.exception.invalid("ccm: invalid tag length");
        if (d.length > 0xffffffff || b.length > 0xffffffff) throw new sjcl.exception.bug("ccm: can't deal with 4GiB or more data");
        f = [h.partial(8, (d.length ? 64: 0) | e - 2 << 2 | f - 1)];
        f = h.concat(f, c);
        f[3] |= h.bitLength(b) / 8;
        f = a.encrypt(f);
        if (d.length) {
            c = h.bitLength(d) / 8;
            if (c <= 65279) g = [h.partial(16, c)];
            else if (c <= 0xffffffff) g = h.concat([h.partial(16, 65534)], [c]);
            g = h.concat(g, d);
            for (d = 0; d < g.length; d += 4) f = a.encrypt(i(f, g.slice(d, d + 4)))
        }
        for (d = 0; d < b.length; d += 4) f = a.encrypt(i(f, b.slice(d, d + 4)));
        return h.clamp(f, e * 8)
    },
    I: function(a, b, c, d, e, f) {
        var g,
        h = sjcl.bitArray;
        g = h.k;
        var i = b.length,
        k = h.bitLength(b);
        c = h.concat([h.partial(8, f - 1)], c).concat([0, 
        0, 0]).slice(0, 4);
        d = h.bitSlice(g(d, a.encrypt(c)), 0, e);
        if (!i) return {
            tag: d,
            data: []
        };
        for (g = 0; g < i; g += 4) {
            c[3]++;
            e = a.encrypt(c);
            b[g] ^= e[0];
            b[g + 1] ^= e[1];
            b[g + 2] ^= e[2];
            b[g + 3] ^= e[3]
        }
        return {
            tag: d,
            data: h.clamp(b, k)
        }
    }
};
sjcl.mode.ocb2 = {
    name: "ocb2",
    encrypt: function(a, b, c, d, e, f) {
        if (sjcl.bitArray.bitLength(c) !== 128) throw new sjcl.exception.invalid("ocb iv must be 128 bits");
        var g,
        h = sjcl.mode.ocb2.A,
        i = sjcl.bitArray,
        k = i.k,
        j = [0, 0, 0, 0];
        c = h(a.encrypt(c));
        var l,
        m = [];
        d = d || [];
        e = e || 64;
        for (g = 0; g + 4 < b.length; g += 4) {
            l = b.slice(g, g + 4);
            j = k(j, l);
            m = m.concat(k(c, a.encrypt(k(c, l))));
            c = h(c)
        }
        l = b.slice(g);
        b = i.bitLength(l);
        g = a.encrypt(k(c, [0, 0, 0, b]));
        l = i.clamp(k(l, g), b);
        j = k(j, k(l, g));
        j = a.encrypt(k(j, k(c, h(c))));
        if (d.length) j = k(j, f ? d: sjcl.mode.ocb2.pmac(a, 
        d));
        return m.concat(i.concat(l, i.clamp(j, e)))
    },
    decrypt: function(a, b, c, d, e, f) {
        if (sjcl.bitArray.bitLength(c) !== 128) throw new sjcl.exception.invalid("ocb iv must be 128 bits");
        e = e || 64;
        var g = sjcl.mode.ocb2.A,
        h = sjcl.bitArray,
        i = h.k,
        k = [0, 0, 0, 0],
        j = g(a.encrypt(c)),
        l,
        m,
        n = sjcl.bitArray.bitLength(b) - e,
        o = [];
        d = d || [];
        for (c = 0; c + 4 < n / 32; c += 4) {
            l = i(j, a.decrypt(i(j, b.slice(c, c + 4))));
            k = i(k, l);
            o = o.concat(l);
            j = g(j)
        }
        m = n - c * 32;
        l = a.encrypt(i(j, [0, 0, 0, m]));
        l = i(l, h.clamp(b.slice(c), m));
        k = i(k, l);
        k = a.encrypt(i(k, i(j, g(j))));
        if (d.length) k = 
        i(k, f ? d: sjcl.mode.ocb2.pmac(a, d));
        if (!h.equal(h.clamp(k, e), h.bitSlice(b, n))) throw new sjcl.exception.corrupt("ocb: tag doesn't match");
        return o.concat(h.clamp(l, m))
    },
    pmac: function(a, b) {
        var c,
        d = sjcl.mode.ocb2.A,
        e = sjcl.bitArray,
        f = e.k,
        g = [0, 0, 0, 0],
        h = a.encrypt([0, 0, 0, 0]);
        h = f(h, d(d(h)));
        for (c = 0; c + 4 < b.length; c += 4) {
            h = d(h);
            g = f(g, a.encrypt(f(h, b.slice(c, c + 4))))
        }
        b = b.slice(c);
        if (e.bitLength(b) < 128) {
            h = f(h, d(h));
            b = e.concat(b, [2147483648 | 0])
        }
        g = f(g, b);
        return a.encrypt(f(d(f(h, d(h))), g))
    },
    A: function(a) {
        return [a[0] << 
        1 ^ a[1] >>> 31, a[1] << 1 ^ a[2] >>> 31, a[2] << 1 ^ a[3] >>> 31, a[3] << 1 ^ (a[0] >>> 31) * 135]
    }
};
sjcl.misc.hmac = function(a, b) {
    this.M = b = b || sjcl.hash.sha256;
    var c = [[], []],
    d = b.prototype.blockSize / 32;
    this.l = [new b, new b];
    if (a.length > d) a = b.hash(a);
    for (b = 0; b < d; b++) {
        c[0][b] = a[b] ^ 909522486;
        c[1][b] = a[b] ^ 1549556828
    }
    this.l[0].update(c[0]);
    this.l[1].update(c[1])
};
sjcl.misc.hmac.prototype.encrypt = sjcl.misc.hmac.prototype.mac = function(a, b) {
    a = (new this.M(this.l[0])).update(a, b).finalize();
    return (new this.M(this.l[1])).update(a).finalize()
};
sjcl.misc.pbkdf2 = function(a, b, c, d, e) {
    c = c || 1E3;
    if (d < 0 || c < 0) throw sjcl.exception.invalid("invalid params to pbkdf2");
    if (typeof a === "string") a = sjcl.codec.utf8String.toBits(a);
    e = e || sjcl.misc.hmac;
    a = new e(a);
    var f,
    g,
    h,
    i,
    k = [],
    j = sjcl.bitArray;
    for (i = 1; 32 * k.length < (d || 1); i++) {
        e = f = a.encrypt(j.concat(b, [i]));
        for (g = 1; g < c; g++) {
            f = a.encrypt(f);
            for (h = 0; h < f.length; h++) e[h] ^= f[h]
        }
        k = k.concat(e)
    }
    if (d) k = j.clamp(k, d);
    return k
};
sjcl.random = {
    randomWords: function(a, b) {
        var c = [];
        b = this.isReady(b);
        var d;
        if (b === 0) throw new sjcl.exception.notready("generator isn't seeded");
        else b & 2 && this.U(!(b & 1));
        for (b = 0; b < a; b += 4) { (b + 1) % 0x10000 === 0 && this.L();
            d = this.u();
            c.push(d[0], d[1], d[2], d[3])
        }
        this.L();
        return c.slice(0, a)
    },
    setDefaultParanoia: function(a) {
        this.t = a
    },
    addEntropy: function(a, b, c) {
        c = c || "user";
        var d,
        e,
        f = (new Date).valueOf(),
        g = this.q[c],
        h = this.isReady();
        d = this.F[c];
        if (d === undefined) d = this.F[c] = this.R++;
        if (g === undefined) g = this.q[c] = 0;
        this.q[c] = 
        (this.q[c] + 1) % this.b.length;
        switch (typeof a) {
        case "number":
            break;
        case "object":
            if (b === undefined) for (c = b = 0; c < a.length; c++) for (e = a[c]; e > 0;) {
                b++;
                e >>>= 1
            }
            this.b[g].update([d, this.J++, 2, b, f, a.length].concat(a));
            break;
        case "string":
            if (b === undefined) b = a.length;
            this.b[g].update([d, this.J++, 3, b, f, a.length]);
            this.b[g].update(a);
            break;
        default:
            throw new sjcl.exception.bug("random: addEntropy only supports number, array or string");
        }
        this.j[g] += b;
        this.f += b;
        if (h === 0) {
            this.isReady() !== 0 && this.K("seeded", Math.max(this.g, 
            this.f));
            this.K("progress", this.getProgress())
        }
    },
    isReady: function(a) {
        a = this.B[a !== undefined ? a: this.t];
        return this.g && this.g >= a ? this.j[0] > 80 && (new Date).valueOf() > this.O ? 3: 1: this.f >= a ? 2: 0
    },
    getProgress: function(a) {
        a = this.B[a ? a: this.t];
        return this.g >= a ? 1["0"] : this.f > a ? 1["0"] : this.f / a
    },
    startCollectors: function() {
        if (!this.m) {
            if (window.addEventListener) {
                window.addEventListener("load", this.o, false);
                window.addEventListener("mousemove", this.p, false)
            } else if (document.attachEvent) {
                document.attachEvent("onload", 
                this.o);
                document.attachEvent("onmousemove", this.p)
            } else throw new sjcl.exception.bug("can't attach event");
            this.m = true
        }
    },
    stopCollectors: function() {
        if (this.m) {
            if (window.removeEventListener) {
                window.removeEventListener("load", this.o);
                window.removeEventListener("mousemove", this.p)
            } else if (window.detachEvent) {
                window.detachEvent("onload", this.o);
                window.detachEvent("onmousemove", this.p)
            }
            this.m = false
        }
    },
    addEventListener: function(a, b) {
        this.r[a][this.Q++] = b
    },
    removeEventListener: function(a, b) {
        var c;
        a = this.r[a];
        var d = [];
        for (c in a) a.hasOwnProperty[c] && a[c] === b && d.push(c);
        for (b = 0; b < d.length; b++) {
            c = d[b];
            delete a[c]
        }
    },
    b: [new sjcl.hash.sha256],
    j: [0],
    z: 0,
    q: {},
    J: 0,
    F: {},
    R: 0,
    g: 0,
    f: 0,
    O: 0,
    a: [0, 0, 0, 0, 0, 0, 0, 0],
    d: [0, 0, 0, 0],
    s: undefined,
    t: 6,
    m: false,
    r: {
        progress: {},
        seeded: {}
    },
    Q: 0,
    B: [0, 48, 64, 96, 128, 192, 0x100, 384, 512, 768, 1024],
    u: function() {
        for (var a = 0; a < 4; a++) {
            this.d[a] = this.d[a] + 1 | 0;
            if (this.d[a]) break
        }
        return this.s.encrypt(this.d)
    },
    L: function() {
        this.a = this.u().concat(this.u());
        this.s = new sjcl.cipher.aes(this.a)
    },
    T: function(a) {
        this.a = 
        sjcl.hash.sha256.hash(this.a.concat(a));
        this.s = new sjcl.cipher.aes(this.a);
        for (a = 0; a < 4; a++) {
            this.d[a] = this.d[a] + 1 | 0;
            if (this.d[a]) break
        }
    },
    U: function(a) {
        var b = [],
        c = 0,
        d;
        this.O = b[0] = (new Date).valueOf() + 3E4;
        for (d = 0; d < 16; d++) b.push(Math.random() * 0x100000000 | 0);
        for (d = 0; d < this.b.length; d++) {
            b = b.concat(this.b[d].finalize());
            c += this.j[d];
            this.j[d] = 0;
            if (!a && this.z & 1 << d) break
        }
        if (this.z >= 1 << this.b.length) {
            this.b.push(new sjcl.hash.sha256);
            this.j.push(0)
        }
        this.f -= c;
        if (c > this.g) this.g = c;
        this.z++;
        this.T(b)
    },
    p: function(a) {
        sjcl.random.addEntropy([a.x || 
        a.clientX || a.offsetX, a.y || a.clientY || a.offsetY], 2, "mouse")
    },
    o: function() {
        sjcl.random.addEntropy(new Date, 2, "loadtime")
    },
    K: function(a, b) {
        var c;
        a = sjcl.random.r[a];
        var d = [];
        for (c in a) a.hasOwnProperty(c) && d.push(a[c]);
        for (c = 0; c < d.length; c++) d[c](b)
    }
};
sjcl.json = {
    defaults: {
        v: 1,
        iter: 1E3,
        ks: 128,
        ts: 64,
        mode: "ccm",
        adata: "",
        cipher: "aes"
    },
    encrypt: function(a, b, c, d) {
        c = c || {};
        d = d || {};
        var e = sjcl.json,
        f = e.c({

            iv: sjcl.random.randomWords(4, 0)
        },
        e.defaults);
        e.c(f, c);
        if (typeof f.salt === "string") f.salt = sjcl.codec.base64.toBits(f.salt);
        if (typeof f.iv === "string") f.iv = sjcl.codec.base64.toBits(f.iv);
        if (!sjcl.mode[f.mode] || !sjcl.cipher[f.cipher] || typeof a === "string" && f.iter <= 100 || f.ts !== 64 && f.ts !== 96 && f.ts !== 128 || f.ks !== 128 && f.ks !== 192 && f.ks !== 0x100 || f.iv.length < 2 || f.iv.length > 
        4) throw new sjcl.exception.invalid("json encrypt: invalid parameters");
        if (typeof a === "string") {
            c = sjcl.misc.cachedPbkdf2(a, f);
            a = c.key.slice(0, f.ks / 32);
            f.salt = c.salt
        }
        if (typeof b === "string") b = sjcl.codec.utf8String.toBits(b);
        c = new sjcl.cipher[f.cipher](a);
        e.c(d, f);
        d.key = a;
        f.ct = sjcl.mode[f.mode].encrypt(c, b, f.iv, f.adata, f.tag);
        return e.encode(e.V(f, e.defaults))
    },
    decrypt: function(a, b, c, d) {
        c = c || {};
        d = d || {};
        var e = sjcl.json;
        b = e.c(e.c(e.c({},
        e.defaults), e.decode(b)), c, true);
        if (typeof b.salt === "string") b.salt = 
        sjcl.codec.base64.toBits(b.salt);
        if (typeof b.iv === "string") b.iv = sjcl.codec.base64.toBits(b.iv);
        if (!sjcl.mode[b.mode] || !sjcl.cipher[b.cipher] || typeof a === "string" && b.iter <= 100 || b.ts !== 64 && b.ts !== 96 && b.ts !== 128 || b.ks !== 128 && b.ks !== 192 && b.ks !== 0x100 || !b.iv || b.iv.length < 2 || b.iv.length > 4) throw new sjcl.exception.invalid("json decrypt: invalid parameters");
        if (typeof a === "string") {
            c = sjcl.misc.cachedPbkdf2(a, b);
            a = c.key.slice(0, b.ks / 32);
            b.salt = c.salt
        }
        c = new sjcl.cipher[b.cipher](a);
        c = sjcl.mode[b.mode].decrypt(c, 
        b.ct, b.iv, b.adata, b.tag);
        e.c(d, b);
        d.key = a;
        return sjcl.codec.utf8String.fromBits(c)
    },
    encode: function(a) {
        var b,
        c = "{",
        d = "";
        for (b in a) if (a.hasOwnProperty(b)) {
            if (!b.match(/^[a-z0-9]+$/i)) throw new sjcl.exception.invalid("json encode: invalid property name");
            c += d + b + ":";
            d = ",";
            switch (typeof a[b]) {
            case "number":
            case "boolean":
                c += a[b];
                break;
            case "string":
                c += '"' + escape(a[b]) + '"';
                break;
            case "object":
                c += '"' + sjcl.codec.base64.fromBits(a[b], 1) + '"';
                break;
            default:
                throw new sjcl.exception.bug("json encode: unsupported type");

            }
        }
        return c + "}"
    },
    decode: function(a) {
        a = a.replace(/\s/g, "");
        if (!a.match(/^\{.*\}$/)) throw new sjcl.exception.invalid("json decode: this isn't json!");
        a = a.replace(/^\{|\}$/g, "").split(/,/);
        var b = {},
        c,
        d;
        for (c = 0; c < a.length; c++) {
            if (! (d = a[c].match(/^([a-z][a-z0-9]*):(?:(\d+)|"([a-z0-9+\/%*_.@=\-]*)")$/i))) throw new sjcl.exception.invalid("json decode: this isn't json!");
            b[d[1]] = d[2] ? parseInt(d[2], 10) : d[1].match(/^(ct|salt|iv)$/) ? sjcl.codec.base64.toBits(d[3]) : unescape(d[3])
        }
        return b
    },
    c: function(a, b, c) {
        if (a === 
        undefined) a = {};
        if (b === undefined) return a;
        var d;
        for (d in b) if (b.hasOwnProperty(d)) {
            if (c && a[d] !== undefined && a[d] !== b[d]) throw new sjcl.exception.invalid("required parameter overridden");
            a[d] = b[d]
        }
        return a
    },
    V: function(a, b) {
        var c = {},
        d;
        for (d in a) if (a.hasOwnProperty(d) && a[d] !== b[d]) c[d] = a[d];
        return c
    },
    W: function(a, b) {
        var c = {},
        d;
        for (d = 0; d < b.length; d++) if (a[b[d]] !== undefined) c[b[d]] = a[b[d]];
        return c
    }
};
sjcl.encrypt = sjcl.json.encrypt;
sjcl.decrypt = sjcl.json.decrypt;
sjcl.misc.S = {};
sjcl.misc.cachedPbkdf2 = function(a, b) {
    var c = sjcl.misc.S,
    d;
    b = b || {};
    d = b.iter || 1E3;
    c = c[a] = c[a] || {};
    d = c[d] = c[d] || {
        firstSalt: b.salt && b.salt.length ? b.salt.slice(0) : sjcl.random.randomWords(2, 0)
    };
    c = b.salt === undefined ? d.firstSalt: b.salt;
    d[c] = d[c] || sjcl.misc.pbkdf2(a, c, b.iter);
    return {
        key: d[c].slice(0),
        salt: c.slice(0)
    }
};
var b64map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var b64pad = "=";

function hex2b64(h) {
    var i;
    var c;
    var ret = "";
    for (i = 0; i + 3 <= h.length; i += 3) {
        c = parseInt(h.substring(i, i + 3), 16);
        ret += b64map.charAt(c >> 6) + b64map.charAt(c & 63);

    }
    if (i + 1 == h.length) {
        c = parseInt(h.substring(i, i + 1), 16);
        ret += b64map.charAt(c << 2);

    }
    else if (i + 2 == h.length) {
        c = parseInt(h.substring(i, i + 2), 16);
        ret += b64map.charAt(c >> 2) + b64map.charAt((c & 3) << 4);

    }
    while ((ret.length & 3) > 0) ret += b64pad;
    return ret;

}

// convert a base64 string to hex
function b64tohex(s) {
    var ret = ""
    var i;
    var k = 0;
    // b64 state, 0-3
    var slop;
    for (i = 0; i < s.length; ++i) {
        if (s.charAt(i) == b64pad) break;
        var v = b64map.indexOf(s.charAt(i));
        if (v < 0) continue;
        if (k == 0) {
            ret += int2char(v >> 2);
            slop = v & 3;
            k = 1;

        }
        else if (k == 1) {
            ret += int2char((slop << 2) | (v >> 4));
            slop = v & 0xf;
            k = 2;

        }
        else if (k == 2) {
            ret += int2char(slop);
            ret += int2char(v >> 2);
            slop = v & 3;
            k = 3;

        }
        else {
            ret += int2char((slop << 2) | (v >> 4));
            ret += int2char(v & 0xf);
            k = 0;

        }

    }
    if (k == 1)
    ret += int2char(slop << 2);
    return ret;

}

// convert a base64 string to a byte/number array
function b64toBA(s) {
    //piggyback on b64tohex for now, optimize later
    var h = b64tohex(s);
    var i;
    var a = new Array();
    for (i = 0; 2 * i < h.length; ++i) {
        a[i] = parseInt(h.substring(2 * i, 2 * i + 2), 16);

    }
    return a;

}
// Copyright (c) 2005  Tom Wu
// All Rights Reserved.
// See "LICENSE" for details.

// Basic JavaScript BN library - subset useful for RSA encryption.

// Bits per digit
var dbits;

// JavaScript engine analysis
var canary = 0xdeadbeefcafe;
var j_lm = ((canary & 0xffffff) == 0xefcafe);

// (public) Constructor
function BigInteger(a, b, c) {
    if (a != null)
    if ("number" == typeof a) this.fromNumber(a, b, c);
    else if (b == null && "string" != typeof a) this.fromString(a, 256);
    else this.fromString(a, b);

}

// return new, unset BigInteger
function nbi() {
    return new BigInteger(null);
}

// am: Compute w_j += (x*this_i), propagate carries,
// c is initial carry, returns final carry.
// c < 3*dvalue, x < 2*dvalue, this_i < dvalue
// We need to select the fastest one that works in this environment.

// am1: use a single mult and divide to get the high bits,
// max digit bits should be 26 because
// max internal value = 2*dvalue^2-2*dvalue (< 2^53)
function am1(i, x, w, j, c, n) {
    while (--n >= 0) {
        var v = x * this[i++] + w[j] + c;
        c = Math.floor(v / 0x4000000);
        w[j++] = v & 0x3ffffff;

    }
    return c;

}
// am2 avoids a big mult-and-extract completely.
// Max digit bits should be <= 30 because we do bitwise ops
// on values up to 2*hdvalue^2-hdvalue-1 (< 2^31)
function am2(i, x, w, j, c, n) {
    var xl = x & 0x7fff,
    xh = x >> 15;
    while (--n >= 0) {
        var l = this[i] & 0x7fff;
        var h = this[i++] >> 15;
        var m = xh * l + h * xl;
        l = xl * l + ((m & 0x7fff) << 15) + w[j] + (c & 0x3fffffff);
        c = (l >>> 30) + (m >>> 15) + xh * h + (c >>> 30);
        w[j++] = l & 0x3fffffff;

    }
    return c;

}
// Alternately, set max digit bits to 28 since some
// browsers slow down when dealing with 32-bit numbers.
function am3(i, x, w, j, c, n) {
    var xl = x & 0x3fff,
    xh = x >> 14;
    while (--n >= 0) {
        var l = this[i] & 0x3fff;
        var h = this[i++] >> 14;
        var m = xh * l + h * xl;
        l = xl * l + ((m & 0x3fff) << 14) + w[j] + c;
        c = (l >> 28) + (m >> 14) + xh * h;
        w[j++] = l & 0xfffffff;

    }
    return c;

}
//if(j_lm && (navigator.appName == "Microsoft Internet Explorer")) {
BigInteger.prototype.am = am2;
dbits = 30;
/*}
else if(j_lm && (navigator.appName != "Netscape")) {
  BigInteger.prototype.am = am1;
  dbits = 26;
}
else { // Mozilla/Netscape seems to prefer am3
  BigInteger.prototype.am = am3;
  dbits = 28;
}*/

BigInteger.prototype.DB = dbits;
BigInteger.prototype.DM = ((1 << dbits) - 1);
BigInteger.prototype.DV = (1 << dbits);

var BI_FP = 52;
BigInteger.prototype.FV = Math.pow(2, BI_FP);
BigInteger.prototype.F1 = BI_FP - dbits;
BigInteger.prototype.F2 = 2 * dbits - BI_FP;

// Digit conversions
var BI_RM = "0123456789abcdefghijklmnopqrstuvwxyz";
var BI_RC = new Array();
var rr,
vv;
rr = "0".charCodeAt(0);
for (vv = 0; vv <= 9; ++vv) BI_RC[rr++] = vv;
rr = "a".charCodeAt(0);
for (vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;
rr = "A".charCodeAt(0);
for (vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;

function int2char(n) {
    return BI_RM.charAt(n);
}
function intAt(s, i) {
    var c = BI_RC[s.charCodeAt(i)];
    return (c == null) ? -1: c;

}

// (protected) copy this to r
function bnpCopyTo(r) {
    for (var i = this.t - 1; i >= 0; --i) r[i] = this[i];
    r.t = this.t;
    r.s = this.s;

}

// (protected) set from integer value x, -DV <= x < DV
function bnpFromInt(x) {
    this.t = 1;
    this.s = (x < 0) ? -1: 0;
    if (x > 0) this[0] = x;
    else if (x < -1) this[0] = x + DV;
    else this.t = 0;

}

// return bigint initialized to value
function nbv(i) {
    var r = nbi();
    r.fromInt(i);
    return r;
}

// (protected) set from string and radix
function bnpFromString(s, b) {
    var k;
    if (b == 16) k = 4;
    else if (b == 8) k = 3;
    else if (b == 256) k = 8;
    // byte array
    else if (b == 2) k = 1;
    else if (b == 32) k = 5;
    else if (b == 4) k = 2;
    else {
        this.fromRadix(s, b);
        return;
    }
    this.t = 0;
    this.s = 0;
    var i = s.length,
    mi = false,
    sh = 0;
    while (--i >= 0) {
        var x = (k == 8) ? s[i] & 0xff: intAt(s, i);
        if (x < 0) {
            if (s.charAt(i) == "-") mi = true;
            continue;

        }
        mi = false;
        if (sh == 0)
        this[this.t++] = x;
        else if (sh + k > this.DB) {
            this[this.t - 1] |= (x & ((1 << (this.DB - sh)) - 1)) << sh;
            this[this.t++] = (x >> (this.DB - sh));

        }
        else
        this[this.t - 1] |= x << sh;
        sh += k;
        if (sh >= this.DB) sh -= this.DB;

    }
    if (k == 8 && (s[0] & 0x80) != 0) {
        this.s = -1;
        if (sh > 0) this[this.t - 1] |= ((1 << (this.DB - sh)) - 1) << sh;

    }
    this.clamp();
    if (mi) BigInteger.ZERO.subTo(this, this);

}

// (protected) clamp off excess high words
function bnpClamp() {
    var c = this.s & this.DM;
    while (this.t > 0 && this[this.t - 1] == c)--this.t;

}

// (public) return string representation in given radix
function bnToString(b) {
    if (this.s < 0) return "-" + this.negate().toString(b);
    var k;
    if (b == 16) k = 4;
    else if (b == 8) k = 3;
    else if (b == 2) k = 1;
    else if (b == 32) k = 5;
    else if (b == 4) k = 2;
    else return this.toRadix(b);
    var km = (1 << k) - 1,
    d,
    m = false,
    r = "",
    i = this.t;
    var p = this.DB - (i * this.DB) % k;
    if (i-->0) {
        if (p < this.DB && (d = this[i] >> p) > 0) {
            m = true;
            r = int2char(d);
        }
        while (i >= 0) {
            if (p < k) {
                d = (this[i] & ((1 << p) - 1)) << (k - p);
                d |= this[--i] >> (p += this.DB - k);

            }
            else {
                d = (this[i] >> (p -= k)) & km;
                if (p <= 0) {
                    p += this.DB; --i;
                }

            }
            if (d > 0) m = true;
            if (m) r += int2char(d);

        }

    }
    return m ? r: "0";

}

// (public) -this
function bnNegate() {
    var r = nbi();
    BigInteger.ZERO.subTo(this, r);
    return r;
}

// (public) |this|
function bnAbs() {
    return (this.s < 0) ? this.negate() : this;
}

// (public) return + if this > a, - if this < a, 0 if equal
function bnCompareTo(a) {
    var r = this.s - a.s;
    if (r != 0) return r;
    var i = this.t;
    r = i - a.t;
    if (r != 0) return r;
    while (--i >= 0) if ((r = this[i] - a[i]) != 0) return r;
    return 0;

}

// returns bit length of the integer x
function nbits(x) {
    var r = 1,
    t;
    if ((t = x >>> 16) != 0) {
        x = t;
        r += 16;
    }
    if ((t = x >> 8) != 0) {
        x = t;
        r += 8;
    }
    if ((t = x >> 4) != 0) {
        x = t;
        r += 4;
    }
    if ((t = x >> 2) != 0) {
        x = t;
        r += 2;
    }
    if ((t = x >> 1) != 0) {
        x = t;
        r += 1;
    }
    return r;

}

// (public) return the number of bits in "this"
function bnBitLength() {
    if (this.t <= 0) return 0;
    return this.DB * (this.t - 1) + nbits(this[this.t - 1] ^ (this.s & this.DM));

}

// (protected) r = this << n*DB
function bnpDLShiftTo(n, r) {
    var i;
    for (i = this.t - 1; i >= 0; --i) r[i + n] = this[i];
    for (i = n - 1; i >= 0; --i) r[i] = 0;
    r.t = this.t + n;
    r.s = this.s;

}

// (protected) r = this >> n*DB
function bnpDRShiftTo(n, r) {
    for (var i = n; i < this.t; ++i) r[i - n] = this[i];
    r.t = Math.max(this.t - n, 0);
    r.s = this.s;

}

// (protected) r = this << n
function bnpLShiftTo(n, r) {
    var bs = n % this.DB;
    var cbs = this.DB - bs;
    var bm = (1 << cbs) - 1;
    var ds = Math.floor(n / this.DB),
    c = (this.s << bs) & this.DM,
    i;
    for (i = this.t - 1; i >= 0; --i) {
        r[i + ds + 1] = (this[i] >> cbs) | c;
        c = (this[i] & bm) << bs;

    }
    for (i = ds - 1; i >= 0; --i) r[i] = 0;
    r[ds] = c;
    r.t = this.t + ds + 1;
    r.s = this.s;
    r.clamp();

}

// (protected) r = this >> n
function bnpRShiftTo(n, r) {
    r.s = this.s;
    var ds = Math.floor(n / this.DB);
    if (ds >= this.t) {
        r.t = 0;
        return;
    }
    var bs = n % this.DB;
    var cbs = this.DB - bs;
    var bm = (1 << bs) - 1;
    r[0] = this[ds] >> bs;
    for (var i = ds + 1; i < this.t; ++i) {
        r[i - ds - 1] |= (this[i] & bm) << cbs;
        r[i - ds] = this[i] >> bs;

    }
    if (bs > 0) r[this.t - ds - 1] |= (this.s & bm) << cbs;
    r.t = this.t - ds;
    r.clamp();

}

// (protected) r = this - a
function bnpSubTo(a, r) {
    var i = 0,
    c = 0,
    m = Math.min(a.t, this.t);
    while (i < m) {
        c += this[i] - a[i];
        r[i++] = c & this.DM;
        c >>= this.DB;

    }
    if (a.t < this.t) {
        c -= a.s;
        while (i < this.t) {
            c += this[i];
            r[i++] = c & this.DM;
            c >>= this.DB;

        }
        c += this.s;

    }
    else {
        c += this.s;
        while (i < a.t) {
            c -= a[i];
            r[i++] = c & this.DM;
            c >>= this.DB;

        }
        c -= a.s;

    }
    r.s = (c < 0) ? -1: 0;
    if (c < -1) r[i++] = this.DV + c;
    else if (c > 0) r[i++] = c;
    r.t = i;
    r.clamp();

}

// (protected) r = this * a, r != this,a (HAC 14.12)
// "this" should be the larger one if appropriate.
function bnpMultiplyTo(a, r) {
    var x = this.abs(),
    y = a.abs();
    var i = x.t;
    r.t = i + y.t;
    while (--i >= 0) r[i] = 0;
    for (i = 0; i < y.t; ++i) r[i + x.t] = x.am(0, y[i], r, i, 0, x.t);
    r.s = 0;
    r.clamp();
    if (this.s != a.s) BigInteger.ZERO.subTo(r, r);

}

// (protected) r = this^2, r != this (HAC 14.16)
function bnpSquareTo(r) {
    var x = this.abs();
    var i = r.t = 2 * x.t;
    while (--i >= 0) r[i] = 0;
    for (i = 0; i < x.t - 1; ++i) {
        var c = x.am(i, x[i], r, 2 * i, 0, 1);
        if ((r[i + x.t] += x.am(i + 1, 2 * x[i], r, 2 * i + 1, c, x.t - i - 1)) >= x.DV) {
            r[i + x.t] -= x.DV;
            r[i + x.t + 1] = 1;

        }

    }
    if (r.t > 0) r[r.t - 1] += x.am(i, x[i], r, 2 * i, 0, 1);
    r.s = 0;
    r.clamp();

}

// (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)
// r != q, this != m.  q or r may be null.
function bnpDivRemTo(m, q, r) {
    var pm = m.abs();
    if (pm.t <= 0) return;
    var pt = this.abs();
    if (pt.t < pm.t) {
        if (q != null) q.fromInt(0);
        if (r != null) this.copyTo(r);
        return;

    }
    if (r == null) r = nbi();
    var y = nbi(),
    ts = this.s,
    ms = m.s;
    var nsh = this.DB - nbits(pm[pm.t - 1]);
    // normalize modulus
    if (nsh > 0) {
        pm.lShiftTo(nsh, y);
        pt.lShiftTo(nsh, r);
    }
    else {
        pm.copyTo(y);
        pt.copyTo(r);
    }
    var ys = y.t;
    var y0 = y[ys - 1];
    if (y0 == 0) return;
    var yt = y0 * (1 << this.F1) + ((ys > 1) ? y[ys - 2] >> this.F2: 0);
    var d1 = this.FV / yt,
    d2 = (1 << this.F1) / yt,
    e = 1 << this.F2;
    var i = r.t,
    j = i - ys,
    t = (q == null) ? nbi() : q;
    y.dlShiftTo(j, t);
    if (r.compareTo(t) >= 0) {
        r[r.t++] = 1;
        r.subTo(t, r);

    }
    BigInteger.ONE.dlShiftTo(ys, t);
    t.subTo(y, y);
    // "negative" y so we can replace sub with am later
    while (y.t < ys) y[y.t++] = 0;
    while (--j >= 0) {
        // Estimate quotient digit
        var qd = (r[--i] == y0) ? this.DM: Math.floor(r[i] * d1 + (r[i - 1] + e) * d2);
        if ((r[i] += y.am(0, qd, r, j, 0, ys)) < qd) {
            // Try it out
            y.dlShiftTo(j, t);
            r.subTo(t, r);
            while (r[i] < --qd) r.subTo(t, r);

        }

    }
    if (q != null) {
        r.drShiftTo(ys, q);
        if (ts != ms) BigInteger.ZERO.subTo(q, q);

    }
    r.t = ys;
    r.clamp();
    if (nsh > 0) r.rShiftTo(nsh, r);
    // Denormalize remainder
    if (ts < 0) BigInteger.ZERO.subTo(r, r);

}

// (public) this mod a
function bnMod(a) {
    var r = nbi();
    this.abs().divRemTo(a, null, r);
    if (this.s < 0 && r.compareTo(BigInteger.ZERO) > 0) a.subTo(r, r);
    return r;

}

// Modular reduction using "classic" algorithm
function Classic(m) {
    this.m = m;
}
function cConvert(x) {
    if (x.s < 0 || x.compareTo(this.m) >= 0) return x.mod(this.m);
    else return x;

}
function cRevert(x) {
    return x;
}
function cReduce(x) {
    x.divRemTo(this.m, null, x);
}
function cMulTo(x, y, r) {
    x.multiplyTo(y, r);
    this.reduce(r);
}
function cSqrTo(x, r) {
    x.squareTo(r);
    this.reduce(r);
}

Classic.prototype.convert = cConvert;
Classic.prototype.revert = cRevert;
Classic.prototype.reduce = cReduce;
Classic.prototype.mulTo = cMulTo;
Classic.prototype.sqrTo = cSqrTo;

// (protected) return "-1/this % 2^DB"; useful for Mont. reduction
// justification:
//         xy == 1 (mod m)
//         xy =  1+km
//   xy(2-xy) = (1+km)(1-km)
// x[y(2-xy)] = 1-k^2m^2
// x[y(2-xy)] == 1 (mod m^2)
// if y is 1/x mod m, then y(2-xy) is 1/x mod m^2
// should reduce x and y(2-xy) by m^2 at each step to keep size bounded.
// JS multiply "overflows" differently from C/C++, so care is needed here.
function bnpInvDigit() {
    if (this.t < 1) return 0;
    var x = this[0];
    if ((x & 1) == 0) return 0;
    var y = x & 3;
    // y == 1/x mod 2^2
    y = (y * (2 - (x & 0xf) * y)) & 0xf;
    // y == 1/x mod 2^4
    y = (y * (2 - (x & 0xff) * y)) & 0xff;
    // y == 1/x mod 2^8
    y = (y * (2 - (((x & 0xffff) * y) & 0xffff))) & 0xffff;
    // y == 1/x mod 2^16
    // last step - calculate inverse mod DV directly;
    // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints
    y = (y * (2 - x * y % this.DV)) % this.DV;
    // y == 1/x mod 2^dbits
    // we really want the negative inverse, and -DV < y < DV
    return (y > 0) ? this.DV - y: -y;

}

// Montgomery reduction
function Montgomery(m) {
    this.m = m;
    this.mp = m.invDigit();
    this.mpl = this.mp & 0x7fff;
    this.mph = this.mp >> 15;
    this.um = (1 << (m.DB - 15)) - 1;
    this.mt2 = 2 * m.t;

}

// xR mod m
function montConvert(x) {
    var r = nbi();
    x.abs().dlShiftTo(this.m.t, r);
    r.divRemTo(this.m, null, r);
    if (x.s < 0 && r.compareTo(BigInteger.ZERO) > 0) this.m.subTo(r, r);
    return r;

}

// x/R mod m
function montRevert(x) {
    var r = nbi();
    x.copyTo(r);
    this.reduce(r);
    return r;

}

// x = x/R mod m (HAC 14.32)
function montReduce(x) {
    while (x.t <= this.mt2)
    // pad x so am has enough room later
    x[x.t++] = 0;
    for (var i = 0; i < this.m.t; ++i) {
        // faster way of calculating u0 = x[i]*mp mod DV
        var j = x[i] & 0x7fff;
        var u0 = (j * this.mpl + (((j * this.mph + (x[i] >> 15) * this.mpl) & this.um) << 15)) & x.DM;
        // use am to combine the multiply-shift-add into one call
        j = i + this.m.t;
        x[j] += this.m.am(0, u0, x, i, 0, this.m.t);
        // propagate carry
        while (x[j] >= x.DV) {
            x[j] -= x.DV;
            x[++j]++;
        }

    }
    x.clamp();
    x.drShiftTo(this.m.t, x);
    if (x.compareTo(this.m) >= 0) x.subTo(this.m, x);

}

// r = "x^2/R mod m"; x != r
function montSqrTo(x, r) {
    x.squareTo(r);
    this.reduce(r);
}

// r = "xy/R mod m"; x,y != r
function montMulTo(x, y, r) {
    x.multiplyTo(y, r);
    this.reduce(r);
}

Montgomery.prototype.convert = montConvert;
Montgomery.prototype.revert = montRevert;
Montgomery.prototype.reduce = montReduce;
Montgomery.prototype.mulTo = montMulTo;
Montgomery.prototype.sqrTo = montSqrTo;

// (protected) true iff this is even
function bnpIsEven() {
    return ((this.t > 0) ? (this[0] & 1) : this.s) == 0;
}

// (protected) this^e, e < 2^32, doing sqr and mul with "r" (HAC 14.79)
function bnpExp(e, z) {
    if (e > 0xffffffff || e < 1) return BigInteger.ONE;
    var r = nbi(),
    r2 = nbi(),
    g = z.convert(this),
    i = nbits(e) - 1;
    g.copyTo(r);
    while (--i >= 0) {
        z.sqrTo(r, r2);
        if ((e & (1 << i)) > 0) z.mulTo(r2, g, r);
        else {
            var t = r;
            r = r2;
            r2 = t;
        }

    }
    return z.revert(r);

}

// (public) this^e % m, 0 <= e < 2^32
function bnModPowInt(e, m) {
    var z;
    if (e < 256 || m.isEven()) z = new Classic(m);
    else z = new Montgomery(m);
    return this.exp(e, z);

}

// protected
BigInteger.prototype.copyTo = bnpCopyTo;
BigInteger.prototype.fromInt = bnpFromInt;
BigInteger.prototype.fromString = bnpFromString;
BigInteger.prototype.clamp = bnpClamp;
BigInteger.prototype.dlShiftTo = bnpDLShiftTo;
BigInteger.prototype.drShiftTo = bnpDRShiftTo;
BigInteger.prototype.lShiftTo = bnpLShiftTo;
BigInteger.prototype.rShiftTo = bnpRShiftTo;
BigInteger.prototype.subTo = bnpSubTo;
BigInteger.prototype.multiplyTo = bnpMultiplyTo;
BigInteger.prototype.squareTo = bnpSquareTo;
BigInteger.prototype.divRemTo = bnpDivRemTo;
BigInteger.prototype.invDigit = bnpInvDigit;
BigInteger.prototype.isEven = bnpIsEven;
BigInteger.prototype.exp = bnpExp;

// public
BigInteger.prototype.toString = bnToString;
BigInteger.prototype.negate = bnNegate;
BigInteger.prototype.abs = bnAbs;
BigInteger.prototype.compareTo = bnCompareTo;
BigInteger.prototype.bitLength = bnBitLength;
BigInteger.prototype.mod = bnMod;
BigInteger.prototype.modPowInt = bnModPowInt;

// "constants"
BigInteger.ZERO = nbv(0);
BigInteger.ONE = nbv(1);
// Copyright (c) 2005-2009  Tom Wu
// All Rights Reserved.
// See "LICENSE" for details.

// Extended JavaScript BN functions, required for RSA private ops.

// Version 1.1: new BigInteger("0", 10) returns "proper" zero

// (public)
function bnClone() {
    var r = nbi();
    this.copyTo(r);
    return r;
}

// (public) return value as integer
function bnIntValue() {
    if (this.s < 0) {
        if (this.t == 1) return this[0] - this.DV;
        else if (this.t == 0) return - 1;

    }
    else if (this.t == 1) return this[0];
    else if (this.t == 0) return 0;
    // assumes 16 < DB < 32
    return ((this[1] & ((1 << (32 - this.DB)) - 1)) << this.DB) | this[0];

}

// (public) return value as byte
function bnByteValue() {
    return (this.t == 0) ? this.s: (this[0] << 24) >> 24;
}

// (public) return value as short (assumes DB>=16)
function bnShortValue() {
    return (this.t == 0) ? this.s: (this[0] << 16) >> 16;
}

// (protected) return x s.t. r^x < DV
function bnpChunkSize(r) {
    return Math.floor(Math.LN2 * this.DB / Math.log(r));
}

// (public) 0 if this == 0, 1 if this > 0
function bnSigNum() {
    if (this.s < 0) return - 1;
    else if (this.t <= 0 || (this.t == 1 && this[0] <= 0)) return 0;
    else return 1;

}

// (protected) convert to radix string
function bnpToRadix(b) {
    if (b == null) b = 10;
    if (this.signum() == 0 || b < 2 || b > 36) return "0";
    var cs = this.chunkSize(b);
    var a = Math.pow(b, cs);
    var d = nbv(a),
    y = nbi(),
    z = nbi(),
    r = "";
    this.divRemTo(d, y, z);
    while (y.signum() > 0) {
        r = (a + z.intValue()).toString(b).substr(1) + r;
        y.divRemTo(d, y, z);

    }
    return z.intValue().toString(b) + r;

}

// (protected) convert from radix string
function bnpFromRadix(s, b) {
    this.fromInt(0);
    if (b == null) b = 10;
    var cs = this.chunkSize(b);
    var d = Math.pow(b, cs),
    mi = false,
    j = 0,
    w = 0;
    for (var i = 0; i < s.length; ++i) {
        var x = intAt(s, i);
        if (x < 0) {
            if (s.charAt(i) == "-" && this.signum() == 0) mi = true;
            continue;

        }
        w = b * w + x;
        if (++j >= cs) {
            this.dMultiply(d);
            this.dAddOffset(w, 0);
            j = 0;
            w = 0;

        }

    }
    if (j > 0) {
        this.dMultiply(Math.pow(b, j));
        this.dAddOffset(w, 0);

    }
    if (mi) BigInteger.ZERO.subTo(this, this);

}

// (protected) alternate constructor
function bnpFromNumber(a, b, c) {
    if ("number" == typeof b) {
        // new BigInteger(int,int,RNG)
        if (a < 2) this.fromInt(1);
        else {
            this.fromNumber(a, c);
            if (!this.testBit(a - 1))
            // force MSB set
            this.bitwiseTo(BigInteger.ONE.shiftLeft(a - 1), op_or, this);
            if (this.isEven()) this.dAddOffset(1, 0);
            // force odd
            while (!this.isProbablePrime(b)) {
                this.dAddOffset(2, 0);
                if (this.bitLength() > a) this.subTo(BigInteger.ONE.shiftLeft(a - 1), this);

            }

        }

    }
    else {
        // new BigInteger(int,RNG)
        var x = new Array(),
        t = a & 7;
        x.length = (a >> 3) + 1;
        b.nextBytes(x);
        if (t > 0) x[0] &= ((1 << t) - 1);
        else x[0] = 0;
        this.fromString(x, 256);

    }

}

// (public) convert to bigendian byte array
function bnToByteArray() {
    var i = this.t,
    r = new Array();
    r[0] = this.s;
    var p = this.DB - (i * this.DB) % 8,
    d,
    k = 0;
    if (i-->0) {
        if (p < this.DB && (d = this[i] >> p) != (this.s & this.DM) >> p)
        r[k++] = d | (this.s << (this.DB - p));
        while (i >= 0) {
            if (p < 8) {
                d = (this[i] & ((1 << p) - 1)) << (8 - p);
                d |= this[--i] >> (p += this.DB - 8);

            }
            else {
                d = (this[i] >> (p -= 8)) & 0xff;
                if (p <= 0) {
                    p += this.DB; --i;
                }

            }
            if ((d & 0x80) != 0) d |= -256;
            if (k == 0 && (this.s & 0x80) != (d & 0x80))++k;
            if (k > 0 || d != this.s) r[k++] = d;

        }

    }
    return r;

}

function bnEquals(a) {
    return (this.compareTo(a) == 0);
}
function bnMin(a) {
    return (this.compareTo(a) < 0) ? this: a;
}
function bnMax(a) {
    return (this.compareTo(a) > 0) ? this: a;
}

// (protected) r = this op a (bitwise)
function bnpBitwiseTo(a, op, r) {
    var i,
    f,
    m = Math.min(a.t, this.t);
    for (i = 0; i < m; ++i) r[i] = op(this[i], a[i]);
    if (a.t < this.t) {
        f = a.s & this.DM;
        for (i = m; i < this.t; ++i) r[i] = op(this[i], f);
        r.t = this.t;

    }
    else {
        f = this.s & this.DM;
        for (i = m; i < a.t; ++i) r[i] = op(f, a[i]);
        r.t = a.t;

    }
    r.s = op(this.s, a.s);
    r.clamp();

}

// (public) this & a
function op_and(x, y) {
    return x & y;
}
function bnAnd(a) {
    var r = nbi();
    this.bitwiseTo(a, op_and, r);
    return r;
}

// (public) this | a
function op_or(x, y) {
    return x | y;
}
function bnOr(a) {
    var r = nbi();
    this.bitwiseTo(a, op_or, r);
    return r;
}

// (public) this ^ a
function op_xor(x, y) {
    return x ^ y;
}
function bnXor(a) {
    var r = nbi();
    this.bitwiseTo(a, op_xor, r);
    return r;
}

// (public) this & ~a
function op_andnot(x, y) {
    return x & ~y;
}
function bnAndNot(a) {
    var r = nbi();
    this.bitwiseTo(a, op_andnot, r);
    return r;
}

// (public) ~this
function bnNot() {
    var r = nbi();
    for (var i = 0; i < this.t; ++i) r[i] = this.DM & ~this[i];
    r.t = this.t;
    r.s = ~this.s;
    return r;

}

// (public) this << n
function bnShiftLeft(n) {
    var r = nbi();
    if (n < 0) this.rShiftTo( - n, r);
    else this.lShiftTo(n, r);
    return r;

}

// (public) this >> n
function bnShiftRight(n) {
    var r = nbi();
    if (n < 0) this.lShiftTo( - n, r);
    else this.rShiftTo(n, r);
    return r;

}

// return index of lowest 1-bit in x, x < 2^31
function lbit(x) {
    if (x == 0) return - 1;
    var r = 0;
    if ((x & 0xffff) == 0) {
        x >>= 16;
        r += 16;
    }
    if ((x & 0xff) == 0) {
        x >>= 8;
        r += 8;
    }
    if ((x & 0xf) == 0) {
        x >>= 4;
        r += 4;
    }
    if ((x & 3) == 0) {
        x >>= 2;
        r += 2;
    }
    if ((x & 1) == 0)++r;
    return r;

}

// (public) returns index of lowest 1-bit (or -1 if none)
function bnGetLowestSetBit() {
    for (var i = 0; i < this.t; ++i)
    if (this[i] != 0) return i * this.DB + lbit(this[i]);
    if (this.s < 0) return this.t * this.DB;
    return - 1;

}

// return number of 1 bits in x
function cbit(x) {
    var r = 0;
    while (x != 0) {
        x &= x - 1; ++r;
    }
    return r;

}

// (public) return number of set bits
function bnBitCount() {
    var r = 0,
    x = this.s & this.DM;
    for (var i = 0; i < this.t; ++i) r += cbit(this[i] ^ x);
    return r;

}

// (public) true iff nth bit is set
function bnTestBit(n) {
    var j = Math.floor(n / this.DB);
    if (j >= this.t) return (this.s != 0);
    return ((this[j] & (1 << (n % this.DB))) != 0);

}

// (protected) this op (1<<n)
function bnpChangeBit(n, op) {
    var r = BigInteger.ONE.shiftLeft(n);
    this.bitwiseTo(r, op, r);
    return r;

}

// (public) this | (1<<n)
function bnSetBit(n) {
    return this.changeBit(n, op_or);
}

// (public) this & ~(1<<n)
function bnClearBit(n) {
    return this.changeBit(n, op_andnot);
}

// (public) this ^ (1<<n)
function bnFlipBit(n) {
    return this.changeBit(n, op_xor);
}

// (protected) r = this + a
function bnpAddTo(a, r) {
    var i = 0,
    c = 0,
    m = Math.min(a.t, this.t);
    while (i < m) {
        c += this[i] + a[i];
        r[i++] = c & this.DM;
        c >>= this.DB;

    }
    if (a.t < this.t) {
        c += a.s;
        while (i < this.t) {
            c += this[i];
            r[i++] = c & this.DM;
            c >>= this.DB;

        }
        c += this.s;

    }
    else {
        c += this.s;
        while (i < a.t) {
            c += a[i];
            r[i++] = c & this.DM;
            c >>= this.DB;

        }
        c += a.s;

    }
    r.s = (c < 0) ? -1: 0;
    if (c > 0) r[i++] = c;
    else if (c < -1) r[i++] = this.DV + c;
    r.t = i;
    r.clamp();

}

// (public) this + a
function bnAdd(a) {
    var r = nbi();
    this.addTo(a, r);
    return r;
}

// (public) this - a
function bnSubtract(a) {
    var r = nbi();
    this.subTo(a, r);
    return r;
}

// (public) this * a
function bnMultiply(a) {
    var r = nbi();
    this.multiplyTo(a, r);
    return r;
}

// (public) this / a
function bnDivide(a) {
    var r = nbi();
    this.divRemTo(a, r, null);
    return r;
}

// (public) this % a
function bnRemainder(a) {
    var r = nbi();
    this.divRemTo(a, null, r);
    return r;
}

// (public) [this/a,this%a]
function bnDivideAndRemainder(a) {
    var q = nbi(),
    r = nbi();
    this.divRemTo(a, q, r);
    return new Array(q, r);

}

// (protected) this *= n, this >= 0, 1 < n < DV
function bnpDMultiply(n) {
    this[this.t] = this.am(0, n - 1, this, 0, 0, this.t);
    ++this.t;
    this.clamp();

}

// (protected) this += n << w words, this >= 0
function bnpDAddOffset(n, w) {
    if (n == 0) return;
    while (this.t <= w) this[this.t++] = 0;
    this[w] += n;
    while (this[w] >= this.DV) {
        this[w] -= this.DV;
        if (++w >= this.t) this[this.t++] = 0;
        ++this[w];

    }

}

// A "null" reducer
function NullExp() {}
function nNop(x) {
    return x;
}
function nMulTo(x, y, r) {
    x.multiplyTo(y, r);
}
function nSqrTo(x, r) {
    x.squareTo(r);
}

NullExp.prototype.convert = nNop;
NullExp.prototype.revert = nNop;
NullExp.prototype.mulTo = nMulTo;
NullExp.prototype.sqrTo = nSqrTo;

// (public) this^e
function bnPow(e) {
    return this.exp(e, new NullExp());
}

// (protected) r = lower n words of "this * a", a.t <= n
// "this" should be the larger one if appropriate.
function bnpMultiplyLowerTo(a, n, r) {
    var i = Math.min(this.t + a.t, n);
    r.s = 0;
    // assumes a,this >= 0
    r.t = i;
    while (i > 0) r[--i] = 0;
    var j;
    for (j = r.t - this.t; i < j; ++i) r[i + this.t] = this.am(0, a[i], r, i, 0, this.t);
    for (j = Math.min(a.t, n); i < j; ++i) this.am(0, a[i], r, i, 0, n - i);
    r.clamp();

}

// (protected) r = "this * a" without lower n words, n > 0
// "this" should be the larger one if appropriate.
function bnpMultiplyUpperTo(a, n, r) {
    --n;
    var i = r.t = this.t + a.t - n;
    r.s = 0;
    // assumes a,this >= 0
    while (--i >= 0) r[i] = 0;
    for (i = Math.max(n - this.t, 0); i < a.t; ++i)
    r[this.t + i - n] = this.am(n - i, a[i], r, 0, 0, this.t + i - n);
    r.clamp();
    r.drShiftTo(1, r);

}

// Barrett modular reduction
function Barrett(m) {
    // setup Barrett
    this.r2 = nbi();
    this.q3 = nbi();
    BigInteger.ONE.dlShiftTo(2 * m.t, this.r2);
    this.mu = this.r2.divide(m);
    this.m = m;

}

function barrettConvert(x) {
    if (x.s < 0 || x.t > 2 * this.m.t) return x.mod(this.m);
    else if (x.compareTo(this.m) < 0) return x;
    else {
        var r = nbi();
        x.copyTo(r);
        this.reduce(r);
        return r;
    }

}

function barrettRevert(x) {
    return x;
}

// x = x mod m (HAC 14.42)
function barrettReduce(x) {
    x.drShiftTo(this.m.t - 1, this.r2);
    if (x.t > this.m.t + 1) {
        x.t = this.m.t + 1;
        x.clamp();
    }
    this.mu.multiplyUpperTo(this.r2, this.m.t + 1, this.q3);
    this.m.multiplyLowerTo(this.q3, this.m.t + 1, this.r2);
    while (x.compareTo(this.r2) < 0) x.dAddOffset(1, this.m.t + 1);
    x.subTo(this.r2, x);
    while (x.compareTo(this.m) >= 0) x.subTo(this.m, x);

}

// r = x^2 mod m; x != r
function barrettSqrTo(x, r) {
    x.squareTo(r);
    this.reduce(r);
}

// r = x*y mod m; x,y != r
function barrettMulTo(x, y, r) {
    x.multiplyTo(y, r);
    this.reduce(r);
}

Barrett.prototype.convert = barrettConvert;
Barrett.prototype.revert = barrettRevert;
Barrett.prototype.reduce = barrettReduce;
Barrett.prototype.mulTo = barrettMulTo;
Barrett.prototype.sqrTo = barrettSqrTo;

// (public) this^e % m (HAC 14.85)
function bnModPow(e, m) {
    var i = e.bitLength(),
    k,
    r = nbv(1),
    z;
    if (i <= 0) return r;
    else if (i < 18) k = 1;
    else if (i < 48) k = 3;
    else if (i < 144) k = 4;
    else if (i < 768) k = 5;
    else k = 6;
    if (i < 8)
    z = new Classic(m);
    else if (m.isEven())
    z = new Barrett(m);
    else
    z = new Montgomery(m);

    // precomputation
    var g = new Array(),
    n = 3,
    k1 = k - 1,
    km = (1 << k) - 1;
    g[1] = z.convert(this);
    if (k > 1) {
        var g2 = nbi();
        z.sqrTo(g[1], g2);
        while (n <= km) {
            g[n] = nbi();
            z.mulTo(g2, g[n - 2], g[n]);
            n += 2;

        }

    }

    var j = e.t - 1,
    w,
    is1 = true,
    r2 = nbi(),
    t;
    i = nbits(e[j]) - 1;
    while (j >= 0) {
        if (i >= k1) w = (e[j] >> (i - k1)) & km;
        else {
            w = (e[j] & ((1 << (i + 1)) - 1)) << (k1 - i);
            if (j > 0) w |= e[j - 1] >> (this.DB + i - k1);

        }

        n = k;
        while ((w & 1) == 0) {
            w >>= 1; --n;
        }
        if ((i -= n) < 0) {
            i += this.DB; --j;
        }
        if (is1) {
            // ret == 1, don't bother squaring or multiplying it
            g[w].copyTo(r);
            is1 = false;

        }
        else {
            while (n > 1) {
                z.sqrTo(r, r2);
                z.sqrTo(r2, r);
                n -= 2;
            }
            if (n > 0) z.sqrTo(r, r2);
            else {
                t = r;
                r = r2;
                r2 = t;
            }
            z.mulTo(r2, g[w], r);

        }

        while (j >= 0 && (e[j] & (1 << i)) == 0) {
            z.sqrTo(r, r2);
            t = r;
            r = r2;
            r2 = t;
            if (--i < 0) {
                i = this.DB - 1; --j;
            }

        }

    }
    return z.revert(r);

}

// (public) gcd(this,a) (HAC 14.54)
function bnGCD(a) {
    var x = (this.s < 0) ? this.negate() : this.clone();
    var y = (a.s < 0) ? a.negate() : a.clone();
    if (x.compareTo(y) < 0) {
        var t = x;
        x = y;
        y = t;
    }
    var i = x.getLowestSetBit(),
    g = y.getLowestSetBit();
    if (g < 0) return x;
    if (i < g) g = i;
    if (g > 0) {
        x.rShiftTo(g, x);
        y.rShiftTo(g, y);

    }
    while (x.signum() > 0) {
        if ((i = x.getLowestSetBit()) > 0) x.rShiftTo(i, x);
        if ((i = y.getLowestSetBit()) > 0) y.rShiftTo(i, y);
        if (x.compareTo(y) >= 0) {
            x.subTo(y, x);
            x.rShiftTo(1, x);

        }
        else {
            y.subTo(x, y);
            y.rShiftTo(1, y);

        }

    }
    if (g > 0) y.lShiftTo(g, y);
    return y;

}

// (protected) this % n, n < 2^26
function bnpModInt(n) {
    if (n <= 0) return 0;
    var d = this.DV % n,
    r = (this.s < 0) ? n - 1: 0;
    if (this.t > 0)
    if (d == 0) r = this[0] % n;
    else for (var i = this.t - 1; i >= 0; --i) r = (d * r + this[i]) % n;
    return r;

}

// (public) 1/this % m (HAC 14.61)
function bnModInverse(m) {
    var ac = m.isEven();
    if ((this.isEven() && ac) || m.signum() == 0) return BigInteger.ZERO;
    var u = m.clone(),
    v = this.clone();
    var a = nbv(1),
    b = nbv(0),
    c = nbv(0),
    d = nbv(1);
    while (u.signum() != 0) {
        while (u.isEven()) {
            u.rShiftTo(1, u);
            if (ac) {
                if (!a.isEven() || !b.isEven()) {
                    a.addTo(this, a);
                    b.subTo(m, b);
                }
                a.rShiftTo(1, a);

            }
            else if (!b.isEven()) b.subTo(m, b);
            b.rShiftTo(1, b);

        }
        while (v.isEven()) {
            v.rShiftTo(1, v);
            if (ac) {
                if (!c.isEven() || !d.isEven()) {
                    c.addTo(this, c);
                    d.subTo(m, d);
                }
                c.rShiftTo(1, c);

            }
            else if (!d.isEven()) d.subTo(m, d);
            d.rShiftTo(1, d);

        }
        if (u.compareTo(v) >= 0) {
            u.subTo(v, u);
            if (ac) a.subTo(c, a);
            b.subTo(d, b);

        }
        else {
            v.subTo(u, v);
            if (ac) c.subTo(a, c);
            d.subTo(b, d);

        }

    }
    if (v.compareTo(BigInteger.ONE) != 0) return BigInteger.ZERO;
    if (d.compareTo(m) >= 0) return d.subtract(m);
    if (d.signum() < 0) d.addTo(m, d);
    else return d;
    if (d.signum() < 0) return d.add(m);
    else return d;

}

var lowprimes = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509];
var lplim = (1 << 26) / lowprimes[lowprimes.length - 1];

// (public) test primality with certainty >= 1-.5^t
function bnIsProbablePrime(t) {
    var i,
    x = this.abs();
    if (x.t == 1 && x[0] <= lowprimes[lowprimes.length - 1]) {
        for (i = 0; i < lowprimes.length; ++i)
        if (x[0] == lowprimes[i]) return true;
        return false;

    }
    if (x.isEven()) return false;
    i = 1;
    while (i < lowprimes.length) {
        var m = lowprimes[i],
        j = i + 1;
        while (j < lowprimes.length && m < lplim) m *= lowprimes[j++];
        m = x.modInt(m);
        while (i < j) if (m % lowprimes[i++] == 0) return false;

    }
    return x.millerRabin(t);

}

// (protected) true if probably prime (HAC 4.24, Miller-Rabin)
function bnpMillerRabin(t) {
    var n1 = this.subtract(BigInteger.ONE);
    var k = n1.getLowestSetBit();
    if (k <= 0) return false;
    var r = n1.shiftRight(k);
    t = (t + 1) >> 1;
    if (t > lowprimes.length) t = lowprimes.length;
    var a = nbi();
    for (var i = 0; i < t; ++i) {
        a.fromInt(lowprimes[i]);
        var y = a.modPow(r, this);
        if (y.compareTo(BigInteger.ONE) != 0 && y.compareTo(n1) != 0) {
            var j = 1;
            while (j++<k && y.compareTo(n1) != 0) {
                y = y.modPowInt(2, this);
                if (y.compareTo(BigInteger.ONE) == 0) return false;

            }
            if (y.compareTo(n1) != 0) return false;

        }

    }
    return true;

}

// protected
BigInteger.prototype.chunkSize = bnpChunkSize;
BigInteger.prototype.toRadix = bnpToRadix;
BigInteger.prototype.fromRadix = bnpFromRadix;
BigInteger.prototype.fromNumber = bnpFromNumber;
BigInteger.prototype.bitwiseTo = bnpBitwiseTo;
BigInteger.prototype.changeBit = bnpChangeBit;
BigInteger.prototype.addTo = bnpAddTo;
BigInteger.prototype.dMultiply = bnpDMultiply;
BigInteger.prototype.dAddOffset = bnpDAddOffset;
BigInteger.prototype.multiplyLowerTo = bnpMultiplyLowerTo;
BigInteger.prototype.multiplyUpperTo = bnpMultiplyUpperTo;
BigInteger.prototype.modInt = bnpModInt;
BigInteger.prototype.millerRabin = bnpMillerRabin;

// public
BigInteger.prototype.clone = bnClone;
BigInteger.prototype.intValue = bnIntValue;
BigInteger.prototype.byteValue = bnByteValue;
BigInteger.prototype.shortValue = bnShortValue;
BigInteger.prototype.signum = bnSigNum;
BigInteger.prototype.toByteArray = bnToByteArray;
BigInteger.prototype.equals = bnEquals;
BigInteger.prototype.min = bnMin;
BigInteger.prototype.max = bnMax;
BigInteger.prototype.and = bnAnd;
BigInteger.prototype.or = bnOr;
BigInteger.prototype.xor = bnXor;
BigInteger.prototype.andNot = bnAndNot;
BigInteger.prototype.not = bnNot;
BigInteger.prototype.shiftLeft = bnShiftLeft;
BigInteger.prototype.shiftRight = bnShiftRight;
BigInteger.prototype.getLowestSetBit = bnGetLowestSetBit;
BigInteger.prototype.bitCount = bnBitCount;
BigInteger.prototype.testBit = bnTestBit;
BigInteger.prototype.setBit = bnSetBit;
BigInteger.prototype.clearBit = bnClearBit;
BigInteger.prototype.flipBit = bnFlipBit;
BigInteger.prototype.add = bnAdd;
BigInteger.prototype.subtract = bnSubtract;
BigInteger.prototype.multiply = bnMultiply;
BigInteger.prototype.divide = bnDivide;
BigInteger.prototype.remainder = bnRemainder;
BigInteger.prototype.divideAndRemainder = bnDivideAndRemainder;
BigInteger.prototype.modPow = bnModPow;
BigInteger.prototype.modInverse = bnModInverse;
BigInteger.prototype.pow = bnPow;
BigInteger.prototype.gcd = bnGCD;
BigInteger.prototype.isProbablePrime = bnIsProbablePrime;

// BigInteger interfaces not implemented in jsbn:

// BigInteger(int signum, byte[] magnitude)
// double doubleValue()
// float floatValue()
// int hashCode()
// long longValue()
// static BigInteger valueOf(long val)
// Depends on jsbn.js and rng.js

// Version 1.1: support utf-8 encoding in pkcs1pad2

// convert a (hex) string to a bignum object
function parseBigInt(str, r) {
    return new BigInteger(str, r);

}

function linebrk(s, n) {
    var ret = "";
    var i = 0;
    while (i + n < s.length) {
        ret += s.substring(i, i + n) + "\n";
        i += n;

    }
    return ret + s.substring(i, s.length);

}

function byte2Hex(b) {
    if (b < 0x10)
    return "0" + b.toString(16);
    else
    return b.toString(16);

}

// PKCS#1 (type 2, random) pad input string s to n bytes, and return a bigint
function pkcs1pad2(s, n) {
    if (n < s.length + 11) {
        // TODO: fix for utf-8
        throw Error("Message too long for RSA");
        return null;

    }
    var ba = new Array();
    var i = s.length - 1;
    while (i >= 0 && n > 0) {
        var c = s.charCodeAt(i--);
        if (c < 128) {
            // encode using utf-8
            ba[--n] = c;

        }
        else if ((c > 127) && (c < 2048)) {
            ba[--n] = (c & 63) | 128;
            ba[--n] = (c >> 6) | 192;

        }
        else {
            ba[--n] = (c & 63) | 128;
            ba[--n] = ((c >> 6) & 63) | 128;
            ba[--n] = (c >> 12) | 224;

        }

    }
    ba[--n] = 0;
    var rng = new SecureRandom();
    var x = new Array();
    while (n > 2) {
        // random non-zero pad
        x[0] = 0;
        while (x[0] == 0) rng.nextBytes(x);
        ba[--n] = x[0];

    }
    ba[--n] = 2;
    ba[--n] = 0;
    return new BigInteger(ba);

}

// "empty" RSA key constructor
function RSAKey() {
    this.n = null;
    this.e = 0;
    this.d = null;
    this.p = null;
    this.q = null;
    this.dmp1 = null;
    this.dmq1 = null;
    this.coeff = null;

}

// Set the public key fields N and e from hex strings
function RSASetPublic(N, E) {
    if (N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N, 16);
        this.e = parseInt(E, 16);

    }
    else
    throw Error("Invalid RSA public key");

}

// Perform raw public operation on "x": return x^e (mod n)
function RSADoPublic(x) {
    return x.modPowInt(this.e, this.n);

}

// Return the PKCS#1 RSA encryption of "text" as an even-length hex string
function RSAEncrypt(text) {
    var m = pkcs1pad2(text, (this.n.bitLength() + 7) >> 3);
    if (m == null) return null;
    var c = this.doPublic(m);
    if (c == null) return null;
    var h = c.toString(16);
    if ((h.length & 1) == 0) return h;
    else return "0" + h;

}

// Return the PKCS#1 RSA encryption of "text" as a Base64-encoded string
//function RSAEncryptB64(text) {
//  var h = this.encrypt(text);
//  if(h) return hex2b64(h); else return null;
//}

// protected
RSAKey.prototype.doPublic = RSADoPublic;

// public
RSAKey.prototype.setPublic = RSASetPublic;
RSAKey.prototype.encrypt = RSAEncrypt;
//RSAKey.prototype.encrypt_b64 = RSAEncryptB64;
// Depends on rsa.js and jsbn2.js

// Version 1.1: support utf-8 decoding in pkcs1unpad2

// Undo PKCS#1 (type 2, random) padding and, if valid, return the plaintext
function pkcs1unpad2(d, n) {
    var b = d.toByteArray();
    var i = 0;
    while (i < b.length && b[i] == 0)++i;
    if (b.length - i != n - 1 || b[i] != 2)
    return null;
    ++i;
    while (b[i] != 0)
    if (++i >= b.length) return null;
    var ret = "";
    while (++i < b.length) {
        var c = b[i] & 255;
        if (c < 128) {
            // utf-8 decode
            ret += String.fromCharCode(c);

        }
        else if ((c > 191) && (c < 224)) {
            ret += String.fromCharCode(((c & 31) << 6) | (b[i + 1] & 63));
            ++i;

        }
        else {
            ret += String.fromCharCode(((c & 15) << 12) | ((b[i + 1] & 63) << 6) | (b[i + 2] & 63));
            i += 2;

        }

    }
    return ret;

}

// Set the private key fields N, e, and d from hex strings
function RSASetPrivate(N, E, D) {
    if (N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N, 16);
        this.e = parseInt(E, 16);
        this.d = parseBigInt(D, 16);

    }
    else
    throw Error("Invalid RSA private key");

}

// Set the private key fields N, e, d and CRT params from hex strings
function RSASetPrivateEx(N, E, D, P, Q, DP, DQ, C) {
    if (N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N, 16);
        this.e = parseInt(E, 16);
        this.d = parseBigInt(D, 16);
        this.p = parseBigInt(P, 16);
        this.q = parseBigInt(Q, 16);
        this.dmp1 = parseBigInt(DP, 16);
        this.dmq1 = parseBigInt(DQ, 16);
        this.coeff = parseBigInt(C, 16);

    }
    else
    throw Error("Invalid RSA private key");

}

// Generate a new random private key B bits long, using public expt E
function RSAGenerate(B, E) {
    var rng = new SecureRandom();
    var qs = B >> 1;
    this.e = parseInt(E, 16);
    var ee = new BigInteger(E, 16);
    for (;;) {
        for (;;) {
            this.p = new BigInteger(B - qs, 1, rng);
            if (this.p.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) == 0 && this.p.isProbablePrime(10)) break;

        }
        for (;;) {
            this.q = new BigInteger(qs, 1, rng);
            if (this.q.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) == 0 && this.q.isProbablePrime(10)) break;

        }
        if (this.p.compareTo(this.q) <= 0) {
            var t = this.p;
            this.p = this.q;
            this.q = t;

        }
        var p1 = this.p.subtract(BigInteger.ONE);
        var q1 = this.q.subtract(BigInteger.ONE);
        var phi = p1.multiply(q1);
        if (phi.gcd(ee).compareTo(BigInteger.ONE) == 0) {
            this.n = this.p.multiply(this.q);
            this.d = ee.modInverse(phi);
            this.dmp1 = this.d.mod(p1);
            this.dmq1 = this.d.mod(q1);
            this.coeff = this.q.modInverse(this.p);
            break;

        }

    }

}

// Perform raw private operation on "x": return x^d (mod n)
function RSADoPrivate(x) {
    if (this.p == null || this.q == null)
    return x.modPow(this.d, this.n);

    // TODO: re-calculate any missing CRT params
    var xp = x.mod(this.p).modPow(this.dmp1, this.p);
    var xq = x.mod(this.q).modPow(this.dmq1, this.q);

    while (xp.compareTo(xq) < 0)
    xp = xp.add(this.p);
    return xp.subtract(xq).multiply(this.coeff).mod(this.p).multiply(this.q).add(xq);

}

// Return the PKCS#1 RSA decryption of "ctext".
// "ctext" is an even-length hex string and the output is a plain string.
function RSADecrypt(ctext) {
    var c = parseBigInt(ctext, 16);
    var m = this.doPrivate(c);
    if (m == null) return null;
    return pkcs1unpad2(m, (this.n.bitLength() + 7) >> 3);

}

// Return the PKCS#1 RSA decryption of "ctext".
// "ctext" is a Base64-encoded string and the output is a plain string.
//function RSAB64Decrypt(ctext) {
//  var h = b64tohex(ctext);
//  if(h) return this.decrypt(h); else return null;
//}

// protected
RSAKey.prototype.doPrivate = RSADoPrivate;

// public
RSAKey.prototype.setPrivate = RSASetPrivate;
RSAKey.prototype.setPrivateEx = RSASetPrivateEx;
RSAKey.prototype.generate = RSAGenerate;
RSAKey.prototype.decrypt = RSADecrypt;
//RSAKey.prototype.b64_decrypt = RSAB64Decrypt;
//
// asn1hex.js - Hexadecimal represented ASN.1 string library
//
//
// version: 1.0 (2010-Jun-03)
//
// Copyright (c) 2010 Kenji Urushima (kenji.urushima@gmail.com)
//
// This software is licensed under the terms of the MIT License.
// http://www.opensource.org/licenses/mit-license.php
//
// The above copyright and license notice shall be 
// included in all copies or substantial portions of the Software.
// 
//
// Depends on:
//

// MEMO:
//   f('3082025b02...', 2) ... 82025b ... 3bytes
//   f('020100', 2) ... 01 ... 1byte
//   f('0203001...', 2) ... 03 ... 1byte
//   f('02818003...', 2) ... 8180 ... 2bytes
//   f('3080....0000', 2) ... 80 ... -1
//
//   Requirements:
//   - ASN.1 type octet length MUST be 1. 
//     (i.e. ASN.1 primitives like SET, SEQUENCE, INTEGER, OCTETSTRING ...)
//   - 
function _asnhex_getByteLengthOfL_AtObj(s, pos) {
    if (s.substring(pos + 2, pos + 3) != '8') return 1;
    var i = parseInt(s.substring(pos + 3, pos + 4));
    if (i == 0) return - 1;
    // length octet '80' indefinite length
    if (0 < i && i < 10) return i + 1;
    // including '8?' octet;
    return - 2;
    // malformed format

}

function _asnhex_getHexOfL_AtObj(s, pos) {
    var len = _asnhex_getByteLengthOfL_AtObj(s, pos);
    if (len < 1) return '';
    return s.substring(pos + 2, pos + 2 + len * 2);

}

//
//   getting ASN.1 length value at the position 'idx' of
//   hexa decimal string 's'.
//
//   f('3082025b02...', 0) ... 82025b ... ???
//   f('020100', 0) ... 01 ... 1
//   f('0203001...', 0) ... 03 ... 3
//   f('02818003...', 0) ... 8180 ... 128
function _asnhex_getIntOfL_AtObj(s, pos) {
    var hLength = _asnhex_getHexOfL_AtObj(s, pos);
    if (hLength == '') return - 1;
    var bi;
    if (parseInt(hLength.substring(0, 1)) < 8) {
        bi = parseBigInt(hLength, 16);

    } else {
        bi = parseBigInt(hLength.substring(2), 16);

    }
    return bi.intValue();

}

//
// get ASN.1 value starting string position 
// for ASN.1 object refered by index 'idx'.
//
function _asnhex_getStartPosOfV_AtObj(s, pos) {
    var l_len = _asnhex_getByteLengthOfL_AtObj(s, pos);
    if (l_len < 0) return l_len;
    return pos + (l_len + 1) * 2;

}

function _asnhex_getHexOfV_AtObj(s, pos) {
    var pos1 = _asnhex_getStartPosOfV_AtObj(s, pos);
    var len = _asnhex_getIntOfL_AtObj(s, pos);
    return s.substring(pos1, pos1 + len * 2);

}

function _asnhex_getPosOfNextSibling_AtObj(s, pos) {
    var pos1 = _asnhex_getStartPosOfV_AtObj(s, pos);
    var len = _asnhex_getIntOfL_AtObj(s, pos);
    return pos1 + len * 2;

}

function _asnhex_getPosArrayOfChildren_AtObj(h, pos) {
    var a = new Array();
    var p0 = _asnhex_getStartPosOfV_AtObj(h, pos);
    a.push(p0);

    var len = _asnhex_getIntOfL_AtObj(h, pos);
    var p = p0;
    var k = 0;
    while (1) {
        var pNext = _asnhex_getPosOfNextSibling_AtObj(h, p);
        if (pNext == null || (pNext - p0 >= (len * 2))) break;
        if (k >= 200) break;

        a.push(pNext);
        p = pNext;

        k++;

    }

    return a;

}
//
// rsa-pem.js - adding function for reading/writing PKCS#1 PEM private key
//              to RSAKey class.
//
// version: 1.0 (2010-Jun-03)
//
// Copyright (c) 2010 Kenji Urushima (kenji.urushima@gmail.com)
//
// This software is licensed under the terms of the MIT License.
// http://www.opensource.org/licenses/mit-license.php
//
// The above copyright and license notice shall be 
// included in all copies or substantial portions of the Software.
// 
//
// Depends on:
//
//
//
// _RSApem_pemToBase64(sPEM)
//
//   removing PEM header, PEM footer and space characters including
//   new lines from PEM formatted RSA private key string.
//
function _rsapem_pemToBase64(sPEMPrivateKey) {
    var s = sPEMPrivateKey;
    s = s.replace("-----BEGIN RSA PRIVATE KEY-----", "");
    s = s.replace("-----END RSA PRIVATE KEY-----", "");
    s = s.replace(/[ \n]+/g, "");
    return s;

}

function _rsapem_getPosArrayOfChildrenFromHex(hPrivateKey) {
    var a = new Array();
    var v1 = _asnhex_getStartPosOfV_AtObj(hPrivateKey, 0);
    var n1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, v1);
    var e1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, n1);
    var d1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, e1);
    var p1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, d1);
    var q1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, p1);
    var dp1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, q1);
    var dq1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, dp1);
    var co1 = _asnhex_getPosOfNextSibling_AtObj(hPrivateKey, dq1);
    a.push(v1, n1, e1, d1, p1, q1, dp1, dq1, co1);
    return a;

}

function _rsapem_getHexValueArrayOfChildrenFromHex(hPrivateKey) {
    var posArray = _rsapem_getPosArrayOfChildrenFromHex(hPrivateKey);
    var v = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[0]);
    var n = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[1]);
    var e = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[2]);
    var d = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[3]);
    var p = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[4]);
    var q = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[5]);
    var dp = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[6]);
    var dq = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[7]);
    var co = _asnhex_getHexOfV_AtObj(hPrivateKey, posArray[8]);
    var a = new Array();
    a.push(v, n, e, d, p, q, dp, dq, co);
    return a;

}

function _rsapem_readPrivateKeyFromPEMString(keyPEM) {
    var keyB64 = _rsapem_pemToBase64(keyPEM);
    var keyHex = b64tohex(keyB64)
    // depends base64.js
    var a = _rsapem_getHexValueArrayOfChildrenFromHex(keyHex);
    this.setPrivateEx(a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]);

}

RSAKey.prototype.readPrivateKeyFromPEMString = _rsapem_readPrivateKeyFromPEMString;
//
// rsa-sign.js - adding signing functions to RSAKey class.
//
//
// version: 1.0 (2010-Jun-03)
//
// Copyright (c) 2010 Kenji Urushima (kenji.urushima@gmail.com)
//
// This software is licensed under the terms of the MIT License.
// http://www.opensource.org/licenses/mit-license.php
//
// The above copyright and license notice shall be 
// included in all copies or substantial portions of the Software.

//
// Depends on:
//   function sha1.hex(s) of sha1.js
//   jsbn.js
//   jsbn2.js
//   rsa.js
//   rsa2.js
//

// keysize / pmstrlen
//  512 /  128
// 1024 /  256
// 2048 /  512
// 4096 / 1024

// As for _RSASGIN_DIHEAD values for each hash algorithm, see PKCS#1 v2.1 spec (p38).
var _RSASIGN_DIHEAD = [];
_RSASIGN_DIHEAD['sha1'] = "3021300906052b0e03021a05000414";
_RSASIGN_DIHEAD['sha256'] = "3031300d060960864801650304020105000420";
//_RSASIGN_DIHEAD['md2'] = "3020300c06082a864886f70d020205000410";
//_RSASIGN_DIHEAD['md5'] = "3020300c06082a864886f70d020505000410";
//_RSASIGN_DIHEAD['sha384'] = "3041300d060960864801650304020205000430";
//_RSASIGN_DIHEAD['sha512'] = "3051300d060960864801650304020305000440";
var _RSASIGN_HASHHEXFUNC = [];
//_RSASIGN_HASHHEXFUNC['sha1'] = sha1.hex;
_RSASIGN_HASHHEXFUNC['sha256'] = function(i) {
    return sjcl.codec.hex.fromBits(sjcl.hash.sha256.hash(i));
}

// ========================================================================
// Signature Generation
// ========================================================================

function _rsasign_getHexPaddedDigestInfoForString(s, keySize, hashAlg) {
    var pmStrLen = keySize / 4;
    var hashFunc = _RSASIGN_HASHHEXFUNC[hashAlg];
    var sHashHex = hashFunc(s);

    var sHead = "0001";
    var sTail = "00" + _RSASIGN_DIHEAD[hashAlg] + sHashHex;
    var sMid = "";
    var fLen = pmStrLen - sHead.length - sTail.length;
    for (var i = 0; i < fLen; i += 2) {
        sMid += "ff";

    }
    var sPaddedMessageHex = sHead + sMid + sTail;

    return sPaddedMessageHex;

}

function _rsasign_signString(s, hashAlg) {
    var hPM = _rsasign_getHexPaddedDigestInfoForString(s, this.n.bitLength(), hashAlg);
    var biPaddedMessage = parseBigInt(hPM, 16);
    var biSign = this.doPrivate(biPaddedMessage);
    var hexSign = biSign.toString(16);
    return hexSign;

}

function _rsasign_signStringWithSHA1(s) {
    var hPM = _rsasign_getHexPaddedDigestInfoForString(s, this.n.bitLength(), 'sha1');
    var biPaddedMessage = parseBigInt(hPM, 16);
    var biSign = this.doPrivate(biPaddedMessage);
    var hexSign = biSign.toString(16);
    return hexSign;

}

function _rsasign_signStringWithSHA256(s) {
    var hPM = _rsasign_getHexPaddedDigestInfoForString(s, this.n.bitLength(), 'sha256');
    var biPaddedMessage = parseBigInt(hPM, 16);
    var biSign = this.doPrivate(biPaddedMessage);
    var hexSign = biSign.toString(16);
    return hexSign;

}

// ========================================================================
// Signature Verification
// ========================================================================

function _rsasign_getDecryptSignatureBI(biSig, hN, hE) {
    var rsa = new RSAKey();
    rsa.setPublic(hN, hE);
    var biDecryptedSig = rsa.doPublic(biSig);
    return biDecryptedSig;

}

function _rsasign_getHexDigestInfoFromSig(biSig, hN, hE) {
    var biDecryptedSig = _rsasign_getDecryptSignatureBI(biSig, hN, hE);
    var hDigestInfo = biDecryptedSig.toString(16).replace(/^1f+00/, '');
    return hDigestInfo;

}

function _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo) {
    for (var algName in _RSASIGN_DIHEAD) {
        var head = _RSASIGN_DIHEAD[algName];
        var len = head.length;
        if (hDigestInfo.substring(0, len) == head) {
            var a = [algName, hDigestInfo.substring(len)];
            return a;

        }

    }
    return [];

}

function _rsasign_verifySignatureWithArgs(sMsg, biSig, hN, hE) {
    var hDigestInfo = _rsasign_getHexDigestInfoFromSig(biSig, hN, hE);
    var digestInfoAry = _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo);
    if (digestInfoAry.length == 0) return false;
    var algName = digestInfoAry[0];
    var diHashValue = digestInfoAry[1];
    var ff = _RSASIGN_HASHHEXFUNC[algName];
    var msgHashValue = ff(sMsg);
    return (diHashValue == msgHashValue);

}

function _rsasign_verifyHexSignatureForMessage(hSig, sMsg) {
    var biSig = parseBigInt(hSig, 16);
    var result = _rsasign_verifySignatureWithArgs(sMsg, biSig, 
    this.n.toString(16), 
    this.e.toString(16));
    return result;

}

function _rsasign_verifyString(sMsg, hSig) {
    hSig = hSig.replace(/[ \n]+/g, "");
    var biSig = parseBigInt(hSig, 16);
    var biDecryptedSig = this.doPublic(biSig);
    var hDigestInfo = biDecryptedSig.toString(16).replace(/^1f+00/, '');
    var digestInfoAry = _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo);

    if (digestInfoAry.length == 0) return false;
    var algName = digestInfoAry[0];
    var diHashValue = digestInfoAry[1];
    var ff = _RSASIGN_HASHHEXFUNC[algName];
    var msgHashValue = ff(sMsg);
    return (diHashValue == msgHashValue);

}

RSAKey.prototype.signString = _rsasign_signString;
RSAKey.prototype.signStringWithSHA1 = _rsasign_signStringWithSHA1;
RSAKey.prototype.signStringWithSHA256 = _rsasign_signStringWithSHA256;

RSAKey.prototype.verifyString = _rsasign_verifyString;
RSAKey.prototype.verifyHexSignatureForMessage = _rsasign_verifyHexSignatureForMessage;

// 
// x509.js - X509 class to read subject public key from certificate.
//
// version: 1.0 (2010-Jun-03)
//
// Copyright (c) 2010 Kenji Urushima (kenji.urushima@gmail.com)
//
// This software is licensed under the terms of the MIT License.
// http://www.opensource.org/licenses/mit-license.php
//
// The above copyright and license notice shall be 
// included in all copies or substantial portions of the Software.
// 

// Depends:
//   base64.js
//   rsa.js

function _x509_pemToBase64(sCertPEM) {
    var s = sCertPEM;
    s = s.replace("-----BEGIN CERTIFICATE-----", "");
    s = s.replace("-----END CERTIFICATE-----", "");
    s = s.replace(/[ \n]+/g, "");
    return s;

}

function _x509_pemToHex(sCertPEM) {
    var b64Cert = _x509_pemToBase64(sCertPEM);
    var hCert = b64tohex(b64Cert);
    return hCert;

}

function _x509_getHexTbsCertificateFromCert(hCert) {
    var pTbsCert = _asnhex_getStartPosOfV_AtObj(hCert, 0);
    return pTbsCert;

}

// NOTE: privateKeyUsagePeriod field of X509v2 not supported.
// NOTE: v1 and v3 supported
function _x509_getSubjectPublicKeyInfoPosFromCertHex(hCert) {
    var pTbsCert = _asnhex_getStartPosOfV_AtObj(hCert, 0);
    var a = _asnhex_getPosArrayOfChildren_AtObj(hCert, pTbsCert);
    if (a.length < 1) return - 1;
    if (hCert.substring(a[0], a[0] + 10) == "a003020102") {
        // v3
        if (a.length < 6) return - 1;
        return a[6];

    } else {
        if (a.length < 5) return - 1;
        return a[5];

    }

}

// NOTE: Without BITSTRING encapsulation.
function _x509_getSubjectPublicKeyPosFromCertHex(hCert) {
    var pInfo = _x509_getSubjectPublicKeyInfoPosFromCertHex(hCert);
    if (pInfo == -1) return - 1;
    var a = _asnhex_getPosArrayOfChildren_AtObj(hCert, pInfo);
    if (a.length != 2) return - 1;
    var pBitString = a[1];
    if (hCert.substring(pBitString, pBitString + 2) != '03') return - 1;
    var pBitStringV = _asnhex_getStartPosOfV_AtObj(hCert, pBitString);

    if (hCert.substring(pBitStringV, pBitStringV + 2) != '00') return - 1;
    return pBitStringV + 2;

}

function _x509_getPublicKeyHexArrayFromCertHex(hCert) {
    var p = _x509_getSubjectPublicKeyPosFromCertHex(hCert);
    var a = _asnhex_getPosArrayOfChildren_AtObj(hCert, p);
    if (a.length != 2) return [];
    var hN = _asnhex_getHexOfV_AtObj(hCert, a[0]);
    var hE = _asnhex_getHexOfV_AtObj(hCert, a[1]);
    if (hN != null && hE != null) {
        return [hN, hE];

    } else {
        return [];

    }

}

function _x509_getPublicKeyHexArrayFromCertPEM(sCertPEM) {
    var hCert = _x509_pemToHex(sCertPEM);
    var a = _x509_getPublicKeyHexArrayFromCertHex(hCert);
    return a;

}

function _x509_readCertPEM(sCertPEM) {
    var hCert = _x509_pemToHex(sCertPEM);
    var a = _x509_getPublicKeyHexArrayFromCertHex(hCert);
    var rsa = new RSAKey();
    rsa.setPublic(a[0], a[1]);
    this.subjectPublicKeyRSA = rsa;
    this.subjectPublicKeyRSA_hN = a[0];
    this.subjectPublicKeyRSA_hE = a[1];

}

function _x509_readCertPEMWithoutRSAInit(sCertPEM) {
    var hCert = _x509_pemToHex(sCertPEM);
    var a = _x509_getPublicKeyHexArrayFromCertHex(hCert);
    this.subjectPublicKeyRSA.setPublic(a[0], a[1]);
    this.subjectPublicKeyRSA_hN = a[0];
    this.subjectPublicKeyRSA_hE = a[1];

}

function X509() {
    this.subjectPublicKeyRSA = null;
    this.subjectPublicKeyRSA_hN = null;
    this.subjectPublicKeyRSA_hE = null;

}

X509.prototype.readCertPEM = _x509_readCertPEM;
X509.prototype.readCertPEMWithoutRSAInit = _x509_readCertPEMWithoutRSAInit;
var jwt = {};

var JWTInternals = (function() {

    // convert a base64url string to hex
    var b64urlmap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    function b64urltohex(s) {
        var ret = ""
        var i;
        var k = 0;
        // b64 state, 0-3
        var slop;
        for (i = 0; i < s.length; ++i) {
            var v = b64urlmap.indexOf(s.charAt(i));
            if (v < 0) continue;
            if (k == 0) {
                ret += int2char(v >> 2);
                slop = v & 3;
                k = 1;

            }
            else if (k == 1) {
                ret += int2char((slop << 2) | (v >> 4));
                slop = v & 0xf;
                k = 2;

            }
            else if (k == 2) {
                ret += int2char(slop);
                ret += int2char(v >> 2);
                slop = v & 3;
                k = 3;

            }
            else {
                ret += int2char((slop << 2) | (v >> 4));
                ret += int2char(v & 0xf);
                k = 0;

            }

        }
        if (k == 1)
        ret += int2char(slop << 2);
        return ret;

    }



    function base64urlencode(arg)
    {
        var s = Base64Encoder.encode(arg);
        // Standard base64 encoder
        s = s.split('=')[0];
        // Remove any trailing '='s
        s = s.replace(/\+/g, '-');
        // 62nd char of encoding
        s = s.replace(/\//g, '_');
        // 63rd char of encoding
        // TODO optimize this; we can do much better
        return s;

    }

    function base64urldecode(arg)
    {
        var s = arg;
        s = s.replace(/-/g, '+');
        // 62nd char of encoding
        s = s.replace(/_/g, '/');
        // 63rd char of encoding
        switch (s.length % 4)
        // Pad with trailing '='s
        {
            case 0:
            break;
            // No pad chars in this case
            case 2:
            s += "==";
            break;
            // Two pad chars
            case 3:
            s += "=";
            break;
            // One pad char
            default:
            throw new InputException("Illegal base64url string!");

        }
        return Base64Encoder.decode(s);
        // Standard base64 decoder

    }

    function NoSuchAlgorithmException(message) {
        this.message = message;
        this.toString = function() {
            return "No such algorithm: " + this.message;
        };

    }
    function NotImplementedException(message) {
        this.message = message;
        this.toString = function() {
            return "Not implemented: " + this.message;
        };

    }
    function InputException(message) {
        this.message = message;
        this.toString = function() {
            return "Malformed input: " + this.message;
        };

    }

    function HMACAlgorithm(hash, key)
    {
        if (hash == "sha256") {
            this.hash = sjcl.hash.sha256;

        } else {
            throw new NoSuchAlgorithmException("HMAC does not support hash " + hash);

        }
        this.key = sjcl.codec.utf8String.toBits(key);

    }

    HMACAlgorithm.prototype = 
    {
        update: function _update(data)
        {
            this.data = data;

        },

finalize: function _finalize()
        {
            },

sign: function _sign()
        {
            var hmac = new sjcl.misc.hmac(this.key, this.hash);
            var result = hmac.encrypt(this.data);
            return base64urlencode(Base64Encoder.decode(sjcl.codec.base64.fromBits(result)));

        },

verify: function _verify(sig)
        {
            var hmac = new sjcl.misc.hmac(this.key, this.hash);
            var result = hmac.encrypt(this.data);

            return base64urlencode(Base64Encoder.decode(sjcl.codec.base64.fromBits(result))) == sig;

        }

    }

    function RSASHAAlgorithm(hash, keyPEM)
    {
        if (hash == "sha1") {
            this.hash = "sha1";

        } else if (hash == "sha256") {
            this.hash = "sha256";

        } else {
            throw new NoSuchAlgorithmException("JWT algorithm: " + hash);

        }
        this.keyPEM = keyPEM;

    }
    RSASHAAlgorithm.prototype = 
    {
        update: function _update(data)
        {
            this.data = data;

        },
        finalize: function _finalize()
        {

            },
        sign: function _sign()
        {
            var rsa = new RSAKey();
            rsa.readPrivateKeyFromPEMString(this.keyPEM);
            var hSig = rsa.signString(this.data, this.hash);
            return base64urlencode(base64urldecode(hex2b64(hSig)));
            // TODO replace this with hex2b64urlencode!

        },
        verify: function _verify(sig)
        {
            var result = this.keyPEM.verifyString(this.data, b64urltohex(sig));
            return result;

        }

    }

    function WebToken(objectStr, algorithm)
    {
        this.objectStr = objectStr;
        this.pkAlgorithm = algorithm;

    }

    var WebTokenParser = {

        parse: function _parse(input)
        {
            var parts = input.split(".");
            if (parts.length != 3) {
                throw new MalformedWebToken("Must have three parts");

            }
            var token = new WebToken();
            token.headerSegment = parts[0];
            token.payloadSegment = parts[1];
            token.cryptoSegment = parts[2];

            token.pkAlgorithm = base64urldecode(parts[0]);
            return token;

        }

    }

    function jsonObj(strOrObject)
    {
        if (typeof strOrObject == "string") {
            return eval("(" + strOrObject + ")");

        }
        return strOrObject;

    }

    function constructAlgorithm(jwtAlgStr, key)
    {
        if ("ES256" === jwtAlgStr) {
            throw new NotImplementedException("ECDSA-SHA256 not yet implemented");

        } else if ("ES384" === jwtAlgStr) {
            throw new NotImplementedException("ECDSA-SHA384 not yet implemented");

        } else if ("ES512" === jwtAlgStr) {
            throw new NotImplementedException("ECDSA-SHA512 not yet implemented");

        } else if ("HS256" === jwtAlgStr) {
            return new HMACAlgorithm("sha256", key);

        } else if ("HS384" === jwtAlgStr) {
            throw new NotImplementedException("HMAC-SHA384 not yet implemented");

        } else if ("HS512" === jwtAlgStr) {
            throw new NotImplementedException("HMAC-SHA512 not yet implemented");

        } else if ("RS256" === jwtAlgStr) {
            return new RSASHAAlgorithm("sha256", key);

        } else if ("RS384" === jwtAlgStr) {
            throw new NotImplementedException("RSA-SHA384 not yet implemented");

        } else if ("RS512" === jwtAlgStr) {
            throw new NotImplementedException("RSA-SHA512 not yet implemented");

        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + jwtAlgStr);

        }

    }

    WebToken.prototype = 
    {
        serialize: function _serialize(key)
        {
            var header = jsonObj(this.pkAlgorithm);
            var jwtAlgStr = header.alg;
            var algorithm = constructAlgorithm(jwtAlgStr, key);
            var algBytes = base64urlencode(this.pkAlgorithm);
            var jsonBytes = base64urlencode(this.objectStr);

            var stringToSign = algBytes + "." + jsonBytes;
            algorithm.update(stringToSign);
            var digestValue = algorithm.finalize();

            var signatureValue = algorithm.sign();
            return algBytes + "." + jsonBytes + "." + signatureValue;

        },

verify: function _verify(key)
        {
            var header = jsonObj(this.pkAlgorithm);
            var jwtAlgStr = header.alg;
            var algorithm = constructAlgorithm(jwtAlgStr, key);
            algorithm.update(this.headerSegment + "." + this.payloadSegment);
            algorithm.finalize();
            return algorithm.verify(this.cryptoSegment);

        }

    }

    jwt.WebToken = WebToken;
    jwt.WebTokenParser = WebTokenParser;
    jwt.base64urlencode = base64urlencode;
    jwt.base64urldecode = base64urldecode;

})();


/*
var Base64Encoder = {
    encode : function(str) {
		if(typeof(Buffer)!="undefined"){
			return new Buffer(str).toString("base64")
		}
		var b;
		with (new ActiveXObject("ADODB.Stream")){
			Charset = "utf-8";
			Type = 2;
			Open();
			WriteText(str);
			Position = 0;
			Type = 1;
			b = Read();
		}
        with (new ActiveXObject("Microsoft.XMLDOM").createElement("TXT")) {
			setAttribute("xmlns:dt","urn:schemas-microsoft-com:datatypes");
            dataType = "bin.base64";
            nodeTypedValue = b
            return text;
        }
    },
    decode : function(bts) {
		//return new Buffer(bts, 'base64').toString('ascii')
        with (new ActiveXObject("Microsoft.XMLDOM").createElement("TXT")) {
            dataType = "bin.base64";
            text = bts;
            return nodeTypedValue;
		}
    }
};
*/
var Base64Encoder = {
    encode : function(str) {
		return base64encode(str)
    },
    decode : function(str) {
		return base64decode(str)
    }
};

var base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var base64DecodeChars = new Array(  
     - 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     
     - 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
     - 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, 
     - 1,   0,   1,   2,   3, 4,   5,   6,   7,   8,   9, 10, 11, 12, 13, 14, 
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, 
     - 1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1);
function base64encode(str) {
        
    var out,
    i,
    len;
        
    var c1,
    c2,
    c3;
        len = str.length;
        i = 0;
        out = "";
        
    while (i < len) {
        c1 = str.charCodeAt(i++) & 0xff;
        if (i == len)
        {
                out += base64EncodeChars.charAt(c1 >> 2);
                out += base64EncodeChars.charAt((c1 & 0x3) << 4);
                out += "==";
                
            break;

        }
        c2 = str.charCodeAt(i++);
        if (i == len)
        {
                out += base64EncodeChars.charAt(c1 >> 2);
                out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
                out += base64EncodeChars.charAt((c2 & 0xF) << 2);
                out += "=";
                
            break;

        }
        c3 = str.charCodeAt(i++);
        out += base64EncodeChars.charAt(c1 >> 2);
        out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
        out += base64EncodeChars.charAt(((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6));
        out += base64EncodeChars.charAt(c3 & 0x3F);
            
    }
        
    return out;

}
function base64decode(str) {
        
    var c1,
    c2,
    c3,
    c4;
        
    var i,
    len,
    out;
        len = str.length;
        i = 0;
        out = "";
        
    while (i < len) {
        /* c1 */
        do {
                c1 = base64DecodeChars[str.charCodeAt(i++) & 0xff];

        }
        while (i < len && c1 == -1);
        if (c1 == -1)
            
        break;
        /* c2 */
        do {
                c2 = base64DecodeChars[str.charCodeAt(i++) & 0xff];

        }
        while (i < len && c2 == -1);
        if (c2 == -1)
            
        break;
        out += String.fromCharCode((c1 << 2) | ((c2 & 0x30) >> 4));
        /* c3 */
        do {
                c3 = str.charCodeAt(i++) & 0xff;
                
            if (c3 == 61)
              
            return out;
                c3 = base64DecodeChars[c3];

        }
        while (i < len && c3 == -1);
        if (c3 == -1)
            
        break;
        out += String.fromCharCode(((c2 & 0XF) << 4) | ((c3 & 0x3C) >> 2));
        /* c4 */
        do {
                c4 = str.charCodeAt(i++) & 0xff;
                
            if (c4 == 61)
              
            return out;
                c4 = base64DecodeChars[c4];

        }
        while (i < len && c4 == -1);
        if (c4 == -1)
            
        break;
        out += String.fromCharCode(((c3 & 0x03) << 6) | c4);
            
    }
        
    return out;

}
function utf16to8(str) {
        
    var out,
    i,
    len,
    c;
        out = "";
        len = str.length;
        
    for (i = 0; i < len; i++) {
        c = str.charCodeAt(i);
        if ((c >= 0x0001) && (c <= 0x007F)) {
                out += str.charAt(i);

        } else if (c > 0x07FF) {
                out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
                out += String.fromCharCode(0x80 | ((c >>   6) & 0x3F));
                out += String.fromCharCode(0x80 | ((c >>   0) & 0x3F));

        } else {
                out += String.fromCharCode(0xC0 | ((c >>   6) & 0x1F));
                out += String.fromCharCode(0x80 | ((c >>   0) & 0x3F));

        }
            
    }
        
    return out;

}
function utf8to16(str) {
        
    var out,
    i,
    len,
    c;
        
    var char2,
    char3;
        out = "";
        len = str.length;
        i = 0;
        
    while (i < len) {
        c = str.charCodeAt(i++);
        switch (c >> 4)
        {
            
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
                
            // 0xxxxxxx
                out += str.charAt(i - 1);
                
            break;
              
        case 12:
        case 13:
                
            // 110x xxxx   10xx xxxx
                char2 = str.charCodeAt(i++);
                out += String.fromCharCode(((c & 0x1F) << 6) | (char2 & 0x3F));
                
            break;
              
        case 14:
                
            // 1110 xxxx  10xx xxxx  10xx xxxx
                char2 = str.charCodeAt(i++);
                char3 = str.charCodeAt(i++);
                out += String.fromCharCode(((c & 0x0F) << 12) | 
                     ((char2 & 0x3F) << 6) | 
                     ((char3 & 0x3F) << 0));
                
            break;

        }
            
    }
        
    return out;

}

function signJwtToken(payload, key, alg) {
  var token = new jwt.WebToken(payload, '{"alg":"' + alg + '", "typ":"JWT"}');
  var signed = token.serialize(key);
  return signed;
}
</script>
