---
title: "About"
blocks:
  - body: "## What is this?\n\nThis is a [TinaCMS](https://tina.io)-enabled Next.js app, so you can edit your content on a live page. In this project the Tina file-based CMS is used via GraphQL: it's powered by a schema that *you* define. It not only serves content from Markdown files in your repository, but it also generates TinaCMS forms for you automatically ✨.\n\n### Scope\n\n*   Run this project locally using local content within this repository.\n*   Connect to Tina Cloud to benefit from its GraphQL Content API.\n*   Deploy the site to visually edit your site.\n*   Invite collaborators.\n\n## Requirements\n\n*   Git\n*   [Node.js Active LTS](https://nodejs.org/en/about/releases/)\n*   Yarn\n\n## Fork this repository\n\n⚠️⚠️ Start by **forking** the repository and then pull it down to your computer. ⚠️⚠️\n\n## Install\n\n> ℹ️ This project uses `yarn` as a package manager, if `yarn` isn't installed on your machine, open a terminal and run `npm install -g yarn`\n\nInstall the project's dependencies:\n\n```\nyarn install\n```\n\n> ⚠️ If you'd like to use `npm` beware that there is no `package-lock.json` so we can't guarantee the dependencies are the same for you.\n\n## Run the project locally\n\nTo run the local development server:\n\n```\nyarn dev\n```\n\nThis command starts the GraphQL server and the Next.js application in development mode. It also regenerates your schema types for TypeScript and GraphQL so changes to your `.tina` config are reflected immediately.\n\nOne of the most interesting aspects of the Tina Cloud Content API is that it doesn't actually require anything from the Cloud to work locally. Since Tina is by default a Git-backed CMS, everything can be run from your local filesystem via the CLI. :sunglasses:\n\nThis is ideal for development workflows and the API is identical to the one used in the cloud, so once you're ready to deploy your application you won't face any challenges there.\n\nOpen [`http://localhost:3000`](http://localhost:3000) in your browser to see your file-based content being loaded from the GraphQL API.\n\n## Edit content locally\n\nWe need to define some local environment variables in order to edit content with Tina.\n\nCopy `.env.example` to `.env`:\n\n```sh\ncp .env.example .env\n\n```\n\n`NEXT_PUBLIC_USE_LOCAL_CLIENT` should be set to `1`, other values can be ignored for now.\n\nRestart your server and visit [`http://localhost:3000/`](http://localhost:3000/`), and click \"enter edit mode\" in the top right hand corner, the same page is displayed but you can notice a pencil icon at the bottom left corner.\n\nClick to open Tina's sidebar which displays a form with fields you can edit and see update live on the page.\nSince we're working locally, saving results in changes to your local filesystem.\n\nFrom here, you're ready to start building your own project, to read a little bit about how this project is structured, and how to modify it to make it your own,\nread the [folder structure](#starter-structure) section below.\n\nWhen you're ready to deploy your site, read on about how you can connect to Tina Cloud and make authenticated changes via our Cloud API.\n\n> **NOTE:** In this project there are two way to enter edit mode. You can click the \"enter edit mode button\" or visit [`/admin`](http://localhost/admin). You can also disable the edit button by setting `NEXT_PUBLIC_SHOW_EDIT_BTN=0` in `.env`\n\n## Connect to Tina Cloud\n\nWhile the fully-local development workflow is the recommended way for developers to work,\nyou'll obviously want other editors and collaborators to be able to make changes on a hosted website with authentication.\n\n> ℹ️ Changes in edit mode show up on your home page after your site finishes a rebuild.\n\n## Register your local application with Tina Cloud\n\n1.  Visit [auth.tina.io](https://auth.tina.io/register), create an organization, and sign in. Make a note of your organization name.\n2.  Create a Tina Cloud app which connects to the GitHub repository you've just forked. Once your app is created, click on the app to get to the app settings and copy the client ID.\n\n## Connect your local project with Tina Cloud\n\nIn the `env.local` file set:\n\n*   `NEXT_PUBLIC_USE_LOCAL_CLIENT` to `0`.\n*   `NEXT_PUBLIC_ORGANIZATION_NAME` to your Tina Cloud organization name\n*   `NEXT_PUBLIC_TINA_CLIENT_ID` to the Client ID displayed in your Tina Cloud App.\n*   `NEXT_PUBLIC_SHOW_EDIT_BTN` to `0` or `1`, `0` means there is no \"enter edit mode\" and you will have to visit [`/admin`](http://localhost/admin) to enter edit mode.\n\nRestart your server and run `yarn dev` again.\n\nOpen [`http://localhost:3000/`](http://localhost:3000/`) and click \"enter edit mode\"\n\n![](/uploads/tina-cloud-authorization.png \"\")\n\nThis time a modal asks you to authenticate through Tina Cloud. Upon success, your edits will be sent to the cloud server (and subsequently to GitHub).\n\n#### Edit content\n\nMake some edits through the sidebar and click save.\nChanges are saved in your GitHub repository.\n\nNow that Tina Cloud editing is working correctly, we can deploy the site so that other team members can make edits too.\n\n> ℹ️ Gotcha: since your changes are being synced directly to Github, you'll notice that when your in non-\"edit\" mode your page still receive the unedited data from your local filesystem. This is mostly fine since editing with Tina Cloud is designed for hosted environments. But beware that changes to your schema may result in a mismatch between the Tina Cloud API and your local client.\n\n## Deploy\n\n### Vercel\n\n[![Deploy with Vercel](https://vercel.com/button \"\")](https://vercel.com/new/)\n\nConnect to your GitHub repository and set the same environment variables as the ones in your `env.local` file:\n\n```\nNEXT_PUBLIC_ORGANIZATION_NAME= <YOUR_ORGANIZATION>\nNEXT_PUBLIC_TINA_CLIENT_ID= <YOUR_CLIENT_ID>\n```\n\n![](/uploads/vercel-congratulations.png \"\")\n\n\U0001F389 Congratulations, your site is now live!\n\nYou can test that everything is configured correctly by navigating to `[your deployment URL]/`, click \"edit this site\",\nlog in to Tina Cloud, and making some edits. Your changes should be saved to your GitHub repository.\n\n### Netlify\n\n[![Deploy to Netlify](https://www.netlify.com/img/deploy/button.svg \"\")](https://app.netlify.com/start/)\n\nConnect to your GitHub repository, then:\n\n*   set the **build command** to `yarn build`,\n*   set the **publish directory**. To `.next/` .\n\n![](/uploads/netlify-build-settings.png \"\")\n\nClick on **advanced** to add the same environment variables as the ones in your `env.local` file:\n\n```\nNEXT_PUBLIC_ORGANIZATION_NAME= <YOUR_ORGANIZATION>\nNEXT_PUBLIC_TINA_CLIENT_ID= <YOUR_CLIENT_ID>\n```\n\n![](/uploads/netlify-advanced-build-settings.png \"\")\n\nCopy-paste your Organization ID and Client ID.\n\nOnce you're done, click \"Deploy site\".\n\nInstall the [\"Next on Netlify\" plugin](https://www.netlify.com/blog/2020/12/07/announcing-one-click-install-next.js-build-plugin-on-netlify/)\nin order to take advantage of server-side rendering and Next.js preview features.\n\nTrigger a new deploy for changes to take effect.\n\nYou can test that everything is configured correctly by navigating to `[your deployment URL]/`, click \"edit this site\",\nlog in to Tina Cloud, and making some edits. Your changes should be saved to your GitHub repository.\n\n***\n\n## Starter structure\n\nTina Cloud Starter is a [Next.js](https://nextjs.org) application. The file-based routing happens through the `pages` directory. To edit this site, navigate to the `/admin` route. This will cause you to go into edit mode where Tina is loaded. Tina is only loaded in edit mode so it will not effect the production bundle size.\n\n### `tina/schema.ts`\n\nThis is where your schema is defined, when you make changes here you'll notice that the generated GraphQL API changes too. It's a good idea to run your GraphQL server while editing so you can see any breakages.\n\n> Tip: Visit the GraphQL GUI at `http://localhost:4001/altair` so you can see how changes to the schema are updated in GraphQL.\n\n### `pages/[filename].tsx`\n\nThis page can be seen at `http://localhost:3000/`, it loads the content from a markdown file which can be found in this repository at `/content/pages/home.md`. You can edit this page at by navigating to `http://localhost:3000/admin`.\n\nHead over to the [reference](/docs/tinacms-reference/) documentation to learn more about [defining a schema](/docs/schema/) or [querying with GraphQL](/docs/graphql/)\n\n### `pages/posts/[filename].tsx`\n\nThe posts are stored in the `content/posts` directory of this repository, and their routes are built with `getStaticPaths` dynamically at build time.\n\n### The `content` folder\n\nHere's where your actual content lives, you can control how content is stored from the `defineSchema` function, by default we use `markdown`.\n\n### `components`\n\nMost of the components in this project are very basic and are for demonstration purposes, feel free to replace them with something of your own!\n\n### `pages/_app.js`\n\nThe `_app.js` file is a feature in Next.js that allows you to wrap all of your routes in some specific logic which will be applied to every page. We're using it to wrap your site content in TinaCMS context. We do this so when data passes through, we can *hydrate* it so that it's editable in real time. You may notice that it's being loaded dynamically based on something called `EditState`, when you're in edit mode we'll load `TinaCMS` and all that it provides. When you're not in edit mode Tina stays out of the way so your builds stay lean.\n\nBy default we've toggle the `showEditButton` to `true`. You'll likely want to remove that option as it'll show for visitors to your site.\n\n### `pages/posts/[filename].tsx`\n\nThe posts are stored in the `content/posts` directory of this repository, and their routes are built with `getStaticPaths` dynamically at build time. You'll notice a couple of helper functions like `getStaticPropsForTina` and `staticRequest`. These are helper functions to make sure you're returning data from the local GraphQL server in a shape that Tina understands. Feel free to bring your own http client if you'd like. Read more about these helpers in the [Next.JS APIs documentation](/docs/tinacms-context/)\n\n### Creating your own pages\n\nFor now, TinaCMS works best when you:\n\n1.  Use `getStaticProps` for data\n2.  Return data from `getStaticProps` with `data`, `query`, and `variables` properties.\n3.  Wrap your `_app.js` in TinaCMS dynamically.\n\nAfter that, you're on your own. Go build something and share it with us on [Twitter](https://twitter.com/tina_cms).\nTo browse the docs and query our GraphQL API, run `yarn dev` in your Tina project and go to `http://localhost:4001/altair`.\n\n## Getting Help\n\nTina Cloud is in public alpha, you might face issues, to provide feedback or get help with any challenges you may have:\n\n*   Read the [Tina Cloud documentation](https://tina.io/docs/tina-cloud/).\n*   [Join our Discord](https://discord.gg/zumN63Ybpf).\n*   Visit the [community forum](https://community.tinacms.org/) to ask questions.\n*   Reach out to us on Twitter at [@tina\\_cms](https://twitter.com/tina_cms).\n*   [Email us](mailto:support@tina.io) to schedule a call with our team and share more about your context and what you're trying to achieve.\n*   Get support through the chat widget on the Tina Cloud Dashboard\n\n## LICENSE\n\nLicensed under the [Apache 2.0 license](./LICENSE).\n"
    color: default
    _template: content
---
