# Contributing to python-script-background-music
I love your input! I want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## I develop with Github
I use github to host code, to track issues and feature requests, as well as accept pull requests.

## I Use [CircleCI](https://circleci.com/product/), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (I use [CircleCI](https://circleci.com/product/)). I actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the tests pass.
5. Make sure your code and commit lints.
6. Issue that pull request!

## Any contributions you make will be under the MIT
In short, when you submit code changes, your submissions are understood to be under the same [MIT](https://github.com/timo-reymann/python-script-background-music/blob/main/LICENSE) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's issues
I use GitHub issues to track public bugs. Report a bug by opening a new issue, it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
    - Be specific!
    - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

To make your life easier there is also a handy template available so feel free to use it.

> ATTENTION: If you DONT provide steps to reproduce the ticket will be closed WITHOUT FURTHER NOTICE!

## License
By contributing, you agree that your contributions will be licensed under its MIT.

