# Book Store Management

The main project folder that for learning and practicing MVC2 model in class

Live Demo: :point_right: [here](https://youtu.be/UFN6RS24hAc)

## Table of Contents
- [Description](#description)
- [Preview Screenshot](#preview-screenshot)
- [Technology](#technology)
- [Useful Resources](#useful-resources)
- [How can get started](#how-can-get-started)
- [Learn More](#learn-more)
- [License & Copyright](#license--copyright)

## Description
- This is a book store web application for buying the book
- This application also contains a login and signup function for users
- If you login in role Admin, you can search for user's information
- If you buy the book, the application does not require you to login 
- This web application is also my assignment under the requirement of teacher in class
- This web works well on desktop, not for mobile

## Preview Screenshot

<div align="center">
  <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/LoginPage.png" alt="Login Page" width="45%"></img> &nbsp;&nbsp; <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/SignUpPage.png" alt="SignUp Page" width="45%"></img>
  <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/SearchPage.png" alt="Search Page" width="45%"></img> &nbsp;&nbsp; <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/Profile.png" alt="Profile" width="45%"></img>
  <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/Invalid.png" alt="Invalid" width="45%"></img> &nbsp;&nbsp; <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/Error404.png" alt="Error 404" width="45%"></img>
  <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/BookStore.png" alt="Book Store" width="45%"></img> &nbsp;&nbsp; <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/Cart.png" alt="View Cart" width="45%"></img>
  <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/CheckOut.png" alt="Check Out" width="45%"></img> &nbsp;&nbsp; <img src="https://raw.githubusercontent.com/tienhuynh-tn/java-web-application-development-prj301/refs/heads/main/Images/Book-Store-Project/CheckOutSuccess.png" alt="Check Out Success" width="45%"></img>
</div>
  
## Technology
**1. Frontend**
  - HTML, CSS
  - JSP - JavaServer Pages
  - JSTL - JSP Standard Tag Library

**2. Backend**
  - Servlets - a Java programming language class that is used to extend the capabilities of servers that host applications accessed by means of a request-response programming model
  - JDBC - Java Database Connectivity - a Java API to connect and execute the query with the database

**3. Database**
  - Microsoft SQL Server - a relational model database server produced by Microsoft

**4. Tool**
  - Netbeans 8.2
  - Java JDK 8
  - Apache Tomcat 8.5.29

## Useful Resources

#| Name | Description
-| ---- | -----------
1| [web Folder](https://github.com/tienhuynh-tn/java-web-application-development-prj301/tree/master/MVC2/web) | -
2| [src Folder](https://github.com/tienhuynh-tn/java-web-application-development-prj301/tree/master/MVC2/src/java) | source code
3| [Database File](https://github.com/tienhuynh-tn/java-web-application-development-prj301/blob/master/MVC2/Database-PRJ301-MVC2.sql) | database script
4| [META-INF Folder](https://github.com/tienhuynh-tn/java-web-application-development-prj301/tree/master/MVC2/web/META-INF) | -
5| [WEB-INF Folder](https://github.com/tienhuynh-tn/java-web-application-development-prj301/tree/master/MVC2/web/WEB-INF) | -

## How Can Get Started

- Using NetBeans 8.2 IDE to start project easier
- After open project in IDE, import JSTL 1.2.1 library that support by IDE
- Run the [`Database-PRJ301-MVC2.sql`](https://github.com/tienhuynh-tn/java-web-application-development-prj301/blob/master/MVC2/Database-PRJ301-MVC2.sql) script 
- Replace some database connection imformation in [`context.xml`](https://github.com/tienhuynh-tn/java-web-application-development-prj301/blob/master/MVC2/web/META-INF/context.xml) file

## Learn More
- [Manual Deploying Tomcat Server](https://github.com/tienhuynh-tn/java-web-application-development-prj301/tree/master/Manual%20Deploying%20Tomcat%20Server)

## License & Copyright
&copy; 2021 Tien Huynh tienhuynh-tn Licensed under the [GPL-3.0 LICENSE](https://github.com/tienhuynh-tn/java-web-application-development-prj301/blob/master/LICENSE).

> :love_you_gesture: Feel free to use my repository and star it if you find something interesting :love_you_gesture:
