import { Config } from '@stencil/core';
import { sass } from '@stencil/sass';

export const config: Config = {
  namespace: 'anywhere-webcomponents',
  taskQueue: 'async',
  buildEs5: true,
  extras: {
    cssVarsShim: true,
    dynamicImportShim: true,
    shadowDomShim: true,
    safari10: true,
    scriptDataOpts: true,
    appendChildSlotFix: false,
    cloneNodeFix: false,
    slotChildNodesFix: true,
  },
  outputTargets: [
    {
      type: 'dist',
      esmLoaderPath: '../loader',
    },
    {
      type: 'dist-custom-elements-bundle',
    },
    {
      type: 'docs-readme',
    },
    {
      type: 'www',
      serviceWorker: null, // disable service workers
      copy: [
        {
          src: 'styles.css',
        },
      ],
    },
  ],
  globalStyle: 'src/scss/global.scss',
  plugins: [
    sass({
      injectGlobalPaths: ['src/scss/injected.scss'],
    }),
  ],
  testing: {
    collectCoverage: true,
    /**
     * Gitlab CI doesn't allow sandbox, therefor this parameters must be passed to your Headless Chrome
     * before it can run your tests
     */
    browserArgs: [
      '--no-sandbox',
      '--disable-setuid-sandbox',
      '--disable-extensions',
    ],
  },
};
