# Contribution guide

> This repository use `git flow` (except for release branches, automated via CI). The default branch is `develop` and pull requests should be opened for him.

To contribute for this project:

1. Use `aw-` preffix in all new components;
2. Write unit tests;
3. Doc props and args using TSDoc syntax (read about Stencil for more);
4. Develop and test Storybook (run `npm run storybook` or `yarn storybook`).

> If you need help, be free for [open a information issue](https://github.com/tiagoboeing/anywhere-webcomponents/issues/new) or contact me.

## Start

Fork this repository and make changes. At end open a pull request for here with `develop` branch as target.

Pull request message should contains the following syntax for `auto-changelog` works:

```md
# The number (#ID) is pull request ID auto generated by GitHub

# features, improvements, enhancements...
feature: Commit message (#ID)

# General fixes
fix: Commit message (#ID)

# API changes, breaking changes
break: Commit message (#ID)
```

> Any questions, [start a discussion](https://github.com/tiagoboeing/anywhere-webcomponents/discussions/new).

## Developing

- Clone this repo
- Access the directory and run:

```bash
npm install
npm start
```

To build the component on production mode, run:

```bash
npm run build
```

To run the unit tests for the components, run:

```bash
npm test

# or 

npm run test:watch
```

## Naming Components

When creating new component tags, use the `aw-` preffix.
