# Examples for Java Servlets

After we have learned about [sockets](http://github.com/thomasWeise/distributedComputingExamples/tree/master/sockets/) and [HTML](http://github.com/thomasWeise/distributedComputingExamples/tree/master/html/), we are able to develop nice web pages and we can also send data over the internet using [TCP](https://en.wikipedia.org/wiki/Transmission_Control_Protocol). It may occur to us that a [web server](https://en.wikipedia.org/wiki/Web_server) is actually just sending HTML and stuff over the net, using sockets. The [web browser](https://en.wikipedia.org/wiki/Web_browser) then receives the data and displays it. Of course, they cannot just use TCP for communication, as the web browser must somehow tell the web server which page or which image (hosted on that server) it wants and the web server needs to say whether the request was successful or not and so on. For this, the [hypertext transfer protocol](https://en.wikipedia.org/wiki/Hypertext_Transfer_Protocol) exist. This protocol is sent via TCP and it is text-based. With the stuff we have learned, we can fully implement it. Actually, we already have done some partial, rudimentary implementations of it in the sockets examples set.

Still, doing this by hand is not just cumbersome, we will probably make many mistakes. What we would like to have is an API for HTTP as comfortable as sockets are for TCP and UDP. [Java Servlets](https://en.wikipedia.org/wiki/Java_Servlet) are this kind of thing. A servlet is a sub-class of a special Java class which implements handler methods for different HTTP interactions ("[HTTP methods](https://en.wikipedia.org/wiki/Hypertext_Transfer_Protocol#Request_methods)"). These methods are called by a [servlet container](https://en.wikipedia.org/wiki/Web_container), the actual implementation of the server, which then uses sockets, thread pools, and also takes care of the character encoding for us. We can therefore fully concentrate on the application logic and don't need to worry about the protocol interaction itself.

We can create [forms](https://en.wikipedia.org/wiki/Form_%28HTML%29) with HTML whose contents are sent to the web server (or servlet, in our case). This means that we can send information from a browser to our servlets. This information is provided by the servlet container to our servlet. Our servlet may process, store, and use this information for its purposes. It may dynamically create contents as response. This means that we can now build dynamic web applications. We can build applications that run in a web browser and communicate with our server components and which use [Javascript](https://en.wikipedia.org/wiki/JavaScript) in the browser to create the feeling of "local applications" for the user.

There are many different implementations for java servlet containers. Here we use [GlassFish](https://glassfish.java.net/) and [Jetty](http://www.eclipse.org/jetty/). Other notable containers are [Tomcat](http://tomcat.apache.org/) and [JBoss](http://www.jboss.org/).

Long story short, here you can find my [Java Servlets](https://en.wikipedia.org/wiki/Java_Servlet) examples.

1. [deployable examples](http://github.com/thomasWeise/distributedComputingExamples/tree/master/javaServlets/examples)
2. [HTTP Proxy Servlet](http://github.com/thomasWeise/distributedComputingExamples/tree/master/javaServlets/proxy)

## Licensing

This work has purely educational purposes. Besides everything mentioned below, for anything in this repository and projects, I impose one additional licensing condition: The code must never be used for anything which might violate the laws of Germany, China, or the USA. This also holds for any other file or resource provided here.

The examples in this repository are licensed under the [GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007](http://github.com/thomasWeise/distributedComputingExamples/tree/master/LICENSE), with the exception of everything in the directories [/javaServerPages/standAloneJSPsWithJetty](http://github.com/thomasWeise/distributedComputingExamples/tree/master/javaServerPages/standAloneJSPsWithJetty) and [/javaServlets/proxy](http://github.com/thomasWeise/distributedComputingExamples/tree/master/javaServlets/proxy), which re licensed under the [Apache License v2.0](http://www.opensource.org/licenses/apache2.0.php) and are partially derived from project [embedded-jetty-jsp](https://github.com/jetty-project/embedded-jetty-jsp) with copyright (c) 1995-2013 Mort Bay Consulting Pty. Ltd.
