import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl90 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={1719}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 99 74"
      {...props}
    >
      <path
        d="M81 35v-7 7zm0-7zm0 7v-1 1zM16 19l-2 5v9L6 43v2H5c0 1 0 1 1 1v-3l8-10v-9l2-5V9l1-5V0v4l-1 5v10zM6 45v1s-1 0-1-1h1zm76-8v-8 8zm0-8zm0 8zM1 45v-2l8-10v-9l2-5V9l2-5V0v4l-2 5v10l-2 5v9L1 43v2zm0 0zM50 2h-8l-5 5h-3 3l5-5h8zM34 7zm16-5zM10 71h1-1v2l1 1-1-1v-2zm0 0zm52 1v2-2zm0 0zm16-57v-4 4zm0-3v-1 1zm0 3zM50 1H36l-1 2h-2V2v1h2l1-2h14zM33 3V2v1zm17-2zM10 63c-1 0-1 1-1 1h1v-5l4-6v-2h1-1v2l-4 6v4zm4-12zm-4 13zm5-45-2 5v9L5 43v3-3l8-10v-9l2-5V9l2-5V0v4l-2 5v10zM5 46zm10-27-2 5v9L5 43v2H4c0 1 0 1 1 1v-3l8-10v-9l2-5V9l1-5V0v4l-1 5v10zM5 45v1s-1 0-1-1h1zm11 23v-8l2-3v-9l1-2V36h1-1v10l-1 2v9l-2 2v9zm3-32h1-1zm-3 32zm-3-49-2 5v9L3 43v16-16l8-10v-9l3-5V9l1-5V0v4l-2 5v10zM3 59v-1 1zM1 45v-2l8-10v-9l2-5V9l1-5V0v4l-1 5v10l-2 5v9L0 43v2c0 1 0 1 1 1v-1zm0 1c-1 0-1 0-1-1h1v1zm10 13 4-6v-5l2-2v-8 8l-2 2v5l-4 6v7l-1 2v2H9l1 1v-3l1-2v-7zm6-21v1-1zm-7 32v1-1zm70-29h-1l1 1v-1h9l1-1v-9 9l-1 1h-9zm0 0zm10-10v1-1zM75 17h-6v1-1h6l1-1v-4h1c0-1 0-1-1-1v5l-1 1zm-6 1v-1 1zm7-6v-1s1 0 1 1h-1zm15 19h-1 1v6l1 1h3c0-1 0-1-1-1v1h-2l-1-1v-6zm3 6 1 1h-1v-1zm-3-6h-1 1zM15 53v-2l-1 1h1v1l-5 6v6l1-1h-1v-5l5-6zm0-1v-1 1zm-5 12zm6-16v9l-2 2v10l1-1h-1v-8l2-3v-9l2-2v-8 8l-2 2zm-2 20zm4-30v1-1zm61-22c1 0 1 0 1-1v-3h-1v4zm0-4h1-1zm0 3h1c0 1 0 1-1 1v-1zm3-8H53h29l13 8h4-4L82 7zM53 7zm30 5h-1v4c1 0 1 0 1-1v-3zm0 3c0 1 0 1-1 1v-1h1zm-1-3h1-1zm-1 0h-1v4c1 0 1 0 1-1v-3zm0 3c0 1 0 1-1 1v-1h1zm-1-3h1-1zm-1 3v-4 4zm0-3v-1 1zm0 3zm-59 8h-1v10l-8 10v4l3 3-3-3v-4l9-10V23zm-6 27zm5-27h1-1zm65-13H72h12zm-12 0zm12 0zM15 68v-8l2-3v-9l1-2v-8h1-1v8l-1 2v9l-2 2v8c0 1-1 1-1 1h1zm3-30h1-1zm-3 30zm65-53v-4 4zm0-3v-1 1zm0 3zm1-7h-9l-4 3v3l1 1v-4l3-2h9V8zm-12 6zm12-5zM10 43v4l2 2v1l1-1h-1l-2-2v-4l9-10v-9h-1v9l-8 10zm2 6zm6-25zm-4 27c0-1-1-1-1-1v4h1c0-1-1-1-1-1v-2h1zm-1 3v-1 1zm0-3v-1 1zm-3-2v2l2 1v1s-1 0-1 1h1v-2l-2-1v-2h1-1zm2 5v-1 1zm-2-5zm2 2h1v3h-1 1v-3h-1zm1 3zm0-3zm4-32-2 5v9L7 43v3-3l8-10v-9l2-5V9l2-5V0v4l-2 5v10zM7 46zm11-27-2 5v9L8 43v2H7c0 1 0 1 1 1v-3l8-10v-9l2-5V9l1-5V0v4l-1 5v10zM8 45v1s-1 0-1-1h1zm70-29c1 0 1 0 1-1h-1v-3h1-1v4zm0-4h1-1zm0 3h1c0 1 0 1-1 1v-1zm4 5H59l-9-8v-2h1c0-1 0-1-1-1v3l9 8h24l6-3h10-10l-7 3zM50 10V9c1 0 1 0 1 1h-1zm-33 9-2 5v9L7 43v2H6c0 1 0 1 1 1v-3l8-10v-9l2-5V9l1-5V0v4l-1 5v10zM7 45v1s-1 0-1-1h1zm9-26-2 5v9L6 43v3-3l8-10v-9l2-5V9l2-5V0v4l-2 5v10zM6 46zm71-31v1c1 0 1 0 1-1h-1v-3h1-1v3zm0-3h1-1zm0 3h1c0 1-1 1-1 1v-1zM16 46v-7 7zm0-6zm0 6zm2-27-2 5v9L8 43v3-3l8-10v-9l2-5V9l2-5V0v4l-2 5v10zM8 46zm45-36v2l6 6h6l2-2V8h1-1v8l-2 2h-6l-6-6v-2zm14-2zm-14 3v-1 1zM15 69l1-1h-1v-8l2-3v-9l2-2V36v10l-2 2v9l-2 2v10zm4-33v1-1zm-4 32zm4-49-2 5v9L9 43v3h1-1v-3l8-10v-9l2-5V9l2-5V0v4l-2 5v10zM9 46zM53 7V1h-1v6h1zM19 19l-2 5v9L9 43v2H8c0 1 1 1 1 1v-3l8-10v-9l2-5V9l1-5V0v4l-1 5v10zM9 45v1-1zM49 7c-1 0-1 0-1 1h-6l-2 2v7h1-1v-7l2-2h7V7zm-9 10zm9-9h-1 1zm0 1V8c-1 0-1 0-1 1h-6l-1 1v7h1-1v-7l1-1h7zm-8 8zm8-8h-1 1zM23 62V48l2-2V32l1-2v-6l-3-5v-5l-2-2V7v5l1 2v5l4 5v5l-2 3v14l-1 2v15-1zM21 8V7v1zm2 54zm1 1h1v-9h-1v9zm0-9h1s0 1-1 1v-1zm0 8c1 0 1 0 1 1h-1v-1zm25-48v6l2 2v12-12l-2-2v-6zm2 19zm-2-19zM25 61h1v-7l-2-2v-4 4l1 2v7zm0 0h1-1zm-1-13zm-3-16 2-2v-6 5l-2 3v14l-1 2v9l-2 2v9-8l2-3v-9l1-2V32zm2-8zm-5 44zm23-50h-1 1v6h-1 1v-6zm0 6zm0-6zM26 32h-1v14h1V32zm-1 14h1-1zm0-14h1-1zM12 67h-1 1v4h-1 1v-4zm0 4zm0-4zm28-42h1c0-1-1-1-1-1v-5h1l-1-1v7zm0-6v-1 1zm0 5v1-1zM19 63v1c1 0 1-1 1-1h-1v-4h1s0-1-1-1v5zm0-4h1-1zm0 4h1-1zM42 8h6-6l-1 2v6h-1c0 1 1 1 1 1v-7l1-2zm6 0zm-7 8v1-1zm8-4h-1v7l-2 3v7-7l2-3v-7h1zm-3 17zm2-17h1-1zM28 43v1c0 1 0 1 1 1v-2l-1-1v-7h-1v7l1 1zm1 1v1c-1 0-1 0-1-1h1zm-2-9h1v1c-1 0-1 0-1-1zm16-6v-7l2-3v-7h1-1v7l-2 3v6l-1 1h1zm2-17h1-1zm-2 17zm-1 0h1-1v-7l3-3v-7 7l-3 3v7zm3-16v-1 1zm-3 16zm-8 17V32l-3-3v-5l-4-5v-5l-1-2V7h-1v5l2 2v5l3 5v6l4 2v14l-1 2v7c-1 0-1 0-1 1h1v-8l1-2zM25 7h1-1zm8 49h-1c0-1 1-1 1-1v1zm3-3c-1 0-1 1-1 1h1v3l-2 2v8-8l2-2v-4zm-2 14zm2-13h-1 1zm7-25h1-1v-7l3-3v-7 7l-3 3v7zm3-16v-1 1zm-3 16zm1-16v-1s-1 0-1 1h1v4s-1 0-1 1h1v-5zm0 5v-1 1zm0-5v-1 1zM26 35v6h1v-6l2-1v-2h-1v2l-2 1zm1 6h-1 1zm1-9h1-1zm-1 12v-1 9-8zm0 8zm0-8v-1 1zm15-26h1v-6s-1 0-1 1h1v4s-1 0-1 1zm1-5v-1 1zm0 4v1-1zm-20 2 3 5v6l4 2v14l-2 2v8h1v-8l1-2V32l-3-3v-5l-4-5v-5l-2-2V0v12l2 2v5zm6 37h-1c0-1 0-1 1-1v1zm13-28-1 1h1v-7l2-3v-7h1-1v7l-2 3v6zm2-16zm-2 17zm1-17v5h1-1v-5h1-1zm0 5zm0-5zm1 17v-7l2-3v-7h1-1v7l-2 3v6l-1 1h1zm2-17h1-1zm-2 17zm16-7v15l3 3h2-2l-3-3V22zm5 18zm-5-17zm5 15c0 1 1 1 1 1v-4h-1 1v3h-1zm1-3zm0 3v1-1zm-6-15s0 1 1 1v13l2 3h3s0-1-1-1v1h-2l-2-3V23h-1zm5 16 1 1h-1v-1zm-4-16h-1 1zm3 0v3-4 1zm0 3v-1 1zm0-3zM16 48l1-2v-8h1-1v8l-1 2v5l-5 6v7l-1 2v2h1-1v-2l1-2v-7l5-6v-5zm1-10h1-1zm-7 32zm55-48h-1l1 1v2h-1 1v-3zm0 3h-1 1zm0-3h-1 1zm-2 0h-1l1 1v2h-1 1v-3zm0 3h-1 1zm0-3h-1 1zm-1 0h-1l1 1v2h-1 1v-3zm0 3h-1 1zm0-3h-1 1zm2 0h-1l1 1v2h-1 1v-3zm0 3h-1 1zm0-3h-1 1zm-2 1v3-4 1zm0 3v-1 1zm0-3zm3 3v5l3 3h4v-1 1h-4l-3-3v-5zm7 7v1-1zm-7-7zm-2-3v3-4 1zm0 3v-1 1zm0-3zm-2 0v14l2 2h2-2l-2-2V22v1zm4 16zm-4-16zm-2 0s0 1 1 1v13l3 4h3s0-1-1-1v1h-2l-3-4V23h-1zm6 18h1-1zm-5-18h-1 1zm-5 0v4l2 2v2-3l-2-2v-3zm2 7zm-2-7zm-4-8c0-1 0-1-1-1v6l2 2v11h1V22l-3-2v-5h1zm2 18h-1 1zm-3-18v-1c1 0 1 1 1 1h-1zm9 28h7s0-1-1-1v1h-6v-1 1zm6 0h1-1zm-6 0zM49 15v5l2 2v11h1V22l-3-2v-5h1c0-1 0-1-1-1v1zm3 18h-1 1zm-2-18h-1v-1c1 0 1 1 1 1zM2 45v-2l8-10v-9l2-5V9l1-5V0v4l-1 5v10l-2 5v9L1 43v2c0 1 0 1 1 1v-1zm0 1c-1 0-1 0-1-1h1v1zm48-32v6l2 2v12-12l-2-2v-6zm2 19zm-2-19zm7 9v-1 5l2 2v8l4 4h2v1-1h-2l-4-4v-9l-2-2v-3zm8 18zm-8-18zm-1-1c-1 0-1 1-1 1v4l2 2v2h1v-3l-2-2v-4zm2 9h-1 1zm-2-8h-1 1zm9 19h-6v1c1 0 1-1 1-1h5v1-1zm-5 0h-1 1zm5 0zM52 16h-1v4l2 2h1c0 1 1 1 1 1v-1h-1l-2-2v-4zm2 6h1v1s-1 0-1-1zm-3-6h1-1zm5 7v4l2 2v2-3l-2-2v-3zm2 7zm-2-7zm26 3h-2l-1 1v11h1V26h3l6-3h10-10l-7 3zm-2 12h-1 1zm10-12h-3 3l3 3h6-6l-3-3zm-2 0h-1 1zm7 0h-4v1h4l2 1h2v-1h-2l-2-1zm-4 1v-1 1zm-3-2v1h11v-1H88zm0 0v1-1zM32 3h3l1-1h14V1c-1 0-1 0-1 1H36l-1 1h-3zm18-2v1h-1c0-1 0-1 1-1zM32 3h1-1zm58 23h-2v1h2l3 3h6v-1h-6l-3-3zm-2 0v1-1zM32 1h3l1-1-1 1h-3zm0 0h1-1zm50 25h-2v13-12h3l6-3h10v-1H89l-7 3zm-2 12v1-1zM26 12l2 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l2 3v5zm12 40zm57-27h-8 8l2-1h2-2l-2 1zm-7 0h-1 1zM32 2h3l1-1h14V0H36l-1 2h-3zm18-2v1h-1c0-1 0-1 1-1zM32 2h1-1zm58 25h-3 3l3 3h6-6l-3-3zm-2 0h-1 1zm-5 5v2-1l1-2v-3 3l-1 1zm0 2zm1-6v1-1zM34 9h3l5-5h8V3c-1 0-1 0-1 1h-7l-5 5h-2c0-1 0-1-1-1v1zm16-6v1h-1s0-1 1-1zM34 9h1-1zm16-5h-8l-5 5h-3v1-1h3l5-5h8zM34 9zm16-5zm37 25v6l-2 2v2-2l2-2v-6zm-2 9v1-1zm2-9zm-4 8v1h1v-1l2-2v-7h-1v7l-2 2zm1 1h-1 1zm1-10h1v1c-1 0-1-1-1-1zM50 3h-8l-5 5h-3 3l5-5h8zM34 8zm16-5zM34 8h3l5-5h8V2c-1 0-1 0-1 1h-7l-5 5h-2c0-1 0-1-1-1v1zm16-6v1h-1s0-1 1-1zM34 8h1-1zm52 21v6l-2 2v2-2l2-2v-6zm-2 9v1-1zm2-9zM34 10h3l5-5h8V4c-1 0-1 0-1 1h-7l-5 5h-2s0-1-1-1v1zm16-6v1h-1s0-1 1-1zm-16 6h1-1zm56 17h-2v1h2l3 3h6v-1h-6l-3-3zm-2 0v1-1zM34 11h3l5-5h8V5c-1 0-1 0-1 1h-7l-5 5h-2s0-1-1-1v1zm16-6v1h-1s0-1 1-1zm-16 6h1-1zm56 17h-3 3l3 3h6-6l-3-3zm-2 0h-1 1zM50 5h-8l-5 5h-3v1-1h3l5-5h8zm-16 5zm16-5zm37 23h-1v7l-2 2v1h1v-1l2-2v-7zm-2 10h-1 1zm2-9c-1 0-1-1-1-1h1v1zm-5-4h-2l-1 2v11h-1c0 1 1 1 1 1V27l1-1h2l6-3h11v-1H88l-6 3zm-3 13v1-1zm-22-1-5-3h-5l-8-5v-2h-1l1 1v2l8 4h5l5 3v7l-5 8v7h1v-7l4-8v-7zM39 27zm14 32h-1v-1c1 0 1 1 1 1zm29-34h-5l-1 1v7-7l1-1h6l6-3h10-10l-7 3zm-6 8zM48 60h1s0-1-1-1v-5l-1-1h-1 1l1 1v6zm-2-7zm2 6 1 1h-1v-1zm-2-29h1l1-1v-5c1 0 1-1 1-1h-1v6l-1 1h-2 1zm2-7h1-1zm-2 7h-1 1zm4-23h-8l-5 5h-1v1-1h1l5-5h8zm0 0zm-14 5zm18 40h-1v7h1v-7zm0 7h-1v-1c1 0 1 1 1 1zm-1-7h1-1zM33 12l2 2v5l3 5v6l8 4v10l-1 2v6-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zm-6-17h-1v3l1 1v3s1 0 1-1h-1v-2l-1-1v-3h1zm0 6v1-1zm-1-6zm7-6h1-1v-7l3-3v-7 7l-3 3v7zm3-16v-1 1zm-3 16h1-1zm0 0v-7l2-3v-7h1-1v7l-2 3v7zm2-17h1-1zm-2 17zm-1 0h1-1v-7l3-3v-7 7l-3 3v7zm3-16v-1 1zm-3 16zm20 23v-2l-1-2v-3c-1 0-1 0-1 1h1v2l1 2v2zm-1-6h-1c0-1 1-1 1-1v1zm1 5v1-1zm-17 3s0-1-1-1v9h1s0-1-1-1v-7h1zm0 8h-1 1zm-1-8h1-1zm4-14-1-1v-1s0-1-1-1v2l1 1v4h1v-4zm-2-2h1-1zm1 6h1-1zM39 14h-1 1v5h-1 1v-5zm0 5zm0-5zm3-7h8V6c-1 0-1 0-1 1h-7l-5 5h-2s0-1-1-1v1h3l5-5zm8-1v1h-1s0-1 1-1zm-16 6h1-1zm48 11h-5l-3 3v7-7l3-3h6l6-3h10-10l-7 3zm-8 10zm8-10h-5l-3 3v7c1 0 1-1 1-1h-1v-6l3-2h6l6-4h10-10l-7 3zm-7 9h-1 1zM50 6h-8l-5 5h-3v1-1h3l5-5h8zm-16 5zm16-5zm32 18h-5l-2 2v7c1 0 1-1 1-1h-1v-6l2-1h6l6-4h10-10l-7 3zm-6 8h-1 1zm6-8h-5l-2 2v7-7l2-2h6l6-3h10-10l-7 3zm-7 9zM65 51v-1l-1-2v-3h-1 1v3l1 2v1zm-2-6h1-1zm2 6zm1 1h1c0-1-1-1-1-1v-1l-1-2v-3s-1 0-1 1h1v2l1 2v2zm-1-6h-1c0-1 1-1 1-1v1zm1 5v1-1zm1 3h1c0-1-1-1-1-1v-3l-1-2v-4h-1 1v4l1 2v4zm-1-10zm1 9v1-1zM38 17v-3h1c0-1-1-1-1-1v4l-1 2v1h-1 1v-1l1-2zm0-3v-1 1zm-1 6h-1 1zm31 24h-1 1v4l1 2v4h1c0-1-1-1-1-1v-3l-1-2v-4zm1 10v-1 1zm-1-10zm-2-2s0-1-1-1v1h-6v-1 1h7zm-7 0zm6 0h1-1zm30 20v1h4v-1h-4zm0 1v-1 1zm-9 0h8-9 1zm7 0h1-1zm-8 0h1-1zm9-1h-9v1h9l2 1h3-3l-2-2zm-9 1v-1 1zm-1-1H71v1h12l4 2h12v-1H87l-3-2zm-13 1v-1 1zm13 0H71v1h12l4 2h12v-1H87l-3-2zm-13 1v-1 1zm13-1H70h13l4 2h12-12l-3-2zm-13 0h-1 1zm-10 2h-8s-1 0-1 1h9l10-5h28-28l-10 4zm-8 1v-1 1zm8 1h-8v-1s-1 0-1 1h9l10-5h28-28l-10 5zm-8 0v-1 1zm8-3h-8 8l10-4h28v-1H71l-10 5zm-8 0zm8 1h-8 8l10-4h28v-1H71l-10 5zm-8 0zm8-1h-8s-1 0-1 1h9l10-5h28-28l-10 4zm-8 1v-1 1zm31-1H70h13l4 2h12-12l-3-2zm-13 0h-1 1zm-10 2h-8 8l10-4h28v-1H71l-10 5zm-8 0zm19 1H53h19l4 2h23-23l-4-2zm-19 0zm19 2H53v-1s-1 0-1 1h20l4 2h23-23l-4-2zm-19 0v-1 1zm19-1H53h19l4 2h23-23l-4-2zm-19 0zm39 4v-1 1h5l2 1v1-1l-2-1h-5zm0 0v-1 1zm-1-5h-4l-3-3H71v1h12l4 2h4l2 1h6-6l-2-1zm-20-2v-1 1zm1 3H53v-1s-1 0-1 1h20l4 2h23-23l-4-2zm-19 0v-1 1zm44 4h-1c0 1 1 1 1 1v1h-1 1v-2zm0 1v-1 1zM61 63h-8s-1 0-1 1h9l10-5h28-28l-10 4zm-8 1v-1 1zm38 4c0-1-1-1-1-1v1h-3l-3-2h-6 6l3 2h4zm-12-2zm11 2v-1 1zm1-1h-4l-3-2H68h15l4 2h4l2 1h6-6l-2-1zm-23-2zm15 0H72l-2 2h-6c0-1 0-1-1-1v1h7l2-1h11v-1zm-19 2h-1v-1c1 0 1 0 1 1zm19-1v-1 1zm6 2h1-3l-3-1h-5l-1-1v1h6l3 1h2zm1 0zm-12-1v-1 1zm6 0h-3l-1 1h-5 5l1-1h3zm-8 1zm8-1zM72 45v-1 1zm-1 6h1c0-1-1-1-1-1v1zm0-3h1c0-1-1-1-1-1v1zm0 4 1-1h-1v1zm0-2h1-1zm0-1 1-1h-1v1zm0 0h1-1zm0 3h1-1zm1-6v-1 1zm0 0zm-1 7h1-1zm1-6zm0-3v-1 1zM61 63h-8 8l10-4h28v-1H71l-10 5zm-8 0zm8-2h-8 8l10-4h28v-1H71l-10 5zm-8 0zm8 0h-8s-1 0-1 1h9l10-5h28-28l-10 4zm-8 1v-1 1zm8-2h-9c0 1 1 1 1 1h8l10-5h28-28l-10 4zm-8 1v-1 1zm8 1h-8 8l10-4h28v-1H71l-10 5zm-8 0zm8-2h-8 8l10-5h28-28l-10 5zm-8 0zm8 2h-8s-1 0-1 1h9l10-5h28-28l-10 4zm-8 1v-1 1zm18-17 1-1h-1v1zm0 0h1-1zm0 1h1-1zm0-3h1l-1-1v1zm0 1s1 0 1-1h-1v1zM61 59h-9c0 1 1 1 1 1h8l10-5h28-28l-10 4zm-8 1v-1 1zm-5 6h1-1v2l1 1v5-5l-1-1v-2zm0 0h1-1zm-7-13v21-20h1l-1-1zm0 1zm2 7v-8h-1 1v9l3 3v9-9l-3-4zm0-8zm0 19v2-1c1 0 1 0 1-1h-1zm0 1v-1 1zm-1-19h1l-1-1v9l3 3v9-9l-3-4v-7zm0 0zm2 11h-1c0 1 1 1 1 1v5l-2 1v2-2l2-1v-6zm0 1v-1 1zm-1 5h-1v-7h1-1v7h1zm-1-7zm0 7zm0-10v-8h-1 1v9l3 3v9-9l-3-4zm0-8zm3 0v9l3 3v9-9l-3-4v-8zm0 0zm27-5v-1 1zM50 69v5-4c1 0 1 0 1-1h-1zm0 1v-1h1c0 1 0 1-1 1zm-7-16h1l-1-1v9l3 3v9-9l-3-4v-7zm0 0zm1-1h-1 1v9l3 3v9-9l-3-4v-8zm0 0zm0 8v-7h1l-1-1v9l3 3v9-9l-3-4zm0-7zm-4-1v21-20h1l-1-1zm0 1zm-7 14V57h-1s0 1 1 1v10l3 4v2-2l-3-4zm0-11h-1 1zm8-4h-1 1v21-21zm0 0zm-9 4v-1 12l3 4v2-2l-3-4V57zm0 0zm-1 0v-1 12l3 4v2-2l-3-4V57zm0 0zm1 11V57h-1s0 1 1 1v10l3 4v2-2l-3-4zm0-11h-1 1zm19 12v5-5zm0 0zM40 53h-1 1v21-21zm0 0zm-1 0h-1 1v21-21zm0 0zm-1 0v21-20h1l-1-1zm0 1zm1-1v21-20h1l-1-1zm0 1zm29 17h6l-1-1h-5l-2 1h-2v1h2l2-1zm5 0zm-9 1zm-4-2v-1h-5l-2 3v2h1v-2l2-2h4zm0 0zm-5 3h3l1 1-1-1h-3zm0 0zm6-2h-5c-1 0-1 1-1 1h6v-1zm-5 1h-1 1zm5 0h-1 1zm-1 0v2-2zm0 1v-1 1zm11-3h1c0-1-1-1-1-1h-9c-1 0-1 0-1 1h10zm0 0zm-10 0h1-1zm2 2-1-2h-6v1h6l1 1v1-1zm-7-1zm7 2zm5 0h-2l-1 1 1-1h3-1zm0 0h1-1zm-17-4v5h1v-5h-1zm0 1v-1h1c0 1 0 1-1 1zm36 3h-9l-2-2h-8v1h8l2 1h9zm-19-1zm19 1h-1 1zm8 0h-4l-3-2h-9v1h9l3 1h4zm-16-1zm16 1zm-20 0zm-1 0zm-22-4v5-5zm0 0zm0 0v5h1v-5h-1zm0 1v-1h1c0 1 0 1-1 1zm21 3h-1 1zm-3 0h1-1zm1 0zm1 0zm-2 0h-1 1zm3 0h1-1zm5-22h-4 4l1-1h20-20l-1 1zm-4 0zm22 1c1 0 1-1 1-1h-1v1zm0-1h1c0-1 0-1-1-1v1zm0 1h1-1zm0 0h-1 1zm2 0zm-2 1h-1 1zm2-2v-1 1zm-1 1v-1 1zm-1-1v-1s-1 0-1 1h1zm1 2zm1-1v-1 1zm-1 0zm0-1v-1 1zm-1 2h1-1zm-3-1h1-1zm0 1h1-1zm1-1v-1 1zm0-1v-1 1zm-1 0h1c0-1 0-1-1-1v1zm0 1c1 0 1-1 1-1h-1v1zm2 0zm1 0v-1h-1l1 1zm-1 1zm-2 0h-1 1zm2-1v-1 1zm-1 0zm0 1zm1-2v-1 1zm3-14v4l-4 3H79l-5-5v-5 5l5 5h15l4-3v-4l1-1-1 1zm-24-3v1-1zm23 3v4l-3 3H79l-5-5v-5h1-1v5l5 5h15l3-3v-4l2-1-2 1zm-23-3h1-1zm22-1v8l-2 2H79l-4-4v-5h1-1v5l4 4h15l2-2v-8l1-1h2-2l-1 1zm-21 1h1-1zm22-1v8l-3 2H79l-4-4v-5 5l4 4h15l3-2v-8h2v-1h-2v1zm-22 1v1-1zm23 19zm-4-8H79l-6-5h-4v-1c-1 0-1 1-1 1h5l6 5h15l4-4h1-1l-4 4zm-25-5h-1s0-1 1-1v1zm13-21H59l-7-7V8c0-1 0-1-1-1v5l8 7h24l6-3h10-10l-7 3zM51 8V7c1 0 1 0 1 1h-1zm31 10H59l-6-6V8c0-1 0-1-1-1v5l7 6h24l6-3h10-10l-7 3zM52 8V7c1 0 1 0 1 1h-1zm44 25v8l-2 1H79l-3-3v-5 5l3 3h15l2-1v-8l1-1h2v-1h-2l-1 2zm-20 1v1-1zm6-15H59l-7-7V8v4l7 7h24l6-3h10-10l-7 3zM52 8zm30 12H59l-8-8V8v4l8 8h24l6-3h10-10l-7 3zM51 8zm43 38H79l-6-6h-5 5l6 6h15l4-4h1-1l-4 4zm-26-6zm26 5H79l-6-6h-5 5l6 6h15l4-4h1-1l-4 4zm-26-6zm26 7H79l-6-5h-4v-1c-1 0-1 1-1 1h5l6 5h15l4-4h1-1l-4 4zm-25-5h-1 1zM31 58v-1h-1v11l4 4v2-2l-3-4V58zm0-1h-1 1zm43-8h1-1v-3h1c0-1 0-1-1-1v4zm0-3v-1s1 0 1 1h-1zm0 3h1-1zm20-2H79l-6-6h-5v1-1h5l6 6h15l4-4h1-1l-4 4zm-26-6zm6 9h4-4zm4 0zm-4 0zm23-3H79l-6-5h-4v-1c-1 0-1 1-1 1h5l6 5h18l1 1h1-1l-1-1zm-28-5h-1 1zm28 6H79l-6-6h-5v1-1h5l6 6h18l1 1h1-1l-1-1zm-29-6zm29 6H79l-6-5h-4v-1c-1 0-1 1-1 1h5l6 5h18l1 1h1-1l-1-1zm-28-5h-1 1zm19 9v-1 1zm-15-1v-1 1zm0 2zm0-1zM16 69l1-1h-1v-8l2-3v-9l2-2V36v10l-2 2v9l-2 2v10zm4-33v1-1zm-4 32h1-1zm57-18zm0-1zm0 3v-1 1zm14-1h1c0-1-1-1-1-1v1zm-6 2h4-4zm0 0h1-1zm4 0zm2-1h1-1zm0 0 1-1h-1v1zm0 2h12-12zm0 0zm-9-1h-3 3l2 1h6-5l-3-1zm-3 0zm11 1h-1 1zm-13-8zm-1 5v-1 1zm0 1v-1 1zm0 0zm1-4v-1 1zm20 4h-1 1zm-21-3zm0 1zm1-5v-1 1zm14 8h1-1zm-14-6zm0-1v-1 1zm0-2v-1 1zm-1 9zm19-1v-1 1zm0 1zm0-1zm-1-1h1c0-1 0-1-1-1v1zm0 1h1-1zm0 1h1-1zm1-2v-1 1zm2 1v-1h-1l1 1zm-1 0v-1 1zm-20-3v-1 1zm20 4zm0-1zm0-1v-1 1zm1 0v-1s-1 0-1 1h1zm-5 2zm1-1v-1 1zm0 0zm1 0c1 0 1-1 1-1h-1v1zm-2 0zm0-1v-1 1zm1 0v-1 1zm1 1h-1 1zm0 1h-1 1zm-1 0zm1-2v-1c-1 0-1 0-1 1h1zm0 1v-1h-1s0 1 1 1zm-17-3v-1 1zM37 60h1-1zm0 3v1c1 0 1-1 1-1h-1zm0-5v1h1s0-1-1-1zm0 3h1-1zm0 1h1-1zm0 0v1h1c0-1 0-1-1-1zm0-3v1c1 0 1 0 1-1h-1zm0-9v1h1c0-1 0-1-1-1zm0 8h1-1zm0-7v1c1 0 1-1 1-1h-1zm0 4v1h1s0-1-1-1zm0 1v1c1 0 1 0 1-1h-1zm0 1h1-1zm0-2h1-1zm0 16v1h1s0-1-1-1zm0 0h1-1zm0-2v1c1 0 1 0 1-1h-1zm0-5h1-1zm0 8v1c1 0 1 0 1-1h-1zm0 1h1-1zm0-3h1-1zm0-5v1h1c0-1 0-1-1-1zm0 1v1c1 0 1-1 1-1h-1zm0-1h1-1zm-7 3V56v12l3 4v2-2l-3-4zm0-11zm7 11h1-1zm0 0v1h1c0-1 0-1-1-1zm15-19v-1 11-10zm0 10zm0-10v-1 1zM32 12l2 2v5l3 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zM33 12l1 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l3 3v5zm11 40zm8-17h-3l-2 2v9l1 1v5h1v-5l-1-1v-9l2-2h2zm0 0zm-4 17h1-1zM32 12l1 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l3 3v5zm11 40zM31 12l2 2v5l3 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zm6-16h5-5zm4 0h1-1zm-4 0h1-1zM30 12l2 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l2 3v5zm12 40zm-5-8v-7l-1-1v-2 2l1 1v7zm-1-9v-1 1zm1 9zm16-5h3v-1s-1 0-1 1h-3v6h1v-6zm3-1v1-1zm-3 7h-1 1zm-2 4v10-11 1zm0 10zm0-10v-1 1zm-3-8v5c1 0 1-1 1-1v-4h-1zm0 0h1-1zm0 4h1-1zm7-8h-6 6zm0 0zm-5 0zm-2 10h-1v5c1 0 1-1 1-1v-4zm-1 4zm0-4zm-10 0h1-1zm0 3h1-1zM27 12l1 2v5l4 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zm-2-6h1-1zm0 1v1h1c0-1 0-1-1-1zm0 1v1c1 0 1-1 1-1h-1zm0 1h1-1zm-8-37 1 2v5l4 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zM30 12l2 2v5l3 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zM27 12l2 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l2 3v5zm12 40zM29 12l2 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l2 3v5zm12 40zM28 12l2 2v5l4 5v6l8 4v10l-2 2v6h1-1v-6l2-2V34l-8-5v-5l-4-5v-5l-1-2V7l-3-3V0v4l2 3v5zm12 40zM28 12l1 2v5l4 5v6l8 4v10l-1 2v5s-1 0-1 1h1v-6l1-2V34l-8-5v-5l-3-5v-5l-2-2V7l-2-3V0h-1v4l3 3v5zm12 40v-1 1zm-3-5h-1 1zm-3 1h-1 1v3c-1 0-1 0-1 1h1v-4zm0 4h-1c0-1 1-1 1-1v1zm0-4h-1 1zm0 15h-1 1v5h-1s0 1 1 1v-6zm0 5h-1 1zm0-5h-1 1zm1-14v2l-1 2v8c-1 0-1 1-1 1h1v-9l1-2v-2zm-1 13h-1 1zm1-13zm-3 6v-7l2-2V32l-4-3v-5l-3-5v-5l-2-2V6v6l1 2v5l4 5v6l4 2v14l-2 2v7zM25 7V6v1zm7 48zM24 7v5l1 2v5l4 5v6l4 2v14l-2 2v7-7l2-2V32l-4-3v-5l-3-5v-5l-2-2V6v1zm7 48zM24 6v1-1zm8 42v7c-1 0-1 0-1 1h1v-8l1-2V32l-3-3v-5l-4-5v-5l-1-2V7h-1v5l2 2v5l3 5v6l4 2v14l-1 2zm0 8h-1c0-1 0-1 1-1v1zM24 7h1-1zm12 32v5l-1 1v1-1l1-1v-5zm-1 7zm1-7zm-1 4V33v10zm0-10zm0 10zm2 27h-1 1zm0 1-1 1h1v-1zm0 0h-1 1zm0-2h-1c0 1 1 1 1 1v-1zm0 3h-1c0 1 1 1 1 1v-1zm0 1h-1 1zM22 32v14l-2 2v15h1s0-1-1-1V48l2-2V32l2-2v-6l-4-5v-5 5l3 5v5l-1 3zm-1 31h-1 1zm-1-49zm-1 43v-9l2-2V32l2-2v-6s0-1-1-1v6l-1 3v14l-2 2v9l-2 2v10c1 0 1-1 1-1h-1v-8l2-3zm3-33h1-1zm-4 44h-1 1zm3-6V48l2-2V32l1-2v-6l-4-5v-5h1c0-1 0-1-1-1v6l4 5v5l-2 3v14l-1 2v15-1zm-1-48v-1s1 0 1 1h-1zm1 48zm-1-33h1v-7h-1v7zm0 0h1-1zm0-7h1-1zm-3 46v-8l2-3v-9l1-2V32l2-2v-6 5l-2 3v14l-1 2v9l-2 2v9zm5-44zm-5 44zm4-5h1s0-1-1-1V48l2-2V32l2-2v-6l-4-5v-5 5l3 5v5l-1 3v14l-2 2v15zm0-49zm0 49h1-1zm3-44 3 5v6l4 2v14l-2 2v8h1v-8l1-2V32l-3-3v-5l-4-5v-5l-1-2V0h-1v12l2 2v5zm6 37h-1c0-1 0-1 1-1v1zm-8 6V48l2-2V32l1-2v-6l-4-5v-5l-1-2V9v3l1 2v5l4 5v5l-2 3v14l-1 2v15-1zm-2-52V9v1zm2 52zm1-55v5l2 2v5l3 5v6l4 2v14l-2 2v8h1v-8l1-2V32l-3-3v-5l-4-5v-5l-1-2V7h-1zm8 49h-1c0-1 0-1 1-1v1zM23 7h1-1zm1 12 4 5v6l4 2v14l-2 2v7-7l2-2V32l-4-3v-5l-3-5v-5l-2-2V0v12l1 2v5zm6 36zm7-9h-1 1zM21 8h-1v4l2 2v5l3 5v5l-1 3v14l-2 2v15h1V48l1-2V32l2-2v-6l-4-5v-5l-2-2V8h1zm2 55h-1 1zM20 8h1-1zm3 11 4 5v6l3 2v14l-1 2v7-7l2-2V32l-4-3v-5l-3-5v-5l-2-2V0v12l1 2v5zm6 36zm8 0-1 1h1v-1zm0-4h-1l1 1v-1zm0 4h-1 1zm0 1h-1c0 1 1 1 1 1v-1zm0 1h-1 1zm0 1-1 1h1v-1zm0 0h-1 1zm0-11s-1 0-1 1h1v-1zm0 1h-1l1 1v-1zm0 2s-1 0-1 1h1v-1zm14 14v-4 4zM37 49h-1 1zm0 1h-1 1zm0 12h-1 1zm0-3h-1c0 1 1 1 1 1v-1zm0 6h-1 1zm0 1h-1l1 1v-1zm0-2h-1 1zm0 4h-1 1zm0-1h-1 1zm0-2s-1 0-1 1h1v-1zm0-5h-1 1zm0 1h-1 1zm0 1s-1 0-1 1h1v-1zm0 6s-1 0-1 1h1v-1zm0-5h-1l1 1v-1zm0 4h1-1zM7 48v-1 12l-4 3v12-11l4-3V48zm0 0v-1 1zm1 0H7h1v11l-4 3v12-11l4-3V48zm-1 0h1-1zm1 0v-1 12l-4 3v12-11l4-3V48zm0 0v-1 1zm1 0H8h1v11l-4 3v12-11l4-3V48zm0 0zM7 60V48H6h1v11l-4 3v12-11l4-3zM6 48h1-1zm0 0v-1 12l-4 3v12-11l4-3V48zm0 0v-1 1zm0 16v10-10zm0 1v-1 1zm2-1H7h1v10-10zm0 0H7h1zM9 2h1c0-1 0-1-1-1v1H0h9zm0 0V1s1 0 1 1H9zM8 62v12-12zm0 0zm-1 2H6h1v10-10zm0 0H6h1zm3-16c0-1-1-1-1-1v12l-4 3v12-11l4-3V48h1zm-1 0v-1 1zM8 12h1s0-1-1-1v1H0h8zm0 0h1-1zm0-2h1s0-1-1-1v1H0h8zm0 0h1-1zM7 7h2V6H7L6 7H0v1h6l1-1zm2 0zm0-4h1c0-1 0-1-1-1v1H0h9zm0 0V2l1 1H9zM4 8C3 8 3 9 3 9h5V8H4zm0 1H3h1zm4 0zm1-8h1c0-1 0-1-1-1H0v1h9zm0-1s1 0 1 1H9V0zm0 2H0h9zm0 0zM8 14h1s0-1-1-1v1H0h8zm0 0h1-1zm1 1H2s0 1 1 1h6v-1zm-6 0H2h1zm6 0zm-1 1-2 1v15H3v1h3l1-1V17h2v-1H8zM3 33v-1 1zm6-17zm0 45H8s0 1 1 1v12-13zm0 1v-1 1zM8 13h1s0-1-1-1v1H0h8zm0 0h1-1zm0-2h1s0-1-1-1v1H0h8zm0 0h1-1zM7 64v10-10zm0 1v-1 1zm15 0v9h1v-9h-1zm0 0h1-1zm29-6h1V49h-1v10zm0-10h1-1zm0 9c1 0 1 1 1 1h-1v-1zm-28 6v10-10zm0 1v-1 1zm-2 0v9-9h1-1zm0 0h1-1zm5 5v1h-1l-1 1v2-2l1-1h1v-1zm0 1v-1 1zm-5-7v10-10zm0 1v-1 1zm4 2v-2h-1v2l3 3v4h1v-4l-3-3zm-1-2h1-1zm5 3V56v12l3 4v2-2l-3-4zm0-11zm0 1v-1h-1v11l4 4v2-2l-3-4V58zm0-1h-1 1zM10 71H9c0 1 0 1 1 1v2-3zm0 1v-1 1zm20 0v2-2zm0 0zm-1-2v4-4zm0 0zm-9-5v9-9h1-1zm0 0h1-1zm10-7v-1h-1v11l4 4v2-2l-3-4V58zm0-1h-1 1zM15 70h-1c0 1 1 1 1 1v3-4zm0 1v-1 1zm0-1h-1v4-4h1zm-1 0zm4-10h1s0-1-1-1v9l2 1v5-5l-2-1v-8zm0 0h1-1zm-2 10v4-4zm0 1v-1 1zm-1-14v-2l-1 1h1v1l-2 2v15-14l2-3zm0-1zm0 0 1-1h-1v2l-2 2v15-14l2-3v-1zm0-1zm1 15h-1v4-4h1zm-1 0zm4-1v5-4c1 0 1 0 1-1h-1zm0 1v-1h1c0 1-1 1-1 1zm-2 0h-1v4-4h1zm-1 0h1-1zm2 0v4-4zm0 1v-1 1zm0-1h-1v4-4h1zm-1 0h1-1zm0 0v4-4zm0 1v-1 1zm5-7v10-10zm0 1v-1 1zm48-42-2 1v5-4l2-2h5-5zm-2 6v-1 1zm7-6zm-3 12h-5l-1 1v2h1-1v-2l1-1h5zm0 0zm-6 3zm1-8v-5 5zm0-5v1-1zm0 5zm4 1v1h1l-1-1 2-2v-4 4l-2 2zm0 1zm2-7zm-7 2v-1l-1 1h1v4l2 2h5-5l-2-2v-4zm6 6h1-1zm-6-6zm7 7h-5l-3-3v-5l-1 1h1v4l3 3h5zm-9-7h1-1zm8 7h1-1zm1-4v-4h1l-1-1v4l-1 2v1h-1l1 1v-2l1-1zm0-4h1-1zm-1 6zM56 11c0 1 0 1 1 1V8c-1 0-1 0-1 1v2zm0-2c0-1 0-1 1-1v1h-1zm1 2v1c-1 0-1 0-1-1h1zm0-1V9v4-3zm0 2v1-1zm0-2V9v1zm8 6h-6l-4-4v-1h-1v1l5 4h7V8s-1 0-1 1h1v7h-1zm-11-5h1-1zm12-2V8v1zM52 1h-1v6h1V1zm30 20H59l-10-9v-2h1c0-1 0-1-1-1v3l10 9h24l6-3h10-10l-7 3zM49 10V9c1 0 1 0 1 1h-1zm33 11H59l-9-9V9v3l9 9h24l6-3h10-10l-7 3zM50 9zm5 45h-1 2l1-1v-4h-1v4l-1 1zm-1 0zm2-5h1-1zM9 1H0h9zm0 0zm43 59v4h-1v2h1v1-7zm-2-1h1s0-1-1-1v-9h1-1v10zm0-10h1-1zm0 9c1 0 1 1 1 1h-1v-1zm6-21s-1 0-1 1h-2l-2 1v8h1v-8l1-1h3v-1zm-4 10h-1 1zm4-9v-1 1zm1 0h-4l-1 1v6-6l1-1h4zm-5 6v1-1zm4-6zm9-31v1H55l-1 1v1h1V9l1-1h9V7zm-10 3h-1 1zm10-2zM52 67l-1-1v2h1v-1zm2-8h7v-1h-7v1zm7-1v1-1zm-7 0v1-1zm15-4c0-1-1-1-1-1v-3l-1-2v-4h-1 1v4l1 2v4h1zm-2-10zm1 10v-1 1zm0 0v-4l-2-2v-4h1c0-1-1-1-1-1v5l2 2v4h-1 1zm-2-10v-1 1zm2 10zm-5-1v-1h-4v1c1 0 1 0 1-1h3v1zm0-1v1-1zm-3 0-1 1v-1h1zm4 0h-5l-1-1v-8 8l1 1h5zm-6-8v-1 1zm5 8h1-1zm6 2v-4l-2-2v-4h1c0-1-1-1-1-1v5l2 2v4h-1 1zm-2-10v-1 1zm2 10zM82 3H54V2s-1 0-1 1h29l8 4h9-9l-8-4zM54 3V2v1zm0 8v1l5 5h6l1-1V8h1-1v8l-1 1h-6l-5-5v-2 1zm12-3zm-12 3v-1 1zm28-9H54V1s-1 0-1 1h29l8 4h9-9l-8-4zM54 2V1v1zm28-1H53h29l8 5h9-9l-8-5zM53 1zm29 3H54V3s-1 0-1 1h29l8 4h9-9l-8-4zM54 4V3v1zm28-1H53h29l8 5h9-9l-8-5zM53 3zm29-1H53h29l8 5h9-9l-8-5zM53 2zm36 0h10-10zm0 0zm-5-2h-1l7 4h9-9l-6-4zm-2 0H54s-1 0-1 1h29l8 4h9-9l-8-5zM54 1V0v1zM8 24l2-5V9l1-5V0v4l-1 5v10l-2 5v9L0 43l8-10v-9zM83 0l7 4h9-9l-7-4zm9 8v1h7-7V8zm0 1zM82 5H54V4s-1 0-1 1h29l13 7h4-4L82 5zM54 5V4v1zm28 1H54V5s-1 0-1 1h29l13 7h4-4L82 6zM54 6V5v1zm28-1H53h29l13 8h4-4L82 5zM53 5zm29 1H53h29l13 8h4-4L82 6zM53 6zm29 1H54V6l-1 1h29l13 7h4-4L82 7zM54 7V6v1zm-1 4v1l6 5h6l2-1V8s-1 0-1 1h1v7l-2 1h-6l-5-5v-1h-1zm14-2V8v1zm-13 2h-1 1zm41-2v1h4-4V9zm0 1zm1 0h-1s0 1 1 1v-1h3-3zm0 0h-1 1zm-4-1v1c1 0 1-1 1-1h6-7zm1 0h-1 1zm3 2h-1s0 1 1 1v-1h3-3zm0 0h-1 1zM82 4H53h29l13 8h4-4L82 4zM53 4zm42 6v1h4-4v-1zm0 1z"
        style={{
          fill: "#231f1f",
          fillRule: "nonzero",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl90;
