import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl89 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={1535}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 112 75"
      {...props}
    >
      <defs>
        <style>{".CyberEl89_svg__fil0{fill:#000;fill-opacity:.960784}"}</style>
      </defs>
      <g id="CyberEl89_svg__Vrstva_x0020_1">
        <g id="CyberEl89_svg___2610557571376">
          <path
            className="CyberEl89_svg__fil0"
            d="M2 0v19h1v1h7c1 0 2 1 2 2 0 0 1 1 2 1 1 2 1 2 2 2h13l1-1c1 0 1 0 1 1 0 0 0 1-1 1 0-1-1-1-1-1H15l-2-2-2-2c-1 0-1-1-1-1H3c-1-1-1-1-1-2-1 0 0-3 0-3V0m28 24v1c0 1 1 0 1 0v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M3 0c1 0 0 0 1 1 1 0 0 0 1 1v1S4 4 4 3C3 2 5 2 4 1L3 0m1 2v1c1 0 1 0 1-1H4z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M4 0h1l2 2c1 1 0 1 0 6v5l-1 1H4l-1 1v3c1 0 1 1 1 1h7l1 1 2 2 1 1h16c0 1 0 1 1 1 0 1 1 0 1 0h1c0 1-1 2-2 1l-1-1H15v-1s-2-2-3-2v-1c-1 0-1 0-1-1H4c-2-2-1-1-1-2v-2l1-1h2l1-1V3s0-1-2-2L4 0m29 25h1l-1-1v1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m6 0 1 1 1 1v6c1 1 3 3 4 3l2 3 4 3s2 2 2 3c1 1 1 1 2 1h9s0-1 1-1c0 0-1 0 0-1h-1l-1-1c-1-1 0-2 1-1v1s0 1 1 1v2H21l-2-2-2-2s-4-4-5-4l-2-3S8 9 8 8V3c0-1 0 0-2-3m24 17s0 1 1 0c0-1-1-1-1 0zM7 0h1S7 1 7 0zM10 0c1 0 1 0 1 1h1c1 1-1 2-1 1s0-1-1-2m1 1v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M13 0v6l-1 5s1 0 2 1l1 2 3 2 2 2h6c4 0 3 0 4 1h1c1 0 0 2-1 1l-1-1h-5l-4-1-2-1-5-5-1-1V3c1-1 1-1 1-2V0m17 20h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M14 0v2c0 1 0 1 1 2h-2c0-1 0-1 1-1V0zM15 0h1-1zM17 0c1 0 2 1 2 1v3c0 1-1 1-1 1-1-1 0-1 0-1V3c0-2 0-2-1-2V0m1 4v1c1 0 1-1 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M18 0h1c0 1 1 2 2 2v2c-1 1-1 0-1 0 0-1 1-1 0-2l-2-2z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M19 0h1l5 5h3V2h-1V1s-1 1-1 0c-1 0-1-1 0-1h1v1h1c0 1 1 1 1 1v2c0 1-1 1-1 1 0 1 0 0-1 0h-2c-1 0-1-1-2-1l-1-1-1-1-1-1-1-1m7 1h1c0-1-1-1-1-1v1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M20 0h3v1h-1c-1 0-1 0-2-1zM29 0v5c0 1 0 1-1 1 0 1 0 1-1 1s0 0-1 1h-1v3s1 0 1 1c0 0 0 1-1 1l-1-1c0-1 1-1 1-1V8c2-2 1-2 3-2h1V0m-4 12s0 1 0 0h1s-1 0-1-1v1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M31 0h1c0 1-1 0-1 0-1 0-1 1-1 1h2v1h-1c-1 0-1 1-1 1h2v1c0 1 0 0-1 0 0 0-1 0-1 1h2v1c0 1 0 0-2 1l-1 1s-2-1-2 0h5v1s0 1-1 1h-2 3v6h1s1 0 1 1c0 0 0 1-1 1s-1-1-1-1v-6h-1c-2 0-2 0-2-1V9h2c1 0 1 0 0 0h-4V8h-1c0-1 1-1 1-1h2l1-1h2l-1-1c-1 0-1 1-1 0V4h2c0-1-2 0-2-1V2h2l-1-1c-1 0-1 1-1 0V0h1m2 17s0 1 0 0h1c-1 0-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M32 0h1v15h1v1s1 0 1 1v1c-1 0-1 0-1 1v1h-2c0-1 0-1 1-1l1-1v-2l-1-1h-1V0m1 19v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M33 0h1v15l1 1c1 1 1 0 2 1 0 1-1 1-2 1v-1c0-1 0-1-1-2 0 0-1 0-1-1V0m2 17h1c0-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M34 0v13l1 1 2 2v2c-1 1 0 0-2 1v2c-1 0-1 0-1 1v1h-1c-1 0-1-1 0-1 0-1 1-1 1-1v-2l1-1h1c1-1 1 0 1-1s0-1-1-2l-2-1V0m-1 22c0 1 1 1 1 0h-1zM38 0c1 2 0 9 0 9 0 4 0 4 1 4v2h-1V0m0 14v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M41 0v8h1v1h1v5c0 1 0 1-1 2h-2c-1 0-1 1-1 1v1c-1 0-2-1-1-1 0-1 1-1 1-1h3V9l-1-1V0m-3 17 1 1v-1s-1-1-1 0zM42 0h1v1c0 1-1 1-1 0V0m0 0v1h1c0-1-1-1-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M44 0v2c-1 0-1 1-1 1v5l1 1v7c0 1-1 1-1 1s-1 0-1 1h-1s-1 0-1-1c0 0 1-1 2-1v1h1V8c-1 0-1 0-1-1V3l1-1s1 0 1-1V0m-3 17c0 1 0 1 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M44 0h1v2l-1 1v2c1 1 1 1 0 1 0 1 0 1-1 0V5h1V0m0 6s1-1 0-1 0 1 0 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M45 0h1c0 15 0 13-1 13-1 2-1 1-1 3v1c-2 2-2 2-2 3h-1c0 1 0 0-1 0v-1h2s0-1 2-2v-3l1-1V0m-4 19v1h1c0-1-1-1-1-1zM47 0zM48 0h1l-2 2v12c0 1 1 1 0 1h-1V2s1 0 2-2m-2 14v1h1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M49 0h1l-2 2c1 1 0 1 0 1 0 1-1 0-1 0V2l1-1s1 0 1-1zM51 0l-1 1v1h-1c0 1 0 1 1 1v2c-1 0-2 0-2-1 0 0 1 0 1-1V2l1-1s0-1 1-1m-2 4s0 1 0 0h1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M52 0v4l-3 3s-1 0-1 1v7l-1 1v1c1 0 0 1 0 1h-1v-2l2-1V7l2-2 1-1h1V0m-6 17c1 1 1 1 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M52 0h1c0 5 0 4-1 5l-2 2-1 1 1 1v6h-1c-1 0-1 0 0-1V7l1-1s1-1 2-1V4h1V2c-1-1-1-1-1-2m-3 14v1c1 0 1 0 1-1h-1zM53 0h1c1 0 1 0 1 1 0 0-1 1-1 0h-1V0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M55 0h1v3h-1v1l-1 1-1 1c-1 0-2 1-2 1v9h-2c-1 0-1 0-1 1v1c1 1 1 1 2 1v1c-1 1-1 0-1 0-1 0-1-1-1-1v-3h2V8c0-1 1-1 1-1V6h1c0-1 1-1 1-1 0-1 1-1 1-2h1V0m-6 19c0 1 1 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M56 0h1c-1 1-1 0-1 3 0 1 0 1-1 1l-1 2h-1l-1 1v6c0 3 0 3-1 3 0 0 0 1-1 1 0 1-1 1-1 1-1 0-1-1 0-1 0-1 1-1 1 0 1 0 1-1 1-1V8h1V7c1 0 2-1 2-1 0-1 1-2 1-2h1V0m-7 17v1l1-1h-1zM59 0h1v2c0 1-1 1-1 1V0m0 2h1c0-1-1 0-1 0zM60 0h2v1c-1 1-2 0-2-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M62 0h1v2h-1c-1 2-1 2-2 2s-1-1-1 0l-1 1v4c0 1-1 2-1 1-1-1 0-1 0-2V5l2-2h2c1-1 1-1 1-2V0m-5 9c0 1 0 1 1 1V9h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M64 0v1c0 1 0 1-1 1l-1 2h-2v1c-1 0-1 0-1 1v5h-4v5c0 1 1 1 1 1-1 1-2 1-2 1v-2c1 0 0 0 0-1v-3l1-1h1c0-1 0 0 0 0 1 0 1-1 2 0V6c0-1 0-1 1-1 0 0 0-1 1-1h1l2-2c1 0 1-1 1-1V0m-9 17h-1c1 0 1 1 1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M65 0v2c0 1-2 2-2 2l-1 1h-2v5c0 1 0 1-1 1l-1 1c0 1-1 1-1 1-1-1-1-1 0-2h2V6c0-1 1-1 1-1h2s0-1 1-1l1-1s0-1 1-1V0m-8 12c1 1 1 0 1 0-1-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M68 0h1c-1 0-1 1-1 1l-1 1-2 1s-1 2-2 2c0 1 0 1-1 1h-1v1h-1l1 1v4h-1c0 1-1 1-1 1l-1 1v1h-1s-1-1 0-1h1c0-1 1-1 1-1l1-1V6h1V5h2l1-1 1-1 1-1 1-1 1-1M57 14v1h1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M69 0h1l-1 1-1 1c-1 0-2 1-2 1l-1 2-1 1-1 1s-1 1-2 1v5l-1 1c-1 0-1 0-1 1v1c-1 1-1 1-1 2 0 0-1 0-1-1-1-1 0-1 1-1h1v-2l1-1 1-1V8l1-1 1-1 1-1 5-5M57 17c0 1 1 1 1 0s-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M80 0s0 1-1 1h-9l-1 1-3 3c-1 0-3 2-3 2v1c0 1 1 1 0 2h-1V9c1-1 0-1 0-1 0-1 1-1 1-1l1-1s2-1 2-2c1 0 2-1 2-2l1-1 1-1h10M63 10V9c-1 0-1 0 0 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m81 0-1 1h-7c-2 0-2 0-2 1-1 0-2 1-2 1s-2 2-2 3c-1 0-2 1-2 1l-1 1v4h-1c0 1 0 1-1 1v-1c0-1 1-1 1-1h1V7l1-1s2-1 2-2h1l1-1 1-2h10s0-1 1-1M62 12h1c0-1 0-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m82 0-1 1-1 1h-9l-1 1-1 1-1 1-1 1s-1 1-1 2h-1v4l-1 1h-2v3h1l1 1c0 1-1 1-2 1v-2h-1v-3h3c0-1 0-1 1-1V7h1V6l2-1 1-1 1-2h10l1-1V0h1M62 17h1c0 1 0 1 0 0 0 0 0-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m83 0-1 1-1 2H71l-2 2v1l-2 1c0 1-1 1-1 1v4l-1 1s-1 1-1 2h-1c-1 0-1 0-1-1h2l1-2h1V8s0-1 1-1l1-1 1-1 1-1c0-1 0-1 1-1h9l1-1V1c1 0 1-1 2-1M62 14c0 1 0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m84 0-1 2-2 2H71l-1 2c-1 0-2 2-3 2v8h-3v4h-1s0 1-1 0v-1h1c1 0 1-1 1-1v-2h1c1 0 1 0 1-1h1v-5c0-2-1-2 0-2 0-1 2-2 2-2l1-1 1-1c0-1 0-1 7-1h3l1-1 1-1 1-1M62 19c0 1 0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M85 0h1c-1 0-2 1-2 2l-1 1-2 1c0 1 0 0-1 0h-2c-2 0-4 1-4 1h-3s0 1-1 1l-1 1-1 1v8l-1 1c-1 0-1 1-1 1-1 0-2-1-1-1 0-1 1-1 1-1 0 1 0 1 1 0V8h1l1-1V6h1l1-2h10l1-1 3-3M65 17h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M86 0h1s-3 2-3 3l-2 2H72c0 1-1 2-1 2-1 0-2 2-2 2-1 0 0 0 0 2v5l-3 2v2s-1 1-1 0v-1c1 0 1 0 1-1l2-1V8h1c0-1 1-2 2-2l1-1h8c2 0 1 0 2-1 1 0 3-3 3-3h1V0M65 19v1h1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m88 0-3 3-3 3H72l-2 2s0 1-1 1v8l-1 1c0 1 0 0 1 1v1c0 1-1 1-2 0 0-1 1-1 1-1v-1c0-1 0-1 1-1V9c0-1 0-1 1-1l1-1 1-1h8c2 0 2 0 2-1l1-1c1 0 3-3 3-3h1c0-1 0-1 1-1M68 19v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m89 0-4 4-2 2c-1 1 0 1-5 1h-5l-1 1h-1v6s1 0 1 1h-2v-1l1-1v-2c0-3-1-3 0-3 0 0 0-1 1-1V6h10l2-1c1-1 2-2 2-3l2-1s0-1 1-1M70 14s0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M90 0s-1 1-1 2c0 0-2 1-2 2h-1c-1 1-1 1-1 2l-1 1h-1c0 1 0 1-2 0-1 1-2 1-3 1-2 0-2-1-3 0l-1 1v1h-1s-1-1 0-1c0 0 1 0 1-1 0 0 1 0 1-1h8V6h1l1-1 1-1V3l4-3M73 9c0 1 1 1 1 1V9h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M97 0h1c-1 1-1 1-5 1-2 0-2-1-3 0 0 1-2 2-2 2 0 1-4 4-4 4l-1 1h-6c0 1-2 3-2 3-1 0-1 1-1 1 0 1-1 1-1 0 0 0-1-1 0-1h1c1 0 3-3 3-3h6l1-2c1 0 3-2 3-2 0-1 1-2 3-3 0-1 0-1 1-1h6M73 12c1 1 1 0 1 0v-1c-1 0-1 1-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M98 0h1l-1 1h-6v1h-1v1c0 1-1 1-1 0-1 0 0-1 0-1h1c1-1 1-1 2-1h5V0m-8 2v1h1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M101 0h1l-3 2c-1 1 0 1-3 1h-4c-1 0 0-1 1-1 1 1 0 1 4 0 1 0 1 1 2 0l1-1V0h1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M102 0h1l-1 1c-1 0-1 1-2 2l-2 2h-3l-1 1c-1 0-1 0-1 1l-1 1h-8l-1 1h-4l-2 2-1 1-1 1h-1c-1 0-2 0-2 1v4h-2c0-1 0-2 1-2h1v-3h2c1 0 1-1 1-1 1 0 1-1 1-1 1 0 2-1 2-2h5l1-1h7l1-1 1-1 1-1c1 0 1-1 1-1h3c1 0 1-1 1-1l1-1s1-1 2-1V0M71 17c0-1-1 0 0 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m104 0-2 2-3 3h-2c-1 0-1 0-2 1l-3 3-3 3c-2 1-1 1-2 1h-6l-1 1-1 1s-3 2-3 3l-2 2h-4s0-2 2-1h2l3-2 2-3c1 0 1 0 1-1h8v-1l3-2c0-1 3-3 3-4 2-1 1-1 2-1h3c0-1 2-2 2-2s2-2 2-3h1M71 20v-1s-1 0 0 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m106 0-3 3-2 2-1 1v3c0 1 0 1 1 1 2 2 2 2 2 3s0 1-1 2c-2 2-2 1-2 1H90c-1 1-1 0-1 1l-4 3-2 2-1 1h-7c-1 0-1 0-2 1-1 0-1 1-1 1h-3l-1 2c-2 1-1 0-3 0H53c-3 0-3 0-3 1l-2 2-5 5c-1 1-1 1-3 1h-9c0 1 0 0-1 1 0 0-2-1-2 0-7-1-5 0-6-1h-3c-1 0-1 1-2 1v-1l1-1h2c2 0 1 0 2 1h9c0-1 0-1 1-1h10s2-1 2-2l1-1 1-1 2-2s2-1 2-2h17c0-1 1-2 2-2 0-1 0 0 1 0 2 0 2 0 2-1 0 0 1-1 2-1 0-1-1 0 4 0 0 0 2-1 4-1h1v-1h1l2-3 2-2h12l2-2v-2l-2-2V6l1-1 1-1 3-4h1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M57 1c0-1 1-1 1 0v2c0 1 0 1-1 1 0 0 0 1-1 1l-1 2-1 1v11h-1v1c-1 1-1 0-1 1v1s0 1-1 2l-1 1s-2 1-2 2l-2 1-2 2-1 1-1 1-1 1H31c-1 0-1 1-1 1h-5v-1H5v1c-1 0-1 0-1-1v-1h1v1h20l1 1h3l1-1h11v-1s1 0 1-1c-1 0-1 0 0-1h2v-1h1c0-1 1-1 1-2h1l1-1v-1h1v-1h1v-1h1c0-1 0-1 1-1v-1c0-1 0 0-1-1v-1h2V7l1-1c1 0 1-1 1-1h1s0-1 1-1V1m0 0s0 1 1 0h-1m-5 18v1h1l-1-1M42 30v1c1 0 1 0 1-1h-1zM112 2v1h-1v11h-1v-2c1 0 0 0 1-1-1-1-1-4-1-4V3c1 0 2-1 2-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M112 3v1c-1 0 0 0 0 8-1 0-1-2-1-2V4l1-1zM23 5h1c0 1 0 1-1 2l-1-1 1-1m0 1h1c0-1-1-1-1 0zM86 6c0-1 1-1 1 0s0 1-1 1V6m0 0v1h1V6h-1zM88 9c0-1 0 0 1 0v1c-1 1-2 0-2-1h1m0 0v1c0-1 1-1 0-1zM98 10c0-1 1 0 1 0-1 1-2 1-2 0h1m0 0s0 1 0 0c0 0 0-1 0 0zM84 11c0-1 1-1 1-1l1 1s0 1-1 1l-1-1m1 0v1s1-1 0-1zM78 11h1l1 1c-1 1-1 1-2 0v-1m0 1h1v-1s0 1-1 1zM81 11h1v1c1 0-1 1-1 0v-1m0 1h1v-1c-1 0-1 1-1 1zM5 11l1 1-1 1s-1 0-1-1c0 0 0-1 1-1m0 1s-1 0 0 0c0 1 1 0 0 0 0-1-1 0 0 0zM104 13c1-1 2-1 2 0-1 1-2 1-2 0m1 0c0 1 0 1 0 0zM100 13h2v1h-1c-1-1-1-1-2-1 0 0-2 1-2 0-1 0 0 1-1 0h-2s0 1-3 1h-1l-1 1-1 1-1 1-2 2-2 2s-1 0-1 1h-9c0 1-1 1-1 2h-3l-1 1h-1l-1 1c-1 0-1 0-1-1v-1h1l1 1v-1h1s0-1 1-1h3l1-1h9v-1l3-2s5-5 5-6h10m1 0v1s1 0 0-1M65 25c1 1 1 0 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M81 14c1-1 2 0 1 1h-1c0 1-2 2-2 3 0 0-3 3-4 3h-5l-2 2-1 1h-5c-1 1-3 2-3 2h-9l-1 1-2 2-3 3-2 2c-1 1 0 1-4 0-8 1-6 0-7 1-1 0-1 1-1 1h-5c-1 0-1-1-1-1-1-1 1-1-17-1l-1 1c-1 0-2 2-3 2 0 1 0 0 0 0H0h3l3-3h18l1 1h5v-1h11l1-1 1-1 2-2 2-2c3-2 2-2 3-2h9s1-2 2-2c1-1 0-1 4-1h2l1-1 1-1h6v-1h1l3-3v-1c2-1 2-1 2-2m1 0h-1v1c1 0 1 0 1-1zM73 14h1v1h-1v-1m0 0v1h1v-1h-1zM30 14h1c0 1 0 1-1 1 0 0-1-1 0-1m0 0v1c1 0 1 0 1-1h-1zM65 14c0-1 1 0 1 1h-1v-1m0 0v1c1 0 1-1 1-1h-1zM41 14h1v1c-1 0-2 0-2-1h1m0 0v1s1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M108 15h4c-1 0-4 0-4 1h-6l-1 1H89c0 1-1 1-3 3l-3 3c-1 1 0 0-2 1h-7s-1 1-2 1c0 1 0 1-1 1h-1v2l-1 1h-3l-1-1H51l-1 1c-1 0-4 4-5 4 0 1-2 3-3 3H32l-1 1c0 1-1 1-1 1 0 1 0 1-5 1H0v-1h28c2 0 1 1 3-1l1-1h10s2-1 2-2l2-2s1 0 1-1h1c0-1 0-1 1-1l1-2h16c0 1 0 1 1 1h2v-1c1 0 0 0 0-1l1-1h1c1 0 1 0 1-1 1 0 1 0 1-1 1-1 1-1 2-1h8s0-1 1-1c0-1 2-2 2-2l3-3h11c1 0 1-1 2-2h6zM86 15l1 1c-1 1-1 1-2 0 0-1 1-1 1-1m0 1c0 1 0 0 0 0 0-1 0-1 0 0zM4 16c0-1 1 0 1 0h7l1 2h1v1h1v1l1 1h1v1h14c1 0 1 1 1 1h3v-1s1-1 1 0c1 0 1 0 1 1h-2v1h-3s0-1-1-1h-9l-3-1c-2 0-2 1-2 0 0 0-1 0-1-1l-2-1c0-1-1-1-1-1 0-1-1-2-2-2-2-1-4 0-5 0-1-1-1 0-2 0v-1m0 0c0 1 1 1 1 0H4m31 6c1 0 1 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M104 16h8-9l-1 1s0 1-1 1H90c-1 0-2 1-2 1 0 1-1 2-1 2h-1c0 1-1 2-1 2s-1 0-1 1h-8c-1 0-1 0-1 1-1 0-2 1-2 1 0 1-1 1-1 1 0 1 0 1-1 1 0 0-1 0-1-1h2c0-1 1-1 1-1 0-1 1-1 1-1v-1h9l1-1 2-2 2-2 1-1h5c5 0 4-1 5 0h2v-1l1-1h2M71 27v1-1zM73 16h1v1c0 1-1 1-1 0v-1m0 1c1 1 1 0 1 0 0-1-1-1-1 0zM52 16s1 0 1 1-1 1-2 1v-1l1-1m0 1v1-1c1 0 0 0 0 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M109 17h3-9s-1 1-1 2H90s-2 1-2 2c-2 1-2 2-2 2l-2 2h-8c0 1-1 1-1 2l-1 1h-1c0-1 0-1 1-1v-1h1l1-1h8v-1c1 0 1-1 1-1s1 0 1-1l4-4h12l1-1h6M73 27s1 0 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M105 17h7v1h-8c-1 1-1 1-2 1H92s-1 0-1 1c0 0-1 0-2 1l-2 2-2 2-1 1h-6l-1 1-1 1-1 1h-5c0 1 0 1-1 1h-3v5h1c1 0 1 1 1 1 1 0 1 0 2 1l-1 1c-1 0-1-1-1-1 0-1 0-1-1-1s-1-1-1-1c-1 0 0-1 0-2 0 0-1-1-1-2s1-1 1-1c0-1 1 0 1 0h2l1-1h5c0-1 2-3 2-3h5c2 0 2 0 2-1l1-1h1c0-1 1-2 1-2 1 0 2-2 3-2v-1h13v-1s1 0 1-1h1M68 37h1v-1c-1 0-1 1-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M105 18c1 0 1 1 1 1 0 1-1 1-1 1-1-1 0-1 0-1v-1m0 1v1c1 0 1-1 1-1h-1zM28 19c1 1 0 1 0 1-1 1-1 0-1-1h1m-1 0v1s1 0 1-1h-1zM35 19h2c0 1-1 1-1 1-1 0-1 0-1-1m1 0-1 1h1v-1zM57 19c1 0 1 0 1 1s-2 0-1-1m0 1c1 0 1 0 1-1-1 0-1 1-1 1zM46 19h1c1 1 0 2-1 1v-1m0 0v1h1v-1h-1zM98 21c1-1 2-1 2 0 0 0 0 1-1 1 0 0-1 0-1-1m1 0v1l1-1s-1-1-1 0zM63 22c1-1 1 1-1 1 0 0 0-1 1-1m-1 0 1 1v-1h-1zM65 22c1-1 2 0 1 1h-1v-1m0 0c1 1 1 0 1 0h-1zM57 22c0-1 0-1 1 0v1h-1v-1m0 0s0 1 1 1v-1h-1zM71 22c0-1 0 0 0 0 0-1 0 0 0 0h1v1h-1s-1 0-1-1h1m0 0v1s1-1 0-1zM41 22c0-1 1 0 1 0v1c-1 0-2 0-2-1h1m0 0v1s1 0 1-1h-1zM44 22c0-1 1 0 1 1-1 0-2 0-2-1h1m0 0v1-1zM46 22c1-1 2 0 1 1h-1v-1m0 0c0 1 0 1 1 1v-1h-1zM49 22c1-1 1 0 1 0v1s-1 0-1-1m0 0c0 1 0 1 1 1v-1h-1zM6 22c1 0 2 0 1 1 0 1-1 0-1-1m0 1h1c0-1 0-1-1-1v1zM104 23h8-23c-1 0-1 0-2 1 0 1-2 2-2 3h-6l-1 1c-1 1-2 1-2 1 0 1 0 1-1 1h-4c-1 0-1 1-1 1-1 0-2 2-2 2v2c-1 0-2-1-1-1 0-1 1-2 1-2 1 0 1-1 1-1l1-1h5s0-1 1-2h1l1-1c1-1 1-1 2-1h5l1-1 1-1s0-1 1-1h16M67 34c0 1 1 0 1-1-1 0-1 0-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M108 23h4v1H88l-1 2-2 1c0 1 0 0-2 0-5 1-3 0-5 1 0 1-1 2-1 2-1 0-1 1-1 1h-5l-1 1v1s1 1 0 1c0 1-1 1-1 0v-2c1 0 1-1 2-1 0-1 0-1 1-1h4l2-2 1-1h6l1-1 1-1c1 0 2-1 2-2h19M69 34h1v-1s-1 0-1 1zM0 24h3l2 2h30v1h1c1 1 0 1 0 1h-1v-1l-1-1H5l-1-1-1-1H0m35 3v1h1v-1h-1zM57 24h2c0 1-1 1-1 1h-1v-1m0 0v1h1v-1h-1zM35 24h1c1 0 1 1 0 1v1h-1v-2m0 1h1v-1s-1 0-1 1zM38 24s1 0 1 1-1 1-1 0v-1m0 1h1v-1s-1 0-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M107 24h5v1h-4l-1-1-1 1c0-1-1 0-1 0H89l-1 1c-1 1-2 1-2 1v1h-6v1s-1 0-2 1l-1 1h-4l-1 1v1h-2c0-1 0-1 1-1h1v-1h4c1 0 1-1 1-1h1c0-1 1-2 1-2h7v-1h1c0-1 1-1 1-1s0-1 1-1v-1h18m-36 9c1 0 1-1 0-1s0 1 0 1zM0 25c1 0 1 0 2 1l1 1h29s1-1 1 0h1c0 1-1 1-1 1-1 0-1 0-1-1H2l-1-2H0m33 2v1h1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M106 25h6-22l-1 1-1 1-2 2h-6l-1 1-1 2-1 1h-1v-1h1l1-1 2-2h6v-1l2-1 2-2h16m-30 7v1h1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M104 26h8-22l-2 2c-1 2-1 2-2 2h-4l-2 2-2 2h-4v-1h-1c0-1 0-1 1-1s1 1 1 1v1h2c1 0 1 0 1-1h1s2-2 2-3c1 0 1-1 1-1h5v-1h1l2-2h14m-30 7s1 0 0-1c0 0-1 0 0 1zM0 26s2 1 2 2h30c0 1 0 1 1 1s1-1 2 0h1v1c1 0 1 0 0 0v1c-1 0-1 0-1-1s0-1-1-1h-2s0-1-1-1H1l-1-1v-1m36 4h-1c1 1 1 1 1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M109 27v-1l1 1c2 0 1-1 2 0H91l-3 2c-1 2 0 2-2 2h-4l-3 3-2 2h-1v-2c1 0 1 1 2 1v-1l2-2h1v-1l1-1h5l2-2c2-2 1-1 4-1h14c1-1 1 0 2 0m-33 8s0 1 1 1v-1h-1zM68 27c1-1 1 0 1 1h-1c-1 0-1-1 0-1m0 0c0 1 0 1 1 1v-1h-1zM38 27h1v1c-1 0-2 0-1-1m0 0v1h1c0-1-1-1-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M102 27c11 0 8 0 10 1H90c0 1-1 2-1 2l-1 1h-5v1h-1s-1 2-2 2l-1 1-1 1v1h-6c0 1 0 1-1 2 0-1 0-1-1-1 0 0 0-1 1-1h1c0-1 0-1 1-1h5v-1l2-2h1c0-1 1-1 1-1 0-1 1-1 1-1h4l1-1c1-1 1 0 2-1 0 0 0-1 1-1v-1h11M71 38h1l-1-1v1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M105 28h2c0 1 1 1 1 1v4h1c3 0 2 0 3-1v1h-4v-4h-1v-1H92v1c-1 0-3 3-3 3h-6l-2 2-3 3c-1 1 0 1-1 1-1 1-1 0-1 0s0-1 1-1 1 0 2-1v-1h1l2-2 1-1h5l4-4h13M76 38h1v-1c-1 0-1 1-1 1zM7 29h25c0 1 0 1 1 0 0 0 1 0 1 1l-1 1c-1 0-1-1-1-1l-1-1H0h7m26 1c1 1 1 0 0 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M37 29c1-1 0 0 2 0h1s1 0 1 1c0 0-1 1-1 0-1 0 0-1-1-1h-2v2c-1 1 0 0-2 0h-4c-2 0-1 0-2 1h-1c-2 0-1 1-3-1 0-1-1 0-9-1H0h25l2 2h2v-1h8v-2m4 1v-1h-1s0 1 1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M27 29c1 0 2 1 1 1 0 1-1 1-1 0v-1m0 1c0 1 1 1 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M30 30c0-1 1-1 1-1v2h-2c-1 1-1 0-2 0 0 0 0 1 0 0-1 0-1 0-1-1H0v-1h25s0 1 1 1l1 1h1c1 0 1-1 1-1h1m0 0c1 0 1 0 0 0 0-1 0 1 0 0zM38 29h1v1c0 1-2 1-1 0v-1m0 1s0 1 1 0h-1zM102 29h1v1h1v1c0 1 0 1 1 2 0 1 0 0 1 0h6v1h-3c-4 0-4 0-4-1h-1v-1c-1 0-1-1-1-1 0-1 1-1 0-1H92l-1 1c0 1-1 1-1 1l-1 1h-5l-2 2-2 1v2c0 1-2 0-1-1l3-3c1-1 1-1 2-1h5c0-1 1-1 1-1s0-1 1-1c0 0 0-1 1-1v-1h10m-22 9v-1h-1s0 1 1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M94 30c5 1 6 0 6 1 2 1 1 0 2 0 0 1 1 1 1 1 0 1-1 1-1 1-1 0-1 0-1-1v-1h-8l-2 2c0 1 0 1-1 1h-6l-1 1-1 1v1h1v1c-1 1-1 1-1 0h-1c0-1 0-1 1-1v-2h1c0-1 1-1 1-2h6s0 1 1 0l2-2 1-1m-12 8h1c0-1-2-1-1 0zM67 31c1-1 1 0 1 0 0 1 0 1-1 1 0 0-1-1 0-1m0 0v1s1 0 1-1h-1zM39 31h1c1 1 0 1 0 1H30l-1 1h-3l-1-1c-1-1 0-1-1-1H0h25l1 1v1h3s0-1 1-1h8c1 0 1 0 1-1m0 1h1v-1s-1 0-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M99 32c1-1 1 0 1 0h1c-1 1-2 1-2 0m0 0h1v1-1c0-1-1 0-1 0zM49 32h1v1h-1v-1m0 0v1c1 0 1 0 1-1h-1zM51 32h2v1c-1 1-2 0-2 0v-1m1 0v1c1 0 1-1 0-1zM55 32s1 0 1 1c0 0-1 1-2 0v-1h1m-1 1h1v-1s-1 0-1 1zM57 32c1 0 1 0 1 1 0 0 0 1-1 0v-1m0 0v1h1c0-1-1-1-1-1zM60 32s1 0 1 1-1 0-2 0v-1h1m0 0v1s1 0 1-1h-1zM101 33l1 1h10-10l-1 1c-1 0-1-1-1-1s0-1 1-1m0 1s-1 0 0 0c0 1 1 0 0 0 0 0 0-1 0 0zM91 34c1-1 1 0 2 0 0 1-1 1-1 1-1 0-1-1-1-1m1 0h-1c1 0 1 0 1 1 0 0 1-1 0-1zM85 34s1 0 1 1v1c-1 0-2-1-1-2m0 1v1c1 0 1-1 1-1h-1zM49 35v-1l1 1s0 1-1 1c0 0-1 0 0-1m0 0v1s1 0 1-1h-1zM52 35c0-1 1-1 1 0 0 0 0 1-1 1 0 0-1 0-1-1h1m0 0v1c1 0 1-1 0-1zM54 35c1-1 1-1 2 0l-1 1c-1 0-1 0-1-1m1 0c0 1 0 1 0 0 0 0-1 0 0 0zM57 34c1 0 2 1 1 2 0 0-1 0-1-1v-1m0 1c0 1 1 1 1 0h-1zM60 35c1-1 1 0 1 0 0 1-1 1-1 1l-1-1h1m0 0v1s1 0 1-1c0 0-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M104 35h8-8c-1 0-1 0-1 1H87l-2 1s0 1-1 2H74l-1-1c0-1 1-1 1-1 1 0 1 1 1 1 0 1 0 1 1 1h7l1-1 1-1 1-1 1-1h17m-30 3v-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M104 35h8v1h-8l-1 1H87l-4 4h-1v1h-3l-1-1h-2v-1h1l2 1c0 1 0 1 2 1 1 0 1 0 1-1l1-1 3-3h17s0-1 1-1v-1m-27 5c-1 0-1 1 0 1v-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M106 36h6-7c0 1-1 2-1 2H87s-1 2-2 2l-1 1c0 1-1 1-1 1 0 1 0 1-1 1h-3c-1 0-1-1-1-1h-3v-1h-1c-1 0-1-1-1-1h2v1s0 1 1 1h7l1-2 1-1c1 0 1 0 2-1h14s3 0 3-1l1-1h1m-32 4v1s1-1 0-1zM65 36h1c1 1 0 1 0 1 0 1-1 0-1 0v-1m1 0c-1 0-1 0-1 1h1v-1zM20 36l1 1-1 1c-1 0-1-1-1-1l1-1m0 1v1c0-1 0-1 1-1h-1c0-1 0 0 0 0zM15 36l1 1-1 1c-1 0-1 0-1-1 0 0 0-1 1-1m0 1h-1l1 1c0-1 1-1 0-1zM55 37s1 0 1 1l-1 1-1-1c0-1 0-1 1-1m-1 1h1c0-1 0-1-1 0zM57 37c1 0 1 0 1 1v1c-1 0-1-1-1-1v-1m0 1h1c0-1-1-1-1 0zM60 37s1 0 1 1c-1 1-2 0-1-1m0 1h1s0-1-1-1v1zM33 37l1 1-1 1c-1 0-1-1-1-1s0-1 1-1m0 1c1 0 0 0 0-1 0 0-1 1 0 1zM49 37s1 0 1 1-1 1-1 0v-1m0 1c1 1 1 0 1 0 0-1-1-1-1 0zM52 37c1 0 1 1 1 1-1 1-2 1-2 0l1-1m0 0v1h1l-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M106 37h6v1h-6c-1 0-1 1-1 1H87s-1 2-2 2l-2 2c0 1 0 0-2 0-3 0-3 1-3 0h-5c0-1-1-2-1-2l-2-1s-1 0-1-1v-1h1v1h1v1l1 1 1 1h5v1h5l1-1s2-2 2-3c1 0 1 0 1-1h18s0-1 1-1m-37 2h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M106 38h6-5c-1 0-1 1-1 1-1 1-1 0-4 0H90c-1 0-1 0-2 1l-1 1c-1 0-3 2-3 3h-7c0-1 0-1-2-1h-2v1h-4l-1 1c-1 0-1-1-1-1 0-1 1-1 1-1l1 1h3c1 0 1-1 1-1h4c1 0 1 0 1 1h6l1-1c0-1 0-1 2-2 0-1 1-2 1-2h17c1 0 1-1 1-1m-39 6h1v-1c-1 0-1 1-1 1zM36 38c1 0 2 2 0 2l-1-1H0h35c1 0 1 0 1-1m0 1v1l1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M112 39h-3l-2 2-1 1c-4 0-4-1-4 0l-1 1h-1v-1h1c1-1 0-1 5-1l2-2c1-1 0 0 4 0zM42 39c1 0 1 0 1 1v6l-1 1c-1 1 0 0-3 0-2 1-1 0-3 1-2 2-1 2-3 2H22c-3 0-2 0-3 1-1 0-1 0-1 1v22l-1 1h-2V59c0-1 0-1-1-1v15c0 1 0 1-1 1v1h-2V61c-1-1-1 0-1 0v1c-1 0-1 3-1 3v10H7c0-1-1-1-1-1v-5s1-4 1-5c0 0-1 0-1-1 0 0-1 0-1 1v5c0 5 0 4-1 5v1H2v-8H0v-1h2v1c1 1 1 0 0 6 0 0 0 1 1 1h1v-9c0-1 0-1 1-2h2v11h1c1 0 1-1 1-1V61c0-1 0-1 1-1h1c0 1 1 1 1 1v10h-1v1c1 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 1 0V59h1v-1h1c1 0 1 0 1 1v15h1v-8l1-4V51c1-1 1-1 2-1h12l2-1c0 1 0 0 1 0 0-1 1-1 1-1l1-1c5 0 4 0 5-1v-5c0-1-1-1 0-1v-1m0 1h1s0-1-1-1v1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M110 39h2-1c0 1 0 0-3 3-1 1 0 1-2 1h-3l-1 1h-2c-1-1-2-1-2-2s0-1-1-1h-4l-1 1s0 1-1 0v-1h7c1 1 1 0 1 1v1h1v1h1l1-1 1-1h4l3-3m-19 2v1c1 0 1 0 1-1h-1zM79 40h1v1h-1v-1m0 1h1v-1c-1 0-1 0-1 1zM49 40c1 0 1 0 1 1h-1v-1m0 0c0 1 0 1 1 1v-1h-1zM52 40c1 0 1 0 1 1h-1c-1 0-1-1 0-1m0 0v1h1v-1h-1zM54 40c1-1 2 0 2 1 0 0-1 1-2 0v-1m1 0c-1 0-1 1 0 1v-1zM57 40h1c1 1 0 1 0 1-1 0-2-1-1-1m0 1h1v-1s-1 0-1 1zM60 40c1 0 1 0 1 1-1 1-2 0-1-1m0 0v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M112 40h-1l-3 3h-5c0 1-1 1-1 1 0 1 0 1-5 1 0 0 0-1-1-1h-6v2h-1v-1c0-1 0-1 1-1h12l1-1h5c0-1 1-2 1-2 1 0 1-1 2-1h1zM24 40h11c0 1 1 1 1 1v1c0 1 1 1 0 1 0 1 0 1-1 1v-1c0-1 1-1 0-1v-1l-1-1H11l-3 3-2 2s-3 2-3 3l-2 1v1H0c0-1 0 0 1-1l1-1 3-3c1 0 3-2 3-2l2-3h14m11 3c1 1 1 1 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M100 40c1 0 1 0 1 1h-1v-1h-9l-1 1v2l-3 2H77c0-1 0 0-1 0h-4v1s-1 1-1 0c0 0-1 0 0-1h4s0-1 1-1h1c1 0 1 1 1 1h9l2-2c0-1 1 0 0-1v-2h11m0 0c0 1 1 1 1 1v-1h-1m-11 0v1h1v-1h-1m-18 6h1v-1h-1v1zM111 40h1v1c-1 0 0-1-3 2l-1 1h-5l-1 1h-9c-1 0 0 0-1 1 0 1-2 0-1-1 0-1 0 0 4 0h7l1-1c1-1 0 0 5 0l3-3v-1m-20 5v1h1v-1h-1zM13 41h21c1 1 1 1 1 2-1 1-1 1 0 1h4c1 0 1 0 1-1s0-1 1-1v1c0 1-1 1-1 1l-1 1h-3c-1 0-1 0-2-1v-2s0-1-1-1H11s-1 1-1 2c-1 0-1 0-1 1H8v1H7l-1 1-3 3c-1 0-3 3-3 3v-1c1 0 3-3 3-3s2-2 3-2c0-1 1-2 2-2l2-2c1-1 1-1 2-1h1m27 2c0 1 1 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M88 41h1v1c-1 0-1 1-2 0v-1h1m0 1s1 0 0-1v1zM67 41h1v1c1 1-1 1-1 0v-1m0 0c0 1 0 1 1 1v-1h-1zM111 41h1v1h-1l-2 2c-1 1 0 1-1 1-5 0-4-1-4 0-2 1-1 1-2 1h-7c-1 0-1 1-1 1-1 0-1-1-1-1s0-1 1-1l1 1h7c1 0 1-1 1-1 1-1 1-1 2-1h4l1-1c0-1 1-1 1-2m-18 5s0 1 1 0c0-1-1-1-1 0zM27 41h4l1 1c1 0 1 0 2 1l-1 1c-1 0-1 0-1-1s0-1-1-1H13c-1 0 0-1-3 1 0 0-3 4-4 4l-1 2-2 1s0 1-1 1l-1 1-1 1c0-1 2-2 2-2v-1l1-1 3-2 4-4 2-2h15m6 2c0 1 0 1 0 0 1 0 0 0 0 0s-1 0 0 0zM97 42s1 1 0 1c0 1 0 1-1 0v-1h1m0 0c-1 0-1 1 0 1 0 0 1 0 0-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M27 42h3s1 0 1 1v1c-1 0-2 0-2-1H12l-2 2-1 1s-3 3-4 3l-3 3c0 1-2 2-2 2l1-1 5-5s2-2 3-2l1-2 2-2h15m3 1v1l1-1h-1zM60 42c1 0 1 0 1 1v1c-1 0-2-1-1-1v-1m0 1c0 1 0 1 1 1v-1h-1zM49 42c1 0 2 2 1 2s-2-1-1-1v-1m0 1c0 1 1 1 1 0h-1zM52 42c1 0 1 1 0 2 0 0-1 0-1-1l1-1m0 1v1c1 0 1-1 1-1-1-1-1 0-1 0zM55 42l1 1c0 1-1 1-2 1v-1s0-1 1-1m0 1v1-1zM57 42c1 0 2 1 1 2h-1v-2m0 1c1 1 1 1 1 0h-1zM38 42c1 0 1 1 1 1v1c-1 0-2-1-1-1v-1m0 1s0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M15 43h14v1h3c2 0 2 0 2 1h1c0 1 0 1 4 1 0-1 1-1 1-1 1 0 2 1 1 1 0 1-1 0-1 1l-1-1h-4c-1 0-1-1-2-1h-3c-1 0 0 0-2-1 0-1 1-1-7-1h-8c0 1-4 4-4 4l-3 3-1 1s-1 0-1 1l-2 2s-2 1-2 2v-1l2-2 1-1s2-1 2-2l2-1c0-1 2-3 3-3l2-2 1-1h2m25 3h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M13 44h2v1h-2c-1 1-2 1-2 1v1h-1v1c-1 0-2 1-2 1l-2 2s-3 3-3 4c-1 0-3 2-3 2v-1c1 0 4-3 4-3l4-4 2-2 2-1c0-1 0-1 1-1v-1m1 0v1s1-1 0-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M20 44h6l1 1h1v1c-1 1-1 1-1 0l-1-1H16l-1 1h-2l-5 5c-1 0-3 2-3 2 0 1-2 3-2 3-1 0-3 2-3 2l1-1 3-3 2-2 1-1c1 0 1 0 3-3 0 0 2-2 3-2h1c1 0 1 0 1-1l1-1h4m7 1v1c0 1 1 0 1 0 0-1 0-1-1-1zM104 45h8-7c-1 0-1 0-1 1h-2s0 1-5 0v1h-1c0 1 0 1-1 1h-6c0-1-1-1-1-2H77c-1 1-1 0-1-1h1c1 0 1 1 1 1h10l1 1h7l1-1h6l1-1m-27 1v-1s-1 1 0 1zM68 45h1v1c1 0 0 0 0 0-1 1-1 0-1 0v-1m0 0v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M32 45c1 0 2 0 2 1l-1 1c-1-1-1-1-2-1h-2c-2 2 0 1-5 1H13s0 1-1 1v1h-1l-2 2s-3 2-3 3l-3 3c-1 0-3 2-3 3v-1l1-1 3-2 2-3 3-2 2-2 2-2h15v-1h3c1 0 1 0 1-1m1 1c-1 0 0 0 0 0 0-1 0-1 0 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M24 45c1 0 2 1 1 1 0 1-1 1-1 0v-1m0 1c1 0 1 0 1-1 0 0-1 0-1 1zM65 45c1 0 1 0 1 1s-1 1-1 0v-1m0 1h1v-1c-1 0-1 1-1 1zM105 46s1 0 1-1c0 1 2 1 2 1h4-2s-1 1-1 0h-4l-1 1h-6c-1 0-1 0-1 1h-5c-3 0-3 1-3 0l-1-1H75v-1h-2c0 1 0 1-1 1h-2v1h-1v1c-1 0-1 0-1-1h1v-1h3l1-1h2c1 0 1 1 1 1h13v1h7l1-1h6c1-1 1-1 2-1 0-1 0 0 0 0m-37 2s0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M53 46h10c1 0 1 1 1 1l2 1v4h4v2l1 1h2v3h1c1 0 1-1 2-1h10s1-2 2-2h4c1-1 1 0 1 0v1h-5c-2 2-2 2-3 2h-9l-1 1v1h-1v-1h-1v-3c0-1-1-1-2-1h-1v-2h-3l-1-1v-2c0-1 0-1-1-1l-2-2H44c-4 3-3 3-4 3h-3v2l-3 3c0 1 0 0-1 0 0 0 0 1-1 0v2s0 1-1 1h-2l-1 1v7s0 1-1 1c0 1-2 3-3 3v5h-1v-5s1 0 3-2l1-2v-6c0-1 0-1 1-1l1-1h2v-2l1-1h1c1 0 1 0 2-1 0-1 1-2 1-2h1v-2c1-1 2 0 3-1h1c0-1 1-1 1-1v-1l2-1h9m39 9v1c1 0 1-1 1-1h-1m-18 4c0 1 0 1 1 1v-1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M105 46h3c1 1 1 1 2 1h2v1h-3l-1-1c0-1 0-1-1-1-2 0-2 0-2 1-1 0-1 1-1 1h-6l-1 1h-8c-1 0-1 0-1-1H76l-1-1h-2c-1 1-1 1-1 2-1 0-2-1-1-1h1l1-1h2l1 1h12c1 1 1 1 3 1h5l1-1c1 0 1-1 1-1h6l1-1m-34 2v1c1 0 1-1 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M105 47h1c2 0 1 0 3 1l1 1c0-1 0-1 1-1l1 1h-1c0 1 0 0-1 0h-1c-1-2-1-2-2-2h-2l-1 1h-2c-4 0-4 0-4 1-1 1-1 1-2 1h-7c-1 0-1 0-2-1H74c-1 0-1-1-1-1 1 0 1-1 2 0h12v1h1v1h8l1-1 1-1h6l1-1m-31 1v1s1 0 1-1h-1zM29 47h3c0 1 1 1 1 1 1 0 1 1 0 1h-1v-1s0-1-1-1h-2s0 1-1 1H14c-1 0-1 0-1 1l-2 1c0 1-1 1-1 1 0 1-1 1-1 1v1H8l-1 1v1c-1 0-1 0-2 1l-2 2-3 3v-1s5-4 5-5c0 0 2-2 3-2l2-2 2-2 1-1h15v-1h1m4 2v-1c-1 0-1 1 0 1zM51 47h9l1 1v1h-1s0-1-1-1H45l-1 1c-2 2-2 1-2 2v1h-1c-1 0-1-1 0-1 0-1 1-1 1-1l1-1 1-1 1-1h6m9 1v1c1 0 1 0 1-1h-1m-19 3v1l1-1s-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M106 47h1l1 1 2 2h1l1 1v1h-1s-1 0-1-1v-1l-3-2h-1l-1 1h-6l-2 2H87s0-1-1-1H73v2s0 1 1 1h1v1c-1 1-1 0-2 0v-4c0-1 4 0 4 0l4-1c5 1 5 0 5 1h1c1 1 1 1 3 1h6c1-1 1 0 1-1 0 0 1-1 2-1h5s0-1 1-1c0 0 0-1 1-1m5 4c-1 0 0 1 0 1l1-1h-1m-37 3c1 0 1 0 1-1 0 0-1 0-1 1zM30 48h1c0 1 0 1-1 1h-1c0-1 0-1 1-1m0 1c1 0 1-1 0-1v1zM38 48c1-1 2 1 1 1h-1v-1m0 0v1c1 0 1 0 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M107 49v1l2 2h3v1h-2c-1 0-1-1-2-2l-1-1h-1s-1 0-1-1c1 0 1-1 2 0zM52 49h7l2 3c2 1 1 1 2 1h1v1l1 1v5c0 1-1 1-1 1v1s0 1-1 1c0 0-1-1 0-2h1v-6h-1s0-1-1-1c0-1 1-1 0-1l-2-2-1-1c-1-1 0-1-2-1-1 1-1 0-1 1v7c0 3 0 1-2 4h-1v1c0 1-1 1-1 1-1-1-1-1 0-2h1v-1l2-1v-9c0-1-1 0-1-1l-4 1s-3-1-4 0c-1 0-1 0-1 1v1c-1 0-2-1-2-1l1-1c1 0 1 0 1-1h7m-8 2c-1 0 0 1 0 0m19 2c0 1 0 2 1 1 0-1-1-1-1-1m-11 8v1h1c0-1-1-1-1-1m11 1h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M103 50v1h3c1 0 1 0 1 1 2 1 2 2 2 2h3-3l-2-2c-1-1 0 0-3 0-1 0-1-1-1-1h-2c0-1 1-2 2-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M104 50c0-1 1-1 1 0 0 0 0 1 1 1s0-1 3 1c0 1 0 1 3 1h-3l-2-2h-3v-1c-1 0 0 0 0 0m0 0c0 1 0 1 1 1v-1c0-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M99 50h1c1 0 1 1 1 1s0 1 1 1h4l3 2h3-3c0 1 0 1-1 0 0 0-1 0-1-1l-1-1h-5s0-1-1-1h-1v-1m0 0c0 1 1 1 1 1v-1h-1zM57 50h1c1 0 1 1 0 1 0 1-1 1-1 1v6c0 1 0 1-2 3v5s0 1 1 1l1 2c4 3 2 2 5 3 1-1 4-1 5-1 3 0 3 0 3 1l3 2h11c1 0 1 0 1 1h-1c0-1 0-1-1-1H73c-1 0-2-1-2-2H60l-1-1-2-2c-3-3-2-2-2-4v-4l1-2v-7h1v-2m0 1h1c0-1-1-1-1 0zM49 50h1c1 1 0 2 0 2-1 0-1-1-1-1v-1m0 1h1c0-1-1-1-1 0zM77 50l1 1-1 1c-1 0-1-1-1-1s0-1 1-1m0 1c1 0 0-1 0-1s-1 1 0 1zM71 50c1 0 1 1 1 1v1h-1s-1-1 0-1v-1m0 1c1 1 1 0 1 0-1-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m74 50 1 1c0 1 0 1 1 1v2l1 2h7l3-3h8l1 1c0 1 1 1 1 1h2l1 1c0 1 1 0 1 0h3c2 0 2 1 2 0 1 0 1 0 1-1h1c1 0 1 0 1 1h-2l-1 1h-6l-1-1c-1-1 0-1-2-1 0 0 0 1 0 0l-2-1c-1-1 0-1-2-1h-6l-1 1-1 2h-8l-1-2h-1v-2s-1 0-1-1h-1c1 0 1-1 1-1m0 1c0 1 1 0 1 0s-1-1-1 0zM35 50c1 0 1 1 1 1v1h-1c-1 0 0 1-1 1H24l-1 1c-1 0 0 0-1 3v4l-1 1s-1 0-1 1v12-13c2-1 2-2 2-2v-6l1-1s0-1 1-1h10c1 0 1 0 1-1v-1m0 2c1 0 1 0 1-1-1 0-1 0-1 1zM38 50h1v1c0 1-1 1-1 1v-2m0 1v1c1 0 1-1 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m32 51 1-1v1c1 0 1 1 0 1H23c-1 1-1 1-1 2v5s0 1-1 1l-1 1v1s-1 5-1 8v5-13l2-2v-7h1v-1h9c1 0 1 0 1-1m0 0 1 1v-1h-1zM92 51h2c2 0 2 0 2 1 0 0 1 1 2 1h6c1-1 1 0 2 0 0 1 0 1-1 1h-1c0-1-1 0-1 0h-5s0-1-1-1l-1-1H81v1c0 1 0 1-1 1 0 1-1 0-1 0 0-1 0-1 1-1h1c0-1 1-1 1-2h10m13 2c-1 0-1 1 0 1v-1m-26 0c0 1 0 1 1 1 0 0 1-1 0-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M92 52h3l1 1 1 1h3s1 0 1 1h1s0 1-1 1h-1v-1c0-1 0 0-3 0 0 0 0-1-1-1 0 0 0-1-1-1v-1h-6s-2 0-3 1c0 0 0-1-2 2h-6s-1 0-1-1c-1 0-1 0-1-1h2v1s0 1 1 1h5v-1l2-1v-1h6m-15 1v1c1 0 1-1 0-1zM46 52c8 0 7 0 8 1v5h-3v2l-1 1v2c0 1 1 1 1 1l2 2v2c1 0 2 1 2 1s3 3 3 4h11l1 1c1 0 1 1 1 1h-1c0-1-1-1-1-1v-1c-1 0-7 1-8 1-2 0-2 0-2-1 0 0-3-2-4-3l-2-2v-1c0-1-3-3-3-3v-4h1v-2h1c1 0 1 0 1-1 1 0 1 0 1-1v-3H42v1l-1 1c-1-1-1-1 0-2h1v-1h4m-5 2h1c-1-1-1-1-1 0zM14 53c0-1 1-1 1 0 1 0 1 1 0 1h-1v-1m0 0c1 1 1 0 1 0s-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M82 53c1 0 1 0 1 1 0 0 0 1-1 0v-1m0 1h1v-1c-1 0-1 0-1 1zM65 53c1 0 2 0 2 1 0 0-1 1-1 0h-1v-1m1 0c-1 1 0 1 0 1s1 0 0 0v-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M71 53c1 0 1 0 3 2h1l1 1c1 1 0 0 2 0h3c5 0 4 1 5 0l2-2h6l2 2h3c1 1 1 2 1 2h6l1-1h2l1-1v-1c1 0 2 1 1 1 0 1-1 0-1 1h-3c-1 1 0 1-3 1h-4l-2-2h-2l-2-2h-5c-2 0 0-1-3 2l-1 1h-9l-1-1v-1h-1c-1 0-1-1-1-1h-1s-1 1-1 0v-1m0 0s0 1 1 1v-1h-1m39 3h1v-1s-1 0-1 1zM57 53h1c1 1 0 1 0 2v4h-1c-2 3-1 2-1 4v3l2 2 3 3h11c0 1 1 2 1 2h11c1 0 1 1 2 1v1l-1-1c-1 0-1-1-1-1H74c-1 0 0 1-3-1-1-1 0-1-2-1h-5c-4 0-3 0-4-1-1 0-4-3-4-4-1 0-1 0-1-5 0 0 1 0 2-2 1 0 1 0 1-1v-3s-1 0-1-1v-1m0 1h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M60 53h1v1c-1 1-1 0-1 0v-1m0 1h1v-1s-1 0-1 1zM44 53l1 1v1h1v11c-1 1-1 0-1 2 0 1 1 1 1 1h2l1 1s2 1 2 2l2 2s1 0 1 1h-1c0-1-1-1-2-2l-2-2v-1h-3l-1-1V55c-1 0-2 0-2-1s0-1 1-1m0 1v-1s-1 0 0 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M49 53s1 0 1 1-1 1-1 1l-2 2c-1 0 0 0 0 0v3c0 5-1 5 0 5l1 2c1 0 1 0 1 1s-1 0 3 3c0 0 3 3 3 4l-1-1-3-3c-3-3-3-2-3-3v-1l-2-2v-8l1-1 1-1 1-1v-1m0 0v1h1c0-1-1-1-1-1zM52 53h1c0 1 0 1-1 2l-1-1c0-1 1-1 1-1m0 1h1c-1-1-1-1-1 0zM68 53h1v1s1 0 0 0v1h1v5c1 0 3 2 3 2l1 1h4l1 1v2h7c1 0 1-1 3 2 0 0 2 1 4 4h11l3 3h-1v-1c-1 0-2-1-2-2H93l-2-2c-1 0-4-4-4-4h-8c0-1 0-1-1-1v-2h-4c-1 0-1 0-1-1l-2-1c-1-1-1 0-1-4 0-1 0-1-1-2l-1-1v-1m0 0c0 1 0 1 1 1 0-1 0-1-1-1zM30 53s1 0 1 1l-1 1c-1 0-1-1-1-1h-5s0 1-1 1v11l-2 1v8-8l1-1c1-1 1 0 1-2v-9l1-1h5c0-1 0-1 1-1m0 1h1c-1-1-2-1-1 0zM38 53h1v2h-2v2s1 0 1 1v13c1 1 2 2 2 3 1 0 1 1 1 1 0-1-2-2-2-3-1 0-1 0-1-1-1 0 0 0 0-2V58l-1-1v-2c0-1 0-1 1-1v-1m0 1h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M74 56h1v1h-1v-1m0 1c1 0 1 0 1-1h-1v1zM63 56h1v1h-1l-1 1v2c0 1-1 1-1 1v2c1 0 2 1 2 2l3 2h7l1 1 1 2h11l4 4 1 1h-1c0-1-3-3-3-3-2-2-1-2-2-2H75s0-1-1-1l-1-1h-6c-1 0-1 0-2-1l-4-3v-4c1 0 1 0 1-1v-3h1m0 0v1h1c0-1-1-1-1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M66 56h1c0 1-1 1-1 1-1 0-1-1-1-1h1m0 1c1 0 1-1 0-1 0 0-1 0 0 1zM68 56c1-1 1 0 1 0 1 0 1 1 0 1s-1 0-1 1v4c1 1 0 1 1 1h2l1 1c1 1 0 1 2 1h1s0 1 1 1c1 1 1 1 2 1h6c2 0 2 0 3 1l4 4 2 2h11v1l-1-1H93l-1-1-4-4-2-1h-8c-1 0-1 0-1-1-1 0-2-1-2-1l-1-1h-1c-1 0-1-1-1-1h-1v-1h-3c-1-1-1-1-1-2v-2c0-2 0-1 1-2v-1m0 1h1v-1s-1 0-1 1zM49 56c1 0 2 0 1 1h-2c-1 0-1 1-1 1v6l1 1 2 2c0 1 0 1 1 2l4 4 2 2h-1c0-1-2-2-2-2l-3-3c-2-2-1-1-1-3h-1l-1-1c-1-2-1-1-1-3v-6l1-1h1m0 0c0 1 1 1 1 0h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M52 56c0-1 1 0 1 1h-2c0 1-1 1-1 1h-2v1c0 6 0 5 1 6l2 2v1l1 1 3 3s3 2 3 3h-1v-1l-4-4-2-2h-1v-1l-2-2v-7h2l1-1c0-1 0-1 1-1m0 1s1 0 1-1h-1v1zM60 56h1c0 1 0 1-1 2l-3 3v5l2 2c2 1 2 2 2 2h10c1 0 1 1 2 1l1 1h11c0 1 2 2 2 3 0-1-2-2-2-2H74s0-1-1-1c-2-1-2-2-2-2H61l-1-1s-2-1-2-2c-1 0-1-1-2-1v-4c0-1 0-1 1-2l2-2c1 0 1 0 1-1 0 0-1-1 0-1m0 0v1s1 0 1-1h-1zM71 56h1v1c0 1-2-1-1-1m0 0c0 1 1 1 1 0h-1zM44 56c0-1 1 1 0 1 0 0 0 1-1 1v12l2 2s3 2 3 3h-1c0-1-1-2-1-2l-4-3V59c0-1 0-1 1-1v-2h1m0 0v1s1-1 0-1zM29 56h1c1 0 1 0 1 1h-2l-1 1-1 1v7l-3 3c-1 0-1 1-1 1v5h-1v-5l1-1 2-2 1-1v-7l1-1s1-1 2-1v-1m1 0v1s1-1 0-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M38 56c0-1 1 0 1 1v14s3 2 3 3c1 0 1 0 1 1h-1c0-1-3-3-3-3l-1-1V57s-1-1 0-1m0 1h1c0-1-1-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M40 56c1 0 2-1 2 0v1h-1c-1 0-1 1-1 1v11s-1 1 0 1l2 2c1 1 2 2 2 3v-1l-2-1c-2-2-2-2-2-3-1 0-1 0-1-3v-9l1-1v-1m1 0v1h1s0-1-1-1zM35 56c1 0 2 0 1 1v1h1v17-16l-1-1-1-1v-1m0 0v1h1v-1h-1zM27 56h1s0 1-1 1 0 1-1 1v8h-1c0 1-2 3-3 3v6h-1v-4c1-2 0-1 1-2l3-3v-1l1-2v-6c0-1 0-1 1-1m0 0v1c1 0 1-1 1-1h-1zM24 56c1 0 1 0 1 1 0 0-1 1-1 0 0 0-1-1 0-1m0 0v1s1 0 1-1h-1zM32 56h1c1 0 1 1 1 1-1 0-1 1-1 1-1 0-1 0-1 1v1c-1 0-1 1-1 1h-2v3c0 3 0 3-1 3l-3 3v5-3c0-2-1-1 0-2l3-3v-4c0-2 0-2 1-2 0-1 0-1 1-1h1v-1l1-1v-2m0 1h1c1 0 0-1 0-1s-1 0-1 1zM97 57c1 0 2 1 1 1h-1c-1-1 0-1 0-1m0 0v1c1 0 1-1 0-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M90 57s0 1 1 1c2 0 1-1 2 0l1 1h7c2 0 2 0 3 1v-1h2c1 0 1 1 1 0 1 0 1-1 1-1h4v1h-4c-1 1-1 1-2 1h-8c-5 0-4 0-5-1l-1-1h-3c0-1 0-1 1-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M94 57s1 0 1 1v1h12c0-1 0-1 1-1h4-4l-1 1H94s-1-1 0-2m0 1s0 1 1 0v-1c-1 0-1 1-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="m76 59 1-1h11c0 1 0 1 1 1h3l1 1h19v2H93s0-1-1-2H77l-1-1m1 0c0 1 1 0 1 0 0-1-1-1-1 0zM60 58h1v2h-1v4h1s2 2 2 3l2 1h8c0 1 2 2 2 2v1h10c1 0 0 0 1 1 1 0 3 2 3 2v1c0-1-3-3-3-3-1-1 0-1-4-1h-7c-1 0-3-2-3-2 0-1 0 0 0 0h-5c-3-1-2 0-3-1-3-3 0-1-3-3 0-1-1-1-1-1v-6m0 1s0 1 1 1v-1c0-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M63 58s1 0 1 1v1c-1 0-1 0-2 1v2h1c0 1 3 3 3 3 0 1 0 1 1 1h6c1 0 1 0 3 1 0 1 0 1 1 1h9l1 1 4 4s1 0 1 1h-1c0-1-3-3-3-3s-1-2-2-2c0-1 0-1-1-1h-9l-1-1-2-1h-7l-1-1-1-1-2-2v-2c0-1 1-1 1-1l-1-1s1 0 1-1m0 1s0 1 1 0c-1-1-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M66 58s1 1 1 2c-1 0-1 0-1 1v4s1 1 2 1h6c1 0 2 2 3 2h7c3 0 2 0 3 1 1 0 3 3 3 3s3 2 3 3h-1c0-1-2-2-2-2 0-1-3-4-4-4 0-1 0 0 0 0-10 0-9 0-10-1-3-2-2-2-3-2h-5c-1 0-1 0-1-1-1 0-1 0-1-1v-4l-1-1 1-1m0 1h1-1zM71 58c1 0 1 0 1 1 1 0 0 0 1 1h14s0 1 1 1h3s1 0 1 1h-5v-1H75c-2 0-2 0-2-1h-2v-2m0 1c1 1 1 0 1 0h-1m19 2c0 1 1 1 1 1v-1h-1zM4 58l1 1c0 1-1 1-1 1-1 0-1-1-1-1l1-1m0 1H3h1c0 1 0 1 0 0zM49 59c1-1 2 0 1 1s-1-1-1 4h1v1c2 2 2 1 2 2s1 1 1 1l3 3c0 1 3 3 3 3h10v1l-1-1H58l-1-1-4-4s-1-1-1-2h-1c0-1 0 0-2-3v-5m0 0v1c1 0 1-1 1-1h-1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M52 58s1 0 1 1v1c-1 0-2 1-2 2s0 0 1 2c3 2 2 1 2 3l1 1 2 1c0 1 2 3 2 3 1 1 0 0 5 0h5c1 0 1 0 2 1 0 0 1 1 1 2l-2-2H60c-1 0-1-1-1-1-1 0-2-2-2-2-1 0-3-3-3-3 0-1 0-1-1-2l-2-2v-3h1l-1-1s1 0 1-1m0 1s0 1 1 1v-1h-1zM41 58c1 0 1 1 1 2h-1l-1-1c1 0 1-1 1-1m0 1v1c0-1 1-1 1-1h-1zM43 59c1-1 2 0 2 0 0 1-1 1-1 1v10c1 1 1 0 3 0h1l2 2c1 1 2 2 2 3 0-1-1-1-1-2-1 0-3-2-3-2 0-1 0 0-1 0h-2c0-1 0-1-1-1v-9c0-1-1-1-1-1v-1m1 0c-1 0 0 0 0 0v1c1-1 1-1 0-1zM32 59c1-1 2 0 1 1-1 0 0 0-1 1 0 0-1 5-1 6v8-14c1 0 1-1 1-1v-1m0 0c1 1 1 1 1 0h-1zM35 58c1 0 1 1 1 1 1 0 0 1 0 1h-1c-1 1-1 1-1 2s0 1 1 1l1 1v11-10l-1-1-1-1v-2c0-1 0-1 1-1v-2m0 2c1 0 1 0 1-1-1 0-1 0-1 1zM30 59h1s0 1-1 1l-1-1h1m0 0v1-1zM69 61l1 1h1l1 1 1 1h2l3 2c0 1 0 0 3 1 4 0 5-1 6 0l2 2 3 3 1 1h11s1 1 1 2l-1-1-1-1H93l-3-3-3-3H77s-2-2-2-3h-2l-2-2h-1l-1 1c-1-1-1-1-1-2h1m-1 1h1c0-1 0-1-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M79 61h1c1 0 1 1 1 1h4l2 1c0 1 2 2 2 3 1 0 2 2 2 2 1 1 1 1 2 1h11l2 2c1 1 4 3 4 4h-1c0-1-1-1-1-1 0-1-4-4-4-4-1-1 0-1-6-1h-6l-4-3c-2-2-2-3-2-3-2-1-1-1-3-1h-2c-1 0-1 1-1 1l-1-1v-1m1 1s1 0 0-1v1zM57 61h1c1 1 1 1 1 2v1s0-1 4 3l1 2h8l2 2c1 1 2 0 3 0 0 0 1 1 1 0h6s1 0 1 1c0 0 2 2 3 2v1c0-1-2-2-3-3H75c-1 0-1 0-1-1l-2-1c0-1-1-1-1-1h-7l-4-4c-1-1-1-1-1-2h-1s-1 0-1-1v-1m0 1h1c0-1 0-1-1 0zM74 61h1c1 1 0 2-1 2-1-1 0-2 0-2m0 1c1 0 1-1 1-1-1 0-1 0-1 1z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M77 61c1 0 1 1 1 1 1 0 1 1 1 1 3 0 2 0 3 1s0 0 3 0c2 0 1 0 2 1l3 2s2 3 3 3h10c1 0 1 1 4 4 0 0 1 0 1 1l-3-3-1-1H94c-1 0-1 0-2-1l-1-1-3-3c-2-1-1-1-2-1h-3l-1-1c-1-1-1-1-2-1h-2c0-1 0 0-1 0 0 0-1-1 0-2m0 1c1 0 1-1 0-1v1zM40 62c1-1 1-1 2 0l-1 1v7h1l2 3s2 1 2 2l-2-2-3-3v-7l-1-1m1 0h1l-1-1v1zM35 61c1 0 2 1 1 2-1 0-1-1-1-1v-1m0 1h1v-1s-1 0-1 1zM32 61c1 0 1 0 1 1 1 0 0 1 0 1v2c1 1 1 0 1 1h1v1h-2c-1 1 0 1 0 1h2v2h-2v1h2v2h-2v1h2v1l-1-1h-2v-1c1 0 1-1 1-1h2c-1-1-2 0-2-1h-1v-1h1c1 0 1 0 2-1h-2l-1-1c0-1 0-1 1-1h2c0-1 0-1-1-1h-1c-1 0-1-1-1-2v-3m1 1v-1c-1 0-1 1 0 1zM29 62c0-1 1-1 1-1l1 1c-1 1-1 0-1 4v2c0 1 0 1-1 2h-2s0 1 1 1h2v1h-2c-1 0-1 0-1 1-1 0-1 0 0 0h3v2-1h-3s-1 0-1-1v-1h3c1 0 1-1 0-1h-2c-1 0-1-1-1-1h1s0-1 1-1h1c1-1 1 0 1-2v-4h-1v-1m1 0c-1 0 0 0 0 0s1 0 0-1v1zM101 62s1 1 0 2c-1 0-1-1-1-1 0-1 0-1 1-1m-1 1h1v-1s-1 0-1 1zM111 62s1 1 0 2c0 0-1 0-1-1 0 0 0-1 1-1m-1 1s1 1 1 0-1 0-1 0z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M88 63c0-1 1-1 1 0l1 1s2 3 3 3h9c2-2 1-1 3-1h7-9l-1 1H92c-2-3-2-3-3-3h-1v-1m0 0s0 1 1 1v-1h-1zM2 63c1 0 1 0 1 1H2v-1m0 0v1h1v-1H2z"
          />
          <path
            className="CyberEl89_svg__fil0"
            d="M91 63c1 0 1 0 1 1 0 0 0 1 1 1h19-20v-1h-1c-1 0-1 0-1-1h1zM0 64c1 0 1 1 0 1 1 0 1-1 0-1zM69 64c1 0 1 1 0 1 0 0-1 0-1-1h1m-1 0 1 1v-1h-1zM77 64c1 0 1 0 1 1 0 0-1 1-1 0-1 0-1-1 0-1m0 0v1s1 0 1-1h-1zM80 64s1 0 1 1c0 0-1 1-1 0-1 0-1-1-1-1h1m0 0v1s1 0 1-1h-1zM57 64h2c0 1-1 1-1 1-1 0-1 0-1-1m0 0c0 1 1 1 1 1v-1h-1zM21 64c1 0 1 0 1 1 0 0-1 1-1 0v-1m0 1h1v-1s-1 0-1 1zM24 64s1 0 1 1c0 0-1 1-1 0h-1l1-1m0 0v1h1c0-1-1-1-1-1zM110 67h2-1s0 1-1 1v1c-1 0-2-1-1-1s1-1 1-1m-1 1s0 1 1 1v-1h-1zM46 68c1-1 2 0 1 0 0 1 0 1-1 1v-1m0 0v1c1 0 1-1 1-1s-1-1-1 0zM112 70v-1 2h-2s0-1 1-1h1m-2 0s0 1 1 1v-1h-1zM112 72v1c-1-1-1-1 0-1zM50 74s1 0 1 1h-2v-1s1-1 1 0zM40 75h-2c0-1 1-1 2 0z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl89;
