import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl88 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2300}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 129 129"
      {...props}
    >
      <defs>
        <style>{".CyberEl88_svg__fil0{fill:#000}"}</style>
      </defs>
      <g id="CyberEl88_svg__Vrstva_x0020_1">
        <g id="CyberEl88_svg___2649068362208">
          <path
            className="CyberEl88_svg__fil0"
            d="M0 0v4l1 1v2H0v5h1v2l-1 1v5h1v2H0h1c2 3 4 5 6 7h18v-8c1-1 2-2 2-3v-1c0-1 1-1 1-1h1c2-2 4-4 6-5V9s0-1 1-1h1l3-3V0h1v5l-3 3-1 1v1s0 1-1 1h-1l-2 2-3 3v1c0 1-1 1-1 1h-1l-2 2c0 1-1 1-1 1v9H7l-7-7v-2h1l-1-1v-6l1-1H0V6h1L0 5V0zm36 9s-1 0-1 1h1c1 0 1-1 0-1zm-8 8s0 1 1 1v-1s-1-1-1 0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M3 0v18h21c3-2 5-4 7-7l6-6V0h1v5l-1 1c-1 2-3 3-5 5l-6 6c-1 1-1 2-2 2H3V0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M5 0h1v1h1v2H6v5c1 0 1 1 1 1v1c0 1-1 1-1 1v4h18c1 0 1-1 1-1v-1c0-1 1-1 1-1h1c2-2 4-4 6-5V5l1-1V0h1v5s1 0 0 1c0 1 0 1-1 1h-1l-3 3c-1 1-1 2-2 2v1c0 1-1 2-1 2-1 0-1 0-1-1l-2 2H5c0-2 1-3 0-5v-1c-1 0-1-1-1-1 1 0 1-1 1-1V3C4 3 4 2 4 1h1V0zm0 1v1h1V1H5zm29 4s-1 1 0 1h1V5h-1zM5 9v1h1V9H5zm21 4c0 1 1 1 1 0h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M8 0h1v12h15c2-2 4-4 7-6V0v6c-2 2-4 5-7 7H8V0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M11 0h1v9c0-1 1-1 1-1 1 0 1 0 1 1h2c0-1 1-1 2-1v1h2c0-1 0-1 1-1 0 0 1 0 1 1h1l1-1h1c1 0 2-1 2-2h1V0v6c-1 1-1 2-2 3 0 1 0 2-1 2h-1s0-1-1-1h-1s0 1-1 1c0 0-1 0-1-1h-2s0 1-1 1h-1v-1h-2v1c-1 0-2 0-2-1h-1V0zm10 9h-1c0 1 1 1 1 1V9zm4 0h-1v1h1V9zM13 9v1c1 0 1-1 1-1h-1zm4 0c-1 1 0 1 0 1h1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M14 0h1v4c1 0 1 1 1 1 1 1 0 1 0 1h9V0v6s0 1-1 1H14V0zm1 5v1h1c0-1-1-1-1-1zM43 0h1v1h1v1s0 1-1 1v2c-5 5-10 11-15 16h-1v12H7c-2-3-5-5-7-7v-1l7 7h21V20L43 5V3c-1 0-1-1-1-1 0-1 1-1 1-1V0zm0 1v1h1V1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M46 0h1v5s0 1-1 1L31 21v14s1 0 1 1v1h-3v-1h-1c0 1 0 1-1 1h-1c-1 0-1-1-1-1h-1v1h-2l-1-1h-1v1h-1c-1 0-1 0-1-1h-1c-1 0-1 1-1 1-1 1-1 0-2 0v-1h-1c0 1-1 1-1 1h-2v-1H9v1H7s-1 0-1-1c0 0 0-1 1-1l-3-3-3-3c0 1-1 1-1 1v-1s1 0 1-1H0v-1h1v2l1 1c1 1 2 2 3 2 0 1 1 2 2 3h24V20L46 5V0zM7 36c0 1 1 1 1 0 0 0 0-1-1 0zm4-1v2c1 0 1-1 1-1s0-1-1-1zm4 0c0 1-1 1 0 1 0 1 1 1 1 0l-1-1zm4 0c-1 1-1 1 0 2 0 0 0-1 1-1l-1-1zm4 1h-1c0 1 1 1 1 0s0-1 0 0zm3 0s0 1 1 1v-1s0-1-1 0zm4 0c0 1 1 1 1 0 0 0-1-1-1 0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M53 0c0 1 1 1 0 2l-2 2-1 1c1 0 1 0 1 1s-1 1-2 1h-1l-5 5v2l-1 1c-1 0-1-1-1-1l-5 5-1 1v1c1 0 0 1 0 1h-1v5h1c0 1 1 1 0 2v1h-1v5c1 0 1 0 1 1 1 0 0 1 0 1h-1v1l-1 1H7c-2-3-5-5-7-7v-1l7 7h26c1 0 1-1 1-1h-1v-2h1v-5c-1 0-1-1-1-1v-1s0-1 1-1v-5h-1v-2c1-1 1 0 2 0 0-1 0-1 1-1 1-2 3-4 4-5 0-1 0-1 1-1 0-1 0-1 1-1s1-1 2-1l3-3c0-1 1-1 1-2V5l1-1h1c1 0 2-1 2-2 1 0 1 0 1-1V0zm-4 5v1h1V5h-1zm-7 8c-1 0-1 0-1 1h1v-1zm-8 7s-1 1 0 1c0 1 1 0 1 0l-1-1zm0 8s-1 0 0 1h1c0-1-1-1-1-1zm0 8v1l1-1c-1 0-1-1-1 0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M56 0v1h9c2 2 3 3 4 5 3 3 6 6 9 8l6 6v19h19c1 0 1 0 1-1 4-4 9-8 13-12V0v26h5c2 3 5 5 7 8l-8-8h-4l-13 13v4l15 15h2c3-3 5-6 8-8l-8 8h-2v47c-1 0-1 0-2 1v23-23l2-2V58c-4-4-8-7-11-11l-5-5v-2H84c-2 2-5 4-7 7v42l-5 5H61c-2 2-5 4-7 7v3l2 2v23-23c-1-1-2-1-2-2v-3h-7L37 91V71c-1 1-1 1-1 0-1 0-2-1-1-1v-1c-1 0-1-1-2-2V42H8l-8 8c2-3 5-5 7-7v-2l-7-7 7 7h26l3-3h1V21c1-2 2-3 3-4L51 6c1-1 3-3 5-4V0zm-7 8c-3 4-7 8-11 11 0 1-1 1-1 2v17h16s1 0 1 1h1c0-1 1 0 1 1v1c2 2 4 4 6 5 1 0 2 0 2 1v1c0 1 1 1 1 2h4l3-3h5v-1c1 0 1-1 2-1 2-2 3-4 5-5V21c-2-2-4-4-5-6-2-2-4-3-6-5-2-3-5-5-8-8h-9c-2 2-4 4-7 6zM37 38c-1 1-3 2-4 3v26c1 1 1 2 2 2h1c1 0 1 0 1 1v1h10l6 6h7c3-3 6-6 9-10V50h-4c-1 0-1-1-2-1h-1l-1-1v-1c0-1-1-2-2-3l-3-3h-1c-1 0-1 0-1-1v-1l-1-1H37zm18 1c-1 0-1 1 0 1s1 0 0-1zm7 8v1h1v-1h-1zm10 0-3 3v17c-3 3-6 7-9 10v12l1 1v3h11c2-1 3-3 5-4V47h-5zM36 70s-1 0 0 1l1-1h-1zm1 1v20c2 1 3 3 5 4 2 2 3 4 5 6h7c2-3 5-5 7-7v-4c-1 0-1-1-2-1V77h-6s-1 0-1-1l-4-4c-1 0-1-1-1-1H37z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M66 0h1c1 2 3 3 4 5l1-1c1 0 1 1 1 2 2 2 3 4 5 5l1 1h1l1 1v1l3 3 1 1h29V0h1v19H85l-1-1-4-4v1c-1 0-2-1-2-2s-1-2-2-3l-3-3h-1s-1 0-1-1V5l-1-1-4-4zm6 5s-1 0 0 1c-1 0 0 0 0 0 1 0 1 0 1-1h-1zm8 8c-1 0-1 0-1 1 1 0 1 0 1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M69 0h1c1 1 2 2 3 4l6 6c2 1 4 3 5 4 0 1 0 1 1 1h26V0h1v16H85l-1-1-3-3-6-6-6-6z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M72 0h1v1h1c1 0 1 0 1 1l3 3 3 3h1l1 1v1c0 1 1 1 1 1 0 1 0 1 1 1h23V0h1v13H85l-1-1c-1-1-1-1-2-1h-1l-1-1V9c0-1-1-2-2-3l-3-3h-1c-1 0-1 0-1-1V1l-1-1zm2 1-1 1c1 0 1 1 1 0h1s-1 0-1-1zm7 8v1h1V9h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M75 0h1c1 2 3 4 5 5 1 2 2 3 3 4 1-1 1-1 2-1 0 0 0 1 1 1h1c0-1 1-1 1-1 1 0 1 0 1 1h2V8h2v1h2c0-1 1-1 2 0h1l1-1h1l1 1h1l1-1h1V0h1v10l-1 1c-1 0-1 0-2-1h-1c-1 1-1 1-2 1l-1-1h-1l-1 1s-1 0-1-1h-2c0 1-1 1-2 1v-1h-2v1c-1 0-1 0-2-1h-2c0 1 0 1-1 1l-1-1V9l-1-1-8-8zm10 9v1h1V9h-1zm4 0v1h1V9h-1zm4 0c-1 0-1 0-1 1h1s1-1 0-1zm3 0v1h1V9h-1zm4 0v1h1V9h-1zm4 0v1h1V9h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M78 0h1c1 2 3 4 5 6h17V5c1 0 1-1 1-1V0h1v5c1 0 1 1 1 1-1 1-1 1-2 1H84c-2-3-4-5-6-7zm24 5v1h1s0-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M81 0h1c1 1 1 2 2 3h15V0h1v4H85l-1-1-3-3z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M84 0h13v1H84V0zM120 0v23h1l5 5 3 3v1c-3-3-5-6-8-9h-1V0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M123 0v1h1c1 0 1 1 0 2h-1v5c1 0 1 1 2 1 0 1-1 1-1 2h-1v5h1c1 1 1 2 0 2h-1v4h1l3 3c0 1 1 2 1 2h1v1s-1 0-1 1h1v1h-1v-2c-2-2-4-4-5-6v-4c-1 0-1-1-1-1 0-1 0-1 1-1v-5s-1 0-1-1V9l1-1V3h-1V1h1V0zm0 1v1h1V1h-1zm0 8v1c1 0 1 0 1-1h-1zm0 8v1l1-1s-1-1-1 0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M126 0v22l1 1c1 0 1 1 2 2v1c-1-1-2-3-3-4-1 0 0 0 0 0V0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M128 0h1v5s-1 0-1 1h1v7h-1l1 1v6l-1 1h1v2-1h-1v-2c1-2 1-4 0-5v-3c1-1 0-2 0-3V4c1-1 0-3 0-4zM56 4h9c2 1 3 3 5 4h1c0 1 1 1 1 2h-1c2 1 3 3 4 4 1 0 1 1 2 2h1c1 0 1 0 1 1v1c1 1 2 1 3 2v3l1 1v1l-1 1v5s1 0 1 1c0 0 0 1-1 1v6h1c0 1 0 2-1 2h-1c-1 1-2 1-3 2 0 1-1 1-1 2h-2v-1h-3c-1 1-2 2-3 4h-2c0 1-1 1-1 1l-1-1c-1-1-1-2-2-3-3-2-5-4-7-7l-3-3H39v-2s-1 0-1-1l1-1v-6c-1-1 0-1 0-1v-3c0-1 1-1 1-1 5-6 11-11 16-16zm0 1c-6 5-11 10-16 16v2l1 1v1c0 1-1 1-1 1v5h1v2l-1 1v1h13l3 3 3 3 6 6c0-1 1-1 1-1 1 0 1 0 2 1h1l3-3h3v-1c0-1 1-1 1-1l1 1 3-3v-1h1v-5c0-1-1-1-1-2l1-1v-5l-1-1s0-1 1-1v-3c-1-1-2-2-2-3h-1c-1 1-1 0-2-1l1-1c-1 0-2-1-2-2-2-1-3-2-4-3h-1c-1 0-1-1-1-1V9c-1-2-3-3-4-4h-9zm14 4c-1 1 0 1 0 1 1 0 1-1 1-1h-1zm8 8h-1l1 1v-1zm-38 7c-1 0-1 0-1 1h1v-1zm41 0v1h1v-1h-1zm-41 8h-1c0 1 1 1 1 1v-1zm41 0c0 1 0 1 1 1v-1h-1zm0 7v1h1v-1h-1zm-5 4h-1c0 1 0 1 1 1 0 0 1 0 0-1zm-10 4v1h1v-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M55 7h10c1 0 1 1 2 1 1 2 2 3 4 4 2 3 4 5 6 7 1 0 1 1 2 2v18c0 1-1 1-1 1 0 1-1 1-1 1h-5c-1 2-2 3-3 4h-5l-1-1v-1l-3-3c-1-1-2-2-2-3h-1c-1 0-1 0-1-1v-1l-3-3-1 1c0 1-1 1-1 0-1 0-1 0-1-1h-1c0 1 0 1-1 1 0 0 0 1-1 1 0 0-1-1-1-2h-1c0 1 0 1-1 2 0 0-1 0-1-1-1 0-1 0-1-1V21c5-5 9-9 13-14zm1 1c-5 4-9 8-13 13v10h1s1 0 1 1h1v-1h1c1 0 1 0 2 1h1c0-1 0-1 1-1h1v1h1l3 3c1-1 2 0 2 1v1l4 4c1 1 1 1 2 1s2 1 2 2h3l3-3h5c0-1 1-1 1-1V21c-1-1-1-2-2-3-2-2-5-4-7-6-1-2-3-3-4-4h-9zM44 32h-1v1h1v-1zm3 0v1c1 0 1 0 1-1h-1zm4 0v1s1 0 1-1h-1zm6 4h-1c1 1 1 1 1 0s0-1 0 0zm7 7c0 1 0 1 1 1v-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M56 10h9c1 1 2 1 2 2h2s1 1 1 2h-1l6 6h1c0-1 1 0 1 0v2h-1v5s1 0 1 1v1l-1 1v5c1 0 1 1 1 1 0 1 0 1-1 1v1h-4v1c-1 1-2 1-2 2-1 0-1 1-1 1h-4c-2-2-4-5-6-7-2-1-3-3-5-4 0-1-1-1-1-2h-6s-1 0-1 1h-1c-1-1-1-2-1-2 0-1 1-1 1-1v-5s-1 0-1-1 1-2 2-1c0-1 0 0 0 0l6-6v-1c0-1 0-1 1-1h1c0-1 1-1 2-2zm0 1c-1 0-1 1-2 1v2s0 1-1 1l-1-1c-2 2-4 4-5 6v1s0 1-1 1v5c1 1 1 1 1 2h6l3 3 8 8 1 1h4l3-3h3v-1c-1-1 0-2 0-2v-6c-1 0-1-1 0-1v-6c0-1-1-1 0-2h-1c-1-2-3-4-5-5 0-1 0-1 0 0-1 0-1 0-1-1-1 0-1 0-1-1-1-1-1-2-2-2h-9zm-3 2v1c1 0 1-1 1-1h-1zm15 0v1s1 0 1-1h-1zm-23 7v1h1c0-1 0-1-1-1zm31 0c-1 0-1 1-1 1 1 1 1 0 1 0v-1zm-31 8c0 1 0 1 1 1v-1h-1zm31 0c-1 0-1 1-1 1h1c1-1 0-1 0-1zm0 7-1 1 1 1v-2z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M56 12h2v1h1l1-1c1 0 2 0 2 1h1s0-1 1-1h1s1 0 1 1v1c2 2 5 4 7 7v14h-1c-1 2-2 3-3 4h-4c-2-2-4-4-5-6-1 1-1 1-2 1 0-1-1-2 0-2v-1c-2-1-4-3-5-5h-5v-5c2-2 3-4 5-5 1-1 2-2 2-3h1v-1zm1 1h-1l1 1v-1zm4 0c-1 0-1 0-1 1h1v-1zm3 0v1s1 0 1-1h-1zm-6 1-1 1c-1 0-1-1-1-1-3 2-5 4-7 7v5h4c1 1 3 2 4 4l1 1h1c1 0 1 1 1 1v1l5 5h4l3-3V20l-6-6c-1 0-1 1-2 1l-1-1h-2c0 1 0 1-1 0h-2zm1 18h-1c0 1 0 1 1 1v-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M55 16h12l1 1c0 1-1 1-1 1l2 2s1 0 1 1v14s-1 0-1 1h-4v-1L53 23c-1 0-1 1-2 0v-2l3-3v-1c0-1 0-1 1-1zm0 1h-1l1 1c1-1 1-1 0-1zm11 0v1c1 0 1-1 1-1h-1zm-10 0c0 1 0 1-1 1h-1c-1 1-1 2-2 3v2h1c1 1 2 2 4 3 2 3 5 6 8 9h4V21c-1-1-1-2-2-3h-2v-1h-9z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M56 19h9l2 2v2c0 1 1 1 1 2l-1 1v5s1 0 1 1c0 0 0 1-1 1 0 1-1 1-1 0h-1L54 22v-1l2-2zm0 1c-1 0-1 0-1 1v1l9 9 1 1c0-1 1-1 1-1v-5c-1 0-1-1-1-1 0-1 0-1 1-1v-3c0-1 0-1-1-1h-9zm10 4v1h1v-1h-1zm0 8v1c1 0 1 0 1-1h-1zM116 28s1-1 2-1c0 0 1 0 1 1h2c3 3 5 6 8 8v1l-8-8h-2l-1 1c-1 0-1 0-1-1l-3 3-3 3v1c0 1 0 1-1 1h-1c-1 1-2 2-2 3v2c3 4 7 8 10 11 1 0 1 1 1 1h2s1 0 1 1l3-3v-1c0-1 0-1 1-1h1l3-3-3 3c0 1 1 1 1 1 0 1-1 2-2 2 0 0 0-1-1-1v1c-1 1-2 2-3 2 0 1-1 1-1 1h-2v-2l-12-12v-3c1-1 2-1 3-2v-1c0-1 0-1 1-1h1c1-2 3-4 5-6v-1zm1 0v1h1c0-1 0-1-1-1zm-7 8c-1 0-1 0 0 0 0 1 0 1 1 0 0 0-1-1-1 0zm15 15s-1 0 0 1c0 0 1 0 1-1h-1zm-6 3v2c1 0 1-1 1-1 0-1 0-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M117 31h4s0 1 1 1c0 1 1 1 2 2 0 0 0 1 1 1s1 0 2 1c0 0-1 0-1 1 1 1 2 1 3 2v1l-3-3h-1c-1 0-1 0-1-1v-1l-3-3h-4l-1 1c-1 2-3 3-5 5 0 0-1 1-1 2v2s-1 0 0 0c3 4 6 7 9 10h2c1-1 1-2 2-3 2-1 4-3 6-5l-6 6c0 1-1 2-2 2v1h-2c-3-4-7-7-10-11v-3c1-1 2-2 3-2 2-2 3-4 5-6zm8 4v2l1-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M117 34h4v1c3 2 5 4 7 6v1c-2 3-5 5-7 8h-2c0-1 0-1-1-1-1-1-2-3-4-4-1 0-1 0-2-1v-3c-1 0-2-1-1-2 0 0 0-1 1-1 0 0 0 1 1 1l3-3c0-1 1-1 1-2zm0 1-1 1-3 3v3c-1 0 0 1 0 1v-1c1 0 2 0 2 1v2l4 4h2c2-2 4-4 6-7v-1l-1-1c-2-2-4-3-5-5h-4zm-5 4c-1 0-1 1-1 1h1v-1zm2 4c-1 0-1 1-1 1h1v-1zM0 36c2 2 3 4 5 5v3c0 1-1 1-1 1H3c-1 1-2 2-3 2l3-3c-1 0-1 0-1-1 1 0 1-1 2-1v-1c-1-1-3-2-4-4v-1zm4 7c-1 0-1 1 0 1v-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M117 37h4c0 1 1 1 1 2 1 0 1-1 2 0 0 0 1 0 1 1 0 0-1 0-1 1h1v1c0 1 0 1-1 1l-3 3v1h-2c-1-1-2-3-4-4v-4l2-2zm0 1-1 1c-1 1 0 1 0 1-1 1 0 2 0 2v1l3 3h2c1-1 2-2 3-4v-1h-1c-1 0-1-1-1-1v-1l-1-1h-4zm6 1v1h1c0-1-1-1-1-1zM0 39c0 1 1 1 1 2h1v2c-1 0-1 1-2 1 0-1 1-1 1-2v-1s-1 0-1-1v-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M118 40h3s0 1 1 1v1c0 1-1 1-1 2h-2c0-1-1-1-1-1v-3zm0 1c1 0 0 1 1 1v1h2v-2h-3zM36 41l1-1h16c1 1 2 3 4 4 2 3 5 5 8 8h2v2h1c0 1 0 2-1 2v5c1 1 1 1 1 2-1 0-1 1-1 1v3l-1 1-6 6h-2v1h-1c-1 0-1 0-1-1h-2v1h-1s-1 0-1-1v-1c-2-1-3-3-5-4H37c0-1-1-1-1-1l-1-1V41h1zm0 0v5h1c0 1 1 2 0 2 0 0 0 1-1 1v5c1 0 1 1 1 1 0 1 0 1-1 1v5s1 0 1 1c0 0 1 1 0 1 0 1 0 1-1 1v4h11l5 5h2v1h2c0-1 0-1 1-1s1 0 1 1h1l1-1 6-6v-3c-1-1-1-2-1-2 1 0 1-1 1-1v-5c-1 0-1-2-1-2h1v-1h-1l-5-5-7-7H36zm0 6s-1 0 0 1h1c0-1-1-1-1-1zm0 7c0 1-1 1 0 1 0 1 0 1 1 0l-1-1zm30 0v2c1 0 1-1 1-1s0-1-1-1zm-30 8c-1 0-1 1 0 1s1 0 1-1h-1zm30 0v1h1v-1h-1zM53 73v1s0 1 0 0h1l-1-1zm4 0-1 1s1 0 1 1v-2zM83 43l1-1h17v1c6 5 11 10 16 15v46l-2 2v23h-1v-23c0-1 1-1 1-1l1-1V58l-15-15H83c-1 2-2 3-3 4v3c1 0 1 1 1 1 0 1 0 1-1 1v6h1v2h-1v5h1v2s-1 0-1 1v5c1 0 1 0 1 1 0 0 0 1-1 1v5l1 1c0 1 0 1-1 2v5c1 0 1 0 1 1s-1 1-1 1h-1l-6 6-1 1H62s0 1-1 1h-1c-1 1-2 2-3 2v3c1 0 1 1 1 1v1l1 1v1h1v2h-1v5c1 0 1 1 1 1 0 1 0 2-1 2v5s1 0 1 1v1l-1 1v2h6l2 2h-1l-1-1h-7v-4h-1c0-1 1-2 1-2v-6c-1 0-1-1 0-1v-6c-1-1-1-2 0-2v-2c-1 1-1 1-2 1v-5c0-1 1-1 1-1l3-3h-1c0-1 1-2 2-2 0 0 0 1 1 1h10c2-2 4-4 6-5v-2c0-1 1-1 1-1v-5c-1-1-1-2-1-2 1 0 1-1 1-1v-5c-1-1-1-1 0-2v-6c-1 0-1-1 0-1v-6c-1-1-1-1 0-2v-5c0-1-1-1-1-2s1-1 1-1v-3l1-1 3-3zm-4 8c0 1 0 1 1 1v-1h-1zm0 7v1h1c0-1 0-1-1-1zm0 8v1h1v-1h-1zm1 7c-1 0-1 0-1 1 1 1 1 0 1 0v-1zm-1 8v1h1v-1h-1zm0 8c0 1 1 1 1 1v-1h-1zm-18 7c-1 0-1 1-1 1h1v-1zm-4 8c-1 0-1 0-1 1h1s1-1 0-1zm2 4h-1c1 1 1 1 1 0zm0 7c-1 0-1 0-1 1h1v-1zm0 8c-1 0-1 0-1 1 1 0 1 0 1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M48 44c0-1 0-2 1-2s1 1 2 1h1l1-1s1 0 1 1c1 0 1 1 0 1l2 2c1 1 2 3 4 4h1l1 1v1c0 1 1 1 2 2v13l-4 4h-1c-2 1-4 0-6 0 0 0 0 1 0 0-2-1-3-2-4-3l-1-1v-1s0-1 1-1v-5c-1 0-1-1-1-1v-1h1v-6h-1c0-1 0-2 1-2v-5c-1 0-1-1-1-1zm1-1v1c1 0 1 0 1-1h-1zm4 0c-1 1 0 1 0 1 1 0 1 0 1-1h-1zm-2 1s-1 0-1 1h-1v5c1 0 2 0 2 1s-1 1-1 1 0 1-1 1v4c1 0 1 1 1 1 1 0 1 1 0 1 0 1 0 1-1 1v5c1 0 2 1 2 2 0 0-1 0-1 1l3 3h6s1 0 1-1c1-1 2-1 3-2v-2h-8v-2c-1 0-1-1-1-2s1-1 1-1v-5h-1v-2h1v-5c-1 0-1-1-1-1v-1c0-1 0-1 1-1h-1v-1h-2v-1h-1zm4 3h-1c0 1 1 1 1 1h1c0-1 0-1-1-1zm-6 4c0 1 0 1 1 1v-1h-1zm8 0h-1c0 1 1 1 1 1v-1zm3 0v1c1 0 1-1 1-1h-1zm-5 3s-1 1 0 1c0 1 0 1 0 0 1 0 0-1 0-1zm4 0-1 1c1 1 1 1 1 0 1 0 0-1 0-1zm3 0v1s0 1 1 1v-1c0-1 0-1-1-1zm-13 4v1h1v-1h-1zm8 0c-1 0-1 1-1 1h1v-1zm4 0c-1 0-1 1-1 1h1v-1zm-6 4s-1 0-1 1h2c0-1-1-1-1-1zm4 0c-1 0-1 1 0 1 0 0 1 0 0-1zm3 0v1h1v-1h-1zm-13 4v1h1v-1h-1zM8 44h23v6c1 1 1 1 0 2v6c1 0 1 1 0 2v5l1 1c0 1-1 1-1 2 1 0 2 1 2 2 1 0 1 1 1 1v2h1c1 0 1 1 0 2h-1v5c1 0 1 1 1 1 1 1 0 1 0 2h-1v5h1c0 1 1 1 0 2h-1l2 2h1v1c1 2 3 3 4 4 0 1 1 1 2 2h1l1 1v1l2 2h5v1c0 1 1 1 1 2v5h1c1 1 1 1 0 2h-1v5c1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1-1 1v5h1c1 1 0 2 0 2l-1 1v-1h-1v-1c0-1 0-1 1-1v-5c-1 0-1-1-1-1v-1c0-1 0-1 1-1v-5h-1v-2h1v-5s-1 0-1-1l-1-1h-4c-1-1-2-2-2-3l-1 1c-1 0-2-1-2-2h1l-6-6h-2v-2c0-1-1-1-1-1 0-1-1-1-1-1v-2h1v-5c-1 0-1-1-1-1v-1c0-1 1-1 1-1v-5h-1v-2h1v-2h-1l-3-3c-1-1-1-1-1-2 0 0 0-1 1-1v-5h-1v-2s1 0 1-1v-5h-1v-2h1v-5H8l-8 8v-1c3-3 6-5 8-8zm22 7v1s1 0 1-1h-1zm0 7v1h1v-1h-1zm0 8v1h1v-1h-1zm4 7v2c0-1 1-1 1-1l-1-1zm0 8v1h1v-1h-1zm0 8c0 1 0 1 1 0h-1zm2 3s0 1-1 1h1c0 1 1 0 1 0l-1-1zm7 8v1h1v-1h-1zm10 11c0 1-1 1 0 1h1l-1-1zm0 8s-1 0 0 1c0 0 1 0 1-1h-1zm0 8c-1 0-1 0 0 1 1 0 1-1 1-1-1 0-1-1-1 0zM83 46l1-1h17c2 2 3 3 4 5h1c1 0 2 1 2 1l-1 1h1l6 6v46c-1 1-2 1-2 2v23h-1v-23l1-1 1-1V58l-5-5-1-1-1 1s-1-1-1-2v-1l-4-4H84l-1 1v42L73 99c-1 0-1 1-1 1H61s-1 0-1 1v3l2 2v18h3l1 1c1 2 3 3 4 4h-1l-3-3-1-1h-4v-19c0-1-1-1-2-2v-3l2-2h11s1 0 1-1l7-7 2-2V47l1-1zm23 5v1l1-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M9 46h1s0 1 1 1h1s0-1 1-1h1v1h2c0-1 1-1 1-1 1 0 1 0 1 1h2v-1h2v1h1l1-1c1 0 2 0 2 1h2v20c1 2 2 3 3 4v19c0 1 1 1 1 1 0 1 1 1 2 2l3 3 5 5 3 3 2 2v23h-1v-23c-4-4-7-8-11-11l-4-4V71c-1 0-1-1-2-1 0-1-1-2-2-2V48s-1-1-1 0c0 0 0 1-1 1s-1 0-2-1c0-1 0 0-1 0 0 1-1 1-1 1-1 0-1-1-1-1h-2c0 1 0 1-1 1s-1-1-1-1c-1-1-1 0-1 0s-1 0-1 1c-1 0-1 0-2-1 0-1 0 0-1 0 0 0 0-1 0 0l-1 1c-1 0-1 0-1-1H8l-5 5-3 3v-1l8-8 1-1zm0 1v1h1c0-1 0-1-1-1zm12 0c-1 0-1 0-1 1h1c1-1 0-1 0-1zm-8 0v1c1 0 1-1 1-1h-1zm4 0s-1 1 0 1 1-1 1-1h-1zm7 0v1h1v-1h-1zM71 50c1 0 1-1 1-1h3v40h-1c0 1-1 2-2 2h-8l-2-2v-3c-1 0-1-1-1-1l1-1v-5l-1-1s0-1 1-1c0-1 0-1 1-1 3-3 5-6 8-9V50zm1 0c1 0 1 0 1 1v1s0 1-1 1v4c1 0 1 1 1 1v1c0 1 0 1-1 1v5c1 0 1 1 1 1v1c0 1-1 1-1 1l-3 3c-2 2-4 4-6 5 0 1 0 1 1 1v2h-1v5s1 0 1 1v1l-1 1v2l1 1h8c1 0 1-1 2-1v-2c-1 0-1-1-1-1v-1c0-1 0-1 1-1v-5c-1 0-1 0-1-1v-1l1-1v-4l-1-1v-1c0-1 0-1 1-1v-5c-1 0-1-1-1-1v-1s0-1 1-1v-5c-1 0-1 0-1-1v-1h1v-4h-2zm0 1c-1 0-1 0 0 1l1-1h-1zm2 3v1c-1 0-1 1 0 1 0 0 0-1 1-1l-1-1zm-2 4s-1 1 0 1h1l-1-1zm2 4s-1 0-1 1h1s1 0 0-1zm-2 4c-1 0-1 1 0 1s1-1 1-1h-1zm2 4h-1l1 1s0-1 1-1h-1zm-12 7v1h1v-1h-1zm12 0c-1 0-1 1 0 1s0-1 0-1zm-12 8v1h1v-1h-1zm12 0c-1 0-1 0-1 1h1c1-1 0-1 0-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M8 50h17v4h1v2h-1v5l1 1v1c0 1-1 1-1 1v3c1 2 2 3 3 4v19c2 2 4 4 5 6l1-1c1 0 1 1 1 1 1 1 0 1 0 1l3 3 3 3h1c1 0 1 1 1 1v1l1 1v1h1v2h-1v5s0 1 1 1v1c0 1-1 1-1 1v5l1 1c0 1 0 1-1 1v5h-1v-5h-1c0-1 0-1 1-2v-5l-1-1s0-1 1-1v-6h-1v-2h1v-2l-1 1c-1 0-2-1-2-2l1-1c-2-1-4-3-5-5h-2c-1 0-1 0-1-1v-1c-1-1-2-2-2-3-1-1-2-2-3-2V71c-1-1-3-2-4-3v-1l-1 1s-1 0-1-1h-2c0 1-1 1-1 1s-1 0-1-1h-2s0 1-1 1l-1-1h-2v1h-1l-1-1v2s1 0 1 1c0 0 0 1-1 1v6c1 0 1 1 1 1 0 1-1 1-1 1v3H9s0 1-1 1H7l-1-1H5c-1 1-1 1-2 1 0 0 0-1-1-1H1v1H0v-1h1c0-1-1-1-1-1v-6c0-1 1-1 1-1l-1-1v-6s1 0 1-1H0v-7h1l-1-1v-1s0 1 1 1c1-2 3-4 5-6v-1l1-1h1zm-1 1v1c1 0 1 0 1-1H7zm4 0v1h1v-1h-1zm4 0s-1 0 0 0v1c1 0 1-1 1-1h-1zm4 0c-1 0-1 1 0 1l1-1h-1zm4 0h-1c0 1 1 1 1 1v-1zM6 54c-1 0-1 1-1 1 0 1 1 1 1 0v-1zm3 0v1c0 1 1 1 1 0 0 0 0-1-1-1zm4 0v1c0 1 1 1 1 0 0 0 0-1-1-1zm4 0c0 1-1 1 0 1-1 0 0 1 0 1l1-1c-1 0-1-1-1-1zm4 0-1 1 1 1v-2zm4 0c-1 0-1 1-1 1s0 1 1 1v-2zM4 58c-1 0-1 1-1 1 1 1 1 0 1 0v-1zm3 0v1c1 1 1 0 1 0 0-1 0-1-1-1zm4 0v1h1v-1h-1zm4 0v1h1c0-1-1-1-1-1zm4 0c-1 0-1 1 0 1h1l-1-1zm4 0c-1 0-1 1-1 1 1 1 1 0 1 0v-1zM2 62c-1 0-1 0-1 1h1s1 0 0-1zm3 0c0 1 0 1 1 1 0-1 0-1-1-1zm4 0v1h1c0-1 0-1-1-1zm4 0v1h1c0-1-1-1-1-1zm4 0c-1 0-1 1 0 1 0 0 1 0 1-1h-1zm4 0c-1 0-1 1 0 1 0 0 1 0 0-1zm3 0v1h1v-1h-1zM4 66c-1 0-1 1-1 1h1v-1zm3 0v1s1 0 1-1H7zm4 0c0 1 0 1 1 1v-1h-1zm4 0s-1 0 0 1c0 0 1 0 1-1h-1zm4 0c-1 0-1 1 0 1h1c0-1-1-1-1-1zm4 0c-1 0-1 0-1 1h1v-1zM2 70c-1 0-1 0-1 1 1 0 1 0 1-1 1 0 0 0 0 0zm4 0c-1 0-1 0-1 1 1 0 1 0 1-1zm3 0v1s1 0 1-1H9zm-5 3c-1 1-1 1 0 1 0 1 0 0 0 0v-1zm3 0v1c1 1 1 0 1 0s0-1-1-1zm-5 4c-1 0-1 1-1 1h1c1-1 0-1 0-1zm4 0c-1 0-1 1-1 1h1v-1zm3 0v1h1s0-1-1-1zm-5 4c-1 0-1 0-1 1h1v-1zm3 0v1h1v-1H7zm27 15s-1 1 0 1h1v-1h-1zm7 8c0 1 0 1 1 1v-1h-1zm2 4s0 1 1 1v-1s0-1-1 0zm0 7v1h1v-1h-1zm0 8v1c1 0 1 0 1-1h-1zM122 59l7-7v1l-6 6-1 1v43l1 1s0 1-1 2h-2v23-26h1V60l1-1zm-1 45v1h1v-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M125 60c1-2 2-3 4-5v1c-1 1-3 2-4 4v5h1c1 1 1 2 0 2 0 1 0 1-1 1v5h1c1 1 1 2 0 2h-1v5c1 0 1 1 1 1 1 1 0 2 0 2h-1v5c1 0 1 0 2 1l-1 1h-1v5s1 0 1 1c0 0 1 0 1 1l-1 1h-1v6l-1 1-1 1v1h1c1 1 1 1 0 2h-1v5c1 0 1 1 1 1 1 1 1 1 0 2h-1v5h1c1 1 1 1 0 2 0 0 0 1-1 1v4-5h-1v-2h1v-5h-1v-2h1v-6h-1v-2h1v-1c0-1 0-1 1-1V60h1zm0 6s-1 0 0 1c1 0 1-1 1-1h-1zm0 7v1s0 1 0 0h1l-1-1zm0 8s-1 1 0 1h1c0-1-1-1-1-1zm0 8c0 1 0 1 1 0h-1zm0 7v1h1c0-1-1-1-1-1zm-2 12v1c1 0 1-1 1-1h-1zm0 7v1h1v-1h-1zm0 8v1s1 0 1-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M128 58s0-1 1-1v1l-1 1h1v7h-1c0 1 1 1 1 1v6l-1 1s1 0 1 1v6h-1c0 1 0 1 1 1v1h-1v21c0 1-1 1-2 2v23-23s-1 0 0 0c0-1 1-1 1-2V60s1 0 1-1v-1zM52 66c0-1 1-1 1-1h1c0 1 1 2 0 2v2h-1v-1c-1 0-1 0-1-1v-1zm1 0s-1 0 0 1c1 0 1-1 0-1zM12 70c0-1 1-1 2-1v1h2v-1h2v1h2v-1h1c1 0 1 0 1 1h2c1 0 1 1 1 1v20c4 3 7 6 10 9l6 6v23h-1v-23L29 95l-4-4V71c-1 0-1 0-1-1h-2v1c-1 1-2 1-2 0v-1h-2v1s-1 1-1 0c-1 0-1 0-1-1h-1c0 1-1 1-1 1 0 1-1 1-1 0v11l-3 3H3v1c0 1-1 1-1 1v5h1v1c0 1 0 1-1 1v5c1 0 1 1 1 1v2H2v2c0 1-1 1-2 2v5c1 0 1 0 1 1v1H0v5c1 0 1 0 1 1v1c0 1 0 1-1 1v5h1v2H0v1-1s0-1 1-1c0 0-1 0-1-1v-6s1 0 1-1H0v-7h1l-1-1v-6s1 0 1-1v-3s-1-1 0-1v-6c-1-1-1-2 0-2v-6s-1-1 0-1c0-1 0-1 1-1h8l2-2V70zm1 0v1c1 0 1-1 1-1h-1zm4 0s-1 0 0 1l1-1h-1zm4 0h-1l1 1v-1zM2 85c-1 0-1 0 0 1v-1zm0 7-1 1h1c0 1 0 0 0 0 1 0 0-1 0-1zm0 8c-1 0-1 0-1 1h1v-1zM41 73c1-1 2 0 2 0h1c1-1 2-1 3 0 0 1 1 1 1 1 1 1 1 2 2 3 1 0 1-1 1-1 1 0 1 1 1 1 1 0 1 1 0 1v1h5v1c1 0 1 1 1 1v2h-1v5h1v2h1v2s1 0 1 1c0 0 0 1-1 1h-1c-1 1-2 3-4 4h-9l-1-1v-1c-1-2-3-4-5-5v-5s-1 0-1-1l1-1v-5s0-1-1-1c0-1 1-1 1-1v-4h2zm0 0v1l1 1v-1c0-1 0-1-1-1zm4 0v1s0 1 1 1v-1c0-1 0-1-1-1zm-5 1v2l1 1v1c0 1-1 1-1 1v5s1 0 1 1v1l-1 1v4c1 1 3 2 4 4h2c1 1 1 1 1 2v1h7c0-1 0-1 1-1l3-3-1-1 1-1v-2h-1c-1 1-2 0-1-1v-9h-3c-1 0-1-1-1-1h-1l-1-1v-1l-3-3c0 1-1 2-2 1 0 0-1 0-1-1h-1v1h-2s-1 0-1-1zm0 3c-1 0-1 1-1 1h1v-1zm11 0v1h1s0-1-1-1zm6 4c-1 0-1 1 0 1v-1zm-17 4c-1 0-1 1 0 1v-1zm17 4h-1l1 1s1-1 0-1zm2 3c-1 0-1 1-1 1h1c0 1 0 0 0 0v-1zm-14 4v1h1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M42 76h5c0 1 0 1 1 1 1 2 3 3 5 5h1v7c1 0 1 1 2 1v4c-1 0-1 1-2 1h-7c-1 0-2-1-3-2 0-1-1-2-2-2V76zm1 1v14c1 1 3 2 4 4h7c0-1 1-1 1-2v-3s-1-1-2-1v-6l-1-1c-2-1-3-3-5-5h-4z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M45 79h2s0 1 1 1l3 3v6c1 0 1 1 2 1v2h-6s-1 0-1-1c0 0-1 0-1-1-1 0-1-1-1-1 0-1 1-1 1-1v-5c-1-1-1-1-1-2l1-1v-1zm1 1c1 1 1 1 1 2l-1 1v5c1 0 1 1 1 2h-1c0 1 1 1 1 2h5v-1c0-1-1-2-2-2v-6l-3-3h-1zm-1 1v1h1v-1h-1zm0 8c0 1 1 1 1 0h-1zM84 90h27v14c1 0 0 1 0 1-1 1-1 1-2 0v24h-1v-23l1-1v-1c0-1 0-1 1-1V90H85c-1 0-1 1-1 1l-1 1v1c0 1-1 1-1 1h-1l-6 6v1s0 1-1 1h-1l-1 1h-9v1l2 2v5h1c0 1 0 1-1 2v5c1 1 1 2 1 2-1 0-1 1-1 1l1 1h1l1 1v1c1 2 3 3 5 5h-1l-2-2-3-3s0 1-1 1c0 0-1-1-1-2v-1h-1v-1l-1-1v-1l1-1v-5h-1v-1c0-1 1-1 1-1v-5c0-1-1-1-1-1 0-1-1-1-1-1v-2h10l1-1v-1s0-1 1-1h1c2-2 4-3 5-5v-1c0-1 1-1 1-1h1l1-1 1-1zm-3 2v1c1 1 1 0 1 0s0-1-1-1zm-7 8h-1c0 1 0 1 1 1 1-1 0-1 0-1zm36 4h-1l1 1s1-1 0-1zm-46 7v1h1s0-1-1-1zm0 8v1h1c0-1 0-1-1-1zm2 4v1c1 0 1 0 1-1h-1zM24 92c1-1 2 0 2 0v2l3 3 2 2h1c1 0 1 1 2 1 0 1-1 1-1 1l2 2 3 3v23h-1v-23c-1-1-1-2-2-2-1-1-1-2-2-2h-1c-1 0-1-1-1-1v-1s0-1-1-1l-3-3c0-1-1-1-2-2-1 0-2 0-2-1H5v11l-2 2v23-21c0-1-1-2 0-2 0-1 1-1 1-2V92h20zm0 0v1s1 1 1 0 0-1-1-1zm8 8v1h1c0-1-1-1-1-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M84 93c0-1 1-2 1-1 1 0 1 0 2 1h1v-1c1 0 1-1 2 0v1h2v-1c1-1 1-1 2 0v1h1l1-1s1-1 1 0c1 0 1 0 1 1h1c0-1 0-1 1-1 0-1 1-1 1 0 1 0 1 0 1 1h1v-1c1 0 2-1 2 0l1 1h2v11l-2 2v23h-1v-23l2-2V93h-1l-1 1h-2v-1h-1c0 1 0 1-1 1h-1s-1 0-1-1h-1c0 1 0 1-1 1h-1l-1-1h-1c0 1 0 1-1 1h-1v-1h-2v1h-2v-1h-1l-1 1h-2c-1 0-1 1-2 2l-6 6-2 2v23c0 1 1 1 2 2h-1l-2-2v-23s1 0 1-1l5-5c2-1 3-3 5-5zm1-1v1s0 1 1 0c0-1-1-1-1-1zm4 0v1c0 1 0 1 1 0 0-1-1-1-1-1zm4 0c-1 0-1 1-1 1h1c1 0 0-1 0-1zm4 0c-1 0-1 1-1 1 1 1 1 1 1 0v-1zm3 0v1c1 1 1 0 1 0 0-1 0-1-1-1zm4 0v1c0 1 1 0 1 0 0-1-1-1-1-1zM7 95h17l2 2 6 6v1s1 0 1 1h1l1 1v5c1 1 0 1 0 2v6c1 0 0 1 0 1v6s1 1 0 1v2h-1v-1h-1v-2h1v-5h-1v-2c0-1 1-1 1-1v-5h-1v-1c0-1 0-1 1-1v-5c0-1-1 0-1-1l-1-1h-1v-1c-2-2-4-5-7-7H9v1c0 1-1 1-1 1v5l1 1v1l-1 1c-1 0-1 0-1-1 0 1-1 1-1 1v1h1v2H6v6c1 0 1 1 1 1 0 1 0 1-1 1v5c1 0 1 1 1 1 0 1 0 1-1 1v5H5v-5c-1 0-1-1 0-1v-6l-1-1c0-1 1-2 1-2v-5c-1 0-1-1 0-2 0-1 0-1 1-1v-2l1-1v-5c-1-1-1-1-1-2 1 0 1-1 1-1zm0 1v1h1v-1H7zm0 8v1h1v-1H7zm-2 4c0 1 1 1 1 0H5zm29 3v1s0 1 1 0v-1h-1zm-28 4c-1 0-1 0-1 1h1v-1zm28 4v1s1 0 1-1h-1zm-28 4c-1 0-1 0-1 1 1 0 1 0 1-1zm28 4s-1 0 0 1l1-1s-1-1-1 0z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M83 95c1 0 1 0 1 1h21v3s0 1 1 1c0 1 0 1-1 2v2s-1 0-1 1c0 0-1 0-1 1v5c1 1 1 1 0 2v5s0 1 1 1c0 0 0 1-1 2v5c1 1 1 1 1 2h-1v1h-1v-1h-1v-2h1v-5l-1-1v-1l1-1v-5h-1v-2h1v-5l2-2v-2l-1-1v-1l1-1v-3H85v1c-1 1-1 1-2 1l-6 6v23c0 1 1 1 2 2h-1c-1 0-1-1-1-1l-1-1v-23l2-2 3-3 1-1v-1c0-1 1-1 1-2zm0 1v1h1c0-1 0-1-1-1zm21 4v1h1v-1h-1zm-2 11v1c0 1 1 1 1 0 0 0 0-1-1-1zm0 8v1h1c0-1 0-1-1-1zm0 8c0 1 0 1 1 1v-1h-1zM10 98h14l5 5v1c1 0 2 1 2 2v23-23c-1-1-2-2-3-2v-1c-1-1-2-3-4-4H11v6c-1 0-1 0-2 1v23H8v-23h1c0-1 1-1 1-2v-6z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M85 99c0-1 1 0 1 0h11c2 0 3-1 5 0v5l-2 2v23h-1v-23l1-1 1-1v-5H84c-1 2-2 3-3 4v1s0 1-1 1v6h1v1c0 1-1 1-1 1v5l1 1c0 1 0 1-1 2v5h1v2s0 1 1 1h-1s-1 0-1-1h-1c-1 0-1-1-1-1 0-1 1-1 1-1v-5c0-1-1-1-1-2 0 0 1 0 1-1v-5c-1 0-1-1-1-2h1v-5c0-1 0-1-1-1 0-1 0-1 1-2h1l2-2c1-1 2-2 3-2zm-6 5v1h1v-1h-1zm0 7v1h1v-1h-1zm1 8c-1 0-1 0-1 1h1v-1zm-1 8s0 1 1 1v-1h-1zM13 101h11c1 1 2 1 2 2h1c1 0 1 1 1 1v25-23s-1 0-1-1c0 1-1 1-1 1 0-1-1-1-1-2v-1c0-1-1-1-1-1H14v2l-1 1-1 1v23h-1v-23c1-1 2-1 2-2v-3zm13 3v1h1v-1h-1z"
          />
          <path
            className="CyberEl88_svg__fil0"
            d="M84 102s1-1 1 0c4 0 9-1 14 0v2l-2 2v1h1v2h-1v5l1 1v1c0 1-1 1-1 1v5h1v2s-1 0-1 1v4H84l-2-2v-23l1-1 1-1zm-1 2v23c0 1 1 1 2 2h11v-5c-1 0-1-1 0-1v-6c-1-1-1-1-1-2 1 0 1 0 1-1v-5c-1 0-1-1 0-2v-1l2-2v-2H85c-1 1-2 1-2 2zm14 4h-1s0 1 1 1v-1s0-1 0 0zm0 7c-1 0-1 1-1 1h1v-1zm0 8h-1v1c1 0 1 0 1-1zM16 105v-1h8v1s1 0 1 1v23-23c-1 0-1 0-1-1h-8l-1 1v5h1c1 1 0 2 0 2h-1v5c1 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1-1 1v5h1s1 1 0 2h-1v1h-1v-23c1-1 1-1 2-1zm-1 6v1s0 1 1 0c0 0 0-1-1-1zm0 8v1h1v-1h-1zm0 8v1l1-1c-1 0-1-1-1 0zM129 106v-1 6s-1 0-1 1h1v7h-1c0 1 1 1 1 1v6c0 1-1 1-1 1l1 1v1h-1v-1s-1-1 0-1v-1c1-1 0-2 0-3s1-2 0-2v-5c0-1 1-2 0-3v-2c1-2 0-3 0-4s0-1 1-1z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl88;
