import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl87 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={1409}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 151 92"
      {...props}
    >
      <defs>
        <style>
          {".CyberEl87_svg__fil0{fill:#000}.CyberEl87_svg__fil1{fill:#fff}"}
        </style>
      </defs>
      <g id="CyberEl87_svg__Vrstva_x0020_1">
        <g id="CyberEl87_svg___2648752634512">
          <path
            className="CyberEl87_svg__fil0"
            d="M148 89c0-1 1-2 2-1 0 1 0 2-1 2l-1-1zm-5 0v-1h1c0-1 1 0 1 0 0 2-2 2-2 1zm-68-6h1v1h-1v-1zm56-21c0-1 1-1 1 0v1-1h-1zm-3 1v-1c0-1 1 0 1 0h-1v1zm-5-8v1h1-1v-1zm-5 1h1v-1h1v1h-2zm26-4h1c0 1-1 1-1 0zm-21 1v-2h1v1h-1v1zm-5-2h2v2h-1v-1l-1-1zm24 0h-2v-2s0-1 1-1h6c1 0 1 0 1 1v6c0 1 0 1-1 2h-6c-1-1-1-2-1-4h2v2h5v-6h-6l1 2zm-20-14h-2l-1-1v-4l1-1s1 1 1 0c1 0 1-1 1-1 1-1 1-1 2-1h3s1 1 1 0v-1c1-1 2-1 3-1h2c1 0 1 1 1 1s1 0 1 1v5s0 1-1 1h-5s-1 0-1-1 0-1-2-1h-2s0 1-1 1c0 1 1 1 0 2 0 1-1 1-1 1zm10-13h1v-2h1v2h-2zm-3-1v1h1-1v-1zm3-5h2v2h-1v-1h-1v-1zm-3 0h1v1h-1v1-2zm19-14c0-1 1-2 1-2 1 0 1 1 1 2s-2 1-2 0zm0-2v5c1 1 1 0 1 2-1 0-1 0-1 1v3h-1v5l-1 1-1 1v1c0 2 0 3-1 4h-1v1c0 1 0 1 1 1 0 1 1 1 1 2v5c0 1-1 1-1 1h-5s-1 0-1-1v-5c0-1 1-1 1-1 1-1 1-1 1-2 0 0 0-1-1-1 0 0 0-1-1-1v-5c1-1 1-1 2-1 0-1 1-1 2-1l1-1c1 0 0 0 0-2v-2h-3c-1 0-4 4-4 4h-6c-1 0-2 2-2 2-1 2-3 3-4 4l-13 16s0 1-1 1H83v-7h-1l2-2h11l2-3v-2h2v-5h-5v5h2v2s-1 1-1 2H84l-3 4H67l-1-1v-1l-1-2h-8l-2-1v-1h2v-4h-4v4h1c0 1 1 1 1 2 1 0 1 1 1 1h9s1 1 1 2h-1v8H38l-3-3h-1v-2h-3c-1 0 0 0 0 0v1h-3l-3-4v-5h-2v-7l-2-2h-7v-1h-3v4h3v-1c1 0 7-1 7 0l1 1v6h-2v5h4l4 5h3v2h3v-2h1c0 1 3 4 3 4h29l2 2v13h1v-5h4v20l2 2v4h1v3l-1 2h-1v2h1c0-1 0-1 2-2 0 0 0-1 1-1v-8h-2l-1-1-1-1V48c0-1 4-5 4-6h1c2-1 3 0 3-1v-1h44l1 1h9v7c-1 1-3 1-4 1v7c0 1 0 1-1 1h-3c-1 0-1 0-1-1h-2v-5h2v-2c-1-1-3 0-4-1v-1h-5c-1 0-1 1-1 1s0 1-1 1h-3l1 2h2v1h-1v4h1-2v1h-3v1c0 1 0 1 1 2l3 4 2 2s1 2 2 2h7c1-1 1-1 1-3v1h4v-1 2c1 1 1 1 1 2v3l1 1h15v12c-1 0-1 0-1 1v2h-2c0-1 0-3-2-3-1 0-1 1-1 2v4c0 1 2 2 2 0h1v-2h2v2c0 1 2 2 2 1l1-1v-4c0-1-1-2-1-2V7l1-1V2c0-1-1-2-2-2s-1 1-1 2z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M7 87c1 0 1 3 0 3s-1-3 0-3zm10-36c0-2 2-2 2 0 0 1-2 1-2 0zm1-28c1 0 1 1 1 1-1 0-1-1-1-1zm16 22v-1c2 0 2 0 3-1v-1h29l2 3v11h1V45s-3-3-3-4H37l-1 2h-2v-2h-3v2h-6v-2h-5v1h-1c-1 0-1-1-1-1V27l1-2v-3h-2v3c1 0 1 0 0 0v17l1 2h2v2h2v4h-1v-1h-4c-2 0-2 2-1 3s2 1 2 1c1 0 2 0 2-1h1v-1c2 0 2 0 3 1v18l-1 2h-5v-2h-4v3l-1 1H8v5h1v2l-3 3v1s-1 1-1 2v4c0 1 2 2 3 1l1-1v-4c0-1-1-2-1-2v-2h1c0-1 1-2 1-2v-2h1v-3h3v-1l1-1h3v-1h5l2-2V52l-1-2h-1v-4l2 1c0-3 0-3 1-3h5v1h3z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M1 89c0-1 0-2 1-2s1 3 0 3-1-1-1-1zm16-32c0-2 2-2 2 0 0 1-2 1-2 0zM2 5C1 5 1 4 1 4c0-2 2-2 2 0L2 5zM0 5v78l1 1v1s0 1-1 1v3c0 1 0 2 1 2 0 1 0 1 1 1 0 0 1 0 1-1 1 0 0-1 0-2s1-3 0-3v-2l-2-2V71l1-1c0-1 0-1 1-1 0 1-1 1 0 1h3v-5H3c-1 0 0 0 0 0H2l-1-1V34l1-1h3c1 0 3 3 3 3v2H7v3h3v-1h1v1h2v13l2 3c1 0 1 2 2 2h3c1 0 1-1 1-2s0-2-1-2h-4s-2-1-2-2V38h-3v1h-1v-1H9v-2c0-1 0-1-1-1l-2-3H2l-1-1V7c1 1 2 0 2-1s1-4 0-5c0-1-1-1-2 0-1 0-1 2-1 4zM138 89c0-2 2-2 2-1s0 2-1 2l-1-1zM82 70s1-1 1 0v1c-1 0-1 0-1-1zm20-21c0-1 1 0 1 0l-1 1s-1-1 0-1zm-27 0v19l3 3h3v1h1v5h3v-4h-1v-4h-3v1h-2c-1 0-1 0-2-1 0-1-1-1-1-2V49s3-4 4-4l1-2h15l4 6v1l12 13c2 2 4 5 6 7 1 2 0 1 1 1h9v2h1v4l2 2 4 5c1 0 1 1 1 1 1 0 1 1 1 1v4c0 1 1 1 1 2h2l1-1v-4c0-1-1-2-2-2h-1l-7-9v-3h1v-4h-4v1h-9s-8-9-8-10l-1-1-3-4s-4-4-4-5v-2h-2l-5-5H80s0 1-1 1l-3 4s0 1-1 1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M84 41h41l1 1h-1v5h5v5h-1v4h3v-4h-1v-5h5v-5h-9s-1-2-2-2H84v1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M121 44h1c0 1-1 2-1 0zm-37-2h17l2 3h3v2h5v5h-1v4h4v-4h-2v-5h5v-2h3v1h2v-3h-2v1h-3v-2h-11v2h-3c-1-1-1-2-2-2 0-1-12-1-12-1-1 0-4 0-5 1zM7 2c1 0 1 1 1 2S6 5 6 4s0-2 1-2zM5 2v4h1L4 8c-1 1-1 1-1 3s1 4 0 6H2v4h3v-4H4V9h1c0-1 1-2 1-2 1 1 1 0 2 0 0 0 6 8 7 9h8s11 13 12 14c0 0 5 6 6 7 0 0 1 1 1 2h22v-1H42S32 26 32 25l-4-4c-1-1-1-2-2-3l-2-3h-8s-6-7-7-8L8 6h1V2c0-3-4-3-4 0zM16 89c0-2 2-2 2-1 0 2-2 2-2 1zm21-43s0-1 1-1c0-1 1-2 1-2h25-26c0 1-1 2-2 2l-5 7-1 1-1 1 1 19-8 9h-4v1c-1 0-1 1-1 1v1c-1 0-1 1-1 2v4c0 1 1 2 2 1l1-1v-4c0-1-1-2-2-2v-1c1 0 1-1 2-1h2c1 0 1 0 2-1s1-2 2-3l5-5V54l7-8zM144 2c1 0 1 1 1 2s-2 1-2 0 1-2 1-2zm-1 0v5l-2 2h-2l-4 5h-6c-1 0-3 3-3 3-1 1-2 2-2 3l-15 18H84v1h25l2-3 3-3 10-12c1-1 2-2 2-3l3-3h6s2-2 2-3c0 0 1 0 1-1l1-1h3l1-2c1 0 1 0 1-1 1 0 2 0 2-1V2c0-3-3-3-3 0z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M21 89v-1h1c0-1 1 0 1 0 0 2-2 2-2 1zm13-36c0-1 0-1 1-1 0-1 1-2 2-3 0-1 1-1 2-2v-1c1 0 1-1 1-1h24v-1H40l-1 1-3 4-2 2s-2 2-2 3v21l-1 1c0 1-1 1-1 1-1 1-2 2-2 3-2 1-4 4-5 5h-1c-1 0-1 1-1 2v5c1 1 2 0 3-1v-5l9-11V54l1-1zM139 5c-1 0-1-1-1-1 0-1 0-2 1-2s1 3 0 3zm-1 2-4 5h-7l-20 25H84h23s1-1 2-1l17-21c1-1 1-2 2-2h6l5-6h1l1-1V2c0-2-3-3-3-1-1 1-1 1-1 2s0 3 1 3v1z"
          />
          <path
            className="CyberEl87_svg__fil1"
            d="M129 29h4v5h-4v-2h-6l-1 1v2h-2v-2h2v-1c1 0 1-1 1-1h6v-2zm-7 8s1 0 1-1c1-1 0-1 0-2 1 0 1-1 1-1h2c2 0 2 0 2 1s1 1 1 1h5c1 0 1-1 1-1v-5c0-1-1-1-1-1s0-1-1-1h-2c-1 0-2 0-3 1v1c0 1-1 0-1 0h-3c-1 0-1 0-2 1 0 0 0 1-1 1 0 1-1 0-1 0l-1 1v4l1 1h2z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M26 89c0-2 2-2 2-1 0 2-2 2-2 1zm38-43v-1H42l-1 1-6 8v22l-8 9s-1 0-1 2v4c0 1 1 2 2 1l1-1v-4c0-1 0-1-1-2l7-8V54l7-8h22zM12 5c-1 0-1-2-1-2l1-1c1 0 1 3 0 3zm0 2s4 5 5 6l1 2h7s16 19 18 22h21-20c-1-1-1-1-1-2L25 14h-6c-1 0-3-3-3-3-1-1-3-4-3-4s1 0 1-1V3c0-1 0-1-1-2 0-1-2-1-2 0-1 1 0 2 0 3s-1 2 0 2c0 1 0 1 1 1zM134 5c-1 0-1-1-1-1 0-1 0-2 1-2s1 3 0 3zm0 2v1l-3 3h-5l-20 25H84h22l20-24h6l2-3V7c2 0 1-1 1-3 0-1 1-2 0-3 0-1-2-1-2 0-1 1-1 2-1 3v2c1 1 1 1 2 1zM128 89c0-2 2-2 2-1 0 2-2 2-2 1zM84 45h9s1 1 1 2c1 0 2 1 2 1 1 2 2 3 3 4 2 3 5 5 7 8 0 1 12 15 13 15h3l3 4c1 1 3 4 4 4l-1 2c-1 0-1 2-1 4v2c1 2 3 2 3 0v-2c0-2 1-3 0-4h-1v-3l-4-4c0-1-1-2-2-3s0 0-2 0h-2c-1-1-3-4-3-4L94 45l-1-1h-9v1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M17 2c1 0 1 3 0 3s-1-3 0-3zm0 5v2l3 3c0 1 1 1 1 1h5c0 1 1 1 1 2l16 18c0 1 2 3 2 3h19-18c-1-1-5-6-5-6-4-4-7-8-10-12l-5-6h-5l-4-4V7c1 0 2-1 2-1V2c0-2-3-3-3 0v4c0 1 0 1 1 1zM31 89c0-2 2-2 2-1 0 2-1 2-2 1zm13-42h20v-1H43l-6 8v24l-5 6v1l-1 1v3c0 1 0 2 1 3 0 1 1 0 2-1v-2c0-2 0-4-1-4v-2c1 0 5-5 5-5V54l6-7z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M50 23c1 0 1 1 0 1v-1zM39 11c0-1 1 0 1 0 0 1-1 1-1 0zm0 1h1v1s6 8 7 8l1 2c1 1 0 1 1 1v1h2v-2l2-2h6l1 1v1h-1v4h3v-1c1 0 1 1 2 1l3 4h6l1-1v-5h-1v5h-5l-6-6v-1h-1c0-1 0-1-1-2l-1-1h-6l-2 2h-2v1l-1-1-7-9s-1 0-1-1h1v-2h-2v2zM123 89c0-1 1-2 2-1 0 1 0 2-1 2s-1-1-1-1zM91 46l1 1s1 0 1 1l22 26s3 4 4 4h2l2 3v4l-1 1v5c1 2 3 2 3 0v-6h-1v-4l-3-3h-2L92 45h-8c0 1 0 1 1 1h6zM129 2c1 0 1 3 0 3-2 0-1-3 0-3zm-2 0v4l1 1v1l-1 1h-2l-1 2-19 23H84v1h20l1-1 5-5c2-4 5-7 7-10l6-7c1 0 1 0 1-1h1v-1h3l1-2V7c1 0 1-1 1-1V2c0-1 0-2-1-2s-2 1-2 2zM145 11c0-1 1 0 1 0 0 1-1 1-1 0zm-1 2h1v3c0 1-2 3-2 3h-3l-1 1v3c1 1 1 1 2 1v5h-2v5h4v-5h-1v-5h1v-1c1-1 0-2 0-3l3-3v-7h-2v3zM36 89c0-1 1-2 1-2 1 0 1 1 1 1 1 2-1 2-2 1zm4-35v27c-1 0-3 3-3 3v1s-1 1-1 2v4c0 1 2 2 3 1v-5c0-1-1-2-1-2v-1l2-3V54l5-6h19v-1H45l-5 7z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M22 5c-1 0-1-1 0-2 0-1 1 0 1 1 0 0 0 1-1 1zm0 2c0 3 0 3 1 4v1h4l20 23h17v-1H47l-5-6c-1-1-15-17-15-17h-3l-1-1V7l1-1V2c0-2-3-3-3 0v3c0 1 0 2 1 2zM42 89c-1-2 1-2 1-1 1 2-1 2-1 1zm4-39 1-1h17-18l-4 5v31l-1 1v5c0 1 0 1 1 1 1 1 1 0 2-1v-5c0-1-1-1-1-1V54l3-4zM20 67h1c1 0 1 1 0 1 0 0-1 0-1-1zM2 41h2v17c0 1 2 3 2 3l2 2h6s1 0 1 1h-1v3h4v-1h1l1 1v2h2v-3h-2v-1h-2v-1h-2l-1-1v-1H8l-3-4V38H2v3zM118 89c0-1 0-2 1-2s1 3 0 3-1-1-1-1zM84 47h6l2 2c0 1 1 2 1 2l25 30v4s-1 1-1 2v4s1 1 2 1l1-1v-5c0-1-1-1-1-1v-5h-1c0-1-1-1-1-1L91 47s-1 0-1-1h-6v1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M50 75c1 0 1 1 1 2 0 0 0 1-1 1s-1-3 0-3zm13-19s0-1 1-1v-1h2v2h1v-4h-1v1h-2l-1 2h-2v-2h-3v4h1v1l-1 1h-7l-1 1v13h-1c-1 1 0 2 0 4 0 0-1 1 0 2 0 1 2 1 2 1 0-1 1-1 1-2v-3c0-2-2-2-2-2V60l1-1h8v-2h2v-1h2zM124 5c-1 0-1-1-1-1 0-1 1-2 1-1 1 0 1 2 0 2zm-1 2c0 1 1 1 0 2 0 0-1 0-1 1l-4 4c-2 2-3 4-5 7l-10 11c0 1 0 1-1 1H84v1h19l5-7 6-6 9-12c1-1 1 0 1-2 2 0 1-2 1-3V1c0-1-2-1-3 0v2c0 3 0 4 1 4z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M47 89c-1-2 1-2 2-1 0 2-2 2-2 1zm5-34h-2s-1 2-2 2c-1 1-1 1-1 3v25c-1 0-1 2-1 4v2c1 2 2 2 3 0v-5l-1-1V58l2-2h2v1h3v-4h-3v2zM113 89c-1-1 1-2 1-1 1 1 0 2 0 2-1 0-1-1-1-1zm2-3-1-1v-8L92 51c-1 0-3-3-4-4h-4v1h4s6 7 6 8c2 1 3 2 4 3l15 19v7c-1 1-1 3-1 4v2c1 2 2 2 3 0v-5zM119 2c1 0 1 3 0 3-2 0-2-3 0-3zm-1 5v4l-17 21H84v1h17l9-11 5-5 4-6V7s1 0 1-1V1c0-1-2-1-3 0v2c0 2 0 4 1 4zM27 5l-1-1c0-2 2-2 2 0 0 0 0 1-1 1zm0 2v2l19 22 1 1c0 1 0 1 1 1v1h16v-1H49L29 10c0-1-1-1-1-1V7l1-1V2c0-2-3-3-3 0v4c0 1 1 1 1 1zM11 89c0-1 0-2 1-2s1 3 0 3l-1-1zm17-40c1-1 1 0 1 0v1c-1 0-1-1-1-1zm0 1h2v-2h-2v2h-1v22l-5 6c-1 0-1 1-1 1h-4c-2 0-1 0-2 1l-2 3c-1 1-1 1-1 2-1 0-1 1-1 1-1 1 0 2 0 3s-1 2 0 2c0 2 2 2 2 0 1 0 1-1 1-2v-3c-1 0-1-1-2-1v-1l2-2 1-1 1-1h5l2-3 5-5V50z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M32 5c-1 0-1-3 0-3 2 0 2 3 0 3zm-1-3v4s0 1 1 1v4c1 2 3 4 4 6l14 16h14v-1H50s-2-2-2-3l-8-9c0-1-1-1-1-1l-6-8V7l1-1V2c0-3-3-3-3 0zM102 89c0-2 2-2 2-1 1 2-1 2-2 1zM81 55v1h1v-2h5l15 18c0 1 1 1 1 2v11s-1 1-1 2v4c0 1 2 2 3 1v-5c0-1-1-2-1-2V73c-1 0-1-1-1-1L89 56l-2-3h-5v-1h-1v3zM113 5V4c0-1 1-2 1-1 1 1 1 2-1 2zm0 2v7l-3 4c-1 2-2 3-4 4l-7 9H84h16l14-17V7h1V1c-1-1-2-1-3 0v5c0 1 1 1 1 1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M107 89c0-1 1-2 1-2 1 0 2 2 1 2 0 1-2 1-2 0zm1 3c1 0 2 0 2-1v-2c0-2 0-4-1-4V75L87 49h-3c1 1 2 0 3 0 0 1 1 2 1 2 3 3 20 24 20 24v10l-1 1v5c0 1 1 1 1 1zM77 89v-1l1-1c1 0 1 3 0 3l-1-1zm-1-24 2 1h6l3 3v9l-4 4h-3l-2 3h-1c-1 1-1 2-1 3s0 2 1 3c0 1 1 2 2 1s1-1 1-2v-3c0-2-2-1-1-2l2-2h2s1 0 1-1l3-4v-9s-2-4-3-4h-6l-1-1V52h-1v13zM55 75c2 0 2 3 0 3l-1-1c0-1 1-2 1-2zm12-18s-3 3-3 4c-1 0-1 1-1 1h-2v-1h-3v4l-3 3v5c-1 0-1 1-1 1v3c0 1-1 2 0 3 1 0 2 0 3-1v-2c0-2 0-4-1-4v-4l3-4h2v-2h2l1-1c1-1 4-5 4-5v-5h-1v5zM37 2c1 0 1 0 1 1 1 0 1 2 0 2s-2-1-1-2V2zm-1 0v4s0 1 1 1v7c0 1 1 1 1 1 0 1 1 1 1 2l2 2 10 12h13-12c-1-1-7-8-7-9-1-1-3-2-4-4l-3-4V7h1V2c0-1-1-2-2-2 0 0-1 1-1 2z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M82 89c0-1 1-1 1-2 1 0 1 1 1 1 0 1 0 2-1 2l-1-1zm-5-26 2 1h6c0 1 4 5 4 5v10l-1 2-4 4h-2v4c0 1-1 2 0 3s2 0 3-1v-4c0-1 0-1-1-1l6-6V69l-1-1v-1l-4-3h-6c0-1-1-1-1-2V52c-1 0-1 0-1 2v9z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M87 89v-1c1-1 2-1 2 0s0 2-1 2l-1-1zm-9-28 2 2h6l3 3 1 1 2 2v12c-1 0-1 1-1 1l-2 2-1 1h-1v6c0 2 2 2 3 0v-4c0-1-1-1-1-2l3-4V69c0-1-5-7-5-7h-7s-1-1-1-2v-8h-1v9z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M97 89c0-1 1-1 1-2 1 0 1 1 1 1 0 1 0 2-1 2l-1-1zM80 57l2 2h6l1 1c1 1 9 10 9 11v14c-1 0-1 1-1 2v4s0 1 1 1 2-1 2-1v-4c0-1-1-2-1-2V70l-1-1-5-6c-1-1-4-5-5-5h-6l-1-1v-5h-1v5z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M92 89c0-2 2-2 2-1s0 2-1 2l-1-1zM79 59s1 0 1 1c0 0 1 0 1 1h6l2 2c1 0 1 1 2 2 0 1 1 1 1 2 1 0 2 2 2 2v14c-1 1-1 1-1 2h-1c-1 1 0 2 0 4v2c1 2 3 1 3 0v-4c0-1-1-2-1-2v-1l1-1V69l-7-9h-7l-1-1v-7h-1v7zM42 5V4c0-2 2-2 1 0 0 0 0 1-1 1zm0 2v4l4 5h17l3 5v7h1v-8l-2-2-2-3H46l-3-4V7c1 0 1-2 1-4V1s-1-1-2-1l-1 1v5c0 1 1 1 1 1zM108 5l-1-1c1-2 3-2 2 0 0 0 0 1-1 1zm-1 1c0 1-6 8-7 9H86c-1 0-1 1-1 1l-1 1-3 3v8h1v-7l4-5h14s1-2 2-2c0-1 5-7 5-7 1 0 1 1 2 0s1-2 1-4V1c-1-2-3-1-3 0v5zM52 89c-1-2 1-2 2-1 0 1-1 2-1 2-1 0-1-1-1-1zm1-24h2v-4h-3v24c-1 1-1 2-1 4v2c0 1 0 1 1 1 1 1 2 0 2-1v-2c0-2 1-3-1-4V65z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M102 4c0-2 2-2 2 0 0 1-2 1-2 0zm0-2v4s0 1 1 1v1l-5 6H84s-1 2-2 2l-1 2s-1 0-1 1v9h1v-9l2-2c0-1 1-2 2-2h13l6-7V7l1-1V2c0-1-1-2-2-2 0 0-1 1-1 2zM47 5V4c0-2 2-2 2 0 0 0-1 1-2 1zm0 2v6l2 2h15l3 3v10h1v-9c0-1-3-4-3-4s0-1-1-1H49l-1-1V7h1V1c-1-1-2-1-3 0v5c0 1 1 1 1 1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M85 25c0 1-1 2-1 2l-1 1-1 1c0 1-1 1-1 1h-6v-5h-1v5s1 1 2 1h5l5-6h4v-5h-5v5zM57 89c0-1 0-2 1-2 0 0 1 1 1 2s-2 1-2 0zm1-17 13-15v-5h-1v4S59 70 58 71s-1 1-1 2v12l-1 1v5c1 2 3 2 3 0v-5s0-1-1-1V72z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M98 3c1-1 1 0 1 0v2c-1 0-2-1-1-2zm-1-1v5h1v1l-4 4H83l-4 5v11h1V17l3-4h12l4-4V7l1-1V2c0-1-1-2-2-2 0 0-1 1-1 2zM62 89c0-1 0-1 1-2l1 1c0 2-2 2-2 1zm9-31s-7 9-8 10c0 0 0 1-1 1v16s-1 1-1 2v4s1 1 2 1 1-1 1-1v-4c0-1 0-2-1-2V69s7-8 8-9l1-2v-6h-1v6zM53 2c1 0 1 3 0 3-2 0-2-3 0-3zm-2 0v5h1v4l2 2h11l3 4v11h1V17l-3-5H54l-1-1V7c1 0 1-1 1-1V2c0-3-3-3-3 0z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M67 89c0-2 2-2 2-1 0 2-2 2-2 1zm5-29-4 6v19c-1 0-1 1-2 1v3c0 1 0 2 1 3s2 0 2-1c1 0 0-1 0-2v-3s0-1-1-1V66l4-4c0-1 1-2 1-2v-8h-1v8z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M72 89c0-1 0-2 1-2s1 2 1 2c-1 1-2 1-2 0zm1-8s1 0 1-1V52h-1v33c-1 0-1 0-2 1v3c0 1 0 2 1 2 0 2 2 2 2 0 1 0 1-1 1-2 0-2 0-4-2-4v-4zM93 5c-1 0-1-3 0-3 2 0 2 3 0 3zm0 2v3l-1 1H82l-4 4v13h1V15l2-2c0-1 0-1 1-1h10l2-2V7l1-1V2c0-2-3-3-3 0v4c0 1 0 1 1 1zM58 5c-1 0-1-1-1-1 0-1 1-2 1-1 1 0 1 2 0 2zm-1 2v3l2 2h8l2 3v13h1V15l-3-4h-8l-1-1V7c2 0 1-2 1-3V1c0-1-2-1-3 0v2c0 2 0 4 1 4z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M88 5c-1 0-1-2-1-2 1 0 1-1 1-1 2 0 2 3 0 3zm0 2c0 1 0 1-1 2h-7l-3 4v15h1V13l3-3h6l2-2V7l1-1V1c-1-1-3-1-3 0v3c0 1-1 2 0 3h1zM8 70h1v1H6l-2 2v1H3v5h3v-5H5c0-1 1-1 1-2h2s1-1 2-1v-1h1v-5H8v5z"
          />
          <path
            className="CyberEl87_svg__fil1"
            d="M141 49h6v6h-5v-2h-2c0 2 0 3 1 4h6c1-1 1-1 1-2v-6c0-1 0-1-1-1h-6c-1 0-1 1-1 1v2h2l-1-2z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M63 2s1 1 1 2-2 1-2 0 0-2 1-2zm-2 0v4l1 1v1l2 2h4l2 3v15h1V13l-3-4h-4l-1-1V7c1 0 1-1 1-1V2c0-1 0-2-1-2s-2 1-2 2zM28 30c1 0 1 1 1 1-1 1-1 0-1-1zm0 2h2v-1h3l8 9h23v-1H41l-7-8h-4v-1h-2v2zM83 2c1 0 1 1 1 2 0 0 0 1-1 1s-1-3 0-3zm-1 0v6h-3l-3 3v17h1V12c0-1 1-2 1-2s1-1 2-1h2l2-2 1-1V2c0-3-3-3-3 0z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M78 5c-1 0-1-1-1-1 0-2 2-2 2 0 0 0 0 1-1 1zm-1 2-2 2v19h1V10c0-1 2-2 2-3 1 0 1 0 1-1 1 0 1-1 1-2s0-2-1-3c0-1-2-1-2 0-1 1-1 1-1 2s0 3 1 3v1zM68 5c-1 0-1-1-1-1 0-2 2-2 2 0l-1 1zm0 2s3 4 3 5v16h1V11s-1-2-2-2l-1-2V1c-1-2-2-1-3 0v3c0 1 0 2 1 2 0 1 0 1 1 1z"
          />
          <path
            className="CyberEl87_svg__fil0"
            d="M73 2c1 0 1 3 0 3s-1-3 0-3zm-2 0v4c0 1 1 1 1 1v21h1V7c1 0 2-1 2-1V2c0-1-1-2-2-2s-2 1-2 2zM121 34v-1l1 1c0 1-1 1-1 0zm8-3h-6s0 1-1 1v1h-2v2h2v-2l1-1h6v2h4v-5h-4v2zM102 21c1 0 1 1 0 1 0 1-1 0 0-1zm9-10c1-1 1 1 0 1 0 0-1-1 0-1zm-4 0s1-1 1 0-1 1-1 0zm-1 2h1v3l-5 5h-1v2h2c0-1 0-1 1-2v-1l4-3v-4c0-1 0 0 0 0v-1h2v1h2v-3h-2v1h-2v-1h-2v3zM70 75c2 0 2 3 0 3-1 0-1-3 0-3zm1-8h1c0 1-1 1-1 0zm-1 2h1l-1 1v3s-1 0-1 1v5c0 1 1 1 2 1s1 0 1-1v-5l-1-1v-4h1v-3h-2v3zM60 83h1c0 1 0 1-1 1 0 0-1-1 0-1zm0-5s-1-1-1-2l1-1c2 0 2 3 0 3zm1 2c1-1 1-2 1-4v-2c-1-2-3-1-3 0v5c0 1 1 1 1 1v2h-1v2h2v-4zM65 75c2 0 2 3 0 3-1 0-1-3 0-3zm0-5h1s0 1-1 1v-1zm-1 2h1v1c-2 0-1 3-1 4v2c0 1 0 1 1 1 0 0 1 0 2-1v-2c0-1 0-3-1-4v-4h-2v3zM45 78c-1 0-1-1-1-2l1-1c1 0 1 3 0 3zm0-5c-1 0-1 0-1 1-1 0-1 2-1 3 0 0 0 1 1 2 0 1 2 2 2 0 1-1 1-2 1-3 0 0 0-1-1-2 0-1 0-1-1-1zM133 89v-1c1-1 2 0 2 1s-2 1-2 0zm1 3c1 0 1 0 1-1 1 0 0-2 0-2 0-1 1-2 0-3 0-1-2-1-3 0v5c1 1 1 1 2 1z"
          />
          <path
            className="CyberEl87_svg__fil1"
            d="M17 57c0 1 2 1 2 0 0-2-2-2-2 0zM67 89c0 1 2 1 2-1 0-1-2-1-2 1zM17 51c0 1 2 1 2 0 0-2-2-2-2 0zM128 89c0 1 2 1 2-1 0-1-2-1-2 1zM47 89c0 1 2 1 2-1-1-1-3-1-2 1zM102 89c1 1 3 1 2-1 0-1-2-1-2 1zM73 2c-1 0-1 3 0 3s1-3 0-3zM16 89c0 1 2 1 2-1 0-1-2-1-2 1zM31 89c1 1 2 1 2-1 0-1-2-1-2 1zM102 4c0 1 2 1 2 0 0-2-2-2-2 0zM62 89c0 1 2 1 2-1l-1-1c-1 1-1 1-1 2zM7 87c-1 0-1 3 0 3s1-3 0-3zM26 89c0 1 2 1 2-1 0-1-2-1-2 1zM42 89c0 1 2 1 1-1 0-1-2-1-1 1zM57 89c0 1 2 1 2 0s-1-2-1-2c-1 0-1 1-1 2zM129 2c-1 0-2 3 0 3 1 0 1-3 0-3zM53 2c-2 0-2 3 0 3 1 0 1-3 0-3zM70 75c-1 0-1 3 0 3 2 0 2-3 0-3zM93 5c2 0 2-3 0-3-1 0-1 3 0 3zM65 75c-1 0-1 3 0 3 2 0 2-3 0-3zM32 5c2 0 2-3 0-3-1 0-1 3 0 3zM63 2c-1 0-1 1-1 2s2 1 2 0-1-2-1-2zM138 89l1 1c1 0 1-1 1-2s-2-1-2 1zM92 89l1 1c1 0 1-1 1-2s-2-1-2 1zM1 89s0 1 1 1 1-3 0-3-1 1-1 2zM2 5l1-1c0-2-2-2-2 0 0 0 0 1 1 1zM119 2c-2 0-2 3 0 3 1 0 1-3 0-3zM17 2c-1 0-1 3 0 3s1-3 0-3zM68 5l1-1c0-2-2-2-2 0 0 0 0 1 1 1zM133 89c0 1 2 1 2 0s-1-2-2-1v1zM77 89l1 1c1 0 1-3 0-3l-1 1v1zM148 4c0 1 2 1 2 0s0-2-1-2c0 0-1 1-1 2zM36 89c1 1 3 1 2-1 0 0 0-1-1-1 0 0-1 1-1 2zM52 89s0 1 1 1c0 0 1-1 1-2-1-1-3-1-2 1zM83 2c-1 0-1 3 0 3s1-1 1-1c0-1 0-2-1-2zM72 89c0 1 1 1 2 0 0 0 0-2-1-2s-1 1-1 2zM11 89l1 1c1 0 1-3 0-3s-1 1-1 2zM118 89s0 1 1 1 1-3 0-3-1 1-1 2zM143 89c0 1 2 1 2-1 0 0-1-1-1 0h-1v1zM7 2C6 2 6 3 6 4s2 1 2 0 0-2-1-2zM144 2s-1 1-1 2 2 1 2 0 0-2-1-2zM87 89l1 1c1 0 1-1 1-2s-1-1-2 0v1zM50 75c-1 0-1 3 0 3s1-1 1-1c0-1 0-2-1-2zM42 5c1 0 1-1 1-1 1-2-1-2-1 0v1zM108 5c1 0 1-1 1-1 1-2-1-2-2 0l1 1zM124 5c1 0 1-2 0-2 0-1-1 0-1 1 0 0 0 1 1 1zM58 5c1 0 1-2 0-2 0-1-1 0-1 1 0 0 0 1 1 1zM78 5c1 0 1-1 1-1 0-2-2-2-2 0 0 0 0 1 1 1zM47 5c1 0 2-1 2-1 0-2-2-2-2 0v1zM60 78c2 0 2-3 0-3l-1 1c0 1 1 2 1 2zM27 5c1 0 1-1 1-1 0-2-2-2-2 0l1 1zM139 5c1 0 1-3 0-3s-1 1-1 2c0 0 0 1 1 1zM82 89l1 1c1 0 1-1 1-2 0 0 0-1-1-1 0 1-1 1-1 2zM22 5c1 0 1-1 1-1 0-1-1-2-1-1-1 1-1 2 0 2zM21 89c0 1 2 1 2-1 0 0-1-1-1 0h-1v1zM88 5c2 0 2-3 0-3 0 0 0 1-1 1 0 0 0 2 1 2zM55 75s-1 1-1 2l1 1c2 0 2-3 0-3zM123 89s0 1 1 1 1-1 1-2c-1-1-2 0-2 1zM12 5c1 0 1-3 0-3l-1 1s0 2 1 2zM134 5c1 0 1-3 0-3s-1 1-1 2c0 0 0 1 1 1zM113 5c2 0 2-1 1-2 0-1-1 0-1 1v1zM45 78c1 0 1-3 0-3l-1 1c0 1 0 2 1 2zM148 89l1 1c1 0 1-1 1-2-1-1-2 0-2 1zM97 89l1 1c1 0 1-1 1-2 0 0 0-1-1-1 0 1-1 1-1 2zM113 89s0 1 1 1c0 0 1-1 0-2 0-1-2 0-1 1zM37 3c-1 1 0 2 1 2s1-2 0-2c0-1 0-1-1-1v1zM107 89c0 1 2 1 2 0 1 0 0-2-1-2 0 0-1 1-1 2zM98 3c-1 1 0 2 1 2V3s0-1-1 0zM132 24h2v-2h-1v2h-1zM129 24h1-1v-1zM132 19h1v1h1v-2h-2zM129 20v-1h1v-1h-1zM132 62v1-1c0-1-1-1-1 0h1zM123 52h1v-1h-1v2zM118 51l1 1v1h1v-2h-2zM128 62h1s-1-1-1 0v1-1zM118 56h2v-1h-1v1h-1zM123 56h1-1v-1zM107 11c0 1 1 1 1 0s-1 0-1 0zM18 23s0 1 1 1c0 0 0-1-1-1zM111 11c-1 0 0 1 0 1 1 0 1-2 0-1zM28 30c0 1 0 2 1 1 0 0 0-1-1-1zM144 52c0 1 1 1 1 0h-1zM102 49c-1 0 0 1 0 1l1-1s-1-1-1 0zM20 67c0 1 1 1 1 1 1 0 1-1 0-1h-1zM121 34c0 1 1 1 1 0l-1-1v1zM50 23v1c1 0 1-1 0-1zM145 11c0 1 1 1 1 0 0 0-1-1-1 0zM39 11c0 1 1 1 1 0 0 0-1-1-1 0zM60 83c-1 0 0 1 0 1 1 0 1 0 1-1h-1zM75 84h1v-1h-1v1zM71 67c0 1 1 1 1 0h-1zM65 70v1c1 0 1-1 1-1h-1zM82 70c0 1 0 1 1 1v-1c0-1-1 0-1 0zM28 49s0 1 1 1v-1s0-1-1 0zM102 21c-1 1 0 2 0 1 1 0 1-1 0-1zM121 44c0 2 1 1 1 0h-1z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl87;
