import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl85 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2255}
      height={2300}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 222 227"
      {...props}
    >
      <defs>
        <style>{".CyberEl85_svg__fil0{fill:#000}"}</style>
      </defs>
      <g id="CyberEl85_svg__Vrstva_x0020_1">
        <g id="CyberEl85_svg___2649068319904">
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-9 0-17 2-8 1-15 5-20 8h8s-1 2-1 4c-1 2-1 5-1 6h5c-1 3-3 6-4 9h27c0 5 0 11-1 17 2 0 10 6 19 11s18 10 18 11c1 4 2 13 2 17 1 0 1 0 2 1 0 1 0 2-1 3s-2 0-3 0c-1-2-1-4 1-4 0-6-1-12-2-17-1-1-10-6-19-11-9-6-17-11-18-11 1-3 1-7 1-10v-6c-12 0-25-1-27 0v-2c1-1 2-3 4-7-5 0-4 0-5-1 0-1 0-4 1-6 0-2 1-4 2-4h-9c7-4 15-7 23-9 8-1 14-1 15-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-8c-1 1-3 1-4 1h2c1 0 2-1 2-1h8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-7c-1 0-1 0-1 1h-1c1-1 2-1 3-1s2 0 0 0h6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-3 0-6 0-9 1h-4c-3 1-3 1-1 0h3-1 3c3-1 6-1 9-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-7 0-10 1-11 1h-2s-5 1-6 2h-2 1c1-1 3-1 3-1h-2 1c2 0 4 0 5-1h1c4-1 8-1 12-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-6 0-11 1S92 4 91 4c-1 1-3 2-4 3 0-1 1-1 1-1s0 1-1 1c-1 1-3 1-2 1l1-1c2-2 3-2 4-2 0-1 0-1 1-1 0 0 4-2 9-3 6-1 11-1 13-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s-4 0-9 1c-5 0-9 2-9 2-1 0-2 1-3 1 2 0 0 1-2 1-1 1-1 0 1-1 1 0 2-1 3-1 6-2 13-3 19-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-6c-4 1-7 2-8 2h-2 1c-1 1-2 1-3 1s-1 0 0 0h2c0-1 1-1 2-1 4-1 9-2 14-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-5l-3 1c-5 1-10 2-15 5 0 0-2 2-4 5-1 2-1 5-1 6h8s-1 2-1 4 1 4 1 4h20v19c4 2 10 5 15 9l18 9c11 7 19 12 20 12 2 9 3 19 3 29h30v1c1 4 1 8 1 12 0 0 1 1 1 2s-1 2-1 3h-1c-2-2-1-4 0-5v-12h-31c0-10-1-20-3-29v-1s-14-8-27-15c-7-4-14-7-18-10-5-3-8-4-8-4V26H92v-9h-8v-2c1-1 1-3 2-5l4-4c8-4 12-5 13-5h2s2-1 4-1h4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-5 0-7 1h-1c-5 1-9 2-14 5l-1 1s-1 1-2 3-1 5-1 5h17v2c0 1 0 2-1 2s-1 0-1-1 0-1 1-2H86c0-1 0-3 1-6 1-2 3-4 3-4 5-2 10-4 14-5 1 0 0 0 4-1h5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-4c-2 0-3 1-4 1-4 1-8 2-12 4 0 1-1 1-1 1s-1 1-2 3-1 4-2 4h27v13c1 4 1 8 1 11v6s3 2 7 4c5 3 12 6 18 10 14 7 27 15 28 15 1 9 3 18 3 28h45c2 4 3 9 4 13 1-1 1 3 1 4s-1 1-1 0v-3c-1-5-2-9-4-13h-45s-1 0-1-1c0-9-1-18-3-27-3-2-23-13-23-13-16-9-24-13-27-15l-3-1V18c-1-2-1-4-1-4H88s0-3 1-5 3-3 3-3c7-4 10-5 12-5h1c3-1 6-1 8-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-7 1h-1c-4 1-7 2-11 4 0 0-1 2-2 3s-1 3-1 3h23c3 0 3 0 3 1s1 2 1 5c0 2 1 6 1 9s1 7 1 10v5c0 1 11 7 24 13 12 7 25 14 27 15v1c2 8 4 17 4 26h44v-2c1 0 1 1 1 2 1 1 0 2 0 2 0 1 0 1 0 0-1 0-1-1-1-1h-44l-1-3c0-3 0-10-3-24h-1c-1-1-10-6-21-12-10-6-22-12-29-16-1 0-1-1-1-2v-7c0-3-1-7-1-10s-1-6-1-8v-3H90s0-2 1-3c1-2 2-3 2-3V5c7-3 10-4 12-4h1c2-1 5-1 7-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-6 1h-1c-4 1-7 2-10 4l-2 2c-1 1-1 2-1 2v1h26c1 2 2 5 2 8 1 3 1 6 2 9 1 6 1 11 1 12 6 4 13 7 19 10 35 19 32 18 32 19 1 3 2 7 3 11l9 9h4c0-1 0-1 1-1 0-1 1-1 1 0 1 1 2 2 1 3 0 1-1 1-2 0 0 0-1 0-1-1h-4c-10-10-10-9-10-10-1-4-1-8-2-11-5-3-18-10-30-17-11-6-21-11-21-11-1-6-2-12-3-17 0-3 0-5-1-7 0-2-1-4-1-6H92c1 0 1-1 1-2 1-2 2-2 2-3 6-3 9-4 10-4h2c2-1 4-1 6-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-5 1h-1c-1 0-3 0-7 2h2-1c0 1-1 1-1 1V3h-1 1c2-1 4-2 7-2 2-1 4-1 6-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-6 1-1 0-2 0-3 1h1c1-1 1-1 0 0h-2 1c1-1 2-1 3-1h1c2-1 3-1 5-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-3 0-5 1-5 1-2 0-4 2-4 2h-1c-1 1-2 1-2 1l1-1h1c2-1 3-2 5-2h-1 1c1-1 3-1 5-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-3c-3 1-6 3-9 5h-1c-1 1-2 1-2 1 1 0 1-1 2-1 0 0 1-1 1 0h-1 1c3-2 6-4 9-5h-1 4zM113 0h-1 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-1c-1 0-2 0-3 1h1c1-1 1-1 2-1h1-1c-1 0-2 1-2 1h-1s1-1 2-1h2zM113 0h-1 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-1l-1 1h-2l-4 4v2h1v1h-1v1c-1 0-1-1-1-1l1-1V5c1-1 2-3 4-4 1 0 2-1 3-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-1c-1 1-1 1-2 1 0 0-1 1-1 2-1 0-2 1-2 1 0 1 1 1 0 1 0 1 0 1-1 1V5h1V4l3-3c1 0 1 0 2-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-1s0 1-1 1c0 0-1 1-1 3-1 1-2 3-2 3 1 0 1 1 0 1-1 1-1 0-1 0 0-1 1-1 1-1 1-2 1-3 2-4 0-1 0-1 1-1V1c1 0 1 0 1-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s-1 0-1 1v2c-1 0-1 2-1 4v1l-1 1V8c-1 0 0-1 0-1 1-2 1-4 2-6V0h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0v2s0 1-1 2v3h8v1s1 1 1 3c1 2 2 6 3 9 1 4 1 8 2 12 1 3 1 6 1 6h-1v-4c-1-2-1-6-2-10-1-3-1-5-2-8s-1-5-2-8h-8V4c0-1 0-2 1-3V0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0v1c0 1 1 3 1 5h7l1 2c1 1 2 4 3 7 1 2 1 5 2 8s2 8 3 13c1 0 16 8 19 10 0-2-1-4-1-6-1 0-2 0-2-1v-2h2c1 1 1 2 1 2 0 1 0 1-1 1 1 2 2 4 3 7h-1s-5-3-10-5c-5-3-10-6-11-6 0 0 0-2-1-6 0-3-2-8-3-12l-3-9c-1-2-2-3-2-3h-7V0zM113 0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 1 0 1 1h1c1 1 2 1 3 2 1 0 2 1 3 1 1 1 2 1 2 1l1 1c0 1 2 2 5 8 1 0 2 1 3 2h1l1 1c1 1 1 2 0 2 0 0-1-1-2-1v-1l-3-3c-1 0-1 0-1-1-1-1-2-4-5-8-3-1-5-2-6-3-1 0-2 0-2-1h-1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 1 0 2 1h1s1 1 2 1c1 1 3 1 4 2h2c2 2 4 5 6 8 0 0 4 2 7 4 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1-1 0-1 0-1-1-1-1s-6-4-8-5c0 0-1-2-2-3-1-2-3-3-3-4-2-1-3-2-5-2-1-1-1-1-2-1-1-1-2-1-2-1-1 0 0 0 0 0-1-1-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h1s1 0 2 1h1-1c-1-1-1-1-2-1h-1zM113 0h2-2zM113 0h1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h3c0 1 1 1 1 1h-1V0h-1 1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 3 0 4 1h1c1 1 1 1 0 1 0 0 0-1-1-1h1s-1 0-1-1h-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 6 1 9 3 5 3 8 7 8 7 1 1 3 2 4 3 0 0 0-1 1 0 0 0 1 0 2 1 0 1-1 1-1 1-1-1-2-1-2-2-1-1-3-2-4-3l-1-1c-1 0-1-1-3-3-1-1-2-2-5-4-2-1-5-2-8-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c5 0 8 2 10 3 3 2 4 3 5 4 2 2 2 1 2 2h2s2 1 2 2h-1c-1 0-1-1-2-1l-1-1h-1c0-1-3-5-7-7s-8-2-9-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c3 0 6 1 8 2h1c1 0 2 1 1 1-1-1-2-1-2-1-2-1-5-2-8-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h5c3 1 6 2 10 4 3 3 7 6 9 8 3 3 4 5 4 6 0 0-1 3-1 4 2 3 3 6 5 9 2 1 2 3 2 3-1 1-1 1-2 1 0 0 0-1-1-1v-3c-1-3-3-7-5-10 1-1 2-3 2-4-2-2-8-9-14-13s-12-4-14-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s3 0 8 1c4 1 10 4 15 9 6 6 11 13 14 18 3 7 5 11 5 11 2 1 11 7 20 12l16 12 1 1s2 5 3 11c2 6 3 12 3 13h20c-1-3 1-2 1 1 1 2 0 3-1 0h-20c-2-9-4-17-7-25 0 0-9-7-18-13-9-5-18-11-18-11s-2-5-5-11c-4-6-8-13-14-19-5-4-11-8-15-9-5-1-8-1-8-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s3 0 8 1 11 4 16 9c6 5 11 12 15 18l5 10c1 1 10 6 19 12s17 12 17 12h5c0-1 0-2 1-1 1 0 2 2 2 3 0 0 0 1-1 1 0 0-1-1-1-2h-6s-5-4-12-9c-7-4-16-10-23-15-1 0-1 0-1-1-1 0-3-5-6-11-4-6-9-12-14-17s-11-8-16-9c-4-1-7-1-8-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c3 0 5 0 7 1 6 1 8 2 9 3h2c0 1 1 1 1 2 3 1 6 3 8 5 5 3 9 5 13 8 4 2 8 4 11 6 6 4 10 6 12 8 5 4 4 3 4 3h7v1c1 1 9 10 14 21s8 22 8 23h7v-2s1 1 1 2c1 1 1 3 0 3 0 0-1-1-1-2h-7c0-3-4-15-9-26-6-10-13-19-13-19h-7c-10-8-19-13-25-17-6-3-9-5-11-6-5-3-4-2-4-2l-1-1c-4-3-5-4-6-5h-1c-1-1-1-2-2-2s-5-2-8-3c-4-1-8-1-9-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 6 0 10 1s7 3 9 3c0 0 0 1 1 1l1 1c1 0 0 0 1 1 1 0 2 1 5 3h4v1c2 1 4 2 6 4 9 5 18 11 27 17h7c1 0 9 9 15 19 6 11 10 22 10 23h7v-2l1 1c0 1 1 2 1 3s-1 0-2-1h-7v-1c-6-15-14-30-24-41h-7s-1 0-1-1c-9-6-18-12-27-17-2-1-4-3-6-4h-4v-1c-2-1-4-2-6-4-1 0-2-1-3-2l-2-1c-2-1-6-3-16-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c3 0 7 0 11 1 5 2 9 3 10 4l1 1c1 0 1 1 2 1 0 0 1 0 1 1 1 0 1 0 2 1h-2c0-1-1-1-1-1V7l-2-1c-1 0-1 0-2-1-6-3-13-5-20-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s7 0 13 2c7 2 13 5 13 5 1 0 1 1 2 1l1 1c-1 0-2-1-2-1-1 0-1-1-1-1-4-2-10-5-15-6s-9-1-11-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 11 0 19 4 9 3 17 9 18 10 8 4 16 9 25 15h8c5 5 9 10 13 16h4c5 6 8 13 12 20h1c-1-3 0-2 1 1 1 2 0 3-1 0h-1l-1-2c-2-3-4-8-11-18h-4v-1c-4-5-8-11-13-15h-7c-14-10-21-13-24-15l-3-1c-1-1-9-7-17-10-8-4-17-4-19-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s10 0 19 3c10 3 18 10 18 10 3 1 12 6 14 7-1 0-2-1-3-2 0 0-1-1-2-1-1-1-1-2 0-2 0 1 0 1 1 1l1 1 1 1c1 1 2 2 4 3v1c-6-4-11-6-16-9-11-8-24-13-37-13z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 6 0 10 1l10 2s1 0 2 1h1c-1 0-2-1-3-1-3-1-6-2-10-2-4-1-8-1-10-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c13 0 25 3 36 10 0 0 9 3 10 4s4 3 8 6c3 2 6 5 6 6h6c1 0 12 9 12 9 1 1 2 2 4 3 0 1 1 1 1 2 1 1 2 2 1 2l-3-3v-1l-3-3c-1-1-11-8-11-9h-6c-2-1-5-4-8-6-3-3-6-5-7-6 0 0-9-4-10-4-1-1-10-6-18-8-9-2-18-2-18-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 8 0 16 2s17 5 20 7c3 1 6 3 10 4h3c4 3 7 5 11 8 0 0 0 1 1 1h-3c1 0 1 1 1 1s-2-1-3-2l-1-1c1 0 1 0 3 1h1c-3-3-6-5-10-7h-2c-1 0-11-5-11-5-1 0-9-5-18-7s-18-2-18-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c6 0 11 1 16 2h2s2 0 4 1c1 0-1 0-3-1h-3c-5-1-10-2-16-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s12 0 22 3c11 3 21 8 21 8h3l2 1c2 1 6 3 12 7l1 1c1 1 3 2 6 5h1l2 2c4 3 6 5 7 6 1 0 2 1 2 1 7 8 14 17 19 26h1v1c1 1 1 2 2 2v1c1 1 2 3 2 3 0 1-1 1-1 0-1-1-1-2-1-2 0-1-1-1-1-2 0 0 0-1-1-2h-1c-5-10-11-19-19-27 0 0-1 0-1-1-5-4-10-7-11-8l-10-8c-5-3-10-5-10-5h-3s0-1-1-1c-13-7-28-11-43-11z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 12 0 21 2 9 3 18 7 20 7h2l1 1c2 1 7 3 12 6s9 7 10 7c0 1 1 1 1 1 1 1 11 8 11 9 8 7 14 16 19 25h1c1 0 1 0 3 5 1 0 1 1 1 1s1 1 1 2c1 2 1 2 0 1 0 0-1-2-1-3-1 0-1 0-1-1s-1-3-2-4h-2v-1c-5-9-11-17-18-25-1 0-11-8-12-8 0-1 0-1-1-1 0-1-5-4-10-7-5-4-10-6-12-7h-3c-1-1-9-5-19-7-9-3-19-3-22-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s10 0 20 2c9 2 18 6 18 6h3c9 4 17 9 24 14 0 0 11 8 12 9 0 0 8 6 19 23h1c-1-2-1-1 0 1l2 2s-1-1-1-2h-2c-6-9-12-17-19-24-1-1-10-8-12-9-7-5-15-10-23-13h-3V8c-2 0-10-4-19-6s-18-2-20-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 10 0 19 2 8 1 16 4 16 5h3c9 3 17 8 25 13l6 4c3 2 6 5 6 5 8 7 16 17 17 19h1c-1-2-1-2-1-1 1 1 2 3 2 3 1 1 0 0 0-1h-1s-1 0-1-1l-8-10c-4-4-8-9-8-9l-6-4c-3-2-7-4-7-4-8-6-16-11-25-14h-2c-11-5-24-7-36-7z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c4 0 8 0 13 1h4c0 1 1 1 1 1 4 0 8 1 11 2h1-1c1 0 3 1 3 1h-2l-1-1c-4-1-7-2-11-2-1 0 0-1-6-1-4-1-8-1-12-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h6c4 0 7 1 7 1 2 0 4 0 6 1h1c2 0 5 1 4 1 0 0-1 0-2-1h-4c-2-1-4-1-5-1-4-1-9-1-13-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c3 0 10 0 13 1h2c1 0 2 0 3 1h3c2 0 4 1 4 1s-1 0-3-1h-4c-2-1-3-1-5-1-4-1-9-1-13-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c4 0 8 0 11 1h6c1 1 3 1 4 1h1s1 0 2 1c3 0 0 0-2-1h-1c-1 0-3 0-4-1h-4c-1 0-4-1-9-1h-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 13 0 24 3 11 2 22 7 24 8 1 1 3 1 4 2s2 1 2 1c3 1 5 3 7 4l1 1c2 2 3 2 2 2l-3-3c-3-1-5-3-7-4s-3-2-5-3c-1 0 0 0-4-1-2-1-4-2-9-4s-12-4-22-5c-4-1-9-1-14-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c13 0 23 2 29 4 7 2 11 3 14 5l5 2c2 1 4 2 5 2 2 1 3 2 4 2 1 1 3 2 4 3 1 0 1 0 1 1 1 0 2 1 3 1 1 1 0 1 0 1-1-1-3-2-3-2 0-1-1-1-1-1-3-2-5-3-5-3-1-1-1-1-2-1-1-1-3-2-5-3-1 0 0 0-5-2-3-1-7-3-13-5-7-2-17-4-31-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c15 0 26 3 34 5 8 3 13 5 16 7 3 1 4 2 5 2 0 0 8 5 9 6 6 3 11 8 16 12 1 2 2 3 3 4 1 0 1 1 1 1 1 1 2 2 3 4 0 0 1 0 2 1 0 1 1 2 1 2s-2-3-3-3c-1-2-2-3-3-4s-2-3-4-4c0 0-1-1-1-2-1 0-4-3-7-6-4-2-7-5-8-5-1-1-7-5-9-6-16-9-36-14-55-14z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c16 0 27 3 35 5 8 3 12 5 15 7 3 1 4 1 4 2h1s8 5 9 6c5 3 10 7 15 12l3 3 1 1c0 1 2 2 2 2l-3-3c-2-3-3-3-3-3-8-8-14-12-15-12 0-1-9-6-10-6-2-2-5-3-12-6-8-3-20-8-42-8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c19 0 37 5 53 13 1 0 9 6 10 6 2 1 4 3 6 4 2 2 5 4 7 6l4 4-2-2c-1-1-2-1-2-2-6-5-9-7-11-9l-2-1s-1 0-1-1c-4-2-6-3-7-4s-1-1-2-1c-3-2-15-7-27-10-11-3-23-3-26-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s11 0 22 2c12 2 24 8 29 10 0 0 1 0 1 1 0 0 2 1 5 2 2 2 4 3 5 3 9 7 17 14 24 22 0 1 1 1 1 2l2 2c1 0-2-3-3-4-2-2-7-8-12-12-5-5-11-8-12-9 0 0 0-1-1-1-4-3-6-4-7-4-1-1-1-1-2-1 0-1-8-5-19-8s-24-5-33-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h10c4 1 9 2 9 2 1 0 4 0 5 1V2h-5c-6-1-12-2-19-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 9 0 18 1 8 2 17 5 19 6 2 0 5 1 7 2 0 0 1 0 2 1h1c-1 0-1 0-2-1-1 0-4-1-2-1-2 0-6-2-6-2-12-4-24-6-37-6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c4 0 8 0 12 1 14 1 20 4 23 5l3 1c1 0 0 0 5 2 3 1 4 1 3 1-1-1-3-1-4-2-1 0-3-1-4-1-3-1-12-4-21-6-8-1-16-1-17-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c4 0 12 0 20 2 8 1 15 4 19 5 1 1 2 1 3 1 0 1 1 1 1 1 1 0 2 1 2 1h1-1c-1-1-3-1-3-2h-1c-1 0-1 0-2-1l-4-1c-2-1-6-2-11-3-6-2-13-3-24-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c15 0 30 3 43 9 4 2 8 4 13 6 0 0-1 0 3 2 2 2 5 4 10 7 4 3 10 8 16 16v1c1 0 2 2 3 3s1 0 0-1l-3-3c-8-10-18-18-29-25-8-4-11-5-12-6-2 0-1 0-3-1-12-5-21-6-27-7-7-1-10-1-14-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c19 0 39 6 55 17 2 0 3 1 4 2 3 2 4 3 4 2-1-1-5-3-4-2-1-1-3-2-4-3-2-1-14-8-27-12s-27-4-28-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c21 0 42 7 59 20 2 1 4 2 6 4 2 1 4 2 3 2 0-1-1-2-2-2l-1-1c-1-1-6-3-6-4-3-2-12-8-24-12-11-5-25-7-35-7z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h8c2 1 6 1 11 2 6 1 14 3 24 9 11 5 25 14 38 32 0 1 0 1 1 1 0 1 1 1 4 4 2 3 3 4 3 3s-1-2-2-3c0-1-1-1-1 0-1-2-3-3-5-5 0 0-3-5-9-11-6-7-15-14-25-20-10-5-21-9-30-10-9-2-15-2-17-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c27 0 46 11 58 20s18 18 22 23c3 5 5 8 6 9v2s1 2 1 3c1 1 2 2 2 1s-1-2-1-3l-1-1c-1-1-4-7-10-15s-16-17-27-24-23-11-32-13c-10-2-17-2-18-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c4 0 13 0 22 3 10 2 21 7 30 14 19 13 31 33 31 33 0 2 1 3 1 4 0 0-1 0-1 1s1 2 2 3c2 1 2-1 0-3-1-4-1-4-2-5 0 0-3-6-10-14-6-7-15-16-26-23-10-6-22-10-31-12-9-1-15-1-16-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s6 0 15 1c9 2 20 6 31 12 10 6 19 15 26 23 6 7 9 13 9 13v5c-1 0-1 0-1 1s1 2 2 3 1 0 1-1-1-2-1-2c0-2 0-4-1-5 0 0-3-6-9-14-6-7-15-16-26-23-10-6-22-10-31-12-9-1-15-1-15-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c17 0 33 5 47 14l3 3c-2 0 0 1 1 2s2 1 2 0c-1 0-2-1-2-1l-3-3c-3-2-13-8-23-11-11-4-22-4-25-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c13 0 26 4 38 10 3 2 1 0 6 3 0 1 1 1 1 2 1 0 3 1 2 0 0 0-1-1-2-1l-1-1c-1 0-2-1-3-1-1-1 0-1-5-3-2-1-6-3-11-5-6-2-14-4-25-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c16 0 28 5 35 9 8 5 13 9 16 11l5 5c0 1 0 1 1 1 3 5 6 12 7 18h-1s0 2 1 3 2 1 2 1c0-1 0-2-1-3v-1c-2-6-4-12-8-18 0-1-11-12-25-19-7-3-14-5-20-6s-10-1-12-1zM113 0h7-7zM113 0h7-7z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c7 0 13 1 19 3 2 1 4 1 6 2 0 0 0 1 1 1h2-1c-1-1-2-1-2-1h-1c-1-1-3-1-5-2 0 0-5-1-9-2-5-1-9-1-10-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c8 0 15 2 22 5l6 3h1l1 1h1s-2-2-3-2-3-1-4-1c-1-1-2-1-2-1-7-3-14-5-22-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c6 0 12 1 18 4 5 2 7 3 8 4 1 0 1 0 2 1 0 0 7 3 8 3l6 6 1 1c0 1 2 2 2 2 1 0 1-1-1-2 0-1-1-1-1-1-2-2-5-4-7-6h-1c-1-1-3-2-7-4-1 0-7-4-14-6s-14-2-14-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c13 0 20 5 20 5 1 0 1 1 2 1h-1c0 1 1 1 1 1 1 1 2 1 2 1 0-1-1-1-2-2l-1-1c-1 0-4-2-8-3s-9-2-13-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s8 0 15 4c7 3 14 10 14 10s4 3 7 5c4 2 9 5 9 6 1 0 2 0 3-1 1 1 1 2 2 2 0 0 0-1-1-2s-3-2-2 0h-2c-6-4-11-7-16-10-2-2-9-8-15-11-7-3-13-3-14-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 9 0 15 4 8 4 13 11 13 11l1 1c6 4 12 8 19 12v1s2 2 4 6c3 3 5 9 8 14 5 11 8 24 8 24v2c2-1 3 0 4 0s2 1 2 1c1 0 2-1 1-2-1-2-3-3-3-1h-3c-1 0-3-12-8-23-3-6-6-11-8-15s-4-6-4-7h-1s-5-3-9-6c-5-4-10-6-10-7 0 0-6-7-14-11-6-4-14-4-15-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c5 0 10 2 15 4 5 3 9 8 13 13 6 4 12 8 19 13-8-6-18-13-19-13 0 0-1-2-4-5-2-2-5-5-9-8-4-2-7-3-10-4h-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h5c2 1 6 2 9 5 3 2 6 5 9 8 2 2 3 5 3 5h1c2 2 5 4 8 6 0 1 0 1 1 2-1 1 1 3 2 3s1-1 0-1c0-1-1-2-1-2-1-1-1-2-2-2 0-1-1-1-1-1-2-2-5-4-7-5 0-1-1-2-3-4-1-1-3-4-7-7s-9-7-17-7z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 4 0 5 1h2c0 1 1 1 2 1h-1l-1-1h-2c-1-1-3-1-5-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 4 0 5 1 1 0 1 1 1 1h2c1 1 5 3 5 3l4 2c2 2 4 5 6 9 3 3 5 8 7 11l2 6h7c0 1 0 1 1 1 0 1 1 1 1 0 1-1 0-2-1-3-1 0-2 0-2 1h-5s-1-2-3-5c-1-4-4-8-6-11-2-4-5-7-7-9-2-1-3-2-3-2-1 0-1 0-3-1-3-2-3-2-5-2V1c-2 0-4-1-6-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h3l2 2c1 0 2 1 4 1 2 1 3 2 4 2 3 3 5 6 7 9 3 3 5 7 6 11 4 7 5 13 5 14h10c1 0 1 1 1 1 1 0 2 0 2-1 0 0-1-2-2-2-1-1-1 0-1 1h-9s-1-3-2-7c-2-4-4-8-6-13-3-4-5-7-7-9l-4-4-4-2c-2-1-3-1-4-1l-2-2h-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c2 0 3 1 4 1h-1c0 1 1 1 1 1h1l-1-1s-1-1-4-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c1 0 1 0 1 1 1 0 2 1 2 3 1 1 1 3 2 6-1 0-1 1 0 1 0 1 1 1 1 0s0-1-1-1V7c-1-1-1-2-1-3-1-1-1-2-2-2V1s-1 0 0 0c-1-1-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h1v38l5 5 13 13 2 1h11c1 3 4 2 3 0 0-2-3-3-3-1h-11s-5-4-10-9l-9-9V14c-1-2-1-4-1-6V0h-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m113 0 1 1V0h-1zM113 0c0 1 0 1 0 0zM113 0c-1 1 0 1 0 1v2s0 1-1 2v15c0 2-1 5-1 8v11c1 0 5 5 9 9l9 9v7h17l1 1c1 1 1 1 2 0 1 0 1-2 0-3s-2-1-3 0v1h-16v-7c-1 0-4-4-8-8l-10-10V13c1-2 1-3 1-5V0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-2c0 1-1 2-1 2l-2 2c-1 1-2 3-3 6-1 2-1 4-2 6-1 3-1 6-2 10s-2 8-3 13c0 5-1 11-2 18h25v1c0 1 0 4 1 12-1 0-1 0-2 1v2l1 1c1 1 3 0 3-1 1-1 0-3-1-3-1-5-1-9-1-14H97c1-6 1-11 2-16 1-4 1-8 2-12 1-3 1-6 2-8 0-3 1-5 1-6 1-4 2-6 3-7 1-2 1-3 2-4l1-1V1c1 0 2-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-3 1-4 2l-2 2c-1 1-1 2-2 4s-2 5-3 8c-1 2-2 4-2 7l-3 9c0 4-1 8-2 13 0 4-1 10-2 16 1 0 5 5 9 10 5 5 9 10 10 11h45c-1-11-2-19-4-24-1-5-2-8-2-10l-1-4h-16c-1-4-1-8-2-12h-10s0-3-1-7c0-3-1-7-1-9h3c0 1 1 1 1 1 1 0 1 0 1-1s-1-2-2-1h-4s0 1 1 3c0 1 0 3 1 6v6c1 2 1 3 1 3h9c1 4 2 8 2 12h16c1 3 3 11 5 19 1 8 2 16 2 17h-44c0-1-5-6-9-11-5-5-9-10-9-10s1-6 2-14c0-4 1-8 2-12l3-12c1-4 2-7 3-10s2-5 3-6c0-2 1-3 2-3 0-1 0-1 1-1 0 0 0-1 1-2h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-3 1-4 2h-1l-2 2c-1 1-2 2-3 4s-2 5-3 9c-1 2-2 4-3 7-1 2-1 5-2 9s-2 8-3 13-2 10-2 16c3 4 8 10 12 15s8 9 9 9h50s-1-12-3-23c-1-6-3-11-4-15s-2-6-2-6h-15c0-1-1-6-2-9-4-4-3-4-3-4-1-1-1-2-1-3v-1c1-1 0-3-2-2-1 0-1 2 1 3 0 1 1 2 1 3s2 3 3 4l1 1c2 9 2 8 2 9h14c1 1 4 10 6 20s3 20 3 22h-49l-2-2c-2-3-6-7-14-16l-4-5c0-1 0-5 1-11 1-4 1-7 2-11l3-12c0-3 2-7 3-10s2-6 3-8 2-4 3-5c1-2 2-3 3-3l2-2h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-2 0-3 1-1 0-2 1-2 1h-1s-1 2-4 5c-1 1-2 4-4 6-1 3-2 7-4 11-1 4-2 8-3 13-1 4-2 9-3 13-2 8-2 14-2 14 0 1 3 4 5 7 3 3 6 6 6 7 11 12 11 12 12 12h55c-1-11-3-24-6-33-2-9-5-16-5-17h-15c-2-8-3-12-3-13l-1-1c1-1 1-1 0-2 0-1-2-2-2-1v2c1 0 1 0 1 1 1 0 2 3 3 7 1 3 2 7 2 8h14c3 7 5 14 7 22s3 17 4 26h-54s-6-7-12-13c-5-6-10-12-10-13 0 0 1-6 2-14 1-4 2-9 3-13s2-9 3-13 3-7 4-10 3-5 4-7c2-3 4-4 4-4s1-1 3-2h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-2 0-3 1-1 0-2 1-2 1-1 0-3 1-6 4-1 2-3 5-5 8s-3 7-5 11c-2 5-3 10-4 15-2 5-3 10-4 15-1 9-2 15-2 15 1 2 5 7 10 13 5 5 10 11 12 13-5 5-10 10-14 15-1-1-3 0-3 1-1 1 0 3 1 3 2 1 3-1 3-3 4-6 9-11 14-16 0-1-6-7-11-13S84 71 83 70c0-1 1-7 2-16 1-4 2-9 3-14 1-4 3-9 4-13 2-4 3-8 5-11 1-3 3-5 4-7 2-4 5-6 5-6 1-1 1-1 2-1 0 0 0-1 1-1s2-1 4-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 1-6 2 0 0-3 1-6 5-2 2-4 4-6 8-2 3-4 8-6 13s-4 10-5 16-3 12-3 17c-2 11-3 19-3 20H62c-2 1-3 3-4 4-1 4-1 8-1 12-2 2-5 5-7 8-1-1-3 0-3 1-1 1 0 3 1 3 1 1 3-1 2-3 2-3 6-7 7-9 1-4 1-8 2-12l3-3h17c0-1 0-8 2-18 1-5 2-11 3-17 1-5 3-11 5-16 1-5 3-10 5-14 2-3 4-7 6-9 3-4 6-6 7-6 0 0 4-2 6-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-4 0-6 1-6 2-1 0-1 0-2 1 0 0-3 1-6 5-2 3-4 5-6 9-2 3-4 8-6 13s-3 10-5 15c-1 6-2 11-3 16-2 10-3 17-3 17H60c-4 4-4 5-4 5-1 3-1 6-1 9l-1 1c-1 1-2 3-4 4-1 0-2 0-2 1-1 1-1 2 0 3 1 2 3 0 3-3 1-2 3-3 4-5 1-3 1-6 2-10 1-1 2-3 3-4h17c0-3 1-11 3-21 1-5 2-10 4-16 1-5 3-10 5-15 1-5 3-9 5-12s4-6 6-8c3-4 6-5 7-5 0 0 1-1 3-2h3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-3 0-5 1-1 0-1 0-3 1 0 1-2 1-4 3l-5 5c-1 2-3 5-5 8-1 1-2 4-4 8-2 5-4 11-6 18s-4 14-5 20-1 10-1 10H60c-1 0 0-1-7 7-4 0-7-1-10-1v-1c-1-1-2-1-3 1-1 1 0 3 1 3 0 0 1 0 2-2 0 0 9 1 10 1 2-3 4-5 7-7h16c0-1 0-8 2-17 1-5 2-10 4-15 1-5 3-10 5-15s4-9 6-12c2-4 4-7 6-9 4-3 7-5 8-6 2 0 4-1 6-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-5 1-7 2 0 0-3 1-7 4-2 1-4 4-6 7s-4 6-6 11c-3 4-5 9-6 13-2 5-3 10-5 15-2 9-3 17-3 18H59c-1 0-1 1-1 1-5 2-4 2-5 2h-8c0-1-1-1-1-2-1 0-2 1-3 2 0 2 1 3 2 3 1-1 1-1 1-2h10c1-1 3-2 5-2 0-1 0-1 14-1 1-6 3-12 4-18 1-5 3-10 4-14 3-8 5-14 8-19 2-4 5-8 7-10s3-4 4-5c3-2 4-3 5-3h1s2-1 3-1c2-1 4-1 4-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-6 1 0 0-2 1-3 1 0 0-1 1-2 1l-1 1h-1 1c1 0 1 0 1-1h1l2-1c1-1 2-1 2-1h1c2-1 4-1 5-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0s-3 0-6 1c-2 0-5 2-6 2s-1 1-2 1-1 1 0 0h2V3c4-2 8-3 12-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-4 0-6 1h-1s-1 0-3 1c-1 0-1 0-4 1 0 0-1 0-1 1h-1c0 1 2 0 2-1 3-1 3-1 4-1s2-1 2-1h2c2-1 4-1 6-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-1 0-8 0-13 3-7 2-12 6-12 7-1 1-1 4-1 4-1 1-3 3-5 6s-4 5-4 5h-5v-1c-1 0-3 3-3 3 1 1 2 0 3-1h6c4-7 6-10 7-11s1 0 1-1c0 0 0-1 1-3V9c1 0 6-4 13-7 6-2 12-2 12-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-6 0-12 1-17 4-6 3-11 7-16 12h-1c-1 1-2 2-1 2s3-2 2-2c1-1 7-7 14-11s15-5 19-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-6 0-10 1-13 2s-4 2-4 2c-3 1-5 2-7 3-1 0-5 3-8 6-4 3-8 7-10 9 1-1 2 0 3 0-1 0 0 1 0 1 1-1 1-1 2-1 0 0 0-1 1-1 0-2-1-1-3 0h-1c7-9 12-11 14-13 2-1 2-1 3-1l6-3 2-1c2-1 6-3 15-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-6 0-12 1-18 4-2 1-4 1-7 2 0 0-2 2-6 4-3 2-8 6-12 10-4 5-8 10-11 15-4 5-6 9-7 11h21v3c-1 1-1 2-1 3 1 1 2 1 3 0s2-4-1-3c0-1 0-2-1-4H53c1 0 1 0 1-1 7-13 12-18 14-21l3-3 7-7c4-3 8-5 10-6l1-1c2 0 4-1 6-2 1 0 5-2 9-3s8-1 9-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-7 0-11 1-14 2s-4 1-4 2c-1 0 1-1 0 0l-7 2s-4 2-8 5c-5 3-11 8-16 13-5 6-9 13-12 18s-5 9-5 9h20c0 1 0 2 1 2 2 0 3-3 2-4 0-1-2 0-2 1H48c4-8 8-14 12-19 3-5 7-9 10-12 6-6 10-8 13-10s4-2 4-3h1c2-1 4-1 7-2 1-1 5-2 9-3s9-1 9-1zM113 0h-2c-1 0-1 0 0 0h2zM113 0h-2 2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-4c-2 0-5 1-5 1h-1c-5 1-9 2-13 3-1 0-1 1-1 1-1 0-2 1-3 2-1 0-4 1-8 4s-10 7-14 12H51l-4 2 1-1s-2 1-3 2l-1 1s1 0 3-2c0 0 2-1 3-1h13c2-2 7-8 13-11 5-4 10-6 10-7 1 0 2-1 3-1l2-1c1-1 5-2 12-3h1s2-1 4-1h5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-5c-2 0-5 1-5 1h-1c-2 0-6 1-14 4h-1c-1 1-2 1-3 2-6 3-12 7-18 12h-6c1 0 1-1 1-1-1 0-1 0-2 1 0 0-1 1-2 1 0 1 0 1 1 0h8c2-2 5-5 9-8 3-2 7-4 9-5 1 0 3-2 4-2 4-2 10-3 15-4h1s1 0 3-1h6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-6c-2 0-5 1-5 1-6 1-11 2-16 4-1 1-3 2-4 3h-2c-1 1-4 3-10 7h-4c1-1 1-1 0-1-1 1-2 1-2 2h-1c0 1 0 0 1 0h6c4-4 8-6 12-8 1-1 3-2 4-3h2c2-1 6-3 14-4h1c2 0 7-1 10-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-5c-3 0-5 1-6 1h-1c-5 1-10 2-14 4-1 0-2 0-2 1-2 0-3 1-5 2s-3 2-3 1h2c1-1 2-1 2-1 1-1 3-2 5-3 5-2 10-3 16-4 3-1 9-1 11-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-10 1-11 1h-2c-5 1-10 2-16 4l-1 1-4 2c-1 0-2 1-3 1s0 1 0 0c2 0 4-2 3-1 2-1 3-2 5-3h1c6-2 11-3 16-4 1 0 3-1 6-1h6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0c-2 0-11 1-12 1h-2c-2 1-6 1-14 4-1 0-3 1-4 1 1 0 2 0 2-1h2c5-2 9-3 14-4h2s1 0 3-1h9z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-6c-3 0-6 1-7 1s-5 1-8 2c-4 0-8 2-8 2h-2c-1 1-2 1-2 1h1c1-1 3-1 3-1 5-2 10-3 15-4h2c1 0 3-1 8-1h4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-9c-4 1-7 1-7 1h-1c-1 1-2 1-3 1h1c1 0 2-1 3-1 4 0 9-1 13-1h3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-3c-5 0-11 1-13 1-1 0-2 1-3 1h-2 2c1 0 2-1 3-1 2 0 5 0 8-1h8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M113 0h-5c-1 0-7 1-12 1-6 1-11 3-11 3-1 0-3 0-4 1-1 0-1 0 0 0 2-1 3-1 4-1 8-2 16-4 24-4h4zM113 0h-1 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M112 0c-10 0-17 2-21 3s-5 1-6 2c-1 0-2 0-3 1h-1c1-1 2-1 3-1s6-2 12-3c6-2 13-2 14-2h2zM111 0h-6 4-2 4zM113 0h1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M107 0h2-2c-1 0-2 1-2 1 1 0 2-1 2-1zM102 1c1 0 2-1 2-1s-1 0-1 1h-6 5-2 2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M103 0c0 1-1 1-1 1h-2l-7 1h1c1 0 2-1 3-1h1-1c-2 1-3 1-4 1h-1s8-1 9-1h-2 3c1-1 2-1 1-1zM126 1h-2 4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M100 1s-4 0-8 1-8 2-8 3c1-1-2 1-4 1h1c1-1 1-1 2-1 5-2 10-3 15-4h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m96 1-1 1c-1 0 0 0 0 0-3 0-8 1-9 1h1c2 0 3 0 4-1l-1 1c-1 0-3 0-4 1h-1c3-1 8-2 8-2h1-1c1 0 2 0 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M96 1c-1 1-2 1-3 1 1 0 2 0 3-1zM90 3h-1s-2 0-3 1c0 0-1 0 0 0 0 0 1 0 1-1h3zM120 3v1h1l-1-1zM119 3h-1c0 1 0 1 1 1V3zM124 4V3c1 0 2 1 2 1 0 1-1 0-2 0zM86 4s1 0 0 0-2 0-3 1h-1s-1 0-2 1h-1c1 0 2-1 3-1 1-1 2-1 3-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M82 4h2c-1 0-1 0-1 1h-2l-6 2h1c-1 0-4 2-7 3-2 2-5 4-5 4-2 1-4 2-2 2 2-1 4-3 3-3 0 0 3-2 5-3 3-2 6-3 7-3h-1l6-3zM138 5c1 0 2 0 2 1 2 0 2 1 0 0-1-1-2-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M77 6h2-3c-3 1-5 2-8 4-1 0-2 1-3 1s-1 0 0 0 3-1 4-2c3-1 8-3 8-3zM144 8c-1-1-2-1-1 0l2 1h1s-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M73 7h2l-1 1h-2c-4 1-7 3-11 5 0 0-1 0-1 1-1 0-2 1-2 1s2-1 3-2c1 0 1-1 1 0 3-2 7-4 11-6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M71 9h1c-1 1-1 2-2 3h7-1c-2 2-4 3-6 5h8v6c0 3 1 6 1 7-1 3-2 5-5 12h29c1-2 1-4 1-5-2-1-2-4 0-4 1 0 2 0 2 1s0 2-1 2c0 2-1 4-1 6v1H73v-1c2-4 3-8 5-11v-2c0-2-2-5-1-11h-8s-1 0 0 0c2-2 4-4 7-6h-7c1-1 1-2 2-2 0-1 0 0-1 0 0-1 0-1 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M71 9c-2 1-3 1-4 2 0 0 3-2 4-2zM76 10s-1 1-3 1c-1 1-1 2-1 2 1 0 2-1 3-2 0 0 1 0 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M67 11c1 0 1 0 0 0v3h6-1c-2 2-4 4-7 6h10c0 3 0 7 2 11-3 4-4 8-6 13 0 0 1 1 0 2 0 1-1 2-2 2s-1-3 1-4c0-1 2-4 3-7s3-6 3-6c-1-4-2-7-1-10H64c3-3 5-5 8-6h-6v-3c1-1 0 0-1 0 1-1 1-1 2-1zM63 13l1-1c-1 1-3 2-4 3 0-1 0-1 1-1 0 0 1-1 2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M64 13h1l-1 1c-1 1-2 1-3 2 0 0-2 2-3 2s-1 0 1-1c0-1 1-1 2-1l2-2 1-1h-1 1zM58 15l2-2s-3 2-4 3c-2 1-3 1-4 2-3 2-6 4-8 6 0 0-1 1 0 1h2-3c4-4 6-5 7-6s1 0 1-1c2-1 3-1 5-2 0-1 1-1 2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M58 14c1 0 3-1 2-1 0 1-3 2-4 3s-3 1-4 2c-3 2-4 3-5 4h1c0 1 0 1-1 1h-1c2-2 3-3 5-4s3-2 5-3c0-1 1-1 2-2zM60 15s1-1 1 0c0 0 1-1 0 0 0 0-1 0-1 1 0 0-1 0-2 1s-2 1-2 1 2-2 3-2 1-1 1-1h-1 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M64 16c1-1 0-1 6-1v1c-3 2-6 4-8 6h11v5c0 2 1 3 1 4-2 3-3 6-4 9-1 1-2 2-3 2-1 1-1 1-1 2 2 1 0 4-2 4s-1-3 1-4c1-1 1-1 1-2l3-3c1 0 4-7 4-8 0 0 0-2-1-4v-4H61c3-3 5-5 8-7h-5s-8 3-8 4h-3l3-3h1l-3 3h1l1-1c1 0 2-1 8-3zM83 16h-1c-1 0-2 1-2 2h2c1-1 1-2 1-2zM163 16c1 0 1 0 2 1 1 0 2 1 2 1-1 1-3-1-4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M58 16c-2 1-3 2-4 2 0 0 3-2 4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M56 16c1 0 1 0 0 0 0 1-1 1-2 2-1 0-2 1-2 2-1 0-1 1-2 1l3-3c0 1-1 1 0 0 0 0 2-1 3-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M55 17c1-1 0-1-1 0s-1 1-2 1c-7 4-9 7-11 8l-1 1h3s-1 0-1 1h-3c1-1 3-3 6-5 3-3 7-4 7-4h-1c1 0 1-1 2-1 1-1 1-1 2-1zM61 19c1-1 2-2 2-1-2 2-3 3-3 2 0 0 0-1 1-1zM64 18c1-1 2-1 1 0s-2 2-3 2l1-1s0-1 1-1zM150 18s-1 0 3 2c2 1 5 3 9 6 5 3 12 7 20 13h4s1 0 1 1c2 2 4 5 5 8 1 0 2 1 2 2 1 1 1 2 0 2-1-1-2-2-2-3v-1c-2-3-3-5-5-8h-5s-1 0-5-4c-2-1-5-3-9-6s-10-7-17-11c2 2 4 4 5 7h2c0 1 1 2 1 2 0 1-1 1-2 1 0-1-1-2-1-3-3-4-5-6-6-7v-1zM126 19h-2v1s0 1 1 1h1c1-1 0-2 0-2zM53 19v1c-3 2-3 2-2 2h1l2 2h16c0 3 0 5 1 7-1 3-2 5-4 7 0 1 0 1-5 5l-1 1c2 1 0 4-2 4-1 0-1-1 0-2 0-1 1-2 2-2v-2c2-1 4-2 6-4l3-6v-4c-1-1-1-3-1-3H53s-1-1-1-2h-2c0-1 1-2 2-3l1-1zM135 20l2 2s0 1-1 1-2-1-2-2c0 0 0-1 1-1zM101 21c1-1 2 0 2 1s-2 2-2 1c-1-1 0-2 0-2zM109 21c-1 0-2 1-2 2 0 0 0 1 1 1s2-1 2-1c0-1-1-1-1-2zM80 24l2-2c1 0 2 1 1 2l-1 1c-1 1-1 3-1 4-1 1-1 1-2 5h14c0-1 1-1 2-1 2 1 1 3-1 3-1 1-1 0-1-1H78c1-4 2-5 2-6s1-3 1-4c-1 0-1 0-1-1zM164 23c-1-1-1 0-1 1 1 0 2 1 3 2v-2c-1 0-2-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M88 23c1 0 2 0 2 1-1 2-3 3-3 2s0-2 1-3zM46 24c1 0 1 0 1 1-1 0-2 1-2 1-1 1-1 1-2 1 0 0 1 0 1-1l1-1c1 0 1 0 1-1zM109 26c-1-1-2 0-2 1s1 2 1 2c2-1 2-3 1-3zM51 27h17v3c-1 1-1 2-2 3 1 1-1 3-2 3s-1-1 0-2c0 0 1-1 2-1 0-1 1-2 1-3v-2H51c0-1-1 0-1 0l-3 2h-7v-1h7c1 0 0 0 0 0 1 0 4-2 4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M56 29c1-1 1-2 1-2-1 0-1 0-2 1H45c-6 6-11 12-16 19h-8 4l-1 1h-3 8s4-6 7-10c4-5 8-9 8-9h10c-1 2 0 1 2 0zM38 30l2-2s-1 0-2 1h3c-1 0-1 0-1 1h-3l-1 1s1 0 2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M50 29h13s0 1 1 1c0 1 0 0-2 3 1 0 1 1 0 1 0 1-1 2-2 2s-1-1 0-2c0 0 1-1 2-1 0-1 1-1 1-2-1-1-1-2-1-2-8 1-11 1-12 1h-1c-1 1-3 1-4 2h-8c1 0 1 0 1-1h8c2-1 3-1 4-2zM160 30c7 12 11 22 14 29 2 8 3 13 4 16 2 7 1 6 2 7h7c1 2 2 2 3 1 0-1 0-3-1-4h-2v2h-7s-3-15-8-28c-2-6-5-12-7-16-3-5-5-7-5-7zM108 31c0-1-1 0-2 1 0 1 0 2 1 2s2-1 2-2c0 0 0-1-1-1zM104 31c-1-1-2 0-3 1 0 1 0 2 1 2s2-1 2-2v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M159 33c0-1 0-2 1-2s3 2 2 3c0 1 2 4 3 6 8 5 15 10 23 15 1 1 0 0 3 0h4v-1c1 0 2 0 2 1 1 2 1 3 1 3-1 0-2-1-2-1-1-1-7-1-8-1s-22-15-23-15c-1-2-3-5-4-7 0 0-1-1-2-1zM48 31h11c0 1-1 1-1 2 0 0 0 1-1 2s-2 2-2 1c0 0 0-1 1-2 0-1 1-1 1-1 1 0 1-1 1-1H48c-1 0-3 1-4 2l-1 1h-8c0-1 1-1 1-1h8c1-1 3-2 4-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M52 33c1 0 1-1 0-1 0 0-1 1-2 1h-9c-3 4-11 15-12 17h-9s-1 0 0 0h3s0 1-1 1h-3 10c1-2 1-3 3-5 1-2 3-5 9-12h9c-1 1-1 2 0 1 1 0 2-1 2-2zM33 33c2-1 0 0-2 2-1 1-2 3-3 4h3l-1 1h-3s0-1 1-1l3-3c-1 1 1-2 2-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M32 34c2-1 2-2 0 0h3v1h-4l1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m34 33-1 1c-1 0-1 1-1 1l-8 8h4l-1 1h-4l8-8c0 1 2-1 3-3zM99 33c2 0 3 2 1 3-1 1-1 1-2 0s0-3 1-3zM192 35c0-1 0 0 1 1 0 1 2 2 2 2s0-1-1-2c-1 0-1-1-2-1zM126 38h1c1 0 10 5 18 9 9 5 18 10 21 12 15 8 14 8 14 8 0 2 1 4 1 6 3 1 3 4 1 4s-3-3-2-4c0-2-1-4-1-6-2-1-14-8-27-15-12-7-24-13-26-14zM49 38c-1-1-2 0-3 1s-1 2 0 2 2-1 2-2c1 0 1-1 1-1zM193 39v-1s0 1 1 2l2 2c-1 0-3-2-3-3zM54 39c1-1 1 0 0 1 0 1-2 2-2 2-1 0-1-1 0-1 0-1 1-2 2-2zM64 39c-1-1-2 1-3 2 0 1 1 1 1 1h1c1-1 2-2 2-3h-1zM60 39c0-1-2 0-2 1-1 1-1 2 0 2 0 0 1 0 2-1 0-1 1-2 0-2zM40 39c-1 0-1 0-2 1s-2 2-2 3c-2 3-4 6-5 10H18h3v1h-4 13c2-4 5-8 7-11 1-1 3-3 3-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M42 41c1-1 1-2 0-2-1 1-3 3-3 4-2 4-5 8-7 13H16h4c-1 0-1 0-1 1h-4 17c2-5 5-10 8-14 1 0 1-1 2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M31 40h12v1c0 1-1 4 0 10h4c0-1 1-2 1-3-1-1 1-4 3-3v2c-1 0-1 1-2 1-1 1-1 2-2 4h-5V40H30h1zM200 40c-1 0 0 1 1 2l2 2-2-2c0-1-1-1-1-2zM197 41c0-1 0 0 1 1 0 1 2 2 2 2s0-1-1-2c0 0-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M28 43h13c-1 3-1 7 0 10 0 1 0 0 0 0h21c1 0 3-1 4-2h48v12c-1 2-2 3-2 5v1c0 1 0 2-1 2-1 1-2 0-2 0-1-1-1-2-1-2 1-1 2-2 3-2 0-1 1-2 1-3 1 0 1-1 1-1V52H66c-4 3-4 2-5 2H40V44l-2-1c-1 0-2 0-4 1h-6v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M26 45h13v1c-1 2 0 5 0 7-1 1-1 2-1 3v2c-1 1-2 2-3 2v-2c1-1 1-2 2-2 0-1 1-2 1-2v-8H25c1 0 1 0 1-1zM201 49c-1-1-1-2 0-1 1 0 2 1 2 2v1c-1 0-1-1-1-1h-2c3 5 6 11 9 18 1 1 2 4 1 4 0 0-1-1-1-2-1-1-1-2 0-2-3-7-6-13-10-19h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M24 48h12v5l-1 1c-1 2-2 4-2 6v3h9s-1 0 6-6h12c1 0 0 1 5-3 0-1 0-1 2-1h43c1 0 1 1 1 1v9s0 1-1 1h-4v5c-1 0-3 2-6 3-2 1 0 0-11 1-1-1-1 0 0-4-1 0-2-1-2-2 0-2 3-4 4-1 1 1 0 2-1 3 0 1-1 2-1 2h10s3-2 6-3c0-4 0-5 1-5h4v-9H65c-1 1-2 3-4 4H47c-6 6-5 6-6 6h-8c-1 0-1-1-1-1v-3l3-6v-5H24v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M32 53c0-1 1-1 1-1 1-1 1 0 1 1-1 1-2 3-3 3v-2h-1l-5 5h-5c0-2 1-3 1-5h-1c1 0 1-1 1-1h1c-1 2-1 3-1 4s-1 1 0 1h4l5-5h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M25 52c0-1 0 1-1 2 0 1-1 2-2 2 0 0 1-2 1-3 1 0 1-1 2-1zM27 52c1-1 1 1 0 2l-2 2s0-2 1-3l1-1zM98 57c2-2 4 0 4 1s-1 2-2 2c-1 1-2 0-2-1H72c0 2-1 4-1 6H48s0 1-1 1c-2 1-3 2-5 4H25c-2-3-1-2-2-2h-9v-1h10c2 2 2 2 3 2h15s0-1 1-1c1-1 3-2 5-3 0-1 0-1 2-1h20c0-2 1-4 1-6h27v-1zM105 56c2 0 3 1 3 2 0 2-1 3-3 3 0-1-1-1-1-3 0-1 1-1 1-2zM28 60l2-2c1 0 1 1 0 3s-3 2-2 0c-1 0-1-1-2 0-1 0-2 1-2 1h-6v-2h-1l1-1c0 1 1 1 1 2h5c1 0 0 0 3-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M38 58H14h4v1h-4 23c-1 3-3 7-4 10-2 1-2 6 0 4 1-1 2-2 1-3v-1c1-4 2-7 4-11z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m65 60 2-2c1 0 2 2 2 3-1 2-4 3-4 0H47c-2 2-3 4-5 5H27c-1 0-1-1-2-1H15v-1h11c1 1 0 1 2 1h14c1-1 3-3 5-4 0-1 0-1 2-1h16z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M73 60h17l3 3 1 1h3c1-1 2-1 3-1s1 1 1 2-1 2-2 2-2-1-2-2h-4l-3-3c-2 0-15-1-16 0-1 2-1 5-1 7H48c-1 1-6 4-6 5H24c-1-1-1-2-2-3 0-1-1-1-1-1h-9c1 0 1 0 1-1h9c1 0 1 1 1 1 1 1 1 2 2 3h8c4 0 8 0 9-1 2-1 4-2 6-4h24c0-2 1-5 1-8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M33 61H13h4c-1 0-1 1-1 1h-4 20c-1 2-2 4-3 7h-1c-1 3 0 5 1 4s1-2 1-3v-1c1-3 2-5 3-8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M23 64H12s-2 2-3 5l-2 4c0 1 2 0 4 0v1H7c1-2 3-6 4-9h11c0 1 0 3 1 5v4c-1 5-3 9-3 14-2 1-2 4-1 5 0 0 1-1 1-2 1-1 1-2 0-3 1-5 2-10 4-14 0-1-1-4-1-6v-4zM46 65c0-1-2 0-2 1-1 1-1 3 0 3s2-1 2-2c1-1 1-2 0-2zM77 65c1-1 2 0 2 1 0 2-1 3-2 3s-2-1-2-2 1-2 2-2zM83 65c1-1 2 0 2 1s-1 3-2 3-2-1-2-2 1-2 2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M21 67H11c-1 0-1 1-2 2-1 2-2 5-3 7h4v1H6v1-1s1-2 2-5l2-4h10v6c-2 5-3 9-4 14-1 1-2 5-1 5s3-4 2-5c1-5 2-10 3-14v-4c0-1 1-3 1-3zM119 71c0-3 3-3 4-1h16c1 0 1 0 1 1 1 7 1 15 2 23h4c0-1 0-1 1-2 1 0 2 0 3 1v2c0 2-2 2-3 1l-1-1h-5c0-2-2-21-2-24h-16v1c0 1-2 2-3 1s-1-2-1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M129 70c-1 0-3 1-2 2 0 2 1 3 2 2 2 0 2-2 2-3-1-1-1-1-2-1zM17 70H9c0 1-3 7-4 9v1h4v1H5v-1s1-2 2-5l2-4h7l1 3c-2 5-3 9-4 14-1 1-2 4-1 5 1 0 2-3 2-4s0-1-1-1c1-5 3-10 4-14v-4zM217 73c0-2 1-1 2 2 0 1 0 2-1 1 0-1-1-2-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M11 74h10c1 0 2 1 3 1h79c1-1 1-1 2-1s2 0 2 2c1 1 0 2-1 2-1 1-3 0-3-1s-6-1-15-1H23c-1 0-2-1-3-1h-9v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M12 76c0-2 0-3-1-2 0 0-1 2-1 3-2 2-3 4-4 7H4h4v1H4h1c2-2 3-5 5-7 0 1 1 0 2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M10 74c0-1-1 0-1 1s-1 2-1 3 1 1 1-1c1-1 1-2 1-3zM10 78h20c2 6 5 11 8 17h39s0-1 3 3 11 13 27 30h18s1 0 1 1v4c2 1 1 4 0 4-2 1-3-1-3-2s1-2 2-2v-4c-6 1-12 0-18 0 0 1 0 1-3-3l-10-10c-4-4-10-11-17-20H38c-1 0 0 0-2-2-1-1-3-5-6-14 0 0 0-1-1-1H10v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M9 81h12l2 2h2c2-3 3-1 3 1 0 1-1 2-2 2l-1-1h-3c-1-2-1-3-2-3H9v-1zM103 83c0-1 1-2 2-2s2 1 2 2v1c-1 2-3 2-4 0H84c0 3-1 7-1 11 1 0 15 16 25 27h20c2-2 3-4 5-5h37c2 1 3 3 4 5 1-1 1-1 2-1 1 1 1 1 1 2s0 3-1 3-2 0-2-2v-1c-1-2-3-4-4-5h-36c-2 1-4 3-5 5h-21c-7-7-14-14-20-21l-6-7c0-4 1-8 1-12h20z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M17 83h1c1 0 1 1 1 2-1 1-1 2-2 2 0 1-1 0-1-1H8v-1h9v-2zM43 87c1-1 2 0 2 2 0 1-1 3-2 2-1 1-2-1-2-2s1-2 2-2zM48 87c1 0 2 0 2 1 1 2-1 4-2 3-1 1-1 0-1-2 0-1 0-2 1-2zM54 87c1-1 2 1 2 2s-1 3-2 2c-1 0-2-1-2-2 1-1 1-2 2-2zM5 90v-3H3h4v1H3h1c1 1 1 1 1 3 0 3 0 3 1 1s1-4 0-3c0 0 0 1-1 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M48 88c-1 1-1 2 0 3 1 2 3 0 3-3-1-2-2-1-3 0zM45 87c-1 0-2 0-3 2 0 1 0 3 1 3s2-1 2-3c1-1 0-1 0-2zM103 89c1-1 2-1 3 0 1 0 1 2 1 3-1 1-1 1-2 1v14c1 0 3 2 4 4h17v4c1 0 1 1 1 1 1 2 0 3-1 4-1 0-3-1-3-3 0-1 1-2 2-2v-3h-16c-2-1-3-3-5-5V93l-1-1v-3zM7 89h22l1 1s1 3 2 5c2 3 3 6 4 6h41c0 1 7 9 14 17l16 16h9c0-1 1-1 2-1s3 1 2 2c0 3-3 4-4 1h-10c0-1-8-9-15-17-8-8-15-16-15-16H39c-4 0-4-1-4-1-2-4-4-8-6-11 0-1-1-1-3-1H7v-1zM4 91H2h5s-1 0-1 1H2h2v9s1-1 1-2c0-2 0-3-1-2v-6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M6 92h19c1 0 1 1 2 1 2 5 5 10 8 16h34c1-3 5-2 5 0s-2 3-3 3-1-1-2-2H35v-1c-4-5-7-10-9-15H6v-2zM182 95c0-2-1-3-2-2-1 0-2 3 1 4v4h-43s-10 11-20 21c-11 11-20 22-20 22H43c0 2 0 4 1 6h6c1 4 2 7 3 10h-5c5 15 8 21 10 24 1 3 1 3 2 4H45c3 4 6 8 10 12h-4l-5-5h-5c4 3 7 7 11 10h-2c5 4 10 7 16 10h-2l6 3c1 0 2 1 5 2 4 1 8 3 13 4h2-1c-1 0-4-1-7-2s-6-2-7-2c-4-1-2-1-5-2-2-1-3-2-5-3h2l-8-4-8-6h2c-3-3-7-6-10-10h3c2 2 3 4 5 5h5c-4-3-7-7-10-11h15c-3-6-6-13-8-18-2-6-4-10-4-10h5l-3-12h-7v-4h54s9-10 19-20c10-11 20-22 21-23h44c0-2 0-3-1-5h1s1-1 0-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M177 94c-1-2-3-2-4 0h-35c-2 2-12 14-22 24-10 11-19 21-19 21v1s9-10 19-20c10-11 20-22 22-24h35c1 1 1 1 2 1s2-1 2-3zM3 95v-1H2h4v1H1h1c1 0 1 0 1 1 0 4 0 8 1 12h5v2c1 1 2-1 2-3 0-3-2-2-2 0H4c0-2-1-8-1-12z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M2 98H1h4v1H1h1v13h37c1 3 3 2 3 0v-1c0-2-2-2-3 0H3s-1-5-1-13z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M5 99h18c1 0 3 5 5 9 3 4 5 8 5 8 1 0 1 1 1 1h47c1 1 10 11 26 27h27c1-6 1-13 1-20 0-1 0-1 1-1h30c1-3 4-2 4 0s-1 3-2 3-2-1-2-2h-30c0 7 0 14-1 21v1h-29c0-1 1 0-2-3-4-4-10-10-24-25H37c-4 0-4 0-4-1 0 0-3-4-5-8-3-4-5-8-5-9H5v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M154 100c0-1 2-1 3 0 0 0 1 1 1 2-1 1-1 2-2 2v3h17c1 1 4 5 7 9s5 7 5 7c-1 22-5 32-6 37-1 4-1 3-1 3 0 1-1 1-1 1h-4c-1 0-1 1-2 1-1 1-2 0-2-1s1-3 2-3 2 0 2 1v1h4c4-12 6-25 7-38v-2c-1-1-2-3-7-9 0-1-4-5-4-6h-18v-4h-1c-1-1-1-3 0-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M160 101c0-1 1-2 2-2s1 1 2 1c1 4-3 6-4 2v-1zM146 102c0-1 1-3 3-2 1 0 2 1 2 3-1 0-1 1-1 1s-1 0-1 1v6h22c1 0 1 0 5 5l5 7c0 2 0 7-1 12 0 5-1 10-1 10l-9 9h-68s-21-22-23-24H32c-3-4-6-8-8-12H4v-1h20l1 1c1 2 2 5 7 11h47c1 0 24 24 24 24h67c8-8 8-8 8-9 1-6 2-13 2-20 0-1-8-10-9-12h-23v-8c-1 0-2-1-2-2zM77 102c-1-1-2 0-3 1-1 2 0 3 2 4 2 0 3-4 1-5zM7 105c0-3 1-3 1-1 1 3 0 4-1 3v-1H5v-1h2zM13 103c1-1 2 0 2 2 0 1-1 3-1 3-1 0-1-1-1-3v-2zM1 103v2c-1 1-1 3-1 2 1 1 1-1 1-2v-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M0 105c0-2 1-3 0-2v5h2c1 2 1 4 1 6 1-1 1 0 1-1v2H3c0-1-1-5-1-5H0v-5zM163 108c0-2-3-3-4 0h-18s0 19-1 36c-1 9-2 17-3 23 0 6-1 10-1 10h-13c-1 3-1 8-2 14v9c-1 3-1 6-2 8 0 3 0 5-1 7 0 2-1 4-1 5s-1 2-1 3v1s-1 1-2 1c0 1-1 1-1 1v1-1s1 0 1-1c1 0 1-1 2-1 0-1 1-1 1-2s1-3 1-4c0-2 1-4 1-6 1-2 1-4 1-7 1-3 1-5 2-8v-8c1-5 1-9 1-11h14c0-3 1-8 2-13 0-6 1-13 2-20 1-15 1-29 1-36h17c0 1 1 2 2 2s2-1 2-3zM77 110c-2-2-4 1-3 3 0 1 1 1 1 1v7h5c1 2 2 3 4 2v-1c1-1 0-3-1-4-1 0-2 1-3 2h-4v-6c1 0 1 0 2-1 0-1 0-3-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M0 112c0-2 0-3 0 0h2c0 1 1 3 1 4s0 1 1 1v1H3c0-2-1-4-1-5H0v1-2zM83 111c-1-1-3 0-3 2 0 1 1 2 2 2 2 0 3-1 3-2s-1-2-2-2zM4 111h21c0 1 2 4 4 6l4 6h47c1 0 0 0 9 9 5 6 11 11 16 17h32c1-6 1-12 1-18h35c1-3 3-2 4-1 0 2-1 3-2 4-1 0-2-1-2-2h-34c-1 19-1 18-1 18h-33c-5-6-25-25-25-26H32c-2-4-5-8-7-12H4v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M1 115c0-1 0-1 1 0v5h3v2H2v-3c-1 1-1-2-1-4zM168 115h-23s-1 0 0 1c-1 6-1 21-2 35-1 7-2 13-3 19 0 5-1 9-2 12h-12c-1 5-1 10-2 15-1 4-1 8-2 12s-2 7-3 9c-1 3-1 5-3 6 0 0-1 1-1 2h-1c-1 0-1 1-1 1s1 0 1-1h1c0-1 1-1 2-2 0 0 1-1 2-3 0-1 1-3 1-5 1-2 2-4 2-7 1-2 2-5 2-8 1-3 1-6 1-9 1-5 2-9 2-9h11c1 0 1-1 1-1 1-4 2-9 3-16 1-6 2-14 2-21 2-16 2-29 2-29h21v2c-2 1-2 5 0 5 1 0 2 0 2-1 1-1 0-2 0-2 0-1 0-1-1-2v-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M0 116v-1 3c1 2 1 4 2 6h3v2H2v-1c-1-2-1-4-2-6v-3zM117 115c2-1 3 0 4 2 0 1-1 2-2 3-1 0-2-1-3-2 0-1 0-3 1-3zM193 117c1-1 2-1 3 0 0 1 0 2-1 3v1c-1 10-2 20-5 30-1 2-3 4-5 6-4 13-9 25-16 35 0 1 0 1-1 1-3 3-3 3-4 3h-16c-9 7-13 10-15 11l-1 1c0 1-1 3-3 6s-4 6-6 8-5 4-7 4c-1 1-3 1-3 1s2 0 3-1c2 0 5-2 7-4l6-9c1-3 2-5 2-5 4-3 7-5 10-7 2-2 4-3 5-4l2-2h17l3-2c2-3 6-10 10-18s6-17 7-19c0 0 4-5 5-5 2-10 3-20 4-30v-1c-1 0-1-2-1-3zM36 118c-1 0-2 1-2 2s1 3 2 3 1-1 1-2c1-1 0-3-1-3zM43 120c0-1-1-2-2-2-2 0-2 4 0 5 0 4 0 6 1 12h49c0-2 0-5-1-7 1 0 0 0 0 0h-5c0-1-1-1-1-2-1 0-2 0-3 1s-1 2 1 3c0 1 1 1 2 0l1-1h4c0 2 1 3 1 5H42v-11c0-1 1-2 1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M32 118c-1 0-2 0-2 1-1 0-1 0-1 1H0c0 1 0 3 1 5 0 6 1 13 3 19v-7h3v1H4c0 5 1 7 1 7-1-1-2-6-3-10-1-5-1-9-1-10v-4h28l2 2c1 0 2-3 1-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M5 119h18v1l9 12h45s4 4 4 5c1 3 1 5 1 8 1 0 1 1 1 1 1 1 1 4-1 4-3-1-3-4-1-5v-7l-1-1c-1-1-2-3-3-4H31c-3-4-6-8-8-13H5v-1zM161 120h-12s-1 18-3 35c-1 8-2 16-3 22-1 5-2 9-2 9h-12c-1 1-1 2-1 2-1 5-1 9-2 13s-2 7-3 11c-1 3-2 5-3 7-1 3-2 4-3 6-1 0-2 1-2 1h-1c0 1-1 1-1 1s1 0 1-1h1c1-1 2-1 2-1s1-1 2-3c1-1 2-3 3-4 0-2 1-4 2-7 1-2 1-5 2-8 1-2 1-5 2-8 1-5 1-8 1-8h12v-1s1-3 2-8c2-6 3-14 4-22 2-17 3-35 3-35h10v5c-2 1-2 5 1 5 2 0 3-4 0-5v-6zM1 125c-1-2-1-3-1-2 0 0 1 1 1 2s1 2 1 3h3v1H2c0-1-1-2-1-3v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M5 123h17c6 10 7 10 9 12 0 0 0 1 1 1h42c1 0 1 0 1 1 0 2 0 5 1 8 2 1 2 4 0 5-1 0-2-1-3-2 0-1 0-1 1-2 0 0 0-1 1-1-1-3-1-7-1-8H31c-3-4-6-8-9-13H5v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M28 124H1v4c1 6 2 13 4 20v-8h2l1 1H5c0 2 0 5 1 7v1c-2-7-4-14-5-21v-3h27s3 4 3 5h4c0 1 1 2 2 1 1 0 1-1 1-3-1-2-3-2-3 0-4 0-3 1-4 0s-2-2-3-4zM168 126c-1 0-2 0-3 2 0 1 1 3 2 3s2-1 2-3c0-1 0-2-1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M5 127h16l2 2c1 2 4 6 13 15h13l1 1c0 5 1 10 3 15h43s8 6 15 13c4 3 7 6 10 8 2 2 3 3 3 4h10c0-3 1-5 1-8 0-1 1-1 1-1h14v1l-3 9c1 1 1 2 0 3s-2 1-2 0c-1 0 0-1 0-2l1-1 3-9h-13c0 3-1 6-1 8 0 1-1 1-1 1h-10l-4-4c-2-2-6-5-9-8-7-7-15-13-15-13H52l-3-15H37c-2 0-1-1-2-1-5-5-10-11-14-17H5v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M27 129c-1-1-2-1-2 0v1h-4l3 15 6 8 7 7c1 5 3 9 5 14-1 0 1 3 2 3 1 1 1 0 1 0 0-1 0-2-1-2 0-1-1-1-1-1-1-2-5-11-6-14-5-6-11-14-13-15-1-5-2-10-2-14h3c0 1 0 1 1 2s2 0 1-3v-1zM2 132c-1-2-1-3 0 0 0-1 0-2 1-2h3v1H3s-1 1-1 2v2-3zM131 133c0-1-1-1-2 0 0 1-1 2 0 3 0 1 1 1 2 1 2-1 2-4 0-4zM126 136c0-2 0-3-2-4-2 0-4 3-2 5 2 1 3 0 4-1zM20 133c0-1 1 0 1 1 1 2 0 4-1 3l-1-1c0-1-1 0-1-1-1 2-1 3-1 4H7v-2h9c1 0 1-2 1-3h2s0-1 1-1zM168 134c0-1-1-1-2 0-1 0-1 1-1 1h-7v1c-1 3-1 14-4 27-1 7-3 14-5 21s-5 13-8 19c-3 5-6 10-9 14-3 3-6 6-9 7-5 3-9 3-10 3 2 0 7-1 13-5 3-2 6-5 9-9 4-4 7-10 9-16 3-6 6-13 7-20 2-7 4-14 5-20 2-12 2-21 2-21h7v2c1 1 2 0 3-1s1-2 0-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M3 134h3v1H3v5c0 1 1 2 1 2 0 1 0 0-1-2v-2 1-5zM174 137c2-1 3 2 1 3-1 1-2 1-3 0 0-1 1-3 2-3zM32 137c-1-1-2 0-2 2 0 1 1 2 2 2s2-1 1-3l-1-1zM27 137c-1 0-1 1-1 2s1 2 2 2l1-1c0-1-1-4-2-3zM202 139c1-1 2-2 2-1 1 0 1 3-1 4h-1c-4 6-9 11-14 16v1c-4 13-10 25-18 36-2 1-5 3-7 5h-16c-5 3-10 7-14 10l-2 3c-1 2-2 4-5 7s-7 7-13 7c0 0 2 0 4-1 1 0 4-2 6-4 3-2 5-5 7-8s3-5 3-5l6-4c3-2 6-5 7-6h17c2-2 5-3 7-5 1-2 7-9 11-18s6-18 6-18h1c0-1 4-4 7-8 3-3 6-7 7-9v-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M206 140c1-2 2-3 2-2l1 1c0 2-2 4-3 3 0 1-3 5-7 9-3 4-6 7-6 7 0 1-1 1-1 1s-6 20-19 36c-6 8-13 14-19 18s-11 7-12 7c-3 2-3 2-4 2-6 2-12 4-18 4l-7 1c2 0 4 0 6-1h1c6 0 12-2 18-4 1 0 2-1 3-1 0-1 0 0 2-1s6-3 14-9l5-5c3-2 5-4 5-5 9-9 13-17 17-23 3-7 5-11 6-14l2-6c5-5 10-11 14-17v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M211 138h1c0 1 0 2-1 3 0 1 0 1-1 1-1 7-3 14-6 20h-7c-1 3-10 25-27 41-8 8-18 14-27 18-9 3-16 5-20 5-3 0-6 1-10 1 3 0 6-1 9-1h2c2 0 8-1 19-5l10-5c6-4 13-9 20-16s13-16 17-23c4-8 6-14 7-15v-1h7c2-6 4-12 6-19v-3c0-1 1-1 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M217 140c0-1 1-2 1-1v2c0 1-1 2-1 2-4 15-10 26-16 35-5 9-11 15-15 19-10 9-15 12-15 12-6 4-11 6-17 9-1 0-8 4-17 6s-20 3-24 3c14 0 28-3 41-9 1-1 6-3 9-5l8-4c0-1 5-3 10-8 6-5 13-13 19-21s10-18 13-25c2-7 4-12 4-12s-1 0-1-1 1-1 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M220 139v1c0 1-1 2-1 3-7 27-25 51-48 66 0 1-4 3-9 5-4 2-8 4-9 4-12 6-26 9-40 9 14 0 28-3 40-9 1 0 5-2 9-4s9-4 9-5c1 0 5-3 11-7 6-5 13-13 19-21s10-17 13-25c3-7 5-12 5-13v-1c0-1 0-3 1-3zM17 139H3l2 6c1 3 2 6 2 7-1-4-1-6-1-7v-1h3v1H6v1c0 2 1 6 1 7h1c-2-4-3-9-4-13h13c1 7 2 10 3 11v1H10v-2c-1-1-2 0-1 3 2 2 2 2 1 0h11c0-1-2-5-2-8l-2-6zM97 139H37c1 2 2 12 5 22 3 9 8 18 8 20H22l-6-9h2l3 3h1c0 1 0 1 1 1h-1l-3-3h-2l6 9h29c-7-13-11-27-14-42h59v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M20 142c0-3 2-2 3 0 0 1 0 3-1 3 0 0-1-1-1-2H8v-1h12zM174 143v-1h-14s-1 9-3 22c-2 6-3 13-6 20-2 7-5 13-8 19s-7 10-10 14c-3 3-7 6-10 7-5 3-10 3-10 3 1 0 6 0 11-3 3-2 7-4 10-7 3-4 6-8 9-14 3-5 6-11 8-17 3-7 5-13 6-19 3-13 4-22 4-24h12c0 2 0 3-1 5 0 0-1 1-1 2-1 1 0 2 1 2 2 0 3-3 1-4 1-2 1-4 1-5zM7 143c0-1-1 0 0 1H5c1 4 3 8 4 12H8c-1-5-1-7-1-8h2c1 0 1 0 1 1H7c0 1 0 3 2 8h1c-2-4-3-8-4-12h1c0 1 1 2 1 2v-1c0-1 0-3-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M14 144s1 2 1 3c0 0 1 1 1 0 0 0 1 0 0-1 0-3-2-4-2-2zM13 143c-1 0-1 0-1 1v3h1c1 1 1 0 1-1s-1-2-1-3zM143 144c2 0 3 1 3 2 0 2-1 3-2 3s-2-1-2-2 0-2 1-3zM86 146c1-1 2-1 3-1 1 1 2 3 1 4s-2 1-3 0-1-2-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M9 147h10s1 2 2 3h1v-2c0-1 1-1 2 0 1 2 1 3 1 4-1 0-2 0-2-1h-2c-1-1-2-2-2-3H9v-1zM45 149c0-1 0-2 2-2 1 1 1 3 1 4-1 1-2 1-3-1h-8s-1 0-1 1c-1 0-3 2-4 3-2 2-3 3-4 3 0 1 0 1-2 1H13v-1h13c2 0 2-1 2-1 4-4 6-5 7-6s1-1 2-1h8zM168 148c-2-1-3 0-3 2 0 1 1 2 2 2s2-2 2-3l-1-1zM8 151h2c1 0 1 1 1 1H8v1c1 1 1 3 2 7h2c1 0 1 1 1 1 1 1 0-2-1-3 0-1-1-1-1-1 0 1 1 1 1 2H9h1l-1-1c0-1-1-3-1-7zM108 152c-1-1-3-1-4 0v1h-7c0 7 1 14 1 20 1 6 2 12 2 18H82c0 1 1 4 2 7 2 3 3 6 5 10 2 3 4 5 5 7l3 3h-4l3 3c1 1 5 3 8 4 4 1 8 2 9 2-6 0-13-3-19-9h3s0 1-1-2c-1-1-3-3-5-6-2-4-5-10-8-18h18v-6c-1-3-1-8-2-12-1-10-1-20-1-20h6l1 1c1 1 2 0 3-1v-2zM219 152c0 1 0 2-1 3v1-1c-1 1-3 3-3 4 0 0-7 15-18 28s-25 22-25 23c-1 0-5 2-9 4-5 3-10 5-10 5-1 0-11 4-20 6-10 2-20 2-20 2 8 0 18-2 26-4s13-4 14-4c2-1 13-6 19-10 0 0 6-3 15-11 8-8 20-21 28-40 0-1 2-2 3-4 1-3 2-3 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M74 154c1-2 2-2 3-1 1 0 1 1 2 1h18c6 5 12 10 17 15h54c0-1 2-2 3-1 0 1 0 3-1 4h-2c-1-1-1-1-1-2h-53c-7-6-17-14-17-15H78c0 1-1 2-2 2s-2-2-2-3zM50 153c-1-1-3-1-3 1h-3c1 4 3 12 6 18 2 7 5 12 5 13H30c6 7 9 10 11 12l1 1h-1c4 4 9 8 14 11h-1c-1 0-3-1-3-1h3-2s-1 0 3 2h1c-5-3-10-7-14-11h1c-4-4-8-9-12-13h26c-2-3-5-9-7-15-3-6-4-13-5-16h2l2 2c1 0 1 0 1-1 1-1 1-2 0-3zM10 154v-1h1l1 1h-1v1c1 2 1 3 0 2s-1-3-1-4c-1 0 0 0 0 1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M46 156c1-2 3-2 4 0 0 3-1 3-3 2 0 0 0-1-1-1h-5c0 2-1 10 0 16 1 7 3 12 3 13H29v-1h14c-3-8-4-17-3-25v-4h6zM218 156c0-1-1-1-1 0s-1 1-1 2v2c-2 4-6 11-11 19-5 7-12 15-20 21-15 13-32 19-33 20l-7 2c-2 0-4 1-7 2h-1s-4 1-9 2c-5 0-11 1-15 1 8 0 16-1 23-3h2s2-1 6-2c1 0 4-1 7-2 1 0 0 0 5-2 2-1 5-2 10-5 5-2 12-6 20-14 4-3 12-11 19-20 6-9 10-18 11-19 0 0 0-1 1-2 0-1 0-2 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M216 156c0-1 0 0 0 0s-1 1-1 2c0 0-1 1-1 2s-3 7-7 14c-5 7-11 16-19 23s-17 13-24 17-12 5-12 5c-1 1-2 1-4 2-4 1-10 3-11 3h-3c-2 1-8 3-21 3 1 0 6 0 12-1s11-2 12-2c0 0 5-1 10-3h1c1 0 2-1 3-1s0 0 5-2c3-1 7-3 13-7 7-4 15-9 24-19 4-4 10-11 14-18 5-8 8-14 8-14v-1c1-1 1-2 1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M186 157c0-1-1-2-2-1-1 0-2 1-2 2s1 2 1 2c-2 6-4 12-7 17v1c-3 3-5 6-7 8-1 1-4 6-8 13-5 6-11 13-19 18l-4 2c-5 3-7 3-8 4h-2c-3 2-5 2-6 3h-1c-3 0-5 1-8 1 2 0 5-1 7-1h1c3-1 5-2 8-3 1 0 3-1 6-2s6-3 7-4c8-5 14-11 17-16 4-4 6-8 8-10l2-5c3-2 5-5 7-8 1 0 1 0 2-2s3-6 6-16c1-1 1-2 2-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M181 157c0-1-1-2-2-2-1 1-1 2-2 3-2 1-5 3-7 4-1 0-1 1-1 1s-1 4-3 11c-2 6-6 14-10 21-3 6-8 12-11 16-4 4-6 6-7 6l-6 3c-6 4-12 7-19 7 5 0 9-2 11-3 3-1 5-2 6-3l2-1c2-1 4-2 6-2 0-1 0-1 1-1l6-6c3-3 8-9 12-16s7-15 9-21c3-7 4-11 4-11l7-4c1 2 4 0 4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M216 160c0-1 0-2 1-2 0 0-1 1-1 2-1 3-2 4-1 1-2 3-4 7-5 10-1 0-1 0-1 1 0 0-1 2-3 5-1 2-3 5-3 5s-4 6-11 13-18 15-29 20c-12 6-24 9-34 11-9 1-16 1-16 1 1 0 7 0 16-1 8-2 19-4 30-9s21-12 29-18c7-7 12-14 15-17 2-3 4-7 6-10 0-1 1-2 1-3 2-3 4-6 5-9h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M216 161c1-2 1-3 1-3s0 1-1 2h1s-1 0-1 1c-1 2-2 5-4 8 0 0 0 1-1 1 0 1-2 4-3 5-1 3-6 10-14 18s-19 16-31 22-24 9-34 11c-9 1-16 1-16 1 2 0 9 0 19-2 11-2 24-6 36-12 11-7 22-15 29-23s11-14 12-16c1-1 2-3 3-5s3-5 4-8c-1 3-1 2 0 0zM13 162c-1-2-1-3 1 0h1v1h-1l1 1c-1 0-1-1-2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M198 162c1-1 0-2-1-1-1 0-1 2-1 3-1 1-13 13-15 14-3 6-5 11-11 18-3 4-7 8-13 13-5 5-13 10-23 14-1 0-1 0-2 1-4 1-12 3-19 3 0 0 5 0 9-1l10-2c16-5 26-14 33-22 7-7 10-13 13-16 2-4 3-6 3-7 2-2 15-14 15-14 1 0 2-2 2-3zM30 162c-1-2-2-2-2 0 1 2 1 2 2 3l6 12H20c-2-2-4-5-5-7h4v1h-3c1 2 3 5 4 7h17s-2-3-3-6c-2-4-3-7-3-7 0-1 0-2-1-3zM115 164c0-1 0-3 1-3s3 0 3 2-2 3-3 2c-1 0-1-1-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M128 162c0-1 1 0-16-1h-2l-1 1s1 8 1 15v16h-1c0-1-1-2-2-2s-2 1-1 2c0 2 2 3 3 1h2v-10c0-4 0-9-1-16v-6c18 1 17 0 18 1s2 3 3 5c-1 1-2 2-1 3s2 1 3 0 1-3-1-3c-1-2-2-4-4-6zM12 163c-1-1 0 1 1 2 0 1 1 2 1 2 0-1-2-4-2-4zM208 164c0 1-1 2-1 3-1 1 0 1 0 1l-1 5c-1 1-2 3-3 5-3 2-4 3-5 4l-1 1c-4 6-13 16-23 23-10 8-21 13-27 15-1 0-3 1-4 1s-1 0 0 0 3-1 4-1c4-2 18-7 29-16s20-20 21-22c1 0 5-4 6-5 1-2 2-3 3-5 0 0 0-1 1-1 0-1 0-2 1-5 1-2 1-4 0-3zM81 164H66c-2 2-3 5-4 7 3 9 6 18 11 25h-8c0 1-1 6 1 10s5 8 6 9l1 1h-2c1 1 3 2 5 3h-3c1 0 3 1 4 1 0 1 4 2 9 3 5 2 10 2 11 2l2 1c2 0 6 1 14 1-5 0-10-1-15-1l-1-1s-5 0-10-1c-4-2-9-3-9-3-1-1-3-1-4-2h3s-5-2-5-3h2s-2-1-3-3c-1-1-2-3-2-3-4-6-4-10-4-12 0-1 0-1 1-1h8c-5-8-8-16-11-26l3-6h15c0 4 1 7 2 11h5c0 1 1 2 2 2 1-1 2-2 1-3 0 0 0-1-1-1 0-1-1 0-2 0v1h-5c0-4-1-7-2-11z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M125 168c-1-1-1-3-2-4h-9s-1 0-1 1v30c0 1-1 2-1 3h-3c-1-2-2-2-3 0 0 0 0 1 1 2h2v-1c3 0 3 0 3-1 1 0 1-1 2-2v-31h9l1 3v2c0 1 1 2 2 2s2-2 1-3c0-1-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M43 165h53c1 0 0-1 12 9 4 4 8 7 11 10s5 4 5 5h8c0-1 1-1 1-1 2-1 2 0 2 1 0 2-3 3-3 1h-8l-3-3c-1-1-3-3-7-6-4-4-10-9-18-15H43s0 6 1 11c1 6 3 11 3 11H31h15c-4-12-3-18-3-21v-2zM27 166v-1c1 0 3 3 2 4l-1-1s-1 0-1-1h-9c-1 0-1 0-1-1h10z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M30 165h1c2 1 3 4 1 4 2 4 3 8 5 12H26s0-1-1-1h11c-2-4-3-7-4-11l-1-1c-1-1-1-3-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M34 166c0-1 0-2 1-1 2 1 3 4 1 4 1 8 2 11 3 13 0 1 0 1 1 2h-8c-2 0-4-1-4 0 0-1-1-1-1-1h12c0-1-2-4-2-7-1-4-2-7-2-8-1 0-1-1-1-2zM12 165h4s1 0 1 1h-4c1 2 3 5 4 7h1c0-1-1-2-1-3 0 0 0-1-1-1 0-1-1-2-1-3-1-1 0 2 1 3 0 1 0 1 1 1 0 1 0 1 1 2h-2c-1-2-2-5-4-7zM213 166c0-1 1-1 0 0 0 1-1 2-1 3-1 2-3 4-4 6 0 1-4 7-11 15s-18 17-30 23c-12 7-26 11-36 12-10 2-17 2-18 2 12 0 24-2 36-6s23-10 31-16c18-13 27-28 28-30l3-6v-1c1 0 1-2 2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M214 165s-1 3-2 5c-4 6-4 6-6 8-8 12-17 21-26 27s-17 10-24 13c-14 6-25 7-31 8s-9 1-10 1h-2s7 0 18-2c10-1 24-5 36-12 13-7 24-16 31-24s10-14 10-14c1-2 3-4 4-5v-2c1-1 2-2 2-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M197 167c1-2 2-1 1 1h4v6c-8 14-19 26-31 34-6 4-12 7-18 10-1 0-10 4-20 6-9 3-19 3-20 3 13 0 26-3 38-8 1-1 1-1 3-1 2-1 6-3 14-8 2-1 1 0 5-3 1-2 5-4 10-9 4-4 11-11 18-23v-6h-3c-1 0-1 1-2 1-1 1-1-2 1-3zM16 167c-1-2-1-1 0 1 1 1 1 2 2 2 1 2 2 3 3 5h-3c-1-3-3-5-4-7h4v1h-4c2 2 3 4 5 7h2l-3-6v-1s-1-2-2-2zM88 167c-1 0-1 1-1 1-1 3 2 4 3 3 1-2 0-4-2-4zM79 168c-1-1-3-1-3 0-1 1 0 2 1 3-2 2-3 4-4 6h-3c3 8 5 13 6 17 2 3 3 5 4 7l1 2H70c0 2 1 3 1 5 4 4 5 5 8 6 2 2 6 6 16 10h-5c1 0 6 1 11 2 6 1 12 1 12 1-6 0-10-1-13-1-4-1-5-1-7-2h-2 5c-3-1-8-4-13-7s-10-7-11-9c-1-1-1-3-1-4h11c-4-8-8-16-11-26h2c2-2 3-5 5-7h1c1-1 0-2 0-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M73 168c-2-2-4 0-3 2l-3 6c2 9 6 17 10 24H67c0 4 1 6 2 7 2 2 3 4 6 6s7 5 16 9h-6c1 0 6 2 12 3 7 1 14 2 16 2-1 0-8 0-14-1s-12-3-13-4h6c-1 0-6-2-11-5-6-4-10-8-11-9-1 0-1 0-1-1 0-2-1-3-1-7h10c-4-7-8-15-11-23 2-2 3-4 4-6 3 1 3-2 2-3zM195 170c1-1 1-2 0-3l-2 2c-1 1-1 2 0 2 0 1 1 0 1 0 0 1 1 2 1 3 0 0 0-1-2 3-1 2-2 5-6 9-3 5-8 11-15 18-1 0 0 0-2 1s-5 3-12 6c-7 6-15 10-23 12-1 1-1 1-2 1 0 0-2 0-5 1 0 0-4 1-7 1-4 1-7 1-8 1 1 0 5 0 8-1 3 0 6-1 6-1 4 0 6-1 6-1h1c9-3 17-7 24-12 5-3 9-5 13-7v-1c10-8 18-18 25-30 0-1 0 0-1-4zM91 168h5c1 1 11 9 12 10 0 5 0 10 1 15 1 0 2 2 0 3-1 0-2 0-2-1s0-2 1-2v-7c-1-4-1-7-1-7-3-3-10-9-11-10h-4c0 1 0 3 1 4 0 0 1 1 1 2 1 1 0 2-1 2-2 0-4-3-1-4 0-2-1-3-1-5zM121 169c-1-2-3-1-3 0-1 3 2 4 3 2 1 0 1-2 0-2zM19 169h5l1 1 3 3h1c1 1 1 2 1 3 1 1 0 1-1 0l-1-2s-2-2-3-4h-6v-1zM206 171s0-1-1-1v1c-2 2-2 3-2 4l2-2c0-1 0-1 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M203 170v1c-1 0-3 3-2 4l-3 3c0 1 0 1-1 4-1 0 0 0-3 4-3 3-8 12-25 23-1 1-2 2-3 2-2 2-4 3-7 4-1 0-1 0-2 1s-4 2-11 5c-1 0-2 0-2 1h-2s2 0 3-1h1c4-2 8-3 11-5 1 0 2-1 2-1 3-1 5-2 7-4 0 0 9-5 17-13 8-7 14-16 14-16 1-1 1-2 2-4 0-1 1-2 2-4 0 0 1 0 1-1 1-1 2-2 1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M193 175c0-2 2-3 2-2v1h3v4s-5 9-13 17c-7 7-16 13-16 14-5 3-10 6-16 9-1 0-10 4-19 6-10 3-20 3-21 3 14 0 27-3 40-9 5-3 10-5 14-8 1-1 2-1 3-2s8-6 15-13c6-7 11-15 13-17 0-1 0-2-1-3h-3c0 1-1 2-1 2-1 0-1-1 0-2zM25 174v-1c1 0 2 1 2 2l1 1c0 1 0 1-1 0 0 0-1 0-1-1h-4l-1-1h4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M31 173c2 1 3 3 2 4 1 1 1 2 2 2H25c-1 0-1 0-1-1h10c-1 0-1-1-1-1l-1-1c-1-1-2-4-1-3zM39 174c0-1-1-1-1 0v2c1 1 2 1 2 2 1 0 1-1 1-1s-1-2-2-3zM192 175c0-1 0-1-1 0-1 0-2 1-2 2s-8 8-9 9c-9 14-18 22-26 27-7 5-12 7-15 9-3 1-5 1-5 1l-1 1c-7 2-13 3-20 3 6 0 13-1 20-3h1c4-2 9-4 14-7 6-3 11-7 16-11 10-9 16-19 17-20 3-3 6-5 8-8 1 0 3-2 3-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M165 176c1-1 2-2 3-2s1 2 0 3c-1 2-3 2-3 0h-5c-2 5-3 10-6 15 0 0 0 1-1 1h-6s-4 4-9 8c-4 4-8 7-8 7s-1 2-3 5c-1 3-3 6-5 9-2 2-4 4-6 4-2 1-3 1-3 1 5 0 8-4 10-7 3-4 4-7 5-8l1-4s4-4 9-7l9-9h6s2-3 4-7c1-4 3-9 3-9h5zM19 176h2c1 1 1 2 2 3h1c1 0 1 0 1 1h-1l-3-3h-1c2 3 4 6 6 8h2c1 1 1 2 2 3 0 1 3 3 3 3 1 0 0-1-1-2-1 0-1-1-2-1-1-1-2-3-3-4h-2c-2-2-4-5-6-8z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M92 180c0-1 2-1 2 0 1 1 1 2 1 3-1 0-2 0-3-1H65v9H34l-1-1h31v-9h28v-1zM194 179c1 0 1 1 0 2 0 1-1 2-2 2 0 0 0-1 1-2 0-1 1-1 1-2zM23 182c0-1-1-3-1-3s1 1 1 2h1c1 0 1 1 2 2h1s1 0 1 1h-1l-2-2h-1c1 2 1 1-1 0zM144 181c1 1 0 3-1 3s-2 0-2-1h-3c-1 7-3 14-6 20l-5 5c-1 4-3 8-5 11v1c-1 0-3 2-4 2l-2 4c-1 0-3 1-3 1s2 0 3-1l2-4c1-1 1-1 4-3l1-1c0-1 0-2 1-3 1-2 2-4 3-8 2-1 4-3 5-4 2-6 4-13 5-21h4c1-2 3-2 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M97 186c0-1-1-2-2-2s-1 0-2 1H76c3 7 6 14 9 20H73c0 1 0 3 1 4 0 0 6 5 12 9 5 4 12 6 13 6h-2c4 2 8 2 12 2h-1c2 1 4 1 5 1h-4 1c-4-1-8-1-12-2h2c-3-1-9-3-14-7-5-3-10-8-12-9v-3h12c-3-6-6-13-9-20h17c1 2 3 2 3 0zM28 185h1l1 1h-2c1 0 1 1 1 1v2c1 0 0 0-1-1 0-1-1-2-2-3l2 2v-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M93 187c0-1 1-2 2-2 1 1 2 3 1 3-1 1-2 1-3 0H68v6H36v-1h31v-3c0-2 1-3 1-3h25zM191 186s-1 1-1 2c-2 1-3 1-2 0 2-2 3-3 3-2zM107 186c-1-1-2 0-2 1s1 2 2 2 2-1 1-2c0 0 0-1-1-1zM141 186c1 0 2 1 2 2-1 1-2 2-3 2 0 0-1-1 0-2 0-1 0-2 1-2zM150 187c1-1 2-1 2-1 1 1 1 2 0 3s-2 1-2 0c-1 0 0-1 0-2zM32 188c-1-1-1 0 0 1s2 2 3 2l-1-1-2-2zM29 188l1 1s0 1 1 1c1 3 1 2 1 2h3l1 1h-3c0-1-1-1-1-2l-3-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M41 188h-7c4 5 8 9 12 12v1c-1-1-1-1-2 0 4 3 9 7 14 10h-2c-1 0-1-1-2-1 0 0-1 0 0 0h3-2s-1 0 0 0c0 1 2 1 3 2h2c-6-3-10-7-15-11h2c-4-3-8-7-12-11v-1h6c1 0 1 1 2 1 0 0 1 1 2 1 0 0 0 1 1 1 1 1 2 1 1 0 0-1-1-2-2-2-1-1-1-1-1 0l-3-2zM163 189c1 0 1 1 0 2 0 1-2 2-2 2-1-1-1-2 0-3 1 0 1-1 2-1zM167 189c1 0 1 1 1 2-1 1-2 1-3 2 0 0-1-1 0-2l2-2zM71 192s0-1 1-1h1c1 1 2 3 0 3l-2-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M44 192h-6l8 8c2 1 2 2 3 3h-2c5 4 10 7 16 10h-2c-2 0-3-1-4-2h2c0 1 0 1 1 1h-2c4 3 4 2 4 2h2c-6-3-11-7-16-11h2c-1 0-4-3-6-5l-5-5h5c2 1 3 2 5 3 1 2 3 3 3 2s-1-2-2-3h-1c-2-1-3-2-5-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M102 194c0-1 0-1 1-1 1-1 2 1 2 2s-2 2-3 0H89l-4 6c-1 2-2 5-2 5h-9l-9-6H43l-1-1h23c0 1 8 6 9 7h8c0-1 0-1 1-2 0-1 1-3 3-6 1-2 1-3 2-3v-1h14z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M131 194s1-1 2-1 1 1 0 2c-1 2-2 2-2 0h-8l-4 4-4 4H87l-2 6v5H74c3 3 5 4 6 5h1-6c-6-2-11-5-16-8-1 0-2 0-2-1 6 3 11 6 17 9h6c-2-2-6-5-7-6h12s-1-2 0-5c0-3 1-6 1-6h29l4-4c2-1 4-3 4-4h8zM37 193c-1 0-1 0 0 1h-1c5 5 11 10 16 14h-1c-1-1-2-2-3-2h3-2v1c2 1 3 1 3 1h1c-5-3-11-8-16-13h1c0 1 1 1 1 1 1 1 1 1 1 0-1-1-3-2-3-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M34 193c0 1 1 1 2 2v1h3l1 1h-3c0-1 0-1-1-1 1 0 1 0 1 1 1 0 1-1 0-1-1-2-3-3-3-3zM133 196c1-1 0-2-1-1-1 0-2 1-2 2s2 1 2 0c1 0 1 0 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M38 195h26s1 1 3 2h3c-1 0-1 0-1-1 1 0 2 0 2 1 1 0 2 2 1 2 0 1-1 0-2-1h-3c-1-1-2-2-3-2H38v-1zM75 196c1 0 2 2 2 3h-2c-1-1-2-3 0-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M60 196c-1 0-2 0-1 1 0 1 1 1 1 2 1 2 2 6 4 9 3 4 5 6 6 6h-3c2 1 4 3 6 4h-3c1 0 3 1 5 2h-1c1 0 3 1 4 1 5 2 10 3 16 4h3c1 1 2 1 3 1 5 0 9 1 13 1-4 0-9-1-13-1-1 0-2 0-4-1h-1c-9-1-13-3-14-3l-2-1c-1 0-3-1-4-1h1c-2-1-3-1-5-2h3l-6-3h3c-1 0-4-3-7-7-2-4-3-8-3-9 2 1 1-2-1-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M40 197h24c1 0 7 5 7 5h6v-1h1c1 1 2 2 1 3 0 0-1 0-2-1h-6c-2-2-6-5-6-5H41l-1-1zM160 198c0-2-2-1-3 1-1 0-1 1-1 1 1 1 3-1 4-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M47 198h-1c0 1 0 1 1 1 1 1 3 4 8 8h-2c5 4 11 7 17 10h-3c1 0 3 1 4 1 0 0 4 2 5 2 1 1 4 2 8 3 3 1 7 1 7 1 2 1 5 1 7 2h5c1 0 4 1 10 1-4 0-8-1-12-1-1 0-3 0-4-1h-5c-5-1-10-3-15-4 0 0-5-2-6-3-1 0-2 0-2-1h2c-6-3-11-6-17-10h3c-4-2-7-5-10-8h1l1 1c0 1 1 1 2 2s2 2 2 1l-3-3c-1 0-2-1-3-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M130 199c1-1 2-1 2 0 1 1 0 2-1 2-1 1-2 0-2-1h-6c-1 1-7 5-7 6H89c-1 2-2 4-2 6s1 4 1 4 2 2 5 4c2 1 5 3 5 3 1 0 2 1 3 1l2 1c1 0 4 2 10 2-4 0-8-1-12-3-1 0-3-1-3-1-4-2-7-4-11-7v-1c-1-5 0-8 1-9 0-1 0-1 1-1h27s5-4 7-5c0-1-1 0 6 0l1-1zM41 199c-1 0-2-1-1 0l1 1h-1 4-3 1c0 1 1 1 1 1l-1-1s-1 0-1-1zM178 199l-2 2c-1 1-1 1 0 1l-3 3c-2 2-5 4-8 6s-6 3-9 4c-8 5-17 8-18 8s-7 2-13 3-12 1-12 1 7 0 13-1 12-3 12-3c6-2 12-4 18-7v-1c3-1 6-2 9-4h1c4-3 6-5 7-5l1-1c1-1 2-2 3-4 2-1 2-2 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M132 200h-2c-1 1-1 2-1 3h1c-2 4-3 7-4 10 0 1 1 3 1 3s-1 1-2 3-3 4-5 5c-1 1-3 2-5 2-1 1-2 1-2 1s1 0 3-1c1 0 3-1 5-2 1-2 3-4 4-5 2-2 2-3 2-3 0-1 0-2-1-3 2-3 3-6 4-10 1-1 2-2 2-3zM44 200h1l1 1c2 1 4 3 7 4h1c-1 0-1-1 0-1l3 3s-1 0-2-1h-2s-1-1-2-1l-5-4h-2v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M183 201c1 0 2-1 2 0-1 0-2 1-3 2-1 0-1 1-1 0-1 1-2 2-3 2-3 3-5 4-6 5-1 0-2 0-2 1-9 5-13 6-15 7s-2 1-3 1c-12 5-25 8-39 8 11 0 19-2 25-3 5-2 9-3 11-4 5-1 4-1 4-1 10-4 15-7 17-8l2-1c0-1 6-5 7-5 1-1 2-2 3-2 0-1 1-1 1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M136 201c-1-1-2-1-2 0-1 1-1 2-1 2 1 1 2 1 2 0 0 0 0-1 1-1h3s-1 3-4 7c-2 4-5 8-8 11s-7 5-9 6c-3 1-5 1-5 1 3 0 6-1 9-3s6-4 9-7c2-3 5-7 6-10 2-3 3-5 3-5h-4v-1zM96 201c0-1-2-1-2 0s0 2 1 2c1 1 2 0 2-1h8c0 1 4 5 6 6v4c0 3 1 5 1 8v3c0 1 0 2 1 2v2-2s-1-2-1-3v-6c0-3 0-5-1-8 0-1-4-5-6-7h-9zM117 202l-1 1c0 1 1 2 2 2 0 0 1-1 1-2s-1-1-2-1zM113 202s-1 0-1 1 0 2 1 2c0 0 1 0 1-1 1-1 0-2-1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M169 204c-1 0-1 1-2 1-11 10-23 16-31 18-9 3-15 3-15 3-3 1-5 1-8 1 1 0 7-1 7-1 1 0 12-1 23-6 12-5 22-13 23-15l1-1c2-2 4-2 2 0zM44 203h3s0 1 1 1h-3c1 0 2 1 2 1 1 0 1 1 2 1 0 0-2-1-3-2 0-1-1-1 0-1v1s-1 0-2-1zM105 204h-6c-1-1-1 0-2 1h-1v2c1 1 2 1 2 1v-2c0-1 0-1 1-2h6c1 1 4 4 4 5 0 0 0 2 1 5v4c1 1 1 3 1 4s1 2 1 3c0 0 0 1 1 1v1-1c-1 0-1-1-1-2 0 0 0-1-1-2v-3c0-2-1-3-1-4v-7c-2-1-3-2-5-4z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M173 204c-1 0-2 1-3 2-2 1-11 6-11 6-1 0-1 1-2 1-11 8-17 9-20 10l-3 1s-4 1-9 2-11 1-12 1c1 0 3 0 6-1h4c7-1 9-2 11-2 1 0 1 0 1-1 8-2 16-6 24-11 3-1 7-3 11-6v1s1-1 2-1c2-2 2-3 1-2zM67 205c0-1 0-1 1-1s2 1 2 2h1c-1 1-3 0-4-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M153 205c1 0 2-1 2-1 1 0 0 2-1 2-1 1-2 1-2 1v-1h-8c-6 4-5 3-5 3-4 5-7 10-12 13h9c-1 0-1 0-2 1h-1c-5 2-10 3-15 3-2 1-3 1-5 1h4l1-1s3 0 7-1c4 0 7-2 8-2l2-1h-8s3-2 5-5c3-3 6-7 6-8 1 0 0 0 6-3 0-1 0-1 1-1h8zM48 204c2 0 2 0 2 1 3 1 6 3 8 5h2c-2-2-1-2 1 0 1 0 1 1 2 1h-1l-1-1h-2l-8-5h-2l-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M134 206c0-1-1-1-2 0s-1 1-1 2c1 0 2 0 3-1h1s-1 2-3 5-4 7-7 10c-3 2-6 4-8 4-2 1-4 1-4 1 2 0 4-1 7-2 2-1 5-3 7-5 2-3 4-5 6-8l3-6h-2zM105 206h-5v1c-1 0-1 1-1 3-2-1-2 1-1 2 2 0 2-1 1-2 1-1 1-2 1-3 1 0 3-1 4 0 1 0 2 1 3 2 0 1 1 3 1 6 1 1 1 2 1 4 1 1 1 2 1 3l2 4 1 1-1-1s-1-2-1-3c-1-2-1-3-1-4-1-1-1-3-1-4-1-3-1-5-1-6l-3-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M168 209c0-1 0-1-1-1 0 1-1 1-2 2l-6 3h-1c-10 7-17 9-19 10-3 1-3 0-3 0s-5 2-11 3c-5 1-11 1-12 1 1 0 7 0 13-1 5-1 10-3 11-3 0 0 6-2 11-4s10-5 11-6c2-1 4-2 5-3 0 1 2 0 4-1zM81 208s-1 0 0 1h-4c0 1 0 1 1 2l3 3c2 2 8 7 20 11h-1c4 1 9 2 13 2-4 0-8-1-12-2h1c-8-2-17-7-24-14v-1h3c2 1 3 1 2 0 0-1-1-1-2-2zM54 208h1c0 1 2 2 9 5h2c-1 0-2-1-1-1l2 2c2 1 2 1 0 0h-2c-3-2-6-3-9-5h-1s-1 0-1-1zM72 209s-1-1 0-1v1c1 0 2 0 2 1 1 0 1 0 1 1 0 0-1 0-2-1H63c3 2 3 2 4 2 0 1 0 1 1 1s2 1 2 1c0 1 0 1-1 0-1 0-2-1-2-1-1 0-1-1-1-1l-4-3h10z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M74 208c1 0 2 1 2 1 1 1 2 2 1 2 1 0 1 1 1 1h-7s1 1 3 2c1 2 2 3 3 3h-2c1 0 1 1 1 1s-1-1-2-1c-1-1-2-1-2-1 1 0 1 0 2 1h2c-4-3-5-4-6-5v-1h7c-2-1-3-3-3-3zM149 210c1-1 2-1 2-1v1c-1 0-2 1-2 1h-1s0-1 1-1zM146 210c1-1 2-1 2-1 1 0 0 1-1 1 0 1-1 1-1 1h-1l1-1h-5l-2 2c-2 3-5 6-8 8h8c-1 1-2 2-4 3-6 2-11 3-16 3-1 0-1 0-1 1h-5c2 0 4 0 5-1 6 0 11-1 16-3 2-1 3-1 4-2h-8v-1c3-2 6-5 9-9l2-1c1-1 0 0 5 0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M131 209c-1 1-2 3-1 3 0 1-1 2-1 4-1 0 0 0-2 2-1 1-2 3-4 5s-6 4-10 4c3 0 6-1 8-3 3-2 6-5 8-8 1-2 1-3 2-4s1-3 0-3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M107 210c1-1 2 0 2 1 0 0 0 1-1 1v1c3 1 6 0 8 0 1 1 1 1 2 1v1s0 1-1 3c0 2-1 4-1 6-1 1-1 2-2 2 0 1-1 1-1 1s1 0 1-1c0 0 1-1 1-2 1-2 2-4 2-6v-3c0-1-1-1-1-1h-8v-2c-2-1-2-2-1-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M111 210c0-1 0-1 1 0h3l1 1c1 0 4 2 4 2-1 3-1 5-2 7s-1 3-2 4c-1 2-2 3-3 3 0 0 1 0 1-1 1 0 2-1 2-2 1-2 2-4 2-6 1-2 1-4 2-4-2-1-3-2-4-3h-4c0 1 0 1-1 1s-1-2 0-2zM170 210c1 0 0 0-2 1-1 1-2 1-2 1 1 0 2 0 3-1 1 0 1-1 1-1zM86 213c-1-1-2-1-2-1 0 1 1 2 1 2 2 1 2 0 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M143 213h2-1c0 1-1 2-2 2v-1h-3l-1 1c-1 1-3 2-4 4h8c-1 1-3 2-5 3l-2 1c-2 1-6 3-16 3-2 1-4 1-6 1 2 0 4 0 5-1h2c2 0 7 0 16-4h1c1 0 2-1 5-3h-9l5-5s1 0 2-1h3zM61 214c-2-1-3-2 0-1h1l1 1h-1c2 1 1 1-1 0zM100 214c0-1 2-1 2 0 1 1 1 1 0 2l-1-1h-4c-1 1-1 2-1 3 3 2 6 5 9 6h1l1 1s2 0 3 1h2c0 1 1 1 1 1s-1 0-1-1h-2c-1-1-3-1-4-1h-1v-1c-5-2-7-4-8-5l-1-2v-3h4zM104 213c1 0 2 1 2 2 2 3 4 4 5 5l2 2v5-4l-3-3-5-5v1l-1-1v-2zM164 214s-1 0-2 1c-2 1-3 1-2 1 0 0 2-1 3-1 0-1 1-1 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M163 215c1-1 1-1-1 0-1 1-2 1-3 2-1 0-2 0-3 1-1 0-1 1-2 1h-1c-1 1-10 4-19 6-9 1-19 2-21 2 14 0 27-3 39-8h2c1-1 1-1 2-1 1-1 2-1 3-1 0-1 0-1 1-1s2-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M163 215c3-1-1 1-3 2-2 0-3 1-4 1-1 1-2 1-3 1-1 1-10 4-19 6-10 2-20 2-21 2 2 0 11 0 20-2 10-2 18-5 20-6 1 0 2-1 3-1s2-1 4-1v-1h2c0-1 1-1 1-1zM64 215h2-1c0 1 1 1 2 2 2 0 3 1 3 1s-2-1-3-1c-1-1-2-1-1-1l-2-1zM79 216c-1 0-1 0 0 0s2 1 2 1c1 0 1 1 1 1 1 1 3 2 5 3 1 0 2 1 3 2 2 1 3 1 3 1h-3 2c-2-1-4-2-5-4 0 0-4-1-6-2 0 0 0-1-1-1l-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M81 216h1c1 1 1 1 2 1v1l6 3 2 2c1 0 2 1 3 1 3 1 7 2 10 2h1-1c3 1 6 1 8 1-4 0-7-1-8-1h-1 1c-4 0-7-1-11-2-1 0-2-1-3-2-1 0-2-1-2-1l-6-3-2-2c-1 0-1 0 0 0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M83 216c-1-1 0 0 2 0h2l1 1c3 2 7 5 10 6 0 0 3 1 4 1 0 1 3 2 5 2 3 1 6 1 6 1-4 0-7-1-11-2-1-1-3-1-4-2-3-1-7-3-10-6h-3c2 1-1 1-2-1zM68 217c-1 0-2-1-3-1 0 0 2 1 4 1 0 1 3 2 3 2 4 1 8 3 12 4h1c-7-2-8-3-11-4h1c0 1 1 1 1 1 3 1 6 2 10 3h-1c-4-1-8-2-12-4-1 0-2-1-4-1 1 0 0 0-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M66 216h-1 1c1 1 2 1 2 1 1 1 2 1 3 1l1 1 9 3h1c-4-1-7-2-11-4h1l1 1s2 1 5 2c2 0 5 1 5 1h-1c-3-1-7-2-11-3v-1h-2c1 0 0 0-1-1-1 0-1 0-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M66 216c-1 0-1 0 0 0 1 1 3 2 3 2h1c2 1 5 2 8 3h1c-3-1-7-2-10-4h1l1 1h-1c3 1 7 2 10 4-4-2-7-3-10-4-1 0-1 0-2-1l-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M67 216c4 2 9 4 13 5 0 0 3 1 4 1h-1c-1 0-2-1-2-1-4-1-8-3-12-4-1 0-1-1-2-1zM137 217c0-1-1-1-1-1-1 1-2 1-2 2 0 0-1 0-2 1-6 5-12 8-19 8 7 0 13-3 19-8 1 0 1-1 2-1 0 0 2-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M66 216h2l1 1h-2 1c3 1 5 2 8 3 1 1 2 1 1 1-1-1-2-1-3-1-1-1-2-1-1-1 0 0 1 0 2 1-3-1-5-2-7-3-1 0-1-1-2-1zM147 217c1-1 1 0 0 0-1 1-2 2-3 1 0 1 0 0 1 0 1-1 2-1 2-1zM157 217c1 0-1 0-2 1l-2 1c1 0 4-2 4-2zM82 219c-1-1-3-1-4-2h-5c1 0 2 1 5 3 3 1 7 3 11 4 10 2 21 3 24 3-1 0-10 0-20-2-4-1-8-3-12-4-3-1-5-3-6-3h4c1 0 2 1 3 1 0 0 0 1 1 1s2 1 2 1c0-1-1-1-2-2h-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M104 217v4c1 0 1 1 2 2 0 1 1 2 1 2 2 1 4 2 6 2-2 0-4-1-6-2v-2c-1 0-2-1-2-2-1 0-1 0 0-2h1c0-1-1-2-2-2zM82 220c-2-1-3-1-2-1 3 1 4 2 4 2-1-1-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M80 220h-1s2 1 5 2 7 2 11 3c8 2 17 2 18 2-3 0-12-1-20-2-4-1-7-2-9-3-3-1-4-2-4-2h1c1 1 2 1 1 0-3-1-5-2-2 0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M90 220c-1 0-2-1-1 0 0 0 1 0 2 1h1l1 1 1 1c1 1 2 1 3 2 5 1 11 2 16 2-5 0-11-1-16-3h-1s-1 0-2-1-2-1-2-2h-1s-1 0-1-1zM141 220c0-1-1 0-2 0l-1 1s1 0 2-1h1zM151 220c1-1 0 0-1 0-1 1-3 1-3 1h2c1-1 2-1 2-1zM101 220h1c0 1 1 1 0 1h-1c-1-1-1-1 0-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M103 220c0-1 1 0 2 1 0 0 1 1 3 2s3 2 4 2v1s0 1 1 1l-1-1c-1-1-2-2-3-2-1-1-3-2-4-3h-1l-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M105 220c1-1 2 0 2 1 0 0 1 1 3 2 1 1 2 1 2 2s1 2 1 2-1-1-1-2c-1-1-3-2-5-4-1 0-2-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M108 220c0-1 1 0 1 1l2 2c1 1 2 1 2 1v3s0-1-1-3l-1-1-2-2h-1s-1-1 0-1zM77 220s1 1 2 1h1s2 1 3 1 1 0 0 0-2-1-3-1h-1c-1-1-2-1-2-1zM145 220c1 0 0 0-1 1 0 0-2 0-2 1-1 0 0-1 1-1s2-1 2-1zM105 220s0 1 1 1c0 1 1 1 1 1 1 0 2 1 2 1 1 2 3 4 4 4-1 0-2-2-4-4l-2-2c0-1-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M102 220v1l1 1c1 0 1 1 2 1 0 0 0 1 1 2 2 1 5 2 7 2-2 0-5-1-7-2 0 0-1-1-1-2-1 0-1-1-2-1 1 0 1-1 0-1 0-1-1-1-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m101 221-1-1c-1 0 0 1 0 1l1 1c1 0 1 1 2 1 0 0 0 1 1 1 3 2 6 3 9 3-3 0-6-1-9-3l-1-1-1-1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M98 221c0-1-1-1-1-1l2 2c1 0 2 1 2 1 1 0 1 1 2 1 3 2 7 3 10 3-3 0-7-1-10-3l-1-1c-1 0-2-1-2-1v-1h-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M79 221h1c10 4 18 5 18 5 5 0 10 1 15 1-6 0-14-1-14-1-6-1-12-2-18-4h2-2c-1-1-2-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M81 221c-1 0 1 0 2 1h2-2c-1-1-2-1-2-1zM148 221c1 0 1 0 0 0s-2 1-3 1h-1c-1 1-3 1-5 2-5 1-7 1-9 1l-1 1h-7c-1 0-4 1-9 1 3 0 6 0 9-1h7c3-1 7-2 10-2 0 0 1 0 1-1 1 0 5-1 5-1 1 0 2-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M82 222c-1-1-2-1-2-1 2 1 3 1 4 2 1 0 0-1-2-1zM120 222h1s-1 1-2 1l1-1zM144 222c-2 1-5 2-4 1-1 0-1 1-2 1-8 2-16 3-25 3 9 0 17-1 26-3 1-1 1-1 2-1 3-1 4-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M139 222c1 0 0 1-1 1s-2 1-3 1c0 0 1-1 2-1s2-1 2-1zM108 223c-1-1-1-1-1 0l1 1h1l2 2c1 1 2 1 2 1s-1 0-2-1l-2-2-1-1zM133 223c-1 0-2 1-2 1h-2c-5 2-11 3-16 3 0 0 4 0 8-1 4 0 8-2 8-2h3l1-1c3-1 2-1 0 0z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M133 223c0-1 0-1 0 0-1 0-3 0-3 1-1 0-2 0-3 1h-1c-5 1-9 2-13 2 0 0 3 0 6-1 3 0 7-1 7-1 1 0 3-1 4-1s1 0 1-1h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M132 223c0-1 0-1-1 0h-2v1c-2 1-5 1-7 2h-5c-2 1-4 1-4 1 3 0 5-1 8-1h1c1 0 3-1 7-2 0 0 1 0 1-1h2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M129 223c0-1 0 0 1 0h3-1c-1 0-3 1-7 2l-4 1h-3c-2 1-3 1-5 1 2 0 3 0 5-1h1s5-1 6-1c2 0 5-1 7-2h-4s-1 0-1 1h-1c-1 0-2 1-2 1s0-1 1-1h1c1-1 2-1 3-1zM87 223c-2 0-1 0 0 0l12 3c5 0 9 1 14 1-4 0-9-1-14-1-3-1-7-1-11-2h1s-1 0-1-1h-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M139 224c2-1 2-1 1-1-1 1-2 1-3 1h-1l-6 1s0 1-5 1c-4 0-8 1-12 1 4 0 8-1 12-1 2 0 4 0 4-1 3 0 5 0 7-1h3z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m140 223-1 1h-3c-1 1 0 0 2 0 1 0 1 0 2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M140 223s-1 0-2 1h-3c-2 1-4 1-6 2h-5c-4 0-7 1-11 1 3 0 6 0 9-1h3c1 0 3 0 4-1 2 0 4 0 6-1h1c2 0 4-1 4-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M118 224h1l-1 1h-1l-1 1c-1 0-2 1-3 1 1 0 2-1 3-1 0-1 0-1 1-1h1v-1zM94 224h-1c-1 0 2 0 3 1h-1 2-3 1s0-1-1-1zM98 224c-1 0 0 0 0 0h2c1 0 2 1 2 1h1c1 0 2 1 5 1 1 0 3 1 5 1-5 0-8-1-9-2h-1c-1 0-2 0-2-1h-1v1c1 0-1-1-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M103 224h-1 2c0 1 1 1 2 1h1c1 0 1 0 2 1h3v1h1-1s-1-1-2-1-3-1-3-1h-1c-1 0-2 0-2-1h-1c2 1 1 1 0 0zM127 224h1c-1 0-2 0-2 1h-3c-1 1-2 1-3 1h-2c-2 1-3 1-5 1 2 0 3 0 5-1l5-1h2c1-1 2-1 2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M129 224s-1 0-2 1h-3s-5 1-6 1c-2 1-3 1-5 1 2 0 3 0 5-1h1c1 0 2 0 5-1h2c1-1 3-1 3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M137 224h-2c-1 1-1 1-2 1-2 0-5 1-7 1-4 0-9 1-13 1 4 0 7 0 10-1h3c1 0 2 0 7-1 0 0 3-1 4-1zM101 224h-1 1-1c1 1 2 1 3 1h-1c4 1 7 2 11 2 0 0-2 0-5-1h-5 1c-1-1-2-1-3-1h2-1c0-1-1-1-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m133 224-1 1h-3 2c1-1 2-1 2-1zM96 224h-1s1 1 2 1h2c2 1 4 1 6 1 3 1 5 1 8 1-2 0-5 0-7-1-2 0-5 0-7-1 0 0-2 0-3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M96 225c-2-1-2-1-1 0h3c1 0 3 1 4 1h-1c4 0 8 1 12 1-3 0-7-1-11-1h1c-2 0-3-1-5-1h-2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M94 224c-1 0 0 0 1 1h1c1 0 4 1 8 1 4 1 8 1 9 1-1 0-5 0-8-1-4 0-7-1-8-1 1 0-1 0-3-1zM109 225c-1-1 0-1 0 0h1c1 1 2 1 2 1l1 1-1-1c-1 0-1 0-2-1h-1zM133 225h-4c-5 1-10 2-16 2 1 0 0 0 0 0h1c1 0 5 0 15-2h4c2 0 1 0 0 0zM120 225h1s-1 0-1 1h-1c0-1 1-1 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M121 225h1c-1 1-3 1-5 1-1 1-2 1-4 1 2 0 3 0 4-1h1s2 0 4-1h-1l-1 1 1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M126 226c1-1 2-1 2-1h-2c-1 1-1 1-2 1-3 0-7 1-11 1 2 0 9-1 11-1h2zM97 225h-2s2 0 3 1h5c4 1 7 1 10 1-3 0-7-1-10-1h-5s-1 0-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M97 225h-2s2 0 3 1h6c3 1 6 1 9 1-3 0-6 0-10-1h-4c-1 0-1 0-2-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M98 225h-3 2s1 1 2 1h6c3 1 5 1 8 1-3 0-6 0-9-1h-5s-1 0-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M100 225h-1l2 1c2 0 2 0 0 0 4 0 8 1 12 1-7 0-10-1-12-1-1 0-1 0-1-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M102 225h2c1 1 1 1 2 1 2 0 5 1 7 1-4 0-5-1-6-1h-3 1s-1 0-3-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m106 226-1-1h3v1c2 0 3 0 4 1h1-1c-1-1-2-1-4-1h-2zM114 226v-1 1c-1 0-1 1-1 1v-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M106 226c-2-1-2-1-1 0h-1c3 0 6 1 9 1-3 0-5-1-8-1h1c1 0 2 0 0 0zM97 226c0-1 1 0 2 0h3-5z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M97 226c0-1 1 0 3 0h2-5zM98 226h7-7zM101 226h-2 4c4 1 4 0 4 0 1 0 1 0 0 0h-6z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M101 226c-1 0-2-1-2 0h5c3 0 6 1 9 1-3 0-6-1-10-1h-2zM125 226h2-2 1c2-1 2 0 0 0h-3 2-2 2z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M108 226h2-2c2 0 4 1 5 1-1 0-3-1-5-1zM118 226h1-3v1h-3 3c1-1 1-1 2-1h-1c-1 0-1 0 0 0h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M106 226c2 0 5 1 7 1-2 0-4-1-7-1h1c1 0 2 0 3 1h1c1 0 0 0-1-1h-1 1-4zM105 226h3-3zM122 226c1 0 1 0 0 0h-2l-1 1h-1s1 0 2-1c-2 1-4 1-7 1h6c1-1 1-1 2-1h1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="m111 226 1 1v-1h-1zM114 226c1 0 1 0 0 0 0 1-1 1-1 1h1v-1z"
          />
          <path
            className="CyberEl85_svg__fil0"
            d="M119 226c1 0 0 0-2 1h-4 3c1 0 2 0 3-1zM107 226c1 1 2 1 3 1h3-5 5c-2 0-4 0-6-1zM112 227c-1 0-1 0 0 0h1-1 1-1zM112 227h1-1zM112 227h1-1zM111 227h-1 3-2zM111 227c-1 0-1 0 0 0h2-2zM113 227c3 0 3 0 0 0zM113 227z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl85;
