import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl83 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={1356}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 541 319"
      {...props}
    >
      <defs>
        <style>
          {
            ".CyberEl83_svg__fil0{fill:none}.CyberEl83_svg__fil1{fill:#000;fill-rule:nonzero}"
          }
        </style>
      </defs>
      <g id="CyberEl83_svg__Vrstva_x0020_1">
        <g id="CyberEl83_svg__World_Map">
          <path
            className="CyberEl83_svg__fil0"
            d="M469 89c0-1 0 0 0 0zM471 88l-1 1h1v-1zM115 65v1-1c1 0 0 0 0 0zM105 25h1-1zM145 64h1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M113 65h-1v1c1 0 1 1 1 1v1h-1v1c-1 0-1 1-1 1v-1h1c1 0 1 0 1 1v1s1-1 1-2c0 0 1 0 1-1 1 0 1-1 1-1-1-1 0-1 0 0 1 0 1 0 1 1 0 0 1 0 1-1v-1c-1-1-1-1-2 0h-1c-1 0-1-1-2-1zM477 75zM492 30h-1 1zM113 65h2-2zM118 70c-1 0-1 1 0 0h4c1 0 1-1 1-1h-4l-1 1zM496 26h1-1zM468 89h-1c0 1 1 1 1 1h1c1 0 1 0 1-1s0-1 0 0h-2zM118 71h-2v1h-3l-1 1h-1c0 1 0 1 0 0h-1v1c1 0 2 0 4-1 1 0 2-1 2-1h1l1-1zM102 63h-1 2c-1 1-1 1 0 1l1-1h2c0-1 1-1 1-1 0 1 0 1 0 0 1 0 1 0 0 1h1c0 1 0 1 1 1s1-1 2-1 1 0 1 1v-2h1c-1 0 0 0 0-1h-1c-1 0-1 0-1-1s-1-1-2 0h-2v1h1-2 1-2c-1 1-1 1-2 1 0 0-1 0-1 1zM98 53c0 1 0 1 1 1v-4h-1l-1 1h1-1v2h1zM118 81zM141 245c1 0 1-1 1-1h-1v1zM167 205zM118 85zM304 163v-2h1v-3c-1-1-1-1-1 0h-2s-1 0-1 3c0 2 0 2 1 2h2zM98 56v-1h1-1c-1 0-1 1-1 1h1zM354 255h1-1zM354 255zM113 12c-1 0-1 0 0 0zM117 137c-1 1-1 1 0 2v1s0-1 1-1v-1l-1-1zM111 10v1h1-1c1 0 1-1 2 0h1l-1-1h-3 1zM114 10h-1 1zM134 28l1-1c0-1-1-1-1-1-1 0-1 0-1 1 1 0 1 0 0 0h1v1zM263 48c1 1 1 0 1 0h-1c-1 0-1 0 0 0zM371 64h1-1zM90 96v1h1s0-1-1-1zM138 265h1c0-1 0-1-1 0zM264 49h1c2-1 3-1 3-1 0 1 1 1 2 1s2 0 2-1c0 0 4-1 3 0 0 0 1 1 1 0h1v-1c1 0 2 0 2-2-1-1 0-2 1-3 1 0 1 0 1 1h1v1c1 0 1-1 1-1v-2h-2v1h-1v-1c-1 0-1 0 0 0v-1h1c1 1 1 0 0 0 0 0 2-2 4-1h3c0-1 0-1 1-1s1 0 0 0c0-1-1-1-2-1h-1s-1 0-1 1h-5c-1 0-1 0-1-1-1 0-1 0-1-1v-4l2-1 1-1h1v-1c1 0 1 0 1-1h-4l-1 1v1l-1 1h-1l-2 1v1c-1 0-1 1-1 1v3c2 0 2 0 2 1v1c0 1-1 1-1 1h-1c0 1-1 1-1 1v2h1s0 1-1 1v1c-1-1-1-1-1 0h-1s-1 0-1 1 0 1-1 1h-1l-1-1v2h-1l-1 1zM140 265v1h2c0-1 0-1-1-1h-1v-1 1zM272 21v1-1zM146 20h-1 1zM285 19zM272 23h-1 1zM270 23s0-1 0 0zM152 16c1 0 1 0 0 0s-1 0-1-1h-1v1h2zM473 88c0-1-1-1-1 0 1 1 1 0 1 0z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M111 73h1c0-1 0-1-1-1v1zM109 67l2-2h-2l-1 1h-1c-1 1-1 1 0 1 0-1 0-1-1 1-2 2-3 4-3 5s1 1 2 0 1-2 1-2c0-1 0-2 1-3s1-1 2-1zM105 104zM375 153zM305 178v6h1v3-1h1-1v-4c1 0 1-1 0-1v-3c-1-1-1-1-1 0zM395 118zM105 104zM105 104zM434 138c-1 0-1-1-1-1v1h1zM299 175h1c0 1 0 0-1-1v-2l-1-1s-1 0-1-1h1v-1s-1 0 0-1h-1v-3 6s0 1 1 1v1s0 1 1 1v1zM387 14c1 0 1 0 0 0 0-1-1-1-1 0h1zM105 104h-1 1zM220 14v1c1 0 1-1 1-1h-1zM146 29v1h1c0-1 0-1-1-1zM170 8s-1 0 0 0zM203 2s0-1 0 0c-1 0-1 0 0 0zM221 15h1-1zM178 30zM222 15c0 1 0 1 0 0zM50 45c0-1 0 0 0 0zM129 248s-1 0 0 0zM267 8V7c-1 0-1 0-1 1h1zM118 119c-1 0 0 0 0 0v1-1zM117 121zM409 53v-1h1c1 0 1 0 1-1h1v-1h-1v-1 1h1c0-1 0-1-1-3l-1-1v5h-1v2h-1c0 1-1 1-1 1-1 0-1 0 0 0h1c1 0 1-1 1-1zM428 136h1c0-1-1-1-1 0zM51 41v-1 1zM226 2h-1c-1 0-1 0 0 0h1zM34 26zM129 250h1-1zM51 41v1-1zM328 76h1c0 1 0 1-1 1s-1 0-1 1v3s0 1 1 1 1 0 2 1 2 1 4 0h1v-2c0-2-1-3-1-2-1 0-1 0-1-1 1-1 0-1 0-1l-1-1c1-1 0-2-1-2v-3h-2v-1s-1 0-1-1h-1v-1h1v-1c0-1 0-1 2-1h1v-2c-1-1-1-1-2-1h-1s-1 0-2 1c-1 0-2 1-2 1v1c0-1-2 0-2 1v1c-1 0-1 0 0 0 0 0 1 1 1 2s0 1 1 1c0 1 1 1 1 2l3 3zM50 42v1c1 0 1 0 0-1 0-1 0-1 0 0zM173 8h1-1zM53 58v-1c-1 0 0 1 0 2h1v1h1c0-1-1-1-1-1 1 0 0-1 0-1h-1zM34 36zM219 16h1s1 0 0 0 0-1 0-1h-1v1zM32 37h1c0-1 1-1 0-1 0 1-1 1-1 1zM53 60v1c-1 0-1 0 0 0s1 0 1-1h-1zM280 80v1h1v-1h-1zM155 6zM151 7h-1 1c0-1 0-1 0 0zM155 5s1 0 1 1V5h-1zM154 2h1-1zM438 119zM316 14h1-1zM310 4h1-1zM128 10c-1 0-1 0 0 0zM370 64c1 0 1 0 0 0s-1 0 0 0zM91 34h-3c0-1 0-1 0 0l-1 1h-1s-1 0-1 1h-2 5c0-1 0-1 1-1h2v-1h1-1zM130 15h-1s1 1 1 0zM132 10h-1 1zM83 29h1v-1h2-2v1h1c0-1 1-1 1-1h1l1-1h3-3v-1h2c0-1 0-1-1 0h-5l-1 1h2-1 2-2v1h-2l1 1zM159 220c0-1-1 0-1 0h1zM122 191c1-1 0-1 0-1-1-1-1-1-1 0h1v1zM109 117v-1h-1s0 1 1 1zM284 81v1-1c1 0 0 0 0 0zM109 116zM268 7c0-1 0 0 0 0zM273 6V5h-1s0 1 1 1zM159 5h1V4h-1 1-1v1zM367 64s-1 0 0 0zM155 4h-1v1h1V4h1c1 0 1 0 0 0h-1zM239 42l-1 1h1v-1zM79 21h1c1-1 0-1-1 0zM317 3h-1v1h-1 1c1 0 1-1 1-1zM128 249c1 1 1 1 1 0h-1zM122 25s-1 0 0 0zM284 81c-1 0-1 0 0 0zM36 36zM131 21v-1 1zM349 22c1 0 1 1 1 1h1c-1-1-2-1-2-1zM305 100c-1 1 0 1 0 1v-1zM127 22v-1h-2v1l-1 1h-1c1 0 0 1 0 1-1-1-1 0 0 0h-1v1h1v-1h1c1-1 2-1 3-1 0-1 0-1-1-1 0 1 0 0 0 0h1zM92 134c1 1 1 1 0 1h1c1 0 1 0 0 0v-1c-1-1-1-1-1 0zM157 50h1-1c-1 0-1 0 0 0zM143 61h1-1zM327 60zM327 62zM285 80c1 0 1 0 0 0z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m335 75-1-1c-1-1-2-1-2 0 1 1 1 1 2 1v1h1v-1c1 0 0 0 0 0zM157 35c-1 0-1 0 0 0zM149 31v1s1 0 1-1h-1zM162 21h1-2 1zM151 22h1-1zM155 26c0-1-1 0-1 0 0 1 0 1 1 1v-1c1 0 1 0 0 0zM143 20h-1v1c1 0 1 0 1-1zM442 211v1-1zM319 124v1-1zM132 22c-1 0-1 1-1 1s1 0 1-1zM151 24h1-1zM303 66h2c1 0 1 0 1-1h1v-1h-1c1 0 1-1 1-1h1-3v1h-2l-1 1 1 1zM150 22zM155 17h1-1zM52 43h-1 1zM274 21h1-1zM264 30h-1v1h-1c1 0 2 0 2-1zM343 64h1-1zM330 28s0-1 1-1h1s1-1 2-1l2-2-2 2c-1 0-2 1-2 1h-1c-1 0-1 1-1 1zM25 39h1-1zM20 42zM264 47v1l1-1h-1zM283 19c-1 0 0 0 0 0zM340 53zM82 20h-1 1zM50 48v-1c0-1 0 0 0 0v1zM334 45h-1s-1 0-1 1c0-1 1-1 1-1h1s1 0 1-1c0 1-1 1-1 1zM74 22c1 0 1 0 1-1 1 0 1 0 0 0 0 0-1 0-1 1zM340 68v-1 1zM143 22v1-1zM325 55h4v-1h3c1 1 1 1 2 1h3s0 1 1 1h3s1 0 1-1c0 1-1 1-1 1h-3c-1 0-1-1-1-1h-3c-1 0-1-1-2-1h-3v1h-4s-1 0-1 1c0-1 1-1 1-1zM341 67c0 1 0 2 1 2s1 0 1-1v-2h-2 1v-1h-1v2zM255 52c1 0 0 0 0 0zM52 45h1-1zM338 51v-2 2zM51 45v1-1zM26 39h1-1zM487 235h-1 1zM52 44h-1 1zM50 50v1h1c0-1-1-1-1-1zM341 67c0 1 0 0 0 0v-1c-1 0-1 0 0 1zM327 60h-1 1zM135 24c1-1 0-1 0 0zM128 28h1c-1 0-1-1-1 0zM160 21c-1 0-1 0 0 0h1c1-1 2-1 2-1h-2s0 1-1 1zM161 20h-1 1zM120 24h1-1zM260 33h-1 1zM143 17v-1l1-1h1-2s0 1-1 1l1 1zM464 138zM465 136h-1 1zM138 20c1 0 0 0 0 0zM465 138v-1 1zM464 138v-1 1zM167 26h-1 1zM278 47c0 1 1 1 1 0h-1zM29 29c1 0 1 0 0 0v1-1zM159 19c-1 0-1 0 0 0s1 0 0 0zM142 17v-1 1c0 1 0 1 0 0zM455 175h-1 1zM364 65v1h1v-2h1-2v1zM105 111h1M136 92h1M131 64c1-1 1-2 1-3 0 0 0-1-1-1v-1h-1v5h1zM378 133l1-1v-4h-1v-1 1c-1 0-1 0-1 1v2c0 1 0 1 1 2zM103 63zM109 39l1-1v-4h-1v-1 1c-1 0-1 0-1 1v3c0 1 1 1 1 1zM375 123v-3l-1-1h-1v1c0 1 1 2 1 3v1l1-1zM365 111h-1 1zM109 30c1 0 1 0 1-1v-3c0-1 0-1-1-1s-1 1-1 1v4h1zM113 64h1v-5h-1c0 1-1 1-1 1v1h1c0 1-1 1 0 1h-1v1s0 1 1 1zM115 72h1v-3c0-1 1-1 1-1 0-1 0-1-1-1 0-1-1-1 0 0 0 0 0 1-1 1v4zM415 119h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM424 145h-2c1 1 1 1 1 0v2s0 1 1 1v1-4zM411 120v-1h-1s0 1-1 1h1l1 1v2-3zM112 70c0 1 0 2 1 2h1v-3c0 1-1 2-1 2v-1c0-1 0-1-1-1v1zM118 71l-1 1c0 1 0 1 1 1v-1c1 0 1-1 1-2h-1c-1 1-1 0 0 0l1-1-1-1h-1v3h1zM355 107zM407 115v-4h-1v-1l-1 1v3s1 1 1 2l1-1zM291 80v-3l-1-1h-2v1h1c0 1 0 1 1 1v2c0-1-1 0-1 0l1 1h1v-1zM306 89v-1s-1 1-1 2l1-1zM312 69h-1v1c0 1 0 1 1 1v-2zM329 127c-1 0-1 0-1 1v3c0-1 1-1 1-1h1c0-1-1-1-1-2v-1zM342 120v-1h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2 1 0 1-1 1-2v-2zM314 72v-2h-2c0 1 0 1 1 1 0 1 0 1 1 1v1-1zM306 85c-1 1-1 1 0 1v1-2zM118 64c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5h1zM341 107v-1 1zM338 102h-1c-1 0-1 0-1 1h1c0 1 0 1 1 1v-2zM351 106v-3c0-1 0-1-1-1s-1 1-1 1v4h2v-1zM333 98h1v-4l-1-1h-1v5h1zM349 114c0-1 1-1 1-2h-1v2zM329 94v-1h-1v5l1-1c1 0 1-1 1-1 0-1-1-2-1-2zM441 21v1c1 0 1 0 1-1s1-1 1-2v-1h-2l-1 1c0 1 1 2 1 2zM355 106v-4h-1s0 1-1 1v2s0 1 1 1v1h1v-1zM103 56v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM479 39h1v-5h-1c-1 0-1 0-1 1h1c1 0 0 1 0 2-1 0-1 0-1 1l1 1zM484 51h-1c1 0 1 0 1 1v-1zM492 34c-1 0-1 0-1 1v2l1-1c0-1 1-1 1-1v-1h-1zM476 34h-2v2h1v1h1v-3zM469 34l-1-1v1l-1 1v1c0 1 0 2 1 2v1h1v-5zM465 68h-1c-1 0-1 1-1 1v2c1 0 2-1 2-2v-1zM465 36v-2c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1h1v-3zM482 22h1c-1 0-1-1-1-1v1zM459 22c0-1 0-1 1-1h-2c0 1 0 1 1 1zM454 21v1h1v-2s-1-1-2-1c0 1 0 2 1 2zM445 21c0 1 0 1 1 1 0-1 1-1 1-1v-3h-2v3zM478 22h1v-1h-2l1 1zM461 69c0-1-1-1-1-1h-1v4-1h1c0-1 0-1 0 0h1v-2zM468 21zM493 26s0-1-1-1-1 1-1 1v4h1-1 2-1l1-1v-1l-1-1h-1 2v1-2zM455 98v-2 1h-1c1 0 1 1 1 1zM437 130c0 1 0 2 1 2v1h1v-2s-1 0-1-1v-2s-1 0-1 1v1zM432 139v-2c-1 0-1-1-1-1h-1v1h1v4h1v-2zM437 120h1v-1s0 1-1 1zM424 130v-2h-1s-1 0-1 1v2h1v1h1v-2zM431 155zM109 85c-1 0-1 1-1 1v4h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM421 139v2h2c0-1-1-2 0-2 0 0 0-1-1-1 0 1 0 1-1 1v-2 2zM447 85h-1v5h1c1 0 1 0 1-1v-1c-1-1-2-1-1-1v-2h1-1zM451 76h-1c-1 1-1 1-1 2h2v-2zM455 79v-3h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 0v-2zM458 81s0 1 1 1v-1h1l-1-1-1-1v2zM439 111c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1s0-1 0 0c1 0 1-1 1-1v-4z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M437 115c0 1 0 2 1 2h-2c-1 0-1 0 0 1h-1v2h1l1 1v-1s0-1 1-1v-1c1 0 0-1 0-1 1 0 1-1 1-1h-1s-1 0-1-1zm1 4zM451 94c-1 0-1 0-1 1v3l1 1h1v-5l-1-1v1zM431 157v-1h1l-1-1v2zM346 119h-1v1h1v-1zM313 133c1 0 1 0 1-1v-5h-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1zM317 145v4c0 1 0 1 1 1 0-1 1-1 1-1v-4h-1v-1s-1 0-1 1zM317 141l1-1v-3l-1-1h-1v5h1zM90 34v-1c-1 0-1 1-1 1h2-1zM322 145c-1 0-1 0-1 1v3l1 1h1v-5h-1v-1 1zM86 34s0-1-1-1v1l-1 1v1h1c0-1 1-1 1-1v-1zM321 141c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM97 56h1v-1 1h-1zM308 141h1v-5h-1c-1 0-1 1-1 1v4h1zM304 163v3c0 1 1 1 1 1l1-1v-4h-1v-1s0 1-1 1v1zM85 38v1h1v-3h-2c0 1 0 2 1 2zM94 30c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM98 64h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM310 69h-1l1 1v-1zM310 153h-1c-1 0-1 1-1 1v4h2v-5zM314 145c0-1 0-1-1-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-5zM88 27v-1 1zM305 182v-4 6-2zM150 47c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM302 187h-1v5s0 1 1 1v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM301 175c1-1 1-2 1-3 0 0 0-1-1-1v-1h-1v5h1zM296 170c0 1-1 1-1 1v2c0 1 0 1 1 2h1v-5h-1zM301 184v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM306 187h-1v5l1 1v-1h1v-4s0-1-1-1zM98 47h1v-5h-1l-1 1v2c0 1 0 1 1 2zM314 153h-1v1c-1 1-1 1-1 2s1 1 1 2h1v-5zM89 38c0 1 0 1 1 1v-1c1-1 1-1 1-2v-1h-2v3zM86 28h-2 2zM309 175h1v-5h-1l-1 1v4h1zM85 30h1v-2s-1 0-1 1h-1s1 0 1 1zM318 153h-1v5h1s1 0 1-1v-3l-1-1zM95 76c-1 1-1 1-1 2v3l1 1 1-1v-4l-1-1zM284 76h-1c1 0 1 1 1 1v-1zM297 63v-4h-1l-1 1v2s0 1 1 2h1v-1zM277 72h1v-4s-1 0-1-1l-1 1v4c0 1 0 1 1 1v-1zM275 77h1c0 1 0 1 0 0v-1h-1v1zM301 67c-1 0-1 0-1 1h1v-1zM270 81h-4c1 1 2 2 3 2s1 1 1 1c1 0 1-1 1-1v-2h-1zM272 80s1-1 1-2l-1-1v-1h-1v1s1 0 1 1v2s-1 0-1 1h1v-1zM327 77c-1 1-1 1-1 2s1 1 1 2v-3c0-1 0-1 1-1v-1h-1 1-1v1zM321 69v3l1 1h1v-3c0-1-1-2-1-2-1 0-1 0 0 0v-1 1c-1 0-1 0-1 1zM267 81h-1 1zM328 68h-1 1-1v1h1v-1zM314 68c0-1 0-1-1-1v2s-1 0-1 1h2v-2zM310 68l-1-1v1h-1l1 1h1v-1zM333 73c0-1 1-1 1-1v-4h-1v-1l-1 1v4c0 1 0 1 1 1zM329 76zM301 110h-1v5s0 1 1 1v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM301 98zM281 81h-1c0 1 1 1 1 0zM240 60h-1v1h1c0 1 0 1 0 0v-1zM99 76c0 1 0 1-1 2v1c0 1 0 1 1 2v1s1 0 1-1v-5h-1zM304 141s1 0 1-1v-3l-1-1h-1v5h1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M300 98v-4h-2v3c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-2-1-2v-1 2l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2h-1c-1 0-1 0-1-1h-2 1v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h1c-1 0-1-1-1-1h-1s0-1-1-1c0 0-2 0-3 1s-1 2-1 3c0-1 1-1 1-1v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-2-1-2v-1 1c0 1 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-3h-2v3h1-2v-5h-1 1c-1 0-1-1-1-1h-2c0-1-1-1-1-1h-3l-1-1h-1v-1h-1v-4c1 0 1 0 1-1h1v-1h-1l-1-1s-1 0-1 1h-6c0 1-1 1-1 0-1 0-1 0-4 1-2 0-4 0-4 1v4s0 1-1 1-1 0-2-1v-3c0 1-1 1-1 1s-1 0-1-1v4h-2 1v-4h-1c0 1-1 1-1 0v3c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-1 0 1-1 1-2 2h1-1c-1 1-3 2-3 2v1c-1 1-1 1-1 3v3h-1c-1 0-1 1-1 1-1 1-2 1-3 1 0 0-1 0-1 1 1 0 1 0 1-1v5s0 1 1 1h-2 1v-5h-1v1c-1 0-1 1-1 1-1 0-2 1-2 2v1h1-1c0 1-1 1-2 2 0 0 0 1-1 2 0 1 0 2-1 2v3h1v2s-1 1 0 1v4c-1 1-1 2-1 2 0 1-1 3-1 3h-1 1v1c1 0 1 1 1 1v4c1 0 1 1 1 0-1 0-1 0-1 1 1 1 1 1 1 0h1c-1 0-1-1-1-1 1 0 1 0 1 1v1h2c0 1 0 1 1 2 0 1 1 1 1 2v1h1v-5h-1 1v5h1-2v1s1 0 0 0c0 1 1 1 1 1 1 0 2 1 4 3v-1l1-1c1 0 1 0 2 1v3c1 1 2 1 2 1v-4s0-1 1-1v5s0-1 1-1h1v-3c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v1-1c0-1 1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v1c1-1 2-1 2-1v-2h-1c1 0 1-1 2-1v2h1s1 0 1-1c1 0 1 0 1-1h1s1 0 1 1h3c0 1 1 3 1 3s0 1 1 1v-4h-1c1-1 1-1 2-1v5h2v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2l-1 1h1c0 1 1 1 1 1s0 2-1 4h1c0 1-1 2-1 2v1c0 1 0 1-1 1v1c0 1 1 1 1 2l1 1v-1c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1 1 1 1 2 1 2v1s1 1 1 2c0 0 1 1 1 2v-4h-1 2v5h-1v1c-1 0-1 0 0 2 1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-2c0 1-1 2-1 2 0 2 0 4-1 4v2h1v1h-1c0 1 0 2 1 2v1s1 1 2 3v-3h-1c1 0 1 0 2-1v7c1 1 1 2 1 3v3s1 2 1 3c0 2 0 3 1 4v-2h-1c1 0 1 0 2-1v4s1 1 1 2c1 2 2 3 2 4 0-1 1-1 1-1v6h1-2s1 1 1 0c1 0 1 1 1 1 1 1 1 1 2 0h1c1 0 1 0 2-1h2-1 1v-5h-1c1 0 1-1 2-1v6h1-2 4c0-1 0-1 1-1h1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0-1 1-1 0 0 0-1 1-1h-1c1 0 1-1 1-1h1c0-1 2-3 2-3v-4c0-1 0-1 1-1h2v-2c-1 0 0-1 0-1l1-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2v-6h-1v-2c0-1 2-3 2-3h1-1 1v-1c1-1 2-2 3-2s1-1 1-1v-4s0-1 1-1h1l1 1v1c1 0 1 0 1-1v-6c0-3 0-3-1-4 0 0-1 0-1-1v-2h-1c0 1 0 1-1 1l-1-1v-4s0-1 1-1h1c0-1 1-3 1-3s1-2 1-3l1-1v-1l1-1v1c1 0 1-1 1-1 1-1 2-3 3-4v-4h-1 1v3c1-1 3-2 3-2l4-4h-2 1v-5h-1c1 0 1-1 2-1v6c1-1 1-1 1-2 0 0 1 0 1-1v-2s1 0 1-1l2-2v-3c0-1 0-2 1-2v-1h1c-1-1-1-1 0-2 0 0-1-1-2 0 0 0-2 1-3 1h-2s-1 0-1 1h1v4c0 1 0 1-1 1 0 0 0 1-1 1 0-1-1-1-1-1v-4c0-1 0-1 1-1h-2c-1 1-2 1-3-1 0 0-1 0-1-1 1 0 1-1 1-1h-1v-1c-1-1-1-2-2-2l-1-1v4h1-2v-5c-1 0-1-1-1-1 0 1 0 0 0 0-1 0 0-1 0-1h-1c0 1 0 1 0 0-1 0-1-1-1-1v-1h-1s-1 0-1-1v-3c-1 0-2-1-2-3v-1h-2s1 0 1-1v-2l-1-1c-1-1-2-2-1-2v-1s-1-1-1-2h-2c1 0 1-1 1-1v-1h-1v-2l-1-1s0-1-1-2l-1-1h-1v-1zm-81 12v5c0 1 1 1 1 1h-2v-5c0-1 1-1 1-1zm1 22v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm0-9v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2s0 2-1 2zm8-22v6h-2 1v-5h-1c1 0 1 0 2-1zm-6 10v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2zm1 8h-1s1 0 1-1v5c0 1 0 1 1 1h-2 1v-5zm1 14h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 0-1 1zm4 7c0 1-1 1-1 1h-2c0-1-1-2-1-2 0-1 1-2 1-2 0-1 0-1 1-1h2v4zm1-8-1 1h-1s-1 0-1-1v-4s0-1 1-1 1 0 2 1v4zm0-9s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm0-9c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1 1 0 2 1v3zm12-21v6h-2v-1h1v-5s-1 0-1 1v-1h2zm0 8v6h-2 1v-5h-1c1 0 1 0 2-1zm0 9v6h-2c1 0 1-1 1-1v-4h-1c1-1 1-1 2-1zm-11-16 1-1h2c0 1 1 2 1 3l-1 1v1l-1 1c-1 0-1-1-2-1v-4zm1 17c0-1 0-1 1-1v5l1 1h-2v-5zm0-4v-5l1-1v6h1-2zm-1 13c0-1 1-1 1-1s0-1 1-1l1 1c0 1 1 1 1 2s-1 2-1 2v1h-1c-1 0-1 0-2-1v-3zm2 21h-2v-5h-1 2v5h1zm1-8h-2v-5c0-1 0-1 1-1v6h1zm3 7v1h-1c-1 0-1 0-1-1-1 0-1-1-1-1v-2l1-1h2c1 1 1 1 1 2s0 2-1 2zm1-7h-2c1 0 1-1 1-1v-4h-1c0-1 1-1 1-1v5s0 1 1 1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm0-8h-2v-1h1v-4h-1c0-1 1-1 1-1v5h1v1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm0-9c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1zm4 42c0 1-1 1-1 1h-1s-1 0-1-1l-1-1c0-1 0-2 1-2v-1h2c1 1 1 1 1 2v2zm0-7h-2 1v-5h-1c1-1 1-1 2-1v6zm1-10-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm1-29 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1-1 0-2-1v-3zm0 8 1-1h1l1 1v3c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-3zm2 21h-3 1v-5h-1 2v5h1zm1-8h-2v-5h-1c1-1 1-1 2-1v6h1zm3 7v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1s1 0 1-1l1 1c0 1 1 1 1 2s0 2-1 2zm1-7h-2c0-1 1-1 1-1v-4h-1c0-1 1-1 1-1v6h1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm0-10v1l-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm0-8v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm0-9v1l-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm0-8v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm6-5v6h-2 1v-5h-1c1 0 1-1 2-1zm0 56c0 1-1 1-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm1-8s-1 0-1 1h-1s-1 0-1-1v-4s0-1 1-1 1 0 2 1v4zm-1-8h-2 1v-5h-1c1 0 1 0 2-1v6zm1-10c0 1-1 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm0-8-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 0 2 1v4zm0-9c0 1-1 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm3 44h-2v-5h-1c1 0 1 0 2-1v6h1zm1-9-1 1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2 0 0-1 1-1 2zm-1-34h1v1h-2v-6h1v5zm0 3v6h1-2v-5s0-1 1-1zm0 9v5h1v1h-2v-6 1-1h1zm0 8v6h1-2v-5l1-1zm1-29s0 1-1 1-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2zm25 12v6h1-3 1v-5h-1c1 0 1-1 2-1zm-2 10s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm0 9c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1h1l1 1v4l-1 1h-1s-1 0-1-1v-4zm1 51h-1c1 0 1 0 2-1v6h1-3 1v-5zm-1-3v-1h1v-5l-1 1v-1h2v5h1v1h-3zm2-9h-1s-1 0-1-1v-4l1-1h1l1 1v4s0 1-1 1zm0-18v1h1-3 1v-5h-1c1-1 1-1 2-1v5zm0 4v5h1-3 1v-5h-1 2zm-1-18v6h1-3 1v-5h-1c1 0 1 0 2-1zm-5-32v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm1 16h-1c1 0 1 0 1-1h1v6h-2 1v-5zm-1-3v-1h1v-5c-1 0-1 1-1 1v-1h2v6h-2zm0 12v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2zm2 73h-2 1v-5h-1c1 0 1 0 1-1h1v6zm-1-22h-1c1 0 1-1 1-1h1v6h-2 1v-5zm1-4c0 1-1 1-1 1l-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1zm0-8h-2 1v-5h-1c1 0 1-1 1-1h1v6zm1-10c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm-1-8v1h-2 1v-5h-1l1-1h1v5zm-2-14v5c0 1 1 1 1 1h-2 1v-5h-1s1 0 1-1zm-3-34v6h1-2 1v-5h-1l1-1zm-2 10c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm0 9 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0 1-1 2v1h-1c-1 0-1 0-2-1v-4zm2 51h-1l1-1v6h1-2 1v-5zm-1-3v-1h1v-4l-1-1v1-1h1v5h1v1h-2zm0-9h1v-5h-1l1-1v6h1-2zm0-9h1v-4c0-1-1-1-1-1h1v5h1-2zm0-8 1-1v-4h-1c0-1 1-1 1-1v6h1-2zm-3-49v6h1-2v-5h-1c1 0 1-1 2-1zm-2 10s0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 9c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-3zm3 54c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h2v4zm0 7v2s0 1-1 1-1 0-2-1v-3c0-1 0-1 1-1 0-1 0-1 1-1l1 1v2zm-1-14h1-2v-5h-1c1 0 1-1 2-1v6zm1-10c0 1 0 1-1 1h-2v-4c0-1 0-1 1-1h2v4zm0-8-1 1c-1 0-1 0-2-1v-4l1-1h1l1 1v4zm-2-21h-1c1-1 1-1 2-1v5c0 1 0 1 1 1h-2v-5zm-5-34s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1s0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-2 1-2zm1 8h-1c1 0 1-1 2-1v6h-2 1v-5zm-1 9s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm0 9c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1zm0 8s0-1 1-1 1 0 1 1c1 0 1 1 1 2v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm2 17c1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2l1-1c1 0 1 0 1 1zm-7-51c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2zm2 25h-1s1 0 1-1v6h1-2 1v-5zm-1-3v-1h1v-4l-1-1v1-1h1v5h1v1h-2zm0-9h1v-5h-1l1-1v6h1-2zm-1 21c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zm0 13h1v-5h-1s1 0 1-1v6h1-2zm3 17h-2 1v-5h-1 1v5h1zm1-9c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm0-9s-1-1-1-2c0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1zm3 27h-2 1v-5h-1c1 0 1-1 2-1v6zm1-10c0 1-1 1-1 1h-2c0-1-1-2-1-2 0-1 1-2 1-2 0-1 0-1 1-1h1c1 1 1 2 1 2v2zm0 36h-2v-1h1v-5l-1 1v-1h2v6zm0-53v-3c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4c0 1 0 1-1 1h-1s-1 0-1-1zm4 70h-2v-5h-1c1-1 1-1 2-1v6h1zm0-10s0 1-1 1-1 0-2-1v-3c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm1-7h-2v-6 1-1h1v5h1v1zm-1-53v-3c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1zm4 78h-2 1v-5h-1s1 0 1-1v6h1zm0-8h-2c0-1 0-1 1-1v-4h-1c0-1 1-1 1-1v6h1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm1-9-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1zm3 35h-2 1v-5h-1l1-1h1v6zm1-10c0 1-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2zm0-8s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-17c0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1zm4 25c0 1 0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1h2v4zm0-8-1 1h-1s-1 0-1-1v-4s0-1 1-1 1 0 2 1v4zm0-9s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm1-7h-2v-5h-1c1-1 1-1 2-1v5l1 1zm26-15v6h1-3 1v-5h-1c1 0 1 0 2-1zm16-41c0-1 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4zm-31-9s0-1 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm0-7v-1c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-2zm1 41h-1c1 0 1-1 2-1v6h1-2v-5zm0-4v-5h-1 2v5h1-2zm1-8c-1 0-1 0-2-1v-4l1-1h1l1 1v4l-1 1zm-3-13c0-1 0-1 1-1h2v4c0 1 0 1-1 1h-1s-1 0-1-1v-3zm0 10v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2zm-2 7v-1h-1 2v5h-2 1v-4zm0-53h1v6h-2 1v-5h-1c1 0 1 0 1-1zm0 9h1v6h-2c0-1 1-1 1-1v-4h-1l1-1zm0 8h1v6h-2 1v-5h-1c1 0 1 0 1-1zm0 9h1v6h-2 1v-5h-1l1-1zm-6-24 1-1c0-1 1-1 1-1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 8c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v1l-1 1-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2zm0 9 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 8c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zm2 30h1-2 1v-4c0-1 0-1-1-1h1v5zm0 3v6h1-2 1v-5h-1l1-1zm0 9v5h1v1h-2v-1h1v-4l-1-1v1-1h1zm-1 9c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1zm3-30c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm-5-9v-3l1-1h2c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1zm4 77v1h-1c-1 0-1 0-1-1-1 0-1-1-1-1v-2l1-1h2c1 1 1 1 1 2s0 2-1 2zm-1-8s0 1 1 1h-2l1-1v-4h-1c0-1 1-1 1-1v5zm2-9c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2zm0-7h-2v-1h1v-4h-1c0-1 1-1 1-1v5h1v1zm0-53c-1 0-1-1-1-1 0-1 0-2 1-2v-1h2c1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1zm3 78h-2 1v-5h-1 2v5zm1-9s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-9-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2zm-4-19 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2zm4 12h-2c1 0 1-1 1-1v-4h-1c1-1 1-1 2-1v6zm1-19c-1 0-1-1-1-1v-1 2c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2v-1h2v-3h-2 1v-5h-1c1 0 1-1 1-1h1v7h1c-1 1 0 1 0 1v1h-1l1 1 1 1v-1s0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1 0-1-1h-1v-1zm0 7v-1c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-2zm3 29h-2v-5h-1c1-1 1-1 2-1v6h1zm0-9h-2v-5h-1c1 0 1 0 2-1v6h1zm1-10c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4l1-1h1l1 1v3zm3 10h-2c1 0 1 0 1-1v-4h-1s1 0 1-1v6h1zm-1-26h1v1h-2v-1h1v-4h-1v-1 1-1h1v5zm0 3c0-1 0-1 1 0v3c1 0 1 1 0 1v4h1-1v1-3h-2c1 0 1-1 1-1v-4h-1s1 0 1-1zm2 13v1l-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0 1-1 1zm1-16c-1-1-1-1-1-2s0-1 1-2v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1zm2-8h-2 1v-5h-1l1-1h1v6zm-1 12h-1s1 0 1-1h1v6h-2 1v-5zm6-12h-3 1v-5h-1c1 0 1-1 2-1v6h1zm0-10c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm0-8s0 1-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4zm4 8v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm4-12c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1zm-4-8 1-1h2c1 1 1 2 1 2v2l-1 1h-2c-1-1-1-2-1-2v-2zm0 8s1 1 1 2 0 1-1 2v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1zm-3-9h2c0 1 1 2 1 2 0 1-1 2-1 2v1h-3v-4c0-1 1-1 1-1zm-4-8s0-1 1-1 1 0 2 1v4l-1 1h-1s-1 0-1-1v-4zm1 8v5h-2 1v-5h-1 2zm-2 57h-2s1 0 1-1v-4h-1l1-1h1v6zm0-37v1c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3zm-1-6h-2 1v-5h-1l1-1h1v6zm-1-32h1v6h-2 1v-5h-1s1 0 1-1zm0 9h1v6h-2 1v-5h-1c0-1 1-1 1-1zm-2 10v-1h2c1 1 1 2 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-1 0-1 0-2 1-2zm0 27c0 1 0 1-1 2v1h-1c-1 0-1 0-2-1v-3h-1c-1 0-1 0-1-2 0-3 1-3 1-3h2c0-1 0-1 1 0v-4l-1-1h1v5h1-1v3h-1 1s1 0 1 1c0 0 1 1 1 2zm-2-14h1-2l1-1v-4h-1l1-1v6zm0-40v5c1 0 1 1 1 1h-2v-1h1v-4h-1c0-1 1-1 1-1zm0 8v6h1-2c1 0 1 0 1-1v-4h-1s1 0 1-1zm0 9v6h1-2v-1h1v-4h-1c0-1 1-1 1-1zm-2 9h2c0 1 1 2 1 2 0 1 0 2-1 2v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1zm-1-23v1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h1l1 1v2zm-1-12v6h1-2v-5h-1c1 0 1 0 2-1zM244 64v-5c0 1 0 1-1 1 0 0-1 0-1-1h-1v4c1 0 1-1 1-1-1 0 0 0 1 1v1h1zM265 70v-2l-1-1-1 1v3h1v1h1v-2zM256 68v-1h-1v1l-1 1v1c1 0 1 1 1 1h1v-3zM236 84s0 1-1 1h2-1v-1zM244 72s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4zM260 67c-1 0-1 0-1 1v1h1v-1h1-1v-1zM231 80c1 0 1-1 1-2 0 0 0-1-1-1v-1c0 1 0 2-1 2v2h1v1-1zM235 72c0 1 1 1 1 1l1-1v-2h-2v2zM232 73c0-1 0-1 1-1v-2h-1c-1 0-1 1-1 2v1h1zM422 82s0-1 1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM410 52h-1v1c0 1 0 2 1 2v1h1v-5c0 1 0 1-1 1zM407 51h-1v-1s0 1-1 1v4c0 1 1 1 1 1 1 0 1-1 1-1v-1c-1 0-1 0 0 0v-3zM415 111v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2zM411 93h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1s1 0 1-1v-5zM415 102h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM411 85h-1l-1 1v2s0 1 1 1v1h1v-5zM411 68h-1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-5zM447 73c1 0 1-1 1-1v-3c0-1-1-1-1-1h-1v4c0 1 1 1 1 1zM424 102h-1l-1 1v4h2v-5zM424 93h-1v1s-1 0-1 1v3c1 0 1 1 1 1s1 0 1-1v-5zM419 119h-1v5h1c1 0 1 0 1-1v-3c0-1-1-1-1-1zM77 85h-1v5h1l1-1v-3l-1-1zM424 119h-1l-1 1v4h2v-5zM419 93l-1 1v4l1 1v-1h1v-4s-1 0-1-1zM419 85h-1v4c0 1 1 1 1 1 1 0 1 0 1-1v-3c0-1-1-1-1-1zM424 85h-1l-1 1v3l1 1h1v-5zM438 39h1v-5c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1zM438 47h1v-5h-1l-1 1v2c0 1 0 1 1 2zM81 85c-1 0-1 1-1 1v4h2v-4c0-1 0-1-1-1zM443 30v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM438 56h1v-5h-1s-1 0-1 1v1c0 1 0 2 1 2v1zM443 73v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM413 19v2s0 1 1 1v-1c0-1 1-1 1-2v-1c-1 0-2 0-2-1v2zM406 68h-1v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM411 111c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-5zM438 73h1v-5h-1l-1 1v1c0 1 0 2 1 2v1zM410 81v-5h-1c0 1-1 1-1 2v3c1 0 1 1 1 1l1-1zM402 68h-1v4c0 1 0 1 1 1 0 0 0-1 1-1v-4h-1zM402 93s-1 0-1 1v4s0 1 1 1v-1h1v-4c-1 0-1 0-1-1zM81 94v-1 1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1v-5h-1zM437 82l1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM411 59h-1c0 1-1 1-1 1v2c0 1 0 1 1 2h1v-5zM126 64h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM126 30h1v-5h-1l-1 1v2s0 1 1 2zM154 30h1v-4 1c-1 0-1 0-1-1 0 0 1-1 1 0v-1h-1l-1 1v4h1zM89 30h1v-1c1 0 1-1 1-2h-2v3zM428 128h-1v1l-1 1c0 1 1 2 1 2 0 1 0 1 1 1v-1s1-1 1-2-1-1-1-2zM113 30h1v-5h-1l-1 1v2s0 1 1 2zM118 30v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM135 64h1v-4l-1-1h-1v5h1zM415 39v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1zM146 47v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM150 56l1-1v-4h-1v-1s0 1-1 1v4c0 1 1 1 1 1zM427 25v1c0 1-1 1-1 2 0 0 1 1 1 2h1v-1s1-1 1-2l-1-1v-1h-1zM419 39l1-1v-4h-1v-1l-1 1v4c0 1 1 1 1 1zM419 30c1 0 1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM418 82v-1h1v-4l-1-1h-1v5s0 1 1 1zM423 64h1v-5h-1c0 1-1 1-1 1v4h1zM428 47v-1s1-1 1-2l-1-1v-1h-1v1c0 1-1 1-1 2s1 1 1 2h1zM428 93c-1 0-1 0-1 1v1l-1 1c0 1 1 2 1 2s0 1 1 1v-1c0-1 1-1 1-2s-1-1-1-2v-1zM428 39v-1c0-1 1-1 1-2s-1-1-1-2v-1c-1 0-1 0-1 1v1l-1 1c0 1 1 2 1 2 0 1 0 1 1 1zM428 102h-1v1c0 1-1 1-1 2 0 0 1 1 1 2h1v-1s1-1 1-2l-1-1v-1zM428 56v-1s1-1 1-2-1-1-1-2h-1v1l-1 1c0 1 1 2 1 2 0 1 0 1 1 1zM77 94v-1s-1 0-1 1v4c0 1 0 1 1 1 0-1 0-1 1-1v-4h-1zM428 111v-1c-1 0-1 1-1 1v1l-1 1c0 1 1 2 1 2 0 1 0 1 1 1v-1c0-1 1-1 1-2s-1-1-1-2zM432 42h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM432 51h-1v4c0 1 0 1 1 1l1-1v-4h-1zM431 25v5h1s1 0 1-1v-3c0-1-1-1-1-1h-1zM428 64c0-1 1-2 1-2 0-1-1-2-1-2v-1h-1v1c0 1-1 1-1 2s1 1 1 2h1zM432 34v-1s-1 0-1 1v4c0 1 0 1 1 1 0-1 1-1 1-1v-4h-1zM432 85h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM431 81h1v-4c-1 0-1-1-1-1h-1v5s0 1 1 1v-1zM432 102h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM439 93h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-6zM260 46c1 0 1-1 1-2v-1c-1 0-2 3-1 4v-1zM264 30c1 0 1-1 1-1v-1c0 1-1 1-1 1h-1 1l-1 1h1zM318 102h-1v4c0 1 0 1 1 1l1-1v-4h-1zM296 76h-1c-1 0-1 1-1 1v4h2v-5zM297 25h-1s-1 0-1 1h1l1 1v-2zM278 21c1 0 1 0 1-1v-1h-1l-1 1v1h1zM282 21h1v-3h-1c0 1 0 1-1 0v1c0 1 0 1 1 2zm1-2s-1 0 0 0zM317 81l1-1v-3l-1-1h-1v5h1zM300 76h-1v1c-1 1-1 1-1 2s1 1 1 2h1v-5zM313 81v-5h-1s0 1-1 1v2c0 1 0 1 1 2h1zM296 29v1h1s-1 0-1-1v-1c0-1 0-1-1-1 0 1 0 2 1 2zM310 85c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1h1v-5zM310 93h-1l-1 1v4h2v-5zM304 76h-1v5h1s1 0 1-1v-3l-1-1zM309 81v-5h-1c-1 0-1 1-1 1v4h2zM254 53c0 1 0 1 1 2v1l1-1v-5c-1 0-1 0-1 1l-1 1v1zm1-1s1 0 0 0zM369 12v1h1V8h-1s-1 1 0 1c0 1 0 1-1 1 0 1 0 2 1 2zM373 10v2c0 1 0 1 1 1 0 0 0-1 1-1V9c-1 0-1 0-1-1h-1v2zM364 12l1 1h1v-3h-2v2zM382 12v1h1v-3s0-1-2-1v1c0 1 0 2 1 2zM387 13h-1 1zM377 12c0 1 1 1 1 1 1 0 1-1 1-1V9h-2v3zM354 13h1v-1h-1v1-1 1zM350 19v2h2v-4h-2v2zM345 29c0 1 0 1 1 1 0 0 0-1 1-1v-3h-1c0 1-1 1-1 0v3zM351 16h1-1zM330 21c-1 0-1-1-1-1v1h1zM342 21h1v-1l-1-1v-1l-1 1c0 1 1 1 1 2zM300 30v-1c-1-1-1-1-1 0-1 0-1 1 0 1h1zM346 17h-1c1 0 1 1 2 1 0-1-1-1-1-1zM343 17h-1v1h1c0 1 0 1 1 1 0-1-1-2-1-2zM103 85h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM464 30h1v-5h-1c-1 0-1 1-1 1v4h1zM460 39l1-1v-4h-1v-1l-1 1v4c0 1 0 1 1 1zM451 30h1v-5h-1c-1 0-1 1-1 1v4h1zM475 30s1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM455 65c1 0 1-1 1-1 0-1 1-2 1-2 0-1-1-2-1-2v-1h-1v1c0 1-1 1-1 2s1 1 1 2v1zM488 30s1 0 1-1v-3l-1-1h-1v5h1zM90 85h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM321 81c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM447 30c1 0 1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM451 73h1v-5h-1c-1 0-1 1-1 1v3l1 1zM447 39l1-1v-4h-1v-1s0 1-1 1v4c0 1 1 1 1 1zM451 65s0-1 1-1v-5h-1l-1 1v4c1 0 1 1 1 1zM451 39h1v-5c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1zM455 56h1v-1s1-1 1-2-1-1-1-2h-1v1l-1 1c0 1 1 2 1 2v1zM86 42h-1c0 1 0 1-1 1v2c0 1 0 1 1 2h1v-5zM451 56h1v-5h-1c-1 0-1 0-1 1v3l1 1zM90 42h-1v5h1c1-1 1-2 1-3 0 0 0-1-1-1v-1zM329 85h-1v4c0 1 0 1 1 1v-1s1-1 1-2-1-1-1-2zM337 124h1v-5h-1c-1 0-1 1-1 1v4h1zM447 107c1 0 1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM346 116v-1h1v-4c-1 0-1 0-1-1h-1v5s0 1 1 1zM109 68c-1 0-1 0-1 1v3c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM337 116l1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM85 73h1v-5h-1s0 1-1 1v2s0 1 1 1v1zM460 56l1-1v-4h-2v4c0 1 0 1 1 1zM90 65v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5s0 1 1 1zM460 65v-1h1v-4l-1-1h-1v5s0 1 1 1zM443 107v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM90 73v-1c1 0 1-1 1-2s0-1-1-1v-1h-1v4c0 1 0 1 1 1zM443 99v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1zM443 90v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM90 25h-1v1c1-1 1-1 1 0h-1v1h2c0-1 0-1-1-1v-1zM111 108v-1c-1 0 0 1 0 1h-1 1c0 1 0 0 0 0zM111 109c0-1 0 0 0 0zM108 95zM114 110h1-1zM107 107v-1 1zM135 120v1-1zM133 120s0-1 0 0zM108 100zM111 110l1-1h-1v-1 2zM111 103v1s1 0 1-1c0 1-1 0-1 0zM110 112h-1 1zM115 110z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M223 116s0-1 1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM108 102v-1 1zM110 112zM135 121zM125 133v-1 1zM121 113v1-1zM121 113zM120 113zM135 122c1 0 1 0 1 1 0-1 0-1-1-1zM130 135zM124 133v-1 1zM132 135h1-1c-1 0 0 0 0 0zM131 121zM137 133s-1 0 0 0zM125 121h1-1zM132 120zM219 119h-1v4c0 1 0 1 1 1 0 0 1 0 1-1v-3l-1-1zM128 120v1h2v-1h-2zM138 128zM132 122v-1 1zM108 115c0 1 1 1 1 1l1-1v-1c-1 0-1-1-1-1s-1 0-1-1v3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M106 114c1 0 1 0 1 1v1h1v1c0 1 5 1 6 0h1l-1-1h-2c0-1 0-1-1-1s-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2s0-1-1-1c0 0-1-1-3-1v2s1 1 2 1h1zm2 2h1v1c-1 0-1-1-1-1zM232 98h1v-4c-1 0-1-1-1-1h-1v5h1zM232 124l1-1v-3l-1-1h-1v4c0 1 0 1 1 1zM228 110h-1c0 1 0 1-1 2v1c0 1 0 1 1 2v1c1 0 1-1 1-1v-5zM117 112v-1 1zM106 111h1-1zM105 108v-1 1zM236 93h-1v5h2v-4s0-1-1-1zM102 111h-3v2c1-1 1-1 2-1h1c-1 0-1 0-1 1h1v-2zM101 114h1v-1h-1s1 1 0 1zM171 166v1h1v-4l-1 1h-1c0 1 1 2 1 2zM104 118zM235 136h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM98 112h-1v1c-1 0-1 0 0 0-1 0-1 1 0 1h1v-2zM113 104v1-1zM114 108v-1 1zM224 127h-1v1c-1 0-1 0-1 1v3c1 0 1 1 1 1l1-1v-5zM115 108v1c1 0 0-1 0-1zM113 104c0-1-1-1-1-1s1 0 1 1zM116 111c0-1 0-1-1-1 0 0 1 1 0 1h1zM114 106v1-1zM112 107zM118 115h-1 1c1 0 1 0 1-1l-1 1zM119 117zM228 127h-1v1l-1 1v1c0 1 0 2 1 2v1c1 0 1 0 1-1v-5zM117 109zM118 112c-1-1-1 0 0 0-1 0-1 0-1 1 0-1 1-1 1-1zM116 110c0-1 0-1 0 0zM227 136h-1l-1 1v2s0 1 1 2h1v-5zM228 119h-1s0 1-1 1v2s0 1 1 1v1h1v-5zM77 303c0 1 0 0-1 1h1l1-1h-1zM167 309s1-1 0-1h-1v1h1zM176 302c-1-1-1 0-1 0h1zM342 294zM175 303l1-1h-1v1zM231 299s-1 0-1 1c1 0 1-1 1 0h-1 1v-1zM337 294h-1v1c0-1 1-1 1-1zM297 292v1-1zM218 309h1v-1c-1 0-1 0-1 1zM168 287h-1 1zM127 299h-2c1 0 1 1 1 1h1v-1zM79 303h1-1zM145 298v1-1zM168 284h2-1c1 0 0-1 0-1h1v-1h-1s0 1-1 1v1zM162 292c0 1 0 1 1 1v-1h-1zM171 282s0 1 1 0h-1zM338 291v-1h-1c-1 0-1 1-1 1v3s0-1 1-1c1 1 1 0 1 0v-2zM79 303h-1v1h2c-1 0-1 0-1-1zM338 290c1 1 1 2 1 2h1s-1 0-1-1h1v-1h1-3zM341 295h1v-1s0 1-1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m337 295 1-1h-1s0 1-1 1h1zM285 295h1v-2c0 1 0 1-1 1v1zM301 295v-1c1 0 1-1 1-2v-1l-1 1c0 1-1 1-1 1v2h1zM292 295c1 0 1 0 1-1v-3 1c-1 0-1 0-1 1h-1v2h1zM354 295h1v-5h-1s0 1-1 1v2c0 1 0 1 1 2zM427 287h1-1zM446 293v2l1 1v-1h1v-3h-1v-1c-1 0-1 0-1 1v1zM450 295c1 0 1 1 1 1s0-1 1-1v-3h-2v3zM455 296c1 0 1 0 1-1v-1h-1 1-1v2zM346 295l1-1v-1h-2v2h1zM335 137h1v-1c-1 0-1 1-1 1zM327 137c-1 1-1 1-1 2 0 0 1 1 1 2h1v-5h-1v1zM94 116h1-1zM138 128v-1 1zM95 116zM137 125l1-1c-1 0-1 1-1 1zM83 158zM158 262c0-1-1-1-1-1h-3v1c-1 0-1 1 0 1s1 0 1-1h1v1h2c1-1 1-1 0-1zM85 160c0-1 0 0 0 0zM137 123zM219 127s-1 0-1 1v4s0 1 1 1v-1h1v-4c-1 0-1 0-1-1zM138 129v1-1zM86 159c1 0 1 0 1-1l-1 1zM138 125zM241 119h-1l-1 1v2s0 1 1 1v1h1v-5zM137 122zM138 135v-1 1zM138 127v-1c-1 0 0 0 0 1zM138 124c0 1 0 1 0 0zM87 311zM426 312v-1h-1c1 0 1 1 1 1zM310 115v1-2 1zM85 310v1h2v-1h-2zM313 123v1h1c-1-2-1-2-2-3v1l1 1zM426 311h1-2 1zM83 310c0 1 0 1 1 1v-1h-1zM85 158l-1-1c0 1 1 1 1 1zM83 157v1h1c-1 0-1 1-1 1h1v-1l-1-1zM85 156v1-1zM85 159v-1 1zM25 42l-1 1h1l1-1h-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M27 40s0 1-1 1-1 0-1 1h-2s-1 0-2 1v1h2v-1h1v-1h2v-1h1c0 1 0 0 0 0v-1zM429 309h-1 1zM305 107h1c-1 0-1 0-1-1v1zM292 107c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM273 196h-1v4c0 1 0 1 1 1v-1c1 0 1-1 1-2s0-1-1-2zM66 102h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM272 141v-1s1-1 1-2l-1-1v-1h-1v1c0 1-1 1-1 2l1 1v1h1zM62 85h-1v5h1l1-1v-3l-1-1zM268 141v-5h-1c-1 0-1 1-1 1v3l1 1h1zM269 153h-1l-1 1v2s0 1 1 2h1v-5zM72 47h1v-5h-1v1c-1 1-1 1-1 2s1 1 1 2zM72 90h1v-5h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2zM283 187h-1c0 1-1 1-1 1v2c0 1 0 1 1 2h1v-5zM286 213h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2h1v-1s1-1 1-2l-1-1v-1zM282 204h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1l1-1v-5zM72 73h1v-5h-1v1c-1 1-1 1-1 2l1 1v1zM278 187h-1v5h2v-4s0-1-1-1zM282 213h-1c-1 0-1 1-1 1v4h2v-5zM72 65c1 0 1-1 1-1v-5h-1v2c-1 0-1 1-1 1 0 1 1 1 1 2v1zM276 141s1 0 1-1v-3c0-1-1-1-1-1h-1v4c0 1 0 1 1 1zM268 98h1v-5h-1l-1 1v2c0 1 0 1 1 2zM268 115h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM66 39c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM62 77v4s0 1 1 1v-1h1v-4c-1 0-1 0-1-1 0 0-1 0-1 1zM66 56c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM268 124h1v-5h-1s-1 0-1 1v1c0 1 0 2 1 2v1zM273 144c-1 0-1 0-1 1v4s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1zM264 144l-1 1v4l1 1v-1h1v-4l-1-1zM66 30c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM66 85h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM66 94v-1l-1 1v4c0 1 1 1 1 1l1-1v-4h-1zM264 133v-1h1v-4s0-1-1-1h-1v5l1 1zM264 98c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM268 133l1-1v-5h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1zM268 145s-1 0-1 1v1c0 1 0 2 1 2v1s1 0 1-1v-5h-1v1zM81 56h1v-5h-1c-1 0-1 0-1 1v3c0 1 1 1 1 1zM292 184c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM81 39h1v-5h-1v-1 1c-1 0-1 0-1 1v3c0 1 1 1 1 1zM292 144l-1 1v4c0 1 1 1 1 1l1-1v-4l-1-1zM85 27h1-2 1-1 1zM292 133v-1h1v-4s0-1-1-1h-1v5l1 1zM72 30h1v-5h-1v1c-1 1-1 1-1 2s1 1 1 2zM292 124c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM297 196h-1l-1 1v2s0 1 1 1v1h1v-5zM297 204h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1s1 0 1-1v-5zM291 141s1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM296 184h1v-5h-1s-1 0-1 1v1c0 1 0 2 1 2v1zM86 25h-1s0 1-1 1h2v-1zM292 213h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM292 196h-1v4c0 1 1 1 1 1 1 0 1-1 1-1v-3c0-1 0-1-1-1zM296 141v-5h-1c-1 0-1 1-1 1v4h2zM292 115h1v-4s0-1-1-1h-1v5h1zM77 56s0-1 1-1v-4h-2v4c0 1 0 1 1 1zM77 47h1v-4c-1 0-1-1-1-1h-1v5h1zM332 141l1-1v-3l-1-1h-1v5h1zM286 196h-1v1c0 1-1 1-1 1 0 1 1 2 1 2v1h1v-1s1-1 1-2-1-1-1-2zM77 39s0-1 1-1v-4h-1v-1l-1 1v4c0 1 0 1 1 1zM286 204h-1v2l-1 1c0 1 1 1 1 2v1c1 0 1 0 1-1s1-1 1-2-1-2-1-2v-1zM73 77v4s0 1 1 1v-1c0-1 1-1 1-2s-1-1-1-2v-1c-1 0-1 0-1 1zM299 141h1v-5h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2zM273 153h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM297 144h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-6zM81 73h1v-4c0-1 0-1-1-1s-1 1-1 1v3c0 1 1 1 1 1zM301 145v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2zM301 124v-1c1 0 1-1 1-2s0-1-1-1v-1h-1v4c0 1 0 1 1 1zM301 133v-1c1-1 1-1 1-2s0-1-1-2v-1h-1v5s0 1 1 1zM77 77v4s0 1 1 1v-1h1v-4s-1 0-1-1c0 0-1 0-1 1zM137 140h1-1zM138 139z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M31 23c1 1 1 1 1 2 0 0 1 0 0 1l-1 1h-1v3h1v1h-3v-1h1v-4h-1s-1 0-1 1v2c0 1-1 1-1 1h1c1 0 1-1 1 0 0 0-1 1-2 1h-2c0 1-1 1-2 1s-2 0-3 1h-1l-1 1h1v4s0 1-1 1h-2l-1 1c-1 0-1 0 0 1 1-1 1-1 1 0-1 0 0 0 1-1 0 0 1 0 1 1h1c0-1 1-1 1 0 1 0 1 0 0 1h-2s1 0 1 1v1-1h2c0-1 1-1 1-1h2l1-1h2s1-1 0-1c0-1 0-1 1-1h2v-5h-1c1 0 1 0 2-1v5c1-1 2-1 2 0h-1c0 1-1 1-1 1h1-2c0 1 2 1 3 0h2c0-1 1-1 2-1v-4h-1s1 0 1-1v5h2c1 0 1-1 1-1h-1v1-1h1c0-1 0-1 1-1v-2h-1s1 0 1-1h1v4l1 1h-1 2v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4c0 1 1 1 1 1 1-1 1 0 1 0-1 0-1 0 0 0 0 1 1 1 1 1v5c0-1 0-1 1-1l-1 1v2h1s0-1 0 0v1h-2 2c1-1 1-1 1 0l1-1c0-1-1-1-1-1v-3h1v-1h2c1 1 1 2 1 3v1l-1 1c0 1-1 1-1 1l-1-1v2c0-1 0-1-1 0 0 0-1 0-1 1v1c1 0 1 1 1 1h-1 1v2l-1 1h1v1h-2c0 1 0 1-1 1h1v1h1v1c1 0 1 0 1 1h1-1v2c0 1 0 1-1 2v1h-1c-1 1-1 1-1 2 0 0-1 0-1 1 0 0-1 0-1 1v3c0 1 0 1-1 1h-2c0 1-1 2-1 2 0 1-1 1-1 1h1v6h-1c0 1 0 1 1 1v1c-1 0-1 0-1 1 1 0 1 0 1 1v2h1s1 0 1 1v-4h-1 2v5s1 1 1 2v5c0 1 0 1 1 1l1 1v2h-1c-1 0-1 0-1 1l2 2v-2 1-1h1v2c1 1 1 1 1 2v2h-1l1 1c1 0 2 1 2 2l1-1s1 0 1 1v-2h-1c0-1 0-1-1 0v-1h1l-1-1c-1-1-1-2-1-2v-3c-1 0-1-1 0-2h-1v-1h-2v-5l1-1v1h1c1 0 2 1 2 1-1 1-1 1 0 2 0 1 0 1-1 2 0 0 0 1 1 1v-1 1l1 1v1h1c1 1 1 1 1 2 1 0 1 0 0 1v1l1 1h1v-5s-1 0-1 1v-1h2v6h-1v1c1 0 1 1 1 1 1 0 1 1 1 2 1 0 1 0 1 1v-1c0-1 1-1 1-1 0-1 0-1 1-1 0 0 1 0 1 1 0 0 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1v-1 2c-1 0-1 1 0 2 0 1 0 1 1 1h1v1c0 1 1 1 2 2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1h2c1 0 1 0 1 1 1 0 2 1 2 1h4c0-1 1-1 1-1 1 0 2 1 3 2v1l1-1c1 0 1 1 1 1 1 0 1 1 1 2h2v-2h-1c1 0 1 0 2-1v4h3v1-4l1-1v6h1-1c2 2 2 3 2 3h1s1 0 1 1c1 0 1 1 1 2 0 0 1 1 0 1 0 0 0 1 1 1h1v-4h-1v-5c0-1 1-2 1-2v-2c1 0 0-1 0-1l-1-1c-1 0-3-1-4 0h-4v-1s1 0 1-1h-1v-4l1-1h2v-2h1c0-1 0-1 0 0 1-1 1-1 0-1l1-1c-1-1-1-1-2-1v1s0 1-1 1-1 0-2-1c-1 0-2 0-2 1s0 1-1 2c0 1-1 2-3 2h-1v4h1v1h-2v-1h1v-4c-1 0-2 1-2 1v1s0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4l1-1-1-1v-1c0-1-1-1-1-2v-1 1s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 0 2 1v1c0-2 1-4 2-5h-1v-4l1-1h1c1-1 2-1 3-2 2-1 3-2 4-2v-4l1-1c1 0 1 0 2 1v4c1 0 1 0 1 1h1v-5s0-1 1-1v6c0-1 1-1 1 0h1v-1c-1 0-1 0 0 0v-1h2v-3h-1l1-1v4h2v-1c0-1 1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2c0-1 1-1 1-1v-3l1-1h1l1 1v4l-1 1h-1c1 0 1 1 0 2v1h2v5h1c0 1 0 1 0 0l1-1c0-1 1-2 0-4v-3c-1-3 0-6 3-7 1 0 2-1 2-2h1v-1s-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 2 1v3h1c1 0 1-1 1-1v-2h-1c1 0 1 0 2-1v3c1-1 1-1 1-2s0-2-1-2v-1h1c-1 0-1-1-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1v1h1v-4c1 0 1-1 1-1h4c1-1 3-1 2-1l1-1h2c1 0 1-1 1-1h-2v-5h-1c1 0 1 0 2-1v5-1l4-2s0-1-1-1c0 0 1 0 1-1v2c1 0 2-1 2-1h1l1-1h1c1 0 1-1 2-1 0 0 0 1-1 1l-1 1c1 0 1 1 1 2l1-1s1-1 2-1h1c0-1 0-1 1-1h2s1 0 1-1c1 0 2-1 2-1v-1 1h-2v-1h1-1c-1 1-1 2-1 1h-1c0 1-2 0-2 0h2l1-1h-2v1c-1 0-1 0-1-1 0 1 0 1-1 1v-5l1-1h1c-1 0-1-1-2 0h-4c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2v-1c0-1 1-1 1-1v-1h3l1-1c1 0 1-1 2-1h10c0-1 1-1 1-1h-2 1v-5h-1c1 0 1-1 1-1h1v6c1 0 1 0 1-1h1v-4l1-1h1l1 1v3h1v-3s1 0 1-1c-1 0-1-1-1-2 1 0 0-1-1 0 0 0-1 0-1-1h-2 1s-1 0 0 0c0-1 0-1-1-2 1 0 1-2 0-2h1v-1h-1 1c-1 0-1-1-1-1v-2l-1-1c1-1 1-1 0-1v1s-1 0-1 1h-1c-1 1-2 1-2 1l-1 1h-1c-1-1-2-1-2-2l1-1c-1-1-1-1-1-2-1 0-1 0-1-1 1 0 1 0 0 0 0-1-1-1-1-1v5h1-2v-5h-1 1c-1 0-2 0-4-1h-1v1c1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1l-1-1v1s0 1-1 1-1 1-1 1-1 0-1 1c0 0 1 0 1 1h1c0 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-1h-1c0 1 0 1-1 1v1c-1 0-1-1-1-1h-1l-1 1v2c0 1-1 1-1 1v5h-2 1v-2h-1c-1 1-1 1-1 0 0 0 0 1-1 1v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1c1-1 1-1 1-2h1s1 0 1 1l1 1v-1c-1 0-1 0-1-1l1-1 1-2h-3 1-2 1c-1 0-2-1-2-1h-1l-1-1v2h1-2v-3c-1 0-1-1-2-1h-1v4h-2 1v-4c-1 0-1 0 0-1h-1 1v-1c0-1 0-1-1-1h-1l1-1v-1s-1-1-1-2 1-1 1-2l1-1c1 0 1 0 2 1v2h1v-2s1 0 1-1h1l1 1h1v-1h2c-1 0 0 0 0 0 1 0 1-1 1-1 1 0 1-1 1-1h2c1 0 3-1 4-2v-4h-1 2v4l2-2v-1c0-1 1-1 1-1h2c0 1 1 1 1 2 0-1 0-1 0 0 0-1 0-1 1-1v-1h3c1 0 1-1 0-1 0 0 1-1 2-1 0 0 0-1 1-1 0-1 0-1-1-1h2v-4l1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1h1v1h2v-4h-1c0-1 1-1 1-1h-1v-1h1c0 1 0 1 1 1s1 0 0 0h-1v5l1 1h-2v-1h-1v1c0 1 0 1 1 0 0 0 1 0 1 1h-1c-2 0-4 1-3 2h2l1-1h1c0-1 0-1 0 0h2l-1-1h-1 2v2h-1c0 1 0 1-1 1 1 0 1 1 1 1 0 1 0 2-1 2v1h-1c-1 0-1 0-1-1-1 0-1 0-1-1h-1v2h1v1h1v1l1 1h1l1 1h1v-1h1c1 0 1 0 1 1 1 0 1 0 1 1 1 1 2 0 1 0 0-1 0-1 0 0h-1v-1s0-1-1-1v-1h-1c0-1 0-1 0 0h2c0 1 0 1 0 0 0 0 1 0 0 0l1 1h1v1-1c1 0 1 0 1-1h1v-1c-1 0-1-1 0-1h-2s-1 0-1-1v-3c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v3c1 0 1 1 1 1h2v-3s-1 0-1-1c0 0 1 0 1-1v4h2v-1s0-1 1-1v-1s-1 0 0 0h-1v-1h-2v-1h-1c-1 0-1-1-1-1h2v-1c1-1 0-2-2-2v1h2s-1 0-2 1h-1v1c-1 0-1-1-2-1v-4l-1 1v3s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2c0 0 0-1 1-1h1-1c-1 0 0 0 0 0l1-1s-1-1-3-1h-2c-1 1-1 1-1 0h-3c-2 1-2 1-1 0-2-1-7 1-8 2l-1 1h-1v1h1l2 1-2-1-1 1v1h3s1 0 0 0c0 1 0 1-1 2l-1 1c-1 1-1 1-1 0-1 0-2 1-1 1 0 0-1 0-1 1h-1c0-1 0-1 1-2 1 0 1-2-1-1 0 0-1 0 0-1 0 1-1 1-1 1 0 1-1 1-1 1s0-1 1-1c-1 0-1 0-2-1v-4h-1v1h-1v4h-2s0 1 0 0c1 0 1 0 1 1-1 0-2 0-3 1h-1v1c1 1 1 2 1 2 0 1 0 2-1 2v1h-2c-1-1-1-2-1-2v-2l1-1h1v-1h1c-1 0-1-1 0 0 0 0 1-1 0-1h1l1-1v-1h2v-3 1s-1 0-1 1h-1c1 1 0 1 0 1h-1c0-1 0-1-1-1v1l1 1h-2c1 0 1-1 1-1h-1s-1 0-1 1h-1c1 0 1 1 1 1h-1c-1 1-1 1-4 1h-2c0-1-1-1-1-1-1 1-1 0-1 0 1 0 1 0 0 0 0-1-1-1-1-1h-1c-1 0-1 0-1-1-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 0-1 1h1s0-1 0 0h2c1 0 2 0 2 1l1-1c1 0 1 0 1-1h-1v-4l1-1h1l1-1c1 0 2-1 2-1h-2c-1 0-2 0-1 1h-1c0-1-1 0-2 0-1 1-1 1-1 2v5h1-3 1v-5h-1c1-1 1-1 2-1h-1c0-1-1-1-1-1 0 1-1 1-2 0h-2l-1-1c0-1-1-1-2-1h-8v1s-1 0-2 1h-1l-1 1h-1l-1 1c1 0 1 0 1 1v-1c1 0 1 0 1-1h1s1 0 1 1c0 0 1 0 1 1h1v-1l1-1c1 0 1 0 1 1 1-1 2-1 2-1l-1 1v2h1v-2s1 0 1-1h1l1 1v2h1-1v2l-1 1c-1 0-1 0-2-1v-1h-1v1s-1 0-1 1h1v1h5c1-1 2-1 3-1h1-1c-2 1-3 1-2 2h-2c1 0 1 0 1-1h-1c-2 1-5 1-5 1-1-1-1-1-1 0h-1c-1 0-1 0 1-1 1 0 1 0 1-1h-5c-1 0-1 0-1-1h-1c0-1-1-1-2 0v1h1-2v-1h-1c-1 0-1-1 0-1v1s0-1 1-1h-2v1l-1 1h-1s-1 0-1-1v-1h-1v1c-1 0-1 0-1 1h-1s-1 0-1-1c0 0-1 0-1-1h-1v1c1-1 1-1 1 0h-1v1h-1c-1 0-1 0-2-1h-1c1 0 1 0 0 0 0 1 0 1-1 1h-1c-1 0-3 0-3-1h-3v1h1-2 1v-2h-4v2h1-2v-2h-1s-1 0-2-1v3h1-3 1v-3h-3v3h-2 1v-3s-1 0-1-1h-3v4h1-2c1 0 1-1 1-1v-3c-1 1-2 1-2 1h-1v2s0 1-1 1-1 0-2-1v-2h-1v2l-1 1h-1s-1 0-1-1v-1c-1 1-1 1-2 1v1h-6c0 1-1 1-1 1zM20 42zm2-4v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 1-1 2zm4 1h-2 1v-5h-1s1 0 1-1v5l1 1zm1 0h-1 1zm24 12h-1v-1s1 0 1 1zm-4 31h-2v-5h-1c1 0 1-1 2-1v6h1zm0-13c0-1 1-1 1-1h2c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm3 20v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c0-1 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm1-7h-2v-1h1v-4h-1l1-1v6h1zm41 47 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm1 5v1c1 0 1 0 0 0h-1c1 0 1 0 0-1 0-1 0-1 1 0zm-7-15v6h-2v-1h1v-5s-1 0-1 1v-1h2zm-13 0v5h1v1h-3v-1h1v-5s0 1-1 1v-1h2zm70-58h1-1zm14-11h1-1c-1 0-1 0 0 0zm-3-8h1v5h-2 1v-5h-1 1zm-6 1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2zm-1 5h-2v-5h-1c1 0 1-1 2-1v6h1zm-3-13c0-1 1-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm-5-1h1v5h-2 1v-5h-1 1zm0 8h1v6h-2 1v-5h-1l1-1zm-4 0v6h1-2c1 0 1-1 1-1v-4h-1l1-1zm-2 10c1 0 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-2-10v6h1-2v-5h-1c1 0 1-1 2-1zm-2 10s0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm-2 13h-2 1v-5h-1c1 0 1 0 1-1h1v6zm-2-13v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm25-38zm2 2h-1 1zm0-2h-1 1zm-2 9c0 1-1 1-1 1v-1h1zm7 4c-1 0-1 0 0 0zm5-14h1-2 1zm-9 4c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1v-1zm-11-5h1c0 1 0 1-1 1v-1zm1 2v1-1zm-1-6c1 0 1-1 1-1h2-1l-1 1v1l-1-1zm0 0v1c0 1 0 1 0 0v-1zm-4 4s1 0 0 0zm1 2h1v-5h-1l1-1h1v6h-2zm-4 2c0-1 1-1 0 0zm-10 2v-1h2c1 1 1 1 1 2v1c0-1 0 0 1 0h-1v1c0 1-1 1-1 1h-1s-1 0-1-1l-1-1c0-1 1-2 1-2zm-5-2h1-1zm-4 2c0-1 1-1 1-1h2v4c0 1 0 1-1 1h-2v-4zm-4 0c0-1 0-1 1-1h2v4c0 1-1 1-1 1h-2c0-1-1-2-1-2 0-1 1-2 1-2zm-38 81h-3 1v-5h-1 2v5h1zm0-8h-3 1v-5h-1c1 0 1-1 2-1v6h1zm4-1v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm0-9v1h-3v-4c0-1 1-1 1-1h2c0 1 1 2 1 2 0 1 0 2-1 2zm-1-25c0 1 1 1 1 1h-2v-5c0-1 1-1 1-1v5zm0 3v6h1-2v-5s1 0 1-1zm6 31c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-9-1 1h-2c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 2v2zm0-7h-2 1v-5h-1c0-1 1-1 1-1h1v6zm1-12v-1c0-1 0-1 1-1v-1c1 0 1 1 2 1v4l-1 1h-1s-1 0-1-1v-2zm1-10h-1c1-1 1-1 2-1v6h-2c1 0 1-1 1-1v-4zm-1-4h1v-5h-1c1 0 1 0 2-1v6h-2zm2-9c0 1 0 1-1 1l-1-1v-4s0-1 1-1h2v4c0 1-1 1-1 1zm0 43h-2 1v-5h-1 2v5zm2-8h-3 1v-5h-1c1-1 1-1 2-1v6h1zm2 15v-1c1 0 1 1 1 1h-1zm1-8c0 1 0 1-1 1s-1 0-2-1v-3c0-1 1-1 1-1h2c0 1 1 1 1 2s-1 2-1 2zm-2-38 1-1v6h1-2v-5zm1-4v1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3l-1 1c0 1 0 1-1 1zm-2 13 1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s-1 2-1 2 0 1-1 1-1 0-2-1v-3zm4 13h-2v-5c0-1 1-1 1-1v6h1zm3 8h-2 1v-5h-1 1v5h1zm-1-51h1-2 1v-5h-1l1-1v6zm0 3v5h1v1h-2v-1h1v-5h-1v1-1h1zm0 8v6h1-2 1v-5h-1s1 0 1-1zm0 9v5h1v1h-2v-1h1v-4h-1c0-1 1-1 1-1zm0 8v6h1-2 1v-5h-1s1 0 1-1zm5 23h-2 1v-5h-1 2v5zm0-17h-2 1v-5h-1c1 0 1 0 2-1v6zm5 16c0 1 0 1-1 1s-1 0-2-1v-3c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4zm0 15h1-1zm1 0zm0-22h-2v-5c0-1 0-1 1-1v6h1zm0 22zm0 0zm0-31c-1 1-2 1-2 0h-1v-5h-1c1 0 1 0 2-1v6c0-1 1-3 3-5 1-2 1-2 1-1-1 0-1 0 0-1h1l1-1h2l-2 2c-1 0-1 0-2 1s-1 2-1 3c0 0 0 1-1 2zm6-1c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1 1-1 1 1c1 1 1 1 1 2v2zm0 0c1 0 1 0 1 1h-1v-1zm0 17-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c1 0 1-1 1-1l1 1c1 1 1 1 1 2v2zm0-7h-2 1v-5h-1c0-1 1-1 1-1v5h1v1zm5 0h-3 1v-5h-1c1-1 1-1 2-1v5c0 1 0 1 1 1zm6-23v5h1v1h-2v-1h1v-4h-1v-1 1-1h1zm-4-9v6h1-2v-5h-1c1 0 1-1 2-1zm-2 10 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 6c1-1 1-1 2 0v1l1 1v1h3v-1h-1s1 0 1-1v2h1s0 1-1 1v3h1-2 1v-3h-3v2s0 1-1 1-1 0-2-1c0 0-1 1-2 1-2 1-3 1-4 1v-1h1c0 1 0 1 0 0h1v-1s-1-1-1-2l1-1h-1v1s0-1 1-1v-1h1v-1s0-1-1-1v-1h1c1 0 1 1 2 1h1zm-1-1v1-1s1 0 0 0zm-1-15v6h-2 1v-5h-1c1 0 1-1 2-1zm-7-24 1-1h2c1 1 1 2 1 2v2l-1 1h-2c-1-1-1-2-1-2v-2zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2zm2 17h-1l1-1v6h1-2 1v-5zm-1-3v-1h1v-5h-1 1v5h1v1h-2zm-3-23h1-1zm0 36h2-1 2-1v-1h2l-1-1v1-1h1v1c1-1 2-1 2 0s0 1 1 1v-1s0-1 1-1h2v4c0 1-1 1-1 1v1h1-2l-1-1c0-1 0-1-1-1s-1 1-2 1h1v1h-2v-1h1c-1 0-1 0-1-1h-1c1-1 1-1 0-1 0 1 0 1 0 0 0 0-1 0-1 1h-2l-1 1h1v1h-2v-2h-1 1v-4s0 1-1 1v-1h2v3c1 0 1 0 2-1zm-2-36v5h1-2v-5h-1 2zm0 8v6h1-2v-5h-1c1 0 1-1 2-1zm0 9v5h1v1h-2v-6l-1 1v-1h2zm-2 10c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1-1 0-2-1v-3zm0 25v4s-1 0-1 1h-1s-1 0-1-1v-4s0-1 1-1 1 0 2 1zm-2-52v5h-2 1v-5h-1 2zm0 8v6h-2 1v-5h-1c1 0 1-1 2-1zm-2 10s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-1 1-2zm0 13s0-1 1-1v-2h-1v-2h1-1l1-1h1v6h-2zm0 4s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm-1 17c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1zm-4-51 1-1h2c1 1 1 2 1 3v1l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2zm0 8h-1c0 1 1 1 1 2s-1 1-1 2c0 0 0 1-1 1s-1 0-2-1v-2h-1v2l-1 1h-1s-1 0-1-1v-2h-1 1v-1c0-1 0-1 1-2 1 0 1 0 2 1v1l1-1c0-1 0-1 0 0 1 0 1 0 1-1h1s1 0 1 1h1zm-10-6h2v-1h-1l1-1c0-1 0-1 1-1h2v1h1c0-1 1-1 1-1h2c0 1 1 2 1 3l-1 1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-3l-1 1v1c0 1-1 1-1 1s0 1-1 1l-1-1v-1h-1l-1-1zm-1-3v5h1-2 1v-5h-1 1zm-1 10v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1zm1 8v-1h-1v1-1h1v5h1v1h-2v-1h1v-4zm-1 9v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1zm1 8h-1c0-1 1-1 1-1v5h1v1h-2l1-1v-4zm-1 9v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1zm-1 8s1 1 1 2 0 1-1 2v1h-1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1zm-2-52v5h1-2v-5h1zm-2 10c0-1 1-1 1-2h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 25v4l-1 1h-1l-1-1v-4l1-1h1l1 1zm-4-51s0-1 1-1h2v4c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4zm1 8h-1c1 0 1-1 2-1v6h1-3 1v-5zm-1 9s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm1 8h-1c1 0 1 0 2-1v6h1-3 1v-5zm-1 9s0-1 1-1 1 0 2 1v3c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm0 9c0-1 0-1 1-1v-1c1 0 1 1 2 1v4c0 1 0 1-1 1h-1s-1 0-1-1v-3zm0 17c0-1 0-1 1-1h2v4c0 1 0 1-1 1h-2v-4zm-8 22h-2v-6 1-1h1v5h1v1zm0-9h-2v-5s0-1 1-1v6h1zm0-10v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c0-1 1-1 1-1h2c0 1 1 2 1 2 0 1-1 2-1 2zm-1-16h1-2v-5l1-1v6zm5 43h-2 1v-5h-1l1-1v6h1zm1-10-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm0-8c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm0-9-1 1h-2c-1-1-1-2-1-2v-2l1-1h2c1 1 1 2 1 2v2zm-2-25h1v1h-2v-1h1v-4h-1c0-1 1-1 1-1v5zm0 3v6h1-2 1v-5h-1s1 0 1-1zm2 15h-2 1v-5h-1c0-1 1-1 1-1v5l1 1zm-4-56c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2zm0 9 1-1c0-1 1-1 1-1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm2 8-1-1v1-1h1v5h1v1h-2v-1h1v-4zm-2 9 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 25s1 1 1 2 0 1-1 2v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1zm-2-52v5h1v1h-2v-6h1zm0 8v6h1-2v-5s0-1 1-1zm-2 10 1-1h2c0 1 1 2 1 3l-1 1v1l-1 1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0-1 1-1 2v1h-1c-1 0-1 0-2-1v-4zm0 17v4l-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1zm-4-51s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm0 9c0-1 0-1 1-1v-1c1 0 1 0 2 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm0 9c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1h-1s-1 0-1-1v-3zm1 8h-1c1-1 1-1 2-1v6h-2 1v-5zm-1 9c0-1 0-1 1-1v-1c1 0 1 1 2 1v4c0 1 0 1-1 1h-1s-1 0-1-1v-3zm0 17c0-1 0-1 1-1h2v4c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4zm0 8 1-1c1 0 1 0 2 1v4s0 1-1 1h-1s-1 0-1-1v-4zm-6-49s0-1 0 0zm1-3v-1 1zm3 17s1 0 1 1h-1v-1h-1c0-1-1-2 0-2v1h1s1 1 0 1zm-1-9v5c0 1 0 1 1 1h-2 1v-5h-1s1 0 1-1zm0 9v1h1c0 1 0 1-1 1v3h1v1h-2 1v-4c-1 0-1 0 0 0v-1h-1c0-1 1-1 1-1zm-1 13c-1 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1zm2 27h-2 1v-5h-1l1-1v5l1 1zm0-9h-2 1v-5h-1 1v4c0 1 0 1 1 1zm1-8h-2 1v-5h-1c0-1 1-1 1-1h1v6zm-3-56v-1h2c1 1 1 2 1 3v1l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-2-1-2 0-1 0-2 1-2zm0 9v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm-1 5v1-1zm-1 2c1 1 1 1 0 1v-1c0-1 0-1 0 0zm-1-17v5h1v1h-2v-6 1-1h1zm0 8v6h1-2v-5l1-1zm-6-7s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm-3-1h1v6h-2v-1h1v-5c-1 0-1 0-1 1v-1h1zm-6 1c1 0 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm0 10zm-1 1h-1s1 0 1-1c1 0 0 0 0 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M44 30h1v-5h-1v1c-1 1-1 1-1 2s1 1 1 2zM36 30h1v-4l-1-1h-1v5h1zM137 140zM138 139c-1 0-1 0-1 1 0 0 1 0 1-1zM245 98v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM53 39h1v-5h-1c-1 0-1 0-1 1v3l1 1zM255 136h-1l-1 1v2s0 1 1 2h1v-5zM256 127h-1c0 1 0 1-1 2v1c0 1 0 1 1 2v1s1 0 1-1v-5zM249 85v-1s0 1-1 1v4c0 1 1 1 1 1l1-1v-4h-1zM137 139h1-1zM249 102h-1v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM256 110h-1c0 1 0 1-1 1v2c0 1 0 1 1 2h1v-5zM249 93h-1v5h1c1 0 1 0 1-1v-3c0-1-1-1-1-1zM249 110h-1v5h2v-4l-1-1zM122 120s0-1-1-1h1v-1s-2-1-3 0c-1 0-1 0-2-1l-1 1c-1 0-1 0 0 0 0 0 1 0 1 1h1v1-1 3h1l1-1h2v-1zM245 124v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM123 121h1c1-1 1-1 0-1-1-1-1-1-2-1v2h1zM109 120v1-1zM273 179h-1v4c0 1 0 1 1 1v-1c1 0 1-1 1-2s0-1-1-2zM112 121l-1-1h-2v1h1s0 1 1 1c-1-1 0-1 0-1s1 0 0 0h1zM245 115c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5h1zM248 136h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM138 139zM138 140zM137 136h1s0-1-1-1v1c0 1-1 1-1 1h1v-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M137 137c1 0 1-1 1-1-1 0-1 1-1 1zM114 120c-1 1-1 1 0 1v-1zM117 120v-1 1h-2v1h2v-1zm0 1zM137 139h1-1zM245 107v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM57 39h1v-5h-1l-1 1v1c0 1 0 2 1 2v1zM277 124c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM58 77v1c-1 0-1 1-1 1 0 1 1 2 1 2v1c1 0 1 0 1-1v-5h-1v1zM57 30h1v-5h-1s0 1-1 1v2c0 1 0 1 1 2zM282 153h-1c-1 0-1 1-1 1v4h2v-5zM57 56h1v-5h-1s0 1-1 1v1c0 1 0 2 1 2v1zM57 47h1v-5h-1c0 1 0 1-1 1v2c0 1 0 1 1 2zM277 115h1v-4l-1-1h-1v5h1zM273 170h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM273 124v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM62 47h1v-4c-1 0-1-1-1-1h-1v5h1zM62 56s0-1 1-1v-4h-2v4c0 1 0 1 1 1zM62 65v-1h1v-4c-1 0-1-1-1-1h-1v5s0 1 1 1zM273 115c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5h1zM277 133v-1h1v-4l-1-1h-1v5l1 1zM57 99h1v-5c0-1 0-1-1-1v1l-1 1v1c0 1 0 2 1 2v1zM285 115h1c0-1 1-2 1-2 0-1-1-2-1-2v-1h-1v1c0 1-1 1-1 2s1 1 1 2zM282 170h-1c-1 0-1 1-1 1v4h2v-5zM285 124h1v-1s1-1 1-2-1-1-1-2h-1v1c0 1-1 1-1 1 0 1 1 2 1 2v1zM53 30h1v-5h-1c-1 0-1 1-1 1v4h1zM260 127h-1v5s0 1 1 1v-1c1-1 1-1 1-2s0-2-1-2v-1zM256 93h-1s0 1-1 1v2c0 1 0 1 1 2h1v-5zM53 73h1v-5h-1c-1 0-1 1-1 1v4h1zM260 85v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2zM285 133c1 0 1 0 1-1s1-1 1-2-1-2-1-2v-1h-1v2l-1 1c0 1 1 1 1 2v1zM281 133l1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM57 73h1v-5h-1s0 1-1 1v2s0 1 1 2zM281 107h1v-5h-1c-1 0-1 0-1 1v3l1 1zM286 162v-1c-1 0-1 1-1 1v1l-1 1c0 1 1 2 1 2v1h1v-1c0-1 1-1 1-2s-1-1-1-2zM256 102h-1l-1 1v1c0 1 0 2 1 2v1h1v-5zM57 90h1v-5h-1s0 1-1 1v2s0 1 1 2zM219 101zM219 21h1l1-1h-2v1zM227 12v-2h-1c0 1 0 2 1 2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M227 7v1l-1 1h1c1 0 1 0 1 1s0 1 0 0V8c-1 0 0 0 0 0s0-1-1-1zM229 8h-1 1zM221 17l-1-1c1 0 0 0 0 0h-1v3s1 1 2 1v-3zM211 2c0 1 0 1 1 2h1V0h-2v2zM222 20v-2c0-1 0-1-1-1 1 0 1 1 1 2v1zM141 11h-1v2h5v-2c-1 0-2-1-1-1h1V9h-1v1c1-1 1-1 1 0h-1c0-1-1-1-2-1h-2v1l1 1zM149 8h1-1zM131 218c1-1 1-2 1-2 0-1-1-2-1-2v-1h-1v5h1zM225 2h1V1c-1 0-1 0-1-1v2zM227 4h1V3c-1 0-1 0 0 0V1h-2v1c0 1 0 1 1 2zM232 4l1-1V2c-1 1-2 0-2 0v2h1zM131 236v-1c1-1 1-1 1-2s-1-2-1-2v-1h-1v5s0 1 1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M233 4h-1 2c1 0 1 0 1-1h1V2h-2c-1 0-1 1-1 1v1zM229 12c1 0 0 0 0 0zM121 141h1v-4l-1-1h-1v5h1zM121 145v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-2zM183 19h-4v1l-1 1h1c1 1 1 1 2 0 2 0 2 0 1-1h-1 2v-1zM229 9h1c-1 0-1-1-1-1v1zM126 150h1v-5h-1s-1 0-1 1v1c0 1 0 2 1 2v1zM237 3c2 0 2-1-1-1v1h1zM118 176v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4s0 1 1 1zM152 2v1-1zM167 8c-1 0 0 0 0 1V8zM126 218h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM126 159l1-1v-5h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1zM126 201h1v-5h-1l-1 1v2c0 1 0 1 1 2zM126 236s1 0 1-1v-5h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1zM183 34v-1h-1c-1 1-1 1-1 2v2h2v-3zM172 8h-1v1c-1 0-1 1-1 1v1c1 0 2 0 1-1h1V8zM222 2v2h2V0h-2v2zM163 8zM176 4c3-1 4-1 4-1h2V1h-6v3zM159 8h-1v2s1 0 2-1h-1s-1 0 0 0V8z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M187 4c0 1 0 1-1 1l-1-1V3h-2v2h-2V4h1V3c-2 0-5 1-5 1v1h2s-2 1-4 1c-3 0-7 1-7 1h-1 1v1h1-1v1c0 1 1 1 2 1V8c-1 0 0 0 0 0h1V7c1 0 1 1 2 1v2h2V8s1 0 1-1v3c1 0 2 0 3 1h1s0 1 1 1v1c-1 0-1 0 0 0h-1c0 1 1 1 1 1 0-1 0 0 0 0h-1 1v1c-1 0-1 0 0 0v1h-1v1c-1 0-1 0 0 1h2-1s0 1 1 1v-1h1v-1h-1c1-1 1-1 2-1v6h-1c-1 0-1 1-2 0-1 0-1 0-2 1v1c-1 0-2 1-2 1l1 1c-1 0-1 1-1 1v1h1c-1 0-1 1 0 1-1 1-1 1 0 2-1 0 0 1 0 1v2s1 0 1 1v1h1v1-1c0-1 0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2h2v-4h-1c1-1 1-1 2-1v4h1v-2c1 0 1-1 1-1 1 0 1-1 1-1s1 0 1-1h1l1-1v-1c1 0 1 0 1-1h1v-4h-1s1 0 1-1v4h2c0-1 0-1 0 0h2v-3h-1c1 0 1 0 2-1v3h2l1-1v-1l1-1v1c1 0 2-1 2-1h1c0-1 0-1 1-1 0 1 0 1 1 1 3-1 7-2 8-2l1-1h1-1v-1c-1-1-2-1-1-1 0-1 0-1 1-1v-1c1 0 1-1 1-1v-1h1s-1 1 0 1h1v1c1 0 2-1 1-1 1 0 1 0 1-1h1c1 0 2-1 1-1v-1h2s-1 0-1-1V9c0-1 0-1 1-2h1-1c0 1-1 0 0 0 0-1 1-1 1-1h2l-1-1h3V4v1c-1 0-1-1-2-1V2h-1v1c0 1 0 1-1 1 0 0 0 1-1 1l-1-1V2h-1v1l-1 1-1 1-1-1c-1-1-1-2-1-2V0h-2v4h1-2V0h-4v3c0 1-1 1-1 1s0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-1 1-2h-1v3l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2V0c-1 0-1 0-2 1v3h1c-1 1-2 1-2 1V1h-3 1v1l-1-1v3h1v1h-3V4h1V1s-1 0 0 0h-1c-1 0-1 0-1 1v1l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-2-1-2V1v1s0 1-1 1v1l-1 1c-1 0-1-1-2-1V2h-1v1c0 1 0 1-1 1zm-13 4h-1 1zm9 5h-2 1V8h-1c1 0 1 0 1-1h1v6zm-5 17zm5 0h-2 1v-5h-1c1 0 1 0 1-1h1v6zm39-15c0 1 0 1 0 0zm1-8v5s0 1 1 1h-2 1V8h-1l1-1zm-1 8h-1 1zm-2 0v-1h1s0 1-1 1zm-3-6c0-1 1-1 1-2h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1V9zm-3 7v6h-2v-1h1v-5l-1 1v-1h2zm-1-9v6h-2 1V8h-1c1 0 1-1 2-1zm-3 9c1 1 1 2 1 3v1l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h2zm-2-9v6h1-2 1V8h-1l1-1zm-2 15h-2v-6 1-1h1v5h1v1zm-3-20c0-1 0 0 0 0-1 0-1 0 0 0zm-1 7c0-1 1-1 1-1 0-1 0-1 1-1 0 0 1 0 1 1 0 0 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1V9zm0 7v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h2zm-2-9v6h1-3 1V8h-1c1 0 1-1 2-1zm-3 9c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h2zm-3-7V8l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm-6 20s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm4 0v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 2-1 2zm1-8v1h-2v-1h1v-4h-1c0-1 1-1 1-1v5h1zm-4-12c0-1 1-1 1-1 0-1 1-1 1-1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1V9zm0 8v3c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h1l1 1zm-1-5s0 1-1 1h-1s-1 0-1-1V9c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zM166 4h2V1h-2v3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M207 4h1c1 0 1 0 1-1V0h-2v4zM185 2V1h-2v1h2zM186 4h1V3s1 0 1-1h-2c1 0 0-1-1-1v1c0 1 1 1 1 2zM162 4h2V1h-1c0 1-1 1-1 0v3zM154 13v-1c1 0 1 0 1-1h-2v1c1 0 1 0 1 1zM146 13h4v-2h-4v2zM150 13h3v-1l-1-1h-2v2zM154 4h1V2h-2v1l1 1zm1-2h-1 1zM148 10h2V8h-1c0 1 0 1-1 1h-2v1h2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M152 10c0-1 1-1 1-1V8l1-1c1 0 1 1 1 1 1 1 1 1 1 2v1h1V9c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1h2c0-1 1-1 1-1l1 1V7h2l1-1s1-1 4-1h2c0-1 1-1 1-1h1V1h-3v3h1v1h-3V4h1V1h-2v2c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2V1v1s0 1-1 1v1l-1 1c-1 0-1-1-2-1V1h-2v3h1-1 1v1h-3V4h1V2h-2v2c1 0 1 0 0 0h-1v1h-1s-1 0-1-1h-1s0-1-1-1h-1v1h1v1h-2V4h1V3h-3s0 1-1 1h1v1h-2V4c-1 0-1 1-1 1v1h1c-1 0-1 0 0 1h3c3 0 5 1 4 1h-2v2h2zm3-5h1v1c0-1-1-1-1-1zm0 1zm-4 1h-1 1c0-1 0-1 0 0z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M155 8h-1s-1 0-1 1v1h1c1 0 1 0 0 0h1V8zM204 13s0-1 1-1V8h-2v4c0 1 0 1 1 1zM200 16v1c0 1-1 1-1 2s1 1 1 2h1c0-1 1-2 1-2 0-1-1-2-1-2v-1h-1zM209 16l-1 1v4h2v-5h-1zM195 4h1V2c-1-1-1 0-2 0v2h1zM187 8h-1v1l-1 1c0 1 1 2 1 2v1h1v-1s1-1 1-2-1-1-1-2zM131 210v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM190 4h1s1 0 1-1V2h-2v2zM219 13l1-1V8h-1V7l-1 1v4c0 1 0 1 1 1zM191 13l1-1V8h-2v4c0 1 0 1 1 1zM187 16v5h1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1zM191 25h-1v4c0 1 0 1 1 1l1-1v-4h-1zM187 25h-1v1c0 1-1 1-1 2l1 1v1h1v-1s1-1 1-2-1-1-1-2zM131 184v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM196 16l-1 1v4h2v-5h-1zM195 13h1V8h-1c-1 0-1 0-1 1v3l1 1zM227 13h1v-2s-1 1 0 1c0 0-1 1-1 0v1zM194 266h1-1 1-1v-1 1zM215 100s1-1 0-1v1zM109 150c1 0 1-1 1-1v-4h-1c-1 0-1 1-1 1v3c0 1 1 1 1 1zM201 80v-1 1zM193 266l1-1h-1c1 0 0 0 0 0h-2 2v1zM109 159v-1h1v-4s0-1-1-1c-1 1-1 1-1 2v3l1 1zM215 102v-1 1zM220 30h-2v1h-1 3c1 1 3 1 4 1 1-1 2-1 3-2h1-2 1v-4c0 1 0 1-1 1h-1v2c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-1l-1 1v1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M218 28c1 0 1 0 0 1 0 1 0 1 1 1l1-1v-2h-1l-1-1v2zM217 27c-1 0-1 1-1 1h1v-1zM232 50v1-1zM217 29h-1v1-1h1zM228 30c1 0 2-1 2-1v-1c-1 0-1-1-1-1 1-1 1-1 0-1h-1v4zM222 29l1 1h1v-3h-1c-1 1-1 1-1 0v2zM195 78zM203 124zM135 10c1 0 0 0 0 0zM203 124zM109 176l1-1v-4l-1-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m102 141 1-1v-1s0 1 1 1l1 1v2l1 1v8h-1v1h-1v5l-1 1c-1 0-1 0-2-1 0 0-1 0-1 1v4c1 0 1 1 1 1 1 0 0 1 0 1h-1v1c0 1-1 1-1 1 0 1 0 2 1 2v1c-1 0 0 0 1 1 0 0 1 0 1-1h1l1 1v4c0 1 0 1 1 2 0 1 1 2 1 2v1s0 1 1 1v1-2l1-1h2c1 1 1 2 1 3v1l-1 1-1 1v1l1 1c1 0 1 0 1 1 1 0 1 1 1 1l2 2v-3h-1c1 0 1-1 2-1v4l1 1h1l1 1-1-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2v1h-2 1c0 1 0 1 1 1 0 0 1 1 1 2h2c1 1 1 2 1 3v1l-1 1-1 1v3-1 6h1-1v8h1v1h-1c0 1 0 1 1 2v1c1 1 1 1 1 2v2s-1 3-1 5v2c-1 0-1 0 0 0v2s1 1 1 2c0 0 1 1 0 1 0 1 1 3 1 4v2h1v-5h-1c1 0 1 0 1-1h1v5-1 1s1 0 0 0c0 0 0 1 1 1v3c1 1 0 1 0 1v4c0 1 0 1 1 1 0 0 0 1-1 2 0 1 0 2 1 2 0-1 0-1 1-1h2v4c0 1 0 1-1 1 0 1 1 1 1 1v1h1s1 0 1 1h1v1s1 0 1 1h1v1-1c1 0 1 0 1-1v-1h2v1h1c1 0 1 0 1 1h-1v2l1 1h3v-3l-1-1c-1-1-1-2-1-2h-1c0-1-1-2-2-2h-2c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 2v1c1 0 1-1 0-1 0-1 0-1 1-3h1v-1c0-1-1-1-1-1h-3 1v-1s-1 0-1-1c0 0 0-1 1-2v-1h-1l1-1h1v2s1 0 0-1v-3h1c1 0 1-1 1-2h-2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2h2c1 0 1-1 0-1v-3h1c2 0 4-1 5-1v-1h1v-4h-1v-1c0-1 0-1-1-2-1 0-1 0-1-1 0 1 1 1 1 1h1s1 0 3 1c2 0 2-1 3-2h-2 1v-5h-1c1 0 1 0 1-1h1v6-1s1-1 1-2 1-1 1-1c0-1 0-1 1-1v-1h-1c0 1 0 1-1 1 0 0 1 0 1-1l1-1v-1 2c1 0 1-1 1-1v-1h-2v-1h1v-5l-1 1v-1h2v5c1-1 1-1 1-2 1 0 1 0 1-1v-6s1 0 2-1v-2c0-1 0-1-1-1l1-1v3h1s1 0 1-1h1s0-1 1-1h-1l1-1h1v1h3v-1h1s0-1 1-1v-1c0-1 0-2 2-4v-4c1 0 1-2 1-4v-6h-1v-5s1 0 1-1v6h1s0-1 1-2c0-2 1-2 1-2 1-1 3-4 3-4h-1s1 0 1-1v-4h-1c0-1 1-1 1-1 0-1-1-2-1-2h-1c-2 0-2 0-4-2v1h1-2v-2l-1-1h-1v2s0 1-1 1h-1s-1 0-1-1v-3h-1v3l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1l-1-1v-1h-1v-1 1l-2-1h-1c0-1-1-1-2-1l-1 1c-1 1-1 1 0 0v-1s0-1-1-1h-1c0-1-1-1-1-1v-3 5h-2v-1h1v-4h-1c0-1 1-1 1-1l-1-2c0-1-1-3-1-2v-1c0 1 0 1-1 1v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1h-1v3s0 1-1 1-1 0-2-1v-3c-1 0-2-1-2-1-1-1-1-1-2-1v-2s-1 0-1-1c0 1-1 1-1 1l-1-1v-1h-1v-2 1s0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4l1-1h-3 1v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4h-1c0-1 0-1-1-1 1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1l-1 1v-1c0-1-1-2-2-2 0-1-1-1-1-1v1c0 1 0 1-1 1 0 0-1 0-1 1h-1 1v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h1v-2c1 0 1 0 1-1h-2v1h-1c0 1-1 1-2 1h-1c-1 0-2 2-2 3v1h-1c0 1 0 1-1 1v1h1v1h-2v-1h1v-1c-1 0-1 1-1 1l-1-1c0-1-2-2-3-2v1-1s0 1-1 1v2zm2 26h-2v-5h-1 2v5h1zm37 77h1s0 1-1 1v-1zm18-24h-1s1-1 1 0zm17-50v5c0 1 1 1 1 1h-2v-5c0-1 1-1 1-1zm-3 31h-3 1v-5h-1 2v5h1zm1-8h-3 1v-5h-1c1-1 1-1 2-1v6h1zm-2-23v5c0 1 0 1 1 1h-3 1v-5h-1c1-1 1-1 2-1zm-2 10c0-1 0-1 1-1v-1c1 0 1 1 2 1v4c0 1 0 1-1 1h-1s-1 0-1-1v-3zm-1 13h-2 1v-5h-1l1-1h1v6zm-2-14h-1s1 0 1-1h1v6h-2 1v-5zm-1-8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2zm0 26v-1h2c1 1 1 2 1 2v2c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2zm-11 22h-2v-1h1v-5c-1 0-1 0-1 1v-1h2v6zm5-9h-3 1v-5h-1c1 0 1-1 2-1v6h1zm0-10c0 1 0 1-1 1 0 0 0 1-1 1 0 0 0-1-1-1v-4c0-1 0-1 1-1h2v4zm4 1h-2c1 0 1 0 1-1v-3h-1v-1h1v5h1zm1-8h-2s1 0 1-1v-4h-1c0-1 1-1 1-1v6h1zm-2-32v6h1-2c1 0 1 0 1-1v-3s0-1-1-1c0 0 1 0 1-1zm-2 10 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 2v1h-1c-1 0-1 0-2-1v-4zm0 9c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8v4l-1 1c-1 0-1 0-2-1v-4s1 0 1-1h1l1 1zm-2-27v6h1-3 1v-5h-1c1 0 1 0 2-1zm0 9v6h1-3 1v-5h-1c1-1 1-1 2-1zm-2 10c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4c0 1 0 1-1 1h-1l-1-1v-3zm-1 8c1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2l1-1c1 0 1 0 1 1zm-3-25v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1zm0 8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 0-1 1-2zm0 9v-1h2c1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1l-1-1c0-1 0-2 1-2zm0 17v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1l-1 1-1-1c0-1-1-2-1-2 0-1 0-2 1-2zm0 9v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1zm-2 20v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2s0 1-1 2zm0-9v1l-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm0-8v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1c1-1 1-1 1-2h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm0-9v1c-1 0-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2l1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm-1-33h1-2 1v-5h-1s1 0 1-1v6zm0 3v5s0 1 1 1h-2l1-1v-4h-1c0-1 1-1 1-1zm0 9v5h1-2 1v-5h-1 1zm2 14h-2c1 0 1 0 1-1v-4h-1l1-1v5c0 1 0 1 1 1zm-4-39c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2zm0 34s1 1 1 2-1 1-1 2v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1zm-3-9h-1 2v5h1-2v-5zm1-12h1-2v-5h-1c1 0 1 0 2-1v6zm0 3v6h1-2v-5h-1c1-1 1-1 2-1zm-2-16 1-1h1l1 1v3c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 43c0-1 1-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm1 8h-1c1 0 1-1 2-1v6h1-2v-5zm-1 9 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm1 8h-1c1 0 1 0 2-1v6h1-2v-5zm-1 9 1-1h1l1 1v3c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm-4-44h1v6h-2 1v-5h-1c1 0 1-1 1-1zm-1-43h1v6h-2 1v-5h-1s1 0 1-1zm0 9h1v6h-2s1 0 1-1v-4h-1c0-1 1-1 1-1zm0 8h1v6h-2 1v-5h-1s1 0 1-1zm0 9h1v6h-2 1v-5h-1c0-1 1-1 1-1zm0 9h1v5h-2 1v-5h-1 1zm-1 18v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2zm0 9v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm1 16h-1s1 0 1-1h1v6h-2 1v-5zm-1-3v-1h1v-5c-1 0-1 0-1 1v-1h2v6h-2zm0 12v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2zm-9 19h1-1zm1-6v-5h-1c1 0 1 0 2-1v6h1-2zm3 8-1 1c-1 0-1 0-2-1v-4s1 0 1-1h1l1 1v4zm2-77v1h1-2v-1h1v-4h-1c0-1 1-1 1-1v5zm0 4v5h1-2c1 0 1 0 1-1v-4h-1 1zm-1 17h2c0 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c1 0 1-1 1-1zm-1 10c0-1 1-1 1-2h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm1 8s1 0 1-1v6h1-2c1 0 1-1 1-1v-3s0-1-1-1zm-1 9 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm1 8s1 0 1-1v6h1-2c1 0 1 0 1-1v-3l-1-1zm2 22h-2c1 0 1 0 1-1v-3h-1v-1h1v5h1zm1-8h-2s1 0 1-1v-4h-1c0-1 1-1 1-1v5s0 1 1 1zm0-60h-2 1v-5h-1l1-1v6h1zm-2-49v6h1-2c1 0 1-1 1-1v-4h-1s1 0 1-1zm0 9v5l1 1h-2v-1h1v-4h-1c0-1 1-1 1-1zm-2 10 1-1 1-1 1 1c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm0 25v4s0 1-1 1-1 0-2-1v-4s1 0 1-1h1l1 1zm-3 9v-1h-1 2v5h1-2v-4zm1-53v6h1-2v-5h-1c1 0 1 0 2-1zm0 9v5c0 1 0 1 1 1h-2v-5h-1c1-1 1-1 2-1zm0 8v6h1-2v-5h-1c1 0 1 0 2-1zm0 9v6h1-2v-5h-1c1-1 1-1 2-1zm-2 10c0-1 0-1 1-1h2v4c0 1 0 1-1 1h-2v-4zm0 26c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1-1 0-2-1v-3zm0 8s0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm1 8h-1c1 0 1 0 2-1v6h1-2v-5zm-1 9s0-1 1-1h1l1 1v3c0 1 0 1-1 2-1 0-1 0-2-1v-4zm0 17c-1 0 0 0 0 0zm0 1c0 1 0 1-1 0h1zm-1-56h-2 1v-5h-1c1 0 1-1 2-1v6zm-2-13v-1h-1 2v5h-2 1v-4zm1-13h-2 1v-5h-1c1 0 1 0 1-1h1v6zm-1 3h1v6h-2 1v-5h-1l1-1zm-1-24v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1zm0 8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm0 43v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1l-1 1-1-1c0-1-1-2-1-2 0-1 1-2 1-2zm1 8h-1c1 0 1-1 1-1h1v6h-2 1v-5zm-1 9v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s0-1 1-2zm1 8h-1c1 0 1 0 1-1h1v6h-2 1v-5zm-1 9v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 0-1 1-2zm-4-47h1v-4c0-1 0-1-1-1h1v5h1-2zm1-26h1v1h-2c0-1 1-1 1-1v-4h-1c0-1 1-1 1-1v5zm0 3v6h1-2 1v-5h-1s1 0 1-1zm0 9v5c0 1 0 1 1 1h-2s1 0 1-1v-4h-1c0-1 1-1 1-1zm0 20h-1c0-1 0-1 1 0 0 0 1 0 0 1v-1zm2 3h-2 1v-5h-1l1-1v6h1zm-1-48c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1zm-4-8c1 0 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-1 7v6h1-2v-5h-1c1 0 1 0 2-1zm0 9v6h1-2v-5h-1c1-1 1-1 2-1zm0 8v6h1-2v-5h-1c1 0 1 0 2-1zm-2 10s1 0 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm0 9c0-1 1-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm-2 4h-2 1v-5h-1 2v5zm0-8h-2 1v-5h-1c1-1 1-1 2-1v6zm0-9h-2 1v-5h-1c1 0 1 0 2-1v6zm1-11v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2c0 0 0-1 1-1s1 0 2 1v2zm-1-6h-2 1v-5h-1c1 0 1 0 2-1v6zm-3-13v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm-4 9 1-1 1-1 1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 8c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zm0 9 1-1c1 0 1-1 1-1l1 1c1 1 1 1 1 2v2l-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-1v-2zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zM200 80z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M98 141c1 0 1 1 1 1-1 1-1 1 0 1 0-1 0-1 1 0 0 1 0 1 1 0 1 0 1 0 0-1h-1l1-1v-2c-1 1-1 1-2 1 0-1 0-1 0 0h-1v-2 3zM233 51l-1 1c-1 1-1 2-1 2h2v-3zM204 126v1-1zM201 123h1c-1-1-1 0-1 0zM109 167c1 0 1 0 1-1v-3c0-1 0-1-1-1s-1 1-1 1v4h1zM202 123s-1 0 0 0zM201 80c-1 0-1 0-1-1 0 1 0 1 1 1zM205 127c0-1-1-1 0 0zM205 125c1 0 0 0 0 0zM202 127h1-1zM200 79zM118 184v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM260 77c-1 2-1 2 0 2v-2zM249 80c0-1 0-1 0 0zM216 101s1 0 0 0c0-1 0 0 0 0zM237 51l-1-1h-1v3h2v-2zM217 91v1c1 0 1 0 1-1h-1zM218 100h-1v1c1 0 1-1 1-1zM114 153h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1s1 0 1-1v-5zM300 87v1-1zM302 86h-1v2h1c0-1 1-1 1-1v-1h-1zM131 7h2c1 0 2 0 2 1V7v1h1c1 0 1 0 1-1 1-1 1-1 0-1h-1c-1 0-1-1-2-1h-1l-1 1-1 1zM90 119h-1v5-2l1-1v-2zM260 72h1-1v1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M260 73s0 1 1 1l-1 1h-1v1h1v3h1v-2l1-1v-1c-1-1-1-1-1-2 1 0 1-2 0-2v1l-1 1zM289 87c0-1-1-1-2-1h-1v1h3c1 0 1 0 0-1v1zM277 295s1 0 1-1h-2v1h1zM240 43v-1h-2v2c1-1 1-1 1 0h-1v1h1-1v1h1c0 1 0 1 0 0v1h1v-4zm-2 0 1-1v1h-1zM222 99c0 1-1 2-1 2s1 0 1-1v-1zM245 47v-1 1zM245 42v1-1zM240 56s1 0 1-1h-1v1zM236 47h1-2 1zM233 49h-1v1s1 0 1 1c0 0 1 1 1 2l-1 1h1v-3c1 0 1-1 1-1h1s1 0 1 1c0 0 1 0 1 1v-2c0-1 0-1 1-1v-2h-4l-1 1v1h-1zM241 51v-1c-1 0-1 0-1 1 1-1 1 0 0 0l-1 1h1c1 0 1 0 0 1h-1v1h2v-3zM238 34s0 1 0 0l1 1v-1s-1-1-1 0zM222 99h1-1zM245 50h-1v5s0 1 1 1v-1c1-1 1-1 1-2s0-2-1-2v-1zM238 35h1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M249 51h-1c-1 1-1 1 0 0v-1c-1 0-1-1-1-1s0-1-1-1c0 0-1 0-1-1h-1v-2c-1 0-1 0 0-1v-2h-2s1 0 1-1c0 0 1 0 0 0l1-1v-1h-1v1s-1 1-2 1c0-1-1 0-1 0s0 1-1 1c1 0 1 0 2-1v6h-1c-1 0-1 1 0 1h2v1c1 0 1 1 0 1 0 0 0 1-1 1 1 0 1 1 1 2v2s-1 0-1 1h-2l-1 1h1c1 0 1-1 2 0l1-1h4c1 0 2-1 3-1v-1c-1 0-1 0 0 0v-3zm-3 4-1 1c-1 0-1 0-2-1v-4l1-1h1l1 1v4zM112 141h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM250 52s-1 0-1-1v2c1 0 1-1 1-1zM285 86zM109 184c1 0 1 0 1-1v-3c0-1 0-1-1-1s-1 1-1 1v3c0 1 1 1 1 1zM93 136h-1v2c1 1 1 1 1 0h1v1-2l-1-1zM150 158h1v-4s0-1-1-1h-1v5h1zM150 196h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM103 171v-1c-1 0-1 0-1 1v2c1 0 1 1 1 1v1c1-1 1-1 1-2s0-1-1-2zM102 158s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v1l-1 1v2zM134 265zM111 188l-1-1c0 1 0 1 1 1zM127 252v-2 2h-1c0 1 0 1 1 1v-1zM119 193c0-1 0-1 1-1v-4h-1v-1l-1 1v4c0 1 0 1 1 1zM127 248h-1v1c0-1 1-1 1 0v-1zM132 258l-1-1v-1h-1v4h1v1-1c1 0 1-1 1-2zM122 201c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v1c0 1 1 3 1 4zM127 244zM121 205h1-1zM146 188v4c0 1 0 1 1 1 0-1 0-1 1-1v-4c-1 0-1 0-1-1 0 0-1 0-1 1zM53 111h-1c0 1 1 1 1 1s0-1 1-1h-1zM81 128c0 1 1 1 1 1v-1h-1zM146 201v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM44 73h1v-4 1c-1 1-1 1-1 2v1zM146 218c1-1 1-2 1-3 0 0 0-1-1-1v-1h-1v5h1zM52 43v4h2v-5h-1l-1 1zm1 2h-1 1zM49 56v-1h1-1v1zM50 64v-1c0 1-1 1-1 2v-1h1zM61 119v1-1zM67 120s0-1-1-1h-1v3h1c0 1 0 1 1 1v-3zM53 107h-1 1zM146 159v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5s0 1 1 1zM62 116s0-1 1-1v-4h-2v4c0 1 0 1 1 1zM49 99h1v-1h-1v1zM54 102v1-1zM159 196h-1v5h1v-1s1-1 1-2l-1-1v-1zM171 184h1v-5h-1v1c-1 1-1 1-1 2l1 1v1zM118 133h-1 1zM116 136v5h1c0-1 1-1 1-2-1 0-1 1-1 1v-1c-1-1-1-1 0-2v-1h-1zM163 184s1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM163 176v-1h1v-4l-1-1h-1v5s0 1 1 1zM167 201h1v-5h-1c-1 0-1 1-1 1v4h1zM48 47v-1 1zM167 176l1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM124 139v2h2v-5h-1l-1 1v2zM149 149c0 1 1 1 1 1 1 0 1-1 1-1v-1c-1-1-1-1-2-1v-1 3zM166 164v2l1 1h1v-4c-1 0-1-1-2 0v1zM145 147v2c0 1 0 1 1 1v-1c1 0 1-1 1-2v-1h-2v1zM128 139c0 1 1 1 1 2h1v-5 1h-1c-1 1-1 1-1 2zM133 137v4h2v-3h-1c0-1 0-1 0 0h-1v-1c1 0 1 0 1-1h-1v1zM138 141h1c-1 0-1 0-2-1v1h1zM154 176s1 0 1-1v-5h-1c0 1-1 1-1 2v3c1 0 1 1 1 1zM150 213h-1v5h2v-4l-1-1zM154 210h1v-5l-1-1v1s-1 0-1 1v3l1 1zM150 222h-1v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM141 253zM146 270c1 0 0-1 0-1h2s0-1 1-1h1l-1-1c-1 0-2 0-3-1v4zM150 205v-1s0 1-1 1v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM140 256h-1c-1 0-1 1-1 1v4h2v-5zM154 167h1v-5h-1l-1 1v3l1 1zM155 188s-1 0-1 1v1c0 1 0 2 1 2v1h1v-6h-1v1zM159 184v-1s1-1 1-2l-1-1v-1h-1v5h1zM159 188v4s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1zM154 201h1v-5h-1l-1 1v4h1zM140 265l-1-1v1c-1 0-1 0-1 1v1h1v1h1v-3zM140 239h-1c-1 0-1 1-1 1v3l1 1h1v-2l-1-1h1v-2zM154 184h1v-5h-1l-1 1v4h1zM97 142zM105 11h2s0-1 0 0v-1h-2c-1 0-1 1 0 1zM157 18v-1 1zM90 99h-1 1zM114 11v2h2v-3c-2 0-2 0-1-1h1V8h-2v3zM135 218h1v-4l-1-1h-1v5h1zM111 10h2V8c-1 0-2 1-2 1v1zM147 22zM108 11c1 0 1 0 0 0h2V9h-2v2zM163 61v2c1-1 1-2 0-2zM163 61c1 0 1 0 0 0zM145 62v-1 1zM145 33v1c0-1 0-1 1-1h-1zM137 36v1-1zM148 22h-2v1h-1c1 1 1 0 1 0s1 0 1-1l2-1s0-1-1 0v1zM164 60h-1 1zM158 34zM124 8c0-1 0-1 0 0 1 0 1 0 1-1h1V6s-1 0-3 1h-1 1-1v1h2zM131 14c0-1 0-1-1-1-1 1-2 1-2 1h-2c-1 0-1 0-1 1 1 0 1 1 0 1s-1-1-1-1h-1c-1 1-1 1 0 1v1c1 0 1 0 1 1h3v-1h-1c1-1 1-1 2-1v1s1 0 2-1l1-1v-1zm-1 1c0 1-1 0-1 0h1zM122 8h-1s1 0 1-1c-1 0-2 1-2 1s0 1 2 0zM131 188v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1zM132 12h1c0-1 1-1 1-1v1c1 0 1 0 0 0v1c1 0 1 0 1-1v-1h-1 1V9h-1c0 1 0 1 0 0h-2v3zM127 10v1h2v-1l-1-1-1 1zm1 0c-1 0-1 0 0 0zM131 12c1 0 1-1 1-2h-1 1V9c-1 0-1 1-1 1h-1v2h1zM117 12v1l1-1c1 0 1 0 1-1h-1s0-1-1-1v2zM124 11c1 0 1-1 0-1h-1V9h-1v3c1 0 1 0 2-1zM135 236v-1h1v-4l-1-1h-1v5l1 1zM119 12h3V9l-2 1c1 0 1 0 0 0 0 0-1 1 0 1h-1v1zM113 13v-1c-1 0-1 0 0 0v-1c-1-1-1 0-2 0h1-1v1h1c0 1 0 1 1 1zM135 167s1 0 1-1v-3c0-1-1-1-1-1h-1v4c0 1 1 1 1 1zM110 11l-1 1h1v-1zM111 10v1-1zM23 28v-1 1s0 1-1 1v1h2c-1-1-1-1-1-2zM146 236v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5s0 1 1 1zM26 27h-2v3h2v-3zM16 39h1v-1s1-1 1-2-1-1-1-2h-1v1l-1 1c0 1 1 2 1 2v1zM15 35c-1 0-1 1-1 1v2h1v-3zM13 44c-1 0-1 1-2 1v1h1s1 0 1-1v-1zM14 44v1h1v-2l-1 1zM30 26c1 0 0 0 0 0v1-1zM45 36v-2h-1v1c-1 0-1 1-1 1 0 1 1 2 1 2h1v-2zM10 45v1h1c-1 0-1-1-1-1zM139 201h1v-5h-1c-1 0-1 1-1 1v4h1zM17 42c0 1 0 1-1 1v1h-1 2v-2zM48 43v1-1zM139 210h1v-5c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1zM132 247c-1 0-1 0-1 1v4s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1zM135 210l1-1v-4h-1v-1s0 1-1 1v4c0 1 1 1 1 1zM139 236s0-1 1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM127 246c-1 0-1 1 0 1v-1zM125 244c1 2 1 2 2 1v-1h-2zM9 47v1l1-1H9zM150 231v3c1-1 1-2 0-3zM134 264c-1 0 0 0 0 1 0 0 0-1 1-1h-1zM52 105zM135 201s1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM135 13h1c1 0 1 0 2-1v-2h1V9h-2l1 2h-3v2zM6 46H5c0 1-1 1-1 1v1h1v-1h2c-1 0-1-1-1-1zM3 48v-1c-2 0-3 1-3 2h1c0-1 1-1 1-1h2-1zM41 79zM8 47h1v-2s-1 1-2 1v1h1v1-1zM48 46zM40 37h-1c0 1 0 1 1 1v-1zM48 45zM366 93h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1s0-1 1-1v-5zM118 21c1 0 1 0 2-1-1 0-1-1-2-1v2zM359 73v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 1-1 1v4c0 1 0 1 1 1zM359 56v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1zM111 16h-1v1c-1 0-1 0-1 1v3c1 0 1 1 1 1l1-1v-5zM359 30v-1c1 0 1-1 1-2s0-1-1-1v-1h-1v4c0 1 0 1 1 1zM118 17v1c0-1 0-1 1-2 0 0-1 0-1 1zM359 39v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4s0 1 1 1zM358 81c1-1 1-2 1-3 0 0 0-1-1-1v-1h-1v5h1zM155 16c0 1-1 1-1 2v1c0 1 0 1 1 2v1l1-1v-4h-1 1v-1h-1zM159 19c1 0 1 0 0 0v2s0 1 1 1v-1c-1 0-1 0 0 0 0-1 1-1 1-1h-1 1v-1h-1v-1c-1 0-1-1-1-1v2zM354 30h1v-5h-1s0 1-1 1v2s0 1 1 1v1zM132 16h-1v5s0 1 1 1v-5c-1 0 0 0 0 0v-1zM122 25h-1v5h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zm0 0c-1 0 0 0 0 0zM127 22v-1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M133 17v-1h2c1 0 5-2 4-2 0 0 0-1-1-1h-2c-1 0-3 0-2 1h-2c0 1 0 1-1 1v1h1l1 1zM360 22v-1h1v-4c-1 0-1-1-1-1h-1v5s0 1 1 1zM379 22s0-1 1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM375 22v-1h1v-4l-1-1h-1v5s0 1 1 1zM374 30l1-1v-3l-1-1h-1v4c0 1 0 1 1 1zM383 22c1 0 1 0 1-1v-5h-1c0 1 0 1-1 2v1c0 1 0 1 1 2v1zM390 81h1v-4l-1-1h-1v5h1zM387 30v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM374 64l1-1v-3l-1-1h-1v5h1zM95 16v1c-1 0-1 0-1 1h2v-1l-1-1zM365 73h1v-5c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1zM369 30h1v-5h-1v1c-1 1-1 1-1 2 0 0 0 1 1 1v1zM355 85h-1l-1 1v1c0 1 0 2 1 2v1h1v-5zM355 93h-1c0 1 0 1-1 1v2c0 1 0 1 1 2v1l1-1v-5zM366 22s0-1 1-1v-5h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM103 13h-1 1zM365 47h1v-5h-1c-1 0-1 1-1 1v4h1zM354 56h1v-6h-1v1l-1 1v1c0 1 0 2 1 2v1zM136 26c0-1-1-1-1-1h-1v1s1 0 1 1l-1 1v-1 3h1s1 0 1-1l-1-1v-1 1h1v-2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M136 30h-1c-1 0-1 0-2-1v-2s-1 1-1 2h-1v1h1-2s0 1-1 1-1 1 0 1c1-1 1-1 1 0s0 1 2 0l1-1h1c0-1 1 0 1 0 0 1 1 1 2 0h1v-1h-1s0-1-1-1v1zM333 85h-1v4c0 1 1 1 1 1l1-1v-4h-1zM333 59h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM140 25h-1c-1 0-1 1-1 1h2v-1zM338 70v-2l-1-1v1c-1 0-1 0-1 1v3l1 1h1v-3zM338 85h-1c-1 0-1 0-1 1v3l1 1h1v-5zM342 85h-1v1c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-5zM341 67v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-4c-1 0-1-1-1-2zM131 47h-1 1zM342 93h-1v1c-1 1-1 1-1 2s1 1 1 2h1v-5zM118 33c-1 0-1 0-1 1v1c1 0 1 0 1-1v-1zM341 81v-5h-1s0 1-1 1v2c0 1 0 1 1 2h1zM114 34c0-1 0-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2l1-1v-3zM122 51v-1s0 1-1 1v4c0 1 1 1 1 1 1 0 1-1 1-1v-3c-1-1-1-1 0-1h-1zM150 30c1 0 1 0 1-1v-3h-1c-1 0-1 1-1 1v3h1zM350 73h1v-5h-1v-1 1c-1 0-1 0-1 1v3c0 1 1 1 1 1zM159 25h-1v4c0 1 0 1 1 1v-1c-1 0-1 0-1-1v-1c1 0 1 0 0 0h1c0-1 0-1 1 0l-1-1v-1zM146 30v-1c1 0 1 0 1-1h-2v2h1zM150 33zM167 26h-1v1l1-1v-1h-1v1h1zM354 47h1v-5h-1s0 1-1 1v2s0 1 1 2zM391 39v-1h1v-4l-1-1-1 1v4l1 1zM155 33h-1v1h-1 2v1-2zM148 17c-1 0-1-1-1-1h-1v5h1l1-1v-3zM354 39s1 0 1-1v-5h-1c0 1 0 1-1 2v1c0 1 0 1 1 2v1zM350 64h1v-4c0-1 0-1-1-1s-1 1-1 1v4h1zM350 47h1v-4c0-1 0-1-1-1s-1 1-1 1v4h1zM350 93l-1 1v4l1 1s0-1 1-1v-4s0-1-1-1zM354 64h1v-5h-1s0 1-1 1v2c0 1 0 1 1 2zM144 29v-1h-1c-1 1-1 2-1 2h3s-1 0-1-1zM337 64h1v-5h-1c-1 0-1 1-1 1v4h1zM95 22c0-1 0-1-1-1l1 1zM370 85h-1v1c-1 0-1 1-1 1 0 1 0 2 1 2v1h1v-5zM370 68h-1v1c-1 0-1 1-1 1 0 1 0 2 1 2v1h1v-5zM370 110h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2v1c1 0 1 0 1-1v-5zM100 21v-1h-2c0 1 1 1 1 1s0 1 1 1v-1zM86 22h1v-1h-1l1-1c0-1 0-1-1-1l-1 1 1 1v1zM82 22h1v-2h-2v1l1 1zm0-2h-1 1zM374 110s-1 0-1 1v4s0 1 1 1v-1h1v-4c-1 0-1 0-1-1zM378 102c-1 0-1 1-1 1v4h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM104 17v-1c-1 0-1 0-1 1v2h2c0-1 0-1-1-2zM378 110v1c-1 0-1 0-1 1v3l1 1v-1h1v-4l-1-1zM374 93h-1v5s0 1 1 1v-1h1v-4c-1 0-1-1-1-1zM104 22v-1l1-1h-2v1s0 1 1 1zM374 102h-1v4c0 1 0 1 1 1l1-1v-3l-1-1zM369 81v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2h1zM378 119c-1 0-1 1-1 1v4h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM49 73s1 0 1-1v-3l-1-1h-1v5h1zM406 33l-1 1v4c0 1 1 1 1 1l1-1v-4l-1-1zM402 59h-1v5h2v-4c-1 0-1-1-1-1zM49 85h-1v5h1s1 0 1-1v-3l-1-1zM410 25l-1 1v2s0 1 1 2h1v-5h-1zM78 22c0-1 1-1 1-1h-1c-1 0-1 0 0 0h-1c0 1 1 1 1 1zM94 133c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM401 82v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5s0 1 1 1zM45 21c0 1 0 1 1 1v-1c1-1 1-1 1-2h-2v2zM415 64c1-1 1-2 1-3 0 0 0-1-1-1v-1h-1v5h1zM366 85h-1c-1 0-1 0-1 1v3l1 1h1v-5zM74 22v-1s-1 0-1 1h1zM21 34h-1v4c0 1 0 1 1 1l1-1v-4h-1zM391 30c1 0 1 0 1-1v-3c0-1 0-1-1-1h-1v5h1zM41 22h1v-2h-2c0 1 0 1 1 1v1zM37 22c1 0 1-1 1-1-1 0-1 0-2 1h1zM387 73v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM387 64v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5h1zM387 119h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM387 33c-1 0-1 0-1 1v4s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1zM100 18l-1 1h1v-1zM387 56v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 1-1 1v4c0 1 0 1 1 1zM387 102h-1v5h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM386 81c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5h1zM396 102h-1l-1 1v2s0 1 1 2h1v-5zM396 22s1 0 1-1v-5h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1zM395 56h1v-5c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1zM396 110h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-6zM391 110l-1 1v4c0 1 1 1 1 1l1-1v-4l-1-1zM391 93h-1v5l1 1v-1h1v-4s0-1-1-1zM387 85h-1v4c0 1 0 1 1 1v-1c1 0 1-1 1-2s0-1-1-2zM383 85h-1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-5zM378 42c-1 0-1 1-1 1v4h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM378 51v-1 1c-1 0-1 0-1 1v3c0 1 1 1 1 1l1-1v-4h-1zM378 68c-1 0-1 0-1 1v3c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM378 59c-1 0-1 1-1 1v4h1c1 0 1 0 1-1v-3c0-1 0-1-1-1zM378 93c-1 1-1 1-1 2v3l1 1v-1h1v-4s0-1-1-1zM100 17v1-1zM378 85c-1 0-1 0-1 1v3c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM382 39s1 0 1-1v-5h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1zM383 128c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-5zM99 16v1h1v-1h-1zM382 73h1v-5h-1s-1 0-1 1v1c0 1 0 2 1 2v1zM383 93h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1s1 0 1-1v-5zM382 47h1v-5h-1l-1 1v2s0 1 1 2zM382 56h1v-5c0-1-1-1-1-1v1s-1 0-1 1v1c0 1 0 2 1 2v1zM378 33v1c-1 0-1 0-1 1v3l1 1v-1h1v-4l-1-1zM322 201h1v-4c0-1 0-1-1-1 1 2 1 2 0 3 0 1 0 1-1 2h1zM373 172zM373 172zM328 188zM388 145v1h1c0-1 1-1 1-1v-3c-1 0-1-1-2-1v-2c0-1-1-1-1-1v1h-1c0 1 0 1 1 1v1h-1 1v3l1 1zM387 145s0 1 1 1l-1-1zM99 96v-3h-1v1s-1 0-1 1v2h1v1h1v-2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m390 141-1-1v1h1zM330 193v-1c1-1 1-1 1-2s0-2-1-2v-1h-1v5s0 1 1 1zM323 207v-2l-1-1v1c-1 0-1 0-1 1v2c0 1 1 1 1 1h1v-2zM73 111h-1v1c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-5z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M332 194c0-2 0-2 1-2v-2l-1-1 1 1h1v-2h-1c0-1 0-1 1-1 0-1 0-1-1-2v-1h-1c1 0 1 0 1-1l-1-1v1c-1 0-1 0-1 1s0 1-1 1c0-1 0-1 0 0-1 0-1 0-1 1v1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4c0 1-2 1-3 2h-1v3h-2v2l1 1c1 1 1 1 1 2v2l-1 1h-2c-1 1-1 3 0 4v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 0-1 1 0 0 1 0 2-1h1s1-1 1-2h1v-2h-1c1 0 1-1 1-1 1 0 1-1 1-1 0-1 0-1 1-2h-3 1v-5h-1c1 0 1 0 2-1v6h1c0-1 0-2 1-4 0-1 1-2 1-3zM86 96v-2c0-1 0-1-1-1v1l-1 1v3h2v-2zM76 102v4-2c1-1 1-1 1-2h-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M323 192h-1v1h1v-1zM205 124v-1 1zM249 59h-1v5h1c1 0 1 0 1-1v-3c0-1-1-1-1-1zM260 56v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1h-1v5s0 1 1 1zM260 64v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v4c0 1 0 1 1 1zM119 82v1-1c1 0 1 0 1-1l-1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M120 79v-2c-1 0-1-1-1-1h-1v5l1 1v-1c0-1 0-1 0 0h1v-2zM269 42h-1s-1 0-1 1v1c0 1 0 2 1 2v1c1 0 1 0 1-1v-4zM264 56v-1h1v-4s0-1-1-1h-1v5l1 1zM123 76c-1 1-1 1-1 2v1l1-1s1 0 1-1c0 0 0-1-1-1zM375 151c-1 0-1 0-1-1v1s1 0 0 0c0 0 0 1 1 1h-1c1 0 1 1 1 1 0 1 0 1 1 0h-1v-2zm0 2zM114 86v-1h-1l-1 1v2s0 1 1 1h1v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M249 55v1h1-1c0 1 0 1-1 1s-1 1-1 1h-3c0-1 0-1 0 0v1s1 0 1-1v6h1-2v3h1l1 1v4l-1 1c-1 0-1 0-2-1v-2h-2v3h-2 1v-3h-2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-1 1c0 1-1 1-1 2v1h-2v3h1v4c0 1 0 1-1 1v1c-1 1 0 1 0 1h2c1 0 1 0 2 1h1s1 0 1 1c0-1 2-1 3-1h2s0-1 1-1c0-1 0-1 1-1v-1h-2 1v-5h-1 2v5h1v-1h1v-1c-1 0-1-1 0-2 0-1 2-2 2-2s1-1 2-1c1-1 2-1 1-2v-1c0-1 1-1 3-1v-2l1-1c1 0 1 0 2 1v2h1v-2s1 0 1-1h1s1 0 1 1v1h1v-1c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1 0 0 2 2 3 2h1c0 1 1 1 1 1h3v5-1l1-1v-1l-1-1 1-1h1c0-1-1-1-1-1-2-1-2-1-2-2 1 0 1 0 0 0h-1c-1 0-1 0-2-1v-1 2h-2 1v-3l-1-1c-1 0-1-1-1-2 0 0 0-1 1-1h1v1h1v1h1v-1 2s1 1 2 1v-2h-1c1-1 1-1 2-1v4h1-1 1c0 1 1 1 1 1v-4c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-1 1v2c-1 1-1 1 0 2 0 0 1 0 0 0 0 1 0 1 1 1v1c1 0 1 0 0 1 0 0 0 1 1 1v-5h-1 1v4h1v1c0 1 0 1 1 2v1c1-1 1-1 1 0h1v1c1 0 0-1 0-2v-1h1s0-1 0 0c1 0 1 0 1-1h1v1c1 0 1 0 0-1l-1-1s0-1-1-1v2h1-2v1-1h-1 1v-3s-1-1-1-2h2v1s1 0 0 0c0-1 0-1 0 0 1 0 1 0 1-1-1 0-1 0 0-1v1c0-1 0 0 0 0s1 0 1-1h1l1 1h2c0-1 1-1 1-1h1c1-1 1-1 0-1s-1-1-1-1h-1v-1c0-1 1-1 1-1v-3h-1c0-1 1-1 1-1v3s0-1 1-1v-1l1-1c0-1 0-1 1-2v-2s-1-1-1-2l1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2c0 1-1 1-1 1h-1c1 1 2 1 3 1h1-1l-1 1c1 0 1 0 1 1h2l1 1v-1h3c0-1 0-1 1 0 0 1 0 1 1 1h1v-1h1c1 0 1 0 1 1 1 0 1 0 1 1h1v-1l1-1c1 0 1 0 2 1v3h2v-3l1-1v4h1l1 1c2 2 5 3 7 4h1l-3-3c0-1-1-1-1-2v1c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2s0-1 1-2v-1h1c0-1 2-2 2-1v-1s1-1 2-1c1-1 2-1 2-1v-4h-1 2v4c1 0 1 0 2 1v2h-1c-2 0-2 0-2 1v1c0-1 0-1 1-1v4h2v1-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v2c1 0 2 1 1 2l1 1s1 0 0 1c0 1 0 1 1 1 0-1 1 0 1 2h1v-5h-1v1-1h1v5h1v1h-2v1h-1c-2 1-3 1-4 0s-1-1-2-1h-1l-1-1v-4s0-1 1-1c-2-1-5-2-7-4l-1-1h-1v2h1-2v-2h-2v1l-1 1c0 1-1 2-4 2h-2s0-1-1-1h-2c0-1 0-1-1-1 0 1 0 0 0 0h-4c-1 0-2 1-3 1 0 1 0 1-2 1-1-1-2 0-2 0 1 1 0 1-2 1v5h1-2c1 0 1 1 1 1v1h1l-1 1h2c0-1 1 0 1 0l1 1c1 0 1-1 1-1h1c0-1 2 0 3 1 0 0 0-1 1-1v1c1 0 1 0 2-1 0 0 1-1 1 0h1c1-1 1-1 1 0h-1c1 0 1 1 1 1s1 1 1 2 0 1-1 2v1h-1c0 1 0 2-1 3h1v5h1v1h-2v-1h1v-4c-1 0-1 0-1-1 0 1-1 2-1 2h-2v3h1v1h-1 1v1l2 2s1 0 1-1h1v1s0 1 1 1c0 0 0 1 1 1v1l1 1v-4h-1s1 0 1-1h1v6h-1c1 0 1 0 0 0 0 1 1 2 1 2h1s0 1 0 0v1h1v2c1 0 1 0 1 1-1 0-1 1 0 1v1-4h-1c1-1 1-1 2-1v5c0 1 0 1 1 1h-1c0 1 1 1 1 1l1 1c-1 0 0 0 0 0l1 1v2-2s1 0 1-1v4c1 0 1 1 1 1l1 1c0 1 0 1 0 0h-1c0-1 0-1-1-1v1h1-1c0 1 1 1 1 1s1 1 1 2 1 3 1 4c0 0 0 1 1 1v-4h-1c0-1 1-1 1-1v5h3c1-1 1-1 2-1v-3l1-1h1l1 1v2c1 0 1-1 1-1s1 0 2-1h-1c0-1 1-1 1-1v1h1c2-1 3-2 3-2 0-1 0-1 1-2h2v-4c0-1 0-1 1-1h2v3h1v-2c0-1 1-1 1-1h1v-1c0-1 1-2 1-1h1v-2h1c-1-1-1-1-1-2v-2c0-1-1-1-2-1-2-1-3-2-3-4s0-2-1-1v2h1-3c0 1-1 2-1 2h-2c0-1 0-1-1-1v1h-1c-1 0-1-1 0-1 0-1 0-3-1-3 0 0-1 0-1 1v1h1-2s1 0 1-1h-1v-1c0 1 1 1 1 1v-1h-1v-1l-1-1v-1c0 1-1 0-1 0s-1 0-1-1l-1-2v-1h-1v-4s0-1 1-1h2v4h1v-3l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1 0-1-1v1l1 1 2 2h1l1-1c1 0 1 1 1 1 1 1 1 1 1 2h2v-2h-1c1 0 1 0 2-1v3s1-1 0-1h1c1 0 1 1 1 2l1 1v-4s1 0 1-1v5h1c1 0 1 1 2 1v-1c-1 0-1-1-1-2v-1l1-1 1-1 1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h3c-1 0-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1h3v-5l1-1v6c1-1 2 0 2 0v1h1c0 1 1 2 1 2s1 0 1 1l1-1v2h2c1 0 1 0 0 0h-2v1c1 1 4 3 4 3 1 0 3-2 2-2 0 0 0-1 1-1v5l1 1h2c0 1 1 2 1 2 0 1-1 2-1 2v1h-1c0 1 1 2 1 2 0 1 1 3 1 3v-1c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1v1c1 1 2 4 2 5 0 0 1 0 1 1v-4c-1 0-1 0-1 1v-1h2v5c1 1 2 0 2-1l1-1v-3l-1 1v-1h2v1c1 0 1 0 1-1-1-1-1-3 0-3h-1v-5h-1c1 0 1-1 2-1-1-1 0-1 0-1h1c0-1 0-1 1-1 0 0 1 0 1-1v-1h1v-3c0-1 0-1-1-1h1v3c1 0 2-2 3-2 0-1 1-2 1-2 1 0 1-1 2-1v-2l1-1h3v-3s0-1 1-1v4h1l1-1v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1s1 1 1 2c1 0 1 0 1 1h2c1 1 1 2 1 3v1c0 1-1 1-1 1v2h3c0-1 0-1 1-1v-1 1c-1 0-1-1-2-1v-4l1-1h2v5s1 2 2 3v3s0 1 1 1v-3h-1l1-1v4c1 1 1 1 0 1v1h1-1v2c1 0 1 0 1 1h-1c1 0 1 2 0 3 0 1 1 3 1 3h1v1c0-1 0-1 0 0 0 0 1 0 1 1 0 0 1 0 1 1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1s1 0 1 1v1s1 1 2 1h1v1l1 1v1c0-1 1-1 1 0v-2h1l-1-1c-1-1-1-1-1-3v-2c0-1-1-1-1-2v4h1-3 1v-5h-1v-1h-1c-1 0-1-1-2-2v-1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1l1-1v-3s-1-1-1-2c0 0 0-1 1-1v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2h-1c1 1 2 1 2 1v1h1l1 1c0 1 1 2 1 2v-1 1l1-1h2c0 1 1 2 1 3v1-1c1 0 2-1 2-2 0 0 1 0 1-1h1l1-1s1-1 1-2h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1s-1 0-1-1c-1 0-1-1-1-1-1 0-4-3-4-3v-1 3h1v1h-2v-1h1v-3c-1-1-1-1-1-2v1-2l1-1v-1h1-2l1-1v-3c0-1-1-1-1-1l1-1v6h1v-1c0 1 0 0 0 0s2-1 3-1c0 0 0 1 1 1v-1c-1 0-1 0-1-1 0 0 1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2-1h2v-3h-1c1 0 1-1 2-1v3c0 1 1 0 0-1h1c0 1 1 1 1 1s0-1 1-1h1c-1 0-1 0 0 0v-1h-1l1-1v2c1 0 1 0 2-1v-1c1 0 1 0 1-1h1s1-1 1-2h-2 1v-5h-1 2v5h1v-1s-1-1 0-1v-2c1 0 1 0 1-1v-1h1v-2c-1 0-1 0 0 0l-1-1v-1h-1v1s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1v-1h1v1c0-1-1-1-2-2v-1l-2-2h-1v1h-1c-1 0-1 0-2-1v-3l1-1h2s0-1 0 0v-1c1 0 1-1 2-1 0-1 0-1-1-1h-2c0-1 0-1-1-1v1h1-1c-1 1-1 1-1 0h-1c0-1 0-1-1-1s-1 0-1-1v2h1-3 1v-5h-1c1-1 1-1 2-1v3l1-1s0-1 1-1v-1s1-1 2-1c0 1 1 1 0 2v1c1 0 1 1 1 1-1 0-1 1 0 1 0 0 0-1 1-1v-1l1-1v-1h1c1 0 1 0 1 1 1 0 1 0 1 1h1v-1s0-1 1-1 1 0 2 1v4h-1l1 1c1 0 1 1 1 1-1 0-1 0 0 1s1 1 1 2v2h1v-3h1v3h2v-1c0 1 1 0 1-1v-1c0-1-1-3-2-3 0-1-1-1-1-1v1h-1c-1 0-1 0-2-1v-3c-1 0-1-1 0-1l1-1c1-1 1-1 0-2v-5c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2v2-2s0-1 1-1v-1c1 0 1-1 1-1l1 1c0-1 1-2 1-2v-7c0-1-1-2-1-2 0-1-1-1-1-1h-1 1v-1c-1-1-1-2-1-2 1 0 1 0 1 1v-3h-1s1 0 1-1h-1c-1-1-1-2-2-1h1v2s1 1 1 2l-1-2s-1 0-2-1c-1 0-2-1-2-1-1 0-3-1-2 0l-1 1c0-1 0-1-1-1v-1c0-1-1-1-1-1h-1v1h1c1 1 1 1 0 1 0 1 0 1 0 0s-1-1-2-1c-2 0-2 0-1-1 0-1 1-1 1-1v-4c-1 0-1 0-1 1v-1h2v1-2c1 0 1-1 1-1v-1h5v1s1 0 0-1h4s0-1 0 0h1v-1c-1 0-1-1-1-2 0 0 0-1 1-1v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1 1 0 1 0 1 1-1 0 0 0 0 0h5c0-1 0-1-1-1h-2s-1 0-1-1v-3c0-1 0-1 1-2 1 0 1 0 2 1v1h3c0-1 1-1 1-1 0-1 1-1 1-1s1 0 1 1l1 1h1c-1 0-1-1-1-1-1-1-1-1 0-1 0 0 1 0 1 1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-2v1s0 2-1 2-1 0 0 1v1s1 1 2 3v-5c-1 0-1 1-1 1v-1h2v6l1 1c1 0 1 1 2 1s1 1 2 1v1l2 2v1-4s1 0 1-1v5h1v-3c-1 0-1-1 0-1h1l-1-1-1-1c0-1 0-1 1-1 1 1 1 1 1 0l-1-1s-1 0-1-1v1h1v1h-2v-4l-1-1c0-1-1-1-2-1 0 0-1-1-1-2v-1h-1v-1h1v-4h-1c1 0 1-1 2-1v5c0-1 1-1 1 0h1c0-1 1-1 1-1v-3l1-1v4c1 0 1 0 2 1h1c-1-1-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1h2c0-1 0-1 1-1h1v1h1v-1l-1-1h-1c-1 0-2-1-3-2 0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2 0-1 0-1 1-2v-1h2c1 1 1 2 1 3h2v-3s-1 0-1 1v-1h1-2c-1-1-6-2-11-3h-1s-1 0-1-1h-1c-1 0-1 1-1 1h-1s-1 0-1-1l-1-1h-2v2h1-2v-2h-5l1 1h1l1 1h-1s-1 0-2-1v1h-2 1v-1h-1l1-1h-2c0 1 0 1-1 1h-1v1h1-2 1v-1h-3v1h-1c-1 0-1 0-2-1h-1l-1 1h-1s-1 0-1-1v-2h-1c-1 0-1-1-2-1v3h1v1h-2 1v-4h-2v1c0 1 0 1-1 2v1h-1c-1 0-1 0-2-1v-2s0-1-1-1v3l-1 1h-1s-1 0-1-1v-3c-1 0-2-1-2-1v5h-2 1v-5h-1l1-1h-4v1c0-1 0-1-5-1-4-1-4-1-4 0h1-2c0 1 1 1 1 1h1c-1 0 0 0 0 0l1 1h-1c0-1-1-1-1-1h-1v5h-2 1v-5c-1 0-2 1-2 1h-2v4h1-2v-1h1v-4h-2c1 2 1 2 0 2h-1v2l-1 1h-1s-1 0-1-1v-4l-1-1h-1c0-1-4-2-4-2 0 1 0 1-1 0h-4l1 1h-6v-1h-6l-2-1h-2s-1 1-1 0l-1 1v1h-2v-1h1s1-1 2-1v-3c0 1-1 0 0 0h-1v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 1 0 1-1h-1v3c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2V9s0-1-1-1c0 1 1 2 1 2 0 1-1 1-1 2v1h-1c-1 0-1 0-2-1V8h-1v4s0 1-1 1h-1s-1 0-1-1v-2h-1v2c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2h-3c0 1 0 1-1 1v2h1-2v-2h-2v1l-1 1h-1s-1 0-1-1v1h2v1h-2v-1c-1 0-1 0 0 1h-5l1 1 1 1h1c1 0 1 0 1 1h1v3l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h-3v5h1v1h-2v-4c-1 0-2-1-2-1 0-1-1-2-1-2h-1c-1 0 0 0 0 1h2v5c1 0 1 0 1 1h2c1 0 1 0 0 0s-1 1 0 1c0 1 1 1 0 1v1c0 1 1 1 1 2s-1 2-1 2v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1v-1s1 0 0-1l-1-1h-1v-1c0 1 0 1-1 1l-1-1v-5c-1 0-1-1-2-1h-1c1 0 1 0 0 0 0-1-2-1-2 0v1c0 1-1 1-1 2h-1v1h1v1c0 1 1 1 1 1h2v-5c-1 0-1 1-1 1v-1h2v6h-1 1v1s-1 0-2-1c-2-1-3-1-2 0h-2v-1h1-4v1c-1 0-1-1-2-1v-1h-2c-1-1-1-1-2-1 0 1 0 1 1 1v1c1-1 2 0 3 1-1 0-1 0-1 1 0-1-1-2-1-2-1 0-1 1 0 1h-3c-1 0-2 1-2 1h-1s-1-1 0-1h-2l-1 1h-2l-1 1c-1 0-2 0-2 1-1 1-2 1-2 0v5h-2 1v-5h-1s1 0 1-1h2l-1-1c-1 0-1 0-3-1-1 0-2 1-1 1s1 0 1 1 0 1 1 1v1c0 1 0 1-1 1 0-1 0-1-1-1h-1v4h1-2c1 0 1-1 1-1v-2h-1s-1 0-1 1h-1l1 1c1 0 0 1-1 0h-1v1h1-2 1c0 1-2 1-3 0h-2s-1 0-1-1c0 0-1-1-1-2v-1h1v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2h2v-2h-1c1 0 1-1 2-1v3c1 0 2 0 2-1 1 0 1-1 1-1v-1c-1 0-3-1-3-1h-1c-1 0-1 0-2-1-1 0-2-1-4-1h-1 1v1h-2v-1h1-1c0-1-1-1-2-1h-2 1c0-1-1-1-2-1v2h1v1c-1 0-2-1-2-1v-2c0-1 0-1-1-1 0 0-1 0-1 1v1c0 1-1 1-1 1l-1 1-1-1c0-1-1-1-1-2v1l-1 1c-1 0-1 1-1 1-1 0-1-1-1-1l-1-1c-1 0-1 0 0 0h-2v1h1-1 1-2v-1c0 1 0 1-1 1s-1 0-1 1h-1v-1c0 1-1 1-1 1-1 0-1 0-1 1 0 0-2 0-2 1h1l1-1h1v7h-2 1v-5h-1c0 1-1 1-1 1v3c-1 0-1 1-1 1h-1s-1 1-2 1h1v-1l-1 1h-2s0 1 0 0c-1 0-1 0-1 1-1 0-1 1-1 1h-1s0 1 0 0l-1 1v5h-1s0 1 1 1c0 0 0 1 1 1 0 1 1 1 2 1 0-1 0-1 1-1s1-1 2-1 1-1 1-1 0 1 1 1v2c1 0 1 0 1 1l1 1v1s-1 0-2 1v1h1-1 1l-1 1v-1h-1 1v-1h-1c0-1 0-1 0 0v-1h1c0-1-1-1-1-1v-2h-1v1h-1l1 1c0 1-1 1-1 2 0 0 0 1-1 1v2c1 0 0 1-1 1h-3l1 1v3c0 1-1 1-1 2h-1s-1 0-1-1v-2c-1 1-2 1-4 2h-1zm-13 26h-2 1v-4c0-1 0-1-1-1h1v5h1zm4 0h-2 1v-5h-1 2v5zm45-1c1 0 1 0 0 0zm-1 1c-1 0-1 0 0 0zm13-1c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm4 0c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4c0-1 0-1 1-1h2v4zm4 0v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c0-1 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm0 21s-1 0 0-1v1zm14 24v-1 1zm-2-31v-1 1-1h1v5h1v1h-2v-5zm0-4v-5l1-1v6h1-2zm-10-9c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1l-1 1-1 1-1-1zm4 16c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h2c1 1 1 2 1 3v1zm0-8-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-8v-4c0-1 0-1 1-1h2v4c0 1 0 1-1 1 0 0 0 1-1 1l-1-1zm4 26h-3 1v-5h-1c1 0 1 0 2-1v6h1zm0-8h-3v-1h1v-5l-1 1v-1h2v5h1v1zm0-9h-3 1v-5h-1c1 0 1-1 2-1v6h1zm0-9v-4l1-1h2c0 1 1 2 1 3l-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1zm4 35h-2v-5c0-1 1-1 1-1v5c0 1 1 1 1 1zm0-10v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 1-1 2zm1-25c-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1l-1 1-1 1c-1 0-1-1-1-1zm3 43h-2 1v-5h-1s1 0 1-1v6h1zm0-8h-2l1-1v-4h-1c0-1 1-1 1-1v5h1v1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm0-8h-2v-1h1v-4c0-1-1-1-1-1v1-1h1v5h1v1zm0-9h-2 1v-5h-1l1-1v6h1zm21 21 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1v-4zm-2-1v6h1-3 1v-5h-1c1-1 1-1 2-1zm-6 1v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2zm0 9v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm-3-10v6h1-2v-1h1v-3c0-1 0-1-1-1 0-1 1-1 1-1zm0 8v6h1-2c1 0 1 0 1-1v-3l-1-1s1 0 1-1zm-4-17v6h1-3 1v-5h-1c1 0 1 0 2-1zm0 9v6h1-3 1v-5h-1c1-1 1-1 2-1zm0 8v6h1-3 1v-5h-1c1 0 1 0 2-1zm1-29s0 1-1 1h-1l-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4zm103 48s0 1 1 1h-1v-1zm14-44v6h1-2 1v-5h-1l1-1zm-2 10 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4zm-4-17c0-1 0-1 1-1h2v4c0 1 0 1-1 1s-1 0-2-1v-3zm0 8 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm0 9c0-1 0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm23-44v5h1v1h-2l1-1v-4h-1c0-1 1-1 1-1zm-6-7c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm0 8 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-1 13h-3 1v-5h-1c1 0 1 0 2-1v6h1zm-3-21c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1h1l1 1v3c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm30-18v5h1v1h-3v-1h1v-5s0 1-1 1v-1h2zm2-16 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-2-1v5h1v1h-3v-1h1v-5l-1 1v-1h2zm-5 0h1v6h-2v-1h1v-5h-1 1zm-6 1c1 0 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4zm-4-1v5h-2 1v-5h-1 2zm-6 1v-1h2c1 1 1 2 1 3v1l-1 1-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2zm-3-1v5h1-2v-5h1zm-2 10c0-1 1-1 1-2h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-3zm-2-10v5h1-3 1v-5h-1 2zm0 8v6h1-3 1v-5h-1c1 0 1-1 2-1zm-6-7v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2zm0 9v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm0 17v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm0 8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2zm0 9v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm-5-43 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-4zm2 26h-1c0-1 1-1 1-1v5c1 0 1 1 1 1h-2v-1h1v-4zm-1-4h1v-5h-1s1 0 1-1v6h1-2zm0-8v-1h1v-4s-1 0-1-1v1-1h1v5h1v1h-2zm-1 21 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm-4-43c0-1 0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm1 34h-1c1-1 1-1 2-1v5l1 1h-2v-5zm0-4v-5h-1c1 0 1 0 2-1v6h1-2zm0-8v-6l-1 1v-1h2v5h1v1h-2zm0-9v-5h-1c1 0 1-1 2-1v6h1-2zm-1 30c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-3zm-2 38h-2 1v-5h-1 2v5zm1-9s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2zm-1-8h-2 1v-5h-1c1 0 1 0 2-1v6zm0-65v5h-2 1v-5h-1 2zm-2 9 1-1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 1-1 1-2zm0 9s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-2 1-2zm0 9c0-1 0-1 1-1v-1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1zm1 8v-1l-1 1v-1h2v6h-2v-1h1v-4zm-1 9c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1zm-1 8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 0-1 1-2zm-33 30h-2v-5h1v5h1zm0-9v1h-1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2zm-1-8h1-2v-5l1-1v6zm1-18v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s-1 1-1 2zm4 35h-2 1v-5h-1 1v5h1zm0-8h-2c1 0 1-1 1-1v-4h-1c0-1 1-1 1-1v5s0 1 1 1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm0-17h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1zm-1-9h1v1h-2v-1h1v-5h-1v1-1h1v5zm2 17c0-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1zm4 34-1 1h-1s-1 0-1-1c0 0-1-1-1-2s1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2zm-1-8h-2 1v-5h-1 2v5zm1-9s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2c0 0 0-1 1-1s1 0 1 1c1 0 1 1 1 2v2zm0-9-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-17-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-9c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2c0 0 0-1 1-1h1c1 1 1 2 1 3v1zm0-8-1 1h-1s-1 0-1-1c0 0 0-1-1-1v1c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1c1-1 1-1 1-2h1s1 0 1 1c1 0 1 1 1 2l1-1c0-1 0-1 1-2v-3h-1 1v-5h-1 2v5c1 2 1 2 1 3h-1v-1 1h1v1h-1c1 0 1 1 1 2v2zm-6-8h1-2 1v-5h-1 1v5zm5-9v1h-2 1v-5h-1c1 0 1-1 2-1v5zm5 77s0 1-1 1-1 0-2-1v-4s1 0 1-1h1l1 1v4zm0-9c0 1 0 1-1 1h-2v-4c0-1 1-1 1-1h2v4zm-2-38h-1c1 0 1 0 2-1v6h1-2v-5zm1 16v6h1-2v-5h-1c1 0 1 0 2-1zm0 9v6h1-2v-5h-1c1-1 1-1 2-1zm5 30v1c-1 0-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm-1-16h1-2 1v-4c0-1-1-1-1-1h1v5zm0 3v6h1-2 1v-5h-1l1-1zm1-12v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm0-9v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1 1-1 1 1c1 1 1 1 1 2s0 2-1 2zm-1-21h-1s1 0 1-1v6h1-2 1v-5zm0-21h1-2 1v-4l-1-1h1v5zm0 3v6h1-2 1v-5h-1l1-1zm0 9v5h1v1h-2v-1h1v-4h-1v-1 1-1h1zm6 64c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm-1-7h-2 1v-5h-1c1 0 1-1 1-1h1v6zm1-10c0 1-1 1-1 1h-2c0-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 2v2zm0-8s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-9c0 1-1 1-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2zm-2-21h-1c1 0 1 0 1-1h1v6h-2 1v-5zm6 68h-1c0-1 1-1 1 0zm0-4s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4zm-1-8h1v1h-3v-1h1v-5l-1 1v-1h2v5zm1-9s0 1-1 1h-1s-1 0-1-1v-4l1-1h1l1 1v4zm0-9c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4c0-1 0-1 1-1h2v4zm0-8-1 1h-1s-1 0-1-1v-4l1-1h1l1 1v4zm-2-30h-1c1 0 1 0 2-1v6h1-3 1v-5zm-1-25s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm0-7v-2l1-1h1l1 1v4s0 1-1 1h-1s-1 0-1-1v-2zm0 16c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm2 24v6h1-3 1v-5h-1c1 0 1 0 2-1zm1-3v-4l1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1zm3-17h1v1h-2v-1h1v-3c0-1-1-1-1-1v-1 1-1h1v5zm0 3v6h1-2s1 0 1-1v-3l-1-1s1 0 1-1zm0 60v6h1-2l1-1v-3l-1-1 1-1zm1-21v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c0-1 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm-1-8v1h1-2v-1h1v-3c0-1-1-1-1-1 0-1 1-1 1-1v5zm1-9v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2s0 2-1 2zm0-34v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm0-9v1l-1 1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm0-8v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm0-13c0 1 1 2 1 2 0 1 0 2-1 2v1h-3v-4c0-1 1-1 1-1h2zm-2-9v6h1-2v-5c0-1 1-1 1-1zm-2 9v4c0 1 0 1-1 1h-2v-4c0-1 0-1 1-1h2zm-4-3h1v-5h-1c1-1 1-1 2-1v6h1-3zm2 54v6h1-3 1v-5h-1c1-1 1-1 2-1zm-4-51h1v5h-2 1v-5h-1 1zm0 8h1v6h-2 1v-5h-1c1 0 1-1 1-1zm0 9h1v5h-2 1v-5h-1 1zm0 8h1v6h-2 1v-5h-1c1 0 1-1 1-1zm-1 10v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s0-1 1-2zm-1 16h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1zm-4-50 1-1h2c1 1 1 2 1 2 0 1 0 2-1 2v1h-2c-1-1-1-2-1-2v-2zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2zm0 42h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4l1-1zm-2-51v5h1-2v-5h-1 2zm-2 9s1 0 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm1 17h-1c1 0 1-1 2-1v6h1-2v-5zm0-4v-5h-1 2v5h1-2zm-1 13 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm1 16v5c0 1 0 1 1 1h-3c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1zm-3-51c1 1 1 2 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1l-1-1c0-1 1-2 1-2 0-1 0-1 1-1h1zm-2-9h1v6h-2 1v-5h-1l1-1zm-1 20v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2zm-2-11v5h1-2 1v-5h-1 1zm-1-9v5s0 1 1 1h-2l1-1v-4h-1c0-1 1-1 1-1zm0 60v5h1v1h-2v-1h1v-4h-1c0-1 1-1 1-1zm-1-14-1 1v1l-1 1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3zm-2-24v1h1-2v-5s0-1 1-1v5zm0 4v5h1-2v-5h1zm0 8v6h1-2v-5s0-1 1-1zm0-25v5h1-2v-5h1zm-1-9v6h1-2v-5h-1c1-1 1-1 2-1zm-2 61 1-1h1l1 1v3c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm-33 30h-2 1v-5h-1s1 0 1-1v5c0 1 1 1 1 1zm1-10-1 1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1zm0-8c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-8c0-1-1-1-1-2s1-1 1-2c0 0 0-1 1-1h2v4c0 1-1 1-1 1 0 1 0 1-1 1l-1-1zm0-17c-1 0 0 0 0 0zm4 51-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4zm-1-17c0 1 0 1 1 1h-3c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1v5zm0 3v6h1-3 1v-5h-1c1 0 1 0 2-1zm1-12s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm0-17s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-2 1 0 1 0 2 1v4zm-1-34v1h1-3 1v-5h-1c1-1 1-1 2-1v5zm0 4v5h1-3 1v-5h-1 2zm0 8v6h1-3 1v-5h-1c1 0 1-1 2-1zm0 9v5c1 0 1 0 0 0h1-3 1v-5h-1 2zm2 23v-6 1l-1-1h2v5h1v1h-2zm2-9h1-2v-5s0-1 1-1v6zm-1 12 1-1v6h1-2v-5zm2 30v1h-1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2zm0-9v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1s0-1 1-1l1 1c0 1 1 1 1 2s-1 2-1 2zm0-8v1h-1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2 0 0-1 1-1 2zm2-21h-1v-1 1-1h1v5h1v1h-2v-1h1v-4zm3 46-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2l1-1h2c1 1 1 2 1 3v1zm0-8c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm0-9-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c1 0 1-1 1-1l1 1c1 1 1 1 1 2v2zm0-8c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm0-9c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1 1-1 1 1c1 1 1 1 1 2v2zm0-17c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1 1-1s1 0 1 1c1 0 1 1 1 2v2zm0-9-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm0-8c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm0-9-1 1h-2c-1-1-1-2-1-2v-2l1-1h2c1 1 1 2 1 2v2zm0-8c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2zm1 39v-1c-1 0-1 1-1 1v-1h2v6h-2v-1h1v-4zm0-34c0-1 0-1 1-1h2v4c0 1-1 1-1 1h-2c0-1-1-2-1-2 0-1 1-2 1-2zm-1-7c0-1 1-1 1-2l1-1c1 0 1 0 2 1v4s-1 0-1 1h-1s-1 0-1-1-1-1-1-2zm1 15 1-1c1 0 1 0 2 1v4l-1 1h-1s-1 0-1-1c0 0-1-1-1-2s1-1 1-2zm1 9v-1h-1 2v6h-2v-1h1v-4zm-1 9c0-1 0-1 1-1v-1c1 0 1 0 2 1v4l-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1zm3 63-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 1-1 1-2l1-1c1 0 1 0 2 1v4zm-1-25h-2 1v-5h-1c1 0 1 0 2-1v6zm0 3v6h-2 1v-5h-1c1-1 1-1 2-1zm0 9v5h-2 1v-5h-1 2zm1-21s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2c0 0 0-1 1-1s1 0 2 1v4zm0-9-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm0-8v-4s0-1 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1zm2-38v-1h-1 2v5h1-2v-4zm1-4c-1 0-1 0-2-1v-4s1 0 1-1h1l1 1v4l-1 1zm-2 12s1 0 1-1h1l1 1v4s0 1-1 1-1 0-2-1v-4zm0 9 1-1h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1-1 0-2-1v-3zm3 54c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4c0-1 1-1 1-1h2v4zm-1-8v1h1-2v-5h-1c1-1 1-1 2-1v5zm1-9c0 1 0 1-1 1s-1 0-2-1v-3c0-1 1-1 1-1s0-1 1-1c0 0 0 1 1 1v4zm-1-8v1h1-2v-5h-1c1-1 1-1 2-1v5zm1-9s0 1-1 1-1 0-2-1v-3c0-1 1-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm4 26v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm-1-8h1-2 1v-5h-1 1v5zm1-9v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm-1-8h1-2 1v-5h-1s1 0 1-1v6zm0-22h-1l1-1v6h1-2 1v-5zm0-21h1-2 1v-4c0-1 0-1-1-1h1v5zm0 3v6h1-2 1v-5h-1l1-1zm0 9v5h1v1h-2v-1h1v-4s0-1-1-1v1-1h1zm3 18h-1c0-1 1-1 1-1h1v6h-2v-1h1v-4zm2-13v1h-2v-1h1v-5c-1 0-1 0-1 1v-1h2v5zm-1 3h1v6h-2 1v-5h-1c1 0 1 0 1-1zm0 27h-1l1-1h1v6h-2 1v-5zm-1-4h1v-5h-1c1 0 1 0 1-1h1v6h-2zm1 28zm2-3s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-9c0 1-1 1-1 1h-1s-1 0-1-1l-1-1c0-1 0-2 1-2v-1h2c1 1 1 1 1 2v2zm-2-89s0-1 1-1 1 0 2 1v4s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2zm0 7h1v6h-2 1v-5h-1c1 0 1 0 1-1zm0 9h1v6h-2 1v-5h-1c1 0 1-1 1-1zm0 9h1v5h-2 1v-5h-1 1zm-1 9v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-2zm-2-35v5s1 0 1 1h-2l1-1v-4h-1c0-1 1-1 1-1zm-3 10 1-1 1-1 1 1c1 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zm0 42h2c0 1 1 2 1 3 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4c1 0 1-1 1-1zm-1-60v6h1-2v-5c0-1 0-1 1-1zm-1-2c1 0 1 0 0 0h-1c0-1 1-1 1 0zm-1 11s0-1 1-1c0 0 0 1 1 1v4c0 1 0 1-1 1s-1 0-2-1v-3c0-1 1-1 1-1zm-4-8s0-1 1-1 1 0 2 1v4l-1 1h-1s-1 0-1-1v-4zm1 7v6h-2 1v-5h-1c1 0 1 0 2-1zm-5-7v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 0-1 1h-1l-1-1c-1-1-1-1-1-2s0-1 1-2zm0 7v6h1-2 1v-5h-1s1 0 1-1zm-5-7 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-1 9c0-1 1-1 1-1s0-1 1-1l1 1c0 1 1 1 1 2s-1 2-1 2v1h-1c-1 0-1 0-2-1v-3zm1 25s0-1 1-1v6h1-2v-5zm0-4v-5h1v5h1-2zm0-8v-5c0-1 0-1 1-1v6h1-2zm-1 21 1-1h2c0 1 1 2 1 3l-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4zm0 4h-1 1zm-1-48v5c0 1 0 1 1 1h-3c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1zm-2 9v-1c1 0 1 1 2 1v4s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1zm-4-8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2zm0 7v5c0 1 1 1 1 1h-2 1v-5h-1s1 0 1-1zm0 9v5h1v1h-2 1v-5h-1c0-1 1-1 1-1zm-1 10v-1h2c1 1 1 2 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-1 0-1 0-2 1-2zm0 22v-1h1v-5h-1 1v5h1-1v2h-1v-1zm0-9h1v-5h-1l1-1v5s1 0 1 1h-2zm0 13v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1zm0 7v5h1v1h-2v-1h1v-4c0-1-1-1-1-1v1-1h1zm-8 21c0 1-1 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1 1 0 2 1v3zm0-8-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm-2-21h-1c1 0 1-1 2-1v6h-2 1v-5zm6 31h-2v-5c0-1 0-1 1-1v5c0 1 0 1 1 1zm0-9h-2v-5l1-1v6h1zm-2-73 1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1v1l-1 1c-1 0-1-1-2-1v-4zm-1 9c0-1 1-1 1-1s0-1 1-1c0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-3zm0 8 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm1 8h1v5h1-2v-5zm-1 9s1 0 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm1 9v-1h1v5h1-2v-4zm-1 9c0-1 1-1 1-2h1l1 1v4s0 1-1 1-1 0-2-1v-3zm0 7h2v4c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1zm-1-60v5s0 1 1 1h-3c1 0 1-1 1-1v-4h-1c1-1 1-1 2-1zm-3 10c0-1 0-1 1-1v-1c1 0 1 1 2 1v4l-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1 1 0 2 1v4s-1 0-1 1h-1s-1 0-1-1v-4zm0 9c0-1 0-1 1-1h2v4c0 1-1 1-1 1h-1s-1 0-1-1v-3zm0 8 1-1c1 0 1 0 2 1v4s-1 0-1 1h-1s-1 0-1-1v-4zm0 9c0-1 0-1 1-1h2v4c0 1-1 1-1 1s0 1-1 1l-1-1v-4zm1 16v6h-2v-1h1v-5s-1 0-1 1v-1h2zm-2 21-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v1zm-2-7h1-2 1v-5h-1s1 0 1-1v6zm1-67h-1s0-1-1-1c0 0 1 0 2 1zm-1 1v6h1-2 1v-5h-1s1 0 1-1zm0 9v5s1 0 1 1h-2 1v-5h-1c0-1 1-1 1-1zm-2 10 1-1h2c1 1 1 1 1 2v2l-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-1v-2zm2 8h-1l1-1v5c0 1 1 1 1 1h-2 1v-5zm-2 9 1-1h2c1 1 1 2 1 3v1l-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2v-2zm0 8c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2zm1 8v5h1v1h-2v-1h1v-5h-1v1-1h1zm-23-16h1-1zm1 0zm0 2zm7 1v1h-3v-4c0-1 1-1 1-1h2c0 1 1 2 1 2 0 1 0 2-1 2zm1 12v1h-1v-1c-1 0-1 0-2-1 0-1 1-1 2 0l1 1s1 0 0 0zm2-2s-1 0-1-1c-1 0-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2l-1 1h-1zm-2-11c0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2zm-1 27v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm4 10h-2v-1h1v-4s0-1-1-1v1-1h2v6zm1-10-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-8v-4s0-1 1-1h2v4c0 1-1 1-1 1 0 1 0 1-1 1l-1-1zm1-14v1s1 0 1-1v-2h1v1h-1 2v6s0 1-1 1h-1s-1 0-1-1v-5zm2-3h1-3 1v-5h-1 2v5zm-1 2v1s0 1 0 0c-1-1-1-1 0-1zm0-24h-1c1 0 1 0 2-1v6h1-3 1v-5zm2 55c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1 1 0 2 1v3zm0-8s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 0 2 1v4zm4 8v1l-1 1c-1 0-1-1-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1zm0-8v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s-1 1-1 2zm-1-56v6h1-2v-5c0-1 1-1 1-1zm0 8v6h1-2v-5s1 0 1-1zm0 9v6h1-2v-5l1-1zm0 9v5h1-2v-5h1zm-2 9s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2v1h-1c-1 0-1 0-2-1v-4zm0 8h2c0 1 1 2 1 3l-1 1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4l1-1zm0-12h-1 1zm-4-38c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1 1 0 2 1v4l-1 1h-1s-1 0-1-1v-4zm0 19zm-3-29c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1zm-4 14v1h1-2v-1h1v-3c0-1 0-1-1-1 0-1 1-1 1-1v5zm5 0v1h-2 1v-5h-1c0-1 1-1 1-1h1v5zm-1 3h1v6h-2 1v-5h-1s1 0 1-1zm-6 2c0-1 1-1 1-1l1-1 1 1c0 1 1 1 1 2s0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm0-16v-1c0-1 1-1 1-1 0-1 1-1 1-1l1 1v1l2-2-2 2c1 0 1 1 1 1 0 1 0 1-1 2v1h-1c-1 0-1 0-2-1v-2c-1 0-1 1-1 1s0-1 1-1zm-2-3v6h1-3 1v-5h-1c1 0 1 0 2-1zm0 9v5c0 1 0 1 1 1h-3c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1zm-2 10c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4c0 1 0 1-1 1h-1l-1-1v-3zm-2 12h2v-4l1-1h1l1 1v3h1v-3s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2h2c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1v-2 2c1 0 1 1 1 2v2s-1 0-1 1h3v-5h-1c1-1 1-1 2-1v6h1-3 1-4s-1 0-1-1h-2v1h-1c-1 0-1 0-2-1v-1h-1v1l-1 1h-1l-1-1h-2s-1 0-1 1c0-1 1-1 1-1zm-2 9h-2 1v-5h-1 1v5h1zm0-8h-2 1v-5h-1c0-1 1-1 1-1v5c1 0 1 1 1 1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zm-2-21v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1zm0 8v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1l-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2s0-1 1-2zm-6 30h-3 1v-5h-1 2v5h1zm3-40v6h1-2v-5s1 0 1-1zm0 9v5c0 1 1 1 1 1h-2v-5c0-1 1-1 1-1zm0 8v6h1-2v-5s1 0 1-1zm0 9v6h1-2v-5c0-1 1-1 1-1zm-2 10c0-1 1-1 1-1h2c0 1 1 2 1 2 0 1 0 2-1 2v1h-1c-1 0-1 0-2-1v-3zm-4-34c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1h-1s-1 0-1-1v-3zm0 8s0-1 1-1 1 0 2 1v3c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm1 8h-1c1 0 1 0 2-1v6h1-3 1v-5zm-1 9s0-1 1-1 1 0 2 1v4l-1 1h-1s-1 0-1-1v-4zm-10 13h-2v-5h-1 2v5h1zm7-31h1v6h-2l1-1v-4h-1c0-1 1-1 1-1zm0 8h1v6h-2 1v-5h-1s1 0 1-1zm-1 10v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2zm-5-17c1 0 1-1 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-2-1v-4zm2 8h-1s1 0 1-1v6h1-2c1 0 1 0 1-1v-4zm-2 9c1 0 1-1 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2v1h-1c-1 0-1 0-2-1v-4zm0 13h2v-5h-1 1v4h2v-1c0-1 0-2 1-2v-1h2c1 1 1 1 1 2v2c0 1-1 1-1 1h-1s-1 0-1-1h-1s0 1-1 1h1v1h-1c0 1 0 1-1 1h-2l-1-1 1-1zm-2-31v5h1v1h-2v-5h-1c1-1 1-1 2-1zm-2 10c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1v-3zm0 8s0-1 1-1h1l1 1v4l-1 1c-1 0-1 0-2-1v-4zm-2 5h-2 1v-5h-1l1-1h1v6zm0-9h-2 1v-5h-1c1 0 1 0 1-1h1v6zm-2-13v-1h2c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm-2 30h-2 1v-5h-1s1 0 1-1v6h1zm-3-38 1-1c0-1 1-1 1-1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm2 8h-1v-1 1-1h1v5h1v1h-2v-1h1v-4zm-2 9 1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1zm0 8c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2zm-29-14c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3l-1 1zm5 0-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm-1 27h-2 1v-5h-1s1 0 1-1v6h1zm4 0h-2 1v-5h-1c1 0 1 0 2-1v6zm0-8h-2s1 0 1-1v-4h-1c1-1 1-1 2-1v6zm5 7c0 1 0 1-1 1s-1 0-2-1v-3c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4zm0-9c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h1l1 1v3zm4 9v1h-1c-1 0-1 0-2-1v-3l1-1 1-1 1 1c1 1 1 1 1 2s0 2-1 2zm-1-8 1 1h-2v-1h1v-4h-1c0-1 1-1 1-1v5zm2-8c0 1-1 1-1 0h1zm3 26h-2 1v-5h-1l1-1h1v6zm0-9h-2 1v-5h-1c1 0 1 0 1-1h1v6zm0-8h-2s1 0 1-1v-4h-1l1-1h1v6zm5 16-1 1h-1s-1 0-1-1v-4l1-1h1l1 1v4zm0-9c0 1 0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4zm-1-8v1h1-3 1v-5h-1c1-1 1-1 2-1v5zm1-9s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm-2-27zm-1 7c0-1 0-1 1-1 0-1 0-1 1-1l1 1v4s0 1-1 1h-1s-1 0-1-1v-3zm-7-2v6h1-2 1v-5h-1l1-1zm-5-3v1-1zm-1 2h1-1zm0 3c0-1 0-1 1-2h1l1 1v4s0 1-1 1-1 0-2-1v-3zm-1-3c0-1 0 0 0 0zm-3 11s0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2zm-2 14h1v-2l1 1v-1s-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v1h1c0-1 0-1 1 0v-3h-1 1v-1s1 0 1-1h1s1 0 1-1v-1c0-1 0-1-2-1v-1 2h1v1h-2v-6l-1 1v-1h2v1s0-1 1-1v-1l2-1h1l1-1v-1l1-1h2v-3h-1c1 0 1-1 1-1h1v4h1c0 1 0 1-1 1v1h-1l-1 1-2 1v4c0 1 0 1 1 1 0 1 0 1 1 1-1-1-1-1-1-2s0-1 1-2v-1h2c1 1 1 2 1 3v1c0 1 0 1-1 1h2v-4s0-1 1-1h2v4c1 0 2 0 2 1 1 0 1 0 0 0s-1 0-1 1h-3c-2-1-4 1-4 1 1 0 1 1 0 0h-1v1c-1 0-1 0 0 0v1h1v-1h2v5l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1c-1 1-2 2-1 3 0 2-1 2-2 2v1h-1c0 1-1 0-1 0 1-1-3 0-3 0 0 1-1 1-2 1s-2 0-2-1c0 0-1 0-3 1h-1l1-1zm-2 0h1s0 1-1 0c-1 0-1 0 0 0zm-1 3c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2v1l-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2v-2zm-4 0 1-1h1s1 0 1 1c0 0 1 1 1 2l-1 1c0 1 0 1-1 2-1 0-1-1-2-1v-4zm0 9c0-1 1-1 1-1s0-1 1-1l1 1c0 1 1 1 1 2s-1 2-1 2c0 1 0 1-1 1s-1 0-2-1v-3zm-2-2v6h-2 1v-5h-1c1 0 1 0 2-1zm-6 14v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm0-9v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1 1-1 1 1c1 1 1 1 1 2s0 2-1 2zM374 150v-1 1zM103 99v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 0-1 1v4s0 1 1 1zM103 103v-1h-1c0 2 0 2 1 2v2h1v-2s0-1-1-1zM322 182z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m249 67-1 1v4l1 1v-1h1v-4s-1 0-1-1zM341 199c0 1 2 1 1 0h-1zM355 255h-1 1zM354 255h1-1zM354 255zM355 255zM354 255zM354 255c1 0 1 0 1 1v-1c0 1 0 0 0 0h-1 1-1v-1 2-1zm0 0zM354 255zM322 181v-1h-1c0 1 0 1 1 1zM354 256h1-1zM204 81zM205 83zM355 255zM356 255h-1v1h1c1 0 0-1 0-1zM356 256h-1 1zM355 255zM90 116v-1c1 0 1-1 1-1h-2v1c0 1 0 1 1 1zM330 184zM359 263h-1 1zM327 176zM325 183c-1 0-1 0 0 0zM323 181v1-1zM356 197zM355 256zM327 176zM346 197c-1 0-1 1-1 1 1 0 1-1 1-1zM343 166v1-1zM339 132h1-1zM341 132zM282 36v-3h-1l-1 1v4h2v-2zM76 122v2h2v-4h-2v2zM337 133zM139 59l-1 1c1 0 1-1 2-1h-1zM332 46c0 1 1 1 1 1s1 0 1-1v-1h-1s-1 0-1 1zM332 29c0 1 1 1 1 1l1-1v-3c-1 0-2 1-2 1v2zM146 59h-1v2c1-1 1-1 1-2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M333 25h-1v2s1-1 2-1v-1h-1zM286 34v-1h-1v1c0 1-1 1-1 2s1 1 1 2c0-1 1-1 1-1l1-1c0-1-1-2-1-2zM333 45h1v-2c0-1-1-1-1-1h-1v4c0-1 1-1 1-1zM138 64h2v-4h-2v4zM329 56v-2 1h-1s0 1 1 1zM338 55v-5h-1v1c-1 0-1 0-1 1v3h1s0 1 1 1v-1zM145 64h1c-1 0-1 0-1-1v1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M337 56h1c-1 0-1-1-1-1h-1c1 0 1 1 1 1zM334 53v-2s-1 0-1-1c0 0-1 0-1 1v3c1 0 1 1 2 1v-2zM329 47v-1s1-1 1-2l-1-1v-1h-1v4c0 1 0 1 1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M333 56v-1h1c-1 0-1 0-2-1v1s0 1 1 1zM159 51v-1c-1 0-1 0-1 1v4c0-1 1-1 1-1 1 0 1-1 1-1 0-1-1-1-1-2zM346 85h-1v4c0 1 0 1 1 1 0 0 0-1 1-1v-4h-1zM138 38l1 1h1v-6h-1v2s-1 0-1 1v2zM341 30h1v-5h-1v1l-1 1c0 1 1 2 1 2v1zM344 81h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1h-1v5zM159 56v-1c0 1-1 1-1 1h1zM329 51v-1c-1 0-1 0-1 1v4h1v-1c1 0 1-1 1-1 0-1-1-1-1-2zM135 47s1 0 1-1v-4c-1 1-1 3-2 3v2h1zM346 73c0-1 0-1 1-1v-4h-1v-1l-1 1v4c0 1 0 1 1 1zM341 39c1 0 1 0 1-1v-5h-1v2c-1 0-1 1-1 1 0 1 1 1 1 2v1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M159 56h-1c-1 1-2 2-2 3h-1c1 1 1 2 1 3h2v-3h-1 2v3c3 0 2 0 2 1-1 0-1 0 0 0 0 1 0 1 1 1l1-1v-2h-1v1-1c1 0 1-1 0-1h1-1v-1h1v-1s-1 0 0 0c0-1-1-1-1 0h-2v-1c1 0 1 0 0 0h-1l1-1c1 0 1-1 1 0 0 0 1-1 0-1v-1h-1v1s0 1-1 1zM155 60v-1c-1 0-1 1-1 1 1 0 0 0 0 1h-1v1h2v-2zM162 52v1-1c0-1 1-1 1-2l-1 1v1zM159 47zM336 29l1 1h1v-5h-1c-1 0-1 0-1 1v3zM155 38s-1 0-1 1c0 0 1 0 1-1zM149 37s1 0 0 0v-1h1-1v1zM346 93h-1v5h2v-4c-1 0-1-1-1-1zM273 50h-1v5s0 1 1 1v-1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM277 59h-1v4c0 1 1 1 1 1 1 0 1 0 1-1v-3c0-1-1-1-1-1zM292 56v-1h1v-4s0-1-1-1h-1v5l1 1zM260 33h-1v5h1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM286 59h-1v1c0 1-1 1-1 2l1 1v1h1v-1s1-1 1-2l-1-1v-1zM273 59h-1v4c0 1 0 1 1 1v-1c1 0 1-1 1-2 0 0 0-1-1-1v-1zM322 30h1v-5h-1c-1 0-1 0-1 1v3l1 1zM286 67c-1 0-1 0-1 1v1l-1 1c0 1 1 2 1 2v1c1 0 1 0 1-1s1-1 1-2-1-1-1-2v-1zM268 38h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM280 44v2l1 1h1v-4h-1c0-1 0-1-1-1v2zM140 68c-1 0-1 0-1 1 0 0 0 1 1 1v-2zM286 42h-1v1l-1 1c0 1 1 2 1 2v1h1v-1s1-1 1-2-1-1-1-2zM150 64h1v-1h-1v1zM273 30v-1c1-1 1-1 1-2s0-1-1-2v-1c-1 0-1 1-1 1v4c0 1 0 1 1 1zM285 30h1v-1s1-1 1-2-1-1-1-2h-1v1l-1 1c0 1 1 2 1 2v1zM264 33h-1v5h2v-4s0-1-1-1zM313 56c1 0 1 0 1-1v-5h-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1zM309 56l1-1v-5h-1v1c-1 0-1 0-1 1v3c1 0 1 1 1 1zM305 39v-1h1v-4l-1-1h-1v5s1 0 1 1zM313 39c1 0 1-1 1-1v-5h-1v1c-1 1-1 1-1 2s1 1 1 2v1zM313 30h1v-5h-1v1c-1 0-1 1-1 1 0 1 1 2 1 2v1zM322 39s0-1 1-1v-4s0-1-1-1c-1 1-1 1-1 2v3c1 0 1 1 1 1zM318 64s1 0 1-1v-3l-1-1h-1v5h1zM301 47v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM296 38h1v-5h-1c0 1-1 1-1 1v2c0 1 0 1 1 2zM292 30c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM301 56v-1c1-1 1-1 1-2s0-2-1-2v-1h-1v5s0 1 1 1zM309 64h1v-5h-1c-1 0-1 1-1 1v4h1zM292 47c1 0 1-1 1-1v-4h-2v4c0 1 1 1 1 1zM305 56v-1h1v-4s-1 0-1-1h-1v5l1 1zM240 136h-1l-1 1v4h2v-5zM260 316v-1c-1 0-1 1-1 1v3h2v-1c0-1 0-1-1-2zM373 307h-1v5h1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM374 290h-1v5h1l1-1v-3c-1 0-1-1-1-1zM438 171h-1 1l-1-1h-4v-1s1-1 1-2v-3h2c0-1 0-1 0 0h-1v-1c-1 0-1 0-1-2h-1c-1 1-1 1 0 1v1l-1-1v5h1-2s1 0 1-1v-3s-1 0-1-1h1l-1-1v-1h-1c-1-1-1-1 0-1v-2s-1 0-1-1c1 0 1 0 0 0h-1v-1 4h1-3 1v-4l-1-1-1-1h-1s0-1-1-1c0 0 0-1-1-1l-1-1h-1v-1c0-1-1-1-1-1v2h1-2 1v-3h-3l-1-1v2c0 1 1 2 2 3s2 1 2 2c0 0 1 0 1 1 1 0 1 1 1 1l1 3h1v-4h-1l1-1h1v6h-1c1 1 1 2 2 3 0 1 0 1 1 2v-1c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v4c0 1 0 1-1 1 1 0 1 1 1 1 2 2 2 2 3 2 0-1 1-1 1 0v1l1 1v1h2c1 1 2 1 2 1v-3zM269 316c0-1-1-1-1-1v1s-1 0-1 1v2h2v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M432 171c0 1 0 1 1 1v-1h-1zM378 299c-1 0-1 0-1 1v3c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM265 316h-1v-1s0 1-1 1v3h2v-3zM378 290l-1 1v4h2v-4s0-1-1-1zM429 164l-1-1v-1h-1v1c0 1-1 1-1 2 1 0 1 1 1 1l1 1v-1s1-1 1-2zM369 295h1v-5h-1s0 1-1 1v2c0 1 0 1 1 2zM455 175v1h1v-2c0 1-1 1-1 0v1zM460 176c0-1 1-1 1-1h-2c0 1 0 1 1 1zM370 299h-1l-1 1v1c0 1 0 2 1 2v1h1v-5zM349 307h-1v5h2v-4s0-1-1-1zM453 81zM448 172h-1 1zM369 307h-1c0 1-1 1-1 1v2c0 1 0 1 1 2h1v-5zM464 175h3v-1h-3v1zM250 316h-1v-1s0 1-1 1v3h2v-3zM386 139zM505 169v-1c1 0 0 0 0 0v-1h-1 1-1v-1h-1l-1-1h-1v2h1-2v-3h-2v2c0 1-1 1-1 1s0 1-1 1l-1-1v-4c-1-1-2-1-3-1-1-1-1-1-2-1l-1 1c0 1 1 2 1 3 0 0 0 1-1 1v1c-1 0-1 1-1 1 1 0 3 1 3 1v1h1c1 0 1 0 1 1 1 0 1 1 1 2v2l1 1c1 1 1 1 2 1h2v1l1-1v-1s-1 0-1-1v-3c0-1 1-1 1-2h1s1 0 1 1c0 0 1 1 1 2v1h1l1 1v-4h-1l1-1v6h1-1 1v1s1 0 1 1l1 1h4c1 1 1 1 1 0 1 0 0 0 0 0l-1-1h-1c1 0 1-1 0-1h-1v-1c-1 0-1 0-1-1 0 0-1-1-1-2-1 0-1-1-1-1h1v-1s0-1-1-1l-1-1h-1zm-11-3-1 1-1 1c-1 0-1-1-1-1-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm3 10h-2 1v-5h-1c1 0 1-1 2-1v6zM471 175h-1s0 1-1 1h-1l-1-1v1h-1l-1 1-1 1v1c1 0 2-1 3-1 0-1 1-1 2-2 1 0 2-1 2-1zM390 307h-1v5l1 1v-1h1v-4l-1-1zM473 164c-1 0-1 1-1 1h1v1-2zM228 316h-1l-1 1v2h2v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M492 162c-1 0-1 1-1 1v4h2v-4c0-1 0-1-1-1zM205 316h-2v3h2v-3zM391 299h-1v4c0 1 1 1 1 1 1 0 1-1 1-1v-4h-1zM387 131v1-1zM237 316h-2v3h2v-3zM387 290h-1v5h1c1-1 1-2 1-3 0 0 0-1-1-1v-1zM468 176h1v-1h-1v1zM383 299h-1s-1 0-1 1v1c0 1 0 2 1 2v1h1v-5zM466 55c0 1 0 1 1 2 0 0 1 1 1 2 1 0 1 0 2 1v2l1 1c0 1 1 1 1 2h1v-1h1-1v-1l-1-1c-1 0-1-1-1-2-1 0-1-1-1-1 0-1 1-1 2 0l1 1v-1c-1 0-2-1-2-1 0-1-1-1-2-2h-1s-1 0-1-1v-2c-1 0-1-1-2-1 0 0 0-1-1-1v3c1 0 2 1 2 1zM478 165c0-1 0-1-1-1v1c1 1 1 1 1 0zM453 96s1 0 1-1c0 0-1 0 0 0 0-1-1-1-1-1v2zM476 164c-1-1-1-1-2 0v1h2v-1zM241 316h-1s-1 0-1 1v2h2v-3zM407 128v-1 1zM406 125zM321 307h-1v5h1c1 0 1 0 1-1v-3s0-1-1-1zM406 125zM297 316l-1-1v1s-1 0-1 1v2h2v-3zM491 38zM475 65zM407 127c0-1 0 0 0 0zM488 45h1l-1-1v1zM501 171v-1c-1 0-1 1-1 1v5-1s1-1 2-1v-1c0-1 0-1-1-2zM317 307h-1v5h1l1-1v-3l-1-1zM407 129v-1 1zM301 316h-1v3h2v-1c0-1-1-1-1-2zM463 131l1 1s-1 0-1-1v1l1 1h1v-1c0-1 0-1-1-1 0 0-1-1 0-1 0 1 1 1 1 0s-1-1-1 0c0-1-1-1-1-1v2zM313 295h1v-5h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2zM309 307h-1c-1 0-1 1-1 1v4h2v-5zM314 299c0-1 0-1-1-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-5zM463 133v1c1-1 1-1 1 0 1 0 1 0 1-1h-2zM406 124v1-1zM498 29h2v-3c-1-1-2-1-3-1v3s1 0 1 1zM341 307h-1c0 1 0 1-1 1v2c0 1 0 1 1 2h1v-5z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M468 56h1c0-1-1-1-1-1s0-1-1-1c0 1 1 1 1 1v1zM338 299c-1 0-1-1-1-1v1c-1 0-1 0-1 1v3l1 1h1v-5zM469 59h-1l1 1v-1zM336 307l-1 1v4h2v-4s0-1-1-1zM342 299s0-1-1-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-5zM451 176v-1 1c-1 0-1-1 0-1l-1-1h-1c0-1-1-1-2-1v2h1c1 1 1 1 1 0v1h1v-1 1h1zM441 172h-2v2h2v-2zM443 171h-1v3c0 1 1 1 1 1 1-1 1-1 1-2s0-1-1-2zM273 316v-1c-1 0-1 1-1 1v3h2v-1c0-1 0-1-1-2zM447 173h-1 1v-1h-3v3h3v-2zM464 175v-1s-1 0-1 1h-2v1h-1 3c0-1 0-1 1-1zM458 175h-1s0 1-1 1h1c0-1 0-1 0 0h2s0-1-1-1zM328 307h-1v1c-1 1-1 1-1 2s1 1 1 2h1v-5zM293 316h-1v-1s0 1-1 1v3h2v-3zM332 307h-1v5h2v-4c-1 0-1-1-1-1zM329 299v-1c-1 0-1 1-1 1v1l-1 1c0 1 1 2 1 2 0 1 0 1 1 1v-1c0-1 1-1 1-2s-1-1-1-2zM454 175v-1 1h-2c0-1 0-1 0 0v1h-1 4s-1 0-1-1zM475 65c0-1-1-1-1-2v1s0 1 1 1zM402 295h1v-4c-1 0-1-1-1-1h-1v5h1zM530 239l-1 1 1-1zM529 239v1-1zM82 303s-1-1-1 0h-1v1h1-1 2v-1zM517 249h-1 1zM102 303c0 1 0 1 1 1v-1c1 0 1-1 1-2h-2v2zM509 166c1 0 1 1 1 1 0-1 0-1-1-1zM511 248zM93 303c0 1 1 1 1 1 1 0 1 0 1-1v-2h-2v2zM529 239zM401 307h-1v5s0 1 1 1v-1c1-1 1-1 1-2s0-2-1-2v-1zM296 98h1v-4l-1 1h-1v1c0 1 0 1 1 2zM93 313v-1h1v-4s-1 0-1-1l-1 1v1h1c1 1-2 1-1 2v1l1 1zM80 307l-1 1h2s-1 0-1-1zM90 311c-1 0-2-1-2-1v2h1c0-1 1-1 1-1zM304 307h-1v5h1s1 0 1-1v-3l-1-1zM89 307c-1 0-1 0-1 1v1h2l-1-1v-1zM515 163v1-1zM511 248c0 1-1 1-1 1v1h1c0-1 0-1 0 0v-2zM515 248h-1v2c1 0 1 0 1-1h1l-1-1zM117 303c0 1 0 1 1 1v-1c1 0 1-1 1-2-1 0-1-1-1-1h-1v1c-1 0 0 0 0 0v2zM126 304h1v-2h-2s0 1 1 1v1zM522 173v-1 1zM511 162s1 0 0 0zM291 96v2h1c1 0 1 0 1-1v-2c-1 0-1-1-1-1h-1v2zM523 173h-1 1zM411 290h-1c0 1-1 1-1 1v2c0 1 0 1 1 2h1v-5zM405 307h-1v5l1 1v-1h1v-4l-1-1zM525 172zM525 172zM523 172v-1c-1 0-1-1-1-1-1 1 0 1 0 1 0 1 1 1 1 1zM535 199v-1 1zM402 299h-1v4c0 1 0 1 1 1 0 0 0-1 1-1v-4h-1zM527 174s0-1-1-1c0-1-1-1-1-1 0 1 1 1 1 1 0 1 1 1 1 1zM113 303v1h1v-4h-2l1 1h-1v1s0 1 1 1zM511 162zM530 177v-1 1zM526 242h1v-1h1v-2c0 1 0 1-1 1 0-1 1-1 1-1h-1c0-1 1-1 1-1s-1 1-2 1v3zM530 178s0-1-1 0h1v1h1c0-1 0-1-1-1zM533 146v1-1zM524 244c0-1 1-1 1-1v-3l-1 1h-1v1c0 1 0 1 1 2zM317 123zM495 165c0 1 0 1 1 2h1v-4h-2v2zM172 316h-1v1l-1 1v1h2v-3zM492 205c-1 0-1 1-1 1v3l1 1h1v-4c0-1 0-1-1-1zM490 175h1c-1 0-1-1-1-1v1zM159 317v-1h-1v1c0 1-1 1-1 2h3v-1c0-1-1-1-1-1zM164 317c0-1-1-1-1-1h-1v3h2v-2zM492 196l-1 1v4c1 0 1 1 1 1s0-1 1-1v-4s0-1-1-1zM487 167h1s1 0 1-1v-3l-1-1v1c-1 0-1 1-1 1v3zM183 316h-1c-1 0-1 0-1 1v2h2v-3zM196 316h-1c-1 0-1 0-1 1v2h2v-3zM187 316h-1v1l-1 1v1h3v-1c0-1-1-1-1-2zM155 317v-1h-1l-1 1v2h2v-2zM486 165s-1-1-1-2v4h2-1v-2zM493 171h-1v-1 1h-1 1v1c0 1 0 1-1 1v2h1s1 0 1-1v-3zM483 162h2l-1-1v-2h-1c-1-1-2-1-3 0 0 0-1 0-1 1-1-1-1-1-1 0l1 1c1 0 1 0 1 1 0 0 1 1 2 1 0-1 0-1 1-1zM482 163h-1s-1 0-1 1h1v1h1c-1 1 0 1 0 1v-3zM200 316h-1l-1 1v2h2v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M484 163v-1h-1v1c0-1 1 0 0 0-1 1-1 1-1 2 0 0 1 1 1 2v-1c0-1 0-1 1 0v-3zM328 98zM512 174zM315 174h1s-1-1-1 0zM419 295h1v-4l-1-1h-1v5h1zM110 317c0-1 0-1-1-1s-1 1-1 1v2h2v-2zM520 244c1 0 1 0 1-1-1 0-1 1-1 1h-1 1zM99 317v-1h-1l-1 1v2h2v-2zM123 317c0-1 0-1-1-1h-1v3h2v-2zM91 311h-1v1h2c-1 0-1-1-1-1zM86 316h-1l1 1v-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M512 247s-1 1 0 1v2h1v-1c0-1 1-1 1-1 0-1 0-1 1-1 0 0 1 0 1 1v1c1-1 1-1 2-1 0-1 0-1 1-1v-1c1 0 2 0 2-1h1s1-1 1 0h-1 1c1 0 1 0 0-1v-2c-1 0-1 0-1 1l-1 1c0 1-1 1-1 1l-1-1c-1 0-1 0-2 1 0 0-1 0-2 1 0 0-1 0-1 1 0-1-1 0-1 0h-1zM332 145zM146 317v-1h-1v3h2v-1s0-1-1-1zM127 317v-1h-1l-1 1v2h2v-2zM151 317c0-1-1-1-1-1h-1v3h2v-2zM512 174zM508 169h1l1 1h1l1-1s1 0 1-1h1v-2c0-1-1-1-1 0v1c-1 0-1 1-1 1h-1c-1 0-1 0 0-1h-1v1h-2c-1 0-1 0-1 1h1zM512 175zM395 307h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1s0-1 1-1v-5zM248 307h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM448 149v1h-1v1c-1 0-1 1-2 1h-2v1s1 0 1 1v4l-1 1c-1 0-1 0-2-1v-4c-1-1-1 0-2 1v3c1 2 1 3 2 2v3c0-1 1-1 1-1h2v3h1v-2l1-1h2c1 1 1 2 1 2v2c0 1 0 1 1 0h1v-4h-1 2v4-1c0-1 0-1 1-2v-1c-1 0 0-1 1-2h1v-1h-1 1v-5h-1l1-1v-3h-1 1v-4s-1 0 0-1h-1 1c-1 0-1-1-1-1s-1 0 0-1h-1s0 1-1 1v1c1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1l-1-1c0 1 0 1-1 1zm0 10h-2s0-1 1-1v-4h-1c0-1 1-1 1-1v6h1zm2-5v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2zM476 89v-3c0-1-1-1-1-1h-1v4c0 1 1 1 1 1s1 0 1-1zM478 82l1-1v-5h-1v1c-1 0-1 0-1 1v3c1 0 1 1 1 1zM480 85h-1c-1 0-1 1-1 1v2c1 0 1 0 1-1 1 1 1 1 1 0v-2zM477 88v1-1zM269 8c0-1-1-1-1-1v1s-1 0-1 1h2V8zM403 317l-1-1h-1v3h2v-2zM411 317v-1h-1l-1 1v2h2v-2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m451 159 1-1v-5h-1v1c-1 0-1 0-1 1v3c1 0 1 1 1 1zM483 193v-5h-1l-1 1v1c0 1 0 2 1 2v1h1zM480 71h2v-1c-1 0-1 0-1-1 0 0 0-1 1-1h-1v1c0 1-1 1-1 0s0-1 0 0v3-1zM484 230h-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-6zM480 73zM473 72v1h1l-1-1zM355 316h-1l-1 1v2h2v-3zM474 85h2c0 1 1 2 1 3 0-1 0-2 1-2v-1h2c1 1 1 1 1 2h1v-2c-1 0-1-1-1-1v-2l-1-1c0-1 0-1 1-1v-1c0-1-1-1-2-3-1-1-1-2-1-2h-2v2c-1 0 0 0 0 0v1h1v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 0-1 1h-1s-1 0-1-1v1l-1 1h-1c0 1-1 0 0-1h-1v2c-1 0-1 1 0 1zm3-10zM305 4h1s1 1 2 1 1 0 0 0c0-1 0-1-1-1 0 1 0 1 0 0h1V3h-2c-1 0-1 1-1 1zM468 94h-1 1v1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M472 91c-1 0 0-1 0-1h1c0 1 0 1 0 0v-2s0 1-1 0c0-1 1-1 1 0v-2s0-1-1 0h-3v3h1c0-1 0-1 0 0s0 1-1 1h-2 1s-1 0-1-1h1v-2c0 1-1 1-1 1v1h-1c0 1 0 1-1 1v1l1 1s1 0 0 0l1 1v1c1 0 1-1 2-1v2c1-1 1-1 1-2v-2c-1-1 0-1 0 0 1 1 2 1 2 0zm-3-2s0-1 0 0zm2 0h-1l1-1v1zM433 317c0-1-1-1-1-1h-1v3h2v-2zM113 307h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1s1 0 1-1v-5zM272 8l1-1c-1 0-1 0-1 1zM443 162h-1v2h2s0-1-1-1v-1zM424 317v-1h-1l-1 1v2h2v-2zM117 307h-1v5s0 1 1 1v-1c1-1 1-1 1-2s0-2-1-2v-1zM447 150s1 0 1-1l-1 1zM121 307h-1v5l1 1v-1h1v-4l-1-1zM443 300v-1h-1v4h2v-2s0-1-1-1zM442 156v2s0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1 1c0 1 0 1-1 0v2zM448 163c0-1-1-1-1-1h-1v3c0-1 1-1 1-1v1h1v-2zM475 73h-1l1 1h1c1 0 0-1 0-1h-1zM451 150h1v-5 1c-1 0-1 0-1 1h-1c1 1 1 1 0 1v1l1 1zM479 193v-5h-1c-1 0-1 0-1 1v3l1 1h1zM480 205h-1c-1 0-1 1-1 1v3l1 1h1v-5zM427 313s1 0 0 0c1-1 1 0 1-1h-1v1zM425 310h2-1 1v-1c0 1-1 0-1 1h-1zM427 307h-1v2h-1 2v-2zM426 313c1 0 1 0 1-1h-1v1zM431 307s-1 0-1 1c0 0 1 0 0 0h1v-1zM320 4c0-1-1-1-1-1v1h1zM318 12v1h1-2s0 1-1 1c0 0 1 1 0 1h-1v1h1v2c1 1 1 1 1 0 0 1 1 1 2 1v-2h-1v-1 1-1h2c0-1 1-2 2-3-1 0-1 0-1-1-1 0-1-1-1-2v1s-1 0-2 1zm-1 2h-1 1zM313 5V4v1zM456 156c1 0 1 0 0-1v1zM324 12s1-1 3-1v-1h-3v2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m321 12 1 1h1v-3h-2v2zM315 16l-1 1c0 1 1 1 1 1h1l-1-1v-1zM328 11s1 0 2-1c0 0 0-1-1-1h-1v2zM317 13v-1 1zM330 10c2 0 2-1 1-1h-1v1zM488 196h-1v5s0 1 1 1v-1h1v-4c-1 0-1-1-1-1zM484 222h-1v1c-1 1-1 1-1 2 0 0 1 1 1 2h1v-5zM320 19h3-1l-1-1s-1 0-1-1c0 0-1 0-1-1v3h1zM317 3v1h1s1 0 1-1h-2zM313 4h1V2s-1 0-1 1h-1c1 0 1 0 1 1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M315 3c0 1 0 1-1 1v1s0-1 1-1 2 0 1 1h2c-1 0-1-1-2-1h-1 1V3c-1 0-1 0-1-1 1 0 1 0 0 0v1zM304 4c1 0 1 0 1-1-1 0-2 0-3 1h1c1 0 2 1 2 0h-1zM310 4h-1 1zM301 4zM312 4V3h-1v1h-1 3-1zM474 157c1 1 1 0 0 0v-1c1 0 1-2 1-2-1 0-1 1-1 1v2zM501 126v1-1zM501 127c-1 0 0 0 0 0zM499 131l1-1c-1 0-1 0-1 1zM499 120v-1 1zM505 161s-1 0 0 1v-1h1-1zM506 161zM473 66h-1v1c1 0 1 0 2 1l1-1 1 1c0 1 1 1 1 2s0 2-1 2h2c0 1 1 1 1 1v-4s-1 0-1-1c-2 0-3-1-3-1l-2-1zM507 162zM366 316h-1c-1 0-1 1-1 1v2h2v-3zM387 317v-1h-1v3h2v-1s0-1-1-1zM473 159c1 1 1 1 1 0-1-1-1-1-1-2v-3c0-1 0-1 0 0-1 0-1 1-1 1v3c1-1 1-1 1 0h-1s-1 1 0 1c0 1 1 1 1 0zM507 168c-1 0 0 1 0 1v-1zM507 168zM421 13c0 1 0 1 1 1v1h5c-1-1-3-1-4-1l-1-1h-1zM506 161zM354 5h2l1 1h7c-1 0-1-1-1-1l-2-1h-2 1v1h-2V3h-3v2h-2V4h1V3c-1 0-2 0-1 1-1 0-1 0 0 1 0 1 1 1 1 0zM483 142z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M476 69c0-1-1-1-1-1h-1v2c1 0 1 0 0 0v2c0 1 1 1 1 1 0-1-1-1-1-1h2v-3zM301 299v-1c-1 0-1 0-1 1v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s-1-1-1-2zM277 298l-1 1v4c0 1 1 1 1 1 0-1 1-1 1-1v-4s-1 0-1-1zM272 307h-1v1c0 1-1 1-1 2 0 0 1 1 1 2h1v-1s1-1 1-2l-1-1v-1zM314 316h-1v1c-1 0-1 1-1 1v1h2v-3zM468 142h-1s-1 0-1-1h-1c0-1 0-1-1-1 0 1-1 1-1 1h1v1h-2v2h1v-1c0-1 0-1 0 0h2v-1c0 1 1 1 1 2v1c0 1 1 1 1 1 0-1 0-1 1-1v-1h1v1h1v-2c0-1-1-3-1-4v2s-1 0-1 1zM319 316h-2v3h2v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M463 141c-1 0-1 0-1 1v-1h1zM347 16h-1 1zM468 145s0 1-1 1c1 0 1 0 1 1h1v-2h-1zM282 298h-1v1c-1 0-1 0-1 1v3l1 1h1v-6zM276 307h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM467 101zM466 137c1 0 1 1 1 1h1v1h-1c-1 0-1 0-1 1 1 0 1 0 0 0 0 1 1 1 1 1v1l1-1v-4h-1v-1c0 1 0 1-1 1zM268 307h-1c-1 0-1 1-1 1v4h2v-5zM323 316h-1c-1 0-1 0-1 1v2h2v-3zM463 169c0 1 1 1 1 0v-2h-1v2zM465 132v1l1 1v1-1c-1 0-1 0-1 1l1 1h2v-1l-1-1v-1s0-1-1-1h-1zM269 298h-1v1s-1 0-1 1v1c0 1 0 2 1 2v1s1 0 1-1v-5zM466 101s0 1 0 0zM467 101v-1s-1 0 0 1zM457 116h1-1zM292 299v-1l-1 1v4c0 1 1 1 1 1l1-1v-4h-1zM462 131v-2h-1c1 0 1 1 1 1v1zM296 307h-1c-1 0-1 1-1 1v4h2v-5zM460 128h-1v4c0 1 0 1 1 1 1-1 0-2 0-2-1-1-1-1 0-1h1v-1h-1c0-1 0-1 1-1h-1zM502 30h3c-1 0-1-1-1-1-1-1-1-1 0-1 0-1 0-1 0 0v-1h-1c0-1-1-1-2-1v4h1zM300 307h-1v1c-1 1-1 1-1 2s1 1 1 2h1v-5z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M461 130c-1 1-1 1 0 1v-1zM460 124h1v-1l-1-1v2zM458 130h-1l1 1v-1zM286 298h-1v2c-1 0-1 1-1 1 0 1 1 2 1 2v1h1v-1c0-1 1-1 1-2s-1-1-1-2v-1zM386 12c1-1 0-1 0-1v1zM459 108zM462 107c-1 0 0 1 0 0zM469 137v1-1zM460 108z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M457 122v3c-1-1-1 0 0 2 0 1 1 2 1 2v-1h1c0-1 1-1 1-1l1 1s0-1-1-1v-2h1-2v-5c0 1 0 0-1 0h-1v2zM291 307h-1v5h1s1 0 1-1v-3c0-1-1-1-1-1zM264 298l-1 1v4c0 1 1 1 1 1l1-1v-4l-1-1zM273 4h-1 1zM134 307h-1v5s0 1 1 1v-1h1v-4c-1 0-1-1-1-1zM463 104zM461 134v2c0 1 0 1 1 1v-1h1v4c1 0 1 0 1-1s1-1 1-1v1c1-1 1-1 1-2-1 0-1 0-1-1v-1h-1v1c-1 0-1-1-1-1 1-1 0-1 0-1h-2zm4 3v1-1zm0-1h-1 1zm-1 1v1-1zm0 1zM338 316h-1c-1 0-1 0-1 1v2h2v-3zM139 307h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1s0-1 1-1v-5zM145 307h-1v5s0 1 1 1v-1c0-1 1-2 1-2 0-1-1-2-1-2v-1zM457 137h1v-1c-1 0-1 0-1-1h1-1v1c-1 0-1 1-1 1v1c1 0 1-1 1-1zM462 137h1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M463 138c-1 0-1 0-1 1h1v-1zM454 107v1s-1 0-1 1v2s1 0 1 1c0-1 0-1 1-2h1v-1h-1c1 0 1-1 1-1v-1h-2 1v-1c0 1-1 1-1 1zM475 196h-1v5h2v-4l-1-1zM277 4h-1 1zM465 104v1-1s1 0 1-1l-1 1zM273 295v-1h1c-1-1-2 0-2 0v1h1zM456 148c1 0 1 0 1-1l-1-1v2zM466 102z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m455 112-1 1h1v-3 2zM130 307h-1v2c-1 0-1 1-1 1 0 1 1 1 1 2v1c1 0 1 0 1-1v-5zM126 307h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1l1-1v-5zM256 298h-1v1l-1 1v1c0 1 0 2 1 2v1h1v-6zM462 156v-1h-1c-1 0-1 0-1 1v1h2v-1zM227 307h-1l-1 1v2c0 1 0 1 1 2h1v-5zM463 156v1h2v-1h-2zM263 5s0 1 1 1v1-1h-1s0 1 1 1h1c-1-1 1 0 1 1h1l1-1s0-1 0 0c1 0 1 0 1 1 1 0 1 1 1 2 1 0 1-1 1-1V8l1-1h3v1h2-1l1-1v2c1 0 1-1 1-1h1-1V7h-2l-2-1s-1 0 0 0c0 0 0-1 1 0 3 0 5 0 5-1h1s1 0 0-1h-4 1-2c0 1 0 0 0 0h-5s-1 1-1 0c-1 0-1 0-1 1h-6zm10 0v1c-1 0-1-1-1-1h1zm-6 2v1h-1c0-1 0-1 1-1zM465 167c0-1 0-1-1-1 0 1 0 1 1 1zM260 298c-1 0-1 0-1 1v4c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2v-1zM475 213h-1v5l1 1v-1h1v-4l-1-1zM334 316h-2v3h2v-3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M459 157c0 1-1 1-1 1v3c0 1-1 1-1 2v2c1 0 1 0 1 1v2c-1 1-1 2 1 1v-7h1v1c1 0 1 1 0 1 0 1 0 1 1 2v1s0 1 1 1l1-1h1v-1c-1 0-1-1-1-1v-2l-1-1c0-1 1-1 1-1h1c0-1 0-1 1-1 0-1 0-1-1-1h-2c0 1-1 1-1 1 0 1-1 1-1 0l-1-1v-3 1zM255 307h-1l-1 1v2c0 1 0 1 1 2h1v-5zM467 156h1v-1c0-1 0-1-1 0v1zM235 307h-1v5h1c1 0 1 0 1-1v-3c0-1-1-1-1-1zM475 205h-1v4c0 1 1 1 1 1l1-1v-4h-1zM456 148v1c1 0 1 0 0-1zM455 138l-2 2c1 0 1 1 1 1s0-1 1-1v-2zM523 173v1h1l-1-1zM240 307h-1l-1 1v4h2v-5zM467 157v-2l-1 1v1h1zM285 93v1c0 1-1 1-1 2s1 1 1 2h1v-1s1-1 1-2l-1-1v-1h-1zM227 304h1v-1h-1v1zM540 196c1 0 0 0 0 0zM540 246zM512 163zM540 245h1c-1 0-1-1-1 0zM540 194v1-1zM540 189v-1 1zM165 301c0 1 0 1-1 2v1h3c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1h2c0-1 0-1 1-1v-4h-1c1 0 1-1 2-1v5h2v-3c0-1 1-1 1-1 0-1 0-1 1-1l1 1v-1h-2l-1-1c1 0 1 1 1 0h-2s1 0 1-1h-1 1s-1-1 0-1h-2c0 1 0 1-1 1l-1-1v-3h-1v2l-1 1c0 1-1 1-1 1l-1-1c-1-1-1-2-1-2 0-1 0-1 1-2h-1l1-1h-2 1c-1 0-1 0-1-1h1-1v-1h2-1v-1h1l1 1v-1h-1 1-1v-1h1s-1 0-1-1h1v-2h-1c1 0 1 1 0 1h-1v1h-1 1-1 1-2c0 1 1 1 1 1h-1l1 1h-1 1-2v1h-1v1h2-1c0 1 0 1 1 1-1 0 0 0 0 0h-1 1v2h1-1v2h1s1 1 2 1v1c1 0 1 0 1 1 0 0 1 0 1 1h-1l-1 1h-2c0 1 1 1 1 2zM218 136s0 1 1 1l-1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M168 287h1c0-1-1-1-1 0 0 0 0-1 0 0zM540 190v-1c0 1 0 1-1 1h1zM496 184h1v-4 1s0 1-1 1v2zM530 240c1 1 1 0 1 0 1 0 1 0 1-1v1-1h1l1-1c1 0 1 0 1-1h1v-2s-1-1-1-2l1-1v-2s1 0 0 0v-1h1v-1h-1 1l-1-1s-1 0 0 0h-1c1 0 0-1 0-1h1-1v4-1s0 1 1 1c0-1 0 0 0 0h-1v1h1s-1 1-1 0v2h-1v1h-1v2h1-2 1v-1c-1 0-1 0-2 1l1 1v1l-1 1h-1v1zM486 192c0 1 0 1 1 1 0 0 0-1 1-1v-1c-1 0-1-1-1-1 0-1 0-1 0 0 0 0-1 0-1-1v3z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M536 233c0 1 0 2 1 2v1c0-1 1-1 1 0v-3s-1 0-1-1c0 0 1-1 0-1h1-1v-1 1s0 1-1 1v1zM228 145c0-1 0-1-1-1v1l-1 1c1 0 1 1 1 1l1 1v-3zM510 251h1-1 1s0-1-1 0h-1c1 1 1 0 1 0zM495 193h1v-5h-1c0 1 0 2-1 3 0 0 0 1 1 1v1zM465 205h-1c-1 0-1 0-1 1v3l1 1h1v-5zM465 196h-1l-1 1v4h2v-5zM514 175zM529 239zM491 193h-1 1zM223 304h1v-1h-2l1 1zM469 205h-1s0 1-1 1v1c0 1 0 2 1 2v1h1v-5z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M510 214c1-1 1-2 0-1 0 0 0-2 1-2v-1s-1 0-1-1v-2l-1-1s0-1-1-1v-2h-1c0-1 0-1 0 0v-1c0-1-1-1-1-2 0 0 1-1 0-1l-1-1v3h1v1h-2v-1h1v-3c-1 0-1-1-1-1h-1l-1-1v-2c1 0 0-2 0-2v-4h-1v-1s1 0 0-1c-1 0-1 0 0 0v1h-1c-1 0-1 0-1-1s0-1 1-1v-3 2h-1v-2c1 0 0 0 0 0l-1-1c1 0 1 0 0-1 0 0 0-1 0 0v3c0 1-1 1-1 1 0 1 0 1-1 1s-1 1-1 2c1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1 0-1 1l-1 1-1-1c-1 0-1 0-1-1h-1l-1-1v2h-1c-1 0-1 0-2-1v-3l-1-1 1-1v-1h1c0 1 1 1 1 1v-2 1c-1 0-1 0-1-1h1v-3h-2v1c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-3h-1v2c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2v1c-1 0-1 1-2 1h1v1h-1s-1 0-1 1-1 1 0 1v6h1-2v-5h-1c-1 0-1 0 0 0 0 0 0-1-1-1 0 0 0-1-1-1h-3c1 0 1 1 1 1h-1c0-1 0-1 0 0-1 0-1 0-1 1 0 0-1 1-1 2-1 0-1 0-1 1h-1v2h1-2 1v-1l-1 1v-2s-1 0-1 1c-1 1-1 1-1 2 0 0 0 1-1 1 0 1-1 1-1 2 0 0-1 1-2 1v3h1v1h-3v-1h1v-3c-1 0-1 0-2 1v1c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-1h-1v1l-1 1h-1s-1 0-1 1l-1-1c0 1-1 2-1 2v6h1-1c0 1 0 1-1 0v1l-1-1c0-1 0-1 0 0s0 2 1 2v1h1v5c0 1 0 1 1 1h-2v3c1 0 1 0 1-1v6h1-2v-4 1c0 1-1 2-1 2h-1v1l1 1s1 1 2 1 2 0 2-1h2l1-1h-2 1v-5h-1s1 0 1-1v6h3v-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2l-1 1h2v-4c0-1 0-1 1-1v-1c1 0 1 1 2 1v3-1h1v-1c0-1 1-1 1-1l1-1 1 1s0 1 1 1h2v-1h-1s1 0 1-1v2l1-1h3v-1c1 0 1 1 1 1h1c0 1 1 1 1 1h1c1 0 1 1 1 1v-1c0-1 1-1 1-1h2c0 1 1 1 1 2s0 2-1 2v1h-2v1c-1 0-1 0 0 0l1 1c0-1 1-2 2-2 0 0 1-1 1-2h1v-3h-1 2v5h-2 1v-1c-1 0-1 1-1 1l-1 1c-1 0-1 1-1 1h1s1 0 1-1l1-1s0 2-1 2c-1 1 0 1 0 1h2v5l1 1h2c1 1 1 1 2 0h2l1 1c1-1 3-2 4-2v-4h-1l1-1v5c1 0 1-1 1-1h2v-3l1-1c1 0 1 0 2 1v-1c1-1 2-2 3-2v-1h-1v-5h1v5c1-2 2-2 3-3h1v-2h-1 1v1s1 0 1-1c1-1 1-1 1-2l1-1c1-2 2-3 2-4v-1zm-68-2v-1 1zm6 7h-2v-1h1v-4h-1c0-1 1-1 1-1v5l1 1zm0-10v1h-1c-1 0-1 0-2-1v-3l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2s0 1-1 2zm4 10h-2s1 0 1-1v-4h-1c0-1 1-1 1-1h1v6zm1-10-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm4 10h-3c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1v5c0 1 0 1 1 1zm0-9h-3 1v-5h-1c1 0 1 0 2-1v6h1zm3-14v5h1v1h-2v-6 1-1h1zm1 23h-2v-5c0-1 1-1 1-1v6h1zm0-10v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 1-1 2zm5 9c-1 0-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm0-9c-1 0-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-9-1 1c0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h2c1 1 1 2 1 3v1zm3-4v6h-2v-1h1v-5s0 1-1 1v-1h2zm-2-8h-1c1 0 1-1 2-1v6h-2 1v-5zm2 31h-2 1v-5h-1c1-1 1-1 2-1v6zm1-10s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm15-7h-3c1 0 1-1 1-1v-4h-1c1-1 1-1 2-1v5s0 1 1 1zm-2 12h-1c1-1 1-1 2-1v6h1-3 1v-5zm-1-4h1v-5h-1c1 0 1 0 2-1v6h1-3zm-2-8h-2v-1h1v-4h-1c0-1 1-1 1-1h1v6zm-4 16v1h-1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm0-9v1h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2s0 2-1 2zm0-9v1l-1 1c-1 0-1-1-2-1v-4c1 0 1-1 1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1zm1-8c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2c-1 0-1 1-1 1h-1s-1 0-1-1zm3 27h-2 1v-5h-1c0-1 1-1 1-1h1v6zm1-10-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-17v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1h-1s-1 0-1-1zm4 43-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4zm0-9c0 1 0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1h2v4zm1 9h1-1zm3 1h-2v-5l1-1v6h1zm0-9h-2v-5h1v5h1zm0-8h-2v-5c0-1 1-1 1-1v6h1zm0-9h-2v-5s1 0 1-1v6h1zm0-10v1l-1 1c-1 0-1-1-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1zm4 27h-2 1v-5h-1 1v5h1zm0-8h-2 1v-5h-1c0-1 1-1 1-1v5c1 0 1 1 1 1zm1-10c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v2zm0-9-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1zm3 27h-2 1v-5h-1 2v5zm0-8h-2 1v-5h-1c1-1 1-1 2-1v6zm0-9h-2 1v-5h-1c1 0 1 0 2-1v6zm0-8h-2c1 0 1 0 1-1v-4h-1c1-1 1-1 2-1v6zm5 0h-2v-5c0-1 0-1 1-1v5c0 1 1 1 1 1zm-2 3 1-1v6h1-2v-5zm-2-13v-3c0-1 1-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4s0 1-1 1-1 0-2-1zm4 26-1 1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2zm4 1h-2c1 0 1 0 1-1v-4h-1c0-1 1-1 1-1v5c0 1 0 1 1 1zm0-9h-2 1v-5h-1s1 0 1-1v6h1zM511 210v-1l1-1-1 1v1zM540 188h-1 1zM538 178s-1 0-1 1c1 0 1 0 1-1zM264 90v-1h-1v1h1zM153 301v2l1 1h1v-5h-1s-1 0-1 1v1zM537 200c-1 0 0 0 0 0zM263 87v1h1v-1c0 1 0 0 0 0v-2h-1v2zM463 192v-1 1zM540 188v-1 1zM157 301c0 1 1 2 1 2 0 1 0 1 1 1v-1s1-1 1-2-1-1-1-2c0 0 0 1-1 1l-1 1zM538 188v1-1zM244 87v2c0 1 0 1 1 1v-1c1-1 1-1 1-2s0-1-1-2h-1v2zM537 188c1 0 1 0 1-1 0 0 0 1 0 0 0 0-1-1-1 0v1zM539 186v-1 1zM235 89c0 1 1 1 1 1l1-1v-4h-1l-1 1v3zM538 190h1l-1-1c0-1 0 1 0 0v1zM160 303h1v-4s0 1 0 0c0 0-1 0-1 1v3zM162 301v3h1l1-1v-4h-2v2zM539 185zM539 180v1-1zM538 180zM541 198v-1s-1 1 0 1zM447 201h1-1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M451 201h1v-2c-1 1-1 1-2 1v1h1zM442 214v2-2zM218 307h-1v1h1v-1zM452 224v-2h-1c-1 0-1 1-1 1v4h2v-3zM190 312zM483 184h1v-2h-2c0 1 1 1 1 2zM479 184h1v-4h-1v1c1 0 1 1 1 1 0 1-1 1-2 0v2h1zM315 188v-1h-1v5c1 0 1-1 2-2 0-1-1-2-1-2zM185 312h1s-1 0-1-1v1zM237 145h-1v-1l-1 1v3h2v-3zM456 223v-1h-1v1c-1 1-1 1-1 2l1 1v1l1-1v-1l1-1-1-1zM497 231c0-1 0-1-1-1v1l-1 1v2c1 0 1-1 1-1s0-1 1-1v-1zM447 205h-1v4c0 1 1 1 1 1l1-1v-4h-1zM475 227s1 0 1-1v-3c0-1-1-1-1-1h-1v5h1zM207 312h1v-1h-2v1h1zM523 172zM460 222h-1v2l1-1h1c0-1-1-1-1-1zM293 222l-1-1-1 1v4c1 0 1-1 2-1v-3zM306 205s-1 0-1-1l-1 1v4c1-1 1-1 2-1v-3zM468 222h1-1zM218 312l1-1v-1h-2v2h1zM452 205h-1c-1 0-1 0-1 1v3l1 1h1v-5zM301 213h-1v4-1c1 0 1 0 1-2v-1zM261 147c0-1 0-1-1-2v-1c-1 0-1 0-1 1v4h1c1-1 1-1 1-2zM539 235v-1h1c0-1 0-1 1-1v-1c-1 0-1 0-1 1h-1v2zM168 301v-2h-1c-1 0-1 0-1 1v3l1 1h1v-3zM465 213h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1l1-1v-5zM249 144l-1 1h2s-1 0-1-1zM166 293v2h2v-4h-1 1-1v1c0-1 0-1-1-1v2zM162 307h-1 1zM241 145v-1h-1v1s-1 0-1 1v2h2v-3zM176 299h-1 1zM175 301v1-1h1s0 1 1 0c-1 0 0 0-1-1h1-1 1v-1h-2 1-1v2zM171 295h1v-1h-1s0-1-1-1c0 1 1 1 1 2zM512 163v-1 1zM277 226v-4h-1v2c-1 1 0 1 0 2v1l1-1zM537 230zM460 205h-1v4c0 1 0 1 1 1l1-1v-4h-1zM515 165v1s0 1 1 1v-2h-1v-1 1zM265 164v-2h-1v-1l-1 1v2c1 1 1 2 2 2v-2zM514 163h-1c0 1 1 1 1 1v-1zM161 310v2s0 1 1 1v-1h1v-4h-2v2zM313 170v1c-1 1-1 1-1 2s1 1 1 2h1v-5h-1zM156 310c0 1 1 1 1 2v1c1 0 1-1 1-1v-5h-1v1c-1 1-1 1-1 2zM175 312c1-1 1-1 1-2h-2v2h1zM268 184h1v-5h-1c1 1 1 1 1 2s-1 2-1 2v1zM203 312c0-1 0-1 1-1h-2v1h1z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="m449 301 1-1h1v-1h-1s1 0 1-1h1v2c1 0 1 0 1-1h1c1 0 1 0 2-1v1h2c0-1 0-1 1-1s2 0 2-1h-1 2c1 0 1-1 2-1h-2v-1h-1c1 0 1 0 0 0h-1s1 0 1-1l-1 1v1h1-2v-2h-2v1l-1 1h-1s-1 0-1-1v-2h-1v-1 3s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2v-1c0-1 1-1 1-1h-2c1 1 1 1 1 2 0 0 0 1-1 1v2h-1c-1 0-1-1-2-1v-4h1-3v4c0 1 0 1 1 1h-2v-5h-1c1-1 1-1 2-1 0-1-2 0-2 0s1 0 0 0c0-1-1 0-1-1h1v-1l-1 1v-1c-1 0-1 1-1 0h-6c-1-1-1-1-2-1h-2c0-1 1-1 1-1 1 0 1-1 1-1h-2v1s0 1-1 1h-6s-1 0-1 1h-1c-1 1-1 0-2 0h-1s1 0 1-1h-2s-1 1-2 1c1-1 0 0-1 0h-1c-1-1-2 0-3 0h-5c0-1 0-1-1-1 0 0-1 1-1 0h-1c0-1 0-1-1-1h-1c-1 0-1 1-2 1h-1c0 1-1 1-1 1h-2v-1h-6 1-2v-1 1h-4c0 1 0 1-1 1h-1c0-1-1 0-1 0h-1 1-8c0-1-1 0-1 0h-3v-1c-1 0-1 1-1 1h-3c0 1-1 1-1 1h-6c1 0 1 0 1 1 0-1-1-1-1-1 0 1 0 1-1 1h1v4c0 1-1 1-1 1s0 1-1 1l-1-1c0-1 0-2-1-2 1-1 1-2 1-2v-1c-1 0-1 1-2 1 0 0-1 0 0 0l-1 1v3h1-2 1v-3h-2v1l-1 1v1c-1 0-1 1-1 1-1 0-1-1-2-1v-2h-1v1c0 1 0 1-1 1 0 0 0 1-1 1 0 0 0-1-1-1 0 1-1 1-1 1s1 0 0 0c0 0 0 1-1 1h-4s1 0 1-1l1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h1c-1 0-2-1-2-1h-9v-1h-2 1c1 0 0-1-1-1h-1c0-1 0-1-1-1l1 1h-2 1v-1h-1c-1 0-2 0-3 1h1-1c-1 0-1 0-2 1 0 0 0 1 1 1h-2c0-1 0 0-1-1 1 0 1 0 0 0 0 0-1 0-1 1h1-2v1c0-1-1-1-1-1h1-2v6h-2 1v-5h-1 1-4v5h1-2c1 0 1 0 1-1v-3h-3v3c0 1 0 1-1 1h-2v-2h-1s1 0 1-1c-1 0-1 0-2 1v2h-2 1v-3h-1v-1h-1v1c0 1 0 2-1 2v1h-1c-1 0-1 0-1-1-1 0-1 0-1-1h-3v1c0 1 0 1-1 1h-1s-1 0-1-1h-2v1h-2 1v-1h-3v1h-1c-1 0-1 0-2-1h-1c0 1 0 1-1 1s-1 0-2-1h-1c0 1-1 1-1 1h-1s-1 0-1-1h-1c-1 1-1 1-2 1h1-2 1v-1h-1c-1 0-2-1-2 0s0 0-1 0v1h1-2v-1h-1c-1 0-2 0-2 1h-2 1-3c-1 0-1 0-2 1h-2s-1 0-1-1c-1 1-2 0-3 1h-1c-1 0 0-1 0-1h-1c-1 0-1 0-1 1-1 0 0 0 0 0s-1 1-2 0c0-1-1-1-1-1h-1 1c-1 0-1 1-1 1h-2c1 0 1 0 1 1 0 0-1 1-2 1h-1 1c-1 1-1 1-2 1v1h2-2v4h1-2v-3c-1 0-1 0-1 1-1 0 0 0 0 1h-1l-1 1h-1s-1 0-1-1h-2v1h-1s-1 0-1-1c-1 0-1 0-1 1h-3s-1 0-2 1h-3v1h-1c-1 0-1 1-1 1h1v1h4l1-1h2v1h1s1-1 1 0h-2v1h2l-1 1-1 1v1l-1 1c-1 0-1-1-2-1v-2h-4v3h-2v-1h1v-2c-1 0-2 1-2 1h-1v1l-1 1c-1 0-1-1-1-1-1 0-1 0-1-1h-1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-1h-2v2h-2v-1h1v-1c-1 1-1 1-2 1h-2 1v1h-2v-1h1-1s-1 1-2 1h-2v-1h-3c0 1 0 1-1 1l-1-1v-1h-3v1h1v1h-2v-1h1v-1c-2 0-3 0-5-1v1c0 1 0 1-1 1v1c-1 0-1-1-2-1v-2h-2v3h-2v-1h1v-2s-1 0-1-1h-3v3h1v1h-2c0-1 0-1 1-1v-3h-2 2v-1h-3s1 1 1 2l-1 1v1l-1 1c-1 0-1-1-2-1v-4h-1v3c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1c0 0-1 0-1-1 2 0 3 1 5 1h3c0-1-2-1-2-1h-4 1s-1 0-1-1c1 0 1 1 2 1h7s1 0 0-1h-4c-1-1-2-1-3-1h-2s-1 0-1-1v-4h-1v4l-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1v-1s-1 0-1-1v3c0 1 0 1-1 2v1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2s-1 1-2 0v5h1-2v-5h-1 1-3v-1h-2 1c0 1-1 1-1 1 1 1 1 1 1 2v2l-1 1h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1h-3v5h1-2c1 0 1 0 1-1v-3s0-1-1-1h-3 1v4s0 1-1 1-1 0-2-1v-1h-1v1l-1 1h-1s-1 0-1-1l-1-1h-2v2h1-2 1v-2h-3v1s0 1-1 1-1 0-2-1v-2h-1v2l-1 1h-1s-1 0-1-1c0 0-1-1-1-2h1-3v3h1-2 1v-3h-1 1-5v2s0 1-1 1-1 0-2-1v-2h-2v3h-2 1v-3h-2v2l-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2h-2v3h1-2v-3h-2c1 1 0 1-1 1v2h-2 1v-2h-2v1l-1 1s1 0 1 1h-1 1c0 1-1 0-1 0h-1 1-1c0 1-1 0-1 0 0 1 0 1 1 1-1 0-2 0-2-1H69h1c0 1 0 0 1 1h5s1 0 1 1h-1 2c0 1 1 1 1 1v-1h1s1 0 1 1h3-1c1-1 1-1 2-1v1h2l1-1h1l1 1v1h1v-1c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1h-2 2v1h6c2 1 3 1 5 1h7-10s-1 0 0 0H81c-1 0-1-1-2 0 2 0 4 1 5 1h3v1h1l1 1v-2h1v2h1c1 0 2 1 3 1v-3h-1 1v3h2c0-1 1-2 1-2v-1h2c1 1 1 2 1 2v1h2v-3h-1 2v3h4v-2l1-1h2c1 1 1 1 1 2v1h2v-3h-1 2v3h3v-3h-1 2v3h2v-2l1-1 1-1 1 1c1 1 1 1 1 2v1-1s0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v1h2v-3h-1c1 0 1 0 2-1v4h4v-2l-1-1s1 0 1-1v4h4v-3h-1s1 0 1-1h1v4h4v-2c0-1 1-1 1-1s0-1 1-1c0 0 0 1 1 1v3h1v-2l1-1 1-1 1 1c1 1 1 1 1 2v1-1s0-1 1-1v-1c1 0 1-1 1-1 1 0 1 1 1 1 1 1 1 1 1 2v1h1v-2c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v3h1v-2c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2v1h2v-3h-1s1 0 1-1h1v4h2v-2c0-1 0-1 1-1v-1c1 0 1 1 2 1v3h2v-3s1 0 1-1v4h4v-1s0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v1h1v-2c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v3h2v-3s1 0 1-1v4h2v-1s0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v1h1v-2c0-1 0-1 1-1v-1c1 0 1 1 2 1v3h1v-2c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2v1h2v-3h-1s1 0 1-1v4h4v-3h-1c1 0 1 0 2-1v4h5v-3l1-1v4h4v-3h-1l1-1v4h3v-2c0-1 0-1 1-1v-1c1 0 1 0 2 1v3h2v-3s0-1 1-1v4h2v-2c1-1 1-1 1-2h1s1 0 1 1c1 0 1 1 1 2v1-1l1-1c0-1 0-1 1-2 1 0 1 0 1 1 1 0 1 1 1 2v1h2v-3h-1c1 0 1-1 2-1v4h2v-2c1-1 1-1 1-2h1s1 0 1 1c1 0 1 1 1 2v1h4v-3h-1c1 0 1-1 2-1v4h2v-3s1 0 1-1h1l1 1v3h1v-3c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v1-1s1-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1h1v-3l1-1h1l1 1v3h3v-3h-1l1-1v4h4v-3h-1l1-1h1v4h3v-3h-1c1 0 1-1 2-1v4h4v-2c1-1 1-1 1-2h1s1 0 1 1c1 0 1 1 1 2v1-1s0-1 1-1v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v1h1v-2c0-1 0-1 1-2h1l1 1v3h3v-2s0-1-1-1l1-1v4h4v-3h-1l1-1h1v4h2v-2c0-1 0-1 1-1v-1c1 0 1 0 2 1v3h1v-2c0-1 1-1 1-1 0-1 0-1 1-1 0 0 1 0 1 1 0 0 1 1 1 2v1-1s0-1 1-1v-1l1-1c1 0 1 0 1 1 1 0 1 1 1 2v1h4v-3h-1c1 0 1 0 2-1v4h2v-2c0-1 1-1 1-1 0-1 1-1 1-1l1 1c0 1 1 1 1 2v1-1s0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v1h2v-3h-1c1 0 1 0 2-1v4h3v-3s1 0 1-1v4h4v-3h-1s1 0 1-1v4h3l-1-1 1-1c0-1 0-1 1-1v-1c1 0 1 1 2 1v3h2v-3h-1c1 0 1 0 2-1v4h4v-1s0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v1h2v-3h-1c1 0 1 0 2-1v4h3v-3l1-1v4h4v-3h-1s1 0 1-1v4h4v-3h-1c1 0 1 0 2-1v4h2v-2c0-1 1-1 1-1s0-1 1-1c0 0 0 1 1 1v3h3v-3h-1s1 0 1-1v4h4v-3h-1c1 0 1 0 1-1h1v4h4v-2c0-1 1-1 1-1s0-1 1-1l1 1c0 1 1 1 1 2v1h2v-3h-1s1 0 1-1v4h2v-1l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v1h2v-3h-1c1 0 1 0 2-1v4h4v-3h-1s1 0 1-1v4h2c0-1 0-2 1-2v-1h2c1 1 1 1 1 2v1h2v-3h-1 2v3h2v-2c0-1 1-1 1-1h2c0 1 1 1 1 2h1c1 0 2 0 3-1v-1h-1 2v1c1 0 2-1 2-1h2c1-1 2-1 3-2h-10s-1 0 0 0h-5c0-1 0 0-1 0 1-1 1 0 1-1h-4 2-3s-1 0-1-1v-1h-1 1v-3s0-1 1-1 1 0 2 1v1s1 0 1-1l1-1h1s1 0 1 1c0 0 1 0 1-1h7-1v-1h1-2 2-1s0-1 1-1l-1-1h2v-4c0-1 0-1 1-1 0 0 0-1 1-1 0 0 0 1 1 1v3h2v-1h1v-2h-1s1 0 1-1v3h2zM98 313h-2 1v-5h-1l1-1h1v6zm5 0h-3 1v-5h-1c1-1 1-1 2-1v6h1zm6 0h-2c1 0 1-1 1-1v-4h-1c0-1 1-1 1-1v5s0 1 1 1zm5-1s-1 0-1 1h-1s-1 0-1-1-1-1-1-2 1-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm4 0-1 1c-1 0-1 0-2-1v-4s0-1 1-1h1l1 1v4zm4 0v1h-1c-1 0-1 0-2-1v-4c1 0 1-1 1-1h1s1 0 1 1c0 0 1 1 1 2s0 1-1 2zm5 0s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm4 0-1 1h-1s-1 0-1-1v-4s0-1 1-1 1 0 2 1v4zm4 0v1h-1c-1 0-1 0-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 2zm5-1c-1 1-1 1-1 2h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1zm6 0c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4s0-1 1-1h1l1 1v3zm4 2h-2v-1h1v-3c0-1 0-1-1-1 0-1 1-1 1-1v5l1 1zm4 0h-2s1 0 1-1v-4h-1c0-1 1-1 1-1h1v6zm69 0h-2v-1h1v-5h-1v1-1h1v5h1v1zm5-2c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-2 1-2s0-1 1-1h1c1 1 1 2 1 3v1zm4 2h-2v-6h-1 2v5h1v1zm4-2v1c-1 0-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3 0 0 0 1-1 1zm1-7h-2 1v-5h-1l1-1v6h1zm4 7c0 1-1 1-1 1l-1 1-1-1c0-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm0-7h-2 1v-5h-1c1 0 1-1 2-1v6zm4 8h-3 1v-5h-1 2v5h1zm1-8h-2v-5h-1c1 0 1-1 2-1v6h1zm3 7v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm1-7h-2 1v-5h-1l1-1v6h1zm6 7c0 1-1 1-1 1s0 1-1 1l-1-1c0-1-1-2-1-2 0-1 1-2 1-2 0-1 0-1 1-1h1c1 1 1 2 1 3v1zm1-8s-1 0-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4zm3 9h-2v-5h-1 2v5h1zm1-9-1 1c-1 0-1 0-2-1v-4s1 0 1-1h1s1 0 1 1c0 0 1 1 1 2s-1 1-1 2zm3 9h-2 1v-4c0-1-1-1-1-1h1v5h1zm1-8h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2v2c-1 0-1 0-1 1zm4 7c0 1-1 1-1 1l-1 1-1-1c0-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm0-7h-1s-1 0-1-1-1-1-1-2 1-1 1-2l1-1c1 0 1 0 1 1 1 0 1 1 1 2v2s-1 0-1 1zm4 7c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4c0-1 0-1 1-1h2v4zm1-7h-2v-5h-1c1-1 1-1 2-1v6h1zm3 7v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4c0-1 1-1 1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm1-8v1h-1c-1 0-1 0-2-1v-4c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2zm3 9h-2 1v-5h-1 1v4c0 1 0 1 1 1zm2-9s-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm3 9h-3 1v-5h-1 2v5h1zm1-9-1 1h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4zm5 8v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm1-7h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-2c1 0 1 0 1-1h1s1 0 1 1c1 0 1 1 1 2s0 1-1 2v1zm4 7c0 1-1 1-1 1l-1 1-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm0-7h-2 1v-5h-1c1 0 1-1 1-1h1v6zm4 7c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm0-7c-1 0-1 0-2-1v-4l1-1h1l1 1v4s0 1-1 1zm4 7v1c-1 0-1 1-1 1-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3 0 0 0 1-1 1zm1-7h-2l1-1v-3c0-1 0-1-1-1l1-1v6h1zm4 7-1 1c0 1-1 1-1 1l-1-1c-1-1-1-2-1-2 0-1 0-2 1-2v-1h2c1 1 1 2 1 3v1zm0-7h-2 1v-5h-1l1-1h1v6zm2-13c0-1 0-1 1-1h2v4c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v-4zm1 22h-2v-1h1v-5s-1 0-1 1v-1h2v6zm1-9h-1s-1 0-1-1v-4l1-1c1 0 1 0 2 1v4s0 1-1 1zm4 7v1l-1 1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3l-1 1zm1-7h-2v-5l1-1v6h1zm0-9h-2v-5h1v5h1zm4 16-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm0-7h-2 1v-5h-1l1-1v6h1zm0-9h-2 1v-5h-1 1v5h1zm6-5v5h1-3 1v-5h-1 2zm0 21c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm0-7h-1s-1 0-1-1v-4l1-1h1l1 1v4s0 1-1 1zm4 7v1l-1 1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3l-1 1zm1-7h-2l1-1v-3l-1-1 1-1v6h1zm0-9h-2s1 0 1-1v-3h-1v-1h1v5h1zm4 16-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2s0-1 1-2v-1h2c1 1 1 2 1 3v1zm0-7h-1s-1 0-1-1c-1 0-1-1-1-2 0 0 0-1 1-1v-2h1c1 0 1 0 1 1 1 0 1 1 1 2v2c-1 0-1 1-1 1zm4 7c0 1-1 1-1 1 0 1 0 1-1 1l-1-1v-4s0-1 1-1h2v4zm1-8s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-2 1 0 1 0 2 1v4zm3 10h-2v-6 1-1h1v5h1v1zm1-9h-2v-5l1-1v6h1zm4 7-1 1-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm0-7h-2 1v-5h-1l1-1v6h1zm3 9h-2v-1h1v-5l-1 1v-1h2v6zm1-9h-2 1v-5h-1c1 0 1-1 2-1v6zm4 9h-2v-6s0 1-1 1v-1h2v5h1v1zm1-9h-2v-5s0-1 1-1v6h1zm0-8h-2v-6h1v5h1v1zm5 17h-2v-1h1v-4l-1-1v1-1h1v5h1v1zm1-9h-2 1v-5h-1l1-1v5s0 1 1 1zm0-8h-2v-1h1v-5h-1v1-1h1v5h1v1zm2-5s0-1 1-1h2v4c0 1 0 1-1 1 0 1 0 1-1 1l-1-1v-4zm2 20c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2c0 0 0-1 1-1s1 0 2 1v3zm0-7h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1c1 0 1 1 2 1v4s0 1-1 1zm4 7c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4l1-1h1l1 1v3zm1-7h-2v-5l1-1v6h1zm0-10v1l-1 1c-1 0-1-1-2-1v-4l1-1h2c0 1 1 2 1 3l-1 1zm8-4v6h-2v-1h1v-5s-1 0-1 1v-1h2zm-5 23h-2v-1h1v-4h-1c0-1 1-1 1-1v5h1v1zm2-10c-1 0-1 1-1 1h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2v2zm0-9-1 1c0 1-1 1-1 1-1 0-1-1-1-1-1-1-1-2-1-2v-2c1 0 1-1 1-1h2c1 1 1 2 1 3v1zm2 19h-2l1-1v-4h-1l1-1h1v6zm2-10-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 2 1v4zm7-13v5h1v1h-2v-1h1v-4h-1v-1 1-1h1zm-4 23h-2v-5h-1c1-1 1-1 2-1v5c0 1 0 1 1 1zm1-9h-2v-5h-1c1 0 1 0 2-1v6h1zm-1-9v1c-1 0-1-1-2-1v-4l1-1h2v4c0 1 0 1-1 1zm4 16v1l-1 1c-1 0-1-1-2-1v-4l1-1h1s1 0 1 1c0 0 1 1 1 2 0 0 0 1-1 1zm1-7h-1c-1 0-1 0-1-1-1 0-1-1-1-2v-1l1-1c0-1 1-1 1-1l1 1c1 1 1 1 1 2s0 1-1 2v1zm4 7c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1zm0-7h-2 1v-5h-1c1 0 1 0 1-1h1v6zm0-8h-2v-1h1v-5c-1 0-1 0-1 1v-1h2v6zm21-5c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0 1-1 1v1l-1 1c-1 0-1-1-1-1-1-1-1-1-1-2v-2zm-17 0 1-1h2c0 1 1 2 1 3l-1 1v1l-1 1c-1 0-1-1-2-1v-4zm2 21-1 1c-1 0-1-1-2-1v-4l1-1h1l1 1v4zm1-8h-1c-1 0-1 0-2-1v-3c0-1 1-1 1-1 0-1 0-1 1-1l1 1c0 1 1 1 1 2s-1 1-1 2v1zm3 8v1h-1c-1 0-1 0-1-1-1-1-1-1-1-2v-2c1 0 1-1 1-1h1s1 0 1 1c1 0 1 1 1 2 0 0 0 1-1 2zm1-8h-2 1v-5h-1s1 0 1-1v6h1zm0-8h-2v-1h1v-4l-1-1v1-1h1v5h1v1zm3 17h-2 1v-5h-1l1-1h1v6zm1-9h-2 1v-5h-1c1 0 1 0 2-1v6zm0-9c0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2c0 0 0-1 1-1h1c1 1 1 2 1 3v1c0 1-1 1-1 1zm4 17-1 1h-1s-1 0-1-1v-4s0-1 1-1h1l1 1v4zm1-8h-2v-5h-1c1 0 1 0 2-1v6h1zm0-10c0 1 0 1-1 1v1c-1 0-1-1-2-1v-4l1-1h2v4zm3 19h-2v-1h1v-3c0-1-1-1-1-1 0-1 1-1 1-1v6h1zm1-9h-2 1v-5h-1s1 0 1-1v6h1zm4 8c-1 0-1 0-1 1h-1s-1 0-1-1c-1-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v2zm1-9-1 1h-1s-1 0-1-1c0 0-1-1-1-2 0 0 0-1 1-1v-1l1-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-9c0 1-1 1-1 1 0 1-1 1-1 1l-1-1c0-1-1-1-1-2s0-1 1-2v-1h1c1 0 1 0 1 1 1 0 1 1 1 2v1zm3-4v5s0 1 1 1h-3c1 0 1-1 1-1v-4h-1c1-1 1-1 2-1zm1 13s0 1-1 1h-1s-1 0-1-1v-3c0-1 0-1 1-1 0-1 0-1 1-1 0 0 0 1 1 1v4zm4 1h-2s1 0 1-1v-3l-1-1s1 0 1-1v6h1zm0-8h-2v-1h1v-3c0-1-1-1-1-1 0-1 1-1 1-1v5l1 1zm7 7-1 1h-1s-1 0-1-1c0 0-1-1-1-2l1-1c0-1 0-1 1-1v-1c1 0 1 1 1 1 1 1 1 1 1 2v2zm0-9c0 1-1 1-1 1 0 1 0 1-1 1l-1-1c0-1-1-1-1-2s1-1 1-2c0 0 0-1 1-1s1 0 1 1c1 0 1 1 1 2v1zM530 175h-1v-1 2h1v-1zM530 176h-1 1zM510 160z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M125 299c1 0 1 0 1-1-1 1-1 0-1 0h-2c1 0 1 1 2 1zM131 299h-1v2h1-1 1-1c1 1 1 0 2 0 0-1-1-1-1-2zM520 171zM129 300h-1s0 1 1 1v-1zM527 180zM439 290h-1c0 1-1 1-1 2v1c0 1 0 1 1 2v1l1-1v-5zM415 290h-1v5h1c1-1 1-2 1-2 0-1 0-2-1-2v-1zM483 244h1v-4c0-1 0-1-1 0v2l-1 1c1 0 1 0 1 1zM533 199h-1c0-1 0-1-1-1v-1 2c1 0 1 1 1 1l1 1v-2z"
          />
          <path
            className="CyberEl83_svg__fil0"
            d="M485 241v2c0 1 0 1-1 1 0 0 0 1-1 1l-1-1v1c0 1 0 1 1 1 0 0 2 0 2-1h1l1-1v-3h-2zM281 98h1v-5h-1c-1 0-1 1-1 1v4h1zM138 300v3l1 1h1v-5h-1c-1 0-1 0-1 1zM489 241s0-1-1-1v2l1-1zM535 201h-1c0-1 0-1-1-1v1s0 1 1 1 1 0 1-1zM131 304v-1l1-1h-2v1c0 1 0 1 1 1zM520 170v-1l-1-1v2h2-1zM126 299h1-1zM439 299h-1l-1 1v2s0 1 1 1v1h1v-5zM523 175zM523 174v1-1zM524 172zM523 44h1c0-1 0-1-1 0zM424 299h-1l-1 1v3l1 1h1v-5zM424 290h-1c0 1-1 1-1 1v4h2v-5zM520 171zM524 175v-1 1zM130 299v-1h-3v1h3zM423 307h-1c-1 1-1 1-1 2v3c1 0 1 1 1 1l1-1v-5zM428 299h-1v1c0 1-1 1-1 2l1 1v1h1v-1s1-1 1-2-1-1-1-1v-1zM524 196v-1 1zM528 176h-1c-1 0 0 1 0 1h2l-1-1zM534 202zM526 175zM527 175zM528 175zM528 176v-1 1zM535 203c0-1 1-1 1-1-1 0-1 0-1 1zM538 230v-1c-1 0-1 1 0 1zM442 210v-1 1zM519 167c-1 0-1 1 0 1v-1zM414 307h-1v2l-1 1c0 1 1 1 1 2 0 0 0 1 1 1v-1c0-1 1-1 1-2s-1-2-1-2v-1zM442 208v-1 1zM525 143zM501 259l1-1c-1 0-1 0-1 1zM539 191h1l-1-1v1zM268 295h1v-1h-2l1 1zM149 301v2c0 1 1 1 1 1 1 0 1-1 1-1v-3h-2v1zM276 98h1c1 0 1 0 1-1v-1h-1c-1 0-1-1-1-1v3zM539 193v-1 1c0-1 0 0 0 0zM500 193v-1c1 0 1-1 1-2s0-1-1-2h-1v4c0 1 0 1 1 1zM501 259zM501 213c-1 0-1 0-1 1v4s0 1 1 1v-1h1v-2c0-1 0-1-1-2v-1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M145 4v1h2V4h-2zM150 4h-1v1h2V4h-1V3v1zM152 2v1h1V2h-1zM154 5V4h-1c0 1 1 1 1 1zM155 4h1V2h-1v2zM155 4zM158 4h-1v1h3-1V2h-1v2zM160 4v1-1zM161 4c1 0 1 1 2 1l1-1V3c1 0 1-1 1-1V1h-1v3h-2V1h-1v3zM166 4l1 1s1 0 1-1c0 0 1 0 1-1V1h-1v3h-2V1h-1v1c0 1 0 1 1 2zM171 4h-1v1h3V4h-1V1h-1v3zM175 4h1V1h-1v3zM177 4zM183 2V1h-1v2c0-1 0-1 1-1zM182 4h-1v1h2V3h-1v1zM185 2v2l1 1c1 0 1 0 1-1 1 0 1 0 1-1V2c0 1-1 1-1 1v1h-1c0-1-1-1-1-2V1v1zM191 5l1-1V3c1 0 1-1 1-1h-1v1c0 1-1 1-1 1h-1V2h-1v2c1 0 1 1 2 1zM194 4l1 1s1 0 1-1l1-1V2h-1v2h-2V2s0-1-1-1v1s0 1 1 2zM199 4h-1v1h3V4h-1V1h-1v3zM203 4v1s1 0 2-1h-1V1h-1v3zM207 4s0 1 1 1l1-1 1-1V0h-1v3c0 1 0 1-1 1h-1V0h-1v2s0 1 1 2zM211 4l1 1c1 0 1-1 1-1s1 0 1-1V0h-1v4h-1c-1-1-1-1-1-2V0c0 1-1 1-1 2 0 0 1 1 1 2zM218 3v1h2-1V0h-1v3zM222 4l1 1 1-1 1-1V2c-1 0-1 0 0 0V0h-1v4h-2V0h-1v2s0 1 1 2zM228 2l1-1h-1v1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M226 2v2l1 1c1 0 1-1 1-1 1 0 1 0 1-1V2h-1v2h-1c-1-1-1-1-1-2V1v1zM232 5V4h1V3s0-1 1-1h-1v1l-1 1h-1V2h-1v2c1 0 1 1 2 1zM236 3V2v1zM273 4h1-2 1zM278 4h-2 2zM281 4h-1 1zM301 4h1-1zM305 4V3c0 1 0 1-1 1h1s1 0 0 0zM310 4h1V3c-1 0-1 1-1 1h-1 1zM308 4V3v1zM315 3V2h-1v2h-1c0-1 0-1-1-1v1h1-1 1v1h1V4c1 0 1 0 1-1zM317 3h-1 1zM318 4h1V3c0 1-1 1-1 1zM317 4V3s0 1-1 1c1 0 1 1 2 1V4h-1zM354 4h-1v1h2V3h-1v1zM358 4v1h2V4h-1s-1 0 0 0l-1-1v1zM99 13h-1 1zM103 13h1-3 2zM111 11v-1h-1v2h1v-1zM107 11h1V9c0 1 0 1-1 1v1zM108 11zM110 10h1V9h-1v1zM113 9v1h1-1l1 1V8h-1v1zM114 13v-2h-1v2h1zM116 8v1-1zM116 12v1h1v-3h-1v2zM118 12h1v-1c0 1 0 1-1 1zM121 8h1V7c0 1-1 1-1 1zM122 12V9v3zM132 10c0 1 0 2-1 2h1V9v1zM129 11s1 0 1 1v-1h-1v-1 1zM135 7v1-1zM134 13h1v-2 1c0 1 0 1-1 1zM135 10V9v2-1zM139 10h1V9h-1v1zM140 12c-1 0-1 0-1 1h1v-1zM145 13h1v-2h-1v2zM145 10h1V9h-1v1zM150 13v-2 2zM149 8h1v2-2h-1zM156 11v-1 1zM153 13h1c0-1 0-1-1-1v-1h-1l1 1v1zM154 7l-1 1v1s-1 0-1 1h1V9c0-1 1-1 1-1h1v2h1c0-1 0-1-1-2 0 0 0-1-1-1zM159 7c-1 0-1 0-1 1-1 0-1 0-1 1v2-1h1V8h1v1l1-1c-1 0-1-1-1-1zM160 9h-1 1zM162 8h2l-1-1s-1 0-1 1zM167 8v1s1 0 0 0h1V8h-1zM167 7v1h1V7h-1zM173 8c-1 0-1-1-2-1v1h-1v3-1s0-1 1-1V8h1v2c1 1 1 1 1 0V8zM176 7c0 1-1 1-1 1v2h1V7zM183 13V7h-1c0 1 0 1-1 1h1v5h-1 2zM187 7c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1V8c-1 0-1-1-1-1zm0 5v1h-1v-1s-1-1-1-2l1-1V8h1c0 1 1 1 1 2s-1 2-1 2zM191 13h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4V8h2v4l-1 1c-1 0-1 0-1-1V9zM195 13h1s0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1l-1-1V9zM199 8v5h-1 3-1V7c-1 0-1 1-2 1h1zM204 13h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4V8h2v4c-1 0-1 1-1 1-1 0-1 0-1-1V9zM207 8h1v5h-1 2-1V7l-1 1zM212 8v5h-1 2V7c-1 0-1 1-2 1h1zM219 13h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 2v3c1 1 1 1 2 1zm-1-4V8l1-1v1h1v4l-1 1c-1 0-1 0-1-1V9zM222 8h1v5h-1 2c-1 0-1-1-1-1V7l-1 1zM228 13v-1h1c0-1 0-1-1-1v2zM228 10h1V8h-1v2z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M227 7c-1 1-1 1-1 2v3c0 1 1 1 1 1h1-1v-1h-1 1c-1 0-1-1-1-2V9l1-1V7c1 0 1 1 1 1h1-1V7h-1zM265 7h-1 1zM268 7l-1 1v1c0-1 1-1 1-1V7s1 0 1 1v1l1 1c0-1 0-2-1-2 0-1 0-1-1-1zM272 7l-1 1v1-1h1c0-1 0-1 1-1h-1zM277 7l-1 1h1v1-2zM319 13h-1v-1h-1v1h2zM322 13l-1-1v-2h-1c0 1 0 2 1 2 0 1 0 1 1 1zM323 13h-1c1 0 1 0 1-1h1v-2h-1v3zM330 10V9h-1c1 0 1 1 1 1zM327 11h1V9l-1 1v1zM354 13h1l1-1h-1v1h-1v-1h-1c0 1 1 1 1 1zM358 13h2-1v-2h-1v2zM364 12c0 1 1 1 1 1h1s0-1 1-1v-2h-1v3h-1l-1-1v-2h-1c0 1 0 2 1 2zM368 12c0 1 1 1 1 1h1c1 0 1-1 1-1V8h-1v5h-1v-1c-1 0-1-1-1-2v2zM372 10v2c1 1 1 1 2 1h1v-1c0-1 1-1 1-2 0 0-1-1-1-2v4c-1 0-1 1-1 1-1 0-1 0-1-1V8c-1 0-1 0-1 1v1zM377 12c0 1 0 1 1 1h1s0-1 1-1V9h-1v3s0 1-1 1c0 0-1 0-1-1V9v1h-1c0 1 0 2 1 2zM381 12c0 1 1 1 1 1h1l1-1v-2h-1v3h-1v-1c-1 0-1-1-1-2V9c0 1-1 1-1 1 0 1 1 2 1 2zM385 13l1-1v-1l-1-1v3zM387 13h1-2 1zM37 22h1v-1s0 1-1 1h-1 1zM41 22h1l1-1v-2 1h-1v2h-1v-1c-1 0-1 0-1-1v1c0 1 1 1 1 1zM46 22c1 0 1-1 1-1v-2c0 1 0 1-1 2v1c-1 0-1 0-1-1v-2h-1v2c1 1 1 1 2 1zM49 22h2-1v-4 3s0 1-1 1zM54 22h-1 2v-3h-1v3zM58 22h-1 3-1v-3h-1v3zM62 22h2-1v-2h-1v2zM67 22h-1 2-1v-2 2zM74 22h-1 1zM75 21h-1v1c0-1 1-1 1-1zM78 22h1v-2 1s-1 0-1 1c0 0-1 0-1-1h-1c1 1 1 1 2 1zM82 22h1c0-1 1-1 1-1v-1c-1 0-1 0 0 0 0 0 0-1-1 0v2h-1l-1-1v-1h-1c0 1 1 1 1 1 0 1 1 1 1 1zM86 22h1l1-1v-1c0 1 0 1-1 1v1h-1v-1l-1-1v1c0 1 1 1 1 1zM90 21v1h2-1v-1h-1zM95 22h1-1l-1-1c0 1 0 1 1 1zM95 16h-1c0 1 0 1-1 1v1s0 1 1 0c0-1 0-1 1-1v-1l1 1v1h1c0-1-1-1-1-1 0-1-1-1-1-1zM99 16l-1 1v1-1h1v-1h1v1c0-1 0-1-1-1zM98 20c0 1 0 1 1 1 0 0-1 0-1-1zM101 17h-1v2h1v-2zM101 21v-1h-1v2c0-1 1-1 1-1zM105 17l-1-1h-1c0 1-1 1-1 1v2h1v-2c0-1 0-1 1-1v1c1 1 1 1 1 2v-2zM104 22l1-1v-2 1l-1 1v1c-1 0-1-1-1-1v-1h-1v1c1 1 1 1 2 1zM112 21v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 0 1 1 1h1c0-1 1-1 1-1zm-1 0-1 1s0-1-1-1v-3c0-1 0-1 1-1v-1h1v5zM113 17h1v5h-1 3-1v-5h-1l1-1c-1 0-1 0-2 1zM120 20zM118 16l-1 1v4h1c-1 0-1 0 0 0v-2c-1 0-1-1 0-1v-1c0-1 1-1 1-1h-1zM123 16v1-1zM123 21s0 1-1 1h2l-1-1v-1 1zM128 16c-1 0-1 0-2 1h1v1s1 0 1-1v-1zM127 21v1h-1 2v-4h-1v3zM130 19v2c1 1 1 1 2 1 0 0 1 0 1-1h-1v1c-1 0-1-1-1-1v-5h1v1h1l-1-1h-1s0 1-1 1v2zM136 19v1-1zM136 18v-1 1zM141 22v-6h-1l-1 1h1v5h-1 2zM147 22h-1 2v-1h-1v1zM148 17c0-1-1-1-1-1h-1l-1 1v4h1v-1h-1 1v-4h1s0 1 1 1v3l1-1c0-1-1-2-1-2zM150 22h2l-1-1v-5s-1 0-1 1h1v5h-1zM155 16c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-4c-1 0-1 0-1-1h-1zm1 1v4l-1 1v-1c-1-1-1-1-1-2v-1c0-1 1-1 1-2h1v1zM158 21c1 0 1 1 2 1l1-1h-1v1c-1 0-1-1-1-1v-2c-1 0-1 0 0 0v-2h-1v4z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M161 20s-1 0-1 1c1 0 1-1 1-1v-1 1zM163 22zM184 22v-6c-1 0-1 0-2 1h1v5h1zM187 16c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1h-1zm1 1c1 0 1 1 1 2 0 0 0 1-1 2h-1v-5h1v1zM192 21v-5s-1 0-1 1h1v4h-1v1h2v-1h-1zM195 16v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2zm2 1v4h-2v-4l1-1h1v1zM200 16c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2zm1 1s1 1 1 2c0 0-1 1-1 2h-1c0-1-1-1-1-2s1-1 1-2v-1h1v1zM205 21v-5h-1v1-1 6h2v-1h-1zM208 16v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1l1-1v-1c0-1 0-2-1-3h-2zm2 1v4h-2v-4l1-1h1v1zM212 17l1-1v5h-1v1h2v-6h-2v1zM220 16l1 1v3h1v-1c0-1 0-2-1-2v-1h-1zM219 21v-1h-1v1h1zM221 20zM219 17v-1s0 1-1 1v1s1 0 1 1v-2zM270 21zM273 21h2-1v-1h-1v1zM278 22s0-1 1-1l1-1v-1h-1v1c0 1 0 1-1 1h-1v-1h-1l1 1s0 1 1 1zM282 22c1 0 1-1 1-1s1 0 1-1v-1h-1v2h-1c-1-1-1-1-1-2v-1s0 1-1 1c0 1 1 1 1 2l1 1zM286 21v1h2v-1h-1v-2h-1v2zM292 21v1h2v-1h-2zM315 16v1l1 1v-2h-1zM319 16h-1v1-1 1h1v2-3zM323 19zM330 22v-1h1-2v-1h-1v1c1 0 1 1 2 1zM333 21v1h1v-1h-1zM334 19v-1 1zM339 21v-5h-2v1s0-1 1-1v5h-1c0 1 1 1 1 1h1v-1zM344 19v-3h-1c1 0 1 1 0 1 0 0 1 1 1 2v2-2zM341 21l1 1c1 0 1 0 1-1h-1c0-1-1-1-1-2l1-1h-1v3zM346 21v1h2v-1h-1v-5h-1c0 1 1 1 0 1 0 0 1 0 1 1v3h-1zM351 16h-1 2v1c0-1 0-1-1-1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M349 19c0 1 0 1 1 2l1 1s1 0 1-1l1-1v-3h-1v4h-2v-5 1c-1 1-1 1-1 2zM355 17v4s0 1-1 1h3c-1 0-1-1-1-1v-5c-1 0-1 0-2 1h1zM360 22l1-1v-1l1-1c0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s0 1 1 1v4h-1v1c-1 0-1-1-1-1v-4zM366 22s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-4c0-1 0-1 1-2h1v5c-1 0-1 1-1 1s0-1-1-1v-3zM370 17v4c0 1 0 1-1 1h3c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1zM375 22l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-4v-2h1l1 1v4h-1v1c-1 0-1-1-1-1v-3zM379 22h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-4c0-1 0-1 1-2h1v5c-1 0-1 1-1 1s0-1-1-1v-3zM383 22h1l1-1v-4c-1-1-1-1-2-1s-1 1-1 1v4c0 1 1 1 1 1zm-1-4c1-1 1-1 1-2h1v5c0 1 0 1-1 1v-1c-1-1-1-1-1-2v-1zM387 17v5h2-1v-6c-1 0-1 0-1 1zM391 17h1v4l-1 1h2c0-1-1-1-1-1v-5s-1 0-1 1zM396 22h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1s-1 1-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1zm-1-4c0-1 1-1 1-2h1v5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1zM400 17v5h2-1v-6c-1 0-1 0-2 1h1zM404 17h1v4l-1 1h2c-1 0-1-1-1-1v-5s-1 0-1 1zM409 17v5h-1 2v-6h-1l-1 1h1zM412 19v2l1 1h1l1-1v-3 1c0 1-1 1-1 2v1c-1 0-1-1-1-1v-4h-1v2zM418 21h-1v1h2-1v-5 4zM422 21v1h-1 2v-5h-1v4zM428 22h-1v-6c-1 0-1 0-2 1h1v5h-1 3zM430 17v5h2-1v-6s-1 0-1 1zM436 17h1v5h-1 2v-5c-1 0-1 0-1-1l-1 1zM440 21c0 1 1 1 1 1h1l1-1v-3 1c0 1-1 1-1 2s0 1-1 1v-1s-1-1-1-2l1-1h-1v3zM444 21c1 1 1 1 2 1h1v-1c1-1 1-1 1-2v-1h-1v3s-1 0-1 1c-1 0-1 0-1-1v-3l-1 1v2zM450 21v1h-1 2v-1h-1v-3 3zM453 21c0 1 1 1 1 1h1l1-1s0-1-1-1v2h-1v-1c-1 0-1-1-1-2v2zM459 22h1v-1c-1 0-1 0-1 1-1 0-1 0-1-1h-1c1 1 1 1 2 1zM463 22h-1 2-1v-1 1zM468 20h-1 1zM467 22h-1 2v-1h-1 1-1v1zM473 22h2-1v-2h-1v2zM478 22h1s0-1 1-1h-1v1h-1l-1-1-1-1 1 1c0 1 1 1 1 1zM482 22h1-1v-1h-1c0 1 1 1 1 1zM23 28v-1l-1 1v2-1c1 0 1-1 1-1zM27 28v-1h-1v3s1 0 1-1v-1zM24 28v-1h-1v1c0 1 0 1 1 2v-2zM29 29c1 0 1 0 0 0v1h-1v1h3v-1h-1v-3s-1 0 0 0v-1h-1v3zM34 26v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1zm1 0v-1h1l1 1v4h-2v-4zM40 25v5h-1v1h2v-6h-2v1c0-1 0-1 1-1zM44 31c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm0-5v-1h1v5h-1c0-1-1-1-1-2s0-1 1-2zM48 25v6h2v-1h-1v-5h-1v1-1zM53 31s1 0 1-1l1-1v-1c0-1 0-2-1-3h-2v1c-1 1-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM57 31c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm-1-5c1 0 1-1 1-1h1v5h-1c-1-1-1-1-1-2v-2zM61 25v6h2v-1h-1v-5h-1zM66 31l1-1 1-1v-1c0-1 0-2-1-3h-2s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1zm-1-5v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM72 31c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm0-5v-1h1v5h-1c0-1-1-1-1-2s0-1 1-2zM76 25v5h2-1v-5h-1zM80 25h1v5h-1 2-1v-5h-1zM84 26c1 0 1-1 1-1h1v1h1v-1h-2c-1 0-1 0-1 1zM84 27zM84 27v1-1zM87 28h-1v2h-1c0-1-1-1-1-1v-1 2l1 1c1 0 1-1 1-1s1 0 1-1v-1zM89 25h1v1c1 0 1 0 1 1s0 2-1 2v1h-1v-3h-1v3c1 0 1 1 2 1v-1c1 0 1 0 1-1l1-1c0-1-1-2-1-3h-2s-1 0-1 1h1v-1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M89 26h-1v1h1v-1zM94 31l1-1 1-1v-1c0-1 0-2-1-3h-2l-1 1v2s0 1 1 2c0 0 0 1 1 1zm-1-5v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM98 25v5h-1 2v-5h-2 1zM102 25v5h2-1v-5h-2 1zM109 30h1l1-1v-2s0-1-1-2h-2l-1 1v2s0 1 1 2h1zm-1-4s0-1 1-1 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM113 30h1s1 0 1-1v-4h-2c-1 0-1 0-1 1 0 0-1 1-1 2 0 0 1 1 1 2h1zm-1-4 1-1h1v5h-1c-1-1-1-2-1-2v-2zM118 30c1 0 1 0 1-1v-4h-2s-1 0-1 1v4h2zm-1-4v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM122 25h-1l-1 1v2s0 1 1 2h2l1-1v-2s0-1-1-2h-1zm1 2v2c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v1zM126 30h1s1 0 1-1v-2c0-1 0-1-1-2h-2v1s-1 1-1 2l1 1c0 1 1 1 1 1zm-1-4 1-1h1v5h-1c-1-1-1-2-1-2v-2zM131 25h-2 1v4h1v-4zM132 30h-1v-1c0 1-1 1-1 1h2zM135 25h-1l-1 1v3c1 1 1 1 2 1h1v-1c0 1-1 1-1 1h-1v-3h-1c1 0 1 0 0 0 0-1 0-1 1-1v-1h1s1 0 1 1v2s1 0 1-1-1-1-1-2h-1zM139 25h-1v1c-1 0-1 0-1 1h1v-1s0-1 1-1h1v1l1-1h-2zM145 30v-2h-1v1c0 1 1 1 1 1zM147 29v-1c0 1 0 1-1 1 1 0 1 0 1 1h-1 1v-1zM149 27zM149 25s1 0 1-1l-1 1zM150 30h1v-1c1 0 1-1 1-2 0 0 0-1-1-1v3c0 1 0 1-1 1h-1v-2h-1c0 1 0 1 1 1 0 1 0 1 1 1zM152 27c0 1 1 2 1 2 0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1zm1-1 1-1h1v1c1 0 1 0 0 0v4h-2v-4zM160 25c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v3l1 1h2c0-1 0-1-1-1v1c-1 0-1 0-1-1v-4h1v1l1 1v-2zM163 24c0 1-1 1-1 1l1 1v3-5zM165 27h1v-2 1c-1 0-1 1-1 1zM183 30v-6h-1c0 1 0 1-1 1h1v5h-1 2zM187 24c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-1l-1-1c0-1 1-1 1-2v-1h1c0 1 1 1 1 2s-1 2-1 2zM191 24s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h2v4zM195 24c0 1-1 1-1 1h1v4-5zM200 24c-1 1-1 1-2 1h1v3s1 0 1-1v-3zM204 24l-1 1v1c1 0 1 0 1-1v-1zM220 29l-1 1c-1 0-1 0-1-1h-1c1 0 1 1 1 1h2v-1l1-1c-1 0-1 0-1-1v2zM217 28h1v-1h-1v1zM223 30h1s0-1 1-1v-2h-1v3h-1l-1-1v-2h-1v1s0 1 1 1c0 1 1 1 1 1zM227 30h-1 2v-4h-1v4zM230 28v1-1zM264 30h-1 1zM264 30h1s0-1 1-1v-2h-1v2s0 1-1 1zM268 26v4h-1 2v-6c-1 0-1 1-1 1v1zM273 30c1 0 1-1 1-1v-4l-1-1h-1c-1 1-1 1-1 2v3c1 1 1 1 2 1zm-1-4v-1s0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM276 25h1v5h-1 2-1v-6l-1 1zM282 24h-1s0 1-1 1h1v3h1v-4zM281 30h1-1zM285 30h1c1 0 1-1 1-1v-4l-1-1c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1c0 1 1 1 1 2s-1 2-1 2v1h-1v-1s-1-1-1-2l1-1zM292 30h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM295 29c0 1 1 1 1 1h1-1v-1c-1 0-1-1-1-2h-1c0 1 1 2 1 2zM296 24l-1 1v1c0-1 1-1 1-1h1v2h1c0-1 0-2-1-2 0-1 0-1-1-1zM302 30h-1v-1h-1v1h2zM301 24c-1 1-1 1-2 1h1v2h1v-3zM304 25zM304 30h2-1v-4 3s0 1-1 1zM308 25h1v5h-1 2v-5h-1v-1c0 1-1 1-1 1zM313 30h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1v5h-1v-1s-1-1-1-2c0 0 0-1 1-1zM317 25v5h2-1v-6c0 1-1 1-1 1zM322 30h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1l-1-1v-3zM328 25v5h-1 3-1v-6c-1 1-1 1-2 1h1zM334 27v2l-1 1s-1 0-1-1v-2h-1v2c1 1 1 1 2 1h1v-1c1-1 1-1 1-2 0 0 0-1-1-1v1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M332 27v-2h2v1-1l-1-1s-1 0-1 1c0 0-1 0-1 1v1h1zM336 26c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1zm1-1h1v5h-1l-1-1v-3c0-1 0-1 1-1zM341 30h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1v5h-1v-1s-1-1-1-2l1-1zM344 29c1 1 1 1 2 1h1v-1s1-1 1-2-1-1-1-2v4c-1 0-1 1-1 1-1 0-1 0-1-1v-3h-1v3z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M344 26s1 0 1-1c0 0-1 0-1 1zM349 25h1v5h-1 2-1v-6c0 1-1 1-1 1zM354 30h1l1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4c1 0 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-1v-2zM359 30c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1v1c1 0 1 0 1 1s0 2-1 2v1c-1 0-1 0-1-1v-3zM364 25h1v5h-1 2s-1 0-1-1v-5c0 1-1 1-1 1zM368 27v2c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v1zm1-1v-1h1v5h-1v-1c-1 0-1-1-1-1 0-1 0-1 1-2zM374 30h1v-1s1-1 1-2-1-1-1-2l-1-1c-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1l1 1v3l-1 1c-1 0-1 0-1-1v-3zM377 25h1v5h-1 2-1v-6c0 1-1 1-1 1zM382 25v5h-1 2v-6c-1 1-1 1-2 1h1zM385 27v2c1 1 1 1 2 1s1 0 1-1v-4c-1 0-1-1-1-1-1 0-1 1-1 1s-1 0-1 1v1zm1-1v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM391 30h1v-1c1 0 1-1 1-2s0-1-1-2l-1-1-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM395 25v5h-1 2v-6h-1c0 1 0 1-1 1h1zM401 25v5h2-1v-5h-1zM405 25h1v5h-1 2-1v-5h-1zM410 25c-1 0-1 0-1 1 0 0-1 1-1 2l1 1c0 1 1 1 1 1h1s1 0 1-1v-2s0-1-1-2h-1zm1 1v4h-1c-1-1-1-2-1-2v-2l1-1h1v1zM414 25v5h2-1v-5h-2 1zM419 30h1v-1c1 0 1-1 1-2 0 0 0-1-1-2h-2l-1 1v2s0 1 1 2h1zm-1-4v-1h1s1 0 1 1v3c0 1 0 1-1 1h-1v-4zM423 25v5h-1 2v-5h-2 1zM427 25c-1 0-1 0-1 1v4h2c1 0 1 0 1-1v-4h-2zm1 1 1 1c0 1-1 2-1 2v1h-1c0-1-1-2-1-2 0-1 1-1 1-2v-1h1v1zM431 25s-1 0-1 1v4h3v-1c1 0 1-1 1-2 0 0-1-1-1-2h-2zm2 1v3c0 1-1 1-1 1h-1v-5h1s1 0 1 1zM438 25v5h-1 2v-5h-2 1zM443 31v-1c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM447 31s0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s1 0 1 1v3c0 1 0 1-1 1h-1v-4zM451 31l1-1s1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM455 25v5h-1 3-1v-5h-2 1zM459 25v5h2-1v-5h-1zM464 31l1-1 1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM468 25v5h-1 2v-5h-2 1zM475 31s0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s1 0 1 1v3c0 1-1 1-1 1h-1v-4zM479 25v5h-1v1h2v-6h-2 1zM483 25v5h-1v1h3v-1h-1v-5h-2v1l1-1zM488 31l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v3c0 1-1 1-1 1h-1v-4zM493 28v1-1zM493 25h-2v1c-1 1-1 1-1 2 0 0 0 1 1 2 0 0 0 1 1 1 0 0 1 0 1-1h-2v-4s0-1 1-1 1 1 1 1v2h1c0-1 0-2-1-3zM495 26c0-1 1-1 1-1v1h1-1v2h1v-3h-2v1zM500 29c1 0 1 0 1 1v-4h-1v3zM505 30zM14 36v1c-1 0-1 0-1 1h1v-2zM17 39c1 0 1-1 1-1v-4h-1c0 1 1 1 1 2s-1 2-1 2v1h-1 1zM16 35v-1l-1 1v3h1s-1-1-1-2l1-1zM21 33s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-1-1-2l-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h2v4zM26 39h-1 1l-1-1v-5c0 1-1 1-1 1h1v5h-1 2zM31 39h-1 1zM30 33c-1 1-1 1-2 1h1v4h1v-5zM36 36v-3c0 1-1 1-1 1h1v4-2zM40 33c0 1-1 1-1 1h1v4-1h1v-4h-1zM46 36v-2c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3h1s-1-1-1-2c0 0 0-1 1-1v-1h1v4h1v-2zM48 34v5h2-1v-6l-1 1zM53 39h1s0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1l-1-1v-3zM57 39h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM61 34v5h2-1v-6c-1 0-1 1-1 1zM66 39h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM72 39h-1 3-1v-6c-1 0-1 1-2 1h1v5zM77 39h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 2v3c1 1 1 1 2 1zm-1-4v-1l1-1v1h1v4c-1 0-1 1-1 1-1 0-1 0-1-1v-3zM81 39h1s0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1v-1 1h1v5h-1s-1 0-1-1v-3zM86 38v1h-1v-1c-1 0-1-1-1-2v2c0 1 1 1 1 1h1l1-1v-2h-1v2zM84 36v-1l1-1v-1c1 0 1 1 1 1v1h1v-1c-1-1-1-1-2-1-1 1-1 1-1 2v1zM89 34s0-1 1-1v1h1c0-1-1-1-1-1h-1c0 1 0 1-1 1h1zM91 36c0 1 0 1-1 2v1c-1 0-1 0-1-1v-3c-1 0-1 0-1 1v2c1 1 1 1 2 1s1-1 1-1c0-1 1-1 1-2s-1-1-1-2v2zM94 33l-1 1h1v5h-1 2-1v-6zM98 34v5h-1 2v-6c-1 0-1 1-2 1h1zM102 34v5h2-1v-6c-1 0-1 1-2 1h1zM109 39h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1v-1 1h1v4l-1 1s-1 0-1-1v-3zM115 34c-1-1-1-1-2-1l-1 1c0 1-1 1-1 2s1 2 1 2v1c0-1 1-1 1-1-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1c1 0 1 0 1 1v3c1 0 1-1 1-1v-2zM118 33h-1c0 1-1 1-1 1v2c0-1 0-1 1-1v-1c0-1 0-1 1-1v1h1l-1-1zM122 33zM137 37c-1 0-1 0 0 0zM139 39h1c0-1 1-1 1-1v-2c0-1 0-2-1-2v-1h-1 1v6h-1l-1-1v-2h-1v1h1-1l1 1c0 1 1 1 1 1zM145 34v5h2-1v-6c-1 0-1 0-1 1h-1 1zM149 38v-2h-1c0 1 0 1 1 2zM150 33h1-1zM154 33h-1v1h1v-1h1v2h1c0-1 0-1-1-1 0-1 0-1-1-1zM155 39c0-1 1-1 1-1v-1 1h-1c0 1-1 1-1 1h1zM158 34h1c0-1 0-1-1-1v1zM184 36c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2v1h1v-2c0-1 0-1 1-2h1v4c0 1 0 1 1 1v-2zM187 33c-1 0-1 0-2 1h1v4h1v-5zM239 35h-1 1c0 1 0 1 0 0v-1 1zM256 34c-1 0-1 0-1 2v2h1v-4zM256 38c-1 0-1 0-1 1h1v-1zM260 33h-1l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1l1-1c0-1-1-2-1-3h-1zm0 5h-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM264 33h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-5h1c1 0 1 1 1 1v4zM268 39c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM273 35v-2h-2v1l1-1v6h2v-1h-1v-3zM281 38h-1v-4l1-1h1v5c1 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 1-1 1-1 2s0 1 1 2h1zM284 38h1c0-1-1-1-1-2s1-1 1-2v-1h1v1s1 1 1 2l-1 1h1v-4h-2c-1 0-1 1-1 1v4zM292 38h-1v1h2v-1h-1v-5h-1v1-1 1h1v4zM296 39s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM300 34v5h2v-1h-1v-5c-1 0-1 0-2 1h1zM305 39l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v4h-1v1c0-1-1-1-1-1v-4zM309 34v4l-1 1h2v-6h-1s-1 0-1 1h1zM313 39c1 0 1 0 1-1 1 0 1 0 1-1v-3c-1-1-1-1-2-1s-1 1-1 1v4l1 1zm0-5v-1h1v5s0 1-1 1v-1c0-1-1-1-1-2s0-1 1-2zM317 34v5h2s-1 0-1-1v-5s-1 0-1 1zM322 39s1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 0 0 1 1 1zm-1-4c0-1 0-1 1-2 1 0 1 1 1 1v4c-1 0-1 1-1 1s0-1-1-1v-3zM328 34v4c0 1 0 1-1 1h3c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1zM333 33s-1 0-1 1c1 0 1 0 1 1v3h-1v1h2-1v-6zM337 33s-1 0-1 1h1v5h-1 2v-6h-1zM341 39h1l1-1v-4c-1-1-1-1-2-1s-1 1-1 1v4c0 1 1 1 1 1zm0-4v-2h1v5c0 1 0 1-1 1v-1c0-1-1-1-1-2 0 0 0-1 1-1zM345 34v5h2-1v-6s-1 0-1 1zM349 34h1v5h-1 2c0-1-1-1-1-1v-5s-1 0-1 1zM354 39h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1s-1 1-1 1v4c0 1 1 1 1 1zm-1-4c1-1 1-1 1-2h1v5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1zM359 39l1-1v-4l-1-1h-1l-1 1v4c1 1 1 1 2 1zm-1-4v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3zM364 34h1v5h-1 2v-1h-1v-5s-1 0-1 1zM370 33c-1 0-1 0-2 1h1v5h-1 3-1v-6zM375 39h-1v-6c-1 0-1 0-1 1v5h2zM378 33h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-3c0-1 0-1 1-1v-1l1 1v4zM382 39h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1l-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1zm-1-4c0-1 1-1 1-1v-1h1v5c0 1-1 1-1 1v-1c-1 0-1-1-1-2v-1zM388 36v-2l-1-1h-1c0 1-1 1-1 1v4c1 1 1 1 2 1l1-1v-2zm-1 2v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM391 39h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4v-1l1-1 1 1v4h-1v1l-1-1v-3zM395 34v5h-1 2v-6h-1s0 1-1 1h1zM402 33c-1 0-1 1-1 1v5h2-1v-6zM406 33h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-4l1-1 1 1v4zM411 33c-1 0-1 1-2 1h1v5h-1 2v-6zM415 39l1-1v-4l-1-1h-1c0 1-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM419 39h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1l1-1v1h1v4l-1 1s-1 0-1-1v-3zM423 34v5h-1 2v-6h-1s0 1-1 1h1zM427 39h1c1 0 1-1 1-1v-4l-1-1h-1l-1 1v4c0 1 1 1 1 1zm0-4v-1c0-1 0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1zM432 33h-1c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5s-1 0-1 1c-1 0-1 0-1-1v-4c0-1 1-1 1-1v1h1v4zM438 39h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1l-1 1c0 1-1 2-1 2 0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1v-1s1 0 1 1v5h-1v-1c-1 0-1-1-1-2v-1zM444 39h-1v-6c-1 0-1 1-2 1h1v5h2zM447 39h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v4c1 1 1 1 2 1zm-1-4v-1c1 0 1-1 1-1v1h1v4l-1 1s-1 0-1-1v-3zM451 39h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1v-1s0 1 1 1v5h-1l-1-1v-3zM455 34v5h-1 3-1v-6c-1 0-1 1-2 1h1zM460 39h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 2v3c1 1 1 1 2 1zm-1-4v-1l1-1v1h1v4l-1 1c-1 0-1 0-1-1v-3zM466 38v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2v1h2s0-1 1-1zm-1 1h-1l-1-1v-3c0-1 0-1 1-1v-1s0 1 1 1v5zM468 33c-1 1-1 1-1 2v3c0 1 1 1 1 1h1v-1 1h-1v-1c-1 0-1-1-1-2v-1l1-1v-1l1 1v1h1v-1c-1-1-1-1-2-1zM475 33s-1 0-1 1l-1 1 1 1v-2h2v3-1l1-1-1-1c0-1-1-1-1-1zM479 39h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1l-1 1v1c0-1 0-1 1-1h1v5h-1l-1-1v1h1zM478 35h-1 1zM482 39h1-1zM484 33c-1 0-1 1-2 1h1v4h1v-5zM488 33l-1 1v3h1v-4zM492 33l-1 1v1c-1 0-1 1-1 1 0 1 0 1 1 2v-3c0-1 0-1 1-1h1v1l1-1h-1s0-1-1-1zM497 33h-1s1 0 1 1v-1zM4 48v-1H3v1h2-1zM10 46H9v-1 2H8v1l1-1c0-1 0-1 1-1v-1 1zM6 46s0 1 1 1v-1H6zM14 44h-1v1h1v-1zM11 45h-1s0 1 1 1v-1zM17 42v2h1v-1c0-1-1-1-1-1zM16 43h-1v2-1h1v-1zM21 42s-1 0-1 1c1 0 1-1 1-1zM21 43v1-1zM24 42v1h-1 1l1-1h1-2zM49 45l-1 1h1v-1zM50 47h-1v-1h-1v2h2v-1zM50 48zM49 42s0 1-1 1v1h1s0 1-1 1h1v-3zM53 48s1 0 1-1l1-1v-1c0-1 0-2-1-3h-2v1l1-1h1v5h-2v-4h-1v1h1-1v2s1 0 1 1l1 1zM57 48c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm-1-5c1 0 1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM62 48l1-1v-1l1-1c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s0 1 1 1v4h-2v-4zM66 47h-1v1h2v-1h-1v-5h-1v1-1l1 1v4zM72 48c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm0-5v-1h1v5h-1c0-1-1-1-1-2s0-1 1-2zM77 48l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s0 1 1 1v4h-2v-4zM81 47h-1v1h2v-1h-1v-5h-1v1-1h1v5zM87 45v-3h-2c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1zm-1 2h-1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h1v5zM92 45c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1l1-1zm-2 2h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 3zM93 43v-1h1v5h-1v1h2v-1h-1v-5h-1v1zM98 48c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1 0 1-1 1-1 2 0 0 1 1 1 2l1 1zm-1-5 1-1h1v5h-1c-1-1-1-1-1-2v-2zM102 42v6h2v-1h-1v-5h-2v1l1-1zM110 47h-1v-5h-1 1v5h-1v1h2v-1zM112 42h1-1zM113 46v1h-1v1c1-1 2-1 2-1v-4h-1v3zM117 47h2-1v-2s0-1-1-1v3zM121 47h2-2zM131 47c1 0 1 0 1-1 0 0 0 1-1 1h-1s0 1 1 1v-1zM135 48s0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1 1v4c0 1-1 1-1 1h-1v-2l-1 1v1c1 0 1 1 2 1zM139 42v5h-1 2v-5h-2 1zM146 48v-1c1 0 1 0 1-1v-4h-2s-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM150 48s0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-2l-1 1v2s0 1 1 2c0 0 0 1 1 1zm-1-5v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM154 42v5h-1 2v-5h-2 1zM158 47h-1 2-1zM157 42h1-1zM237 47h-2 2zM238 44s-1 0-1 1h1v-1zM241 47v-6c-1 1-1 1-2 1h1v5h1zM244 43v1h1v-2h-1v1zM244 47h1v-1h-1v1zM259 42s1 0 1-1c-1 0-1 0-1 1zM261 46c0-1 1-1 1-2l-1-1v1c0 1 0 2-1 2v1c1 0 1-1 1-1zM264 41v1-1zM264 45zM264 47h-1 2-1v-1 1zM263 42zM268 47v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1h1v4c0-1 1-1 1-1v-1c0-1 0-1-1-2 0 0 0-1-1-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2v1h1zM271 42h1-1zM273 43h-1v1c1 0 1-1 1-1zM282 44v-1 4h-1l-1-1v-4 1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-3s0 1-1 1zM281 41v1-1zM286 41c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-1s-1-1-1-2l1-1v-1h1c0 1 1 1 1 2s-1 2-1 2zM292 47h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM297 47v-6h-1c0 1 0 1-1 1h1v5h-1 2zM301 47c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM304 47h2-1v-6c0 1-1 1-1 1h1v4c0 1 0 1-1 1zM309 42v5h-1 2v-6h-1c0 1-1 1-1 1h1zM313 47h-1 3-1v-6c-1 1-1 1-2 1h1v5zM317 42v5h2-1v-6c0 1-1 1-1 1zM322 47v-6c0 1-1 1-1 1h1v5h-1 2-1zM328 47h1c1 0 1 0 1-1v-4c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v3l1 1zm0-4v-1h1v1l1 1c0 1-1 2-1 2v1c-1 0-1 0-1-1v-3zM333 47h1v-1c1 0 1-1 1-2 0 1-1 1-1 1v1c0 1-1 1-1 1-1 0-1 0-1-1v-4h1s1 0 1 1v2s1 0 1-1-1-1-1-2l-1-1-1 1s-1 0-1 1v3c1 1 1 1 2 1zM336 42h1v5h-1 2v-6h-1c0 1-1 1-1 1zM341 47h-1 3-1v-6c-1 1-1 1-2 1h1v5zM345 42v5h2-1v-6c0 1-1 1-1 1zM350 47h1l1-1v-2c0-1 0-1-1-2h-2l-1 1v2s0 1 1 1c0 1 0 1 1 1zm-1-4s0-1 1-1 1 0 1 1v4h-2v-4zM354 47h1s1 0 1-1v-4h-2c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4c1 0 1-1 1-1h1v5h-1c-1-1-1-2-1-2v-2zM358 47h2-1v-5h-1v5zM365 47h1l1-1v-2s0-1-1-2h-2v1c-1 0-1 1-1 2 0 0 0 1 1 1 0 1 1 1 1 1zm-1-4s0-1 1-1h1v5h-2v-4zM368 42h1v5h-1 3-1v-5h-2zM375 47h-1v-5h-1v5h2zM378 42h-1l-1 1v2s0 1 1 2h2l1-1v-2s0-1-1-2h-1zm1 4c0 1 0 1-1 1h-1v-4s0-1 1-1 1 0 1 1v3zM381 47h2s1 0 1-1v-4h-2c-1 0-1 0-1 1 0 0-1 1-1 2 0 0 1 1 1 2zm0-4 1-1h1v5h-1c-1-1-1-2-1-2v-2zM386 47h2-1v-5h-2 1v5zM391 42h-1c1 0 1 0 1 1v4h-1 2-1v-5zM395 42v5h-1 2v-5h-2 1zM401 42v5h2-1v-5h-1zM406 42h-1 1v5h-1 2-1v-5zM411 47zM411 47v-5h-2 1v4l1 1zM410 46v1h-1 1v-1zM416 47h-1v-5h-2 1v5h2zM419 42h-1l1 1v4h-1 2-1v-5zM423 42v5h-1 2v-5h-2 1zM426 47l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4zm1-4v-1h1v1l1 1c0 1-1 2-1 2v1h-1c0-1-1-1-1-2s1-1 1-2zM432 42h-1l-1 1v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM438 48c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1s-1 1-1 2c0 0 1 1 1 2l1 1zm-1-5 1-1h1v5h-1c-1-1-1-1-1-2v-2zM444 47h-1v-5h-2v1l1-1v6h2v-1zM448 47h-1v-5h-1v1-1c0 1 1 1 1 1v4h-1v1h2v-1zM451 42h-1v1c0-1 0-1 1-1v4c0-1 1-1 0-2l1-1v-1h-1zM452 47h-1s0 1 1 1v-1zM480 47v-5h-2v1s0-1 1-1v5l1 1v-1zM483 42v5h-1v1h3v-1h-1v-5h-2v1c1 0 1-1 1-1zM487 47v1h2v-1h-1v-1c-1 0-1-1 0-1v-1h-1v3zM50 56h-1 1zM50 52h1-1zM50 55zM50 54h1v-1l-1 1zM50 55zM52 51h1v5h-1 2c-1 0-1 0-1-1v-5c0 1-1 1-1 1zM57 56h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4c1 0 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM62 56h1v-1c0-1 1-1 1-2s-1-1-1-2l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h2v4c-1 0-1 1-1 1-1 0-1 0-1-1v-3zM66 56h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM72 56h-1 3-1v-6c-1 1-1 1-2 1h1v5zM77 56h1v-1c1-1 1-1 1-2s-1-1-1-2l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h2v4c-1 0-1 1-1 1-1 0-1 0-1-1v-3zM81 56h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1s-1 0-1-1v-3zM86 56v-6c-1 1-1 1-2 1h1v5h-1 2zM89 56h2-1v-6l-1 1v5zM93 51h1v5h-1 2-1v-6c0 1-1 1-1 1zM99 56v-2c-1 0-1 0-1-1v2h1-1v1h-1 2zM98 51zM103 56c1 0 1-1 1-1v-4l-1-1c-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM109 56h-1 2-1v-6l-1 1h1v5zM113 51v5h-1 2v-6c-1 0-1 1-2 1h1zM117 51v5h2-1v-6c-1 0-1 1-2 1h1zM122 50h-1c0 1 0 1-1 2v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-1l-1-1v2s0 1-1 1c0 0-1 0-1-1v-4c1 0 1-1 1-1v1h1v1h1l-1-1c0-1-1-1-1-1zM126 56h-1 2v-3h-1v3zM130 51v5h2-1v-6c-1 0-1 1-2 1h1zM134 51h1v4s0 1-1 1h2-1v-6l-1 1zM139 51v5h-1 2v-6h-1l-1 1h1zM146 56v-6c-1 0-1 1-2 1h1v5h2-1zM150 56h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1c1 0 1-1 1-1v1h1v4l-1 1s-1 0-1-1v-3zM155 56v-6h-1s0 1-1 1h1v5h-1 2zM160 51l-1-1h-1l-1 1v4h1v-4c0-1 0-1 1-1v1c0 1 1 1 1 2 0 0 0 1-1 1h1l-1 1v1h-1 1c1 0 1-1 1-1v-4zM161 55c1 0 1-1 1-1h-1v1zM161 51v3c0-1 1-1 1-1v-2l1-1h-1c0 1-1 1-1 1zM233 51c0-1-1-1-1-1v1h1v3l1-1c0-1-1-2-1-2zM236 50h-1s0 1-1 1v3h1v-4h1l1 1v2s1 0 1-1-1-1-1-1c0-1-1-1-1-1zM241 56c0-1 1-1 1-1v-2c0-1 0-2-1-2v-1 4c1 0 1 1 0 1 0 1-1 1-1 1v-1s-1 0-1 1h2zM239 54v-1 1zM245 50h-1l-1 1v4c1 1 1 1 2 1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2s0 1-1 2zM249 51v3-3zM250 56h-1v-1 1h1zM249 55v-1 1zM254 55c0 1 1 1 1 1h1c0-1 1-1 1-1v-4l-1-1v5l-1 1v-1c-1-1-1-1-1-2v-1l1-1c-1 0-1 0-1 1v3zM260 56c1-1 1-1 1-2l1-1c0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-4v-2h1v1c1 0 1 1 1 2 0 0 0 1-1 2v1c-1 0-1-1-1-1v-3zM264 56s1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1zm-1-4v-2h1c1 0 1 1 1 1v4h-1v1l-1-1v-3zM269 55v-5c-1 0-1 0-2 1h1v4c0 1-1 1-1 1h2v-1zM273 50h-1c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM277 50s-1 0-1 1h1v4h-1v1h2l-1-1v-5zM282 55v-5h-1l-1 1h1v4c0 1-1 1-1 1h2v-1zM286 50c-1 0-1 0-2 1h1v5h-1 3-1v-6zM292 56h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4v-2h1c1 0 1 1 1 1v4h-1v1l-1-1v-3zM297 55v-5h-1l-1 1h1v5h-1 2v-1zM301 56l1-1v-4l-1-1h-1c-1 0-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-2h1v1c1 0 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3zM305 56h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1s0 1-1 1v4c1 1 1 1 2 1zm-1-4v-2h1c0 1 1 1 1 1v4h-1v1l-1-1v-3zM309 56h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1zm-1-4c0-1 0-1 1-1v-1h1v5l-1 1s0-1-1-1v-3zM313 56h1l1-1v-4c-1-1-1-1-2-1s-1 1-1 1v4c0 1 1 1 1 1zm0-4v-2h1v5c0 1 0 1-1 1v-1s-1-1-1-2c0 0 0-1 1-1zM317 51v5h2-1v-6s-1 0-1 1zM322 55v-5s-1 0-1 1h1v5h-1 2s0-1-1-1zM328 55v-4c0-1 0-1 1-1v1c0 1 1 1 1 2 0 0 0 1-1 1h1v-3l-1-1h-1l-1 1v4h1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M329 54v2c-1 0-1-1-1-1h-1l1 1h1l1-1v-1h-1zM332 53v-2c0-1 1-1 1-1 0 1 1 1 1 1v4c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 1v3h1v-1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M333 55v1l-1-1v-1h-1v1c1 1 1 1 2 1h1v-1h-1zM338 56h-1s0-1-1-1c0 1 1 1 1 1h1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M336 55v-3c0-1 0-1 1-1v-1h1v6c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2zM342 55v-5c-1 0-1 0-2 1h1v5s1 0 1-1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M341 56h-1 3-1v-1c0 1-1 1-1 1zM345 51v5h2-1v-6l-1 1zM350 55v1h-1 2s-1 0-1-1v-5l-1 1h1v4zM354 56h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1l-1 1v4c0 1 1 1 1 1zm-1-4 1-1v-1h1v6h-1v-1c-1 0-1-1-1-2v-1zM359 56l1-1v-4l-1-1h-1c0 1-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM366 56c0-1-1-1-1-1v-5l-1 1h1v5h-1 2zM368 51h1v5h-1 3-1v-6c-1 0-1 1-2 1zM373 56h2-1v-6c-1 0-1 1-1 1v5zM378 50h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-3c0-1 0-1 1-1v-1 1h1v4zM381 55c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1l-1 1c0 1-1 1-1 2s1 2 1 2zm0-3c0-1 1-1 1-1v-1s1 0 1 1v5h-1v-1c-1 0-1-1-1-2v-1zM385 55c1 1 1 1 2 1s1-1 1-1v-4l-1-1h-1c0 1-1 1-1 1v4zm1-3v-1s0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM390 51h1v5h-1 2-1v-6l-1 1zM395 56h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 2-1 2 0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1v-1s1 0 1 1v5h-1v-1c-1 0-1-1-1-2v-1zM401 51v5h2-1v-6c-1 0-1 1-1 1zM407 54v1s0 1-1 1c0 0-1 0-1-1v-4c1 0 1-1 1-1v1h1v3s1 0 1-1 0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 2v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-1h-1zM411 51v5h-1v-1c-1 0-1-1-1-2v-1 1s0 1-1 1c1 0 1 1 1 1 0 1 1 1 1 1h1l1-1v-2c0-1 0-2-1-2z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M409 52v-1h1v-1c-1 1-1 1-1 2l-1 1h1v-1zM414 56h2-1v-6c-1 0-1 1-2 1h1v5zM418 51h1v5h-1 2-1v-6l-1 1zM423 51v5h-1 2v-6h-1s0 1-1 1h1zM426 55c0 1 1 1 1 1h1c1 0 1-1 1-1v-4l-1-1c-1 0-1 0-1 1-1 0-1 0-1 1v3zm1-3v-1h1c0 1 1 1 1 2s-1 2-1 2v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1zM432 50s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h2v4zM438 56h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM444 56h-1v-6c-1 1-1 1-2 1h1v5h2zM448 56h-1v-6c0 1-1 1-1 1h1v5h-1 2zM451 56h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1l-1-1v-3zM455 56h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1c0 1 1 1 1 2s-1 2-1 2v1h-1v-1s-1-1-1-2l1-1zM460 56h1v-1c1-1 1-1 1-2s-1-1-1-2l-1-1s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h2v4l-1 1c-1 0-1 0-1-1v-3zM463 51h1v3-4c0 1-1 1-1 1zM464 56h-1 1v-1 1zM468 56h1-1v-1s-1 0-1-1v-1 2c0 1 1 1 1 1zM483 50v1h1v1h1v-1c-1 0-1-1-2-1zM488 50c0 1-1 1-1 1v4h1v-5zM50 64c1-1 1-1 1-2v-1c-1 0-1 1-1 1v2h-1v1h1v-1zM53 61v4h-1 2v-1h-1v-3zM52 60h1v-1s-1 0-1 1zM57 64v1h-1 2v-6c-1 0-1 0-2 1h1v4zM62 65h1v-1c0-1 1-2 1-2 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 1 1 1 2 1zm-1-4v-2h1s0 1 1 1v4h-1v1c-1 0-1-1-1-1v-3zM66 59s-1 0-1 1h1v4h-1v1h2v-1h-1v-5zM72 65c1 0 1 0 1-1 1 0 1 0 1-1v-3c-1-1-1-1-2-1s-1 1-1 1v4l1 1zm0-4v-2h1v5s0 1-1 1v-1c0-1-1-1-1-2 0 0 0-1 1-1zM77 59s-1 0-1 1v5h2s-1 0-1-1v-5zM81 64l-1 1h2v-1h-1v-5s-1 0-1 1h1v4zM85 64s0 1-1 1h2v-6c-1 0-1 0-2 1h1v4zM88 64c1 0 1 1 2 1v-1c1 0 1 0 1-1l1-1c0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4zm1-4v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2v1c-1 0-1-1-1-1v-4zM93 60h1v4h-1v1h2v-1h-1v-5s-1 0-1 1zM98 65c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM103 59h-2v1c1 0 1-1 1-1v4c0-1 1-1 1-1v-3zM103 63h-1v2h2v-1h-1c-1 0-1 0 0-1zM109 59h-1v1-1l1 1v-1zM109 64h-1v1h2v-1h-1zM112 61v-1s1 0 1-1h1v5h-1c-1 0-1-1-1-1v1l1 1h1v-1s1 0 1-1v-4h-2c-1 0-1 1-1 1v1zM118 65v-1c1 0 1 0 1-1v-4h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2h-1v-4zM121 59v1h1v4h-1v1h2v-1h-1v-5h-1v1-1zM126 65s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM131 65v-1c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 3h-1v-4zM135 65l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v4h-2v-4zM138 64l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3v5h-2v-4c0 1 0 1-1 1v1c0 1 0 1 1 2z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M138 59v1s-1 0-1 1c1 0 1-1 1-1l1-1h1-2zM145 59l-1 1v3c0-1 0-1 1-1v-1c-1 0-1 0 0 0v-2h1-1zM146 64h1-2v-1c-1 0-1 1 0 1 0 1 0 1 1 1v-1zM149 64v1h2v-1h-1v-1 1h-1zM153 62v-1 1zM155 59v3h1c0-1 0-2-1-3zM159 59h-2 1v3h1v-3zM163 59h-1v1h1s-1-1 0-1zM163 63v-2 1-1 2zM240 60v1l1 1v-3c-1 0-1 1-1 1zM246 64h-1v-6c0 1-1 1-1 1v5h2zM249 58l-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1 0 1-1 1-2s0-1-1-2l-1-1zm1 5c0 1 0 1-1 1h-1v-5h1s1 0 1 1v3zM255 59v5h-1 2v-6c-1 1-1 1-2 1h1zM260 64c1 0 1 0 1-1 0 0 1-1 1-2s-1-1-1-2l-1-1c-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1c-1 0-1 0-1-1v-3zM264 64v-6c0 1-1 1-1 1h1v5h-1 2-1zM269 64v-6c-1 1-1 1-2 1h1v5h-1 2zM273 58c-1 0-1 1-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1s1 0 1-1v-4c-1 0-1-1-1-1zm0 5v1c-1 0-1 0-1-1v-4h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM277 58l-1 1-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s0-1-1-2l-1-1zm1 5c0 1 0 1-1 1 0 0-1 0-1-1v-4h1s1 0 1 1v3zM282 64v-6h-1c0 1 0 1-1 1h1v5h-1 2zM286 58c-1 0-1 1-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1 0 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-1l-1-1c0-1 1-1 1-2v-1h1v1l1 1c0 1-1 2-1 2zM292 64v-6c0 1-1 1-1 1h1v5h-1 2-1zM298 63v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1l-1 1c0 1 1 2 1 2v1h1c-1-1-1-2-1-2v-2l1-1h1v5h-1 1s1 0 1-1zM301 64v-5h-2 1v5h2-1zM305 63v-4h-1 1v5-1zM308 63c0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2h-2v1c-1 0-1 1-1 2v1h1zm0-3s0-1 1-1h1v5h-2v-4zM314 64v-5h-2 1v5h-1 3-1zM318 64h1v-1c1 0 1-1 1-2 0 0-1-1-1-2h-2s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1l1 1v3c0 1-1 1-1 1h-1v-4zM322 64v-5h-1 1v5h-1 2-1zM329 63v-4h-2 1v4h1zM334 59h-2s-1 0-1 1v4h3v-1c1 0 1-1 1-2 0 0-1-1-1-2zm0 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM337 65l1-1s1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM342 59h-2 1v5h-1 3-1v-5zM345 59v5h2-1v-5h-1zM350 65l1-1 1-1v-1c0-1 0-2-1-3h-2l-1 1v2s0 1 1 2c0 0 0 1 1 1zm-1-5s0-1 1-1 1 0 1 1v4h-2v-4zM354 65c1 0 1-1 1-1s1 0 1-1v-4h-2c-1 0-1 0-1 1v4l1 1zm-1-5c1 0 1-1 1-1h1v5h-1c-1-1-1-1-1-2v-2zM358 64h2-1v-5h-1v5zM364 64zM365 64v-5h-1 1v5zM365 64h1-1zM368 59h1v5h-1 3-1c-1 0-1 0 0 0v-5h-2zM374 65s0-1 1-1v-1l1-1c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v3l-1 1h-1v-4zM378 59h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-4s0-1 1-1 1 0 1 1v3zM382 64h-1v1h2v-6h-2 1v5zM385 64c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4h-2l-1 1v4zm1-4v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM390 60v-1c1 0 1 1 1 1v4h-1v1h2v-1h-1v-5h-1v1zM395 59h-1v1c0-1 0-1 1-1v5h-1v1h2v-6h-1zM402 59h-1l-1 1v4c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-3h-1zm1 5h-2v-5h1s0 1 1 1v4zM406 59h-1v1-1h1v5h-1v1h2v-1h-1v-5zM410 59c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1zm1 5h-1c-1-1-1-1-1-2v-2s1 0 1-1h1v5zM415 65v-1c1 0 1 0 1-1v-4h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 3h-1v-4zM418 60v-1 1h1v4h-1v1h2v-1h-1v-5h-1v1zM423 65s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-2v-4zM426 64l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4zm1-4v-1h1v1s1 1 1 2c0 0-1 1-1 2h-1c0-1-1-1-1-2s1-1 1-2zM432 59h-1v1-1 1s1 0 1 1v3h-1v1h2v-1h-1v-5zM438 64h-1v1h2v-6h-2v1l1-1v5zM442 64v1h2l-1-1v-5c-1 0-1 0-2 1h1v4zM447 64h-1v1h2s0-1-1-1v-5s-1 0-1 1h1v4zM451 65s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-5 1-1h1v5c-1 0-1 1-1 1s0-1-1-1v-4zM455 65c1 0 1 0 1-1 1 0 1 0 1-1v-3l-1-1h-1c-1 0-1 1-1 1v4l1 1zm0-5v-1h1v1s1 1 1 2c0 0-1 1-1 2 0 0 0 1-1 1v-1c0-1-1-1-1-2s1-1 1-2zM460 65l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-4v-2h1l1 1v4h-1v1c-1 0-1-1-1-1v-3zM463 60h1v4l-1 1h2v-1h-1v-5s-1 0-1 1zM468 59h1v1c1 1 1 1 1 2v-2c-1-1-1-1-2-1zM474 64v1h1c-1 0-1-1-1-1v-1h-1v1h1zM44 73h1c1 0 1 0 1-1v-3h-1v4h-1v-1c-1 0-1 1-1 1h1zM49 73h1v-1c1 0 1-1 1-2s-1-1-1-2h-2s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1l1 1v3c0 1-1 1-1 1h-1v-4zM53 73h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4s0-1 1-1h1v5h-2v-4zM57 73h1c1 0 1 0 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4c1 0 1-1 1-1h1v5h-1c-1-1-1-2-1-2v-2zM62 67l-1 1v5h2-1v-6zM65 68h1v5h-1 2-1v-6c0 1-1 1-1 1zM72 73h1c1 0 1 0 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1v5h-1v-1l-1-1c0-1 0-1 1-2zM76 68v5h2-1v-6c0 1-1 1-1 1zM81 73h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1zm-1-4s0-1 1-1 1 0 1 1v4h-1s-1 0-1-1v-3zM85 73h1l1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm-1-4c1 0 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-1v-2zM88 72c1 1 1 1 2 1s1-1 1-1 1-1 1-2-1-1-1-2l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3zm1-3v-1h1v1c1 0 1 0 1 1s0 2-1 2v1c-1 0-1 0-1-1v-3zM93 68h1v5h-1 2-1v-6c0 1-1 1-1 1zM99 67c-1 1-1 1-2 1h1v5h-1 2v-6zM103 73v-6c-1 1-1 1-2 1h1v5h1zM109 67l-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-3c0-1 0-1 1-1h1v4zM114 72h1v-4c0 1-1 1-1 1v3zM113 72c-1 0-1-1-1-2v-1l-1 1c0 1 1 2 1 2v1l1-1zM113 68h-1 1zM119 70c0 1 0 2-1 2v1c-1 0-1 0-1-1h-1c1 1 1 1 2 1s1-1 1-1v-2zM117 68s-1 0-1 1v2h1v-3h1l1 1v-1l-1-1c0 1-1 1-1 1zM122 69v-2c0 1-1 1-1 1h1v1zM122 72v1h-1 2-1v-3 2zM127 73v-6h-1c0 1 0 1-1 1h1v5h-1 2zM131 67c-1 1-1 1-2 1h1v5h1v-6zM132 73zM135 67c0 1-1 1-1 1h1v1-2zM138 68h1v-1l-1 1zM140 68v2h1c0-1 0-2-1-2zM145 68h-1c1 0 1 0 2-1-1 0-1 0-1 1zM233 73v-1c0-1 1-1 1-2v-1c-1 0-1 1-1 1v2c-1 0-1 0-1 1h-1 2zM235 72c0 1 0 1 1 1h1c0-1 0-1 1-1v-2h-1v2l-1 1s-1 0-1-1v-2s-1 0-1-1v1c0 1 0 1 1 2zM240 72v1h-1 2v-3h-1v2zM245 73l1-1v-4l-1-1h-1v1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3l-1 1v2c1 1 1 1 2 1zM249 67h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5h-1v1l-1-1v-4l1-1c0 1 1 1 1 1v4zM257 68c-1-1-1-1-2-1l-1 1v2-1l1-1v-1h1v4c1 0 1 0 1-1v-2zM260 67h-1c0 1-1 1-1 1v2s0-1 1-1v-1c0-1 0-1 1-1v1h1v1-1c0-1-1-1-1-1zM260 73l1-1v-1 1h-1v1zM266 72v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v1h1v2-3l1-1 1 1v4h-1c1 0 1 0 1 1 0-1 0-1 1-1zM263 71c-1 0-1 0 0 1v-1zM268 72v1h-1 2v-2c0-1-1-1-1-1v2zM269 67h-1 1zM273 71zM273 67c-1 0-1 0-2 1h1v2l1 1v-4zM278 72c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v4h1v-4l1-1c0 1 1 1 1 1v4h-1v1h1v-1zM282 72v-5h-1l-1 1h1v5h-1 2v-1zM286 67h-1l-1 1v4c0 1 1 1 1 1h1l1-1v-4l-1-1zm0 5c0 1 0 1-1 1v-1s-1-1-1-2l1-1v-1c0-1 0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2zM291 73h1-1zM292 67s-1 0-1 1h1v2-3zM301 67h-1v1c0-1 0-1 1-1v1h1l-1-1zM301 73h-1 1zM311 69h-1v1h1v-1zM309 67h-1v1h1v-1l1 1v1h1c0-1 0-1-1-1 0-1 0-1-1-1zM315 68c-1-1-1-1-2-1l-1 1v2c0-1 1-1 1-1v-2c1 0 1 0 1 1v2c1 0 1 0 1 1v-3z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M312 70v-1 2h1c-1 0-1 0-1-1zM315 72v-1c0-1 0-1-1-1v3l1-1zM318 67l-1 1v3h1v-4zM317 73h2-1v-2h-1v2zM323 70v3h-1l-1-1v-3c0-1 0-1 1-1v-1h-1v1c-1 1-1 1-1 2s0 2 1 2c0 1 0 1 1 1h1s0-1 1-1v-1c-1 0-1 0-1-1zM328 68h-1 1v1c0 1 1 1 1 1v-3c-1 0-1 0-1 1zM331 72c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 1v4zm1-3v-1l1-1v1h1v4s-1 0-1 1c0 0-1 0-1-1v-3zM339 72v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 2 1 2c0 1 1 1 1 1h1l1-1zm-2 1-1-1v-3c0-1 0-1 1-1v-1l1 1v5h-1zM340 70v2c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c0 1 0 1-1 1v4h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2c0 1-1 1-1 1v2zM346 73h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-1l1-1v1h1v4c-1 0-1 0-1 1-1 0-1 0-1-1v-3zM350 73h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1v-1 1h1v5h-1s-1 0-1-1v-3zM354 73h-1 2v-6c-1 0-1 1-2 1h1v5zM359 73c1 0 1-1 1-1v-4l-1-1h-1c0 1-1 1-1 2v3c1 1 1 1 2 1zm-1-4v-1s0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM365 73h1s0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1v-1s0 1 1 1v5h-1l-1-1v-3zM369 67c-1 1-1 1-1 2v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1s0-1 0 0h1v4zM374 67c-1 0-1 1-1 1v5h2-1v-6zM378 67l-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-3c0-1 0-1 1-1h1v4zM381 72c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2zm0-3c0-1 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM385 72c1 1 1 1 2 1s1-1 1-1v-4l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3zm1-3v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM391 73h-1 2-1v-6l-1 1h1v5zM394 68h1v5h-1 2v-6h-1c0 1 0 1-1 1zM402 67c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-1-1-2l-1-1zm1 5c-1 0-1 1-1 1-1 0-1 0-1-1v-4h2v4zM408 70c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2zm-1 2s0 1-1 1c0 0-1 0-1-1v-4h2v4zM410 67v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1h1v4zM414 73h2-1v-6c-1 1-1 1-2 1h1v5zM419 73h-1 2-1v-6c0 1-1 1-1 1h1v5zM423 73h-1 2v-6h-1c0 1 0 1-1 1h1v5zM427 73h-1 3-1v-6c-1 1-1 1-2 1h1v5zM431 68l1 1v3c0 1-1 1-1 1h2-1v-6c0 1-1 1-1 1zM438 73h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1zm-1-4 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM443 73c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM447 73h1v-1c1 0 1-1 1-2s0-1-1-2l-1-1s-1 0-1 1l-1 1v3c1 1 1 1 2 1zm-1-4v-1h1s1 0 1 1v3s0 1-1 1c0 0-1 0-1-1v-3zM451 73h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4s0-1 1-1h1v5h-1l-1-1v-3zM456 73v-6c-1 1-1 1-2 1h1v5h-1 3-1zM461 68l-1-1-1 1s-1 0-1 1v3l1 1v-5h1s1 0 1 1v2h1v-1c0-1-1-1-1-2zM463 68v1c-1 0-1 1-1 1v2c1 0 1 0 1-1v-2s0-1 1-1h1v1-1l-1-1s0 1-1 1zM476 68l-1-1-1 1h1s1 0 1 1v3c1 0 1-1 1-2s-1-1-1-2zM475 73s-1 0-1-1v-2c-1 0-1 0-1 1 1 0 1 0 0 0v1l1 1h2-1zM479 72v1h1c-1-1-1-1 0-1v-3h-1v3zM482 71v-1 1zM42 82v-6h-1v1c1 0 0 0 0 1v4h1zM46 81v-5c-1 0-1 1-2 1h1v5h2-1v-1zM50 81v-5l-1 1h1v4h-1v1h2-1v-1zM55 81v-5h-1s-1 0-1 1h1v5h-1 2v-1zM58 76l-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 1v4c0 1 0 1-1 1v-1s-1-1-1-2c0 0 0-1 1-1v-2h1v1zM62 76c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1zm2 1v4h-1v1c-1 0-1-1-1-1v-4c0-1 1-1 1-1 0 1 0 1 1 1zM67 81v-5s-1 0-1 1h1v5h-1 2l-1-1zM73 76l-1 1v4l1 1h1l1-1v-4l-1-1h-1zm1 1c0 1 1 1 1 2s-1 1-1 2v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1zM77 76l-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1zm2 1v4h-1v1c-1 0-1-1-1-1v-4c0-1 1-1 1-1 0 1 1 1 1 1zM83 81v-5h-1s-1 0-1 1h1v5h-1 2v-1zM87 81v-5c-1 0-1 0-2 1h1v5h-1 3-1v-1zM91 81v-5s-1 0-1 1v5h2-1v-1zM94 76s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1zm2 1v4l-1 1-1-1v-3c0-1 0-1 1-2l1 1zM99 76c-1 0-1 1-1 1v4c0 1 1 1 1 1h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1zm1 1v4c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1c1-1 1-1 1-2h1v1zM104 81v-5c-1 0-1 0-1 1v5h2-1v-1zM111 81h-1v-5s-1 0-1 1h1v5h-1 2v-1zM115 81v-5c-1 0-1 0-2 1h1v5h-1 3c-1 0-1 0-1-1zM120 80l1-1c0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 0 1 1 2 1l-1-1v-5h1s0 1 1 1v4h-1v1l1-1v-1zM123 76h-1s0 1-1 1v2c0-1 0 0 0 0h1v-1c0-1 0-1 1-2 1 0 1 1 1 1v-1h-1zM195 78zM199 80h1-1zM199 80zM202 79h-1v1h1v-1zM205 81h-1 1zM232 80v-4h-1v1c1 0 1 1 1 1 0 1 0 2-1 2v2-1c1 0 1 0 1-1zM235 81v-5h-1c1 0 1 0 1 1v4h-1 2-1zM240 81v-5h-2 1v5h-1 2zM244 81v-5h-2 1v5h-1 3-1zM260 76h-1c1 0 1 1 1 1v2-3zM261 77v2c1 0 1 0 1-2v-1l-1 1zM268 81h-2 2zM273 78v-2h-3s0 1 1 1v-1h1v1l1 1c0 1-1 2-1 2v1h1v-3zM271 81h-1 1zM274 79v-1 1zM275 76v1-1h1-1zM281 81h-1v-5h-1 1v5h1zM285 76h-2 1v1h1v-1zM284 81h-1 1s1 0 0 0h2-1v-2l-1-1v3zM292 81h-1v-5h-1l1 1v4h-1 1-1 2zM295 76h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1h1v4zM299 76c-1 0-1 0-1 1v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2zm1 4v1h-1c0-1-1-1-1-2s0-1 1-2v-1h1v4zM304 76h-1s-1 0-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1l1 1v3zM309 81l1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1 1-1zm-2 0v-4s0-1 1-1h1v5h-2zM313 81c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4l1 1c1 0 1-1 1-1zm-1 0c-1-1-1-1-1-2v-2c1 0 1-1 1-1h1v5h-1zM318 81v-1l1-1c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1zm-2 0v-5h1l1 1v3l-1 1h-1zM322 81l1-1v-1c0-1 0-2-1-3h-2s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1l1-1zm-2 0v-5h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1zM328 76v1c1 0 1 0 1-1h-2 1zM326 77v4l1 1h1c-1 0-1-1-1-1 0-1-1-1-1-2s0-1 1-2v-1c-1 0-1 1-1 1zM337 82v-1h-1v-5h-1v1-1h1v5h-1v1h2zM341 81s1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1zm-1 0c-1-1-1-1-1-2v-2c1 0 1-1 1-1h1v5h-1zM343 77v4c1 0 1 1 2 1v-1c1 0 1 0 1-1l1-1c0-1-1-2-1-3h-2l-1 1zm1-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-5zM348 76h1v5h-1v1h2v-1h-1v-5h-1v1-1zM353 76v5h-1v1h2v-6h-2v1c0-1 1-1 1-1zM356 79v2c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v2zm1-2v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 3h-1v-4zM363 76s1 0 1 1v4h-1v1h2v-1h-1v-5h-1v1-1zM369 81s1 0 1-1v-4h-2c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1zm-1 0c-1-1-1-1-1-2v-2s1 0 1-1h1v5h-1zM374 81h-1v-5h-2l1 1v-1 6h2v-1zM377 81h-1v1h2v-1h-1v-5h-1v1-1 1h1v4zM381 81h-1v1h2v-6h-2v1s0-1 1-1v5zM386 81c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1zm-1 0v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2h-1zM388 79v2c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1v2zm1-2v-1h1l1 1v4h-2v-4zM394 81h-1v1h2v-6h-1s-1 0-1 1h1v4zM401 82v-1c1 0 1 0 1-1v-3l-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2v1c-1 0-1-1-1-1v-4zM404 77h1v4h-1v1h2v-1h-1v-5s-1 0-1 1zM410 81s1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s1 1 1 2l1 1s1 0 1-1zm-2 0v-3c0-1 1-1 1-2h1v5l-1 1s0-1-1-1zM413 77v4c0 1 0 1-1 1h3c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1zM416 79v2c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v2zm1-1v-2h1l1 1v4h-1v1l-1-1v-3zM420 79c0 1 0 1 1 2l1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2zm1-1c0-1 0-1 1-2h1v5c-1 0-1 1-1 1s0-1-1-1v-3zM426 77v5h-1 3-1v-6c-1 0-1 0-2 1h1zM432 82v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1l-1 1v4c1 1 1 1 2 1h1zm-2-1v-5h1s0 1 1 1v4h-1v1c-1 0-1-1-1-1zM437 82h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s1 1 1 2 1 1 1 1zm-1-4c0-1 0-1 1-2h1v5l-1 1s0-1-1-1v-3zM442 76c-1 0-1 0-2 1h1v2h1v-3zM441 81v1h-1 3-1v-2h-1v1zM447 82h-1v-1 1h1zM446 78v-1 1zM450 76h-1v1l-1 1h1c0-1 0-1 1-2h1v2h1c0-1 0-1-1-1 0-1 0-1-1-1zM456 81v-4c-1-1-1-1-2-1s-1 1-1 1v4h1c-1 0-1-1-1-2 0 0 0-1 1-1v-2h1v5h1zM457 81c1 1 1 1 2 1h1v-1h-1v1c-1 0-1-1-1-1v-2c-1 0-1 0-1-1v3zM478 82h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v3-1c0-1 0-1 1-1v-1h1v5l-1 1s0-1-1-1v-1 1c0 1 1 1 1 1zM481 80c0 1 0 0 0 0v-1 1zM42 86v2-2zM45 85h-2 1v4h1v1-5zM49 85h-1s-1 0-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1l1 1v3zM54 90c-1 0-1 0-1-1v-4h-1 1v5h-1 2zM57 91c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4l1 1zm-1-5c1 0 1-1 1-1h1v5h-1c-1-1-1-2-1-2v-2zM62 85h-1s-1 0-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1s1-1 1-2c0 0-1-1-1-2h-1zm1 4-1 1h-1v-5h1l1 1v3zM66 85h-1l-1 1v2s0 1 1 2h2l1-1v-2s0-1-1-2h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v3zM72 90h1c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4h1zm0-4v-1h1v5h-1c0-1-1-2-1-2 0-1 0-1 1-2zM77 85h-1s-1 0-1 1v4h3v-1c1 0 1-1 1-2 0 0-1-1-1-2h-1zm1 4-1 1h-1v-5h1l1 1v3zM81 85h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2h2l1-1v-2s0-1-1-2h-1zm1 4v1h-2v-4s0-1 1-1 1 0 1 1v3zM86 90v-5h-2 1v5h-1 2zM90 85h-1s-1 0-1 1v3c1 1 1 1 2 1s1 0 1-1c0 0 1-1 1-2s-1-1-1-2h-1zm0 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM94 90v-5h-1 1v5h-1 2-1zM99 90v-5h-2 1v5h-1 2zM104 85c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1s1 0 1-1v-4zm-1 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM109 84s0 1-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1l1-1v-2c0-1 0-1-1-2l-1-1zm1 5c0 1 0 1-1 1h-1v-4s0-1 1-1 1 0 1 1v3zM115 85c-1 0-1-1-2-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2v1s0-1 1-1c-1 0-1-1-1-1v-2l1-1h1v4l1-1v-3zM118 85v-1c-1 1-1 1-2 1h1v1h1v-1zM118 87h-1 1v-1 1zM233 90h-1 1zM236 90h1s0-1 1-1v-3h-1v3l-1 1s-1 0-1-1v-3 1l-1 1s0 1 1 1c0 1 0 1 1 1zM235 84v1c1 0 1-1 1-1v1h1c0-1-1-1-1-1h-1zM240 90h-1 2v-4h-1v4zM243 89c1 1 1 1 2 1s1-1 1-1v-4h-1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3h-1v3zM249 84h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-4c1 0 1-1 1-1v1h1v4zM255 85v5h-1 2v-6c-1 0-1 1-2 1h1zM260 84h-1c0 1-1 1-1 1v4c1 1 1 1 2 1s1-1 1-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm0 5v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM262 85v4c1 0 1-1 1-1v-3s0-1 1-1h-1c0 1 0 1-1 1zM264 90h-1 1zM285 86c0 1 1 1 1 1v-1h-1zM296 84s0 1-1 1h1l1-1h-1zM301 84c-1 0-1 1-1 1h1v-1zM301 86c0 1-1 1-1 1v1h1v-2zM303 86c1 0 1-1 1-1-1 0-1 1-1 1zM306 89c1-1 1-1 1-2s-1-2-1-2 0-1-1-1c0 0 0 1 1 1v4l-1 1h1v-1zM309 84h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1v-1s0 1 1 1v4zM314 90v-6c-1 0-1 1-2 1h1v5h-1 3-1zM319 90h-1v-6l-1 1v5h2zM322 90v-6l-1 1h1v5h-1 2-1zM329 84c-1 0-1 0-1 1-1 0-1 0-1 1v3l1 1h1c1 0 1-1 1-1v-4l-1-1zm0 5v1c-1 0-1 0-1-1v-4h1c0 1 1 1 1 2s-1 2-1 2zM333 84s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-4h2v4zM337 84l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1h1v4zM341 84v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-1h1v4zM346 84c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-1-1-2l-1-1zm1 5c-1 0-1 1-1 1-1 0-1 0-1-1v-4h2v4zM350 84c0 1-1 1-1 1h1v5h-1 2-1v-6zM354 84v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1l1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1l1-1h1v4zM359 90v-6l-1 1v5h2-1zM365 84l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1h1v4zM369 84v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2 0 0 0-1 1-1v-1h1v4zM373 90h2-1v-6l-1 1v5zM378 84l-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-3c0-1 0-1 1-1h1v4zM382 84v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1h1v4zM387 84c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1s1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1c-1 0-1 0-1-1v-4h1c1 1 1 1 1 2s0 2-1 2zM391 84c0 1-1 1-1 1h1v5h-1 2-1v-6zM396 90v-6h-1c0 1 0 1-1 1h1v5h-1 2zM402 84l-1 1v5h2-1v-6zM406 90v-6c0 1-1 1-1 1h1v5h-1 2-1zM410 84v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-1v-2l1-1h1v4zM414 85v5h2-1v-6c-1 1-1 1-2 1h1zM419 84l-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1 0 1-1 1-2s0-1-1-2l-1-1zm1 5c0 1 0 1-1 1 0 0-1 0-1-1v-4h1s1 0 1 1v3zM423 84s0 1-1 1v1c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3l1-1h1v4zM426 85h1v5h-1 3-1v-6c-1 1-1 1-2 1zM432 84l-1 1s-1 0-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1zm1 5c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM439 84c-1 1-1 1-2 1h1v5h-1 2v-6zM443 90c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM446 85l-1 1v3c1 1 1 1 2 1h1v-1h1l-1-1v1c0 1 0 1-1 1h-1v-5h2-2zM460 85h-1v3h1v-3zM465 90zM463 85zM469 90zM469 90h-2 2zM468 89h1v-3l-1 1v2zM473 88v1h1v-4h1s1 0 1 1v3c0 1-1 1-1 1h1v-1h1v-1h-1c0-1 0-1 0 0h1c0-1-1-2-1-3h-2v1h-1v2zM479 85h-1v1c-1 0-1 1-1 2h1v-2s0-1 1-1h1v2h1c0-1 0-1-1-2h-1zM482 86v1-1zM482 86zM46 95v2-2zM49 93l-1 1v5h2-1v-6zM54 99l-1-1v-5l-1 1h1v5h-1 2zM57 99h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1l-1 1v4c0 1 1 1 1 1zm-1-4 1-1v-1c1 0 1 0 1 1v5h-1v-1c-1 0-1-1-1-2v-1zM62 99v-6c-1 0-1 1-1 1v5h2-1zM66 93h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-4l1-1v1h1v4zM73 99v-6c-1 0-1 1-2 1h1v5h-1 3-1zM77 93h-1c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5c-1 0-1 0-1 1-1 0-1 0-1-1v-4c0-1 1-1 1-1v1h1v4zM81 93h-1v1c-1 1-1 1-1 2s0 2 1 2c0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1s-1 0-1-1v-3c0-1 0-1 1-1v-1 1h1v4zM87 96v-2c-1-1-1-1-2-1l-1 1v4-3l1-1v-1c1 0 1 0 1 1v4h1v-2zM90 98v-5c-1 0-1 1-1 1v5h1v-1zM94 93l-1 1h1v3-4zM99 94c0-1 0-1-1-1l-1 1c0 1-1 1-1 2v1h1v-2c0-1 1-1 1-1v-1h1v5h1v-2c0-1 0-2-1-2zM103 99l1-1v-4l-1-1h-1l-1 1v3s0 1 1 1v1h1zm-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1zM223 99zM228 98l-1 1h1v-1zM232 99l1-1v-1l1-1c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s0 1 1 1v4h-2v-4zM238 96c0-1 0-2-1-3h-2s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1zm-1 2h-2v-5h1c1 0 1 1 1 1v4zM240 93v5h-1v1h2v-6h-2v1c0-1 1-1 1-1zM245 99v-1c1 0 1 0 1-1v-4h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM249 93h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1s1 0 1 1v3zM255 93c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-4h-2zm1 4v1h-1c-1-1-1-1-1-2v-2c1 0 1-1 1-1h1v4zM260 93h-1v6h2v-1h-1v-5zM264 99l1-1 1-1v-1c0-1 0-2-1-3h-2s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1zm-1-5v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM268 99c1 0 1-1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1s-1 1-1 2c0 0 1 1 1 2l1 1zm-1-5 1-1h1v5h-1c-1-1-1-1-1-2v-2zM271 93h1-1zM272 97v1h2-1v-3l-1-1v3zM275 98c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1 0 1-1h-1v1c0 1 0 1-1 1h-1v-3h-1v3zM280 98l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1s-1 0-1 1v1s0 1 1 2zm0-4s0-1 1-1h1v5h-2v-4zM285 93c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2zm1 1 1 1c0 1-1 2-1 2v1h-1c0-1-1-1-1-2s1-1 1-2v-1h1v1zM290 96s0 1 1 2c0 0 0 1 1 1l1-1 1-1v-2h-1v2c0 1 0 1-1 1h-1v-4h-1v2zM295 98l1 1s1 0 1-1c0 0 1 0 1-1v-3h-1v4h-1c-1-1-1-1-1-2v-1h-1v1s1 1 1 2zM302 98h-1v1h1v-1zM301 96c0-1-1-1-1-2v5h1v-4 1zM304 93c0 1 0 1 1 1v4h-1v1h2v-1h-1v-5h-1zM309 93h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-4l1-1h1v5zM314 98v-5h-2v1l1-1v5h-1v1h3v-1h-1zM317 98v1h2v-1h-1v-5h-1v1-1 5zM322 98v-5h-1v1-1s1 0 1 1v4h-1v1h2v-1h-1zM328 98v1-1zM330 93h-2c-1 0-1 1-1 1v4h1v-5h1v1s1 1 1 2l-1 1h1v-4zM333 99l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2l-1 1v3c0 1 0 1 1 1 0 1 0 1 1 1zm-1-5v-1h1l1 1v4h-2v-4zM338 98v-5h-2v1-1c1 0 1 1 1 1v4h-1v1h2v-1zM341 93c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-3c-1-1-1-1-2-1zm1 5h-1c0-1-1-1-1-2s0-1 1-2v-1h1v5zM346 93h-1l-1 1v4c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-2v-5h1s0 1 1 1v4zM350 93h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1-1-1-1-1zm1 5c-1 0-1 1-1 1l-1-1v-4l1-1c1 0 1 1 1 1v4zM354 93c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-3c-1-1-1-1-2-1zm1 5-1 1v-1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h1v5zM359 98v-5c-1 0-1 0-1 1v5h2c-1 0-1 0-1-1zM365 93h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c-1 0-1 1-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM370 93c-1 0-1 0-2 1h1v4c0 1 0 1-1 1h3c-1 0-1 0-1-1v-5zM374 93h-1l-1 1v4c1 1 1 1 2 1h1v-1c0-1 1-2 1-2 0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-5h1s0 1 1 1v4zM378 93h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-3c0-1 0-1 1-2 1 0 1 1 1 1v4zM382 93c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1zm1 5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1c0-1 1-1 1-2h1v5zM387 93c-1 0-1 0-2 1h1v5h2-1v-6zM391 93h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1c1 0 1 1 1 1v4zM395 98v1h-1 2v-6h-1l-1 1h1v4zM402 93h-1l-1 1v4c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-4c0-1 1-1 1-1 0 1 0 1 1 1v4zM406 98v-5s-1 0-1 1h1v4s0 1-1 1h2c-1 0-1-1-1-1zM410 93c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c0 1-1 1-1 1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM414 94v5h2-1v-6c-1 0-1 0-2 1h1zM419 93h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5h-1v1l-1-1v-4l1-1c0 1 1 1 1 1v4zM423 93h-1v1c-1 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c0 1-1 1-1 1s0-1-1-1v-3c0-1 1-1 1-1v-1h1v5zM428 93h-1l-1 1v4c0 1 1 1 1 1h1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1s-1-1-1-2l1-1v-1c0-1 0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2zM432 93s-1 0-1 1c0 0 1 0 1 1v3h-1v1h2-1v-6zM438 93l-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM443 99l1-1v-4l-1-1h-1l-1 1v4c1 1 1 1 2 1zm-1-4v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-3zM446 94h1v5h-1 2-1v-6l-1 1zM450 93v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 1-1 1-1v-1c-1 0-1-1 0-1v-2h-1c0-1 0-1-1-1h-1zm2 1v5h-1l-1-1v-3c0-1 0-1 1-1v-1l1 1zM455 99v-1s0-1-1-1v1l1 1zM454 95zM469 93c-1 0-1 1-2 1h1v1h1v-2zM50 107c-1 0-1 0-1 1h1v-1zM49 102h-1v1-1 2h1v-2zM55 106v-1 1zM54 102v1h1v1c0-1 0-1-1-2zM52 107l1 1v-1h-1v-2c0-1 0-1-1-2v2s0 1 1 2zM58 107v-5h-2v1c0-1 1-1 1-1v6h1v-1zM62 107v-5h-1v1-1 6h2v-1h-1zM66 102h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v3zM73 107v-5h-2 1v5h-1 3-1zM76 102l-1 1v4h1v-5h1-1zM104 105v-3h-2 1v1c1 0 1 1 1 1v3-2zM108 102zM111 104h-1 1v-1 1zM114 107zM113 104zM113 106h1-1zM220 107h-1v-1 1h1zM219 101zM223 102v5h-1 2c-1 0-1-1-1-1v-5c0 1 0 1-1 1h1zM227 102v5h-1 2v-6c-1 1-1 1-2 1h1zM233 107h-1v-6l-1 1v5h2zM236 107v-6c0 1-1 1-1 1h1v5h-1 2-1zM240 102v5h-1 2v-6c-1 1-1 1-2 1h1zM245 107c1 0 1-1 1-1v-4l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM249 101s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-4h2v4zM255 101v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1l1-1h1v4zM259 102v5h2-1v-6c-1 0-1 1-1 1zM265 107h-1v-6l-1 1h1v5h-1 2zM268 107h-1 2v-6c-1 0-1 1-2 1h1v5zM272 102v5h2-1v-6c-1 0-1 1-2 1h1zM276 102h1v5h-1 2-1v-6l-1 1zM281 107h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1h1v5h-1l-1-1v-3zM285 102v5h-1 3-1v-6c-1 0-1 1-2 1h1zM292 107h1s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM296 102v5h-1 2v-6h-1c0 1 0 1-1 1h1zM299 102h1v5h2-1v-6c-1 1-1 1-2 1zM304 107h2-1v-2 1s0 1-1 1zM304 102zM310 107v-6h-1c0 1-1 1-1 1h1v5h1zM314 107v-6c-1 1-1 1-2 1h1v5h-1 3-1zM318 101s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-1-1-2l-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h2v4zM322 107v-6c0 1-1 1-1 1h1v5h-1 2-1zM328 102v5h-1 3-1v-6c-1 1-1 1-2 1h1zM332 107h2-1v-1 1-1c0 1 0 1-1 1zM333 106v-1 1zM337 101l-1 1v1c0-1 0-1 1-1h1v2s1 0 0 0h1c0-1 0-1-1-2 0 0 0-1-1-1zM342 101c-1 1-1 1-2 1h1v2h1v-3zM343 107h-1v-1h-1v1h-1 3zM346 101c0 1-1 1-1 1v4h1v-5zM352 106v-2c0-1 0-1-1-2l-1-1-1 1-1 1v1c0 1 0 2 1 2v1-4s0-1 1-1 1 0 1 1v4h-1 1s0-1 1-1zM356 104v-2c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 0 1 1 1v-1c-1 0-1-1-1-1v-2c1 0 1-1 1-1h1v5h1v-3zM359 101l-1 1v5h1v-6zM366 107s-1 0-1-1v-5c0 1-1 1-1 1h1v5h-1 2zM368 102h1v5h-1 3-1v-6c-1 1-1 1-2 1zM374 101c-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1h1v-1s1-1 1-2-1-1-1-2l-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h1l1 1v3zM378 101s0 1-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1l1-1v-2c0-1 0-1-1-2l-1-1zm1 5c0 1 0 1-1 1h-1v-4s0-1 1-1 1 0 1 1v3zM383 101c-1 1-1 1-2 1h1v5h-1 2v-6zM387 101c-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1s1 0 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM391 102h-1 1v5h-1 2-1v-5zM395 102h-1v1c-1 0-1 1-1 2l1 1c0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2h-1zm1 4v1h-1c-1-1-1-2-1-2v-2l1-1h1v4zM402 107v-5h-1v5h2-1zM406 107v-5h-1 1v5h-1 2-1zM411 102h-2 1v5h-1 2v-5zM415 102h-1s-1 0-1 1v4h2c1 0 1 0 1-1v-4h-1zm0 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM419 102h-1s1 0 1 1v4h-1 2-1v-5zM423 102h-1v1c-1 0-1 1-1 2 0 0 1 1 1 2h2s1 0 1-1v-2s0-1-1-2h-1zm1 4v1h-2v-4l1-1h1v4zM428 102h-1c-1 0-1 0-1 1v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-1zm0 4v1h-1c0-1-1-2-1-2 0-1 1-1 1-2v-1h1v1l1 1c0 1-1 2-1 2zM432 102h-1s-1 0-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM439 107v-5h-2 1v5h-1 2zM443 108v-1c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM447 108s0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s1 0 1 1v3c0 1 0 1-1 1h-1v-4zM452 107v-5h-2 1v5h-1 2zM455 107h-1 2-1zM52 111h2c0-1-1-1-1-1l-1 1zM62 116h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h2v4c-1 0-1 1-1 1-1 0-1 0-1-1v-3zM66 116v-6l-1 1h1v5h-1 2-1zM72 110v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-1h1v4zM86 116zM90 116c1 0 1-1 1-1v-1s0 1-1 1v1c-1 0-1 0-1-1v-1c-1 0-1 1-1 1 1 1 1 1 2 1zM95 116h-1 1zM98 112v1h1v-1h-1zM102 111v2h1v-2h-1zM102 111h-1 1zM110 112zM110 113h1-1zM110 113c1 0 0-1 0-1v1zM108 115c0 1 0 1 1 1h1s0-1 1-1l-1-1v1l-1 1s-1 0-1-1v-3h-1v1c0 1 0 2 1 2zM112 116h1-1zM119 114c0 1 0 1-1 1 1 0 1-1 1-1zM119 114zM119 112zM120 113zM121 113zM218 111v5h2s-1 0-1-1v-5s-1 0-1 1zM223 116s1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-4c0-1 0-1 1-2h1v5c-1 0-1 1-1 1s0-1-1-1v-3zM227 110c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-3c-1-1-1-1-2-1zm1 5s0 1-1 1v-1c-1-1-1-1-1-2v-1c1-1 1-1 1-2h1v5zM231 115v1h2l-1-1v-5c-1 0-1 0-1 1v4zM236 115v-5s-1 0-1 1h1v4h-1v1h2v-1h-1zM240 111v4s0 1-1 1h2v-6c-1 0-1 0-2 1h1zM245 116v-1c1 0 1 0 1-1v-3l-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2h-1v-4zM249 110h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 5h-2v-5h1l1 1v4zM255 110c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-4h-2zm1 5h-1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h1v5zM259 111v-1 6h2v-1h-1v-5h-1v1zM265 115h-1v-5h-1v1-1l1 1v4h-1v1h2v-1zM268 116c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM273 116v-1c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2h-1v-4zM277 116l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-2s0 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v4h-2v-4zM282 115v-5h-2v1s0-1 1-1v5h-1v1h2v-1zM285 116c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm0-5v-1h1v1s1 1 1 2c0 0-1 1-1 2h-1c0-1-1-1-1-2s1-1 1-2zM292 116l1-1 1-1v-1c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1zm-1-5v-1h1c1 0 1 1 1 1v4h-2v-4zM296 111v4s-1 0-1 1h2v-6h-1l-1 1h1zM301 110h-1c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM304 111h1v4h-1v1h2s0-1-1-1v-5s-1 0-1 1zM309 115c0 1-1 1-1 1h2v-2h-1v-1 2zM315 116c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1v5h2zM318 115v-5s-1 0-1 1v5h2s-1 0-1-1zM322 115v-5s-1 0-1 1h1v4l-1 1h2v-1h-1zM328 111v5h-1 3-1v-6c-1 0-1 0-2 1h1zM332 111c1 0 1 0 1 1v3h-1v1h2-1v-6s-1 0-1 1zM337 116h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1zm-1-4c0-1 0-1 1-2h1v5l-1 1s0-1-1-1v-3zM341 111v5h-1 3-1v-6c-1 0-1 0-2 1h1zM346 116h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1l-1 1v4c1 1 1 1 2 1zm-1-4v-2h1c0 1 0 1 1 1v4h-1v1c-1 0-1-1-1-1v-3zM349 115v-3h-1v1c0 1 0 1 1 2zM365 113v-1 1zM365 110l-1 1h1v1-2zM369 110l-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5c0 1 0 1-1 1v-1c-1 0-1-1-1-2 0 0 0-1 1-1v-2h1v5zM374 110h-1c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-4c0-1 1-1 1-1 0 1 0 1 1 1v4zM378 110h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-3c0-1 0-1 1-1v-1l1 1v4zM381 111h1v5h-1 2v-6c-1 0-1 0-2 1zM387 110c-1 0-1 0-2 1h1v5h2-1v-6zM391 110h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5-1 1s-1 0-1-1v-4l1-1 1 1v4zM395 110h-1v1c-1 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM402 110c-1 0-1 1-1 1v3h1v-4zM408 115v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v1h1v1-2l1-1v1h1v4l-1 1h1c0-1 0-1 1-1zM404 113v-1 1zM410 110l-1 1c0 1-1 1-1 2s1 2 1 2c0 1 1 1 1 1h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1s1 0 1 1v4zM415 110h-1c0 1-1 1-1 1v4c1 1 1 1 2 1s1-1 1-1v-4l-1-1zm0 5v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM418 111h1v5h-1 2-1v-6l-1 1zM423 110s0 1-1 1h1v5h-1 2v-6h-1zM428 110h-1l-1 1v4c0 1 1 1 1 1h1c1 0 1-1 1-1v-4l-1-1zm0 5v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1v-1s0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2zM432 116v-6l-1 1s1 0 1 1v3l-1 1h2-1zM439 111c0-1 0-1-1-1l-1 1c0 1-1 2-1 2 0 1 0 1 1 1v1c0 1 1 1 1 1h1-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1s1 0 1 1v4h1v-2c0-1 0-2-1-2zM443 110c-1 0-1 1-2 1h1v3h1v-4zM447 110l-1 1h1v1-2zM455 110c-1 1-1 1-1 2v1l1-1v-2h1-1zM62 119h-1v1h1v-1zM68 122c0-1 0-2-1-3h-2s0 1-1 1v2h1v-3h1c1 0 1 1 1 1v4l1-1v-1zM72 119v5h-1v1h3v-1h-1v-5h-2v1c1 0 1-1 1-1zM75 120v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1v-1h-1v-1 4h-2v-5l-1 1zM81 124h-1v1h2v-1h-1v-4 4zM85 119v5h-1v1h2v-6h-2v1c0-1 1-1 1-1zM90 119h-1l-1 1v4h1v-5h1v1c1 0 1 0 1-1h-1zM109 120v1-1zM114 120v1c1 1 1 1 1 0v-1h-1zM112 121zM118 119h-1v2c1 0 1 0 1 1v-3s-1 0 0 0zM122 119h-1c1 0 1 1 1 1v1-2zM125 121zM128 121zM130 121s1 0 1-1h-1v1zM136 123zM138 124zM205 123zM203 124zM219 118l-1 1s-1 0-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1zm1 5c0 1-1 1-1 1-1 0-1 0-1-1v-4h1l1 1v3zM223 124h-1 2c-1 0-1 0-1-1v-5c0 1-1 1-1 1h1v5zM227 118v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-1v-2c1 0 1-1 1-1h1v4zM232 124h1v-1s1-1 1-2-1-1-1-2l-1-1c-1 0-1 1-1 1s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1l1 1v3l-1 1c-1 0-1 0-1-1v-3zM236 124v-6c0 1-1 1-1 1h1v5h-1 2-1zM240 118v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-1v-2l1-1h1v4zM245 124c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM249 124v-6c0 1-1 1-1 1h1v5h-1 2-1zM256 118c-1 1-1 1-2 1h1v5h-1 2v-6zM259 119v5h2-1v-6l-1 1zM264 124h-1 2-1v-6c0 1-1 1-1 1h1v5zM268 124h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM273 124c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM277 124h1v-1c1-1 1-1 1-2s0-1-1-2l-1-1s-1 0-1 1l-1 1v3c1 1 1 1 2 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM281 124h-1 2v-6h-1c0 1 0 1-1 1h1v5zM285 124h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1c0 1 1 1 1 2s-1 2-1 2v1h-1v-1s-1-1-1-2c0 0 1 0 1-1zM292 124h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM296 119v5h-1 2v-6h-1c0 1 0 1-1 1h1zM301 124c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1v1c1 0 1 0 1 1s0 2-1 2v1c-1 0-1 0-1-1v-3zM304 119h1v4c0 1 0 1-1 1h2-1v-6c0 1-1 1-1 1zM309 119v5h-1 2v-6h-1c0 1-1 1-1 1h1zM312 123c0 1 1 1 1 1h1-1v-1l-1-1v-2 3zM319 124h-1c0-1 0-1-1-1l1 1h1zM318 123v1-1zM318 118c0 1-1 1-1 1v2c1 0 1 0 1 1v-4zM322 124v-6c0 1-1 1-1 1h1v5h-1 2-1zM328 119v5h-1 3-1v-6c-1 1-1 1-2 1h1zM332 119l1 1v3c0 1 0 1-1 1h2-1v-6c0 1-1 1-1 1zM337 124h1s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4s0-1 1-1h1v5h-2v-4zM343 119h-2c-1 0-1 0-1 1v4h1c0-1-1-2-1-2 0-1 0-1 1-2v-1h1v3h1v-3zM345 119s-1 0-1 1v2-1l1-1v-1h1-1zM375 123s1-1 1-2c0 0-1-1-1-2h-2v1-1h1l1 1v3l-1 1h1v-1zM378 119h-1l-1 1v2s0 1 1 2c0 0 0 1 1 1l1-1 1-1v-1c0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-4s0-1 1-1 1 0 1 1v3zM381 119h1v5h-1 2v-5h-2zM387 119h-1s-1 0-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4h-1zm0 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM390 124zM391 119h-1c1 0 1 0 1 1v3-4zM406 122v1-1zM406 123v-1 2-1zM406 123zM412 123v-1c0-1 0-2-1-3h-2v1c1 0 1-1 1-1h1v5s1 0 1-1zM416 122v-3h-2l-1 1v4c1 0 1 1 2 1v-1h1c0-1 0-1 0 0v-2zm-1 1v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM419 119h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1s1 0 1 1v3zM423 119h-1v1c-1 0-1 1-1 2 0 0 1 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4l1-1h1v4zM428 119h-2v1l1-1v5h-1v1h3v-1h-1v-5zM431 124v1h2v-1h-1v-3 3h-1zM431 120v-1 1zM437 120v1-1c1 0 1-1 1-1-1 0-1 1-1 1zM457 122v-2 4-2zM459 124v1h2v-1h-1v-3c0-1 0-1-1-1v4zM81 127l-1 1h2v1c0 1 1 1 1 1 0-1 0-2-1-2 0 0 0-1-1-1zM86 127c-1 1-1 1-2 1h1v2l1 1v-4zM91 133h-1v-6l-1 1v4l1 1h1zM94 133h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM97 128zM118 133h-1 1zM122 132zM141 131s0-1-1-1c0 1 0 1 1 1zM138 128zM138 131v-1s-1 1 0 1zM138 130v-1 1zM204 127zM219 127h-1c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-4c0-1 1-1 1-1 0 1 0 1 1 1v4zM225 130c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 0-1 1-1v-2zm-1 2-1 1s0-1-1-1v-3c0-1 0-1 1-1v-1h1v5zM227 127c-1 0-1 1-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5c0 1 0 1-1 1v-1c-1 0-1-1-1-2v-1l1-1v-1h1v5zM232 132v-5c-1 0-1 0-1 1v5h2-1v-1zM236 132v-5s-1 0-1 1h1v4s0 1-1 1h2c-1 0-1-1-1-1zM241 132v-5c-1 0-1 0-2 1h1v5h-1 2v-1zM245 132v-5c-1 0-1 0-2 1h1v5h2-1v-1zM249 132v-5s-1 0-1 1h1v4s-1 0-1 1h2-1v-1zM255 127c-1 0-1 1-1 1v4c0 1 1 1 1 1h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1zm1 5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1c1-1 1-1 1-2h1v5zM260 127h-1l-1 1v4c1 1 1 1 2 1l1-1c0-1 1-2 1-2 0-1-1-2-1-2 0-1-1-1-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2s0 1-1 2zM264 133h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4v-2h1c1 0 1 1 1 1v4h-1v1l-1-1v-3zM268 133c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1s-1 1-1 1c0 1-1 1-1 2s1 1 1 2l1 1zm-1-4c0-1 1-1 1-2h1v5l-1 1v-1c-1-1-1-1-1-2v-1zM272 132v1h2c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1v4zM277 133h1v-1c1-1 1-2 1-2 0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v4c1 1 1 1 2 1zm-1-4v-2h1l1 1v4h-1v1l-1-1v-3zM281 133h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1zm-1-4c0-1 0-1 1-2h1v5l-1 1s0-1-1-1v-3zM285 133h1l1-1v-4l-1-1h-1c-1 0-1 1-1 1v4c0 1 1 1 1 1zm0-4v-2h1v1s1 1 1 2-1 1-1 2 0 1-1 1v-1c0-1-1-1-1-2l1-1zM292 133h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4v-2h1c1 0 1 1 1 1v4h-1v1l-1-1v-3zM296 128v5h-1 2v-6h-1l-1 1h1zM301 133l1-1v-4l-1-1h-1c-1 0-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-2h1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3zM304 128h1v4h-1v1h2-1v-6s-1 0-1 1zM309 128v5h-1 2v-6h-1s-1 0-1 1h1zM313 133h1l1-1v-4c-1-1-1-1-2-1s-1 1-1 1v4c0 1 1 1 1 1zm0-4v-2h1v5c0 1 0 1-1 1v-1s-1-1-1-2c0 0 0-1 1-1zM317 128zM317 132v1h2-1v-4s0-1-1-1v4zM322 127s-1 0-1 1h1v4-5zM321 133h1-1zM329 127h-1l-1 1v3h1v-3c0-1 0-1 1-1v1c0 1 1 1 1 2v-2l-1-1zM333 127s-1 0-1 1h1v-1zM337 133zM340 132h1-1zM379 133s0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v1c1 1 1 1 1 2v-2c0-1 0-1 1-1v-1 1h1v4l-1 1h1zM382 127l-1 1c0 1-1 2-1 2 0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1s1 0 1 1v4zM386 128v5h1v-6c-1 0-1 1-2 1h1zM419 127l-1 1h1v3-4zM420 133h-1v-1 1h1zM425 130c0-1 0-2-1-2 0-1 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 1 2 1 2v1-4c0-1 1-1 1-1h1v4h1v-2zM428 127c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4l-1-1zm0 5v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1v-1h1c0 1 1 1 1 2s-1 2-1 2zM431 128l1 1v3l-1 1h2-1v-6l-1 1zM437 129l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1-1 0-1 0-1 1zM461 130v1h1v-1s0-1-1-1v1zM458 129v-1 1zM459 132v-2c0 1-1 0-1 0v1l1 1c0 1 1 1 1 1-1 0-1 0-1-1zM460 127s-1 0-1 1c0 0 0 1-1 1 0 0 0 1 1 1v-2h2l-1-1zM465 130zM465 132v1-1zM463 131v-2h-1v1l1 1zM463 132v-1c-1 0 0 1 0 1v1h2-1l-1-1zM467 133zM94 137c0-1-1-1-1-1h-1v1c-1 0 0 0 0 1v-2h1l1 1v2h1c0-1 0-2-1-2zM96 137v-1 1zM97 141h-1l1 1v-1h1v-3h-1v3zM101 141l-1 1h1c0-1 0-1 1-1v-2h-1v2zM108 141h-1v1h2v-1h-1v-1 1zM112 142c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c0 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM116 136c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4h-2zm1 1 1 1v1c0 1-1 1-1 2h-1v-5h1v1zM121 142l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v4h-2v-4zM123 139c0 1 0 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3v5h-2v-4l1-1h-1v1c-1 1-1 1-1 2zM128 141l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-1v5h-1c0-1-1-1-1-2s0-1 1-2h-1v4zM135 136zM132 137v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1v-1h-1v3h-2v-5h1-1l-1 1zM134 136c1 0 0 0 0 0zM138 136h-1v1s0-1 1-1zM136 139zM137 140zM138 142s1 0 1-1h-2v-1 1l1 1zM136 140h1-1zM218 136l1 1v1h1c-1-1-1-1-1-2h-1zM223 141h-1v-5h-1 1v5h-1 2zM226 136c-1 0-1 0-1 1 0 0-1 1-1 2 0 0 1 1 1 2h2s1 0 1-1v-4h-2zm1 4v1h-1c-1-1-1-2-1-2v-2l1-1h1v4zM231 141v-5h-2 1v5h2-1zM235 136h-1l-1 1v2s0 1 1 1c0 1 0 1 1 1h1v-1c1 0 1-1 1-2s0-1-1-2h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v3zM239 136h-1v1c-1 0-1 1-1 2l1 1c0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2h-1zm1 4v1h-2v-4l1-1h1v4zM244 141v-5h-2 1v5h-1 3-1zM248 136h-1s-1 0-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s-1-1-1-2c0 0-1-1-1 0zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM254 135v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1c-1-1-1-2-1-2v-2l1-1h1v4zM259 141v-6c-1 1-1 1-2 1h1v5h2-1zM264 141h-1v-6c0 1-1 1-1 1h1v5h-1 2zM268 141s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1h1zm-2-1v-3s0-1 1-1h1v5h-1l-1-1zM272 141c1 0 1 0 1-1v-4c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1zm-1-1-1-1c0-1 1-1 1-2v-1h1v1l1 1c0 1-1 2-1 2v1h-1v-1zM277 141v-1c1 0 1-1 1-2s-1-1-1-2l-1-1-1 1s-1 0-1 1v3c1 1 1 1 2 1h1zm-2-1v-4h1s1 0 1 1v3c0 1-1 1-1 1-1 0-1 0-1-1zM279 136h1v5h-1 2s-1 0-1-1v-5c0 1-1 1-1 1zM284 136v5h-1 3-1v-6c-1 1-1 1-2 1h1zM292 141v-1c1 0 1-1 1-2s-1-1-1-2h-2l-1 1v3c1 1 1 1 2 1h1zm-2 0v-5h1s1 0 1 1v3c0 1-1 1-1 1h-1zM296 141s1 0 1-1v-2c0-1 0-1-1-2h-2v1c-1 0-1 1-1 2 0 0 0 1 1 1 0 1 1 1 1 1h1zm-2 0v-4s0-1 1-1h1v5h-2zM299 141h1c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1v5h-1c0-1-1-2-1-2 0-1 0-1 1-2zM302 139v1c1 1 1 1 2 1h1v-1c1 0 1-1 1-2 0 0-1-1-1-2h-2s-1 0-1 1v2zm1-2v-1h1l1 1v3c0 1-1 1-1 1h-1v-4zM308 141h1l1-1v-2s0-1-1-2h-2v1c-1 0-1 1-1 2 0 0 0 1 1 1 0 1 1 1 1 1zm-1-4s0-1 1-1h1v5h-2v-4zM312 136v5h-1 2v-5h-2 1zM315 139v2h3v-1s1-1 1-2c0 0-1-1-1-2h-2s-1 0-1 1v2zm1-2v-1h1l1 1v3l-1 1h-1v-4zM321 141h1l1-1v-2s0-1-1-2h-2l-1 1v2s0 1 1 2h1zm-1-4v-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM326 137v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-1v5h-1c0-1-1-2-1-2 0-1 0-1 1-2v-1c-1 0-1 0-1 1zM332 142s0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1l1 1v3l-1 1h-1v-4zM335 137c-1 0-1 1-1 2v1c1-1 1-2 1-2v-1s0-1 1-1h-1v1zM382 136h-2v1c0-1 0-1 1-1v4s0 1 1 1v-5zM382 141zM386 136h-2v1l1-1v3h1c-1 0-1 0-1-1l1-1v-1zM387 141h-1l1 1v-1zM388 141c1 0 1 1 2 1v-1h-1v-2h-1v2zM421 137c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1h-2v-5 1zM432 136h-2l-1 1c0 1 1 1 1 0v-1h1s0 1 1 1v4-1h1v-1c0-1-1-2-1-3zM436 136h1-1zM453 140v1h1s0-1-1-1zM456 138h-1v1c1 0 1-1 1-1v-1 1zM458 137v-1 1zM462 137zM464 142v-1h-2v1h2zM463 136h-1v1h1v3-4zM468 139v2l-1 1v-1s-1 0-1-1v1c0 1 1 1 1 1h1c0-1 1-1 1-1v-4c-1 1-1 1-1 0v2zM466 136v1c1 0 1 0 1-1h-1zM465 139c1 0 1-1 1-1v-1c0 1 0 1-1 2zM483 142zM109 150h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1-1 1-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1zm-1-4s0-1 1-1h1v4s0 1-1 1c0 0-1 0-1-1v-3zM114 150v-6c-1 1-1 1-2 1h1v5h-1 2zM117 145v5h2-1v-6c-1 1-1 1-2 1h1zM121 145l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1zm2 0v4s0 1-1 1c0 0-1 0-1-1v-4h2zM126 150h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM130 145v5h2-1v-6c-1 1-1 1-2 1h1zM134 145h1v4s0 1-1 1h2-1v-6c0 1-1 1-1 1zM139 145v5h-1 2v-6h-1c0 1-1 1-1 1h1zM144 149c1 1 1 1 2 1s1-1 1-1v-3 1c0 1 0 2-1 2v1c-1 0-1 0-1-1v-3h-1v3zM149 149c0 1 0 1 1 1h1v-1c1 0 1 0 1-1h-1v1s0 1-1 1c0 0-1 0-1-1v-3h-1v1c0 1 0 2 1 2zM229 145c-1-1-1-1-2-1l-1 1v1l1-1v-1c1 0 1 0 1 1v3h1v-3zM232 144c-1 0-1 1-1 1v4h1v-5zM237 145c0-1-1-1-1-1h-1c0 1 0 1-1 1v3h1v-3l1-1v1h1v3h1v-1c0-1 0-2-1-2zM241 145c0-1 0-1-1-1l-1 1c0 1-1 1-1 2v1h1v-2c0-1 1-1 1-1v-1h1v4h1v-1c0-1 0-2-1-2zM245 144c-1 0-1 1-2 1h1v2c1 0 1 0 1-1v-2zM249 144h-1c0 1 0 1-1 1h1l1-1c0 1 1 1 1 1 0-1-1-1-1-1zM256 144c-1 0-1 0-2 1h1v4h1v-5zM261 149c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 1v4h1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1l1-1zM264 144h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-4l1-1 1 1v4zM268 144l-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 1v4c0 1-1 1-1 1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v1zM274 145l-1-1h-1l-1 1v4c1 1 1 1 2 1l1-1v-4zm-1 4v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM278 150h-1v-6s-1 0-1 1h1v4l-1 1h2zM281 144l-1 1h1v5h-1 2v-6h-1zM286 144c-1 0-1 0-2 1h1v5h-1 3-1v-6zM293 145c0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2zm0 4-1 1s-1 0-1-1v-4l1-1 1 1v4zM296 144h-1v1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM302 147v-2l-1-1h-1l-1 1v4c1 1 1 1 2 1l1-1v-2zm-1 2v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM305 144l-1 1h1v4l-1 1h2-1v-6zM309 144l-1 1h1v5h-1 2v-6h-1zM313 144l-1 1v4c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2c1 0 1 0 1 1v4zM317 144c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1zm2 1v4s-1 0-1 1c-1 0-1 0-1-1v-4c0-1 1-1 1-1v1h1zM321 144v1c-1 1-1 1-1 2s0 2 1 2c0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1zm2 1v5h-1l-1-1v-3c0-1 0-1 1-1v-1 1h1zM329 150v-6c-1 0-1 1-2 1h1v5h-1 2zM331 145v2c1-1 1-1 1-2v-1c0 1-1 1-1 1zM374 150zM387 144v1l1 1v-1l-1-1zM390 145zM414 147l1 1v-2l-1 1zM419 150h-1 2-1v-3 3zM425 147c0-1 0-1-1-2 0 0 0-1-1-1v1h-1 2v5l1-1v-2zM426 145h1-1zM427 149v1h-1 3-1v-4h-1v3zM448 149c1 0 1 0 1-1h-1v1c0 1-1 1-1 1h1v-1zM451 150h1l1-1v-2c0-1 0-1-1-2v5h-1l-1-1v-1h-1l1 1c0 1 1 1 1 1zM454 150h1-1zM454 145h1-1zM455 149h1v-1c-1 0-1 0 0 0v-2h-1v3zM467 146c1 0 1-1 1-1h1c-1 0-1 0-1-1v1c-1 0-1 0-1 1zM469 145h1-1zM533 147v-1 1zM85 159v-1 1zM85 158s-1 0-1-1c0 0 0 1 1 1zM103 159l1-1v-4h-1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-2c-1 0-1 0-1 1v1c1 1 1 1 2 1zM109 159h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-2 1 0 1 1 1 1v4h-1v1l-1-1v-3zM113 153c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1zm1 5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1c0-1 1-1 1-2h1v5zM117 154v5h2-1v-6c-1 0-1 0-2 1h1zM122 153s-1 0-1 1h1v4s-1 0-1 1h2v-1h-1v-5zM126 159s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c0 1-1 1-1 2s1 1 1 2l1 1zm-1-4c0-1 1-1 1-2h1v5l-1 1v-1c-1-1-1-1-1-2v-1zM130 154v5h2c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1zM134 154h1v4h-1v1h2l-1-1v-5s-1 0-1 1zM139 154v4c0 1-1 1-1 1h2v-6h-1s-1 0-1 1h1zM146 159v-1c1 0 1 0 1-1v-3l-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 2 0 0 0 1-1 2v1c-1 0-1-1-1-1v-4zM150 159l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1zm-1-5v-1h1c1 0 1 1 1 1v4h-2v-4zM153 154h1v4h-1v1h2v-5l-1-1s-1 0-1 1zM158 159c0-1 0-1-1-1 1 0 1 1 1 1zM262 155h-1v3-1s1-1 1-2zM264 158v-5h-1 1v5h-1 2-1zM269 153h-1c-1 0-1 0-1 1 0 0-1 1-1 2 0 0 1 1 1 2h2s1 0 1-1v-2s0-1-1-2zm0 4v1h-1c-1-1-1-2-1-2v-2l1-1h1v4zM274 153h-2c-1 0-1 0-1 1v4h2c1 0 1 0 1-1v-4zm-1 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM278 158h-1v-5h-1s1 0 1 1v4h-1 2zM282 153h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3zm0 4v1h-2v-4s0-1 1-1h1v4zM284 153h1v5h-1 3-1v-5h-2zM292 153h-1c1 0 1 0 1 1v4h-1 2-1v-5zM296 158h-1 2v-5h-2 1v5zM302 158h-1v-5h-2 1v5h2zM305 158h1-1v-5h-1l1 1v4zM309 153h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1h1v4zM313 153c-1 0-1 1-1 1v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2zm1 4v1h-1c0-1-1-1-1-2s0-1 1-2v-1h1v4zM318 153h-1l-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1l1 1v3zM322 153h-1 1v4-4zM419 153l1 1c0-1-1-1-1-1zM424 159v-6h-1l-1 1h1v5h1zM428 153h-1c0 1 1 1 1 1v-1zM427 158v1h-1 3-1v-4h-1v3zM430 156h1v1-2c-1 0-1 0 0 0v-1h-1v2zM441 156v2c1 1 1 1 2 1l1-1v-4c0-1-1-1-1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-4h-1v2zM447 158v-5s-1 0-1 1h1v4c-1 0-1 1-1 1h2-1v-1zM451 159h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1zm-1-4c0-1 0-1 1-1v-1h1v5l-1 1s0-1-1-1v-3zM454 159h1-1zM454 154h1v2h1v-1l-1-1v-1l-1 1zM459 159zM460 156h-1v1h1v-1zM466 156h-1v1h1v-1zM463 156h-1v1h1v-1zM467 157v-2 2zM473 156v1h1v-2c-1 0-1 0-1-1v2zM480 159zM100 166v-1 1c-1 0-1 1-1 1s1 0 1-1zM103 167v-5h-2 1v5h2-1zM109 167h1l1-1v-2c0-1 0-1-1-2l-1-1s0 1-1 1l-1 1v2s0 1 1 1c0 1 0 1 1 1zm-1-4s0-1 1-1 1 0 1 1v3c0 1 0 1-1 1h-1v-4zM114 167v-6c-1 1-1 1-2 1h1v5h-1 2zM117 162v5h2-1v-6c-1 1-1 1-2 1h1zM121 162h1v5h-1 2-1v-6c0 1-1 1-1 1zM126 161c0 1 0 1-1 1h1v5h-1 2v-6h-1zM130 162v5h2-1v-6c-1 1-1 1-2 1h1zM135 167h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1-1 1-1 1v3c1 1 1 1 2 1zm-1-4v-1h1s1 0 1 1v3c0 1-1 1-1 1s-1 0-1-1v-3zM139 162v5h-1 2v-6h-1c0 1-1 1-1 1h1zM146 161c-1 1-1 1-2 1h1v5h2-1v-6zM150 161c0 1-1 1-1 1h1v5h-1 2-1v-6zM154 167h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1zm-1-4 1-1h1v5h-1l-1-1v-3zM158 162v5h-1 3-1v-6c-1 1-1 1-2 1h1zM162 162c1 0 1 1 1 1v3c0 1 0 1-1 1h2-1v-6c0 1-1 1-1 1zM166 163zM165 164c0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-3h-1v4h-1l-1-1v-3c-1 0-1 1-1 1zM170 166c0 1 1 1 1 1h1c1 0 1-1 1-1v-2l-1-1v4h-1v-1s-1-1-1-2v-1 3zM175 167h2-1v-1s0-1-1-1v2zM266 166v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2h1v-2l1-1v1h1v5s0-1 1-1zM269 167v-6c-1 0-1 1-2 1h1v5h-1 2zM273 161c-1 0-1 1-2 1h1v5h2-1v-6zM278 167h-1v-6l-1 1h1v5h-1 2zM281 161s0 1-1 1h1v5h-1 2v-6h-1zM287 164v-2l-1-1h-1l-1 1v4c0 1 1 1 1 1h1c1 0 1-1 1-1v-2zm-1 2v1h-1v-1s-1-1-1-2l1-1v-1s0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2zM291 162h1v5h-1 2-1v-6l-1 1zM297 167zM297 165v-4h-1s0 1-1 1h1v5h-1 2v-2zM300 167h2-1v-6c-1 0-1 1-2 1h1v5zM305 161h-1v1c1 0 1-1 1-1v1h1v4l-1 1s-1 0-1-1v-3h-1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zM309 161l-1 1h1v5h-1 2v-6h-1zM314 167v-6c-1 0-1 1-2 1h1v5h-1 3-1zM318 161l-1 1v1c1 0 1-1 1-1v-1zM429 166v-4c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v2c0-1 1-1 1-2v-1h1v1l1 1c0 1-1 2-1 2v1c1 0 1 0 1-1zM431 162c0 1 1 1 1 1v3c0 1-1 1-1 1h2-1v-5h-1zM444 162h-2s-1 0-1 1 0 1 1 1v-2h1v1c1 0 1 1 1 1v1-3zM448 162h-2l-1 1v2h1v-3h1s1 0 1 1v2h1v-1s0-1-1-2zM451 162h-1 1v4-1l1 1v-4h-1zM457 163s-1 0 0 1v1-2zM460 162h-1v4c1-2 1-2 1-3v-1zM459 167zM464 167h-1 2c-1 0-1 0-1-1v1zM474 164h-1v2s0-1 1-1v-1zM477 164h-1v1h1v-1zM483 163h-1v3h1v1c0-1-1-2-1-2 0-1 0-1 1-2z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M485 165v-2s-1 0-1-1h-1c-1 0-1 0-1 1h1v-1h1v4h1v-1zM489 166c1 0 1-1 1-1 0-1-1-2-1-3h-1l1 1v3c0 1-1 1-1 1h-1v-3l-1 1v2h1l1 1s0-1 1-1v-1zM492 162h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2 0 0 0 1 1 1l1-1 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1 1 0 1 1v3zM495 165v2l1 1c1 0 1-1 1-1s1 0 1-1v-2l-1-1v4h-1c-1-1-1-1-1-2v-2h1-1v2zM500 167h2-1v-2h-1v2zM504 167h1-1zM511 167h-1 1zM513 163l-1-1v1h1zM512 163zM511 162zM515 164h-1 1zM514 167c1 0 1-1 1-1-1 0-1 0-1-1v2zM104 173v-2l-1-1h-1c0 1-1 1-1 1s0 1 1 1v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2h1v-2zM109 176h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1zm-1-4c0-1 0-1 1-1v-1l1 1v4l-1 1s-1 0-1-1v-3zM114 175v-5c-1 0-1 0-2 1h1v5h-1 2v-1zM118 176l1-1v-4l-1-1h-1c0 1-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-1c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3zM121 171h1v4c0 1-1 1-1 1h2c-1 0-1 0-1-1v-5s-1 0-1 1zM125 171h1v5h-1 2v-6h-1l-1 1zM130 171v5h2-1v-6c-1 0-1 0-2 1h1zM135 170s-1 0-1 1h1v4h-1v1h2-1v-6zM139 171v5h-1 2v-6h-1s-1 0-1 1h1zM145 171v5h2-1v-6c-1 0-1 0-2 1h1zM149 171h1v4l-1 1h2c-1 0-1-1-1-1v-5s-1 0-1 1zM154 176h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s1 1 1 2 1 1 1 1zm-1-4c0-1 1-1 1-2h1v5c0 1-1 1-1 1s0-1-1-1v-3zM158 171v5h-1 3-1v-6c-1 0-1 0-2 1h1zM163 176h1v-1c1-1 1-2 1-2 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4c1 1 1 1 2 1zm-1-4v-2h1l1 1v4h-1v1c-1 0-1-1-1-1v-3zM167 176h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1zm-1-4c0-1 0-1 1-2h1v5l-1 1s0-1-1-1v-3zM171 171v5h-1 3c-1 0-1 0-1-1v-5c-1 0-1 0-2 1h1zM175 171v5h2s-1 0-1-1v-5s-1 0-1 1zM181 171h1v4c0 1-1 1-1 1h1c1-2 1-3 0-5v-1s-1 0-1 1zM269 175v-5h-2 1v6s1-1 1 0v-1zM274 170h-2c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4zm-1 4v1h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 2zM278 175h-1v-5h-1v1-1l1 1v4h-1v1h2v-1zM283 173c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1zm-1 1v1h-2v-4s0-1 1-1h1v4zM287 175h-1v-5h-2v1l1-1v5h-1v1h3v-1zM291 171v-1l1 1v4h-1v1h2v-1h-1v-5h-1v1zM298 171l-1-1c0 1 1 1 1 1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M297 171v4h-1c-1-1-1-1-1-2v-2s1 0 1-1h1-2v1c0 1-1 1-1 2s1 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-2c-1 0-1-1-1-1zM299 174c1 1 1 2 1 1 0 1 0 1 1 1v-1c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v3zm1-3v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 3h-1v-4zM305 170h-1v1-1 1h1v4h-1v1h2v-1h-1v-5zM309 176s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-5 1-1h1v5h-2v-4zM313 170c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1h1v-2c0-1 0-1-1-2v4h-1c0-1-1-1-1-2s0-1 1-2v-1h1-1zM433 171v1h1l-1-1zM438 171h-1 1v3h1v-2l-1-1zM442 172v-1c0 1-1 1-1 1v2h1v-2zM444 173v-2h-1c1 1 1 1 1 2s0 1-1 2h1v-2zM447 173v2-2zM447 173v-1 1zM452 176v-1h-1v1h-1 2zM454 175h1v-1h-1v1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M457 175v-1h-1v2h-1v-1h-1c0 1 1 1 1 1h1c1 0 1-1 1-1zM461 175s-1 0-1 1c-1 0-1 0-1-1h-1c1 0 1 1 1 1h2v-1zM464 175v-1 1zM467 175c1-1 0-1 0-1v1zM468 176h1c1 0 1-1 1-1h-1v1h-1v-1h-1l1 1zM491 173l-1 1s0 1 1 1v-2zM493 171c0-1 0-1-1-1h-1v1h1v-1 1h1v3s1 0 1 1v-2c0-1 0-2-1-2zM497 176v-6c-1 0-1 1-2 1h1v5h-1 2zM502 171c0-1-1-1-1-1h-1c0 1-1 1-1 2v3c0 1 1 1 1 1v-5s0-1 1-1v1c1 1 1 1 1 2v1c0-1 0-1 1 0v-1c0-1-1-2-1-2zM506 176h-1v-6l-1 1h1v5h1zM510 176zM512 175v-1 1zM512 174zM512 174zM515 176s0-1-1-1c1 0 1 0 1 1zM522 173s-1 0 0 1v-1zM522 172c-1 0 0 1 0 1v-1zM521 171zM519 170c1 0 1 1 1 1 1 0 1 0 1-1h-2zM524 174v1-1zM525 172zM524 175zM525 172zM529 174v2-2zM529 176h1-1zM528 176zM110 184l1-1v-1c0-1 0-2-1-3h-2l-1 1v2l1 1v-3s0-1 1-1 1 0 1 1v3c0 1 0 1-1 1v1l1-1zM114 184v-5h-2 1v5h-1 2zM118 185v-1c1 0 1 0 1-1v-4h-2s-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM123 184h-1v-5h-1c1 0 1 0 1 1v4h-1 2zM126 184h-1 2v-5h-2 1v5zM131 184c1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4h2zm-1-4v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM134 179h1v4c0 1 0 1-1 1h2-1v-5h-1zM139 179v5h-1 2v-5h-2 1zM145 184h2-1v-5h-2 1v5zM149 179h1v5h-1 2-1v-5h-1zM154 184h1s1 0 1-1v-2c0-1 0-1-1-2h-2v1c-1 0-1 1-1 2l1 1c0 1 1 1 1 1zm-1-4 1-1h1v5h-2v-4zM158 184h1c1 0 1 0 1-1v-4c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v3l1 1zm0-4v-1h1v1l1 1c0 1-1 2-1 2v1h-1v-4zM163 184h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1-1 1s-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1s1 0 1 1v3c0 1-1 1-1 1h-1v-4zM167 184h-1 2v-6h-1c0 1-1 1-1 1h1v5zM171 184h1c1 0 1 0 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1zm0-4v-1h1v5h-1v-1l-1-1c0-1 0-1 1-2zM176 184v-6c0 1-1 1-1 1v5h2-1zM269 184l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1v1h1v5h-2 2zM273 178c-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1s1-1 1-1v-4l-1-1zm0 5v1c-1 0-1 0-1-1v-4h1c1 1 1 1 1 2s0 2-1 2zM277 184h-1 2-1v-6l-1 1h1v5zM281 184h-1 2v-6h-1s0 1-1 1h1v5zM285 184h-1 3-1v-6c-1 1-1 1-2 1h1v5zM290 181c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1zm1-1v-1h2v4s0 1-1 1c0 0-1 0-1-1v-3zM296 184h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1h1v5h-1v-1c-1 0-1-1-1-2v-1zM301 184c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM304 179h1v4s0 1-1 1h2-1v-6c0 1-1 1-1 1zM309 184h-1 2v-6h-1c0 1-1 1-1 1h1v5zM313 179v5h-1 3-1v-6c-1 1-1 1-2 1h1zM323 182c1-1 0 0 0-1v1zM332 184h1v-1c0 1 0 1-1 1zM464 179zM476 184h-1v1h1v-1zM479 185s1 0 1-1c0 0 1 0 1-1v-2c-1 0-1 0-1-1v4h-2v-2h-1c0 1 1 1 1 2l1 1zM482 184l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-1s0 1-1 0v2h-1c0-1-1-1-1-2v-1 3zM487 185v-1 1zM488 182h-1v1c1 0 1 0 1-1zM497 184s1 0 1-1v-3h-1v4h-1v1c1 0 1 0 1-1zM500 185v-1 1zM512 179h-1 1zM528 181l-1-1s0 1 1 1zM110 187l1 1c0 1 1 1 1 1s0-1-1-1c0-1 0-1-1-1zM115 187c-1 0-1 1-2 1h1v3h1v-4zM120 193v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 1v4l1 1h2zm-2-1v-4l1-1v1h1v4c-1 0-1 0-1 1-1 0-1 0-1-1zM123 193v-6l-1 1h1v5h-1 2-1zM128 193v-6c-1 0-1 1-2 1h1v5h-1 2zM131 187c0 1-1 1-1 1v4c1 1 1 1 2 1s1-1 1-1v-4l-1-1h-1zm1 1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1zM136 193v-6l-1 1h1v5h-1 2-1zM139 188h1v5h-1 2v-6h-1s0 1-1 1zM146 187c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1zm2 1v4c-1 0-1 0-1 1-1 0-1 0-1-1v-4c0-1 1-1 1-1 0 1 0 1 1 1zM151 192v-5l-1 1h1v4c0 1 0 1-1 1h2c-1 0-1 0-1-1zM155 187l-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 1v5h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v1zM159 187c0 1-1 1-1 1v4c1 1 1 1 2 1l1-1v-4l-1-1h-1zm1 1c1 1 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1zM164 192v-5s-1 0-1 1h1v4c0 1-1 1-1 1h2-1v-1zM169 192v-5h-1l-1 1h1v5h-1 2v-1zM173 192v-5c-1 0-1 0-2 1h1v5h-1 3-1v-1zM176 188zM266 192h-1v-2 3h1v-1zM270 192v-5h-2v1l1-1v5h-1v1h2v-1zM274 192v-5h-1v1-1 6h2v-1h-1zM280 190c0-1 0-2-1-3h-2s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1l1-1 1-1v-1zm-1 2h-2v-5h1c1 0 1 1 1 1v4zM284 190c0-1 0-2-1-3h-2v1c0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1zm-1 2h-1c-1-1-1-1-1-2v-2s1 0 1-1h1v5zM287 192v-5c-1 0-1 0-2 1h1v5h2l-1-1zM293 192v-5s-1 0-1 1h1v4h-1v1h2v-1h-1zM298 192v-5c-1 0-1 0-2 1h1v4s0 1-1 1h2v-1zM302 187h-1l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM306 187h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1c1 0 1 1 1 1v4zM311 192v-5h-1l-1 1h1v4c0 1-1 1-1 1h2v-1zM315 187h-1c-1 0-1 1-1 1v4h1v-5h1v1s1 1 1 2v-2l-1-1zM324 193v-2h-1v2h-1 2zM328 190v2c1 1 1 1 2 1l1-1v-4l-1-1h-1v1h-1v2zm1-1v-2h1v1c1 0 1 1 1 2s0 1-1 2v1c-1 0-1-1-1-1v-3zM333 188h1v2-3c-1 0-1 0-1 1zM462 193h2-1v-2 2h-1zM467 193h-1 2v-6c-1 0-1 1-2 1h1v5zM473 188v5h2-1v-6c0 1 0 1-1 1zM479 193s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1zm-2-1v-3c0-1 0-1 1-1h1v5h-1l-1-1zM483 193c1 0 1-1 1-1v-4c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1zm-1-1c-1 0-1-1-1-2v-1l1-1h1v5h-1v-1zM485 192c1 1 1 1 2 1h1v-2 1c-1 0-1 1-1 1-1 0-1 0-1-1v-3h-1v3zM491 193h-1c0-1 0-1-1-1h1c0 1 0 1 1 1zM495 193h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1v1h1v5h-1v-1c-1 0-1-1-1-1v1c0 1 1 1 1 1zM500 193c1 0 1-1 1-1v-4c-1 0-1-1-1-1-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1zm-1-1v-4h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1zM539 188h1-1zM540 192h-1v1c1 0 1-1 1-1zM540 189l-1 1c1 0 1 0 1-1zM540 188zM539 190zM539 191v-1 1zM539 192zM123 201l1-1v-1c0-1 0-2-1-3h-2v1-1h1c1 0 1 0 1 1v3c0 1 0 1-1 1v1l1-1zM126 202l1-1s1 0 1-1v-1c0-1 0-2-1-3h-2v1s-1 1-1 2c0 0 1 1 1 2l1 1zm-1-5 1-1h1v5h-1c-1-1-1-1-1-2v-2zM130 201h2-1v-5h-2 1v5zM133 199v2c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2s0 1-1 1v2zm1-2v-1h1s1 0 1 1v3c0 1-1 1-1 1h-1v-4zM139 202l1-1s1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM146 202v-1c1 0 1 0 1-1v-4h-2s-1 0-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 2v1h-1v-4zM150 196h-1l-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v3zM154 202l1-1s1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 0-1 1-1 2 0 0 1 1 1 2l1 1zm-1-5 1-1h1v5h-2v-4zM159 196h-1c-1 0-1 0-1 1v4c1 0 1 1 1 1 1 0 1-1 1-1 1 0 1 0 1-1v-4h-1zm0 4v1h-1v-5h1v1l1 1c0 1-1 2-1 2zM163 201v-5h-1v1h1v3c0 1 0 1-1 1h2-1zM167 202l1-1s1 0 1-1v-2s0-1-1-2h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1zm-1-5s0-1 1-1h1v5h-2v-4zM172 201v-5h-2 1v5h-1 3-1zM175 196zM269 201v-6c-1 1-1 1-2 1h1v4l1 1zM273 195c-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1s1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1c-1 0-1 0-1-1v-4h1c1 1 1 1 1 2s0 2-1 2zM277 201v-6c0 1-1 1-1 1h1v5h-1 2-1zM281 195c0 1 0 1-1 1h1v5h-1 2v-6h-1zM286 195c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-1s-1-1-1-2c0 0 1 0 1-1v-1h1c0 1 1 1 1 2s-1 2-1 2zM292 195s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-4h1c1 0 1 0 1 1v3zM296 195s0 1-1 1v1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-1v-2l1-1h1v4zM301 201v-6c-1 1-1 1-2 1h1v5h2-1zM305 201v-6c0 1-1 1-1 1h1v4c0 1 0 1-1 1h2-1zM308 196h1-1zM322 201h1l1-1v-2c0-1 0-1-1-2l-1-1v1c1 0 1 0 1 1v4h-2 1zM329 201v-6c-1 1-1 1-2 1h1v5h-1 3-1zM356 197zM448 201v-1h1c-1 0-1 0-1 1h-1c-1 0-1 0-1 1h1l1-1zM451 202s1 0 1-1c0 0 1 0 1-1v-1h-1v2h-2v-1h-1s1 0 1 1l1 1zM455 201h-1v1h3v-1h-1v-3h-1v3zM459 196v6h2v-1h-1v-5h-1v1-1zM464 196h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-4l1-1h1v5zM467 197c1 0 1-1 1-1v5h-1v1h2v-6h-2v1zM475 196h-1s0 1-1 1v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-2v-5h1l1 1v4zM480 201v-5h-1s-1 0-1 1h1v4h-1v1h2v-1zM484 201v-5c-1 0-1 0-2 1h1v4s0 1-1 1h3c-1 0-1-1-1-1zM488 196h-1l-1 1v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-5h1s0 1 1 1v4zM492 196h-1v1c-1 1-1 1-1 2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c-1 0-1 1-1 1s0-1-1-1v-3c0-1 0-1 1-2 1 0 1 1 1 1v4zM497 201v-5c-1 0-1 0-2 1h1v4c0 1 0 1-1 1h2v-1zM501 201v-5c-1 0-1 0-1 1v5h2s-1 0-1-1zM505 201h-1v1h2v-1h-1v-3 3zM534 202zM534 202zM533 200v-1 2-1zM536 199c-1 0 0 0 0 1v-1zM123 210h-1v-6 1h-1 1v5h1zM126 210h-1 2v-6h-1s0 1-1 1h1v5zM131 210c1 0 1-1 1-1v-4l-1-1c-1 0-1 0-1 1-1 0-1 0-1 1v3c1 1 1 1 2 1zm-1-4v-1h1c1 1 1 1 1 2s0 2-1 2v1c-1 0-1 0-1-1v-3zM133 209c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1h-1c0 1-1 1-1 2v3zm1-3v-1c1 0 1-1 1-1v1h1v4l-1 1s-1 0-1-1v-3zM139 210h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1zm-1-4c0-1 0-1 1-1v-1s0 1 1 1v5h-1l-1-1v-3zM145 210h2-1v-6c-1 0-1 1-2 1h1v5zM150 204h-1c0 1 0 1-1 2v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-4c1 0 1-1 1-1v1h1v4zM154 210h1l1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1zm-1-4c0-1 1-1 1-1v-1l1 1v5h-1l-1-1v-3zM159 210v-6c-1 0-1 1-2 1h1v5h-1 3-1zM163 204l-1 1c1 0 1 0 1 1v2-4zM167 204l-1 1h2v-1h-1zm0 1zM171 204v1c0-1 0-1 1-1h-1zM270 206v1-1zM273 209v-5c-1 0-1 0-2 1h1v5h2-1v-1zM277 209v-5s-1 0-1 1h1v4c-1 0-1 0-1 1h2-1v-1zM281 204h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM285 204c-1 0-1 1-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5c0 1 0 1-1 1v-1c0-1-1-1-1-2l1-1v-2h1v1s1 1 1 2-1 1-1 2zM292 204s-1 0-1 1h1v4l-1 1h2c-1 0-1-1-1-1v-5zM296 204h-1v1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c0 1-1 1-1 1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM301 209v-5c-1 0-1 0-2 1h1v5h2-1v-1zM305 204h-1l-1 1v4h1v-4l1-1c0 1 1 1 1 1v3-1h1c0-1-1-2-1-2 0-1-1-1-1-1zM324 209v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v3-1c0-1 0-1 1-1v-1l1 1v5c0-1 0-1 1-1zM327 205h1v-1s0 1-1 1zM444 210h-1v-4c-1 0-1 1-1 1v1l1 1v1h1zM442 210zM447 204s-1 0-1 1l-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s0-1-1-2l-1-1zm1 5-1 1s-1 0-1-1v-4h2v4zM451 204l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1h1v4zM456 210v-6c-1 1-1 1-2 1h1v5h-1 3-1zM460 204s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-1-1-2l-1-1zm1 5-1 1c-1 0-1 0-1-1v-4h2v4zM464 204l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1h1v4zM468 204v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c1 0 1-1 1-1h1v4zM475 204s-1 0-1 1c0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c1 0 1-1 1-2s-1-1-1-2l-1-1zm1 5-1 1s-1 0-1-1v-4h2v4zM479 204l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3s0-1 1-1h1v4zM485 210h-1v-6c-1 1-1 1-2 1h1v5h-1 3zM488 210v-6c0 1-1 1-1 1v5h2-1zM492 204s0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3s0-1 1-1 1 0 1 1v3zM497 210v-6c-1 1-1 1-2 1h1v5h-1 2zM500 210h2-1v-6l-1 1v5zM505 210v-6c0 1-1 1-1 1h1v5h-1 2-1zM510 209c0 1 1 1 1 1v-1c-1 0-1 0-1-1v-1 2zM123 218h-1v1h1v-1zM122 213v5-5zM126 219s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-3h-2v1c-1 1-1 1-1 2s1 1 1 2l1 1zm-1-5s1 0 1-1h1v5h-1c-1-1-1-1-1-2v-2zM131 219v-1c1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1s1 1 1 2c0 0 0 1-1 2h-1v-4zM133 218c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-2l-1 1v4zm1-4v-1h1l1 1v4h-2v-4zM140 218v-5h-2v1c0-1 0-1 1-1v5h-1v1h2v-1zM146 219v-1c1 0 1 0 1-1v-4h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1v1c1 0 1 1 1 1 0 1 0 2-1 3h-1v-4zM150 213h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 5h-2v-5h1l1 1v4zM155 218v-5h-2v1c0-1 0-1 1-1v5h-1v1h2v-1zM159 218v-5h-2v1l1-1v5h-1v1h2v-1zM161 215v-1 1zM273 212c-1 1-1 1-2 1h1v2h1v1-4zM277 218v-6c0 1-1 1-1 1h1v5h-1 2-1zM281 212s0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1s1 0 1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-2v-4s0-1 1-1h1v4zM285 213c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1 0 1-1v-4h-2zm1 4v1h-1c0-1-1-2-1-2 0-1 0-1 1-2v-1h1v1l1 1c0 1-1 2-1 2zM292 213h-1l-1 1v2s0 1 1 1c0 1 0 1 1 1h1v-1c1 0 1-1 1-2s0-1-1-2h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 0 1 1v3zM297 218v-5h-2 1v5h-1 2zM301 213h-1c-1 0-1 0-1 1v3h1v-4h1v1h1v-1h-1zM444 219c-1 0-1 0-1-1v-5h-1v6h2zM447 218v-5s-1 0-1 1h1v4h-1v1h2l-1-1zM452 218v-5h-1s-1 0-1 1h1v4c0 1-1 1-1 1h2v-1zM456 218v-5c-1 0-1 0-2 1h1v4c0 1 0 1-1 1h3c-1 0-1 0-1-1zM460 218v-5s-1 0-1 1v5h2-1v-1zM464 213h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM469 218v-5c-1 0-1 0-2 1h1v5h-1 2v-1zM475 213h-1l-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1l1 1v4zM480 218v-5h-1s-1 0-1 1h1v5h-1 2v-1zM483 218v1h-1 3-1v-6c-1 0-1 0-2 1h1v4zM488 218v-5s-1 0-1 1v5h2-1v-1zM492 218v-5s-1 0-1 1h1v5h-1 2s0-1-1-1zM497 218v-5c-1 0-1 0-2 1h1v5h-1 2v-1zM501 213h-1c0 1-1 1-1 1v4c1 1 1 1 2 1h1v-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2v2zM505 218v-5s-1 0-1 1h1v4c0 1 0 1-1 1h2c-1 0-1 0-1-1zM510 214zM123 222v1c1 0 1 1 1 1v2-2c0-1 0-1-1-2zM126 227h-1 2v-6h-1c0 1 0 1-1 1h1v5zM130 227h2-1v-6c-1 1-1 1-2 1h1v5zM134 227h2-1v-6c0 1-1 1-1 1 1 0 1 1 1 1v3s0 1-1 1zM139 227h-1 2v-6h-1c0 1-1 1-1 1h1v5zM145 227h2-1v-6c-1 1-1 1-2 1h1v5zM150 221s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2s0-1-1-2l-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-4h2v4zM155 227v-6h-1c0 1 0 1-1 1h1v5h-1 2zM157 223v-1h1c-1 0-1 0-1 1zM278 227h-1v-6s-1 0-1 1h1v4l-1 1h2zM282 226v-5h-1l-1 1h1v5h-1 2v-1zM287 227h-1v-6c-1 0-1 1-2 1h1v5h-1 3zM292 221h-1c0 1 0 1-1 1v2c0 1 0 1 1 2v-4l1-1 1 1v3c0-1 1-1 1-1 0-1 0-2-1-2 0-1-1-1-1-1zM295 222h1s0-1 1-1h-1s0 1-1 1zM442 226v1h2-1v-6c0 1 0 1-1 1v4zM447 227v-6c0 1-1 1-1 1h1v5h-1 2-1zM453 224c0-1 0-1-1-2 0 0 0-1-1-1 0 0 0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2v1-4s0-1 1-1h1v5l1-1v-2zM457 222c-1 0-1-1-2-1v1c-1 0-1 0-1 1v4h1v-1l-1-1c0-1 0-1 1-2v-1h1v1l1 1-1 1h1v-3zM460 221l-1 1s-1 0-1 1v1h1v-2h1s1 0 1 1h1c-1 0-1-1-1-1l-1-1zM464 221c0 1-1 1-1 1h1v1-2zM468 222h-1 2s0-1-1-1v1zM476 227v-1c1 0 1-1 1-2s-1-1-1-2h-2s-1 0-1 1v1c1 0 1 0 0 0v1c1 0 1 1 1 2h2zm-2 0v-5h1s1 0 1 1v3c0 1-1 1-1 1h-1zM479 227h-1 2v-2h-1v2zM479 222h-1 1v3h1v-3h-1zM483 222c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1 0 1-1v-4h-2zm1 4v1h-1c0-1-1-2-1-2 0-1 0-1 1-2v-1h1v4zM488 227v-5h-1v5h2-1zM492 227v-5h-1 1v5h-1 2-1zM497 227v-5h-2 1v5h-1 2zM501 222h-1v5h1v-5zM505 222h-1 1v2-2zM536 227zM126 236h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s1 1 1 2 1 1 1 1zm-1-4c0-1 1-1 1-2h1v5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1zM131 236c1-1 1-1 1-2v-3l-1-1h-1c-1 0-1 1-1 1v4c1 1 1 1 2 1zm-1-4v-2h1v1s1 1 1 2 0 1-1 2v1c-1 0-1-1-1-1v-3zM133 235c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1h-1l-1 1v4zm1-3v-2h1l1 1v4h-1v1l-1-1v-3zM139 236s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1zm-1-4c0-1 0-1 1-2h1v5c-1 0-1 1-1 1s0-1-1-1v-3zM146 236v-1c1 0 1 0 1-1v-3l-1-1h-1l-1 1v4c1 0 1 1 2 1zm-1-4v-2h1v1c1 0 1 1 1 2 0 0 0 1-1 2v1c-1 0-1-1-1-1v-3zM150 235h-1v1l1-1v-4 4zM149 231v-1 1zM479 232v2s0 1 1 1v-3h-1zM479 230v1h1v-1h-1zM483 230l-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2h1v5zM488 235v-5l-1 1v5h2-1v-1zM492 230l-1 1h1v4-5zM496 230l-1 1v3-2l1-1v-1c1 0 1 0 1 1h1c-1-1-1-1-2-1zM532 236h2-1v-2 2h-1zM538 236c0-1 0-1 1-1v-2h-1v3zM537 231h-1 1zM535 233c0 1 1 2 1 2v1h1v-1c-1 0-1-1-1-2v-2 1l-1 1zM537 230zM126 238c0 1 0 1-1 1h1v5h-1 2c-1 0-1-1 0-1h-1s0-1 1 0v-5h-1zM132 244h-1v-6c-1 1-1 1-2 1h1v5h2zM134 244h2-1v-6c0 1-1 1-1 1l1 1v3c0 1 0 1-1 1zM139 238s0 1-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1h-1v1h-1l-1-1v-3s0-1 1-1h1v2h1c0-1 0-1-1-2 0 0 0-1-1-1zM483 245c1 0 1-1 1-1 1 0 1 0 1-1v-2c0-1 0-1-1-1v4h-1c0-1 0-1-1-1v1l1 1zM488 243v-3 1h-1v2h1zM520 245s1 0 1-1l1-1h-1c0 1 0 1-1 1h-1l1 1zM523 244h1c-1-1-1-1-1-2v-1 3zM525 243c1 0 1 0 1-1v-2h-1v3zM529 239zM528 240v1s0-1 1-1v-1 1h-1c1 0 1-1 1-1h-1v1zM532 240v-1h1-1v1zM128 252v-4c-1 0-1 0-1-1 0 1 0 1-1 1h1v5-1h1zM132 247h-1c0 1-1 1-1 1v4c1 1 1 1 2 1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM136 252v-5s-1 0-1 1h1v4c0 1-1 1-1 1h2c-1 0-1-1-1-1zM140 247l-1 1h1v1h1v-2h-1zM140 253h-1 2l-1-1v1zM509 251zM512 248h-1c1 0 1 0 0 0v2h1v-2zM515 247c-1 0-1 0-1 1 0 0-1 0-1 1v1h1v-2h1l1 1v-1c0-1-1-1-1-1zM132 260v-4h-2c-1 0-1 0-1 1s0 1 1 2v-3h1v1l1 1c0 1 0 2-1 2v1c1 0 1 0 1-1zM135 261v-5h-1v1h1v3c0 1 0 1-1 1h2-1zM140 256h-2v1c-1 0-1 1-1 2 0 0 0 1 1 2h2v-1c0-1 0-1 1-1v-1s0-1-1-2zm0 4v1h-2v-4s0-1 1-1h1v4zM155 261h-1s-1 0 0 0h1zM355 256c0-1 0-1-1-1v1h-1 3-1zM502 258zM135 264c-1 0-1 1-1 1h1v-1zM141 265h-1 1zM139 265h-1c0 1 0 1-1 1h1c0-1 0-1 1-1zM139 265v-1l1 1v-1h-2v1c1-1 1-1 1 0zM141 266h-1v-1 3h1v-2zM137 267c1 0 1 0 1-1h-1v1zM145 269c1 0 1 0 1 1v-4h-1v3zM150 268zM191 265zM193 266h1v-1l-1 1zM164 287h-1v-1s-1 1 0 1h-1 2zM163 286zM168 284v-1h-1v2l1-1zM167 286zM166 287h2-2zM170 283v-1h1-1v1zM170 284zM319 287h-1 1zM322 287h-1 2l-1-1v1zM383 287zM386 287h2-1v-1h-1v1zM401 287zM424 287h-2 2zM427 287h1c1 0 1-1 1-1v-1 1l-1 1h-1zM163 292v2-2zM163 290h-1c1 0 1 0 1 1v-1zM163 292v-1 1zM168 291zM166 295l1 1s1 0 1-1l1-1v-2h-1v3h-2v-4c-1 1-1 1-1 2 0 0 0 1 1 2zM168 291zM172 294zM170 295l1 1c1 0 1 0 1-1h1-2c0-1-1-1-1-2v-1 3zM255 295h-1 2-1zM259 295h2-1v-1h-1v1zM263 295h2-1v-1 1h-1zM268 295h1s1 0 1-1h-1v1h-1l-1-1c0 1 1 1 1 1zM273 295c1 0 1 0 1-1h-1v1h-1v-1h-1c1 1 1 1 2 1zM277 295h1v-1c0 1-1 1-1 1h-1v-1h-1c1 1 1 1 2 1zM281 295h-1 2v-1h-1v1zM285 295h1c1 0 1 0 1-1v-1h-1v2h-1v-1h-1c0 1 1 1 1 1zM292 295h1v-1c1 0 1-1 1-2v-1h-1v3c0 1 0 1-1 1h-1v-2h-1c0 1 0 1 1 1 0 1 0 1 1 1zM296 295h-1 2v-2c-1 0-1 0-1-1 0 0 0 1 1 1v-1h-1v3zM301 295c1 0 1 0 1-1v-3 1c0 1 0 2-1 2v1h-1v-2h-1v2h2zM305 294c0 1 0 1-1 1h2-1v-5 4zM308 290h1v5h-1 2v-5h-2zM313 296c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 0-1 1v4l1 1zm0-5v-1h1v5h-1c0-1-1-2-1-2 0-1 0-1 1-2zM318 295v-5h-1v5h2-1zM322 295v-5h-1 1v5h-1 2-1zM328 290v5h-1 3-1v-5h-2 1zM333 295v-5h-1v1h1v3c0 1-1 1-1 1h2-1zM336 291c-1 0-1 1-1 2 0 0 0 1 1 2h1-1v-4s0-1 1-1h1v3c0-1 1-1 1-1s0-1-1-2h-2v1zM338 293h1-1zM340 292zM341 296c1 0 1-1 1-1 1 0 1 0 1-1v-1s0 1-1 1v1h-2c1 0 1 1 1 1zM340 291h1l-1-1v1zM346 296s0-1 1-1v-1l1-1v-1l-1 1v1l-1 1h-1v-2h-1v2c1 0 1 1 2 1zM350 295h-1 2-1v-3 3zM353 291v4l1 1c1 0 1-1 1-1s1 0 1-1v-4h-3v1zm1-1h1v5h-1c-1-1-1-1-1-2v-2c1 0 1-1 1-1zM359 295v-5h-1v6h2v-1h-1zM366 295h-1v-5h-1v1-1h1v5h-1v1h2v-1zM369 296c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2c-1 0-1 1-1 1v4l1 1zm-1-5c1 0 1-1 1-1h1v5h-1c-1-1-1-1-1-2v-2zM374 290h-1l-1 1v4c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-3h-1zm1 4-1 1h-1v-5h1s0 1 1 1v3zM378 290h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-4l1-1c1 0 1 1 1 1v4zM382 290v5h-1v1h2v-6h-2v1c0-1 1-1 1-1zM388 293v-3h-2l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-1zm-1 2h-1v-5h1v1c1 0 1 1 1 1 0 1 0 2-1 3zM390 290v1h1v4h-1v1h2v-1h-1v-5h-1v1-1zM396 295v-5h-2v1c0-1 0-1 1-1v5h-1v1h2v-1zM402 296l1-1v-1l1-1c0-1-1-2-1-3h-2l-1 1v4c1 0 1 1 2 1zm-1-5v-1h1s0 1 1 1v4h-2v-4zM406 295v-5h-1v1-1l1 1v4h-1v1h2v-1h-1zM412 293c0-1 0-2-1-3h-1c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1zm-1 2h-1c-1-1-1-1-1-2v-2s1 0 1-1h1v5zM415 290h-1l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-4h-1zm0 5h-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM419 296l1-1v-1c1 0 1-1 1-1 0-1 0-2-1-2 0-1-1-1-1-1h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1zm-1-5v-1h1l1 1v4h-2v-4zM423 290h-1v1c-1 1-1 1-1 2s1 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5h-2v-4s1 0 1-1h1v5zM427 291v4s0 1-1 1h3c-1 0-1-1-1-1v-5c-1 0-1 0-2 1h1zM432 295v-5s-1 0-1 1c0 0 1 0 1 1v3h-1v1h2l-1-1zM438 290c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5-1 1v-1c-1-1-1-1-1-2v-1c0-1 1-1 1-2h1v5zM443 290c-1 0-1 0-2 1h1v5h2c-1 0-1 0-1-1v-5zM446 291h-1 1zM445 295c1 0 1 1 2 1h1v-2c1 0 1-1 1-1 0-1 0-1-1-2v4h-1v1l-1-1v-3h-1v3zM450 291zM450 295c0 1 1 1 1 1h1c0-1 1-1 1-1v-3h-1v3c-1 0-1 1-1 1s0-1-1-1v-3h-1v1c0 1 0 1 1 2zM454 295c0 1 1 1 1 1h1l1-1v-1c0 1-1 1-1 0v1c0 1 0 1-1 1v-2h-1v-1 2zM459 295v1h2-1v-1h-1zM464 296h-1 1zM78 303l-1 1h1v-1zM83 303v-1h-1v2h-1 1l1-1zM80 303h-1 1v1-1zM80 304h1-1zM85 304h-1 2v-2h-1v2zM89 304h2-1v-3h-1v3zM93 303c0 1 0 1 1 1h1l1-1v-2h-1v2c0 1 0 1-1 1 0 0-1 0-1-1v-2h-1c0 1 0 2 1 2zM98 304h-1 2v-3h-1v3zM101 303c1 1 1 1 2 1s1-1 1-1v-2c0 1 0 2-1 2v1c-1 0-1 0-1-1v-2h-1v2zM109 304h-1 2-1v-3 3zM112 303c0 1 1 1 1 1h1l1-1v-2h-1v3h-1v-1c-1 0-1-1-1-1v-1h-1c0 1 1 2 1 2zM112 300zM116 300s0 1 1 1v-1h-1zM116 303c1 1 1 1 2 1s1-1 1-1v-2c0 1 0 2-1 2v1c-1 0-1 0-1-1v-2h-1v2zM122 304h-1 2-1v-2 2zM127 299v1h1l-1-1zM125 299h1-1zM126 304h1l1-1v-1h-1v2h-1v-1c-1 0-1-1-1-1h-1l1 1c0 1 1 1 1 1zM127 298h-1c0 1 0 1-1 1h2v-1zM131 304c1 0 1-1 1-1v-4h-1c0 1 1 1 1 2v1l-1 1v1c-1 0-1 0-1-1v-1h-1v1c1 1 1 1 2 1zM130 299l1-1h-1v1h-1 1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M130 299c0 1-1 1-1 1v1h1v-2zM134 299c1 0 1 1 1 1v3c0 1 0 1-1 1h2-1v-5h-1zM138 300c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2v5h-1l-1-1v-3c0-1 0-1 1-1h-1v1zM145 299v5h2-1v-5h-2 1zM148 301c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2v-1h-1v3s0 1-1 1c0 0-1 0-1-1v-3c0-1 0-1-1-1v2zM153 300c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-4h-1v5h-1l-1-1v-3c0-1 1-1 1-1h-1v1zM157 301v2c0 1 1 1 1 1h2c-1 0-1 0-1-1v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1h-1c1-1 0-1 0-1v2z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M159 303s1 0 0 0h1v-4h-1c0 1 1 1 1 2s-1 2-1 2zM164 301v2l-1 1h1v-1c1-1 1-1 1-2s-1-1-1-2h-1 1v2zM161 301v2c1 0 1 0 1 1v-5h-1v2zM169 303v-2c0-1 0-2-1-2 0 0 0-1-1-1l-1 1v1c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1zm-2 1-1-1v-3c0-1 0-1 1-1h1v5h-1zM172 298c-1 0-1 1-2 1h1v4h1v-5zM177 300v-1h-1 1v1zM177 301zM174 300v3h1v-1h-1 1v-3s-1 0-1 1zM177 300zM175 299h2l-1-1c-1 0-1 0-1 1zM220 304h-2 2zM223 304h1v-1 1h-1l-1-1c0 1 1 1 1 1zM227 304h1c1 0 1-1 1-1h-1v1h-1v-1h-1c0 1 1 1 1 1zM231 304h2-1v-3h-1v3zM232 299h-1v1h1v-1zM236 304v-6l-1 1h1v5h-1 2-1zM241 304v-6c-1 0-1 1-2 1h1v5h-1 2zM245 304v-6c-1 0-1 1-2 1h1v5h2-1zM249 303v-5l-1 1h1v5h-1 2-1v-1zM255 298l-1 1v4c0 1 1 1 1 1h1c0-1 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1l1-1v-1h1v5zM260 298h-1c0 1-1 1-1 1v4c1 1 1 1 2 1l1-1c0-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm0 5v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1c1 1 1 1 1 2s0 1-1 2zM266 301c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1c0-1 0-1 1-1v-2zm-1 2-1 1s-1 0-1-1v-4l1-1 1 1v4zM270 301c0-1 0-2-1-2 0-1 0-1-1-1l-1 1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2zm-1 2c0 1-1 1-1 1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1v-1h1v5zM273 303v-5c-1 0-1 0-2 1h1v5h2-1v-1zM277 298h-1c0 1 0 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1zm1 5s-1 0-1 1c0 0-1 0-1-1v-4l1-1c0 1 1 1 1 1v4zM281 298h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5v1h-1l-1-1v-3c0-1 0-1 1-1v-1h1v5zM285 298l-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2h1v1c0 1 1 1 1 2s-1 1-1 2zM294 301c0-1 0-2-1-2 0-1-1-1-1-1h-1c0 1 0 1-1 1v2c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2zm-1 2-1 1s-1 0-1-1v-4l1-1v1h1v4zM297 304v-6h-1s0 1-1 1h1v5h-1 2zM302 301v-2l-1-1h-1l-1 1v4c1 1 1 1 2 1s1-1 1-1v-2zm-1 2v1c-1 0-1 0-1-1v-4c0-1 0-1 1-1v1c0 1 1 1 1 2s0 1-1 2zM305 304v-6l-1 1c1 0 1 0 1 1v3l-1 1h2-1zM310 304v-6h-1l-1 1h1v5h-1 2zM315 301v-2c-1-1-1-1-2-1l-1 1v4c0 1 1 1 1 1h1c1 0 1-1 1-1v-2zm-1 2v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2c1 0 1 0 1 1v4zM318 304v-6l-1 1v5h2-1zM322 304v-6l-1 1h1v5h-1 2-1zM330 301v-2l-1-1h-1l-1 1v4c0 1 1 1 1 1h1c1 0 1-1 1-1v-2zm-1 2v1c-1 0-1 0-1-1 0 0-1-1-1-2l1-1v-1s0-1 1-1v1c0 1 1 1 1 2s-1 1-1 2zM333 304v-6l-1 1 1 1v3l-1 1h2-1zM339 301c0-1 0-2-1-2 0-1 0-1-1-1h-1v2c-1 0-1 1-1 1 0 1 0 2 1 2 0 1 1 1 1 1h1s0-1 1-1v-2zm-1 2v1h-1l-1-1v-3c0-1 0-1 1-1v-1s0 1 1 1v4zM341 298c-1 1-1 1-1 2v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1-1-1-1-2-1zm1 5v1h-1v-1s-1-1-1-2c0 0 0-1 1-1v-2c1 0 1 1 1 1v4zM346 304v-6l-1 1v5h2-1zM350 304v-6l-1 1h1v5h-1 2-1zM355 304v-6c-1 0-1 1-2 1h1v5h-1 2zM359 304v-6c-1 0-1 1-1 1v5h2-1zM366 304c-1 0-1-1-1-1v-5l-1 1h1v5h-1 2zM371 301v-2c-1 0-1-1-2-1v1c-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-2zm-1 2v1h-1v-1c-1 0-1-1-1-2v-1l1-1h1v4zM374 304v-6l-1 1v5h2-1zM378 298s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1s0-1 1-1v-2c0-1 0-1-1-2l-1-1zm1 5s0 1-1 1c0 0-1 0-1-1v-3c0-1 0-1 1-1h1v4zM382 298v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-4c-1 0-1-1-2-1zm1 5v1h-1v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1h1v4zM387 304v-6c-1 1-1 1-2 1h1v5h2-1zM393 301c0-1 0-1-1-2l-1-1s-1 0-1 1l-1 1v1c0 1 0 2 1 2 0 1 0 1 1 1h1v-1c1-1 1-1 1-2zm-1 2s0 1-1 1c0 0-1 0-1-1v-4h2v4zM396 304v-6h-1c0 1 0 1-1 1h1v5h-1 2zM404 301c0-1-1-1-1-2l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v3c1 1 1 1 2 1h1v-1c0-1 1-1 1-2zm-1 2c-1 0-1 1-1 1-1 0-1 0-1-1v-4h2v4zM406 304v-6c0 1-1 1-1 1h1v5h-1 2-1zM411 304v-6c-1 1-1 1-2 1h1v5h-1 2zM415 304v-6c-1 1-1 1-2 1h1v5h2-1zM419 304v-6c0 1-1 1-1 1h1v5h-1 2-1zM423 298l-1 1v1c-1 0-1 1-1 1 0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1l-1-1v-3l1-1h1v4zM428 298c-1 0-1 0-1 1-1 0-1 0-1 1v3c0 1 1 1 1 1h1c1 0 1-1 1-1v-4c-1 0-1-1-1-1zm0 5v1h-1v-1l-1-1c0-1 1-1 1-2v-1h1v1s1 0 1 1-1 2-1 2zM432 304v-6c0 1-1 1-1 1l1 1v3c0 1-1 1-1 1h2-1zM438 298v1c-1 0-1 0-1 1l-1 1c0 1 1 2 1 2 0 1 1 1 1 1h1l1-1v-2c0-1 0-1-1-2 0 0 0-1-1-1zm1 5v1h-1v-1c-1 0-1-1-1-1v-2l1-1h1v4zM444 299c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v4c1 0 1 0 1-1h-1 1v-4h1v1c1 0 1 1 1 1v2-4zM447 298c0 1-1 1-1 1h1v2-3zM451 298c0 1-1 1-1 1h1v1h1v-2h-1zM456 298c-1 1-1 1-2 1h2v-1zM76 307zM80 307h-1v1l1-1c0 1 1 1 1 1 0-1-1-1-1-1zM85 307c-1 0-1 0-2 1h2v-1zM84 310v1h1v-1h-1zM90 311s-1 0-1 1h1v-1zM87 310v1l1 1v-2h-1zM89 307h-1l-1 1s0 1 1 1v-1c0-1 0-1 1-1v1l1 1v-1l-1-1zM94 313v-1c1-1 1-1 1-2s0-2-1-2c0-1-1-1-1-1h-1c0 1 0 1-1 1v1h1v-1l1-1c0 1 1 1 1 1v4h-1v1l-1-1v-1h-1s0 1 1 1v1h2zM98 312v-5h-1l-1 1h1v5h-1 2v-1zM102 312v-5c-1 0-1 0-2 1h1v5h-1 3-1v-1zM108 312v-5s-1 0-1 1h1v4s0 1-1 1h2c-1 0-1-1-1-1zM112 307h-1v1c0 1-1 1-1 2s1 1 1 2 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c0 1-1 1-1 1v-1c-1-1-1-1-1-2v-1c0-1 1-1 1-2h1v5zM117 307h-1c-1 0-1 1-1 1v4c1 1 1 1 2 1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2s0 1-1 2zM121 307h-1s0 1-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-1 1-2s-1-2-1-2c0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1l1 1v4zM125 307h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM129 307c-1 0-1 1-1 1v4c0 1 1 1 1 1h1l1-1v-4c-1-1-1-1-2-1zm1 5c0 1 0 1-1 1v-1c0-1-1-1-1-2 0 0 0-1 1-1v-2h1v5zM134 307h-1l-1 1v4c1 1 1 1 2 1h1v-1c1-1 1-2 1-2 0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-1v1c-1 0-1-1-1-1v-5h1s0 1 1 1v4zM138 307h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 0-1 1-2v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c-1 0-1 1-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM145 307h-1c-1 0-1 1-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1s1 1 1 2c0 0-1 1-1 2zM149 312v-5s-1 0-1 1c1 0 1 0 1 1v3h-1v1h2l-1-1zM154 312v-5h-1s-1 0-1 1h1v4c0 1-1 1-1 1h2v-1zM156 308v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-3c-1-1-1-1-2-1s-1 1-1 1zm1-1h1v5s0 1-1 1v-1c0-1-1-1-1-2s0-1 1-2v-1zM161 307h2-2zM160 310v2c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-2v4h-1v1c-1 0-1-1-1-1v-4h-1v2zM166 312c-1 0-1 0-1 1h2v-1h-1v-3 3zM166 309v-1 1zM170 312h-1v1h2v-3h-1v2zM175 313v-1c1 0 1 0 1-1v-1c0 1 0 1-1 2h-1v-2h-1v2c1 0 1 1 2 1zM181 312h-1v1h2v-1h-1v-1 1zM185 313c1 0 1 0 1-1h1-2v-1h-1v1l1 1zM189 312v1h1v-1h-1zM194 312h-1v1h2v-1h-1zM198 312h-1v1h2v-2h-1v1zM203 313v-1c1 0 1 0 1-1-1 0-1 0-1 1h-1v-1h-1v1c1 0 1 1 2 1zM207 313l1-1v-1h1-1v1h-2v-1h-1c0 1 0 1 1 1 0 0 0 1 1 1zM211 307s0 1 1 1v-1h-1zM211 312h-1v1h2v-3h-1v2zM218 313l1-1v-1l1-1h-1v1l-1 1h-1v-2h-1v2c1 0 1 1 2 1zM218 307h-1l-1 1h1v-1h1v1h1v-1h-1zM219 308v1-1zM222 312v-5h-1v1-1h1v5h-1v1h2v-1h-1zM226 307c-1 0-1 1-1 1s-1 1-1 2c0 0 1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-1c-1-1-1-1-1-2v-2l1-1h1v4zM231 312v-5h-2 1v6h2v-1h-1zM235 307h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1s1 0 1 1v3zM239 307h-1v1c-1 0-1 1-1 2 0 0 1 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4l1-1h1v4zM244 312v-5h-2 1v5h-1 3-1zM248 307h-1l-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM254 307c-1 0-1 0-1 1 0 0-1 1-1 2 0 0 1 1 1 2l1 1c1 0 1-1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-1c-1-1-1-1-1-2v-2l1-1h1v4zM259 312v-5h-2 1v5h2-1zM263 312v-5h-1s1 0 1 1v4h-1 2-1zM267 307h-1v1c-1 0-1 1-1 2 0 0 1 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1h1v4zM272 307h-1c-1 0-1 0-1 1v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-1zm0 4v1h-1c0-1-1-2-1-2 0-1 1-1 1-2v-1h1v1l1 1c0 1-1 2-1 2zM276 307h-1s-1 0-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM281 312c-1 0-1 0-1-1v-4h-1 1v5h-1 2zM285 312v-5h-2 1v5h-1 3-1zM291 307h-1l-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1s1 0 1 1v3zM295 307h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1 1-1s1 0 1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1h1v4zM299 307c-1 0-1 1-1 1v4l1 1c1 0 1-1 1-1 1 0 1 0 1-1v-4h-2zm1 4v1h-1c0-1-1-1-1-2s0-1 1-2v-1h1v4zM304 307h-1l-1 1v4c1 0 1 1 2 1 0 0 0-1 1-1v-1c1 0 1-1 1-1 0-1-1-2-1-3h-1zm1 4c0 1-1 1-1 1h-1v-5h1l1 1v3zM308 307h-1v1c-1 0-1 1-1 2 0 0 0 1 1 2l1 1s1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 4v1h-2v-4s0-1 1-1h1v4zM313 312v-5h-2v1c0-1 1-1 1-1v5h-1v1h2v-1zM317 307h-1l-1 1v4c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-3h-1zm1 4-1 1h-1v-5h1l1 1v3zM321 307h-1s0 1-1 1v2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 4c0 1 0 1-1 1h-1v-5h1c1 0 1 1 1 1v3zM327 307c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 1 0 1 0 1-1v-4h-2zm1 5h-1c0-1-1-1-1-2s0-1 1-2v-1h1v5zM332 307h-1l-1 1v4c1 0 1 1 2 1l1-1v-1l1-1c0-1-1-2-1-3h-1zm1 5h-2v-5h1s0 1 1 1v4zM336 307h-1v1c-1 1-1 1-1 2s0 1 1 2c0 0 0 1 1 1 0 0 1 0 1-1l1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-4l1-1c1 0 1 1 1 1v4zM340 307c-1 0-1 1-1 1v4l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-4h-2zm1 5h-1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h1v5zM345 312v-5h-1v1-1 6h2v-1h-1zM349 307h-1s0 1-1 1v2c0 1 0 1 1 2 0 0 0 1 1 1l1-1 1-1v-1c0-1 0-2-1-3h-1zm1 5h-2v-5h1c1 0 1 1 1 1v4zM354 312v-5h-2v1l1-1v5h-1v1h2v-1zM358 312v-5h-2v1c1 0 1-1 1-1v6h2v-1h-1zM364 312v-5h-1v1-1l1 1v4h-1v1h2v-1h-1zM368 307c-1 0-1 1-1 1 0 1-1 1-1 2s1 1 1 2l1 1c1 0 1 0 1-1 0 0 1 0 1-1v-3c-1-1-1-1-2-1zm1 5h-1c-1-1-1-1-1-2v-2s1 0 1-1h1v5zM373 307h-1l-1 1v4c1 0 1 1 2 1v-1c1 0 1 0 1-1v-3l-1-1zm0 5h-1v-5h1v1c1 0 1 1 1 2 0 0 0 1-1 2zM377 312v-5s-1 0-1 1h1v4h-1v1h2v-1h-1zM382 312v-5h-1l-1 1h1v4l-1 1h2v-1zM386 312v-5c-1 0-1 0-2 1h1v5h2c-1 0-1 0-1-1zM390 307h-1l-1 1v4c1 0 1 1 2 1l1-1v-1c1 0 1-1 1-1 0-1-1-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1l1 1v4zM394 307h-1v1c-1 1-1 1-1 2s0 1 1 2l1 1s1 0 1-1c0 0 1 0 1-1v-1c0-1 0-2-1-2 0-1 0-1-1-1zm1 5c-1 0-1 1-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM401 307h-1l-1 1v4c1 0 1 1 2 1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1v-5h1v1c1 0 1 1 1 2s0 1-1 2zM405 307h-1s0 1-1 1v2c0 1 0 1 1 2 0 1 0 1 1 1h1v-1c1-1 1-2 1-2 0-1 0-2-1-2 0-1-1-1-1-1zm1 5h-1v1l-1-1v-5h1l1 1v4zM410 312v-5h-1l-1 1h1v5h-1 2v-1zM414 307h-1c-1 0-1 1-1 1v4c0 1 1 1 1 1h1l1-1v-4l-1-1zm0 5v1c-1 0-1-1-1-1 0-1-1-1-1-2l1-1v-2h1v1s1 1 1 2-1 1-1 2zM418 312v-5s-1 0-1 1c0 0 1 0 1 1v3h-1v1h2-1v-1zM422 307h-1v1c-1 1-1 1-1 2s0 1 1 2c0 1 1 1 1 1h1c0-1 0-1 1-1v-2c0-1 0-2-1-2 0-1 0-1-1-1zm1 5-1 1s0-1-1-1v-3c0-1 0-1 1-2h1v5zM426 313h1v-1c0 1 0 1-1 1v-1s0-1-1-1v1c0 1 1 1 1 1zM426 307c-1 0-1 1-1 1v3-2h1v-2h1v2h1v-1c-1-1-1-1-2-1zM428 309h-1 1z"
          />
          <path
            className="CyberEl83_svg__fil1"
            d="M428 309h-1v1c1 0 1 0 1-1zM431 307h-1l-1 1h1c0-1 1-1 1-1v1h1c0-1-1-1-1-1zM85 316h-1 2v1h1v-1h-2zM90 316h-1v2h1v-2zM94 316h-1 1v3-3zM99 316h-1c-1 0-1 0-1 1 0 0-1 1-1 2h1v-2l1-1h1v3h1v-1s0-1-1-2zM103 316h-2 1v3h1v-3zM110 316h-2l-1 1v2h1v-2s0-1 1-1 1 0 1 1v2h1v-1c0-1 0-1-1-2zM114 316h-2 1v3h1v-3zM118 316h-2 1v3h1v-3zM123 316l-1-1-1 1-1 1v2h1v-3h1c1 0 1 0 1 1v2h1v-1c0-1 0-1-1-2zM127 316s0-1-1-1c0 0 0 1-1 1v1c-1 0-1 1-1 1v1h1v-2l1-1h1v3h1v-1c0-1 0-1-1-2zM131 315c-1 1-1 1-2 1h1v3h1v-4zM135 315c0 1-1 1-1 1l1 1v2-4zM139 315c0 1-1 1-1 1h1v3h1v-4h-1zM147 316c-1 0-1-1-1-1-1 0-1 1-1 1s-1 0-1 1v2h1v-3h1v1c1 0 1 1 1 1v1-3zM151 316l-1-1-1 1-1 1v2h1v-3h1s1 0 1 1v2h1v-1c0-1 0-1-1-2zM155 316s0-1-1-1c0 0 0 1-1 1v1c-1 0-1 1-1 1v1h1v-2l1-1h1v3h1v-1c0-1 0-1-1-2zM160 316c-1 0-1-1-1-1-1 0-1 1-1 1-1 0-1 0-1 1v2h1-1c0-1 1-1 1-2v-1h1v1s1 0 1 1v1-3zM164 316l-1-1s-1 0-1 1c0 0-1 0-1 1v2h1v-3h1s1 0 1 1v2h1v-1c0-1-1-1-1-2zM167 315c0 1-1 1-1 1h1v3h1v-4h-1zM173 316c-1 0-1-1-2-1v1c-1 0-1 0-1 1v2-1l1-1v-1h1v3h1v-3zM176 315c0 1-1 1-1 1v3h1v-4zM183 316s0-1-1-1l-1 1v1c-1 0-1 1-1 1v1h1v-2c0-1 0-1 1-1h1v3h1v-1c0-1 0-1-1-2zM188 316c-1 0-1-1-1-1-1 0-1 0-1 1-1 0-1 0-1 1v2-1l1-1v-1h1c0 1 1 1 1 2v1-3zM191 315c0 1-1 1-1 1v3h1v-4zM196 316s0-1-1-1l-1 1v1c-1 0-1 1-1 1v1h1v-2c0-1 0-1 1-1h1v3h1v-1c0-1 0-1-1-2zM201 316c-1 0-1-1-2-1v1c-1 0-1 0-1 1v2-2l1-1h1v3h1v-3zM205 316l-1-1c-1 0-1 0-1 1 0 0-1 0-1 1v2h1v-3h2v3h1v-1c0-1-1-1-1-2zM208 315c0 1-1 1-1 1h1v3-4zM213 315c-1 1-1 1-2 1h1v3h1v-4zM219 315l-1 1v3h1v-4zM223 315l-1 1h1v3-4zM229 316c-1-1-1-1-2-1v1c-1 0-1 0-1 1v2-2l1-1h1v3h1v-3zM232 315c-1 0-1 1-1 1v3h1v-4zM237 316c0-1-1-1-1-1s-1 0-1 1l-1 1v2h1v-3h2v3h1v-1c0-1 0-2-1-2zM241 316c0-1 0-1-1-1-1 1-1 1-1 2l-1 1v1h1v-2c0-1 1-1 1-1h1v3h1v-1c0-1 0-2-1-2zM245 315c-1 0-1 1-2 1h1v3h1v-4zM250 316c0-1-1-1-1-1h-1c0 1 0 1-1 2v2h1v-3c1 0 1-1 1-1v1h1v3h1v-1c0-1 0-2-1-2zM256 315c-1 0-1 1-2 1h1v3h1v-4zM261 316c0-1-1-1-1-1h-1c0 1-1 1-1 2v2h1v-3s0-1 1-1v1c1 1 1 1 1 2v1l1-1c0-1-1-2-1-2zM265 316c0-1-1-1-1-1h-1c0 1 0 1-1 1v3h1v-3c1 0 1-1 1-1v1h1v3h1v-1c0-1 0-2-1-2zM269 316c0-1 0-1-1-1l-1 1c0 1-1 2-1 2v1h1v-2c0-1 1-1 1-1v-1s1 0 1 1v3h1v-1c0-1 0-2-1-2zM274 316l-1-1h-1l-1 1v3h1v-3s0-1 1-1v1c1 1 1 1 1 2v1-3zM277 315l-1 1h1v3-4zM281 315l-1 1h1v3h1v-4h-1zM286 315c-1 0-1 1-2 1h1v3h1v-4zM293 316c0-1-1-1-1-1h-1c0 1 0 1-1 2v2h1v-3c1 0 1-1 1-1v1h1v3h1v-1c0-1 0-2-1-2zM297 316c0-1 0-1-1-1h-1v2c-1 0-1 1-1 1v1h1v-2c0-1 1-1 1-1v-1l1 1v3h1v-1c0-1 0-2-1-2zM302 316l-1-1c-1 0-1 0-1 1-1 0-1 0-1 1v2h1v-3h1c0 1 1 1 1 2v1-3zM305 315l-1 1c1 0 1 1 1 1v2-4zM309 315l-1 1h1v3h1v-4h-1zM315 316c-1-1-1-1-2-1v1c-1 0-1 0-1 1v2-1s0-1 1-1v-1h1v3h1v-3zM319 316c0-1-1-1-1-1s-1 0-1 1c0 0-1 0-1 1v2h1v-3h2v3h1v-1c0-1-1-2-1-2zM323 316s0-1-1-1l-1 1v1c-1 0-1 1-1 1v1h1v-2c0-1 0-1 1-1h1v3h1v-1c0-1 0-1-1-2zM329 315c-1 1-1 1-2 1h1v3h1v-4zM334 316l-1-1s-1 0-1 1c0 0-1 0-1 1v2h1v-3h2v3h1v-1c0-1-1-1-1-2zM338 316s0-1-1-1l-1 1v1c-1 0-1 1-1 1v1h1v-2c0-1 0-1 1-1h1v3h1v-1c0-1 0-1-1-2zM342 315c-1 1-1 1-2 1h1v3h1v-4zM346 315c0 1-1 1-1 1v3h1v-4zM350 315c0 1-1 1-1 1h1v3-4zM356 316c-1 0-1-1-2-1v1c-1 0-1 0-1 1v2-2l1-1h1v3h1v-3zM359 315l-1 1v3h1v-4zM366 316s0-1-1-1l-1 1v1c-1 0-1 1-1 1v1h1v-2s0-1 1-1h1v3h1v-1c0-1 0-1-1-2zM370 315c-1 1-1 1-2 1h1v3h1v-4zM374 315l-1 1v3h1v-4zM378 315c0 1-1 1-1 1h1v3-4zM383 315c-1 1-1 1-2 1h1v3h1v-4zM388 316c-1 0-1-1-1-1-1 0-1 1-1 1s-1 0-1 1v2h1v-3h1v1c1 0 1 1 1 1v1-3zM391 315c0 1-1 1-1 1h1v3-4zM395 315c0 1 0 1-1 1h1v3h1v-4h-1zM403 316l-1-1c-1 0-1 1-1 1s-1 0-1 1v2h1v-3h1l1 1v2h1v-1c0-1-1-1-1-2zM406 315c0 1-1 1-1 1h1v3-4zM411 316s0-1-1-1v1c-1 0-1 0-1 1l-1 1v1h1v-2l1-1h1v3h1v-1c0-1 0-1-1-2zM415 315c-1 1-1 1-2 1h1v3h1v-4zM419 316h-1 1v3-3zM424 316h-2v1c-1 0-1 1-1 2h1v-2l1-1h1v3h1v-1c0-1 0-1-1-2zM428 316h-2 1v3h1v-3zM433 316h-2s-1 0-1 1v2h1v-3h1s1 0 1 1v2l1-1s-1-1-1-2zM439 316h-2 1v1h1v-1zM442 316h-1 2-1z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl83;
