import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl82 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2252}
      height={2255}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 1439 1441"
      {...props}
    >
      <defs>
        <style>
          {
            ".CyberEl82_svg__str0{stroke:#ccc;stroke-width:1.50932}.CyberEl82_svg__fil0,.CyberEl82_svg__fil1{fill:#000;fill-rule:nonzero}.CyberEl82_svg__fil1{fill:#ccc}"
          }
        </style>
      </defs>
      <g id="CyberEl82_svg__Vrstva_x0020_1">
        <g id="CyberEl82_svg___2609965150768">
          <path
            className="CyberEl82_svg__fil0"
            d="m682 735-1 1c-1 0-1 1-1 2l1 21v2h3c1-1 1-1 1-2v-22l-1-1c0-1-1-1-2-1zm20-4c-1 1-2 1-3 2 0 1 0 1-1 2v1c0 1-1 2 0 3v2l4 10v1l1 1c1 1 1 2 2 2 1 1 2 1 3 1h2s1 0 2-1c1 0 2-1 3-2 1 0 1-1 1-2 1-1 1-2 1-3 0 0 0-1-1-1v-1l-4-10c0-1-1-2-1-3-1 0-1-1-2-1-1-1-2-1-3-1h-4zm10 16v3c-1 1-1 1-2 1-1 1-1 1-2 1 0 0 0-1-1-1l-1-1v-1l-4-10v-1c0-1 0-1 1-2l1-1h2s1 0 1 1h1v1l4 10zm8-26c-1 1-1 1-1 2s0 1 1 2l14 16h3c1-1 1-1 1-2 0 0 0-1-1-1l-14-16c0-1-1-1-2-1h-1zm12-15v7c1 0 1 1 2 2l1 1h1l9 5c1 1 1 1 2 1h4s1-1 2-1c1-1 1-1 2-1 0-1 0-1 1-2 0-1 1-3 1-4s-1-2-1-3l-2-2-1-1h-1l-9-5c-1-1-2-1-3-1h-2c-1 0-2 1-3 1l-1 1c-1 1-1 2-2 2zm18 6h1s0 1 1 1v3l-1 1c-1 0-1 1-2 1h-1c0-1 0-1-1-1l-9-5h-1c0-1-1-1-1-1v-3c1 0 1-1 2-1 0 0 0-1 1-1l1 1h1l9 5zm-12-24 1 1c0 1 1 1 2 1l21 2s1 0 2-1v-3h-2l-21-2h-2c0 1-1 1-1 2zm0-23c0 2 0 3 1 4 0 0 1 0 1 1 1 0 1 0 1 1h6l10-2h2c1-1 2-1 3-2 0-1 1-2 1-3v-3c0-2-1-3-1-4-1-1-2-1-2-2-1 0-2 0-3-1h-1c-1 0-1 0-2 1l-10 1c-1 1-2 1-3 1 0 1-1 1-2 2 0 1-1 2-1 3v1c-1 1 0 2 0 2zm17-6h2s1 0 1 1l1 1v2l-1 1s0 1-1 1h-1l-10 2h-2c-1 0-1-1-1-1s-1-1-1-2v-1c0-1 0-1 1-1 0-1 0-1 1-1h1l10-2zm-26-20c1 2 1 3 2 3s1 1 2 1h1c1 1 2 1 3 0h2l10-5 1-1s1 0 1-1c1 0 1-1 1-2 1-1 1-2 1-3v-2l-1-1c0-2-1-3-2-3-1-1-2-1-3-1-1-1-2-1-3 0h-2l-10 5c0 1-1 1-2 2 0 0-1 1-1 2-1 1-1 2-1 3v2l1 1zm15-11h3c1 1 1 1 1 2 1 0 1 1 1 1 0 1 0 1-1 2l-1 1-10 5h-3c0-1-1-1-1-2v-3h1v-1l10-5zm-27-6c0 1 1 1 2 1 0 0 1 0 1-1l15-15c1 0 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1-1 0-2 0-2 1l-15 15s-1 1-1 2c0 0 0 1 1 1zm-17-12c1 0 3 1 4 1 0 0 1 0 1-1h2l2-2 1-1v-1l5-9v-2c1 0 1 0 1-1v-3c-1 0-1-1-2-2 0-1 0-1-1-2 0 0-1 0-2-1h-6c-1 1-2 1-2 2-1 0-1 1-1 1l-1 1-4 10c-1 0-1 1-1 2v3c0 1 1 2 1 3 1 0 1 0 1 1 1 0 2 1 2 1zm5-18 1-1c1-1 1-1 2-1h1c1 1 2 1 2 1v4l-5 9v1l-1 1h-3c-1 0-1-1-1-1l-1-1v-2h1l4-10zm-28 12h4s0-1 1-1l1-1c1-1 1-2 1-2 0-1 1-1 1-2v-14c0-1-1-2-1-3-1 0-2-1-3-2h-1c-1 0-2 0-2-1-2 0-3 1-4 1-1 1-2 1-2 2l-2 2v16c0 1 1 2 1 3 1 0 1 1 3 2h3zm-3-18 1-1v-1l1-1h3l1 1 1 1v1l-1 11v2s-1 0-1 1h-3l-1-1-1-1v-12zm-23 22c1 0 2-1 3-2 1 0 1 0 1-1 1 0 1-1 1-1v-5l-3-11s0-1-1-1v-1l-2-2c-1 0-2-1-3-1h-4c-1 1-2 1-3 2s-1 2-1 3c-1 1-1 1-1 2v3l4 10c0 1 0 2 1 2 0 1 1 2 2 2 0 1 1 1 2 2h2c1 0 1-1 2-1zm-8-16v-1c-1-1-1-1 0-1v-2h2c0-1 1-1 1 0h2v1l1 1 3 10v2s0 1-1 1c0 0 0 1-1 1h-3c0-1-1-1-1-1v-1l-3-10zm-12 26c0-1 1-1 1-2 0 0 0-1-1-2l-11-18s-1 0-2-1c0 0-1 0-1 1-1 0-1 0-1 1v2l12 18s0 1 1 1h2zm-14 11v-4l-16-14c0-1-1-1-2-1 0 0-1 0-1 1-1 0-1 1-1 1 0 1 1 1 1 2l15 15h4zm-14 18c1-1 1-3 1-4v-1c0-1 0-1-1-2 0-1 0-1-1-2l-1-1s-1 0-1-1l-9-5h-2s0-1-1-1h-3c-1 0-1 1-2 1l-2 2s0 1-1 1c0 1-1 3-1 4s0 2 1 3c0 0 1 1 1 2l1 1c1 0 1 0 1 1l10 5s1 0 2 1h3c1 0 2-1 3-1 0-1 0-1 1-2l1-1zm-18-6v-1c-1 0-1 0-1-1v-3l1-1h3l10 5 1 1v4l-1 1h-3l-10-5zm10 25c1 0 0-1 0-1 0-1-1-1-1-1l-21-4h-2c-1 1-1 1-1 2v1c1 1 1 1 2 1l21 4h1c1 0 1-1 1-2zm-2 24v-3l-1-1-1-1c-1-1-2-1-3-2h-14c-1 0-1 1-2 1s-1 0-2 1l-2 2v2c-1 1-1 1-1 2s1 3 1 4l2 2c1 0 2 1 3 1h15c1 0 2-1 3-2 1 0 1-1 2-2v-4zm-18 4h-2c0-1 0-1-1-1v-4s1 0 1-1h15v1c1 0 1 1 1 2v1l-1 1c-1 0-1 1-1 1h-12zm22 20-1-1c-1-1-1-1-2-1l-21 5c0 1-1 1-1 1 0 1-1 2 0 2 0 1 0 1 1 1 0 1 1 1 1 1l21-5c1 0 1-1 2-1v-2zm8 23c0-2-1-3-2-3 0-1-1-1-1-1-1 0-1 0-2-1h-3s0 1-1 1h-1l-10 5h-1s0 1-1 1c0 1-1 1-1 2-1 1-1 2-1 3v2c0 1 0 1 1 2 0 1 1 2 2 3 1 0 2 1 3 1h4s1 0 1-1l10-4c0-1 1-1 2-2 0 0 1-1 1-2 1-1 1-2 1-3v-1c0-1-1-2-1-2zm-15 10-1 1h-1s-1 0-1-1c-1 0-1-1-1-1-1-1-1-1-1-2l1-1s0-1 1-1l10-5h3s1 1 1 2c0 0 1 1 0 1v1c0 1 0 1-1 1v1l-10 4zm31 13c-1-1-2-2-3-2-1-1-1-1-2-1h-1c-1 0-2 0-3 1h-1l-1 1-8 7c-1 0-1 1-1 1s-1 0-1 1-1 2-1 3v3l1 1c0 1 1 1 1 2 1 1 2 2 3 2h6s0-1 1-1l1-1 8-7 1-1c1-1 1-2 1-3 1-1 1-2 0-3v-2c-1 0-1-1-1-1zm-12 14c-1 0-1 0-1 1h-2c-1 0-1-1-2-1v-2c-1 0-1-1 0-1v-1s1 0 1-1l8-7h1s0-1 1-1l1 1s1 0 1 1c1 0 1 1 1 1v1c0 1 0 1-1 1v1l-8 7zm29 1c-1-1-1-1-2-1s-1 1-1 1l-13 18v2l1 1c1 0 1 1 2 0h1l12-18c1-1 1-1 1-2l-1-1zM658 784h-5c-1 0-1 1-2 1l-2 2v1c-1 0-1 1-1 1l-3 10c0 1-1 1-1 2v1c0 1 0 2 1 3 0 0 1 1 1 2 1 0 1 1 2 1 0 0 1 1 2 1h3c1 0 2 0 3-1 1 0 1-1 2-2l1-1v-1l4-10v-3s0-1-1-2c0-1 0-2-1-3-1 0-1-1-1-1-1 0-2-1-2-1zm-3 19h-1v1c0 1-1 1-1 1h-2c-1-1-1-1-2-1v-3l3-10 1-1v-1c1 0 1-1 2-1 0 0 1 0 1 1h2v1c1 1 1 1 0 2l-3 11zm28-15c-1 0-2 0-3 1-1 0-1 0-2 1l-1 1c0 1-1 1-1 2v15l1 1c0 1 0 2 1 2 0 1 1 2 2 2s1 1 2 1h2c1 0 2 0 3-1s2-1 3-2c0-1 1-1 1-2v-16c-1-1-1-2-2-3 0 0-1-1-2-1-1-1-1-1-2-1h-2zm4 18v1s0 1-1 1c0 0 0 1-1 1h-3s-1 0-1-1v-2l-1-10v-2h1c0-1 0-1 1-1l1-1c1 0 2 1 2 1s1 0 1 1v1h1v11zm24-22c-1 0-2 1-3 1 0 1 0 1-1 2l-1 1v5l3 10v2s1 0 1 1 1 1 2 2c1 0 2 1 3 1h3c2-1 3-1 4-2 0-1 1-1 1-2 1-1 1-2 1-3v-2l-3-11c0-1-1-1-1-2-1-1-1-2-2-2-1-1-2-1-3-1 0-1-1-1-2-1 0 1-1 1-2 1zm8 17v3c-1 0-1 0-2 1h-2s0-1-1-1v-1c-1 0-1-1-1-1l-2-10-1-1v-1c1 0 1-1 1-1s1-1 2-1h1c1 0 1 0 2 1v1l3 11zm14-26-1 1v2l10 19c1 0 1 1 2 1h2s0-1 1-1c0-1 0-2-1-2l-10-19c0-1 0-1-1-1h-2zm16-10v3l14 16c0 1 0 1 1 1h2c0-1 0-1 1-2l-1-1-13-17c-1 0-1-1-2-1s-1 0-2 1zm18-17c-1 1-2 2-2 3v3c0 1 1 2 1 2 0 1 1 1 1 1 0 1 1 1 1 1l8 7 1 1h1c1 1 2 1 3 1s2 0 3-1h1l2-2c1-1 1-2 2-3v-3c-1-1-1-2-1-3-1 0-1 0-1-1h-1l-8-7c-1-1-2-1-3-2h-5c-1 1-1 1-2 1 0 1-1 1-1 2zm16 9 1 1v2s0 1-1 1c0 1 0 1-1 1 0 1-1 1-1 1l-1-1h-1l-8-7-1-1v-1c-1 0-1-1 0-1v-2c1 0 1 0 2-1h1s1 0 1 1h1l8 7zm-4-29v2c1 1 1 1 2 1l19 10h2l1-1v-2c0-1-1-1-1-1l-20-10h-1c-1 1-1 1-2 1zm9-22c-1 1-1 2 0 4v1l1 1c1 1 1 2 2 2 0 0 1 0 1 1h1l11 3h2c1 0 2-1 3-1s2-1 2-2c1 0 1-1 1-1 1-1 1-1 1-2v-4c0-1-1-2-1-2-1-1-1-2-2-2s-1-1-1-1h-2l-10-3h-3s-1 0-2 1c-1 0-2 1-3 2l-1 1v2zm18 1h1c0 1 1 1 1 1l1 1v2l-1 1c0 1-1 1-1 1h-2l-11-2v-1h-1l-1-1v-2c0-1 1-1 1-2h3l10 2zm-15-25c0 1 0 1 1 2h1l22 1s1 0 1-1c1 0 1-1 1-1 0-1 0-1-1-2 0 0-1 0-1-1h-22s-1 0-1 1c-1 0-1 0-1 1zm-1-25c0 2 0 3 1 4l1 1 1 1c1 0 2 0 3 1h2l11-2h1s1 0 1-1c1 0 2-1 2-1 1-1 2-2 2-3v-4c0-1 0-2-1-3l-2-2c-1-1-2-1-3-1h-2l-11 2h-3c0 1-1 1-2 2 0 1-1 2-1 3l-1 1c0 1 0 2 1 2zm17-6h1s1 0 1 1h1c0 1 1 1 1 2v2l-1 1h-1l-1 1-10 1h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-2c0-1 0-1 1-1 0 0 0-1 1-1h1l10-2zm-25-22c1 1 2 2 2 3 1 0 1 1 2 1 0 0 1 0 1 1h4l1-1 10-4h2l1-1s1-1 1-2c1-1 1-2 1-3v-3c-1-2-1-3-2-3-1-1-2-2-3-2h-5l-10 4c-1 0-2 1-2 1-1 1-2 2-2 3-1 0-1 1-1 2v4zm16-10h2c1 0 1 1 2 1 0 0 0 1 1 1v2s0 1-1 1v1h-1l-10 4h-3c-1 0-1-1-1-2-1 0-1-1-1-1 0-1 1-1 1-2h1v-1l10-4zm-26-13c0 1 1 1 1 1 1 1 2 0 2 0l18-11c1 0 1-1 2-1 0-1 0-2-1-2 0-1 0-1-1-1h-2l-18 11c-1 1-1 1-1 2v1zm-14-20c1 1 2 2 3 2 0 1 1 1 1 1h2c1 0 2 0 3-1h1c0-1 0-1 1-1l8-7c0-1 0-1 1-1v-1c1-1 1-2 1-3v-3s0-1-1-1c0-1 0-2-1-2-1-1-2-2-3-2-1-1-2-1-3-1s-2 1-2 1c-1 0-1 0-1 1h-2l-8 8-1 1c-1 1-1 2-1 3v3c0 1 0 1 1 2 0 0 0 1 1 1zm11-14 1-1h3l1 1 1 1v2l-1 1-8 7-1 1h-2c-1 0-1 0-2-1l-1-1v-2h1v-1l8-7zm-32-5c1 1 2 1 4 1h3s1-1 2-1c0-1 1-1 1-1s0-1 1-1l6-9v-1l1-1v-3c0-1 0-2-1-3 0 0 0-1-1-1 0-1-1-1-1-2-2 0-3-1-4-1h-3l-2 2c-1 0-1 0-1 1 0 0-1 0-1 1l-6 8c0 1-1 2-1 3v2c0 1 0 2 1 3 0 1 0 1 1 2l1 1zm8-17v-1h1c1 0 1-1 2 0h1l1 1c1 1 1 1 1 2l-1 1-6 9-1 1v1h-2s-1 0-1-1c-1 0-1-1-1-1-1 0-1-1-1-1v-1l1-1 6-9zm-33 3c1 1 2 1 3 1h2c0-1 1-1 1-1l2-2 1-1v-1l4-10c0-1 1-1 1-1v-2s0-1-1-2c0-1 0-2-1-3l-1-1c-1 0-1-1-2-1s-3-1-4 0h-3c0 1-1 2-2 2v1l-1 1-4 10v6c0 1 1 1 1 2 1 1 1 1 2 1 0 1 1 1 2 1zm3-18s1 0 1-1c1-1 1-1 2-1h1c1 1 1 1 2 1v3l-4 10v1l-1 1h-3c-1 0-1 0-1-1-1 0-1-1-1-1v-2l4-10zm-26 13s1 0 1-1c1 0 1-1 1-1l3-21v-2c-1-1-1-1-2-1h-1c-1 1-1 1-1 2l-3 21v2c1 0 1 1 2 1zm-20-1s1 0 2-1v-23l-1-1c-1-1-1-1-2-1 0 0-1 0-1 1-1 0-1 1-1 1l1 22v1c1 1 1 1 2 1zm-24 3c1 0 2-1 3-1 0-1 1-1 1-2 0 0 1 0 1-1s1-2 1-3v-2l-3-11v-1l-1-1c0-1-1-1-2-2 0-1-1-1-2-1h-4c-1 0-2 1-3 1-1 1-2 2-2 3 0 0-1 1-1 2v3l3 10c0 1 0 2 1 3 0 0 1 1 1 2 1 0 2 1 3 1h4zm-7-17v-2s0-1 1-1c0-1 0-1 1-1h2s1 0 1 1l1 1 2 11v2s0 1-1 1l-1 1h-2l-1-1-1-1v-1l-2-10zm-17 25 2-2v-1l-9-20c0-1-1-1-1-1-1-1-1-1-2 0 0 0-1 0-1 1v2l9 19c0 1 0 1 1 2h1zM600 569c1-1 2-2 2-3l1-1v-4c0-1-1-1-1-1v-2l-6-8-1-1c0-1-1-1-1-1-1-1-2-1-3-2h-3s-1 0-1 1c-1 0-1 0-2 1-1 0-2 1-2 2-1 1-1 2-1 3v4c1 0 1 1 1 1l6 9 2 2c1 0 1 1 2 1s2 1 3 0h2c1 0 1-1 2-1zm-13-13c0-1-1-1-1-1v-3c1 0 1 0 2-1h3l1 1 6 9v1h1v1s0 1-1 1c0 0 0 1-1 1 0 1-1 1-1 1h-2s0-1-1-1v-1l-6-8zm-8 29c1 0 1-1 1-2v-1l-15-16-1-1c-1 0-2 0-2 1l-1 1c0 1 0 2 1 2l14 16c1 0 1 0 2 1l1-1zm-16 18c1-1 2-2 2-3v-3c-1-1-1-2-2-3v-1h-1l-9-7s-1 0-1-1h-7c0 1-1 1-1 1l-2 2c0 1-1 2-1 3v3c0 1 1 2 1 3 0 0 1 0 1 1h1l9 7s1 1 2 1h6c0-1 0-1 1-1 0-1 1-1 1-2zm-16-8c-1 0-1-1-1-1l-1-1v-1s1-1 1-2c0 0 1 0 1-1h3v1l9 6 1 1v4c-1 0-1 0-2 1h-2l-1-1-8-6zm1 34c1-1 1-3 1-4v-1c0-1 0-1-1-2 0-1-1-1-1-2-1 0-1 0-1-1h-1l-10-5h-1c-1 0-1 0-2-1 0 0-1 0-2 1-1 0-2 0-3 1l-1 1c-1 1-1 1-1 2-1 1-1 2-1 3 0 2 0 2 1 3 0 1 1 2 1 3h1c1 1 1 1 2 1l9 4c1 1 2 1 3 1h2c1 0 2-1 3-1 1-1 1-1 1-2 1 0 1-1 1-1zm-18-5v-1h-1c0-1 0-1-1-2l1-1c0-1 1-1 1-2h3l10 5h1v1c1 0 1 1 1 1 0 1 0 1-1 2 0 1 0 1-1 1 0 1-1 1-1 1h-1l-1-1-10-4zm11 28c0-1 0-2-1-2 0-1-1-1-1-1l-21-5h-2c0 1-1 1-1 2 0 0 0 1 1 1 0 1 0 1 1 1l21 5h2s0-1 1-1zm-4 25c0-2 0-3-1-4 0 0 0-1-1-1 0-1 0-1-1-1 0-1-1-1-2-2h-2l-11-1h-3c-1 0-1 1-2 1-1 1-2 1-2 2-1 1-1 1-1 2v5c1 1 1 2 2 3s1 1 2 1 1 1 1 1h2l10 1h3c1-1 2-1 2-2 1 0 2-1 3-2v-1c0-1 1-2 1-2zm-19 1h-2s0-1-1-1v-2c0-1 0-1 1-1 0-1 0-1 1-1 0-1 0-1 1-1h1l10 1h2v1s1 0 1 1v3c-1 0-1 1-1 1h-2l-11-1zm19 29c0-2 0-3-1-4l-1-1-1-1c-1 0-2-1-3-1h-2l-11 1h-1l-1 1c-1 0-2 1-3 1 0 1-1 2-1 3 0 0 0 1-1 2v2c1 1 1 2 2 3 0 1 1 2 2 2 1 1 1 1 2 1h3l11-1s1 0 2-1c1 0 2 0 2-1 1-1 1-2 2-3v-3zm-18 5h-2c0-1 0-1-1-1v-4l1-1h2l10-2h2v1h1c0 1 1 1 1 2v2c-1 0-1 1-1 1h-1l-1 1-11 1zm24 24c0-1-1-2-2-3 0 0 0-1-1-1 0 0-1 0-1-1h-5l-11 3-1 1h-1c-1 1-1 2-2 2-1 1-1 2-1 3v4c1 1 1 2 2 3l2 2h6l10-3c1 0 1-1 2-1 1-1 2-1 2-2 1-1 1-2 1-3v-4zm-17 9h-2s0-1-1-1c0 0 0-1-1-2v-1c0-1 1-1 1-1 0-1 0-1 1-1h1l10-3 1-1h1c0 1 1 1 1 1s0 1 1 2v1c0 1 0 1-1 1 0 1 0 1-1 1l-11 4zm26 16c0-1-1-1-1-1-1-1-1-1-2 0l-20 8c0 1-1 1-1 2v1c0 1 1 1 1 2 1 0 2 0 2-1l20-8c0-1 1-1 1-2v-1zm10 18c-1 0-1-1-2-1h-2l-18 12s-1 0-1 1v2c1 0 1 1 2 1 0 0 1 0 2-1l18-11 1-1v-2zm15 21c-1-1-2-2-3-2s-1 0-2-1h-1c-1 0-2 1-3 1h-1c0 1-1 1-1 1l-8 7c-1 0-1 1-1 1-1 0-1 0-1 1-1 1-1 1-1 2v3c0 1 0 1 1 2 0 1 0 1 1 2s2 2 3 2 1 1 2 1c1-1 2-1 3-1 0 0 1 0 1-1h1l9-7c0-1 1-1 1-2 1-1 1-2 1-3 1-1 1-2 0-3v-1c-1-1-1-1-1-2zm-13 14v1h-3s0-1-1-1c0-1-1-1-1-2v-1l1-1 1-1 8-6v-1h3s1 0 1 1c1 0 1 1 1 1v2l-1 1-9 7zm30 3h-2c-1 0-1 0-1 1l-14 16c0 1-1 1 0 2v2h2c1 0 1 0 1-1l14-16c0-1 1-1 1-2-1-1-1-1-1-2zm20 15c-1 0-2-1-3-1h-2s-1 0-1 1c-1 0-2 0-2 1-1 0-1 1-1 1l-1 1-5 9-1 1v2c-1 1-1 1 0 2 0 1 0 2 1 3 0 1 0 1 1 2 0 0 1 0 1 1 2 0 3 1 4 1s2 0 3-1c1 0 1 0 2-1l1-1 1-1 5-9c1-1 1-2 1-3v-2c0-1 0-2-1-3 0-1-1-1-1-2 0 0-1 0-2-1zm-6 18h-1v1h-3c-1-1-1-1-2-1v-3h1l5-10c0-1 1-1 1-1h3c1 0 1 1 1 1l1 1v2h-1l-5 10zm29-7h-2s0 1-1 1l-7 20c-1 1-1 1 0 2 0 1 0 1 1 1h2s1 0 1-1l7-20c1-1 1-1 0-2 0 0 0-1-1-1zm23 6h-4c0 1 0 1-1 1l-1 1-2 2v1c0 1 0 1-1 2l-1 10v3c0 1 0 2 1 2 0 1 1 2 2 3h2c0 1 1 1 1 1h4c1-1 2-1 3-2 0-1 1-1 1-2s1-1 1-1v-2l1-10c1-1 1-2 1-3-1-1-1-2-1-2l-3-3h-1c-1-1-1-1-2-1zm1 19s-1 0-1 1-1 1-1 1h-4v-1c-1 0-1-1-1-1v-1l2-11v-1s1 0 1-1h4l1 1v2l-1 11zm29-17c-1 0-2 0-3 1 0 0-1 0-1 1-1 0-1 0-1 1l-2 2v15c1 0 1 0 1 1s1 2 1 2c1 1 2 2 3 2l1 1h2c2 0 3 0 4-1 1 0 1-1 2-2s1-1 1-2v-2c1 0 1-1 1-1l-1-11v-2c0-1-1-2-2-3 0 0-1-1-2-1 0-1-1-1-2-1h-2zm4 18v2c-1 0-1 1-1 1h-4l-1-1v-14c0-1 1-1 1-1s1 0 2-1l1 1c1 0 1 0 1 1 0 0 1 0 1 1v11zm22-21c-1 0-1 0-2 1v2l4 21s0 1 1 1c0 0 1 1 1 0h2v-2l-4-21v-2h-2zm23-7c-1 1-2 2-3 2v2c-1 0-1 1-1 1v5l4 10v2h1l2 2c1 1 2 1 3 1h4c1-1 2-2 3-2 1-1 1-2 1-3 1-1 1-2 1-3 0 0 0-1-1-1v-1l-4-10c0-1 0-2-1-2-1-1-1-2-2-2-1-1-2-1-3-1h-4zm10 16v4h-2c0 1-1 1-1 1-1 0-1 0-2-1v-1h-1l-4-10v-2c0-1 0-1 1-1 0-1 0-1 1-1 1-1 1-1 2-1l1 1 1 1 4 10zM768 828c-2 1-3 2-3 3l-1 1v5c0 1 0 1 1 2l5 9c0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 2 1 1 1 2 1 3 1h2c0-1 1-1 1-1 2-1 2-2 3-3 1 0 1-1 1-2v-4c0-1-1-1-1-1l-5-10-2-2s-1-1-2-1c-1-1-2-1-3-1h-2c0 1-1 1-1 1zm11 15s1 0 1 1v1l-1 1s0 1-1 1l-1 1c-1 0-1-1-2-1h-1v-1l-5-10h-1v-3c1 0 1 0 2-1h3v1h1l5 10zm13-32c-1 1-2 2-2 3l-1 1v2c0 1 1 2 1 3v1c1 0 1 0 1 1l7 8 1 1s1 0 1 1c1 0 2 1 3 1h3c0-1 1-1 1-1 1 0 1-1 2-1 1-1 2-2 2-3s1-2 1-3-1-2-1-3l-1-1v-1l-7-8-2-2c-1 0-2 0-3-1h-3c0 1-1 1-1 1-1 0-1 1-2 1zm14 12 1 1v2c0 1-1 1-1 1-1 1-1 1-2 1h-2v-1l-7-8-1-1v-2s0-1 1-1c0-1 1-1 1-1h3v1l7 8zm4-30v2s0 1 1 1l16 15h1c1 0 1 0 2-1v-3l-16-14c-1 0-1-1-2-1s-1 1-2 1zm13-16v2s0 1 1 1l18 12h1c1 0 1 0 2-1v-1c0-1 0-1-1-2l-18-11c0-1-1-1-2-1l-1 1zm13-22c-1 1-1 2-1 4v1c0 1 1 1 1 2l2 2h1c0 1 0 1 1 1l9 5h6c1 0 1-1 2-1l2-2s0-1 1-1v-7c-1 0-1-1-2-2 0 0-1 0-1-1h-1l-10-5h-2c-1-1-2 0-3 0s-2 0-3 1l-1 1c0 1-1 1-1 2zm18 5h1v1c1 0 1 1 1 1 0 1 0 1-1 2 0 1 0 1-1 1 0 1 0 1-1 1h-1s-1 0-1-1l-9-4h-1l-1-1v-3c0-1 1-1 1-1 0-1 1-1 1-1h2l10 5zm-9-29c0 1 0 1 1 2 0 1 0 1 1 1l21 6h1c1-1 1-1 1-2 1 0 0-1 0-1 0-1-1-1-1-1l-21-6h-2s0 1-1 1zm6-26c0 2 0 3 1 4v1c0 1 1 1 1 1 1 1 1 2 2 2s1 0 1 1h2l10 2h3c1 0 2 0 2-1 1 0 2-1 3-2v-1c1-1 1-2 1-2v-4c0-1-1-2-2-3 0 0-1-1-2-1 0 0 0-1-1-1h-1l-11-2h-2c-1 0-2 0-3 1-1 0-1 1-2 2l-1 1c0 1 0 1-1 2zm19 0s1 0 1 1h1s0 1 1 1v2l-1 1c0 1-1 1-1 1l-1 1-1-1-11-1v-1h-1l-1-1v-2c0-1 0-1 1-2h1c0-1 0-1 1-1h1l10 2zm-16-25v1c1 1 1 1 2 1l21 1c1 0 1-1 2-1 0 0 1-1 1-2l-1-1c0-1-1-1-2-1h-23v2zm-2-26c1 1 1 2 2 3 0 1 0 1 1 1 0 1 0 1 1 1 1 1 2 1 2 1 1 1 1 1 2 1h1l11-2h2c1-1 2-1 2-2l2-2v-4c0-1 0-3-1-4-1 0-1-1-2-2-1 0-2 0-3-1h-2l-11 1c-1 1-1 1-2 1s-2 1-3 2c0 0-1 1-1 2s0 1-1 2v2zm18-5h2c1 0 1 0 1 1 1 0 1 1 1 1v2c0 1-1 1-1 1l-1 1h-1l-11 1h-2v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1 0-1 0-1 1-1h1l10-1zm-23-26c0 1 1 2 2 3 0 1 0 1 1 1 0 1 1 1 1 1 1 0 2 1 3 1h2l11-3h1c0-1 0-1 1-1l2-2c1-1 1-2 1-3v-3c0-2-1-3-2-4 0 0-1-1-2-1-1-1-2-1-3-1h-2l-11 3s-1 0-2 1c-1 0-1 1-2 2 0 0-1 1-1 2v4zm17-7c0-1 1-1 1-1h1c0 1 1 1 1 1 0 1 1 1 1 2v1c0 1 0 1-1 2h-1l-1 1-10 2h-3c0-1 0-1-1-2v-2l1-1h1l1-1 10-2zm-25-18c0 1 1 1 1 2h2l20-8c0-1 1-1 1-2v-1c0-1-1-1-1-2h-2l-20 8c0 1-1 1-1 2v1zm-11-23c1 1 2 2 3 2 0 1 0 1 1 1 0 0 1 0 1 1 1 0 2 0 3-1h2l10-6h1c0-1 0-1 1-1 0-1 1-2 1-3 1-1 1-2 1-3 0 0 0-1-1-1v-2l-3-3c-1 0-2-1-3-1h-2c-1 0-1 0-2 1h-1l-9 5-2 2c-1 1-1 1-1 2-1 1-1 2-1 3v2s1 1 1 2zm15-12 1-1c1 0 1 1 2 1 0 0 0 1 1 1v3s0 1-1 1l-10 6h-3l-1-1v-4l1-1 10-5zm-32-15c1 2 2 2 3 3h1c1 0 1 0 2 1 1-1 2-1 3-1h1c0-1 0-1 1-1l8-7c1 0 1 0 1-1 1 0 1 0 1-1 1 0 1-1 1-2v-5l-1-1-3-3h-6l-1 1h-1l-8 7c-1 0-2 1-2 2-1 0-1 1-1 2-1 1-1 2 0 3v2l1 1zm13-13s0-1 1-1h2l1 1c1 1 1 1 1 2v1s0 1-1 1v1l-9 6-1 1h-2l-1-1c-1-1-1-1-1-2v-1s0-1 1-1v-1l9-6zm-34-10c1 1 2 2 4 2h1c1 1 1 1 2 0h2l1-1 1-1 8-8 1-1v-1c1 0 1-1 1-2v-3c-1-1-1-1-1-2-1 0-1-1-1-1-1-1-2-2-4-2-1-1-2-1-2-1-1 1-2 1-3 1 0 1-1 1-1 1-1 0-1 1-1 1l-8 8s-1 1-1 2c-1 0-1 1-1 2v3c1 1 1 1 1 2 1 0 1 1 1 1zm11-15s1 0 1-1h2s1 0 1 1c1 0 1 1 1 1 1 1 1 1 0 2v1h-1l-7 8-1 1h-2s-1 0-1-1c-1 0-1-1-1-1-1-1-1-1 0-2v-1h1l7-8zm-30-1h3l12-18c1 0 1-1 1-2l-1-1h-3l-13 18v2s0 1 1 1zm-17-11c0 1 1 1 1 0 1 0 1 0 2-1l9-19c1 0 1-1 1-2-1 0-1-1-2-1h-1c-1 0-1 1-2 1l-9 19c0 1-1 1 0 2 0 1 0 1 1 1zm-25-11c2 1 3 1 4 1h1c1-1 1-1 2-1l2-2s0-1 1-1v-1l4-10v-3c1-1 0-1 0-2s-1-2-1-3c-1 0-1-1-2-1l-1-1c-2 0-3-1-4 0h-3c-1 1-1 2-2 2 0 1 0 1-1 1v2l-4 10s0 1-1 2c0 1 0 2 1 3 0 1 1 2 1 2 1 1 1 1 2 1 0 1 1 1 1 1zm4-18v-1h1c0-1 1-1 1-1h2l1 1c1 0 1 1 1 1v2l-4 10v1s-1 0-1 1h-3c-1 0-1 0-1-1-1 0-1-1-1-1v-2l4-10zm-28 12c1 0 1 0 2-1 0 0 1 0 1-1l4-21v-2c-1 0-1-1-2-1 0 0-1 0-1 1-1 0-1 0-1 1l-5 21c0 1 0 1 1 2l1 1zm-25-3c2 0 3 0 4-1 0 0 1 0 1-1 0 0 1 0 1-1l2-2v-16c0-1-1-2-1-2-1-1-2-2-3-2 0-1-1-1-1-1h-6c-1 1-1 2-2 2-1 1-1 2-1 3-1 0-1 0-1 1v14c0 1 1 2 1 3 1 1 2 1 3 2 0 0 1 0 1 1h2zm-2-19v-2h1c1-1 1-1 2-1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1l-1 11v2l-1 1h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-1l1-11zm-25 19h2c0-1 1-1 1-2l-2-21c0-1 0-1-1-2h-3c0 1-1 1-1 2l2 21c0 1 0 1 1 2 0 0 1 1 1 0zM628 483c2-1 3-1 4-2 0 0 0-1 1-1v-1c1-1 1-2 1-3v-3l-3-10v-2l-2-2c-1-1-2-1-3-2h-4c-1 1-2 1-3 2l-2 2c0 1 0 2-1 3 0 0 0 1 1 1v1l2 11c0 1 1 1 1 2s1 2 2 2c1 1 1 1 3 2h3zm-7-18v-1c0-1 0-1 1-2h4l1 1v1l2 11h1v1h-1v1c-1 1-1 1-2 1h-3v-1l-1-1-2-11zm-22 27c1-1 2-1 3-2 0-1 0-1 1-1v-7l-4-10c0-1 0-1-1-1v-1l-2-2c-1 0-2-1-3-1h-2c-1 0-1 0-2 1-1 0-2 1-3 2s-1 1-1 2c-1 1-1 2-1 3 0 0 0 1 1 1v2l4 10s1 1 1 2c1 0 1 1 2 2h3c1 1 1 1 2 0h2zm-10-16v-3c1-1 1-1 2-1h3v1c1 0 1 0 1 1l4 10v2l-1 1-1 1h-3c0-1 0-1-1-1v-1l-4-10zm-14 27c1 0 1-1 1-1 1-1 1-2 0-2l-10-19c-1 0-1-1-2-1h-1c-1 1-1 1-1 2-1 0-1 1 0 1l10 19c1 1 1 1 2 1h1zm-22 14c1 0 2-1 2-2s1-1 1-2v-4c-1 0-1-1-1-1v-1l-7-9v-1c-1 0-1 0-1-1-1 0-2-1-3-1h-5c0 1-1 1-1 1l-3 3c0 1-1 2-1 3s1 2 1 3v1c1 0 1 1 1 1l6 9c1 0 1 1 2 1l2 2h3c1 0 1 0 2-1 1 0 1 0 2-1zm-13-13h-1v-3l1-1c1 0 1-1 2-1h1c0 1 1 1 1 1l1 1 6 9s0 1 1 1c0 1-1 1-1 2l-1 1h-1c-1 1-1 1-2 0h-1v-1l-6-9zm-10 33c1-1 2-2 2-3v-3c0-1 0-2-1-3v-1c-1 0-1 0-1-1l-8-7c0-1-1-1-1-1s-1 0-1-1h-3c-1-1-2 0-3 0 0 0-1 0-1 1-1 0-1 0-2 1s-1 2-2 3v3c0 1 1 2 1 3l1 1 1 1 7 7c1 1 2 1 2 2h6c1 0 1 0 2-1l1-1zm-15-11h-1v-3l1-1s0-1 1-1h2l1 1 8 7v1h1v2c0 1-1 1-1 2-1 0-1 1-2 1h-1s-1 0-1-1h-1l-7-8zm-5 34c0-1 1-2 1-3v-3c0-1-1-2-1-2l-1-1c0-1-1-1-1-1l-9-6c0-1-1-1-1-1s-1 0-1-1h-3c-1 0-2 0-3 1 0 0-1 0-1 1-1 0-1 1-1 1-1 1-2 3-2 4v3l2 2v1c1 0 1 1 1 1l9 6c1 1 1 1 2 1 1 1 2 1 3 1s2-1 3-1l1-1 2-2zm-17-8h-1v-1c0-1-1-1 0-2v-1l1-1c1 0 1-1 2-1 0 0 0 1 1 1h1l8 6 1 1c0 1 0 1 1 1v1c0 1-1 1-1 2l-1 1h-3v-1l-9-6zm2 31v-2s0-1-1-1l-18-11h-2c-1 0-1 0-1 1-1 1-1 1-1 2l1 1 19 11h2l1-1zm-10 19c1 0 1-1 0-1 0-1 0-1-1-2l-19-9h-2c-1 1-1 1-1 2v1c0 1 0 1 1 2l19 8c1 1 2 1 2 0 1 0 1 0 1-1zm-8 24v-3c0-1 0-1-1-2v-1c-1-1-2-1-2-2-1 0-1 0-1-1h-2l-10-3h-5c-1 1-2 1-3 2 0 0 0 1-1 2v1c-1 2-1 3-1 4 1 1 1 2 2 3l2 2h1l1 1 10 3h3c1 0 2 0 2-1 1 0 2-1 3-1 0-1 1-1 1-2 0 0 0-1 1-2zm-19-2h-1l-1-1v-2c0-1 0-2 1-2 0 0 0-1 1-1h2l10 3 1 1h1v1c1 1 0 1 0 2v2h-4l-10-3zm13 29c0-1 0-2-1-2 0-1-1-1-1-1l-21-4c-1 0-1 0-2 1-1 0-1 0-1 1v2c1 0 1 0 2 1l21 3h2l1-1zm-3 25c0-1 0-3-1-4l-1-1s0-1-1-1c0-1-1-1-2-1l-1-1h-15c-1 0-2 1-2 1-1 1-2 2-2 3l-1 1v2c0 2 0 3 1 4 0 1 1 2 1 2 1 1 2 1 3 2h16s1-1 2-1c1-1 1-1 2-3l1-1v-2zm-19 3v-1h-1c-1 0-1 0-1-1-1 0-1-1-1-2l1-1c0-1 0-1 1-1l1-1h1l10 1h2c1 0 1 1 1 1v3c0 1-1 1-1 1 0 1-1 1-1 1h-12zm19 24c0-1 0-1-1-2h-1l-22 1-1 1c-1 1-1 1-1 2 0 0 0 1 1 1 0 1 1 1 2 1l21-2h2v-2zm3 27c0-1-1-3-1-3 0-1-1-1-1-2h-1c-1-1-2-1-3-1h-3l-10 1c-1 0-1 1-1 1h-2c0 1-1 1-2 2 0 1-1 1-1 2s-1 2-1 2c0 1 0 1 1 2 0 1 0 3 1 4 1 0 1 1 2 1 1 1 2 1 3 1h2l11-1c1-1 1-1 2-1s2-1 2-2c1 0 2-1 2-2v-4zm-17 6h-2c-1 0-1-1-1-1-1 0-1-1-1-2v-1c0-1 0-1 1-1 0-1 0-1 1-1h1l10-2h2l1 1s1 1 1 2v1l-1 1c0 1-1 1-1 1h-1l-10 2zm24 24c0-1-1-2-2-3l-1-1h-1c-1-1-2-1-3-1h-2l-11 3c0 1-1 1-1 1l-1 1c-1 0-1 1-2 2 0 0-1 1-1 2v4c1 1 1 2 2 3s2 2 3 2h5l10-3c1 0 2-1 2-1 1-1 2-1 2-2 1-1 1-2 2-3v-2s-1-1-1-2zm-16 9h-2c-1 0-1 0-2-1v-1c-1-1-1-2-1-2 1 0 1-1 1-1l1-1h1l10-3 1-1c1 0 1 0 1 1h1s1 1 1 2v3h-1l-1 1-10 3zm25 17c0-1 0-1-1-1 0-1-1-1-2 0l-19 8c-1 0-1 0-2 1v2c1 0 1 1 1 1h2l20-8c1 0 1-1 1-1 1-1 1-1 0-2zm12 23c-1-1-2-2-3-2 0-1-1-1-1-1h-2c-1-1-2 0-2 0h-2l-1 1-9 5c-1 0-1 0-1 1 0 0-1 0-1 1-1 0-1 1-2 2v5l1 1c1 2 2 2 3 3 0 1 1 1 2 1h4l1-1 10-5c0-1 1-1 2-2 0 0 1-1 1-2 1-1 1-2 1-3s0-1-1-2v-2zm-15 12-1 1h-1l-1-1s-1 0-1-1-1-1-1-1c0-1 1-1 1-2v-1h1l9-5 1-1h2c1 0 1 1 2 2v2c0 1 0 1-1 1v1l-10 5zm32 16-3-3h-1c-1 0-1-1-2-1s-1 1-2 1h-1c-1 0-1 1-2 1l-8 6c-1 0-1 1-1 1-1 0-1 0-1 1-1 1-1 1-1 2-1 1-1 2-1 3 1 1 1 1 1 2s0 1 1 2 2 2 3 2c0 1 1 1 2 1h3l1-1c1 0 1 0 1-1l9-6c1 0 1-1 2-1 1-1 1-2 1-3 1-1 1-2 0-3v-2l-1-1zm-13 13h-1s-1 0-1 1l-1-1c-1 0-1 0-2-1v-3l1-1 9-6 1-1h2l1 1c1 1 1 1 1 2v1s0 1-1 1v1l-9 6zm33 10c-1-1-2-1-3-2h-3c-1 0-2 0-2 1h-1c-1 1-1 1-2 1l-7 7-1 1c0 1-1 1-1 2 0 0-1 1-1 2v3c1 1 1 1 1 2l1 1c1 1 2 2 3 2 1 1 2 1 3 1s2-1 3-1c0 0 1 0 1-1h1l8-8s1-1 1-2c1-1 1-1 1-2v-3c0-1 0-1-1-2 0-1 0-1-1-2zm-11 15c0 1-1 1-1 1h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-3h1l8-8h1v-1c1 0 1 0 1 1 1 0 1 0 2 1l1 1v1c0 1 0 1-1 1v1l-8 7zM555 880s-1-1-2-1l-1 1-13 17c-1 0-1 1-1 2 0 0 0 1 1 1 0 1 1 1 2 1l1-1 13-17c1 0 1-1 1-2 0 0 0-1-1-1zm17 13c0-1-1-1-1-1-1 0-1 1-2 1l-11 18c-1 1-1 1-1 2 1 1 1 1 1 2h2c1 0 1-1 1-1l12-18v-2c0-1 0-1-1-1zm24 13c-2-1-3-1-4-1h-1c-1 0-1 1-2 1s-1 1-2 1c0 1-1 1-1 1 0 1 0 1-1 1l-4 10c-1 0-1 1-1 1v4c0 1 0 2 1 3l1 1c1 1 1 1 2 1 1 1 2 1 4 1 1 0 2 0 2-1 1 0 2 0 3-1v-1l1-1 5-10c0-1 1-1 1-2v-3c0-1-1-2-2-3 0 0 0-1-1-1l-1-1zm-6 18c0 1-1 1-1 1l-1 1c-1 0-1-1-2-1s-1 0-1-1c-1 0-1-1-1-1v-1c0-1 1-1 1-1l4-10h1v-1h4l1 1v3l-5 10zm29-8h-2l-1 1-6 21v1c0 1 1 1 1 2 1 0 1 0 2-1 0 0 1 0 1-1l6-20c1-1 0-2 0-2 0-1-1-1-1-1zm26 7c-2-1-3-1-4 0h-1c-1 1-1 1-2 1 0 1-1 2-1 2l-1 1v2l-2 10c-1 1-1 1-1 2l1 1v2c1 1 1 2 2 3 1 0 1 0 2 1h5c1 0 2-1 3-1 1-1 1-2 2-2v-2l1-1 2-10v-3c0-1-1-2-1-3-1 0-1-1-2-2 0 0-1 0-2-1h-1zm-1 18v1s0 1-1 1c0 0 0 1-1 1h-2l-1-1s-1 0-1-1v-2l2-10v-1s0-1 1-1c0-1 1-1 1-1h2s1 0 1 1c1 0 1 0 1 1v2l-2 10zm27-15c-1 0-1 0-2 1v1l-2 22v1c1 1 1 1 2 1h1c1-1 1-1 1-2l2-21c0-1 0-1-1-2 0 0 0-1-1-1zm27 1h-4c0 1-1 1-1 1l-1 1c-1 1-1 2-1 3-1 0-1 1-1 1v12c0 1 1 1 1 1v2c0 1 1 1 1 2 1 1 2 1 3 2h1c1 1 2 1 2 1 2 0 3-1 4-1 1-1 2-1 2-2 1-1 1-2 1-3 0 0 1 0 1-1v-1l-1-11v-2c0-1-1-2-1-3-1-1-2-1-3-2h-3zm3 18v2s-1 0-1 1h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-14h1c0-1 1-1 2-1h1l1 1 1 1v12zm27-22c-1 0-2 1-3 1l-1 1c-1 1-1 1-1 2-1 1-1 1-1 2v3l2 10v2s1 0 1 1 1 1 2 2c0 1 1 1 2 1 1 1 1 1 2 1h2c1-1 2-1 3-2s2-1 2-2c1-1 1-2 1-3v-2l-2-11c0-1 0-2-1-2 0-1-1-2-2-2 0-1-1-2-2-2h-4zm7 17v1c0 1 0 1-1 1v1c-1 1-1 1-2 1h-2l-1-1v-1h-1l-1-11-1-1c0-1 1-1 1-1v-1c1 0 1 0 2-1h2c0 1 1 1 1 1v1l1 1 2 10zm19-23s-1 0-1 1v1l6 21c0 1 0 1 1 1 0 1 1 1 1 1l2-2v-1l-6-21s0-1-1-1c-1-1-1-1-2 0zm24-9c-1 0-2 1-3 2v1c-1 1-1 1-1 2v4l1 1 4 10 1 1v1c1 0 2 1 3 1 1 1 1 1 3 1h1c1 0 2 0 2-1 1 0 2-1 3-2s1-2 1-2c1-1 1-2 1-3s-1-1-1-1v-2l-5-9c0-1 0-2-1-3 0 0-1-1-2-1-1-1-2-1-3-1h-2s-1 0-2 1zm11 15v3c-1 1-1 1-2 1 0 1-1 1-1 1-1 0-1 0-2-1l-1-1-4-10-1-1v-1l1-1 1-1c1 0 1-1 2 0h1s1 0 1 1l5 10zm18-30c-1 1-2 2-3 2v2l-1 1v3c1 0 1 1 1 1v1l6 10v1c1 0 1 0 1 1 1 0 2 1 3 1 1 1 2 1 3 1l1-1h2l3-3c0-1 1-2 1-3v-3l-1-1v-1l-6-9c0-1 0-2-1-2l-2-2h-5c-1 0-1 1-2 1zm12 14v1c1 0 1 1 1 1 0 1-1 1-1 2 0 0-1 0-1 1h-3s-1 0-1-1v-1l-6-9v-3l1-1c1 0 2-1 2-1 1 0 1 0 1 1h1l1 1 5 9zm14-32-3 3v6l1 1v1l7 9c1 0 1 0 1 1h1c1 1 2 1 3 1 0 1 1 1 3 0h1c1 0 1-1 2-1 1-1 2-2 2-3 1-1 1-2 1-3s0-2-1-3v-1c-1 0-1-1-1-1l-7-8c0-1-1-2-1-2-1-1-2-1-3-1h-5c0 1-1 1-1 1zm14 13v3s0 1-1 1l-1 1h-2l-1-1-7-9h-1v-3c1 0 1-1 1-1 1 0 2-1 2-1h1c1 0 1 1 1 1h1l7 9zm6-30-1 1c0 1 1 1 1 2l15 15c0 1 1 1 1 1 1 0 2 0 2-1l1-1c0-1-1-1-1-2l-15-15c0-1-1-1-1-1-1 0-2 0-2 1zm15-16c-1 0-1 1-1 1 0 1 1 2 1 2l16 14c1 0 1 1 2 1l1-1c1-1 1-1 1-2 0 0 0-1-1-1l-16-14c0-1-1-1-2-1 0 0-1 0-1 1zm16-22c-1 2-1 3-1 4v3c0 1 1 2 1 2l1 1 1 1 9 6c0 1 1 1 1 1h1c1 1 2 1 3 1s2-1 3-1l1-1c1-1 1-1 1-2 1-1 2-2 2-3v-3c-1-1-1-2-2-2v-1l-1-1-9-6c-1-1-2-1-2-2h-3c-1 0-2 0-3 1-1 0-1 1-1 1-1 0-1 1-2 1zm17 8c0 1 1 1 1 1v4c-1 0-1 1-1 1h-3l-1-1-8-6h-1v-1h-1v-1c0-1 1-1 1-2s1-1 1-1h3l9 6zm-3-29c-1 0-1 1 0 1 0 1 0 1 1 2l19 9c0 1 1 1 2 0 0 0 1 0 1-1v-1c0-1-1-1-1-2l-19-9c-1-1-1-1-2-1-1 1-1 1-1 2zm11-25v5c0 1 0 1 1 2 0 0 1 1 1 2h1c1 1 1 1 2 1l10 4h2c1 1 2 0 3 0s2-1 2-1l2-2v-1c1-2 1-3 1-4s0-2-1-3c0-1-1-1-2-2l-1-1h-1l-10-4c-1 0-1-1-2-1s-2 0-3 1c-1 0-2 0-3 1 0 1 0 1-1 1 0 1 0 2-1 2zm19 4 1 1s0 1 1 1c0 1 0 1-1 2 0 1 0 1-1 1 0 1 0 1-1 1h-2l-10-4-1-1-1-1v-2c1-1 1-1 1-2h3l11 4zm-10-29v2c1 0 1 0 2 1l20 5h2c1 0 1-1 1-1v-2l-1-1-21-6h-2c0 1-1 1-1 2zm6-26c0 1 0 2 1 3v2l1 1 2 2h3l10 2h3c1 0 1 0 2-1 1 0 2-1 3-2v-1c1-1 1-1 1-2v-4l-2-2c0-1-1-1-2-2h-1c0-1-1-1-1-1l-11-2h-2c-1 0-2 1-3 1-1 1-2 1-2 2-1 1-1 1-1 2 0 0 0 1-1 2zm19 0h2c0 1 0 1 1 2v1c-1 1-1 2-1 2l-1 1h-2l-11-2h-1v-1c-1 0-1 0-1-1v-3l1-1h2l11 2zm-15-32c0 1 0 2 1 3 0 1 0 1 1 2l1 1s1 1 2 1c0 0 1 0 1 1h1l11 1h1c1 0 1-1 2-1 0 0 1 0 2-1 1 0 2-1 2-2 0 0 1-1 1-2v-5c-1-1-1-2-2-3-1 0-2-1-2-1h-2l-1-1h-13c-1 0-2 0-3 1l-2 2v2c-1 0-1 1-1 2zm19-2h2v2c1 0 1 1 1 1 0 1 0 1-1 2l-1 1h-2l-10-1h-2l-1-1v-4c1 0 1 0 1-1h2l11 1zm-18-25v1c1 1 1 1 2 1l21-1h2c0-1 1-1 1-2l-1-1c-1-1-1-1-2-1h-21c-1 0-1 1-2 1v2zM926 637c1 1 1 2 2 3 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 2 1h3l11-1h1s1 0 1-1c1 0 2 0 2-1 1-1 1-2 2-3v-3c0-2 0-3-1-4l-2-2c-1 0-2-1-3-1h-2l-11 1c-1 0-2 1-2 1-1 0-2 1-3 2 0 0-1 1-1 2s-1 1-1 2v2zm18-6h1c1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1v2l-1 1h-1c0 1-1 1-1 1l-11 1h-2c0-1 0-1-1-1v-4l1-1h2l10-2zm-23-25c0 1 1 2 2 3 0 1 0 1 1 1l1 1c1 0 2 1 3 1h1c0-1 1-1 1-1l11-2 1-1h1l2-2c1-1 1-2 1-3v-4c0-1-1-2-2-3 0-1-1-1-2-2h-5l-11 3s-1 0-2 1c-1 0-1 1-2 2 0 0-1 1-1 2v4zm17-8h2l1 1s1 1 1 2v1c0 1 0 1-1 1 0 1 0 1-1 1l-11 3h-2s-1 0-1-1l-1-1v-2l1-1s0-1 1-1h1l10-3zm-26-23c0 1 1 2 2 3 0 0 1 0 1 1h1c1 1 2 1 3 1h1c1 0 1-1 2-1l10-3 1-1h1c1-1 1-2 2-3 0 0 1-1 1-2v-2c0-1-1-1-1-2s-1-2-2-3c0-1-1-1-2-2h-5l-11 4s-1 1-2 1l-2 2c0 1-1 2-1 3v2s1 1 1 2zm16-9 1-1h1c0 1 1 1 1 1 1 0 1 1 1 2v2c0 1-1 1-1 1h-1l-10 4h-3c0-1-1-1-1-2v-3h1l1-1 10-3zm-26-16s0 1 1 1h2l19-9c1-1 1-1 1-2v-1c0-1 0-1-1-1-1-1-1-1-2 0l-19 9c-1 0-1 0-1 1-1 1-1 1 0 2zm-10-20c0 1 1 1 1 1h2l18-11c1 0 1-1 2-1 0-1 0-1-1-2 0 0 0-1-1-1h-2l-18 11c-1 0-1 1-1 2-1 0 0 1 0 1zm-14-23c0 1 1 2 2 3h7c0-1 1-1 1-1l9-6c0-1 1-1 1-1s0-1 1-1c0-1 1-2 1-3v-4c-1-1-1-1-1-2-1-1-2-2-3-2-1-1-2-1-3-1h-3s0 1-1 1h-1l-9 7-1 1c-1 1-1 2-2 3v3s0 1 1 1c0 1 0 2 1 2zm13-13h1v-1c1 0 1 0 2 1 0 0 1 0 1 1l1 1v2s-1 0-1 1h-1l-8 6-1 1h-2c-1 0-1-1-2-1v-4l1-1 9-6zm-30-8h3l17-14v-3c-1-1-1-1-2-1h-1l-17 14v4zm-18-20c1 1 2 1 3 2h3c1 0 2 0 3-1l1-1h1l7-8c0-1 1-1 1-1v-1c1-1 1-2 1-3v-3l-1-1c0-1-1-1-1-2-1-1-2-2-3-2h-3c-1 0-2 0-3 1 0 0-1 0-1 1h-1l-7 8-2 2c0 1 0 2-1 3 0 1 0 2 1 3 0 0 0 1 1 1 0 1 0 1 1 2zm10-16h1l1-1h1c1 1 1 1 2 1 0 1 1 1 1 2v1s0 1-1 1v1l-8 7v1h-1v1h-2c0-1 0-1-1-1-1-1-1-1-1-2v-2l1-1 7-8zm-30-2 1 1c1-1 1-1 2-1l13-17c0-1 1-1 0-2v-1c-1-1-1-1-2-1s-1 1-2 1l-13 17v2s0 1 1 1zm-22-15c1 0 2 1 3 1h2s1 0 1-1c1 0 2 0 3-1v-1c1 0 1 0 1-1l6-9 1-1v-4c0-1 0-2-1-3 0 0 0-1-1-1 0-1-1-1-1-1-2-1-3-2-4-2s-2 0-3 1c-1 0-1 0-2 1l-1 1-1 1-6 9c0 1 0 2-1 2v3c0 1 1 2 1 3l1 1 2 2zm7-18 1-1h3l1 1c1 1 1 1 1 2v1c-1 0-1 0-1 1l-6 9v1h-4c0-1-1-1-1-1v-4l6-9zm-35 2c1 1 2 1 3 1h2l1-1c1 0 2-1 2-1l1-1c0-1 1-1 1-1l5-10v-5c0-1 0-2-1-3l-1-1c-1-1-1-1-2-1-1-1-2-1-3-1-2 0-3 0-3 1-1 0-2 0-3 1v1l-1 1-5 10c0 1 0 1-1 2v3c1 1 1 2 2 3 0 0 0 1 1 1 0 0 1 1 2 1zm5-18v-1h1l1-1c1 0 2 0 2 1 1 0 1 0 1 1 1 0 1 1 1 1v1c0 1 0 1-1 1l-4 10h-1v1h-3c-1 0-1-1-2-1v-3l5-10zm-29 9c1 0 1 0 2-1 0 0 1 0 1-1l6-20v-2c0-1-1-1-1-1h-2l-1 1-6 21c-1 0 0 1 0 1 0 1 0 1 1 2zm-26-8c2 1 3 1 4 0h1c1-1 1-1 2-1 0-1 1-2 1-2l1-1v-2l2-10c0-1 1-1 1-2l-1-1v-2c-1-1-1-2-2-3-1 0-1 0-2-1h-5c-1 0-2 1-3 1-1 1-1 2-2 2v2s0 1-1 1l-2 10v3c0 1 1 2 1 3 1 0 1 1 2 2 0 0 1 1 2 1h1zm1-18v-1s0-1 1-1c0 0 0-1 1-1h2l1 1s1 0 1 1v2l-2 10v1s0 1-1 1c0 1-1 1-1 1h-2s-1 0-1-1c-1 0-1 0-1-1v-2l2-10zm-32 14c1 0 2-1 3-1s1 0 2-1c0 0 1 0 1-1 1 0 1-1 1-2 1 0 1-1 1-1v-1l1-11v-3c0-1-1-1-1-2-1-1-2-2-3-2 0-1-1-1-1-1h-6c-1 1-2 1-2 2l-2 2v3l-1 10v3c0 1 1 2 1 2 1 1 1 2 2 2 1 1 1 1 2 1 0 0 1 0 2 1zm-2-19v-1s1 0 1-1l1-1h2s1 0 1 1c1 0 1 0 1 1v2l-1 10v2l-1 1h-3l-1-1-1-1v-1l1-11zm-30 18c1 0 2-1 3-1s1-1 2-1c0 0 0-1 1-1 0-1 1-2 1-3v-14s0-1-1-1c0-1 0-2-1-3l-2-2h-4c-1 0-2 0-3 1-1 0-2 1-3 2 0 0-1 1-1 2v16l2 2c0 1 1 2 2 2s1 0 2 1h2zm-4-19c0-1 0-1 1-1 0-1 0-1 1-1 0-1 1-1 1-1 1 0 2 0 2 1h1v2l1 11v1c0 1-1 1-1 1s0 1-1 1h-3l-1-1v-2l-1-11zm-23 21c1 0 1 0 2-1v-1l-3-22s0-1-1-1c0-1-1-1-1-1-1 0-1 1-2 1v2l3 21v2h2zm-21 4c1 0 1-1 1-1 1-1 1-1 1-2l-5-21-1-1c-1-1-1-1-2 0-1 0-1 0-1 1-1 0-1 1-1 1l5 21c0 1 1 1 1 2h2zm-26 7c1-1 2-1 3-2l1-1c0-1 1-1 1-2v-5l-4-10v-1l-1-1c-1-1-1-2-2-2-1-1-2-1-3-1h-3c-2 1-3 1-4 2 0 1-1 2-1 3s-1 2-1 2c0 1 0 1 1 2v1l3 10c1 1 1 2 2 2 0 1 1 2 2 2 0 1 1 1 2 1h4zm-9-17v-1c0-1 0-1 1-2h1c1-1 1-1 2-1l1 1 1 1 3 11h1v2s-1 0-1 1c0 0-1 0-1 1h-2c-1 0-1 0-1-1-1 0-1 0-1-1l-4-11zm-16 26s1 0 1-1v-2l-9-19c0-1-1-1-1-1-1-1-1-1-2 0-1 0-1 0-1 1v2l9 19c0 1 1 1 1 1 1 1 1 1 2 0zM537 429c1 0 2-1 2-2 1-1 1-1 1-2v-1c1-1 0-2 0-3v-1s0-1-1-1l-5-9c0-1-1-1-1-2h-1c0-1-1-2-2-2h-5s-1 0-1 1c-2 1-3 1-3 2-1 1-1 2-1 3v4l1 1 5 9c1 1 1 2 2 2 0 1 1 2 2 2h5s1 0 2-1zm-12-14-1-1v-1s0-1 1-1c0-1 0-1 1-1 0-1 1-1 1-1h2c0 1 0 1 1 1v1l5 9 1 1v2s-1 1-2 1c0 1-1 1-1 1h-1l-1-1-1-1-5-9zm-11 28 1-1c0-1 0-1-1-2l-12-17c-1-1-1-1-2-1h-1c-1 1-1 1-1 2v1l13 18s0 1 1 1 1 0 2-1zm-22 17c1-1 2-2 2-3s1-1 1-2v-1c0-1 0-2-1-3v-1c-1 0-1-1-1-1l-7-8-1-1-1-1c-1 0-2-1-3-1h-3c0 1-1 1-1 1-1 0-1 1-2 1-1 1-2 2-2 3-1 1-1 2-1 3s1 2 1 3l1 1v1l7 8c1 1 2 1 2 2 1 0 2 0 3 1 1 0 2 0 3-1h2c0-1 1-1 1-1zm-14-12-1-1v-2c0-1 0-1 1-1l1-1h3v1l7 8 1 1v2s0 1-1 1c0 1-1 1-1 1h-3v-1l-7-8zm-9 34c0-1 1-2 1-3 1-1 1-1 1-2v-1c-1-1-1-2-1-3l-1-1s0-1-1-1l-8-7c0-1 0-1-1-1 0 0 0-1-1-1s-1 0-2-1c-1 0-2 1-3 1s-1 0-2 1c0 0-1 0-1 1-1 1-2 2-2 3-1 1-1 2 0 3v3c1 0 1 0 1 1 0 0 1 0 1 1l8 7c0 1 1 1 2 2h6l1-1c1 0 1-1 2-1zm-16-11h-1v-3l1-1 1-1h3v1l8 7 1 1v2c0 1 0 1-1 2 0 0-1 0-1 1h-1c-1 0-1 0-1-1h-1l-8-8zm-2 31v-2s0-1-1-1l-17-13c0-1-1-1-1-1-1 0-1 1-2 1v2s0 1 1 1l17 13c0 1 1 1 1 1 1 0 1 0 2-1zm-16 22c1-1 1-2 1-4v-3c-1 0-1-1-2-2 0 0 0-1-1-1l-1-1-9-5c0-1-1-1-1-1h-1c-1-1-2-1-3-1-1 1-2 1-3 1 0 1 0 1-1 1 0 1-1 1-1 2-1 1-1 2-1 3v3c0 1 1 2 1 3 1 0 1 0 1 1h1l9 6c1 1 2 1 3 1s1 1 2 0c1 0 2 0 3-1 1 0 1 0 2-1 0 0 0-1 1-1zm-17-7c-1 0-1-1-1-1l-1-1v-1c0-1 0-1 1-2 0 0 0-1 1-1h3l9 6 1 1v1c1 0 1 0 1 1l-1 1c0 1-1 1-1 2h-2l-1-1-9-5zm1 35c0-1 1-3 1-4l-1-1v-2l-2-2-1-1h-1l-9-5c-1-1-1-1-2-1h-4s-1 1-2 1l-2 2s0 1-1 1c0 1-1 3 0 4v3c1 0 1 1 2 2l1 1h1l9 5c1 1 2 1 3 1h3s1-1 2-1l2-2s0-1 1-1zm-18-6h-1s0-1-1-1v-3c1 0 1-1 1-1 1 0 1-1 2-1h1c0 1 0 1 1 1l9 5h1l1 1v3c-1 0-1 1-1 1-1 0-1 1-2 1l-1-1h-1l-9-5zm4 35c1-1 1-2 1-3v-2l-1-1c0-1-1-2-2-2 0-1 0-1-1-1l-1-1-10-3c0-1-1-1-1-1h-4c-1 1-2 1-3 2 0 0 0 1-1 1 0 1 0 1-1 2v4c0 1 0 2 1 2 0 1 1 2 1 3h2s0 1 1 1l10 4h5c1 0 2-1 3-2l1-1v-2zm-18-3c0-1 0-1-1-1-1-1-1-1-1-2v-1c1-1 1-2 1-2h2c0-1 0-1 1 0l10 4h2v1l1 1s0 1-1 2c0 0 0 1-1 1 0 0 0 1-1 1h-1l-1-1-10-3zm10 29v-2s-1-1-2-1l-20-6c-1 0-1 0-2 1 0 0-1 0-1 1v2c1 0 1 1 2 1l20 5c1 1 1 0 2 0s1-1 1-1zm-5 22s0-1-1-2c0 0-1 0-1-1l-21-4h-2l-1 1c0 1 0 1 1 2 0 1 0 1 1 1l21 5s1 0 2-1l1-1zm-5 27c1-2 0-3 0-4 0 0 0-1-1-1 0-1 0-1-1-2 0 0-1-1-2-1h-1c0-1-1-1-1-1l-11-1h-2c-1 0-2 0-3 1-1 0-2 1-2 2 0 0-1 1-1 2v1c-1 2 0 3 0 4s1 2 2 3c0 0 1 1 2 1l1 1h1l11 1h2c1 0 2 0 3-1 1 0 2-1 2-2 1 0 1-1 1-1v-2zm-18 0h-2l-1-1v-2c0-1 0-1 1-2h1c0-1 0-1 1-1h1l10 2h2c0 1 1 1 1 1v2c0 1 0 1-1 2l-1 1h-2l-10-2zm16 27v-2c-1-1-1-1-2-1h-23v3c1 1 1 1 2 1l21 1c1 0 1-1 2-1v-1zm1 27c0-2-1-3-1-4-1 0-1-1-1-1l-1-1c-1-1-2-1-3-1h-1l-1-1-11 1h-1c-1 0-1 1-2 1 0 0-1 1-2 1-1 1-1 2-2 3v3c0 2 0 3 1 4 0 1 1 2 2 2 1 1 1 1 2 1h14s1-1 2-1 2-1 2-1c1-1 2-2 2-3l1-1v-2zm-18 4h-2l-1-1c-1-1-1-1-1-2v-2c1 0 1 0 1-1h2l11-1h2c0 1 0 1 1 1v4l-1 1h-2l-10 1zm20 24c0-1 0-1-1-2h-1l-22 2-1 1c0 1-1 1 0 2v1c1 1 1 1 2 1l21-3c1 0 1 0 2-1v-1zm5 26c0-1-1-2-2-3 0 0 0-1-1-1l-1-1c-1 0-2 0-3-1h-1s-1 0-1 1l-11 2h-1s-1 0-1 1c-1 0-2 1-2 1-1 1-1 2-1 3-1 1-1 1-1 2 0 0 0 1 1 2 0 1 0 2 1 3s1 2 2 2 2 1 3 1h3l10-3h2c1-1 2-1 2-2 1-1 2-2 2-3v-4zm-17 7h-2c-1 0-1 0-1-1-1 0-1 0-1-1v-2s0-1 1-1v-1h1l11-2h2s1 0 1 1c0 0 0 1 1 1 0 1 0 2-1 2v1l-1 1h-1l-10 2zm25 25c0-2-1-3-2-3 0-1 0-1-1-1 0-1-1-1-1-1-1 0-2-1-3-1 0 0-1 0-1 1h-1l-11 3h-1c0 1 0 1-1 1l-2 2c0 1-1 2-1 3v3c1 2 1 3 2 4 1 0 2 1 3 1 0 1 1 1 2 1h2s1 0 1-1l10-3c1 0 2 0 2-1 1 0 2-1 2-2 1-1 1-1 1-3 1 0 1-1 1-1-1-1-1-2-1-2zm-16 8h-4v-2c-1-1-1-1-1-2 1 0 1 0 1-1h1c0-1 1-1 1-1l10-3h2s1 0 1 1c0 0 1 0 1 1v2s0 1-1 1v1h-1l-10 3zm25 17s0-1-1-1h-2l-20 8s0 1-1 1v2c0 1 1 1 1 1 1 1 2 1 2 0l20-8c1 0 1 0 1-1v-2zm11 25c0-1-1-2-2-3h-1c-1-1-1-1-2-1h-4l-1 1-9 5c-1 0-1 0-2 1h-1c0 1-1 2-1 3s-1 1-1 3c0 0 0 1 1 1v2l3 3c1 1 1 1 2 1h4c1 0 1-1 2-1l9-5c1 0 2-1 2-1 1-1 1-2 2-3v-4c0-1 0-1-1-2zm-14 11c-1 0-1 1-1 1h-1c-1 0-1 0-2-1l-1-1v-3s1 0 1-1h1l9-5 1-1h1l1 1c1 0 1 0 1 1 1 1 1 1 1 2v1c-1 0-1 1-1 1h-1l-9 5zM437 874c-1-1-1-2-2-2s-1-1-2-1h-5l-1 1-9 6c-1 0-1 1-1 1-1 0-1 0-1 1-1 0-1 1-2 2v3c0 1 0 1 1 2v1c1 2 2 3 3 3 1 1 2 1 3 1h3s0-1 1-1h1l9-6 2-2c0-1 1-1 1-2s1-2 0-3v-2c0-1 0-1-1-2zm-13 13h-1c-1 0-1 1-1 1-1 0-1-1-2-1l-1-1v-4h1l9-6 1-1h1s1 0 1 1c1 0 1 0 1 1 1 0 1 1 1 1v2h-1v1l-9 6zm32 14c-1-1-2-2-3-2l-1-1h-5c0 1 0 1-1 1 0 0-1 0-1 1l-8 6-1 1c-1 0-1 1-1 1-1 1-1 2-1 3v4c1 1 1 1 1 2 1 1 2 2 3 2 1 1 2 1 3 1s2 0 3-1h1l1-1 8-6 2-2c1-1 1-2 1-3 1-1 1-2 0-3v-1c0-1-1-2-1-2zm-13 14h-1c-1 1-1 0-2 0 0 0-1 0-1-1-1 0-1-1-1-1v-2s1 0 1-1l9-7h1v-1h1l1 1s1 0 1 1c1 0 1 1 1 1v1c0 1 0 1-1 1v1l-9 7zm30 7c0-1-1-1-1-1h-2l-16 15v4h4l15-15c0-1 1-1 1-2 0 0 0-1-1-1zm16 16c0-1-1-1-1-1-1 0-1 0-2 1l-15 15v4h4l14-16c1 0 1-1 1-2 0 0 0-1-1-1zm21 17c-1 0-3-1-4-1h-3c-1 0-1 1-2 1l-1 1s-1 0-1 1l-7 8v1c0 1-1 1-1 1v6c1 1 1 1 1 2 1 0 1 0 2 1s2 1 3 1c1 1 2 1 3 0 1 0 2 0 3-1l1-1 7-9c0-1 1-1 1-2 1-1 1-2 1-3s-1-2-1-3l-1-1c0-1-1-1-1-2zm-9 17h-1c0 1 0 1-1 1h-1s-1 0-2-1l-1-1v-2l1-1 7-8v-1h1v-1h1c1 0 1 0 2 1l1 1v3h-1l-6 9zm30-1h-1c-1 0-1 0-2 1l-11 18v2s0 1 1 1h1c1 0 1 0 2-1l11-18s1-1 0-2c0 0 0-1-1-1zm24 14c-2-1-3-1-4-1h-1c-1 0-1 0-2 1-1 0-2 1-2 1 0 1-1 1-1 1s0 1-1 1l-4 10c-1 0-1 1-1 1v4c0 1 1 2 1 3 1 0 1 1 1 1 1 0 1 1 2 1 1 1 3 1 4 1s2 0 3-1c0 0 1-1 2-1 0-1 0-1 1-1v-1l5-10c0-1 1-2 1-2v-3c-1-1-1-2-2-3 0 0 0-1-1-1 0-1-1-1-1-1zm-6 18c0 1-1 1-1 1h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-1c0-1 1-1 1-1l4-10 1-1h1s0-1 1-1c0 0 1 1 2 1 0 0 1 0 1 1v3l-5 10zm31-6c0-1-1-1-2 0 0 0-1 0-1 1l-8 20c-1 0-1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 2-1l8-19v-2c0-1 0-1-1-1zm25 9c-1-1-2-1-3-1s-1 0-2 1h-1l-2 2c0 1-1 1-1 1v2l-3 10c-1 0-1 1-1 1v1c0 1 0 2 1 3 0 1 1 2 1 3 1 0 1 0 2 1h2c1 1 2 1 3 1 1-1 2-1 3-1 1-1 1-2 2-2 0-1 0-1 1-2v-1l3-10c0-1 1-2 1-2 0-1-1-2-1-3s-1-2-2-3l-1-1h-2zm-2 18s0 1-1 1v1h-3c-1 0-1 0-2-1v-3l3-10v-1h1v-1h3c1 0 1 0 1 1 1 0 1 0 1 1v2l-3 10zm33-11h-3c-1 0-1 1-2 1 0 0-1 0-1 1-1 0-1 1-2 2v1s0 1-1 1l-2 11v2c0 1 1 2 1 3l2 2s1 1 2 1c0 0 1 0 1 1h4c1-1 2-1 3-2 0-1 1-1 1-2 1 0 1-1 1-1v-1l2-11c0-1 1-2 0-3v-2c-1-1-1-2-2-2-1-1-1-1-2-1 0-1-1-1-2-1zm0 19v1h-1c0 1-1 1-1 1h-3c-1-1-1-1-1-2v-1l2-11v-1c0-1 1-1 1-1h1c0-1 1-1 1-1 1 1 2 1 2 1l1 1v2l-2 11zm27-15h-2c0 1-1 1-1 2l-1 21v2s1 0 2 1l1-1c1 0 1-1 1-2l2-21s0-1-1-2h-1zm26 1c-1 0-2 0-3 1-1 0-1 0-1 1-1 0-1 0-1 1-1 0-1 1-2 2v15s1 0 1 1 0 2 1 2l2 2c1 0 2 1 2 1h2c2 0 3-1 4-1l2-2c0-1 1-2 1-2v-16c0-1-1-2-2-3 0 0-1-1-2-1 0-1-1-1-2-1h-2zm4 18v2c-1 0-1 1-1 1h-4l-1-1v-14c0-1 0-1 1-1 0 0 1-1 2-1 0 0 1 0 1 1h1c0 1 1 1 1 2v11zm28-20c-1 0-2 1-3 1 0 1-1 1-1 1 0 1-1 1-1 2 0 0-1 1-1 2v3l1 10c0 1 0 1 1 2v1c0 1 1 1 2 2 0 1 1 1 2 2h4c1 0 2-1 3-1l2-2c1-1 1-2 1-3v-3l-1-10c0-1 0-2-1-3 0-1-1-1-1-2-1-1-2-1-3-2h-4zm6 18v2l-1 1h-2c0 1-1 1-1 0h-1l-1-1v-1l-2-11v-1s0-1 1-1v-1h2c1-1 1 0 2 0h1v1l1 1 1 11zm26-23c-1 0-2 1-3 2 0 0-1 0-1 1l-1 1c0 1 0 2-1 3v1l1 1 2 11v1c1 0 1 1 1 1 1 1 1 2 2 2 1 1 2 1 3 1 0 1 1 1 1 1 1 0 2 0 2-1 2 0 3 0 4-1 0-1 1-2 1-3 1 0 1-1 1-2v-3l-3-10c0-1 0-2-1-3 0 0-1-1-1-2-1 0-2-1-3-1h-4zm7 17 1 1v1l-1 1c-1 1-1 1-2 1h-1c-1 0-1 0-2-1v-1l-3-11v-2l1-1h1c1-1 2-1 2 0h1l1 1v1l2 10zm20-24s0 1-1 1v2l6 20c0 1 0 1 1 2h2l1-1v-2l-6-20c0-1 0-1-1-2h-2zm21-7c-1 0-1 1-1 1-1 1-1 1 0 2l8 20s0 1 1 1h2s1 0 1-1v-2l-8-20-1-1h-2zm26-11c-1 1-2 1-3 2 0 1-1 1-1 1v2c-1 1-1 2-1 3 0 0 1 0 1 1v1l5 10v1l1 1 2 2h5s1 0 2-1c1 0 2-1 3-2 0-1 1-1 1-2v-4c0-1-1-1-1-2l-4-9c-1-1-1-2-2-2 0-1-1-2-2-2-1-1-2-1-3-1h-1c-1 0-2 1-2 1zm10 15c0 1 1 1 1 1v1c0 1-1 1-1 1 0 1-1 1-1 1-1 1-1 1-2 1 0 0-1 0-1-1h-1v-1l-5-10v-3s1-1 2-1h3v1l1 1 4 9zm13-28s0 1-1 2c0 0 0 1 1 1l11 19s0 1 1 1h2c0-1 0-1 1-2 0 0 0-1-1-2l-10-18c-1 0-1-1-2-1h-2zm23-14c-1 0-2 1-2 2s-1 1-1 2v4l1 1v1l7 9s0 1 1 1l1 1s1 1 2 1h5c0-1 1-1 1-1 2-1 2-2 3-3 0-1 1-2 1-3s0-2-1-3v-1c-1 0-1-1-1-1l-6-9c-1 0-1-1-2-2-1 0-2 0-3-1h-3s-1 0-1 1c-1 0-1 0-2 1zm13 13h1v3l-1 1c-1 0-1 1-2 1h-1c0-1-1-1-1-1s0-1-1-1l-6-8v-1s-1 0-1-1 0-1 1-1c0-1 0-1 1-2h1c1-1 1-1 2 0h1v1l6 9zm10-31c-1 1-1 1-1 2v2l14 16c0 1 0 1 1 1h2c0-1 0-1 1-2 0 0 0-1-1-2l-13-16c-1-1-1-1-2-1h-1zM915 923c-1 1-1 2-2 3v3c0 1 0 2 1 3 0 0 0 1 1 1v1l8 8s1 0 1 1h1c1 1 2 1 2 1h3c1-1 2-1 2-1 1 0 1-1 2-1 1-1 1-2 2-3v-3c0-1 0-2-1-3 0 0 0-1-1-1v-1l-8-8s-1-1-2-1c-1-1-1-1-2-1h-3c-1 0-1 1-2 1s-1 1-2 1zm15 11c1 0 1 1 1 1v1c1 0 1 1 0 1 0 1 0 1-1 2h-1c0 1-1 1-1 1l-1-1c-1 0-1 0-1-1l-7-7-1-1v-1c-1 0-1-1 0-1 0-1 0-1 1-2h1l1-1c1 0 1 1 1 1h1l7 8zm7-35c-1 1-1 3-1 4 0 0 0 1-1 1 0 1 1 1 1 2s0 1 1 2v1c1 0 1 1 1 1l8 7c1 0 1 1 2 1h1c0 1 1 1 2 1s2 0 3-1c1 0 1 0 2-1 0 0 1 0 1-1 1-1 2-2 2-3v-3c0-1-1-2-1-3 0 0-1 0-1-1l-1-1-8-6-2-2h-6l-1 1c-1 0-1 1-2 1zm16 10c1 0 1 0 1 1h1v2c-1 0-1 1-1 1-1 1-1 1-2 1 0 0 0 1-1 0h-2l-8-7v-1h-1v-2c0-1 0-1 1-2l1-1h2l1 1 8 7zm1-31s-1 1 0 2v1l18 12c1 1 1 1 2 1l1-1c1-1 1-1 1-2-1 0-1-1-1-1l-18-13h-2l-1 1zm15-24c0 2-1 3-1 4v1c0 1 0 1 1 2 0 1 0 2 1 2 0 1 0 1 1 1 0 0 0 1 1 1l9 6h1s1 0 1 1h3c1 0 2-1 3-1 0-1 1-1 1-1 1-1 1-1 1-2 1-1 2-2 2-3s0-2-1-3c0-1-1-2-1-3 0 0-1 0-1-1h-1l-9-6c-1 0-2-1-2-1h-3c-1 0-2 0-3 1-1 0-1 0-1 1-1 0-1 1-2 1zm18 8c1 0 1 0 1 1v3c-1 0-1 1-2 1h-3l-9-6h-1v-4l1-1c1-1 1-1 2-1h1v1l10 6zm-2-36c-1 1-1 2-1 3v3c1 1 1 2 2 3h1c0 1 1 1 1 1l10 5h1l1 1h3c1-1 2-1 3-2l1-1s1-1 1-2 1-2 1-3-1-2-1-3-1-2-2-2c0-1 0-1-1-1 0 0 0-1-1-1l-9-5h-5c-1 0-2 0-3 1-1 0-1 1-1 1-1 1-1 1-1 2zm17 5c1 0 1 1 1 1h1v3c-1 1-1 2-1 2h-3l-10-5h-1v-1h-1v-1c0-1 0-1 1-2 0-1 0-1 1-1 0-1 0-1 1-1h2l9 5zm-5-35c0 1-1 3 0 4v3c1 0 2 1 2 2h1c1 0 1 1 1 1l10 4h6c1 0 1-1 2-2 1 0 1 0 1-1 1 0 1-1 1-2 1-1 1-2 1-3s-1-2-1-3c-1-1-1-2-2-2l-1-1h-1l-10-4c-1-1-2-1-3-1 0 0-1 0-2 1-1 0-2 0-3 1l-1 1c0 1-1 1-1 2zm18 4h1s1 0 1 1v3s0 1-1 1c0 0 0 1-1 1h-1s-1 0-1-1l-10-3-1-1h-1v-3c0-1 1-1 1-2h3l10 4zm-10-30c0 1 0 2 1 2 0 1 0 1 1 1l21 6h1c1-1 1-1 1-2 1 0 0-1 0-1 0-1-1-1-1-1l-21-6h-2s0 1-1 1zm6-22v2s1 1 2 1l20 5c1 0 2 0 2-1 1 0 1-1 1-1v-2s-1-1-2-1l-20-4c-1-1-2 0-2 0-1 0-1 1-1 1zm5-26c-1 1-1 2 0 3 0 1 0 1 1 2v1c1 1 2 1 3 1 0 1 0 1 1 1h1l11 1c0 1 1 1 1 1l1-1c1 0 2 0 3-1 1 0 1-1 2-2l1-1v-6c0-1-1-2-2-2 0-1-1-2-2-2h-1c-1 0-1-1-1-1l-11-1h-3s-1 1-2 1c-1 1-2 1-2 2-1 1-1 1-1 2v2zm18-1h2c0 1 0 1 1 2v1c0 1 0 2-1 2 0 0 0 1-1 1h-2l-10-1h-1c0-1-1-1-1-1l-1-1v-2s0-1 1-1v-1h2l11 1zm-16-27s0 1 1 1c0 1 1 1 1 1l22 2 1-1c1 0 1-1 1-1v-2c-1-1-1-1-2-1l-21-1h-2s-1 1-1 2zm1-27c0 1 0 2 1 3 0 1 0 1 1 1 0 1 0 1 1 1l2 2h15l1-1c1 0 2 0 2-1 1-1 2-1 2-2s1-1 1-2v-2c0-1 0-3-1-4-1 0-1-1-2-2-1 0-2-1-2-1h-16c-1 1-2 1-3 2 0 0-1 1-1 2-1 1-1 1-1 2v2zm18-4h2c0 1 1 1 1 2v3s0 1-1 1h-2l-10 1h-1l-1-1c-1 0-1 0-1-1l-1-1c0-1 0-2 1-2 0-1 0-1 1-1l1-1h11zm-19-25v2c1 0 1 1 2 1l21-2c1 0 1 0 2-1 0 0 1-1 0-1v-2c-1 0-1-1-2 0l-21 1c-1 0-1 0-2 1v1zm-4-26c1 1 1 2 2 3 0 0 0 1 1 1l1 1c1 0 2 1 3 1h2l11-2h1l1-1c1 0 2-1 2-1 1-1 2-2 2-3v-4c0-1-1-2-1-3l-2-2c-1-1-2-1-3-1h-3l-10 2c-1 0-2 0-3 1 0 0-1 1-2 1 0 1-1 2-1 3-1 0-1 1-1 2v2zm18-7h1s1 0 1 1h1c0 1 1 1 1 2v2s-1 0-1 1h-1l-1 1-11 1h-1c-1 0-1 0-1-1-1 0-1 0-1-1v-2s0-1 1-1l1-1 11-2zm-24-25c1 1 1 2 2 3l1 1c1 0 1 0 2 1h5l10-3h1c1 0 1 0 1-1 1 0 2-1 2-2 1 0 1-1 2-2v-4c-1-1-1-2-2-3l-2-2c-1 0-2-1-3-1h-1c-1 1-1 1-2 1l-10 2c-1 1-2 1-2 1-1 1-2 1-2 2-1 1-1 2-2 3v4zm17-8h2c1 0 1 0 1 1 1 0 1 1 1 1v3l-1 1h-1l-10 3h-2c-1 0-1-1-1-1-1 0-1-1-1-1v-3l1-1h1l10-3zm-24-20c0 1 0 1 1 2h2l20-6 2-2v-1c-1-1-1-1-1-2h-2l-21 7s-1 0-1 1v1zm-9-25c1 1 1 2 2 3 1 0 1 0 1 1h2c1 0 2 1 3 0h2l10-4 1-1s1 0 1-1c1 0 1-1 2-2 0-1 1-1 1-3v-1c-1-1-1-2-1-2-1-2-1-3-2-3-1-1-2-1-3-2h-4l-1 1-10 4c-1 0-1 1-2 1l-2 2c0 1-1 2-1 3v2c1 1 1 1 1 2zm16-10h3s1 1 1 2v2c0 1-1 1-1 1s-1 0-1 1l-10 4h-3c0-1 0-1-1-2v-3s1 0 1-1h1l10-4zm-30-21 3 3 1 1h7l9-5c1 0 1 0 1-1h1c1-1 2-2 2-3 0 0 1-1 1-2v-2c-1-1-1-1-1-2-1-1-1-2-2-3s-2-1-3-1-2-1-3 0h-2l-10 5c-1 0-1 1-2 1-1 1-1 2-2 3v6zm16-11h2l1 1s1 0 1 1v3s-1 0-1 1h-1l-9 5h-3l-2-2v-3c1 0 1 0 1-1h1l10-5zm-31-17c1 1 1 2 2 2 1 1 1 1 2 1h5l1-1 10-5c0-1 0-1 1-1l1-1c0-1 1-1 1-2v-5s0-1-1-2c0-1-1-2-2-2-1-1-2-1-3-1h-4l-1 1-9 5c-1 1-2 1-2 2-1 0-1 1-2 2v5s1 1 1 2zm14-12c0-1 1-1 1-1h2c1 1 1 1 1 2 1 0 1 1 1 1v2h-1c0 1-1 1-1 1l-9 5-1 1h-2c0-1-1-1-1-2-1 0-1-1-1-1v-2h1l1-1 9-5zM948 445s1 1 2 1c0 0 1 0 1-1l18-12c0-1 0-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1h-2l-17 13c-1 0-1 1-1 1v2zm-14-18h4l16-13c1-1 1-1 1-2v-2h-2c0-1-1 0-1 0l-17 13c-1 1-1 1-1 2v2zm-17-21c1 1 2 2 3 2h6c0-1 0-1 1-1 0 0 0-1 1-1l7-7 1-1 1-1c0-1 1-2 1-3s0-2-1-3v-2c-1 0-1-1-1-1-1-1-2-2-4-2-1 0-2-1-2 0h-3l-1 1c-1 0-1 1-1 1l-8 7c-1 1-1 1-1 2-1 1-1 2-1 3v3s0 1 1 1c0 1 0 1 1 2zm11-15 1-1h2l1 1 1 1v3h-1l-8 8v1h-2c-1 0-1-1-2-1 0-1-1-1-1-2v-1s0-1 1-1v-1l8-7zm-31-5 1 1c1 0 2-1 2-1l15-16v-3h-4l-14 16c-1 0-1 1-1 2 0 0 0 1 1 1zm-21-18c2 1 3 2 4 2h3c1 0 2-1 2-1 1 0 1-1 1-1l1-1 7-8v-1c1-1 1-1 1-2v-5c-1-1-1-1-1-2-1 0-1-1-2-1-1-1-2-1-3-2h-3c-1 1-2 1-3 2h-1v1l-7 9s-1 1-1 2-1 2-1 3 1 2 1 3l1 1c0 1 1 1 1 1zm9-16s1 0 1-1h4c0 1 0 1 1 2v2c-1 0-1 1-1 1l-6 8-1 1c-1 0-1 1-1 1h-1c-1 0-1-1-2-1l-1-1v-3h1l6-9zm-31 0h1c1 0 1 0 2-1l12-17c0-1 1-1 0-2 0-1 0-1-1-1 0-1-1-1-1-1-1 0-1 1-2 1l-12 18v1c0 1 0 1 1 2zm-23-14c1 0 2 1 3 1h2l1-1c1 0 2-1 3-1v-1c1 0 1-1 1-1l5-10c1 0 1-1 1-1v-4c0-1 0-2-1-3 0 0-1 0-1-1 0 0-1-1-2-1-1-1-2-1-3-1s-2 0-3 1c-1 0-2 0-2 1-1 0-1 1-1 1-1 0-1 1-1 1l-5 9c-1 1-1 2-1 3v3s0 1 1 2c0 1 1 1 1 2 1 0 1 0 2 1zm6-18h1v-1c1 0 1 0 2-1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1v1c0 1-1 1-1 1l-5 10c0 1 0 1-1 1h-3c-1 0-1-1-1-1l-1-1v-2h1l5-10zm-35 3c1 1 3 1 4 1h1c1 0 1-1 2-1l2-2v-1c1 0 1 0 1-1l4-10c1 0 1-1 1-1v-4c-1-1-1-2-2-2 0-1-1-1-1-2-1 0-1 0-2-1h-3c-1 0-2 0-3 1-1 0-2 1-2 1l-1 1c0 1-1 1-1 1l-4 10c0 1 0 2-1 3 0 1 0 2 1 3 0 0 0 1 1 2 0 1 1 1 1 1 1 1 1 1 2 1zm4-18c1 0 1 0 1-1h1s0-1 1-1c0 0 1 0 2 1 0 0 1 0 1 1v1c1 0 0 0 0 1v1l-4 10c-1 0-1 1-1 1-1 0-1 0-1 1-1 0-1-1-2-1s-1 0-2-1v-3l4-10zm-30 8h2l1-1 7-20v-2c0-1-1-1-1-1-1-1-1-1-2 0 0 0-1 0-1 1l-7 20c-1 1-1 1 0 2 0 0 0 1 1 1zm-26-8c2 1 3 1 4 1 0-1 1-1 1-1 1 0 1 0 2-1l2-2v-1s0-1 1-1l2-11v-5l-2-2c-1-1-1-1-2-1l-1-1h-4c-1 0-2 1-3 1-1 1-1 2-2 2v2s-1 0-1 1l-2 10v5c1 1 1 2 2 3 0 0 1 0 1 1h2zm2-18v-1s0-1 1-1l1-1s1 0 2 1h1c0 1 1 1 1 1v2l-3 11v1s-1 0-1 1h-3s-1 0-1-1c0 0-1 0-1-1v-2l3-10zm-33 12h4c0-1 1-1 1-1l1-1 2-2v-1c0-1 0-1 1-2l1-10v-3c0-1-1-2-1-2-1-1-1-2-2-3h-2c0-1-1-1-2-1h-3c-1 1-2 1-3 2 0 1-1 1-1 2s-1 1-1 1v2l-2 10c0 1 0 2 1 3v2l3 3h1c1 1 1 1 2 1zm-1-19s1 0 1-1 1-1 1-1h3c1 0 1 1 1 1l1 1c0 1 0 1-1 1l-1 11v1l-1 1h-4l-1-1v-2l1-11zm-32 15h3c1 0 1-1 2-1l1-1c0-1 1-1 1-2s1-1 1-1v-2l1-10v-3c-1-1-1-2-1-2-1-1-2-2-3-2 0-1-1-1-1-1-1 0-1 0-2-1-2 0-3 1-4 1s-2 1-2 2c-1 0-1 1-2 2v2l-1 11v3c0 1 0 1 1 2s1 2 2 2c1 1 1 1 2 1h2zm-2-18v-1s0-1 1-1c0 0 0-1 1-1h3c0 1 1 1 1 1v2l-1 11v2s-1 0-1 1h-2c-1 0-1 0-1-1-1 0-1 0-1-1-1 0-1 0-1-1l1-11zm-25 18c1 0 1 0 2-1v-23l-1-1c0-1-1-1-2-1 0 0-1 0-1 1-1 0-1 1-1 1l1 22v1c1 1 1 1 2 1zm-23 1h2v-2l-1-22-1-1c-1 0-1-1-2-1l-1 1c-1 1-1 1-1 2l2 21c0 1 0 1 1 2h1zm-26 3c1 0 2 0 3-1l1-1c1 0 1-1 1-1 0-1 1-2 1-3v-2l-2-11v-1l-1-1c0-1-1-2-2-3 0 0-1-1-2-1h-4c-1 0-3 1-3 1-1 1-2 2-2 3-1 0-1 1-1 2v3l2 10c0 1 0 2 1 3 0 1 1 1 1 2 1 1 2 1 3 1 1 1 1 1 2 1 0 0 1 0 2-1zm-7-17v-2c1 0 1-1 1-1 1 0 1-1 2-1h1c1 0 1 1 2 1v2l2 10 1 1s0 1-1 1v1c-1 1-1 1-2 1h-2s-1 0-1-1v-1h-1l-2-11zm-21 23c1 0 1 0 2-1v-2l-5-20c0-1-1-1-1-2h-2s-1 0-1 1c-1 0-1 1-1 2l5 20c1 1 1 1 1 2h2zm-26 7c2 0 3-1 3-2 1 0 1 0 1-1 1 0 1-1 1-1v-5l-4-11v-1l-1-1c0-1-1-1-2-2-1 0-2-1-3-1h-1c-1 0-2 1-2 1-2 0-3 1-3 2-1 0-2 1-2 2v5l4 11s0 1 1 2c0 1 1 1 2 2 1 0 2 1 3 1h1c1 0 2-1 2-1zm-9-16v-2s0-1 1-1c0-1 1-1 1-1h3l1 1v1l4 10v2s0 1-1 1c0 0 0 1-1 1h-3l-1-1v-1l-4-10zm-17 26 1-1v-2l-8-20-1-1h-2l-1 1v2l8 20 1 1h2zm-25 11c1-1 2-2 3-2 0-1 1-1 1-2v-5c0-1 0-1-1-1l-5-10v-1l-1-1c-1-1-2-1-2-1-1-1-2-1-3-1h-2c-1 0-1 1-2 1-1 1-2 1-3 2 0 1-1 2-1 3v3s0 1 1 1v1l5 10s1 1 1 2c1 0 2 1 3 1 1 1 2 1 3 1h1c1-1 2-1 2-1zm-11-15v-1c-1 0-1 0-1-1l1-1 1-1c1 0 1-1 2-1l1 1h1v1l5 10 1 1v2c-1 0-1 1-2 1h-3l-1-1-5-10zm-18 31c1 0 2-1 3-2v-2l1-1v-3c-1 0-1-1-1-1v-1l-6-9c0-1 0-1-1-2h-1c0-1-1-2-2-2h-5l-1 1c-2 1-2 1-3 2s-1 2-1 3v3s0 1 1 1v1l6 10s0 1 1 1l2 2h5c1 0 1 0 2-1zm-12-14v-1c-1 0-1 0-1-1 0 0 0-1 1-1 0-1 0-1 1-1 1-1 1-1 2-1h1c0 1 0 1 1 1v1l6 9v3l-1 1c-1 1-1 1-2 1h-1c-1 0-1-1-1-1l-1-1-5-9zm-11 29c1 0 1-1 1-1v-2l-13-17c0-1-1-1-1-1h-2s-1 1-1 2c0 0 0 1 1 1l12 18h2c0 1 1 0 1 0zM431 381c1-1 2-2 2-3 1 0 1 0 1-1v-2s0-1-1-2v-1c0-1-1-1-1-1l-7-9v-1h-1c-1-1-2-1-3-2h-3c-1 1-1 1-2 1l-1 1-3 3v6s1 0 1 1c0 0 0 1 1 1l6 8c1 1 2 1 2 2 1 0 2 1 3 1h3s1 0 1-1c1 0 2 0 2-1zm-14-12v-1c-1 0-1 0-1-1v-1c1-1 1-1 2-1 0-1 1-1 1-1h2l1 1 7 8v2h1c0 1-1 1-1 1 0 1 0 1-1 2 0 0-1 0-1 1h-2v-1l-1-1-7-8zm-10 34c1-1 2-2 2-3v-6c-1 0-1 0-1-1 0 0-1 0-1-1l-7-7-1-1-1-1c-1 0-2-1-3-1s-2 0-3 1h-2c0 1-1 1-1 1-1 1-2 2-2 4 0 1-1 2 0 2v3c1 0 1 1 1 1 0 1 1 1 1 1l7 8c1 0 2 1 2 1 1 1 2 1 3 1h3c1 0 1 0 2-1l1-1zm-15-11-1-1v-2l1-1 1-1h3v1l8 7 1 1v2c0 1-1 1-1 2-1 0-1 1-2 1h-1l-1-1-8-8zm-7 35c1-2 1-3 2-4v-3c-1-1-1-1-1-2l-1-1c0-1-1-1-1-1l-8-7c-1 0-1-1-1-1h-1c-1-1-2-1-3-1s-2 0-3 1h-2c0 1-1 1-1 2-1 1-1 2-2 3v3c0 1 1 2 1 3 1 0 1 0 1 1 0 0 1 0 1 1l8 6c1 1 2 1 2 2h6c1 0 1-1 1-1 1 0 1-1 2-1zm-16-10s-1 0-1-1v-3c1-1 1-1 2-1 0-1 1-1 1-1 0 1 1 1 1 1h1l8 7 1 1v2s0 1-1 2c0 0 0 1-1 1h-1c-1 0-1 0-1-1h-1l-8-7zm-2 32c1-1 1-1 1-2s-1-1-1-2l-17-13h-2c-1 0-1 0-1 1-1 0-1 1-1 1 0 1 1 2 1 2l17 13h3zm-13 18v-1c0-1 0-2-1-2l-17-12c-1 0-1-1-2 0-1 0-1 0-1 1-1 0-1 1-1 1 0 1 1 1 1 2l18 12h2s1 0 1-1zm-14 23c1-1 1-2 1-3v-2s0-1-1-1c0-1 0-2-1-2 0-1-1-1-1-1 0-1-1-1-1-1l-9-5c-1-1-1-1-2-1h-4s-1 0-2 1c-1 0-1 1-2 1 0 1 0 1-1 2 0 1-1 2-1 3s0 2 1 3c0 1 1 2 1 2 0 1 1 1 1 1l1 1 10 5c0 1 1 1 2 1h3c1 0 2 0 3-1 0 0 0-1 1-1 0-1 1-1 1-2zm-18-6-1-1v-3l1-1 1-1h2v1l10 5h1v1c0 1 1 1 1 1 0 1-1 1-1 2s-1 1-1 1l-1 1h-1l-1-1-10-5zm5 31v-1c0-1-1-1-1-2l-19-9c-1 0-1-1-2 0-1 0-1 0-1 1-1 0-1 1-1 1l2 2 19 9c0 1 1 1 2 0 0 0 1 0 1-1zm-11 25c0-1 1-2 1-4-1 0-1-1-1-1v-1c-1-1-2-2-2-3h-1c-1 0-1-1-1-1l-10-4h-6c-1 0-1 1-2 2-1 0-1 1-1 1-1 1-1 1-1 2-1 1-1 2-1 3s1 2 1 3c1 1 1 2 2 2 0 1 1 1 1 1s1 0 1 1l10 3c1 1 2 1 3 1h2c1-1 2-1 3-2l1-1c0-1 1-1 1-2zm-18-4h-1s-1 0-1-1v-3s0-1 1-1l1-1h1l1 1 10 3 1 1 1 1v2c0 1-1 2-1 2h-1c-1 1-1 1-1 0h-1l-10-4zm8 31c1-1 1-1 0-2 0-1 0-1-1-1l-20-7h-2c-1 1-1 1-1 2v1c0 1 1 1 1 1l21 7h1c1 0 1-1 1-1zm-7 26v-4c0-1 0-1-1-2v-1c-1-1-2-1-2-2h-2l-1-1-10-2h-3c-1 0-2 0-3 1l-2 2-1 1v2c-1 1-1 2 0 4 0 1 0 1 1 2s1 2 2 2c0 0 1 0 1 1h1l11 2h5c1-1 2-1 2-2 1-1 1-1 1-2 1 0 1-1 1-1zm-19-1v-1h-1l-1-1v-2c0-1 0-1 1-2h1c0-1 0-1 1-1 0 0 1 0 1 1l10 2h2v1l1 1v2c-1 0-1 1-1 1l-1 1h-2l-11-2zm12 33c1-1 0-2 0-3s0-1-1-2v-1c-1-1-2-1-3-2h-2l-11-2h-2c-1 0-2 0-3 1-1 0-1 1-2 2l-1 1v2c-1 1 0 3 0 4s1 2 1 2l2 2h2c0 1 1 1 1 1l10 2h3c1 0 2-1 3-1 0-1 1-1 2-2 0-1 1-1 1-2v-2zm-18 0h-2c0-1-1-1-1-2v-1c0-1 0-1 1-2l1-1h2l10 2h2v1s1 0 1 1v2s0 1-1 1c0 1 0 1-1 1h-2l-10-2zm15 27s-1-1-1-2h-1l-22-2s-1 0-2 1v3c1 0 1 1 2 1l21 1h2c0-1 1-1 1-2zm-2 28c0-1 0-2-1-3 0-1 0-1-1-2l-1-1s-1-1-2-1h-1c-1 0-1 0-2-1h-12l-1 1c-1 0-2 0-2 1-1 0-2 1-2 2s-1 1-1 2v2c0 1 0 2 1 3 0 1 1 2 1 3 1 0 2 1 3 1h2l11 1c1 0 2 0 3-1 0 0 1 0 2-1 1 0 1-1 2-2 0-1 0-1 1-2v-2zm-19 3c-1 0-1 0-1-1-1 0-1 0-1-1-1 0-1-1-1-1 0-1 0-1 1-2 0 0 0-1 1-1h14v1h1v4l-1 1h-13zm19 31c0-2 0-3-1-4l-1-1-1-1c-1-1-2-1-2-1h-2s0-1-1-1l-11 1h-2c-1 0-2 1-3 2 0 0-1 1-1 2-1 0-1 1-1 2v1c0 2 0 3 1 4 0 1 1 2 2 2 0 1 1 1 2 2h13c1 0 2-1 3-1s2 0 2-1c1-1 2-2 2-3l1-1v-2zm-18 3h-2c-1 0-1-1-1-1s-1-1-1-2l1-1c0-1 0-1 1-1 0 0 0-1 1-1h13l1 1v4l-1 1h-12zm20 29c0-1 0-2-1-3 0-1 0-1-1-1 0-1-1-1-1-1-1-1-2-1-3-1h-1c0-1-1-1-1-1l-11 2h-2c-1 1-2 1-2 2-1 1-2 2-2 3v3c0 2 0 3 1 4 0 1 1 1 2 2 1 0 2 1 3 1h2l11-1c1-1 1-1 2-1s2-1 2-2c1 0 2-1 2-2v-2c1 0 0-1 0-2zm-17 5h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-2l1-1s1 0 1-1h1l10-1h2c1 0 1 1 1 1 1 0 1 1 1 2v1c0 1-1 1-1 1 0 1-1 1-1 1h-1l-10 1zm21 23s0-1-1-1c0-1-1-1-1-1l-21 4c-1 0-1 0-2 1v1c0 1 0 1 1 2h1l22-3 1-1v-2zm5 23c0-1-1-1-1-2h-2l-21 4c0 1-1 1-1 1-1 1-1 1 0 2v1c1 1 2 1 2 1l21-5c1 0 1 0 2-1v-1zm7 26c-1-1-1-3-2-3l-1-1c-1-1-1-1-2-1h-5l-10 3c-1 0-1 0-1 1h-1c-1 1-2 1-2 2-1 1-1 2-2 3v2c1 0 1 1 1 2s1 2 2 3c0 1 1 1 2 1 1 1 2 1 3 1h2l11-4s1 0 2-1c1 0 1-1 2-2 0 0 1-1 1-3v-3zm-17 8h-1c0 1 0 1-1 0h-1c0-1-1-1-1-2v-3h1c1 0 1-1 1-1l10-3h2c1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 2v1l-1 1h-1l-10 3zm25 19c0-1 0-1-1-2h-1l-21 8s-1 0-1 1v2l1 1h2l20-7c1-1 1-1 1-2 1 0 1-1 0-1zM324 876c-1-1-1-2-2-3-1 0-1-1-2-1h-1c-1-1-2-1-3-1l-1 1h-1l-10 4c-1 0-1 1-1 1h-1c-1 1-2 2-2 3 0 0-1 1-1 2v2c0 1 1 1 1 2s1 2 2 3 2 1 3 1c1 1 1 1 2 1s1 0 2-1h1l10-4s1-1 2-1c1-1 1-2 2-3v-2c1-1 1-1 0-2v-2zm-16 10h-3c0-1-1-1-1-2v-3h1c0-1 1-1 1-1l10-4h3c0 1 0 1 1 2v3h-1l-1 1-10 4zm27 15c0-1 0-1-1-2-1 0-1 0-2 1l-19 10s-1 0-1 1v2c1 0 1 1 2 1h1l19-10c1-1 1-1 1-2 1 0 1-1 0-1zm14 24c-1-1-2-2-3-2 0-1 0-1-1-1h-5c-1 0-1 0-1 1l-10 5-1 1-1 1s-1 1-1 2-1 2-1 3c1 1 1 1 1 2 0 0 0 1 1 2 0 1 1 2 2 2 1 1 2 1 3 1h4l1-1 9-5c1-1 2-1 2-2l2-2v-5s-1-1-1-2zm-14 12-1 1h-2l-2-2v-3s1 0 1-1h1l9-5 1-1h2c0 1 1 1 1 2l1 1c0 1 0 1-1 1v1l-1 1-9 5zm31 16c0-1-1-2-2-3h-2l-1-1c-1 0-2 1-3 1h-1c0 1-1 1-1 1l-9 6c0 1-1 1-1 1s0 1-1 1c0 1-1 2-1 3v4c1 1 1 1 1 2 1 1 2 2 3 2 1 1 2 1 3 1h3s0-1 1-1h1l9-7s1-1 1-2c1 0 1-1 2-2v-3c0-1 0-1-1-2 0 0 0-1-1-1zm-13 13-1 1c-1 0-1 0-2-1 0 0-1 0-1-1l-1-1v-2c1 0 1 0 1-1h1l8-6 1-1h2c1 0 1 1 2 1v4l-1 1-9 6zm30 9s-1 0-1-1c-1 0-1 0-2 1l-17 13v3c0 1 1 1 2 1h1l17-14s1 0 1-1 0-1-1-2zm19 22c-1-1-2-2-3-2-1-1-1-1-2-1h-1c-1 0-2 0-3 1h-1c0 1-1 1-1 1l-8 7-1 1-1 1c0 1-1 2-1 3v3c1 0 1 1 1 1 0 1 1 1 1 2 1 1 2 2 3 2 1 1 2 1 3 1s2-1 3-1l1-1h1l8-8c1 0 1-1 2-1 0-1 0-2 1-3 0-1 0-2-1-3v-2c-1 0-1-1-1-1zm-12 14-1 1h-2c-1 0-1 0-1-1l-1-1v-3h1l8-7 1-1h2s1 0 1 1c1 0 1 1 1 1v2l-1 1-8 7zm34 9c-1-1-2-2-3-2h-3c-1 0-2 0-2 1h-1l-1 1-8 8s0 1-1 1v1c-1 1-1 2-1 3s0 2 1 3v1l2 2c1 1 2 1 3 2h3c1 0 2-1 2-1 1 0 1 0 1-1 1 0 1 0 1-1l8-7c0-1 1-2 1-3 1 0 1-1 1-2s0-2-1-3v-2c-1 0-1-1-2-1zm-10 15c0 1 0 1-1 1h-2s-1 0-1-1c-1 0-1 0-1-1v-2c0-1 0-1 1-1l7-8h1v-1h2l1 1 1 1v3h-1l-7 8zm35 6c-1-1-3-1-4-2h-1c-1 0-1 0-2 1-1 0-1 0-2 1 0 0-1 0-1 1h-1l-7 9v1l-1 1v3c0 1 0 2 1 3 0 0 0 1 1 1 0 1 0 1 1 2s2 1 3 1h3c1 0 2 0 3-1 0 0 0-1 1-1 0 0 0-1 1-1l6-8c1-1 1-2 1-3 1 0 1-1 1-2s0-2-1-3c0-1 0-1-1-2l-1-1zm-9 16c0 1 0 1-1 1v1h-2s-1 0-1-1c-1 0-1-1-1-1l-1-1c0-1 0-1 1-2l7-9c0-1 0-1 1-1h1c1 0 1 0 2 1 1 0 1 0 1 1v3l-7 8zm31 1-1-1c-1 1-1 1-2 1l-12 18v2s0 1 1 1c0 1 1 1 1 1 1-1 1-1 2-1l12-18v-2s0-1-1-1zm19 12h-1c-1 0-1 0-2 1l-11 18v2c0 1 0 1 1 1 0 1 1 1 1 1 1-1 2-1 2-1l11-19s1-1 0-1c0-1 0-1-1-2zm24 14c-1-1-3-1-4-1h-3l-2 2s0 1-1 1v1l-5 10-1 1v4c0 1 1 2 2 3 0 0 0 1 1 1l1 1c2 1 3 1 4 1s2 0 3-1c1 0 1-1 2-1 0-1 1-1 1-1 0-1 0-1 1-2l4-9c1-1 1-2 1-3v-2c0-1-1-2-1-3-1-1-1-1-2-1 0-1-1-1-1-1zm-5 17-1 1c0 1 0 1-1 1h-3l-1-1v-3l5-10v-1h1c0-1 1-1 1-1s1 0 2 1c0 0 1 0 1 1l1 1v1l-1 1-4 9zm30-5c0-1-1-1-1 0-1 0-1 0-2 1l-8 20v1c0 1 1 1 1 1 1 1 1 1 2 0 0 0 1 0 1-1l8-19c1-1 1-2 0-2 0-1 0-1-1-1zm26 10c-1-1-2-1-3-1s-1 1-2 1h-1l-2 2c0 1-1 1-1 1v1l-4 10v3c-1 1 0 2 0 3s1 1 1 2c1 1 1 1 2 1 0 1 1 1 2 1 1 1 2 1 3 1s2-1 3-1c1-1 2-1 2-2l1-1v-1l4-10v-3c1-1 0-2 0-3s-1-1-1-2c-1-1-1-1-2-1 0-1-1-1-2-1zm-3 18v1s-1 0-1 1h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-2l4-10v-1h1v-1h3c1 0 1 1 1 1 1 0 1 1 1 1v2l-4 10zm29-10h-2l-1 1-5 21v2c1 0 1 1 2 1h1c1-1 1-1 1-2l6-21s0-1-1-1c0-1 0-1-1-1zm27 6h-3c-1 0-1 0-2 1 0 0-1 0-1 1-1 0-1 1-2 2v1s0 1-1 1l-2 11v2c0 1 1 2 1 3l2 2c1 0 1 1 2 1h1c2 1 3 1 4 0 1 0 2 0 3-1 0-1 1-1 2-2v-3l2-10c1-1 1-2 1-3-1-1-1-1-1-2-1-1-1-2-2-3h-2c0-1-1-1-2-1zm0 19c0 1-1 1-1 1 0 1 0 1-1 1h-2s-1 0-1-1c-1 0-1 0-1-1v-2l2-10v-1c0-1 1-1 1-1l1-1h2l1 1 1 1v2l-2 11zm32-14h-4c0 1 0 1-1 1l-1 1c-1 1-1 2-2 2v3l-1 10v3c0 1 1 2 1 3 1 0 2 1 2 2h2c1 1 1 1 2 1s3 0 4-1c1 0 1-1 2-1 1-1 1-2 2-3v-2l1-11v-2c0-1-1-2-1-3-1-1-2-2-3-2 0 0 0-1-1-1h-2zm2 18c0 1 0 1-1 1v1l-1 1h-3c-1 0-1-1-1-1s0-1-1-1v-1l1-11v-1h1v-1h1c0-1 1-1 2-1l1 1c1 0 1 0 1 1v12zm26-16h-2v2l-1 21c0 1 0 1 1 2l1 1c1 0 1-1 2-1 0 0 1-1 1-2v-23h-2zm28 0c-1 0-2 0-3 1h-2c0 1 0 1-1 1 0 1-1 2-1 3v16l2 2c0 1 1 1 2 2h2c0 1 1 1 2 1s2-1 3-1c1-1 2-1 3-2 0-1 1-2 1-3v-13c0-1 0-2-1-2 0-1 0-2-1-3 0-1-1-1-2-2h-4zm4 18v1l-1 1-1 1h-3l-1-1v-2l-1-11v-1s1 0 1-1h1c0-1 0-1 1-1h2c0 1 1 1 1 1v2l1 11zM738 1124c-1 1-2 1-3 2-1 0-1 0-1 1-1 0-1 0-1 1-1 1-1 1-1 2v3l1 11v1s1 0 1 1 1 2 1 2c1 1 2 1 3 2h4c1 0 2-1 3-1l2-2c1-1 1-2 1-3v-2l-1-11c0-1-1-2-1-3l-2-2s-1-1-2-1c-1-1-1-1-2-1h-2zm6 18v1s0 1-1 1v1c-1 0-1 1-2 1h-2c0-1 0-1-1-1v-2l-2-11v-2s1 0 1-1h3c1 0 1 0 2 1v1l2 11zm27-23c-1 0-2 1-3 2-1 0-1 0-1 1-1 0-1 0-1 1s-1 2-1 3v2l2 11v1c1 0 1 1 1 1 0 1 1 2 2 2 0 1 1 1 2 2h4c1-1 3-1 3-2 1 0 2-1 2-2 1-1 1-2 1-3v-2l-2-11c0-1 0-1-1-2 0-1-1-2-1-2-1-1-2-1-3-2h-4zm7 18v2c-1 0-1 0-1 1h-5v-2l-2-11-1-1c1 0 1-1 1-1v-1h2c1-1 1-1 2 0h1v1l1 1 2 11zm19-24-1 1v2l6 21s0 1 1 1h2s1 0 1-1v-2l-6-20c0-1 0-1-1-1 0-1-1-1-2-1zm22-6s-1 0-1 1v2l7 20 1 1c1 1 1 1 2 0 0 0 1 0 1-1v-2l-7-20s0-1-1-1h-2zm27-10c-2 1-3 1-3 2l-1 1c0 1-1 1-1 2v4s0 1 1 1l4 10v1l1 1c1 1 1 2 2 2s2 1 3 1h2s1-1 2-1 2-1 3-2c0-1 1-2 1-2v-6l-4-10c-1 0-1-1-2-2 0-1-1-1-2-2h-3c0-1-1 0-1 0h-2zm10 16v2s0 1-1 1l-1 1h-3l-1-1v-1l-4-10h-1v-2c1 0 1 0 1-1 0 0 1 0 1-1h3l1 1v1l5 10zm16-27c-1 0-1 1-2 1v2l10 19c0 1 0 1 1 1 0 1 1 1 2 0l1-1v-2l-10-19c0-1 0-1-1-1h-1zm25-13c-2 1-3 1-3 2s-1 1-1 2v6l5 10c1 0 1 1 1 1s1 0 1 1c1 0 1 1 2 1 1 1 2 1 3 1h2c1-1 1-1 2-1l3-3s1-1 1-2v-3s0-1-1-1v-1l-5-10-2-2c0-1-1-1-2-1-1-1-2-1-3-1h-2l-1 1zm11 15v3l-1 1h-3s-1 0-1-1h-1l-5-10v-3c1 0 1-1 2-1l1-1c1 0 1 1 2 1l1 1 5 10zm12-29c-1 0-1 1-1 1-1 1 0 2 0 2l12 18 1 1h2c0-1 1-1 1-2v-2l-12-17c-1-1-1-1-2-1 0-1-1 0-1 0zm23-16-3 3v6l1 1 7 9v1c1 0 1 1 1 1 1 0 2 1 3 1h4c1-1 2-1 2-1l3-3v-6l-1-1v-1l-7-9-1-1c-1-1-2-1-3-2h-3s-1 1-2 1c0 0-1 0-1 1zm13 13h1v3c-1 0-1 1-2 1l-1 1h-1c-1 0-1-1-1-1-1 0-1 0-1-1l-6-8-1-1v-2c0-1 1-1 1-2h4l1 1 6 9zm12-33c-1 1-2 2-2 3v1c-1 1-1 1-1 2 1 1 1 1 1 2s0 1 1 1v1l8 8c0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 2 1h3c1 0 1-1 2-1l1-1 3-3v-3c0-1 0-2-1-3v-1c-1 0-1-1-1-1l-7-8c-1 0-1-1-2-1-1-1-2-1-3-1-1-1-2 0-3 0h-1l-2 2zm15 11v2c1 0 1 1 0 1 0 1 0 1-1 2h-1c0 1-1 1-1 0h-1c-1 0-1-1-1-1l-7-8h-1v-3l1-1 1-1h2l1 1 8 8zm6-31c-1 1-1 1-1 2s0 1 1 2l15 15 1 1c1 0 2-1 2-1s1-1 1-2l-1-1-15-16h-3zm19-20c-1 1-1 2-2 3v3c0 1 1 2 1 3 0 0 1 0 1 1l1 1 8 7s0 1 1 1h1c1 1 2 1 2 1h3c1 0 1-1 2-1l1-1c1-1 2-2 2-4 1-1 1-2 0-2v-3c-1 0-1-1-1-1l-1-1-8-7-2-2h-3c-1-1-2 0-3 0 0 0-1 0-1 1-1 0-1 1-2 1zm16 10v1c1 0 1 0 1 1v1c0 1 0 1-1 2 0 0-1 0-1 1h-2l-1-1-8-8h-1v-2c0-1 0-1 1-2l1-1h2l1 1 8 7zm5-35c-1 1-1 2-1 4-1 0-1 1-1 1 0 1 1 1 1 2 0 0 0 1 1 2 0 0 0 1 1 1 0 0 0 1 1 1l8 6 1 1s1 0 1 1h3c1 0 2 0 3-1 0 0 1 0 1-1 1 0 1-1 2-1 1-1 1-2 1-3v-3c0-1 0-2-1-3 0 0 0-1-1-1l-1-1-8-6c-1-1-2-1-2-1-1-1-2-1-3-1s-2 0-3 1c-1 0-1 0-2 1l-1 1zm17 9c0 1 1 1 1 1v2s0 1-1 1c0 1-1 1-1 1 0 1-1 1-1 1-1 0-1-1-1-1h-1l-9-7c-1 0-1-1-1-1v-1c0-1 0-1 1-2 0-1 0-1 1-1h3l9 7zm3-36c-1 1-2 2-2 3v2s0 1 1 1c0 1 0 2 1 3l1 1 1 1 9 6h1s0 1 1 1h3c1 0 1 0 2-1 1 0 1 0 2-1l1-1c1-2 1-3 2-4 0-1 0-2-1-3 0-1 0-1-1-2l-1-1-1-1-9-6s-1-1-2-1h-3c-1 0-2 0-3 1h-1c0 1-1 1-1 2zm17 8 1 1v2s0 1-1 1c0 1 0 1-1 1 0 1-1 1-1 1s-1 0-1-1h-1l-9-6v-1h-1v-3l2-2h2l1 1 9 6zm-3-31v2s0 1 1 1l19 11h1c1 0 1-1 2-1v-2c0-1-1-1-1-1l-19-11h-2l-1 1zm11-20v2l1 1 19 10h2l1-1c1-1 1-2 0-2 0-1 0-1-1-1l-19-10h-2l-1 1zm12-25v6c1 1 1 2 2 2l1 1s1 0 1 1l10 4h3c0 1 1 1 2 0 1 0 2 0 3-1l1-1c1-1 1-1 1-2 1-1 1-3 1-4s-1-2-1-3l-2-2h-1c0-1-1-1-1-1l-10-4c0-1-1-1-2-1h-3c-1 0-2 1-3 2l-1 1s0 1-1 2zm18 4h1c0 1 1 1 1 1v3c0 1-1 1-1 2h-3l-10-5h-1s0-1-1-1v-3c1 0 1-1 1-1 1 0 1-1 2-1l1 1h1l9 4zm-7-31v2c0 1 1 1 1 1l20 8h2c1 0 1-1 1-1v-2c0-1 0-1-1-1l-20-8h-2l-1 1zm9-26v5l1 1c0 1 1 2 2 2 0 0 0 1 1 1h1l10 4h5c1-1 2-1 3-2 0-1 1-1 1-1 0-1 1-2 1-2v-4c0-1 0-2-1-3l-2-2h-1c0-1-1-1-1-1l-10-3c-1 0-2-1-3-1s-2 1-2 1c-1 0-2 1-3 2 0 0-1 0-1 1 0 0-1 1-1 2zm19 2v1h1c0 1 1 1 1 2v1c-1 1-1 2-1 2h-1c-1 1-1 1-2 1v-1l-11-3c-1 0-1 0-1-1-1 0-1-1-1-1v-2l1-1 1-1h2l11 3zm-12-28s0 1 1 1c0 1 0 1 1 1l21 5h2c0-1 1-1 1-2 0 0 0-1-1-1 0-1 0-1-1-1l-21-5h-2c0 1-1 1-1 2zM1119 756v4l1 1c0 1 0 1 1 1 0 1 1 2 2 2h1c0 1 1 1 1 1l11 2h2c1 0 2-1 3-1 1-1 2-1 2-2 1-1 1-1 1-2 0 0 1-1 1-2v-3c-1-1-1-2-2-3-1 0-1-1-2-2h-2l-11-2h-3s-1 0-2 1c-1 0-2 1-3 2v1c-1 1-1 1-1 2zm19 0h1v1c1 0 1 1 1 1v3l-1 1h-2l-11-2h-2v-1c0-1-1-1 0-2v-2c1 0 1 0 1-1h2l11 2zm-14-33v3c1 1 1 1 1 2l1 1 2 2h3l10 2h3c1-1 2-1 2-1l3-3v-1c1-1 1-1 1-2s0-3-1-4c0-1 0-2-1-2-1-1-2-1-2-2h-3l-11-2h-2c-1 0-2 1-3 1 0 1-1 1-2 2 0 1 0 1-1 2v2zm19-1c1 0 1 0 1 1 1 0 1 0 1 1v3l-1 1h-2l-11-1h-1c0-1 0-1-1-1v-1s-1-1-1-2c1 0 1-1 1-1 0-1 1-1 1-1h2l11 1zm-17-27 1 1c0 1 1 1 2 1l21 2s1 0 2-1v-3c-1 0-1-1-2-1l-21-1h-2c0 1-1 1-1 2zm1-27c0 1 1 2 1 3s1 1 1 2c0 0 1 0 1 1 1 0 2 1 2 1h15s1 0 1-1c1 0 2 0 3-1 0 0 1-1 1-2 1-1 1-1 1-2v-2c0-1 0-2-1-3 0-1-1-2-2-3 0 0-1-1-2-1h-16l-2 2c-1 0-2 1-2 2s-1 1-1 2v2zm18-4h1c1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 2-1 2v1h-2l-11 1h-2v-1s-1 0-1-1v-3l1-1h1l1-1h10zm-19-30c0 2 0 3 1 4 0 0 1 0 1 1l1 1c1 0 2 1 3 1h2l11-1h2c1 0 2-1 3-2 0 0 1-1 1-2 1-1 1-1 1-2v-2c0-1-1-2-1-3-1-1-1-2-2-2-1-1-2-1-3-1 0-1-1-1-1-1h-1l-11 1c-1 0-2 0-2 1-1 0-2 0-3 1 0 1-1 2-2 3v3zm18-4h2l1 1v3c0 1 0 1-1 1 0 1 0 1-1 1l-11 1h-2v-1h-1c0-1 0-1-1-2 0-1 1-1 1-2v-1h2l11-1zm-21-29c0 1 0 2 1 3 0 1 1 1 1 1 0 1 1 1 1 1 1 1 2 1 3 1h2l11-1h1s1 0 1-1c1 0 2 0 3-1 0-1 1-2 1-3 0 0 0-1 1-1v-2c-1-2-1-3-2-4 0-1-1-1-2-2-1 0-1-1-2-1h-3l-11 1s-1 1-2 1-2 1-2 2c-1 0-1 1-2 2v4zm18-6h1s0 1 1 1l1 1v3s0 1-1 1h-1c0 1 0 1-1 1l-10 1h-2l-1-1s-1-1-1-2v-1c1-1 1-1 1-2h2l11-2zm-23-22c1 0 1 1 1 1 1 1 1 1 2 1l21-4c1 0 1 0 2-1v-1c0-1 0-1-1-2h-2l-21 3-1 1c-1 1-1 1-1 2zm-4-23c0 1 0 1 1 2h1l21-4c1-1 1-1 2-1v-2c0-1 0-1-1-1 0-1-1-1-2-1l-21 5s-1 0-1 1v1zm-7-27c0 1 1 2 1 3 1 1 1 1 2 1 0 1 0 1 1 1s2 1 3 1h1l1-1 10-2c1-1 1-1 2-1h1c1-1 1-2 2-2 0-1 1-2 1-3v-4c-1-1-1-2-2-3l-2-2h-5l-11 3c-1 0-1 0-2 1-1 0-2 1-2 2-1 0-1 1-1 2-1 1-1 1-1 2s1 1 1 2zm17-8h2s0 1 1 1v1c1 1 1 2 1 2l-1 1c0 1-1 1-1 1h-1l-10 3h-2c-1 0-1 0-1-1 0 0-1 0-1-1v-2s0-1 1-1v-1h1l11-3zm-26-18c1 1 1 1 2 1 0 1 1 1 1 1l20-8c1 0 1 0 2-1v-2l-1-1h-2l-20 7c-1 1-1 1-1 2-1 0-1 1-1 1zm-10-26c1 1 2 2 2 3 1 0 1 0 2 1h6l10-4 1-1c1 0 1 0 1-1 1 0 2-1 2-2 1-1 1-2 1-3v-1c0-1 0-2-1-2 0-2-1-3-2-3-1-1-2-1-2-2h-4c-1 0-1 1-2 1l-10 4s-1 1-2 1c0 1-1 1-1 2-1 1-1 2-1 3v4zm16-10h1c0-1 1-1 1-1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 2 1 2l-1 1c0 1 0 1-1 1h-1l-9 5h-2c-1 0-1 0-1-1-1 0-1 0-2-1v-2s0-1 1-1v-1h1l10-4zm-27-16 1 1h2l19-9c1 0 1-1 1-1 1-1 1-2 0-2 0-1 0-1-1-1-1-1-1-1-2 0l-19 9c-1 0-1 1-1 1v2zm-13-25c1 1 1 2 2 3h2l1 1h3s1 0 1-1h1l10-5 1-1 1-1s1-1 1-2c1-1 1-2 1-3v-2c-1 0-1-1-1-1-1-2-2-3-3-3 0-1-1-1-2-1-1-1-2-1-3 0h-2l-10 6c-1 0-1 0-2 1s-1 1-1 2c-1 1-1 2-1 3v2c0 1 1 1 1 2zm15-12h3c0 1 1 1 1 2v3h-1v1l-10 5h-3l-1-1c0-1-1-1 0-2-1 0 0-1 0-1 0-1 0-1 1-1v-1l10-5zm-31-16c0 1 1 2 2 2 1 1 1 1 2 1h5c0-1 1-1 1-1l9-6c1 0 1-1 1-1s1 0 1-1c1 0 1-1 1-2 1-1 1-2 1-3-1-1-1-1-1-2 0 0 0-1-1-1-1-2-1-3-2-3-1-1-2-1-3-1h-3l-1 1h-1l-9 6c-1 1-2 1-2 2-1 1-1 1-1 2-1 1-1 2-1 3s0 2 1 2c0 1 0 1 1 2zm13-13h1s0-1 1-1l1 1c1 0 1 0 1 1 1 1 1 1 1 2v1l-1 1-9 6-1 1h-2l-2-2v-3l1-1 9-6zm-29-11c0 1 0 1 1 1h2l17-13c1 0 1-1 1-1v-2c-1 0-1-1-2-1 0 0-1 0-2 1l-17 12c0 1-1 1-1 2 0 0 0 1 1 1zm-18-22c1 1 2 2 3 2 1 1 1 1 2 1h1c1 0 2 0 3-1h1l1-1 9-7h1v-1c1-1 1-2 1-3 1-1 1-2 0-3v-2c-1 0-1-1-1-1l-3-3h-6l-1 1s-1 0-1 1l-8 6c-1 1-2 1-2 2-1 1-1 2-1 3v4c1 1 1 1 1 2zm13-14h1v-1h2c0 1 1 1 1 2 1 0 1 1 1 1v1c0 1 0 1-1 1v1l-9 7h-1v1c-1 0-1-1-2-1l-1-1-1-1v-2s1 0 1-1l9-7zm-34-11c1 1 2 2 3 2 1 1 1 1 2 1h1c1 0 2-1 3-1 0 0 1 0 1-1h1l8-8 1-1v-1c1-1 1-2 1-3v-3l-1-1c0-1-1-1-1-2-1-1-2-1-3-2h-3c-1 0-2 0-3 1h-1c0 1-1 1-1 1l-7 8c-1 0-2 1-2 2 0 0-1 1-1 2v3c1 1 1 1 1 2l1 1zm11-15h1s1 0 1-1c0 0 1 0 1 1h2c0 1 1 1 1 2v1s0 1-1 1v1l-8 7-1 1h-2s-1 0-1-1c-1 0-1-1-1-1v-2l1-1 7-8zm-34-8c1 1 2 1 3 2h3c1 0 2-1 2-1 1 0 1-1 1-1 1 0 1 0 1-1l8-7v-2c1 0 1 0 1-1 0 0 1-1 1-2s0-2-1-3v-2c-1 0-1-1-2-1-1-1-2-2-3-2h-3c-1 0-2 0-2 1h-2v1l-8 8c0 1-1 1-1 2-1 1-1 2-1 3s0 2 1 3v1l2 2zm10-16 1-1h2l1 1 1 1v3h-1l-7 8-1 1h-2s-1 0-1-1c-1 0-1 0-1-1 0 0-1-1 0-1v-2l8-8zM948 279c1 0 1 1 2 1s1-1 2-1l13-17c1 0 1-1 1-1 0-1 0-1-1-2h-1c-1 0-2 0-2 1l-14 16v3zm-18-14h2c1 0 1 0 2-1l13-17v-1c0-1 0-1-1-2h-1c-1 0-2 0-2 1l-13 17v3zm-23-16c2 0 3 1 4 1h3c1-1 2-1 2-2h1c0-1 1-1 1-1l6-9c0-1 1-1 1-1v-1c1-1 1-2 1-3-1-1-1-2-1-3-1-1-1-1-1-2-1 0-1 0-2-1s-2-1-3-1h-3c-1 0-2 1-3 1 0 1 0 1-1 1v1l-6 9-2 2v3c0 1 0 2 1 3l1 1c0 1 1 1 1 2zm8-17 1-1 1-1h1c1 0 1 1 2 1l1 1v3h-1l-6 9v1h-1l-1 1c-1 0-1-1-2-1s-1-1-1-1v-3l6-9zm-30 2c0 1 1 1 1 1 1-1 1-1 2-1l10-19v-2c0-1 0-1-1-1 0-1-1-1-2 0 0 0-1 0-1 1l-10 18c-1 1-1 1 0 2 0 1 0 1 1 1zm-25-13c1 1 2 1 3 1h2s1 0 1-1c1 0 2-1 2-1l1-1c0-1 1-1 1-1l5-10v-5c0-1 0-2-1-3l-1-1c-1 0-1-1-2-1-1-1-2-1-3-1-2 0-3 0-3 1-1 0-2 1-3 1v1l-1 1-5 10c0 1 0 2-1 2 0 1 0 2 1 3 0 1 0 2 1 3l1 1c1 1 1 1 2 1zm5-18 1-1s1 0 1-1c1 0 1 1 2 1s1 1 1 1c1 0 1 1 1 1v1c0 1 0 1-1 1l-4 10-1 1c-1 0-1 1-2 1l-1-1c-1 0-1 0-2-1v-3l5-10zm-31 7h2c0-1 1-1 1-2l8-19c1-1 1-1 0-2 0-1 0-1-1-1 0-1-1-1-1 0-1 0-1 0-2 1l-8 20v1c0 1 1 1 1 2zm-26-11c1 1 2 1 4 1h1c0-1 1-1 1-1 1-1 2-1 2-2 1 0 1-1 1-1s0-1 1-1l3-10c0-1 1-1 1-1v-2c0-1 0-2-1-2 0-1 0-2-1-3-1 0-1-1-2-1l-1-1c-2 0-3-1-4 0-1 0-2 0-3 1-1 0-1 1-2 1v1c-1 1-1 1-1 2l-4 10v5c1 1 1 2 2 3 0 0 1 0 1 1h2zm3-18 1-1c1-1 1-1 2-1h1c1 1 1 1 2 1v3l-4 10v2h-2c0 1-1 0-2 0 0 0-1 0-1-1 0 0-1 0-1-1v-1l1-1 3-10zm-34 9h5c1-1 1-1 2-1 0-1 1-1 1-2l1-1v-1l3-11v-5c-1-1-1-2-2-3h-2c0-1-1-1-2-1s-2-1-3 0c-1 0-2 0-3 1l-2 2v1l-1 1-2 11c-1 1-1 2-1 2 0 1 1 2 1 3s1 2 2 2c0 1 1 1 1 1 1 1 2 1 2 1zm2-18v-2c1 0 1-1 2-1h1c1 0 2 1 2 1s0 1 1 1v2l-3 10v2h-1l-1 1h-2l-1-1c-1 0-1-1-1-1v-2l3-10zm-29 12s1 0 2-1v-1l4-21c1-1 0-1 0-2l-1-1c-1 0-1 0-2 1 0 0-1 0-1 1l-4 21v2c1 0 1 1 2 1zm-28-5h4s1 0 1-1c1 0 1 0 1-1 1 0 2-1 2-2v-1l1-1 1-11v-2c0-1 0-2-1-3 0-1-1-2-2-2 0-1-1-1-2-1h-1c-2-1-3-1-4 0-1 0-2 1-3 1 0 1-1 2-1 3 0 0-1 0-1 1v1l-1 11v2c0 1 0 2 1 3 0 1 1 1 2 2l1 1h2zm0-18v-2l1-1h4v1c1 1 1 1 1 2l-2 11v1c0 1 0 1-1 1l-1 1h-1c-1 0-1 0-2-1 0 0-1 0-1-1v-2l2-10zm-33 15h3c1-1 1-1 2-1 0-1 1-1 1-1 1-1 1-2 1-3 1 0 1 0 1-1v-1l1-11v-2c0-1-1-2-1-3-1-1-2-1-3-2 0 0-1 0-1-1h-2c-2 0-3 0-4 1-1 0-2 1-2 1-1 1-1 2-2 3v2l-1 11v2c0 1 1 2 1 3l2 2c1 0 1 0 2 1h2zm-2-19c0-1 1-1 1-1 0-1 0-1 1-1h3c1 0 1 1 1 1v2l-1 11v2h-1s-1 1-2 1c0-1-1-1-1-1-1 0-1-1-1-1-1 0-1-1-1-1v-1l1-11zm-30 18h3c1-1 1-1 2-1 0-1 0-1 1-1 0-1 1-2 1-3v-14c0-1 0-1-1-2 0 0 0-1-1-2l-2-2h-7c-1 1-2 2-3 2 0 1-1 2-1 3v16c1 0 1 1 2 2 0 1 1 1 2 2h4zm-4-18v-1l1-1 1-1h3l1 1v2l1 11v1c-1 0-1 1-1 1l-1 1h-3c0-1-1-1-1-1v-1l-1-1v-11zm-24 20 1-1c1-1 1-1 1-2l-2-21c0-1 0-1-1-2h-1c-1 0-1 0-2 1v1l1 22 1 1c1 1 1 1 2 1zm-23 2c1 0 1 0 2-1v-2l-3-21s0-1-1-1c0-1-1-1-1-1-1 0-1 1-2 1v2l3 21v2h2zm-28 4c2 0 3 0 4-1 0 0 0-1 1-1 0-1 0-1 1-1v-6l-2-10v-3c-1 0-1-1-2-2-1 0-2-1-3-1h-4c-1 0-2 0-3 1s-1 2-2 2c0 1-1 2-1 3v3l2 10c1 1 1 2 1 3 1 0 1 1 2 2 1 0 2 1 3 1h3zm-6-17v-2s0-1 1-1c0-1 1-1 1-1h2l1 1s1 0 1 1v1l2 10v2c0 1-1 1-1 1s-1 1-2 1h-1c-1 0-1-1-1-1-1 0-1 0-1-1v-1l-2-10zm-21 23s1 0 1-1c0 0 1-1 0-2l-5-20c0-1 0-1-1-2h-1c-1 0-1 0-2 1v2l5 21 1 1h2zm-27 8c1-1 2-1 3-2 0 0 0-1 1-1 0-1 0-1 1-2v-5l-3-10c0-1-1-1-1-1v-1l-2-2c-1-1-2-1-3-1-1-1-1-1-2 0h-2c-1 0-2 1-3 2-1 0-1 1-2 2v5l3 11s1 1 1 2l2 2c1 0 2 1 3 1h4zm-9-17v-2l1-1s1-1 2-1h1c1 0 1 0 1 1h1v1l3 11h1v2c-1 0-1 0-1 1h-2c0 1-1 1-1 1l-1-1c-1 0-1-1-1-1v-1l-4-10zm-18 26c1 0 1-1 1-1 1-1 1-1 0-2l-7-20c0-1 0-1-1-2h-2c0 1-1 1-1 1v2l7 20c0 1 1 1 1 2h2zm-25 10c1-1 2-1 3-2 0-1 1-1 1-1v-2c1-1 1-2 0-3v-2l-5-10v-1c-1 0-1-1-1-1-1-1-2-1-2-2h-5c-1 0-1 0-2 1-1 0-2 1-3 2 0 1-1 2-1 2v6l5 9c0 1 1 2 1 2 1 1 2 2 3 2 0 1 1 1 3 1h1c1 0 2-1 2-1zm-10-15-1-1v-1s0-1 1-1c0-1 0-1 1-1 1-1 1-1 2-1l1 1h1v1l5 10v3c-1 0-1 1-2 1h-3v-1l-1-1-4-9zm-20 30 3-3 1-1v-5c0-1-1-1-1-2l-5-9c0-1 0-1-1-1v-1c-1-1-2-1-3-2h-4c-1 0-2 1-2 1-1 1-2 1-3 2s-1 2-1 3v4l1 1 5 10s1 1 1 2c1 0 2 1 3 1 0 1 1 1 3 1h1c1-1 1-1 2-1zm-11-15c-1 0-1-1-1-1v-1s0-1 1-1c0 0 0-1 1-1s1-1 2-1l1 1h1v1l5 10h1v2s-1 0-1 1l-1 1h-3s-1 0-1-1l-5-10zm-14 29 2-2s0-1-1-1l-11-19s0-1-1-1h-2c0 1-1 1-1 2v1l11 19c1 0 1 1 2 1h1zM394 260c1-1 2-2 2-3 1 0 1-1 1-1v-4c0-1 0-1-1-1v-2l-6-9s-1 0-1-1h-1l-2-2h-5c-1 1-1 1-2 1-1 1-2 2-2 3-1 1-1 2-1 3v3l1 1v1l6 9 2 2c1 0 1 1 2 1h5c1 0 1-1 2-1zm-13-14-1-1c0-1 0-1 1-2 0 0 0-1 1-1l1-1c1 0 1 0 2 1h1v1l6 9 1 1v1s0 1-1 1c0 0 0 1-1 1 0 1-1 1-1 1h-2v-1l-1-1-6-9zm-13 33c1-1 2-2 2-3v-1c0-1 1-1 1-2-1-1-1-2-1-3l-1-1v-1l-7-8-1-1-1-1c-1 0-2-1-2-1h-4l-1 1c-1 0-1 1-2 1-1 1-2 2-2 3s-1 2-1 3 1 2 1 2v2c1 0 1 0 1 1l7 8 2 2c1 0 1 0 2 1h3c1 0 1-1 2-1s1-1 2-1zm-14-12c-1 0-1-1-1-1v-2c0-1 1-1 1-2h4v1l7 8 1 1v2c0 1-1 1-1 2h-4l-1-1-6-8zm-12 34c1-1 2-2 2-3s0-1 1-2v-1c0-1-1-2-1-3 0 0 0-1-1-1v-1l-8-8s0-1-1-1l-1-1s-1 0-2-1c-1 0-2 0-3 1h-2c0 1-1 1-1 1-1 1-2 2-2 3-1 1-1 2-1 3s0 2 1 3v1l1 1 7 8c1 1 2 1 2 2 1 0 2 1 3 1h3c0-1 1-1 1-1 1 0 2-1 2-1zm-15-12v-1c-1-1 0-1 0-2 0 0 0-1 1-1 0-1 1-1 1-1h2l1 1 7 8 1 1v2s0 1-1 1c0 1-1 1-1 1h-3v-1l-8-8zm-5 31v-3l-16-15c0-1 0-1-1-1s-1 0-2 1v3l15 15c1 1 1 1 2 1s1 0 2-1zm-16 17v-3l-16-15c-1 0-1 0-2-1 0 1-1 1-1 1-1 1-1 1-1 2 0 0 0 1 1 1l16 15h3zm-19 21c1-1 2-2 2-3v-3c0-1-1-2-1-3l-1-1-1-1-8-6c0-1-1-1-1-1l-1-1h-6c0 1-1 1-1 1l-2 2c-1 1-1 2-1 3-1 1-1 2 0 3 0 1 0 2 1 2v1l1 1 9 7c0 1 1 1 2 1 1 1 1 1 2 1s2 0 3-1h2c0-1 1-1 1-2zm-16-9v-1c-1 0-1 0-1-1v-1c0-1 0-1 1-2 0 0 1 0 1-1h1c1 0 1 0 2 1l8 7h1v1c1 0 1 0 1 1v1l-1 1-1 1c-1 1-1 1-2 1 0 0 0-1-1-1l-9-7zm-1 31s1-1 0-1v-2l-18-13h-1c-1 0-1 0-2 1v1c0 1 0 2 1 2l17 13h2s1 0 1-1zm-15 23c0-1 1-3 1-4v-1c0-1 0-1-1-2 0-1 0-1-1-2l-1-1-1-1-9-5-1-1h-1c-1-1-2-1-3-1-1 1-2 1-3 1 0 1-1 1-1 2-1 0-1 1-1 1-1 1-2 2-2 4 0 1 0 2 1 2 0 1 0 2 1 3 0 0 1 0 1 1 0 0 1 0 1 1l9 5c1 1 2 1 2 1h3c1 0 2 0 3-1 1 0 1 0 1-1 1 0 1-1 2-1zm-18-7v-1c-1 0-1 0-1-1v-3c1 0 1-1 1-1h4l9 6 1 1v3c-1 1-1 1-1 2h-3v-1l-10-5zm3 31v-2s0-1-1-1l-19-11h-1c-1 0-2 1-2 1v2c0 1 1 1 1 1l19 11h2l1-1zm-14 25c1-2 1-3 1-4v-3l-2-2-1-1s-1 0-1-1l-10-4c0-1-1-1-1-1h-4c-1 0-2 1-3 1 0 1 0 1-1 2l-1 1c0 2-1 3-1 4s1 2 1 3 1 1 2 2l1 1h1l9 5c1 0 2 1 3 1h2c1 0 2-1 3-1 1-1 1-1 1-2 1 0 1-1 1-1zm-17-6h-1s-1 0-1-1v-3c1 0 1-1 1-1 1 0 1-1 1-1h2v1l10 5h1s0 1 1 1v1s0 1-1 2c0 0 0 1-1 1l-1 1s-1 0-1-1h-1l-9-5zm3 36c1-1 1-2 1-3v-2l-1-1c0-1-1-2-2-3h-1s0-1-1-1l-10-4-1-1h-4c-1 1-2 1-2 2-1 0-1 1-2 1 0 1 0 1-1 2v3c0 1 0 2 1 3 0 1 1 2 1 2l1 1c1 0 1 1 1 1l10 4c1 0 2 1 3 1s1 0 2-1c1 0 2 0 3-1 1 0 1-1 1-1 1-1 1-1 1-2zm-18-4s0-1-1-1c-1-1-1-1-1-2 0 0 0-1 1-1v-2h4l10 4v1h1v2c1 0 0 1 0 1 0 1 0 1-1 2h-3l-10-4zm8 30v-1l-2-2-20-7h-1c-1 0-1 1-2 1 0 1 0 1 1 2 0 0 0 1 1 1l20 8h2c0-1 1-1 1-2zm-9 27v-5l-1-1c-1-1-1-2-2-2 0-1-1-1-1-1s-1 0-1-1l-10-3h-6l-2 2c-1 0-1 1-1 1-1 1-1 1-1 2s-1 3 0 4c0 1 0 2 1 2 0 1 1 2 2 2 0 1 0 1 1 1 0 0 1 0 1 1l10 3h5c1 0 2-1 3-2l1-1c0-1 0-1 1-2zm-19-3h-1v-1c-1 0-1 0-1-1v-2l1-1 1-1h2l10 4h2v1s0 1 1 1c0 0 0 1-1 2v1c-1 0-1 1-2 1h-2l-10-4zm10 34v-3c0-1 0-1-1-2v-1c-1-1-2-1-3-2h-1c0-1 0-1-1-1l-10-2h-6c0 1-1 1-2 2 0 1-1 1-1 2v2c-1 1-1 2 0 3 0 1 0 2 1 3 0 1 1 1 2 2h1c1 0 1 1 1 1l11 2h2c1 0 2 0 3-1 1 0 2-1 2-2 1 0 1 0 1-1 1 0 1-1 1-2zm-19-1h-1v-1c-1 0-1 0-1-1v-1c0-1 0-2 1-2 0 0 0-1 1-1h2l10 3h2v1c1 1 1 1 1 2-1 1-1 1-1 2-1 0-1 0-1 1h-2l-11-3zm12 34v-4s-1 0-1-1c0 0 0-1-1-1 0-1-1-1-2-2h-1l-1-1-11-2h-2c-1 1-2 1-3 1-1 1-2 1-2 2-1 1-1 1-1 2 0 0 0 1-1 2 0 1 0 2 1 3 0 1 0 2 1 3l2 2h3l10 2h3c1 0 1 0 2-1 1 0 2-1 3-2v-1c1-1 1-1 1-2zm-19 0c-1 0-1 0-1-1-1 0-1 0-1-1v-3c1 0 1-1 1-1h2l11 2h1c1 0 1 0 1 1v1c1 0 1 1 1 1-1 1-1 1-1 2l-1 1h-2l-11-2zm15 28c0-1 0-1-1-2 0 0-1 0-1-1l-22-2h-1c-1 1-1 1-1 2v1c1 1 1 1 2 1l21 3c1 0 1 0 2-1 0 0 1 0 1-1zm-3 23v-2c-1 0-1-1-2-1l-21-1h-2c0 1-1 1-1 2 0 0 0 1 1 1 0 1 1 1 1 1l22 2s1 0 1-1c1 0 1-1 1-1zm-2 28v-4l-1-1-1-1c-1-1-2-1-3-1 0-1 0-1-1-1h-14c-1 0-2 1-3 1 0 1-1 2-2 3v3c-1 2 0 3 0 4 1 1 1 2 2 2 1 1 2 1 2 2h16c1 0 2-1 3-1 0-1 1-2 2-3v-3zm-18 3-1-1h-1s0-1-1-1v-3l1-1 1-1h1l11 1h2s0 1 1 1v3l-1 1-1 1h-12zm18 25s0-1-1-1c0-1-1-1-1-1h-22l-1 1c-1 1-1 1-1 2 0 0 0 1 1 1 0 1 1 1 1 1l22-1h2v-2zM169 734c0-1 0-2-1-3 0-1 0-1-1-1 0-1-1-1-1-1-1-1-2-1-3-1 0-1 0-1-1-1h-1l-11 1h-1s-1 0-1 1c-1 0-2 0-3 1 0 1-1 2-1 3l-1 1v2c0 2 1 3 1 4 1 1 2 1 2 2 1 0 2 1 3 1h2l11-1h3l2-2c1 0 1-1 2-2v-4zm-18 5h-1l-1-1s-1 0-1-1v-3s0-1 1-1h2l10-1h2c1 0 1 1 1 1s1 1 1 2c0 0 0 1-1 1v1l-1 1h-1l-11 1zm20 24v-2c-1 0-1-1-2 0l-21 2c-1 0-1 0-2 1v2s0 1 1 1l1 1 22-3s1 0 1-1c0 0 1-1 0-1zm4 28c0-2-1-3-1-4l-1-1c-1 0-1-1-1-1-1 0-2-1-3-1h-3l-10 2h-1c-1 0-1 1-2 1l-2 2s-1 1-1 2 0 1-1 2c0 0 0 1 1 2 0 1 0 2 1 3s1 2 2 2c1 1 2 1 3 1h2l11-2c1 0 2 0 2-1 1 0 2 0 2-1 1-1 2-2 2-3v-3zm-17 6h-1c-1 0-1 0-1-1h-1c-1-1-1-1-1-2v-2l1-1h2l10-2h2c1 0 1 0 1 1 0 0 1 0 1 1v2c-1 0-1 1-1 1s-1 0-1 1h-1l-10 2zm23 27c0-2 0-3-1-4 0 0-1 0-1-1-1 0-1 0-2-1h-5l-10 2h-1c-1 0-1 1-2 1l-2 2s-1 1-1 2v4c0 1 1 3 1 3 1 1 2 2 3 2 1 1 2 1 2 1h3l11-2c0-1 1-1 2-1l2-2c1-1 1-2 1-3l1-1c0-1-1-2-1-2zm-17 6c0 1-1 1-1 1l-1-1h-1c0-1-1-1-1-2v-2s1 0 1-1h1l1-1 10-2h2c1 0 1 1 1 1s1 1 1 2v1c0 1 0 1-1 1 0 1 0 1-1 1l-11 2zm24 21c0-1-1-1-1-1-1-1-1-1-2-1l-21 6s-1 0-1 1v2s0 1 1 1h2l20-5c1 0 1-1 2-1v-2zm8 27c-1-1-1-2-2-3l-1-1c-1 0-1 0-1-1h-6l-10 3c0 1-1 1-1 1s-1 0-1 1c-1 0-2 1-2 2-1 0-1 1-1 2v4c1 1 1 2 2 3s2 1 2 2h6l10-3c1-1 1-1 2-1l2-2c1-1 1-2 1-3v-4zm-17 9h-2s0-1-1-1c0 0 0-1-1-1v-2l1-1s0-1 1-1l11-3 1-1h1c0 1 0 1 1 1 0 0 0 1 1 2v1c0 1 0 1-1 1 0 1 0 1-1 1l-11 4zm28 23c0-1-1-2-2-3l-1-1c-1 0-1-1-2-1h-5l-10 4s-1 0-1 1h-1c-1 1-1 2-2 2 0 1-1 2-1 3v2c0 1 0 1 1 2 0 1 1 2 2 3 0 1 1 1 2 2h4c1 0 1-1 1-1l11-3c0-1 1-1 2-2l2-2s0-1 1-3v-1c-1-1-1-1-1-2zm-16 9h-3c-1-1-1-1-1-2v-3h1l1-1 10-3 1-1h1c0 1 1 1 1 1s0 1 1 1v3l-1 1h-1l-10 4zm28 21c0-1-1-2-2-3l-1-1h-2c-1 0-1-1-2 0h-3l-9 5c-1 0-1 0-2 1h-1c0 1-1 2-1 3-1 0-1 1-1 3v1c1 1 1 1 1 2 1 1 1 2 2 3s2 1 3 1h5l10-5c1 0 1-1 2-1 1-1 1-2 2-3v-4c0-1 0-2-1-2zm-15 11h-2l-1-1s-1 0-1-1v-3l1-1h1l9-5h3c1 1 1 1 1 2 1 0 1 1 1 1 0 1 0 1-1 2l-1 1-10 5zm28 14c-1 0-1-1-2-1h-1l-19 11c-1 0-1 0-1 1-1 0 0 1 0 2 0 0 1 0 1 1h2l19-11s1 0 1-1v-2zm11 22c0-1-1-1-1-2-1 0-1 0-2 1l-19 10-1 1v2c1 0 1 1 2 1h1l19-10c1-1 1-1 1-2v-1zm14 23-3-3h-1c-1 0-1-1-2-1 0 0-1 0-2 1h-1c-1 0-1 0-2 1l-8 6h-2v1c-1 1-1 2-2 3v3s0 1 1 1v2l3 3c1 0 2 1 3 1s2 0 3-1h1l1-1 9-6c1 0 1-1 2-1 0-1 1-2 1-3v-4c0-1-1-2-1-2zm-14 13h-3l-1-1c0-1 0-1-1-2 0 0 0-1 1-1v-1c1 0 1 0 1-1l9-6h3l1 1c1 1 1 1 1 2v1c0 1-1 1-1 1l-1 1-9 6zm30 10c-1 0-1 0-2-1 0 0-1 0-1 1l-18 13-1 1c0 1 0 1 1 2 0 0 1 0 1 1 1 0 1 0 2-1l17-13c1 0 1 0 1-1v-2zm17 23c-1-1-2-2-3-2s-1-1-2-1h-1c-1 0-2 0-3 1h-1l-1 1-8 7c-1 0-1 0-1 1-1 0-1 0-1 1-1 0-1 1-1 2v5c1 0 1 1 1 1l3 3h6l1-1s1 0 1-1l8-6c1-1 2-1 2-2 1-1 1-2 1-3v-4c-1-1-1-1-1-2zm-13 14-1 1h-2c0-1-1-1-1-1-1-1-1-2-1-2v-1c0-1 0-1 1-1v-1l9-7h3s1 0 1 1c1 0 1 1 1 1v2l-1 1-9 7zm31 8c-1-1-1-1-2-1s-1 0-2 1l-16 14v3c1 0 1 1 2 1 0 0 1 0 1-1l16-14c1 0 1-1 1-2v-1zm19 21c-1-1-2-2-3-2-1-1-1-1-2-1h-1c-1 0-2 1-3 1l-1 1s-1 0-1 1l-8 7-1 1v1c-1 1-1 2-1 3v3l1 1c0 1 1 1 1 2 1 1 2 2 3 2h3c1 0 2 0 3-1h1c0-1 1-1 1-1l8-8s1-1 1-2c0 0 1-1 1-2v-3c-1-1-1-1-1-2l-1-1zm-11 15h-1l-1 1h-1c-1-1-1-1-2-1 0-1 0-1-1-2v-1l1-1v-1l8-7 1-1h2s1 0 1 1c1 0 1 1 1 1 0 1 1 1 0 1v1l-1 1-7 8zm35 8c-1-1-2-1-3-2h-3c-1 0-2 1-3 1 0 0-1 0-1 1 0 0-1 0-1 1l-7 7-1 1c0 1-1 1-1 2v2c-1 1 0 2 0 3s0 1 1 2l1 1c1 1 2 2 3 2h3c1 0 2 0 3-1h1c0-1 1-1 1-1l7-8 2-2v-6l-1-1c0-1-1-1-1-2zm-11 16-1 1h-1c-1 0-1-1-2-1 0-1-1-1-1-1v-3c1 0 1 0 1-1l7-7 1-1s1 0 1-1c0 0 1 0 1 1h2c0 1 0 1 1 2v1s0 1-1 1v1l-8 8zm32 3c0-1-1-1-2-1 0 0-1 0-1 1l-14 16c0 1-1 1-1 2 1 1 1 1 1 2h2s1 0 1-1l14-16c1-1 1-1 1-2l-1-1zm22 17c-1-1-2-1-3-1-1-1-1-1-2-1l-1 1c-1 0-2 0-3 1l-1 1v1l-7 8c0 1-1 1-1 1v1c-1 1-1 2-1 3s1 2 1 3l1 1c0 1 1 1 1 2 2 1 3 1 4 1h3c1 0 2 0 2-1 1 0 1 0 1-1 1 0 1 0 1-1l7-8c0-1 1-2 1-3v-5c-1-1-1-1-1-2-1 0-1-1-2-1zm-8 17h-1l-1 1h-1c-1 0-1 0-2-1l-1-1v-2c0-1 1-1 1-1l6-9h1v-1h2s1 0 1 1c1 0 1 0 2 1v1c0 1 0 1-1 1v1l-6 9zM421 1177c-2-1-3-2-4-2h-1c-1 0-1 1-2 1s-2 1-2 1c-1 0-1 1-1 1l-1 1-5 9-1 1v2c-1 0-1 1-1 2 1 1 1 2 1 3l1 1 2 2c1 0 2 1 3 1 2 0 3 0 3-1 1 0 2 0 3-1l1-1v-1l6-9c1-1 1-1 1-2v-3c0-1 0-2-1-3 0 0 0-1-1-1 0-1-1-1-1-1zm-7 17h-1c0 1 0 1-1 1h-3c0-1-1-1-1-1v-3l6-10c1 0 1-1 1-1h3c1 1 1 1 1 2 1 0 1 0 1 1v1l-1 1-5 9zm35 0c-1-1-2-1-3-1h-3c-1 1-2 1-2 2-1 0-1 0-1 1 0 0-1 0-1 1l-5 9c0 1-1 1-1 1v4c0 1 1 2 1 3s1 1 1 1l2 2c1 0 2 1 3 1 2 0 3-1 3-1 1 0 2-1 3-1 0-1 0-1 1-1v-2l5-9c1-1 1-1 1-2v-3c0-1 0-2-1-3l-1-1c0-1-1-1-2-1zm-6 17v1l-1 1h-3l-1-1c0-1-1-1-1-2v-1c1 0 1 0 1-1l5-9v-1h1v-1h2s1 0 1 1c1 0 1 0 1 1 1 0 1 1 1 1v1l-1 1-5 9zm31-4h-1c-1 0-1 0-2 1l-9 19v2s0 1 1 1h2s1 0 1-1l9-19c1-1 1-1 0-2 0-1 0-1-1-1zm21 9h-2c0 1-1 1-1 2l-8 19v2c0 1 0 1 1 1 0 1 1 1 2 0 0 0 1 0 1-1l8-20v-1c0-1 0-1-1-2zm26 11c-1-1-2-1-3-1s-1 1-2 1h-1l-2 2-1 1c0 1 0 1-1 1l-3 11-1 1v1c0 1 0 2 1 3 0 1 0 2 1 2 1 1 1 1 2 1 0 1 1 1 1 1 2 1 3 1 4 1s2-1 3-1l2-2s0-1 1-1v-1l4-10v-6l-2-2c0-1-1-1-1-1-1-1-1-1-2-1zm-3 18s0 1-1 1v1h-3c-1 0-1 0-2-1v-3l4-10v-1l1-1h3l1 1 1 1v1l-1 1-3 10zm30-9h-2l-1 1-6 21v2l1 1h2c0-1 1-1 1-2l6-20v-2c0-1-1-1-1-1zm27 7h-4l-1 1c-1 0-1 0-1 1-1 0-2 1-2 2-1 0-1 0-1 1v1l-3 10v3c0 1 0 2 1 3 0 0 1 1 1 2 1 0 1 1 2 1 0 0 1 0 2 1h3c1-1 2-1 3-2 1 0 1-1 2-2v-1c1 0 1-1 1-1l2-10c1-1 1-2 1-3s-1-2-1-3l-2-2-1-1c-1 0-1 0-2-1zm-2 19v2h-5c0-1 0-1-1-2v-1l1-1 2-10v-1h1v-1h4l1 1v2l-3 11zm29-13s-1 0-1 1c-1 0-1 0-1 1l-4 21v2l1 1c1 0 2 0 2-1 1 0 1 0 1-1l4-21v-2c-1 0-1-1-2-1zm28 5c-1-1-3 0-4 0l-1 1s-1 0-1 1c-1 0-1 1-2 2v2l-2 11v2c0 1 1 2 1 3 1 1 1 2 2 2s1 1 2 1h2c1 1 2 1 3 0 1 0 2-1 3-1 0-1 1-2 1-3 1 0 1 0 1-1v-1l2-11v-2c-1-1-1-2-1-3-1-1-2-1-3-2 0 0 0-1-1-1h-2zm1 18c0 1 0 1-1 1v1l-1 1h-2s-1 0-1-1c-1 0-1 0-1-1l-1-1c1 0 1 0 1-1l1-10v-2h1s0-1 1-1h1c1 0 2 0 2 1 0 0 1 0 1 1v2l-1 10zm32-15h-3c-1 1-1 1-2 1 0 0 0 1-1 1 0 1-1 2-1 2 0 1 0 1-1 2v1l-1 11v2c1 1 1 2 2 3l2 2h1c1 1 2 1 2 1 2 0 3 0 4-1 1 0 2-1 2-1 1-1 2-2 2-3v-2l1-11v-2c0-1 0-2-1-3 0-1-1-1-2-2-1 0-1-1-2-1h-2zm2 18v1c0 1 0 1-1 1 0 1 0 1-1 1h-3l-1-1v-2l1-11v-2h1c1-1 1-1 2-1s1 1 2 1l1 1v2l-1 10zm26-17s-1 0-1 1c-1 0-1 0-1 1v23c1 1 1 1 2 1 0 0 1 0 1-1 1 0 1-1 1-1l1-22-1-1c0-1-1-1-2-1zm29-1c-2 0-3 1-4 1l-1 1c-1 0-1 1-1 1-1 1-1 2-2 3v13c0 1 0 1 1 1v1c0 1 1 2 1 3 1 1 2 1 3 2h3c2 0 3 0 4-1 1 0 1-1 2-1 1-1 1-2 1-3 0 0 0-1 1-1v-1l-1-11v-3c0-1-1-1-2-2 0-1-1-1-2-2h-1c-1-1-2-1-2-1zm3 19v1c0 1-1 1-1 1-1 1-1 1-2 1h-2c0-1 0-1-1-1v-15l1-1h3c1 0 1 1 1 1 1 0 1 1 1 1v12zm29-21c-2 0-3 1-4 1 0 1-1 1-1 1 0 1-1 1-1 1 0 1-1 2-1 3v3l1 10c0 1 1 1 1 2v1l2 2c0 1 1 1 2 1 1 1 1 1 2 1h2c1 0 3-1 3-1 1-1 2-2 2-3 1 0 1-1 1-2s1-1 1-2l-1-1-1-10c0-1 0-2-1-3 0-1-1-1-1-2-1-1-2-1-3-2h-3zm5 18v2s-1 0-1 1h-3c-1 0-1 0-1-1h-1v-1l-1-11-1-1c0-1 1-1 1-1v-1c1 0 1 0 2-1 1 0 1 0 2 1h1v1l1 1 1 11zm28-23c-2 1-3 1-4 2l-1 1s0 1-1 1v5l2 11v2c1 1 1 2 2 2 1 1 2 1 3 2h3c2 0 3-1 4-2 1 0 1-1 2-2 0-1 0-2 1-2v-2s0-1-1-1l-1-11c-1 0-1-1-1-2l-2-2c-1-1-2-1-3-2h-3zm6 18v2l-1 1h-1c-1 1-2 1-2 0h-1l-1-1v-1l-2-11v-2s1 0 1-1h4l1 1v1l2 11zm21-23s-1 0-1 1c0 0-1 1 0 2l5 20c0 1 0 1 1 2h1c1 0 1 0 2-1v-2l-5-20c0-1-1-1-1-2h-2zm22-5s-1 0-1 1v1l6 21 1 1c1 1 1 1 2 0 0 0 1 0 1-1v-1l-6-21s0-1-1-1c0-1-1-1-2 0zm27-9c-1 1-2 2-3 2 0 1 0 1-1 2v1c-1 1-1 2-1 3v1c1 0 1 1 1 1l3 10c1 1 1 1 1 2l1 1s1 1 2 1c0 1 1 1 2 1h4c1-1 2-1 3-2s1-2 2-3v-5l-4-10c0-1-1-1-1-2l-2-2c-1-1-2-1-3-1h-4zm9 17c1 0 1 0 1 1v1s-1 0-1 1c0 0-1 0-1 1h-2c-1 0-1 0-1-1h-1v-1l-4-10v-3c1-1 1-1 2-1 1-1 1-1 2-1 0 1 0 1 1 1v1l1 1 3 10zm18-26c-1 0-1 1-1 1-1 1-1 1 0 2l8 20s0 1 1 1h2l1-1v-2l-8-20-1-1h-2zm26-11c-1 1-2 1-3 2 0 1-1 1-1 2v6l5 10s0 1 1 1v1c1 1 2 1 3 2h6l3-3c1-1 1-1 1-2v-6l-5-9c0-1-1-2-1-2-1-1-2-2-3-2 0 0-1-1-3-1h-1c-1 1-1 1-2 1zm11 15v2c0 1 0 1-1 2l-1 1h-3c0-1 0-1-1-1v-1l-5-10v-3c1 0 1 0 2-1h3v1l1 1 5 9zm14-27-1 1v2l11 19s0 1 1 1h2s0-1 1-2c0 0 0-1-1-1l-10-19c0-1 0-1-1-1h-2zM964 1185l-3 3v1c0 1 0 1-1 2 0 1 0 2 1 3v2l6 9c0 1 1 1 1 1s0 1 1 1c0 1 1 1 2 1 1 1 2 1 3 1s1 0 2-1h1c2-1 3-2 3-3 1-1 1-2 1-3v-4c-1 0-1 0-1-1l-5-9-2-2c-1-1-1-1-2-1-1-1-2-1-3-1s-2 0-2 1h-2zm12 15h1v1c0 1 0 1-1 2l-1 1h-3l-1-1-6-9v-4s1 0 1-1h3c1 0 1 0 1 1h1l5 10zm17-32c-2 0-2 1-3 2v2c-1 0-1 1-1 1v3c1 0 1 1 1 1s0 1 1 1l5 9 1 1 1 1c1 1 2 1 3 1 1 1 2 1 3 1l1-1c1 0 1 0 2-1s2-1 3-2v-3c1-1 0-2 0-3v-1c0-1-1-1-1-1l-6-9c0-1-1-1-2-2 0-1-1-1-2-1-1-1-2-1-3-1s-1 1-2 1c0 0-1 0-1 1zm12 13 1 1v2c0 1-1 1-1 2h-3c-1 0-1 0-1-1h-1l-6-9v-3c0-1 0-1 1-2h3s1 0 1 1l6 9zm11-29c-1 0-1 0-1 1v2l13 17s1 1 2 1c0 0 1 0 1-1 1 0 1 0 1-1v-2l-13-17s-1-1-2-1c0 0-1 0-1 1zm22-18c-1 1-2 2-2 3s-1 1-1 2v1c0 1 0 2 1 3v1c1 0 1 1 1 1l7 8c0 1 1 1 1 1s0 1 1 1c1 1 1 1 2 1h3c1 0 1 0 2-1 0 0 1 0 2-1s1-2 2-3v-5c0-1 0-1-1-1v-1l-7-9c-1 0-1-1-2-1-1-1-2-1-3-1-1-1-2-1-3 0h-1c-1 0-1 1-2 1zm14 13h1v3s-1 0-1 1c-1 0-1 1-2 1h-1l-1-1s-1 0-1-1l-6-8-1-1v-2s0-1 1-1c0-1 1-1 1-1h2l1 1 7 9zm11-35c-1 1-1 2-2 3v3c0 1 0 2 1 3v1l1 1 7 8c1 0 1 1 1 1s1 0 1 1c1 0 2 0 3 1 1 0 2 0 3-1h1c1-1 1-1 2-1 1-1 2-2 2-3s1-2 1-3c-1-1-1-2-1-3l-1-1c0-1 0-1-1-1l-7-8c0-1-1-1-2-2 0 0-1 0-2-1-1 0-2 0-3 1h-2s-1 1-2 1zm15 12 1 1v2l-1 1c-1 1-1 1-2 1h-2v-1l-8-8v-1h-1v-2c1 0 1-1 1-1 1-1 1-1 2-1h2l1 1 7 8zm10-35c-1 1-2 2-2 3 0 0-1 1-1 2v1c0 1 1 2 1 3 0 0 1 0 1 1l1 1 7 7 1 1 1 1c1 0 2 1 3 1s2 0 3-1h1l2-2c1-1 2-2 2-3v-3c0-1 0-1-1-2v-1l-1-1-8-8c0-1-1-1-2-2h-5c-1 0-1 0-2 1 0 0-1 0-1 1zm15 11 1 1v2l-1 1c-1 1-1 1-2 1h-2c0-1 0-1-1-1l-7-7-1-1v-2c0-1 0-1 1-2l1-1h1c1 0 1 0 1 1h1l8 8zm4-32c-1 1-1 1-1 2 0 0 0 1 1 1l16 15h3c0-1 1-1 1-2l-1-1-16-15h-3zm15-17c-1 0-1 1-1 1 0 1 0 1 1 2l16 14h2c1 0 1 0 2-1v-1c0-1 0-1-1-2l-16-14h-2c-1 0-1 0-1 1zm17-23c-1 1-1 3-2 4v3l2 2v1c1 0 1 1 1 1l9 6c0 1 1 1 1 1l1 1h3c1 0 2 0 3-1 0 0 1 0 1-1 1 0 1 0 2-1 0-1 1-2 1-3v-3c0-1-1-2-1-3 0 0-1 0-1-1 0 0-1 0-1-1l-9-6c0-1-1-1-2-1-1-1-1-1-2-1s-2 1-3 1-1 1-2 1l-1 1zm16 9c1 0 1 0 1 1h1v2l-1 1c0 1-1 1-1 1-1 1-1 1-2 1l-1-1-9-7h-1v-4c1 0 1-1 2-1h3l8 7zm0-32v2c0 1 0 1 1 1l17 12c1 1 1 1 2 1s1-1 2-1v-2l-1-1-18-12c0-1-1-1-1-1-1 0-2 1-2 1zm15-24c-1 2-1 3-1 4v3l2 2s0 1 1 1c0 0 0 1 1 1l9 5c0 1 1 1 1 1h1c1 1 2 1 3 1 1-1 2-1 3-1 0-1 1-1 1-2 1 0 1 0 1-1 1-1 1-2 2-4 0-1-1-2-1-2 0-1-1-2-1-3-1 0-1 0-1-1h-1l-9-6c-1-1-2-1-3-1h-2c-1 0-2 0-3 1-1 0-1 0-2 1 0 0 0 1-1 1zm17 7c1 0 1 1 1 1s1 0 1 1v1s0 1-1 2c0 0 0 1-1 1h-3l-9-6-1-1c-1-1-1-1-1-2l1-1c0-1 1-1 1-1l1-1h1l1 1 9 5zm-3-31v2s0 1 1 1l19 10s1 1 2 0c0 0 1 0 1-1v-1c0-1 0-1-1-2l-19-10h-2s-1 0-1 1zm13-25c-1 1-1 2-1 3v2l1 1c0 1 1 2 1 2l1 1c1 0 1 1 1 1l10 5h5c1 0 2 0 3-1l1-1c1-1 1-1 1-2 1-1 1-2 1-4 0-1 0-2-1-2 0-1 0-2-1-3h-1l-1-1-10-5c-1 0-1 0-2-1h-3c-1 1-2 1-3 2 0 0-1 0-1 1 0 0-1 1-1 2zm18 5 1 1 1 1c0 1 0 1-1 2 0 1 0 1-1 1 0 1-1 1-1 1h-1c-1 0-1 0-1-1l-10-4v-1h-1v-3c0-1 1-1 1-2h3l10 5zm-4-36c-1 1-1 2-1 4v1l1 1c0 1 1 2 1 3h1c1 0 1 1 2 1l9 4c1 0 1 1 2 1h4l2-2c1 0 1-1 1-1 1-1 1-1 1-2 1-1 1-2 1-3s0-2-1-3c0-1-1-2-1-2l-1-1c-1 0-1-1-2-1l-9-4c-1 0-2-1-3-1s-2 0-3 1c0 0-1 0-2 1-1 0-1 1-1 1-1 1-1 1-1 2zm18 4v1h1c0 1 1 1 1 2 0 0 0 1-1 1 0 1 0 2-1 2h-3l-10-4v-1h-1c0-1-1-1-1-2 0 0 0-1 1-1 0-1 0-1 1-2h3l10 4zm-8-30v1c0 1 0 1 1 1l20 8h2l1-1v-2c0-1-1-1-1-1l-20-8h-2c-1 1-1 1-1 2zm9-27c-1 1-1 2-1 3s1 1 1 2v1l2 2c1 0 1 1 1 1h2l10 4h5c1-1 2-1 3-2 0-1 0-1 1-2v-1c1-2 1-3 1-4s-1-2-1-3c-1 0-2-1-2-2h-1c-1-1-1-1-2-1l-10-3c-1 0-1-1-2-1s-2 1-3 1-2 1-3 2l-1 1v2zm18 2c0 1 1 1 1 1h1v3c0 1 0 2-1 2h-1c0 1-1 1-1 1 0-1-1-1-1-1l-10-3h-1v-1h-1v-3c0-1 0-1 1-1 0-1 0-1 1-1h2l10 3zm-9-35c-1 2-1 3-1 4 1 0 1 1 1 1 0 1 0 1 1 2 0 1 1 1 2 2h1l1 1 10 3h3c1 0 2 0 3-1l2-2s1 0 1-1 1-1 1-2v-3c0-2-1-2-1-3l-2-2c-1 0-1 0-1-1h-2l-10-3h-5c-1 1-2 1-3 2 0 1 0 1-1 2v1zm18 2c1 0 1 0 1 1h1s0 1 1 1c0 1 0 1-1 2v2h-3l-11-3h-1l-1-1v-2c0-1 0-2 1-2l1-1h2l10 3zm-11-33c-1 1-1 2 0 3v2c1 0 1 1 1 1 1 1 2 1 2 2h2l1 1 10 1c1 0 1 1 2 1 0 0 0-1 1-1h3c0-1 1-2 2-2 0-1 0-1 1-2v-6c0-1-1-1-1-2-1-1-2-1-3-2h-1l-1-1-11-1c0-1-1-1-2 0h-3l-2 2c0 1-1 1-1 2v2zm18 0h1s1 0 1 1c0 0 1 0 1 1v1c0 1 0 2-1 2 0 0 0 1-1 1h-2l-10-2h-2v-1s-1 0-1-1v-1c0-1 0-2 1-2 0 0 0-1 1-1h2l10 2zM1250 756c0 1 0 1 1 2h1l22 3h1c1-1 1-1 1-2v-2h-2l-21-3h-2c0 1-1 1-1 2zm3-24c0 1 0 1 1 2 0 0 1 0 1 1l22 2h1c1-1 1-1 1-2v-1c-1-1-1-1-2-1l-21-3c-1 0-1 0-2 1 0 0-1 0-1 1zm3-28v3c0 1 1 1 1 2l1 1c1 1 1 1 2 1l1 1h2l10 1h3c1-1 2-1 2-2 1 0 2-1 3-2v-1c0-1 0-2 1-2 0-2-1-3-1-4s-1-2-2-2c0-1-1-1-2-2h-3l-10-1h-3c-1 0-1 1-2 1-1 1-2 1-2 2-1 1-1 1-1 2v2zm18-2h1s1 0 1 1c0 0 1 0 1 1v3c-1 0-1 1-1 1h-2l-11-1h-2s0-1-1-1v-2c0-1 0-1 1-1 0-1 0-1 1-1 0-1 0-1 1-1l11 1zm-17-26v1c1 1 1 1 2 1h23c0-1 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1l-22-1s-1 1-2 1v2zm0-29v4c1 0 1 1 1 1l1 1c1 1 2 1 3 1 0 1 1 1 1 1h12c1 0 1 0 1-1h2c1 0 1-1 2-1 1-1 1-2 2-3v-1c1-1 1-2 1-2 0-2-1-3-1-4l-2-2c-1-1-2-1-3-1l-1-1h-1l-11 1h-2c-1 0-2 1-3 1-1 1-1 2-2 3v3zm18-3h2s0 1 1 1v4s-1 0-1 1h-15v-1c-1 0-1-1-1-2v-1l1-1 1-1h12zm-20-25c0 1 1 1 1 2h2l21-1c1 0 1-1 2-1v-3c-1-1-2-1-2-1l-22 2s-1 0-1 1l-1 1zm-2-28c0 1 0 3 1 3 0 1 1 1 1 2 0 0 1 0 1 1 1 0 2 0 3 1h2l11-2h3c0-1 1-1 2-2 0-1 1-1 1-2 1-1 1-1 1-2v-2c0-1-1-3-1-4-1 0-2-1-3-2 0 0-1 0-2-1h-3l-10 2h-3l-2 2c-1 0-1 1-2 2v4zm18-5h2l1 1v3c0 1 0 1-1 1 0 0 0 1-1 1l-11 1h-2s-1 0-1-1c0 0 0-1-1-1 0-1 0-2 1-2v-1c1 0 1-1 1-1h1l11-1zm-23-28c1 1 1 2 2 3 0 1 0 1 1 1 0 1 1 1 1 1 1 1 2 1 3 1h2l11-2h1s1 0 1-1c1 0 2-1 2-1 1-1 2-2 2-3v-4c0-1-1-2-1-3-1-1-2-1-3-2 0 0-1-1-2-1h-3l-10 2c-1 0-2 0-3 1 0 0-1 1-2 1-1 1-1 2-1 3-1 1-1 1-1 2v2zm18-6h2s1 0 1 1l1 1v2c-1 0-1 1-1 1s-1 0-1 1h-1l-11 2h-1l-1-1c-1-1-1-1-1-2v-2s0-1 1-1h1v-1l11-1zm-23-22c1 0 1 1 1 1 1 1 1 1 2 1l21-5c1 0 1 0 1-1 1 0 1-1 1-2l-1-1h-2l-21 4-1 1c-1 1-1 1-1 2zm-6-28c1 2 1 3 2 4 0 0 1 0 1 1h1c1 1 2 1 3 1h3l10-3h1c0-1 1-1 1-1 1-1 2-1 2-2 1-1 1-2 1-3 1 0 1-1 1-1 0-1-1-2-1-2 0-2-1-3-1-4-1 0-2-1-3-1-1-1-2-1-3-1h-2l-10 3c-1 0-2 1-3 1 0 1-1 1-2 2 0 1-1 2-1 3v3zm17-7h1c0-1 1-1 1 0h1c1 1 1 1 1 2v1c0 1 0 1-1 2-1 0-1 1-1 1l-11 2-1 1-1-1h-1v-2c-1 0-1-1-1-1 1-1 1-1 1-2h1l1-1 10-2zm-26-25c1 1 1 2 2 3l1 1c1 0 1 1 2 1h5l10-3 1-1h1l2-2c1-1 1-2 1-3v-4c-1-1-1-2-2-3s-2-1-2-2h-6l-10 3-2 2c-1 0-1 1-2 2-1 0-1 1-1 2v4zm17-9h2s0 1 1 1c0 0 0 1 1 1v2c0 1 0 1-1 1 0 1 0 1-1 1l-11 4h-2s0-1-1-1c0 0 0-1-1-1v-2c0-1 1-1 1-1 0-1 0-1 1-1l11-4zm-27-23c0 1 1 2 1 3 1 0 1 1 2 1l1 1h5l10-4c1 0 1-1 2-1h1c0-1 1-2 1-2 1-1 1-2 1-3v-4c-1-1-1-2-2-3s-2-1-3-2h-4s-1 0-1 1l-10 3-2 2c-1 0-1 1-2 2-1 0-1 1-1 3v1c0 1 0 1 1 2zm16-9h1s0-1 1 0h1c0 1 0 1 1 2v1c0 1 0 1-1 2-1 0-1 1-1 1l-10 3-1 1h-1l-1-1c-1 0-1-1-1-1-1-1-1-2 0-2v-1c0-1 0-1 1-1h1l10-4zm-27-17c1 0 1 1 2 1h1l20-8c1-1 1-1 1-2 1 0 1-1 0-1 0-1 0-1-1-2h-2l-19 9c-1 0-1 0-2 1v2zm-9-21c1 0 1 1 2 1h1l20-10s1 0 1-1v-2s-1 0-1-1h-2l-20 10-1 1v2zm-12-27c0 1 1 2 2 3 0 0 1 0 1 1h7l9-5c1 0 1-1 2-1h1c0-1 1-2 1-3 1-1 1-2 1-3v-1c-1-1-1-2-1-2-1-1-1-2-2-3s-2-1-3-1c-1-1-2-1-3 0h-2l-10 5c-1 0-1 1-2 1-1 1-1 2-2 3v4c0 1 0 1 1 2zm15-11h3c0 1 1 1 1 2v3h-1c0 1 0 1-1 1l-9 5h-2c-1 0-1 0-1-1-1 0-1 0-1-1-1 0-1-1-1-2l1-1v-1h1l10-5zm-29-14c0 1 1 1 2 1h1l19-10c1 0 1-1 1-1v-2c0-1-1-1-1-1h-2l-19 10-1 1v2zm-14-24c0 1 1 2 2 3h2s1 0 1 1c1 0 2 0 3-1h1s1 0 1-1l9-5c1 0 1-1 1-1 1 0 1 0 1-1 1 0 1-1 2-2v-5l-1-1c-1-2-2-3-3-3-1-1-1-1-2-1h-4c-1 1-1 1-2 1l-9 5c0 1-1 1-2 2 0 1-1 1-1 2s-1 2 0 3v2c0 1 0 1 1 2zm14-12s0-1 1-1h1l1 1s1 0 1 1l1 1c0 1 0 1-1 2v1h-1l-9 6h-3c-1 0-1-1-1-1-1-1-1-2-1-2v-1c0-1 1-1 1-1l1-1 9-5zm-30-12c0 1 1 1 2 1h1l18-12c1 0 1-1 1-1v-2c-1-1-1-1-2-1h-1l-18 12c-1 0-1 1-1 2v1zm-16-23c0 1 1 2 2 3h2l1 1c1 0 2-1 3-1h1c0-1 1-1 1-1l9-6c0-1 1-1 1-1s0-1 1-1c0-1 1-2 1-3v-3s0-1-1-1c0-1 0-1-1-2 0-1-1-2-2-2-1-1-2-1-3-1h-3l-1 1h-1l-9 7-2 2s-1 1-1 2v3c0 1 0 1 1 2 0 0 0 1 1 1zm12-13h1c0-1 1-1 1-1 1 0 1 0 2 1l1 1s0 1 1 1c0 1 0 1-1 1v1c0 1-1 1-1 1l-9 6v1h-3s0-1-1-1c0-1 0-1-1-2 0 0 0-1 1-1v-1l1-1 8-6zm-33-13c0 1 1 2 2 2 1 1 1 1 2 1h1c1 0 2 0 3-1h1c1 0 1-1 1-1l9-7h1v-1c1-1 1-2 1-3 1-1 1-2 0-3v-2l-1-1-3-3h-6c0 1-1 1-1 1s-1 0-1 1l-8 6-2 2c-1 1-1 2-1 3v4c1 1 1 2 2 2zm12-14h1c0-1 0-1 1-1h1c0 1 1 1 1 2 1 0 1 1 1 1v1c0 1 0 1-1 1v1l-9 7h-1v1c-1 0-1 0-2-1l-1-1-1-1v-2h1l1-1 8-7zm-31-7 1 1c1 0 2 0 2-1l16-14c0-1 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1h-2l-16 15-1 1c0 1 0 2 1 2zM1066 201c1 1 2 1 3 2h3c1 0 2 0 3-1h1c0-1 1-1 1-1l8-8v-1c1 0 1 0 1-1 1-1 1-2 1-2v-3c-1-1-1-1-1-2s-1-1-1-2c-1-1-2-1-3-2h-3c-1 0-2 0-3 1 0 0-1 0-1 1h-1l-8 8c0 1-1 1-1 2-1 1-1 2-1 3v3l1 1c0 1 1 1 1 2zm11-15c0-1 1-1 1-1h2c1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1v1c0 1 0 1-1 1l-7 8h-1c-1 0-1 1-1 1s-1 0-1-1h-2c0-1 0-1-1-2v-1c0-1 1-1 1-1v-1l8-7zm-35-8c1 1 2 1 3 2h3c1 0 2-1 2-1 1 0 1-1 1-1 1 0 1 0 1-1l8-8 1-1v-1c1-1 1-1 1-2s0-2-1-3v-2c-1 0-1-1-2-1-1-1-2-2-3-2-1-1-2-1-3 0h-3c0 1 0 1-1 1v1l-8 8c0 1-1 1-1 2-1 1-1 2-1 3s0 2 1 3v1l2 2zm10-16 1-1h2s1 0 1 1c1 0 1 1 1 1v3h-1l-7 8-1 1h-2s-1 0-1-1c-1 0-1-1-1-1s-1-1 0-1v-1l1-1 7-8zm-35-5c1 1 2 1 3 2h2s1 0 1-1c1 0 2 0 3-1l1-1h1l6-9c0-1 1-1 1-1v-1c1-1 1-2 1-3s-1-2-1-3l-1-1c0-1-1-1-1-2-2-1-3-1-4-1h-3c-1 0-2 0-2 1-1 0-1 1-1 1-1 0-1 1-1 1l-7 8c0 1-1 2-1 3v5c1 1 1 1 1 2 1 0 1 1 2 1zm8-17h1l1-1h1c1 0 1 0 2 1l1 1v3h-1l-6 9h-1v1h-2s-1 0-1-1c-1 0-1 0-2-1v-1c0-1 0-1 1-1v-1l6-9zm-31 0h2c1 0 1 0 1-1l13-17v-2c0-1-1-1-1-1 0-1-1-1-2-1l-1 1-12 18c-1 0-1 1-1 2 1 0 1 1 1 1zm-20-14c1 1 1 1 2 1s1-1 2-1l12-18v-2s0-1-1-1h-2s-1 0-1 1l-12 17c0 1-1 1-1 2l1 1zm-24-15c2 1 3 2 4 2h1c1 0 1-1 2-1s2-1 2-1c1 0 1-1 1-1l1-1 6-9v-1c0-1 0-1 1-2v-2c0-1-1-2-1-3l-1-1-2-2c-1 0-2-1-3-1-2 0-3 0-3 1-1 0-2 0-3 1l-1 1v1l-6 9c0 1-1 2-1 2v3c0 1 0 2 1 3 0 0 0 1 1 1 0 1 1 1 1 1zm7-17h1c0-1 0-1 1-1h3c0 1 1 1 1 1v3l-6 10c-1 0-1 1-1 1h-3c-1-1-1-1-1-2-1 0-1 0-1-1v-1l1-1 5-9zm-31 4h2l1-1 10-19s1-1 0-2c0 0 0-1-1-1h-1c-1 0-1 0-2 1l-10 19v1c0 1 0 1 1 2zm-25-13c1 1 2 1 3 1h2s1 0 1-1c1 0 2-1 2-1l1-1c0-1 1-1 1-1l4-10 1-1v-4c0-1-1-2-1-3-1 0-1-1-1-1-1-1-2-1-2-1-1-1-3-1-4-1s-2 0-3 1c0 0-1 1-2 1 0 1 0 1-1 1v1l-5 10c0 1-1 2-1 2v3c1 1 1 2 2 3 0 0 0 1 1 1 0 1 1 1 2 1zm5-18c0-1 1-1 1-1s1 0 1-1c1 0 1 1 2 1s1 1 1 1c1 0 1 1 1 1v1c0 1-1 1-1 1l-4 10h-1v1h-1s0 1-1 1l-1-1c-1 0-1 0-2-1v-3l5-10zm-31 7h2l1-1 8-20v-2l-1-1h-2l-1 1-8 20c-1 1-1 1 0 2 0 0 0 1 1 1zm-26-10c1 0 2 1 3 0h2s1 0 1-1c1 0 1-1 2-1 0-1 0-1 1-1v-2l4-10v-5c0-1-1-2-2-3l-1-1h-2c-1-1-2-1-3-1s-2 1-3 1c-1 1-2 1-2 2l-1 1v1l-4 10c0 1 0 2-1 3 0 1 1 2 1 2 0 1 1 2 1 3 1 0 1 1 2 1 0 0 1 1 2 1zm3-18v-1l1-1h1c1-1 1 0 2 0 0 0 1 0 1 1 1 0 1 0 1 1v2l-4 10v1h-1v1h-3c-1 0-1-1-1-1l-1-1v-2l4-10zm-35 8h5c0-1 1-1 1-1l2-2s0-1 1-1v-1l3-11s0-1 1-1v-1c0-1-1-2-1-3s-1-1-2-2c0-1-1-1-1-1-1-1-1-1-2-1s-2-1-4 0c-1 0-2 0-2 1-1 0-2 1-2 2 0 0-1 0-1 1v1l-3 10c-1 1-1 2-1 3s0 2 1 3c0 0 1 1 1 2 1 0 1 1 2 1 0 0 1 1 2 1zm2-19c0-1 1-1 1-1 0-1 1-1 1-1h2l1 1c1 0 1 1 1 1v2l-3 10-1 1v1c-1 0-1 1-1 1h-2c-1-1-1-1-2-1v-3l3-11zm-30 12h2c1-1 1-1 1-2l5-21v-1c0-1-1-1-1-1-1-1-2 0-2 0-1 0-1 1-1 1l-5 21v2l1 1zm-27-6h4l1-1h1c1-1 1-2 2-3v-1l1-1 2-11v-2c0-1-1-2-1-3s-1-1-2-2l-1-1h-2c-2-1-3-1-4 0-1 0-2 0-3 1 0 1-1 1-1 2s-1 1-1 1v2l-2 10v3c0 1 0 1 1 2 0 1 1 2 2 3l1 1h2zm0-19h1v-1c0-1 1-1 1-1h2c1 0 1 0 1 1 1 0 1 0 1 1v2l-2 10v2c-1 0-1 0-2 1h-1c-1 0-1-1-2-1l-1-1v-2l2-11zm-33 14h3c1 0 1-1 2-1 0 0 1 0 1-1l2-2v-2l2-11v-3c0-1-1-1-1-2-1-1-1-2-2-2-1-1-1-1-2-1 0 0-1-1-2-1s-2 0-3 1c-1 0-2 1-3 1-1 1-1 2-2 2v3l-2 11v2c0 1 1 2 1 3 1 0 1 1 2 2 1 0 1 0 2 1h2zm-1-19c0-1 1-1 1-1 0-1 0-1 1-1h3l1 1v2l-1 11v1c-1 0-1 1-1 1h-1c0 1-1 1-2 1l-1-1c-1 0-1-1-1-1v-2l1-11zm-32 16h3l1-1c1-1 1-1 2-1 0-1 1-2 1-3v-1c1 0 1-1 1-1l1-11v-1l-1-1c0-1 0-2-1-3 0-1-1-1-2-2 0 0-1 0-2-1h-1c-2 0-3 0-4 1-1 0-2 1-3 1 0 1-1 2-1 3v1l-1 1v11c-1 1 0 1 0 2s0 2 1 3c0 1 1 1 2 2 0 0 1 0 2 1h2zm-2-19v-1c1-1 1-1 2-1h3l1 1v2l-1 11v2h-1c-1 0-1 1-2 1-1-1-1-1-2-1 0 0 0-1-1-1v-2l1-11zm-27 18c1 0 2 0 2-1l1-1V7c-1-1-1-1-2-1 0 0-1 0-1 1-1 0-1 1-1 1l-1 22s0 1 1 1c0 1 1 1 1 1zm-22 0h1c1-1 1-1 1-2l-1-22V7c-1-1-1-1-2-1s-1 0-2 1v23c0 1 1 1 1 2h2zm-28 2c1-1 2-1 3-2h1c1-1 1-1 1-2 1 0 1-1 1-2s1-1 1-1v-2l-1-10v-2c-1 0-1 0-1-1s-1-1-1-2c-1-1-2-1-3-2h-3c-2 0-3 0-4 1-1 0-2 1-2 2-1 1-1 1-1 2v14c1 0 1 1 1 2s1 2 2 2c0 1 1 2 2 2h2c0 1 1 1 2 1zm-5-19v-1l1-1c1-1 1-1 2-1h2s0 1 1 1v2l1 11v2s-1 0-1 1h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-1l-1-11zm-23 21s1 0 1-1c1 0 1-1 1-1l-3-22-1-1c-1-1-1-1-2-1 0 1-1 1-1 1-1 1-1 1-1 2l3 21c0 1 0 1 1 2h2zM561 40c1 0 2-1 3-1l1-1c1-1 1-1 1-2s1-1 1-2v-3l-2-10v-2c-1 0-1 0-1-1s-1-1-2-2c0-1-1-1-2-1s-1-1-2-1-1 0-2 1c-1 0-3 0-3 1-1 1-2 1-2 2-1 1-1 2-1 3v2l2 11c0 1 0 2 1 2 0 1 1 2 1 3 1 0 2 1 3 1h4zm-7-17v-2l1-1c1-1 1-1 2-1h1c1 0 1 0 2 1v1l2 11 1 1-1 1v1c-1 0-1 0-2 1h-2c0-1-1-1-1-1v-1l-1-1-2-10zm-21 22c1 0 1 0 2-1v-1l-5-21c0-1-1-1-1-2h-2c-1 0-1 1-1 1-1 1-1 1-1 2l5 21c1 0 1 1 1 1h2zm-29 7c2 0 3-1 4-1 0-1 0-1 1-1 0-1 0-1 1-2v-5l-2-10c-1-1-1-1-1-2v-1c-1-1-2-1-2-2-1 0-2-1-3-1h-4c-1 0-2 1-3 2-1 0-1 1-2 2v5l2 11c1 0 1 1 1 2l2 2c1 1 2 1 3 1 0 0 1 1 2 1 0-1 1-1 1-1zm-7-17v-2l1-1s1 0 1-1h2c1 0 1 1 1 1s1 0 1 1v1l3 10v2l-1 1s-1 1-2 1h-1c-1 0-1 0-1-1-1 0-1 0-1-1l-3-11zm-23 26c1 0 2-1 3-2l1-1v-1c1-1 1-2 1-3v-1l-1-1-3-11c-1 0-1-1-1-1l-1-1c0-1-1-1-2-2 0 0-1 0-2-1h-2c-1 0-1 1-2 1s-2 1-3 2l-2 2v6l4 10s1 1 1 2l2 2c1 0 2 1 3 1h2s1 0 2-1zm-9-16c-1 0-1-1-1-1v-1l1-1 1-1h3c1 0 1 1 1 1v1l4 10v3c-1 0-1 1-2 1h-3v-1l-1-1-3-10zm-19 26s1 0 1-1v-2l-7-20-1-1h-2s-1 0-1 1v2l7 20 1 1h2zm-26 11c1-1 2-1 3-2 0-1 0-1 1-1v-2c0-1 1-2 0-3v-2l-4-10c0-1-1-1-1-1s0-1-1-1c0-1-1-2-2-2 0 0-1-1-3-1h-1c-1 0-2 1-2 1-1 0-2 1-3 2s-1 2-2 3v4s1 0 1 1l4 10s1 1 1 2l2 2h3c1 1 1 1 2 0h2zm-10-16v-3s1-1 2-1h2c1 0 1 1 1 1l1 1 4 10v3c-1 0-1 0-2 1h-3c0-1 0-1-1-1v-1l-4-10zm-21 30c2-1 3-1 3-2 1-1 1-1 1-2l1-1v-3s0-1-1-1v-1l-5-10v-1l-1-1-2-2h-5c-1 0-1 0-2 1-1 0-2 1-3 2 0 1-1 2-1 2v4c0 1 1 1 1 2l4 9c1 1 1 2 2 2 0 1 1 2 2 2 1 1 2 1 3 1h2l1-1zm-10-15c0-1-1-1-1-1v-1l1-1c0-1 1-1 1-1 1-1 1-1 2-1 0 0 1 0 1 1h1v1l5 10v3s-1 1-2 1h-2c-1 0-1 0-1-1l-1-1-4-9zm-19 31 3-3v-1l1-1v-3c0-1-1-1-1-1v-2l-5-9c0-1-1-1-1-1s0-1-1-1c0-1-1-1-2-2h-5s-1 1-2 1c-1 1-2 1-2 2-1 1-1 2-1 3-1 1-1 2 0 3v2l5 10c1 0 1 1 2 2 1 0 1 1 2 1 1 1 2 1 3 1s1 0 2-1h2zm-12-15v-3c1-1 1-1 2-1 0-1 1-1 1-1 1 0 1 0 1 1h1l1 1 5 10v3s-1 0-1 1h-3c-1 0-1 0-1-1l-1-1-5-9zm-12 29 1-1c0-1 0-1-1-2l-11-18c0-1 0-1-1-1h-2l-1 1v2l12 19 1 1c1 0 1 0 2-1zm-19 13s0-1 1-2c0 0 0-1-1-1l-12-18-1-1h-2c0 1-1 1-1 2 0 0 0 1 1 2l11 17c1 1 1 1 2 1h2zm-23 16c1 0 2-1 2-2s0-1 1-2v-1c0-1 0-2-1-3v-1l-1-1-6-9c-1 0-1-1-1-1s-1 0-1-1c-1 0-2-1-3-1h-3s-1 0-1 1c-1 0-1 0-2 1-1 0-2 1-2 2-1 1-1 2-1 3v3c1 0 1 1 1 1 0 1 0 1 1 1l6 9c1 0 1 1 2 2 0 0 1 0 2 1h3c1 0 1 0 2-1 1 0 1 0 2-1zm-14-12v-1c0-1-1-1-1-1 0-1 0-1 1-2l1-1 1-1c1 0 1 0 2 1h1v1l7 8v3c0 1 0 1-1 2h-2c0 1-1 1-1 0h-1v-1l-7-8zm-9 30c1-1 1-1 1-2v-1l-14-17-1-1c-1 0-2 0-2 1-1 0-1 1-1 1 0 1 0 1 1 2l13 16c1 1 1 1 2 1h1zm-21 18c1-1 2-2 2-3v-1c1-1 1-1 1-2-1-1-1-2-1-2 0-1-1-1-1-2v-1l-8-8h-1c0-1 0-1-1-1 0-1-1-1-2-1h-3c-1 0-1 1-2 1 0 0-1 0-1 1-2 1-2 2-3 3v3c0 1 0 2 1 3v1c1 0 1 0 1 1l7 8c1 0 1 1 2 1 1 1 2 1 3 1h3s1 0 1-1c1 0 1 0 2-1zm-15-11v-1s0-1-1-1c0 0 0-1 1-1 0-1 0-1 1-2l1-1h1c1 0 1 1 1 1 1 0 1 0 1 1l7 7 1 1v2c0 1 0 1-1 2-1 0-1 1-2 1h-1s0-1-1-1l-8-8zm-6 30c1 0 1 0 1-1s0-1-1-2l-15-15-1-1c-1 0-2 1-2 1s-1 1-1 2l1 1 15 15c1 1 1 1 2 1 0 0 1 0 1-1zm-19 21c0-1 1-2 1-4l1-1v-2c-1-1-1-1-1-2l-1-1-1-1-8-7c0-1-1-1-1-1l-1-1h-3c-1-1-2 0-3 0l-1 1c-1 0-1 1-2 1-1 1-1 2-1 3-1 1-1 2-1 3 1 1 1 2 1 3l1 1 1 1 8 7c0 1 1 1 2 2h6l1-1c1 0 1-1 2-1zm-16-10c0-1-1-1-1-1v-2c0-1 0-1 1-2l1-1h2l1 1 8 7 1 1v2s0 1-1 2c0 0-1 0-1 1h-1c-1 0-1 0-1-1h-1l-8-7zm-7 35c1-1 2-2 2-4v-3s-1-1-1-2l-1-1s0-1-1-1l-8-7c-1 0-1 0-1-1h-1c-1-1-2-1-3-1s-2 1-3 1c0 0-1 0-1 1-1 0-1 1-2 1-1 1-1 2-1 3-1 1-1 2-1 3 1 1 1 2 2 3v1c1 0 1 1 1 1l9 7s1 1 2 1c0 0 1 1 2 1s2-1 3-1 1-1 2-1l1-1zm-16-10c-1 0-1-1-1-1v-2l1-1c0-1 1-1 1-1h2c1 0 1 1 1 1l8 7h1c0 1 0 1 1 1v1c-1 1-1 1-1 2-1 0-1 1-2 1h-2l-1-1-8-7zm-2 32c1-1 1-1 1-2s-1-1-1-2l-17-12c-1-1-1-1-2-1s-1 1-1 1c-1 1-1 1-1 2l1 1 17 13c1 0 1 1 2 0h1zm-17 22c1-1 2-2 2-3v-3c-1-1-1-2-2-3h-1c0-1 0-1-1-1l-8-6c-1-1-1-1-2-1h-1c-1-1-2-1-2-1-1 0-2 1-3 1s-1 1-2 1c0 1-1 1-1 2-1 1-1 2-1 3v3c0 1 1 2 1 3h1c0 1 1 1 1 1l9 6c1 1 1 1 2 1 1 1 2 1 3 1s2-1 3-1l1-1c1-1 1-1 1-2zm-16-7-1-1s-1 0-1-1v-1c0-1 0-1 1-2 0 0 0-1 1-1h3l9 6 1 1v4c-1 0-1 1-1 1h-4l-8-6zM134 328c0-1 1-2 1-3v-3c-1-1-1-2-2-3h-1c0-1 0-1-1-1l-9-6s-1 0-1-1h-4c-1 0-2 0-3 1l-1 1c-1 1-1 1-1 2-1 1-2 2-2 3s0 2 1 3c0 1 1 2 1 2 0 1 1 1 1 1 0 1 1 1 1 1l9 6c1 0 2 0 3 1h2c1 0 2-1 3-1s1-1 2-1c0-1 0-1 1-2zm-18-7-1-1v-3c1-1 1-1 2-1 0 0 0-1 1-1l1 1h1l9 6h1v4l-1 1h-3l-10-6zm0 36c1-1 1-2 1-4v-3c-1 0-1-1-2-2l-1-1h-1l-9-6h-2c-1-1-2-1-3 0-1 0-2 0-3 1 0 0-1 0-1 1-1 0-1 1-1 1-1 2-1 3-1 4v3c0 1 1 2 2 2 0 1 0 1 1 1 0 0 0 1 1 1l9 5c1 0 2 1 2 1h3c1 0 2-1 3-1 0-1 1-1 1-1 1-1 1-1 1-2zm-17-6s-1 0-1-1h-1v-2s0-1 1-1c0-1 0-1 1-2h3l9 6h1c0 1 1 1 1 1v1c0 1 0 1-1 2 0 0 0 1-1 1 0 0 0 1-1 1 0 0-1 0-1-1h-1l-9-5zm4 31v-2c0-1-1-1-1-1l-19-10h-2c-1 0-1 1-1 1-1 1-1 1-1 2 1 1 1 1 2 1l19 10h2l1-1zm-11 21c1 0 1-1 0-1 0-1 0-1-1-2l-19-9h-2l-1 1v2s0 1 1 1l19 9c1 1 1 1 2 1 1-1 1-1 1-2zm-11 26c0-1 1-2 0-3v-3c-1-1-1-2-2-2 0-1-1-1-1-1s-1 0-1-1l-10-4h-1c-1-1-1-1-2-1 0 0-1 0-2 1-1 0-2 0-3 1l-1 1c0 1-1 1-1 2-1 1-1 3-1 4s1 2 1 2c0 1 1 2 2 3h1c0 1 1 1 1 1l10 4c1 1 1 1 2 1h3c1-1 2-1 3-2l1-1c0-1 0-1 1-2zm-18-4c-1 0-1 0-1-1h-1v-3c0-1 1-1 1-2h3l10 4 1 1 1 1v2c-1 1-1 2-1 2h-1c-1 1-1 0-2 0l-10-4zm7 31c1-1 1-2 0-2 0-1 0-1-1-1l-20-8h-2l-1 1v2c0 1 1 1 1 1l20 8h2c1 0 1-1 1-1zm-9 26v-5l-1-1c0-1-1-2-2-2 0 0 0-1-1-1h-1l-10-4h-5c-1 1-2 1-3 2l-1 1c0 1-1 2-1 2v4c0 1 0 2 1 3l2 2h1l1 1 10 3h3c1 1 2 0 3 0l2-2c1 0 1 0 1-1s1-1 1-2zm-18-3h-2c0-1-1-1-1-2 0 0 0-1 1-1v-2c1 0 1 0 1-1h2v1l11 3h1v1c1 0 1 1 1 1v2c-1 0-1 1-1 1l-1 1h-2l-10-4zm10 30s0-1-1-2l-1-1-21-5h-1c-1 0-1 1-1 1-1 1 0 1 0 2s1 1 1 1l21 6h2c0-1 0-1 1-2zm-8 27c1-1 1-2 0-3v-2s-1 0-1-1l-2-2h-1c-1 0-1 0-1-1l-11-2h-2c-1 0-2 0-3 1-1 0-2 1-2 2-1 0-1 0-1 1-1 1-1 1-1 2v4c0 1 1 1 1 2l2 2c1 0 1 0 2 1h1l10 2h6c0-1 1-1 2-2 0-1 1-1 1-2v-2zm-18 0-1-1h-1c0-1 0-1-1-1v-2c1-1 1-1 1-2h1c0-1 1-1 1-1 1 0 1 1 1 1l11 2h1v1c1 0 1 0 1 1v2s0 1-1 1c0 0 0 1-1 1h-2l-10-2zm11 33c1-1 1-2 0-3v-2c-1 0-1-1-1-1-1-1-2-1-3-2h-2l-10-2h-3c-1 0-2 0-3 1l-2 2s0 1-1 1v2c-1 1 0 3 0 4s1 2 1 2c1 1 2 1 3 2h1c0 1 1 1 1 1l11 1c0 1 1 1 2 1 1-1 2-1 3-1l2-2c0-1 1-1 1-2v-2zm-18 0h-2c0-1-1-1-1-2v-1c0-1 0-2 1-2l1-1h2l10 2h2v1s1 0 1 1v2s0 1-1 1c0 1 0 1-1 1h-2l-10-2zm13 29v-1c0-1-1-1-1-1l-22-4s-1 0-1 1c-1 0-1 0-1 1v2c1 0 1 0 2 1l21 3h1c1-1 1-1 1-2zm-3 28v-3c-1-1-1-1-1-2 0 0-1 0-1-1-1 0-1-1-2-1l-1-1h-2l-10-1h-3c-1 0-2 0-2 1-1 0-2 1-3 2v1c-1 1-1 2-1 2v4c1 1 1 2 2 2l2 2h2c0 1 0 1 1 1l10 1h3c1 0 2 0 3-1l2-2c0-1 0-1 1-2v-2zm-19 1h-1l-1-1v-4s1 0 1-1h2l11 1 1 1h1v1s1 1 0 2v1c0 1-1 1-1 1 0 1-1 1-1 1h-1l-11-2zm16 33v-4c-1 0-1-1-1-1l-1-1c-1-1-2-1-2-2h-3l-11-1H7c-1 0-2 1-3 1 0 1-1 2-2 3v1c-1 1-1 1-1 2s0 3 1 4c0 1 1 1 1 2 1 1 2 1 3 2h2l11 1h3s1-1 2-1c1-1 2-2 2-3l1-1v-2zm-18 2c-1 0-1 0-1-1H7s-1 0-1-1v-3c0-1 1-1 1-1s1 0 1-1c1 0 1 0 1 1h12v1h1v1c1 0 1 1 1 2l-1 1c0 1 0 1-1 1H9zm17 31c0-1 0-2-1-3 0-1 0-1-1-1 0-1 0-1-1-2 0 0-1-1-2-1h-2l-11-1H6s0 1-1 1-1 0-2 1-2 1-2 2-1 1-1 2v2c0 1 0 2 1 3 0 1 1 2 2 3 0 0 1 1 2 1h1l1 1h14l2-2c1 0 2-1 2-2 0 0 1-1 1-2v-2zm-18 3H6l-1-1c0-1-1-1-1-2s1-1 1-2l1-1h14v1c1 0 1 0 1 1v3s0 1-1 1H8zm18 26c0-1 0-1-1-2l-1-1-22 1s-1 0-1 1c-1 0-1 1-1 1 0 1 0 1 1 2h23c1 0 1 0 2-1v-1zm1 23c0-1 0-2-1-2l-1-1-22 2s-1 0-1 1c-1 0-1 1-1 1 0 1 0 1 1 2 0 0 1 1 1 0l22-1s1 0 1-1c1 0 1-1 1-1zm2 29c0-1 0-3-1-4 0 0-1 0-1-1 0 0-1 0-1-1-1 0-2-1-3-1h-2l-11 1H8c-1 1-2 1-3 2 0 0-1 1-1 2-1 1-1 1-1 2v2c0 1 1 2 1 3 1 1 1 2 2 3 1 0 2 0 3 1h2l11-1h2c1-1 2-1 3-2l2-2v-4zm-18 4H9s-1 0-1-1v-3c0-1 0-1 1-1 0 0 0-1 1-1h1l10-1h1l1 1c1 0 1 0 1 1 0 0 0 1 1 1 0 1 0 2-1 2v1h-1l-1 1H11zm21 24v-1c-1-1-2-1-2-1l-21 3H7c0 1-1 2 0 2v2h2l21-2c1-1 1-1 2-1v-2zm5 28c-1-1-1-3-2-3 0-1 0-1-1-2h-1c-1-1-2-1-3-1h-2l-11 2h-2c-1 1-2 1-2 2-1 1-1 2-2 3v3c0 2 1 3 1 4 1 1 2 1 3 2 0 0 1 0 2 1h2l1-1 10-1c1 0 2-1 3-1s1-1 2-2c1 0 1-1 1-2 1-1 1-1 1-2v-2zm-18 6h-2s-1 0-1-1c0 0 0-1-1-1v-2l1-1 1-1h1l11-2h2c0 1 0 1 1 1v3c0 1 0 1-1 2h-1l-11 2zm23 22c0-1-1-1-1-2h-2l-21 5s-1 0-1 1c-1 0-1 1 0 1v2h2l21-5c1 0 1 0 2-1v-1zM48 885c0-1-1-2-2-3 0 0 0-1-1-1l-1-1h-5l-11 3h-1l-1 1c-1 0-1 1-2 2 0 0-1 1-1 2v4c0 1 1 2 2 3 0 1 1 2 2 2s2 1 3 1h1c1 0 1-1 1-1l11-2c1-1 1-1 2-1l2-2c1-1 1-2 1-3v-4zm-17 8h-2l-1-1s0-1-1-1v-2l1-1 1-1h1l10-3h2l1 1 1 1v2c0 1 0 1-1 1 0 1 0 1-1 1l-11 3zm26 25c0-2-1-3-2-3 0-1-1-1-1-1 0-1-1-1-1-1-1 0-2-1-3-1 0 0-1 0-1 1h-2l-10 3s-1 0-1 1h-1l-2 2c-1 1-1 2-1 3v4c1 1 1 2 2 3s2 1 3 1c0 1 1 1 2 1h2l1-1 10-3c1 0 2 0 2-1 1 0 2-1 2-2 1-1 1-2 1-3v-3zm-17 8h-3v-2c-1 0-1-1-1-1 0-1 1-1 1-2h1s0-1 1-1l10-3h2s1 0 1 1l1 1v2s0 1-1 1l-1 1-11 3zm26 20c0-1-1-1-1-2h-2l-20 7c-1 0-1 0-2 1v2l1 1h2l20-6 2-2v-1zm10 26c-1-1-1-2-2-3-1 0-1 0-1-1h-2c-1-1-2-1-3-1l-1 1h-1l-10 4h-1c-1 0-1 0-1 1-1 0-2 1-2 2-1 1-1 2-1 3v3c1 2 2 3 2 3 1 1 2 2 3 2h5l10-4c1 0 2-1 2-1 1-1 2-1 2-2 1-1 1-2 1-3v-4zm-16 10h-2c-1 0-1 0-2-1v-1c-1-1-1-1-1-2l1-1s0-1 1-1l11-4h3c0 1 0 1 1 2v2l-1 1h-1v1l-10 4zm29 21c-1-1-2-2-2-3h-2c0-1-1-1-1-1h-5l-10 5h-1c-1 0-1 1-1 1-1 1-2 1-2 2-1 1-1 2-1 3v2s0 1 1 2c0 1 1 2 2 3 1 0 2 1 2 1h6l10-5s1 0 2-1c0-1 1-1 1-2 1-1 1-2 1-3v-4zm-16 10c0 1-1 1-1 1h-1s-1 0-1-1c-1 0-1-1-1-1 0-1-1-1-1-2 1 0 1-1 1-1s0-1 1-1h1l9-4 1-1h1c1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 2 0 0 0 1-1 1v1h-1l-10 4zm30 21c-1-1-1-2-2-3-1 0-1-1-2-1h-1c-1 0-2-1-3 0h-2l-10 5c-1 0-1 0-1 1h-1c-1 1-1 2-2 3v6l3 3c1 1 2 1 2 1 1 0 2 1 3 0h3l9-5c1 0 2-1 2-1 1-1 2-2 2-3 0 0 1-1 1-3v-1c-1-1-1-2-1-2zm-15 11h-2c-1 0-1 0-1-1-1 0-1 0-1-1-1 0-1-1-1-1v-2c1 0 1 0 1-1h1l10-5h3c0 1 0 1 1 2v3h-1l-1 1-9 5zm28 14c0-1-1-1-1-1h-2l-19 10s-1 1-1 2v1c0 1 1 1 1 1h2l19-10c1 0 1-1 1-1v-2zm11 20c0-1 0-1-1-1h-2l-18 11c-1 0-1 1-1 2v1c0 1 1 1 1 1h2l18-11c1 0 1-1 2-1 0-1 0-2-1-2zm15 24-3-3h-6c-1 0-1 1-2 1l-8 6c-1 0-1 0-2 1v1c-1 0-1 1-2 2v3c0 1 0 1 1 2v1c1 2 2 2 3 3 1 0 2 1 3 1h3c0-1 0-1 1-1 0 0 1 0 1-1l9-6c1 0 1-1 2-1 0-1 1-2 1-3v-4c0-1-1-1-1-2zm-14 13h-3s0-1-1-1c0-1 0-1-1-2l1-1v-1h1l9-6 1-1h2l1 1c1 1 1 2 1 2v1c0 1-1 1-1 1l-1 1-9 6zm30 11-1-1c-1 0-1 0-2 1l-18 12s0 1-1 1c0 1 0 1 1 2l1 1c1 0 1 0 2-1l18-11c0-1 1-1 1-2 0 0 0-1-1-2zm17 23c-1-1-2-2-3-2 0 0 0-1-1-1h-4l-1 1c-1 0-1 0-1 1l-9 6c-1 0-1 1-1 1s-1 0-1 1-1 1-1 2v5c1 1 1 1 1 2 1 1 2 2 3 2 1 1 2 1 3 1s2 0 3-1h1l1-1 9-6c0-1 1-1 1-2l2-2v-4l-1-1c0-1 0-1-1-2zm-13 14h-3s-1 0-1-1-1-1-1-2v-1s1 0 1-1h1l8-7h1l1-1 1 1c1 0 1 0 2 1v4h-1l-9 7zm31 8c-1 0-1 0-2-1l-1 1-17 14s-1 0-1 1 0 1 1 2h1c1 1 1 0 2 0l16-14c1 0 1 0 1-1v-2zm18 22c-1-1-2-2-3-2 0-1-1-1-1-1h-2c-1 0-1 0-2 1h-1l-1 1-8 7-1 1c-1 0-1 1-1 1-1 1-1 2-1 3v3l1 1c0 1 1 2 1 2 1 1 2 2 3 2 1 1 2 1 3 1s2-1 3-1l1-1h1l8-8s1-1 1-2c1 0 1-1 1-2v-3c0-1 0-1-1-2 0 0 0-1-1-1zm-11 14c-1 0-1 1-1 1h-2c-1 0-1 0-2-1 0-1 0-1-1-1v-2c1 0 1 0 1-1h1l8-8h1c1-1 1 0 2 0l1 1 1 1v1c0 1 0 1-1 1v1l-8 7zm34 10c-1-1-2-2-3-2h-3c-1 0-2 0-2 1h-1c-1 0-1 1-1 1l-8 8s-1 0-1 1l-1 1v5c0 1 0 1 1 2 0 0 0 1 1 1 1 1 2 2 3 2 1 1 2 1 3 1s2-1 3-1c0 0 0-1 1-1l1-1 7-7 2-2c0-1 0-2 1-3 0-1 0-2-1-3v-1l-2-2zm-11 15v1h-3l-1-1-1-1v-2l1-1 8-8c1 0 1-1 1-1h2l1 1c1 1 1 1 1 2v2l-1 1-8 7zm32 5c-1-1-1-1-2-1s-1 0-2 1l-14 16-1 1c0 1 1 1 1 2h3l15-16v-3zm21 19c-1-1-3-2-4-2h-3c-1 0-1 1-2 1s-1 0-1 1c0 0-1 0-1 1l-7 8-1 1v1c-1 1-1 2-1 3s0 2 1 3c0 0 0 1 1 1 0 1 0 1 1 2 1 0 2 1 3 1 1 1 2 1 3 0 1 0 2 0 3-1l1-1h1l7-9s1-1 1-2v-6s-1 0-1-1l-1-1zm-10 16-1 1h-2s-1 0-1-1c-1 0-1-1-1-1v-3h1l6-8 1-1 1-1h1c1 0 1 1 2 1 0 1 1 1 1 1v3h-1l-7 9zm36 5c-1-1-3-1-4-2h-3l-2 2h-1c0 1-1 1-1 1l-6 9c-1 0-1 1-1 1l-1 1v3c0 1 0 2 1 3 0 0 0 1 1 1 0 1 0 1 1 2 1 0 2 1 3 1h3c1 0 2-1 3-1 0 0 0-1 1-1 0 0 0-1 1-1l6-9c1 0 1-1 1-2 1-1 1-1 1-2s0-2-1-3c0-1-1-1-1-2l-1-1zm-9 16c0 1 0 1-1 1v1h-2l-1-1c-1 0-1-1-1-1-1-1-1-1-1-2l1-1 7-9v-1h4c0 1 1 1 1 2v3l-7 8zm36 4c-1-1-3-1-4-2h-1c-1 0-1 1-2 1s-1 0-2 1c0 0-1 0-1 1 0 0-1 0-1 1l-6 9-1 1v4c0 1 0 2 1 3l1 1s0 1 1 1c1 1 2 1 3 2 2 0 3 0 3-1 1 0 2 0 3-1l1-1s0-1 1-1l6-9s0-1 1-2v-3c0-1 0-2-1-3 0 0 0-1-1-1l-1-1zm-8 17h-1v1h-3l-2-2v-2c1 0 1-1 1-1l6-9c0-1 1-1 1-1h3c1 1 1 1 1 2 1 0 1 1 1 1s0 1-1 1v1l-6 9zM352 1313h-2l-1 1-11 19s-1 1 0 1c0 1 0 1 1 2h1c1 0 1-1 2-1l11-18v-2c0-1 0-1-1-2zm21 13h-2c-1 0-1 0-1 1l-12 18v2l1 1c1 0 1 1 2 0 0 0 1 0 1-1l11-18c1 0 1-1 1-2l-1-1zm24 14c-1-1-2-1-3-1h-3c-1 1-2 1-2 2-1 0-1 0-1 1 0 0-1 0-1 1l-5 9c0 1-1 1-1 1v4c0 1 1 2 1 3s1 1 1 1l2 2c1 0 2 1 3 1 2 0 2-1 3-1s2-1 3-1c0-1 0-1 1-1v-2l5-9c1-1 1-1 1-2v-3c0-1 0-2-1-3l-1-1c-1-1-1-1-2-1zm-6 17v1l-1 1h-3l-1-1c0-1-1-1-1-2v-1c1 0 1 0 1-1l5-9v-1h1v-1h1c1 0 1 0 2 1 1 0 1 0 1 1 1 0 1 1 1 1v1l-1 1-5 9zm31-5h-1c-1 0-1 1-2 1l-9 20v2l1 1h2c1 0 1-1 1-1l10-20v-1l-2-2zm26 12c-1-1-2-1-3-1s-1 0-2 1h-1c-1 1-2 1-2 2-1 0-1 1-1 1l-1 1-4 10v1l-1 1c0 1 0 2 1 3 0 1 0 2 1 3l1 1c1 0 2 1 2 1 1 0 3 1 4 1 1-1 2-1 3-1 0-1 1-1 2-2v-1c1 0 1-1 1-1l4-10c1-1 1-2 1-3v-2c-1-1-1-2-2-3l-1-1c-1 0-1-1-2-1zm-4 18s0 1-1 1v1h-3c-1 0-1-1-2-1v-3l4-10 1-1c0-1 0-1 1-1h2c1 0 1 1 2 1v3l-4 10zm30-8s-1 0-1 1c-1 0-1 0-2 1l-7 20v2l1 1h2c1 0 1-1 1-1l8-21v-1l-2-2zm27 10c-2-1-3-1-4 0h-1c-1 0-1 0-2 1l-2 2v1s-1 0-1 1l-3 10v5c1 1 1 2 2 3 1 0 1 1 2 1 0 0 1 0 1 1h4c1 0 2-1 3-1 0-1 1-1 2-2v-1c0-1 1-1 1-1l3-11v-5c-1-1-1-2-2-2 0-1-1-1-1-1-1-1-2-1-2-1zm-3 18v2c-1 0-1 0-2 1 0 0-1 0-1-1h-2c0-1 0-1-1-2v-1s1 0 1-1l3-10v-1l1-1h2c1 0 2 1 2 1l1 1v2l-4 10zm35-9h-4l-1 1c-1 0-1 0-1 1-1 0-2 1-2 2-1 0-1 0-1 1v1l-3 10v3c0 1 0 2 1 3 0 0 1 1 1 2 1 0 1 1 2 1 0 0 1 0 2 1h3c1-1 2-1 3-2 1 0 1-1 2-2v-1c1 0 1-1 1-1l2-10c1-1 1-2 1-3s-1-2-1-3-1-1-2-2l-1-1c-1 0-1-1-2-1zm-1 19c-1 0-1 0-1 1v1h-3c-1 0-1 0-2-1v-1c-1 0-1 0-1-1 0 0 1 0 1-1l2-10v-1h1v-1h4l1 1v2l-2 11zm30-12c-1 0-2 0-2 1-1 0-1 0-1 1l-5 21v2s1 0 1 1c1 0 1 0 2-1 1 0 1-1 1-1l5-21v-2l-1-1zm27 6c-1-1-2-1-4 0h-1c0 1-1 1-1 1-1 1-1 2-2 2v1c0 1-1 1-1 2l-2 10v3c0 1 1 2 1 2 0 1 1 2 2 3 0 0 1 0 1 1h6c1 0 2-1 3-1 0-1 1-2 1-3 1 0 1 0 1-1v-1l2-11v-2c0-1 0-2-1-3l-2-2s0-1-1-1h-2zm0 18v1c-1 0-1 1-1 1s-1 0-1 1h-2c-1 0-1-1-1-1-1 0-1-1-1-1v-2l2-10v-2h1c0-1 0-1 1-1h1c1 0 1 0 2 1 0 0 1 0 1 1v2l-2 10zm33-14c-1 0-2 0-3 1h-2c0 1-1 1-1 1-1 1-1 2-2 3v2l-2 11v2c0 1 1 2 1 3l2 2c1 0 1 0 2 1h5c1 0 2-1 3-2 1 0 1-1 2-2v-2l2-11v-3s-1-1-1-2c-1-1-1-2-2-2-1-1-1-1-2-1 0 0-1 0-2-1zm1 19v1l-1 1-1 1h-2l-1-1c-1 0-1 0-1-1v-2l1-10v-1s0-1 1-1c0-1 1-1 1-1h2s1 0 1 1h1v2l-1 11zm33-15c-2-1-3 0-4 0 0 0-1 0-1 1-1 0-1 0-2 1 0 0-1 1-1 2v1c0 1-1 1-1 2l-1 10v2s1 0 1 1 0 2 1 2c0 1 1 2 2 2 0 1 1 1 2 1h1c2 1 3 0 4 0s2-1 3-2c0 0 1-1 1-2v-1c1-1 1-1 1-2v-10c1-1 1-2 0-3 0-1 0-1-1-2 0-1-1-2-2-2 0-1-1-1-2-1h-1zm1 18v2c-1 0-1 0-2 1h-3c0-1 0-1-1-1v-2l1-11v-2c1 0 1-1 1-1h2c1 0 1 0 2 1h1v2l-1 11zm27-17h-2c0 1-1 1-1 2v23c1 0 1 1 2 1 0 0 1 0 1-1 1 0 1-1 1-1l1-22s0-1-1-2h-1zm22 0s-1 0-1 1c-1 0-1 1-1 1l1 22v1c1 1 1 1 2 1s1 0 2-1v-23l-1-1c-1-1-1-1-2-1zm28-1c-1 0-2 1-3 1 0 1-1 1-1 1l-1 1c-1 1-1 2-1 3v1c0 1-1 1-1 2l1 10c0 1 0 1 1 2v1c0 1 1 1 1 2 1 1 2 1 3 2h4c1 0 2 0 3-1 1 0 2-1 2-2 1-1 1-2 1-2v-2c1 0 1-1 0-1v-11c0-1-1-1-1-2s-1-2-1-2c-1-1-2-2-3-2 0 0-1-1-2-1h-2zm5 18v2c0 1-1 1-1 1-1 1-1 1-2 1h-1c-1-1-1-1-2-1v-2l-1-11v-2c1 0 1 0 1-1h3c1 0 1 0 2 1v2l1 10zm25-20c-1 0-1 0-2 1v1l2 22v1c1 1 1 1 2 1 0 0 1 0 1-1 1 0 1-1 1-2l-2-21c0-1 0-1-1-1 0-1-1-1-1-1zm28-3c-2 0-3 0-4 1 0 0 0 1-1 1 0 0 0 1-1 1 0 1 0 2-1 3v2l2 11v2c1 1 1 2 2 3 1 0 2 1 3 1h1c1 1 2 0 2 0 2 0 3 0 4-1 1 0 1-1 2-2 0-1 1-2 1-3v-2l-2-11v-2c-1-1-1-2-2-2-1-1-2-2-3-2h-3zm5 17v2c0 1 0 1-1 1 0 1-1 1-1 1h-2l-1-1s-1 0-1-1v-1l-1-10v-2c0-1 0-1 1-1 0-1 1-1 1-1h2c1 0 1 1 1 1l1 1v1l1 10zm23-22c-1 0-2 1-2 1v2l4 21c0 1 0 1 1 1 0 1 1 1 1 1 1 0 1-1 2-1v-2l-4-21s0-1-1-1c0-1-1-1-1-1zm27-5c-1 0-2 1-3 1-1 1-1 1-1 2 0 0-1 0-1 1s-1 2-1 3v1s0 1 1 1l2 10v2c1 0 1 0 1 1l2 2c1 0 2 1 3 1h3c2 0 3-1 4-2 0 0 1-1 1-2 1-1 1-2 1-3v-2l-3-11s0-1-1-2c0-1-1-1-2-2 0-1-1-1-2-1h-4zm7 17c1 0 1 1 1 1l-1 1v1c-1 0-1 1-2 1h-1c-1 0-1-1-2-1v-1l-1-1-2-10v-2s0-1 1-1c0 0 0-1 1-1h2s1 0 1 1l1 1 2 11zm26-25c-2 0-3 1-4 1 0 1 0 1-1 2v1c-1 1-1 2-1 3v1s0 1 1 1l3 10v2l1 1c0 1 1 1 2 2 0 0 1 1 2 1h4c1-1 2-1 3-2s2-2 2-3v-5l-3-10c0-1-1-2-1-2 0-1-1-2-2-2-1-1-2-1-3-2h-1c-1 0-2 1-2 1zm8 16v2c0 1 0 1-1 2h-1c-1 1-1 1-2 0h-1l-1-1v-1l-3-10v-3c1 0 1-1 2-1h3v1l1 1 3 10zm20-25c-1 0-1 1-1 1-1 1-1 1-1 2l6 21c1 0 1 1 2 1h1c1 0 1 0 2-1v-2l-6-20c-1-1-1-1-1-2h-2zM934 1373c-1 0-2 1-3 2 0 0 0 1-1 1v1c0 1-1 2-1 3s0 1 1 1v2l3 10c1 0 1 1 1 1s0 1 1 1c0 1 1 1 2 2 0 0 1 1 3 1h1c1 0 1 0 2-1 1 0 3-1 3-2 1 0 2-1 2-2v-5l-4-10c0-1-1-2-1-3-1 0-1-1-2-1-1-1-2-1-3-2h-2c0 1-1 1-2 1zm9 16 1 1v1l-1 1c0 1-1 1-1 1-1 0-2 1-2 0h-1l-1-1v-1l-4-10v-3c1 0 1 0 2-1h3v1l1 1 3 10zm23-28c-2 0-3 1-3 2-1 0-1 0-1 1-1 0-1 1-1 1v5l5 10v2s1 0 1 1c0 0 1 1 2 1 1 1 2 1 3 1h3c2-1 3-2 4-3 0 0 1-1 1-2v-5l-5-10c0-1 0-2-1-3 0 0-1-1-2-1-1-1-2-1-3-1h-2s-1 0-1 1zm9 15 1 1v1c0 1-1 1-1 1 0 1-1 1-1 1-1 1-1 1-2 1 0 0-1 0-1-1 0 0-1 0-1-1l-4-10-1-1v-1c0-1 1-1 1-1 0-1 1-1 1-1 1-1 1-1 2-1l1 1s1 0 1 1l4 10zm21-29c-1 0-2 1-3 2 0 0 0 1-1 1v7l5 9c0 1 1 1 1 2v1c1 0 2 1 3 1 1 1 2 1 3 1h1c1 0 2-1 2-1 1-1 2-1 3-2s1-2 1-3c1-1 1-2 1-3-1 0-1 0-1-1v-1l-5-10s-1-1-1-2c-1-1-2-1-2-1-1-1-2-1-3-1h-2c-1 0-1 0-2 1zm11 15v3c-1 0-1 1-2 1h-3v-1h-1l-4-10-1-1v-1c0-1 0-1 1-1 0-1 0-1 1-1 1-1 1-1 2-1 0 0 1 0 1 1h1v1l5 10zm14-28-1 1v2l10 19c1 0 1 1 2 1h1c1-1 1-1 1-2 1 0 1-1 0-1l-10-19c0-1-1-1-1-1-1-1-1 0-2 0zm20-11-1 1v2l11 18c1 1 1 1 2 1h2s0-1 1-1c0-1 0-2-1-2l-11-18c0-1-1-1-1-1-1-1-1-1-2 0zm25-15c-1 0-2 1-2 2-1 0-1 1-1 1v6l1 1 5 9 1 1 1 1 2 2h5c1-1 1-1 2-1 1-1 2-2 2-3 1-1 1-2 1-3 1-1 1-1 0-2v-2l-1-1-5-9-2-2s-1-1-2-1c-1-1-2-1-3-1s-1 0-2 1c0 0-1 0-2 1zm13 14v3c-1 0-1 1-2 1h-1c-1 1-1 0-1 0h-1c0-1-1-1-1-1l-5-9-1-1v-2l2-2h3v1h1l6 10zm11-30c-1 0-1 1-1 1v2l12 18s1 0 2 1c0 0 1 0 1-1 1 0 1 0 1-1v-2l-12-18s-1 0-2-1c0 0-1 0-1 1zm23-17-3 3v7c1 0 1 0 1 1l7 8v1l1 1c1 1 2 1 3 1 1 1 2 1 3 1 0-1 1-1 1-1 1 0 2-1 2-1l3-3v-5c0-1 0-1-1-2v-1l-7-8c0-1-1-1-2-2 0-1-1-1-2-1h-5l-1 1zm13 13s0 1 1 1v2c-1 1-1 1-2 1 0 1-1 1-1 1h-1c-1 0-1 0-1-1h-1l-6-9-1-1v-2l1-1c1-1 1-1 2-1h1l1 1h1l6 9zm9-30c-1 0-1 1-1 1 0 1 0 1 1 2l13 16c1 1 1 1 2 1h1c1-1 1-1 1-2v-1l-14-17s-1-1-2-1c0 0-1 0-1 1zm21-18c-1 0-1 1-2 3v3s0 1 1 2v1c0 1 1 1 1 1l7 8 1 1 1 1c1 0 2 1 3 1h3c0-1 1-1 1-1 1 0 1-1 2-1 1-1 2-2 2-3s1-2 0-3v-3l-1-1s0-1-1-1l-7-8c0-1-1-1-2-2h-2c-1-1-2-1-3 0h-2l-2 2zm15 11s0 1 1 1v2c0 1-1 1-1 1-1 1-1 1-2 1h-2s0-1-1-1l-7-8c0-1-1-1-1-1v-2c1 0 1-1 1-1 1-1 1-1 2-1h1c1 0 1 0 1 1h1l7 8zm10-34c-1 1-2 2-2 3v3c0 1 0 2 1 2v1c0 1 1 1 1 2l8 7c0 1 0 1 1 1l1 1h5c1 0 1 0 2-1 0 0 1 0 1-1 1-1 2-2 2-3 1-1 1-2 1-3s-1-2-1-3c0 0-1 0-1-1l-1-1-7-7-2-2c-1 0-2 0-3-1-1 0-2 0-3 1 0 0-1 0-1 1-1 0-1 0-2 1zm15 11h1v3l-1 1-1 1h-1c-1 0-1 0-1-1h-1l-8-8-1-1v-2s1 0 1-1c1-1 1-1 2-1h2l1 1 7 8zm6-32c-1 0-1 1-1 1 0 1 0 2 1 2l15 15c0 1 1 1 2 1 0 0 1 0 1-1 1 0 1-1 1-1 0-1 0-2-1-2l-15-15s-1-1-2-1c0 0-1 0-1 1zm19-21c-1 1-2 2-2 3v3c0 1 0 2 1 3l1 1v1l8 7c1 0 1 1 1 1h1c1 1 2 1 3 1h3c1-1 1-1 2-1 0-1 1-1 1-2 1-1 2-2 2-3v-3c0-1 0-2-1-2 0-1 0-1-1-1v-1l-8-8c-1 0-2-1-2-1-1 0-2-1-3-1s-2 0-3 1c-1 0-1 0-2 1 0 0-1 0-1 1zm16 10v1s1 0 1 1v1l-1 1c-1 1-1 1-2 1 0 1 0 1-1 1 0-1-1-1-1-1h-1l-8-8v-1h-1v-1c0-1 1-1 1-2 1-1 1-1 2-1h2l1 1 8 7zm6-36c-1 1-2 2-2 3v4s0 1 1 2c0 0 0 1 1 1 0 0 0 1 1 1l8 7s1 0 1 1h1c1 0 2 1 3 1s2-1 3-1l1-1c1 0 1-1 2-1 0-1 1-2 1-3v-3c0-1 0-2-1-3 0 0 0-1-1-1 0 0 0-1-1-1l-8-7s-1-1-2-1-2-1-3-1-2 1-3 1c0 0-1 0-1 1-1 0-1 1-1 1zm16 10c1 0 1 1 1 1v1c0 1 0 1-1 2l-1 1h-3v-1l-9-7-1-1v-1c0-1 1-1 1-2l1-1h3v1l9 7zm4-36c-1 1-1 2-2 3v1c0 1 1 1 1 2s0 2 1 2c0 1 0 1 1 1 0 1 0 1 1 1l8 7h1c0 1 1 1 1 1h6l1-1 2-2c1-1 1-2 1-3v-3c0-1 0-2-1-3l-1-1h-1l-8-7c-1 0-2-1-3-1 0 0-1-1-2-1s-2 1-3 1-1 1-2 1c0 1-1 1-1 2zm17 8v1s1 0 1 1v1s0 1-1 1c0 1-1 1-1 2h-2l-1-1-9-6v-1h-1v-2s0-1 1-2c0 0 0-1 1-1h2l1 1 9 6zm-1-31v1c0 1 0 1 1 2l18 12h1c1 0 1 0 2-1v-2s0-1-1-1l-18-12s-1-1-1 0c-1 0-1 0-2 1zm13-20v2c0 1 0 1 1 2l18 11h2l1-1v-2s0-1-1-1l-18-11c0-1-1-1-2-1 0 1-1 1-1 1zm15-25c0 1-1 3-1 4v1c0 1 0 1 1 2 0 1 0 1 1 2 0 0 0 1 1 1l1 1 9 5 1 1h1c1 0 2 1 3 0 1 0 2 0 3-1 0 0 1 0 1-1 1 0 1-1 1-1 1-1 2-3 2-4s0-2-1-3c0-1-1-1-1-2l-1-1s-1 0-1-1l-9-5c-1-1-2-1-3-1 0-1-1-1-2 0-1 0-2 0-3 1-1 0-1 0-2 1 0 0 0 1-1 1zm18 7v1h1v3c-1 1-1 1-1 2h-3s0-1-1-1l-9-5-1-1v-3c0-1 1-1 1-2h3v1l10 5zm-4-32v2c0 1 0 1 1 2l19 10h1c1 0 1-1 2-1v-2l-1-1-19-10c0-1-1-1-2-1 0 1-1 1-1 1zM1334 1005c-1 2-1 3-1 4v1c0 1 0 1 1 2 0 1 1 1 1 2 1 0 1 1 1 1h1l10 5 1 1h4c1 0 2-1 3-1 0-1 1-1 1-2l1-1c1-2 1-3 1-4s0-2-1-3c0-1-1-1-1-2-1 0-1-1-1-1h-1l-10-5c-1-1-2-1-2-1h-3c-1 0-2 1-3 1 0 1-1 1-1 2-1 0-1 1-1 1zm18 6c1 0 1 0 1 1v3l-1 1s-1 0-1 1c0 0-1 0-1-1h-1l-10-5h-1v-1l-1-1s0-1 1-2c0 0 0-1 1-1l1-1s1 0 1 1h1l10 5zm-6-31c-1 0-1 1 0 1 0 1 0 1 1 2l20 8h1c1 0 1 0 2-1v-2c-1 0-1-1-2-1l-19-8c-1-1-1-1-2 0-1 0-1 0-1 1zm11-26c-1 1-1 2-1 3s0 1 1 2v1c1 1 1 2 2 2l1 1h1l10 4c1 0 1 1 2 1h1c1 0 2 0 3-1 0 0 1 0 2-1 0-1 1-1 1-1 1-1 1-2 1-2 1-2 1-3 1-4-1-1-1-2-1-3-1 0-1-1-2-2h-1l-1-1-10-4h-6c-1 0-1 1-2 2-1 0-1 0-1 1-1 0-1 1-1 2zm18 3s1 0 1 1h1v3c0 1-1 1-1 2h-3l-10-4h-1c-1 0-1-1-1-1v-3l1-1 1-1h2l10 4zm-6-36c-1 1-1 3-1 4 1 0 1 1 1 1v2c1 0 2 1 2 2h1c1 0 1 1 1 1l11 4h5l2-2c1 0 1-1 1-1 1-1 1-1 1-2 1-1 1-2 1-3 0-2-1-2-1-3-1-1-1-2-2-2 0-1-1-1-1-1s-1 0-1-1l-10-3c-1-1-2-1-3-1h-2c-1 1-2 1-3 2l-1 1c0 1-1 1-1 2zm18 4h1s1 0 1 1v3s0 1-1 1c0 0 0 1-1 1h-1l-1-1-10-3-1-1h-1v-3c0-1 1-1 1-2h1c1-1 1 0 1 0h1l10 4zm-9-31c-1 1 0 1 0 2 0 0 0 1 1 1l21 7s1 0 1-1c1 0 1 0 1-1 1 0 0-1 0-2l-1-1-21-6h-1c-1 0-1 1-1 1zm7-27v4l1 1v1l2 2c1 0 1 1 2 1h1l10 3h5c1-1 2-1 3-2 0 0 0-1 1-1v-2c1-2 1-3 1-4-1-1-1-2-2-3l-2-2h-1s-1 0-1-1l-10-2c-1-1-2-1-3-1s-2 1-2 1c-1 0-2 1-3 2l-1 1c0 1 0 1-1 2zm19 2h1l1 1v3s0 1-1 1c0 0 0 1-1 1h-2l-10-3h-1v-1h-1v-3s0-1 1-1c0-1 0-1 1-1h2l10 3zm-11-35v4c1 0 1 1 1 1 0 1 0 1 1 2l2 2h2l11 3h2c1 0 2 0 3-1 1 0 2-1 2-2 1 0 1-1 1-1 0-1 1-1 1-2v-4c0-1-1-2-2-2 0-1-1-2-2-2 0 0 0-1-1-1h-1l-11-2c0-1-1-1-2-1s-2 1-3 1l-2 2s-1 1-1 2c0 0 0 1-1 1zm19 1s1 0 1 1h1v1c1 1 1 1 0 2v2h-3l-11-2h-1c0-1 0-1-1-1v-3s0-1 1-1c0-1 0-1 1-1h2l10 2zm-12-34v4c0 1 1 1 1 1 0 1 0 1 1 2 0 0 1 1 2 1 0 1 1 1 1 1h1l11 2h2c1 0 2 0 3-1 1 0 2-1 2-2 1 0 1-1 1-1 0-1 1-2 1-2v-4c-1-1-1-2-2-2-1-1-1-2-2-2 0 0-1 0-1-1h-2l-10-2h-3c-1 0-1 1-2 1s-2 1-3 2v2c-1 0-1 1-1 1zm19 0c0 1 0 1 1 1s1 1 1 1v4h-1l-1 1h-1l-11-2h-1v-1h-1v-1c-1 0-1-1-1-2 1 0 1-1 1-1 0-1 1-1 1-1h2l11 1zm-14-27v1c1 1 1 1 2 1l21 3c1 0 1 0 2-1v-1c1-1 0-1 0-2l-1-1-22-2h-1c-1 0-1 1-1 2zm3-24v1c0 1 1 1 2 1l21 3s1 0 2-1v-3s-1-1-2-1l-21-2h-2v2zm2-28c0 1 0 2 1 3 0 1 0 1 1 1 0 1 0 1 1 2 0 0 1 1 2 1h1l1 1h14s1 0 2-1c1 0 2-1 2-2s1-1 1-2v-5c-1-1-1-2-2-3-1 0-2-1-2-1-1 0-1 0-2-1h-12c0-1-1-1-2 0-1 0-2 0-3 1l-2 2v2c-1 0-1 1-1 2zm19-2h2v1c1 1 1 1 1 2s-1 1-1 2l-1 1h-2l-10-1h-2l-1-1v-4l1-1h2l11 1zm-17-27c0 1 0 1 1 2l1 1h23c1-1 1-1 1-2s0-1-1-2h-1l-22-1s-1 0-1 1c-1 0-1 1-1 1zm1-29v3c1 1 1 1 1 2 1 0 1 0 1 1 1 0 2 1 3 1h1c0 1 1 1 1 1h13c1-1 2-1 3-2 1 0 1-1 2-2v-2c1 0 1-1 1-2s-1-2-1-3-1-2-2-2c-1-1-1-2-2-2h-3l-10-1c-1 0-2 1-3 1s-2 0-2 1c-1 1-2 1-2 2-1 1-1 1-1 2v2zm18-3h1s1 0 1 1c0 0 1 0 1 1v3l-1 1h-15v-1c-1-1-1-1-1-2s0-1 1-2v-1h13zm-19-25 1 1c0 1 1 1 2 1l21-1h2v-4h-24l-1 1c-1 0-1 1-1 2zm-1-29c0 2 1 3 1 4l1 1 1 1c1 1 2 1 3 1h13c1 0 1 0 1-1h1c1 0 2-1 3-1 0-1 1-2 1-3 1 0 1-1 1-2v-1c0-2 0-3-1-4s-1-2-2-2c-1-1-2-1-3-1h-1c0-1-1-1-1 0h-11c-1 0-2 1-2 1-1 0-2 1-3 1 0 1-1 2-1 3-1 0-1 1-1 1v2zm18-4h2l1 1c0 1 0 1 1 2 0 1-1 1-1 2v1h-2l-11 1h-2c0-1-1-1-1-1v-4l1-1h1l11-1zm-21-29c1 1 1 2 2 3 0 1 0 1 1 1 0 1 0 1 1 1 1 1 2 1 2 1 1 0 1 1 2 1h1l11-2h2c1-1 2-1 2-2 1-1 2-2 2-3v-3c0-2 0-3-1-4l-2-2c-1 0-2-1-3-1h-2l-11 1c-1 1-1 1-2 1s-2 1-3 2c0 0-1 1-1 2s0 1-1 2v2zm18-5h2c1 0 1 0 1 1 1 0 1 1 1 1v2l-1 1s-1 0-1 1h-1l-11 1h-2v-1c-1 0-1-1-1-2v-1c0-1 1-1 1-1 0-1 0-1 1-1h1l10-1zm-21-24s0 1 1 1c0 1 1 1 1 1l22-3s1 0 1-1c1 0 1-1 1-1 0-1-1-2-1-2h-2l-21 2c-1 0-1 0-2 1v2zm-4-28c0 1 0 2 1 3l1 1c0 1 1 1 1 1 1 0 2 1 3 1h2l11-2h1c1 0 1 0 1-1 1 0 2-1 3-1 0-1 1-2 1-3v-4c0-1-1-2-1-3l-2-2c-1 0-2-1-3-1h-3l-10 2c-1 0-2 0-3 1 0 0-1 1-2 1 0 1-1 2-1 3s-1 1-1 2c0 0 0 1 1 2zm17-6h2s1 0 1 1c0 0 1 0 1 1v2l-1 1s-1 0-1 1h-1l-10 1-1 1h-1v-1h-1c-1-1-1-1-1-2v-2s0-1 1-1h1l1-1 10-1zM1394 484c1 1 1 2 2 3 0 0 0 1 1 1l1 1c1 0 2 1 3 1h2l11-3h1s1 0 1-1c1 0 2-1 2-1 1-1 1-2 2-3v-4c-1-1-1-2-2-3s-1-2-2-2-2-1-3-1h-2l-11 3c-1 0-1 0-2 1-1 0-2 1-2 1-1 1-1 2-2 3v4zm18-7h1c1 0 1 0 2 1v4c-1 0-1 0-1 1h-1l-11 2h-2l-1-1v-4c1 0 1-1 1-1h1l11-2zm-25-26c0 1 1 2 1 3l1 1c1 1 1 1 2 1s2 1 3 1h1c0-1 1-1 1-1l10-2c1-1 1-1 2-1h1c0-1 1-2 2-2 0-1 1-2 1-3v-4c-1-1-1-2-2-3l-2-2h-6l-10 3c-1 0-2 0-2 1-1 0-2 1-2 2-1 0-1 1-1 2-1 1-1 1-1 2s0 1 1 2zm17-8h1c1 0 1 1 2 1v1c1 1 1 2 1 2-1 0-1 1-1 1l-1 1h-1l-10 3h-2c-1 0-1 0-1-1 0 0-1 0-1-1v-3c1 0 1-1 1-1h1l11-3zm-25-21c0 1 1 1 1 2h2l21-5c0-1 1-1 1-2v-1c0-1 0-1-1-2h-2l-20 6c-1 0-1 0-2 1v1zm-7-21 1 1h2l20-6 2-2v-1c0-1-1-1-1-2h-2l-20 7c-1 0-1 0-2 1v2zm-9-27c0 1 1 2 2 3l1 1c1 0 1 0 2 1h3c1 0 1 0 2-1l10-3c0-1 1-1 1-1s1 0 1-1c1 0 1-1 2-2 0 0 1-1 1-3v-1c0-1-1-2-1-2 0-1-1-3-2-3l-2-2h-6l-10 4s-1 1-2 1c-1 1-1 2-2 2 0 1 0 2-1 3v2c1 1 1 1 1 2zm16-9c0-1 1-1 1-1h1l1 1c1 0 1 1 1 1v3c0 1-1 1-1 1h-1l-10 4h-3s-1-1-1-2v-3h1l1-1 10-3zm-26-18c0 1 1 1 1 2h2l20-9s1 0 1-1v-2l-1-1h-2l-20 9s-1 0-1 1v1zm-12-27c1 2 2 3 3 3 0 1 0 1 1 1l1 1h4c1 0 1-1 1-1l10-4h1l1-1 2-2c1-1 1-2 1-3v-2c0-1 0-1-1-2 0-1-1-2-2-3s-2-1-2-1c-1 0-2-1-3 0h-3l-10 4c0 1-1 1-2 2 0 0-1 1-1 2-1 1-1 2-1 3v3zm16-10h2s1 0 1 1c1 0 1 0 1 1s1 1 1 2c-1 0-1 0-1 1l-1 1h-1l-9 4-1 1h-1l-1-1c-1 0-1-1-1-1-1-1-1-2-1-2 0-1 0-1 1-1v-1l1-1 10-4zm-28-15c1 0 1 1 2 1h1l20-10s1 0 1-1v-2s-1 0-1-1h-2l-20 10-1 1v2zm-12-25c0 1 1 2 2 2 0 1 1 1 1 1h2c1 1 2 1 3 0h2l9-6h2v-1l2-2c0-1 1-2 1-3-1-1-1-1-1-2s0-1-1-2c0-1-1-2-2-3-1 0-2-1-3-1h-2c-1 0-1 0-2 1h-1l-9 5c-1 1-2 1-2 2-1 0-1 1-2 2v5s0 1 1 2zm14-12h3c1 0 1 1 2 1v3l-1 1h-1l-9 6h-3c-1-1-1-1-1-2-1 0-1-1-1-1v-2h1l1-1 9-5zm-31-18 3 3h1c1 1 1 1 2 1h2c1-1 1-1 2-1h1l9-6c1 0 1 0 1-1 0 0 1 0 1-1 1 0 1-1 1-2 1-1 1-2 1-3 0 0 0-1-1-2v-1c-1-2-2-2-3-3s-2-1-3-1h-3l-1 1h-1l-9 6c-1 0-1 1-2 1-1 1-1 2-1 3-1 1-1 2-1 3 0 0 0 1 1 1v2zm14-12h1l1-1c1 0 1 0 2 1l1 1v3l-1 1-10 6h-3s0-1-1-1v-3s0-1 1-1l9-6zm-29-13 1 1h2l19-11c0-1 0-1 1-2 0 0 0-1-1-2l-1-1c-1 0-1 0-2 1l-18 11c-1 0-1 1-1 1v2zm-16-24c1 2 2 2 3 3h1c1 1 1 1 2 1s2 0 3-1h1s1 0 1-1l9-6h1c0-1 0-1 1-1 0-1 1-2 1-3v-4c0-1-1-2-1-2l-3-3c-1 0-2 0-3-1 0 0-1 0-2 1h-1c-1 0-1 1-2 1l-8 6c-1 0-2 1-2 2-1 0-1 1-2 2v5c1 0 1 1 1 1zm14-12c0-1 0-1 1-1h2l1 1c1 1 1 1 1 2v1c0 1-1 1-1 1s0 1-1 1l-9 6h-3s0-1-1-1v-2c-1 0 0-1 0-1v-1h1l9-6zm-33-15c1 1 2 2 3 2 0 1 0 1 1 1h4c1 0 1-1 1-1h1l9-7c1 0 1 0 1-1 0 0 1 0 1-1 0 0 1-1 1-2v-5c-1 0-1-1-1-1-1-2-2-2-3-3-1 0-2-1-3-1s-2 1-3 1h-1c0 1-1 1-1 1l-9 6c0 1-1 1-1 2-1 1-1 2-2 3v3l1 1c0 1 0 1 1 2zm13-13v-1h3l1 1c1 1 1 1 1 2v1l-1 1-1 1-8 6h-1v1h-2l-2-2v-3l1-1 9-6zm-34-13c1 1 2 1 3 2h6l1-1h1l8-7 1-1 1-1c0-1 1-2 1-3v-3s0-1-1-1c0-1 0-1-1-2s-2-2-3-2c-1-1-2-1-3-1 0 0-1 0-2 1h-1l-1 1-9 7s-1 1-1 2c-1 0-1 1-2 2 0 1 0 2 1 3v2s1 1 1 2zm12-14 1-1h2c1 0 1 0 2 1 0 0 0 1 1 1v2c-1 0-1 0-1 1h-1l-8 7-1 1h-2l-1-1c-1-1-1-1-1-2v-2l1-1 8-6zm-30-8s1 1 2 1c0 0 1 0 1-1l16-14c0-1 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1h-2l-16 15-1 1c0 1 1 1 1 2zm-16-18 1 1c1 0 2 0 2-1l16-14c0-1 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1h-2l-16 15-1 1c0 1 0 2 1 2zm-20-20c1 1 2 1 3 2h3c1 0 2 0 3-1h1c0-1 0-1 1-1l7-8c1 0 1 0 1-1 1 0 1 0 1-1s1-1 1-2 0-2-1-3v-2c-1-1-1-1-1-2-1-1-3-1-4-2h-3s-1 1-2 1c0 0-1 0-1 1h-1l-8 8c0 1-1 1-1 2-1 1-1 2-1 3v3l1 1c0 1 1 1 1 2zm11-15c0-1 0-1 1-1h2s1 0 1 1c1 0 1 1 1 1v2c0 1-1 1-1 1l-7 8h-1l-1 1h-1c-1-1-1-1-2-1 0-1-1-1-1-2v-1l1-1v-1l8-7zm-31-5c0 1 1 1 1 1 1 0 1 0 2-1l14-16c1 0 1-1 1-1 0-1 0-2-1-2 0 0-1-1-1 0h-2l-14 16c-1 0-1 1-1 2 0 0 0 1 1 1zm-21-19c1 1 2 2 3 2h3c1 0 2-1 3-1 0 0 0-1 1-1v-1l7-8c1 0 1-1 1-1s0-1 1-1v-6c-1 0-1-1-1-1l-2-2c-1-1-2-1-3-1-1-1-2-1-3 0-1 0-2 0-2 1h-1l-1 1-7 9c-1 0-1 1-2 2v2c0 1 0 2 1 3v2c1 0 1 1 2 1zm9-16h1c0-1 0-1 1-1h1s1 0 1 1c1 0 1 1 2 1v1c0 1 0 1-1 1v1l-7 8-1 1s0 1-1 1h-1l-1-1-1-1c-1-1-1-1-1-2 0 0 1 0 1-1v-1l7-8zm-32-3c1 1 1 1 2 1 0 0 1 0 1-1l14-16c0-1 1-1 0-2V0h-2c-1 0-1 0-1 1l-14 16c-1 1-1 1-1 2s1 1 1 1z"
          />
          <path
            className="CyberEl82_svg__fil1 CyberEl82_svg__str0"
            d="M664 718h-2s-1 0-1 1l-11 16v1c0 1 0 1 1 1 0 1 1 1 1 1l1-1 11-16v-3zm16 7h-3c-1 0-1 0-2 1h-1c0 1-1 1-1 2-1 0-1 1-1 1v1l-3 9v3s0 1 1 2c0 1 1 1 1 2 1 0 1 1 1 1h2c1 1 2 1 3 1 1-1 2-1 3-2l1-1c0-1 1-1 1-1v-2l3-9v-2c0-1 0-2-1-2 0-1-1-2-1-2-1-1-1-1-2-1 0-1-1-1-1-1zm-2 17v1c-1 0-1 0-1 1h-2l-1-1c-1 0-1-1-1-1v-2l3-9v-1l1-1h2s1 0 1 1c0 0 1 0 1 1v1l-3 10zm19-15h-1c0 1-1 1-1 2l2 19c1 0 1 1 1 1h3v-2l-2-19v-1h-2zm17-5c-1 0-2 1-2 2-1 0-1 1-1 1v1c-1 1-1 2-1 3 1 0 1 1 1 1v1l4 8 1 1c0 1 0 1 1 1 0 1 1 1 2 1 1 1 1 1 2 1h2l1-1c2-1 2-1 3-2 0-1 1-2 1-3v-3l-1-1-4-8c0-1-1-2-1-2-1-1-1-1-2-1-1-1-2-1-3-1h-1c-1 0-1 1-2 1zm10 13v3s-1 0-1 1h-3s0-1-1-1v-1l-4-8-1-1v-1l1-1 1-1h2c1 0 1 1 1 1l5 9zm4-23c-1 0-1 0-1 1s0 1 1 1l14 12c1 1 1 1 2 1l1-1v-3l-15-12h-1c-1 0-1 0-1 1zm11-17c-1 1-1 2-1 3v1c0 1 0 1 1 1 0 1 0 2 1 2 0 1 1 1 1 1l1 1 8 3 1 1h4c1 0 1-1 2-1l1-1c1-1 1-1 1-2 1-1 1-2 1-3s0-2-1-3c0 0-1-1-1-2h-1l-1-1-9-4h-4c-1 0-2 1-2 1-1 0-1 1-2 1v2zm15 4h1s0 1 1 1v2c-1 1-1 1-1 2h-3l-9-4s0-1-1-1v-3l1-1h3l8 4zm-8-27v4c1 0 1 1 1 1 1 1 1 1 2 1l1 1h1l10 1h2c1 0 1 0 2-1 1 0 1-1 2-1 0-1 1-1 1-2v-5c0-1-1-1-1-2-1 0-2-1-2-1-1 0-1-1-1-1h-1l-10-1h-2c-1 0-1 0-2 1-1 0-2 1-2 2 0 0-1 0-1 1v2zm16-1h1l1 1v3c0 1-1 1-1 1h-2l-9-1h-2v-4c0-1 1-1 1-1h2l9 1zm-16-18c0 1 0 1 1 1 0 1 1 1 1 1l19-4s1 0 1-1v-3h-2l-18 4c-1 0-1 0-2 1v1zm-6-17 2 2c1 0 1 0 2 1h4c1 0 1-1 1-1l9-5h1v-1l2-2v-4c0-1 0-1-1-2 0-1-1-2-2-2-1-1-1-1-2-1h-4c0 1 0 1-1 1l-8 5c-1 0-1 0-2 1 0 0-1 1-1 2s-1 2-1 3l1 1v2zm13-11h3l1 1v3l-1 1-9 5h-2l-1-1c-1-1-1-1-1-2 0 0 0-1 1-1v-1h1l8-5zm-26-5c1 1 2 1 3 2h1l1-1c1 0 2 0 2-1h1c0-1 1-1 1-1l6-8v-1s1 0 1-1v-5c-1 0-1-1-1-1-1-1-1-1-2-1l-2-2c-1 0-2 0-3 1-1 0-2 0-2 1h-1c0 1-1 1-1 1l-6 8s0 1-1 2v2c0 1 0 2 1 3v1c1 0 1 1 2 1zm7-14c0-1 1-1 1-1l1-1h1l1 1c1 0 1 1 1 1v3l-6 7-1 1v1h-2s0-1-1-1l-1-1v-2l1-1 5-7zm-28 4c1 0 3 1 4 0h1s1 0 1-1c1 0 1-1 2-1v-1c0-1 1-1 1-1l3-9v-5c-1-1-1-2-2-2 0-1 0-1-1-1l-1-1h-4c-1 0-1 0-2 1-1 0-1 1-2 2v1c-1 0-1 0-1 1l-3 9v4c0 1 1 2 2 2 0 1 0 1 1 1 0 1 1 1 1 1zm3-16v-1l1-1h2c1 0 1 0 2 1v2l-3 9v1l-1 1h-4v-3l3-9zm-22 13c1 0 1 0 2-1v-1l1-19v-2h-3c0 1-1 1-1 2l-1 19s0 1 1 1l1 1zm-16 1c1 0 1-1 2-1v-2l-3-18-1-1c-1-1-1-1-2-1l-1 1v2l3 18c0 1 1 1 1 1 0 1 1 1 1 1zm-19 6c1 0 2-1 3-2 0 0 0-1 1-1v-6l-4-8-1-1c0-1 0-1-1-1 0-1-1-1-2-2h-4s-1 0-1 1c-1 0-2 1-3 2 0 0-1 1-1 2v4l1 1 4 8c0 1 0 1 1 2 0 0 1 1 2 1 0 1 1 1 2 1h2l1-1zm-9-13v-3l1-1h3l1 1 4 9v3s-1 0-1 1h-3c0-1 0-1-1-1v-1l-4-8zm-6 24c0-1 1-1 1-2l-1-1-13-14h-3v3l13 14h3zm-14 16c1-1 1-2 2-3v-1c-1-1-1-1-1-2 0 0 0-1-1-2h-1v-1l-8-5-1-1h-1c-1-1-2-1-3-1 0 1-1 1-2 1l-1 1c-1 1-1 1-1 2-1 1-2 2-2 3s0 1 1 2c0 1 0 2 1 2v1c1 0 1 1 1 1l8 5c1 0 1 1 2 1h2c1 0 2 0 3-1 0 0 1 0 1-1 1 0 1 0 1-1zm-14-6-1-1-1-1v-1s0-1 1-1c0-1 0-1 1-1 0-1 1-1 1-1s1 0 1 1h1l7 5 1 1 1 1c0 1-1 1-1 2l-1 1h-3l-7-5zm5 25v-1l-1-1-18-7h-1c-1 0-1 0-1 1-1 0-1 1 0 1 0 1 0 1 1 1l17 7h2l1-1zm-6 21v-4l-1-1v-1c-1-1-2-1-2-1l-1-1h-1l-10-2h-2c-1 1-1 1-2 1-1 1-2 1-2 2l-1 1v2c-1 1-1 2 0 3 0 1 0 2 1 3 1 0 1 1 2 1h1c0 1 1 1 1 1l9 1h2c1 0 2 0 3-1 1 0 1-1 2-1 0-1 0-1 1-2v-1zm-16 0h-1l-1-1v-1c-1 0-1-1 0-1v-2h1c0-1 1-1 1-1h1l9 2h1l1 1v3l-1 1h-2l-9-1zm15 24c0-1 0-2-1-3 0 0 0-1-1-1 0 0 0-1-1-1 0 0-1-1-2-1h-2l-9 1h-2s0 1-1 1c0 0-1 1-2 1 0 1-1 2-1 2v2c-1 0-1 1 0 2v3c1 1 2 1 2 2h3c0 1 0 1 1 1h1l9-2h2c1 0 2-1 2-2 1 0 1-1 2-2v-3zm-16 5c-1 0-1 0-1-1h-1c0-1-1-1-1-2 0 0 0-1 1-1v-1l1-1h1l9-1h2c0 1 1 1 1 1v3s0 1-1 1l-1 1-10 1zm21 15c0-1-1-1-1-2h-2l-18 7s0 1-1 1v2l1 1h2l17-7c1 0 1 0 2-1v-1zM621 741c-1-1-2-1-2-2h-5c-1 0-1 0-1 1h-1l-8 6s-1 0-1 1l-1 1s0 1-1 2v2c0 1 1 1 1 2 0 0 0 1 1 1 0 1 1 2 2 2 1 1 2 1 2 1h3l1-1h1l7-6c1-1 2-1 2-2 1 0 1-1 1-2v-4c0-1-1-1-1-2zm-11 12-1 1h-2c-1 0-1-1-1-1l-1-1v-2h1v-1l8-6h3l1 1v3l-1 1-7 5zm27 4c-1-1-2-1-3-1h-2c-1 0-2 1-3 1v1c-1 0-1 0-1 1l-5 8c-1 0-1 1-1 1v1c-1 1-1 1-1 2s1 2 1 3l1 1 1 1c1 1 2 1 3 1h3c1 0 1-1 2-1l1-1s0-1 1-1l5-8c0-1 1-1 1-2v-2c0-1 0-2-1-3v-1c-1 0-1-1-2-1zm-7 15c0 1-1 1-1 1h-2l-1-1-1-1c0-1 0-1 1-1v-1l5-8 1-1h3l1 1v3l-6 8zm29-4c-1 0-2-1-3 0h-2c-1 1-2 1-2 2 0 0 0 1-1 1v1l-4 9v5c1 0 1 1 2 2l1 1s1 0 1 1h4s1 0 2-1c1 0 1-1 2-2v-1c1 0 1 0 1-1l3-9s1-1 1-2c0 0 0-1-1-2 0-1 0-2-1-2 0-1-1-1-1-1-1-1-1-1-2-1zm-3 16v1l-1 1h-2c-1 0-1-1-1-1-1 0-1-1-1-1v-2l4-9v-1c1 0 1 0 1-1 1 0 1 0 2 1h1l1 1v2l-4 9zm23-12s-1 0-1 1c-1 0-1 1-1 1l-2 19v1c0 1 1 1 1 1h2c0-1 0-1 1-2l2-18v-2c-1 0-1-1-2-1zm17 1s-1 0-1 1c-1 0-1 0-1 1l1 19 1 1c0 1 1 1 1 1 1 0 1-1 2-1v-1l-1-19v-2h-2zm21-4c-1 1-2 1-3 2v1c-1 0-1 1-1 1 0 1-1 2-1 2v3l3 9v1l1 1 1 1c1 1 2 1 3 1 0 1 1 1 1 1 1 0 1-1 2-1s2-1 3-1c0-1 1-2 1-2 1-1 1-2 1-3v-2l-3-9v-2l-2-2c-1 0-2-1-3-1h-3zm7 15v2l-1 1h-1c-1 1-1 1-2 1 0 0 0-1-1-1v-1l-3-10v-1c0-1 1-1 1-1l1-1h3v1l1 1 2 9zm12-22s-1 0-1 1v1l9 17s1 0 1 1c1 0 1 0 2-1 0 0 1 0 1-1v-1l-9-17c-1 0-1 0-2-1 0 0-1 0-1 1zm17-13c-1 1-1 2-2 3v3s0 1 1 2v1l1 1 6 7 1 1h1c0 1 1 1 2 1h2c1 0 1 0 2-1 0 0 1 0 1-1 1-1 2-1 2-2 1-1 1-2 1-3s-1-2-1-2v-1l-1-1-6-7-2-2h-2c-1-1-2-1-3 0h-1c-1 1-1 1-2 1zm13 10v1c1 0 1 1 1 1v1l-1 1c-1 1-1 1-2 1h-2v-1l-6-7h-1v-2c0-1 0-1 1-2h1l1-1 1 1h1l6 7zm2-25s-1 0-1 1l1 1 15 11c1 1 1 1 2 1l1-1v-3l-15-11h-2s-1 0-1 1zm12-19c-1 1-1 2-1 3v3c1 0 1 1 2 2 1 0 1 1 1 1l9 4h1l1 1c1 0 2 0 2-1 1 0 2 0 3-1l1-1s0-1 1-1c0-1 1-2 1-3s-1-2-1-3-1-1-1-2c-1 0-1 0-1-1h-1l-9-4c0-1-1-1-2-1h-2c-1 0-2 1-2 1-1 1-1 1-2 1v2zm15 4c0 1 1 1 1 1 0 1 1 1 1 2 0 0 0 1-1 1 0 1 0 1-1 1 0 0 0 1-1 1h-1v-1l-9-4h-1v-3c0-1 1-1 1-2h3l8 4zm-6-28v4c0 1 1 1 1 1l2 2h1c0 1 0 1 1 1l9 2h4c1-1 2-1 3-2v-1c1-1 1-1 1-2v-3c0-1 0-2-1-3 0 0-1-1-2-1 0 0 0-1-1-1h-1l-9-2h-4c-1 0-2 1-3 2v1c-1 1-1 1-1 2zm16 1h1l1 1v3l-1 1h-2l-9-2h-1v-1h-1v-4h1c1-1 1-1 1 0h1l9 2zm-12-23c0 1 0 1 1 1 0 1 0 1 1 1l19 1h1c1-1 1-1 1-2 0 0 0-1-1-1 0 0 0-1-1-1l-19-1s-1 0-1 1c-1 0-1 1-1 1zm0-22c1 2 1 3 1 3l1 1 1 1c1 1 2 1 3 1h2l9-1h1l1-1c1 0 2-1 2-1 1-1 1-2 2-2v-4c0-1 0-2-1-3-1 0-1-1-2-2h-4l-10 1h-2l-2 2s-1 1-1 2-1 1-1 2v1zm16-4c0-1 1-1 1 0 0-1 0 0 1 0h1v3c0 1 0 1-1 1 0 0 0 1-1 1l-10 1h-1c-1 0-1 0-1-1l-1-1v-2c1 0 1 0 1-1h2l9-1zm-20-20c0 1 1 2 1 3h1c1 1 1 1 2 1h4l9-4h1s0-1 1-1 1-1 1-2c1-1 1-1 1-2v-4c-1-1-1-2-2-2-1-1-1-1-2-1-1-1-2-1-3-1h-1c0 1 0 1-1 1l-9 3c0 1-1 1-1 1-1 1-2 1-2 2-1 1-1 2-1 3v1c0 1 0 1 1 2zm14-9h1c1 0 1 0 1 1 1 0 1 0 1 1v2c0 1 0 1-1 1l-9 4h-3s0-1-1-1v-3c1 0 1-1 1-1h1l9-4zm-26-14c1 1 2 2 3 2 0 1 0 1 1 1h4c1-1 1-1 2-1l7-5 1-1c1 0 1-1 1-1 1-1 1-1 1-2s1-2 1-3c-1 0-1-1-1-1 0-1 0-1-1-2 0-1-1-1-2-2-1 0-2-1-2-1-1 0-2 0-3 1h-1s-1 0-1 1l-8 5-1 1c-1 1-1 2-2 3v2c0 1 0 1 1 2v1zm12-11c1 0 1 0 1-1h1s1 0 1 1c0 0 1 0 1 1l1 1s0 1-1 1v1h-1l-8 6h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-2h1v-1l8-5zm-25-4h3l13-14v-3c-1 0-1-1-2-1l-1 1-13 14-1 1c0 1 1 1 1 2zm-14-11c1 1 1 1 2 1 0-1 1-1 1-1l11-16v-2s0-1-1-1h-1c-1 0-1 0-2 1l-10 16v2zm-18-9h4s1 0 1-1c1 0 2-1 2-1 0-1 1-1 1-1v-1l4-9v-1l1-1c0-1 0-2-1-3 0 0 0-1-1-2l-1-1s-1 0-1-1h-4c-1 0-1 0-2 1-1 0-2 0-2 1 0 0 0 1-1 1v1l-4 9v2c-1 1 0 2 0 2 0 1 0 2 1 3 0 0 1 0 1 1 1 0 1 0 2 1zm3-16 1-1v-1h3c1 0 1 0 1 1 0 0 1 0 1 1v1s-1 0-1 1l-3 8-1 1v1h-3l-1-1-1-1s0-1 1-1v-1l3-8zm-24 9h2s0-1 1-1l4-19s0-1-1-1c0-1 0-1-1-1h-1c-1 0-1 1-1 1l-4 19v2h1zM690 556c1 0 2 0 3-1 0 0 1 0 1-1 1 0 1 0 1-1 1 0 1-1 1-2l1-1v-13c-1 0-1-1-1-2-1 0-2-1-2-1-1-1-1-1-2-1h-2c-1 0-2 0-3 1-1 0-1 1-2 1 0 1-1 2-1 2v3l-1 9c0 1 0 2 1 2 0 1 0 2 1 2 0 1 1 2 2 2l1 1h2zm-2-16v-2s0-1 1-1h3s0 1 1 1v12c0 1-1 1-1 1v1h-3l-1-1-1-1v-1l1-9zm-21 17h2v-2l-2-19s0-1-1-1h-3v2l2 19 1 1h1zm-20 6c1-1 2-1 2-2 1 0 1-1 1-1 0-1 1-1 1-1v-5l-3-9v-1c-1 0-1 0-1-1l-2-2h-5c-2 0-3 1-3 2-1 0-1 1-2 2v5l3 8c0 1 1 2 1 2 1 1 1 2 2 2 1 1 1 1 2 1h4zm-8-15v-3h2l1-1 1 1s1 0 1 1l3 9v3c-1 0-1 1-2 1h-2c0-1-1-1-1-1v-1l-3-9zm-16 26 2-2c0-1 1-1 1-2v-4c0-1 0-1-1-1l-4-9s-1 0-1-1h-1c0-1-1-1-2-2h-4c0 1-1 1-1 1-1 1-2 1-3 2 0 1-1 2-1 3v2l1 1v1l5 8c0 1 1 2 1 2 1 1 1 1 2 1 1 1 2 1 3 1 0 0 1 0 1-1h2zm-10-13h-1v-1c0-1 0-1 1-2l1-1h2s1 0 1 1l5 9v2c0 1 0 1-1 1l-1 1h-2v-1l-1-1-4-8zm-7 25v-2l-13-14c0-1 0-1-1-1 0 0-1 0-1 1-1 0-1 0-1 1 0 0 0 1 1 1l12 14c0 1 1 1 1 1 1 0 1 0 2-1zm-16 17c1-1 1-2 1-3l1-1c0-1 0-1-1-2v-2c-1 0-1-1-1-1s-1 0-1-1l-7-6h-1l-1-1h-5c0 1-1 1-1 1l-1 1c-1 1-2 2-2 3v3c0 1 0 2 1 2 0 0 0 1 1 1v1l8 6 1 1h5c1 0 1-1 2-1l1-1zm-14-8s0-1-1-1v-2s0-1 1-1c0-1 0-1 1-1h2v1l8 5v1l1 1v1l-1 1c0 1-1 1-1 1h-3l-7-6zm-1 30c1-1 1-2 1-3v-3l-2-2-1-1-9-5h-2c-1-1-1-1-2 0-1 0-2 0-3 1l-1 1s0 1-1 1c0 1-1 2-1 3s0 2 1 3c0 1 1 1 1 2 0 0 1 0 1 1h1l8 5h2c1 1 2 1 3 0 0 0 1 0 2-1 0 0 1 0 1-1l1-1zm-15-5-1-1c-1-1-1-1-1-2l1-1c0-1 0-1 1-1 0 0 0-1 1-1l1 1 9 4v1h1v3l-1 1c-1 0-1 1-1 1-1 0-1 0-1-1h-1l-8-4zm4 29c0-1 1-2 0-3v-1c0-1 0-1-1-1 0-1-1-2-1-2s-1 0-1-1h-1l-9-3h-5l-2 2-1 1v1c-1 2-1 3-1 4 0 0 1 1 1 2s1 1 2 2h1s0 1 1 1l9 3h4c1-1 2-1 2-2 1 0 1-1 1-1 1-1 1-1 1-2zm-16-2h-1v-1c-1 0-1-1-1-1v-1c0-1 1-2 1-2h3l9 3h1v2c1 0 0 0 0 1v1l-1 1h-2l-9-3zm10 25v-2c-1 0-1-1-2-1l-18-3h-2v3l1 1 19 3h1l1-1zm-3 18v-2h-2l-18-1h-2v3l1 1 19 1c1 0 1-1 2-1v-1zm0 22c0-1 0-2-1-3v-1h-1c-1-1-2-1-3-1 0 0 0-1-1-1h-1l-9 1h-1l-1 1c-1 0-2 1-2 1l-2 2v7c1 0 2 1 2 2 1 0 2 0 2 1h3l9-1c1 0 2 0 2-1 1 0 2 0 2-1l2-2v-4zm-16 5c-1 0-1 0-1-1h-1v-2c-1 0 0-1 0-1v-1c1 0 1 0 1-1h1l9-1h2v1h1v3c0 1 0 1-1 1v1h-1l-10 1zm20 17-1-1c-1-1-1-1-2-1l-18 6s-1 0-1 1c0 0-1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0l18-5c1 0 1 0 1-1 1 0 1-1 1-1zm7 21c-1-1-1-2-2-3h-1c-1-1-1-1-2-1h-3s-1 0-1 1l-9 4h-1s0 1-1 1c0 0-1 1-1 2s-1 1-1 2v2s1 1 1 2 1 2 2 2c1 1 1 1 2 1s2 1 3 0h2l8-4c1-1 2-1 2-2 1 0 1-1 2-2v-5zm-14 9h-1c0 1 0 1-1 1 0-1 0-1-1-1 0 0 0-1-1-1v-2l1-1 1-1 8-4h3l1 1v3s0 1-1 1l-9 4zm24 10s0-1-1-1h-1l-16 11c0 1-1 1-1 2v1c1 0 1 1 2 1 0 0 1 0 1-1l16-10c0-1 0-1 1-2 0 0 0-1-1-1zm13 16c0-1-1-2-2-2h-3c-1 0-1 0-2 1h-1c0 1-1 1-1 1l-6 7-1 1-1 1v5c0 1 0 1 1 1 0 1 0 1 1 2s2 1 2 1c1 1 2 1 3 0h2l1-1c1 0 1-1 1-1l7-7s1-1 1-2c0 0 0-1 1-2 0-1 0-2-1-3v-1c-1 0-1-1-2-1zm-9 14s-1 0-1 1h-1c-1-1-1-1-2-1v-1c-1-1-1-1 0-2v-1l7-7v-1h2c1 0 1 0 2 1 0 0 0 1 1 1v1l-1 1v1l-7 7zm30 2c-1 0-2-1-3-1h-2c-1 1-2 1-3 2l-1 1-5 8-1 1v1c-1 1-1 2-1 3s1 1 1 2 1 1 1 1c0 1 1 1 1 2 1 0 2 1 3 1s2 0 3-1c1 0 1 0 2-1 0 0 1 0 1-1h1l5-8c0-1 1-2 1-2v-3c0-1 0-2-1-2 0-1 0-1-1-2l-1-1zm-7 15v1s-1 0-1 1h-1c-1 0-1 0-1-1-1 0-1 0-2-1v-2c1 0 1 0 1-1l5-8h1v-1h1c1 0 1 0 2 1 0 0 1 0 1 1v2l-6 8zm27-4h-2s-1 0-1 1l-8 17v2l1 1h1l1-1 9-18v-1l-1-1zm20 7c-1 0-3-1-3 0h-2l-1 1c-1 0-1 1-2 2v2l-3 9v2c0 1 0 2 1 3 0 0 0 1 1 2 1 0 1 0 1 1h5c1 0 2 0 3-1 0-1 1-1 1-2 0 0 1 0 1-1v-1l2-9c1-1 1-2 1-2 0-1 0-2-1-3 0 0-1-1-1-2-1 0-1 0-2-1h-1zm-2 16v2h-4l-1-1v-2l2-9 1-1v-1h4c0 1 1 1 1 1v2l-3 9zM676 828c-1 0-2 0-3 1h-1c0 1-1 1-1 1 0 1-1 2-1 2 0 1-1 1-1 1v1l-1 10v2c0 1 1 2 1 2 1 1 1 2 2 2l1 1h5c1-1 2-1 2-2 1 0 1-1 2-2v-2l1-9v-3s0-1-1-2c0-1-1-1-2-2h-1c0-1-1-1-2-1zm1 17v1c0 1-1 1-1 1h-3l-1-1v-2l1-9v-1c0-1 0-1 1-1v-1h2c1 0 1 0 1 1h1v2l-1 10zm26-17c-2 0-3 0-3 1-1 0-1 0-1 1-1 0-1 0-1 1-1 1-1 1-1 2v1c0 1-1 1-1 1l1 10v1s1 0 1 1 0 1 1 2 1 1 2 1c1 1 1 1 2 1h1c2 0 3-1 3-1 1-1 2-1 2-2 1-1 1-2 1-2v-12c0-1 0-1-1-2 0-1 0-2-1-2l-2-2h-3zm4 16v1h-1c0 1 0 1-1 1 0 1 0 1-1 1h-1c-1 0-1-1-1-1s-1 0-1-1v-1l-1-9v-1c1 0 1-1 1-1v-1h3c1 0 1 0 1 1 0 0 1 0 1 1l1 10zm18-20c-1 0-1 0-1 1-1 0-1 1-1 1l5 19v1h2s1 0 1-1v-1l-4-18c0-1 0-1-1-2h-1zm17-5s-1 0-1 1v1l7 18s0 1 1 1h1c1 0 1-1 1-1v-2l-7-17c0-1 0-1-1-1 0-1-1-1-1 0zm20-10-2 2v1c-1 1-1 1-1 2v2c0 1 0 1 1 1v1l5 8v1c0 1 1 1 1 1 1 1 1 1 2 1 1 1 2 1 3 1 0 0 1 0 1-1h2c1-1 2-2 2-3 1 0 1-1 1-2v-4c-1 0-1 0-1-1l-4-8c-1 0-1-1-2-1 0-1-1-1-2-2h-4s-1 1-2 1zm11 13v2c0 1-1 1-1 1-1 1-1 1-2 1h-1c0-1 0-1-1-1v-1l-5-8v-2c0-1 1-1 1-2h3s0 1 1 1l5 9zm8-25v2l12 15s0 1 1 1 1 0 1-1c1 0 1-1 1-1v-2l-12-14c0-1-1-1-1-1-1 0-1 0-2 1zm18-16c-1 0-1 1-2 2v3c0 1 0 2 1 2v1l1 1 6 7h1c0 1 1 1 1 1 1 0 2 1 3 1 0 0 1 0 2-1h1c1-1 1-1 2-1 1-1 1-2 2-3v-3c0-1 0-1-1-2v-1c-1 0-1-1-1-1l-7-7s-1 0-1-1h-3c0-1-1-1-2 0h-2c0 1-1 1-1 2zm13 9s1 0 1 1v2l-1 1-1 1h-1c-1 0-1 0-1-1h-1l-6-7h-1v-2c0-1 0-1 1-2h1c0-1 1-1 1-1l1 1h1l6 7zm2-27c-1 0-1 1-1 2l1 1 15 11h3v-2s0-1-1-1l-15-11c0-1-1-1-1-1-1 0-1 1-1 1zm12-19c-1 1-1 2-1 3v1c0 1 0 1 1 1 0 1 0 2 1 2 0 1 0 1 1 1 0 0 0 1 1 1l8 4 1 1h3c1 0 2-1 3-1 0 0 0-1 1-1 0-1 1-1 1-2s1-2 1-3 0-1-1-2c0-1 0-2-1-2 0-1-1-1-1-1l-1-1-8-4c-1 0-1-1-2-1h-2c-1 0-2 1-3 1 0 1-1 1-1 1 0 1-1 1-1 2zm15 5h1s0 1 1 1v1c0 1 0 1-1 2 0 0 0 1-1 1h-2l-9-5h-1v-3c1-1 1-1 1-2h3l8 5zm-3-30c-1 1-1 2-1 3 0 0 0 1 1 1v1c1 1 1 2 2 2l1 1h1l8 3 1 1h4l2-2c1 0 1-1 1-1s1-1 1-2 1-2 0-3v-2c-1-1-1-2-2-2l-1-1h-1l-9-3c0-1-1-1-2-1h-2c-1 1-2 1-2 2-1 0-1 1-1 1-1 0-1 1-1 2zm16 3h1c0 1 0 1 1 2 0 0 0 1-1 1v1c-1 1-1 1-2 1h-1l-9-4h-1v-1c-1 0-1 0-1-1v-1l1-1 1-1h2l9 4zm-9-25v1c0 1 1 1 1 1l18 4h2c0-1 1-1 1-1v-2c-1 0-1-1-2-1l-18-4h-1c-1 1-1 1-1 2zm4-23c0 1 0 2 1 3v1c0 1 1 1 1 1l2 2h2l9 1h3s1-1 2-1l2-2v-1c1-1 1-2 1-2 0-1 0-2-1-3 0-1 0-2-1-2-1-1-1-2-2-2h-2l-9-1h-3s-1 0-2 1c-1 0-1 1-2 2v1c-1 1-1 1-1 2zm16-1h2l1 1v2s0 1-1 1v1h-2l-9-1h-2c0-1-1-1-1-1v-2s0-1 1-1v-1h2l9 1zm-14-27v4c1 0 1 0 1 1h1l2 2h2l10-1h2c1 0 1-1 2-1 1-1 1-2 2-3v-6c-1-1-2-1-2-2-1 0-2-1-2-1h-12c-1 0-1 1-2 1s-2 0-2 1l-2 2v3zm16-3h1l1 1v3s0 1-1 1h-1l-10 1h-1v-1h-1c0-1 0-1-1-2l1-1v-1c1 0 1 0 1-1h11zm-19-24c0 1 0 2 1 3 0 0 0 1 1 1l1 1c1 0 1 0 2 1h1c1 0 1 0 1-1l10-1 1-1h1l2-2s1-1 1-2v-3c0-2-1-2-1-3-1-1-1-2-2-2s-2-1-2-1h-3l-9 2c-1 0-1 1-2 1s-1 1-2 2c0 0-1 1-1 2v3zm15-6h2c0 1 0 1 1 1v4c-1 0-1 0-1 1h-1l-9 2h-1c-1 0-1 0-1-1h-1v-2c-1 0-1-1 0-1v-1s1 0 1-1h1l9-2zm-21-15 1 1h1l18-7c1 0 1 0 1-1 1 0 1-1 1-1l-1-1c-1-1-1-1-2 0l-18 6s-1 0-1 1v2zm-7-17c1 1 1 1 2 1h1l17-9 1-1v-2c-1 0-1-1-1-1h-2l-17 10-1 1v1zm-11-20c0 1 1 2 2 2 0 1 1 1 1 1h4s1 0 1-1h1l8-6h1v-1c1-1 1-2 2-2v-3s0-1-1-1v-2c-1-1-2-2-3-2 0-1-1-1-2-1h-3c0 1 0 1-1 1h-1l-7 6c-1 0-2 1-2 1-1 1-1 2-1 3 0 0-1 1 0 2v2s0 1 1 1zm12-11v-1h2c1 0 1 1 1 1 1 1 1 1 1 2v1l-1 1-8 6h-3l-1-1v-1c-1-1-1-1 0-2l1-1 8-5zm-26-6c0 1 1 1 1 1 1 0 1 0 2-1l13-13c1 0 1-1 1-1 0-1 0-1-1-2h-2l-14 13c0 1-1 1-1 2l1 1zm-16-14c1 0 2 1 3 1h2c1-1 2-1 2-1l1-1 1-1 6-8v-1c1 0 1 0 1-1v-5c-1 0-1 0-1-1-1 0-1-1-2-1 0-1-1-1-2-1h-3c-1 0-2 0-2 1 0 0-1 0-1 1 0 0-1 0-1 1l-6 7c0 1 0 1-1 2v3s0 1 1 2v1l2 2zm7-15 1-1h3l1 1v3l-6 8h-1v1h-1c-1 0-1 0-2-1 0 0-1 0-1-1v-2h1l5-8zm-27 2h2s1 0 1-1l10-16v-2s0-1-1-1h-1c-1 0-1 0-2 1l-9 16c-1 1-1 1-1 2 1 0 1 1 1 1zM754 507c1 1 2 1 3 1s1 0 2-1h1l2-2v-1c1 0 1 0 1-1l4-8v-5c0-1-1-2-1-2l-1-1c-1-1-1-1-2-1-1-1-2-1-3-1s-2 1-3 1c0 1-1 1-1 2-1 0-1 0-1 1l-1 1-3 9s-1 1-1 2v2c1 1 1 2 2 2 0 1 0 1 1 1 0 1 1 1 1 1zm4-16v-1h1l1-1c1 0 1 0 2 1h1v3l-4 9v1h-1c0 1 0 1-1 1h-1l-1-1-1-1v-2l4-9zm-29 8c1 0 2 1 3 0h1l1-1c1 0 1-1 2-2v-1s1 0 1-1l2-9v-5c-1 0-1-1-2-2 0 0-1 0-1-1h-5c-1 0-2 0-2 1-1 1-2 1-2 2v1c-1 0-1 1-1 1l-2 9v5l2 2 1 1h2zm1-16v-1l1-1h4v3l-2 9v1h-1v1h-4v-1c-1 0-1-1 0-1v-1l2-9zm-24 13c1 0 1 0 2-1l1-1 2-19c0-1-1-1-1-1 0-1-1-1-1-1h-2v2l-2 19v1c1 0 1 1 1 1zm-23-1c1 0 2 0 3-1 0 0 1 0 1-1 0 0 1 0 1-1 1 0 1-1 1-2v-1c1 0 1 0 1-1v-11s-1 0-1-1c0 0 0-1-1-2 0 0-1-1-2-1 0-1-1-1-1-1h-2c-1 0-2 0-3 1-1 0-2 1-2 1-1 1-1 2-1 3l-1 1v10c0 1 0 2 1 3 0 0 0 1 1 2 0 0 1 1 2 1 0 1 1 1 1 1h2zm-3-16v-1l1-1 1-1h2c1 0 1 1 1 1l1 1v11h-1v1l-1 1h-3v-1c-1 0-1-1-1-1v-10zm-23 19c1 0 2-1 3-2h1v-2c1 0 1-1 1-2v-2l-2-9v-3c-1 0-1-1-2-1 0-1-1-1-2-2h-3c-2 1-3 1-3 2-1 0-2 1-2 2 0 0-1 1-1 2v2l2 10s0 1 1 2c0 0 1 1 1 2 1 0 2 0 3 1h3zm-6-16v-1c0-1 1-1 1-1l1-1h2s1 0 1 1v1h1l1 10v2c-1 0-1 1-2 1h-1c-1 0-1 0-1-1-1 0-1 0-1-1l-2-10zm-21 23c2-1 2-1 3-2l1-1c0-1 0-1 1-1v-5l-3-9c-1 0-1-1-1-1l-1-1-1-1c-1-1-2-1-3-1h-3c-1 1-2 1-3 2 0 1-1 1-1 2v5l3 9s1 1 1 2c0 0 1 1 2 1 0 1 1 1 2 1h3zm-7-15h-1v-1l1-1c0-1 1-1 1-1h3l1 1v1l3 8v2c0 1 0 1-1 1 0 0 0 1-1 1h-2c-1 0-1-1-1-1v-1l-3-9zm-15 24c1 0 1-1 1-1 1-1 1-1 0-2l-7-17c-1 0-1-1-1-1h-2l-1 1v2l8 17s0 1 1 1h1zm-16 9s0-1 1-1c0-1 0-1-1-2l-9-16-1-1h-2c0 1 0 1-1 2 0 0 0 1 1 1l9 16c0 1 1 1 1 1h2zm-19 13c1-1 2-1 2-2s0-1 1-2v-1c0-1 0-2-1-2v-1c0-1-1-1-1-1l-6-8-1-1c-1 0-2-1-2-1h-3c-1 0-1 0-2 1 0 0-1 0-1 1-1 0-2 1-2 2s-1 2-1 3 1 1 1 2v1l1 1 6 7c0 1 1 1 1 2 1 0 2 1 3 1h2c1 0 1-1 2-1 0 0 1 0 1-1zm-12-10v-1c-1 0-1-1-1-1s0-1 1-1v-1c1-1 1-1 2-1h2v1l6 7 1 1v2l-1 1c-1 1-1 1-2 1h-1l-1-1-6-7zm-5 26v-3l-14-13h-2c-1 1-1 1-1 2 0 0 0 1 1 1l13 13c0 1 1 1 1 1 1 0 1 0 2-1zm-15 17c0-1 1-2 1-3v-2c0-1-1-2-1-2 0-1-1-1-1-1s0-1-1-1l-7-6h-1s-1 0-1-1h-3s-1 0-2 1c-1 0-1 0-1 1-1 0-1 0-2 1 0 1-1 2-1 3v3s1 1 1 2c0 0 1 0 1 1h1l7 6c1 0 1 1 2 1h5l1-1 2-2zm-15-7-1-1v-1c0-1 0-1 1-2 0 0 0-1 1-1h2v1l8 5v1h1v2l-1 1c0 1 0 1-1 1h-2l-8-6zm1 27v-1c0-1 0-1-1-2l-16-9h-1c-1 0-1 0-1 1-1 0-1 0-1 1s1 1 1 1l16 10h2s1 0 1-1zm-12 21c1-1 1-2 1-3v-1c0-1 0-1-1-1 0-1 0-2-1-2 0-1 0-1-1-1l-1-1-8-4h-5s-1 0-2 1l-1 1c-1 1-1 1-1 2-1 1-1 2-1 3s0 1 1 2c0 1 1 2 1 2l1 1h1l8 4c1 1 2 1 2 1h3c1 0 1-1 2-1s1-1 1-1c1-1 1-1 1-2zm-15-4c-1 0-1 0-1-1h-1v-3c1 0 1-1 1-1h3l8 4h1s0 1 1 1v3c-1 0-1 1-1 1h-3l-8-4zm5 30v-4c0-1-1-1-1-2 0 0-1-1-2-1v-1h-1l-9-3c-1 0-1-1-2-1h-1s-1 1-2 1-1 1-2 1c-1 1-1 1-1 2l-1 1v3c0 1 0 2 1 3 0 0 1 1 1 2h1c1 0 1 0 1 1l9 2c1 1 2 1 2 1 1 0 2 0 3-1 1 0 1 0 2-1 0-1 1-1 1-1 0-1 0-1 1-2zm-16-2c-1 0-1 0-1-1h-1v-3s0-1 1-1l1-1h1v1l9 2 1 1h1v3s0 1-1 1c0 0 0 1-1 1h-2l-8-3zm9 25v-1c0-1-1-1-1-1l-19-4h-1c-1 0-1 1-1 1v2c1 0 1 1 1 1l19 4s1 0 1-1c1 0 1 0 1-1zm-4 23v-3c0-1-1-1-1-2l-1-1s-1-1-2-1h-2l-9-1h-2c-1 0-2 0-3 1l-2 2v3c-1 1-1 2 0 3 0 1 1 2 1 2 1 1 2 1 2 2h2l10 1h2c1 0 1-1 2-1 1-1 2-1 2-2s1-1 1-2v-1zm-16 1h-2v-1c-1-1-1-1-1-2l1-1s0-1 1-1h1l10 1h1c1 0 1 1 1 1v3c-1 0-1 1-1 1h-2l-9-1zm15 27c0-1-1-2-1-3 0 0-1 0-1-1 0 0 0-1-1-1 0 0-1-1-2-1h-14c0 1-1 1-2 1 0 1-1 2-2 3v6l2 2c1 0 1 1 2 1h14c1 0 1-1 2-1 1-1 1-2 2-2v-2s1-1 1-2zm-17 3h-1s-1 0-1-1v-3l1-1h13v1l1 1c0 1-1 2-1 2v1h-12zm19 25c0-1-1-2-1-3l-1-1-1-1c-1 0-2-1-3-1h-2l-9 2h-2c-1 1-2 1-2 2-1 0-1 1-2 2v3c0 1 1 3 1 3 1 1 1 2 2 2s2 1 2 1h3l9-2h2l2-2c1 0 1-1 1-2 1-1 1-1 1-2v-1zm-16 5h-2v-1c-1 0-1-1-1-1v-2s0-1 1-1h1l10-2h1c1 0 1 1 1 1l1 1v2c-1 0-1 1-1 1h-2l-9 2zM499 760c0-1 0-1-1-1 0-1-1-1-1-1l-18 6c-1 0-1 1-1 1-1 1-1 1-1 2 0 0 1 0 1 1h2l18-6s1 0 1-1v-1zm6 18c0-1-1-1-1-1-1-1-1-1-2 0l-17 7c-1 0-1 1-1 1v2l1 1h1l18-8s1 0 1-1v-1zm10 21-2-2c-1-1-1-1-2-1h-5l-9 5s-1 0-1 1h-1c0 1-1 2-1 2v6l3 3s1 0 2 1c1 0 2 0 2-1h2l9-5s1-1 2-1c0-1 1-1 1-2v-6zm-13 10c-1 0-1 0-1 1h-1s-1 0-1-1c0 0-1 0-1-1v-3c1 0 1 0 1-1l8-4h1c0-1 0-1 1-1l1 1s1 0 1 1c0 0 1 1 0 1v2l-1 1-8 4zm24 9c0-1-1-1-1-1h-2l-15 12v1c-1 1 0 2 0 2l1 1c1 0 1 0 2-1l15-11v-2c1 0 0-1 0-1zm15 18c-1-1-2-2-3-2h-5s0 1-1 1l-1 1-6 6-1 1-1 1c0 1 0 2-1 2 0 1 0 2 1 3v1c1 1 1 1 1 2 1 1 2 1 3 1 1 1 2 1 2 1 1 0 2-1 3-1l1-1h1l7-7s0-1 1-2c0 0 1-1 1-2s0-2-1-3v-1l-1-1zm-10 13h-1v1h-2s0-1-1-1c0-1-1-1-1-1v-1c0-1 1-1 1-1v-1l7-7h2c0-1 0-1 1 0h1c0 1 1 1 1 2v1l-1 1-7 7zm27 2h-2s-1 0-1 1l-12 14c-1 1-1 1-1 2l1 1 1 1c1 0 1-1 2-1l12-15v-3zm18 14c-1-1-2-1-2-1h-3c-1 0-2 1-2 1l-1 1-1 1-5 8-1 1v6c1 0 1 1 1 1 1 0 1 1 2 1 1 1 2 1 3 1h2c1 0 2-1 2-1 1 0 1-1 1-1l1-1 5-8c1 0 1-1 1-2v-5c-1 0-1-1-1-1-1 0-1-1-2-1zm-6 15c-1 0-1 0-1 1h-3c-1 0-1-1-1-1v-3l6-8v-1h3l1 1c0 1 1 1 1 1 0 1-1 1-1 1v1l-5 8zm30-2c-1-1-2-1-3-1h-1c-1 0-1 0-2 1 0 0-1 1-2 1v1l-1 1-4 9v2c-1 1-1 1 0 2 0 1 0 2 1 3l1 1h1c1 1 2 1 3 1s2 0 3-1c1 0 1 0 2-1 0 0 0-1 1-1v-1l4-9c1 0 1-1 1-2v-2c0-1-1-2-1-3-1 0-1 0-1-1h-2zm-4 15-1 1v1h-3c-1 0-1-1-1-1l-1-1v-1c1 0 1-1 1-1l4-8v-1l1-1h2c1 0 1 1 2 1v3l-4 8zm26-7h-2s0 1-1 1l-6 18v2s1 0 1 1h2c0-1 1-1 1-2l6-18v-1c0-1-1-1-1-1zm21 6c-1-1-2-1-3 0h-1l-1 1-2 2v2l-2 9v5l2 2s1 0 1 1h5c1 0 2-1 3-1 0-1 1-2 1-2 0-1 0-1 1-1v-1l2-10v-2c0-1 0-1-1-2 0-1-1-2-2-2 0-1 0-1-1-1h-2zm0 16v1h-1c0 1 0 1-1 1h-3v-3l2-9v-2h1c0-1 1-1 2-1 0 1 1 1 1 1l1 1v2l-2 9zm28-13c-1 0-2 0-3 1h-1c0 1-1 1-1 1-1 1-1 1-1 2s-1 1-1 1v1l-1 10v2c0 1 1 2 1 2 1 1 1 2 2 2s1 0 2 1h4c1-1 2-1 3-2 0-1 1-1 1-2v-2l1-10v-2c0-1 0-1-1-2 0-1-1-1-2-2l-1-1h-2zm2 16-1 1v1l-1 1h-3c0-1 0-1-1-1v-2l1-9v-2h1v-1h2c1 0 1 0 1 1h1v11zm26-16c-2 0-3 0-3 1-1 0-1 0-2 1v1c-1 1-1 1-1 2-1 0-1 1-1 1v1l1 10v2c0 1 1 1 1 2 1 1 2 1 2 1 1 1 1 1 2 1h2c1 0 2 0 3-1 1 0 1-1 2-2 0 0 1-1 1-2v-12s-1-1-1-2-1-1-1-2c-1-1-1-1-2-1-1-1-1-1-2-1h-1zm3 16v2s-1 0-1 1h-3l-1-1v-2l-1-9v-1s0-1 1-1v-1h3c1 0 1 1 1 1v1l1 1v9zm20-19-1 1c-1 0-1 1-1 2l3 18c0 1 0 1 1 1 0 1 1 1 1 1 1 0 1-1 2-1v-1l-3-19v-1c-1-1-1-1-2-1zm19-4c-1 0-1 1-2 1v2l5 18s0 1 1 1h1c1 0 1 0 1-1 0 0 1-1 0-1l-4-18c0-1 0-1-1-2h-1zm22-7c-1 0-2 1-2 1-1 1-1 1-1 2 0 0-1 0-1 1v4l3 9c0 1 1 1 1 1v1l2 2c1 0 2 1 3 1h1c1 0 1-1 2-1s2-1 2-2c1 0 2-1 2-2v-4l-3-9c0-1-1-2-1-2l-2-2c-1 0-2-1-3-1h-1c-1 0-1 1-2 1zm8 14v3c-1 0-1 0-2 1h-1s-1 0-1-1h-1v-1l-3-9v-3c1 0 1 0 2-1h1c1 0 1 0 1 1h1v1l3 9zm13-23s-1 0-1 1v1l9 17 1 1h2v-1c1-1 1-2 0-2l-8-17s-1 0-1-1c-1 0-1 0-2 1zm21-12c-1 0-2 1-2 2-1 0-1 1-1 1v5l1 1 5 8s0 1 1 1c1 1 2 1 3 2h2c1 0 1 0 2-1h1c1-1 2-2 2-3 1-1 1-1 1-2v-4c-1 0-1-1-1-1l-5-8-1-1c-1-1-2-1-3-1 0-1-1-1-2-1s-1 1-2 1c0 0-1 0-1 1zm11 11v3c0 1-1 1-1 1l-1 1h-2v-1h-1l-5-8v-3s0-1 1-1l1-1h1l1 1 1 1 5 7zm8-25s-1 0-1 1c0 0 0 1 1 1l11 15c1 0 1 0 2 1l1-1c1 0 1-1 1-1v-2l-12-14c0-1-1-1-1-1-1 0-2 0-2 1zm18-16c-1 0-2 1-2 2v5l1 1s0 1 1 1l6 7c1 0 1 0 1 1h1c1 0 2 1 2 1 1 0 2 0 3-1h1c1-1 1-1 2-1 1-1 1-2 2-3v-3c0-1 0-1-1-2v-1c-1 0-1-1-1-1l-7-6c0-1-1-1-1-2h-3c-1-1-1 0-2 0s-1 0-2 1c0 0-1 0-1 1zm13 9v1h1v2s-1 0-1 1l-1 1h-1c-1 0-1 0-1-1h-1l-6-7h-1v-2c0-1 0-1 1-2h1c0-1 1-1 1-1 0 1 1 1 1 1l7 7zm6-31c-1 1-1 2-1 3l-1 1v2c1 1 1 1 1 2 1 0 1 1 1 1s1 0 1 1l7 6h1l1 1h5c0-1 1-1 1-1l1-1c1-1 2-2 2-3v-3c0-1-1-1-1-2 0 0 0-1-1-1v-1l-8-6-1-1h-5c-1 0-1 1-2 1l-1 1zm14 8s0 1 1 1v2s0 1-1 1c0 1 0 1-1 1h-2v-1l-8-5v-1c-1 0-1-1-1-1v-1l1-1c0-1 1-1 1-1h3l7 6zm0-27v1c0 1 0 1 1 2l15 10h1c1 0 1 0 2-1v-1c0-1 0-1-1-1l-15-11h-2s-1 0-1 1zM887 768c0 1-1 2-1 3v2c1 0 1 0 1 1s1 1 1 2c0 0 1 0 1 1h1l8 5h5s1 0 2-1c0 0 1 0 1-1 1 0 1-1 1-1 1-1 1-2 1-3v-3l-2-2-1-1-9-5h-2c0-1-1-1-2 0-1 0-2 0-3 1l-1 1s0 1-1 1zm16 5v1h1v3c-1 0-1 1-1 1h-1c-1 1-1 0-1 0h-1l-8-4-1-1v-1c-1 0-1 0-1-1l1-1c0-1 0-1 1-1 0 0 0-1 1-1l1 1 9 4zm-4-30v4c0 1 0 1 1 2 0 0 0 1 1 2h1s1 0 1 1l9 3h4c1 0 2-1 3-1 0-1 0-1 1-2v-1c1-1 1-2 1-3s-1-2-1-3-1-1-2-2l-1-1-9-3h-2c-1-1-2 0-3 0s-1 1-2 1c0 1-1 1-1 1 0 1-1 1-1 2zm16 3h1s0 1 1 1v2c-1 1-1 1-1 2h-3l-9-3c0-1-1-1-1-1v-3s0-1 1-1h1c0-1 0-1 1 0l9 3zm-6-30c-1 1-1 2-1 3l1 1v1l2 2s1 0 1 1h1l9 2c1 0 1 1 1 1h1c1 0 2-1 3-1s1-1 2-2c0 0 1 0 1-1v-1c1-2 1-3 1-4-1-1-1-1-1-2l-2-2h-1l-1-1-9-2h-5c0 1-1 1-2 2l-1 1v2zm16 1v1h1l1 1v2c-1 0-1 1-1 1s-1 0-1 1h-1s-1 0-1-1l-9-2h-1v-1s-1 0-1-1v-1c1-1 1-1 1-2h3l9 2zm-11-25c0 1 0 1 1 2 0 0 0 1 1 1l18 3c1 0 1 0 2-1l1-1s0-1-1-1c0-1-1-1-1-1l-18-3h-2l-1 1zm3-19c0 1 0 1 1 2l1 1 19 1s1 0 1-1c1 0 1 0 1-1 0 0 0-1-1-1 0-1 0-1-1-1l-19-1h-1c-1 0-1 1-1 1zm2-24c0 2 0 3 1 4v1c1 0 1 0 1 1 1 0 2 1 2 1h14c1-1 2-1 2-2 1 0 1-1 2-2v-1c1-1 1-1 1-2s-1-2-1-3c-1-1-1-2-2-2 0-1-1-1-2-1h-14s-1 1-2 1c0 1-1 1-1 2-1 1-1 1-1 2v1zm16-3 1 1h1v1c1 0 1 1 1 1 0 1 0 1-1 2l-1 1h-12l-1-1v-3l1-1h2l9-1zm-17-20 1 1h1l19-2h1c1-1 1-1 1-2 0 0 0-1-1-1 0-1-1-1-1-1l-19 2c0 1-1 1-1 1-1 1-1 1-1 2zm-3-24c1 1 1 2 2 3v1c1 0 1 1 2 1h4l9-2h2c1-1 2-1 2-2l2-2v-4c-1-1-1-2-2-3 0 0-1-1-2-1 0-1-1-1-2-1h-2l-9 2c-1 0-2 1-2 1-1 0-2 1-2 2-1 0-1 1-2 2v3zm16-6h1c1 0 1 0 1 1 1 0 1 1 1 1v2s-1 0-1 1h-1l-10 2v1h-1v-1h-1c0-1-1-1-1-2v-1c0-1 1-1 1-1s0-1 1-1l10-2zm-21-17c0 1 1 1 1 1 0 1 1 1 2 0l18-5s0-1 1-1v-2l-1-1h-2l-18 6-1 1v1zm-8-22 2 2 1 1c1 0 1 1 2 1h3l1-1 9-3c0-1 1-1 1-1l1-1 1-1c1-1 1-2 1-3v-3c-1-1-2-2-2-3-1 0-2-1-3-1h-4l-9 4s-1 1-2 1c0 1-1 1-1 2-1 1-1 2-1 3v3zm14-9h3l1 1v3s-1 0-1 1h-1l-8 4h-3c0-1-1-1-1-2v-2c0-1 1-1 1-1h1l8-4zm-26-16c1 1 2 1 2 2 1 0 1 0 2 1h4l1-1 9-5h1v-1c1 0 2-1 2-2v-4c0-1 0-1-1-2 0-1-1-2-2-2 0-1-1-1-2-1h-3c-1 0-1 1-2 1l-8 4c0 1-1 1-2 2 0 0-1 1-1 2v6zm13-11h3l1 1v4h-1l-8 5h-3l-1-1c0-1-1-1-1-2l1-1v-1h1l8-5zm-24-8s0 1 1 1c0 0 1 0 1-1l15-12c1 0 1 0 1-1v-1c-1-1-1-1-2-1h-1l-15 12-1 1c0 1 0 1 1 2zm-15-18c1 1 2 1 3 2h2c1 0 2 0 3-1h1v-1l7-7c1 0 1 0 1-1l1-1v-2c1-1 0-2 0-3v-1c-1 0-1-1-1-1-1-1-2-2-3-2h-5c0 1-1 1-1 1s-1 0-1 1l-7 6c0 1-1 1-1 2s-1 2-1 2v3l1 1c0 1 1 1 1 2zm10-13v-1h3l1 1 1 1v1c-1 0-1 0-1 1l-7 7-1 1h-2s-1 0-1-1c-1 0-1-1-1-1v-1c0-1 0-1 1-1v-1l7-6zm-30-6c1 0 2 1 3 1h2c1 0 2-1 3-1l1-1 7-8v-1s1 0 1-1v-5l-1-1-1-1c-1-1-2-1-3-2h-3c0 1-1 1-2 1 0 0 0 1-1 1 0 0 0 1-1 1l-6 7c0 1-1 1-1 2v5c0 1 1 1 1 1 0 1 1 1 1 2zm8-15h1s0-1 1-1h1l1 1c1 0 1 1 1 1v2s0 1-1 1l-6 7v1h-3c-1-1-1-1-1-2 0 0-1 0 0-1v-1l6-8zm-30-2c1 1 2 1 3 1h2c1 0 2-1 2-1l1-1 1-1 5-8c1 0 1-1 1-1v-1c0-1 1-2 0-2v-3c-1 0-1-1-1-1-1 0-1-1-1-1-2-1-3-1-3-1h-3c-1 0-2 1-2 1l-1 1-1 1-5 8s-1 1-1 2v2c0 1 0 2 1 3v1c1 0 1 1 2 1zm7-15v-1h3c1 0 1 1 1 1l1 1c0 1 0 1-1 1v1l-5 8-1 1h-3l-1-1v-3l6-8zm-27 3c0 1 1 1 1 1l1-1 9-17v-2s0-1-1-1h-1c-1 0-1 0-1 1l-9 17v1c0 1 0 1 1 1zm-17-7h1c1-1 1-1 1-2l7-17c1-1 1-1 0-2 0 0 0-1-1-1h-1l-1 1-7 18c-1 0-1 1 0 2l1 1zm-22-8h3s1 0 1-1h1c1-1 2-1 2-2v-1c1 0 1-1 1-1l3-9v-2c0-1 0-2-1-3 0 0 0-1-1-2 0 0-1 0-1-1h-2c-1-1-2-1-3-1-1 1-2 1-2 2-1 0-2 1-2 1 0 1 0 1-1 1v1l-3 10v4c1 1 1 2 2 2 0 1 1 1 1 1 1 0 1 1 2 1zm2-17v-1c1 0 1 0 2-1h1l1 1c1 0 1 1 1 1v2l-3 9v1s-1 0-1 1h-2c-1 0-1 0-1-1-1 0-1 0-1-1v-1l3-10zm-25 11h1c1-1 1-1 1-2l4-18v-2h-2c0-1-1 0-1 0-1 0-1 1-1 1l-4 19s0 1 1 1c0 1 0 1 1 1zM717 423c1 0 2 0 3-1h1c0-1 1-1 1-1 1-1 1-2 1-2 0-1 1-1 1-1v-2l1-9v-2c0-1-1-2-1-2-1-1-1-2-2-2s-1-1-2-1h-4c-1 1-2 1-3 2 0 0-1 1-1 2v2l-1 10v2c0 1 0 1 1 2 0 1 1 1 2 2h1c0 1 1 1 2 1zm-2-17h1v-1l1-1h3s0 1 1 1v2l-1 9v1c0 1 0 1-1 1v1h-2c-1 0-1 0-1-1h-1v-12zm-22 16c1 0 1-1 2-1v-20c0-1 0-1-1-2h-2c-1 1-1 1-1 2v19s0 1 1 1l1 1zm-24 1c2-1 3-1 4-1 0-1 0-1 1-1v-1c1-1 1-2 1-3v-11l-1-1v-1c0-1-1-2-1-2-1-1-2-1-3-2h-3c-1 0-2 0-3 1l-2 2c0 1 0 1-1 2v2l1 10c0 1 0 1 1 2 0 1 0 1 1 2s1 1 2 1c1 1 1 1 2 1h1zm-4-16v-2c1 0 1 0 1-1h3s1 0 1 1h1v11h1c0 1 0 1-1 1v1c-1 0-1 1-2 1h-1l-1-1c-1 0-1-1-1-1v-1l-1-9zm-24 20c2 0 3-1 3-1l1-1 1-1c0-1 1-2 1-3v-2l-2-9v-1l-1-1c0-1-1-2-1-2-1-1-2-1-3-1 0-1-1-1-1-1-1 0-1 0-2 1-1 0-2 0-3 1l-2 2v5l2 9v2l2 2s1 1 2 1h3zm-5-15v-3c1 0 1 0 2-1h1c1 0 1 1 1 1s1 0 1 1v1l2 9v2h-1c0 1-1 1-1 1h-3v-1l-1-1-1-9zm-18 21c1 0 1-1 2-1v-2l-6-18s0-1-1-1h-1c-1 0-1 0-1 1 0 0-1 1 0 2l5 18 1 1h1zm-22 8c1-1 2-1 3-2v-1l1-1v-5l-4-9v-1c-1 0-1 0-1-1-1 0-1-1-2-1-1-1-1-1-2-1h-2s-1 1-2 1-2 1-2 2c-1 0-1 1-2 2v4c1 0 1 0 1 1l3 8c1 1 1 2 1 2l2 2h6zm-9-14v-2l1-1 1-1h2l1 1v1l4 9v2c0 1-1 1-2 1h-2s-1 0-1-1l-4-9zm-17 26c1-1 2-1 3-2v-1c0-1 1-1 1-2v-2l-1-1v-1l-4-8-1-1c0-1 0-1-1-1 0-1-1-1-2-2h-4l-1 1c-2 1-2 1-3 2 0 1-1 2-1 3v3c1 0 1 1 1 1l4 8c0 1 1 2 1 2 1 1 2 1 2 1 1 1 2 1 3 1h1c1 0 2-1 2-1zm-10-13v-3c1 0 1 0 1-1h3s0 1 1 1v1l4 8 1 1v1l-1 1-1 1h-2c-1 0-1-1-1-1v-1l-5-8zm-14 28c1-1 1-2 2-2v-2c1 0 1-1 1-1v-2l-1-1v-1l-6-8v-1l-1-1c-1 0-1-1-2-1h-4c-1 0-1 1-2 1l-2 2c0 1-1 2-1 3v2l1 1v1l5 8 2 2c1 0 1 1 2 1h4c1 0 1-1 2-1zm-11-12c-1 0-1 0-1-1v-2c1 0 1 0 1-1h4v1l5 8 1 1v2c-1 0-1 0-1 1h-4v-1l-5-8zm-8 26v-2l-12-15-1-1c-1 0-1 0-2 1v3l12 14 1 1c1 0 1 0 2-1zm-16 14c1-1 1-1 1-2v-1l-13-14-1-1c-1 0-1 1-2 1v3l13 14h2zm-16 17c1-1 1-2 1-3 1 0 1-1 1-1v-1c-1-1-1-2-1-3 0 0-1 0-1-1h-1l-6-7h-1l-1-1c-1 0-2 0-3-1 0 0-1 1-2 1s-1 0-2 1l-1 1c-1 1-1 2-2 3v2c0 1 1 2 1 3 0 0 1 0 1 1h1l6 7c1 0 2 0 2 1h5c1 0 1 0 1-1 1 0 1-1 2-1zm-14-9c-1 0-1-1-1-1v-1c0-1 1-1 1-2h1l1-1c1 0 1 1 1 1h1l7 7h1v2l-1 1c0 1-1 1-1 1h-3l-7-7zm-1 28v-2s0-1-1-1l-15-11c0-1-1-1-1-1-1 0-1 1-1 1-1 1-1 1-1 2l1 1 15 11h3zm-14 19c1-1 1-2 1-3v-2c-1-1-1-2-1-2l-1-1-1-1-8-5h-2c-1-1-2-1-3-1 0 1-1 1-2 1 0 1-1 1-1 1-1 1-1 1-1 2-1 1-1 2-1 3v2c0 1 1 2 1 3h1c0 1 1 1 1 1l8 5s1 0 2 1h2c1 0 2-1 3-1 0-1 1-1 1-1 0-1 1-1 1-2zm-15-5c0-1-1-1-1-1v-3c0-1 1-1 1-1 0-1 1-1 1-1h1c0 1 1 1 1 1l8 5h1v3l-1 1-1 1h-1l-1-1-8-4zm2 27c1 0 1-1 1-1-1-1-1-1-1-2l-17-8c0-1-1-1-1 0h-1c-1 1-1 1-1 2 1 0 1 1 1 1l17 9h1c1 0 1 0 1-1zm-10 22c1-1 1-2 1-3s0-1-1-2v-1c0-1-1-1-1-2h-1c-1 0-1-1-1-1l-9-4h-4c-1 0-2 1-3 1 0 1-1 1-1 2 0 0 0 1-1 1v6l2 2h1c0 1 0 1 1 1l8 3c1 1 2 1 2 1h3c1 0 1-1 2-2 1 0 1 0 1-1 1 0 1-1 1-1zm-16-4c-1 0-1 0-1-1v-2c0-1 0-1 1-2h2l9 4h1v1c1 0 1 0 1 1v1c-1 1-1 1-1 2h-3l-9-4zm6 31v-5l-1-1c0-1-1-1-1-2h-1c-1 0-1 0-1-1l-9-2-1-1h-1c-1 0-2 0-3 1-1 0-1 1-2 1 0 1-1 1-1 1 0 1 0 1-1 2v3c0 1 0 2 1 3 0 0 1 1 2 1 0 1 0 1 1 1h1l8 3c1 0 2 1 3 1 0 0 1-1 2-1s2-1 2-1c1-1 1-1 1-2l1-1zm-16-2-1-1h-1v-3s0-1 1-1c0 0 0-1 1-1h1l9 3h1c0 1 0 1 1 1v3s0 1-1 1l-1 1h-1v-1l-9-2zm9 25v-2h-1l-18-4h-2l-1 1v2c1 0 1 0 2 1l18 3c0 1 1 0 1 0 1 0 1-1 1-1zm-5 23c1-1 1-2 0-3v-1c-1 0-1-1-1-1-1-1-1-1-2-1 0-1-1-1-1-1h-1l-9-1h-3c-1 0-1 0-2 1-1 0-1 1-2 2 0 0 0 1-1 1v5c1 1 1 2 2 2 0 1 1 1 2 2h2l9 1h2c1 0 2 0 2-1 1 0 2-1 2-2 1 0 1 0 1-1v-2zm-16 1h-1c-1 0-1-1-1-1v-3c1 0 1-1 1-1h2l9 1h1c1 0 1 0 1 1 1 1 1 1 1 2s-1 1-1 1c0 1 0 1-1 1h-1l-10-1zM418 697v-3c0-1-1-1-1-1 0-1 0-1-1-1 0-1-1-1-2-2h-14s-1 1-2 1c0 1-1 1-2 2v7c1 0 1 1 2 2 0 0 1 1 2 1h14s1 0 2-1c0 0 1-1 1-2 1 0 1-1 1-1v-2zm-16 2h-1c-1 0-1-1-1-1v-3s0-1 1-1h12v1h1v3c0 1 0 1-1 1h-1v1l-10-1zm16 27c0-2 0-3-1-4l-1-1h-1c0-1-1-1-2-1 0-1-1-1-1-1h-1l-9 1h-3c0 1-1 1-2 2 0 0-1 1-1 2l-1 1v2c0 1 1 2 1 3 1 1 1 2 2 2 0 1 1 1 2 1h12s1-1 2-1c0 0 1 0 2-1 0-1 1-1 1-2 1-1 1-1 1-2v-1zm-16 3h-2l-1-1v-3s1 0 1-1h2l9-1h1s1 0 1 1h1v3c0 1-1 1-1 1l-1 1h-10zm18 20-1-1h-2l-18 3c-1 0-1 0-1 1-1 0-1 0-1 1 0 0 0 1 1 1 0 1 1 1 1 1l19-3c0-1 1-1 1-1 1-1 1-1 1-2zm3 20-1-1s-1-1-2 0l-18 4h-1c-1 1-1 1-1 2 1 0 1 1 1 1 1 0 1 1 2 0l18-4h1c1-1 1-1 1-2zm5 23c0-1-1-2-1-3h-1l-1-1c-1 0-2-1-3-1 0 0-1 0-1 1h-1l-9 3h-1s-1 0-1 1c-1 0-1 1-2 1 0 1-1 2-1 3v3c1 1 1 2 2 3s1 1 2 1c1 1 2 1 3 1h1l1-1 9-2c0-1 1-1 2-1 0-1 1-1 1-2 1-1 1-2 2-3v-1c0-1-1-1-1-2zm-14 8h-2s-1 0-1-1l-1-1v-2l1-1c1 0 1 0 1-1l9-2 1-1h1c0 1 1 1 1 1s0 1 1 1v2l-1 1h-1v1l-9 3zm22 14s-1 0-1-1h-2l-17 8c-1 0-1 0-1 1-1 1-1 1 0 2l1 1h1l18-8s0-1 1-1v-2zm9 22c0-1-1-2-2-3h-2c-1-1-2-1-3 0h-2l-8 5c-1 0-1 0-1 1h-1c-1 1-1 2-1 2-1 1-1 2-1 3v2c1 0 1 1 1 1 1 1 1 2 2 3 1 0 2 0 3 1 0 0 1 0 2-1h2l8-5c1 0 2-1 2-1 1-1 1-2 1-2 1-1 1-2 1-3v-2l-1-1zm-13 10h-1v1c-1 0-1 0-2-1v-1c-1 0-1-1-1-1v-1c0-1 1-1 1-1s1 0 1-1l8-4 1-1h1l1 1 1 1v2c0 1-1 1-1 1v1l-9 4zm25 11-1-1c-1 0-1 0-2 1l-16 10-1 1c0 1 0 1 1 1 0 1 0 1 1 1h1l16-10c1 0 1-1 1-1 1-1 0-1 0-2zm13 19c0-1-1-1-2-2h-5s-1 0-1 1h-1l-7 6c-1 0-1 1-1 1s-1 0-1 1c0 0-1 1-1 2v3s0 1 1 1v2c1 1 2 1 3 2h5s0-1 1-1h1l7-6 2-2c0-1 1-1 1-2v-3s0-1-1-1c0-1 0-1-1-2zm-11 12v1h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-2c1 0 1-1 1-1l8-6h2c1 0 1 0 1 1 1 0 1 1 1 1v1c0 1 0 1-1 1v1l-8 5zm30 9c-1-1-2-1-3-1 0-1-1-1-1-1h-2s-1 1-2 1l-1 1h-1l-7 7v1s-1 0-1 1c0 0-1 1-1 2s0 2 1 3v1c0 1 1 1 1 1 1 1 2 2 3 2s2 1 2 0h3s0-1 1-1l1-1 6-6 2-2c0-1 0-1 1-2 0-1 0-2-1-3v-1c0-1-1-1-1-2zm-10 14h-2c0 1 0 1-1 0h-1c0-1-1-1-1-2v-1l1-1 7-7h1v-1h2s0 1 1 1l1 1v1c0 1-1 1-1 1v1l-7 7zm27 2h-3l-12 15c-1 0-1 1-1 1 0 1 0 1 1 2h3l12-15v-3zm18 14c-1 0-2-1-3-1h-3c0 1-1 1-2 2h-1v1l-6 8v1s0 1-1 1v3s1 1 1 2 1 1 1 1c0 1 1 1 1 1 1 1 2 2 3 2s2 0 3-1c1 0 1 0 2-1l1-1v-1l6-7c0-1 0-2 1-3v-2c0-1 0-2-1-3l-1-1s-1 0-1-1zm-7 15v1h-1c0 1-1 1-1 1-1 0-1-1-2-1 0 0 0-1-1-1v-2l1-1 5-8c1 0 1 0 1-1h1c1 0 1 0 2 1 0 0 1 0 1 1v2h-1l-5 8zm31 0c-1-1-2-1-3-1h-2l-1 1c-1 0-1 1-2 1l-1 1v1l-5 8v1c0 1-1 1-1 2v2c1 1 1 2 1 2l1 1c1 1 1 1 2 1 1 1 2 1 3 1h2c1-1 2-1 3-2v-1s1 0 1-1l4-8c1-1 1-1 1-2v-3s0-1-1-2l-1-1-1-1zm-6 16c0 1 0 1-1 1h-2c-1 0-1-1-1-1-1 0-1-1-1-1v-1l1-1 4-8v-1h1v-1h1c1 0 1 0 2 1h1v3l-5 9zm31-4h-5s-1 0-1 1c-1 0-1 1-2 1v1c-1 0-1 1-1 1l-4 9v5s1 1 1 2c1 0 1 0 2 1 0 0 1 0 1 1h3c1 0 2 0 3-1 0 0 1-1 2-1v-1c0-1 1-1 1-1l3-9c1-1 1-2 1-2v-3c-1 0-1-1-2-2 0 0 0-1-1-1l-1-1zm-4 16v1s-1 0-1 1h-2c-1 0-1-1-2-1v-3l4-8v-2h3c1 0 1 0 1 1 1 0 1 0 1 1v1l-4 9zm27-7c-1-1-1 0-2 0 0 0-1 0-1 1l-6 18v1c0 1 1 1 1 1 1 1 1 1 2 0l1-1 6-18v-1c0-1-1-1-1-1zm18 5h-2l-1 1-4 19v1c0 1 1 1 1 1h2l1-1 4-19v-1c0-1-1-1-1-1zm24 5c-1-1-2-1-3 0h-2s0 1-1 1c0 1-1 1-1 2 0 0 0 1-1 1v1l-2 9v3s1 1 1 2 1 1 2 2l1 1h5c1 0 1-1 2-1 1-1 1-2 2-2v-2l2-10v-2c0-1 0-1-1-2 0-1 0-2-1-2-1-1-1-1-2-1h-1zm-1 16v1c0 1-1 1-1 1h-3c0-1-1-1-1-1v-2l2-9v-1c0-1 0-1 1-1h1c0-1 0-1 1-1l1 1c1 0 1 1 1 1v2l-2 9zm24-14s-1 0-1 1c-1 0-1 0-1 1l-2 19s0 1 1 1c0 1 1 1 1 1 1 0 1 0 2-1v-1l2-19v-1c-1-1-1-1-2-1zm24 1c-1 0-2 0-3 1h-1l-1 1c-1 1-1 2-2 2v13c0 1 0 1 1 1 0 1 0 2 1 2 0 1 1 2 2 2 0 0 1 0 1 1h2c1 0 2-1 3-1 1-1 2-1 2-2 1 0 1-1 1-2v-14c0-1 0-1-1-2l-2-2h-3zm3 16-1 1v1h-1c0 1-1 1-1 1-1 0-1 0-2-1-1 0-1-1-1-1v-12c1 0 1-1 1-1h3c1 0 1 0 1 1v1h1v10zm21-18s0 1-1 1v2l1 18v2h3c0-1 1-1 1-2l-1-19c-1 0-1-1-1-1-1 0-1-1-2-1zM733 971c-1 0-2 1-3 1 0 1-1 1-1 1 0 1-1 1-1 1 0 1 0 2-1 3v2l2 9v2c1 1 1 2 2 2 0 1 1 1 2 2h3c2-1 3-1 3-2 1 0 2-1 2-2 0 0 1-1 1-2v-2l-2-9v-3s-1-1-2-1c0-1-1-1-2-2h-3zm5 16v1c0 1-1 1-1 1l-1 1h-2s0-1-1-1v-2l-2-9v-2h1c0-1 1-1 2-1h1s1 0 1 1l1 1 1 10zm23-22c-2 0-2 1-3 1 0 1-1 1-1 1 0 1-1 1-1 1v5l2 9v1c1 0 1 1 1 1 0 1 1 1 2 2 0 0 1 1 2 1h3c1-1 2-1 3-2 1 0 1-1 2-2v-4l-2-10s-1-1-1-2c0 0-1-1-2-1 0-1-1-1-2-1-1-1-1-1-2-1l-1 1zm6 15v2c-1 1-1 1-2 1h-2c0-1-1-1-1-1v-1l-2-9-1-1c1 0 1-1 1-1v-1h2c0-1 1-1 1-1l1 1s1 0 1 1l2 10zm16-23c0 1-1 1-1 1v2l6 18c1 0 1 1 1 1h2l1-1v-2l-6-17c0-1-1-1-1-2h-2zm23-9c-1 0-2 1-2 2l-1 1v1c-1 1-1 2-1 3v1c1 0 1 0 1 1l3 8c1 1 1 1 1 2l2 2c1 0 2 1 3 1 0 0 1 0 1-1h2c1-1 2-1 3-2 0-1 1-1 1-2v-5l-4-9-1-1c-1-1-1-2-2-2s-1-1-2-1h-2c0 1-1 1-2 1zm9 14v2l-1 1c-1 1-2 1-2 1s-1 0-1-1h-1v-1l-4-9v-2h1c0-1 0-1 1-1 0-1 1-1 1-1 1 0 1 0 1 1h1v1l4 9zm17-27c-1 0-2 1-3 2v1c0 1-1 1-1 1v3s0 1 1 1v1l4 8 1 1s0 1 1 1c0 1 1 1 2 1 0 1 1 1 2 1s1 0 2-1h1c1-1 2-2 3-2 0-1 1-2 1-3v-3l-1-1-4-9c-1 0-1-1-2-1 0-1-1-1-2-2h-4s-1 0-1 1zm10 13v2l-1 1c-1 1-1 1-2 1h-1c0-1 0-1-1-1v-1l-4-8-1-1v-2c1 0 1 0 2-1h2s1 0 1 1l5 9zm14-29c-1 1-2 2-2 3-1 0-1 0-1 1v5c1 0 1 0 1 1l5 7c0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 2 1s1 1 2 0h2s1 0 1-1c1-1 2-1 3-2v-3c1-1 0-1 0-2v-1c0-1-1-1-1-1l-5-8c0-1-1-1-1-2-1 0-2 0-2-1h-5c0 1-1 1-1 1zm11 12v1s1 0 1 1c0 0-1 0-1 1 0 0 0 1-1 1 0 0-1 0-1 1 0 0-1 0-1-1h-1s0-1-1-1l-5-8v-2c0-1 1-1 1-1l1-1h2v1h1l5 8zm8-26-1 1c0 1 0 1 1 2l11 14c1 0 1 1 2 1 0 0 1 0 1-1 1 0 1 0 1-1s0-1-1-2l-11-14c-1 0-1-1-2-1 0 0-1 0-1 1zm15-14v2c-1 0 0 1 0 1l12 14c1 0 1 1 2 1 0 0 1 0 1-1 1 0 1-1 1-1 0-1 0-1-1-2l-12-14h-3zm17-17c-1 1-1 2-2 3v3c0 1 1 1 1 2 0 0 0 1 1 1v1l7 6c1 0 1 1 1 1h1c1 1 2 1 3 1 0 0 1 0 2-1h1c1-1 1-1 2-1 1-1 1-2 1-3 1-1 1-2 1-3-1-1-1-1-1-2l-1-1s0-1-1-1l-7-6c0-1-1-1-1-1-1-1-2-1-3-1 0 0-1 0-2 1h-2c0 1-1 1-1 1zm14 9v1h1v2s-1 0-1 1c-1 0-1 1-1 1h-2l-1-1-7-6v-1h-1v-2s1 0 1-1l1-1h2l1 1 7 6zm2-28v2s0 1 1 1l14 12h3v-3l-15-12h-3zm15-19c-1 1-1 2-2 3v1c0 1 1 1 1 2 0 0 0 1 1 2v1h1l8 5 1 1h1c1 1 2 1 3 1 0 0 1-1 2-1l1-1 1-1c1-2 1-3 2-3 0-1 0-2-1-3 0-1 0-2-1-2 0 0 0-1-1-1v-1l-8-5c-1 0-1-1-2-1h-3s-1 0-2 1c0 0-1 0-1 1-1 0-1 1-1 1zm14 7h1l1 1v1l-1 1c0 1-1 1-1 1 0 1-1 1-1 1h-1c0-1 0-1-1-1l-7-5h-1v-1h-1v-1c0-1 1-1 1-2l1-1h3l7 6zm-1-28v1c0 1 0 1 1 2l16 9h1c1 0 1 0 1-1 1 0 1 0 1-1s-1-1-1-1l-16-10h-2s-1 0-1 1zm12-21c-1 1-1 2-1 3v1c0 1 0 1 1 1 0 1 0 2 1 2 0 1 0 1 1 1l1 1 8 4h5s1 0 2-1l1-1c0-1 1-1 1-2 1-1 1-2 1-3s0-2-1-2c0-1-1-2-1-2l-1-1h-1l-8-4c-1-1-2-1-2-1h-3c-1 0-2 1-2 1-1 0-1 1-1 1-1 1-1 1-1 2zm15 4c1 0 1 0 1 1h1v3c-1 0-1 1-1 1h-3l-9-4-1-1v-3l1-1h3l8 4zm-3-30c-1 1-1 2-1 3 0 0 0 1 1 1v1c1 1 1 2 2 2l1 1h1l8 3c1 0 1 1 1 1h1c1 0 2 0 3-1 1 0 1 0 2-1l1-1c0-1 1-1 1-2s1-2 0-3v-2c-1-1-1-2-2-2l-1-1h-1l-9-3c0-1-1-1-2-1h-2c-1 1-2 1-3 2 0 0 0 1-1 1v2zm16 2v1h1v1c1 1 0 1 0 2s0 1-1 1c0 0 0 1-1 1h-1l-9-4h-1v-1c-1 0-1 0-1-1v-1l1-1 1-1h2l9 3zm-8-26v1c1 1 1 1 2 1l17 6h2l1-1v-2c-1 0-1-1-1-1l-18-5c-1-1-1 0-2 0 0 0-1 0-1 1zm7-23v3c0 1 0 1 1 1v1c1 1 1 2 2 2h1c0 1 1 1 1 1l9 2h2c1 0 2 0 3-1 1 0 1-1 2-1 0-1 0-1 1-2v-1c0-2 1-3 0-4 0-1 0-1-1-2 0-1-1-1-2-2h-2l-9-2h-4c-1 1-2 1-3 2v1c-1 1-1 1-1 2zm16 1h2v1c1 1 1 1 0 2v1l-1 1h-2l-9-2h-1c0-1 0-1-1-1v-2c0-1 0-1 1-2 1 0 1-1 1 0h1l9 2zm-10-30v3l1 1c0 1 0 1 1 1 0 1 1 1 1 2h3l9 2h2c1 0 2 0 2-1 1 0 2-1 2-2 1 0 1 0 1-1s0-1 1-2c0-1 0-2-1-3 0-1 0-2-1-2 0-1-1-1-2-2h-2l-9-2h-2c-1 0-2 0-3 1l-2 2v1c-1 1-1 1-1 2zm16 0h2s0 1 1 1v2l-1 1s0 1-1 1h-2l-9-2h-1c-1 0-1-1-1-1v-2s0-1 1-1v-1h2l9 2zm-12-29v3c0 1 0 1 1 2l1 1s1 1 2 1h2l9 1h2c1 0 2-1 3-1 0-1 1-1 1-2 1-1 1-1 1-2v-4c0-1-1-2-2-3 0 0-1-1-2-1h-2l-9-1h-2c-1 0-2 1-3 1 0 1-1 1-1 2-1 1-1 1-1 2v1zm16-1h1c1 0 1 1 1 1v3s0 1-1 1h-2l-9-1h-2v-4l1-1h2l9 1zM1001 639v2h21s1 0 1-1l1-1c0-1-1-1-1-2h-20c-1 0-1 1-2 1v1zm-1-20c0 1 1 1 1 2h2l18-1c1 0 1-1 2-1v-1c0-1 0-1-1-2h-1l-19 1s-1 0-1 1l-1 1zm-1-24c0 2 0 3 1 3 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 2 1h2l9-2h2c1-1 2-1 2-2 1 0 1-1 2-2v-3c0-2-1-3-1-3-1-1-1-2-2-2s-2-1-2-1h-3l-9 2h-2l-2 2c0 1-1 1-1 2s-1 1-1 2c0 0 0 1 1 1zm15-5h2s0 1 1 1v3l-1 1h-1l-10 2h-1c-1 0-1 0-1-1 0 0 0-1-1-1 0-1 0-1 1-2v-1h2l9-2zm-20-19c1 0 1 1 1 1 1 1 1 1 2 1l18-5h2v-2l-1-1s-1-1-2 0l-18 4s-1 0-1 1c-1 0-1 0-1 1zm-5-23c0 1 1 2 2 3l1 1h1c1 0 1 1 2 1h1c0-1 1-1 1-1l9-3h1c1 0 1 0 1-1 1 0 2-1 2-1 0-1 1-2 1-3v-3c-1-1-1-2-2-3 0-1-1-1-2-1-1-1-1-1-2-1h-1c-1 0-1 1-2 1l-9 3s-1 0-2 1l-1 1c-1 1-1 2-1 3v3zm15-8h1c1 0 1 1 1 1 1 0 1 1 1 1v3h-1l-1 1-9 3h-2v-1c-1 0-1-1-1-1v-3h1l1-1 9-3zm-23-15c1 0 1 0 1 1h2l18-7s0-1 1-1v-2s-1 0-1-1h-2l-17 7c-1 0-1 1-2 1v2zm-9-22c1 1 1 2 2 2l1 1h2c0 1 1 1 2 1 0-1 1-1 1-1h1l9-4c0-1 0-1 1-1v-1c1 0 2-1 2-2 0 0 1-1 1-2s-1-1-1-2v-1c-1-1-1-2-2-3-1 0-2-1-2-1h-4l-1 1-9 4-1 1-2 2v6zm14-10h2c1 0 1 1 1 1 1 1 1 1 1 2 0 0 0 1-1 1v1h-1l-9 4v1h-1c-1 0-1 0-1-1 0 0-1 0-1-1 0 0-1-1 0-1v-1c0-1 0-1 1-1v-1l9-4zm-27-15 2 2c1 1 1 1 2 1h4l1-1 8-5c1 0 1 0 1-1h1c1-1 1-2 1-3 1 0 1-1 1-2s0-1-1-2v-1c-1-1-2-2-2-3h-6c-1 0-1 1-1 1l-8 5c-1 0-2 1-2 1-1 1-1 2-1 2-1 1-1 2-1 3s0 1 1 2v1zm13-11h2c1 0 1 0 1 1 1 0 1 1 1 1v1c0 1-1 1-1 1s0 1-1 1l-8 5h-2c-1 0-1 0-1-1l-1-1v-2h1l1-1 8-5zm-26-9h3l15-11c1 0 1-1 1-1v-2s-1 0-1-1c-1 0-1 0-2 1l-15 11c-1 0-1 0-1 1v2zm-14-19c0 1 1 2 2 2h2s0 1 1 0h2c1 0 1 0 1-1h1l7-7h1c0-1 0-1 1-1 0-1 0-2 1-3v-2c-1-1-1-1-1-2l-1-1-2-2h-5c-1 0-1 1-1 1h-1l-7 7c-1 0-2 1-2 1 0 1-1 2-1 3v2c0 1 0 1 1 2 0 0 0 1 1 1zm10-13h3s1 0 1 1c0 0 1 0 1 1v1s0 1-1 1l-7 7h-1l-1 1s-1 0-1-1h-1c-1-1-1-1-1-2v-1l1-1 7-7zm-29-7c1 1 2 1 2 1 1 1 1 1 2 1h1c1-1 2-1 2-1 1 0 1-1 1-1 1 0 1 0 1-1l7-7v-1c1 0 1 0 1-1 0 0 1-1 1-2s0-2-1-3v-1c-1 0-1-1-2-1 0-1-1-2-2-2h-3c-1 0-2 0-2 1-1 0-1 0-1 1h-1l-6 7c-1 1-1 2-2 2v5c0 1 0 1 1 2l1 1zm9-14v-1h2c1 0 1 0 2 1 0 0 0 1 1 1v1s0 1-1 1v1l-7 7h-1v1h-1c-1 0-1-1-2-1v-1c0-1-1-1 0-1v-2l7-7zm-31-5c1 0 2 1 3 1h2c1 0 2 0 3-1l1-1 6-8c1 0 1 0 1-1l1-1v-5c-1 0-1 0-1-1l-1-1c-1-1-2-1-3-2h-3c-1 1-1 1-2 1 0 1-1 1-1 1s0 1-1 1l-6 7c0 1-1 1-1 2v5c0 1 0 1 1 1 0 1 1 1 1 2zm8-15h1s0-1 1-1h1l1 1c1 0 1 1 1 1v2s0 1-1 1l-6 7v1h-3c-1-1-1-1-1-2-1 0-1 0-1-1 0 0 1 0 1-1l6-8zm-27 1h3l10-16c1-1 1-1 1-2l-1-1h-1c-1 0-1 0-2 1l-10 15c-1 1-1 1-1 2l1 1zm-17-10h2l1-1 10-16v-2s0-1-1-1h-1c-1 0-1 0-1 1l-10 16s-1 1 0 1v2zm-20-11h6c0-1 1-1 2-2v-1s1 0 1-1l4-8v-3c1 0 0-1 0-2s0-2-1-2c0-1-1-1-1-1 0-1-1-1-1-1-2-1-3-1-4-1 0 0-1 0-2 1-1 0-1 1-2 1 0 1 0 1-1 1v1l-4 9c-1 1-1 1-1 2v2c0 1 1 2 1 3 1 0 1 1 1 1 1 0 1 0 2 1zm4-16 1-1v-1h3c0 1 1 1 1 1 0 1 0 1 1 1v1l-1 1-4 9v1h-3c-1 0-1 0-2-1v-3l4-8zm-27 6h2l1-1 7-18v-1c0-1 0-1-1-1h-1c-1 0-1 0-1 1l-8 18v1l1 1zm-22-8c2 1 3 1 4 1 0-1 0-1 1-1 0 0 1 0 1-1 1 0 1-1 2-1v-1c0-1 1-1 1-1l2-10c1 0 1 0 1-1v-1c0-1-1-1-1-2s-1-2-1-2c-1-1-1-1-2-1l-1-1h-3c-1 0-2 1-3 1 0 1-1 1-1 2-1 0-1 1-1 1v1l-3 9v5l2 2 1 1h1zm2-16 1-1c0-1 1-1 1-1h2s1 0 1 1c0 0 1 0 1 1v1l-3 10s0 1-1 1l-1 1h-1c-1-1-1-1-2-1v-3l2-9zm-25 10h1c1 0 1-1 1-1l4-19c1 0 0-1 0-1 0-1 0-1-1-1h-1c-1 0-1 1-1 1l-5 19v1c1 1 1 1 2 1zm-23-4h3c0-1 1-1 1-1s1 0 1-1c1 0 1-1 1-2 1 0 1 0 1-1v-1l1-9c0-1 1-1 1-2 0 0-1 0-1-1v-2l-2-2h-2c0-1-1-1-1-1-2 0-3 0-3 1-1 0-2 0-3 1 0 1-1 1-1 2 0 0 0 1-1 1v1l-1 10v2c0 1 0 1 1 2 0 1 1 1 2 2l1 1h2zm-1-16v-1l1-1s0-1 1-1h1c1 0 1 0 2 1 0 1 1 1 1 1 0 1-1 1-1 1l-1 10v1l-1 1h-3l-1-1v-2l1-9zm-29 13h4s0-1 1-1c0 0 0-1 1-1 0 0 1-1 1-2v-1c1 0 1-1 1-1v-10c1 0 1 0 1-1 0 0-1 0-1-1s0-1-1-2c0-1-1-1-1-2h-2c0-1-1-1-2-1s-2 0-3 1c-1 0-1 1-2 1 0 1-1 2-1 2 0 1 0 1-1 1v2l-1 9c0 1 0 2 1 2 0 1 0 2 1 2 0 1 1 2 1 2 1 1 1 1 2 1h1zm-1-16v-1l1-1 1-1h1c1 0 1 0 2 1 0 1 1 1 1 1v1l-1 10c0 1 0 1-1 1 0 1 0 1-1 1h-3v-1c-1 0-1-1-1-1v-1l1-9zm-22 16s1 0 1-1c1 0 1-1 1-1v-19c0-1-1-1-1-2h-1c-1 0-1 0-2 1v21c1 1 1 1 2 1zM666 335c1 0 2 0 3-1 1 0 1 0 1-1 1 0 1 0 1-1 1 0 1-1 1-2v-13l-1-1s0-1-1-2c0 0-1-1-2-1l-1-1h-2c-1 0-2 1-3 1-1 1-2 1-2 2-1 1-1 2-1 2v12c0 1 0 1 1 2 0 1 0 2 1 2 0 1 1 1 2 2h3zm-3-16v-1c0-1 0-1 1-1 0-1 1-1 1-1h2v1c1 0 1 1 1 1v10l1 1h-1v1s0 1-1 1h-3v-1c-1 0-1 0-1-1v-10zm-25 20c1 0 2-1 3-1 0-1 1-1 1-1 0-1 1-1 1-1 0-1 0-2 1-3v-2l-2-9v-2c-1-1-1-2-2-2-1-1-1-1-2-1-1-1-1-1-2-1h-1c-2 1-3 1-3 2-1 0-2 1-2 2-1 0-1 1-1 2v2l1 10c1 0 1 1 1 2l2 2s1 1 2 1h3zm-5-15v-2s0-1 1-1l1-1h2s0 1 1 1v2l2 9v2h-1c0 1-1 1-2 1h-1s-1 0-1-1l-1-1-1-9zm-23 21c1 0 2-1 3-1 0-1 1-1 1-1 0-1 0-1 1-2v-4l-2-9c0-1 0-1-1-1v-1c-1-1-1-2-2-2 0-1-1-1-2-1h-3c-2 0-3 1-3 1-1 1-1 2-2 3v4l2 9c0 1 1 2 1 2 0 1 1 2 2 2 0 1 1 1 2 1h3zm-6-15v-3h4l1 1v1l2 9v2c-1 1-1 1-2 1h-2l-1-1v-1l-2-9zm-18 22c1 0 1 0 2-1v-1l-6-18c0-1 0-1-1-1 0-1-1-1-1-1l-1 1c-1 1-1 1 0 2l5 18s0 1 1 1h1zm-19 7c1 0 1 0 2-1v-1l-7-18s0-1-1-1h-1c-1 0-1 0-1 1 0 0-1 1 0 1l6 18c0 1 0 1 1 1h1zm-21 10c1-1 2-1 2-2l1-1v-1c1-1 1-2 0-3v-2l-4-8c0-1-1-1-1-1v-1c-1-1-2-1-2-2h-4c-1 0-1 0-2 1-1 0-2 1-3 2 0 0 0 1-1 2v3l1 1 4 9c0 1 1 1 1 2 1 0 1 1 2 1 1 1 2 1 3 1h1c1-1 1-1 2-1zm-10-13v-2s0-1 1-1c0 0 0-1 1-1h2s1 0 1 1l4 9h1v1c0 1-1 1-1 1 0 1 0 1-1 1l-1 1h-2v-1l-1-1-4-8zm-12 25c0-1 0-1 1-2 0 0 0-1-1-1l-8-17c-1 0-1 0-2-1 0 0-1 0-1 1 0 0-1 0-1 1v1l9 17 1 1h2zm-21 12c1 0 2-1 2-2 1 0 1-1 1-1v-5c-1 0-1-1-1-1l-5-8-1-1-1-1s-1 0-2-1h-2c-1 0-1 0-2 1h-1l-3 3v6c1 0 1 0 1 1l5 8 1 1c1 1 2 1 3 1 0 1 1 1 2 0h2s1 0 1-1zm-11-12v-2c0-1 0-1 1-1 0-1 1-1 1-1h1c1 0 1 0 1 1h1l5 8v3s0 1-1 1l-1 1c-1 0-1 0-1-1h-1l-1-1-5-8zm-9 27 1-1c0-1 0-2-1-2l-11-15s0-1-1-1-1 0-2 1v2l11 15c0 1 1 1 1 1h2zm-19 15c1-1 2-2 2-3v-1c1 0 1-1 1-1-1-1-1-2-1-3l-1-1v-1l-6-6-1-1-1-1c-1 0-2-1-2-1-1 0-2 0-3 1h-1c-1 0-1 1-2 1-1 1-1 2-2 3v5c1 0 1 0 1 1l1 1 6 7s1 1 2 1c0 0 1 1 2 1h3c0-1 0-1 1-1l1-1zm-12-10c-1 0-1 0-1-1v-2l1-1 1-1h1s1 0 1 1h1l6 7v1h1v2c-1 0-1 1-1 1-1 0-1 1-2 1h-1l-1-1-6-7zm-9 31c1-1 1-2 1-3l1-1v-2c0-1-1-1-1-2v-1c-1 0-1-1-1-1l-7-7h-1s0-1-1-1c0 0-1 0-2-1-1 0-2 1-2 1-1 0-1 0-2 1 0 0-1 0-1 1-1 0-2 1-2 2v5l1 1c0 1 1 1 1 1l6 7c1 0 1 1 2 1s2 1 2 1c1 0 2 0 3-1h1c1-1 1-1 2-1zm-13-10h-1v-2c0-1 0-1 1-2l1-1h1s0 1 1 1l7 7h1v2c0 1-1 1-1 2 0 0-1 0-1 1h-1c-1 0-1 0-1-1h-1l-6-7zm-4 27c1 0 1-1 1-1 0-1 0-1-1-2l-14-11c-1-1-1-1-2-1 0 0-1 0-1 1v3l15 11c0 1 1 1 1 1 1 0 1 0 1-1zm-15 20c1-1 1-2 1-3v-3c0-1-1-1-1-2 0 0 0-1-1-1v-1l-8-5-1-1h-1c-1 0-2-1-2 0h-3l-1 1c-1 0-1 1-1 1-1 1-2 2-2 3v3c1 1 1 1 1 2 1 0 1 1 1 1l1 1 7 5c1 1 2 1 2 1 1 1 2 1 3 1s1-1 2-1 1-1 2-1c0 0 0-1 1-1zm-15-7v-1s-1 0-1-1v-1s0-1 1-1c0-1 1-1 1-1 0-1 1-1 1-1l1 1h1l7 6h1v3l-1 1c-1 1-1 1-2 1v-1h-1l-8-5zm-2 31c0-1 1-2 1-3v-2c-1-1-1-2-1-3h-1c0-1-1-1-1-1l-8-5c0-1-1-1-1-1h-6c0 1-1 1-1 1 0 1-1 1-1 2-1 1-1 2-1 3v2c0 1 1 2 1 3h1c0 1 0 1 1 1l7 5c1 1 2 1 2 1h3c1 0 1 0 2-1h2c0-1 0-1 1-2zm-15-6-1-1v-3c0-1 1-1 1-1h3l8 5v1h1v2l-1 1c0 1 0 1-1 1h-2l-8-5zm0 31c0-1 1-2 1-3v-1c0-1 0-1-1-2 0 0 0-1-1-2h-1c0-1 0-1-1-1l-8-4c0-1-1-1-1-1h-3c-1 0-2 0-3 1l-1 1-1 1c-1 1-1 3-1 3 0 1 0 2 1 3 0 1 0 1 1 2 0 0 0 1 1 1h1l8 5c1 0 1 0 2 1 1 0 1 0 2-1 1 0 2 0 3-1 0 0 1 0 1-1 0 0 1 0 1-1zm-15-5c-1 0-1 0-1-1h-1v-3c1 0 1-1 1-1h3l8 4 1 1s1 0 1 1v1l-1 1c0 1 0 1-1 1 0 1 0 1-1 1h-1v-1l-8-4zm3 27c1 0 1-1 1-1l-1-1-17-8c-1-1-1-1-2 0 0 0-1 0-1 1v1c0 1 0 1 1 1l17 8s1 1 1 0c1 0 1 0 1-1zm-8 19v-2l-1-1-17-7h-2s0 1-1 1v2l1 1 18 7h1c1 0 1-1 1-1zm-9 22c1-1 1-2 1-3 0 0 0-1-1-1v-1c-1-1-1-2-2-2l-1-1h-1l-9-3h-4c-1 1-2 1-2 2-1 0-1 1-1 1-1 1-1 1-1 2s-1 2 0 3v2c1 1 1 2 2 2 0 0 1 0 1 1h1l9 3h5c0-1 1-1 2-2 0 0 0-1 1-1v-2zm-16-2c-1 0-1 0-1-1l-1-1s0-1 1-1v-1l1-1h2l9 3h1v1c1 0 1 0 1 1v1c0 1-1 1-1 1 0 1-1 1-1 1h-2l-9-3zm9 26v-1c0-1-1-1-1-1l-18-5h-2c0 1-1 1-1 2v1l1 1 19 5h1c1-1 1-1 1-2zM337 642v-4l-1-1v-1c-1-1-1-1-2-1 0-1-1-1-1-1h-1l-9-2h-5l-2 2s0 1-1 1v2c0 1-1 2 0 3 0 1 0 2 1 3 0 0 1 1 2 1l1 1h1l9 2h2c1 0 2 0 2-1 1 0 2-1 3-1v-2c1 0 1-1 1-1zm-16-1h-1s-1 0-1-1v-1c-1 0-1-1 0-1v-2h3l9 2h2v3s0 1-1 1v1h-2l-9-2zm12 24-1-1c0-1-1-1-1-1l-19-2h-1c-1 1-1 1-1 2v1c1 1 1 1 2 1l18 2h2c0-1 0-1 1-2zm-3 25c0-1 0-2-1-3v-1l-1-1c-1-1-2-1-2-2h-2l-10-1h-1s-1 0-1 1c-1 0-2 0-2 1-1 0-2 1-2 1 0 1-1 1-1 2v5l2 2s1 1 2 1l1 1h13s1 0 2-1l2-2v-1c0-1 0-1 1-2zm-17 2c-1 0-1-1-1-1-1 0-1 0-1-1v-3h1c0-1 1-1 1-1h1l9 1h2v1c1 1 1 1 1 2l-1 1c0 1 0 1-1 1h-11zm15 27c0-2 0-3-1-3 0-1 0-1-1-2v-1c-1 0-2 0-3-1h-12l-1 1c-1 0-2 0-2 1-1 1-2 1-2 2s0 1-1 2v1c0 2 0 3 1 3 0 1 1 2 2 2 0 1 1 1 2 2h11c1-1 2-1 2-1 1 0 2 0 3-1 0-1 1-1 1-2s1-1 1-2v-1zm-16 3h-2c0-1 0-1-1-1v-3l1-1s1 0 1-1h12c0 1 0 1 1 1v3l-1 1h-1l-1 1h-9zm16 22v-2h-2l-18 1c-1 0-1 0-2 1v3h2l19-1s0-1 1-1v-1zm2 24c0-1 0-2-1-3v-1c-1 0-1 0-1-1h-4c0-1 0-1-1 0l-9 1h-2c-1 1-2 1-2 2-1 0-1 1-2 2v3c0 1 0 2 1 3 0 1 1 2 2 2 0 0 1 1 2 1h2l9-1c1 0 2 0 3-1 0 0 1-1 2-1 0-1 1-2 1-2v-4zm-15 5h-2l-1-1v-3l1-1h1l10-2h1v1h1v2c1 0 0 1 0 1v1c-1 0-1 1-1 1h-1l-9 1zm20 23c0-1-1-2-1-2l-1-1c-1-1-1-1-2-1 0 0-1-1-2-1h-2l-9 2c-1 0-1 1-1 1h-1c-1 1-2 1-2 2-1 0-1 1-1 2-1 1-1 1-1 2v1c1 2 1 3 2 3 0 1 1 2 2 2 0 0 1 1 2 1h1c1 0 1 0 1-1l10-2h2c0-1 1-1 1-2l2-2v-4zm-15 7h-2c0-1-1-1-1-1l-1-1v-2l1-1 1-1 10-2h1c1 0 1 1 1 1 1 0 1 1 1 1v2s0 1-1 1h-1v1l-9 2zm21 21c0-1-1-2-1-3-1 0-1 0-1-1h-2s-1-1-2-1c0 0-1 0-1 1h-1l-9 3h-1s-1 0-1 1c-1 0-1 1-2 1 0 1-1 2-1 3v3c1 1 1 2 2 3s1 1 2 1c1 1 2 1 3 1h1l1-1 9-3s1 0 2-1l1-1c1-1 1-2 1-3 1 0 1-1 0-1v-2zm-14 8h-2s-1 0-1-1l-1-1v-2l1-1c1 0 1 0 1-1l9-2 1-1h1s0 1 1 1v1c1 1 1 1 0 2v1h-1v1l-9 3zm22 16c0-1-1-1-1-2h-2l-18 7s0 1-1 1v2l1 1h2l17-7c1 0 1 0 2-1v-1zm7 18-1-1h-2l-17 8s-1 0-1 1v1c0 1 0 1 1 1 0 1 1 1 1 0l18-7 1-1v-2zm10 21c-1-1-2-1-2-2h-2c0-1 0-1-1-1h-2c-1 0-1 0-1 1h-1l-9 5h-1v1l-2 2v4c0 1 0 1 1 2 0 1 1 2 2 2 0 1 1 1 2 1h4s0-1 1-1l8-4 2-2s1-1 1-2 1-1 0-2v-4zm-13 11h-3l-1-1v-3h1v-1l8-5h3l1 1c0 1 1 1 1 2l-1 1v1h-1l-8 5zm25 11c-1-1-1-1-2-1h-1l-16 10c-1 1-1 1-1 2v1c0 1 1 1 1 1h2l16-10c0-1 1-1 1-2v-1zm13 20c-1-1-2-1-2-2h-6c-1 0-1 1-1 1l-8 5-1 1s0 1-1 1c0 1-1 1-1 2v4c1 1 1 1 1 2 1 1 2 1 2 2 1 0 2 1 3 1s2 0 2-1h1c1 0 1-1 1-1l8-5 2-2s1-1 1-2v-4c0-1-1-1-1-2zm-12 12-1 1c-1 0-1 0-2-1l-1-1v-2s0-1 1-1l8-6h1v-1h1s0 1 1 1l1 1v3l-1 1-8 5zm26 7-1-1c-1 0-1 0-2 1l-14 12c0 1-1 1-1 2 0 0 0 1 1 1 0 0 0 1 1 1s1 0 1-1l15-12v-2c1 0 0-1 0-1zm16 18-2-2h-3c-1 0-2 0-2 1h-1c0 1-1 1-1 1l-7 7s-1 0-1 1v1c-1 0-1 1-1 2v3l1 1s0 1 1 1l2 2h5l1-1c1 0 1-1 1-1l7-6c1-1 1-2 1-2 1-1 1-2 1-3v-2c0-1 0-1-1-2l-1-1zm-10 13v1h-2c-1 0-1 0-1-1-1 0-1 0-1-1v-2h1l7-7v-1h2s1 0 1 1c1 0 1 1 1 1v2l-1 1-7 6zm30 6c-1 0-2-1-3-1h-2c-1 0-2 1-2 1-1 0-1 0-1 1h-1l-6 8c-1 0-1 0-1 1v1c-1 0-1 1-1 2s0 2 1 3v1c1 0 1 1 2 1l2 2h3c1-1 2-1 2-1 1 0 1-1 1-1l1-1 6-7c0-1 1-1 1-2 1-1 1-2 1-2 0-1 0-2-1-3 0 0 0-1-1-1 0-1 0-1-1-2zm-8 15h-1v1h-2l-1-1-1-1v-2c1 0 1-1 1-1l6-7v-1h4c0 1 0 1 1 2v1l-1 1-6 8zm27 1c0-1-1-1-1-1-1 0-1 1-2 1l-11 16v2c1 1 1 1 2 1l1-1 12-15v-2c0-1 0-1-1-1zm20 14c-1-1-2-1-3-1h-2c-1 0-2 1-3 1v1c-1 0-1 0-1 1l-5 8c-1 0-1 0-1 1v1c-1 1-1 1-1 2 1 1 1 2 1 3 0 0 1 0 1 1l1 1c1 1 2 1 3 1h3c1 0 1-1 2-1 0-1 1-1 1-1s0-1 1-1l5-8c0-1 1-1 1-2v-2c0-1 0-2-1-3v-1c-1-1-1-1-2-1zm-7 15c0 1-1 1-1 1h-2l-1-1-1-1c0-1 0-1 1-1v-1l5-8 1-1h3l1 1v3l-6 8zM504 1029c-1-1-2-1-3-1h-1c-1 0-1 1-2 1 0 0-1 1-2 1v1l-1 1-4 8c-1 1-1 1-1 2v3c0 1 0 2 1 2 0 1 1 1 1 2h1c1 1 2 1 3 1h3l2-2 1-1 5-9c0-1 0-1 1-2v-2c-1-1-1-2-1-3-1 0-1-1-1-1-1 0-1-1-2-1zm-5 16h-1v1h-3l-1-1v-3l5-8v-1s1 0 1-1h1s1 0 1 1c1 0 1 0 1 1 1 0 1 0 1 1v1h-1l-4 9zm31-3c-1-1-2-1-3-1h-1c-1 0-1 1-1 1-1 0-2 1-2 1l-1 1s0 1-1 1l-4 9v4c0 1 0 2 1 3l1 1c1 0 1 0 2 1h5c1-1 2-1 2-2 0 0 1 0 1-1v-1l4-8c1-1 1-2 1-3v-2c0-1-1-2-1-2l-1-1c-1-1-1-1-2-1zm-4 16h-1v1h-3s-1 0-1-1v-3l4-8v-1h1v-1h3c0 1 0 1 1 1v3l-4 9zm26-7c-1-1-1-1-2 0 0 0-1 0-1 1l-6 18v1c0 1 1 1 1 1 1 1 1 0 2 0 0 0 1 0 1-1l6-18v-1c0-1-1-1-1-1zm19 6h-2l-1 1-5 18v2l1 1h2c0-1 1-1 1-2l5-18v-1c0-1-1-1-1-1zm23 6h-4c0 1-1 1-1 1l-2 2v1s0 1-1 1l-2 9v3s0 1 1 2c0 1 0 1 1 2 1 0 1 1 1 1h2c1 1 2 1 3 0 1 0 2 0 3-1 0 0 1-1 1-2 0 0 1 0 1-1v-1l2-9c0-1 1-2 1-2-1-1-1-2-1-3l-2-2-1-1h-2zm-1 16v2h-2c0 1 0 1-1 0h-1c-1 0-1-1-1-1v-2l2-9v-1h1v-1h4v1l1 1-1 1-2 9zm26-11c-1-1-1 0-2 0l-1 1-3 19v1c0 1 1 1 1 1h2c0-1 0-1 1-1l3-19v-2h-1zm24 3h-3c-1 0-1 0-1 1h-2c0 1-1 2-1 2v1c0 1 0 1-1 2l-1 9v2c0 1 1 2 1 3 0 0 1 1 2 1 0 1 1 1 1 1h2c1 1 2 0 3 0s2-1 2-1c1-1 1-2 2-2v-2l2-10v-2c-1-1-1-2-1-2-1-1-1-2-2-2 0-1-1-1-1-1h-2zm0 16v2h-1c-1 1-1 1-2 0h-1s-1 0-1-1v-2l1-9v-1h1v-1h4s0 1 1 1v2l-2 9zm23-15h-1c0 1-1 1-1 2v20c1 1 1 1 2 1 0 0 1 0 1-1l1-1v-20c-1-1-1-1-2-1zm25 0c-1 0-2 0-3 1h-1c0 1-1 1-1 1 0 1-1 2-1 3v13c0 1 1 2 1 2 1 1 1 2 2 2s1 0 2 1h1c2 0 3-1 4-1 0-1 1-1 2-2 0-1 0-1 1-2v-14l-2-2c0-1-1-1-2-2h-3zm3 16v1l-1 1c-1 1-1 1-2 1 0 0-1 0-1-1h-1v-13s0-1 1-1h3v1c1 0 1 0 1 1v10zm25-18c-1 0-2 0-3 1l-1 1v1c-1 0-1 1-1 2v1c-1 0-1 1-1 1l1 10c1 0 1 1 1 1v1c0 1 1 1 1 2 1 0 2 1 3 1h3c1 0 2 0 3-1 1 0 1-1 2-2 0 0 0-1 1-2v-2l-1-10s-1-1-1-2c0 0-1-1-1-2-1 0-2-1-2-1h-4zm5 15v2c-1 0-1 1-1 1h-2c0 1-1 1-1 0h-1v-1c-1 0-1-1-1-1l-1-9v-2h1v-1h4c0 1 1 1 1 1v1l1 9zm20-19c-1 0-1 0-1 1-1 0-1 1-1 1l3 19 1 1c0 1 1 1 1 1 1 0 1-1 2-1v-2l-3-18c0-1 0-1-1-2h-1zm24-5c-1 0-2 1-3 1 0 1 0 1-1 1v1c-1 1-1 2-1 3v2l2 9v1c0 1 0 1 1 1 0 1 1 2 1 2 1 1 2 1 3 1l1 1c1 0 1-1 2-1s2 0 3-1c0-1 1-1 1-2 1-1 1-2 1-2v-3l-2-9c0-1 0-1-1-2 0-1-1-1-1-2-1 0-2-1-3-1h-3zm6 15v2l-1 1h-1l-1 1-1-1c-1 0-1 0-1-1v-1l-2-9v-2h1c0-1 0-1 1-1h2l1 1v1l2 9zm22-23c-1 1-2 1-3 2l-1 1s0 1-1 1v5l3 9v1c1 0 1 0 1 1 0 0 1 1 2 1 0 1 1 1 2 1h3c2 0 2-1 3-2 1 0 1-1 2-2v-4l-3-9c0-1-1-2-1-2 0-1-1-2-2-2 0-1-1-1-2-1h-3zm7 15v1c0 1 0 1-1 2h-1s-1 1-1 0h-1c-1 0-1 0-1-1l-3-9v-3c1 0 1-1 2-1h2l1 1v1l3 9zm21-25c-2 1-2 1-3 2l-1 1v1c-1 1-1 2-1 3v1s0 1 1 1l3 9v1s1 0 1 1c0 0 1 1 2 1 0 1 1 1 2 1h3c1-1 2-1 3-2s1-2 1-2c1-1 1-2 1-3v-1c-1 0-1-1-1-1l-3-9c0-1-1-1-1-2 0 0-1-1-2-1 0-1-1-1-2-1h-3zm8 14v2l-1 1-1 1h-3v-1s0-1-1-1l-3-9v-1c0-1 0-1 1-1 0 0 0-1 1-1h2c1 0 1 1 1 1v1l4 8zm13-23-1 1s0 1 1 1l8 17c0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1-1v-1l-8-17c0-1 0-1-1-1h-2zm19-9c-1 0-1 0-1 1-1 0 0 1 0 1l9 17s0 1 1 1h1l1-1v-2l-9-17h-1c0-1-1-1-1 0zm21-13-2 2c0 1 0 1-1 2v4l1 1 5 9 1 1c1 1 1 1 2 1 1 1 2 1 3 1 0 0 1 0 1-1h2c1-1 2-2 2-3 1 0 1-1 1-2v-4c-1 0-1 0-1-1l-5-8s0-1-1-1l-2-2h-4c-1 1-1 1-2 1zm11 12v3c0 1-1 1-1 1-1 1-1 1-2 1h-1v-1c-1 0-1 0-1-1l-5-8v-2c0-1 1-1 1-1 1-1 1-1 2-1h1s0 1 1 1l5 8zm10-25-1 1s0 1 1 1l10 16 1 1c1 0 1 0 2-1l1-1s0-1-1-1l-10-16-1-1c-1 0-1 0-2 1zm20-15c-1 0-1 1-2 2v6c1 0 1 1 1 1l5 8h1c0 1 1 1 1 1 1 1 1 1 2 1h4c1-1 1-1 2-1 1-1 2-2 2-3s1-1 1-2 0-2-1-3v-1s-1 0-1-1l-5-7-2-2s-1 0-2-1h-3s-1 0-1 1c-1 0-1 0-2 1zm12 11 1 1c0 1 0 1-1 2l-1 1h-3v-1l-6-7v-1l-1-1 1-1s0-1 1-1c0-1 1-1 1-1h1s1 0 1 1h1l5 8zm7-27c-1 1-1 1-1 2 0 0 0 1 1 1l12 14s1 1 2 1l1-1s0-1 1-1c0-1-1-1-1-2l-12-14h-3zM963 951c-1 1-1 2-2 3v3s0 1 1 2v1s1 0 1 1l7 6v1c1 0 1 0 1 1h5c1 0 1-1 2-1 0 0 1 0 1-1 1-1 1-2 2-3v-2c0-1 0-2-1-3v-1h-1l-7-7c0-1-1-1-1-1-1-1-2-1-3-1h-2c-1 0-1 1-2 1 0 0 0 1-1 1zm13 9c0 1 1 1 1 1v2s0 1-1 1c0 1-1 1-1 1h-2s0-1-1-1l-6-6-1-1v-2s0-1 1-1c0-1 1-1 1-1h2l1 1 6 6zm8-31c-1 1-2 2-2 3v3c0 1 0 1 1 2v1l1 1 7 6s0 1 1 1h1c0 1 1 1 2 1s2 0 3-1h1c0-1 1-1 1-1 1-1 2-2 2-3v-3c0-1 0-2-1-2v-1c-1 0-1-1-1-1l-7-6c-1-1-1-1-2-1-1-1-1-1-2-1h-3c0 1-1 1-1 1l-1 1zm13 9s1 0 1 1v2l-1 1s0 1-1 1h-2v-1l-7-6-1-1v-3c1 0 1-1 2-1h2v1l7 6zm3-28c-1 0-1 1-1 2 0 0 0 1 1 1l14 12h2s1 0 1-1v-2l-15-12s0-1-1-1-1 1-1 1zm14-19c-1 1-1 2-1 3v3s1 1 1 2h1c0 1 0 1 1 1l7 5 1 1h1c1 0 2 1 3 0h2c1-1 1-1 2-1 0-1 0-1 1-2 0-1 1-2 1-3v-2c-1-1-1-2-1-2l-1-1-1-1-8-5s-1-1-2-1h-2c-1 0-2 0-3 1 0 0-1 0-1 1 0 0-1 0-1 1zm15 6v1c1 0 1 0 1 1v1s0 1-1 1c0 1 0 1-1 1 0 0 0 1-1 1l-1-1-8-5-1-1v-3c1 0 1-1 1-1h3l8 5zm1-31c0 1-1 2-1 3v1c0 1 0 1 1 2 0 0 0 1 1 2h1v1l8 5h1c1 0 1 1 2 1h2c1 0 2-1 2-1 1 0 1-1 2-1 0-1 0-1 1-2 0-1 1-2 1-3s0-1-1-2c0-1 0-2-1-2 0-1 0-1-1-1 0 0 0-1-1-1l-8-5h-2c0-1-1-1-2 0h-3c0 1 0 1-1 1 0 1 0 1-1 2zm15 6h1l1 1v1s0 1-1 1c0 1 0 1-1 2h-2v-1l-8-4-1-1c-1 0-1 0-1-1v-1s0-1 1-1c0-1 0-1 1-1 0 0 0-1 1-1l1 1 8 5zm0-32c0 1-1 2-1 3v1c0 1 1 1 1 2 0 0 0 1 1 2h1s0 1 1 1l8 4c0 1 1 1 1 1h3c1 0 2 0 3-1l1-1 1-1c1-2 1-3 1-4s0-1-1-2c0-1 0-2-1-2 0 0 0-1-1-1l-1-1-8-4s-1-1-2-1h-2c-1 0-2 1-3 1 0 1-1 1-1 1 0 1-1 1-1 2zm15 5h1c0 1 1 1 1 1v3c-1 0-1 1-1 1h-3l-8-5h-1l-1-1v-1s0-1 1-1c0-1 0-1 1-1 0-1 0-1 1-1h1v1l8 4zm-4-28v2l1 1 17 8h2l1-1v-1c0-1-1-1-1-2l-17-8h-2c0 1 0 1-1 1zm8-18v1l1 1 18 8h1c1-1 1-1 1-2v-1c0-1 0-1-1-1l-17-7c0-1-1-1-1 0-1 0-1 0-2 1zm9-24v5l1 1c0 1 1 1 1 2h1l1 1 9 3h2c1 1 2 0 3 0 0 0 1-1 2-1 0-1 1-1 1-1 0-1 0-1 1-2v-3c0-1 0-2-1-3 0 0-1-1-1-2h-1c-1 0-1 0-1-1l-9-3h-4c-1 0-2 1-3 2l-1 1s0 1-1 1zm16 3c1 0 1 0 1 1h1v3s0 1-1 1h-1c0 1 0 1-1 1v-1l-9-3h-1c0-1-1-1-1-1v-2c0-1 1-1 1-2h3l8 3zm-8-26v2l1 1 18 4c1 1 1 1 2 0 0 0 1 0 1-1 0 0 0-1-1-1 0-1 0-1-1-1l-18-5h-1l-1 1zm6-24v3c0 1 0 1 1 2v1c1 0 1 1 2 1l1 1h1l9 2h3s1 0 2-1c1 0 1-1 2-1 0-1 0-1 1-2v-1c1-1 1-3 0-3 0-1 0-2-1-3 0 0-1-1-2-1 0-1 0-1-1-1h-1l-9-2h-2c-1 0-2 0-2 1-1 0-2 0-3 1v2c-1 0-1 1-1 1zm16 1h2c0 1 0 1 1 1 0 1 0 1-1 2v1c0 1-1 1-1 1h-2l-9-2h-1l-1-1v-2c0-1 0-1 1-1 0-1 0-1 1-1h1l9 2zm-11-25s0 1 1 1c0 1 0 1 1 1l18 3c1 0 1 0 2-1l1-1s0-1-1-1c0-1 0-1-1-1l-19-3h-1c0 1-1 1-1 2zm4-25v3l1 1c0 1 0 1 1 1 0 1 1 1 2 2h2l9 1h2c1 0 2 0 2-1 1 0 2-1 2-2 1 0 1 0 1-1v-2c1-1 1-2 0-3 0-1-1-1-1-2-1-1-1-1-2-1 0-1-1-1-1-1h-1l-10-1h-2c-1 0-1 0-2 1-1 0-1 1-2 2 0 0 0 1-1 1v2zm16-1h2v1c1 1 1 1 1 2l-1 1c0 1 0 1-1 1h-2l-9-1h-1l-1-1v-3c1 0 1-1 1-1h2l9 1zm-13-28c-1 2 0 3 0 4 0 0 1 0 1 1l1 1s1 1 2 1h14s1-1 2-1c0-1 1-1 1-2 1-1 1-1 1-2v-4c-1-1-1-2-2-3 0 0-1 0-2-1h-14s-1 1-2 1l-2 2v3zm16-2h1c1 0 1 1 1 1v3s0 1-1 1h-13v-1s-1-1-1-2l1-1s0-1 1-1h11zm-16-23c0 1 0 1 1 2h20s1 0 1-1c1 0 1-1 1-1 0-1 0-1-1-2h-20l-1 1c-1 0-1 1-1 1zm-1-24c1 1 1 2 1 3 1 0 1 0 1 1 0 0 1 0 1 1 1 0 2 0 2 1h3l9-1h1s1 0 1-1c1 0 2 0 2-1 1 0 1-1 2-2v-3c0-2 0-3-1-3 0-1-1-2-1-2-1-1-2-1-3-1h-11c-1 0-2 1-2 1-1 0-2 1-2 1-1 1-2 1-2 2v2c-1 0-1 1-1 2zm16-4h2s1 0 1 1v3h-1c0 1 0 1-1 1l-10 1h-1v-1h-1c0-1 0-1-1-2 0 0 0-1 1-1v-1c1 0 1-1 1-1h10zm-18-25c0 1 1 2 1 3l1 1 1 1c1 0 2 0 2 1h3l9-2h1l1-1c1 0 1-1 2-1 1-1 1-2 1-3l1-1v-2c-1-1-1-2-2-3 0-1-1-1-1-2h-5l-9 1c-1 1-2 1-2 1-1 0-2 1-2 2-1 0-1 1-2 2v3zm16-5h2c0 1 1 1 1 2v1l-1 1c0 1 0 1-1 1h-1l-9 2h-2v-1c-1 0-1-1-1-2v-1s0-1 1-1h1v-1l10-1zm-21-24c1 1 1 2 2 3 0 0 0 1 1 1l1 1h4l9-2h1c1 0 1-1 1-1 1 0 2-1 2-1 1-1 1-2 2-3v-3c-1-1-1-2-2-3 0-1-1-1-2-2h-4l-9 2c-1 0-2 0-3 1l-1 1c-1 1-1 2-2 3v3zm16-6h1s1 0 1 1c0 0 1 0 1 1v1c0 1-1 1-1 1 0 1 0 1-1 1l-10 2h-2c0-1-1-1-1-2v-1c0-1 0-1 1-1 0-1 0-1 1-1l10-2zM1086 519s0 1 1 1h1l18-5c1 0 1 0 2-1v-1c0-1-1-1-1-1 0-1-1-1-2-1l-18 5c0 1-1 1-1 1v2zm-6-19c1 0 1 0 1 1h2l18-6 1-1v-2l-1-1h-1l-18 6c-1 0-1 1-1 1-1 1-1 1-1 2zm-8-24c1 1 1 2 2 3 0 0 1 0 1 1h1c1 0 2 1 3 1 0 0 0-1 1-1h1l9-3 1-1h1c0-1 1-2 1-2 1-1 1-2 1-3v-3c-1-1-1-2-2-3-1 0-1-1-2-1h-5l-9 4s-1 0-2 1c0 0-1 1-1 2-1 0-1 1-1 2v3zm15-8h2c1 0 1 1 1 1v3s-1 0-1 1h-1l-8 3-1 1h-1c-1 0-1-1-1-1l-1-1v-3h1l1-1 9-3zm-24-13c1 0 1 0 1 1 1 0 1 0 2-1l17-8 1-1v-2l-1-1h-2l-17 9s0 1-1 1v2zm-11-22c1 1 2 1 3 2l1 1h3c1 0 1 0 1-1h1l9-5h1s0-1 1-1c0-1 1-1 1-2v-4c0-1 0-1-1-2 0-1-1-2-2-2 0-1-1-1-2-1h-4s0 1-1 1l-8 4c0 1-1 1-2 2 0 0-1 1-1 2v6zm13-11h3l1 1v3l-1 1-8 5h-3l-1-1v-4h1l8-5zm-25-11 1 1h2l16-10c0-1 1-1 1-2v-1c-1-1-1-1-2-1h-1l-16 11s-1 0-1 1v1zm-13-20c0 1 1 2 2 2h1c1 1 1 1 2 1 0 0 1 0 2-1h1s1 0 1-1l8-5 1-1v-1c1 0 1-1 2-2v-3s0-1-1-1v-2c-1-1-2-1-3-2h-6c0 1 0 1-1 1l-7 5c-1 1-2 1-2 2-1 1-1 1-1 2s-1 2 0 3v1c0 1 0 1 1 2zm12-12h1c0-1 1 0 1 0 1 0 1 0 1 1 1 0 1 1 1 1v1c0 1-1 1-1 1v1l-8 5-1 1h-2c0-1-1-1-1-1 0-1 0-1-1-2 0 0 0-1 1-1v-1h1l8-6zm-29-10 2 2h3c1 0 2 0 2-1h1c1 0 1-1 1-1l7-6c1 0 1-1 1-1s1 0 1-1 1-1 1-2v-3c-1 0-1-1-1-1 0-1-1-1-1-2-1-1-2-1-2-1-1-1-2-1-3-1s-2 0-2 1h-1c-1 0-1 1-1 1l-7 6-2 2c0 1-1 1-1 2v3l1 1c0 1 0 1 1 2zm10-13s1 0 1-1h2l1 1 1 1v1c0 1 0 1-1 1v1l-7 6-1 1h-2s-1 0-1-1c-1 0-1-1-1-1v-1c0-1 0-1 1-1v-1l7-6zm-26-6c0 1 0 1 1 1 0 0 1 0 1-1l14-13 1-1c0-1-1-1-1-2h-3l-13 14c-1 0-1 0-1 1s0 1 1 1zm-18-17c1 1 2 2 3 2h3s1 0 2-1h1c0-1 0-1 1-1l6-7c0-1 1-1 1-1v-1c1-1 1-2 1-2v-3c-1 0-1-1-1-1 0-1-1-1-1-2-1-1-2-1-3-1-1-1-2-1-2 0h-3c0 1 0 1-1 1 0 0 0 1-1 1l-6 7c-1 0-1 1-1 2-1 0-1 1-1 2v3c1 0 1 1 1 1l1 1zm9-14h2c0-1 0-1 1-1 0 1 1 1 1 1l1 1v3h-1l-6 7-1 1h-2s-1 0-1-1c-1 0-1 0-1-1v-2l1-1 6-7zm-31-5c1 1 2 2 3 2h3c1 0 1-1 2-1l1-1 1-1 6-7v-1c1 0 1-1 1-1v-5l-1-1c0-1-1-1-1-1-1-1-2-2-3-2h-2c-1 0-2 1-3 1l-1 1v1l-6 7c-1 0-1 1-2 2v5l1 1c0 1 1 1 1 1zm9-14c0-1 1-1 1-1h1c1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1v1l-6 8h-1v1h-2s-1 0-1-1c-1 0-1-1-1-1v-3l7-7zm-31-2c1 1 2 1 3 1h2c1-1 2-1 2-1l1-1 1-1 5-8c1 0 1-1 1-1v-1c0-1 1-2 1-2-1-1-1-2-1-3-1 0-1-1-1-1l-1-1c-1-1-2-1-3-1h-3c-1 0-2 1-2 1l-1 1s-1 0-1 1l-5 8s-1 1-1 2v2c0 1 0 2 1 3v1c1 0 1 1 2 1zm7-15v-1h3c1 0 1 1 1 1 1 0 1 1 1 1s0 1-1 1v1l-5 8h-1v1h-3l-1-1v-3l6-8zm-28 2h2s1 0 1-1l10-16v-2l-1-1h-2l-1 1-9 16c-1 1-1 1-1 2l1 1zm-17-10h1c1 0 1 0 2-1l8-17c1 0 1 0 1-1l-1-1h-2s-1 0-1 1l-9 17v1c0 1 0 1 1 1zm-22-11c1 1 2 1 3 1h1c1 0 1 0 2-1 0 0 1-1 2-1v-1l1-1 4-9v-2c1-1 1-1 0-2 0-1 0-2-1-3l-1-1h-1c-1-1-3-1-3-1-1 0-2 0-3 1-1 0-1 0-2 1 0 0 0 1-1 1v1l-4 9s-1 1-1 2v2c0 1 1 2 1 3 1 0 1 0 2 1h1zm4-15 1-1v-1h3c1 0 1 1 1 1l1 1v1c-1 0-1 1-1 1l-4 8v2h-3c-1 0-1-1-1-1-1 0-1-1-1-1v-2l4-8zm-27 6h2l1-1 7-18v-1c0-1 0-1-1-1h-1c-1 0-1 0-2 1l-7 18v1l1 1zm-23-8c1 0 3 1 3 0h2s1 0 1-1c1 0 1-1 2-1v-1c0-1 1-1 1-1l3-9v-5c0-1-1-1-1-2-1 0-1-1-2-1l-1-1h-3c-1 0-2 0-3 1-1 0-1 1-2 2v1s-1 0-1 1l-3 9v4c0 1 1 2 2 2 0 1 0 1 1 1 0 1 1 1 1 1zm3-16v-1s1 0 1-1h3s1 0 1 1v2l-3 9v2h-3c-1 0-1 0-2-1v-2l3-9zm-26 9h1c1 0 1-1 1-1l5-18c1-1 1-1 0-2 0 0 0-1-1-1h-1c-1 1-1 1-1 2l-6 18s0 1 1 1c0 1 0 1 1 1zm-23-5c1 1 2 1 3 0h1l1-1 2-2v-1l1-1 1-10s1 0 1-1c0 0-1 0-1-1v-2l-2-2-1-1h-5c-1 0-2 1-2 1-1 1-2 1-2 2v1l-1 1-1 10c-1 0-1 1-1 2 1 1 1 1 1 2 1 1 1 2 2 2l1 1h2zm0-16v-1s1 0 1-1h4v1l1 1-1 1-1 9v1h-1v1h-1s-1 1-1 0h-2v-1c-1 0-1-1-1-1v-1l2-9zm-29 12h3c1 0 1-1 1-1 1 0 1 0 1-1 1 0 1-1 2-2v-2l2-9v-2c0-1-1-2-1-3-1 0-1-1-2-2h-1c-1 0-1-1-2-1s-2 0-3 1c-1 0-2 0-2 1-1 1-2 1-2 2v2l-2 10v2c0 1 1 1 1 2 1 1 1 2 2 2l1 1h2zm-1-16c0-1 1-1 1-1v-1s1 0 1-1h1c1 0 2 0 2 1l1 1v1l-2 10v1c0 1-1 1-1 1h-3c0-1-1-1-1-1v-2l1-9zm-24 14c1 0 1 0 2-1l1-1 1-19v-1c-1-1-1-1-2-1 0 0-1 0-1 1 0 0-1 0-1 1l-1 19v1c0 1 1 1 1 1zM702 228h3c0-1 1-1 1-1l1-1c1-1 1-1 1-2v-1l1-1v-12c0-1-1-2-1-2-1-1-2-1-2-2h-2c0-1-1-1-1-1-2 0-3 1-4 1l-2 2s-1 1-1 2v2l-1 9c0 1 0 2 1 3 0 0 0 1 1 2l2 2h3zm-2-16v-2h1c0-1 1-1 1-1 1 0 2 0 2 1h1v13h-1c0 1 0 1-1 1h-3v-1c-1 0-1 0-1-1v-1l1-9zm-27 17c2 0 3 0 4-1l1-1v-1c1 0 1-1 1-2 1 0 1-1 1-1v-1l-1-10v-2l-2-2s-1-1-2-1l-1-1h-2c-1 0-2 1-3 1l-2 2c0 1-1 2-1 2v12c0 1 1 1 1 2s1 2 1 2l2 2h3zm-3-16v-1c0-1 0-1 1-1 0-1 1-1 1-1h2c0 1 0 1 1 1v2l1 9v1c0 1 0 1-1 1v1h-3c-1 0-1 0-1-1v-1h-1v-10zm-26 19c1 0 2 0 3-1 1 0 1-1 1-1 1 0 1-1 1-1 0-1 1-1 1-2v-2l-1-10v-1s0-1-1-1c0-1 0-1-1-2s-1-1-2-1-1-1-2-1h-1c-2 1-3 1-3 1l-2 2c-1 1-1 2-1 3v2l1 9v2c1 1 1 2 2 2 0 1 1 2 2 2h3zm-4-16v-1c0-1 0-1 1-1l1-1h2c0 1 0 1 1 1v2l1 9v2s-1 0-1 1h-3l-1-1v-1l-1-10zm-20 20s1 0 1-1v-1l-3-19v-1c-1 0-1-1-2 0h-1c0 1-1 1 0 2l2 18c1 1 1 1 1 2h2zm-20 4s1 0 1-1c1 0 1-1 1-1l-4-19s-1 0-1-1h-2s-1 0-1 1v1l4 19s0 1 1 1h1zm-24 7c1-1 2-1 3-2 0 0 0-1 1-1v-1c1-1 1-2 1-2v-3l-3-9v-1l-1-1c0-1 0-1-1-2-1 0-2 0-3-1h-1c-1 0-1 0-2 1-1 0-2 0-3 1 0 1-1 1-1 2s-1 2-1 3v1s0 1 1 1l2 9c0 1 0 1 1 2 0 1 1 1 1 2 1 0 2 1 3 1h3zm-7-15v-2l1-1s1 0 1-1h2l1 1v1h1l2 9v2c0 1 0 1-1 1 0 0 0 1-1 1h-2l-1-1v-1l-3-9zm-17 22c1 0 1 0 1-1 1 0 1-1 1-1l-6-18c0-1 0-1-1-1 0-1-1-1-1 0-1 0-1 0-2 1v1l6 18s0 1 1 1h1zm-22 9c1-1 2-1 3-2v-1c0-1 1-1 1-2v-4l-4-9s0-1-1-1v-1c-1 0-1-1-2-1-1-1-2-1-3-1h-1c-1 0-1 1-2 1s-2 1-2 2c-1 0-1 1-2 2v4s1 0 1 1l3 8c1 1 1 2 1 2l2 2h6zm-9-14v-3c1 0 1 0 2-1h2c0 1 1 1 1 1v1l4 8v3c-1 0-1 1-2 1h-2s-1 0-1-1l-4-9zm-14 24c1 0 1-1 1-1v-2l-8-17s-1 0-1-1h-2c0 1 0 1-1 2v1l9 17s0 1 1 1h1zm-22 11c1 0 2-1 2-2 1 0 1-1 1-1v-6l-5-8v-1c-1 0-1-1-1-1-1 0-1-1-2-1s-2-1-3-1l-1 1h-2c-1 1-2 2-2 3-1 0-1 1-1 2v4l5 9s1 1 1 2c1 0 1 0 2 1h4c1 0 1 0 2-1zm-10-12v-1s-1-1 0-1v-1c0-1 1-1 1-1l1-1c1 0 1 0 2 1 0 1 1 1 1 1l4 8v1h1v1l-1 1-1 1h-2c-1 0-1 0-1-1h-1l-4-8zm-16 27c1 0 2-1 3-2v-2c1-1 0-2 0-3v-2l-5-8c-1 0-1-1-1-1l-1-1s-1-1-2-1h-4l-1 1c-1 1-2 1-3 2 0 1-1 2-1 3v2c1 0 1 1 1 1v1l5 8c0 1 1 1 1 2 1 0 2 1 3 1 0 0 1 1 2 0h2s1 0 1-1zm-10-12s-1 0-1-1 0-1 1-2l1-1h2s1 0 1 1l5 8v1h1v1s0 1-1 1c0 0 0 1-1 1h-1c-1 1-1 1-1 0h-1l-1-1-4-8zm-11 26c1 0 1-1 1-1v-2l-10-15c-1 0-1-1-2-1h-1c-1 1-1 1-1 2v1l11 16 1 1s1 0 1-1zm-20 15c1-1 2-1 2-2s1-1 1-2v-3l-1-1v-1l-6-8s0-1-1-1h-1c0-1-1-1-2-1 0-1-1-1-2 0h-2l-1 1-2 2c-1 1-1 2-1 3v2c0 1 1 1 1 1v1l6 8 1 1c1 1 2 1 3 1 0 1 1 1 2 0h2l1-1zm-11-11c-1 0-1-1-1-1v-2l1-1c1 0 1 0 1-1 1 0 1 0 2 1 1 0 1 1 1 1l5 7 1 1v2l-1 1c-1 0-1 1-1 1h-2v-1l-1-1-5-7zm-11 29c1 0 2-1 2-2v-5c0-1-1-1-1-1v-1l-7-7s0-1-1-1c-1-1-2-1-3-1h-2c-1 0-1 0-2 1 0 0-1 0-1 1-1 1-2 1-2 2v5c0 1 1 1 1 1v1l7 7c0 1 1 1 1 1 1 1 2 1 3 1h2c1 0 1 0 2-1 0 0 1 0 1-1zm-13-10v-1c-1 0 0-1 0-1 0-1 0-1 1-1 0-1 0-1 1-1h2v1l7 7v2c0 1 0 1-1 2h-3v-1l-7-7zm-9 31c1-1 2-2 2-3v-5s-1 0-1-1l-1-1-6-6-1-1s-1 0-1-1h-5l-1 1c-1 0-1 0-2 1 0 1-1 2-1 3-1 1-1 1-1 2s1 2 1 3l1 1 7 7c0 1 1 1 2 1 0 1 1 1 2 1h3l1-1 1-1zm-13-9v-1c-1 0-1 0-1-1v-1l1-1 1-1h2c1 0 1 1 1 1l7 6v2c1 0 1 0 0 1v1c-1 1-1 1-2 1h-2v-1l-7-6zm-4 27 1-1c0-1-1-1-1-2l-14-12c0-1-1-1-1-1-1 0-1 0-2 1v3l14 12c1 1 1 1 2 1l1-1zm-13 15v-1c0-1 0-1-1-1l-14-12c0-1-1-1-1-1-1 0-1 1-2 1v3l15 12h1c1 0 1 0 2-1zm-16 20c1-1 1-2 1-3v-3s0-1-1-2l-1-1-8-6s-1 0-1-1h-6c0 1-1 1-1 1 0 1-1 1-1 2-1 1-1 2-2 3 0 0 0 1 1 2 0 1 0 2 1 2v1c1 0 1 1 1 1l8 5c0 1 1 1 2 1 0 1 1 1 2 1s2 0 3-1l1-1 1-1zm-14-7c-1 0-1-1-1-1l-1-1v-1l1-1c0-1 1-1 1-1h3l7 6h1v1c0 1 1 1 0 1v2c-1 0-1 0-1 1h-2l-1-1-7-5zm-1 27c1 0 1-1 1-1l-1-1-16-11h-1c-1 0-1 0-1 1-1 0-1 1-1 1 0 1 1 1 1 2l16 10h1c1 0 1 0 1-1zM300 461c0-1 1-2 1-3v-1c-1 0-1-1-1-1 0-1 0-2-1-2 0-1 0-1-1-1 0 0 0-1-1-1l-8-5h-2c0-1-1-1-2 0h-3c0 1 0 1-1 1 0 1 0 1-1 2 0 1-1 2-1 3v2c1 1 1 2 2 3h1v1l8 5c1 0 2 0 2 1h3c1 0 1-1 2-1s1-1 1-1l2-2zm-16-5v-1s-1 0-1-1v-1s0-1 1-1c0-1 0-1 1-1 0 0 0-1 1-1h1v1l8 5h1c0 1 0 1 1 1v1s0 1-1 1c0 1 0 1-1 1 0 1-1 1-1 1h-1l-1-1-8-4zm3 27v-1c0-1 0-1-1-2l-16-8c-1-1-1-1-2-1 0 1-1 1-1 1v2s0 1 1 1l16 9h2s1 0 1-1zm-12 22c1-1 1-2 1-3v-1c0-1-1-1-1-1 0-1-1-2-1-2 0-1-1-1-1-1s-1 0-1-1l-8-4h-5c-1 0-2 0-2 1-1 0-1 1-1 1-1 1-1 1-1 2-1 1-1 2-1 3s0 2 1 2c0 1 0 2 1 2 0 1 0 1 1 1l1 1 8 4h5s1-1 2-1l1-1c1-1 1-1 1-2zm-16-4c0-1-1-1-1-1v-3c1 0 1-1 1-1h3l8 4h1v1h1v3c-1 0-1 1-1 1h-3l-9-4zm4 31v-4c0-1 0-1-1-1 0-1 0-2-1-2l-1-1h-1l-8-4h-3c0-1-1 0-2 0s-2 0-2 1c-1 0-1 1-1 1-1 1-1 1-1 2-1 1-1 2-1 3s0 2 1 2c0 1 1 2 1 2l1 1h1l9 4s1 1 2 1 1 0 2-1c1 0 2 0 3-1 0 0 0-1 1-1 0-1 0-1 1-2zm-16-3c-1 0-1 0-1-1h-1v-3c1 0 1-1 1-1s1 0 1-1h1l1 1 9 3v1h1v3l-1 1-1 1h-1l-1-1-8-3zm6 27v-2s0-1-1-1l-17-6h-2l-1 1v2s1 0 1 1l18 6h1c1 0 1-1 1-1zm-8 23v-4c0-1 0-1-1-1 0-1-1-2-1-2h-1l-1-1-9-3h-5l-2 2-1 1c0 1 0 1-1 2v3c0 1 1 2 1 2 0 1 1 2 2 2 0 0 0 1 1 1h1l9 3h4c1-1 2-1 2-2 1 0 1-1 1-1 1 0 1-1 1-2zm-16-2h-2v-3c0-1 1-1 1-1 0-1 0-1 1-1h2l8 3h2v3c0 1 0 1-1 2h-2l-9-3zm8 31v-3c0-1 0-1-1-1v-2c-1 0-1-1-2-1l-1-1h-1l-9-2-1-1h-1c-1 0-2 1-3 1l-2 2-1 1v1c-1 2-1 3 0 4 0 1 0 1 1 2 0 1 1 1 1 2h1c1 0 1 0 1 1l9 2h5l2-2 1-1c0-1 0-1 1-2zm-17-1v-1h-1s0-1-1-1c0-1 0-1 1-2v-1s1 0 1-1h2l9 3h1v1c1 0 1 0 1 1v1c0 1-1 1-1 1 0 1 0 1-1 1h-1l-10-2zm10 29v-3c0-1 0-1-1-1v-1l-2-2h-1l-1-1-10-1h-2c-1 0-1 0-2 1-1 0-1 1-2 1 0 1-1 1-1 2v5c0 1 1 1 1 2 1 1 1 1 2 1 0 1 1 1 1 1h1l9 2h3s1-1 2-1l2-2s0-1 1-1v-2zm-16 0h-2v-4c0-1 1-1 1-1h2l9 1h1v1h1v4c-1 0-1 0-1 1h-2l-9-2zm12 25c0-1 0-1-1-2l-1-1-18-2c-1 0-1 1-2 1l-1 1c0 1 0 1 1 2h1l19 2h1l1-1zm-3 21v-2h-2l-18-2h-2v1c-1 1 0 1 0 2l1 1 19 2s1 0 1-1c1 0 1-1 1-1zm-2 24c0-2 0-3-1-3v-2c-1 0-1 0-1-1-1 0-2 0-2-1h-14c-1 0-2 1-2 1l-2 2v2c-1 0-1 1-1 1 0 2 0 3 1 4 0 0 1 1 1 2 1 0 2 1 3 1h13c1 0 2-1 2-1 1-1 2-1 2-2s1-1 1-2v-1zm-16 2h-2s0-1-1-1v-2s0-1 1-1v-1h13c0 1 1 1 1 1v3c-1 0-1 1-1 1h-11zm15 23v-2h-21l-1 1-1 1c0 1 1 1 1 2h20c1 0 1-1 2-1v-1zm1 25c-1-2-1-3-1-4-1 0-1 0-1-1h-1c-1-1-2-1-2-1-1 0-1-1-1-1h-1l-10 1h-1s-1 0-1 1c-1 0-2 0-2 1l-2 2v3c0 2 0 3 1 3 0 1 1 2 1 2 1 1 2 1 3 1h1c0 1 1 1 1 1l9-1c1 0 2 0 2-1 1 0 2 0 2-1 1-1 2-1 2-2v-2c1 0 1-1 1-1zm-16 4h-1l-1-1s-1 0-1-1v-2c0-1 0-1 1-1 0 0 0-1 1-1l10-1h1v1h1c0 1 1 1 1 2 0 0 0 1-1 1v1c-1 0-1 1-1 1h-1l-9 1zm17 20s0-1-1-1h-1l-19 2s-1 0-1 1v3h2l18-2c1 0 1-1 2-1v-2zm3 25c0-1-1-2-1-3l-1-1s-1 0-1-1h-5l-9 1s-1 0-1 1h-1c-1 0-1 1-2 1 0 1-1 2-1 3v1c-1 1-1 1 0 2 0 1 0 2 1 3 0 1 1 1 2 2 0 0 1 0 2 1h1s1 0 1-1l9-1c1 0 2-1 3-1l1-1c1-1 2-2 2-3v-3zm-15 6h-1s-1 0-1-1h-1c0-1 0-1-1-2 0 0 0-1 1-1v-1s1 0 1-1h1l9-1 1-1 1 1h1v3c0 1 0 1-1 1v1h-1l-9 2zm20 23c0-1-1-2-1-3 0 0-1 0-1-1h-1c-1-1-2-1-3-1h-2l-9 2h-1c0 1-1 1-1 1-1 0-1 1-2 2 0 0-1 1-1 2v3c0 1 1 2 1 3l2 2h5l9-2c1 0 1 0 2-1 1 0 1-1 2-1 0-1 1-2 1-3v-3zm-15 6h-3v-4l1-1h1l9-2h2l1 1v3l-1 1h-1l-9 2zm21 18-1-1h-2l-18 5s-1 0-1 1v1c0 1 0 1 1 2h1l18-5c1 0 1-1 1-1 1-1 1-1 1-2zm7 24c-1-1-1-2-2-3 0 0-1 0-1-1h-1c-1 0-2-1-3-1h-1c0 1 0 1-1 1l-9 3h-1l-1 1-1 1c-1 1-1 2-1 3v3c0 1 1 2 1 3 1 1 2 1 3 1 0 1 1 1 2 1h1c1 0 1 0 1-1l9-3c1 0 2 0 2-1 1 0 1-1 2-1 0-1 1-2 1-3v-3zm-15 8h-2l-1-1v-1c-1-1-1-1-1-2 1 0 1 0 1-1h1l9-3 1-1h1c1 0 1 1 1 1l1 1v3h-1l-1 1-9 3zM252 909c-1-1-1-2-2-3 0 0-1 0-1-1h-6l-8 4c-1 0-1 0-2 1s-2 1-2 2-1 2-1 3v1c1 1 1 1 1 2s1 2 2 3c1 0 1 1 2 1h4s0-1 1-1l8-4c1 0 2 0 2-1 1 0 1-1 2-2v-2c1-1 1-1 0-2v-1zm-14 9h-3v-2c-1 0-1-1-1-1s0-1 1-1v-1h1l9-4c1 0 1 0 1-1v1h1c1 0 1 1 1 1 1 1 1 1 1 2l-1 1h-1v1l-9 4zm26 17c-1-1-2-1-2-2-1 0-1 0-2-1h-4c-1 0-1 0-1 1l-9 4h-1c0 1 0 1-1 1 0 1-1 1-1 2s-1 2-1 3v1c1 1 1 1 1 2 1 1 1 2 2 2 1 1 2 1 2 1 1 1 2 1 3 0h2l8-5c1 0 2 0 2-1 1 0 1-1 2-2v-6zm-14 10-1 1c-1 0-1-1-2-1v-1c-1 0-1-1-1-1 0-1 0-1 1-1v-1c1 0 1-1 1-1l8-4h3l1 1v3l-1 1-9 4zm25 12h-2c0-1-1-1-1 0l-17 9s0 1-1 1c0 1 0 1 1 2 0 0 0 1 1 1h1l17-10 1-1v-2zm9 18c0-1 0-1-1-1h-1l-16 10c-1 1-1 1-1 2v1c0 1 1 1 1 1h2l16-11 1-1s0-1-1-1zm14 20c-1-1-2-1-3-2h-6s0 1-1 1l-7 5-1 1c-1 0-1 1-1 1-1 1-1 1-1 2s-1 2 0 3v1c0 1 0 1 1 2s1 2 2 2 2 1 3 1c0 0 1 0 2-1h1l1-1 8-5c0-1 1-1 1-2 1 0 1-1 2-2v-3s0-1-1-1v-2zm-12 12h-1c0 1 0 1-1 1l-1-1s-1 0-1-1c0 0-1 0-1-1 0 0 0-1 1-1v-1h1l8-6 1-1c1 0 1 1 1 1s1 0 1 1c1 0 1 1 1 1v1c0 1-1 1-1 1v1l-8 5zm26 8s-1 0-1-1c-1 0-1 1-2 1l-15 12s0 1-1 1c0 1 0 1 1 2h3l14-12c1 0 1-1 1-1v-2zm15 19-2-2h-5l-1 1s-1 0-1 1l-7 6c-1 0-1 1-1 1l-1 1s0 1-1 2v3c1 0 1 1 1 1 0 1 1 1 1 1 1 1 2 2 3 2 0 1 1 1 2 1s2 0 2-1h1l1-1 8-6c0-1 1-1 1-2s1-1 1-2v-3s0-1-1-1c0-1 0-1-1-2zm-10 13h-1c0 1 0 1-1 1h-1l-1-1c0-1-1-1-1-1v-2l1-1 7-6 1-1h2s1 0 1 1c1 0 1 1 1 1v1c0 1 0 1-1 1v1l-7 6zm27 5h-3l-14 14v2c1 1 1 1 2 1 0 0 1 0 1-1l14-13v-3zm17 17c-1-1-2-1-3-1 0 0 0-1-1-1 0 0-1 0-1 1h-2l-1 1c-1 0-1 0-1 1l-7 7v1c-1 0-1 0-1 1 0 0-1 1-1 2s0 2 1 3v1c1 0 1 1 2 1 0 1 1 2 2 2h3c1 0 1 0 2-1 1 0 1 0 1-1h1l6-7 2-2v-5c0-1 0-1-1-1 0-1 0-1-1-2zm-9 14v1h-2c-1 0-1 0-2-1 0 0 0-1-1-1v-1s0-1 1-1v-1l7-7h1v-1h1c1 0 1 1 2 1v1c0 1 1 1 0 2v1l-7 7zm31 5c-1-1-2-1-3-1h-2c-1 0-2 0-3 1l-1 1-6 8c-1 0-1 0-1 1v1c-1 0-1 1-1 2s0 2 1 3v1c1 0 1 1 1 1 1 1 2 1 3 1 1 1 2 1 3 0h2c0-1 1-1 1-1l1-1 6-7c0-1 1-2 1-2 0-1 1-2 1-3 0 0-1-1-1-2s0-1-1-2l-1-1zm-8 15h-1v1h-2l-1-1-1-1v-2c0-1 1-1 1-1l6-7v-1h4v1c1 1 1 1 1 2h-1v1l-6 8zm28 0h-3l-12 16v1c0 1 0 1 1 1 0 1 1 1 1 1 1 0 1-1 2-1l11-15v-3zm20 14c-1-1-2-1-3-2h-1c-1 0-1 1-2 1s-1 0-2 1l-1 1v1l-6 8v1s-1 0-1 1v2c0 1 0 2 1 3l1 1s1 0 1 1c1 0 2 1 3 1h3c0-1 1-1 2-2h1v-1l6-8c0-1 0-1 1-2v-3s0-1-1-2c0-1 0-1-1-1 0-1-1-1-1-1zm-7 15c-1 0-1 1-1 1h-1c-1 0-1 0-2-1 0 0-1 0-1-1v-2h1l5-8v-1h1c0-1 1-1 1-1 1 0 1 1 2 1 0 0 0 1 1 1v2l-1 1-5 8zm31-1c-1-1-2-1-3-1h-2s-1 0-1 1c-1 0-1 0-2 1 0 0 0 1-1 1v1l-5 8v2c-1 1-1 2 0 3 0 1 0 1 1 2 0 1 0 1 1 1 0 1 0 1 1 1 1 1 2 1 3 1h3c0-1 1-1 2-2v-1c1 0 1 0 1-1l4-8c1-1 1-2 1-2v-3c0-1 0-1-1-2 0-1 0-1-1-1 0-1-1-1-1-1zm-5 16h-1s0 1-1 1h-2l-1-1-1-1v-1l1-1 4-8 1-1v-1h3c0 1 1 1 1 1v3l-4 9zm31-3c-1-1-2-1-3-1s-1 0-2 1h-1c-1 0-1 1-2 2h-1v1l-4 9c0 1-1 1-1 1v4c1 0 1 1 1 2 1 0 1 1 2 1 0 0 0 1 1 1s2 1 3 1c1-1 2-1 3-1 0-1 1-1 2-2v-1c1 0 1 0 1-1l4-8c0-1 0-2 1-2 0-1 0-2-1-3 0-1 0-1-1-2 0-1 0-1-1-1 0-1-1-1-1-1zm-5 16v1h-1s0 1-1 1c0 0-1 0-1-1-1 0-1 0-1-1-1 0-1 0-1-1v-1l4-9 1-1 1-1c1 0 1 0 2 1h1c0 1 1 1 1 1v1l-1 1-4 9zm27-6h-1c-1 0-1 0-2 1l-7 18v1l1 1h2s1 0 1-1l7-18v-1c0-1 0-1-1-1zm19 7h-2l-1 1-6 18v2l1 1h2c0-1 0-1 1-2l6-18v-1l-1-1zm23 7h-3c-1 0-1 1-2 1h-1c0 1-1 2-1 2l-1 1v1l-3 9v5c0 1 1 1 2 2 0 0 0 1 1 1 0 0 1 0 1 1h4c1 0 1-1 2-1l2-2v-1c0-1 1-1 1-1l2-9c1-1 1-2 1-3 0 0-1-1-1-2s-1-1-1-2c-1 0-1-1-2-1 0 0-1 0-1-1zm-2 17v1h-1c0 1 0 1-1 1h-1c-1 0-1-1-2-1v-3l2-9h1v-1l1-1h2l1 1 1 1v2l-3 9zm26-10h-2l-1 1-4 19v1c0 1 1 1 1 1h2l1-1 4-19v-1l-1-1zm24 5h-4l-1 1h-1c-1 1-1 2-1 2l-1 1v1l-2 10v2c0 1 0 2 1 2 0 1 1 2 1 2 1 1 1 1 2 1h1c2 1 3 1 4 0 1 0 1 0 2-1s1-1 1-2c1 0 1-1 1-1v-1l2-9v-3s0-1-1-2c0-1-1-1-2-2l-1-1h-1zm-1 16v2c-1 0-1 0-1 1h-2c0-1-1-1-1-1-1 0-1 0-1-1v-2l2-9v-2h4l1 1v2l-2 9zm25-12h-2v1l-3 19c0 1 0 1 1 2h2c1 0 1-1 1-1l2-19c1-1 0-1 0-2h-1zM633 1186c-1 0-2 0-3 1h-1c0 1-1 1-1 1-1 1-1 2-1 2 0 1-1 1-1 1v2l-1 9v1s0 1 1 1v2l2 2c1 0 1 1 2 1h5c0-1 1-1 2-2 0-1 1-1 1-2v-1l1-1v-12c0-1 0-1-1-2 0-1-1-1-2-2l-1-1h-2zm2 17c0 1-1 1-1 1s0 1-1 1h-3v-1c-1 0-1-1-1-1v-1l1-9v-1c0-1 0-1 1-1v-1h2c1 0 1 0 1 1h1v12zm28-15h-4s0 1-1 1c0 0 0 1-1 1 0 1-1 1-1 2v2l-1 10v1s1 0 1 1 0 1 1 2c0 1 1 1 2 2h6c1-1 2-1 2-2 1 0 1-1 1-2 0 0 0-1 1-1v-13c0-1-1-1-1-2l-2-2h-3zm2 16v1h-1c0 1 0 1-1 1h-2c-1 0-1 0-1-1 0 0-1 0-1-1l1-10v-1c0-1 1-1 1-1s1 0 1-1c1 0 2 1 2 1s1 0 1 1v11zm22-17-1 1-1 1 1 19v2h3c0-1 1-1 1-2l-1-19v-1c-1-1-1-1-2-1zm25-1c-1 0-2 0-3 1 0 0-1 0-1 1 0 0-1 0-1 1 0 0-1 1-1 2v12s0 1 1 1v1c0 1 1 1 1 2 1 0 1 1 2 1s1 1 2 1h1c2 0 3-1 4-1 0-1 1-1 1-2 1-1 1-2 1-2l1-1v-2l-1-9v-2c-1-1-1-2-2-2 0-1-1-1-2-2h-3zm4 16v1h-1v1c-1 1-1 1-2 1h-1l-1-1s0-1-1-1v-12l1-1h3l1 1v1l1 10zm25-19c-1 0-2 0-3 1l-1 1-1 1v2c-1 0-1 1-1 1v1l1 10c1 0 1 0 1 1v1s1 1 1 2c1 0 2 1 3 1h3c1 0 2 0 3-1 1 0 1-1 2-2 0 0 0-1 1-2v-2l-1-10s-1-1-1-2c0 0-1-1-1-2-1 0-2-1-3-1h-1c-1-1-1 0-2 0zm5 15v2c-1 0-1 1-1 1h-4c0-1 0-1-1-1v-1l-1-9v-2h1v-1h2c0-1 1-1 1 0h1s0 1 1 1v1l1 9zm24-20c-1 0-2 0-3 1l-1 1v1c-1 1-1 1-1 2v2l1 10 1 1v1c0 1 1 1 1 2 1 0 2 1 3 1h3c1 0 2 0 3-1l2-2c0-1 0-2 1-2v-2l-1-1-1-9c0-1 0-1-1-2 0-1 0-1-1-2s-1-1-2-1-1 0-2-1c0 0-1 1-2 1zm6 15v1l-1 1v1h-4c0-1 0-1-1-1v-1l-1-9v-2s0-1 1-1h1c1-1 1-1 1 0h1c1 0 1 1 1 1v1l2 9zm19-21c-1 0-1 1-2 1v2l4 18s0 1 1 1c0 0 1 1 1 0h1c1-1 1-1 1-2l-4-18c0-1 0-1-1-2h-1zm19-5s-1 0-1 1c0 0-1 1 0 1l4 18c0 1 1 1 1 2h2l1-1v-2l-5-18v-1h-2zm24-8c-1 0-2 1-3 2 0 0-1 0-1 1v1c-1 1-1 2-1 2v3l3 9 1 1v1c1 0 1 1 2 1 1 1 1 1 2 1h4c1-1 2-1 2-2l2-2v-5l-3-9s0-1-1-2c0 0-1-1-2-1 0-1-1-1-2-1h-3zm7 15v2c-1 1-1 1-2 1h-2l-1-1v-1l-3-9v-1c0-1 0-1 1-1 0-1 0-1 1-1h2c1 0 1 1 1 1v1l3 9zm16-24c0 1-1 1-1 1v2l6 18c1 0 1 0 1 1h2l1-1v-2l-6-17c-1-1-1-1-1-2h-2zm23-9c-1 0-2 1-3 1v2s-1 0-1 1v4l4 9c0 1 0 1 1 1v1c1 1 1 1 2 1 1 1 2 1 3 1h1c1 0 1 0 2-1 1 0 2-1 2-1 1-1 1-2 2-3v-3c0-1-1-1-1-1l-3-9c-1-1-1-1-1-2-1-1-1-1-2-1-1-1-2-1-3-1h-1c-1 0-1 0-2 1zm9 13v3c-1 0-1 1-2 1h-2l-1-1v-1l-4-8v-3c1 0 1-1 2-1h2l1 1v1l4 8zm14-24c-1 0-1 0-1 1-1 0-1 1 0 1l8 17c0 1 0 1 1 1h1c1 0 1-1 1-1v-2l-8-16c0-1 0-1-1-1 0-1-1-1-1 0zm22-12c-2 0-2 1-3 2 0 0 0 1-1 1v5s1 0 1 1l4 8c0 1 1 1 1 1l1 1s1 1 2 1c0 0 1 1 2 1s1-1 2-1h1l3-3s1-1 1-2v-2c0-1-1-1-1-2v-1l-5-8s0-1-1-2c0 0-1-1-2-1h-4s-1 0-1 1zm9 12 1 1v2c-1 1-1 1-2 1l-1 1s-1 0-1-1h-1v-1l-5-8v-3l1-1h3l1 1 4 8zm16-28-2 2c-1 1-1 1-1 2v4c0 1 0 1 1 1l4 8 1 1c0 1 1 1 1 1 0 1 1 1 2 1 1 1 2 1 3 1l1-1h2c1-1 1-2 2-3 0-1 1-1 1-2v-3l-1-1v-1l-5-8-1-1c-1-1-2-1-2-2h-5c0 1-1 1-1 1zm10 12 1 1v2l-1 1c-1 1-1 1-2 1h-1c0-1 0-1-1-1v-1l-5-8v-1c-1 0-1 0 0 0v-1c0-1 0-1 1-1 0-1 1-1 1-1h1c1 0 1 1 1 1h1l4 8zm11-26c-1 0-1 1-1 1v2l10 15c1 1 1 1 2 1h1c1 0 1-1 1-1v-2l-11-15c0-1 0-1-1-1h-1zm20-15-2 2c-1 1-1 1-1 2v3c0 1 1 1 1 1v1l6 8s0 1 1 1c1 1 2 1 3 1 0 1 1 1 2 0h2l1-1 2-2c1-1 1-2 1-3v-2l-1-1v-1l-6-8s-1-1-2-1c0-1-1-1-2-1-1-1-1-1-2 0h-2l-1 1zm11 11c1 0 1 1 1 1v2l-1 1c-1 0-1 1-2 1h-1c0-1 0-1-1-1v-1l-6-7v-3l1-1s1 0 1-1h1l1 1 1 1 5 7zm12-30-2 2c-1 1-1 1-1 2v1c0 1 0 2 1 2v1c0 1 0 1 1 1l6 8 1 1c1 0 2 1 2 1h3c1 0 1 0 2-1l1-1c1 0 2-1 2-2s1-2 0-3v-3l-1-1-6-7c0-1-1-1-2-2 0 0-1-1-2-1h-3s0 1-1 1l-1 1zm12 10v1l1 1s0 1-1 1c0 1 0 1-1 1 0 1 0 1-1 1h-2v-1l-6-7-1-1v-2l1-1c1 0 1-1 1-1h2v1h1l6 7zm9-30c-1 1-2 2-2 3v5c1 0 1 1 1 1s0 1 1 1l6 6 1 1 1 1h2c1 1 2 0 3 0 0 0 1 0 1-1 1 0 1 0 2-1s1-1 1-2c1-1 1-2 1-3s-1-2-1-2c0-1 0-1-1-1v-1l-7-7s-1-1-2-1c0 0-1-1-2-1s-2 0-3 1h-1c0 1-1 1-1 1zm13 10c1 0 1 1 1 1v1c0 1-1 1-1 2h-1c-1 1-1 1-1 0h-2l-7-7v-4c1 0 1-1 2-1h1l1 1 7 7zM1056 1017v2l14 13h3c0-1 1-1 1-2l-1-1-14-13h-1c-1 0-1 0-2 1zm15-16c-1 0-1 0-1 1 0 0 0 1 1 1l14 13h2c1-1 1-1 1-2 0 0 0-1-1-1l-14-13h-1c-1 0-1 0-1 1zm16-20c-1 1-2 2-2 3v3c0 1 1 1 1 2l1 1 1 1 7 6h1l1 1h5c0-1 0-1 1-1 0-1 1-1 1-2 1 0 1-1 2-2v-3c0-1-1-2-1-2 0-1-1-1-1-1s0-1-1-1l-7-6s-1-1-2-1h-5l-1 1-1 1zm14 8v1h1v2s0 1-1 1c0 1-1 1-1 1h-2s-1 0-1-1l-7-5v-1h-1v-2s0-1 1-1c0-1 1-1 1-1s1-1 1 0h2l7 6zm1-28v3l15 11h3v-3l-15-11c-1 0-1-1-2-1 0 1-1 1-1 1zm14-20c0 1-1 2-1 3v2c1 1 1 2 1 2l1 1 1 1 8 5 1 1h3c1 0 2 0 3-1 0 0 1 0 1-1 0 0 1 0 1-1 1-1 1-2 1-3v-3s-1-1-1-2h-1c0-1 0-1-1-1l-7-5c-1-1-2-1-2-1-1 0-2-1-3 0h-2c-1 1-1 1-2 1 0 1 0 1-1 2zm15 6 1 1v3c-1 0-1 1-1 1h-3l-8-5v-1h-1v-2s0-1 1-1c0-1 0-1 1-1 0 0 0-1 1-1l1 1 8 5zm-1-28c0 1-1 1 0 2v1l16 10h2s1 0 1-1c0 0 1-1 0-1v-2l-16-9c-1 0-1-1-2 0h-1zm13-21c-1 1-1 2-1 3v2c0 1 1 2 1 3h1l1 1 8 4c1 0 1 1 1 1h4c1 0 1-1 2-1s1-1 1-1c1-1 1-1 1-2 1-1 1-2 1-3v-2c0-1-1-2-1-2l-1-1c-1 0-1 0-1-1l-8-4c-1 0-2-1-3-1h-2c-1 0-2 1-2 1-1 1-1 1-2 1v2zm15 5c1 0 1 1 1 1v3s-1 0-1 1h-3l-8-5h-1v-3c0-1 1-1 1-2h3l8 5zm-2-32v6l2 2v1h1l9 4 1 1h3c1-1 2-1 3-1 0-1 0-1 1-2 0 0 0-1 1-1 0-1 1-2 1-3-1-1-1-2-1-3s-1-1-1-2h-1l-1-1-9-4s-1 0-2-1c-1 0-1 0-2 1-1 0-2 0-3 1l-1 1s0 1-1 1zm16 5h1v1s1 0 1 1l-1 1c0 1 0 1-1 1 0 1 0 1-1 1h-1l-9-4-1-1v-2c-1 0 0 0 0-1s0-1 1-1l1-1h1l1 1 8 4zm-5-27v1c0 1 1 1 1 1l17 7h2s1 0 1-1v-1c0-1-1-1-1-1l-17-8h-2c0 1-1 1-1 2zm10-24c-1 2-1 3-1 4l1 1v1l2 2h1c0 1 0 1 1 1l8 3h1c1 0 1 1 2 1 0 0 1-1 2-1s1-1 2-1l1-1c0-1 1-1 1-2s1-2 0-3v-3c-1 0-1-1-2-1 0-1-1-1-1-1s-1 0-1-1l-9-3h-4c-1 0-2 1-3 2l-1 1v1zm16 3v1h1s0 1 1 1c0 1-1 1-1 2 0 0 0 1-1 1l-1 1h-1v-1l-9-3h-1v-1c-1 0-1 0-1-1v-1c1-1 1-1 1-2h3l9 3zm-6-31c-1 1-1 3 0 4v2c1 1 2 1 2 2h1l1 1 9 2 1 1h1c1 0 2 0 3-1 0 0 1-1 2-1 0-1 0-1 1-1v-2c1-1 1-2 1-3s-1-2-1-3c-1 0-1-1-2-1 0-1 0-1-1-1h-1l-9-3h-4c-1 0-2 1-3 2v1c-1 0-1 1-1 1zm16 2s0 1 1 1 1 1 1 1v2l-1 1-1 1h-2l-9-3c-1 0-1-1-1-1s0-1-1-1c0 0 0-1 1-2v-1h1c1-1 1-1 1 0h1l9 2zm-7-30c-1 1-1 2-1 3 1 0 1 1 1 1 0 1 0 1 1 1 0 1 1 2 1 2 1 0 1 0 1 1h1l9 2h1c1 1 1 0 2 0h2c1 0 1-1 2-2l1-1s0-1 1-2v-3c-1-1-1-2-1-2l-2-2h-1c0-1-1-1-1-1l-9-2h-5l-2 2-1 1v2zm16 1h1v1s1 0 1 1v1c0 1-1 1-1 2h-1c0 1 0 1-1 1 0-1 0-1-1-1l-9-2h-1v-1s-1 0-1-1v-1c1-1 1-1 1-2h3l9 2zm-10-25v1l1 1 19 4s1 0 1-1c1 0 1 0 1-1v-1l-1-1-19-4h-1c-1 1-1 1-1 2zm4-20s0 1 1 1c0 1 0 1 1 1l18 3h2c0-1 1-1 1-2 0 0 0-1-1-1 0-1 0-1-1-1l-18-3h-2c0 1-1 1-1 2zm5-26v4c1 1 1 1 1 2 1 0 1 1 2 1h1l1 1 9 1h3s1 0 2-1c1 0 1-1 2-2l1-1v-5c0-1-1-1-1-2-1-1-1-1-2-1 0-1-1-1-1-1h-1l-9-2h-3s-1 1-2 1l-2 2-1 1v2zm16 0h2v4c0 1-1 1-1 1h-2l-9-1h-1v-1h-1v-4c1 0 1 0 1-1h2l9 2zm-13-25v2h2l18 2h2s0-1 1-1c0-1-1-1-1-2 0 0-1 0-1-1l-19-2-1 1c-1 0-1 1-1 1zm2-25c0 2 0 3 1 3v2s1 0 1 1c1 0 1 1 2 1h2l10 1h2c1 0 1-1 2-1l2-2v-2c1 0 1-1 1-1 0-2 0-3-1-4 0 0-1-1-1-2-1 0-1-1-2-1h-2l-10-1h-2c-1 0-1 1-2 1l-2 2c0 1 0 1-1 2v1zm16-1h2s0 1 1 1v1c0 1 0 2-1 2v1h-2l-9-1h-2l-1-1v-3c1 0 1-1 1-1h2l9 1zm-15-24c0 1 0 1 1 2h1l19 1 1-1c1 0 1-1 1-1 0-1 0-1-1-2h-1l-19-1-1 1c-1 0-1 1-1 1zm0-25c0 2 0 3 1 4l1 1 1 1s1 0 2 1h11c1 0 1 0 1-1h1c1 0 2-1 3-1 0-1 1-1 1-2s1-1 1-2v-1c0-2 0-3-1-4 0 0-1-1-2-1 0-1-1-1-2-2h-2l-9 1h-2c-1 0-2 1-3 1 0 1-1 1-1 2s-1 1-1 2v1zm16-3h2c0 1 0 1 1 1v3l-1 1s-1 0-1 1h-12c0-1 0-1-1-1v-3l1-1h1l1-1h9zm-17-26c0 1 0 2 1 3v1c1 0 1 1 1 1 1 0 2 1 3 1h2l9-1h2c1-1 2-1 2-2 1 0 1-1 2-2v-3c0-1 0-2-1-3 0-1-1-2-1-2-1 0-2-1-2-1h-3l-9 1h-2c-1 0-2 1-2 1-1 1-1 2-2 3v3zm16-4h1s1 0 1 1v4h-2l-10 1h-1c-1 0-1-1-1-1v-4h2l10-1zm-19-21c0 1 0 1 1 1 0 1 1 1 1 1l19-3h1c1-1 1-1 1-2l-1-1-1-1-19 3c-1 0-1 0-1 1-1 0-1 1-1 1zM1210 521c0 1 0 2 1 3h1c0 1 0 1 1 1 0 1 1 1 2 1h2l9-2h3c0-1 1-1 2-2 0-1 1-1 1-2v-3c0-2-1-3-1-3-1-1-1-2-2-2-1-1-2-1-2-1h-3l-9 2h-2l-2 2c0 1-1 1-1 2s0 1-1 2c0 0 0 1 1 2zm15-6h2l1 1v3l-1 1h-1l-9 2h-2s-1 0-1-1l-1-1c0-1 0-1 1-2v-1h2l9-2zm-21-23c0 1 1 2 1 3h1c0 1 1 1 1 1 1 0 2 1 3 1h2l9-2c0-1 1-1 1-1h1l2-2c0-1 1-1 1-2v-4c0-1-1-2-1-2-1-1-1-2-2-2s-2-1-2-1h-3l-9 3h-2l-2 2c0 1-1 1-1 2v4zm15-7h2s0 1 1 1v4h-1c0 1-1 1-1 1l-9 2h-2s0-1-1-1v-4h1l1-1 9-2zm-22-21c0 1 1 2 1 3 1 0 1 0 1 1h2c0 1 1 1 2 1h1l1-1 9-3h1c1 0 1 0 1-1 1 0 1-1 2-1 0-1 1-2 1-3v-3c-1-1-1-2-2-3s-1-1-2-1c-1-1-2-1-3-1h-1c0 1 0 1-1 1l-9 3s-1 0-2 1l-1 1c-1 1-1 2-1 3v3zm14-8h2l1 1 1 1v3h-1c-1 0-1 1-1 1l-9 3h-2s0-1-1-1v-1c-1-1-1-1 0-2v-1h1v-1l9-3zm-21-15 1 1h1l18-7 1-1v-2l-1-1h-2l-17 7c-1 0-1 1-1 1-1 1-1 1 0 2zm-8-20c1 0 1 1 1 1h2l18-7s0-1 1-1v-2s-1 0-1-1h-2l-17 7c-1 0-1 1-2 1v2zm-9-23c1 1 1 2 2 3h1l1 1h4s0-1 1-1l8-4h1c1 0 1 0 1-1 1 0 1-1 2-2 0 0 0-1 1-2 0-1 0-1-1-2v-1c0-2-1-2-2-3s-1-1-2-1-2-1-3 0h-2l-8 4c-1 0-2 1-2 1l-2 2c0 1 0 2-1 3 0 0 0 1 1 1v2zm14-9h1v-1c1 1 1 1 2 1v1c1 1 1 1 1 2l-1 1-1 1-9 4h-2c-1-1-1-1-1-2-1 0-1-1-1-1 0-1 1-1 1-1v-1h1l9-4zm-24-13 1 1h1l17-9c1 0 1-1 1-1v-2l-1-1h-2l-16 9c-1 0-1 1-1 1-1 1-1 1 0 2zm-12-22c1 1 1 2 2 2l1 1h5s1 0 1-1l8-4 1-1c1 0 1 0 1-1 1 0 1-1 1-2 1-1 1-1 1-2v-2l-1-1c-1-2-1-2-2-3-1 0-2-1-2-1h-3s-1 0-1 1h-1l-8 5c-1 0-1 1-2 1-1 1-1 1-1 2-1 1-1 2-1 3v1c1 1 1 1 1 2zm13-10c0-1 0-1 1-1h2c0 1 0 1 1 1v3l-1 1h-1l-8 5h-2c-1 0-1 0-1-1l-1-1v-2h1l1-1 8-4zm-25-11s0 1 1 1c0 0 1 0 1-1l16-10c1 0 1 0 1-1v-2h-3l-16 10-1 1c0 1 0 1 1 2zm-14-21c1 1 1 2 2 3h6c0-1 1-1 1-1l8-6h1s0-1 1-1c0-1 0-1 1-2v-3s0-1-1-1v-2c-1-1-2-2-3-2s-1-1-2-1-2 0-3 1h-1l-1 1-7 5-2 2s-1 1-1 2v4l1 1zm12-11v-1h2l1 1c1 1 1 1 1 2v1l-1 1-8 6h-3l-1-1v-3l1-1 8-5zm-30-12c1 1 2 2 3 2 0 0 1 0 1 1h2s1 0 2-1h1s0-1 1-1l7-6c1 0 1 0 1-1h1c0-1 1-2 1-3v-2c0-1 0-1-1-2v-1c-1-1-2-2-3-2-1-1-2-1-2-1-1 0-2 0-3 1h-1l-1 1-7 6c-1 0-1 1-2 1 0 1-1 2-1 3v2c0 1 0 1 1 2v1zm12-12v-1h2l1 1c1 1 1 1 1 2v1l-1 1-8 6v1h-2c-1 0-1-1-1-1-1-1-1-1-1-2v-1l1-1 8-6zm-27-7c0 1 1 1 1 1h2l14-13s0-1 1-1c0-1-1-1-1-2h-3l-14 13s-1 0-1 1 0 1 1 1zm-17-17c1 0 2 1 3 1l1 1h1c1-1 2-1 3-1l1-1h1l6-7c1 0 1-1 1-1l1-1v-2c1-1 1-2 0-3v-1c-1-1-1-1-1-2-1 0-2-1-3-1-1-1-2-1-3-1 0 1-1 1-2 1 0 0-1 0-1 1h-1l-7 7c0 1-1 1-1 2s-1 1-1 2v3c1 0 1 1 1 1 0 1 1 1 1 2zm10-14h1v-1h2c0 1 0 1 1 1 0 1 0 1 1 1v2s-1 0-1 1l-7 7h-1v1h-2l-1-1c0-1-1-1-1-1v-2h1v-1l7-7zm-31-7c1 1 2 2 3 2h3s1 0 2-1h1s0-1 1-1l6-7 1-1v-1c1-1 1-1 1-2v-3c-1 0-1-1-1-1 0-1-1-1-1-2-1 0-2-1-3-1h-3s-1 0-2 1h-1s0 1-1 1l-6 7c-1 1-1 1-1 2-1 1-1 1-1 2v3c1 0 1 1 1 1 0 1 1 1 1 1zm9-13c0-1 1-1 1-1h3c1 1 1 1 1 2v2h-1l-6 7-1 1h-3c-1-1-1-1-1-2v-2h1l6-7zm-31-5c1 0 2 1 3 1h3s1 0 2-1l1-1h1l6-8v-1s1 0 1-1v-5l-1-1-1-1c-1-1-2-1-3-2h-3c0 1-1 1-2 1 0 1 0 1-1 1 0 0 0 1-1 1l-6 7c0 1 0 1-1 2v5c0 1 1 1 1 1 0 1 1 1 1 2zm8-15h1s0-1 1-1h1l1 1c1 0 1 1 1 1v3l-7 7v1h-3c-1-1-1-1-1-2v-2l6-8zm-27 0h1c1 0 1 0 1-1l12-15v-1c0-1 0-1-1-2h-1s-1 0-1 1l-12 15v2s0 1 1 1zm-17-11h2s1 0 1-1l11-16v-1c0-1 0-1-1-2h-1c-1 0-1 1-1 1l-11 16v3zm-20-13c1 0 2 1 3 1h1l1-1c1 0 2-1 3-1v-1s1 0 1-1l5-8v-1l1-1v-3s-1-1-1-2l-1-1c0-1-1-1-1-1-1-1-2-1-3-1h-3l-2 2h-1c0 1 0 1-1 1l-4 9c-1 0-1 1-1 2 0 0-1 1 0 2 0 1 0 2 1 3v1c1 0 1 0 2 1zm6-16c0-1 1-1 1-1h3c0 1 0 1 1 1v2c0 1 0 1-1 1l-4 8-1 1h-1c0 1 0 1-1 1 0 0-1 0-1-1-1 0-1 0-1-1l-1-1s0-1 1-1v-1l5-8zm-27 4h1c1 0 1-1 1-1l9-17v-2s0-1-1-1h-1c-1 0-1 1-1 1l-9 17v1c0 1 0 1 1 2zM933 152h4c1 0 1 0 2-1 0 0 1 0 1-1 1 0 1-1 1-1l1-1 4-9v-4c0-1 0-2-1-3 0 0-1 0-1-1h-2c-1-1-2-1-3-1s-1 0-2 1c-1 0-2 1-2 1l-1 1v1l-4 9c-1 0-1 1-1 2v2c0 1 1 2 1 3 1 0 1 0 1 1 1 0 1 0 2 1zm4-16c0-1 0-1 1-1v-1h3l1 1v1c1 0 0 1 0 1v1l-4 9-1 1h-2c-1 0-1-1-2-1v-3l4-8zm-26 6h1c1-1 1-1 1-2l7-17v-2s0-1-1-1h-1c-1 0-1 1-1 1l-8 18v2c1 0 1 0 2 1zm-24-10c1 1 2 1 3 1 0 0 1 0 1-1h1c1-1 2-1 2-2 0 0 1 0 1-1v-1l4-8v-5c0-1-1-2-1-2 0-1-1-1-1-1-1-1-1-1-2-1-1-1-2-1-3-1-1 1-2 1-2 1-1 1-2 1-2 2-1 0-1 0-1 1v1l-4 9s0 1-1 2c0 1 0 1 1 2 0 1 0 2 1 3 0 0 1 0 1 1h2zm3-16h1v-1l1-1c1 0 1 0 2 1h1v1c1 1 1 1 0 1v1l-3 9-1 1-1 1h-2c0-1-1-1-1-1 0-1-1-1-1-1v-1l1-1 3-9zm-30 8h3c1 0 1-1 2-1h1c0-1 1-2 1-2l1-1v-1l3-9v-5l-2-2-1-1s-1 0-2-1h-3c-1 0-2 1-2 1l-2 2v1l-1 1-2 9c-1 1-1 2-1 3 0 0 0 1 1 2 0 1 1 1 1 2 1 0 1 1 1 1 1 0 1 0 2 1zm2-17v-1h1c0-1 0-1 1-1h1c1 0 1 1 2 1v3l-2 9h-1v1l-1 1h-2l-1-1-1-1v-2l3-9zm-27 10h2c0-1 1-1 1-2l5-18v-1c0-1-1-1-1-1h-2l-1 1-5 18v2l1 1zm-24-5h4c0-1 0-1 1-1 0 0 1 0 1-1 1 0 1-1 2-1v-3l3-9v-2c0-1-1-2-1-2 0-1-1-2-2-2 0-1 0-1-1-1l-1-1h-4c-1 0-1 1-2 1-1 1-1 2-2 2v2l-3 10v2c0 1 0 1 1 2 0 1 1 2 1 2 1 1 1 1 2 1 0 0 1 0 1 1zm1-17s1 0 1-1 1-1 1-1h2s1 0 1 1l1 1v1l-3 10v1c-1 0-1 1-1 1h-2l-1-1s-1 0-1-1v-2l2-9zm-29 12h3c0-1 1-1 1-1s1 0 1-1c1 0 1-1 2-2v-2l2-9v-2c0-1 0-2-1-3 0 0-1-1-1-2h-2c0-1-1-1-1-1h-4c0 1-1 1-2 2 0 0-1 1-1 2-1 0-1 0-1 1v1l-2 9v2c0 1 0 2 1 3l2 2h1s1 1 2 1zm0-17v-1c1 0 1-1 1-1h2c1 0 1 0 1 1h1v2l-2 10v1c-1 0-1 1-1 1h-2s-1 0-1-1c0 0-1 0-1-1v-1l2-10zm-30 13c2 1 3 0 4 0l1-1h1c0-1 1-2 1-2 0-1 1-1 1-1v-2l1-9v-2c0-1 0-2-1-2 0-1-1-2-2-2 0-1 0-1-1-1h-5c-1 0-1 1-2 1-1 1-1 2-1 2-1 1-1 1-1 2v1l-1 9v2c0 1 0 2 1 3l1 1c1 1 1 1 2 1h1zm0-16v-2h4c1 0 1 1 1 1v2l-1 9v1s0 1-1 1h-1s0 1-1 1l-1-1c-1 0-1-1-1-1v-2l1-9zm-24 15s1 0 1-1c1 0 1 0 1-1l1-19c1 0 0-1 0-1 0-1-1-1-1-1-1 0-1 0-2 1v1l-2 19s0 1 1 1c0 1 0 1 1 1zm-20 0 1-1c1 0 1-1 1-1V81c1-1 0-1 0-2h-3v2l-1 19v1c1 0 1 1 2 1zm-25 0c1 0 2 0 3-1h1l1-1c1-1 1-2 1-3 0 0 1 0 1-1V86c0-1 0-1-1-1v-1c0-1 0-2-1-3-1 0-1-1-2-1s-1 0-2-1h-1c-1 0-3 1-3 1-1 1-2 1-2 2-1 1-1 1-1 2-1 0-1 1-1 1v11s1 1 1 2 0 1 1 2c0 1 1 1 2 2h3zm-3-16v-1l1-1c1-1 1-1 2-1h1l1 1s0 1 1 1v12h-1v1h-3c-1 0-1 0-1-1 0 0-1 0-1-1V86zm-22 18c1 0 1 0 2-1v-1l-1-19c0-1 0-1-1-2h-1s-1 0-1 1c-1 0-1 1-1 1l1 19 1 1c0 1 1 1 1 1zm-24 2c1 0 2 0 3-1 0 0 1 0 1-1l1-1s0-1 1-2v-2l-1-9c0-1 0-1-1-2v-1s-1-1-1-2c-1 0-2-1-3-1h-3c-1 0-2 0-3 1-1 0-1 1-2 2v2c-1 0-1 1-1 1v1l2 10v2c0 1 1 1 1 2 1 0 2 1 3 1 0 0 1 0 1 1 1 0 1 0 2-1zm-5-15v-1s0-1 1-1v-1h4c0 1 0 1 1 1v1l1 9v2l-1 1s-1 0-2 1c0 0-1 0-1-1h-1v-1l-1-1-1-9zm-20 19c1 0 1 0 2-1v-1l-3-19s0-1-1-1h-1c-1 0-1 0-2 1v1l3 19s0 1 1 1h1zm-24 5c1 0 2-1 3-1 0-1 0-1 1-1 0-1 0-1 1-2v-4l-2-9v-1c0-1 0-1-1-1 0-1-1-2-1-2-1-1-2-1-3-1h-3c-1 0-2 0-3 1 0 1-1 1-1 2-1 1-1 2-1 3v2l2 9c0 1 0 1 1 2 0 1 1 1 1 2 1 0 2 1 3 1h3zm-6-15v-2l1-1h1c1-1 1-1 2-1 0 1 0 1 1 1v2l2 9v2c-1 1-1 1-2 1h-2l-1-1v-1l-2-9zm-23 22c1 0 2-1 3-1 0-1 1-1 1-1 0-1 0-1 1-2v-4l-2-9-1-1v-1c-1-1-1-2-2-2-1-1-1-1-2-1h-4c-1 0-2 1-2 2-1 0-2 1-2 2v4l2 10s1 1 1 2c0 0 1 1 2 1 0 1 1 1 2 1h3zm-6-15h-1c0-1 0-1 1-1v-1c0-1 1-1 1-1h3s0 1 1 1v1l2 9v3h-2s-1 1-1 0h-1l-1-1v-1l-2-9zm-18 22c1 0 1 0 2-1v-1l-6-18c0-1 0-1-1-1 0-1-1-1-1-1-1 1-1 1-2 1v2l6 18s0 1 1 1h1zm-23 8c1 0 2-1 2-2 1 0 1 0 1-1 0 0 1 0 1-1v-4l-3-9-1-1c0-1 0-1-1-1 0-1-1-1-1-2-1 0-2 0-3-1h-1c-1 1-1 1-2 1s-2 1-3 2c0 0-1 1-1 2v5l3 8c1 1 1 2 1 2l2 2c1 0 2 1 3 1h1c1 0 1-1 2-1zm-8-14v-1c-1 0-1 0 0 0v-2h1c1-1 1-1 2-1 0 0 1 0 1 1h1v1l3 9v3s-1 0-2 1h-1s-1 0-1-1h-1v-1l-3-9zM482 148c1 0 2-1 3-2l1-1v-6l-4-8v-1l-1-1-2-2h-6c-1 1-2 1-2 2-1 1-1 2-1 3-1 0-1 1-1 2 0 0 0 1 1 1v1l4 9s0 1 1 2c0 0 1 1 2 1 0 1 1 1 2 1h2l1-1zm-9-13v-2s0-1 1-1c0-1 0-1 1-1h2c1 0 1 0 1 1l4 9v3s-1 0-1 1h-3v-1l-1-1-4-8zm-18 25c1 0 2-1 3-2v-1c1 0 1-1 1-1v-3c0-1-1-1-1-2l-4-8v-1s-1 0-1-1c-1 0-1-1-2-1-1-1-2-1-3-1h-1c-1 1-1 1-2 1-1 1-2 1-2 2-1 1-1 2-1 2 0 1-1 2 0 3v2l4 8c1 1 1 2 2 2 0 1 1 1 1 2h5s1 0 1-1zm-9-13-1-1c0-1 1-1 1-2h1l1-1h2v1l1 1 4 8v3c-1 0-1 1-2 1h-2s-1 0-1-1l-4-9zm-13 25 1-1v-2l-9-16c0-1-1-1-1-1h-2s-1 0-1 1v2l9 16 1 1h2zm-19 10c1 0 1 0 1-1v-1l-9-17s0-1-1-1h-2v2c-1 0-1 1 0 1l9 17h1c0 1 1 1 1 0zm-21 13c1 0 2-1 2-2l1-1v-5c-1 0-1-1-1-1l-5-8v-1s-1 0-1-1c-1 0-1-1-2-1h-4c-1 0-1 1-2 1-1 1-2 1-2 2-1 1-1 2-1 3v3l1 1 5 8c0 1 1 1 1 2 1 0 1 1 2 1s2 1 3 0h1c1 0 1 0 2-1zm-11-12v-3s1 0 1-1h3l1 1 5 8v3l-1 1h-2c0 1 0 0-1 0l-1-1-5-8zm-10 26s1 0 1-1v-2l-11-15-1-1h-2v3l10 16c1 0 1 0 2 1 0 0 1 0 1-1zm-20 15c1-1 1-2 2-3v-5c0-1-1-1-1-1l-5-8c-1 0-1-1-1-1s-1 0-1-1c-1 0-1 0-2-1h-3c0 1-1 1-1 1-1 0-1 0-2 1l-2 2c0 1-1 2-1 3s1 1 1 2v1c0 1 1 1 1 1l5 8c1 0 1 1 2 1 1 1 1 1 2 1h4c1 0 1-1 2-1zm-12-11v-1c-1 0-1 0-1-1l1-1s0-1 1-1l1-1h1l1 1 6 8v1h1v1l-1 1-1 1h-3v-1l-6-7zm-8 26s1 0 1-1c0 0 0-1-1-1l-12-15h-1c0-1-1 0-1 0-1 0-1 1-1 1v2l12 14c1 1 1 1 2 1 0 0 1 0 1-1zm-19 17c1-1 1-2 2-3v-5c-1 0-1-1-1-1l-1-1-6-7-1-1h-1c0-1-1-1-2-1h-2c-1 0-1 1-2 1l-1 1c-1 1-2 2-2 3s-1 1-1 2 1 2 1 3l1 1 7 7c0 1 1 1 1 2 1 0 2 0 2 1 1 0 2 0 3-1h2c0-1 0-1 1-1zm-13-10v-1s-1 0-1-1v-1c1 0 1-1 1-1 1-1 1-1 2-1h2v1l6 7h1v2c0 1 0 1-1 2 0 0-1 0-1 1h-1l-1-1h-1l-6-7zm-9 30c1-1 2-2 2-3v-2c0-1 0-2-1-3v-1h-1l-6-7c-1 0-1-1-1-1h-1c-1-1-2-1-3-1h-2c-1 0-1 1-2 1 0 0 0 1-1 1-1 1-1 2-2 3v2c0 1 0 2 1 3v1c1 0 1 0 1 1l7 6c0 1 1 1 1 1 1 1 2 1 3 1h2c1 0 1-1 2-1l1-1zm-13-9s0-1-1-1v-2s0-1 1-1c0-1 1-1 1-1h2c0 1 1 1 1 1l6 6 1 1v2s0 1-1 1c0 1-1 1-1 1h-2l-1-1-6-6zm-5 28v-3l-13-13c-1-1-1-1-2-1 0 0-1 0-1 1-1 0-1 1-1 1 0 1 0 1 1 2l13 13h3zm-17 18 2-2v-3c0-1-1-2-1-2 0-1-1-1-1-1v-1l-7-6-1-1c-1 0-1 0-1-1h-5c-1 1-1 1-2 1 0 0 0 1-1 1-1 1-1 2-1 3-1 1-1 2-1 3 1 1 1 1 1 2l1 1s0 1 1 1l7 6 1 1c1 1 2 1 3 1 0 0 1 0 2-1h2c0-1 0-1 1-2zm-14-8v-1s-1 0-1-1v-1l1-1c0-1 1-1 1-1h2c1 0 1 1 1 1l7 6c0 1 1 1 1 1v1c0 1-1 1-1 2l-1 1h-1c-1 0-1 0-1-1h-1l-7-6zm-5 31c1-1 1-2 1-2v-3c0-1 0-2-1-2v-1l-1-1-7-6c-1 0-1-1-1-1h-1c-1 0-2-1-3-1 0 1-1 1-2 1s-1 1-1 1c-1 0-1 1-2 1 0 1-1 2-1 3v3s0 1 1 2v1c1 0 1 0 1 1l7 5c1 1 2 1 2 2h3s1 0 2-1h2c0-1 0-1 1-2zm-14-8h-1v-3c1-1 1-1 2-1 0-1 0-1 1-1 0 0 0 1 1 1l7 6 1 1c1 1 1 1 1 2-1 0-1 0-1 1-1 0-1 1-1 1h-2l-1-1-7-6zm-4 32c1-1 1-2 1-3v-2c0-1-1-2-1-3h-1c0-1 0-1-1-1l-7-6h-1l-1-1h-2c-1 0-2 0-3 1 0 0-1 0-1 1-1 0-1 0-1 1-1 1-2 2-2 3v2c1 1 1 2 1 3h1c0 1 1 1 1 1l7 6c1 0 2 0 2 1h3c1 0 1 0 2-1h2c0-1 0-1 1-2zm-15-7v-1h-1v-2l1-1 1-1h2l1 1 7 5 1 1v3c-1 0-1 1-1 1h-2l-1-1-8-5zm0 28c1-1 1-1 1-2l-1-1-16-10s0-1-1 0h-1c-1 1-1 1-1 2 1 0 1 1 1 1l16 10c0 1 1 1 1 1 1 0 1-1 1-1zm-11 17c1-1 1-1 1-2-1 0-1-1-1-1l-16-9c-1-1-1-1-2-1 0 1-1 1-1 1v2s0 1 1 1l16 10h1c1 0 1-1 1-1zm-13 22c0-1 1-2 1-3v-1s0-1-1-1c0-1 0-2-1-2v-1c-1 0-1-1-1-1l-8-5h-2c-1-1-2-1-3-1-1 1-1 1-2 1-1 1-1 1-2 1 0 1 0 1-1 2 0 1-1 2-1 3s0 2 1 2c0 1 0 2 1 3h1c0 1 0 1 1 1l8 5s1 0 2 1h2c1 0 2-1 3-1 0-1 0-1 1-1 0-1 0-1 1-2zm-15-5-1-1v-1c-1 0-1 0-1-1 0 0 0-1 1-1 0-1 0-1 1-1 0-1 0-1 1-1h1c0 1 0 1 1 1l8 5c1 0 1 1 1 1v1s0 1-1 1c0 1 0 1-1 1 0 1 0 1-1 1h-1v-1l-8-4zm3 27v-1c0-1-1-1-1-1l-16-9h-2s-1 0-1 1v1c0 1 0 1 1 1l16 9c1 0 1 1 2 0 0 0 1 0 1-1zm-11 23v-6l-2-2h-1c0-1 0-1-1-1l-8-4h-1c0-1-1-1-1-1h-2c-1 1-2 1-3 2 0 0-1 0-1 1l-1 1c0 1-1 2-1 3s1 2 1 3 1 1 1 2c1 0 1 0 1 1h1l9 4s1 1 2 1h2c1-1 2-1 3-2l1-1s0-1 1-1zm-16-4c0-1-1-1-1-1-1-1-1-1-1-2 0 0 0-1 1-1 0-1 0-1 1-1 0-1 0-1 1-1h1v1l9 4h1v3c0 1-1 1-1 1 0 1-1 1-1 1h-2l-8-4zm5 27v-2s0-1-1-1l-17-7h-2l-1 1v2s1 0 1 1l17 7h2l1-1zM136 511c1-1 1-2 1-3v-2c-1 0-1 0-1-1s-1-1-2-2c-1 0-1-1-1-1l-9-3h-5c-1 0-1 1-2 2 0 0-1 0-1 1l-1 1v6l2 2h1c0 1 1 1 1 1l9 3h4c1 0 2-1 3-1 0-1 0-1 1-2v-1zm-16-3c-1 0-1-1-1-1v-2c0-1 0-1 1-2h2l9 3h1v1h1v3l-1 1h-3l-9-3zm6 31c0-1 1-2 0-3v-2l-1-1s-1-1-1-2h-2l-9-3h-1c0-1-1-1-1-1-1 0-2 1-3 1 0 0-1 1-2 1 0 1-1 1-1 2v1c-1 2-1 3-1 4 0 0 1 1 1 2l2 2h1s0 1 1 1l9 2c0 1 1 1 2 1s1 0 2-1c1 0 2-1 3-1v-2c1 0 1-1 1-1zm-16-2h-1v-1c-1 0-1-1-1-1v-2l1-1h1c0-1 1-1 1-1 0 1 1 1 1 1l9 2v1h1c0 1 0 1 1 1 0 1 0 1-1 2v1c-1 0-1 1-1 1h-2l-9-3zm8 27v-2l-1-1-18-5h-2s0 1-1 1c0 1 0 1 1 2l1 1 18 5h1c1 0 1-1 1-1zm-7 24c1-1 1-2 1-3s-1-1-1-1v-2c-1 0-2-1-2-1l-1-1h-1l-9-2-1-1h-1c-1 0-2 1-3 1s-1 1-2 2c0 0-1 0-1 1v1c-1 2-1 3-1 4 1 1 1 1 1 2 1 1 2 1 2 2h1c1 0 1 0 1 1l9 2h2c1 0 2 0 3-1 1 0 1 0 2-1l1-1v-2zm-16-1v-1h-1l-1-1v-2c1 0 1-1 1-1s1 0 1-1h2l9 3h1v1h1v2c0 1-1 1-1 1 0 1-1 1-1 1h-2l-9-2zm10 30v-3c0-1-1-1-1-1v-2c-1 0-2-1-2-1-1 0-1 0-1-1h-1l-9-2h-3c-1 0-1 0-2 1-1 0-1 1-2 2 0 0-1 0-1 1v1c-1 2-1 3 0 4 0 1 0 1 1 2 0 1 1 1 2 2h2l9 2h4c1-1 2-1 2-2 1 0 1-1 1-1 0-1 1-1 1-2zm-17-1h-1s0-1-1-1v-2c1 0 1-1 1-1l1-1h2l9 2h1v1c1 0 1 0 1 1v1c0 1 0 1-1 2h-2l-10-2zm11 30v-4l-1-1-2-2h-2l-9-2h-3s-1 1-2 1-1 1-2 2c0 0 0 1-1 1v5c0 1 1 2 1 2l2 2h2l10 2h2c1 0 1 0 2-1 1 0 1-1 2-2l1-1v-2zm-16 1c0-1-1-1-1-1h-1v-4c1 0 1-1 1-1h2l9 2h2v4l-1 1h-2l-9-1zm13 24s0-1-1-1c0-1 0-1-1-1l-19-2h-1c0 1-1 1-1 2 0 0 0 1 1 1 0 0 0 1 1 1l19 2s1 0 1-1c0 0 1 0 1-1zm-2 20-1-1c0-1-1-1-1-1l-19-1h-1c-1 1-1 1-1 2v1c1 1 1 1 2 1l18 1h2c0-1 1-1 1-2zm-2 25c0-1 0-2-1-3 0 0 0-1-1-1v-1c-1-1-2-1-3-1l-1-1H75c-1 0-1 0-1 1-1 0-2 0-3 1 0 0-1 1-1 2l-1 1v2c0 1 0 2 1 3 0 1 0 2 1 2 1 1 1 1 2 1h1l1 1h10c1 0 1 0 2-1 1 0 1 0 2-1 1 0 1-1 2-2v-1c1-1 1-1 1-2zm-16 3h-1l-1-1s-1 0-1-1v-3h1c0-1 1-1 1-1h11l1 1v1c1 0 1 0 1 1s0 1-1 1v1l-1 1H76zm15 23s0-1-1-1c0-1-1-1-1-1H69c-1 1-1 1-1 2 0 0 0 1 1 1 0 1 0 1 1 1h19s1 0 1-1c1 0 1 0 1-1zm0 25c0-1 0-2-1-3v-1l-1-1c-1-1-2-1-2-1H73c-1 1-2 1-2 2-1 0-2 1-2 2v1c-1 1-1 1-1 2s1 2 1 3l2 2s1 1 2 1h14c0-1 1-1 2-2 0 0 1-1 1-2 1 0 1-1 1-1v-2zm-16 3h-2v-1c-1 0-1-1-1-1 0-1 0-1 1-2v-1h13s1 0 1 1v3s-1 0-1 1H75zm17 22v-1c-1-1-1-1-2-1l-19 2h-1v3c1 0 1 1 2 1l18-2c1 0 1 0 2-1v-1zm3 25c-1-2-1-3-1-3l-1-1-1-1c-1-1-2-1-3-1h-2l-9 1h-1c-1 0-1 1-1 1-1 0-2 1-2 1-1 1-1 2-2 2v4c0 1 0 2 1 3l2 2h4l10-1h2c0-1 1-1 2-2 0 0 1-1 1-2s0-1 1-2v-1zm-16 4c0 1-1 1-1 0 0 1-1 0-1 0h-1v-3c0-1 0-1 1-1v-1h1l10-1h1c1 0 1 0 1 1l1 1c0 1 0 1-1 2v1h-2l-9 1zm19 25c0-1 0-2-1-3 0 0 0-1-1-1 0 0 0-1-1-1s-1 0-2-1h-1l-1 1-10 1h-1c0 1 0 1-1 1 0 0-1 1-2 1 0 1-1 2-1 3v3c0 1 0 2 1 3l2 2h2l1 1c1-1 1-1 2-1l9-1c1 0 1-1 2-1s1-1 2-2c0 0 1-1 1-2v-3zm-15 6h-1l-1-1h-1v-4c1 0 1-1 1-1h1l9-2h2v1h1v2c1 0 1 1 0 1v1l-1 1h-1l-9 2zm20 18-1-1h-2l-18 4c-1 0-1 1-1 1-1 0-1 1-1 2 1 0 1 0 1 1h2l18-4c1 0 1-1 1-1 1-1 1-1 1-2zm5 25c0-2-1-3-1-3l-1-1c-1 0-1-1-2-1h-4l-9 3h-2c-1 1-2 1-2 2-1 1-1 2-1 3v3c0 1 1 2 1 3 1 0 2 1 2 1 1 0 2 1 3 1h1l1-1 9-2c1 0 2-1 2-1 1 0 1-1 2-2 0 0 1-1 1-2v-3zm-15 7h-2s0-1-1-1v-4h1c0-1 1-1 1-1l9-2h2c1 1 1 1 1 2v2l-1 1h-1l-9 3zm23 21c-1-1-1-2-2-3 0 0-1 0-1-1h-1c-1 0-2-1-3-1l-1 1h-1l-9 3h-1s0 1-1 1c0 0-1 1-1 2-1 0-1 1-1 2v3c0 1 1 2 1 3 1 1 2 1 3 1 0 1 1 1 2 1h1c1 0 1 0 1-1l9-3c1 0 2 0 2-1 1 0 1-1 2-1 0-1 1-2 1-3v-3zm-15 8h-2l-1-1v-1l-1-1c1-1 1-1 1-2h1l9-3 1-1h1c1 0 1 1 1 1l1 1v3h-1l-1 1-9 3zm24 20c-1-1-1-2-2-3h-1l-1-1h-5l-9 4h-1l-1 1s-1 1-1 2c-1 0-1 1-1 2v3c1 1 1 2 2 3s1 1 2 1c1 1 2 1 3 1 0 0 0-1 1-1h1l9-3c0-1 1-1 2-1 0-1 1-2 1-2 1-1 1-2 1-3v-3zm-15 8v1h-1c-1 0-1-1-1-1-1 0-1-1-1-1v-3h1c0-1 0-1 1-1l8-3h3l1 1v3s-1 0-1 1h-1l-9 3zM133 974s0-1-1-1h-1l-18 8s-1 0-1 1v1c0 1 1 1 1 1 1 1 1 1 2 0l17-7 1-1v-2zm8 19-1-1h-1l-17 8c-1 0-1 1-2 1v2c1 0 1 1 1 1h2l17-8c1 0 1 0 1-1 1-1 1-1 0-2zm11 23c-1-1-1-2-2-3h-1l-1-1h-4c0 1-1 1-1 1l-8 4c-1 0-1 1-2 1-1 1-1 2-2 2v6c1 1 2 2 2 3 1 0 2 1 3 1h2s1 0 1-1h1l9-4c0-1 1-1 2-2 0 0 1-1 1-2 0 0 1-1 1-2s0-1-1-2v-1zm-13 10h-3c-1-1-1-1-1-2v-2s0-1 1-1l9-5h2c1 1 1 1 1 2 1 0 1 1 1 1s0 1-1 1v1h-1l-8 5zm24 12c0-1 0-1-1-1 0-1-1 0-1 0l-17 9-1 1v2c1 0 1 1 1 1h2l16-10c1 0 1 0 1-1 1-1 1-1 0-1zm13 21-3-3h-6s0 1-1 1l-8 5-1 1c-1 1-1 2-2 3v4c1 0 1 1 1 1l2 2c1 1 2 1 3 1h3l1-1 8-5c1 0 2-1 2-1 1-1 1-2 1-3 1 0 1-1 1-2s0-1-1-2v-1zm-13 11h-2c-1 0-1 0-1-1-1 0-1-1-1-1v-1c0-1 1-1 1-1v-1l9-5h2s1 0 1 1c1 0 1 1 1 1v1l-1 1-1 1-8 5zm26 9h-3l-15 11c-1 0-1 1-1 1v2s1 0 1 1c1 0 1 0 2-1l15-11c1 0 1-1 1-1v-2zm14 20c-1-1-2-1-3-2h-5s0 1-1 1h-1l-7 6c0 1-1 1-1 1s0 1-1 1c0 1 0 1-1 2v3c1 0 1 1 1 1 0 1 0 1 1 2l2 2h5s1 0 1-1h1l8-6c0-1 1-1 1-2 1 0 1-1 1-2v-4c-1-1-1-1-1-2zm-11 13h-3s-1 0-1-1l-1-1v-1l1-1v-1l8-5 1-1h2l1 1v3l-1 1-7 6zm29 10c-1-1-2-1-3-2h-2c-1 0-2 0-3 1h-1s0 1-1 1l-7 6c0 1 0 1-1 1v1c-1 1-1 1-1 2v3s0 1 1 1v2c1 1 2 1 3 2h3s1 0 2-1h1l1-1 7-6c1-1 1-1 1-2 1-1 1-1 1-2v-4c-1-1-1-1-1-2zm-11 13v1h-2c-1 0-1-1-2-1v-3c0-1 1-1 1-1l7-6 1-1h2s0 1 1 1v1c1 1 1 1 0 1v1l-1 1-7 6zm28 7c-1-1-1-1-2-1 0 0-1 0-1 1l-15 12v3c1 0 1 1 2 1 0 0 1 0 1-1l14-12c1-1 1-1 1-2v-1zm16 17s-1-1-2-1-1-1-2-1h-1c-1 1-1 1-2 1s-1 0-1 1h-1l-7 7s0 1-1 1v1c-1 1-1 1-1 2v3l1 1c0 1 1 1 1 2 1 0 2 1 3 1 0 1 1 1 2 1 1-1 2-1 3-1v-1h1l7-7 2-2v-5s0-1-1-1c0-1 0-1-1-2zm-9 14h-1s0 1-1 1h-1c0-1-1-1-1-1l-1-1v-3h1l7-7 1-1h1c1 0 1 1 2 1v3l-1 1-6 7zm30 6s-1-1-2-1h-3c-1 0-2 0-2 1h-1l-1 1-6 7c-1 0-1 1-1 1l-1 1v5s0 1 1 1c0 1 0 1 1 1 1 1 2 2 3 2h2c1 0 2 0 2-1h1l1-1 7-7c0-1 1-1 1-2s1-1 1-2 0-2-1-3v-1l-2-2zm-9 14v1h-2c-1 0-1 0-1-1-1 0-1 0-1-1v-2l7-7v-1h4c0 1 0 1 1 2v1l-1 1-7 7zm32 5c-1 0-2-1-3-1h-3c-1 0-2 0-2 1h-1c0 1-1 1-1 1l-6 8s-1 0-1 1v1s-1 1-1 2 0 2 1 3l1 1s0 1 1 1c1 1 2 1 3 2h2c1-1 2-1 2-1l1-1c1 0 1-1 1-1l6-7c1-1 1-1 1-2 1-1 1-2 1-3 0 0 0-1-1-2v-1c-1-1-1-1-1-2zm-9 15c-1 0-1 1-1 1h-1c-1 0-1-1-2-1 0 0 0-1-1-1v-1c0-1 0-1 1-1v-1l6-7 1-1h3c0 1 1 1 1 2v2h-1l-6 8zm28 0h-2s-1 0-1 1l-11 15c-1 0-1 1-1 1 0 1 1 1 1 2h1c1 0 1 0 2-1l11-15s1-1 1-2c-1 0-1 0-1-1zm16 12c-1-1-1-1-2-1 0 1-1 1-1 1l-10 16c-1 1-1 1-1 2l1 1h1c1 0 1 0 2-1l10-16c1 0 1 0 1-1s-1-1-1-1zm20 13c-1 0-2-1-3-1h-1c-1 0-1 1-2 1 0 0-1 0-2 1v1c-1 0-1 0-1 1l-5 8v1c-1 0-1 1-1 1v2c0 1 1 2 1 3l1 1 1 1c1 1 2 1 3 1h3l2-2h1v-1l5-9c1 0 1-1 1-2v-2c0-1 0-2-1-3v-1c-1 0-1 0-2-1zm-6 16-1 1h-3c0-1 0-1-1-1v-2c0-1 0-1 1-1l4-8 1-1 1-1h1l1 1c1 0 1 0 1 1 0 0 1 0 1 1 0 0-1 0-1 1l-5 9zm28-3h-1c-1 0-1 0-1 1l-10 16c0 1-1 1 0 2v1h2s1 0 1-1l10-16v-2s0-1-1-1zm22 12c-1-1-2-1-3-1h-3l-2 2-1 1v1l-5 8v2c-1 1-1 2 0 3 0 0 0 1 1 2 0 0 0 1 1 1 0 1 0 1 1 1 1 1 2 1 3 1s2 0 3-1c0 0 1 0 2-1v-1c1 0 1-1 1-1l4-8c1-1 1-2 1-2v-3c0-1 0-1-1-2 0-1 0-1-1-1 0-1-1-1-1-1zm-5 15-1 1-1 1h-2l-1-1c0-1-1-1-1-1v-1l1-1 4-9h1v-1h3l1 1v3l-4 8zm27-5h-2l-1 1-8 18v1c0 1 1 1 1 1 0 1 1 1 2 0l1-1 8-17v-2s-1 0-1-1zm22 10h-4c-1 0-1 0-2 1l-1 1c-1 0-1 1-1 1s0 1-1 1l-3 9s0 1-1 1v1c0 1 0 2 1 2 0 1 0 2 1 3 0 0 1 0 1 1 0 0 1 0 2 1h3c1 0 1 0 2-1 1 0 2-1 2-1 0-1 0-1 1-1v-1l4-9v-5c0-1-1-1-1-2-1 0-1-1-1-1-1 0-1-1-2-1zm-3 16-1 1v1h-3c-1 0-1-1-1-1l-1-1v-1s0-1 1-1l3-9 1-1h3s1 0 1 1v2l-3 9zm30-6h-3s-1 0-1 1h-1c-1 1-2 1-2 2 0 0-1 0-1 1v1l-3 9-1 1v1c0 1 0 2 1 2 0 1 0 2 1 3 0 0 1 0 1 1h2c1 1 2 1 3 1 1-1 2-1 2-1 1-1 2-1 2-2l1-1v-1l3-9c1-1 1-2 1-2 0-1 0-2-1-3 0 0 0-1-1-2l-1-1c-1 0-1 0-2-1zm-2 17h-1v1c-1 0-1 1-1 1h-2c0-1-1-1-1-1l-1-1v-1c0-1 0-1 1-1l3-9v-1l1-1h2c1 0 1 1 1 1 1 0 1 1 1 1v2l-3 9zm27-9c-1 0-1 0-2 1 0 0-1 0-1 1l-6 18v1c0 1 1 1 1 1h2l1-1 6-18v-2s-1 0-1-1zM516 1308c-1 0-2-1-3 0h-1c-1 0-1 1-1 1-1 0-2 1-2 2v1c-1 0-1 0-1 1l-3 9v2c0 1 0 2 1 2 0 1 0 2 1 3h1c1 1 1 1 2 1h3c1 0 2 0 3-1 0 0 1-1 1-2 0 0 1 0 1-1v-1l3-9v-5c-1 0-1-1-2-2 0 0-1 0-1-1h-2zm-2 16v2h-4l-1-1v-2l3-9v-1c0-1 1-1 1-1h3l1 1v2l-3 9zm31-10h-3c-1 0-1 1-2 1l-1 1-1 1-1 1v2l-2 9c-1 0-1 1-1 1v1c0 1 1 2 1 2 0 1 1 2 2 2 0 1 0 1 1 1 0 0 1 1 2 1h3c1-1 1-1 2-1 1-1 1-2 2-2v-1c0-1 0-1 1-1l2-10v-2c0-1 0-1-1-2 0-1-1-2-1-2-1-1-1-1-2-1l-1-1zm-1 17h-1v1c0 1-1 1-1 1h-2s-1 0-1-1l-1-1v-1l3-10v-1c1 0 1-1 1-1h2l1 1c1 0 1 0 1 1v1l-2 10zm30-12c-2 0-3 0-4 1h-1l-1 1c-1 1-1 1-1 2-1 0-1 1-1 1v1l-2 9v3s0 1 1 2c0 1 1 1 2 2l1 1h5c1 0 1-1 2-1 1-1 1-2 1-2l1-1v-2l2-9v-2c0-1 0-2-1-2 0-1-1-2-2-2 0-1 0-1-1-1 0 0-1 0-1-1zm-1 17v1l-1 1h-3l-1-1v-2l2-9v-2c1 0 1 0 1-1h2l1 1c1 0 1 0 1 1v1l-2 10zm25-13h-2v1l-3 19c0 1 0 1 1 2h2c1 0 1-1 1-1l3-19c0-1 0-1-1-2h-1zm20 2h-2v1l-2 19c0 1 0 1 1 2h2c1 0 1-1 1-1l2-19c0-1-1-1-1-2h-1zm25 1c-1 0-2 0-3 1h-1c0 1-1 1-1 1 0 1-1 1-1 2v1l-1 1v12c0 1 0 2 1 2 0 1 1 2 2 2l1 1h2c1 0 2 0 3-1 1 0 1 0 2-1s1-1 1-2 1-1 1-1v-1l1-10c0-1 0-1-1-2 0-1 0-2-1-2 0-1-1-2-1-2-1 0-1-1-2-1h-2zm2 16v1s0 1-1 1c0 0 0 1-1 1h-2l-1-1s0-1-1-1l1-1v-11h1s0-1 1-1h3v1c1 0 1 1 1 1v1l-1 9zm23-16s-1 0-1 1c-1 0-1 1-1 1v21h3v-2l1-19v-1c-1 0-1-1-2-1zm25 0h-3l-1 1-1 1c-1 1-1 2-1 2 0 1-1 1-1 1v11c0 1 1 1 1 1v1c0 1 1 2 1 2 1 1 1 2 2 2h2c0 1 1 1 1 1 2-1 3-1 3-1 1-1 2-1 2-2 1-1 1-1 1-2l1-1v-11c0-1-1-1-1-2s0-2-1-2c0-1-1-1-2-2h-3zm3 16v1l-1 1c-1 0-1 1-2 1 0 0-1 0-1-1h-1c0-1 0-1-1-1v-12h1v-1h3c1 0 1 0 1 1h1v11zm22-18c-1 0-1 0-2 1v1l1 19c0 1 0 1 1 1 0 1 0 1 1 1s1 0 1-1c1 0 1-1 1-1l-1-19c0-1-1-1-1-2h-1zm24-2c-1 0-2 0-3 1 0 0-1 0-1 1l-1 1s0 1-1 2v2l1 9c0 1 1 1 1 2v1s1 1 1 2c1 0 2 1 3 1h3c1 0 2 0 3-1 1 0 1-1 2-2 0-1 0-1 1-2v-2l-1-10c-1 0-1-1-1-2s-1-1-1-2c-1 0-2-1-3-1l-1-1c-1 0-1 0-2 1zm5 15v2c-1 0-1 0-1 1h-4c0-1 0-1-1-1v-1l-1-9v-2l1-1s1 0 2-1c0 0 1 0 1 1h1v1l1 1 1 9zm24-20c-1 0-2 1-3 1 0 1 0 1-1 1v2c-1 0-1 1-1 2v2l1 9c0 1 1 1 1 2s1 2 2 2c0 1 1 1 2 2h3c1 0 2-1 3-2 1 0 1-1 2-2 0 0 0-1 1-2v-1s0-1-1-1l-1-9c0-1 0-2-1-3 0 0 0-1-1-1-1-1-2-1-2-2h-4zm6 16v1l-1 1c-1 1-1 1-2 1h-1s-1 0-1-1l-1-1-1-10v-1c0-1 0-1 1-1 0 0 0-1 1-1h1c1 0 1 0 1 1 1 0 1 0 1 1l2 10zm20-21-1 1c-1 1-1 1-1 2l3 18c0 1 1 1 1 2h2l1-1v-1l-3-19s0-1-1-1c0-1-1-1-1-1zm24-5c-1 0-2 0-3 1l-1 1s0 1-1 1v5l2 9v1s0 1 1 1c0 1 1 1 1 2 1 0 2 1 3 1h3c1 0 2-1 3-1 0-1 1-2 1-3 1 0 1-1 1-2v-2l-2-9c0-1-1-2-1-2 0-1-1-2-1-2-1-1-2-1-3-1l-1-1c-1 0-1 1-2 1zm6 15v1c0 1 0 1-1 2h-4v-2l-2-9v-3h2c0-1 1-1 1 0h1c1 0 1 1 1 1v1l2 9zm23-23c-2 0-3 1-3 1l-1 1c0 1-1 1-1 2v4l2 9c0 1 0 1 1 1v1c1 1 1 2 2 2 0 0 1 1 2 1h3c2-1 2-1 3-2 1 0 1-1 2-2v-5l-2-9c-1 0-1-1-1-2-1 0-1-1-2-1 0-1-1-1-2-1-1-1-1-1-2-1l-1 1zm6 15v2c-1 1-1 1-2 1h-2c0-1-1-1-1-1v-1l-2-9-1-1 1-1v-1h2c0-1 1-1 1 0h1l1 1 2 10zm22-24c-1 0-2 1-3 1 0 1-1 1-1 1 0 1 0 1-1 2v4l3 9c0 1 0 1 1 1v1l2 2c1 0 1 0 2 1h2s1-1 2-1 2-1 2-1c1-1 1-2 2-3v-4l-3-9c0-1 0-2-1-2 0-1-1-1-2-2 0 0-1-1-2-1h-2s-1 0-1 1zm7 14v3c-1 0-1 0-2 1h-1s-1 0-1-1h-1v-1l-3-9v-2s0-1 1-1l1-1h1c1 0 1 0 1 1h1v1l3 9zm16-23s-1 0-1 1v1l6 18 1 1h2s1 0 1-1v-1l-6-18c-1 0-1-1-1-1h-2zm19-8-1 1v2l7 17c0 1 1 1 1 1h2l1-1v-1l-8-18-1-1h-1zm24-10c-1 0-2 1-3 2l-1 1v6l4 8v1l1 1c0 1 1 1 2 2h5c2-1 2-2 3-2 1-1 1-2 1-3 1-1 1-1 1-2-1 0-1-1-1-1v-1l-4-9c0-1 0-1-1-2 0 0-1-1-2-1 0-1-1-1-2-1h-2s-1 0-1 1zm8 13c0 1 1 1 1 1v1l-1 1-1 1h-3v-1h-1l-3-9-1-1v-1c1 0 1 0 1-1 0 0 1 0 1-1h3v1l1 1 3 8zm14-25c0 1-1 1-1 2v1l8 17 1 1h2l1-1v-2l-8-17c-1 0-1 0-2-1h-1zM988 1240c-1 0-2 1-2 2-1 0-1 0-1 1v1c-1 1-1 2 0 3v2l5 8v1s1 0 1 1c1 0 1 1 2 1h4c1 0 1 0 2-1 1 0 2-1 2-2 1-1 1-1 1-2v-4l-1-1-4-8c0-1-1-1-1-2-1 0-2-1-2-1h-4c-1 0-1 0-2 1zm10 12v3l-1 1h-3l-1-1-4-8-1-1v-1s0-1 1-1c0 0 0-1 1-1h3l1 1 4 8zm12-25c-1 0-1 1-1 1v2l10 16h1c0 1 1 0 1 0 1 0 1 0 1-1v-2l-10-16h-1c-1-1-1 0-1 0zm21-14-3 3v6s1 0 1 1l5 8h1c0 1 0 1 1 1 0 1 1 1 2 1 1 1 1 1 2 0h2s1 0 1-1c1-1 2-1 3-2v-6l-1-1-5-8-2-2s-1 0-2-1h-2c-1 0-1 0-2 1h-1zm11 12v3s0 1-1 1l-1 1c-1 0-1 0-1-1h-1l-1-1-5-7v-3s0-1 1-1c0-1 1-1 1-1h1c1 0 1 1 1 1h1l5 8zm14-29c-1 1-2 1-2 2s0 1-1 1v4l1 1v1l5 8c1 0 1 1 1 1s1 0 1 1c1 0 1 0 2 1h3s1 0 1-1h2c1-1 1-2 2-3 0-1 1-2 1-2 0-1 0-2-1-3v-2l-6-8-1-1c-1-1-1-1-2-1-1-1-2-1-3 0h-1c-1 0-1 0-2 1zm11 11c0 1 1 1 1 1v2l-1 1c-1 1-1 1-2 1h-1l-1-1-5-8-1-1v-2s1 0 1-1h2c0-1 0-1 1 0h1v1l5 7zm9-26s-1 0-1 1c0 0 0 1 1 1l11 15c0 1 0 1 1 1h1c1-1 1-1 1-2v-1l-11-15c-1 0-1-1-2-1 0 0-1 0-1 1zm19-16c-1 0-1 1-2 2v5c0 1 1 1 1 1v1l6 7 1 1 1 1c1 0 1 1 2 1h3c0-1 1-1 1-1 1 0 1-1 2-1 1-1 1-2 2-2v-5c0-1 0-1-1-1v-1l-6-8c-1 0-1-1-2-1 0 0-1-1-2-1h-3s-1 0-1 1c-1 0-1 0-2 1zm13 10v3s0 1-1 1l-1 1h-1s-1 0-1-1h-1l-5-7-1-1v-2s0-1 1-1c0-1 1-1 1-1h2l1 1 6 7zm10-30c-1 1-2 2-2 3v5h1v1l7 7v1c1 0 1 0 1 1h3c0 1 1 1 2 0h2c0-1 1-1 1-1 1-1 2-2 2-3v-5l-1-1s0-1-1-1l-6-7s-1-1-2-1c0-1-1-1-2-1h-2c-1 0-1 1-2 1l-1 1zm13 10v3l-1 1s-1 0-1 1h-1c0-1-1-1-1-1l-7-7v-1c-1 0-1-1-1-1s0-1 1-1v-1c1-1 1-1 2-1h2v1l7 7zm8-31c-1 1-1 2-1 3l-1 1v2c0 1 1 1 1 2 0 0 0 1 1 1v1l7 6c0 1 1 1 1 1l1 1h5s1 0 1-1c0 0 1 0 1-1 1-1 2-2 2-3v-4c0-1-1-1-1-1 0-1 0-1-1-1l-6-7c-1 0-1-1-2-1-1-1-1-1-2-1s-2 0-3 1h-1c-1 0-1 1-2 1zm14 10v1c1 0 0 1 0 1v1c-1 1-1 1-2 1h-2v-1l-7-6v-1h-1v-2s1 0 1-1c1 0 1-1 1-1h1c1 0 1 0 1 1h1l7 7zm4-28c0 1-1 1-1 2l1 1 14 13h1c1 0 1 0 2-1v-1c0-1 0-1-1-1l-13-13h-3zm14-16v3l14 13h2s1 0 1-1v-2l-14-13h-3zm16-19c0 1-1 2-1 3v3c0 1 0 1 1 2 0 0 0 1 1 1v1l8 6c1 0 1 0 1 1h3c1 0 1 0 2-1h2c0-1 1-1 1-2 1-1 1-2 1-2 1-1 1-2 0-3v-2l-1-1c0-1-1-1-1-1l-7-6c-1 0-1-1-2-1h-5l-1 1c-1 0-1 1-2 1zm15 8v1h1v2l-1 1c-1 0-1 1-1 1h-2c-1 0-1-1-1-1l-7-6h-1v-3c1-1 1-1 2-1 0 0 0-1 1-1 0 1 0 1 1 1l8 6zm1-27v1c0 1 0 1 1 1l14 11c1 1 1 1 2 1l1-1c1 0 1-1 1-1 0-1-1-1-1-2l-15-11h-2s-1 0-1 1zm16-22c-1 1-1 2-2 3v2s0 1 1 1c0 1 0 2 1 2v1l1 1 8 5v1h1c1 1 2 1 3 1s2-1 2-1c1 0 1-1 2-1 0 0 0-1 1-1 1-1 1-2 1-3v-3c0-1 0-1-1-2l-1-1-8-6c-1 0-1-1-2-1h-5c0 1-1 1-1 1 0 1-1 1-1 1zm14 8h1v4c-1 0-1 0-1 1h-2l-1-1-8-5v-1c-1 0-1-1-1-1v-1s0-1 1-1c0-1 1-1 1-1l1-1c0 1 1 1 1 1h1l7 6zm0-28s-1 1 0 1v1l16 11h1c1 0 1 0 2-1v-1c0-1 0-1-1-2l-15-10h-2s-1 0-1 1zm13-21c0 1-1 2-1 3v1c1 0 1 1 1 1 0 1 0 2 1 2 0 1 0 1 1 1l1 1 8 5h2c0 1 1 1 2 0 1 0 2 0 3-1l1-1 1-1c0-1 1-2 1-3v-3c-1 0-1-1-2-2h-1v-1l-8-5c-1 0-2 0-2-1h-3c-1 0-1 1-2 1s-1 1-1 1l-2 2zm16 5v1s1 0 1 1v1s0 1-1 1c0 1 0 1-1 1 0 0 0 1-1 1l-1-1-8-5h-1c0-1 0-1-1-1v-1s0-1 1-1c0-1 0-1 1-2h2l1 1 8 4zm0-31c-1 1-1 2-1 3v3c1 0 1 1 2 2 1 0 1 1 1 1l9 4c0 1 0 1 1 1h3c1 0 2 0 3-1 0 0 0-1 1-1 0-1 0-1 1-2 0-1 1-2 1-3s-1-1-1-2-1-2-1-2l-1-1s-1 0-1-1l-8-4c-1 0-2-1-2-1h-3s-1 1-2 1l-1 1c-1 1-1 1-1 2zm15 5h1v1c1 0 1 1 1 1 0 1-1 1-1 2 0 0 0 1-1 1h-2l-9-5h-1v-3c0-1 1-1 1-1l1-1h1l1 1 8 4zm-3-28v1c0 1 1 1 1 2l16 8c1 0 1 1 2 0 0 0 1 0 1-1v-1c0-1 0-1-1-1l-16-9h-2s-1 0-1 1zm11-23v6l2 2v1h1l9 4 1 1h3c1-1 2-1 3-1 0-1 1-1 1-2l1-1c0-1 1-2 1-3s-1-2-1-3c0 0-1-1-1-2h-1l-1-1-9-4s-1 0-2-1c-1 0-1 0-2 1-1 0-2 0-3 1l-1 1s0 1-1 1zm16 5h1v1s1 0 1 1c0 0 0 1-1 1 0 1 0 1-1 1 0 1 0 1-1 1h-1l-9-4-1-1v-3c0-1 0-1 1-1l1-1h1l1 1 8 4zM1298 890c-1 1-1 2-1 3v2c1 0 1 0 1 1s1 1 1 2h1l1 1 9 3c0 1 1 1 1 1h3c1 0 2-1 3-2l1-1s0-1 1-1v-6l-2-2h-1c0-1-1-1-1-1l-8-3c-1-1-2-1-3-1h-2c-1 0-2 1-2 2-1 0-1 0-1 1-1 0-1 1-1 1zm16 4c1 0 1 0 1 1v2c0 1 0 1-1 2h-3l-8-4h-1s0-1-1-1v-2c1-1 1-1 1-2h3l9 4zm-5-31v4s0 1 1 1c0 1 1 2 1 2s1 0 1 1h1l9 3 1 1h1c1 0 2 0 2-1 1 0 2 0 3-1 0 0 0-1 1-1v-2c1-1 1-2 1-3s-1-2-1-3c0 0-1-1-2-1 0-1 0-1-1-1l-9-4h-5l-2 2-1 1s-1 1-1 2zm16 2 1 1 1 1v2l-1 1-1 1h-1s-1 0-1-1l-9-3h-1v-3c0-1 0-1 1-1 0-1 0-1 1-1h1l9 3zm-7-27v2c1 0 1 0 1 1l18 6h1c1 0 1-1 2-1 0-1 0-1-1-2 0 0 0-1-1-1l-17-6h-2l-1 1zm7-19c-1 0-1 1 0 1 0 1 0 1 1 1l18 6s1 0 1-1c1 0 1 0 1-1v-1c0-1-1-1-1-1l-18-6s-1 0-2 1v1zm7-24c-1 1-1 2 0 3v1c0 1 0 1 1 1 0 1 1 1 1 2h1c1 0 1 1 1 1l9 2h5l2-2 1-1c0-1 0-1 1-2v-3c0-1-1-2-1-2-1-1-1-2-2-2 0 0-1 0-1-1h-1l-9-2h-5l-2 2s0 1-1 1v2zm16 1h1v1c1 0 1 0 1 1v1c0 1-1 1-1 2h-3l-9-2s-1 0-1-1c0 0-1 0-1-1v-1c1-1 1-1 1-2h1c0-1 1-1 1 0h1l9 2zm-10-26v2c1 0 1 1 2 1l18 3c0 1 1 0 1 0 1 0 1-1 1-1v-2h-1l-18-4h-2l-1 1zm6-25v4c0 1 1 1 1 1 1 1 1 2 2 2h1c0 1 0 1 1 1l9 2h2c1 0 2-1 3-1l2-2v-1c1 0 1-1 1-2v-3c0-1-1-2-1-2l-2-2h-2l-9-2c-1 0-2-1-2 0h-3c0 1-1 1-2 2 0 0 0 1-1 1v2zm16 0 1 1h1v4c-1 0-1 1-1 1h-2l-9-2h-1l-1-1v-4h1c0-1 1-1 1-1l1 1 9 1zm-12-25c0 1 0 1 1 2l1 1 18 2h2l1-1c0-1 0-1-1-2h-1l-18-3h-2l-1 1zm4-24c0 1 0 2 1 3v1l1 1c1 1 1 1 2 1 0 1 1 1 1 1h1l9 1h3s1-1 2-1l2-2v-1c1-1 1-1 1-2v-3c-1-1-1-2-2-2 0-1-1-2-2-2h-2l-9-1h-3s-1 0-2 1l-2 2v1c-1 0-1 1-1 2zm17-1h1l1 1v2s0 1-1 1v1h-2l-9-1h-2v-1h-1v-2c0-1 0-1 1-1v-1h2l10 1zm-13-29v3c0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 2 2h2l9 1h1c1 0 1 0 1-1 1 0 2 0 3-1 0 0 1-1 1-2 1 0 1 0 1-1v-5c0-1-1-1-2-2 0-1-1-1-2-1l-1-1h-12c-1 0-2 0-3 1 0 0-1 1-1 2-1 0-1 1-1 1v2zm16-2h1s0 1 1 1v1s1 1 0 1v2h-1c0 1 0 1-1 1l-10-1h-2v-4c0-1 1-1 1-1h11zm-14-24v2h2l18 1h2v-3l-1-1-19-1c-1 0-1 0-2 1v1zm1-25v3c0 1 1 1 1 1 0 1 1 1 1 1l2 2h14c1-1 1-1 2-1 1-1 1-2 2-2v-7l-2-2s-1-1-2-1h-14s-1 0-2 1l-2 2v3zm16-2h1c1 0 1 0 1 1v3l-1 1h-12l-1-1v-3c0-1 0-1 1-1h1v-1l10 1zm-16-28v4c1 0 1 0 1 1 1 0 1 0 1 1 1 0 2 0 2 1h12s1 0 1-1h1c1 0 2-1 2-1l2-2v-6c-1-1-1-2-2-2l-2-2h-2l-10 1h-2c-1 0-1 1-2 1l-2 2v3zm16-3h1l1 1c0 1 1 1 1 2l-1 1v1c-1 0-1 0-1 1h-12l-1-1v-3c0-1 0-1 1-1h1l10-1zm-17-26v3c1 0 1 1 1 1 1 0 1 1 1 1 1 0 2 1 2 1h3l9-1h2c1-1 2-1 2-2 1 0 1-1 2-2v-3c0-1 0-2-1-3 0-1-1-2-1-2-1 0-2-1-3-1h-2l-9 1h-2c-1 0-2 1-2 2-1 0-2 1-2 2v3zm15-4h2s1 0 1 1v3l-1 1h-1l-10 1h-1c-1 0-1-1-1-1v-1c-1-1 0-2 0-2v-1h2l9-1zm-17-21v1c1 1 1 1 2 1l19-3h1v-3c-1-1-1-1-2-1l-19 3-1 1v1zm-3-21 1 1c1 1 1 1 2 1l18-3c1 0 1 0 2-1v-1c0-1 0-1-1-1 0-1-1-1-1-1l-19 3s-1 0-1 1c0 0-1 0-1 1zm-3-25c0 2 0 3 1 3 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 2 1h2l10-2h1l1-1c1 0 1 0 2-1 0-1 1-2 1-2v-4c0-1 0-2-1-3 0 0-1-1-2-1-1-1-1-1-2-1h-2l-10 2h-2c0 1-1 1-2 2 0 0-1 1-1 2v3zm15-5h2s1 0 1 1v4h-2l-9 2h-2l-1-1v-4h2l9-2zm-20-19c0 1 1 1 1 1 1 1 1 1 2 1l18-5c1 0 1 0 1-1 1 0 1-1 1-1 0-1-1-1-1-1-1-1-1-1-2-1l-18 5c-1 0-1 0-1 1-1 0-1 1-1 1zm-5-24c0 1 1 2 2 3l1 1h1s1 1 2 1h1s1 0 1-1l9-2c1 0 1 0 1-1h1c1-1 2-1 2-2 1 0 1-1 1-2v-3c0-2-1-3-1-3-1-1-2-1-2-2h-5l-9 3h-2l-2 2c0 1-1 2-1 3v3zm15-7h3v2s1 1 0 1v1l-1 1h-1l-9 3h-1c-1 0-1-1-1-1-1 0-1-1-1-1v-3h1l1-1 9-2zm-21-18s0 1 1 1h1l18-5c1 0 1 0 1-1 1 0 1-1 1-1 0-1-1-1-1-2h-2l-18 5-1 1v2zM1326 388c1 1 1 2 2 3 0 0 1 0 1 1h1c1 1 2 1 3 1h1s0-1 1-1l9-3h1l1-1 1-1c1-1 1-2 1-3v-3c0-1-1-2-1-3-1-1-2-1-3-1 0-1-1-1-2-1h-1c-1 0-1 1-1 1l-9 3c-1 0-2 0-2 1-1 0-1 1-2 1 0 1-1 2-1 3v3zm15-8h2s0 1 1 1v1c1 1 1 1 1 2-1 0-1 0-1 1h-1v1l-9 3h-2l-1-1s-1 0-1-1v-2l1-1 1-1 9-3zm-24-20c0 2 1 2 2 3 0 0 0 1 1 1h1c1 1 1 1 2 1s1 0 1-1h1l9-3c1 0 1-1 1-1h1c1-1 1-2 2-2 0-1 0-2 1-3v-1c0-1-1-1-1-2s-1-2-2-3c0 0-1-1-2-1h-4l-9 4c-1 0-2 0-2 1-1 0-1 1-2 2 0 0 0 1-1 2v2l1 1zm14-8h3v1c1 1 1 2 1 2s0 1-1 1v1h-1l-9 3-1 1h-1s0-1-1-1v-1c-1-1-1-1-1-2 0 0 1 0 1-1l1-1 9-3zm-23-15c0 1 0 1 1 2 0 0 1 0 1-1l18-7c0-1 0-1 1-1v-2l-1-1h-2l-17 8c-1 0-1 0-1 1v1zm-10-22c1 1 1 2 2 2 0 1 1 1 1 1h1c1 1 2 1 3 0h2l8-5h1c1 0 1-1 1-1 1 0 1-1 2-2v-4s0-1-1-2c0-1-1-2-1-2-1-1-2-1-3-1h-3c-1 0-1 0-1 1l-9 4s-1 1-2 1c0 1-1 1-1 2s-1 2-1 3v1c1 1 1 1 1 2zm13-10h3l1 1v3l-1 1-9 4v1h-1c-1 0-1-1-1-1-1 0-1 0-1-1-1 0-1-1-1-1 0-1 0-1 1-1v-1l1-1 8-4zm-26-16c1 1 2 1 2 2 1 0 1 0 2 1h3c1 0 1 0 1-1h1l9-5h1v-1l2-2v-4c0-1-1-1-1-2s-1-2-2-2c-1-1-2-1-2-1h-4l-1 1-8 4-2 2s-1 1-1 2c-1 1-1 1-1 3l1 1v2zm13-11h3s0 1 1 1v3h-1v1l-9 5h-2c-1 0-1-1-1-1-1-1-1-1-1-2v-1c1 0 1-1 1-1h1l8-5zm-27-16c0 1 1 2 2 2 0 1 0 1 1 1h5l1-1 8-4c0-1 1-1 1-1l1-1s1-1 1-2v-6c-1-1-2-1-3-2 0 0-1-1-2-1h-2c-1 0-1 0-1 1h-1l-9 5-1 1-2 2v4c0 1 0 1 1 2zm12-11h3l1 1c0 1 1 1 1 2l-1 1v1h-1l-8 5h-3s-1 0-1-1v-3h1v-1l8-5zm-25-10s0 1 1 1h1l16-11c1 0 1 0 1-1v-1c0-1-1-1-1-1h-2l-16 10v2c-1 0-1 1 0 1zm-11-17c0 1 1 1 1 1h2l15-11 1-1v-2c-1 0-1-1-2-1 0 0-1 0-1 1l-16 11v1c-1 1 0 1 0 1zm-14-20c1 1 1 2 2 2l1 1h4l1-1s1 0 1-1l8-6c1 0 1-1 1-1 1-1 1-2 1-2v-4c-1-1-1-1-1-2-1-1-2-2-3-2s-1-1-2-1-2 1-3 1h-1c0 1 0 1-1 1l-7 6c-1 0-1 1-2 2v2c-1 1-1 2-1 3 0 0 1 0 1 1 0 0 0 1 1 1zm11-12h1v-1c1 0 1 0 2 1l1 1v3h-1l-7 6-1 1h-2l-1-1c0-1-1-1-1-1v-2h1v-1l8-6zm-27-8c0 1 1 1 1 1 1 0 1 0 2-1l15-11v-2c1 0 0-1 0-1 0-1-1-1-1-1-1 0-1 0-2 1l-15 11v3zm-16-18c1 0 2 1 3 1 0 1 1 1 1 1h1c1 0 2 0 3-1h1s0-1 1-1l7-6c0-1 0-1 1-1v-1c1-1 1-1 1-2v-3s0-1-1-1v-2c-1-1-2-1-3-2h-3s-1 0-2 1h-1l-1 1-7 6c-1 1-1 1-1 2-1 0-1 1-1 2-1 1 0 2 0 3v1c1 1 1 1 1 2zm11-13v-1h2c1 0 1 0 2 1v3l-1 1-7 6-1 1h-2s0-1-1-1v-1c-1-1-1-1 0-2l1-1 7-6zm-27-6c0 1 1 1 1 1 1 0 1 0 2-1l13-13c1 0 1-1 1-1 0-1 0-1-1-2h-2l-14 14s-1 0-1 1 0 1 1 1zm-17-17c1 1 2 1 2 2h3c1 0 2-1 2-1 1 0 1-1 1-1h1l7-8 1-1c0-1 0-2 1-3 0-1-1-1-1-2s0-1-1-2c0 0 0-1-1-1l-2-2h-3c-1 0-2 1-2 1-1 0-1 0-1 1-1 0-1 0-1 1l-6 7c-1 0-1 1-2 1v5c0 1 0 1 1 2 0 0 0 1 1 1zm9-14 1-1h1c1 0 1 1 2 1 0 0 0 1 1 1v1c0 1-1 1-1 1v1l-7 7s0 1-1 1h-1c-1 0-1-1-2-1v-1l-1-1 1-1v-1l7-7zm-31-7c0 1 1 2 2 2h3c1 0 2 0 2-1h1c0-1 1-1 1-1l6-7 1-1 1-1v-5s0-1-1-1c0-1 0-1-1-2-1 0-2-1-3-1h-4l-1 1c-1 0-1 1-1 1l-7 7s-1 1-1 2c0 0 0 1-1 2 0 1 0 2 1 3v1c1 1 1 1 2 1zm9-13v-1h4v2c1 0 1 0 0 1v1l-7 7v1h-2c-1 0-1 0-2-1l-1-1v-1l1-1 7-7zm-28-2h1c1 0 1 0 2-1l12-14v-3h-3l-12 15c-1 0-1 1-1 1 0 1 0 1 1 2zm-19-15c1 1 2 1 3 1h2c1 0 2-1 2-1 1 0 1-1 1-1s1 0 1-1l6-7v-1c0-1 1-1 1-1v-3c0-1 0-1-1-2v-2c-1 0-1 0-2-1-1 0-2-1-3-1h-2c-1 0-2 1-2 1-1 0-1 1-1 1l-1 1-6 7c0 1 0 2-1 2v3c0 1 0 2 1 2v2c1 0 1 0 2 1zm7-15h1v-1h3c1 1 1 1 1 2v2h-1l-5 8-1 1h-3c0-1-1-1-1-2v-2h1l5-8zm-31-2c1 1 2 1 3 1h3c0-1 1-1 2-1 0-1 0-1 1-1v-1l6-8v-1s0-1 1-1v-3s-1-1-1-2l-1-1c0-1-1-1-1-1-1-1-2-1-3-1-1-1-2 0-3 0s-1 0-2 1l-1 1v1l-6 8s0 1-1 2v2c0 1 0 2 1 3l1 1 1 1zm7-15v-1h1l1-1c1 0 1 1 2 1 0 0 0 1 1 1v2l-1 1-5 8-1 1h-3c0-1-1-1-1-1v-3h1l5-8zm-31-1c1 1 2 1 3 1h2c1-1 2-1 2-2 1 0 1 0 1-1h1l5-9v-1l1-1v-2c0-1-1-2-1-3 0 0-1 0-1-1-1 0-1-1-2-1s-2-1-3-1-1 0-2 1c-1 0-2 0-2 1 0 0-1 0-1 1l-1 1-5 8v2c-1 1-1 2 0 2v3c1 0 1 1 1 1 1 0 1 1 2 1zm6-15v-1s1 0 1-1h1s1 0 1 1c1 0 1 0 2 1v2h-1l-5 9v1h-3l-1-1-1-1c0-1 0-1 1-1v-1l5-8zM1038 33h1c1 0 1 0 1-1l10-16v-2l-1-1h-1c-1 0-1 0-1 1l-10 16v2s0 1 1 1z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl82;
