import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl60 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={1400}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 99 60"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl60_svg__id0"
          gradientUnits="userSpaceOnUse"
          x1={0}
          y1={30.075}
          x2={98.812}
          y2={30.075}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl60_svg__id1"
          gradientUnits="userSpaceOnUse"
          x1={12.935}
          y1={60.267}
          x2={85.742}
          y2={-6.274}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "black",
            }}
          />
          <stop
            offset={0.58}
            style={{
              stopOpacity: 1,
              stopColor: "#7f7f7f",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "white",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl60_svg__id2"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl60_svg__id0"
          x1={5.178}
          y1={29.4}
          x2={5.311}
          y2={29.4}
        />
        <linearGradient
          id="CyberEl60_svg__id3"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl60_svg__id0"
          x1={58.03}
          y1={57.149}
          x2={70.837}
          y2={57.149}
        />
        <linearGradient
          id="CyberEl60_svg__id4"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl60_svg__id0"
          x1={2.003}
          y1={29.4}
          x2={2.136}
          y2={29.4}
        />
        <style>{".CyberEl60_svg__fil5{fill:#202020;fill-rule:nonzero}"}</style>
      </defs>
      <g id="CyberEl60_svg__Vrstva_x0020_1">
        <g id="CyberEl60_svg___2610578993984">
          <path
            d="M74 4H11v31c0 1-1 3-2 4l-5 5v2h37c1 0 2 0 3 1l3 3h45V37c0-1 1-2 2-3v-1c1 0 1-1 1-1v-7c0-1 0-2-1-3L77 5c-1-1-2-1-3-1z"
            style={{
              fill: "url(#CyberEl60_svg__id1)",
            }}
          />
          <path
            style={{
              fill: "url(#CyberEl60_svg__id2)",
            }}
            d="M6 39H5V20h1z"
          />
          <path
            style={{
              fill: "url(#CyberEl60_svg__id4)",
            }}
            d="M2 42V17z"
          />
          <path
            d="M78 58h11-11l-1-1-1-1H40v1h36l1 1h1z"
            style={{
              fill: "url(#CyberEl60_svg__id3)",
            }}
          />
          <path
            d="M3 43c-1 0-1 1-1 2v1c0 1 1 1 1 1h38c1 0 2 1 2 1l3 3 1 1h34l11-1c1 0 2 0 2-2V37c0-1 0-2 1-2l1-1v-9c0-2 0-3-1-4L78 4c-1-1-2-2-4-2H11c-1 0-2 1-2 2v31c0 1 0 2-1 3l-5 5zM87 5h-5l13 12v-5l-8-7zM1 18c-1-1-1-2-1-4V4c0-2 2-4 4-4h70c2 0 4 1 6 2h5-1c-1-1 0-2 1-2h13s1 0 1 1v13c0 1-1 2-2 1v-1 6c1 1 2 3 2 5v31c0 3-2 4-4 4h-5c-1 0-3 0-4-1l-4-4c0-1-1-1-2-1H49h4-7l-4 5c-1 1-2 1-4 1H4c-2 0-4-1-4-4V45c0-2 0-3 1-4l6-5V25c0-1 0-2-1-2l-5-5z"
            style={{
              fill: "url(#CyberEl60_svg__id0)",
            }}
          />
          <path
            className="CyberEl60_svg__fil5"
            d="M33 58h3l7-7c0-1 0-1-1-1h-3l-6 7v1zM28 58h2l7-7c0-1 0-1-1-1h-3l-6 7s0 1 1 1zM22 58h3l6-7c0-1 0-1-1-1h-2l-7 7s0 1 1 1zM16 58h3l6-7v-1h-3l-7 7s0 1 1 1zM10 58h3l6-7c1-1 0-1 0-1h-3l-7 7s0 1 1 1z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl60;
