import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl58 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={440}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 129 25"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl58_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={64.476}
          y1={4.445}
          x2={64.476}
          y2={20.251}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
        </linearGradient>
      </defs>
      <path
        d="m16 20 2 1H6l8-9c1 0 1-1 2-1h6l-6 8v1z"
        style={{
          fill: "#000",
        }}
      />
      <path
        d="M27 19v1l1 1h-9l-2-2 6-7v-1h10l-6 8z"
        style={{
          fill: "#1a1a1a",
        }}
      />
      <path
        d="M37 19s0 1 1 1l1 1h-9l-2-2 6-7v-1h10l-7 8z"
        style={{
          fill: "#333",
        }}
      />
      <path
        d="M52 21H41l-2-2 6-7v-1h12l-7 8s0 1 1 1l1 1z"
        style={{
          fill: "#4d4d4d",
        }}
      />
      <path
        d="m61 20 2 1h-9l-2-2 6-7v-1h10l-7 8v1z"
        style={{
          fill: "#666",
        }}
      />
      <path
        d="M74 21h-9l-3-2 7-7v-1h10l-7 8v1l2 1z"
        style={{
          fill: "gray",
        }}
      />
      <path
        d="M85 21H75l-2-2 7-7v-1h9l-6 8v1l2 1z"
        style={{
          fill: "#999",
        }}
      />
      <path
        d="m111 11-6 8v1l1 1h-9l-2-2 6-7v-1h10z"
        style={{
          fill: "#ccc",
        }}
      />
      <path
        d="M114 21h-6l-2-2 6-7v-1h11l-9 10z"
        style={{
          fill: "#e6e6e6",
        }}
      />
      <path
        d="M96 21H86l-2-2 7-7v-1h9l-6 8v1l2 1z"
        style={{
          fill: "#b3b3b3",
        }}
      />
      <path
        d="m2 24 10-13c1-1 3-2 4-2h111l-12 15H2zm114 1 13-16V8H80c-1 0-2 0-2-1l-6-6c-1-1-2-1-3-1H15c-1 0-2 1-3 2L7 7c-1 1-1 2-1 3v5c0 2-1 3-2 4l-4 5c0 1 0 1 1 1h115z"
        style={{
          fill: "url(#CyberEl58_svg__a)",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl58;
