import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl40 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2184}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 99 94"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl40_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={45.795}
          y1={54.192}
          x2={53.012}
          y2={54.192}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl40_svg__e"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl40_svg__a"
          x1={32.441}
          y1={66.391}
          x2={33.772}
          y2={66.391}
        />
        <linearGradient
          id="CyberEl40_svg__b"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl40_svg__a"
          x1={46.441}
          y1={46.92}
          x2={52.37}
          y2={46.92}
        />
        <linearGradient
          id="CyberEl40_svg__d"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl40_svg__a"
          x1={65.558}
          y1={66.391}
          x2={66.622}
          y2={66.391}
        />
        <linearGradient
          id="CyberEl40_svg__c"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl40_svg__a"
          x1={48.52}
          y1={33.305}
          x2={49.916}
          y2={33.305}
        />
      </defs>
      <path
        d="M51 83v-5c0-1-1-2-2-2s-1 1-1 2v5H5l20-36 5 3h2c0-1 0-2-1-3l-4-3L49 5l23 39-5 3c-1 1-1 2 0 3h2l5-3 20 36H51zm48 1L77 45l4-3c1 0 1-1 1-2-1-1-2-1-3 0l-4 3L51 1c0-1-1-1-2-1 0 0-1 0-1 1L24 43l-5-3c-1-1-2-1-2 0-1 1 0 2 0 2l5 4L0 84v1c1 1 1 1 2 1h46v6c0 1 0 2 1 2s2-1 2-2v-6h46c1 0 1 0 2-1v-1z"
        style={{
          fill: "url(#CyberEl40_svg__b)",
        }}
      />
      <path
        d="M56 32H42c-1 0-2 0-2 1s1 2 2 2h14c1 0 2-1 2-2s-1-1-2-1z"
        style={{
          fill: "url(#CyberEl40_svg__c)",
        }}
      />
      <path
        d="M72 60h-2L60 70c-1 1-1 2 0 3h2l10-10c1-1 1-2 0-3z"
        style={{
          fill: "url(#CyberEl40_svg__d)",
        }}
      />
      <path
        d="M29 60h-2c-1 1-1 2 0 3l10 10h2c1-1 1-2 0-3L29 60z"
        style={{
          fill: "url(#CyberEl40_svg__e)",
        }}
      />
      <path
        d="M53 54c0 2-2 4-4 4s-3-2-3-4 1-3 3-3 4 1 4 3z"
        style={{
          fill: "url(#CyberEl40_svg__a)",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl40;
