import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl35 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2002}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 232 202"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl35_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={113.283}
          y1={23.251}
          x2={118.072}
          y2={23.251}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl35_svg__b"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl35_svg__a"
          x1={113.283}
          y1={177.475}
          x2={118.072}
          y2={177.475}
        />
      </defs>
      <path
        d="M174 167c-2-1-5 0-6 2l-7 11H70l-7-11c-1-2-3-3-5-2s-3 4-2 6l8 13c0 1 2 2 3 2h97c1 0 2 0 3-2l8-13c1-2 0-5-1-6z"
        style={{
          fill: "url(#CyberEl35_svg__b)",
        }}
      />
      <path
        d="M167 14c-1-1-2-2-3-2H67c-1 0-3 1-3 3l-8 13c-1 2 0 4 2 6h2c1 0 3-1 3-2l7-12h91l7 12c1 2 4 3 6 1 1-1 2-3 1-5l-8-14z"
        style={{
          fill: "url(#CyberEl35_svg__a)",
        }}
      />
      <path
        d="M169 194H62l-51-89h10l10 15c1 2 2 2 4 2h2c2-2 2-4 1-6l-10-15 10-15c1-1 1-4-1-5s-4-1-6 1L21 97H11L62 8h107l52 89h-10l-10-15c-1-2-4-2-5-1-2 1-3 4-2 5l10 15-9 14c-2 2-1 4 1 6h2c1 0 3 0 3-2l10-14h10l-52 89zm63-93c0-1-1-2-1-3L175 2c-1-1-2-2-3-2H60c-2 0-3 1-4 2L1 99H0v3c0 1 0 1 1 1l55 97c1 1 2 2 4 2h112c1 0 2-1 3-2l56-97s1-1 1-2z"
        style={{
          fill: "#666",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl35;
