import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl24 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2300}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 327 327"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl24_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={44.362}
          y1={43.776}
          x2={109.736}
          y2={43.776}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl24_svg__d"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl24_svg__a"
          x1={163.436}
          y1={237.275}
          x2={311.112}
          y2={237.275}
        />
        <linearGradient
          id="CyberEl24_svg__b"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl24_svg__a"
          x1={124.211}
          y1={163.436}
          x2={202.661}
          y2={163.436}
        />
        <linearGradient
          id="CyberEl24_svg__c"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl24_svg__a"
          x1={127.849}
          y1={163.435}
          x2={199.026}
          y2={163.435}
        />
      </defs>
      <path
        d="M163 327C73 327 0 254 0 163c0-42 16-83 46-113l4 4C22 83 6 122 6 163c0 87 71 158 157 158 87 0 158-71 158-158C321 77 250 6 163 6c-24 0-47 5-68 16l-3-6c22-11 46-16 71-16 91 0 164 73 164 163 0 91-73 164-164 164z"
        style={{
          fill: "url(#CyberEl24_svg__b)",
        }}
      />
      <path
        d="M32 163c0-8 1-16 3-24l25 25-25 25c-2-8-3-17-3-26zm44 1-38 38c-1-3-1-5-2-8l29-28v-4l-29-28c0-3 1-5 2-8l38 38zm87-137c-20 0-39 4-57 12l2 6c17-8 36-13 55-13 73 0 131 59 131 131 0 73-58 131-131 131-57 0-106-36-123-88l40-40c1-1 1-2 0-3l-41-41c6-18 16-35 29-49l-4-4c-24 26-37 59-37 94 0 76 61 137 136 137 76 0 137-61 137-137 0-75-61-136-137-136z"
        style={{
          fill: "url(#CyberEl24_svg__c)",
        }}
      />
      <path
        d="M77 17c-15 0-27 12-27 27s12 27 27 27 27-12 27-27-12-27-27-27zm0 59c-18 0-33-14-33-32s15-33 33-33 33 15 33 33-15 32-33 32z"
        style={{
          fill: "url(#CyberEl24_svg__a)",
        }}
      />
      <path
        d="M163 311v-29c66 0 119-53 119-119h29c0 82-66 148-148 148z"
        style={{
          fill: "url(#CyberEl24_svg__d)",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl24;
