import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl21 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2300}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 2233 2233"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl21_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={163.397}
          y1={1116.55}
          x2={2069.7}
          y2={1116.55}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl21_svg__b"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl21_svg__a"
          x1={514.005}
          y1={1607.15}
          x2={1721.3}
          y2={1607.15}
        />
        <linearGradient
          id="CyberEl21_svg__c"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl21_svg__a"
          x1={511.736}
          y1={587.133}
          x2={1719.03}
          y2={587.133}
        />
      </defs>
      <path
        d="M1117 2102c-544 0-986-442-986-985 0-544 442-986 986-986 543 0 985 442 985 986 0 543-442 985-985 985zm1116-985c0-123-20-244-59-359l-90 30c-102-299-338-536-637-638l30-90c-116-40-237-60-360-60-124 0-245 20-361 60l30 90C487 252 251 489 149 788l-90-30C20 873 0 994 0 1117c0 122 20 243 59 358l90-30c102 300 339 537 639 639l-30 90c115 39 236 59 359 59 122 0 243-20 358-59l-30-90c300-102 537-339 639-639l90 30c39-115 59-236 59-358z"
        style={{
          fill: "#1a1a1a",
        }}
      />
      <path
        d="M272 1117c0-466 379-845 845-845 465 0 844 379 844 845 0 465-379 844-844 844-466 0-845-379-845-844zm1725 0c0-486-395-881-880-881v-73c-526 0-954 428-954 954h73c0 485 395 880 881 880v73c525 0 953-428 953-953h-73z"
        style={{
          fill: "url(#CyberEl21_svg__a)",
        }}
      />
      <path
        d="M1119 1792c-3 0-5-1-7-2l-591-338c-7-4-9-12-5-19s12-9 18-5l585 335 582-339c6-4 15-2 18 5 4 7 2 15-5 19l-588 342c-2 1-5 2-7 2z"
        style={{
          fill: "url(#CyberEl21_svg__b)",
        }}
      />
      <path
        d="M525 772c-4 0-9-2-11-7-4-6-2-15 5-18l588-343c5-2 10-2 14 0l591 339c7 3 9 12 5 18-4 7-12 9-18 5l-585-334-582 338c-2 1-4 2-7 2z"
        style={{
          fill: "url(#CyberEl21_svg__c)",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl21;
