import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl11 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2302}
      height={2333}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 2235 2265"
      {...props}
    >
      <defs>
        <clipPath
          id="CyberEl11_svg__id0"
          style={{
            clipRule: "nonzero",
          }}
        >
          <path d="M71 2144H58v-16h13v16z" />
        </clipPath>
        <style>
          {
            ".CyberEl11_svg__fil0,.CyberEl11_svg__fil1,.CyberEl11_svg__fil2{fill:#4d4d4d;fill-rule:nonzero}.CyberEl11_svg__fil0,.CyberEl11_svg__fil2{fill:#666}.CyberEl11_svg__fil2{fill:#999}"
          }
        </style>
      </defs>
      <g id="CyberEl11_svg__Vrstva_x0020_1">
        <g id="CyberEl11_svg___2610739849072">
          <path
            className="CyberEl11_svg__fil0"
            d="M1980 1205c-1 13-3 25-4 37l9 1c2-12 3-24 4-37l-9-1zm-10 73c-2 12-4 24-7 36l10 2c3-12 5-24 7-37l-10-1zm-15 71c-3 12-6 23-10 35l9 3c4-12 7-24 10-36l-9-2zm-22 70c-4 11-8 23-13 34l9 3c5-11 9-22 14-34l-10-3zm-27 67c-5 11-10 22-16 33l9 5c5-11 11-22 16-34l-9-4zm-33 65c-6 11-13 21-19 32l8 5c7-11 13-21 19-32l-8-5zm-39 62-21 30 8 6 21-30-8-6zm-44 58c-7 10-15 19-23 28l7 7c8-10 16-19 24-28l-8-7zm-48 55c-9 8-17 17-26 25l6 7c9-8 18-17 27-25l-7-7zm-53 50c-10 8-19 15-28 23l6 8c9-8 19-16 28-24l-6-7zm-57 45-30 21 5 8 30-21-5-8zm-61 40c-10 6-21 12-32 18l5 9c11-6 21-12 32-18l-5-9zm-64 35c-11 5-22 11-33 15l4 9 33-15-4-9zm-66 29c-12 5-23 9-35 13l3 9c12-4 24-8 35-13l-3-9zm-69 24-36 9 3 10c12-3 24-7 35-10l-2-9zm-71 17c-12 2-24 5-36 7l1 9c13-2 25-4 37-6l-2-10zm-72 11c-12 2-24 3-36 4v9c12 0 25-2 37-3l-1-10zm-73 5c-8 1-15 1-23 1h-13v9h36v-10zm-73-1c-12 0-24-1-36-3l-1 10c12 1 24 2 37 3v-10zm-72-7-36-6-2 10 36 6 2-10zm-72-13c-12-3-23-6-35-9l-3 9 36 9 2-9zm-70-20c-12-4-23-8-35-12l-3 9c12 4 23 8 35 12l3-9zm-68-26c-12-4-23-9-34-15l-4 9c11 5 22 11 34 15l4-9zm-66-31c-11-6-22-12-32-18l-5 9c10 6 21 12 32 18l5-9zm-63-37c-10-7-21-13-30-20l-6 8c10 7 20 14 30 20l6-8zm-60-42c-9-8-19-15-28-23l-6 7c9 8 19 16 28 24l6-8zm-55-47c-9-8-18-17-27-25l-7 6c9 9 18 18 27 26l7-7zm-52-52-24-27-7 6c8 9 16 19 24 28l7-7zm-47-56c-7-9-14-19-21-29l-8 6c7 10 14 20 22 29l7-6zm-42-59c-6-10-12-21-18-31l-9 5c6 10 13 21 19 31l8-5zm-36-63c-6-11-11-22-16-33l-9 5c5 11 11 22 16 33l9-5zm-31-66c-5-11-9-22-14-34l-9 4c5 11 9 23 14 34l9-4zm-25-68c-4-12-8-23-11-35l-9 3c3 12 7 23 10 35l10-3zm-20-70c-3-12-5-24-7-36l-10 2c2 12 5 24 8 36l9-2zm-13-72c-2-12-3-24-4-36l-10 1c1 12 3 24 4 37l10-2zm-7-72c-1-12-1-25-1-37h-10c0 13 0 25 1 37h10zm-1-73c0-12 1-25 2-37h-10c-1 12-1 24-2 36l10 1zm5-73c2-12 3-24 5-36l-9-2c-2 13-4 25-5 37l9 1zm12-72c2-12 5-24 8-35l-10-3c-3 12-5 24-8 36l10 2zm17-71c4-11 7-23 11-34l-9-3c-4 11-8 23-11 35l9 2zm24-69c4-11 9-22 14-33l-9-4c-5 11-10 22-14 34l9 3zm30-66c5-11 11-22 16-33l-8-4c-6 10-12 21-17 32l9 5zm35-64c6-11 13-21 19-31l-8-5c-7 10-13 20-20 31l9 5zm40-61c7-10 15-19 22-29l-7-6c-8 10-15 19-23 29l8 6zm46-57 24-27-7-6c-8 8-16 18-25 27l8 6zm50-53 27-24-7-8c-9 8-18 17-27 25l7 7zm54-48c10-8 19-15 29-22l-6-8c-9 7-19 15-29 22l6 8zm59-44c10-6 20-13 30-19l-5-9c-10 7-20 14-31 20l6 8zm62-38c10-6 21-12 32-17l-5-9c-11 6-21 12-32 18l5 8zm65-33c11-5 22-10 33-14l-4-9c-11 5-22 9-33 14l4 9zm67-27c11-4 23-8 35-11l-3-10c-12 4-24 8-35 12l3 9zm70-21c11-3 23-6 35-9l-2-9c-12 2-24 5-36 8l3 10zm71-15c12-3 24-4 36-6l-1-9c-12 1-25 3-37 5l2 10zm72-10c12-1 24-1 37-2l-1-9c-12 0-24 1-37 2l1 9zm73-2h36l1-9c-12-1-25-1-37-1v10zm73 3c12 1 24 2 36 4l1-10c-12-1-24-3-36-4l-1 10zm72 9c12 2 24 5 36 7l2-9c-12-3-24-5-36-7l-2 9zm71 16c12 3 24 6 35 10l3-9c-12-4-23-7-35-10l-3 9zm70 22c11 4 23 8 34 13l4-9c-12-5-23-9-35-13l-3 9zm67 27c12 5 22 11 33 16l5-8c-11-6-22-11-33-16l-5 8zm65 34c11 6 21 12 32 19l5-9c-11-6-21-13-32-19l-5 9zm62 39 30 21 6-8-30-21-6 8zm58 44c10 7 19 15 28 23l6-7c-9-8-18-16-28-24l-6 8zm54 48 26 26 7-6c-8-9-17-18-26-27l-7 7zm50 53c8 10 16 19 23 29l8-6c-8-10-15-20-23-29l-8 6zm45 58c8 10 14 19 21 30l8-6-21-30-8 6zm40 60c7 11 13 21 18 32l9-5c-6-10-12-21-18-32l-9 5zm35 64 15 33 9-3c-5-12-10-23-15-34l-9 4zm29 67c5 11 9 23 13 34l9-3c-4-11-8-23-13-34l-9 3zm23 69c4 12 7 23 10 35l9-2-9-36-10 3zm18 71 6 36 9-2c-1-12-3-24-6-36l-9 2zm11 72 3 36h10c-1-13-2-25-4-37l-9 1zm4 73c1 7 1 14 1 21 0 12-1 24-1 36l10 1v-59l-10 1z"
          />
          <path
            className="CyberEl11_svg__fil0"
            d="M1932 1133h-4c0 219-89 418-233 562s-343 233-562 233c-220 0-419-89-563-233-143-144-232-343-232-562 0-220 89-419 232-563 144-143 343-232 563-232 219 0 418 89 562 232 144 144 233 343 233 563h9c0-444-360-804-804-804s-804 360-804 804 360 804 804 804 804-360 804-804h-5z"
          />
          <path
            className="CyberEl11_svg__fil1"
            d="M1914 1133c0 215-88 411-229 552s-337 229-552 229v37c451 0 818-367 818-818h-37z"
          />
          <path
            className="CyberEl11_svg__fil0"
            d="M352 1133c0-216 87-411 228-553 142-141 337-228 553-228v-37c-452 0-818 366-818 818h37z"
          />
          <path
            className="CyberEl11_svg__fil0"
            d="M2223 1133h-12c0 297-121 567-316 762s-465 316-762 316c-298 0-568-121-763-316S54 1430 54 1133c0-298 121-568 316-763S835 54 1133 54c297 0 567 121 762 316s316 465 316 763h24c0-609-493-1103-1102-1103S30 524 30 1133s494 1102 1103 1102 1102-493 1102-1102h-12z"
          />
          <path
            className="CyberEl11_svg__fil2"
            d="M1853 1675c-165 219-426 360-720 360-250 0-475-101-638-265-163-163-264-388-264-637 0-141 32-275 90-394l-73-35c-63 130-98 275-98 429 0 271 110 517 288 695 177 177 423 288 695 288 320 0 605-154 785-392l-65-49z"
          />
          <path
            d="M439 556c166-199 415-325 694-325 249 0 474 101 637 264 164 163 265 388 265 638 0 62-7 123-19 181l80 17c13-64 20-131 20-198 0-272-111-518-288-695-178-178-424-288-695-288-304 0-576 138-756 354l62 52z"
            style={{
              fill: "#333",
              fillRule: "nonzero",
            }}
          />
          <path
            d="M1133 386v184h1V386h-1zm21 0-5 184c3 1 7 1 10 1l8-184h-7c-2 0-4 0-6-1zm34 2-14 184c4 0 7 0 10 1l17-184c-4 0-9-1-13-1zm33 3-21 183c3 1 6 1 9 1l25-182c-2 0-4-1-6-1h-2c-1 0-3 0-4-1h-1zm33 5-29 182c3 0 6 1 9 1l33-181c-2 0-3 0-5-1h-1c-2 0-4-1-7-1zm33 6-38 180c4 1 7 2 10 2l41-179c-1 0-2 0-3-1h-3l-1-1h-2c-1 0-3-1-4-1zm33 8-46 178 9 3 50-178c-5-1-9-2-13-3zm32 9-54 176 9 3 58-175-3-1h-1l-1-1h-3v-1h-1c-1 0-3-1-4-1zm32 10-62 174 9 3 65-172c-4-2-8-3-12-5zm31 12-70 171c3 1 7 2 10 4l72-169-12-6zm31 14-77 167c3 1 6 3 8 4l81-166c-2 0-4-1-6-2l-1-1c-2-1-3-1-5-2zm30 15-85 163c3 2 6 3 9 5l88-162c-2-1-3-2-5-2v-1c-2-1-5-2-7-3zm29 16-92 159c3 2 6 3 9 5l95-158c-2-1-3-1-5-2v-1h-1c-1-1-3-1-4-2v-1h-2zm29 17-99 155c3 2 5 4 8 6l102-154h-1v-1h-2v-1h-1v-1h-2v-1h-1c-1-1-3-2-4-3zm28 19-106 150c3 2 5 4 8 6l108-149-1-1h-1v-1h-2v-1h-1v-1c-2-1-4-2-5-3zm27 20-113 145c3 2 5 4 8 6l115-143-1-1-1-1c-3-2-6-4-8-6zm26 21-119 140c2 2 5 4 7 7l122-139-1-1h-1c-2-2-4-4-6-5v-1l-2-1zm25 22-125 135c2 2 5 4 7 7l127-133c-1-2-3-3-5-5v-1h-1l-1-1-1-1-1-1zm24 23-131 130c2 2 5 4 7 7l133-127-2-3h-1v-1h-1l-1-1v-1h-1v-1h-1v-1l-2-2zm23 25-137 123 7 7 139-121-3-2v-1l-6-6zm22 25-142 117c2 3 4 5 6 8l144-115-2-2-1-1v-1l-1-1-1-1v-1h-1v-1h-1l-1-2zm20 26-147 111c2 3 4 5 6 8l149-108-1-2-1-2h-1v-1h-1v-2h-1v-1h-1v-1l-2-2zm20 27-152 104 6 9 153-102-1-1v-1c-1-2-3-4-4-5v-1l-2-3zm18 28-156 98c2 2 3 5 5 8l158-94c-1-3-3-6-5-8v-1l-2-3zm17 29-160 90c1 3 3 6 5 9l162-87c-1-1-1-2-2-3v-1h-1v-2h-1v-2h-1v-2h-1v-1l-1-1zm16 30-164 83c1 2 3 5 4 8l166-79v-1c-2-4-4-7-6-11zm14 30-168 75c2 3 3 6 4 9l170-72-6-12zm13 31-171 68c1 3 3 6 4 9l172-65c-1-4-3-8-5-12zm12 31-174 60c1 3 2 6 3 10l175-57c-1-4-3-8-4-13zm10 32-177 52c1 3 2 6 3 10l178-49-1-2c-1-2-1-5-2-7 0-1-1-3-1-4zm9 33-179 43c1 4 2 7 2 10l180-40v-2h-1c0-2 0-4-1-6v-2h-1v-3zm7 32-181 36c1 3 2 7 2 10l181-33v-5h-1c0-3 0-5-1-8zm6 33-182 28c0 3 1 6 1 10l183-25c-1-1-1-3-1-4v-3l-1-1v-5zm4 34-183 19c0 3 1 6 1 10l183-16v-4c0-3-1-6-1-9zm3 33-184 11c0 3 0 7 1 10l183-8v-13zm1 33-184 3v10l184 1v-14zm-184 29v10l183 8c1-4 1-9 1-13l-184-5zm-1 25c-1 3-1 7-1 10l183 17v-5h1v-9l-183-13zm-3 25c0 4-1 7-1 10l182 25c1-2 1-4 1-5v-2c1-2 1-4 1-6l-183-22zm-3 25c-1 4-1 7-2 10l181 33v-2h1c0-4 1-7 1-11l-181-30zm-5 25c-1 3-1 7-2 10l179 41c1-2 1-3 1-4v-1l1-1c0-2 1-5 1-7l-180-38zm-6 25c0 3-1 6-2 9l177 49 1-2v-1l3-9-179-46zm-6 24-3 9 175 57c0-1 0-2 1-4v-2h1v-3h1v-3l-175-54zm-8 24c-2 3-3 6-4 9l172 65c2-3 3-7 4-10l1-2-173-62zm-9 23c-2 3-3 6-4 9l169 73c1-2 2-4 2-6h1v-1c1-2 1-4 2-5l-170-70zm-10 23c-2 3-3 6-5 9l166 80c2-4 4-7 6-11l-167-78zm-12 23c-1 3-3 6-4 9l162 87 1-1v-2c1-2 3-4 4-6v-1l1-1-164-85zm-12 22c-1 3-3 6-5 9l158 94c1-2 2-4 4-5v-2h1v-1l1-1v-1l1-1-160-92zm-13 22c-2 2-3 5-5 8l153 102c1-2 2-3 3-5h1v-1c1-2 2-3 3-5l-155-99zm-14 21c-2 2-4 5-6 8l149 108c2-3 4-6 7-9v-1h1v-1l-151-105zm-15 20c-2 3-4 5-6 8l144 115v-1c2-2 4-4 6-7l2-3-146-112zm-16 20c-2 2-4 5-6 7l138 121 2-1v-1l1-1h1v-1l1-1c1-2 3-3 4-5l-141-118zm-16 19c-3 2-5 4-7 7l133 127 1-2h1v-1h1v-1h1c1-2 3-4 5-5l-135-125zm-18 18c-2 2-5 4-7 7l127 133 7-7 2-2-129-131zm-18 17c-3 2-5 4-8 7l121 138c2-1 4-3 6-5l1-1h1v-1l2-1-123-137zm-20 17c-2 2-5 4-7 6l114 144 1-1h1v-1h1v-1l2-1c1 0 2-1 3-2v-1h1l1-1h1l-118-142zm-19 15c-3 2-6 4-8 6l108 149h1v-1c3-2 6-4 9-7l-110-147zm-21 15c-3 2-5 4-8 6l101 153h1v-1h1l9-6-104-152zm-21 14c-3 2-6 3-8 5l94 158 2-1 1-1c2-1 3-2 5-3h1l2-2-97-156zm-22 13c-3 1-5 3-8 4l87 163 2-2h1l1-1h1l1-1h1l1-1h1v-1h1l1-1-90-160zm-22 11c-3 2-6 3-9 5l80 166 2-1v-1h3v-1h1l1-1c1 0 3-1 5-2l-83-165zm-23 11c-3 2-6 3-9 4l72 170 1-1h1c3-2 7-3 10-5l-75-168zm-23 10c-3 1-6 2-9 4l64 172c5-2 9-3 13-5l-68-171zm-24 9-9 3 57 175c4-1 8-3 12-4l-60-174zm-24 7-9 3 49 178c4-2 8-3 12-4l-52-177zm-24 7c-3 1-6 1-9 2l40 180 3-1c3-1 6-1 9-2h1l-44-179zm-24 5c-4 1-7 2-10 2l32 181c2 0 5 0 7-1h3l2-1h1l-35-181zm-25 5c-4 0-7 1-10 1l24 183c2-1 4-1 6-1h1l2-1h4l-27-182zm-25 3c-4 0-7 1-10 1l16 183h4c2 0 5-1 8-1h1l-19-183zm-26 2c-3 0-6 0-9 1l7 183h14l-12-184zm-25 1h-10v184h13l-3-184zm-35 0-9 183c3 0 5 1 7 1h7l5-184h-10zm-25-2-17 183h3c4 1 7 1 10 1l13-183c-3-1-6-1-9-1zm-26-3-24 182c1 1 2 1 3 1h1c1 0 3 0 5 1h4l21-183c-3 0-6-1-10-1zm-24-4-33 181 2 1h1c3 0 6 1 10 1l29-181c-3-1-6-1-9-2zm-25-5-41 179c2 1 3 1 5 2h1c2 0 5 1 7 1l38-180c-4-1-7-1-10-2zm-25-6-49 177 2 1h1c3 1 7 2 10 3l46-179c-3 0-6-1-10-2zm-24-7-57 175c3 0 5 1 7 2h2l3 1 1 1 54-176c-3-1-7-2-10-3zm-23-9-65 173c4 1 8 3 12 4l62-173c-3-1-6-3-9-4zm-24-9-72 169 1 1c4 1 7 3 11 4l69-170c-3-2-6-3-9-4zm-23-11-80 166h1v1h2c3 2 6 3 9 5l77-167c-3-2-6-3-9-5zm-22-11-88 162c1 1 3 1 4 2 3 1 5 3 8 4l85-163c-3-2-6-3-9-5zm-22-13-95 158c4 3 8 5 12 7l91-160c-2-1-5-3-8-5zm-21-13-102 153c1 1 3 2 5 3v1h1v1h1l1 1 3 2 99-156c-3-1-6-3-8-5zm-21-14-109 148c3 2 5 4 8 6h1v1l2 1 106-151c-3-2-5-3-8-5zm-20-16-115 144c3 3 7 5 10 8l113-146c-3-2-6-4-8-6zm-20-16-121 139c3 2 7 5 10 8l119-141c-3-2-5-4-8-6zm-18-17-128 133c4 3 7 6 10 9l125-135c-2-3-5-5-7-7zm-18-18-133 127c3 3 6 6 9 10l131-130c-3-2-5-5-7-7zm-17-19-139 121c3 4 6 7 9 10l136-123c-2-3-4-5-6-8zm-16-19-144 115 1 1v1h1v1c2 2 3 4 5 6l1 1 142-117c-2-3-4-5-6-8zm-16-20-149 108c3 4 6 7 8 11l147-111c-2-3-4-5-6-8zm-14-21-154 102h1l1 2v1h1v1l1 1v1h1v1l3 3 151-104c-1-2-3-5-5-8zm-14-21-158 94c3 4 5 8 7 11l157-97c-2-3-4-5-6-8zm-12-22-162 87v1h1v1l1 1v1c1 3 3 5 4 8l161-91c-2-2-3-5-5-8zm-11-23-166 80v1c2 4 4 7 6 11l164-83c-2-3-3-6-4-9zm-11-23-169 73c2 4 3 8 5 12l168-76c-1-3-3-6-4-9zm-9-23-173 65c2 4 4 8 5 12l171-68-3-9zm-9-24-175 57c1 3 3 7 4 10v1l1 2 174-60c-1-3-3-7-4-10zm-7-24-177 49c0 1 0 2 1 3v3c1 2 2 4 2 7l177-52c-1-3-2-7-3-10zm-6-24-179 40v4c1 2 1 4 2 5v3l1 1 178-44c0-3-1-6-2-9zm-5-25-181 33c0 1 1 3 1 5 0 3 1 5 1 8l181-36c-1-3-1-7-2-10zm-4-25-182 25v1c0 3 1 6 1 9l1 3 182-28c-1-3-1-7-2-10zm-3-25-183 16c0 5 1 9 1 13l183-19c0-3 0-7-1-10zm-1-25-184 8v9c0 1 0 3 1 4l183-11v-10zm-185-26 184 1H386v12l184-3v-9l-184-1zm0 0h184-184zm1-33c0 4 0 9-1 13l184 5c1-3 1-7 1-10l-184-8zm2-34v8h-1v6l184 13v-10l-183-17zm4-33c-1 3-1 6-1 10v1h-1v2l183 22c0-4 1-7 1-10l-182-25zm5-33c0 2-1 4-1 5v4h-1v4l182 30c0-4 1-7 1-10l-181-33zm7-33-1 3v1c-1 3-1 6-2 9l180 38c1-3 2-7 2-10l-179-41zm8-32v1l-1 1v3h-1v2c-1 2-1 4-1 5l178 46c1-3 2-6 2-9l-177-49zm10-32c-2 4-3 8-4 12l176 54 3-9-175-57zm11-32-1 1v2h-1v3h-1v2l-1 1c0 1 0 2-1 3l174 62 3-9-172-65zm12-31c-1 2-1 3-2 5v1l-3 6 171 70c1-3 2-7 3-10l-169-72zm14-31-1 3v1h-1c-1 3-2 6-4 8l168 77c1-3 2-6 4-8l-166-81zm15-29c-1 2-2 4-4 7v1c-1 1-1 2-2 3l164 85c1-3 3-6 4-9l-162-87zm17-29-1 1v1h-1c-1 2-3 5-4 7v1l-1 1 160 92c1-3 3-6 5-9l-158-94zm18-29c-2 2-3 4-4 5v1l-1 1c-1 2-2 3-2 4l155 99c2-3 3-5 5-8L510 721zm19-27c-3 3-5 7-8 10l151 106c2-3 4-5 6-8L529 694zm20-27-2 2v1l-1 1c-1 2-3 4-5 6l146 113c2-3 4-5 6-8L549 667zm22-26-1 2h-1c-2 3-5 6-7 8l141 119c2-2 4-5 6-7L571 641zm22-24-6 6v1l-3 2 135 125c3-2 5-5 7-7L593 617zm24-24h-1v1l-6 6h-1v1h-1v1h-1l130 131 7-7-127-133zm25-23c-4 3-7 6-10 9l123 137c3-3 5-5 8-7L642 570zm25-21c-2 2-4 3-6 5l-1 1c-1 0-2 1-3 2l117 142c3-2 6-4 8-6L667 549zm27-20c-1 0-2 1-4 2l-4 4h-1l-2 1 111 147c3-2 6-4 8-6L694 529zm27-19c-3 2-6 4-10 6v1l104 152c2-2 5-4 8-6L721 510zm29-18-6 3-1 1h-1v1h-1l-2 2 97 156c3-2 6-4 8-5l-94-158zm29-17-1 1h-1l-1 1c-3 1-5 3-8 4h-1l91 161c2-2 5-3 8-5l-87-162zm30-15c-4 2-8 4-12 5v1l83 164c3-1 6-3 9-4l-80-166zm30-14c-2 1-3 2-5 2l-1 1h-1c-1 1-3 2-5 2l76 168c3-1 6-2 9-4l-73-169zm31-12c-2 0-3 1-5 2-2 0-4 1-6 2h-1l68 171 9-3-65-172zm32-12c-4 2-7 3-11 4h-1v1l59 174c4-1 7-2 10-3l-57-176zm32-9c-4 1-8 2-13 3l52 177c4-1 7-2 10-3l-49-177zm33-8c-4 0-7 1-10 2l-3 1 44 178c3 0 6-1 9-2l-40-179zm32-7c-2 0-5 1-7 1-2 1-4 1-6 1l36 181c4-1 7-1 10-2l-33-181zm33-5c-2 0-4 0-6 1h-4c-1 0-2 1-3 1l28 182c3-1 7-1 10-2l-25-182zm34-4c-3 0-6 1-9 1h-4l19 183c3 0 7 0 10-1l-16-183zm33-2h-11l-2 1 11 183h10l-8-184zm34-1h-14l4 184h10V386z"
            style={{
              fill: "gray",
              fillRule: "nonzero",
            }}
          />
          <path
            d="M1401 1464c-73 59-167 95-268 95h-7l-1 61h8c116 0 223-41 306-109l-38-47zm-356 86c-100-21-187-77-247-154l-48 38c69 88 168 151 282 175l13-59zm-292-223c-30-58-46-124-46-194 0-33 3-64 10-95l-59-13c-8 35-12 71-12 108 0 80 19 155 53 222l54-28zm-10-366c40-92 112-166 201-211l-27-54c-102 50-184 135-230 240l56 25zm278-240c35-9 73-14 112-14 63 0 124 14 178 38l25-55c-62-28-131-44-203-44-45 0-87 6-128 17l16 58zm360 66c80 57 140 142 165 240l59-15c-29-112-97-209-188-275l-36 50zm177 321c0 8 1 16 1 25 0 104-38 199-100 273l47 39c71-84 114-194 114-312 0-10-1-19-1-28l-61 3z"
            style={{
              fill: "#1a1a1a",
              fillRule: "nonzero",
            }}
          />
          <path
            className="CyberEl11_svg__fil0"
            d="M1912 1834c-192 213-470 347-779 347-290 0-552-118-741-307-190-190-307-452-307-741 0-290 117-552 307-741C581 202 843 85 1133 85V0C820 0 537 127 332 332S0 820 0 1133c0 312 127 596 332 801 205 204 488 331 801 331 334 0 634-144 841-375l-62-56z"
          />
          <path
            className="CyberEl11_svg__fil1"
            d="M1499 1168c0 6 4 12 10 12 6 1 12-4 12-10 1-6-4-11-10-12-6 0-11 4-12 10zm-5 35c-1 6 3 12 9 13s12-2 13-8-3-12-9-13c-6-2-12 2-13 8zm-8 35c-2 6 1 12 7 14 6 1 12-2 14-8s-2-12-8-14c-5-1-12 2-13 8zm-12 33c-2 6 0 13 6 15s12-1 14-6c3-6 0-12-6-15-5-2-12 1-14 6zm-15 33c-3 5-1 12 5 15 5 2 12 0 15-5 2-5 0-12-5-15-6-3-12-1-15 5zm-18 30c-3 5-2 12 3 16 5 3 12 2 15-4 4-5 2-11-3-15-5-3-12-2-15 3zm-21 29c-4 5-3 12 2 16 4 3 11 3 15-2s3-12-1-16c-5-3-12-3-16 2zm-24 27c-4 4-4 11 1 15 4 5 11 5 15 0 4-4 4-11 0-15-4-5-11-5-16 0zm-26 24c-4 4-5 11-1 16 4 4 11 5 16 1 4-4 5-11 1-16-4-4-11-5-16-1zm-28 22c-5 3-6 10-3 15 4 5 11 6 16 3 5-4 6-11 3-16-4-5-11-6-16-2zm-30 18c-5 3-7 10-4 16 3 5 9 7 15 4 5-3 7-10 4-15-3-6-10-7-15-5zm-32 16c-5 3-8 9-6 15 3 5 9 8 15 6 6-3 8-9 6-15-3-6-9-8-15-6zm-33 13c-6 2-9 8-7 14s8 9 14 7 9-8 7-14-8-9-14-7zm-34 9c-6 2-10 8-9 13 1 6 7 10 13 9s10-7 9-13c-2-6-7-10-13-9zm-35 6c-7 1-11 7-10 13s6 10 12 9 11-6 10-12-6-10-12-10zm-36 3c-6 0-11 5-11 11s6 11 12 11 11-5 10-11c0-6-5-11-11-11zm-36-1c-6 0-11 4-11 10-1 6 4 12 10 12 6 1 11-4 12-10 0-6-4-11-11-12zm-35-4c-6-1-12 3-13 9s3 12 9 13c7 1 12-3 13-9s-3-12-9-13zm-35-8c-5-1-12 2-13 8-2 6 2 12 8 14 6 1 12-2 13-8 2-6-2-12-8-14zm-33-11c-6-2-12 1-15 7-2 6 1 12 7 14 5 2 12-1 14-6 2-6-1-12-6-15zm-33-14c-6-2-12 0-15 5-3 6 0 12 5 15 6 3 12 0 15-5s0-12-5-15zm-31-17c-5-3-12-2-15 4-4 5-2 12 3 15s12 1 15-4c4-5 2-12-3-15zm-29-20c-5-4-12-3-16 2s-3 12 2 15c5 4 12 3 16-2 3-5 2-12-2-15zm-28-23c-4-4-11-4-15 0-4 5-4 12 0 16 5 4 12 4 16-1 4-4 4-11-1-15zm-25-26c-4-4-11-4-15 0-5 4-5 11-1 15 4 5 11 5 16 1 4-4 4-11 0-16zm-22-27c-4-5-10-6-15-3-5 4-6 11-3 16 4 5 11 6 16 2 5-3 6-10 2-15zm-19-30c-4-5-10-7-16-4-5 3-7 10-3 15 3 6 9 7 15 4 5-3 7-10 4-15zm-17-31c-3-6-9-8-15-6-5 3-8 9-5 15 2 6 9 8 15 5 5-2 7-9 5-14zm-14-33c-2-6-8-9-14-7-5 2-8 8-6 14s8 9 14 7c5-2 8-9 6-14zm-10-34c-1-6-7-10-13-8-6 1-10 7-8 13 1 6 7 10 13 8 6-1 10-7 8-13zm-7-35c-1-6-6-10-12-9-6 0-10 6-10 12 1 6 7 10 13 9s10-6 9-12zm-3-36c-1-6-6-10-12-10s-11 5-10 12c0 6 5 10 11 10s11-5 11-12zm0-35c0-6-5-11-11-12-6 0-11 5-11 11-1 6 4 11 10 11 6 1 11-4 12-10zm3-36c1-6-3-11-9-12s-12 3-13 9 3 12 10 13c6 1 11-4 12-10zm7-35c1-5-3-11-8-13-6-1-12 2-14 8-1 6 2 12 8 14 6 1 12-3 14-9zm10-34c2-5-1-12-7-14s-12 1-14 7 1 12 7 14c5 2 12-1 14-7zm13-33c3-5 0-12-5-14-6-3-12 0-15 5-3 6 0 12 5 15 6 2 13 0 15-6zm17-31c3-5 1-12-4-15-6-3-12-2-16 4-3 5-1 12 4 15 6 3 12 1 16-4zm19-30c4-5 2-12-3-15-4-4-11-3-15 2s-2 12 3 16c4 3 11 2 15-3zm22-28c4-4 4-11-1-15-4-4-11-4-15 1-4 4-4 11 1 15 4 4 11 4 15-1zm25-25c4-4 5-11 0-16-4-4-11-5-15 0-5 4-5 11-1 15 4 5 11 5 16 1zm27-23c5-4 6-11 2-16s-11-5-15-2c-5 4-6 11-2 16 3 5 10 5 15 2zm29-21c5-3 7-10 4-15-4-5-10-7-16-3-5 3-6 10-3 15s10 7 15 3zm31-17c6-3 8-9 5-15-3-5-9-8-15-5-5 3-7 10-5 15 3 5 10 8 15 5zm33-14c5-3 8-9 6-15-2-5-8-8-14-6s-9 9-6 14c2 6 8 9 14 7zm34-11c5-2 9-8 7-14-1-6-7-9-13-8-6 2-10 8-8 14s8 9 14 8zm34-8c6-1 10-7 9-13s-7-10-13-9-10 7-9 13c2 6 7 10 13 9zm36-5c6 0 10-5 10-11-1-7-6-11-12-11-6 1-11 6-10 12 0 6 5 11 12 10zm35-1c6 1 11-4 11-10 0-7-4-12-10-12-7 0-12 5-12 11s5 11 11 11zm36 3c6 0 11-4 12-10s-4-11-10-12-11 3-12 10c-1 6 4 11 10 12zm35 6c6 1 12-3 13-9s-3-12-9-13-11 3-13 8c-1 6 3 12 9 14zm34 9c6 2 12-2 14-7 2-6-1-12-7-14s-12 1-14 7 1 12 7 14zm33 12c6 3 12 0 15-6 2-5 0-12-6-14s-12 0-14 6c-3 5 0 12 5 14zm32 16c6 3 12 1 15-4 3-6 1-12-4-15s-12-1-15 4-1 12 4 15zm31 19c5 3 11 2 15-3 3-5 2-12-3-16-5-3-12-2-15 3-4 5-2 12 3 16zm28 21c5 4 12 3 15-1 4-5 4-12-1-16s-12-3-15 1c-4 5-4 12 1 16zm26 24c4 5 11 5 16 0 4-4 4-11 0-15-4-5-11-5-16 0-4 4-4 11 0 15zm24 27c4 4 11 5 15 1 5-4 6-11 2-15-4-5-11-6-16-2-4 4-5 11-1 16zm21 28c3 5 10 7 15 3 5-3 7-10 3-15-3-5-10-6-15-3s-7 10-3 15zm18 31c3 5 10 7 15 4 5-2 7-9 5-14-3-6-10-8-15-5-6 3-8 10-5 15zm15 32c3 6 9 8 15 6 5-2 8-9 6-14-3-6-9-9-15-6-5 2-8 8-6 14zm12 34c2 5 8 9 14 7s9-8 7-14c-1-6-8-9-13-7-6 2-10 8-8 14zm9 34c1 6 7 10 13 9s10-7 8-13c-1-6-7-10-12-9-6 1-10 7-9 13zm5 35c1 6 6 11 12 10s11-6 10-12-6-11-12-10-10 6-10 12zm2 36c0 6 5 11 11 11s11-5 11-11-5-11-11-11-11 5-11 11zm0 2c0 6 5 11 11 11s11-5 11-11-5-11-11-11-11 5-11 11z"
          />
          <path
            className="CyberEl11_svg__fil2"
            d="M1133 812c-177 0-321 144-321 321s144 320 321 320 320-143 320-320-143-321-320-321zm0 78c134 0 243 109 243 243s-109 243-243 243-243-109-243-243 109-243 243-243z"
          />
        </g>
      </g>
    </svg>
  );
};
export default SvgCyberEl11;
