import React, { CSSProperties } from "react";
type CyberElProps = {
  id?: string,
  className?: string,
  style?: CSSProperties,
  [x: string]: any,
};
const SvgCyberEl10 = (props: CyberElProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlSpace="preserve"
      width={2300}
      height={2300}
      style={{
        shapeRendering: "geometricPrecision",
        textRendering: "geometricPrecision",
        imageRendering: "auto",
        fillRule: "evenodd",
        clipRule: "evenodd",
      }}
      viewBox="0 0 99 99"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <defs>
        <linearGradient
          id="CyberEl10_svg__a"
          gradientUnits="userSpaceOnUse"
          x1={55.932}
          y1={25.864}
          x2={89.815}
          y2={25.864}
        >
          <stop
            offset={0}
            style={{
              stopOpacity: 1,
              stopColor: "#525252",
            }}
          />
          <stop
            offset={1}
            style={{
              stopOpacity: 1,
              stopColor: "#939393",
            }}
          />
        </linearGradient>
        <linearGradient
          id="CyberEl10_svg__d"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={8.849}
          y1={72.575}
          x2={43.405}
          y2={72.575}
        />
        <linearGradient
          id="CyberEl10_svg__f"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={9.009}
          y1={25.784}
          x2={43.405}
          y2={25.784}
        />
        <linearGradient
          id="CyberEl10_svg__c"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={44.994}
          y1={49.406}
          x2={53.817}
          y2={49.406}
        />
        <linearGradient
          id="CyberEl10_svg__e"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={55.858}
          y1={72.535}
          x2={89.965}
          y2={72.535}
        />
        <linearGradient
          id="CyberEl10_svg__h"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={7.843}
          y1={49.357}
          x2={15.713}
          y2={49.357}
        />
        <linearGradient
          id="CyberEl10_svg__i"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={45.02}
          y1={86.988}
          x2={53.624}
          y2={86.988}
        />
        <linearGradient
          id="CyberEl10_svg__n"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={57.336}
          y1={36.172}
          x2={60.487}
          y2={36.172}
        />
        <linearGradient
          id="CyberEl10_svg__g"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={45.333}
          y1={12.086}
          x2={54.004}
          y2={12.086}
        />
        <linearGradient
          id="CyberEl10_svg__b"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={46.441}
          y1={49.406}
          x2={52.37}
          y2={49.406}
        />
        <linearGradient
          id="CyberEl10_svg__o"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={56.099}
          y1={31.761}
          x2={57.202}
          y2={31.761}
        />
        <linearGradient
          id="CyberEl10_svg__j"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={85.414}
          y1={48.954}
          x2={87.849}
          y2={48.954}
        />
        <linearGradient
          id="CyberEl10_svg__l"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={61.506}
          y1={44.995}
          x2={68.117}
          y2={44.995}
        />
        <linearGradient
          id="CyberEl10_svg__k"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={63.861}
          y1={49.406}
          x2={71.608}
          y2={49.406}
        />
        <linearGradient
          id="CyberEl10_svg__m"
          gradientUnits="userSpaceOnUse"
          xlinkHref="#CyberEl10_svg__a"
          x1={59.228}
          y1={40.584}
          x2={64.44}
          y2={40.584}
        />
      </defs>
      <path
        d="M49 2C23 2 2 23 2 49c0 27 21 48 47 48 27 0 48-21 48-48C97 23 76 2 49 2zm0 97C22 99 0 77 0 49 0 22 22 0 49 0c28 0 50 22 50 49 0 28-22 50-50 50z"
        style={{
          fill: "url(#CyberEl10_svg__b)",
        }}
      />
      <path
        d="M49 54c-2 0-4-2-4-5 0-2 2-4 4-4 3 0 5 2 5 4 0 3-2 5-5 5z"
        style={{
          fill: "url(#CyberEl10_svg__c)",
        }}
      />
      <path
        d="M43 90h-1C25 87 12 73 9 56c0 0 0-1 1-1 0 0 1 0 1 1 2 16 15 29 32 32v2z"
        style={{
          fill: "url(#CyberEl10_svg__d)",
        }}
      />
      <path
        d="M57 90c-1 0-1 0-1-1 0 0 0-1 1-1 16-3 28-16 31-32 0-1 1-1 1-1 1 0 1 1 1 1-3 17-16 31-33 34z"
        style={{
          fill: "url(#CyberEl10_svg__e)",
        }}
      />
      <path
        d="m89 43-1-1c-3-16-16-28-31-31-1 0-1-1-1-1 0-1 0-1 1-1 16 3 30 16 33 33 0 0 0 1-1 1z"
        style={{
          fill: "url(#CyberEl10_svg__a)",
        }}
      />
      <path
        d="M10 43c-1 0-1-1-1-1 3-17 17-30 33-33 1 0 1 0 1 1v1c-16 2-29 15-32 31l-1 1z"
        style={{
          fill: "url(#CyberEl10_svg__f)",
        }}
      />
      <path
        d="M57 17s-1 0-1-1l-7-6-6 6h-1v-1l7-7c0-1 1-1 1 0l7 7c1 1 1 1 0 1v1z"
        style={{
          fill: "url(#CyberEl10_svg__g)",
        }}
      />
      <path
        d="M15 57h-1l-6-7c-1 0-1-1 0-1l7-7h1v1l-6 6 6 6v2h-1z"
        style={{
          fill: "url(#CyberEl10_svg__h)",
        }}
      />
      <path
        d="m49 91-7-7v-1h1l6 6 6-6h2v1l-7 7h-1z"
        style={{
          fill: "url(#CyberEl10_svg__i)",
        }}
      />
      <path
        d="M84 57h-1v-2l6-6-7-7v-1h1l8 8v1l-7 7z"
        style={{
          fill: "url(#CyberEl10_svg__j)",
        }}
      />
      <path
        d="M79 50H56v-1h24c0 1 0 1-1 1z"
        style={{
          fill: "url(#CyberEl10_svg__k)",
        }}
      />
      <path
        d="M73 46H56v-2h17c1 0 1 1 1 1s0 1-1 1z"
        style={{
          fill: "url(#CyberEl10_svg__l)",
        }}
      />
      <path
        d="M67 41H56v-1h11c1 0 1 0 1 1h-1z"
        style={{
          fill: "url(#CyberEl10_svg__m)",
        }}
      />
      <path
        d="M62 37h-6v-1h6v1z"
        style={{
          fill: "url(#CyberEl10_svg__n)",
        }}
      />
      <path
        d="M57 32h-1v-1h1s1 0 1 1h-1z"
        style={{
          fill: "url(#CyberEl10_svg__o)",
        }}
      />
    </svg>
  );
};
export default SvgCyberEl10;
