# ASP.NET Web Framework Simulation

## Overview
This project demonstrates a simulation of how a web framework works using the pipeline design pattern in .NET. It leverages attributes and listeners, deploys a base controller, and utilizes the ThreadPool for improved concurrency.

## Give a Star! ⭐
If you find this project valuable and appreciate the efforts put into simulating a web framework in .NET, consider showing your support by giving this repository a star! ⭐️ Your star will encourage continued development and improvements. Thank you!

## Features
**Pipeline Design Pattern:** The project implements a pipeline design pattern commonly used in web frameworks to process requests through a series of middleware components.

**Base Controller:** A base controller is provided to encapsulate common functionality shared across multiple controllers. It serves as a foundation for creating new controllers with shared features.

**ThreadPool Usage:** The project efficiently utilizes the ThreadPool for handling concurrent requests, improving the overall performance of the web application.

## Diagram
![image](https://github.com/thisisnabi/MicroWebFramework/assets/3371886/5a0f747b-fdc4-45d6-907e-36266eff3189)
