# Module 

Welcome to the [Tock](https://theopenconversationkit.github.io/tock) KDoc documentation!

# package ai.tock.bot

Utility methods to start a new bot

# package ai.tock.bot.admin.answer

Custom bot scripts created via the admin interface

# package ai.tock.bot.admin.bot

Bot configuration support	

# package ai.tock.bot.admin.dialog

Conversation monitoring via the admin interface

# package ai.tock.bot.admin.message

Messages created with the scripts managed via the admin interface	

# package ai.tock.bot.admin.story

Configurable stories

# package ai.tock.bot.admin.test

Contains [TestPlan] and [TestPlanExecution] to manage automated integration tests	

# package ai.tock.bot.admin.user

User monitoring via the admin interface	

# package ai.tock.bot.api.client

Bot API Client Definition

# package ai.tock.bot.api.model

Bot API Model Definition

# package ai.tock.bot.api.model.configuration

Bot API Model Configuration

# package ai.tock.bot.api.model.context

Bot API Model Context

# package ai.tock.bot.api.model.message.bot

Bot API Bot Messages Model

# package ai.tock.bot.api.model.message.user

Bot API User Messages Model

# package ai.tock.bot.api.model.websocket

Bot API Websocket dedicated Model

# package ai.tock.bot.api.webhook

Bot API Webhook methods

# ai.tock.bot.api.websocket

Bot API Websocket methods

# package ai.tock.bot.connector

Contains classes used to define a new [Connector]

# package ai.tock.bot.connector.alexa	

Alexa connector implementation. See [AlexaConnector]

# package ai.tock.bot.connector.ga

Google Assistant connector implementation. See [GAConnector]

# package ai.tock.bot.connector.ga.model

Google Assistant connector common model	

# ai.tock.bot.connector.ga.model.notification

Google Assistant notification model

# package ai.tock.bot.connector.ga.model.request

Google Assistant connector request model

# package ai.tock.bot.connector.ga.model.response

Google Assistant connector response model

# package ai.tock.bot.connector.media

Generic Media Configuration

# package ai.tock.bot.connector.messenger

[MessengerConnector] implementation

# package ai.tock.bot.connector.messenger.model

Messenger connector common model

# package ai.tock.bot.connector.messenger.model.attachment

Messenger connector attachment model

# package ai.tock.bot.connector.messenger.model.handover

Messenger connector handover protocol model		

# package ai.tock.bot.connector.messenger.model.send

Messenger connector "send" model	

# package ai.tock.bot.connector.messenger.model.webhook

Messenger connector "webhook" model	

# package ai.tock.bot.connector.rocketchat

Rocketchat connector implementation

# package ai.tock.bot.connector.slack

[SlackConnector] implementation

# package ai.tock.bot.connector.slack.model

Slack connector model

# package ai.tock.bot.connector.slack.model.old

Old Slack connector model - will be removed in 19.3

# package ai.tock.bot.connector.teams

Teams connector implementation

# package ai.tock.bot.connector.teams.auth

Teams connector authentication

# package ai.tock.bot.connector.teams.messages

Teams connector complex messages

# package ai.tock.bot.connector.teams.token

Teams connector token support

# ai.tock.bot.connector.twitter

Twitter connector implementation

# ai.tock.bot.connector.twitter.model

Twitter connector base model classes

# ai.tock.bot.connector.twitter.model.incoming

Twitter connector incoming model

# ai.tock.bot.connector.twitter.model.outcoming

Twitter connector outcoming model

# ai.tock.bot.connector.web

Web Connector implementation

# package ai.tock.bot.connector.whatsapp

WhatsApp connector implementation

# package ai.tock.bot.connector.whatsapp.model.common

Common WhatsApp model

# package ai.tock.bot.connector.whatsapp.model.send

"Send" WhatsApp model

# package ai.tock.bot.connector.whatsapp.model.webhook

"Webhook" WhatsApp model

# package ai.tock.bot.definition

Contains all classes used to *define* a bot

# package ai.tock.bot.engine

**Core conversational engine** with the main interface [BotBus] used by all bot implementations

# package ai.tock.bot.engine.action

The bot and user core [Action] definitions

# package ai.tock.bot.engine.config	

Configuration utilities

# package ai.tock.bot.engine.dialog

Contains runtime conversation related classes, ie [Dialog] and [Story] classes.	

# package ai.tock.bot.engine.event

The [Event]s supported by Tock	

# package ai.tock.bot.engine.feature

Built-in feature flipping

# package ai.tock.bot.engine.message

The generic format for actions, used by monitoring and automated integration tests

# package ai.tock.bot.engine.message.parser

A very simple dsl for [Message] parsing and formatting	

# package ai.tock.bot.engine.monitoring

Runtime monitoring utility classes	

# package ai.tock.bot.engine.nlp

To customize default NLP behaviour	

# package ai.tock.bot.engine.stt

Configure specific STT handling	

# package ai.tock.bot.engine.user

User core classes, contains [UserTimeline] and [PlayerId] classes

# package ai.tock.bot.test

Utility methods for unit tests

# package ai.tock.bot.test.junit

JUnit utilities

# package ai.tock.shared

Shared utility classes and extensions

# package ai.tock.shared.cache

Internal cache utilities

# package ai.tock.shared.jackson

Jackson configuration and extension methods

# package ai.tock.shared.security

User definition and encryption methods

# package ai.tock.shared.security.auth

Web authentication methods 

# package ai.tock.shared.vertx

Vert.x related package
	


	


	


	

