---
title: i18n - guide
---

# Construire un bot multilingue avec Tock

L'interface _Tock Studio_ permet de traduire et moduler les réponses d'un bot en fonction de la 
langue mais aussi du canal utilisés.


## Pré-requis

Tock met à disposition un framework complet d'internationalisation. Il est activé par défaut en mode _Bot API_
 (par exemple sur la [plateforme de démonstration](https://demo.tock.ai/)).

Dans le mode _Bot intégré_ (voir le [manuel développeur](../../../dev/modes)), l'internationalisation 
est désactivée par défaut. Pour l'activer, il est alors nécessaire de configurer la plateforme à son démarrage :

* Soit via le code de démarrage du bot (développeur) :
```kotlin
    Translator.enabled = true
```
* Soit avec une _propriété Système_ (administrateur) en passant ```-Dtock_i18n_enabled=true``` au démarrage de la JVM

## Activer plusieurs langues pour un bot

Il est possible d'ajouter et de gérer les langues actives pour un bot dans la section _NLU Applications_
(dans _Tock Studio_). Voir [_Le menu Settings_](../../studio/configuration).

A tout moment dans _Tock Studio_, il est possible de changer la langue sélectionnée dans la bannière en haut de page, 
notamment pour dialoguer avec un bot dans l'interface _Test the bot_. Voir [_Interface générale_](../../studio/general).

## Langue et _locale_ utilisateur

Quand c'est possible, la _locale_ de l'utilisateur (langue / région) est importée de celle de son compte. 

> Par exemple, si le compte d'un utilisateur Messenger est configuré en Français, le Français sera automatiquement
 sélectionné par Tock.

S'il n'y a pas d'indication de locale, c'est la locale par défaut de Tock qui est utilisée.

Un développeur peut modifier la locale de l'utilisateur dans le code du bot lui-même : 

```kotlin
    userPreferences.locale = Locale.FRENCH
```  

Enfin, la locale par défaut peut être modifiée par un administrateur de la plateforme, en passant la _propriété Système_ 
```-Dtock_default_locale=fr``` au démarrage de la JVM.

## Traduire et faire varier les réponses du bot

Dans _Tock Studio_, la section _Stories & Answers_ > _Answers_ permet de gérer les libellés des réponses du bot. 
Voir [_Le menu Stories & Answers_](../../studio/stories-and-answers).

Chaque libellé a une valeur par défaut pour chaque langue du bot. 
Il est possible de concevoir et configurer différentes variantes :

* En fonction de la langue
* En fonction du canal / connecteur
> Par exemple, certains canaux requièrent des libellés spécifiques, soit parce que le propriétaire du canal l'exige 
>(sur Alexa le vouvoiement est requis), soit parce que l'expérience utilisateur diffère des autres canaux (par exemple 
>en vocal on évitera de trop longues phrases).
* Aléatoirement (pour que le bot ne réponde pas toujours la même chose)

## Traduire massivement les modèles et réponses

Des fonctionnalités sont à l'étude pour permettre la traduction plus ou moins automatisée de nombreuses phrases 
utilisateur (corpus / modèle conversationnel) et réponses (libellés / i18n). A suivre...

Pour le moment, pour envisager une traduction de masse, on peut par exemple :

1. Exporter les données en JSON ou CSV avec _Tock Studio_
2. Traduire les phrases/réponses en dehors de Tock (API SaaS, agence...)
3. Importer les traductions avec _Tock Studio_

> Remarque : au moment de l'import seuls les libellés marqués _validés_ sont pris en compte. 

## Développer avec l'internationalisation

Le [manuel développeur Tock](../../../dev/i18n) donne plus de détails sur le développement des bots multilingues.
