---
title: i18n - guide
---

# Building a multilingual bot with Tock

The _Tock Studio_ interface allows translating and customizing a bot's answers based not only on the language,
but also on the connector used.


## Prerequisites

Tock provides a full internationalisation framework. It is enabled by default in _Bot API_ mode
 (e.g. on the [demo platform](https://demo.tock.ai/)).

In the _integrated bot_ mode (see the [dev guide](../../dev/modes)), internationalisation 
is disabled by default. To enable it, you must configure the platform at launch :

* Either through the bot's init code (developer side) :
```kotlin
    Translator.enabled = true
```
* Or through a configuration value (administrator side), as the added property ```-Dtock_i18n_enabled=true``` at JVM launch,
    or as an environment variable `export tock_i18n_enabled=true`

## Enabling multiple languages for a bot

It is possible to add and configure a bot's active languages in the _NLU Applications_ section
(in _Tock Studio_) - see _the Settings menu_.

At any time in _Tock Studio_, it is possible to change the selected language in the banner at the top of the page.
This is particularly useful when conversing with a bot in the _Test the bot_ interface.

When possible, the user's _locale_ (language/region) is imported from their account.

> For example, if a Messenger user's account is set to French, French will be automatically
selected by Tock.

If no locale is specified, Tock's default locale is used.

A developer can change the user's locale in the bot code itself:

```kotlin
userPreferences.locale = Locale.FRENCH
```  

Finally, the default locale can be modified by a platform administrator, by passing the _System_ property 
```-Dtock_default_locale=en``` at JVM startup.

## Translate and vary bot responses

In _Tock Studio_, the _Stories & Answers_ > _Answers_ section lets you manage the wording of bot answers. 
See [_The Stories & Answers menu_](../../studio/stories-and-answers).

Each label has a default value for each bot language. 
Different variants can be designed and configured:

* language-dependent
* Channel/connector-dependent
> For example, some channels require specific labels, either because the channel owner requires it 
>(on Alexa, polite conversation is required), or because the user experience differs from other channels (for example 
>in voice, avoid long sentences).
* Randomly (so that the bot doesn't always answer the same thing)

## Mass translation of templates and responses

Functionalities are being considered to enable more or less automated translation of numerous user phrases
(corpus / conversational model) and responses (labels / i18n). To be continued...

For the time being, if mass translation is required, you may for example:

1. Export data as JSON or CSV with _Tock Studio_.
2. Translate sentences/answers outside Tock (SaaS API, agency...)
3. Import translations with _Tock Studio_.

> Note: when importing, only wordings marked _validated_ are taken into account.

## Developing with internationalization

The [Tock developer manual](../../dev/i18n) gives more details on developing multilingual bots.
