---
layout: page
title: Table of Contents
---

# Tock documentation

* [Overview](..)

* [Table of contents](../toc)

* Try Tock Studio:
    * [Create your first bot with _Tock Studio_](../guide/studio)
    * [Configure your bot for _Messenger_](../guide/messenger)
    * [Build NLP models](../build-nlp-model)
    * [Monitor NLP models](../evaluate-the-model)
    * [Reducing the scope of intentions](../guide/intents-restrictions)

* Use Tock:
  - Guides:
    - [Create a multilingual bot (internationalisation)](../user/guides/i18n)

* Develop Stories :
    * [Bot API mode](../dev/bot-api)
    * [Integrated Bot mode](../dev/integrated-bot)
    * [Connectors](../dev/connectors)
    * [KDoc](../kdoc)
    * [Code Samples](../the-open-data-bot)
    * [API documentation](../api)

* Develop with Tock :
    * [Available modes](../dev/modes)
    * [_Tock Bot API_](../dev/bot-api)
    * [_Tock Integrated Bot_](../dev/integrated-bot)
        * [Unit Tests](../dev/test)
    * [Connectors](../dev/connectors)
    * [Internationalization (_i18n_)](../dev/i18n)
    * [Tock APIs](../dev/api)
    * [Code samples](../dev/exemples-code)
    * _Feature technical designs_
        * [#1696 GCP Secret Manager](../dev/feature-technical-designs/1696-gcp-secrets)

* About Tock :
    * [Why Tock](../about/why)
    * [Showcase](../about/showcase)
    * [Awards](../about/contact)
    * [Resources & press kit](../about/resources)
    * [Contact us](../about/contact)
    * [Community](../about/community)
    * [Contribute](../about/contribute)
    * [Jobs](../about/jobs)
