/*
 * Copyright (C) 2017/2021 e-voyageurs technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ai.tock.bot.connector.ga

import ai.tock.bot.connector.ga.model.response.GAFinalResponse
import ai.tock.bot.connector.ga.model.response.GAItem
import ai.tock.bot.connector.ga.model.response.GARichResponse
import ai.tock.bot.connector.ga.model.response.GASimpleResponse
import org.junit.jupiter.api.Test
import kotlin.test.assertEquals

/**
 *
 */
class GAResponseConnectorMessageTest {

    @Test
    fun toSentenceElement_shouldRenderSimpleText() {
        val r = GAResponseConnectorMessage(
            finalResponse =
            GAFinalResponse(
                GARichResponse(
                    listOf(
                        GAItem(
                            GASimpleResponse("ok computer")
                        )
                    )
                )
            )
        )
        val e = r.toGenericMessage()
        assertEquals(mapOf("textToSpeech" to "ok computer"), e!!.texts)
    }
}
