/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Util;

public final class Murmur3 {
    private static final int seed = 0;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;

    public static int hashInt(int input2) {
        if (input2 == 0) {
            return 0;
        }
        int k1 = Murmur3.mixK1(input2);
        int h1 = Murmur3.mixH1(0, k1);
        return Murmur3.fmix(h1, 4);
    }

    public static int hashLong(long input2) {
        if (input2 == 0L) {
            return 0;
        }
        int low = (int)input2;
        int high = (int)(input2 >>> 32);
        int k1 = Murmur3.mixK1(low);
        int h1 = Murmur3.mixH1(0, k1);
        k1 = Murmur3.mixK1(high);
        h1 = Murmur3.mixH1(h1, k1);
        return Murmur3.fmix(h1, 8);
    }

    public static int hashUnencodedChars(CharSequence input2) {
        int h1 = 0;
        for (int i = 1; i < input2.length(); i += 2) {
            int k1 = input2.charAt(i - 1) | input2.charAt(i) << 16;
            k1 = Murmur3.mixK1(k1);
            h1 = Murmur3.mixH1(h1, k1);
        }
        if ((input2.length() & 1) == 1) {
            int k1 = input2.charAt(input2.length() - 1);
            k1 = Murmur3.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3.fmix(h1, 2 * input2.length());
    }

    public static int mixCollHash(int hash2, int count2) {
        int h1 = 0;
        int k1 = Murmur3.mixK1(hash2);
        h1 = Murmur3.mixH1(h1, k1);
        return Murmur3.fmix(h1, count2);
    }

    public static int hashOrdered(Iterable xs) {
        int n = 0;
        int hash2 = 1;
        for (Object x : xs) {
            hash2 = 31 * hash2 + Util.hasheq(x);
            ++n;
        }
        return Murmur3.mixCollHash(hash2, n);
    }

    public static int hashUnordered(Iterable xs) {
        int hash2 = 0;
        int n = 0;
        for (Object x : xs) {
            hash2 += Util.hasheq(x);
            ++n;
        }
        return Murmur3.mixCollHash(hash2, n);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

