/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPending;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.PersistentList;
import clojure.lang.RT;

public class Cycle
extends ASeq
implements IReduce,
IPending {
    private final ISeq all;
    private final ISeq prev;
    private volatile ISeq _current;
    private volatile ISeq _next;

    private Cycle(ISeq all, ISeq prev2, ISeq current) {
        this.all = all;
        this.prev = prev2;
        this._current = current;
    }

    private Cycle(IPersistentMap meta, ISeq all, ISeq prev2, ISeq current, ISeq next2) {
        super(meta);
        this.all = all;
        this.prev = prev2;
        this._current = current;
        this._next = next2;
    }

    public static ISeq create(ISeq vals2) {
        if (vals2 == null) {
            return PersistentList.EMPTY;
        }
        return new Cycle(vals2, null, vals2);
    }

    private ISeq current() {
        if (this._current == null) {
            ISeq current = this.prev.next();
            this._current = current == null ? this.all : current;
        }
        return this._current;
    }

    @Override
    public boolean isRealized() {
        return this._current != null;
    }

    @Override
    public Object first() {
        return this.current().first();
    }

    @Override
    public ISeq next() {
        if (this._next == null) {
            this._next = new Cycle(this.all, this.current(), null);
        }
        return this._next;
    }

    @Override
    public Cycle withMeta(IPersistentMap meta) {
        return new Cycle(meta, this.all, this.prev, this._current, this._next);
    }

    @Override
    public Object reduce(IFn f) {
        ISeq s = this.current();
        Object ret = s.first();
        do {
            if ((s = s.next()) != null) continue;
            s = this.all;
        } while (!RT.isReduced(ret = f.invoke(ret, s.first())));
        return ((IDeref)ret).deref();
    }

    @Override
    public Object reduce(IFn f, Object start2) {
        Object ret = start2;
        ISeq s = this.current();
        while (!RT.isReduced(ret = f.invoke(ret, s.first()))) {
            if ((s = s.next()) != null) continue;
            s = this.all;
        }
        return ((IDeref)ret).deref();
    }
}

