/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm.commons;

import clojure.asm.Label;
import clojure.asm.MethodVisitor;
import clojure.asm.Opcodes;
import clojure.asm.Type;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        this(262144, access, desc, mv);
    }

    protected LocalVariablesSorter(int api2, int access, String desc, MethodVisitor mv) {
        super(api2, mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.nextLocal = (8 & access) == 0 ? 1 : 0;
        for (int i = 0; i < args.length; ++i) {
            this.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Type type2;
        switch (opcode) {
            case 22: 
            case 55: {
                type2 = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type2 = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type2 = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type2 = Type.INT_TYPE;
                break;
            }
            default: {
                type2 = OBJECT_TYPE;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, type2));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.nextLocal);
    }

    @Override
    public void visitLocalVariable(String name2, String desc, String signature, Label start2, Label end2, int index2) {
        int newIndex = this.remap(index2, Type.getType(desc));
        this.mv.visitLocalVariable(name2, desc, signature, start2, end2, newIndex);
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        int number2;
        if (type2 != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(type2, nLocal, local2, nStack, stack);
            return;
        }
        Object[] oldLocals = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, oldLocals, 0, oldLocals.length);
        this.updateNewLocals(this.newLocals);
        int index2 = 0;
        for (number2 = 0; number2 < nLocal; ++number2) {
            int size;
            Object t2 = local2[number2];
            int n = size = t2 == Opcodes.LONG || t2 == Opcodes.DOUBLE ? 2 : 1;
            if (t2 != Opcodes.TOP) {
                Type typ = OBJECT_TYPE;
                if (t2 == Opcodes.INTEGER) {
                    typ = Type.INT_TYPE;
                } else if (t2 == Opcodes.FLOAT) {
                    typ = Type.FLOAT_TYPE;
                } else if (t2 == Opcodes.LONG) {
                    typ = Type.LONG_TYPE;
                } else if (t2 == Opcodes.DOUBLE) {
                    typ = Type.DOUBLE_TYPE;
                } else if (t2 instanceof String) {
                    typ = Type.getObjectType((String)t2);
                }
                this.setFrameLocal(this.remap(index2, typ), t2);
            }
            index2 += size;
        }
        index2 = 0;
        number2 = 0;
        int i = 0;
        while (index2 < this.newLocals.length) {
            Object t3;
            if ((t3 = this.newLocals[index2++]) != null && t3 != Opcodes.TOP) {
                this.newLocals[i] = t3;
                number2 = i + 1;
                if (t3 == Opcodes.LONG || t3 == Opcodes.DOUBLE) {
                    ++index2;
                }
            } else {
                this.newLocals[i] = Opcodes.TOP;
            }
            ++i;
        }
        this.mv.visitFrame(type2, number2, this.newLocals, nStack, stack);
        this.newLocals = oldLocals;
    }

    public int newLocal(Type type2) {
        Object t2;
        switch (type2.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                t2 = Opcodes.INTEGER;
                break;
            }
            case 6: {
                t2 = Opcodes.FLOAT;
                break;
            }
            case 7: {
                t2 = Opcodes.LONG;
                break;
            }
            case 8: {
                t2 = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                t2 = type2.getDescriptor();
                break;
            }
            default: {
                t2 = type2.getInternalName();
            }
        }
        int local2 = this.newLocalMapping(type2);
        this.setLocalType(local2, type2);
        this.setFrameLocal(local2, t2);
        return local2;
    }

    protected void updateNewLocals(Object[] newLocals) {
    }

    protected void setLocalType(int local2, Type type2) {
    }

    private void setFrameLocal(int local2, Object type2) {
        int l = this.newLocals.length;
        if (local2 >= l) {
            Object[] a = new Object[Math.max(2 * l, local2 + 1)];
            System.arraycopy(this.newLocals, 0, a, 0, l);
            this.newLocals = a;
        }
        this.newLocals[local2] = type2;
    }

    private int remap(int var, Type type2) {
        int value;
        int size;
        if (var + type2.getSize() <= this.firstLocal) {
            return var;
        }
        int key2 = 2 * var + type2.getSize() - 1;
        if (key2 >= (size = this.mapping.length)) {
            int[] newMapping = new int[Math.max(2 * size, key2 + 1)];
            System.arraycopy(this.mapping, 0, newMapping, 0, size);
            this.mapping = newMapping;
        }
        if ((value = this.mapping[key2]) == 0) {
            value = this.newLocalMapping(type2);
            this.setLocalType(value, type2);
            this.mapping[key2] = value + 1;
        } else {
            --value;
        }
        if (value != var) {
            this.changed = true;
        }
        return value;
    }

    protected int newLocalMapping(Type type2) {
        int local2 = this.nextLocal;
        this.nextLocal += type2.getSize();
        return local2;
    }
}

