# S🎈nder

![AGPL3 License](https://img.shields.io/github/license/saurabh-khanna/sonder)
![GitHub commit activity](https://img.shields.io/github/commit-activity/m/saurabh-khanna/sonder)
[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](CODE_OF_CONDUCT.md)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.4536014.svg)](https://doi.org/10.5281/zenodo.4536014)

<br/>

> _sonder (n.)_
>
> the realization that each random passerby is living a life as vivid and complex as your own<sup id="a1">[1](#f1)</sup>

<br/>

## ⚡ TL;DR

Internet search shows us what we consume. Sonder shows us what we miss out on. We assess the opportunity cost of (the status-quo in) internet search.

Our access to knowledge is biased by ~~public~~ private algorithms, trained on ~~diverse~~ mainstream data, intended to maximize ~~representation~~ consumption. This robs us of the choice to understand those who think and learn differently. Sonder is an attempt to make our lack of choice explicit. To at least be mindful of our filter bubbles, if not break them.

Current work on Sonder spans two dimensions:

-   ⚖️ *Balance*: Assess (in)completeness in knowledge as we search the web. Balance relevance with diversity.
-   📣 *Trends*: Highlight (in)completeness in global web, news, wiki, and social media trends.

<br/>

## 👀 Glimpses

### ⚖️ Balance

#### Latent knowledge summary for search query

<p align="center">
  <img src="images/1.png" />
</p>

<br/>

#### Latent sentiment

<p align="center">
  <img src="images/2.png" />
</p>

<br/>

#### Latent geographies

<p align="center">
  <img src="images/3.png" />
</p>

<br/>

#### Latent carbon cost

<p align="center">
  <img src="images/4.png" />
</p>

<br/>

#### Experimental Analysis of Behavior Changes Induced

<p align="center">
  <img src="images/sonder_treatment.png" />
</p>

### 📣 Trends

#### Global sentiment trends (Web search)

<p align="center">
  <img src="images/5.png" />
</p>

<br/>

#### Global sentiment trends (News search)

<p align="center">
  <img src="images/6.png" />
</p>

<br/>

## 🧮 Algorithms

Preliminary details [here](https://raw.githubusercontent.com/sonder-labs/sonder/main/slides_sonder.pdf).

<br/>

## 🏆 Awards

-   Stanford Institute for Human-Centered Artificial Intelligence Fellowship
-   Stanford Data Science Scholarship
-   Design Challenge Research Award, Stanford University
-   Karr Fellowship, Stanford University
-   Digital Learning Design Challenge Grant, Stanford University

<br/>

## 👾 Maintainer

-   [Saurabh Khanna](mailto:saurabhkhanna@stanford.edu)

Sonder is [open-source](https://github.com/sonder-labs/sonder/blob/main/LICENSE) and envisioned as a nonprofit. [Reach out](mailto:saurabhkhanna@stanford.edu) to join forces.

Contribution covenant [here](https://github.com/sonder-labs/sonder/blob/main/CODE_OF_CONDUCT.md).

<br/>

* * *

<b id="f1">1</b> Diction credit: [John Koenig](https://www.ted.com/speakers/john_koenig) [↩](#a1)
