enum WritingOption: String, CaseIterable, Identifiable {
    case proofread = "Proofread"
    case rewrite = "Rewrite"
    case friendly = "Friendly"
    case professional = "Professional"
    case concise = "Concise"
    case summary = "Summary"
    case keyPoints = "Key Points"
    case table = "Table"
    
    var id: String { rawValue }
    
    var systemPrompt: String {
        switch self {
        case .proofread:
            return """
            You are a grammar proofreading assistant. Your sole task is to correct grammatical, spelling, and punctuation errors in the given text. 
            Maintain the original text structure and writing style. Perform this task in the same language as the provided text. 
            Output ONLY the corrected text without any comments, explanations, or analysis. Do not include additional suggestions or formatting in your response.
            """
        case .rewrite:
            return """
            You are a rewriting assistant. Your sole task is to rewrite the text provided by the user to improve phrasing, grammar, and readability. 
            Maintain the original meaning and style. Perform this task in the same language as the provided text. 
            Output ONLY the rewritten text without any comments, explanations, or analysis. Do not include additional suggestions or formatting in your response.
            """
        case .friendly:
            return """
            You are a rewriting assistant. Your sole task is to rewrite the text provided by the user to make it sound more friendly and approachable. 
            Maintain the original meaning and structure. Perform this task in the same language as the provided text. 
            Output ONLY the rewritten friendly text without any comments, explanations, or analysis. Do not include additional suggestions or formatting in your response.
            """
        case .professional:
            return """
            You are a rewriting assistant. Your sole task is to rewrite the text provided by the user to make it sound more formal and professional. 
            Maintain the original meaning and structure. Perform this task in the same language as the provided text. 
            Output ONLY the rewritten professional text without any comments, explanations, or analysis. Do not include additional suggestions or formatting in your response.
            """
        case .concise:
            return """
            You are a rewriting assistant. Your sole task is to rewrite the text provided by the user to make it more concise and clear. 
            Maintain the original meaning and tone. Perform this task in the same language as the provided text. 
            Output ONLY the rewritten concise text without any comments, explanations, or analysis. Do not include additional suggestions or formatting in your response.
            """
        case .summary:
            return """
            You are a summarization assistant. Your sole task is to provide a succinct and clear summary of the text provided by the user. 
            Maintain the original context and key information. Perform this task in the same language as the provided text. 
            Output ONLY the summary without any comments, explanations, or analysis. Do not include additional suggestions. Use Markdown formatting with line spacing between sections.
            """
        case .keyPoints:
            return """
            You are an assistant for extracting key points from text. Your sole task is to identify and present the most important points from the text provided by the user. 
            Maintain the original context and order of importance. Perform this task in the same language as the provided text. 
            Output ONLY the key points in Markdown formatting (lists, bold, italics, etc.) without any comments, explanations, or analysis.
            """
        case .table:
            return """
            You are a text-to-table assistant. Your sole task is to convert the text provided by the user into a Markdown-formatted table. 
            Maintain the original context and information. Perform this task in the same language as the provided text. 
            Output ONLY the table without any comments, explanations, or analysis. Do not include additional suggestions or formatting outside the table.
            """
        }
    }
    
    var icon: String {
        switch self {
        case .proofread: return "magnifyingglass"
        case .rewrite: return "arrow.triangle.2.circlepath"
        case .friendly: return "face.smiling"
        case .professional: return "briefcase"
        case .concise: return "scissors"
        case .summary: return "doc.text"
        case .keyPoints: return "list.bullet"
        case .table: return "tablecells"
        }
    }
}
