using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Ace.Wpf;
using Ace;
using System.Windows.Media.Animation;
using System.Windows.Controls.Primitives;

namespace MalwarePatch.Windows.Update
{
    /// <summary>
    /// UpdateWindow.xaml 的交互逻辑
    /// </summary>
    public partial class UpdateWindow : Window
    {
        public UpdateWindow()
        {
            InitializeComponent();
            viewModel = new UpdateViewModel(this);
            DataContext = viewModel;
            
#if DEBUG
            //viewModel.TextProxy = "127.0.0.1:8580";
            buttonDebug.Visibility = Visibility.Visible;
            buttonDebug.Click += (s, e) =>
            {
                viewModel.ShowProgressBar = true;
                viewModel.ProgressValue = 50.0;
            };
#endif
            buttonMinimize.Click += (s, e) => WindowState = WindowState.Minimized;
            buttonClose.Click += (s, e) => Close();

            Loaded += (s, e) =>
            {
                buttonRetry.Command.Execute(null);
            };
            this.DragMove(borderHeader);
            this.DragMove(textWindowTitle);
        }
        private UpdateViewModel viewModel;
        internal void SetProgress(double value)
        {
            Dispatcher.Invoke(() =>
            {
                var animation = new DoubleAnimation
                {
                    Duration = TimeSpan.FromMilliseconds(300),
                    To = value,
                    EasingFunction = new CircleEase { EasingMode = EasingMode.EaseOut },
                };
                progress.BeginAnimation(RangeBase.ValueProperty, animation);
            });
        }
    }
}
