using MalwarePatch.Commands;
using MalwarePatch.Models;
using Ace.Settings;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Net;
using System.ComponentModel;
using System.Windows.Input;
using System.Diagnostics;
using System.Windows.Shell;
using System.Net.Configuration;
using MalwarePatch.Languages;
using Ace.Wpf.Mvvm;

namespace MalwarePatch.Windows.Update
{
    sealed partial class UpdateViewModel : ViewModel<UpdateWindow, UpdateLanguage>
    {
        public UpdateViewModel(UpdateWindow view) : base(view)
        {
            versionChecker = new VersionChecker();
            updater = new Updater();
        }
        private VersionChecker versionChecker;
        private Updater updater;
        //I couldn't find any method to get system proxy...maybe null should work
        private string SystemProxy => null;
        private string getProxy() => String.IsNullOrWhiteSpace(TextProxy) ? SystemProxy : TextProxy;

        

        private string textTitle = "";
        public string TextTitle
        {
            get => textTitle;
            set
            {
                textTitle = value;
                OnPropertyChanged(nameof(TextTitle));
            }
        }
        private double progressValue = 0.0;
        public double ProgressValue
        {
            get => progressValue;
            set
            {
                progressValue = value;
                OnPropertyChanged(nameof(ProgressValue));
                OnPropertyChanged(nameof(ProgressText));
                OnPropertyChanged(nameof(TaskBarProgressValue));
                View.SetProgress(value);
            }
        }
        public double TaskBarProgressValue => progressValue / 100.0;
        public string ProgressText => $"{progressValue:0.##}%";
        private string textStatus = "";
        public string TextStatus
        {
            get => textStatus;
            set
            {
                textStatus = value;
                OnPropertyChanged(nameof(TextStatus));
            }
        }
        private string textProxy = "";
        public string TextProxy
        {
            get => textProxy;
            set
            {
                textProxy = value;
                OnPropertyChanged(nameof(TextProxy));
            }
        }
        private bool isNotCheckingUpdate = true;
        public bool IsNotCheckingUpdate
        {
            get => isNotCheckingUpdate;
            set
            {
                isNotCheckingUpdate = value;
                OnPropertyChanged(nameof(IsNotCheckingUpdate));
                OnPropertyChanged(nameof(IsProxyEditable));
                OnPropertyChanged(nameof(IsCheckUpdateEnabled));
            }
        }
        public bool IsCheckUpdateEnabled => IsNotCheckingUpdate && IsNotDownloading && !IsDownloadComplete;
        
        private bool canDownload = false;
        public bool CanDownload
        {
            get => canDownload;
            set
            {
                canDownload = value;
                OnPropertyChanged(nameof(CanDownload));
                OnPropertyChanged(nameof(IsDownloadEnabled));
            }
        }
        private bool showProgressBar = false;
        public bool ShowProgressBar
        {
            get => showProgressBar;
            set
            {
                showProgressBar = value;
                OnPropertyChanged(nameof(ShowProgressBar));
            }
        }
        private bool isNotDownloading = true;
        public bool IsNotDownloading
        {
            get => isNotDownloading;
            set
            {
                isNotDownloading = value;
                ShowProgressBar = !value;
                ProgressState = value ? TaskbarItemProgressState.None : TaskbarItemProgressState.Normal;
                OnPropertyChanged(nameof(IsNotDownloading));
                OnPropertyChanged(nameof(IsProxyEditable));
                OnPropertyChanged(nameof(IsDownloadEnabled));
                OnPropertyChanged(nameof(IsCheckUpdateEnabled));
            }
        }

        private TaskbarItemProgressState progressState;
        public TaskbarItemProgressState ProgressState
        {
            get => progressState;
            set
            {
                progressState = value;
                OnPropertyChanged(nameof(ProgressState));
            }
        }


        public bool IsProxyEditable => IsNotDownloading && IsNotCheckingUpdate;
        public bool IsDownloadEnabled => CanDownload && IsNotDownloading && !IsDownloadComplete;
        private void downloadFailed(string message)
        {
            TextStatus = string.Format(Language[UpdateLanguage.Keys.DownloadFailedStatus], message ?? Language[UpdateLanguage.Keys.Unknown]);
            TextTitle = Language[UpdateLanguage.Keys.DownloadFailedTitle];
            CanDownload = IsNotDownloading = true;
        }
        private void downloadCompleted()
        {
            TextStatus = Language[UpdateLanguage.Keys.DownloadCompleteStatus];
            updater.SetUpdatePlan();
            IsNotDownloading = true;
            IsDownloadComplete = true;
        }
        
        private bool isDownloadComplete = false;
        public bool IsDownloadComplete
        {
            get => isDownloadComplete;
            set
            {
                isDownloadComplete = value;
                OnPropertyChanged(nameof(IsDownloadComplete));
                OnPropertyChanged(nameof(IsCheckUpdateEnabled));
                OnPropertyChanged(nameof(IsDownloadEnabled));
            }
        }
        
    }
}
