using MalwarePatch.Commands;
using MalwarePatch.Languages;
using MalwarePatch.Models;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace MalwarePatch.Windows.Update
{
    partial class UpdateViewModel
    {
        public DirectCommand CheckUpdateCommand
            => new DirectCommand
            {
                CanExecuteFunc = (o) => IsNotCheckingUpdate,
                ExcuteAction = async (o) =>
                {
                    IsNotCheckingUpdate = false;
                    versionChecker.Proxy = getProxy();
                    TextStatus = Language[UpdateLanguage.Keys.CheckingNewVersion];
                    TextTitle = Language[UpdateLanguage.Keys.CheckingNewVersion];
                    await Task.Run(() =>
                    {
                        try
                        {
                            CanDownload = false;
                            if (versionChecker.HasNewVersion)
                            {
                                TextStatus = string.Format(Language[UpdateLanguage.Keys.NewVerisonStatus], versionChecker.NewVersion);
                                TextTitle = Language[UpdateLanguage.Keys.NewVerisonTitle];
                                CanDownload = true;
                            }
                            else
                            {
                                TextStatus = string.Format(Language[UpdateLanguage.Keys.NoNewVerisonStatus], versionChecker.NewVersion);
                                TextTitle = Language[UpdateLanguage.Keys.NoNewVerisonTitle];
                            }
                        }
                        catch (WebException we)
                        {
                            TextStatus = string.Format(Language[UpdateLanguage.Keys.CheckFailedStatus], we.Message);
                            TextTitle = Language[UpdateLanguage.Keys.CheckFailedTitle];
                        }
#if !DEBUG
                        catch (Exception ex)
                        {
                            TextStatus = string.Format(Language[UpdateLanguage.Keys.CheckFailedStatus], ex.Message);
                            TextTitle = Language[UpdateLanguage.Keys.CheckFailedTitle];
                        }
#endif
                    });
                    IsNotCheckingUpdate = true;
                }
            };

        public DirectCommand DownloadCommand
        {
            get
            {
                return new DirectCommand
                {
                    CanExecuteFunc = (o) => true,
                    ExcuteAction = async (o) =>
                    {
                        TextStatus = Language[UpdateLanguage.Keys.DownloadingStatus];
                        TextTitle = Language[UpdateLanguage.Keys.NewVerisonTitle];
                        ProgressValue = 0.0;
                        CanDownload = false;
                        IsNotDownloading = false;
                        updater.ProgressChanged = (s, e) =>
                        {
#if DEBUG
                            Debug.WriteLine($"{e.BytesReceived}/{e.TotalBytesToReceive}");
#endif
                            ProgressValue = e.ProgressPercentage;
                        };
                        updater.Proxy = getProxy();
                        try
                        {
                            await updater.DownloadUpdate();
                            downloadCompleted();
                        }
                        catch (Exception ex)
                        when (ex is WebException ||
                              ex is InvalidOperationException)
                        {
                            downloadFailed(ex.Message);
                        }
#if !DEBUG
                        catch (Exception ex)
                        {
                            downloadFailed(ex.Message);
                        }
#endif

                    },
                };
            }
        }
        public DirectCommand RestartCommand
            => new DirectCommand
            {
                CanExecuteFunc = (o) => true,
                ExcuteAction = (o) =>
                {
                    updater.RestartParameters = Updater.RestartParameter;
                    Application.Current.Shutdown();
                },
            };
    }
}
