using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MalwarePatch.Languages;
using System.ComponentModel;
using System.Windows;
using MalwarePatch.Commands;
using System.Windows.Controls;
using System.Threading;
using MalwarePatch.Models;
using Ace.Wpf.Mvvm;
using System.Collections.ObjectModel;

namespace MalwarePatch.Windows.Main
{
  sealed partial class MainViewModel : ViewModel<MainWindow, MainLanguage>
  {
    public MainViewModel(MainWindow mainWindow) : base(mainWindow)
    {
      silentCheckUpdate();
      certificates = new ObservableCollection<CertificateAdapter>();
      BuiltInCertificates.All.ForEach(cert =>
      {
        if (!cert.IsEmpty)
        {
          certificates.Add(new CertificateAdapter(cert));
        }
      });
    }
    private async void silentCheckUpdate()
    {
#if DEBUG
      await Task.Run(() =>
      {
        //ShowNewVersionPopup = true;
        var checker = new VersionChecker();
        var hasNewVersion = false;
        try
        {
          hasNewVersion = checker.HasNewVersion;
        }
        catch
        {
          hasNewVersion = false;
        }
        if (hasNewVersion)
        {
          ShowNewVersionPopup = true;
        }
      });
#else
            await Task.Run(() =>
            {
                //ShowNewVersionPopup = true;
                var checker = new VersionChecker();
                var hasNewVersion = false;
                try
                {
                    hasNewVersion = checker.HasNewVersion;
                }
                catch
                {
                    hasNewVersion = false;
                }
                if (hasNewVersion)
                {
                    ShowNewVersionPopup = true;
                }
            });
#endif

    }

    private ObservableCollection<CertificateAdapter> certificates;
    public ObservableCollection<CertificateAdapter> Certificates
    {
      get => certificates;
      set
      {
        certificates = value;
        OnPropertyChanged(nameof(Certificates));
      }
    }

    private bool showSavedPopup = false;
    public bool ShowSavedPopup
    {
      get => showSavedPopup;
      set
      {
        showSavedPopup = value;
        OnPropertyChanged(nameof(ShowSavedPopup));
        if (value)
        {
          Task.Run(() =>
          {
            Thread.Sleep(2000);
            ShowSavedPopup = false;
          });
        }
      }
    }
    private bool showNewVersionPopup = false;
    public bool ShowNewVersionPopup
    {
      get => showNewVersionPopup;
      set
      {
        showNewVersionPopup = value;
        OnPropertyChanged(nameof(ShowNewVersionPopup));
        if (value)
        {
          Task.Run(() =>
          {
            Thread.Sleep(5000);
            ShowNewVersionPopup = false;
          });
        }
      }
    }

    public bool IsUnbundled => BuildConfig.IsUnbundled;
    public bool IsBundled => !BuildConfig.IsUnbundled;
  }
}
