using MalwarePatch.Models;
using MalwarePatch.Commands;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;
using MalwarePatch.Windows.Update;
using System.Diagnostics;

namespace MalwarePatch.Windows.Main
{
  partial class MainViewModel
  {
    private bool isNotBusy = true;
    public bool IsNotBusy
    {
      get => isNotBusy;
      set
      {
        isNotBusy = value;
        OnPropertyChanged(nameof(IsNotBusy));
      }
    }
    public SaveChangesCommand ButtonSaveCommand => new SaveChangesCommand(Certificates)
    {
      BeforeExecute = () => IsNotBusy = false,
      AfterExecute = () =>
      {
        IsNotBusy = true;
        ShowSavedPopup = true;
      }
    };

    public ICommand ButtonCheckAllCommand => new BatchCheckCommand(true, Certificates);
    public ICommand ButtonUncheckAllCommand => new BatchCheckCommand(false, Certificates);
    public ICommand AllowFileCommand => new UserCertificateCommand(true, Certificates);
    public ICommand DisallowFileCommand => new UserCertificateCommand(false, Certificates);

    public DirectCommand ButtonUpdateCommand => new DirectCommand
    {
      ExcuteAction = o =>
      {
        var updateWindow = new UpdateWindow()
        {
          Owner = View
        };
        ShowNewVersionPopup = false;
        ShowSavedPopup = false;
        updateWindow.ShowDialog();
      }
    };

    public DirectCommand ButtonGetUpdateCommand => new DirectCommand
    {
      ExcuteAction = o =>
      {
        Process.Start(Updater.UpdateUrl);
      }
    };

  }
}
