﻿using Ace.Wpf;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace MalwarePatch.Windows.Dialog
{
    public partial class DialogWindow : Window
    {
        public DialogWindow()
        {
            InitializeComponent();
            buttonOK.Click += (s, e) => Close();
            this.DragMove(this);
        }
        public static bool? Show(string message, string title)
        {
            var window = Application.Current.Windows.OfType<Window>().SingleOrDefault(x => x.IsActive);
            return new DialogWindow()
            {
                Owner = window ?? null,
                WindowStartupLocation = window is null ?
                    WindowStartupLocation.CenterScreen :
                    WindowStartupLocation.CenterOwner,
                DataContext = new
                {
                    Title = title,
                    Message = message
                }
            }.ShowDialog();
        }
    }
}
