using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Ace.Web;
using Ace;
using System.Windows;

namespace MalwarePatch.Models
{
  sealed class VersionChecker
  {
    public Version NewVersion { get; private set; }
    private Version CurrentVersion => Assembly.GetEntryAssembly().GetName().Version;
    public string Proxy { get; set; }

    public bool HasNewVersion
    {
      get
      {
        var downloadLink = "https://github.com/the1812/malware-patch/raw/master/mwp-ver.txt";
        var info = new DownloadInfo(downloadLink)
        {
          Proxy = Proxy,
        };
        var newVersionString = info.DownloadString();
        NewVersion = new Version(newVersionString);

        //#if DEBUG
        //                return true;
        //#endif
        return NewVersion > CurrentVersion;
      }
    }
  }
}
