﻿using Ace;
using Ace.Files;
using MalwarePatch.Languages;
using MalwarePatch.Windows.Dialog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Models
{
    class UserCertificate
    {
        private readonly string filename;
        private readonly UserCertificateLanguage language = new UserCertificateLanguage();
        private static void dialog(string message, string title)
        {
            // MessageBox.Show(message, title, MessageBoxButton.OK);
            DialogWindow.Show(message, title);
        }
        public UserCertificate(string filename)
        {
            this.filename = filename;
        }
        public void Allow() => processCertificate(allow: true, UserCertificateLanguage.Keys.Allowed);
        public void Disallow() => processCertificate(allow: false, UserCertificateLanguage.Keys.Disallowed);
        private bool Exists => File.Exists(filename);
        private CertificateFile Certificate
        {
            get
            {
                try
                {
                    var certificate = new X509Certificate2(filename);
                    return new CertificateFile(certificate);
                }
                catch (CryptographicException)
                {
                    return null;
                }
            }
        }
        private void processCertificate(bool allow, UserCertificateLanguage.Keys messageKey)
        {
            if (check())
            {
                var cert = Certificate;
                if (allow)
                {
                    cert.Allow();
                }
                else
                {
                    cert.Disallow();
                }
                var name = cert.Certificate.GetNameInfo(X509NameType.SimpleName, false);
                if (name.IsNullOrWhiteSpace())
                {
                    name = language[UserCertificateLanguage.Keys.UnknownPublisher];
                }
                dialog(string.Format(language[messageKey], name),
                    language[UserCertificateLanguage.Keys.Complete]);
            }
        }
        private bool check()
        {
            if (filename.IsNullOrWhiteSpace())
            {
                dialog(language[UserCertificateLanguage.Keys.TipMessage], language[UserCertificateLanguage.Keys.Tip]);
                return false;
            }
            if (!Exists)
            {
                dialog(string.Format(language[UserCertificateLanguage.Keys.FileNotFound], filename),
                    language[UserCertificateLanguage.Keys.Error]);
                return false;
            }
            if (Certificate is null)
            {
                dialog(string.Format(language[UserCertificateLanguage.Keys.FileNotSigned], filename),
                    language[UserCertificateLanguage.Keys.Error]);
                return false;
            }
            return true;
        }
    }
}
