﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace MalwarePatch.Models
{
    class UIElementToImageConverter : IValueConverter
    {
        // https://stackoverflow.com/questions/6676072/get-system-drawing-bitmap-of-a-wpf-area-using-visualbrush
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is UIElement element)
            {
                var target = new RenderTargetBitmap(96, 96, 96, 96, PixelFormats.Pbgra32);
                var brush = new VisualBrush(element);

                var visual = new DrawingVisual();
                var drawingContext = visual.RenderOpen();


                drawingContext.DrawRectangle(brush, null, new Rect(new Point(0, 0),
                    new Point(96, 96)));

                drawingContext.Close();

                target.Render(visual);

                return target;
            }
            return null;
        }
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture) => throw new NotImplementedException();
    }
}
