﻿using Ace.Files;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Models
{
  public abstract class Certificates
  {
    protected List<CertificateFile> certificateFiles = new List<CertificateFile>();
    public string DisplayName { get; protected set; }
    public void Allow() => certificateFiles.ForEach(file => file.Allow());
    public void Disallow() => certificateFiles.ForEach(file => file.Disallow());
    public bool IsDisallowed => certificateFiles.TrueForAll(file => file.IsDisallowed);
    public bool IsEmpty => !certificateFiles.Any();
  }
}
